/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/******************************************************************************
*
* @file board.h
*
* @author nxf47721
*
* @version 0.0.1
*
* @date Oct 20, 2019
*
*******************************************************************************/

#include "board.h"
#include "common.h"
#include "wcop.h"
#include "sci.h"
#include "ics.h"

/******************************************************************************
* Global functions
******************************************************************************/
void delay(void)
{
	uint16_t n;
    
    for(n=0;n<500;n++) 
    {
        asm(nop);
    }
}


void BOARD_InitDebugConsole(void)
{ 
    /* OSBDM serial outputs are connected to SCI0 PTB1/0 */
	Init_SCI0(BUS_CLK_HZ); 
}

void Sys_Init(void)
{
    /* Disable the watchdog timer */
    /* WARNINGIN: DO NOT single step this function call, otherwise
    * will cause watch dog reset
    */
    wdog_disable();	
    /*

    */

    /* Default FEI mode, if use FEE mode, S08PB16-EVK needs to add R19, R21, remove R18, R20. */
#if defined(USE_FEE)  
    // Initialize system clock to 16MHz with external 8M crystal
    FEI_to_FEE();
#endif  

    /* enable stop,*/  
    SYS_SOPT1 = 0x2D;    // write once register, enable stop, IIC SCL and SDA are mapped on PTB7 and PTB6
   
    /* Configure SCI for printing */                       
    BOARD_InitDebugConsole();
    

#if	defined(PRINT_SYS_LOG)
    print_sys_log();
#endif

    /* _asm CLI */ /* enable interrupts */
}
