/*! *********************************************************************************
* \defgroup FSCI_BLE_PRIVATE_INTERFACE_H BLE FSCI
* @{
********************************************************************************** */
/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
* All rights reserved.
*
* \file
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

#ifndef FSCI_BLE_PRIVATE_INTERFACE_H
#define FSCI_BLE_PRIVATE_INTERFACE_H

/************************************************************************************
*************************************************************************************
* Include
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/*! *********************************************************************************
* \brief   This function registers the FSCI handlers for the enabled BLE private layers.
*
* \param[in]    fsciInterfaceId        The interface on which data should be printed.
*
********************************************************************************** */
void fsciBleRegisterPrivate
(
    uint32_t fsciInterfaceId
);

#ifdef __cplusplus
}
#endif 

#endif /* FSCI_BLE_PRIVATE_INTERFACE_H */

/*! *********************************************************************************
* @}
********************************************************************************** */