/* board.c */

#include "clock_config.h"
#include "pin_mux.h"
#include "board.h"

#include "fsl_lpsci.h"

void board_uart_init(void);

void board_init(void)
{
    BOARD_InitBootClocks();
    BOARD_InitPins();
    
    board_uart_init();
}

/* Initialize debug console. */
/*
 * PTB0 - LPUART0_RX
 * PTB1 - LPUART0_TX
 */
void board_uart_init(void)
{
    /* clocks. */
    CLOCK_EnableClock(kCLOCK_Uart0);

    /* pins. */
    /* pins are configured in pin_mux.h/.c by config_tool */

   /* setup uart transfer. */
    lpsci_config_t lpsci_config;
    LPSCI_GetDefaultConfig(&lpsci_config);
    lpsci_config.baudRate_Bps = 9600;
    lpsci_config.enableRx = true;
    lpsci_config.enableTx = true;
    LPSCI_Init(UART0, &lpsci_config, CLOCK_GetFreq(kCLOCK_PllFllSelClk));
}


int fputc(int ch, FILE *f)
{
    uint8_t tmp8 = (uint8_t)ch;

    LPSCI_WriteBlocking(UART0, &tmp8, 1u);

    return ch;
}

int fgetc(FILE *f)
{
    uint8_t tmp8;

    LPSCI_ReadBlocking(UART0, &tmp8, 1u);

    return tmp8;
}

/* EOF. */

