/* glitch_filter.h */
#ifndef __GLITCH_FILTER_H__
#define __GLITCH_FILTER_H__

#include <stdint.h>
#include <stdbool.h>
#include <string.h>

/* Keep all the static variable and information for each key. */
typedef struct
{
    /* Attr. */
    uint32_t filter_level_max; /* The output would change if the new value keeps enough time. */

    /* Static. */
    int32_t init_value; /* Initialize value. Actually only available for Asymmetric Filter. */
    int32_t stable_output; /* Current output value. */
    int32_t new_output; /* Protential output value, would be change to output value if it keeps long enough. */
    uint32_t filter_level_count; /* Tick counter for nex value. */
} glitch_filter_handler_t;

void glitch_filter_init(glitch_filter_handler_t *handler, int32_t init_value, uint32_t filter_level);
int32_t glitch_filter_output(glitch_filter_handler_t *handler, int32_t input_raw);

#endif /* __GLITCH_FILTER_H__ */

