/* main.c */
#include "fsl_common.h"
#include "board.h"

#include "touch.h"
#include "touch_2d.h"

#include "led.h"

#include "glitch_filter.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* touch state machine. */
typedef enum
{
    eAppTouchState_Init   = 0,
    eAppTouchState_Calib  = 1,
    eAppTouchState_Detect = 2,
} app_touch_state_t;

/*******************************************************************************
 * Variables.
 ******************************************************************************/
volatile app_touch_state_t app_touch_state = eAppTouchState_Init;
int32_t app_touch_state_init_counter = 0;     /* 开始预热一段时间. */

int32_t app_touch_channel_values[TOUCH_2D_ALL_COUNT];
int32_t app_touch_2d_x_pos_raw;
int32_t app_touch_2d_y_pos_raw;
volatile int32_t app_touch_2d_x_pos;
volatile int32_t app_touch_2d_y_pos;

int32_t app_touch_err;

/* for touch 2d gesture. */
touch_2d_gesture_event_t app_touch_2d_gesture_event;
touch_2d_gesture_event_t app_touch_2d_gesture_event_raw;
glitch_filter_handler_t app_touch_2d_gesture_event_filter;


int main(void)
{
    board_init(); /* setup clocks. */

    printf("kl16z touch 2d gesture.\r\n");

    led_init();
    led_on((1u << LED_COUNT)-1u); /* led all on. */

    /* touch. */
    touch_init_pins();
    touch_init();
    app_touch_state_init_counter = 0u;
    app_touch_state = eAppTouchState_Init;

    /* leds. */
    led_blink_init();

    /* lptmr. */
    lptmr_init();
    lptmr_start();

    while (1)
    {
        touch_wait_data_ready(app_touch_channel_values);
        //touch_start();

        /* todo: using app_touch_channel_values for calculation.*/
        switch (app_touch_state)
        {
        case eAppTouchState_Init:
            if (app_touch_state_init_counter < 10u)
            {
                app_touch_state_init_counter++;
            }
            else
            {
                app_touch_state = eAppTouchState_Calib;
            }
            break;

        case eAppTouchState_Calib:
            if (touch_2d_calib(app_touch_channel_values))
            {
                led_off((1u << LED_COUNT)-1u); /* led off. */
                glitch_filter_init(&app_touch_2d_gesture_event_filter, eTouch_2d_gesture_event_no_touch_keep, 3u);
                app_touch_state = eAppTouchState_Detect;
            }
            break;

        case eAppTouchState_Detect:
            app_touch_err = touch_2d_calc_position(app_touch_channel_values, &app_touch_2d_x_pos_raw, &app_touch_2d_y_pos_raw);
            if (app_touch_err == 0) /*  */
            {
                app_touch_2d_x_pos = app_touch_2d_x_pos_raw;
                app_touch_2d_y_pos = app_touch_2d_y_pos_raw;
                //printf("%4d, %4d\r\n", app_touch_2d_x_pos, app_touch_2d_y_pos);
            }
            else
            {
                app_touch_2d_x_pos = 0;
                app_touch_2d_y_pos = 0;

                if (app_touch_err == 3u)
                {
                    //led_on((1u << LED_COUNT)-1u); /* all cover */
                    led_blink_set_blink(7u, 3u);
                    printf("o");
                }
                else
                {
                    //led_off((1u << LED_COUNT)-1u);
                }
            }

            /* recognize the gesture. */
            app_touch_2d_gesture_event_raw = touch_2d_gesture_process(app_touch_2d_x_pos_raw, app_touch_2d_y_pos_raw, (app_touch_err == 0) );
            app_touch_2d_gesture_event = (touch_2d_gesture_event_t)glitch_filter_output( &app_touch_2d_gesture_event_filter, app_touch_2d_gesture_event_raw);

            /* using printf. */

            if (   (app_touch_2d_gesture_event >= eTouch_2d_gesture_event_on_touch_move_0)
                && (app_touch_2d_gesture_event <= eTouch_2d_gesture_event_on_touch_move_4)
                && (app_touch_2d_gesture_event_raw >= eTouch_2d_gesture_event_on_touch_move_0)
                && (app_touch_2d_gesture_event_raw <= eTouch_2d_gesture_event_on_touch_move_4)
               )
            {
                led_blink_set_blink(app_touch_2d_gesture_event - eTouch_2d_gesture_event_on_touch_move_0, 3u);
                printf("%d", app_touch_2d_gesture_event);
            }
            if (app_touch_2d_gesture_event_raw == eTouch_2d_gesture_event_on_touch_just)
            {
                printf("\r\n");
            }
            if (app_touch_2d_gesture_event_raw == eTouch_2d_gesture_event_on_touch_just_2nd_click)
            {
                led_blink_set_blink(5u, 3u);
                printf("**");
            }
            if (app_touch_2d_gesture_event_raw == eTouch_2d_gesture_event_on_touch_just_3rd_click)
            {
                led_blink_set_blink(6u, 3u);
                printf("***");
            }
            if (app_touch_2d_gesture_event_raw == eTouch_2d_gesture_event_on_touch_no_process)
            {
                printf("-");
            }

            break;

        default:
            app_touch_state_init_counter = 0u;
            app_touch_state = eAppTouchState_Init;
            break;
        }
    }
}
/* EOF. */

