/* touch_2d.h */
#ifndef __TOUCH_2D_H__
#define __TOUCH_2D_H__

#include "touch.h"

#define TOUCH_2D_X_POS_RANGE  1024
#define TOUCH_2D_Y_POS_RANGE  1024

bool touch_2d_calib(int32_t *values);
int32_t touch_2d_calc_position(int32_t *values, int32_t *x_pos, int32_t *y_pos);

typedef enum
{
    eTouch_2d_gesture_event_no_touch_keep = 0,
    //eTouch_2d_gesture_event_no_touch_just = 1,
    eTouch_2d_gesture_event_on_touch_just = 2,
    eTouch_2d_gesture_event_on_touch_move_0 = 3,
    eTouch_2d_gesture_event_on_touch_move_1 = 4,
    eTouch_2d_gesture_event_on_touch_move_2 = 5,
    eTouch_2d_gesture_event_on_touch_move_3 = 6,
    eTouch_2d_gesture_event_on_touch_move_4 = 7,

    /* to support double click. */
    eTouch_2d_gesture_event_no_touch_interval, /* 在短时的离开后返回. */
    eTouch_2d_gesture_event_on_touch_just_2nd_click,  /* 短时间内的第二次on_touch_just. */
    eTouch_2d_gesture_event_on_touch_just_3rd_click,  /* 短时间内的第三次on_touch_just. */

    eTouch_2d_gesture_event_on_touch_no_process,  /* 按下但不处理的模式 */
} touch_2d_gesture_event_t;

touch_2d_gesture_event_t touch_2d_gesture_process(int32_t x_pos, int32_t y_pos, bool on_touch);


#endif /* __TOUCH_2D_H__ */

