/*
 * Copyright (c) 2007-2015 Freescale Semiconductor, Inc.
 * Copyright 2018-2019 NXP
 *
 * License: NXP LA_OPT_NXP_Software_License
 *
 * NXP Confidential. This software is owned or controlled by NXP and may
 * only be used strictly in accordance with the applicable license terms.
 * By expressly accepting such terms or by downloading, installing,
 * activating and/or otherwise using the software, you are agreeing that
 * you have read, and that you agree to comply with and are bound by,
 * such license terms.  If you do not agree to be bound by the applicable
 * license terms, then you may not retain, install, activate or otherwise
 * use the software.  This code may only be used in a microprocessor,
 * microcontroller, sensor or digital signal processor ("NXP Product")
 * supplied directly or indirectly from NXP.  See the full NXP Software
 * License Agreement in license/LA_OPT_NXP_Software_License.pdf
 *
 * FreeMASTER Communication Driver - FlasCAN low-level driver
 */

#ifndef __FREEMASTER_MPC577xC_CAN_H
#define __FREEMASTER_MPC577xC_CAN_H

/******************************************************************************
* Required header files include check
******************************************************************************/
#ifndef __FREEMASTER_H
#error Please include the freemaster.h master header file before the freemaster_flexcan.h
#endif

#include <MPC577xC.h>

//Code values of the RX MB
#define RX_MB_INACTIVE 0x0
#define RX_MB_EMPTY 0x4
#define RX_MB_FULL 0x2
#define RX_MB_OVERRUN 0x6
#define RX_MB_RANSWER 0xA
#define RX_MB_BUSY	0x1 //only the low bit needs to be check for busy flag, other needs to be filtered
//Code values of the TX mB
#define TX_MB_INACTIVE 0x8
#define TX_MB_ABORT 0x9
#define TX_MB_DATA 0xC //RTR must be 0x0
#define TX_MB_REMOTE 0xC //RTR must be 0x1
#define TX_MB_TANSWER 0xE

/******************************************************************************
 *  CAN data types
 ******************************************************************************/
typedef struct
{
	uint32_t :4;
	uint32_t CODE:4;
	uint32_t :1;
	uint32_t SRR:1;
	uint32_t IDE:1;
	uint32_t RTR:1;
	uint32_t DLC:4;
	uint32_t TIMES:16;
	uint32_t PRIO:3;
	uint32_t ID:29;
	uint8_t data[8];
} flexcan_frame_t;

typedef struct
{
	uint8_t length;
	uint8_t data[8];
}flexcan_received_mb;

/******************************************************************************
* Adapter configuration
******************************************************************************/

/* flexcan needs to know the transmit and receive MB number */
#if ((FMSTR_USE_FLEXCAN) || (FMSTR_USE_FLEXCAN32))
    /* Flexcan TX message buffer must be defined */
    #ifndef FMSTR_FLEXCAN_TXMB
    /* #error FlexCAN transmit buffer needs to be specified (use FMSTR_FLEXCAN_TXMB) */
    #warning "FlexCAN Message Buffer 0 is used for transmitting messages"
    #define FMSTR_FLEXCAN_TXMB 0
    #endif
    /* Flexcan RX message buffer must be defined */
    #ifndef FMSTR_FLEXCAN_RXMB
    /* #error FlexCAN receive buffer needs to be specified (use FMSTR_FLEXCAN_RXMB) */
    #warning "FlexCAN Message Buffer 1 is used for receiving messages"
    #define FMSTR_FLEXCAN_RXMB 1
    #endif
#endif


#ifdef __cplusplus
  extern "C" {
#endif
      
/******************************************************************************
* Types definition
******************************************************************************/

/******************************************************************************
* inline functions
******************************************************************************/

/******************************************************************************
* Global API functions
******************************************************************************/
      
void FMSTR_CanSetBaseAddress(FMSTR_ADDR base);
void FMSTR_CanIsr(void);

#ifdef __cplusplus
  }
#endif

#endif /* __FREEMASTER_MPC574XP_CAN_H */

