/*
 * Copyright (c) 2007-2015 Freescale Semiconductor, Inc.
 * Copyright 2018-2019 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * FreeMASTER Communication Driver - User Configuration File
 */

#ifndef __FREEMASTER_CFG_H
#define __FREEMASTER_CFG_H

////////////////////////////////////////////////////////////////////////////////
// Definitions
////////////////////////////////////////////////////////////////////////////////

#define FMSTR_PLATFORM_CORTEX_M 0   /* Cortex-M platform (see freemaster.h for list of all supported platforms) */
#define FMSTR_PLATFORM_S32S 0
#define FMSTR_PLATFORM_PA32 1

//! Enable/Disable FreeMASTER functionalities
#define FMSTR_DISABLE           0   //!< To disable all FreeMASTER functionalities

//! Select interrupt or poll-driven serial communication
#define FMSTR_LONG_INTR         0   //!< Complete message processing in interrupt
#define FMSTR_SHORT_INTR        0   //!< Queuing done in interrupt
#define FMSTR_POLL_DRIVEN       1   //!< No interrupt needed, polling only

//! Select communication interface
#define FMSTR_SCI_BASE         	    0xFFFB0000UL 	/* eSCI A base on MPC5777C (Cobra55)*/
#define FMSTR_FLEXCAN_BASE         	0xFFFC0000UL 	/* FlexCAN A base on MPC5777C (Cobra55)*/
//! List of implemented standard FreeMASTER transports and its drivers
//!< FMSTR_SERIAL   -   Standard serial transport protocol (Used by various types of UART peripherals as USB CDC implementation)
//!<    FMSTR_SERIAL_MCUX_UART   -   MCUXSDK driver for UART peripheral
//!<    FMSTR_SERIAL_MCUX_LPUART -   MCUXSDK driver for LPUART peripheral
//!<    FMSTR_SERIAL_MCUX_USART  -   MCUXSDK driver for USART peripheral
//!<    FMSTR_SERIAL_MCUX_MINIUSART -MCUXSDK driver for MINIUSART peripheral
//!<    FMSTR_SERIAL_MCUX_USB    -   MCUXSDK driver for USB peripheral with CDC class
//!< FMSTR_CAN      -   Standard CAN transport protocol (Used by various types of CAN peripherals)
//!<    FMSTR_CAN_MCUX_FLEXCAN   -   MCUXSDK driver for FlexCAN peripheral
//!<    FMSTR_CAN_MCUX_MCAN      -   MCUXSDK driver for MCAN peripheral
//!<    FMSTR_CAN_MCUX_MSCAN     -   MCUXSDK driver for msCAN peripheral
//!< FMSTR_PDBDM    -   Packet Driven BDM (Background debug memory access using JTAG, SWD or BDM debug probes). This transport does not use low-level driver.

#define FMSTR_TRANSPORT         FMSTR_SERIAL    //!< Use serial transport layer */
#define FMSTR_SERIAL_DRV        FMSTR_SERIAL_MPC577xC_SCI //!< Use serial driver for UART */
#define FMSTR_CAN_DRV           FMSTR_FLEXCAN_MPC577XC  //!< Use serial driver for UART */

//! Define communication interface base address or leave undefined for runtime setting
// #undef FMSTR_SERIAL_BASE   //!< Serial base will be assigned in runtime (when FMSTR_USE_UART)
// #undef FMSTR_CAN_BASE   //!< CAN base will be assigned in runtime (when FMSTR_USE_FLEXCAN)

//! FlexCAN-specific, communication message buffers
#define FMSTR_FLEXCAN_TXMB      0
#define FMSTR_FLEXCAN_RXMB      1

//! Input/output communication buffer size
#define FMSTR_COMM_BUFFER_SIZE  0   //!< Set to 0 for "automatic"

//! Receive FIFO queue size (use with FMSTR_SHORT_INTR only)
#define FMSTR_COMM_RQUEUE_SIZE  32  //!< Set to 0 for "default"

//! Support for Application Commands
#define FMSTR_USE_APPCMD        1  //!< Enable/disable App.Commands support
#define FMSTR_APPCMD_BUFF_SIZE  32  //!< App.Command data buffer size
#define FMSTR_MAX_APPCMD_CALLS  4   //!< How many app.cmd callbacks? (0=disable)

//! Oscilloscope support
#define FMSTR_USE_SCOPE         1   //!< Specify count of enabled scopes
#define FMSTR_MAX_SCOPE_VARS    8   //!< Max. number of scope variables (2..8)

//! Recorder support
#define FMSTR_USE_RECORDER      1       //!< This application is using 2 recorders
#define FMSTR_MAX_REC_VARS    8     /* max. number of recorder variables (2..8) */
#define FMSTR_REC_OWNBUFF     0     /* use user-allocated rec. buffer (1=yes) */

//! Built-in recorder buffer
#define FMSTR_REC_BUFF_SIZE     16383    //!< Built-in buffer size. Set to zero to disable using embedded buffer for recorder 0.

//! Recorder time base, specifies how often the recorder is called in the user app.
#define FMSTR_REC_TIMEBASE      FMSTR_REC_BASE_MILLISEC(50)  //!< 0 = "unknown"
#define FMSTR_REC_FLOAT_TRIG    1   //!< Enable/disable floating point triggering

//!< Target-side address translation (TSA)
#define FMSTR_USE_TSA           0   //!< Enable TSA functionality
#define FMSTR_USE_TSA_INROM     1   //!< TSA tables declared as const (put to ROM)
#define FMSTR_USE_TSA_SAFETY    1   //!< Enable/Disable TSA memory protection
#define FMSTR_USE_TSA_DYNAMIC   1   //!< Enable/Disable TSA entries to be added also in runtime

//!< Pipes as data streaming over FreeMASTER protocol
#define FMSTR_USE_PIPES         3   //!< Enable/Disable pipes
//#define FMSTR_MAX_PIPES_COUNT   3   //!< 3 pipes for demo purposes

/*****************************************************************************
* Enable/Disable read/write memory commands
******************************************************************************/

#define FMSTR_USE_READMEM      1    /* enable read memory commands */
#define FMSTR_USE_WRITEMEM     1    /* enable write memory commands */
#define FMSTR_USE_WRITEMEMMASK 1    /* enable write memory bits commands */

/*****************************************************************************
* Enable/Disable read/write variable commands (a bit faster than Read Mem)
******************************************************************************/

#define FMSTR_USE_READVAR      0    /* enable read variable fast commands */
#define FMSTR_USE_WRITEVAR     0    /* enable write variable fast commands */
#define FMSTR_USE_WRITEVARMASK 0    /* enable write variable bits fast commands */


// Define password for access levels to protect them. AVOID SHORT PASSWORDS in production version.
// Passwords should be at least 20 characters long to prevent dictionary attacks.
//#define FMSTR_RESTRICTED_ACCESS_RWF_PASSWORD  "rwf"
//#define FMSTR_RESTRICTED_ACCESS_RW_PASSWORD   "rw"
//#define FMSTR_RESTRICTED_ACCESS_R_PASSWORD    "r"

// Storing cleartext passwords in Flash memory is not safe, consider storing their SHA1 hash instead
// Even with this option, the hash must be generated from reasonably complex password to prevent dictionary attack.
#define FMSTR_USE_HASHED_PASSWORDS  0  //!< When non-zero, the passwords above are specified as a pointer to 20-byte SHA1 hash of password text

#define FMSTR_DEBUG_TX 0

#endif /* __FREEMASTER_CFG_H */

////////////////////////////////////////////////////////////////////////////////
// EOF
////////////////////////////////////////////////////////////////////////////////
