#ifndef __BLDC_SCT_H__
#define __BLDC_SCT_H__

/*********************************Function declaration********************************************************/
/*****************************************************************************
+FUNCTION----------------------------------------------------------------
* @function name: MC_INIT
*
* @brief   The function is used to initiate PME and after call SCT init for motor control
*        
* @param  none
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/
extern void MC_INIT(void);

/*****************************************************************************
+FUNCTION----------------------------------------------------------------
* @function name: SCT_STOP
*
* @brief   The function is used to stop SCT function.
*        
* @param  none
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/
extern void SCT_STOP (void);
/*********************************Function declaration********************************************************/

/*********************************Macro Definition************************************************************/             
/**********************SCT match reload register*****************/
#define MR3                       SCT0->MATCHREL[3]//Match reload register 3 for complementary PWM edge 1
#define MR4                       SCT0->MATCHREL[4]//Match reload register 4 for complementary PWM edge 2
#define MR6                       SCT0->MATCHREL[6]//Match reload register 6 for ADC trigger
/**********************SCT match reload register*****************/

/**********************Pin for Hall Sensor***********************/
#define P0_2                      2//pin number for pin 2 on port 0
#define P0_3                      3//pin number for pin 3 on port 0
#define P0_5                      5//pin number for pin 5 on port 0
#define M_PHA                     P0_2//P0_2<---->Motor Phase A
#define M_PHB                     P0_3//P0_3<---->Motor Phase B
#define M_PHC                     P0_5//P0_5<---->Motor Phase C
/**********************Pin for Hall Sensor***********************/

/**********************SCTimer counter macro*********************/
//This is the value that will be loaded into PWM module register
#define CNT_MODULE_VALUE          1000      
//This is the minimum value for a PWM
#define CNT_MINIMUN_VALUE         100
//This is the maximum value for a PWM 
#define CNT_MAXIMUN_VALUE         2000      
#define CNT_NUM_VALUE		  (CNT_MODULO_VALUE - DEAD_TIME)
//30tick = 1us  Dead time used to avoid short circuits in the same phase transistors
#define DEAD_TIME                 15        
/**********************SCTimer counter macro*********************/
/*********************************Macro Definition************************************************************/

#endif
