#include "../../lvgl.h"

/*******************************************************************************
 * Size: 28 px
 * Bpp: 4
 * Opts: --no-compress --no-prefilter --bpp 4 --size 28 --font Roboto-Regular.woff -r 0x20-0x7F --font FontAwesome5-Solid+Brands+Regular.woff -r 61441,61448,61451,61452,61452,61453,61457,61459,61461,61465,61468,61473,61478,61479,61480,61502,61512,61515,61516,61517,61521,61522,61523,61524,61543,61544,61550,61552,61553,61556,61559,61560,61561,61563,61587,61589,61636,61637,61639,61671,61674,61683,61724,61732,61787,61931,62016,62017,62018,62019,62020,62087,62099,62212,62189,62810,63426,63650 --format lvgl -o lv_font_roboto_28.c --force-fast-kern-format
 ******************************************************************************/

#ifndef LV_FONT_ROBOTO_28
#define LV_FONT_ROBOTO_28 1
#endif

#if LV_FONT_ROBOTO_28

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xbf, 0xe0, 0xbf, 0xe0, 0xbf, 0xe0, 0xaf, 0xe0,
    0xaf, 0xe0, 0xaf, 0xd0, 0xaf, 0xd0, 0x9f, 0xd0,
    0x9f, 0xd0, 0x9f, 0xc0, 0x9f, 0xc0, 0x9f, 0xc0,
    0x8f, 0xc0, 0x8f, 0xc0, 0x13, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x5d, 0x90, 0xcf, 0xf2, 0x6f, 0xb0,

    /* U+22 "\"" */
    0x2f, 0xc0, 0x7f, 0x72, 0xfc, 0x7, 0xf7, 0x2f,
    0xb0, 0x7f, 0x62, 0xfa, 0x7, 0xf5, 0x2f, 0x80,
    0x7f, 0x42, 0xf7, 0x7, 0xf2, 0x1b, 0x40, 0x5b,
    0x10,

    /* U+23 "#" */
    0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x4, 0xfb, 0x0, 0xb, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x80, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xa, 0xf5, 0x0, 0x1f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x4,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x0,
    0x7f, 0x80, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0xe, 0xee, 0xff, 0xfe,
    0xee, 0xff, 0xee, 0xe3, 0x0, 0x0, 0x9, 0xf5,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x10, 0x4, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xe0, 0x0, 0x7f, 0x70, 0x0, 0x0, 0x0, 0x4,
    0xfa, 0x0, 0xb, 0xf3, 0x0, 0x0, 0xe, 0xee,
    0xef, 0xfe, 0xee, 0xff, 0xee, 0xe2, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x0, 0xdf, 0x10, 0x4, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0x3, 0xfb, 0x0, 0xa, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x80, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0x9, 0xf5, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x20, 0x3, 0xfc, 0x0,
    0x0, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x0, 0xdf, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0x30, 0x0, 0x0, 0x0, 0x1, 0x9e,
    0xff, 0xfa, 0x30, 0x0, 0x0, 0x3f, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0x1, 0xef, 0xf7, 0x32, 0x6f,
    0xff, 0x20, 0x6, 0xff, 0x50, 0x0, 0x4, 0xff,
    0x90, 0xa, 0xfe, 0x0, 0x0, 0x0, 0xcf, 0xe0,
    0xb, 0xfd, 0x0, 0x0, 0x0, 0x9f, 0xf0, 0x9,
    0xff, 0x10, 0x0, 0x0, 0x25, 0x50, 0x5, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xfd,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xff,
    0xa3, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xff,
    0xb1, 0x0, 0x0, 0x0, 0x0, 0x39, 0xff, 0xfe,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x1a, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x5b,
    0xb0, 0x0, 0x0, 0x0, 0x6f, 0xf3, 0x6f, 0xf2,
    0x0, 0x0, 0x0, 0x5f, 0xf3, 0x2f, 0xf8, 0x0,
    0x0, 0x0, 0xaf, 0xf0, 0xc, 0xff, 0x60, 0x0,
    0x8, 0xff, 0xa0, 0x2, 0xff, 0xfe, 0xcd, 0xff,
    0xfe, 0x10, 0x0, 0x2b, 0xff, 0xff, 0xff, 0xa1,
    0x0, 0x0, 0x0, 0x16, 0xff, 0x51, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x0, 0x0, 0x0,

    /* U+25 "%" */
    0x0, 0x7d, 0xfd, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xeb, 0xef, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xc0, 0x0, 0xcf, 0x40,
    0x0, 0x9, 0x20, 0x0, 0x8, 0xf6, 0x0, 0x6,
    0xf8, 0x0, 0x7, 0xf8, 0x0, 0x0, 0x9f, 0x50,
    0x0, 0x4f, 0x90, 0x2, 0xfd, 0x0, 0x0, 0x8,
    0xf6, 0x0, 0x5, 0xf8, 0x0, 0xbf, 0x40, 0x0,
    0x0, 0x4f, 0xc0, 0x0, 0xcf, 0x40, 0x6f, 0xa0,
    0x0, 0x0, 0x0, 0xaf, 0xeb, 0xdf, 0xb0, 0x1e,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x7d, 0xfe, 0x70,
    0xa, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x60, 0x1a, 0xef,
    0xc4, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xc0, 0x1e,
    0xfc, 0xbf, 0xf6, 0x0, 0x0, 0x0, 0xd, 0xf2,
    0x9, 0xf8, 0x0, 0x2f, 0xf0, 0x0, 0x0, 0x8,
    0xf8, 0x0, 0xdf, 0x10, 0x0, 0xbf, 0x40, 0x0,
    0x2, 0xfd, 0x0, 0xe, 0xf0, 0x0, 0x9, 0xf4,
    0x0, 0x0, 0xcf, 0x30, 0x0, 0xdf, 0x10, 0x0,
    0xbf, 0x40, 0x0, 0x1d, 0x90, 0x0, 0x9, 0xf8,
    0x0, 0x2f, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0xfc, 0xaf, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1a, 0xef, 0xc4, 0x0,

    /* U+26 "&" */
    0x0, 0x0, 0x7d, 0xff, 0xc6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf9, 0x22, 0x9f, 0xf5, 0x0,
    0x0, 0x0, 0xd, 0xfc, 0x0, 0x0, 0xcf, 0xa0,
    0x0, 0x0, 0x0, 0xff, 0x90, 0x0, 0xa, 0xfa,
    0x0, 0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0xef,
    0x70, 0x0, 0x0, 0x0, 0x9f, 0xf2, 0x1, 0xcf,
    0xe0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xc5, 0xef,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0xc1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0x50, 0x0, 0x2, 0x20, 0x0, 0x6f, 0xfb,
    0x2c, 0xff, 0x30, 0x3, 0xff, 0x10, 0x1f, 0xfc,
    0x0, 0x1d, 0xfe, 0x20, 0x5f, 0xf0, 0x7, 0xff,
    0x20, 0x0, 0x2e, 0xfd, 0x19, 0xfd, 0x0, 0x9f,
    0xf0, 0x0, 0x0, 0x4f, 0xfc, 0xff, 0x80, 0x8,
    0xff, 0x10, 0x0, 0x0, 0x5f, 0xff, 0xf1, 0x0,
    0x4f, 0xf9, 0x0, 0x0, 0x0, 0xcf, 0xfa, 0x0,
    0x0, 0xbf, 0xfa, 0x31, 0x15, 0xcf, 0xff, 0xf5,
    0x0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xf8, 0xcf,
    0xf2, 0x0, 0x0, 0x5a, 0xef, 0xfd, 0x82, 0x2,
    0xff, 0xd1,

    /* U+27 "'" */
    0x9f, 0x79, 0xf7, 0x9f, 0x69, 0xf5, 0x9f, 0x49,
    0xf3, 0x48, 0x10,

    /* U+28 "(" */
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0xa,
    0xc0, 0x0, 0x0, 0xb, 0xfb, 0x0, 0x0, 0x9,
    0xfc, 0x0, 0x0, 0x4, 0xff, 0x10, 0x0, 0x0,
    0xdf, 0x70, 0x0, 0x0, 0x6f, 0xe0, 0x0, 0x0,
    0xd, 0xf9, 0x0, 0x0, 0x2, 0xff, 0x30, 0x0,
    0x0, 0x7f, 0xf0, 0x0, 0x0, 0xb, 0xfb, 0x0,
    0x0, 0x0, 0xef, 0x90, 0x0, 0x0, 0xf, 0xf7,
    0x0, 0x0, 0x2, 0xff, 0x60, 0x0, 0x0, 0x2f,
    0xf5, 0x0, 0x0, 0x2, 0xff, 0x50, 0x0, 0x0,
    0x2f, 0xf6, 0x0, 0x0, 0x0, 0xff, 0x70, 0x0,
    0x0, 0xe, 0xf9, 0x0, 0x0, 0x0, 0xbf, 0xb0,
    0x0, 0x0, 0x6, 0xfe, 0x0, 0x0, 0x0, 0x2f,
    0xf3, 0x0, 0x0, 0x0, 0xdf, 0x80, 0x0, 0x0,
    0x6, 0xfe, 0x0, 0x0, 0x0, 0xd, 0xf6, 0x0,
    0x0, 0x0, 0x4f, 0xe1, 0x0, 0x0, 0x0, 0x9f,
    0xb0, 0x0, 0x0, 0x0, 0xbf, 0xa0, 0x0, 0x0,
    0x0, 0xad, 0x0, 0x0, 0x0, 0x0, 0x20,

    /* U+29 ")" */
    0x1, 0x0, 0x0, 0x0, 0x4f, 0x40, 0x0, 0x0,
    0x3e, 0xf5, 0x0, 0x0, 0x3, 0xff, 0x20, 0x0,
    0x0, 0x8f, 0xd0, 0x0, 0x0, 0xe, 0xf7, 0x0,
    0x0, 0x7, 0xfe, 0x0, 0x0, 0x1, 0xff, 0x60,
    0x0, 0x0, 0xbf, 0xb0, 0x0, 0x0, 0x7f, 0xf0,
    0x0, 0x0, 0x3f, 0xf4, 0x0, 0x0, 0xf, 0xf7,
    0x0, 0x0, 0xe, 0xf9, 0x0, 0x0, 0xd, 0xfb,
    0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0xd, 0xfb,
    0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0xe, 0xf9,
    0x0, 0x0, 0xf, 0xf7, 0x0, 0x0, 0x3f, 0xf4,
    0x0, 0x0, 0x6f, 0xf0, 0x0, 0x0, 0xaf, 0xb0,
    0x0, 0x0, 0xff, 0x60, 0x0, 0x5, 0xfe, 0x0,
    0x0, 0xd, 0xf7, 0x0, 0x0, 0x6f, 0xd0, 0x0,
    0x2, 0xff, 0x30, 0x0, 0x2e, 0xf5, 0x0, 0x0,
    0x4f, 0x50, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0,

    /* U+2A "*" */
    0x0, 0x0, 0xf, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf0,
    0x0, 0x0, 0x1a, 0x40, 0xe, 0xf0, 0x2, 0x81,
    0x6f, 0xfe, 0x8e, 0xf7, 0xcf, 0xf6, 0x28, 0xdf,
    0xff, 0xff, 0xff, 0xa4, 0x0, 0x2, 0xcf, 0xfc,
    0x40, 0x0, 0x0, 0x4, 0xfe, 0xff, 0x20, 0x0,
    0x0, 0x1e, 0xf5, 0x7f, 0xd0, 0x0, 0x0, 0xbf,
    0xb0, 0xd, 0xf9, 0x0, 0x0, 0xbf, 0x10, 0x3,
    0xfb, 0x0, 0x0, 0x3, 0x0, 0x0, 0x40, 0x0,

    /* U+2B "+" */
    0x0, 0x0, 0x2, 0x77, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x20,
    0x0, 0x0, 0x56, 0x66, 0x69, 0xff, 0x76, 0x66,
    0x64, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x6, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x20, 0x0,
    0x0,

    /* U+2C "," */
    0x4, 0xff, 0x30, 0x4f, 0xf3, 0x4, 0xff, 0x20,
    0x7f, 0xf0, 0xc, 0xf9, 0x5, 0xff, 0x10, 0x1b,
    0x40, 0x0,

    /* U+2D "-" */
    0x1, 0x11, 0x11, 0x10, 0x8f, 0xff, 0xff, 0xf2,
    0x8f, 0xff, 0xff, 0xf2,

    /* U+2E "." */
    0x9, 0xfa, 0x0, 0xff, 0xf1, 0x9, 0xfa, 0x0,

    /* U+2F "/" */
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x80, 0x0, 0x0,
    0x0, 0xf, 0xf2, 0x0, 0x0, 0x0, 0x6, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0x2f, 0xf0, 0x0, 0x0, 0x0, 0x9, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x30, 0x0, 0x0,
    0x0, 0x5f, 0xd0, 0x0, 0x0, 0x0, 0xb, 0xf6,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x7f, 0xa0, 0x0, 0x0, 0x0, 0xe, 0xf4,
    0x0, 0x0, 0x0, 0x4, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x80, 0x0, 0x0, 0x0, 0x1f, 0xf2,
    0x0, 0x0, 0x0, 0x6, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0x50, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x9, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x30, 0x0, 0x0, 0x0, 0x5f, 0xc0,
    0x0, 0x0, 0x0, 0x5, 0x84, 0x0, 0x0, 0x0,
    0x0,

    /* U+30 "0" */
    0x0, 0x2, 0x9d, 0xff, 0xc8, 0x10, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x2, 0xff,
    0xd5, 0x12, 0x7f, 0xfd, 0x0, 0xa, 0xff, 0x10,
    0x0, 0x5, 0xff, 0x50, 0xf, 0xf9, 0x0, 0x0,
    0x0, 0xdf, 0xb0, 0x2f, 0xf5, 0x0, 0x0, 0x0,
    0x9f, 0xe0, 0x5f, 0xf2, 0x0, 0x0, 0x0, 0x7f,
    0xf0, 0x6f, 0xf2, 0x0, 0x0, 0x0, 0x6f, 0xf1,
    0x6f, 0xf1, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x6f,
    0xf1, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x6f, 0xf1,
    0x0, 0x0, 0x0, 0x6f, 0xf2, 0x6f, 0xf1, 0x0,
    0x0, 0x0, 0x6f, 0xf2, 0x5f, 0xf2, 0x0, 0x0,
    0x0, 0x6f, 0xf1, 0x5f, 0xf3, 0x0, 0x0, 0x0,
    0x7f, 0xf0, 0x2f, 0xf5, 0x0, 0x0, 0x0, 0x9f,
    0xe0, 0xf, 0xf9, 0x0, 0x0, 0x0, 0xef, 0xa0,
    0x9, 0xff, 0x20, 0x0, 0x5, 0xff, 0x50, 0x2,
    0xff, 0xe5, 0x11, 0x6f, 0xfc, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x2, 0x9d,
    0xff, 0xd8, 0x10, 0x0,

    /* U+31 "1" */
    0x0, 0x0, 0x3, 0x9e, 0x0, 0x17, 0xdf, 0xff,
    0x4b, 0xff, 0xff, 0xff, 0xaf, 0xfd, 0x7a, 0xff,
    0x99, 0x30, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x9, 0xff,

    /* U+32 "2" */
    0x0, 0x4, 0xae, 0xff, 0xc8, 0x10, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xff, 0xe3, 0x0, 0xa, 0xff,
    0xb3, 0x12, 0x8f, 0xff, 0x10, 0x3f, 0xf9, 0x0,
    0x0, 0x6, 0xff, 0x70, 0x8f, 0xf1, 0x0, 0x0,
    0x0, 0xff, 0xb0, 0xbf, 0xe0, 0x0, 0x0, 0x0,
    0xcf, 0xc0, 0x1, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xef, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xe2, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0x31, 0x11, 0x11, 0x11, 0x10, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb,

    /* U+33 "3" */
    0x0, 0x4, 0xae, 0xfe, 0xc7, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x9, 0xff, 0xa4,
    0x13, 0x8f, 0xfc, 0x2, 0xff, 0xa0, 0x0, 0x0,
    0x7f, 0xf4, 0x6f, 0xf2, 0x0, 0x0, 0x1, 0xff,
    0x83, 0x77, 0x0, 0x0, 0x0, 0xf, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xf1, 0x0, 0x0, 0x1, 0x14,
    0xbf, 0xf6, 0x0, 0x0, 0xa, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xa1, 0x0,
    0x0, 0x0, 0x0, 0x28, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xfc, 0x35, 0x40, 0x0, 0x0, 0x0,
    0xaf, 0xea, 0xff, 0x0, 0x0, 0x0, 0xc, 0xfc,
    0x6f, 0xf6, 0x0, 0x0, 0x4, 0xff, 0x80, 0xdf,
    0xf9, 0x31, 0x27, 0xef, 0xe1, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0xe3, 0x0, 0x0, 0x6b, 0xef, 0xfc,
    0x71, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xef, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xfe, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf5, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x1, 0xef, 0x73, 0xff, 0x50, 0x0,
    0x0, 0x0, 0xa, 0xfc, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x4f, 0xf3, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x0, 0xef, 0x80, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x9, 0xfd, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x4f, 0xf3, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0xef, 0x90, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x9, 0xfd, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,

    /* U+35 "5" */
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x6, 0xff, 0x55,
    0x55, 0x55, 0x55, 0x0, 0x8f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x90, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf7, 0x2, 0x33, 0x0, 0x0, 0x0, 0xff, 0xbe,
    0xff, 0xff, 0x91, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xd1, 0x1, 0xef, 0xc3, 0x0, 0x4d, 0xff,
    0xa0, 0x0, 0x20, 0x0, 0x0, 0xd, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xf9, 0x68, 0x40, 0x0, 0x0, 0x0,
    0xff, 0x8b, 0xfc, 0x0, 0x0, 0x0, 0x4f, 0xf5,
    0x6f, 0xf4, 0x0, 0x0, 0xc, 0xff, 0x10, 0xdf,
    0xf7, 0x21, 0x3b, 0xff, 0x70, 0x2, 0xdf, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x7c, 0xff, 0xea,
    0x40, 0x0,

    /* U+36 "6" */
    0x0, 0x0, 0x0, 0x5a, 0xdf, 0x80, 0x0, 0x0,
    0x0, 0x4e, 0xff, 0xff, 0x90, 0x0, 0x0, 0x6,
    0xff, 0xfa, 0x53, 0x10, 0x0, 0x0, 0x4f, 0xfc,
    0x20, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xfd, 0x0, 0x1, 0x0, 0x0,
    0x0, 0xc, 0xf9, 0x3b, 0xff, 0xfc, 0x50, 0x0,
    0xf, 0xfc, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x1f,
    0xff, 0xe7, 0x20, 0x4d, 0xff, 0x50, 0x2f, 0xfe,
    0x20, 0x0, 0x1, 0xef, 0xd0, 0x3f, 0xf7, 0x0,
    0x0, 0x0, 0x7f, 0xf2, 0x3f, 0xf5, 0x0, 0x0,
    0x0, 0x4f, 0xf4, 0x2f, 0xf6, 0x0, 0x0, 0x0,
    0x2f, 0xf5, 0xf, 0xf9, 0x0, 0x0, 0x0, 0x4f,
    0xf4, 0xa, 0xfe, 0x0, 0x0, 0x0, 0x8f, 0xf1,
    0x4, 0xff, 0x80, 0x0, 0x1, 0xef, 0xb0, 0x0,
    0xaf, 0xf9, 0x21, 0x5d, 0xff, 0x30, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x5c,
    0xef, 0xd9, 0x20, 0x0,

    /* U+37 "7" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x6f, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf7,
    0x0, 0x0, 0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x2, 0x9d, 0xff, 0xc7, 0x10, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x3, 0xff,
    0xe5, 0x22, 0x8f, 0xfe, 0x0, 0xa, 0xff, 0x20,
    0x0, 0x7, 0xff, 0x60, 0xe, 0xfb, 0x0, 0x0,
    0x0, 0xff, 0xa0, 0xf, 0xf9, 0x0, 0x0, 0x0,
    0xdf, 0xb0, 0xd, 0xfb, 0x0, 0x0, 0x0, 0xff,
    0x90, 0x8, 0xff, 0x20, 0x0, 0x6, 0xff, 0x30,
    0x1, 0xdf, 0xe5, 0x23, 0x8f, 0xf9, 0x0, 0x0,
    0x1b, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x4d,
    0xff, 0xff, 0xff, 0xa1, 0x0, 0x4, 0xff, 0xb3,
    0x1, 0x5e, 0xfd, 0x10, 0xe, 0xfb, 0x0, 0x0,
    0x1, 0xef, 0xa0, 0x4f, 0xf3, 0x0, 0x0, 0x0,
    0x8f, 0xf0, 0x6f, 0xf1, 0x0, 0x0, 0x0, 0x5f,
    0xf2, 0x6f, 0xf3, 0x0, 0x0, 0x0, 0x7f, 0xf1,
    0x2f, 0xfa, 0x0, 0x0, 0x1, 0xef, 0xd0, 0xa,
    0xff, 0xb4, 0x12, 0x5d, 0xff, 0x50, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x4, 0xae,
    0xff, 0xd9, 0x20, 0x0,

    /* U+39 "9" */
    0x0, 0x4, 0xae, 0xfe, 0xa3, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x7, 0xff, 0xb4,
    0x14, 0xcf, 0xf6, 0x0, 0xff, 0xc0, 0x0, 0x0,
    0xcf, 0xe0, 0x5f, 0xf3, 0x0, 0x0, 0x3, 0xff,
    0x58, 0xff, 0x0, 0x0, 0x0, 0xe, 0xf9, 0x9f,
    0xe0, 0x0, 0x0, 0x0, 0xbf, 0xc9, 0xff, 0x0,
    0x0, 0x0, 0xa, 0xfd, 0x6f, 0xf3, 0x0, 0x0,
    0x0, 0xbf, 0xe1, 0xff, 0xb0, 0x0, 0x0, 0x6f,
    0xfd, 0xa, 0xff, 0xb2, 0x2, 0x9f, 0xff, 0xc0,
    0xc, 0xff, 0xff, 0xff, 0xcc, 0xfb, 0x0, 0x8,
    0xef, 0xfd, 0x70, 0xdf, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x1, 0xef, 0xb0,
    0x0, 0x0, 0x0, 0x2, 0xcf, 0xf2, 0x0, 0x0,
    0x13, 0x59, 0xff, 0xf5, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xd4, 0x0, 0x0, 0x0, 0xde, 0xda, 0x50,
    0x0, 0x0,

    /* U+3A ":" */
    0xb, 0xf8, 0x1f, 0xff, 0xb, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf8, 0x2f, 0xff, 0xb, 0xf8,

    /* U+3B ";" */
    0x2, 0xde, 0x40, 0x7f, 0xf9, 0x2, 0xde, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x60, 0x1f, 0xf6, 0x2, 0xff, 0x50, 0x4f, 0xf2,
    0xa, 0xfc, 0x2, 0xff, 0x30, 0x9, 0x60, 0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2a, 0x20, 0x0,
    0x0, 0x0, 0x4, 0xbf, 0xf2, 0x0, 0x0, 0x0,
    0x5c, 0xff, 0xff, 0x20, 0x0, 0x6, 0xdf, 0xff,
    0xd6, 0x0, 0x1, 0x7e, 0xff, 0xfa, 0x30, 0x0,
    0x0, 0xff, 0xfd, 0x71, 0x0, 0x0, 0x0, 0xf,
    0xfe, 0x60, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff,
    0xf9, 0x30, 0x0, 0x0, 0x0, 0x5, 0xcf, 0xff,
    0xc6, 0x0, 0x0, 0x0, 0x0, 0x4b, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x3, 0xaf, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x29, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x0,

    /* U+3D "=" */
    0xef, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x23, 0x33, 0x33, 0x33,
    0x33, 0x31, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x21, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf7,

    /* U+3E ">" */
    0x2a, 0x30, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xc5, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xff, 0xfe,
    0x71, 0x0, 0x0, 0x0, 0x4, 0xaf, 0xff, 0xf9,
    0x20, 0x0, 0x0, 0x0, 0x17, 0xdf, 0xff, 0xb4,
    0x0, 0x0, 0x0, 0x0, 0x39, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x4b, 0xff, 0x80, 0x0, 0x0,
    0x28, 0xef, 0xff, 0x92, 0x0, 0x5, 0xbf, 0xff,
    0xe8, 0x10, 0x0, 0x8e, 0xff, 0xfd, 0x60, 0x0,
    0x0, 0x2f, 0xff, 0xb4, 0x0, 0x0, 0x0, 0x2,
    0xf9, 0x20, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x0, 0x3a, 0xef, 0xec, 0x60, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x4f, 0xfd, 0x63, 0x5c,
    0xff, 0x80, 0xbf, 0xe1, 0x0, 0x0, 0xdf, 0xe0,
    0xcd, 0x80, 0x0, 0x0, 0x8f, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x3e, 0xfd, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xe2, 0x0, 0x0, 0x0, 0x1e, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x9f, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xa0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x55, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xac, 0x40, 0x0, 0x0, 0x0, 0x3, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x0, 0x0, 0x5a, 0xde, 0xfe, 0xc8,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xef,
    0xff, 0xdd, 0xef, 0xff, 0xb2, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0x93, 0x0, 0x0, 0x5, 0xbf,
    0xf4, 0x0, 0x0, 0x0, 0xb, 0xfc, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xf3, 0x0, 0x0, 0x9,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xd0, 0x0, 0x4, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x70, 0x0, 0xcf, 0x40,
    0x0, 0x0, 0x39, 0xba, 0x60, 0x0, 0x0, 0xed,
    0x0, 0x3f, 0xd0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xd2, 0x0, 0x9, 0xf2, 0x9, 0xf6, 0x0, 0x0,
    0x7f, 0xe4, 0x2, 0xdf, 0x40, 0x0, 0x5f, 0x60,
    0xdf, 0x20, 0x0, 0x2f, 0xf2, 0x0, 0xd, 0xf3,
    0x0, 0x3, 0xf8, 0x1f, 0xe0, 0x0, 0x9, 0xf8,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x1f, 0xa3, 0xfb,
    0x0, 0x0, 0xff, 0x20, 0x0, 0xf, 0xf0, 0x0,
    0x1, 0xfa, 0x5f, 0xa0, 0x0, 0x3f, 0xe0, 0x0,
    0x1, 0xfe, 0x0, 0x0, 0xf, 0xb6, 0xf9, 0x0,
    0x6, 0xfc, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x2,
    0xfa, 0x6f, 0x90, 0x0, 0x8f, 0xa0, 0x0, 0x4,
    0xfb, 0x0, 0x0, 0x4f, 0x85, 0xf9, 0x0, 0x8,
    0xfb, 0x0, 0x0, 0x7f, 0xa0, 0x0, 0x7, 0xf4,
    0x4f, 0xb0, 0x0, 0x6f, 0xe0, 0x0, 0xe, 0xfa,
    0x0, 0x0, 0xee, 0x1, 0xfe, 0x0, 0x2, 0xff,
    0x70, 0x1b, 0xff, 0xe0, 0x0, 0x9f, 0x70, 0xd,
    0xf3, 0x0, 0xa, 0xff, 0xff, 0xf3, 0xcf, 0xda,
    0xdf, 0xa0, 0x0, 0x7f, 0x90, 0x0, 0x9, 0xef,
    0xb3, 0x1, 0xae, 0xfd, 0x60, 0x0, 0x1, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xfb,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0x72, 0x0, 0x0, 0x4,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xfd, 0xcb, 0xcf, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x6b, 0xdf, 0xfe, 0xc8, 0x20,
    0x0, 0x0, 0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x0, 0x3, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xfd,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xb7, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x51, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0x0, 0xbf, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xfa, 0x0, 0x5f, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf4, 0x0, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xe0, 0x0, 0xa, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x90, 0x0, 0x4,
    0xff, 0x40, 0x0, 0x0, 0x6, 0xff, 0x30, 0x0,
    0x0, 0xef, 0xa0, 0x0, 0x0, 0xc, 0xfe, 0x22,
    0x22, 0x22, 0xaf, 0xf1, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0xef, 0xc0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x20,
    0x4, 0xff, 0x60, 0x0, 0x0, 0x0, 0x2, 0xff,
    0x80, 0xa, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xe0, 0x1f, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf5, 0x6f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xfb,

    /* U+42 "B" */
    0xbf, 0xff, 0xff, 0xff, 0xda, 0x40, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0xbf, 0xf2,
    0x22, 0x23, 0x5c, 0xff, 0x90, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0xdf, 0xf0, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0x7f, 0xf3, 0xbf, 0xf0, 0x0, 0x0, 0x0,
    0x5f, 0xf4, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x7f,
    0xf2, 0xbf, 0xf0, 0x0, 0x0, 0x1, 0xef, 0xd0,
    0xbf, 0xf1, 0x11, 0x13, 0x6e, 0xff, 0x30, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xc2, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x10, 0xbf, 0xf0, 0x0,
    0x0, 0x16, 0xff, 0xd0, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0x5f, 0xf6, 0xbf, 0xf0, 0x0, 0x0, 0x0,
    0xe, 0xfb, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0xc,
    0xfd, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0xe, 0xfc,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x8f, 0xf7, 0xbf,
    0xf2, 0x22, 0x22, 0x5a, 0xff, 0xe1, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x30, 0xbf, 0xff, 0xff,
    0xff, 0xeb, 0x60, 0x0,

    /* U+43 "C" */
    0x0, 0x0, 0x6, 0xbe, 0xfe, 0xc8, 0x10, 0x0,
    0x0, 0x3, 0xdf, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x3f, 0xff, 0x94, 0x23, 0x7e, 0xff, 0x60,
    0x0, 0xdf, 0xf3, 0x0, 0x0, 0x1, 0xef, 0xf1,
    0x7, 0xff, 0x50, 0x0, 0x0, 0x0, 0x4f, 0xf7,
    0xd, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfc,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x6, 0x87,
    0x4f, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5, 0x76,
    0xd, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xe, 0xfc,
    0x7, 0xff, 0x40, 0x0, 0x0, 0x0, 0x4f, 0xf7,
    0x1, 0xef, 0xe2, 0x0, 0x0, 0x0, 0xdf, 0xf1,
    0x0, 0x4f, 0xff, 0x83, 0x23, 0x7e, 0xff, 0x60,
    0x0, 0x4, 0xef, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x7, 0xce, 0xfe, 0xc8, 0x10, 0x0,

    /* U+44 "D" */
    0xbf, 0xff, 0xff, 0xfd, 0xa4, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x0, 0xbf,
    0xf2, 0x22, 0x35, 0xaf, 0xff, 0x30, 0xb, 0xff,
    0x0, 0x0, 0x0, 0x3e, 0xfe, 0x10, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x3f, 0xf9, 0xb, 0xff, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xf1, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0x5b, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf8, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xab, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xfb, 0xbf, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xbb, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xfa, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x8b, 0xff, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xf5, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0x1b, 0xff, 0x0, 0x0, 0x0, 0x4, 0xff, 0x90,
    0xbf, 0xf0, 0x0, 0x0, 0x4, 0xff, 0xe1, 0xb,
    0xff, 0x22, 0x23, 0x5b, 0xff, 0xf3, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xc2, 0x0, 0xb, 0xff,
    0xff, 0xfe, 0xd9, 0x40, 0x0, 0x0,

    /* U+45 "E" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xbf, 0xf2, 0x22,
    0x22, 0x22, 0x22, 0x2b, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf2, 0x22, 0x22,
    0x22, 0x21, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xb,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x22, 0x22, 0x22, 0x22, 0x22, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff,

    /* U+46 "F" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xab, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0xbf, 0xf2, 0x22,
    0x22, 0x22, 0x22, 0x1b, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xb,
    0xff, 0x22, 0x22, 0x22, 0x22, 0x0, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x0, 0x6, 0xbe, 0xff, 0xd9, 0x30, 0x0,
    0x0, 0x0, 0x4e, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x4f, 0xff, 0x94, 0x23, 0x6d, 0xff,
    0x90, 0x0, 0x1e, 0xff, 0x30, 0x0, 0x0, 0xc,
    0xff, 0x30, 0x7, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x2f, 0xfa, 0x0, 0xdf, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0xbe, 0xd0, 0xf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0x50, 0x0,
    0x0, 0x22, 0x22, 0x22, 0x20, 0x5f, 0xf5, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0x4, 0xff, 0x50,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xf0, 0x3f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x0, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xf0, 0xb,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x0,
    0x5f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xf0,
    0x0, 0xcf, 0xf6, 0x0, 0x0, 0x0, 0xc, 0xff,
    0x0, 0x1, 0xef, 0xfb, 0x52, 0x23, 0x7d, 0xff,
    0xa0, 0x0, 0x1, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x4a, 0xdf, 0xfe, 0xc8,
    0x20, 0x0,

    /* U+48 "H" */
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf2, 0x22, 0x22, 0x22, 0x22, 0x2f, 0xf9,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,

    /* U+49 "I" */
    0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2,
    0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2,
    0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2,
    0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2,
    0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2, 0x8f, 0xf2,

    /* U+4A "J" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf4, 0x2b, 0xb4, 0x0, 0x0, 0x0, 0x6f,
    0xf4, 0x2f, 0xf8, 0x0, 0x0, 0x0, 0x9f, 0xf1,
    0xe, 0xfe, 0x10, 0x0, 0x2, 0xff, 0xd0, 0x6,
    0xff, 0xe6, 0x33, 0x7f, 0xff, 0x40, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x3, 0xad,
    0xff, 0xd9, 0x20, 0x0,

    /* U+4B "K" */
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0xa, 0xff, 0x80,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0xf9, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x7, 0xff, 0xb0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x5f, 0xfc, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x4, 0xff, 0xd1, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x3f, 0xfe, 0x20, 0x0, 0x0,
    0xbf, 0xf0, 0x2, 0xef, 0xf3, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x1d, 0xff, 0x40, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0xcf, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xfb, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xfe, 0xff, 0x60, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0x91, 0xef, 0xf2, 0x0, 0x0, 0x0,
    0xbf, 0xfa, 0x0, 0x4f, 0xfd, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x8, 0xff, 0xa0, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0xbf, 0xf6, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x1e, 0xff, 0x30, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x4, 0xff, 0xd0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x7f, 0xfa, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x60,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xf3,

    /* U+4C "L" */
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x22, 0x22, 0x22, 0x22, 0x20, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x6b, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6,

    /* U+4D "M" */
    0xbf, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0x2b, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xf2, 0xbf, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x2b,
    0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xf2, 0xbf, 0xcf, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xfb, 0xff, 0x2b, 0xfb, 0xaf, 0xe0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0x6f, 0xf2, 0xbf,
    0xc4, 0xff, 0x40, 0x0, 0x0, 0x0, 0xdf, 0xa5,
    0xff, 0x2b, 0xfc, 0xd, 0xfb, 0x0, 0x0, 0x0,
    0x4f, 0xf4, 0x5f, 0xf2, 0xbf, 0xd0, 0x7f, 0xf1,
    0x0, 0x0, 0xa, 0xfd, 0x6, 0xff, 0x2b, 0xfd,
    0x1, 0xff, 0x70, 0x0, 0x1, 0xff, 0x70, 0x6f,
    0xf2, 0xbf, 0xe0, 0xa, 0xfe, 0x0, 0x0, 0x7f,
    0xf1, 0x7, 0xff, 0x2b, 0xfe, 0x0, 0x3f, 0xf4,
    0x0, 0xd, 0xfa, 0x0, 0x7f, 0xf2, 0xbf, 0xe0,
    0x0, 0xdf, 0xa0, 0x4, 0xff, 0x30, 0x7, 0xff,
    0x2b, 0xff, 0x0, 0x6, 0xff, 0x10, 0xaf, 0xd0,
    0x0, 0x8f, 0xf2, 0xbf, 0xf0, 0x0, 0xf, 0xf7,
    0x1f, 0xf6, 0x0, 0x8, 0xff, 0x2b, 0xff, 0x0,
    0x0, 0x9f, 0xd7, 0xff, 0x0, 0x0, 0x8f, 0xf2,
    0xbf, 0xf0, 0x0, 0x3, 0xff, 0xff, 0x90, 0x0,
    0x8, 0xff, 0x2b, 0xff, 0x0, 0x0, 0xc, 0xff,
    0xf3, 0x0, 0x0, 0x8f, 0xf2, 0xbf, 0xf0, 0x0,
    0x0, 0x6f, 0xfc, 0x0, 0x0, 0x8, 0xff, 0x2b,
    0xff, 0x0, 0x0, 0x0, 0xff, 0x60, 0x0, 0x0,
    0x8f, 0xf2,

    /* U+4E "N" */
    0xbf, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xff, 0x90, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xff, 0xf3, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xff, 0xfd, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf7, 0xff, 0x80, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0xcf, 0xf2, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x2f, 0xfc, 0x0, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x8, 0xff, 0x70, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0xdf, 0xf2, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x3f, 0xfc, 0x0, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x8, 0xff, 0x60, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0xdf, 0xf1, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x4f, 0xfb, 0xf, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x9, 0xff, 0x5f, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0xef, 0xef, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xf9,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf9,

    /* U+4F "O" */
    0x0, 0x0, 0x5, 0xbe, 0xfe, 0xc7, 0x10, 0x0,
    0x0, 0x0, 0x2d, 0xff, 0xff, 0xff, 0xfe, 0x50,
    0x0, 0x0, 0x2e, 0xff, 0xb6, 0x45, 0x9f, 0xff,
    0x60, 0x0, 0xd, 0xff, 0x50, 0x0, 0x0, 0x2e,
    0xff, 0x20, 0x5, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x3f, 0xfa, 0x0, 0xcf, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xf0, 0xf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0x43, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xf7, 0x5f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x86, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf9, 0x6f, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x95, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf9, 0x4f, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0x71, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4, 0xc,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0x10,
    0x6f, 0xf6, 0x0, 0x0, 0x0, 0x2, 0xff, 0xa0,
    0x0, 0xdf, 0xf4, 0x0, 0x0, 0x1, 0xdf, 0xf2,
    0x0, 0x2, 0xef, 0xfa, 0x53, 0x48, 0xff, 0xf6,
    0x0, 0x0, 0x2, 0xdf, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x5b, 0xef, 0xec, 0x71,
    0x0, 0x0,

    /* U+50 "P" */
    0xbf, 0xff, 0xff, 0xff, 0xfd, 0x92, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xbf,
    0xf2, 0x22, 0x22, 0x37, 0xef, 0xf7, 0xb, 0xff,
    0x0, 0x0, 0x0, 0x1, 0xdf, 0xf1, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x5, 0xff, 0x6b, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xf9, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0x9b, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf7, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0x3b, 0xff, 0x0, 0x0, 0x0,
    0x4b, 0xff, 0xa0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x60, 0x0, 0xbf, 0xf2, 0x22, 0x21, 0x10, 0x0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x0, 0x6, 0xbe, 0xfe, 0xb7, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xff, 0xff, 0xfe, 0x40,
    0x0, 0x0, 0x4f, 0xff, 0xa5, 0x45, 0xaf, 0xff,
    0x40, 0x0, 0x1e, 0xff, 0x30, 0x0, 0x0, 0x3e,
    0xfe, 0x10, 0x7, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x4f, 0xf8, 0x0, 0xef, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xe0, 0x2f, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0x25, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf6, 0x7f, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0x78, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xf8, 0x8f, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x87, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf6, 0x6f, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x52, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xf3, 0xe,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0xc, 0xfe, 0x0,
    0x8f, 0xf5, 0x0, 0x0, 0x0, 0x4, 0xff, 0x80,
    0x1, 0xef, 0xf3, 0x0, 0x0, 0x2, 0xef, 0xe0,
    0x0, 0x4, 0xff, 0xfa, 0x53, 0x59, 0xff, 0xf4,
    0x0, 0x0, 0x3, 0xef, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x6b, 0xef, 0xed, 0xff,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xef, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xc6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+52 "R" */
    0xbf, 0xff, 0xff, 0xff, 0xea, 0x50, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x0, 0xbf,
    0xf2, 0x22, 0x23, 0x5c, 0xff, 0xd0, 0xb, 0xff,
    0x0, 0x0, 0x0, 0x9, 0xff, 0x60, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0xf, 0xfb, 0xb, 0xff, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xd0, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0xc, 0xfd, 0xb, 0xff, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xb0, 0xbf, 0xf0, 0x0, 0x0,
    0x0, 0xaf, 0xf5, 0xb, 0xff, 0x22, 0x22, 0x25,
    0xcf, 0xfa, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0x2, 0xff, 0xa0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x9, 0xff, 0x30,
    0x0, 0xbf, 0xf0, 0x0, 0x0, 0x1f, 0xfb, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0x7f, 0xf4, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0xef, 0xd0, 0xb,
    0xff, 0x0, 0x0, 0x0, 0x6, 0xff, 0x60, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0xd, 0xfe, 0xb, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xf7,

    /* U+53 "S" */
    0x0, 0x1, 0x8c, 0xef, 0xec, 0x71, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x0, 0x5,
    0xff, 0xe7, 0x32, 0x37, 0xef, 0xf4, 0x0, 0xef,
    0xe1, 0x0, 0x0, 0x1, 0xef, 0xe0, 0x3f, 0xf8,
    0x0, 0x0, 0x0, 0x6, 0xff, 0x44, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x2e, 0xe6, 0x1f, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfa, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xa5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xb4, 0x0, 0x0, 0x0, 0x0, 0x17, 0xdf, 0xff,
    0xfd, 0x30, 0x0, 0x0, 0x0, 0x0, 0x27, 0xdf,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xfe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xf6, 0xce, 0xb0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0x8b, 0xff, 0x10, 0x0, 0x0, 0x0, 0x3f, 0xf7,
    0x4f, 0xfb, 0x0, 0x0, 0x0, 0xa, 0xff, 0x30,
    0x9f, 0xfe, 0x74, 0x23, 0x6c, 0xff, 0xb0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x17, 0xce, 0xff, 0xd9, 0x30, 0x0,

    /* U+54 "T" */
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x15, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x2, 0x22, 0x22, 0x2f, 0xfb, 0x22, 0x22,
    0x22, 0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0,
    0x0, 0x0,

    /* U+55 "U" */
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf5,
    0xf, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf4,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf3,
    0xc, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0,
    0x6, 0xff, 0x90, 0x0, 0x0, 0x5, 0xff, 0x90,
    0x0, 0xcf, 0xfb, 0x52, 0x24, 0xaf, 0xfd, 0x10,
    0x0, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0,
    0x0, 0x0, 0x4a, 0xdf, 0xfe, 0xa5, 0x0, 0x0,

    /* U+56 "V" */
    0x6f, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xf4, 0x1f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xe0, 0xb, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x4, 0xff, 0x80, 0x5, 0xff, 0x70, 0x0, 0x0,
    0x0, 0xa, 0xff, 0x20, 0x0, 0xef, 0xc0, 0x0,
    0x0, 0x0, 0xf, 0xfc, 0x0, 0x0, 0x9f, 0xf2,
    0x0, 0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0x3f,
    0xf7, 0x0, 0x0, 0x0, 0xaf, 0xf1, 0x0, 0x0,
    0xd, 0xfd, 0x0, 0x0, 0x0, 0xff, 0xa0, 0x0,
    0x0, 0x7, 0xff, 0x20, 0x0, 0x5, 0xff, 0x50,
    0x0, 0x0, 0x1, 0xff, 0x80, 0x0, 0xb, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xd0, 0x0, 0x1f,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf3, 0x0,
    0x6f, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf9,
    0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xfe, 0x1, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0x47, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x9c, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x40, 0x0, 0x0, 0x0,

    /* U+57 "W" */
    0xf, 0xf9, 0x0, 0x0, 0x0, 0xa, 0xfd, 0x0,
    0x0, 0x0, 0x8, 0xff, 0x10, 0xdf, 0xc0, 0x0,
    0x0, 0x0, 0xef, 0xf1, 0x0, 0x0, 0x0, 0xbf,
    0xd0, 0x9, 0xff, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x60, 0x0, 0x0, 0xf, 0xfa, 0x0, 0x5f, 0xf4,
    0x0, 0x0, 0x8, 0xff, 0xfa, 0x0, 0x0, 0x2,
    0xff, 0x60, 0x1, 0xff, 0x70, 0x0, 0x0, 0xcf,
    0xcf, 0xe0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0xd,
    0xfb, 0x0, 0x0, 0x1f, 0xf5, 0xff, 0x30, 0x0,
    0xa, 0xfe, 0x0, 0x0, 0x9f, 0xf0, 0x0, 0x5,
    0xff, 0xc, 0xf7, 0x0, 0x0, 0xdf, 0xa0, 0x0,
    0x5, 0xff, 0x20, 0x0, 0xaf, 0xb0, 0x7f, 0xc0,
    0x0, 0x1f, 0xf6, 0x0, 0x0, 0x2f, 0xf6, 0x0,
    0xe, 0xf6, 0x3, 0xff, 0x0, 0x5, 0xff, 0x30,
    0x0, 0x0, 0xef, 0xa0, 0x3, 0xff, 0x10, 0xe,
    0xf5, 0x0, 0x8f, 0xf0, 0x0, 0x0, 0xa, 0xfd,
    0x0, 0x7f, 0xd0, 0x0, 0xaf, 0x90, 0xc, 0xfb,
    0x0, 0x0, 0x0, 0x6f, 0xf1, 0xc, 0xf8, 0x0,
    0x5, 0xfd, 0x0, 0xff, 0x70, 0x0, 0x0, 0x2,
    0xff, 0x50, 0xff, 0x30, 0x0, 0x1f, 0xf2, 0x3f,
    0xf3, 0x0, 0x0, 0x0, 0xe, 0xf8, 0x5f, 0xe0,
    0x0, 0x0, 0xdf, 0x67, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xb9, 0xfa, 0x0, 0x0, 0x8, 0xfa,
    0x9f, 0xb0, 0x0, 0x0, 0x0, 0x7, 0xfd, 0xdf,
    0x50, 0x0, 0x0, 0x4f, 0xec, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xf1, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0xb, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x6f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf3, 0x0, 0x0, 0x0, 0x2, 0xff, 0x80,
    0x0, 0x0,

    /* U+58 "X" */
    0xb, 0xff, 0x50, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x50, 0x2f, 0xfe, 0x0, 0x0, 0x0, 0x5, 0xff,
    0xb0, 0x0, 0x7f, 0xf9, 0x0, 0x0, 0x1, 0xef,
    0xf2, 0x0, 0x0, 0xdf, 0xf3, 0x0, 0x0, 0x9f,
    0xf7, 0x0, 0x0, 0x3, 0xff, 0xd0, 0x0, 0x3f,
    0xfc, 0x0, 0x0, 0x0, 0x9, 0xff, 0x70, 0xd,
    0xff, 0x30, 0x0, 0x0, 0x0, 0xe, 0xff, 0x27,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xfc,
    0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xae, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xe1, 0x6f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xf5, 0x0, 0xbf, 0xf4, 0x0, 0x0,
    0x0, 0x5f, 0xfb, 0x0, 0x2, 0xff, 0xe0, 0x0,
    0x0, 0x1e, 0xff, 0x20, 0x0, 0x7, 0xff, 0x90,
    0x0, 0x9, 0xff, 0x70, 0x0, 0x0, 0xd, 0xff,
    0x30, 0x4, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x3f,
    0xfd, 0x0, 0xdf, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xf7,

    /* U+59 "Y" */
    0x8f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0x40, 0xef, 0xe0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xb0, 0x6, 0xff, 0x80, 0x0, 0x0, 0x0, 0xbf,
    0xf3, 0x0, 0xd, 0xff, 0x10, 0x0, 0x0, 0x4f,
    0xfa, 0x0, 0x0, 0x5f, 0xf8, 0x0, 0x0, 0xc,
    0xff, 0x10, 0x0, 0x0, 0xcf, 0xf1, 0x0, 0x4,
    0xff, 0x80, 0x0, 0x0, 0x3, 0xff, 0x90, 0x0,
    0xdf, 0xe1, 0x0, 0x0, 0x0, 0xb, 0xff, 0x10,
    0x5f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf9,
    0xd, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xf8, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xb0, 0x0,
    0x0, 0x0,

    /* U+5A "Z" */
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x12,
    0x22, 0x22, 0x22, 0x22, 0x5f, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xfe,
    0x10, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xef, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xa2, 0x22, 0x22, 0x22, 0x22, 0x21, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xad, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,

    /* U+5B "[" */
    0xff, 0xff, 0xf2, 0xff, 0xff, 0xf2, 0xff, 0x91,
    0x10, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0, 0xff,
    0x80, 0x0, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0,
    0xff, 0x80, 0x0, 0xff, 0x80, 0x0, 0xff, 0x80,
    0x0, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0, 0xff,
    0x80, 0x0, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0,
    0xff, 0x80, 0x0, 0xff, 0x80, 0x0, 0xff, 0x80,
    0x0, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0, 0xff,
    0x80, 0x0, 0xff, 0x80, 0x0, 0xff, 0x80, 0x0,
    0xff, 0x91, 0x10, 0xff, 0xff, 0xf2, 0xff, 0xff,
    0xf2,

    /* U+5C "\\" */
    0x4f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xef, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x18, 0x81,

    /* U+5D "]" */
    0xef, 0xff, 0xf4, 0xef, 0xff, 0xf4, 0x1, 0x4f,
    0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0,
    0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4,
    0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f,
    0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0,
    0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4,
    0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f,
    0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0,
    0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4,
    0x11, 0x4f, 0xf4, 0xef, 0xff, 0xf4, 0xef, 0xff,
    0xf4,

    /* U+5E "^" */
    0x0, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0x50, 0x0, 0x0, 0x1, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x7f, 0xef, 0xf2, 0x0, 0x0, 0xd,
    0xf6, 0xcf, 0x80, 0x0, 0x4, 0xff, 0x5, 0xfe,
    0x0, 0x0, 0xbf, 0x90, 0xe, 0xf5, 0x0, 0x1f,
    0xf3, 0x0, 0x8f, 0xc0, 0x8, 0xfd, 0x0, 0x2,
    0xff, 0x20, 0xef, 0x60, 0x0, 0xc, 0xf9,

    /* U+5F "_" */
    0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x90,

    /* U+60 "`" */
    0xc, 0xff, 0x20, 0x0, 0x1d, 0xfc, 0x0, 0x0,
    0x1e, 0xf7, 0x0, 0x0, 0x2f, 0xf2,

    /* U+61 "a" */
    0x0, 0x4, 0xae, 0xff, 0xc7, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x9, 0xff, 0x93,
    0x12, 0x9f, 0xf9, 0x1, 0xff, 0x90, 0x0, 0x0,
    0xbf, 0xf0, 0x5, 0x51, 0x0, 0x0, 0x6, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf3, 0x0,
    0x6, 0xbe, 0xff, 0xff, 0xff, 0x30, 0x2d, 0xff,
    0xfe, 0xcc, 0xdf, 0xf3, 0xd, 0xfe, 0x50, 0x0,
    0x5, 0xff, 0x35, 0xff, 0x30, 0x0, 0x0, 0x5f,
    0xf3, 0x7f, 0xf0, 0x0, 0x0, 0x6, 0xff, 0x36,
    0xff, 0x50, 0x0, 0x1, 0xdf, 0xf3, 0x1f, 0xff,
    0x73, 0x48, 0xef, 0xff, 0x40, 0x6f, 0xff, 0xff,
    0xff, 0x9f, 0xf6, 0x0, 0x3a, 0xef, 0xe9, 0x20,
    0xbb, 0x70,

    /* U+62 "b" */
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf7, 0x19, 0xef, 0xea, 0x30,
    0x0, 0x1f, 0xfa, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x1f, 0xff, 0xe7, 0x33, 0x6e, 0xff, 0x30, 0x1f,
    0xfe, 0x20, 0x0, 0x2, 0xff, 0xb0, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x9f, 0xf1, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x4f, 0xf4, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0x2f, 0xf6, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0x1f, 0xf6, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x2f,
    0xf6, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x4f, 0xf4,
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0xaf, 0xf1, 0x1f,
    0xfe, 0x20, 0x0, 0x2, 0xff, 0xb0, 0x1f, 0xff,
    0xe7, 0x32, 0x6e, 0xff, 0x30, 0x1f, 0xf9, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0x1f, 0xf4, 0x29, 0xef,
    0xea, 0x30, 0x0,

    /* U+63 "c" */
    0x0, 0x2, 0x9d, 0xff, 0xc7, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x5, 0xff, 0xc4,
    0x12, 0x8f, 0xfc, 0x0, 0xef, 0xc0, 0x0, 0x0,
    0x5f, 0xf5, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0xdf,
    0x99, 0xff, 0x0, 0x0, 0x0, 0x2, 0x42, 0xbf,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0xad, 0x80,
    0xef, 0xc0, 0x0, 0x0, 0x3f, 0xf6, 0x5, 0xff,
    0xc4, 0x12, 0x7f, 0xfd, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xfd, 0x10, 0x0, 0x2, 0x9d, 0xff, 0xc6,
    0x0, 0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xfc, 0x0,
    0x4, 0xbe, 0xfd, 0x80, 0xcf, 0xc0, 0x8, 0xff,
    0xff, 0xff, 0xdd, 0xfc, 0x6, 0xff, 0xd5, 0x23,
    0x8f, 0xff, 0xc0, 0xef, 0xd1, 0x0, 0x0, 0x4f,
    0xfc, 0x4f, 0xf6, 0x0, 0x0, 0x0, 0xcf, 0xc8,
    0xff, 0x0, 0x0, 0x0, 0xc, 0xfc, 0xaf, 0xe0,
    0x0, 0x0, 0x0, 0xcf, 0xcb, 0xfd, 0x0, 0x0,
    0x0, 0xc, 0xfc, 0xaf, 0xe0, 0x0, 0x0, 0x0,
    0xcf, 0xc8, 0xff, 0x0, 0x0, 0x0, 0xc, 0xfc,
    0x4f, 0xf6, 0x0, 0x0, 0x0, 0xcf, 0xc0, 0xef,
    0xd0, 0x0, 0x0, 0x4f, 0xfc, 0x5, 0xff, 0xd5,
    0x23, 0x8f, 0xff, 0xc0, 0x8, 0xff, 0xff, 0xff,
    0xec, 0xfc, 0x0, 0x4, 0xbe, 0xfd, 0x81, 0x9f,
    0xc0,

    /* U+65 "e" */
    0x0, 0x1, 0x8d, 0xfe, 0xc6, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xfc, 0x10, 0x3, 0xff, 0xd4,
    0x12, 0x8f, 0xfa, 0x0, 0xcf, 0xd0, 0x0, 0x0,
    0x7f, 0xf3, 0x3f, 0xf4, 0x0, 0x0, 0x0, 0xff,
    0x88, 0xff, 0x0, 0x0, 0x0, 0xc, 0xfb, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xcb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0xbf, 0xd1, 0x11, 0x11,
    0x11, 0x11, 0x19, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xe1, 0x0, 0x0, 0x6, 0xb1, 0x4, 0xff,
    0xe6, 0x11, 0x3a, 0xff, 0x50, 0x5, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x1, 0x8d, 0xff, 0xd9,
    0x20, 0x0,

    /* U+66 "f" */
    0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x19,
    0xff, 0xfb, 0x0, 0x0, 0xdf, 0xff, 0xfa, 0x0,
    0x7, 0xff, 0x91, 0x0, 0x0, 0xb, 0xfe, 0x0,
    0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0x0, 0xd,
    0xfb, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xd0,
    0x2f, 0xff, 0xff, 0xff, 0xc0, 0x0, 0xd, 0xfb,
    0x0, 0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0x0,
    0xd, 0xfb, 0x0, 0x0, 0x0, 0xd, 0xfb, 0x0,
    0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0x0, 0xd,
    0xfb, 0x0, 0x0, 0x0, 0xd, 0xfb, 0x0, 0x0,
    0x0, 0xd, 0xfb, 0x0, 0x0, 0x0, 0xd, 0xfb,
    0x0, 0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0x0,
    0xd, 0xfb, 0x0, 0x0, 0x0, 0xd, 0xfb, 0x0,
    0x0, 0x0, 0xd, 0xfb, 0x0, 0x0,

    /* U+67 "g" */
    0x0, 0x5, 0xbe, 0xfd, 0x80, 0x8f, 0xd0, 0x9,
    0xff, 0xff, 0xff, 0xdb, 0xfd, 0x6, 0xff, 0xd5,
    0x23, 0x8f, 0xff, 0xd0, 0xef, 0xe1, 0x0, 0x0,
    0x4f, 0xfd, 0x4f, 0xf7, 0x0, 0x0, 0x0, 0xbf,
    0xd8, 0xff, 0x10, 0x0, 0x0, 0xb, 0xfd, 0xaf,
    0xf0, 0x0, 0x0, 0x0, 0xbf, 0xda, 0xfd, 0x0,
    0x0, 0x0, 0xb, 0xfd, 0xaf, 0xf0, 0x0, 0x0,
    0x0, 0xbf, 0xd8, 0xff, 0x10, 0x0, 0x0, 0xb,
    0xfd, 0x4f, 0xf6, 0x0, 0x0, 0x0, 0xcf, 0xd0,
    0xef, 0xd1, 0x0, 0x0, 0x4f, 0xfd, 0x5, 0xff,
    0xd5, 0x23, 0x8f, 0xff, 0xd0, 0x8, 0xff, 0xff,
    0xff, 0xdd, 0xfd, 0x0, 0x4, 0xbe, 0xfd, 0x81,
    0xbf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xfb,
    0x0, 0x10, 0x0, 0x0, 0x1, 0xff, 0x90, 0x4e,
    0x20, 0x0, 0x0, 0x9f, 0xf4, 0xb, 0xff, 0x72,
    0x13, 0xaf, 0xfb, 0x0, 0x1c, 0xff, 0xff, 0xff,
    0xfc, 0x10, 0x0, 0x5, 0xae, 0xfe, 0xb6, 0x0,
    0x0,

    /* U+68 "h" */
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf7, 0x7, 0xdf, 0xfc, 0x50, 0x1, 0xff, 0x8d,
    0xff, 0xff, 0xff, 0x70, 0x1f, 0xff, 0xf8, 0x33,
    0x7f, 0xff, 0x11, 0xff, 0xf3, 0x0, 0x0, 0x6f,
    0xf5, 0x1f, 0xf8, 0x0, 0x0, 0x1, 0xff, 0x71,
    0xff, 0x70, 0x0, 0x0, 0xf, 0xf8, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0xff, 0x81, 0xff, 0x70, 0x0,
    0x0, 0xf, 0xf8, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0xff, 0x81, 0xff, 0x70, 0x0, 0x0, 0xf, 0xf8,
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff, 0x81, 0xff,
    0x70, 0x0, 0x0, 0xf, 0xf8, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0xff, 0x81, 0xff, 0x70, 0x0, 0x0,
    0xf, 0xf8, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff,
    0x80,

    /* U+69 "i" */
    0xa, 0xf8, 0xf, 0xfe, 0x8, 0xd6, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa,
    0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa,
    0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa,
    0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa, 0xd, 0xfa,

    /* U+6A "j" */
    0x0, 0xc, 0xf5, 0x0, 0x3f, 0xfa, 0x0, 0xb,
    0xd4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8,
    0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf,
    0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0,
    0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8,
    0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf,
    0xf8, 0x0, 0xf, 0xf8, 0x0, 0xf, 0xf8, 0x0,
    0xf, 0xf8, 0x0, 0x1f, 0xf6, 0x23, 0xaf, 0xf4,
    0xef, 0xff, 0xc0, 0xcf, 0xea, 0x10,

    /* U+6B "k" */
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x2e, 0xfe,
    0x20, 0x1f, 0xf7, 0x0, 0x1, 0xdf, 0xe2, 0x0,
    0x1f, 0xf7, 0x0, 0x1d, 0xff, 0x30, 0x0, 0x1f,
    0xf7, 0x0, 0xcf, 0xf4, 0x0, 0x0, 0x1f, 0xf7,
    0xc, 0xff, 0x50, 0x0, 0x0, 0x1f, 0xf7, 0xaf,
    0xf7, 0x0, 0x0, 0x0, 0x1f, 0xfd, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xaa, 0xff, 0x60, 0x0,
    0x0, 0x1f, 0xfb, 0x0, 0xdf, 0xf2, 0x0, 0x0,
    0x1f, 0xf7, 0x0, 0x2f, 0xfd, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x6, 0xff, 0x90, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0xaf, 0xf5, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0xd, 0xfe, 0x20, 0x1f, 0xf7, 0x0, 0x0,
    0x3, 0xff, 0xc0,

    /* U+6C "l" */
    0xdf, 0xad, 0xfa, 0xdf, 0xad, 0xfa, 0xdf, 0xad,
    0xfa, 0xdf, 0xad, 0xfa, 0xdf, 0xad, 0xfa, 0xdf,
    0xad, 0xfa, 0xdf, 0xad, 0xfa, 0xdf, 0xad, 0xfa,
    0xdf, 0xad, 0xfa, 0xdf, 0xad, 0xfa, 0xdf, 0xa0,

    /* U+6D "m" */
    0x1f, 0xf5, 0x19, 0xdf, 0xeb, 0x40, 0x1, 0x9d,
    0xff, 0xc5, 0x0, 0x1f, 0xf9, 0xff, 0xff, 0xff,
    0xf5, 0x4f, 0xff, 0xff, 0xff, 0x80, 0x1f, 0xff,
    0xd5, 0x23, 0x8f, 0xff, 0xff, 0x73, 0x36, 0xef,
    0xf2, 0x1f, 0xfd, 0x0, 0x0, 0x7, 0xff, 0xf3,
    0x0, 0x0, 0x4f, 0xf7, 0x1f, 0xf7, 0x0, 0x0,
    0x2, 0xff, 0xb0, 0x0, 0x0, 0xf, 0xf9, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0xff, 0x80, 0x0, 0x0,
    0xe, 0xfa, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff,
    0x80, 0x0, 0x0, 0xe, 0xfa, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0xff, 0x80, 0x0, 0x0, 0xe, 0xfa,
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff, 0x80, 0x0,
    0x0, 0xe, 0xfa, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0xff, 0x80, 0x0, 0x0, 0xe, 0xfa, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0xff, 0x80, 0x0, 0x0, 0xe,
    0xfa, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff, 0x80,
    0x0, 0x0, 0xe, 0xfa, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0xff, 0x80, 0x0, 0x0, 0xe, 0xfa, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0xff, 0x80, 0x0, 0x0,
    0xe, 0xfa, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff,
    0x80, 0x0, 0x0, 0xe, 0xfa,

    /* U+6E "n" */
    0x1f, 0xf5, 0x7, 0xdf, 0xfc, 0x50, 0x1, 0xff,
    0x7d, 0xff, 0xff, 0xff, 0x70, 0x1f, 0xff, 0xf8,
    0x33, 0x7f, 0xff, 0x11, 0xff, 0xf3, 0x0, 0x0,
    0x6f, 0xf5, 0x1f, 0xf8, 0x0, 0x0, 0x1, 0xff,
    0x71, 0xff, 0x70, 0x0, 0x0, 0xf, 0xf8, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0xff, 0x81, 0xff, 0x70,
    0x0, 0x0, 0xf, 0xf8, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0xff, 0x81, 0xff, 0x70, 0x0, 0x0, 0xf,
    0xf8, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff, 0x81,
    0xff, 0x70, 0x0, 0x0, 0xf, 0xf8, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0xff, 0x81, 0xff, 0x70, 0x0,
    0x0, 0xf, 0xf8, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0xff, 0x80,

    /* U+6F "o" */
    0x0, 0x1, 0x8d, 0xff, 0xd8, 0x10, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xe4, 0x0, 0x3, 0xff,
    0xe5, 0x11, 0x6e, 0xff, 0x30, 0xd, 0xfe, 0x10,
    0x0, 0x2, 0xef, 0xd0, 0x4f, 0xf6, 0x0, 0x0,
    0x0, 0x6f, 0xf3, 0x8f, 0xf0, 0x0, 0x0, 0x0,
    0x1f, 0xf8, 0xaf, 0xd0, 0x0, 0x0, 0x0, 0xe,
    0xfa, 0xbf, 0xc0, 0x0, 0x0, 0x0, 0xd, 0xfb,
    0xbf, 0xd0, 0x0, 0x0, 0x0, 0xd, 0xfa, 0x8f,
    0xf0, 0x0, 0x0, 0x0, 0xf, 0xf8, 0x4f, 0xf6,
    0x0, 0x0, 0x0, 0x6f, 0xf4, 0xd, 0xfe, 0x10,
    0x0, 0x1, 0xef, 0xd0, 0x3, 0xff, 0xd5, 0x11,
    0x5e, 0xff, 0x30, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x1, 0x8d, 0xff, 0xd8, 0x10,
    0x0,

    /* U+70 "p" */
    0x1f, 0xf4, 0x29, 0xef, 0xea, 0x30, 0x0, 0x1f,
    0xf9, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x1f, 0xff,
    0xd6, 0x33, 0x8f, 0xff, 0x30, 0x1f, 0xfd, 0x10,
    0x0, 0x4, 0xff, 0xb0, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0xaf, 0xf0, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0x5f, 0xf3, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x3f,
    0xf5, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x2f, 0xf6,
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x3f, 0xf5, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0x5f, 0xf3, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0xaf, 0xf0, 0x1f, 0xfc, 0x0,
    0x0, 0x3, 0xff, 0xa0, 0x1f, 0xff, 0xc4, 0x11,
    0x6f, 0xff, 0x20, 0x1f, 0xfc, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x1f, 0xf7, 0x2a, 0xef, 0xea, 0x30,
    0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x5, 0xbe, 0xfd, 0x81, 0x9f, 0xc0, 0x9,
    0xff, 0xff, 0xff, 0xec, 0xfc, 0x7, 0xff, 0xd5,
    0x12, 0x7f, 0xff, 0xc0, 0xef, 0xd1, 0x0, 0x0,
    0x3f, 0xfc, 0x5f, 0xf6, 0x0, 0x0, 0x0, 0xcf,
    0xc8, 0xff, 0x10, 0x0, 0x0, 0xc, 0xfc, 0xaf,
    0xe0, 0x0, 0x0, 0x0, 0xcf, 0xcb, 0xfd, 0x0,
    0x0, 0x0, 0xc, 0xfc, 0xaf, 0xe0, 0x0, 0x0,
    0x0, 0xcf, 0xc8, 0xff, 0x0, 0x0, 0x0, 0xc,
    0xfc, 0x4f, 0xf6, 0x0, 0x0, 0x0, 0xcf, 0xc0,
    0xef, 0xd0, 0x0, 0x0, 0x3f, 0xfc, 0x6, 0xff,
    0xd4, 0x12, 0x6f, 0xff, 0xc0, 0x9, 0xff, 0xff,
    0xff, 0xee, 0xfc, 0x0, 0x5, 0xbe, 0xfd, 0x81,
    0xcf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xc0,

    /* U+72 "r" */
    0x1f, 0xf6, 0x3b, 0xfe, 0x1, 0xff, 0xaf, 0xff,
    0xf1, 0x1f, 0xff, 0xfa, 0x77, 0x1, 0xff, 0xf3,
    0x0, 0x0, 0x1f, 0xf8, 0x0, 0x0, 0x1, 0xff,
    0x70, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0, 0x1,
    0xff, 0x70, 0x0, 0x0, 0x1f, 0xf7, 0x0, 0x0,
    0x1, 0xff, 0x70, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x1, 0xff, 0x70, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x1, 0xff, 0x70, 0x0, 0x0, 0x1f,
    0xf7, 0x0, 0x0, 0x0,

    /* U+73 "s" */
    0x0, 0x7, 0xcf, 0xfe, 0xa4, 0x0, 0x0, 0x1d,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0xb, 0xff, 0x72,
    0x14, 0xdf, 0xf5, 0x1, 0xff, 0x80, 0x0, 0x1,
    0xef, 0xc0, 0x2f, 0xf6, 0x0, 0x0, 0x5, 0x87,
    0x0, 0xef, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xfe, 0xa6, 0x10, 0x0, 0x0, 0x2, 0x9e,
    0xff, 0xff, 0xb2, 0x0, 0x0, 0x0, 0x3, 0x7b,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x3, 0xef,
    0xd0, 0x7b, 0xa0, 0x0, 0x0, 0x8, 0xff, 0x7,
    0xff, 0x30, 0x0, 0x0, 0xaf, 0xf0, 0x1e, 0xff,
    0x72, 0x13, 0x9f, 0xf9, 0x0, 0x3e, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x17, 0xcf, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+74 "t" */
    0x0, 0x18, 0x82, 0x0, 0x0, 0x3, 0xff, 0x50,
    0x0, 0x0, 0x3f, 0xf5, 0x0, 0x0, 0x3, 0xff,
    0x50, 0x0, 0xef, 0xff, 0xff, 0xff, 0x1d, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x3f, 0xf5, 0x0, 0x0,
    0x3, 0xff, 0x50, 0x0, 0x0, 0x3f, 0xf5, 0x0,
    0x0, 0x3, 0xff, 0x50, 0x0, 0x0, 0x3f, 0xf5,
    0x0, 0x0, 0x3, 0xff, 0x50, 0x0, 0x0, 0x3f,
    0xf5, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0, 0x0,
    0x3f, 0xf5, 0x0, 0x0, 0x2, 0xff, 0x60, 0x0,
    0x0, 0xf, 0xfc, 0x33, 0x0, 0x0, 0xaf, 0xff,
    0xf2, 0x0, 0x0, 0x9e, 0xfd, 0x20,

    /* U+75 "u" */
    0x2f, 0xf6, 0x0, 0x0, 0x0, 0xff, 0x82, 0xff,
    0x60, 0x0, 0x0, 0xf, 0xf8, 0x2f, 0xf6, 0x0,
    0x0, 0x0, 0xff, 0x82, 0xff, 0x60, 0x0, 0x0,
    0xf, 0xf8, 0x2f, 0xf6, 0x0, 0x0, 0x0, 0xff,
    0x82, 0xff, 0x60, 0x0, 0x0, 0xf, 0xf8, 0x2f,
    0xf6, 0x0, 0x0, 0x0, 0xff, 0x82, 0xff, 0x60,
    0x0, 0x0, 0xf, 0xf8, 0x2f, 0xf6, 0x0, 0x0,
    0x0, 0xff, 0x82, 0xff, 0x60, 0x0, 0x0, 0xf,
    0xf8, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0xff, 0x80,
    0xef, 0xc0, 0x0, 0x0, 0x8f, 0xf8, 0x9, 0xff,
    0xa3, 0x24, 0xbf, 0xff, 0x80, 0x1e, 0xff, 0xff,
    0xff, 0xcf, 0xf8, 0x0, 0x19, 0xef, 0xfc, 0x60,
    0xef, 0x80,

    /* U+76 "v" */
    0x5f, 0xf3, 0x0, 0x0, 0x0, 0xbf, 0xd0, 0xf,
    0xf8, 0x0, 0x0, 0x0, 0xff, 0x80, 0xa, 0xfd,
    0x0, 0x0, 0x5, 0xff, 0x20, 0x4, 0xff, 0x30,
    0x0, 0xa, 0xfc, 0x0, 0x0, 0xef, 0x80, 0x0,
    0xf, 0xf7, 0x0, 0x0, 0x9f, 0xd0, 0x0, 0x5f,
    0xf1, 0x0, 0x0, 0x3f, 0xf3, 0x0, 0xaf, 0xb0,
    0x0, 0x0, 0xd, 0xf8, 0x0, 0xff, 0x60, 0x0,
    0x0, 0x8, 0xfd, 0x4, 0xff, 0x10, 0x0, 0x0,
    0x2, 0xff, 0x39, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x8e, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x0, 0x0,
    0x0,

    /* U+77 "w" */
    0x4f, 0xf3, 0x0, 0x0, 0xa, 0xfa, 0x0, 0x0,
    0x4, 0xff, 0x30, 0xff, 0x70, 0x0, 0x0, 0xff,
    0xf0, 0x0, 0x0, 0x8f, 0xf0, 0xb, 0xfc, 0x0,
    0x0, 0x4f, 0xff, 0x40, 0x0, 0xc, 0xfa, 0x0,
    0x6f, 0xf0, 0x0, 0x9, 0xff, 0xf9, 0x0, 0x0,
    0xff, 0x60, 0x1, 0xff, 0x40, 0x0, 0xef, 0x7f,
    0xe0, 0x0, 0x4f, 0xf1, 0x0, 0xd, 0xf8, 0x0,
    0x3f, 0xd0, 0xff, 0x30, 0x8, 0xfc, 0x0, 0x0,
    0x8f, 0xc0, 0x8, 0xf8, 0xa, 0xf8, 0x0, 0xcf,
    0x80, 0x0, 0x4, 0xff, 0x0, 0xdf, 0x30, 0x5f,
    0xd0, 0xf, 0xf3, 0x0, 0x0, 0xf, 0xf4, 0x2f,
    0xe0, 0x0, 0xff, 0x24, 0xfe, 0x0, 0x0, 0x0,
    0xbf, 0x97, 0xfa, 0x0, 0xb, 0xf7, 0x8f, 0xa0,
    0x0, 0x0, 0x6, 0xfd, 0xcf, 0x50, 0x0, 0x6f,
    0xcc, 0xf5, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xf0,
    0x0, 0x1, 0xff, 0xff, 0x10, 0x0, 0x0, 0x0,
    0xdf, 0xfb, 0x0, 0x0, 0xc, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0x60, 0x0, 0x0, 0x7f,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf1, 0x0,
    0x0, 0x2, 0xff, 0x30, 0x0, 0x0,

    /* U+78 "x" */
    0xe, 0xfe, 0x0, 0x0, 0x2, 0xff, 0xc0, 0x4,
    0xff, 0x80, 0x0, 0xc, 0xff, 0x20, 0x0, 0xaf,
    0xf2, 0x0, 0x5f, 0xf7, 0x0, 0x0, 0x1e, 0xfb,
    0x1, 0xef, 0xc0, 0x0, 0x0, 0x5, 0xff, 0x59,
    0xff, 0x30, 0x0, 0x0, 0x0, 0xbf, 0xef, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xe1, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xde, 0xfa, 0x0, 0x0, 0x0, 0x7,
    0xff, 0x36, 0xff, 0x40, 0x0, 0x0, 0x2f, 0xfa,
    0x0, 0xcf, 0xe0, 0x0, 0x0, 0xcf, 0xe1, 0x0,
    0x3f, 0xf9, 0x0, 0x7, 0xff, 0x60, 0x0, 0x9,
    0xff, 0x40, 0x2f, 0xfc, 0x0, 0x0, 0x0, 0xef,
    0xe0,

    /* U+79 "y" */
    0x8f, 0xf3, 0x0, 0x0, 0x0, 0xef, 0xb2, 0xff,
    0x80, 0x0, 0x0, 0x4f, 0xf6, 0xd, 0xfe, 0x0,
    0x0, 0x9, 0xff, 0x10, 0x7f, 0xf3, 0x0, 0x0,
    0xef, 0xb0, 0x1, 0xff, 0x90, 0x0, 0x3f, 0xf5,
    0x0, 0xb, 0xfe, 0x0, 0x8, 0xff, 0x0, 0x0,
    0x6f, 0xf3, 0x0, 0xdf, 0xa0, 0x0, 0x0, 0xff,
    0x90, 0x2f, 0xf5, 0x0, 0x0, 0xa, 0xfe, 0x7,
    0xff, 0x0, 0x0, 0x0, 0x5f, 0xf3, 0xcf, 0xa0,
    0x0, 0x0, 0x0, 0xef, 0xaf, 0xf4, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xfd, 0x0, 0x0, 0x0, 0x3, 0x49, 0xff,
    0x50, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0xb, 0xfe, 0x70, 0x0, 0x0, 0x0,
    0x0,

    /* U+7A "z" */
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x1, 0x11, 0x11, 0x12,
    0xef, 0xe1, 0x0, 0x0, 0x0, 0xa, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x6f, 0xf8, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xc0, 0x0, 0x0, 0x0, 0xd, 0xfe,
    0x10, 0x0, 0x0, 0x0, 0xaf, 0xf4, 0x0, 0x0,
    0x0, 0x6, 0xff, 0x90, 0x0, 0x0, 0x0, 0x2f,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xf2, 0x0,
    0x0, 0x0, 0x9, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x5f, 0xfa, 0x11, 0x11, 0x11, 0x10, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff,

    /* U+7B "{" */
    0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0,
    0x6e, 0xe0, 0x0, 0x0, 0x9, 0xff, 0x90, 0x0,
    0x0, 0x6f, 0xf5, 0x0, 0x0, 0x0, 0xdf, 0xc0,
    0x0, 0x0, 0x0, 0xff, 0x70, 0x0, 0x0, 0x2,
    0xff, 0x50, 0x0, 0x0, 0x3, 0xff, 0x40, 0x0,
    0x0, 0x3, 0xff, 0x40, 0x0, 0x0, 0x3, 0xff,
    0x40, 0x0, 0x0, 0x4, 0xff, 0x30, 0x0, 0x0,
    0x9, 0xff, 0x0, 0x0, 0x1, 0x6f, 0xf9, 0x0,
    0x0, 0x1f, 0xff, 0xa0, 0x0, 0x0, 0x2f, 0xff,
    0xa0, 0x0, 0x0, 0x1, 0x7f, 0xf8, 0x0, 0x0,
    0x0, 0x9, 0xff, 0x0, 0x0, 0x0, 0x5, 0xff,
    0x30, 0x0, 0x0, 0x3, 0xff, 0x40, 0x0, 0x0,
    0x3, 0xff, 0x40, 0x0, 0x0, 0x3, 0xff, 0x40,
    0x0, 0x0, 0x2, 0xff, 0x50, 0x0, 0x0, 0x0,
    0xff, 0x70, 0x0, 0x0, 0x0, 0xdf, 0xb0, 0x0,
    0x0, 0x0, 0x6f, 0xf5, 0x0, 0x0, 0x0, 0xa,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x6e, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x30,

    /* U+7C "|" */
    0x9f, 0x79, 0xf7, 0x9f, 0x79, 0xf7, 0x9f, 0x79,
    0xf7, 0x9f, 0x79, 0xf7, 0x9f, 0x79, 0xf7, 0x9f,
    0x79, 0xf7, 0x9f, 0x79, 0xf7, 0x9f, 0x79, 0xf7,
    0x9f, 0x79, 0xf7, 0x9f, 0x79, 0xf7, 0x9f, 0x79,
    0xf7, 0x9f, 0x74, 0x83,

    /* U+7D "}" */
    0x11, 0x0, 0x0, 0x0, 0x7, 0xfa, 0x10, 0x0,
    0x0, 0x4d, 0xfe, 0x20, 0x0, 0x0, 0x1d, 0xfd,
    0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0,
    0xff, 0x70, 0x0, 0x0, 0xe, 0xf9, 0x0, 0x0,
    0x0, 0xef, 0xa0, 0x0, 0x0, 0xe, 0xfa, 0x0,
    0x0, 0x0, 0xdf, 0xa0, 0x0, 0x0, 0xc, 0xfb,
    0x0, 0x0, 0x0, 0x9f, 0xe0, 0x0, 0x0, 0x2,
    0xff, 0xb2, 0x0, 0x0, 0x4, 0xef, 0xf8, 0x0,
    0x0, 0x3d, 0xff, 0x90, 0x0, 0x2f, 0xfc, 0x30,
    0x0, 0x9, 0xff, 0x10, 0x0, 0x0, 0xcf, 0xb0,
    0x0, 0x0, 0xd, 0xfa, 0x0, 0x0, 0x0, 0xef,
    0xa0, 0x0, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x0,
    0xef, 0x90, 0x0, 0x0, 0xf, 0xf7, 0x0, 0x0,
    0x5, 0xff, 0x40, 0x0, 0x0, 0xdf, 0xd0, 0x0,
    0x4, 0xdf, 0xe2, 0x0, 0x0, 0x8f, 0xb1, 0x0,
    0x0, 0x1, 0x20, 0x0, 0x0, 0x0,

    /* U+7E "~" */
    0x0, 0x0, 0x22, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xdf, 0xff, 0xa1, 0x0, 0x0, 0xc,
    0xd3, 0x3, 0xff, 0xff, 0xff, 0xe4, 0x0, 0x2,
    0xff, 0x10, 0xcf, 0xc2, 0x6, 0xef, 0xf9, 0x45,
    0xdf, 0xb0, 0x1f, 0xf2, 0x0, 0x1, 0xcf, 0xff,
    0xff, 0xe2, 0x1, 0x88, 0x0, 0x0, 0x0, 0x6c,
    0xfe, 0xa1, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x38, 0xdf, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x15, 0xae, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x49, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x16, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe9, 0xbf, 0xff, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x73, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xfe, 0xa5, 0x10, 0x0, 0x0,
    0x8f, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xd8, 0x30, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xa2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0x0, 0xf, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x0, 0x0, 0xf, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0x0, 0xf, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x1, 0x7a, 0xcb,
    0xcf, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xf, 0xff, 0x80, 0x0, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x1,
    0x33, 0x2f, 0xff, 0x80, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x3, 0xcf, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x5f, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x7, 0xef, 0xff, 0xfb, 0x20, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x32, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xe4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x27, 0xaa, 0x95, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0x9b, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0xb9, 0xfe, 0x44,
    0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe4, 0x44, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x88, 0x8f, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xf8, 0x88, 0xff,
    0xfc, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xb0, 0x0, 0xcf, 0xfc, 0x0,
    0xc, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xb0, 0x0, 0xcf, 0xfd, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xd0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xcc, 0xcf, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xfc, 0xcc, 0xff, 0xfc, 0x0,
    0xc, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xff, 0xc0, 0x0, 0xcf, 0xfc, 0x0, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0xcf, 0xfc, 0x0, 0xc, 0xff, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xff, 0xc0, 0x0, 0xcf,
    0xff, 0xcc, 0xcf, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xfc, 0xcc, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xd0,
    0x0, 0xdf, 0xfc, 0x0, 0xc, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xb0, 0x0, 0xcf,
    0xfc, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xb0, 0x0, 0xcf, 0xff, 0x88,
    0x8f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xf8, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x44, 0x4e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x44, 0xef,
    0xab, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0xb9,

    /* U+F00B "" */
    0x9f, 0xff, 0xff, 0xfb, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff,
    0xff, 0xff, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x21, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x21, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xaf, 0xff, 0xff, 0xfc,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xfb, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff,
    0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x21, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x21, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xaf, 0xff, 0xff, 0xfc, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xfc,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x21, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x21, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x21, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x9f, 0xff, 0xff, 0xfb, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xe9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x8e, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0x80, 0x0,
    0xa, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xf6, 0x6, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xaf, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xe7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x6, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x2d, 0xfa, 0x0, 0x6f, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xa0, 0xef, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xf2,
    0xcf, 0xff, 0xff, 0xf5, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xf1, 0x2e, 0xff, 0xff, 0xff, 0x50, 0x2e,
    0xff, 0xff, 0xff, 0x50, 0x2, 0xef, 0xff, 0xff,
    0xf7, 0xef, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x2e,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x50, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xf6, 0xef, 0xff, 0xff, 0xf5, 0x0, 0x2e, 0xff,
    0xff, 0xff, 0x40, 0x2e, 0xff, 0xff, 0xff, 0x50,
    0xcf, 0xff, 0xff, 0xf4, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xf1, 0xef, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x2e, 0xff, 0xff, 0xf2, 0x6f, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xa0, 0x6, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x10, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x69, 0x96,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xa8, 0x0, 0x3,
    0xff, 0xff, 0x30, 0x0, 0x8a, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0x60, 0x3, 0xff, 0xff,
    0x30, 0x6, 0xff, 0xe3, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xff, 0xe0, 0x3, 0xff, 0xff, 0x30, 0xe,
    0xff, 0xff, 0x30, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xe0, 0x3, 0xff, 0xff, 0x30, 0xe, 0xff, 0xff,
    0xd1, 0x0, 0x0, 0x9f, 0xff, 0xfe, 0x30, 0x3,
    0xff, 0xff, 0x30, 0x3, 0xef, 0xff, 0xf9, 0x0,
    0x2, 0xff, 0xff, 0xe2, 0x0, 0x3, 0xff, 0xff,
    0x30, 0x0, 0x2e, 0xff, 0xff, 0x20, 0x9, 0xff,
    0xff, 0x50, 0x0, 0x3, 0xff, 0xff, 0x30, 0x0,
    0x5, 0xff, 0xff, 0x90, 0xe, 0xff, 0xfc, 0x0,
    0x0, 0x3, 0xff, 0xff, 0x30, 0x0, 0x0, 0xcf,
    0xff, 0xe0, 0x3f, 0xff, 0xf5, 0x0, 0x0, 0x3,
    0xff, 0xff, 0x30, 0x0, 0x0, 0x6f, 0xff, 0xf3,
    0x6f, 0xff, 0xf0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0x30, 0x0, 0x0, 0xf, 0xff, 0xf6, 0x7f, 0xff,
    0xe0, 0x0, 0x0, 0x3, 0xff, 0xff, 0x30, 0x0,
    0x0, 0xe, 0xff, 0xf8, 0x8f, 0xff, 0xd0, 0x0,
    0x0, 0x2, 0xff, 0xff, 0x20, 0x0, 0x0, 0xd,
    0xff, 0xf8, 0x8f, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0xef, 0xfe, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf7,
    0x6f, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x2, 0x20,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xf6, 0x3f, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xf3, 0xe, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xe0, 0x9, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x90,
    0x2, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xff, 0x20, 0x0, 0x9f,
    0xff, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xef, 0xff, 0xf9, 0x0, 0x0, 0x1e, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xd1, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xfa,
    0x75, 0x57, 0xaf, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe3, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x9d,
    0xff, 0xfe, 0xd9, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2c, 0xff, 0xff, 0xd6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xc8, 0x0, 0x5d,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x6d, 0x40,
    0x0, 0x0, 0xcf, 0xfe, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xcf, 0xfe, 0x20, 0x0, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xe7, 0x32, 0x5d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x13, 0xcf, 0xff, 0xff,
    0xff, 0xe1, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xfe, 0x60, 0x0, 0x7f, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xfb, 0x10, 0x0,
    0x4, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0x90, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x4, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xfb, 0x10, 0x3, 0xcf, 0xff,
    0xff, 0xff, 0xe1, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xfe, 0x60, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xe7, 0x32, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x17, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0xcf, 0xfe, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xcf, 0xfe, 0x10, 0x0, 0x1,
    0xc8, 0x0, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x5d, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2c, 0xff, 0xff, 0xd6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x37,
    0x60, 0x0, 0x0, 0x48, 0x88, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xfd, 0x10, 0x0, 0xaf, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xe3, 0x0, 0xbf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xff,
    0xff, 0xff, 0x60, 0xbf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xef, 0xff, 0xf8,
    0xcf, 0xff, 0xf9, 0xbf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xfe, 0x30,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xd2, 0x3,
    0x10, 0x7f, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xbf, 0xff, 0xfa, 0x0, 0x8f,
    0xd2, 0x4, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x2d, 0xff, 0xff, 0x80, 0xb, 0xff,
    0xff, 0x40, 0x2d, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xf5, 0x2, 0xdf, 0xff,
    0xff, 0xf7, 0x1, 0xbf, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xfe, 0x30, 0x3e, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0x9, 0xff, 0xff, 0xc1, 0x0,
    0xa, 0xff, 0xff, 0xc1, 0x6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x10, 0x6f, 0xff, 0xfe, 0x30,
    0xbf, 0xff, 0xfa, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe3, 0x4, 0xef, 0xff, 0xf4,
    0xbf, 0xff, 0x70, 0x1b, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x2d, 0xff, 0xf3,
    0xd, 0xf4, 0x2, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xbf, 0x60,
    0x1, 0x20, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x3, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xfe, 0x10, 0x0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x55, 0x55,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1c, 0xdd, 0xdd, 0xef,
    0xff, 0xff, 0xfe, 0xdd, 0xdd, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x10, 0x8,
    0xff, 0xff, 0x80, 0x1, 0x11, 0x11, 0x11, 0x10,
    0xbf, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x8f, 0xf8,
    0x1, 0xdf, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe2, 0x6, 0x60, 0x2d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x30, 0x3, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x1e, 0xb0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x2e, 0xc1,
    0x8f, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x37, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x73,

    /* U+F01C "" */
    0x0, 0x0, 0x0, 0x2b, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0xd8, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x9f, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x1, 0xef, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xef, 0xff, 0x30, 0x0,
    0x0, 0x5f, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xd0, 0x0,
    0x1, 0xef, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xf8, 0x0,
    0xa, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xff, 0x20,
    0x5f, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xd0,
    0xdf, 0xff, 0xb8, 0x88, 0x88, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x48, 0x88, 0x88, 0x8e, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x58, 0x86, 0x0, 0x0,
    0x0, 0x0, 0x4, 0x9d, 0xef, 0xfe, 0xb7, 0x20,
    0x0, 0x0, 0xdf, 0xff, 0x0, 0x0, 0x0, 0x6,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x30, 0x0,
    0xdf, 0xff, 0x0, 0x0, 0x1, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x10, 0xcf, 0xff,
    0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xfe, 0xef,
    0xff, 0xff, 0xff, 0xe3, 0xbf, 0xff, 0x0, 0x2,
    0xef, 0xff, 0xff, 0x94, 0x0, 0x0, 0x4b, 0xff,
    0xff, 0xfe, 0xdf, 0xff, 0x0, 0xd, 0xff, 0xff,
    0xc2, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x9f, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0x2, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x11, 0x0, 0x8, 0xff, 0xff, 0xff, 0x9, 0xff,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xee, 0xff, 0xff, 0xff, 0xe, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x3f, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x2b, 0xcc, 0x60, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xbc, 0xcc, 0xcc, 0xcc, 0xcc, 0xca, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xac, 0xcc, 0xcc, 0xcc, 0xcc, 0xcb, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xbc, 0xb2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xf2, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0xe0, 0xff, 0xff, 0xff, 0xee, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0x90,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x11, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0x20, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xf9, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xb2, 0x0, 0x0, 0x0, 0x0, 0x2c, 0xff, 0xff,
    0xd0, 0x0, 0xff, 0xfd, 0xef, 0xff, 0xff, 0xa4,
    0x0, 0x0, 0x4a, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0xff, 0xfb, 0x3e, 0xff, 0xff, 0xff, 0xfe, 0xef,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0xff, 0xfc,
    0x1, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x10, 0x0, 0x0, 0xff, 0xfd, 0x0, 0x3,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x60, 0x0,
    0x0, 0x0, 0xff, 0xfd, 0x0, 0x0, 0x2, 0x7c,
    0xff, 0xff, 0xd9, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x68, 0x85, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xb6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0x38, 0x88, 0x88, 0x8f, 0xff, 0xff,
    0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x10,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x38,
    0x88, 0x88, 0x8f, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x1, 0xb9, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x6f, 0xfc, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1, 0xcf,
    0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xef, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xdf,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xbf, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x6f, 0xfd, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x2, 0xdb, 0x10,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0,
    0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x18, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xb6, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xdf, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x0,
    0x0, 0x0, 0x21, 0x0, 0x1c, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0x0,
    0x0, 0x4, 0xfe, 0x50, 0x1, 0xef, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0x0,
    0x0, 0x5, 0xff, 0xf6, 0x0, 0x4f, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0x40, 0xa, 0xff, 0x40,
    0x38, 0x88, 0x88, 0x8f, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xe0, 0x2, 0xff, 0xa0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1c, 0xa1, 0x0, 0x8f, 0xf6, 0x0, 0xcf, 0xf0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x6f, 0xfd, 0x0, 0x1f, 0xfc, 0x0, 0x8f, 0xf2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1c, 0xff, 0x80, 0xa, 0xff, 0x0, 0x4f, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xdf, 0xd0, 0x7, 0xff, 0x20, 0x3f, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xaf, 0xf0, 0x6, 0xff, 0x30, 0x2f, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xdf, 0xd0, 0x7, 0xff, 0x20, 0x3f, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1c, 0xff, 0x80, 0xa, 0xff, 0x0, 0x4f, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x6f, 0xfd, 0x0, 0x1f, 0xfc, 0x0, 0x8f, 0xf2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1c, 0xa1, 0x0, 0x9f, 0xf6, 0x0, 0xdf, 0xe0,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xe0, 0x3, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0x40, 0xa, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0x0,
    0x0, 0x5, 0xff, 0xf6, 0x0, 0x4f, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0x0,
    0x0, 0x4, 0xfe, 0x50, 0x1, 0xef, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0,
    0x0, 0x0, 0x21, 0x0, 0x1d, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xdf, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x18, 0x50, 0x0, 0x0, 0x0,

    /* U+F03E "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x93, 0x27, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xd8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xfc, 0x10, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x50, 0x3, 0xdf, 0xff, 0xff, 0xff,
    0xc1, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0xef, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x3e, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xff, 0xfc, 0x10, 0x3, 0xef, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xc1, 0x0, 0x0, 0x3b, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xfc,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb1,

    /* U+F048 "" */
    0x48, 0x88, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x70, 0xbf, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf9, 0xbf, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x1c, 0xff, 0xfc, 0xbf, 0xff, 0x30, 0x0, 0x0,
    0x1, 0xdf, 0xff, 0xfc, 0xbf, 0xff, 0x30, 0x0,
    0x0, 0x2e, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0x30,
    0x0, 0x3, 0xef, 0xff, 0xff, 0xfc, 0xbf, 0xff,
    0x30, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xfc, 0xbf,
    0xff, 0x30, 0x5, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xbf, 0xff, 0x30, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0xbf, 0xff, 0x37, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0xbf, 0xff, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xbf,
    0xff, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xbf, 0xff, 0x31, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0xbf, 0xff, 0x30, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0xbf, 0xff, 0x30, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xfc, 0xbf, 0xff, 0x30, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0x30, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0x30,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xfc, 0xbf, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xfc, 0xbf,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x4, 0xff, 0xfb,
    0x9f, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x3d,
    0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F04B "" */
    0x3, 0x75, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xfc, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb2, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb2, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x50, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb2, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xe6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff,
    0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xfc, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x74,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x1a, 0xef, 0xff, 0xff, 0xd5, 0x0, 0x0, 0x1a,
    0xef, 0xff, 0xff, 0xd5, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0x66,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0x4, 0x89, 0x99, 0x98,
    0x71, 0x0, 0x0, 0x4, 0x89, 0x99, 0x98, 0x71,
    0x0,

    /* U+F04D "" */
    0x3, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x60, 0x6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x1a, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5,
    0x0,

    /* U+F051 "" */
    0x5, 0x81, 0x0, 0x0, 0x0, 0x0, 0x0, 0x68,
    0x87, 0x5f, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0x7f, 0xff, 0xe3, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x8f, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xc1,
    0x0, 0x0, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x8f, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x7f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0x1c, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x9a, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x1, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x5, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x93, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0,

    /* U+F054 "" */
    0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x1, 0xcf, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x1c, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x1, 0xcf, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x1c, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x1, 0xdf, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xa8, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x23, 0x33, 0x33, 0x33,
    0x8f, 0xff, 0xfe, 0x33, 0x33, 0x33, 0x33, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8d, 0xdc, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F068 "" */
    0x1, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x10, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x77, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe1, 0x1, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x10, 0x0,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x26, 0xad, 0xef,
    0xfe, 0xc9, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xff, 0xff, 0xff, 0xba,
    0xbd, 0xff, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xfd, 0x50, 0x0,
    0x0, 0x18, 0xff, 0xff, 0xfe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x39,
    0x95, 0x0, 0x2, 0xef, 0xff, 0xff, 0x70, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x3f,
    0xff, 0xd2, 0x0, 0x5f, 0xff, 0xff, 0xf5, 0x0,
    0x7, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x3f,
    0xff, 0xfe, 0x10, 0xd, 0xff, 0xff, 0xff, 0x20,
    0x2f, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0x80, 0x8, 0xff, 0xff, 0xff, 0xc0,
    0xbf, 0xff, 0xff, 0xff, 0x0, 0x48, 0x6b, 0xff,
    0xff, 0xff, 0xd0, 0x5, 0xff, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x4, 0xff, 0xff, 0xff, 0xf9,
    0xbf, 0xff, 0xff, 0xff, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x5, 0xff, 0xff, 0xff, 0xf5,
    0x1f, 0xff, 0xff, 0xff, 0x20, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x8, 0xff, 0xff, 0xff, 0xc0,
    0x6, 0xff, 0xff, 0xff, 0x70, 0x8, 0xff, 0xff,
    0xff, 0xff, 0x20, 0xd, 0xff, 0xff, 0xff, 0x20,
    0x0, 0xaf, 0xff, 0xff, 0xe0, 0x0, 0xaf, 0xff,
    0xff, 0xf4, 0x0, 0x5f, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xfb, 0x0, 0x4, 0xad,
    0xc8, 0x10, 0x2, 0xef, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xfd, 0x50, 0x0,
    0x0, 0x18, 0xff, 0xff, 0xfe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xff, 0xff, 0xff, 0xba,
    0xac, 0xff, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x26, 0xad, 0xff,
    0xfe, 0xc9, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F070 "" */
    0x4, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xe3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x26, 0xad, 0xff, 0xed,
    0xb7, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xdf, 0xff, 0xfa, 0x16, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xba, 0xbe, 0xff, 0xff, 0xfe, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xc5, 0x0, 0x0, 0x3, 0xbf, 0xff, 0xff,
    0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1b, 0xff, 0xff, 0xc1, 0x6, 0xba, 0x50,
    0x0, 0x7f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xe4, 0x7f,
    0xff, 0xc1, 0x0, 0xbf, 0xff, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0xad, 0x20, 0x0, 0x4, 0xff, 0xff,
    0xfc, 0xff, 0xff, 0xc0, 0x3, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x5f, 0xff, 0x50, 0x0, 0x2,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0x50, 0xe, 0xff,
    0xff, 0xff, 0x50, 0x0, 0xe, 0xff, 0xff, 0x90,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0xbf, 0xff, 0xff, 0xfe, 0x0, 0x2, 0xff, 0xff,
    0xff, 0xc2, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xb0, 0xa, 0xff, 0xff, 0xff, 0xf2, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x3e, 0xff,
    0xff, 0xfa, 0x0, 0xcf, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x1b, 0xff, 0xff, 0xd2, 0xe, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x4, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x1, 0xcf,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xdf, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xbf, 0xff, 0xff, 0xc4, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0xff, 0xff,
    0xfe, 0xba, 0xb5, 0x0, 0x0, 0x2d, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xdf, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x37, 0xbd, 0xef, 0xfd, 0xb4, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xef, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xcf, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x44, 0x0,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x87, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xff, 0x80, 0x0, 0x1e, 0xff,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xff, 0xf6, 0x0, 0x0, 0xef,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0x70, 0x0, 0xf,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0x80, 0x0,
    0xf, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xd1, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x9, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x13, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x10, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf7, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x48,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x98, 0x71, 0x0,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xe3, 0x0, 0x24, 0x44, 0x44, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x44, 0x4f, 0xff, 0xfe, 0x30,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x1, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1,
    0x12, 0x22, 0x26, 0xff, 0xff, 0xa0, 0x1d, 0xff,
    0xff, 0xd2, 0x2f, 0xff, 0xfd, 0x10, 0x0, 0x0,
    0x0, 0x7f, 0xfb, 0x1, 0xdf, 0xff, 0xfd, 0x10,
    0xf, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xc0, 0xc, 0xff, 0xff, 0xe2, 0x0, 0xe, 0xfd,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xfe, 0x20, 0x0, 0x4, 0x81, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x4, 0x81, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xf5, 0x5, 0xe2, 0x0, 0xe, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0x60, 0x4f, 0xfd, 0x10, 0xf, 0xff, 0xe2, 0x0,
    0x12, 0x22, 0x26, 0xff, 0xff, 0xf7, 0x3, 0xff,
    0xff, 0xd2, 0x2f, 0xff, 0xfe, 0x20, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x1, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe2, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x24, 0x44,
    0x44, 0x30, 0x0, 0x0, 0x0, 0x0, 0x2, 0x44,
    0x4f, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfe, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xa2, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xb2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xfa, 0x3f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xfa, 0x0, 0x3f, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xe2, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xe2, 0x0, 0x8, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff,
    0xe2, 0x6, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xe0, 0x9f, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0x11, 0xdf, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x60, 0x1,
    0xa8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3b, 0x50, 0x0,

    /* U+F078 "" */
    0x1, 0xa8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3b, 0x60, 0x1, 0xdf, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x60, 0x9f, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0x16, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xd0, 0x8, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xe2, 0x0, 0x8,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x8, 0xff, 0xff, 0xfa,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xfa, 0x0, 0x3f, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xfa, 0x3f, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xa2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x0, 0x42, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xf4,
    0x0, 0x0, 0x57, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x60, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xf4, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xf4, 0x2, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xef, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xf9,
    0x0, 0x0, 0xf, 0xff, 0xf4, 0xef, 0xf9, 0x9f,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0x90, 0x0, 0x0, 0x7f, 0xf5, 0xe, 0xff,
    0x90, 0xaf, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xf9, 0x0, 0x0, 0x0, 0x32, 0x0,
    0xef, 0xf9, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0x80,
    0xe, 0xff, 0x90, 0x2a, 0x70, 0x0, 0x0, 0xe,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xa0, 0xef, 0xf9, 0x2e, 0xff, 0x60, 0x0,
    0x0, 0xef, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0x9e, 0xff, 0xad, 0xff, 0xf9,
    0x0, 0x0, 0xe, 0xff, 0xc7, 0x77, 0x77, 0x77,
    0x77, 0x73, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x10, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x4, 0xff,
    0xff, 0xff, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x3, 0xff, 0xff, 0xfc, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xfc, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xdb, 0x0, 0x0,
    0x0,

    /* U+F07B "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xc1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd8, 0x88, 0x88, 0x88, 0x88, 0x87, 0x30,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb1,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x22, 0x22, 0xcf,
    0xff, 0xff, 0xf6, 0x22, 0x22, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x0, 0xbf,
    0xff, 0xff, 0xf4, 0x0, 0x11, 0x11, 0x11, 0x10,
    0xbf, 0xff, 0xff, 0xff, 0xc0, 0xaf, 0xff, 0xff,
    0xf3, 0xc, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x18, 0x99, 0x99, 0x60, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0x1, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xcc, 0xcc, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x1e, 0xb0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x2e, 0xc1,
    0x8f, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x37, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x73,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0x62, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xfe, 0xb7, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x26, 0x10, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xbf, 0xfc, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xfe, 0x10,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x5, 0xef, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x20, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x91, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xe9,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xd9, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x17,
    0x76, 0x53, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C4 "" */
    0x0, 0x5, 0x99, 0x72, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x1, 0x7b, 0xb8,
    0x10, 0x1e, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xfe, 0x38, 0xff, 0xff,
    0xef, 0xff, 0xf1, 0x0, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xf4, 0xdf, 0xfe, 0x10, 0x7f, 0xff, 0x50,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xf5, 0xf, 0xff,
    0x80, 0x0, 0xff, 0xf7, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xf5, 0x0, 0xef, 0xfc, 0x0, 0x4f, 0xff,
    0x60, 0x2, 0xef, 0xff, 0xff, 0xf5, 0x0, 0xa,
    0xff, 0xfd, 0xbf, 0xff, 0xf4, 0x3, 0xef, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0xe5, 0xef, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x18, 0xcd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xef, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x99, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x8, 0xff, 0xff, 0xef,
    0xff, 0xf6, 0x5, 0xff, 0xff, 0xff, 0xe2, 0x0,
    0x0, 0xdf, 0xfe, 0x10, 0x7f, 0xff, 0x50, 0x5,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0xf, 0xff, 0x80,
    0x0, 0xff, 0xf7, 0x0, 0x5, 0xff, 0xff, 0xff,
    0xe2, 0x0, 0xef, 0xfc, 0x0, 0x4f, 0xff, 0x60,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xe2, 0xa, 0xff,
    0xfd, 0xbf, 0xff, 0xf2, 0x0, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xe2, 0x2f, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0x40,
    0x4f, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xbe, 0xfb, 0x30, 0x0, 0x18, 0xcd, 0xb5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x0, 0x1, 0x44, 0x44, 0x44, 0x44,
    0x42, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0x80, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xe, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xef,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0xef, 0xff, 0xf4, 0xaf, 0xff, 0xf4, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0xbb, 0xbb, 0xb3, 0xff, 0xff, 0xf4, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x5f, 0xff, 0xff, 0x40, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xf4,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x5f, 0xff, 0xff, 0x40, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff,
    0xf4, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x5f, 0xff, 0xff, 0x40, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff,
    0xff, 0xf4, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x5f, 0xff, 0xff, 0x40, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xf4, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x5f, 0xff, 0xff, 0x40,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xf4, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xff, 0xff,
    0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xff, 0xff, 0xf4, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xff,
    0xff, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0xff, 0xff, 0xf5, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1f,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xa2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x37, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x60, 0x0,
    0x0, 0x0, 0x0,

    /* U+F0C7 "" */
    0x4, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x87, 0x20, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x40, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x0, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0x40, 0xf, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0x30, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xfe, 0xf,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xf3, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0x4f, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xf4, 0xff, 0xfd, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x7e, 0xff, 0xff,
    0xff, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x82, 0x15, 0xef, 0xff,
    0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0x30, 0x0, 0x0, 0xef, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xa9, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x1a, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3,
    0x0,

    /* U+F0E7 "" */
    0x0, 0x8, 0xbb, 0xbb, 0xbb, 0xbb, 0x80, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x70, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x0, 0x0, 0x1, 0x43, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x49, 0x99, 0x99, 0xff, 0xef, 0xfe, 0x99,
    0x99, 0x81, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xa0, 0x1e, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xfa, 0x1, 0xef,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xfc, 0x64, 0x44, 0x44, 0x44,
    0x30, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0x20, 0xaf, 0xff, 0xff,
    0xff, 0xa0, 0xd6, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xf0, 0x1f, 0xff, 0xff, 0xff, 0xfa, 0xe, 0xf6,
    0x0, 0xf, 0xff, 0xff, 0xff, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0xef, 0xf6, 0x0, 0xff, 0xff,
    0xff, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xfa, 0xe,
    0xff, 0xf6, 0xf, 0xff, 0xff, 0xff, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0xef, 0xff, 0xf3, 0xff,
    0xff, 0xff, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xfa,
    0x4, 0x44, 0x44, 0x1f, 0xff, 0xff, 0xff, 0x1,
    0xff, 0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x5f, 0xff, 0xff, 0xff,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xff, 0xf0, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xff, 0xff,
    0xff, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xff, 0xff, 0xff, 0xf0, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xff,
    0xff, 0xff, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0xaf, 0xff, 0xff, 0xf0, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x42, 0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xa2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x8d, 0xff, 0xfa, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xd4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xa0, 0x1, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x15, 0x73, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xff, 0xfd, 0x88, 0x9f, 0xf8, 0x88, 0xff, 0x98,
    0x8e, 0xfa, 0x88, 0xbf, 0xd8, 0x89, 0xff, 0xf8,
    0xff, 0xf8, 0x0, 0xf, 0xc0, 0x0, 0xcf, 0x0,
    0xa, 0xf1, 0x0, 0x4f, 0x70, 0x0, 0xff, 0xf8,
    0xff, 0xf8, 0x0, 0xf, 0xc0, 0x0, 0xcf, 0x0,
    0xa, 0xf1, 0x0, 0x4f, 0x70, 0x0, 0xff, 0xf8,
    0xff, 0xf9, 0x0, 0x1f, 0xd0, 0x0, 0xdf, 0x10,
    0xc, 0xf3, 0x0, 0x6f, 0x90, 0x1, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xdc, 0xce, 0xfe, 0xcc, 0xdf,
    0xfc, 0xcd, 0xff, 0xcc, 0xcf, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0x20, 0x6, 0xf6, 0x0, 0x3f,
    0x80, 0x0, 0xfd, 0x0, 0xa, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0x20, 0x6, 0xf6, 0x0, 0x2f,
    0x80, 0x0, 0xed, 0x0, 0xa, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0x20, 0x6, 0xf6, 0x0, 0x3f,
    0x80, 0x0, 0xfd, 0x0, 0xa, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xdc, 0xce, 0xfe, 0xcc, 0xdf,
    0xfc, 0xcd, 0xff, 0xcc, 0xcf, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xf9, 0x0, 0x1f, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x90, 0x1, 0xff, 0xf8,
    0xff, 0xf8, 0x0, 0xf, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0xff, 0xf8,
    0xff, 0xf8, 0x0, 0xf, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0xff, 0xf8,
    0xff, 0xfd, 0x88, 0x9f, 0xf8, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0xbf, 0xd8, 0x89, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x72, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xef, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x18, 0xef, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3a, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4c, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x7e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x2, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x4,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x1, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x44, 0x44, 0x44, 0x44, 0x4d, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x17, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x10, 0x30,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0xf, 0xa0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x40, 0xff, 0xa0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xf, 0xff,
    0xa0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0xff, 0xff, 0xa0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0xf, 0xff, 0xff, 0xa0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0xff, 0xff,
    0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xb, 0xbb, 0xbb, 0xbb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x14, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x10,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x69, 0xab, 0xcb, 0xa9, 0x63, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x27,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xba,
    0xaa, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xc7, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x37, 0xcf, 0xff, 0xff,
    0xff, 0xd1, 0x3, 0xef, 0xff, 0xff, 0xf9, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29,
    0xff, 0xff, 0xff, 0xe3, 0xef, 0xff, 0xff, 0xb2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xbf, 0xff, 0xff, 0xe7, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xf7, 0x7,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x48, 0xbe, 0xff,
    0xfd, 0xb8, 0x40, 0x0, 0x0, 0x0, 0x2d, 0xf7,
    0x0, 0x4, 0x10, 0x0, 0x0, 0x18, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe8, 0x10, 0x0, 0x0,
    0x14, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xc8, 0x76, 0x78, 0xcf,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xef, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x47, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xdb, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x2, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x74,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x9f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0xc, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x80, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x28, 0xcf, 0xff, 0xff, 0xf8, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x8, 0xff, 0xff, 0xff, 0x80,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x80, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f,
    0xff, 0xff, 0xff, 0xf8, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfe, 0xff, 0xfb, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x79, 0xff, 0xfa, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F241 "" */
    0x2, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x74,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x9f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x80, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x28, 0xcf, 0xff, 0xff, 0xf8, 0xe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x80,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x80, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfe, 0xff, 0xfb, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x79, 0xff, 0xfa, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F242 "" */
    0x2, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x74,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x9f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x80, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x28, 0xcf, 0xff, 0xff, 0xf8, 0xe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x80,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x80, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfe, 0xff, 0xfb, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x79, 0xff, 0xfa, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F243 "" */
    0x2, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x74,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x9f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x80, 0xef, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x28, 0xcf, 0xff, 0xff, 0xf8, 0xe, 0xff,
    0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x80,
    0xef, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0xe, 0xff, 0xff, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x80, 0xef, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfe, 0xff, 0xfb, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x79, 0xff, 0xfa, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F244 "" */
    0x2, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x74,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x9f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x28, 0xcf, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfe, 0xff, 0xfb, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x79, 0xff, 0xfa, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5e, 0xfe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x23, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xcd, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xe1, 0x0, 0xcf, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x50, 0x0, 0x7, 0xa7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x10, 0x0, 0x0, 0x4, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xef, 0xfc, 0x20, 0x0, 0xc, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x40,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xe1, 0x0, 0x4f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xfb, 0x20, 0x0, 0xcf, 0xff, 0xff, 0xfa,
    0x35, 0xef, 0x94, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x4d, 0xff, 0xf7, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0xef, 0xff, 0xff, 0xfe, 0xbb, 0xbb, 0xbc, 0xff,
    0xcb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbf, 0xff,
    0xfe, 0x50, 0x8f, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x9f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0x80, 0x0, 0xb, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xb2, 0x0, 0x0, 0x0, 0x58,
    0x73, 0x0, 0x0, 0x0, 0x0, 0x7, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x20, 0x6, 0xdd, 0xdd, 0xc2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xc0, 0x9, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xde, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xaf,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x19, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x34, 0x32, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 0xef,
    0xff, 0xff, 0xfb, 0x50, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10,
    0x0, 0x0, 0x1, 0xcf, 0xff, 0xff, 0xc7, 0xff,
    0xff, 0xff, 0xd1, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xc0, 0x8f, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xc0, 0x9, 0xff, 0xff,
    0xff, 0x50, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0xaf, 0xff, 0xff, 0xb0, 0x2, 0xff, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0xb, 0xff, 0xff, 0xf1,
    0x6, 0xff, 0xff, 0xaf, 0xff, 0xc0, 0x39, 0x0,
    0xcf, 0xff, 0xf5, 0xa, 0xff, 0xf9, 0x3, 0xef,
    0xc0, 0x3f, 0x90, 0x1d, 0xff, 0xf8, 0xc, 0xff,
    0xfd, 0x10, 0x3e, 0xc0, 0x2f, 0xb0, 0xc, 0xff,
    0xfa, 0xe, 0xff, 0xff, 0xd1, 0x3, 0xb0, 0x2b,
    0x0, 0xaf, 0xff, 0xfc, 0xf, 0xff, 0xff, 0xfd,
    0x10, 0x10, 0x0, 0x9, 0xff, 0xff, 0xfd, 0xf,
    0xff, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0xfd, 0x10,
    0x5, 0xff, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x3, 0xff, 0xff, 0xff, 0xfe,
    0xf, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xfd, 0xf, 0xff, 0xff, 0xfb, 0x0,
    0x20, 0x11, 0x4, 0xff, 0xff, 0xfd, 0xe, 0xff,
    0xff, 0xb0, 0x5, 0xc0, 0x2d, 0x10, 0x5f, 0xff,
    0xfc, 0xc, 0xff, 0xfb, 0x0, 0x5f, 0xc0, 0x2f,
    0xd0, 0x7, 0xff, 0xfa, 0x9, 0xff, 0xfb, 0x5,
    0xff, 0xc0, 0x3f, 0x60, 0x1d, 0xff, 0xf7, 0x5,
    0xff, 0xff, 0xdf, 0xff, 0xc0, 0x36, 0x1, 0xdf,
    0xff, 0xf4, 0x1, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x1d, 0xff, 0xff, 0xf0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xd0, 0x1, 0xdf, 0xff, 0xff, 0xa0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xd0, 0x1d, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xd1, 0xcf, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x2, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x58, 0xab, 0xba, 0x84, 0x0, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x0, 0x0, 0x14, 0x44, 0x44, 0x43,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x58, 0x88, 0x88, 0x8c, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x88, 0x88, 0x88, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8b, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x28, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x86, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x4f, 0xff, 0xf5, 0x5f, 0xff, 0x92,
    0xff, 0xfc, 0x1c, 0xff, 0xfc, 0x0, 0x4, 0xff,
    0xff, 0x22, 0xff, 0xf6, 0xe, 0xff, 0xa0, 0xaf,
    0xff, 0xc0, 0x0, 0x4f, 0xff, 0xf2, 0x2f, 0xff,
    0x60, 0xef, 0xfa, 0xa, 0xff, 0xfc, 0x0, 0x4,
    0xff, 0xff, 0x22, 0xff, 0xf6, 0xe, 0xff, 0xa0,
    0xaf, 0xff, 0xc0, 0x0, 0x4f, 0xff, 0xf2, 0x2f,
    0xff, 0x60, 0xef, 0xfa, 0xa, 0xff, 0xfc, 0x0,
    0x4, 0xff, 0xff, 0x22, 0xff, 0xf6, 0xe, 0xff,
    0xa0, 0xaf, 0xff, 0xc0, 0x0, 0x4f, 0xff, 0xf2,
    0x2f, 0xff, 0x60, 0xef, 0xfa, 0xa, 0xff, 0xfc,
    0x0, 0x4, 0xff, 0xff, 0x22, 0xff, 0xf6, 0xe,
    0xff, 0xa0, 0xaf, 0xff, 0xc0, 0x0, 0x4f, 0xff,
    0xf2, 0x2f, 0xff, 0x60, 0xef, 0xfa, 0xa, 0xff,
    0xfc, 0x0, 0x4, 0xff, 0xff, 0x22, 0xff, 0xf6,
    0xe, 0xff, 0xa0, 0xaf, 0xff, 0xc0, 0x0, 0x4f,
    0xff, 0xf2, 0x2f, 0xff, 0x60, 0xef, 0xfa, 0xa,
    0xff, 0xfc, 0x0, 0x4, 0xff, 0xff, 0x22, 0xff,
    0xf6, 0xe, 0xff, 0xa0, 0xaf, 0xff, 0xc0, 0x0,
    0x4f, 0xff, 0xf2, 0x2f, 0xff, 0x60, 0xef, 0xfa,
    0xa, 0xff, 0xfc, 0x0, 0x4, 0xff, 0xff, 0x55,
    0xff, 0xf9, 0x2f, 0xff, 0xc1, 0xcf, 0xff, 0xc0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x4,
    0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x61, 0x0, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x66, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xdf, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xec,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xfc, 0x0,
    0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xfc, 0x0, 0xbf,
    0xff, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xff, 0xff, 0xfc, 0x0, 0xbf, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0xbe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xec, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x76,
    0x42, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd5, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x99, 0xff,
    0xff, 0xff, 0x99, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x8, 0xff, 0xff, 0x80, 0x7, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x8, 0xff, 0x80, 0x0, 0xe, 0xff,
    0xff, 0xff, 0xf0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x8, 0x80, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x8, 0x80, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x8, 0xff,
    0x80, 0x0, 0xe, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x8,
    0xff, 0xff, 0x80, 0x8, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x99, 0xff, 0xff, 0xff, 0x99, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5, 0x0,

    /* U+F7C2 "" */
    0x0, 0x0, 0x0, 0x17, 0x88, 0x88, 0x88, 0x88,
    0x87, 0x50, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xc1, 0x0, 0x0, 0x2d,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x2e, 0xff, 0x20, 0x1f, 0xa0,
    0xe, 0xd0, 0x8, 0xff, 0xf0, 0x2e, 0xff, 0xf2,
    0x1, 0xfa, 0x0, 0xed, 0x0, 0x8f, 0xff, 0x3e,
    0xff, 0xff, 0x20, 0x1f, 0xa0, 0xe, 0xd0, 0x8,
    0xff, 0xfe, 0xff, 0xff, 0xf2, 0x1, 0xfa, 0x0,
    0xed, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x1f, 0xa0, 0xe, 0xd0, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x24,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x20,
    0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x5c, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x7f, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf1, 0x0,
    0x0, 0x8f, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0x10, 0x0, 0x9f,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xf1, 0x0, 0xaf, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0x10, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1c,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x2e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x1d, 0xff, 0xff,
    0xfe, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x10, 0x0, 0x1c, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 111, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 115, .box_w = 4, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 40, .adv_w = 143, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 14},
    {.bitmap_index = 65, .adv_w = 279, .box_w = 17, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 235, .adv_w = 252, .box_w = 14, .box_h = 26, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 417, .adv_w = 328, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 607, .adv_w = 278, .box_w = 17, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 777, .adv_w = 78, .box_w = 3, .box_h = 7, .ofs_x = 1, .ofs_y = 14},
    {.bitmap_index = 788, .adv_w = 153, .box_w = 9, .box_h = 30, .ofs_x = 1, .ofs_y = -7},
    {.bitmap_index = 923, .adv_w = 156, .box_w = 8, .box_h = 30, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 1043, .adv_w = 193, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 1115, .adv_w = 254, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1220, .adv_w = 88, .box_w = 5, .box_h = 7, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1238, .adv_w = 124, .box_w = 8, .box_h = 3, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 1250, .adv_w = 118, .box_w = 5, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1258, .adv_w = 185, .box_w = 11, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1379, .adv_w = 252, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1519, .adv_w = 252, .box_w = 8, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1599, .adv_w = 252, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1739, .adv_w = 252, .box_w = 13, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1869, .adv_w = 252, .box_w = 16, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2029, .adv_w = 252, .box_w = 13, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2159, .adv_w = 251, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2299, .adv_w = 252, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2439, .adv_w = 252, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2579, .adv_w = 252, .box_w = 13, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2709, .adv_w = 109, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2739, .adv_w = 95, .box_w = 5, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2787, .adv_w = 228, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 2872, .adv_w = 246, .box_w = 12, .box_h = 8, .ofs_x = 2, .ofs_y = 5},
    {.bitmap_index = 2920, .adv_w = 234, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 3005, .adv_w = 212, .box_w = 12, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3125, .adv_w = 402, .box_w = 23, .box_h = 26, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 3424, .adv_w = 292, .box_w = 18, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3604, .adv_w = 279, .box_w = 14, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3744, .adv_w = 292, .box_w = 16, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3904, .adv_w = 294, .box_w = 15, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4054, .adv_w = 255, .box_w = 13, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4184, .adv_w = 248, .box_w = 13, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4314, .adv_w = 305, .box_w = 17, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4484, .adv_w = 319, .box_w = 16, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4644, .adv_w = 122, .box_w = 4, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4684, .adv_w = 247, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4824, .adv_w = 281, .box_w = 16, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4984, .adv_w = 241, .box_w = 13, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5114, .adv_w = 391, .box_w = 21, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5324, .adv_w = 319, .box_w = 16, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5484, .adv_w = 308, .box_w = 17, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5654, .adv_w = 283, .box_w = 15, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5804, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 6008, .adv_w = 276, .box_w = 15, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6158, .adv_w = 266, .box_w = 15, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6308, .adv_w = 267, .box_w = 17, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6478, .adv_w = 291, .box_w = 16, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6638, .adv_w = 285, .box_w = 18, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6818, .adv_w = 397, .box_w = 25, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7068, .adv_w = 281, .box_w = 17, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7238, .adv_w = 269, .box_w = 17, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7408, .adv_w = 268, .box_w = 15, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7558, .adv_w = 119, .box_w = 6, .box_h = 27, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 7639, .adv_w = 184, .box_w = 12, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7771, .adv_w = 119, .box_w = 6, .box_h = 27, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7852, .adv_w = 187, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 7907, .adv_w = 202, .box_w = 13, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7927, .adv_w = 138, .box_w = 7, .box_h = 4, .ofs_x = 0, .ofs_y = 17},
    {.bitmap_index = 7941, .adv_w = 244, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8039, .adv_w = 251, .box_w = 14, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8186, .adv_w = 235, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8284, .adv_w = 253, .box_w = 13, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8421, .adv_w = 237, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8519, .adv_w = 156, .box_w = 10, .box_h = 22, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8629, .adv_w = 251, .box_w = 13, .box_h = 21, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 8766, .adv_w = 247, .box_w = 13, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8903, .adv_w = 109, .box_w = 4, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8943, .adv_w = 107, .box_w = 6, .box_h = 26, .ofs_x = -1, .ofs_y = -6},
    {.bitmap_index = 9021, .adv_w = 227, .box_w = 14, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9168, .adv_w = 109, .box_w = 3, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 9200, .adv_w = 393, .box_w = 22, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9365, .adv_w = 247, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9463, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9568, .adv_w = 251, .box_w = 14, .box_h = 21, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 9715, .adv_w = 255, .box_w = 13, .box_h = 21, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 9852, .adv_w = 152, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9920, .adv_w = 231, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10018, .adv_w = 146, .box_w = 9, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10104, .adv_w = 247, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10202, .adv_w = 217, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10307, .adv_w = 337, .box_w = 21, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10465, .adv_w = 222, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10570, .adv_w = 212, .box_w = 13, .box_h = 21, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 10707, .adv_w = 222, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10797, .adv_w = 152, .box_w = 10, .box_h = 28, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 10937, .adv_w = 109, .box_w = 3, .box_h = 24, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 10973, .adv_w = 152, .box_w = 9, .box_h = 28, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 11099, .adv_w = 305, .box_w = 17, .box_h = 6, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 11150, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11556, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11850, .adv_w = 448, .box_w = 28, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12200, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12494, .adv_w = 308, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12704, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 13110, .adv_w = 448, .box_w = 27, .box_h = 29, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 13502, .adv_w = 504, .box_w = 32, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13902, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 14308, .adv_w = 504, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14644, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 15050, .adv_w = 224, .box_w = 14, .box_h = 23, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 15211, .adv_w = 336, .box_w = 21, .box_h = 23, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 15453, .adv_w = 504, .box_w = 32, .box_h = 27, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15885, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16179, .adv_w = 392, .box_w = 18, .box_h = 26, .ofs_x = 3, .ofs_y = -3},
    {.bitmap_index = 16413, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 16776, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17089, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17402, .adv_w = 392, .box_w = 18, .box_h = 26, .ofs_x = 3, .ofs_y = -3},
    {.bitmap_index = 17636, .adv_w = 392, .box_w = 26, .box_h = 25, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 17961, .adv_w = 280, .box_w = 16, .box_h = 25, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 18161, .adv_w = 280, .box_w = 16, .box_h = 25, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 18361, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18674, .adv_w = 392, .box_w = 25, .box_h = 7, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 18762, .adv_w = 504, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19098, .adv_w = 560, .box_w = 35, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 19606, .adv_w = 504, .box_w = 33, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 20085, .adv_w = 448, .box_w = 28, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20435, .adv_w = 392, .box_w = 25, .box_h = 15, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 20623, .adv_w = 392, .box_w = 25, .box_h = 15, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 20811, .adv_w = 560, .box_w = 35, .box_h = 22, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21196, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21490, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 21896, .adv_w = 448, .box_w = 29, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 22317, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 22630, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 22993, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23306, .adv_w = 280, .box_w = 19, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 23582, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 23945, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 24308, .adv_w = 504, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24644, .adv_w = 448, .box_w = 30, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 25079, .adv_w = 336, .box_w = 21, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 25384, .adv_w = 560, .box_w = 35, .box_h = 26, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 25839, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 26172, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 26505, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 26838, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 27171, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 27504, .adv_w = 560, .box_w = 36, .box_h = 23, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 27918, .adv_w = 392, .box_w = 22, .box_h = 29, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 28237, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 28600, .adv_w = 448, .box_w = 29, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 29021, .adv_w = 560, .box_w = 35, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29389, .adv_w = 336, .box_w = 21, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 29694, .adv_w = 451, .box_w = 29, .box_h = 19, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 96,
        .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -23, 0, 0, 0,
    0, 0, 0, 0, -26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -11, -13, 0, -4, -13, 0, -17, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 4, 0,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -37, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -49, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -26, 0, 0, 0, 0, 0, 0, -13,
    0, -2, 0, 0, -28, -4, -19, -15,
    0, -21, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -4, -2, -11, -7, 0,
    3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -6,
    0, -5, 0, 0, -12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -6, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    0, 0, 0, 0, 0, -22, 0, 0,
    0, -5, 0, 0, 0, -6, 0, -5,
    0, -5, -9, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 0, 0, 0, 0, 0, 0, 0,
    0, -4, -4, 0, -4, 0, 0, 0,
    -4, -6, -5, 0, 0, 0, 0, 0,
    0, 0, 0, -51, 0, 0, 0, -37,
    0, -58, 0, 4, 0, 0, 0, 0,
    0, 0, 0, -7, -5, 0, 0, -5,
    -6, 0, 0, -5, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 0, 0, 0, -6, 0,
    0, 0, 4, -6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -14, 0, 0,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, -5,
    -6, 0, 0, 0, -5, -9, -14, 0,
    0, 0, 0, -73, 0, 0, 0, 0,
    0, 0, 0, 4, -14, 0, 0, -60,
    -12, -38, -31, 0, -52, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    -29, -20, 0, 0, 0, 0, 0, 0,
    0, 0, -71, 0, 0, 0, -30, 0,
    -44, 0, 0, 0, 0, 0, -7, 0,
    -6, 0, -2, -3, 0, 0, -3, 0,
    0, 3, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -9, 0, -6,
    -4, 0, -8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -17, 0, -4, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -9, 0,
    0, 0, 0, -48, -51, 0, 0, -17,
    -6, -52, -3, 4, 0, 4, 3, 0,
    4, 0, 0, -25, -22, 0, -24, -22,
    -16, -25, 0, -21, -16, -12, -17, -13,
    0, 0, 0, 0, 4, 0, -49, -8,
    0, 0, -16, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4, -10, -10,
    0, 0, -10, -7, 0, 0, -6, -2,
    0, 0, 0, 4, 0, 0, 0, 3,
    0, -27, -13, 0, 0, -9, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    3, -7, -7, 0, 0, -7, -5, 0,
    0, -4, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, -5, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    -5, 0, 0, 0, -5, -7, 0, 0,
    0, 0, 0, 0, -7, 4, -11, -46,
    -11, 0, 0, -21, -6, -21, -3, 4,
    -21, 4, 4, 3, 4, 0, 4, -16,
    -14, -5, -9, -14, -9, -13, -5, -9,
    -4, 0, -5, -7, 4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, 0, -5, 0,
    0, 0, -4, -6, -6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -15, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, -3, -3,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    4, 0, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 4, 0, -23, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -30, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    -5, -3, 0, 0, 4, 0, 0, 0,
    -27, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -9, -4, 3, 0, -4, 0, 0, 11,
    0, 4, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, -23, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, -3,
    3, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -27, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 35,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 2,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_roboto_28 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 32,          /*The maximum line height required by the font*/
    .base_line = 7,             /*Baseline measured from the bottom of the line*/
    .subpx = LV_FONT_SUBPX_NONE,
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if LV_FONT_ROBOTO_28*/

