﻿/* gpio_ctrl.h */
#ifndef __GPIO_CTRL_H__
#define __GPIO_CTRL_H__

#include "fsl_common.h"

#define GPIO_CS_PIN_NUM 1u

typedef enum
{
    eGPIO_CsPinMode_QuasiBidirectionalOutput = 0u, /* not support yet. */
    eGPIO_CsPinMode_PullUpOutput = 1u,
    eGPIO_CsPinMode_InputOnly = 2u,
    eGPIO_CsPinMode_OpenDrainOutput = 3u,
    eGPIO_CsPinMode_SpiCsOutput = eGPIO_CsPinMode_PullUpOutput, /* normal output. */
} gpio_cs_pin_mode_t;

void gpio_cs_pin_init(uint8_t pins);
void gpio_cs_pin_set_pin_mode(uint8_t pin, gpio_cs_pin_mode_t mode);
void gpio_cs_pin_write_1(uint8_t pins);
void gpio_cs_pin_write_0(uint8_t pins);
uint8_t gpio_cs_pin_read(uint8_t pins);

void gpio_int_pin_init(void);
void gpio_int_pin_set(void); /* write 0. */
void gpio_int_pin_clear(void); /* write 1. */

#endif /* __GPIO_CTRL_H__ */

