/*
 * Copyright  2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v4.1
processor: LPC802
package_id: LPC802M001JDH20
mcu_data: ksdk2_0
processor_version: 0.0.0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "board_gpio.h"
#include "fsl_gpio.h"
#include "fsl_swm.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '6', peripheral: USART0, signal: TXD, pin_signal: PIO0_4/ADC_11}
  - {pin_num: '19', peripheral: USART0, signal: RXD, pin_signal: PIO0_0/ACMP_I1}
  - {pin_num: '1', peripheral: SPI0, signal: SCK, pin_signal: PIO0_16/ACMP_I4/ADC_3}
  - {pin_num: '9', peripheral: SPI0, signal: SSEL0, pin_signal: PIO0_11/ADC_6/WKTCLKIN}
  - {pin_num: '20', peripheral: SPI0, signal: MISO, pin_signal: PIO0_14/ACMP_I3/ADC_2}
  - {pin_num: '3', peripheral: SPI0, signal: MOSI, pin_signal: PIO0_13/ADC_10}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M0P */
void BOARD_InitPins(void)
{
	//Define the init structure for the output pin
  gpio_pin_config_t output_config = {kGPIO_DigitalOutput,0};
	
  //Enables clock for switch matrix.: enable 
  CLOCK_EnableClock(kCLOCK_Swm);

	//USART0_TXD connect to P0_4
	SWM_SetMovablePinSelect(SWM0, kSWM_USART0_TXD, kSWM_PortPin_P0_4);
  //USART0_RXD connect to P0_0
	SWM_SetMovablePinSelect(SWM0, kSWM_USART0_RXD, kSWM_PortPin_P0_0);

	//USART1_TXD connect to P0_15
	SWM_SetMovablePinSelect(SWM0, kSWM_USART1_TXD, kSWM_PortPin_P0_15);
	//USART1_RXD connect to P0_16
	SWM_SetMovablePinSelect(SWM0, kSWM_USART1_RXD, kSWM_PortPin_P0_16);

	//SPI0_SCK connect to P0_14
	SWM_SetMovablePinSelect(SWM0, kSWM_SPI0_SCK, kSWM_PortPin_P0_14);
  //SPI0_MOSI connect to P0_13
	SWM_SetMovablePinSelect(SWM0, kSWM_SPI0_MOSI, kSWM_PortPin_P0_13);
	//SPI0_MISO connect to P0_1
	SWM_SetMovablePinSelect(SWM0, kSWM_SPI0_MISO, kSWM_PortPin_P0_1);
  //SPI0_SSEL0 connect to P0_11
	SWM_SetMovablePinSelect(SWM0, kSWM_SPI0_SSEL0, kSWM_PortPin_P0_11);

	//Disable clock for switch matrix
	CLOCK_DisableClock(kCLOCK_Swm);
	
	//Initialize GPIO Port 0
	GPIO_PortInit(GPIO_BASE_ADDR, GPIO_Port_NUM);
	
	//Initialize pin 7 on port 0 as output and output logic high by default
  GPIO_PinInit(GPIO_BASE_ADDR, GPIO_Port_NUM, IRQ_PIN_NUM, &output_config);
  GPIO_PinWrite(GPIO_BASE_ADDR, GPIO_Port_NUM, IRQ_PIN_NUM, LOGIC_HIGH);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
