/*
 * Copyright  2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "clock_config.h"
#include "board_spi.h"
#include "board_usart.h"
#include "board_ctimer.h"
#include "pin_mux.h"
#include "spi_to_dual_usart_bridge.h"

/*******************************************************************************
 * Variables
 ******************************************************************************/
uint8_t prompt[] = "SPI-USART bridge demo starts up!\r\n";

/*!
 * brief  main entry
 * param  void
 * return int
 */
int main(void)
{
	//Attach main clock to USART0
  CLOCK_Select(kUART0_Clk_From_MainClk);
	//Attach main clock to USART1
	CLOCK_Select(kUART1_Clk_From_MainClk);
  //Attach main clock to SPI
  CLOCK_Select(kSPI_Clk_From_MainClk);
	
	//Input/Ouput Pin initialization
  BOARD_InitBootPins();
	//System clock initialization
  BOARD_InitBootClocks();
  //Initialize usart
  BOARD_UsartInit();
  //Initialize SPI slave
  BOARD_SPISlaveInit();
	//Initalize bridge register
	initalizeBridgeRegister();
	//Configure software watchdog
	BOARD_ConfigSoftWDT();
	
  BOARD_UsartSendData(USART0, prompt, sizeof(prompt) - 1);
  while(1)
  {
		//update data transmission parameter
		updateDataTransferParameter();
		//process time out
		processTimeOut();
		//process data from SPI host
		processDataFromSPIHost();
  }
}

