/*
 * Copyright (c) 2013 - 2014, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __WLAN_QCOM_TFTP_H__
#define __WLAN_QCOM_TFTP_H__

#include <stdint.h>

#define OPCODE_PRQ (1)
#define OPCODE_WRQ (2)
#define OPCODE_DATA (3)
#define OPCODE_ACK (4)
#define OPCODE_ERR (5)

#define BLOCK_SIZE (512)
#define DATA_PACK_HD_LEN (4)


typedef struct _tftp_PWRQ_pack
{
	uint16_t opcode;
	char *file_name;
	uint8_t reserved0;
	char *mode;
	uint8_t reserved1;
} tftp_PWRQ_pack_t;

typedef struct _tftp_data_pack
{
	uint16_t opcode;
	uint16_t data_no;
	uint8_t data[];
} _tftp_data_pack_t;

typedef struct _tftp_ack_pack
{
	uint16_t opcode;
	uint16_t data_no;
} _tftp_ack_pack_t;

typedef struct _tftp_err_pack
{
	uint16_t opcode;
	uint16_t err_code;
	char *err_msg;
} _tftp_err_pack_t;

int isTFTPPinged(void);
uint32_t pingTFTP(void);
int tftpPRQ(char *file_name);
int tftpGet(int timeout, char * *buf, int *buf_len);
int tftpACK(char *block_no);
void tftpStop(void);

#endif
