/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_debug_console.h"
#include "board.h"
#include "fsl_flashiap.h"
#include "fsl_common.h"
#include "pin_mux.h"

#include "flashiap.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/
static uint32_t s_start_sect, s_end_sect;
/*******************************************************************************
 * Code
 ******************************************************************************/

uint32_t prepare_programing(uint32_t startSector, uint32_t endSector)
{
	uint32_t status;

	/* Erase sector before writing */
	FLASHIAP_PrepareSectorForWrite(startSector, endSector);
	__disable_irq();
	FLASHIAP_EraseSector(startSector, endSector, SystemCoreClock);
	__enable_irq();
	status = FLASHIAP_BlankCheckSector(startSector, endSector);
	if(status != kStatus_FLASHIAP_Success)
	{
		return status;
	}

	s_start_sect = startSector;
	s_end_sect = endSector;

	return kStatus_FLASHIAP_Success;
}

uint32_t program_image_page(uint32_t addr, uint8_t *page_data)
{
	uint32_t status;


	FLASHIAP_PrepareSectorForWrite(s_start_sect, s_end_sect);
    /* write a page */
		__disable_irq();
    FLASHIAP_CopyRamToFlash(addr, (uint32_t *)(&page_data[0]),
                            FSL_FEATURE_SYSCON_FLASH_PAGE_SIZE_BYTES, SystemCoreClock);
		__enable_irq();
    /* Verify */
    status = FLASHIAP_Compare(addr, (uint32_t *)(&page_data[0]),
                              FSL_FEATURE_SYSCON_FLASH_PAGE_SIZE_BYTES);
    if (status != kStatus_FLASHIAP_Success)
    {
        return status;
    }
    return kStatus_FLASHIAP_Success;
}


