/*
 * The Clear BSD License
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer below) provided
 * that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS LICENSE.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef SPIFLASH_H
#define SPIFLASH_H
#include "fsl_common.h"

#define PAGE_SIZE (256)
#define SECTOR_4KB_SIZE (4096)
#define SECTOR_32KB_SIZE (32768)
#define SECTOR_SIZE (65536)
#define PAGE_COUNT (32768) 

#define COMMAND_NUM (8)
#define READ (0)
#define PROGRAM_PAGE (1)
#define GET_STATUS (2)
#define ERASE_4KB_SECTOR (3)
#define ERASE_32KB_SECTOR (4)
#define ERASE_64KB_SECTOR (5)
#define WRITE_ENABLE (6)
#define WRITE_REGISTER (7)

typedef enum {
  SPI_FLASH_MODE_UNKNOWN,
  SPI_FLASH_MODE_MEMORY,
  SPI_FLASH_MODE_COMMAND
} SPI_FLASH_MODE;

typedef enum {
  SPI_FLASH_ERASE_SECTOR_4KB,
  SPI_FLASH_ERASE_SECTOR_32KB,
  SPI_FLASH_ERASE_SECTOR_64KB
} SPI_FLASH_ERASE_SECTOR_OPTION;

#ifdef __cplusplus
extern "C" {
#endif

int8_t spi_flash_init(clock_attach_id_t spiclksrc);

int8_t spi_flash_setmode(SPI_FLASH_MODE mode);

void spi_flash_enable_quad_mode(void);

int8_t spi_flash_erase_sector(uint32_t sectornum, SPI_FLASH_ERASE_SECTOR_OPTION option);

int8_t spi_flash_program_page(uint32_t pagenum, uint8_t *pbuffer);

void spifi_mem_read(uint32_t addr, uint8_t *data, uint32_t size);



#ifdef __cplusplus
}
#endif
#endif

