// Copyright (c) Qualcomm Atheros, Inc.
// All rights reserved.
// Redistribution and use in source and binary forms, with or without modification, are permitted (subject to
// the limitations in the disclaimer below) provided that the following conditions are met:
//
//  Redistributions of source code must retain the above copyright notice, this list of conditions and the
//   following disclaimer.
//  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
//   following disclaimer in the documentation and/or other materials provided with the distribution.
//  Neither the name of nor the names of its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
//
// NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS LICENSE. THIS SOFTWARE IS
// PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
// BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
// ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//==============================================================================
// Author(s): ="Atheros"
//==============================================================================

#ifndef _RTC_WLAN_REG_REG_H_
#define _RTC_WLAN_REG_REG_H_

#define WLAN_RESET_CONTROL_ADDRESS 0x00000000
#define WLAN_RESET_CONTROL_OFFSET 0x00000000
#define WLAN_RESET_CONTROL_DEBUG_UART_RST_MSB 14
#define WLAN_RESET_CONTROL_DEBUG_UART_RST_LSB 14
#define WLAN_RESET_CONTROL_DEBUG_UART_RST_MASK 0x00004000
#define WLAN_RESET_CONTROL_DEBUG_UART_RST_GET(x) \
    (((x)&WLAN_RESET_CONTROL_DEBUG_UART_RST_MASK) >> WLAN_RESET_CONTROL_DEBUG_UART_RST_LSB)
#define WLAN_RESET_CONTROL_DEBUG_UART_RST_SET(x) \
    (((x) << WLAN_RESET_CONTROL_DEBUG_UART_RST_LSB) & WLAN_RESET_CONTROL_DEBUG_UART_RST_MASK)
#define WLAN_RESET_CONTROL_BB_COLD_RST_MSB 13
#define WLAN_RESET_CONTROL_BB_COLD_RST_LSB 13
#define WLAN_RESET_CONTROL_BB_COLD_RST_MASK 0x00002000
#define WLAN_RESET_CONTROL_BB_COLD_RST_GET(x) \
    (((x)&WLAN_RESET_CONTROL_BB_COLD_RST_MASK) >> WLAN_RESET_CONTROL_BB_COLD_RST_LSB)
#define WLAN_RESET_CONTROL_BB_COLD_RST_SET(x) \
    (((x) << WLAN_RESET_CONTROL_BB_COLD_RST_LSB) & WLAN_RESET_CONTROL_BB_COLD_RST_MASK)
#define WLAN_RESET_CONTROL_BB_WARM_RST_MSB 12
#define WLAN_RESET_CONTROL_BB_WARM_RST_LSB 12
#define WLAN_RESET_CONTROL_BB_WARM_RST_MASK 0x00001000
#define WLAN_RESET_CONTROL_BB_WARM_RST_GET(x) \
    (((x)&WLAN_RESET_CONTROL_BB_WARM_RST_MASK) >> WLAN_RESET_CONTROL_BB_WARM_RST_LSB)
#define WLAN_RESET_CONTROL_BB_WARM_RST_SET(x) \
    (((x) << WLAN_RESET_CONTROL_BB_WARM_RST_LSB) & WLAN_RESET_CONTROL_BB_WARM_RST_MASK)
#define WLAN_RESET_CONTROL_CPU_INIT_RESET_MSB 11
#define WLAN_RESET_CONTROL_CPU_INIT_RESET_LSB 11
#define WLAN_RESET_CONTROL_CPU_INIT_RESET_MASK 0x00000800
#define WLAN_RESET_CONTROL_CPU_INIT_RESET_GET(x) \
    (((x)&WLAN_RESET_CONTROL_CPU_INIT_RESET_MASK) >> WLAN_RESET_CONTROL_CPU_INIT_RESET_LSB)
#define WLAN_RESET_CONTROL_CPU_INIT_RESET_SET(x) \
    (((x) << WLAN_RESET_CONTROL_CPU_INIT_RESET_LSB) & WLAN_RESET_CONTROL_CPU_INIT_RESET_MASK)
#define WLAN_RESET_CONTROL_VMC_REMAP_RESET_MSB 10
#define WLAN_RESET_CONTROL_VMC_REMAP_RESET_LSB 10
#define WLAN_RESET_CONTROL_VMC_REMAP_RESET_MASK 0x00000400
#define WLAN_RESET_CONTROL_VMC_REMAP_RESET_GET(x) \
    (((x)&WLAN_RESET_CONTROL_VMC_REMAP_RESET_MASK) >> WLAN_RESET_CONTROL_VMC_REMAP_RESET_LSB)
#define WLAN_RESET_CONTROL_VMC_REMAP_RESET_SET(x) \
    (((x) << WLAN_RESET_CONTROL_VMC_REMAP_RESET_LSB) & WLAN_RESET_CONTROL_VMC_REMAP_RESET_MASK)
#define WLAN_RESET_CONTROL_RST_OUT_MSB 9
#define WLAN_RESET_CONTROL_RST_OUT_LSB 9
#define WLAN_RESET_CONTROL_RST_OUT_MASK 0x00000200
#define WLAN_RESET_CONTROL_RST_OUT_GET(x) (((x)&WLAN_RESET_CONTROL_RST_OUT_MASK) >> WLAN_RESET_CONTROL_RST_OUT_LSB)
#define WLAN_RESET_CONTROL_RST_OUT_SET(x) (((x) << WLAN_RESET_CONTROL_RST_OUT_LSB) & WLAN_RESET_CONTROL_RST_OUT_MASK)
#define WLAN_RESET_CONTROL_COLD_RST_MSB 8
#define WLAN_RESET_CONTROL_COLD_RST_LSB 8
#define WLAN_RESET_CONTROL_COLD_RST_MASK 0x00000100
#define WLAN_RESET_CONTROL_COLD_RST_GET(x) (((x)&WLAN_RESET_CONTROL_COLD_RST_MASK) >> WLAN_RESET_CONTROL_COLD_RST_LSB)
#define WLAN_RESET_CONTROL_COLD_RST_SET(x) (((x) << WLAN_RESET_CONTROL_COLD_RST_LSB) & WLAN_RESET_CONTROL_COLD_RST_MASK)
#define WLAN_RESET_CONTROL_WARM_RST_MSB 7
#define WLAN_RESET_CONTROL_WARM_RST_LSB 7
#define WLAN_RESET_CONTROL_WARM_RST_MASK 0x00000080
#define WLAN_RESET_CONTROL_WARM_RST_GET(x) (((x)&WLAN_RESET_CONTROL_WARM_RST_MASK) >> WLAN_RESET_CONTROL_WARM_RST_LSB)
#define WLAN_RESET_CONTROL_WARM_RST_SET(x) (((x) << WLAN_RESET_CONTROL_WARM_RST_LSB) & WLAN_RESET_CONTROL_WARM_RST_MASK)
#define WLAN_RESET_CONTROL_CPU_WARM_RST_MSB 6
#define WLAN_RESET_CONTROL_CPU_WARM_RST_LSB 6
#define WLAN_RESET_CONTROL_CPU_WARM_RST_MASK 0x00000040
#define WLAN_RESET_CONTROL_CPU_WARM_RST_GET(x) \
    (((x)&WLAN_RESET_CONTROL_CPU_WARM_RST_MASK) >> WLAN_RESET_CONTROL_CPU_WARM_RST_LSB)
#define WLAN_RESET_CONTROL_CPU_WARM_RST_SET(x) \
    (((x) << WLAN_RESET_CONTROL_CPU_WARM_RST_LSB) & WLAN_RESET_CONTROL_CPU_WARM_RST_MASK)
#define WLAN_RESET_CONTROL_MAC_COLD_RST_MSB 5
#define WLAN_RESET_CONTROL_MAC_COLD_RST_LSB 5
#define WLAN_RESET_CONTROL_MAC_COLD_RST_MASK 0x00000020
#define WLAN_RESET_CONTROL_MAC_COLD_RST_GET(x) \
    (((x)&WLAN_RESET_CONTROL_MAC_COLD_RST_MASK) >> WLAN_RESET_CONTROL_MAC_COLD_RST_LSB)
#define WLAN_RESET_CONTROL_MAC_COLD_RST_SET(x) \
    (((x) << WLAN_RESET_CONTROL_MAC_COLD_RST_LSB) & WLAN_RESET_CONTROL_MAC_COLD_RST_MASK)
#define WLAN_RESET_CONTROL_MAC_WARM_RST_MSB 4
#define WLAN_RESET_CONTROL_MAC_WARM_RST_LSB 4
#define WLAN_RESET_CONTROL_MAC_WARM_RST_MASK 0x00000010
#define WLAN_RESET_CONTROL_MAC_WARM_RST_GET(x) \
    (((x)&WLAN_RESET_CONTROL_MAC_WARM_RST_MASK) >> WLAN_RESET_CONTROL_MAC_WARM_RST_LSB)
#define WLAN_RESET_CONTROL_MAC_WARM_RST_SET(x) \
    (((x) << WLAN_RESET_CONTROL_MAC_WARM_RST_LSB) & WLAN_RESET_CONTROL_MAC_WARM_RST_MASK)
#define WLAN_RESET_CONTROL_MBOX_RST_MSB 2
#define WLAN_RESET_CONTROL_MBOX_RST_LSB 2
#define WLAN_RESET_CONTROL_MBOX_RST_MASK 0x00000004
#define WLAN_RESET_CONTROL_MBOX_RST_GET(x) (((x)&WLAN_RESET_CONTROL_MBOX_RST_MASK) >> WLAN_RESET_CONTROL_MBOX_RST_LSB)
#define WLAN_RESET_CONTROL_MBOX_RST_SET(x) (((x) << WLAN_RESET_CONTROL_MBOX_RST_LSB) & WLAN_RESET_CONTROL_MBOX_RST_MASK)
#define WLAN_RESET_CONTROL_UART_RST_MSB 1
#define WLAN_RESET_CONTROL_UART_RST_LSB 1
#define WLAN_RESET_CONTROL_UART_RST_MASK 0x00000002
#define WLAN_RESET_CONTROL_UART_RST_GET(x) (((x)&WLAN_RESET_CONTROL_UART_RST_MASK) >> WLAN_RESET_CONTROL_UART_RST_LSB)
#define WLAN_RESET_CONTROL_UART_RST_SET(x) (((x) << WLAN_RESET_CONTROL_UART_RST_LSB) & WLAN_RESET_CONTROL_UART_RST_MASK)
#define WLAN_RESET_CONTROL_SI0_RST_MSB 0
#define WLAN_RESET_CONTROL_SI0_RST_LSB 0
#define WLAN_RESET_CONTROL_SI0_RST_MASK 0x00000001
#define WLAN_RESET_CONTROL_SI0_RST_GET(x) (((x)&WLAN_RESET_CONTROL_SI0_RST_MASK) >> WLAN_RESET_CONTROL_SI0_RST_LSB)
#define WLAN_RESET_CONTROL_SI0_RST_SET(x) (((x) << WLAN_RESET_CONTROL_SI0_RST_LSB) & WLAN_RESET_CONTROL_SI0_RST_MASK)

#define WLAN_XTAL_CONTROL_ADDRESS 0x00000004
#define WLAN_XTAL_CONTROL_OFFSET 0x00000004
#define WLAN_XTAL_CONTROL_TCXO_MSB 0
#define WLAN_XTAL_CONTROL_TCXO_LSB 0
#define WLAN_XTAL_CONTROL_TCXO_MASK 0x00000001
#define WLAN_XTAL_CONTROL_TCXO_GET(x) (((x)&WLAN_XTAL_CONTROL_TCXO_MASK) >> WLAN_XTAL_CONTROL_TCXO_LSB)
#define WLAN_XTAL_CONTROL_TCXO_SET(x) (((x) << WLAN_XTAL_CONTROL_TCXO_LSB) & WLAN_XTAL_CONTROL_TCXO_MASK)

#define WLAN_TCXO_DETECT_ADDRESS 0x00000008
#define WLAN_TCXO_DETECT_OFFSET 0x00000008
#define WLAN_TCXO_DETECT_PRESENT_MSB 0
#define WLAN_TCXO_DETECT_PRESENT_LSB 0
#define WLAN_TCXO_DETECT_PRESENT_MASK 0x00000001
#define WLAN_TCXO_DETECT_PRESENT_GET(x) (((x)&WLAN_TCXO_DETECT_PRESENT_MASK) >> WLAN_TCXO_DETECT_PRESENT_LSB)
#define WLAN_TCXO_DETECT_PRESENT_SET(x) (((x) << WLAN_TCXO_DETECT_PRESENT_LSB) & WLAN_TCXO_DETECT_PRESENT_MASK)

#define WLAN_XTAL_TEST_ADDRESS 0x0000000c
#define WLAN_XTAL_TEST_OFFSET 0x0000000c
#define WLAN_XTAL_TEST_NOTCXODET_MSB 0
#define WLAN_XTAL_TEST_NOTCXODET_LSB 0
#define WLAN_XTAL_TEST_NOTCXODET_MASK 0x00000001
#define WLAN_XTAL_TEST_NOTCXODET_GET(x) (((x)&WLAN_XTAL_TEST_NOTCXODET_MASK) >> WLAN_XTAL_TEST_NOTCXODET_LSB)
#define WLAN_XTAL_TEST_NOTCXODET_SET(x) (((x) << WLAN_XTAL_TEST_NOTCXODET_LSB) & WLAN_XTAL_TEST_NOTCXODET_MASK)

#define WLAN_QUADRATURE_ADDRESS 0x00000010
#define WLAN_QUADRATURE_OFFSET 0x00000010
#define WLAN_QUADRATURE_ADC_MSB 7
#define WLAN_QUADRATURE_ADC_LSB 4
#define WLAN_QUADRATURE_ADC_MASK 0x000000f0
#define WLAN_QUADRATURE_ADC_GET(x) (((x)&WLAN_QUADRATURE_ADC_MASK) >> WLAN_QUADRATURE_ADC_LSB)
#define WLAN_QUADRATURE_ADC_SET(x) (((x) << WLAN_QUADRATURE_ADC_LSB) & WLAN_QUADRATURE_ADC_MASK)
#define WLAN_QUADRATURE_SEL_MSB 2
#define WLAN_QUADRATURE_SEL_LSB 2
#define WLAN_QUADRATURE_SEL_MASK 0x00000004
#define WLAN_QUADRATURE_SEL_GET(x) (((x)&WLAN_QUADRATURE_SEL_MASK) >> WLAN_QUADRATURE_SEL_LSB)
#define WLAN_QUADRATURE_SEL_SET(x) (((x) << WLAN_QUADRATURE_SEL_LSB) & WLAN_QUADRATURE_SEL_MASK)
#define WLAN_QUADRATURE_DAC_MSB 1
#define WLAN_QUADRATURE_DAC_LSB 0
#define WLAN_QUADRATURE_DAC_MASK 0x00000003
#define WLAN_QUADRATURE_DAC_GET(x) (((x)&WLAN_QUADRATURE_DAC_MASK) >> WLAN_QUADRATURE_DAC_LSB)
#define WLAN_QUADRATURE_DAC_SET(x) (((x) << WLAN_QUADRATURE_DAC_LSB) & WLAN_QUADRATURE_DAC_MASK)

#define WLAN_PLL_CONTROL_ADDRESS 0x00000014
#define WLAN_PLL_CONTROL_OFFSET 0x00000014
#define WLAN_PLL_CONTROL_DIG_TEST_CLK_MSB 20
#define WLAN_PLL_CONTROL_DIG_TEST_CLK_LSB 20
#define WLAN_PLL_CONTROL_DIG_TEST_CLK_MASK 0x00100000
#define WLAN_PLL_CONTROL_DIG_TEST_CLK_GET(x) \
    (((x)&WLAN_PLL_CONTROL_DIG_TEST_CLK_MASK) >> WLAN_PLL_CONTROL_DIG_TEST_CLK_LSB)
#define WLAN_PLL_CONTROL_DIG_TEST_CLK_SET(x) \
    (((x) << WLAN_PLL_CONTROL_DIG_TEST_CLK_LSB) & WLAN_PLL_CONTROL_DIG_TEST_CLK_MASK)
#define WLAN_PLL_CONTROL_MAC_OVERRIDE_MSB 19
#define WLAN_PLL_CONTROL_MAC_OVERRIDE_LSB 19
#define WLAN_PLL_CONTROL_MAC_OVERRIDE_MASK 0x00080000
#define WLAN_PLL_CONTROL_MAC_OVERRIDE_GET(x) \
    (((x)&WLAN_PLL_CONTROL_MAC_OVERRIDE_MASK) >> WLAN_PLL_CONTROL_MAC_OVERRIDE_LSB)
#define WLAN_PLL_CONTROL_MAC_OVERRIDE_SET(x) \
    (((x) << WLAN_PLL_CONTROL_MAC_OVERRIDE_LSB) & WLAN_PLL_CONTROL_MAC_OVERRIDE_MASK)
#define WLAN_PLL_CONTROL_NOPWD_MSB 18
#define WLAN_PLL_CONTROL_NOPWD_LSB 18
#define WLAN_PLL_CONTROL_NOPWD_MASK 0x00040000
#define WLAN_PLL_CONTROL_NOPWD_GET(x) (((x)&WLAN_PLL_CONTROL_NOPWD_MASK) >> WLAN_PLL_CONTROL_NOPWD_LSB)
#define WLAN_PLL_CONTROL_NOPWD_SET(x) (((x) << WLAN_PLL_CONTROL_NOPWD_LSB) & WLAN_PLL_CONTROL_NOPWD_MASK)
#define WLAN_PLL_CONTROL_UPDATING_MSB 17
#define WLAN_PLL_CONTROL_UPDATING_LSB 17
#define WLAN_PLL_CONTROL_UPDATING_MASK 0x00020000
#define WLAN_PLL_CONTROL_UPDATING_GET(x) (((x)&WLAN_PLL_CONTROL_UPDATING_MASK) >> WLAN_PLL_CONTROL_UPDATING_LSB)
#define WLAN_PLL_CONTROL_UPDATING_SET(x) (((x) << WLAN_PLL_CONTROL_UPDATING_LSB) & WLAN_PLL_CONTROL_UPDATING_MASK)
#define WLAN_PLL_CONTROL_BYPASS_MSB 16
#define WLAN_PLL_CONTROL_BYPASS_LSB 16
#define WLAN_PLL_CONTROL_BYPASS_MASK 0x00010000
#define WLAN_PLL_CONTROL_BYPASS_GET(x) (((x)&WLAN_PLL_CONTROL_BYPASS_MASK) >> WLAN_PLL_CONTROL_BYPASS_LSB)
#define WLAN_PLL_CONTROL_BYPASS_SET(x) (((x) << WLAN_PLL_CONTROL_BYPASS_LSB) & WLAN_PLL_CONTROL_BYPASS_MASK)
#define WLAN_PLL_CONTROL_REFDIV_MSB 15
#define WLAN_PLL_CONTROL_REFDIV_LSB 12
#define WLAN_PLL_CONTROL_REFDIV_MASK 0x0000f000
#define WLAN_PLL_CONTROL_REFDIV_GET(x) (((x)&WLAN_PLL_CONTROL_REFDIV_MASK) >> WLAN_PLL_CONTROL_REFDIV_LSB)
#define WLAN_PLL_CONTROL_REFDIV_SET(x) (((x) << WLAN_PLL_CONTROL_REFDIV_LSB) & WLAN_PLL_CONTROL_REFDIV_MASK)
#define WLAN_PLL_CONTROL_DIV_MSB 9
#define WLAN_PLL_CONTROL_DIV_LSB 0
#define WLAN_PLL_CONTROL_DIV_MASK 0x000003ff
#define WLAN_PLL_CONTROL_DIV_GET(x) (((x)&WLAN_PLL_CONTROL_DIV_MASK) >> WLAN_PLL_CONTROL_DIV_LSB)
#define WLAN_PLL_CONTROL_DIV_SET(x) (((x) << WLAN_PLL_CONTROL_DIV_LSB) & WLAN_PLL_CONTROL_DIV_MASK)

#define WLAN_PLL_SETTLE_ADDRESS 0x00000018
#define WLAN_PLL_SETTLE_OFFSET 0x00000018
#define WLAN_PLL_SETTLE_TIME_MSB 11
#define WLAN_PLL_SETTLE_TIME_LSB 0
#define WLAN_PLL_SETTLE_TIME_MASK 0x00000fff
#define WLAN_PLL_SETTLE_TIME_GET(x) (((x)&WLAN_PLL_SETTLE_TIME_MASK) >> WLAN_PLL_SETTLE_TIME_LSB)
#define WLAN_PLL_SETTLE_TIME_SET(x) (((x) << WLAN_PLL_SETTLE_TIME_LSB) & WLAN_PLL_SETTLE_TIME_MASK)

#define WLAN_XTAL_SETTLE_ADDRESS 0x0000001c
#define WLAN_XTAL_SETTLE_OFFSET 0x0000001c
#define WLAN_XTAL_SETTLE_TIME_MSB 7
#define WLAN_XTAL_SETTLE_TIME_LSB 0
#define WLAN_XTAL_SETTLE_TIME_MASK 0x000000ff
#define WLAN_XTAL_SETTLE_TIME_GET(x) (((x)&WLAN_XTAL_SETTLE_TIME_MASK) >> WLAN_XTAL_SETTLE_TIME_LSB)
#define WLAN_XTAL_SETTLE_TIME_SET(x) (((x) << WLAN_XTAL_SETTLE_TIME_LSB) & WLAN_XTAL_SETTLE_TIME_MASK)

#define WLAN_CPU_CLOCK_ADDRESS 0x00000020
#define WLAN_CPU_CLOCK_OFFSET 0x00000020
#define WLAN_CPU_CLOCK_STANDARD_MSB 1
#define WLAN_CPU_CLOCK_STANDARD_LSB 0
#define WLAN_CPU_CLOCK_STANDARD_MASK 0x00000003
#define WLAN_CPU_CLOCK_STANDARD_GET(x) (((x)&WLAN_CPU_CLOCK_STANDARD_MASK) >> WLAN_CPU_CLOCK_STANDARD_LSB)
#define WLAN_CPU_CLOCK_STANDARD_SET(x) (((x) << WLAN_CPU_CLOCK_STANDARD_LSB) & WLAN_CPU_CLOCK_STANDARD_MASK)

#define WLAN_CLOCK_OUT_ADDRESS 0x00000024
#define WLAN_CLOCK_OUT_OFFSET 0x00000024
#define WLAN_CLOCK_OUT_SELECT_MSB 3
#define WLAN_CLOCK_OUT_SELECT_LSB 0
#define WLAN_CLOCK_OUT_SELECT_MASK 0x0000000f
#define WLAN_CLOCK_OUT_SELECT_GET(x) (((x)&WLAN_CLOCK_OUT_SELECT_MASK) >> WLAN_CLOCK_OUT_SELECT_LSB)
#define WLAN_CLOCK_OUT_SELECT_SET(x) (((x) << WLAN_CLOCK_OUT_SELECT_LSB) & WLAN_CLOCK_OUT_SELECT_MASK)

#define WLAN_CLOCK_CONTROL_ADDRESS 0x00000028
#define WLAN_CLOCK_CONTROL_OFFSET 0x00000028
#define WLAN_CLOCK_CONTROL_LF_CLK32_MSB 2
#define WLAN_CLOCK_CONTROL_LF_CLK32_LSB 2
#define WLAN_CLOCK_CONTROL_LF_CLK32_MASK 0x00000004
#define WLAN_CLOCK_CONTROL_LF_CLK32_GET(x) (((x)&WLAN_CLOCK_CONTROL_LF_CLK32_MASK) >> WLAN_CLOCK_CONTROL_LF_CLK32_LSB)
#define WLAN_CLOCK_CONTROL_LF_CLK32_SET(x) (((x) << WLAN_CLOCK_CONTROL_LF_CLK32_LSB) & WLAN_CLOCK_CONTROL_LF_CLK32_MASK)
#define WLAN_CLOCK_CONTROL_SI0_CLK_MSB 0
#define WLAN_CLOCK_CONTROL_SI0_CLK_LSB 0
#define WLAN_CLOCK_CONTROL_SI0_CLK_MASK 0x00000001
#define WLAN_CLOCK_CONTROL_SI0_CLK_GET(x) (((x)&WLAN_CLOCK_CONTROL_SI0_CLK_MASK) >> WLAN_CLOCK_CONTROL_SI0_CLK_LSB)
#define WLAN_CLOCK_CONTROL_SI0_CLK_SET(x) (((x) << WLAN_CLOCK_CONTROL_SI0_CLK_LSB) & WLAN_CLOCK_CONTROL_SI0_CLK_MASK)

#define WLAN_BIAS_OVERRIDE_ADDRESS 0x0000002c
#define WLAN_BIAS_OVERRIDE_OFFSET 0x0000002c
#define WLAN_BIAS_OVERRIDE_ON_MSB 0
#define WLAN_BIAS_OVERRIDE_ON_LSB 0
#define WLAN_BIAS_OVERRIDE_ON_MASK 0x00000001
#define WLAN_BIAS_OVERRIDE_ON_GET(x) (((x)&WLAN_BIAS_OVERRIDE_ON_MASK) >> WLAN_BIAS_OVERRIDE_ON_LSB)
#define WLAN_BIAS_OVERRIDE_ON_SET(x) (((x) << WLAN_BIAS_OVERRIDE_ON_LSB) & WLAN_BIAS_OVERRIDE_ON_MASK)

#define WLAN_WDT_CONTROL_ADDRESS 0x00000030
#define WLAN_WDT_CONTROL_OFFSET 0x00000030
#define WLAN_WDT_CONTROL_ACTION_MSB 2
#define WLAN_WDT_CONTROL_ACTION_LSB 0
#define WLAN_WDT_CONTROL_ACTION_MASK 0x00000007
#define WLAN_WDT_CONTROL_ACTION_GET(x) (((x)&WLAN_WDT_CONTROL_ACTION_MASK) >> WLAN_WDT_CONTROL_ACTION_LSB)
#define WLAN_WDT_CONTROL_ACTION_SET(x) (((x) << WLAN_WDT_CONTROL_ACTION_LSB) & WLAN_WDT_CONTROL_ACTION_MASK)

#define WLAN_WDT_STATUS_ADDRESS 0x00000034
#define WLAN_WDT_STATUS_OFFSET 0x00000034
#define WLAN_WDT_STATUS_INTERRUPT_MSB 0
#define WLAN_WDT_STATUS_INTERRUPT_LSB 0
#define WLAN_WDT_STATUS_INTERRUPT_MASK 0x00000001
#define WLAN_WDT_STATUS_INTERRUPT_GET(x) (((x)&WLAN_WDT_STATUS_INTERRUPT_MASK) >> WLAN_WDT_STATUS_INTERRUPT_LSB)
#define WLAN_WDT_STATUS_INTERRUPT_SET(x) (((x) << WLAN_WDT_STATUS_INTERRUPT_LSB) & WLAN_WDT_STATUS_INTERRUPT_MASK)

#define WLAN_WDT_ADDRESS 0x00000038
#define WLAN_WDT_OFFSET 0x00000038
#define WLAN_WDT_TARGET_MSB 21
#define WLAN_WDT_TARGET_LSB 0
#define WLAN_WDT_TARGET_MASK 0x003fffff
#define WLAN_WDT_TARGET_GET(x) (((x)&WLAN_WDT_TARGET_MASK) >> WLAN_WDT_TARGET_LSB)
#define WLAN_WDT_TARGET_SET(x) (((x) << WLAN_WDT_TARGET_LSB) & WLAN_WDT_TARGET_MASK)

#define WLAN_WDT_COUNT_ADDRESS 0x0000003c
#define WLAN_WDT_COUNT_OFFSET 0x0000003c
#define WLAN_WDT_COUNT_VALUE_MSB 21
#define WLAN_WDT_COUNT_VALUE_LSB 0
#define WLAN_WDT_COUNT_VALUE_MASK 0x003fffff
#define WLAN_WDT_COUNT_VALUE_GET(x) (((x)&WLAN_WDT_COUNT_VALUE_MASK) >> WLAN_WDT_COUNT_VALUE_LSB)
#define WLAN_WDT_COUNT_VALUE_SET(x) (((x) << WLAN_WDT_COUNT_VALUE_LSB) & WLAN_WDT_COUNT_VALUE_MASK)

#define WLAN_WDT_RESET_ADDRESS 0x00000040
#define WLAN_WDT_RESET_OFFSET 0x00000040
#define WLAN_WDT_RESET_VALUE_MSB 0
#define WLAN_WDT_RESET_VALUE_LSB 0
#define WLAN_WDT_RESET_VALUE_MASK 0x00000001
#define WLAN_WDT_RESET_VALUE_GET(x) (((x)&WLAN_WDT_RESET_VALUE_MASK) >> WLAN_WDT_RESET_VALUE_LSB)
#define WLAN_WDT_RESET_VALUE_SET(x) (((x) << WLAN_WDT_RESET_VALUE_LSB) & WLAN_WDT_RESET_VALUE_MASK)

#define WLAN_INT_STATUS_ADDRESS 0x00000044
#define WLAN_INT_STATUS_OFFSET 0x00000044
#define WLAN_INT_STATUS_HCI_UART_MSB 21
#define WLAN_INT_STATUS_HCI_UART_LSB 21
#define WLAN_INT_STATUS_HCI_UART_MASK 0x00200000
#define WLAN_INT_STATUS_HCI_UART_GET(x) (((x)&WLAN_INT_STATUS_HCI_UART_MASK) >> WLAN_INT_STATUS_HCI_UART_LSB)
#define WLAN_INT_STATUS_HCI_UART_SET(x) (((x) << WLAN_INT_STATUS_HCI_UART_LSB) & WLAN_INT_STATUS_HCI_UART_MASK)
#define WLAN_INT_STATUS_THERM_MSB 20
#define WLAN_INT_STATUS_THERM_LSB 20
#define WLAN_INT_STATUS_THERM_MASK 0x00100000
#define WLAN_INT_STATUS_THERM_GET(x) (((x)&WLAN_INT_STATUS_THERM_MASK) >> WLAN_INT_STATUS_THERM_LSB)
#define WLAN_INT_STATUS_THERM_SET(x) (((x) << WLAN_INT_STATUS_THERM_LSB) & WLAN_INT_STATUS_THERM_MASK)
#define WLAN_INT_STATUS_EFUSE_OVERWRITE_MSB 19
#define WLAN_INT_STATUS_EFUSE_OVERWRITE_LSB 19
#define WLAN_INT_STATUS_EFUSE_OVERWRITE_MASK 0x00080000
#define WLAN_INT_STATUS_EFUSE_OVERWRITE_GET(x) \
    (((x)&WLAN_INT_STATUS_EFUSE_OVERWRITE_MASK) >> WLAN_INT_STATUS_EFUSE_OVERWRITE_LSB)
#define WLAN_INT_STATUS_EFUSE_OVERWRITE_SET(x) \
    (((x) << WLAN_INT_STATUS_EFUSE_OVERWRITE_LSB) & WLAN_INT_STATUS_EFUSE_OVERWRITE_MASK)
#define WLAN_INT_STATUS_UART_MBOX_MSB 18
#define WLAN_INT_STATUS_UART_MBOX_LSB 18
#define WLAN_INT_STATUS_UART_MBOX_MASK 0x00040000
#define WLAN_INT_STATUS_UART_MBOX_GET(x) (((x)&WLAN_INT_STATUS_UART_MBOX_MASK) >> WLAN_INT_STATUS_UART_MBOX_LSB)
#define WLAN_INT_STATUS_UART_MBOX_SET(x) (((x) << WLAN_INT_STATUS_UART_MBOX_LSB) & WLAN_INT_STATUS_UART_MBOX_MASK)
#define WLAN_INT_STATUS_GENERIC_MBOX_MSB 17
#define WLAN_INT_STATUS_GENERIC_MBOX_LSB 17
#define WLAN_INT_STATUS_GENERIC_MBOX_MASK 0x00020000
#define WLAN_INT_STATUS_GENERIC_MBOX_GET(x) \
    (((x)&WLAN_INT_STATUS_GENERIC_MBOX_MASK) >> WLAN_INT_STATUS_GENERIC_MBOX_LSB)
#define WLAN_INT_STATUS_GENERIC_MBOX_SET(x) \
    (((x) << WLAN_INT_STATUS_GENERIC_MBOX_LSB) & WLAN_INT_STATUS_GENERIC_MBOX_MASK)
#define WLAN_INT_STATUS_RDMA_MSB 16
#define WLAN_INT_STATUS_RDMA_LSB 16
#define WLAN_INT_STATUS_RDMA_MASK 0x00010000
#define WLAN_INT_STATUS_RDMA_GET(x) (((x)&WLAN_INT_STATUS_RDMA_MASK) >> WLAN_INT_STATUS_RDMA_LSB)
#define WLAN_INT_STATUS_RDMA_SET(x) (((x) << WLAN_INT_STATUS_RDMA_LSB) & WLAN_INT_STATUS_RDMA_MASK)
#define WLAN_INT_STATUS_BTCOEX_MSB 15
#define WLAN_INT_STATUS_BTCOEX_LSB 15
#define WLAN_INT_STATUS_BTCOEX_MASK 0x00008000
#define WLAN_INT_STATUS_BTCOEX_GET(x) (((x)&WLAN_INT_STATUS_BTCOEX_MASK) >> WLAN_INT_STATUS_BTCOEX_LSB)
#define WLAN_INT_STATUS_BTCOEX_SET(x) (((x) << WLAN_INT_STATUS_BTCOEX_LSB) & WLAN_INT_STATUS_BTCOEX_MASK)
#define WLAN_INT_STATUS_RTC_POWER_MSB 14
#define WLAN_INT_STATUS_RTC_POWER_LSB 14
#define WLAN_INT_STATUS_RTC_POWER_MASK 0x00004000
#define WLAN_INT_STATUS_RTC_POWER_GET(x) (((x)&WLAN_INT_STATUS_RTC_POWER_MASK) >> WLAN_INT_STATUS_RTC_POWER_LSB)
#define WLAN_INT_STATUS_RTC_POWER_SET(x) (((x) << WLAN_INT_STATUS_RTC_POWER_LSB) & WLAN_INT_STATUS_RTC_POWER_MASK)
#define WLAN_INT_STATUS_MAC_MSB 13
#define WLAN_INT_STATUS_MAC_LSB 13
#define WLAN_INT_STATUS_MAC_MASK 0x00002000
#define WLAN_INT_STATUS_MAC_GET(x) (((x)&WLAN_INT_STATUS_MAC_MASK) >> WLAN_INT_STATUS_MAC_LSB)
#define WLAN_INT_STATUS_MAC_SET(x) (((x) << WLAN_INT_STATUS_MAC_LSB) & WLAN_INT_STATUS_MAC_MASK)
#define WLAN_INT_STATUS_MAILBOX_MSB 12
#define WLAN_INT_STATUS_MAILBOX_LSB 12
#define WLAN_INT_STATUS_MAILBOX_MASK 0x00001000
#define WLAN_INT_STATUS_MAILBOX_GET(x) (((x)&WLAN_INT_STATUS_MAILBOX_MASK) >> WLAN_INT_STATUS_MAILBOX_LSB)
#define WLAN_INT_STATUS_MAILBOX_SET(x) (((x) << WLAN_INT_STATUS_MAILBOX_LSB) & WLAN_INT_STATUS_MAILBOX_MASK)
#define WLAN_INT_STATUS_RTC_ALARM_MSB 11
#define WLAN_INT_STATUS_RTC_ALARM_LSB 11
#define WLAN_INT_STATUS_RTC_ALARM_MASK 0x00000800
#define WLAN_INT_STATUS_RTC_ALARM_GET(x) (((x)&WLAN_INT_STATUS_RTC_ALARM_MASK) >> WLAN_INT_STATUS_RTC_ALARM_LSB)
#define WLAN_INT_STATUS_RTC_ALARM_SET(x) (((x) << WLAN_INT_STATUS_RTC_ALARM_LSB) & WLAN_INT_STATUS_RTC_ALARM_MASK)
#define WLAN_INT_STATUS_HF_TIMER_MSB 10
#define WLAN_INT_STATUS_HF_TIMER_LSB 10
#define WLAN_INT_STATUS_HF_TIMER_MASK 0x00000400
#define WLAN_INT_STATUS_HF_TIMER_GET(x) (((x)&WLAN_INT_STATUS_HF_TIMER_MASK) >> WLAN_INT_STATUS_HF_TIMER_LSB)
#define WLAN_INT_STATUS_HF_TIMER_SET(x) (((x) << WLAN_INT_STATUS_HF_TIMER_LSB) & WLAN_INT_STATUS_HF_TIMER_MASK)
#define WLAN_INT_STATUS_LF_TIMER3_MSB 9
#define WLAN_INT_STATUS_LF_TIMER3_LSB 9
#define WLAN_INT_STATUS_LF_TIMER3_MASK 0x00000200
#define WLAN_INT_STATUS_LF_TIMER3_GET(x) (((x)&WLAN_INT_STATUS_LF_TIMER3_MASK) >> WLAN_INT_STATUS_LF_TIMER3_LSB)
#define WLAN_INT_STATUS_LF_TIMER3_SET(x) (((x) << WLAN_INT_STATUS_LF_TIMER3_LSB) & WLAN_INT_STATUS_LF_TIMER3_MASK)
#define WLAN_INT_STATUS_LF_TIMER2_MSB 8
#define WLAN_INT_STATUS_LF_TIMER2_LSB 8
#define WLAN_INT_STATUS_LF_TIMER2_MASK 0x00000100
#define WLAN_INT_STATUS_LF_TIMER2_GET(x) (((x)&WLAN_INT_STATUS_LF_TIMER2_MASK) >> WLAN_INT_STATUS_LF_TIMER2_LSB)
#define WLAN_INT_STATUS_LF_TIMER2_SET(x) (((x) << WLAN_INT_STATUS_LF_TIMER2_LSB) & WLAN_INT_STATUS_LF_TIMER2_MASK)
#define WLAN_INT_STATUS_LF_TIMER1_MSB 7
#define WLAN_INT_STATUS_LF_TIMER1_LSB 7
#define WLAN_INT_STATUS_LF_TIMER1_MASK 0x00000080
#define WLAN_INT_STATUS_LF_TIMER1_GET(x) (((x)&WLAN_INT_STATUS_LF_TIMER1_MASK) >> WLAN_INT_STATUS_LF_TIMER1_LSB)
#define WLAN_INT_STATUS_LF_TIMER1_SET(x) (((x) << WLAN_INT_STATUS_LF_TIMER1_LSB) & WLAN_INT_STATUS_LF_TIMER1_MASK)
#define WLAN_INT_STATUS_LF_TIMER0_MSB 6
#define WLAN_INT_STATUS_LF_TIMER0_LSB 6
#define WLAN_INT_STATUS_LF_TIMER0_MASK 0x00000040
#define WLAN_INT_STATUS_LF_TIMER0_GET(x) (((x)&WLAN_INT_STATUS_LF_TIMER0_MASK) >> WLAN_INT_STATUS_LF_TIMER0_LSB)
#define WLAN_INT_STATUS_LF_TIMER0_SET(x) (((x) << WLAN_INT_STATUS_LF_TIMER0_LSB) & WLAN_INT_STATUS_LF_TIMER0_MASK)
#define WLAN_INT_STATUS_KEYPAD_MSB 5
#define WLAN_INT_STATUS_KEYPAD_LSB 5
#define WLAN_INT_STATUS_KEYPAD_MASK 0x00000020
#define WLAN_INT_STATUS_KEYPAD_GET(x) (((x)&WLAN_INT_STATUS_KEYPAD_MASK) >> WLAN_INT_STATUS_KEYPAD_LSB)
#define WLAN_INT_STATUS_KEYPAD_SET(x) (((x) << WLAN_INT_STATUS_KEYPAD_LSB) & WLAN_INT_STATUS_KEYPAD_MASK)
#define WLAN_INT_STATUS_SI_MSB 4
#define WLAN_INT_STATUS_SI_LSB 4
#define WLAN_INT_STATUS_SI_MASK 0x00000010
#define WLAN_INT_STATUS_SI_GET(x) (((x)&WLAN_INT_STATUS_SI_MASK) >> WLAN_INT_STATUS_SI_LSB)
#define WLAN_INT_STATUS_SI_SET(x) (((x) << WLAN_INT_STATUS_SI_LSB) & WLAN_INT_STATUS_SI_MASK)
#define WLAN_INT_STATUS_GPIO_MSB 3
#define WLAN_INT_STATUS_GPIO_LSB 3
#define WLAN_INT_STATUS_GPIO_MASK 0x00000008
#define WLAN_INT_STATUS_GPIO_GET(x) (((x)&WLAN_INT_STATUS_GPIO_MASK) >> WLAN_INT_STATUS_GPIO_LSB)
#define WLAN_INT_STATUS_GPIO_SET(x) (((x) << WLAN_INT_STATUS_GPIO_LSB) & WLAN_INT_STATUS_GPIO_MASK)
#define WLAN_INT_STATUS_UART_MSB 2
#define WLAN_INT_STATUS_UART_LSB 2
#define WLAN_INT_STATUS_UART_MASK 0x00000004
#define WLAN_INT_STATUS_UART_GET(x) (((x)&WLAN_INT_STATUS_UART_MASK) >> WLAN_INT_STATUS_UART_LSB)
#define WLAN_INT_STATUS_UART_SET(x) (((x) << WLAN_INT_STATUS_UART_LSB) & WLAN_INT_STATUS_UART_MASK)
#define WLAN_INT_STATUS_ERROR_MSB 1
#define WLAN_INT_STATUS_ERROR_LSB 1
#define WLAN_INT_STATUS_ERROR_MASK 0x00000002
#define WLAN_INT_STATUS_ERROR_GET(x) (((x)&WLAN_INT_STATUS_ERROR_MASK) >> WLAN_INT_STATUS_ERROR_LSB)
#define WLAN_INT_STATUS_ERROR_SET(x) (((x) << WLAN_INT_STATUS_ERROR_LSB) & WLAN_INT_STATUS_ERROR_MASK)
#define WLAN_INT_STATUS_WDT_INT_MSB 0
#define WLAN_INT_STATUS_WDT_INT_LSB 0
#define WLAN_INT_STATUS_WDT_INT_MASK 0x00000001
#define WLAN_INT_STATUS_WDT_INT_GET(x) (((x)&WLAN_INT_STATUS_WDT_INT_MASK) >> WLAN_INT_STATUS_WDT_INT_LSB)
#define WLAN_INT_STATUS_WDT_INT_SET(x) (((x) << WLAN_INT_STATUS_WDT_INT_LSB) & WLAN_INT_STATUS_WDT_INT_MASK)

#define WLAN_LF_TIMER0_ADDRESS 0x00000048
#define WLAN_LF_TIMER0_OFFSET 0x00000048
#define WLAN_LF_TIMER0_TARGET_MSB 31
#define WLAN_LF_TIMER0_TARGET_LSB 0
#define WLAN_LF_TIMER0_TARGET_MASK 0xffffffff
#define WLAN_LF_TIMER0_TARGET_GET(x) (((x)&WLAN_LF_TIMER0_TARGET_MASK) >> WLAN_LF_TIMER0_TARGET_LSB)
#define WLAN_LF_TIMER0_TARGET_SET(x) (((x) << WLAN_LF_TIMER0_TARGET_LSB) & WLAN_LF_TIMER0_TARGET_MASK)

#define WLAN_LF_TIMER_COUNT0_ADDRESS 0x0000004c
#define WLAN_LF_TIMER_COUNT0_OFFSET 0x0000004c
#define WLAN_LF_TIMER_COUNT0_VALUE_MSB 31
#define WLAN_LF_TIMER_COUNT0_VALUE_LSB 0
#define WLAN_LF_TIMER_COUNT0_VALUE_MASK 0xffffffff
#define WLAN_LF_TIMER_COUNT0_VALUE_GET(x) (((x)&WLAN_LF_TIMER_COUNT0_VALUE_MASK) >> WLAN_LF_TIMER_COUNT0_VALUE_LSB)
#define WLAN_LF_TIMER_COUNT0_VALUE_SET(x) (((x) << WLAN_LF_TIMER_COUNT0_VALUE_LSB) & WLAN_LF_TIMER_COUNT0_VALUE_MASK)

#define WLAN_LF_TIMER_CONTROL0_ADDRESS 0x00000050
#define WLAN_LF_TIMER_CONTROL0_OFFSET 0x00000050
#define WLAN_LF_TIMER_CONTROL0_ENABLE_MSB 2
#define WLAN_LF_TIMER_CONTROL0_ENABLE_LSB 2
#define WLAN_LF_TIMER_CONTROL0_ENABLE_MASK 0x00000004
#define WLAN_LF_TIMER_CONTROL0_ENABLE_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL0_ENABLE_MASK) >> WLAN_LF_TIMER_CONTROL0_ENABLE_LSB)
#define WLAN_LF_TIMER_CONTROL0_ENABLE_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL0_ENABLE_LSB) & WLAN_LF_TIMER_CONTROL0_ENABLE_MASK)
#define WLAN_LF_TIMER_CONTROL0_AUTO_RESTART_MSB 1
#define WLAN_LF_TIMER_CONTROL0_AUTO_RESTART_LSB 1
#define WLAN_LF_TIMER_CONTROL0_AUTO_RESTART_MASK 0x00000002
#define WLAN_LF_TIMER_CONTROL0_AUTO_RESTART_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL0_AUTO_RESTART_MASK) >> WLAN_LF_TIMER_CONTROL0_AUTO_RESTART_LSB)
#define WLAN_LF_TIMER_CONTROL0_AUTO_RESTART_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL0_AUTO_RESTART_LSB) & WLAN_LF_TIMER_CONTROL0_AUTO_RESTART_MASK)
#define WLAN_LF_TIMER_CONTROL0_RESET_MSB 0
#define WLAN_LF_TIMER_CONTROL0_RESET_LSB 0
#define WLAN_LF_TIMER_CONTROL0_RESET_MASK 0x00000001
#define WLAN_LF_TIMER_CONTROL0_RESET_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL0_RESET_MASK) >> WLAN_LF_TIMER_CONTROL0_RESET_LSB)
#define WLAN_LF_TIMER_CONTROL0_RESET_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL0_RESET_LSB) & WLAN_LF_TIMER_CONTROL0_RESET_MASK)

#define WLAN_LF_TIMER_STATUS0_ADDRESS 0x00000054
#define WLAN_LF_TIMER_STATUS0_OFFSET 0x00000054
#define WLAN_LF_TIMER_STATUS0_INTERRUPT_MSB 0
#define WLAN_LF_TIMER_STATUS0_INTERRUPT_LSB 0
#define WLAN_LF_TIMER_STATUS0_INTERRUPT_MASK 0x00000001
#define WLAN_LF_TIMER_STATUS0_INTERRUPT_GET(x) \
    (((x)&WLAN_LF_TIMER_STATUS0_INTERRUPT_MASK) >> WLAN_LF_TIMER_STATUS0_INTERRUPT_LSB)
#define WLAN_LF_TIMER_STATUS0_INTERRUPT_SET(x) \
    (((x) << WLAN_LF_TIMER_STATUS0_INTERRUPT_LSB) & WLAN_LF_TIMER_STATUS0_INTERRUPT_MASK)

#define WLAN_LF_TIMER1_ADDRESS 0x00000058
#define WLAN_LF_TIMER1_OFFSET 0x00000058
#define WLAN_LF_TIMER1_TARGET_MSB 31
#define WLAN_LF_TIMER1_TARGET_LSB 0
#define WLAN_LF_TIMER1_TARGET_MASK 0xffffffff
#define WLAN_LF_TIMER1_TARGET_GET(x) (((x)&WLAN_LF_TIMER1_TARGET_MASK) >> WLAN_LF_TIMER1_TARGET_LSB)
#define WLAN_LF_TIMER1_TARGET_SET(x) (((x) << WLAN_LF_TIMER1_TARGET_LSB) & WLAN_LF_TIMER1_TARGET_MASK)

#define WLAN_LF_TIMER_COUNT1_ADDRESS 0x0000005c
#define WLAN_LF_TIMER_COUNT1_OFFSET 0x0000005c
#define WLAN_LF_TIMER_COUNT1_VALUE_MSB 31
#define WLAN_LF_TIMER_COUNT1_VALUE_LSB 0
#define WLAN_LF_TIMER_COUNT1_VALUE_MASK 0xffffffff
#define WLAN_LF_TIMER_COUNT1_VALUE_GET(x) (((x)&WLAN_LF_TIMER_COUNT1_VALUE_MASK) >> WLAN_LF_TIMER_COUNT1_VALUE_LSB)
#define WLAN_LF_TIMER_COUNT1_VALUE_SET(x) (((x) << WLAN_LF_TIMER_COUNT1_VALUE_LSB) & WLAN_LF_TIMER_COUNT1_VALUE_MASK)

#define WLAN_LF_TIMER_CONTROL1_ADDRESS 0x00000060
#define WLAN_LF_TIMER_CONTROL1_OFFSET 0x00000060
#define WLAN_LF_TIMER_CONTROL1_ENABLE_MSB 2
#define WLAN_LF_TIMER_CONTROL1_ENABLE_LSB 2
#define WLAN_LF_TIMER_CONTROL1_ENABLE_MASK 0x00000004
#define WLAN_LF_TIMER_CONTROL1_ENABLE_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL1_ENABLE_MASK) >> WLAN_LF_TIMER_CONTROL1_ENABLE_LSB)
#define WLAN_LF_TIMER_CONTROL1_ENABLE_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL1_ENABLE_LSB) & WLAN_LF_TIMER_CONTROL1_ENABLE_MASK)
#define WLAN_LF_TIMER_CONTROL1_AUTO_RESTART_MSB 1
#define WLAN_LF_TIMER_CONTROL1_AUTO_RESTART_LSB 1
#define WLAN_LF_TIMER_CONTROL1_AUTO_RESTART_MASK 0x00000002
#define WLAN_LF_TIMER_CONTROL1_AUTO_RESTART_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL1_AUTO_RESTART_MASK) >> WLAN_LF_TIMER_CONTROL1_AUTO_RESTART_LSB)
#define WLAN_LF_TIMER_CONTROL1_AUTO_RESTART_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL1_AUTO_RESTART_LSB) & WLAN_LF_TIMER_CONTROL1_AUTO_RESTART_MASK)
#define WLAN_LF_TIMER_CONTROL1_RESET_MSB 0
#define WLAN_LF_TIMER_CONTROL1_RESET_LSB 0
#define WLAN_LF_TIMER_CONTROL1_RESET_MASK 0x00000001
#define WLAN_LF_TIMER_CONTROL1_RESET_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL1_RESET_MASK) >> WLAN_LF_TIMER_CONTROL1_RESET_LSB)
#define WLAN_LF_TIMER_CONTROL1_RESET_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL1_RESET_LSB) & WLAN_LF_TIMER_CONTROL1_RESET_MASK)

#define WLAN_LF_TIMER_STATUS1_ADDRESS 0x00000064
#define WLAN_LF_TIMER_STATUS1_OFFSET 0x00000064
#define WLAN_LF_TIMER_STATUS1_INTERRUPT_MSB 0
#define WLAN_LF_TIMER_STATUS1_INTERRUPT_LSB 0
#define WLAN_LF_TIMER_STATUS1_INTERRUPT_MASK 0x00000001
#define WLAN_LF_TIMER_STATUS1_INTERRUPT_GET(x) \
    (((x)&WLAN_LF_TIMER_STATUS1_INTERRUPT_MASK) >> WLAN_LF_TIMER_STATUS1_INTERRUPT_LSB)
#define WLAN_LF_TIMER_STATUS1_INTERRUPT_SET(x) \
    (((x) << WLAN_LF_TIMER_STATUS1_INTERRUPT_LSB) & WLAN_LF_TIMER_STATUS1_INTERRUPT_MASK)

#define WLAN_LF_TIMER2_ADDRESS 0x00000068
#define WLAN_LF_TIMER2_OFFSET 0x00000068
#define WLAN_LF_TIMER2_TARGET_MSB 31
#define WLAN_LF_TIMER2_TARGET_LSB 0
#define WLAN_LF_TIMER2_TARGET_MASK 0xffffffff
#define WLAN_LF_TIMER2_TARGET_GET(x) (((x)&WLAN_LF_TIMER2_TARGET_MASK) >> WLAN_LF_TIMER2_TARGET_LSB)
#define WLAN_LF_TIMER2_TARGET_SET(x) (((x) << WLAN_LF_TIMER2_TARGET_LSB) & WLAN_LF_TIMER2_TARGET_MASK)

#define WLAN_LF_TIMER_COUNT2_ADDRESS 0x0000006c
#define WLAN_LF_TIMER_COUNT2_OFFSET 0x0000006c
#define WLAN_LF_TIMER_COUNT2_VALUE_MSB 31
#define WLAN_LF_TIMER_COUNT2_VALUE_LSB 0
#define WLAN_LF_TIMER_COUNT2_VALUE_MASK 0xffffffff
#define WLAN_LF_TIMER_COUNT2_VALUE_GET(x) (((x)&WLAN_LF_TIMER_COUNT2_VALUE_MASK) >> WLAN_LF_TIMER_COUNT2_VALUE_LSB)
#define WLAN_LF_TIMER_COUNT2_VALUE_SET(x) (((x) << WLAN_LF_TIMER_COUNT2_VALUE_LSB) & WLAN_LF_TIMER_COUNT2_VALUE_MASK)

#define WLAN_LF_TIMER_CONTROL2_ADDRESS 0x00000070
#define WLAN_LF_TIMER_CONTROL2_OFFSET 0x00000070
#define WLAN_LF_TIMER_CONTROL2_ENABLE_MSB 2
#define WLAN_LF_TIMER_CONTROL2_ENABLE_LSB 2
#define WLAN_LF_TIMER_CONTROL2_ENABLE_MASK 0x00000004
#define WLAN_LF_TIMER_CONTROL2_ENABLE_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL2_ENABLE_MASK) >> WLAN_LF_TIMER_CONTROL2_ENABLE_LSB)
#define WLAN_LF_TIMER_CONTROL2_ENABLE_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL2_ENABLE_LSB) & WLAN_LF_TIMER_CONTROL2_ENABLE_MASK)
#define WLAN_LF_TIMER_CONTROL2_AUTO_RESTART_MSB 1
#define WLAN_LF_TIMER_CONTROL2_AUTO_RESTART_LSB 1
#define WLAN_LF_TIMER_CONTROL2_AUTO_RESTART_MASK 0x00000002
#define WLAN_LF_TIMER_CONTROL2_AUTO_RESTART_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL2_AUTO_RESTART_MASK) >> WLAN_LF_TIMER_CONTROL2_AUTO_RESTART_LSB)
#define WLAN_LF_TIMER_CONTROL2_AUTO_RESTART_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL2_AUTO_RESTART_LSB) & WLAN_LF_TIMER_CONTROL2_AUTO_RESTART_MASK)
#define WLAN_LF_TIMER_CONTROL2_RESET_MSB 0
#define WLAN_LF_TIMER_CONTROL2_RESET_LSB 0
#define WLAN_LF_TIMER_CONTROL2_RESET_MASK 0x00000001
#define WLAN_LF_TIMER_CONTROL2_RESET_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL2_RESET_MASK) >> WLAN_LF_TIMER_CONTROL2_RESET_LSB)
#define WLAN_LF_TIMER_CONTROL2_RESET_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL2_RESET_LSB) & WLAN_LF_TIMER_CONTROL2_RESET_MASK)

#define WLAN_LF_TIMER_STATUS2_ADDRESS 0x00000074
#define WLAN_LF_TIMER_STATUS2_OFFSET 0x00000074
#define WLAN_LF_TIMER_STATUS2_INTERRUPT_MSB 0
#define WLAN_LF_TIMER_STATUS2_INTERRUPT_LSB 0
#define WLAN_LF_TIMER_STATUS2_INTERRUPT_MASK 0x00000001
#define WLAN_LF_TIMER_STATUS2_INTERRUPT_GET(x) \
    (((x)&WLAN_LF_TIMER_STATUS2_INTERRUPT_MASK) >> WLAN_LF_TIMER_STATUS2_INTERRUPT_LSB)
#define WLAN_LF_TIMER_STATUS2_INTERRUPT_SET(x) \
    (((x) << WLAN_LF_TIMER_STATUS2_INTERRUPT_LSB) & WLAN_LF_TIMER_STATUS2_INTERRUPT_MASK)

#define WLAN_LF_TIMER3_ADDRESS 0x00000078
#define WLAN_LF_TIMER3_OFFSET 0x00000078
#define WLAN_LF_TIMER3_TARGET_MSB 31
#define WLAN_LF_TIMER3_TARGET_LSB 0
#define WLAN_LF_TIMER3_TARGET_MASK 0xffffffff
#define WLAN_LF_TIMER3_TARGET_GET(x) (((x)&WLAN_LF_TIMER3_TARGET_MASK) >> WLAN_LF_TIMER3_TARGET_LSB)
#define WLAN_LF_TIMER3_TARGET_SET(x) (((x) << WLAN_LF_TIMER3_TARGET_LSB) & WLAN_LF_TIMER3_TARGET_MASK)

#define WLAN_LF_TIMER_COUNT3_ADDRESS 0x0000007c
#define WLAN_LF_TIMER_COUNT3_OFFSET 0x0000007c
#define WLAN_LF_TIMER_COUNT3_VALUE_MSB 31
#define WLAN_LF_TIMER_COUNT3_VALUE_LSB 0
#define WLAN_LF_TIMER_COUNT3_VALUE_MASK 0xffffffff
#define WLAN_LF_TIMER_COUNT3_VALUE_GET(x) (((x)&WLAN_LF_TIMER_COUNT3_VALUE_MASK) >> WLAN_LF_TIMER_COUNT3_VALUE_LSB)
#define WLAN_LF_TIMER_COUNT3_VALUE_SET(x) (((x) << WLAN_LF_TIMER_COUNT3_VALUE_LSB) & WLAN_LF_TIMER_COUNT3_VALUE_MASK)

#define WLAN_LF_TIMER_CONTROL3_ADDRESS 0x00000080
#define WLAN_LF_TIMER_CONTROL3_OFFSET 0x00000080
#define WLAN_LF_TIMER_CONTROL3_ENABLE_MSB 2
#define WLAN_LF_TIMER_CONTROL3_ENABLE_LSB 2
#define WLAN_LF_TIMER_CONTROL3_ENABLE_MASK 0x00000004
#define WLAN_LF_TIMER_CONTROL3_ENABLE_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL3_ENABLE_MASK) >> WLAN_LF_TIMER_CONTROL3_ENABLE_LSB)
#define WLAN_LF_TIMER_CONTROL3_ENABLE_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL3_ENABLE_LSB) & WLAN_LF_TIMER_CONTROL3_ENABLE_MASK)
#define WLAN_LF_TIMER_CONTROL3_AUTO_RESTART_MSB 1
#define WLAN_LF_TIMER_CONTROL3_AUTO_RESTART_LSB 1
#define WLAN_LF_TIMER_CONTROL3_AUTO_RESTART_MASK 0x00000002
#define WLAN_LF_TIMER_CONTROL3_AUTO_RESTART_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL3_AUTO_RESTART_MASK) >> WLAN_LF_TIMER_CONTROL3_AUTO_RESTART_LSB)
#define WLAN_LF_TIMER_CONTROL3_AUTO_RESTART_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL3_AUTO_RESTART_LSB) & WLAN_LF_TIMER_CONTROL3_AUTO_RESTART_MASK)
#define WLAN_LF_TIMER_CONTROL3_RESET_MSB 0
#define WLAN_LF_TIMER_CONTROL3_RESET_LSB 0
#define WLAN_LF_TIMER_CONTROL3_RESET_MASK 0x00000001
#define WLAN_LF_TIMER_CONTROL3_RESET_GET(x) \
    (((x)&WLAN_LF_TIMER_CONTROL3_RESET_MASK) >> WLAN_LF_TIMER_CONTROL3_RESET_LSB)
#define WLAN_LF_TIMER_CONTROL3_RESET_SET(x) \
    (((x) << WLAN_LF_TIMER_CONTROL3_RESET_LSB) & WLAN_LF_TIMER_CONTROL3_RESET_MASK)

#define WLAN_LF_TIMER_STATUS3_ADDRESS 0x00000084
#define WLAN_LF_TIMER_STATUS3_OFFSET 0x00000084
#define WLAN_LF_TIMER_STATUS3_INTERRUPT_MSB 0
#define WLAN_LF_TIMER_STATUS3_INTERRUPT_LSB 0
#define WLAN_LF_TIMER_STATUS3_INTERRUPT_MASK 0x00000001
#define WLAN_LF_TIMER_STATUS3_INTERRUPT_GET(x) \
    (((x)&WLAN_LF_TIMER_STATUS3_INTERRUPT_MASK) >> WLAN_LF_TIMER_STATUS3_INTERRUPT_LSB)
#define WLAN_LF_TIMER_STATUS3_INTERRUPT_SET(x) \
    (((x) << WLAN_LF_TIMER_STATUS3_INTERRUPT_LSB) & WLAN_LF_TIMER_STATUS3_INTERRUPT_MASK)

#define WLAN_HF_TIMER_ADDRESS 0x00000088
#define WLAN_HF_TIMER_OFFSET 0x00000088
#define WLAN_HF_TIMER_TARGET_MSB 31
#define WLAN_HF_TIMER_TARGET_LSB 12
#define WLAN_HF_TIMER_TARGET_MASK 0xfffff000
#define WLAN_HF_TIMER_TARGET_GET(x) (((x)&WLAN_HF_TIMER_TARGET_MASK) >> WLAN_HF_TIMER_TARGET_LSB)
#define WLAN_HF_TIMER_TARGET_SET(x) (((x) << WLAN_HF_TIMER_TARGET_LSB) & WLAN_HF_TIMER_TARGET_MASK)

#define WLAN_HF_TIMER_COUNT_ADDRESS 0x0000008c
#define WLAN_HF_TIMER_COUNT_OFFSET 0x0000008c
#define WLAN_HF_TIMER_COUNT_VALUE_MSB 31
#define WLAN_HF_TIMER_COUNT_VALUE_LSB 12
#define WLAN_HF_TIMER_COUNT_VALUE_MASK 0xfffff000
#define WLAN_HF_TIMER_COUNT_VALUE_GET(x) (((x)&WLAN_HF_TIMER_COUNT_VALUE_MASK) >> WLAN_HF_TIMER_COUNT_VALUE_LSB)
#define WLAN_HF_TIMER_COUNT_VALUE_SET(x) (((x) << WLAN_HF_TIMER_COUNT_VALUE_LSB) & WLAN_HF_TIMER_COUNT_VALUE_MASK)

#define WLAN_HF_LF_COUNT_ADDRESS 0x00000090
#define WLAN_HF_LF_COUNT_OFFSET 0x00000090
#define WLAN_HF_LF_COUNT_VALUE_MSB 31
#define WLAN_HF_LF_COUNT_VALUE_LSB 0
#define WLAN_HF_LF_COUNT_VALUE_MASK 0xffffffff
#define WLAN_HF_LF_COUNT_VALUE_GET(x) (((x)&WLAN_HF_LF_COUNT_VALUE_MASK) >> WLAN_HF_LF_COUNT_VALUE_LSB)
#define WLAN_HF_LF_COUNT_VALUE_SET(x) (((x) << WLAN_HF_LF_COUNT_VALUE_LSB) & WLAN_HF_LF_COUNT_VALUE_MASK)

#define WLAN_HF_TIMER_CONTROL_ADDRESS 0x00000094
#define WLAN_HF_TIMER_CONTROL_OFFSET 0x00000094
#define WLAN_HF_TIMER_CONTROL_ENABLE_MSB 3
#define WLAN_HF_TIMER_CONTROL_ENABLE_LSB 3
#define WLAN_HF_TIMER_CONTROL_ENABLE_MASK 0x00000008
#define WLAN_HF_TIMER_CONTROL_ENABLE_GET(x) \
    (((x)&WLAN_HF_TIMER_CONTROL_ENABLE_MASK) >> WLAN_HF_TIMER_CONTROL_ENABLE_LSB)
#define WLAN_HF_TIMER_CONTROL_ENABLE_SET(x) \
    (((x) << WLAN_HF_TIMER_CONTROL_ENABLE_LSB) & WLAN_HF_TIMER_CONTROL_ENABLE_MASK)
#define WLAN_HF_TIMER_CONTROL_ON_MSB 2
#define WLAN_HF_TIMER_CONTROL_ON_LSB 2
#define WLAN_HF_TIMER_CONTROL_ON_MASK 0x00000004
#define WLAN_HF_TIMER_CONTROL_ON_GET(x) (((x)&WLAN_HF_TIMER_CONTROL_ON_MASK) >> WLAN_HF_TIMER_CONTROL_ON_LSB)
#define WLAN_HF_TIMER_CONTROL_ON_SET(x) (((x) << WLAN_HF_TIMER_CONTROL_ON_LSB) & WLAN_HF_TIMER_CONTROL_ON_MASK)
#define WLAN_HF_TIMER_CONTROL_AUTO_RESTART_MSB 1
#define WLAN_HF_TIMER_CONTROL_AUTO_RESTART_LSB 1
#define WLAN_HF_TIMER_CONTROL_AUTO_RESTART_MASK 0x00000002
#define WLAN_HF_TIMER_CONTROL_AUTO_RESTART_GET(x) \
    (((x)&WLAN_HF_TIMER_CONTROL_AUTO_RESTART_MASK) >> WLAN_HF_TIMER_CONTROL_AUTO_RESTART_LSB)
#define WLAN_HF_TIMER_CONTROL_AUTO_RESTART_SET(x) \
    (((x) << WLAN_HF_TIMER_CONTROL_AUTO_RESTART_LSB) & WLAN_HF_TIMER_CONTROL_AUTO_RESTART_MASK)
#define WLAN_HF_TIMER_CONTROL_RESET_MSB 0
#define WLAN_HF_TIMER_CONTROL_RESET_LSB 0
#define WLAN_HF_TIMER_CONTROL_RESET_MASK 0x00000001
#define WLAN_HF_TIMER_CONTROL_RESET_GET(x) (((x)&WLAN_HF_TIMER_CONTROL_RESET_MASK) >> WLAN_HF_TIMER_CONTROL_RESET_LSB)
#define WLAN_HF_TIMER_CONTROL_RESET_SET(x) (((x) << WLAN_HF_TIMER_CONTROL_RESET_LSB) & WLAN_HF_TIMER_CONTROL_RESET_MASK)

#define WLAN_HF_TIMER_STATUS_ADDRESS 0x00000098
#define WLAN_HF_TIMER_STATUS_OFFSET 0x00000098
#define WLAN_HF_TIMER_STATUS_INTERRUPT_MSB 0
#define WLAN_HF_TIMER_STATUS_INTERRUPT_LSB 0
#define WLAN_HF_TIMER_STATUS_INTERRUPT_MASK 0x00000001
#define WLAN_HF_TIMER_STATUS_INTERRUPT_GET(x) \
    (((x)&WLAN_HF_TIMER_STATUS_INTERRUPT_MASK) >> WLAN_HF_TIMER_STATUS_INTERRUPT_LSB)
#define WLAN_HF_TIMER_STATUS_INTERRUPT_SET(x) \
    (((x) << WLAN_HF_TIMER_STATUS_INTERRUPT_LSB) & WLAN_HF_TIMER_STATUS_INTERRUPT_MASK)

#define WLAN_RTC_CONTROL_ADDRESS 0x0000009c
#define WLAN_RTC_CONTROL_OFFSET 0x0000009c
#define WLAN_RTC_CONTROL_ENABLE_MSB 2
#define WLAN_RTC_CONTROL_ENABLE_LSB 2
#define WLAN_RTC_CONTROL_ENABLE_MASK 0x00000004
#define WLAN_RTC_CONTROL_ENABLE_GET(x) (((x)&WLAN_RTC_CONTROL_ENABLE_MASK) >> WLAN_RTC_CONTROL_ENABLE_LSB)
#define WLAN_RTC_CONTROL_ENABLE_SET(x) (((x) << WLAN_RTC_CONTROL_ENABLE_LSB) & WLAN_RTC_CONTROL_ENABLE_MASK)
#define WLAN_RTC_CONTROL_LOAD_RTC_MSB 1
#define WLAN_RTC_CONTROL_LOAD_RTC_LSB 1
#define WLAN_RTC_CONTROL_LOAD_RTC_MASK 0x00000002
#define WLAN_RTC_CONTROL_LOAD_RTC_GET(x) (((x)&WLAN_RTC_CONTROL_LOAD_RTC_MASK) >> WLAN_RTC_CONTROL_LOAD_RTC_LSB)
#define WLAN_RTC_CONTROL_LOAD_RTC_SET(x) (((x) << WLAN_RTC_CONTROL_LOAD_RTC_LSB) & WLAN_RTC_CONTROL_LOAD_RTC_MASK)
#define WLAN_RTC_CONTROL_LOAD_ALARM_MSB 0
#define WLAN_RTC_CONTROL_LOAD_ALARM_LSB 0
#define WLAN_RTC_CONTROL_LOAD_ALARM_MASK 0x00000001
#define WLAN_RTC_CONTROL_LOAD_ALARM_GET(x) (((x)&WLAN_RTC_CONTROL_LOAD_ALARM_MASK) >> WLAN_RTC_CONTROL_LOAD_ALARM_LSB)
#define WLAN_RTC_CONTROL_LOAD_ALARM_SET(x) (((x) << WLAN_RTC_CONTROL_LOAD_ALARM_LSB) & WLAN_RTC_CONTROL_LOAD_ALARM_MASK)

#define WLAN_RTC_TIME_ADDRESS 0x000000a0
#define WLAN_RTC_TIME_OFFSET 0x000000a0
#define WLAN_RTC_TIME_WEEK_DAY_MSB 26
#define WLAN_RTC_TIME_WEEK_DAY_LSB 24
#define WLAN_RTC_TIME_WEEK_DAY_MASK 0x07000000
#define WLAN_RTC_TIME_WEEK_DAY_GET(x) (((x)&WLAN_RTC_TIME_WEEK_DAY_MASK) >> WLAN_RTC_TIME_WEEK_DAY_LSB)
#define WLAN_RTC_TIME_WEEK_DAY_SET(x) (((x) << WLAN_RTC_TIME_WEEK_DAY_LSB) & WLAN_RTC_TIME_WEEK_DAY_MASK)
#define WLAN_RTC_TIME_HOUR_MSB 21
#define WLAN_RTC_TIME_HOUR_LSB 16
#define WLAN_RTC_TIME_HOUR_MASK 0x003f0000
#define WLAN_RTC_TIME_HOUR_GET(x) (((x)&WLAN_RTC_TIME_HOUR_MASK) >> WLAN_RTC_TIME_HOUR_LSB)
#define WLAN_RTC_TIME_HOUR_SET(x) (((x) << WLAN_RTC_TIME_HOUR_LSB) & WLAN_RTC_TIME_HOUR_MASK)
#define WLAN_RTC_TIME_MINUTE_MSB 14
#define WLAN_RTC_TIME_MINUTE_LSB 8
#define WLAN_RTC_TIME_MINUTE_MASK 0x00007f00
#define WLAN_RTC_TIME_MINUTE_GET(x) (((x)&WLAN_RTC_TIME_MINUTE_MASK) >> WLAN_RTC_TIME_MINUTE_LSB)
#define WLAN_RTC_TIME_MINUTE_SET(x) (((x) << WLAN_RTC_TIME_MINUTE_LSB) & WLAN_RTC_TIME_MINUTE_MASK)
#define WLAN_RTC_TIME_SECOND_MSB 6
#define WLAN_RTC_TIME_SECOND_LSB 0
#define WLAN_RTC_TIME_SECOND_MASK 0x0000007f
#define WLAN_RTC_TIME_SECOND_GET(x) (((x)&WLAN_RTC_TIME_SECOND_MASK) >> WLAN_RTC_TIME_SECOND_LSB)
#define WLAN_RTC_TIME_SECOND_SET(x) (((x) << WLAN_RTC_TIME_SECOND_LSB) & WLAN_RTC_TIME_SECOND_MASK)

#define WLAN_RTC_DATE_ADDRESS 0x000000a4
#define WLAN_RTC_DATE_OFFSET 0x000000a4
#define WLAN_RTC_DATE_YEAR_MSB 23
#define WLAN_RTC_DATE_YEAR_LSB 16
#define WLAN_RTC_DATE_YEAR_MASK 0x00ff0000
#define WLAN_RTC_DATE_YEAR_GET(x) (((x)&WLAN_RTC_DATE_YEAR_MASK) >> WLAN_RTC_DATE_YEAR_LSB)
#define WLAN_RTC_DATE_YEAR_SET(x) (((x) << WLAN_RTC_DATE_YEAR_LSB) & WLAN_RTC_DATE_YEAR_MASK)
#define WLAN_RTC_DATE_MONTH_MSB 12
#define WLAN_RTC_DATE_MONTH_LSB 8
#define WLAN_RTC_DATE_MONTH_MASK 0x00001f00
#define WLAN_RTC_DATE_MONTH_GET(x) (((x)&WLAN_RTC_DATE_MONTH_MASK) >> WLAN_RTC_DATE_MONTH_LSB)
#define WLAN_RTC_DATE_MONTH_SET(x) (((x) << WLAN_RTC_DATE_MONTH_LSB) & WLAN_RTC_DATE_MONTH_MASK)
#define WLAN_RTC_DATE_MONTH_DAY_MSB 5
#define WLAN_RTC_DATE_MONTH_DAY_LSB 0
#define WLAN_RTC_DATE_MONTH_DAY_MASK 0x0000003f
#define WLAN_RTC_DATE_MONTH_DAY_GET(x) (((x)&WLAN_RTC_DATE_MONTH_DAY_MASK) >> WLAN_RTC_DATE_MONTH_DAY_LSB)
#define WLAN_RTC_DATE_MONTH_DAY_SET(x) (((x) << WLAN_RTC_DATE_MONTH_DAY_LSB) & WLAN_RTC_DATE_MONTH_DAY_MASK)

#define WLAN_RTC_SET_TIME_ADDRESS 0x000000a8
#define WLAN_RTC_SET_TIME_OFFSET 0x000000a8
#define WLAN_RTC_SET_TIME_WEEK_DAY_MSB 26
#define WLAN_RTC_SET_TIME_WEEK_DAY_LSB 24
#define WLAN_RTC_SET_TIME_WEEK_DAY_MASK 0x07000000
#define WLAN_RTC_SET_TIME_WEEK_DAY_GET(x) (((x)&WLAN_RTC_SET_TIME_WEEK_DAY_MASK) >> WLAN_RTC_SET_TIME_WEEK_DAY_LSB)
#define WLAN_RTC_SET_TIME_WEEK_DAY_SET(x) (((x) << WLAN_RTC_SET_TIME_WEEK_DAY_LSB) & WLAN_RTC_SET_TIME_WEEK_DAY_MASK)
#define WLAN_RTC_SET_TIME_HOUR_MSB 21
#define WLAN_RTC_SET_TIME_HOUR_LSB 16
#define WLAN_RTC_SET_TIME_HOUR_MASK 0x003f0000
#define WLAN_RTC_SET_TIME_HOUR_GET(x) (((x)&WLAN_RTC_SET_TIME_HOUR_MASK) >> WLAN_RTC_SET_TIME_HOUR_LSB)
#define WLAN_RTC_SET_TIME_HOUR_SET(x) (((x) << WLAN_RTC_SET_TIME_HOUR_LSB) & WLAN_RTC_SET_TIME_HOUR_MASK)
#define WLAN_RTC_SET_TIME_MINUTE_MSB 14
#define WLAN_RTC_SET_TIME_MINUTE_LSB 8
#define WLAN_RTC_SET_TIME_MINUTE_MASK 0x00007f00
#define WLAN_RTC_SET_TIME_MINUTE_GET(x) (((x)&WLAN_RTC_SET_TIME_MINUTE_MASK) >> WLAN_RTC_SET_TIME_MINUTE_LSB)
#define WLAN_RTC_SET_TIME_MINUTE_SET(x) (((x) << WLAN_RTC_SET_TIME_MINUTE_LSB) & WLAN_RTC_SET_TIME_MINUTE_MASK)
#define WLAN_RTC_SET_TIME_SECOND_MSB 6
#define WLAN_RTC_SET_TIME_SECOND_LSB 0
#define WLAN_RTC_SET_TIME_SECOND_MASK 0x0000007f
#define WLAN_RTC_SET_TIME_SECOND_GET(x) (((x)&WLAN_RTC_SET_TIME_SECOND_MASK) >> WLAN_RTC_SET_TIME_SECOND_LSB)
#define WLAN_RTC_SET_TIME_SECOND_SET(x) (((x) << WLAN_RTC_SET_TIME_SECOND_LSB) & WLAN_RTC_SET_TIME_SECOND_MASK)

#define WLAN_RTC_SET_DATE_ADDRESS 0x000000ac
#define WLAN_RTC_SET_DATE_OFFSET 0x000000ac
#define WLAN_RTC_SET_DATE_YEAR_MSB 23
#define WLAN_RTC_SET_DATE_YEAR_LSB 16
#define WLAN_RTC_SET_DATE_YEAR_MASK 0x00ff0000
#define WLAN_RTC_SET_DATE_YEAR_GET(x) (((x)&WLAN_RTC_SET_DATE_YEAR_MASK) >> WLAN_RTC_SET_DATE_YEAR_LSB)
#define WLAN_RTC_SET_DATE_YEAR_SET(x) (((x) << WLAN_RTC_SET_DATE_YEAR_LSB) & WLAN_RTC_SET_DATE_YEAR_MASK)
#define WLAN_RTC_SET_DATE_MONTH_MSB 12
#define WLAN_RTC_SET_DATE_MONTH_LSB 8
#define WLAN_RTC_SET_DATE_MONTH_MASK 0x00001f00
#define WLAN_RTC_SET_DATE_MONTH_GET(x) (((x)&WLAN_RTC_SET_DATE_MONTH_MASK) >> WLAN_RTC_SET_DATE_MONTH_LSB)
#define WLAN_RTC_SET_DATE_MONTH_SET(x) (((x) << WLAN_RTC_SET_DATE_MONTH_LSB) & WLAN_RTC_SET_DATE_MONTH_MASK)
#define WLAN_RTC_SET_DATE_MONTH_DAY_MSB 5
#define WLAN_RTC_SET_DATE_MONTH_DAY_LSB 0
#define WLAN_RTC_SET_DATE_MONTH_DAY_MASK 0x0000003f
#define WLAN_RTC_SET_DATE_MONTH_DAY_GET(x) (((x)&WLAN_RTC_SET_DATE_MONTH_DAY_MASK) >> WLAN_RTC_SET_DATE_MONTH_DAY_LSB)
#define WLAN_RTC_SET_DATE_MONTH_DAY_SET(x) (((x) << WLAN_RTC_SET_DATE_MONTH_DAY_LSB) & WLAN_RTC_SET_DATE_MONTH_DAY_MASK)

#define WLAN_RTC_SET_ALARM_ADDRESS 0x000000b0
#define WLAN_RTC_SET_ALARM_OFFSET 0x000000b0
#define WLAN_RTC_SET_ALARM_HOUR_MSB 21
#define WLAN_RTC_SET_ALARM_HOUR_LSB 16
#define WLAN_RTC_SET_ALARM_HOUR_MASK 0x003f0000
#define WLAN_RTC_SET_ALARM_HOUR_GET(x) (((x)&WLAN_RTC_SET_ALARM_HOUR_MASK) >> WLAN_RTC_SET_ALARM_HOUR_LSB)
#define WLAN_RTC_SET_ALARM_HOUR_SET(x) (((x) << WLAN_RTC_SET_ALARM_HOUR_LSB) & WLAN_RTC_SET_ALARM_HOUR_MASK)
#define WLAN_RTC_SET_ALARM_MINUTE_MSB 14
#define WLAN_RTC_SET_ALARM_MINUTE_LSB 8
#define WLAN_RTC_SET_ALARM_MINUTE_MASK 0x00007f00
#define WLAN_RTC_SET_ALARM_MINUTE_GET(x) (((x)&WLAN_RTC_SET_ALARM_MINUTE_MASK) >> WLAN_RTC_SET_ALARM_MINUTE_LSB)
#define WLAN_RTC_SET_ALARM_MINUTE_SET(x) (((x) << WLAN_RTC_SET_ALARM_MINUTE_LSB) & WLAN_RTC_SET_ALARM_MINUTE_MASK)
#define WLAN_RTC_SET_ALARM_SECOND_MSB 6
#define WLAN_RTC_SET_ALARM_SECOND_LSB 0
#define WLAN_RTC_SET_ALARM_SECOND_MASK 0x0000007f
#define WLAN_RTC_SET_ALARM_SECOND_GET(x) (((x)&WLAN_RTC_SET_ALARM_SECOND_MASK) >> WLAN_RTC_SET_ALARM_SECOND_LSB)
#define WLAN_RTC_SET_ALARM_SECOND_SET(x) (((x) << WLAN_RTC_SET_ALARM_SECOND_LSB) & WLAN_RTC_SET_ALARM_SECOND_MASK)

#define WLAN_RTC_CONFIG_ADDRESS 0x000000b4
#define WLAN_RTC_CONFIG_OFFSET 0x000000b4
#define WLAN_RTC_CONFIG_BCD_MSB 2
#define WLAN_RTC_CONFIG_BCD_LSB 2
#define WLAN_RTC_CONFIG_BCD_MASK 0x00000004
#define WLAN_RTC_CONFIG_BCD_GET(x) (((x)&WLAN_RTC_CONFIG_BCD_MASK) >> WLAN_RTC_CONFIG_BCD_LSB)
#define WLAN_RTC_CONFIG_BCD_SET(x) (((x) << WLAN_RTC_CONFIG_BCD_LSB) & WLAN_RTC_CONFIG_BCD_MASK)
#define WLAN_RTC_CONFIG_TWELVE_HOUR_MSB 1
#define WLAN_RTC_CONFIG_TWELVE_HOUR_LSB 1
#define WLAN_RTC_CONFIG_TWELVE_HOUR_MASK 0x00000002
#define WLAN_RTC_CONFIG_TWELVE_HOUR_GET(x) (((x)&WLAN_RTC_CONFIG_TWELVE_HOUR_MASK) >> WLAN_RTC_CONFIG_TWELVE_HOUR_LSB)
#define WLAN_RTC_CONFIG_TWELVE_HOUR_SET(x) (((x) << WLAN_RTC_CONFIG_TWELVE_HOUR_LSB) & WLAN_RTC_CONFIG_TWELVE_HOUR_MASK)
#define WLAN_RTC_CONFIG_DSE_MSB 0
#define WLAN_RTC_CONFIG_DSE_LSB 0
#define WLAN_RTC_CONFIG_DSE_MASK 0x00000001
#define WLAN_RTC_CONFIG_DSE_GET(x) (((x)&WLAN_RTC_CONFIG_DSE_MASK) >> WLAN_RTC_CONFIG_DSE_LSB)
#define WLAN_RTC_CONFIG_DSE_SET(x) (((x) << WLAN_RTC_CONFIG_DSE_LSB) & WLAN_RTC_CONFIG_DSE_MASK)

#define WLAN_RTC_ALARM_STATUS_ADDRESS 0x000000b8
#define WLAN_RTC_ALARM_STATUS_OFFSET 0x000000b8
#define WLAN_RTC_ALARM_STATUS_ENABLE_MSB 1
#define WLAN_RTC_ALARM_STATUS_ENABLE_LSB 1
#define WLAN_RTC_ALARM_STATUS_ENABLE_MASK 0x00000002
#define WLAN_RTC_ALARM_STATUS_ENABLE_GET(x) \
    (((x)&WLAN_RTC_ALARM_STATUS_ENABLE_MASK) >> WLAN_RTC_ALARM_STATUS_ENABLE_LSB)
#define WLAN_RTC_ALARM_STATUS_ENABLE_SET(x) \
    (((x) << WLAN_RTC_ALARM_STATUS_ENABLE_LSB) & WLAN_RTC_ALARM_STATUS_ENABLE_MASK)
#define WLAN_RTC_ALARM_STATUS_INTERRUPT_MSB 0
#define WLAN_RTC_ALARM_STATUS_INTERRUPT_LSB 0
#define WLAN_RTC_ALARM_STATUS_INTERRUPT_MASK 0x00000001
#define WLAN_RTC_ALARM_STATUS_INTERRUPT_GET(x) \
    (((x)&WLAN_RTC_ALARM_STATUS_INTERRUPT_MASK) >> WLAN_RTC_ALARM_STATUS_INTERRUPT_LSB)
#define WLAN_RTC_ALARM_STATUS_INTERRUPT_SET(x) \
    (((x) << WLAN_RTC_ALARM_STATUS_INTERRUPT_LSB) & WLAN_RTC_ALARM_STATUS_INTERRUPT_MASK)

#define WLAN_UART_WAKEUP_ADDRESS 0x000000bc
#define WLAN_UART_WAKEUP_OFFSET 0x000000bc
#define WLAN_UART_WAKEUP_ENABLE_MSB 0
#define WLAN_UART_WAKEUP_ENABLE_LSB 0
#define WLAN_UART_WAKEUP_ENABLE_MASK 0x00000001
#define WLAN_UART_WAKEUP_ENABLE_GET(x) (((x)&WLAN_UART_WAKEUP_ENABLE_MASK) >> WLAN_UART_WAKEUP_ENABLE_LSB)
#define WLAN_UART_WAKEUP_ENABLE_SET(x) (((x) << WLAN_UART_WAKEUP_ENABLE_LSB) & WLAN_UART_WAKEUP_ENABLE_MASK)

#define WLAN_RESET_CAUSE_ADDRESS 0x000000c0
#define WLAN_RESET_CAUSE_OFFSET 0x000000c0
#define WLAN_RESET_CAUSE_LAST_MSB 2
#define WLAN_RESET_CAUSE_LAST_LSB 0
#define WLAN_RESET_CAUSE_LAST_MASK 0x00000007
#define WLAN_RESET_CAUSE_LAST_GET(x) (((x)&WLAN_RESET_CAUSE_LAST_MASK) >> WLAN_RESET_CAUSE_LAST_LSB)
#define WLAN_RESET_CAUSE_LAST_SET(x) (((x) << WLAN_RESET_CAUSE_LAST_LSB) & WLAN_RESET_CAUSE_LAST_MASK)

#define WLAN_SYSTEM_SLEEP_ADDRESS 0x000000c4
#define WLAN_SYSTEM_SLEEP_OFFSET 0x000000c4
#define WLAN_SYSTEM_SLEEP_HOST_IF_MSB 4
#define WLAN_SYSTEM_SLEEP_HOST_IF_LSB 4
#define WLAN_SYSTEM_SLEEP_HOST_IF_MASK 0x00000010
#define WLAN_SYSTEM_SLEEP_HOST_IF_GET(x) (((x)&WLAN_SYSTEM_SLEEP_HOST_IF_MASK) >> WLAN_SYSTEM_SLEEP_HOST_IF_LSB)
#define WLAN_SYSTEM_SLEEP_HOST_IF_SET(x) (((x) << WLAN_SYSTEM_SLEEP_HOST_IF_LSB) & WLAN_SYSTEM_SLEEP_HOST_IF_MASK)
#define WLAN_SYSTEM_SLEEP_MBOX_MSB 3
#define WLAN_SYSTEM_SLEEP_MBOX_LSB 3
#define WLAN_SYSTEM_SLEEP_MBOX_MASK 0x00000008
#define WLAN_SYSTEM_SLEEP_MBOX_GET(x) (((x)&WLAN_SYSTEM_SLEEP_MBOX_MASK) >> WLAN_SYSTEM_SLEEP_MBOX_LSB)
#define WLAN_SYSTEM_SLEEP_MBOX_SET(x) (((x) << WLAN_SYSTEM_SLEEP_MBOX_LSB) & WLAN_SYSTEM_SLEEP_MBOX_MASK)
#define WLAN_SYSTEM_SLEEP_MAC_IF_MSB 2
#define WLAN_SYSTEM_SLEEP_MAC_IF_LSB 2
#define WLAN_SYSTEM_SLEEP_MAC_IF_MASK 0x00000004
#define WLAN_SYSTEM_SLEEP_MAC_IF_GET(x) (((x)&WLAN_SYSTEM_SLEEP_MAC_IF_MASK) >> WLAN_SYSTEM_SLEEP_MAC_IF_LSB)
#define WLAN_SYSTEM_SLEEP_MAC_IF_SET(x) (((x) << WLAN_SYSTEM_SLEEP_MAC_IF_LSB) & WLAN_SYSTEM_SLEEP_MAC_IF_MASK)
#define WLAN_SYSTEM_SLEEP_LIGHT_MSB 1
#define WLAN_SYSTEM_SLEEP_LIGHT_LSB 1
#define WLAN_SYSTEM_SLEEP_LIGHT_MASK 0x00000002
#define WLAN_SYSTEM_SLEEP_LIGHT_GET(x) (((x)&WLAN_SYSTEM_SLEEP_LIGHT_MASK) >> WLAN_SYSTEM_SLEEP_LIGHT_LSB)
#define WLAN_SYSTEM_SLEEP_LIGHT_SET(x) (((x) << WLAN_SYSTEM_SLEEP_LIGHT_LSB) & WLAN_SYSTEM_SLEEP_LIGHT_MASK)
#define WLAN_SYSTEM_SLEEP_DISABLE_MSB 0
#define WLAN_SYSTEM_SLEEP_DISABLE_LSB 0
#define WLAN_SYSTEM_SLEEP_DISABLE_MASK 0x00000001
#define WLAN_SYSTEM_SLEEP_DISABLE_GET(x) (((x)&WLAN_SYSTEM_SLEEP_DISABLE_MASK) >> WLAN_SYSTEM_SLEEP_DISABLE_LSB)
#define WLAN_SYSTEM_SLEEP_DISABLE_SET(x) (((x) << WLAN_SYSTEM_SLEEP_DISABLE_LSB) & WLAN_SYSTEM_SLEEP_DISABLE_MASK)

#define WLAN_SDIO_WRAPPER_ADDRESS 0x000000c8
#define WLAN_SDIO_WRAPPER_OFFSET 0x000000c8
#define WLAN_SDIO_WRAPPER_SLEEP_MSB 3
#define WLAN_SDIO_WRAPPER_SLEEP_LSB 3
#define WLAN_SDIO_WRAPPER_SLEEP_MASK 0x00000008
#define WLAN_SDIO_WRAPPER_SLEEP_GET(x) (((x)&WLAN_SDIO_WRAPPER_SLEEP_MASK) >> WLAN_SDIO_WRAPPER_SLEEP_LSB)
#define WLAN_SDIO_WRAPPER_SLEEP_SET(x) (((x) << WLAN_SDIO_WRAPPER_SLEEP_LSB) & WLAN_SDIO_WRAPPER_SLEEP_MASK)
#define WLAN_SDIO_WRAPPER_WAKEUP_MSB 2
#define WLAN_SDIO_WRAPPER_WAKEUP_LSB 2
#define WLAN_SDIO_WRAPPER_WAKEUP_MASK 0x00000004
#define WLAN_SDIO_WRAPPER_WAKEUP_GET(x) (((x)&WLAN_SDIO_WRAPPER_WAKEUP_MASK) >> WLAN_SDIO_WRAPPER_WAKEUP_LSB)
#define WLAN_SDIO_WRAPPER_WAKEUP_SET(x) (((x) << WLAN_SDIO_WRAPPER_WAKEUP_LSB) & WLAN_SDIO_WRAPPER_WAKEUP_MASK)
#define WLAN_SDIO_WRAPPER_SOC_ON_MSB 1
#define WLAN_SDIO_WRAPPER_SOC_ON_LSB 1
#define WLAN_SDIO_WRAPPER_SOC_ON_MASK 0x00000002
#define WLAN_SDIO_WRAPPER_SOC_ON_GET(x) (((x)&WLAN_SDIO_WRAPPER_SOC_ON_MASK) >> WLAN_SDIO_WRAPPER_SOC_ON_LSB)
#define WLAN_SDIO_WRAPPER_SOC_ON_SET(x) (((x) << WLAN_SDIO_WRAPPER_SOC_ON_LSB) & WLAN_SDIO_WRAPPER_SOC_ON_MASK)
#define WLAN_SDIO_WRAPPER_ON_MSB 0
#define WLAN_SDIO_WRAPPER_ON_LSB 0
#define WLAN_SDIO_WRAPPER_ON_MASK 0x00000001
#define WLAN_SDIO_WRAPPER_ON_GET(x) (((x)&WLAN_SDIO_WRAPPER_ON_MASK) >> WLAN_SDIO_WRAPPER_ON_LSB)
#define WLAN_SDIO_WRAPPER_ON_SET(x) (((x) << WLAN_SDIO_WRAPPER_ON_LSB) & WLAN_SDIO_WRAPPER_ON_MASK)

#define WLAN_MAC_SLEEP_CONTROL_ADDRESS 0x000000cc
#define WLAN_MAC_SLEEP_CONTROL_OFFSET 0x000000cc
#define WLAN_MAC_SLEEP_CONTROL_ENABLE_MSB 1
#define WLAN_MAC_SLEEP_CONTROL_ENABLE_LSB 0
#define WLAN_MAC_SLEEP_CONTROL_ENABLE_MASK 0x00000003
#define WLAN_MAC_SLEEP_CONTROL_ENABLE_GET(x) \
    (((x)&WLAN_MAC_SLEEP_CONTROL_ENABLE_MASK) >> WLAN_MAC_SLEEP_CONTROL_ENABLE_LSB)
#define WLAN_MAC_SLEEP_CONTROL_ENABLE_SET(x) \
    (((x) << WLAN_MAC_SLEEP_CONTROL_ENABLE_LSB) & WLAN_MAC_SLEEP_CONTROL_ENABLE_MASK)

#define WLAN_KEEP_AWAKE_ADDRESS 0x000000d0
#define WLAN_KEEP_AWAKE_OFFSET 0x000000d0
#define WLAN_KEEP_AWAKE_COUNT_MSB 7
#define WLAN_KEEP_AWAKE_COUNT_LSB 0
#define WLAN_KEEP_AWAKE_COUNT_MASK 0x000000ff
#define WLAN_KEEP_AWAKE_COUNT_GET(x) (((x)&WLAN_KEEP_AWAKE_COUNT_MASK) >> WLAN_KEEP_AWAKE_COUNT_LSB)
#define WLAN_KEEP_AWAKE_COUNT_SET(x) (((x) << WLAN_KEEP_AWAKE_COUNT_LSB) & WLAN_KEEP_AWAKE_COUNT_MASK)

#define WLAN_LPO_CAL_TIME_ADDRESS 0x000000d4
#define WLAN_LPO_CAL_TIME_OFFSET 0x000000d4
#define WLAN_LPO_CAL_TIME_LENGTH_MSB 13
#define WLAN_LPO_CAL_TIME_LENGTH_LSB 0
#define WLAN_LPO_CAL_TIME_LENGTH_MASK 0x00003fff
#define WLAN_LPO_CAL_TIME_LENGTH_GET(x) (((x)&WLAN_LPO_CAL_TIME_LENGTH_MASK) >> WLAN_LPO_CAL_TIME_LENGTH_LSB)
#define WLAN_LPO_CAL_TIME_LENGTH_SET(x) (((x) << WLAN_LPO_CAL_TIME_LENGTH_LSB) & WLAN_LPO_CAL_TIME_LENGTH_MASK)

#define WLAN_LPO_INIT_DIVIDEND_INT_ADDRESS 0x000000d8
#define WLAN_LPO_INIT_DIVIDEND_INT_OFFSET 0x000000d8
#define WLAN_LPO_INIT_DIVIDEND_INT_VALUE_MSB 23
#define WLAN_LPO_INIT_DIVIDEND_INT_VALUE_LSB 0
#define WLAN_LPO_INIT_DIVIDEND_INT_VALUE_MASK 0x00ffffff
#define WLAN_LPO_INIT_DIVIDEND_INT_VALUE_GET(x) \
    (((x)&WLAN_LPO_INIT_DIVIDEND_INT_VALUE_MASK) >> WLAN_LPO_INIT_DIVIDEND_INT_VALUE_LSB)
#define WLAN_LPO_INIT_DIVIDEND_INT_VALUE_SET(x) \
    (((x) << WLAN_LPO_INIT_DIVIDEND_INT_VALUE_LSB) & WLAN_LPO_INIT_DIVIDEND_INT_VALUE_MASK)

#define WLAN_LPO_INIT_DIVIDEND_FRACTION_ADDRESS 0x000000dc
#define WLAN_LPO_INIT_DIVIDEND_FRACTION_OFFSET 0x000000dc
#define WLAN_LPO_INIT_DIVIDEND_FRACTION_VALUE_MSB 10
#define WLAN_LPO_INIT_DIVIDEND_FRACTION_VALUE_LSB 0
#define WLAN_LPO_INIT_DIVIDEND_FRACTION_VALUE_MASK 0x000007ff
#define WLAN_LPO_INIT_DIVIDEND_FRACTION_VALUE_GET(x) \
    (((x)&WLAN_LPO_INIT_DIVIDEND_FRACTION_VALUE_MASK) >> WLAN_LPO_INIT_DIVIDEND_FRACTION_VALUE_LSB)
#define WLAN_LPO_INIT_DIVIDEND_FRACTION_VALUE_SET(x) \
    (((x) << WLAN_LPO_INIT_DIVIDEND_FRACTION_VALUE_LSB) & WLAN_LPO_INIT_DIVIDEND_FRACTION_VALUE_MASK)

#define WLAN_LPO_CAL_ADDRESS 0x000000e0
#define WLAN_LPO_CAL_OFFSET 0x000000e0
#define WLAN_LPO_CAL_ENABLE_MSB 20
#define WLAN_LPO_CAL_ENABLE_LSB 20
#define WLAN_LPO_CAL_ENABLE_MASK 0x00100000
#define WLAN_LPO_CAL_ENABLE_GET(x) (((x)&WLAN_LPO_CAL_ENABLE_MASK) >> WLAN_LPO_CAL_ENABLE_LSB)
#define WLAN_LPO_CAL_ENABLE_SET(x) (((x) << WLAN_LPO_CAL_ENABLE_LSB) & WLAN_LPO_CAL_ENABLE_MASK)
#define WLAN_LPO_CAL_COUNT_MSB 19
#define WLAN_LPO_CAL_COUNT_LSB 0
#define WLAN_LPO_CAL_COUNT_MASK 0x000fffff
#define WLAN_LPO_CAL_COUNT_GET(x) (((x)&WLAN_LPO_CAL_COUNT_MASK) >> WLAN_LPO_CAL_COUNT_LSB)
#define WLAN_LPO_CAL_COUNT_SET(x) (((x) << WLAN_LPO_CAL_COUNT_LSB) & WLAN_LPO_CAL_COUNT_MASK)

#define WLAN_LPO_CAL_TEST_CONTROL_ADDRESS 0x000000e4
#define WLAN_LPO_CAL_TEST_CONTROL_OFFSET 0x000000e4
#define WLAN_LPO_CAL_TEST_CONTROL_ENABLE_MSB 5
#define WLAN_LPO_CAL_TEST_CONTROL_ENABLE_LSB 5
#define WLAN_LPO_CAL_TEST_CONTROL_ENABLE_MASK 0x00000020
#define WLAN_LPO_CAL_TEST_CONTROL_ENABLE_GET(x) \
    (((x)&WLAN_LPO_CAL_TEST_CONTROL_ENABLE_MASK) >> WLAN_LPO_CAL_TEST_CONTROL_ENABLE_LSB)
#define WLAN_LPO_CAL_TEST_CONTROL_ENABLE_SET(x) \
    (((x) << WLAN_LPO_CAL_TEST_CONTROL_ENABLE_LSB) & WLAN_LPO_CAL_TEST_CONTROL_ENABLE_MASK)
#define WLAN_LPO_CAL_TEST_CONTROL_RTC_CYCLES_MSB 4
#define WLAN_LPO_CAL_TEST_CONTROL_RTC_CYCLES_LSB 0
#define WLAN_LPO_CAL_TEST_CONTROL_RTC_CYCLES_MASK 0x0000001f
#define WLAN_LPO_CAL_TEST_CONTROL_RTC_CYCLES_GET(x) \
    (((x)&WLAN_LPO_CAL_TEST_CONTROL_RTC_CYCLES_MASK) >> WLAN_LPO_CAL_TEST_CONTROL_RTC_CYCLES_LSB)
#define WLAN_LPO_CAL_TEST_CONTROL_RTC_CYCLES_SET(x) \
    (((x) << WLAN_LPO_CAL_TEST_CONTROL_RTC_CYCLES_LSB) & WLAN_LPO_CAL_TEST_CONTROL_RTC_CYCLES_MASK)

#define WLAN_LPO_CAL_TEST_STATUS_ADDRESS 0x000000e8
#define WLAN_LPO_CAL_TEST_STATUS_OFFSET 0x000000e8
#define WLAN_LPO_CAL_TEST_STATUS_READY_MSB 16
#define WLAN_LPO_CAL_TEST_STATUS_READY_LSB 16
#define WLAN_LPO_CAL_TEST_STATUS_READY_MASK 0x00010000
#define WLAN_LPO_CAL_TEST_STATUS_READY_GET(x) \
    (((x)&WLAN_LPO_CAL_TEST_STATUS_READY_MASK) >> WLAN_LPO_CAL_TEST_STATUS_READY_LSB)
#define WLAN_LPO_CAL_TEST_STATUS_READY_SET(x) \
    (((x) << WLAN_LPO_CAL_TEST_STATUS_READY_LSB) & WLAN_LPO_CAL_TEST_STATUS_READY_MASK)
#define WLAN_LPO_CAL_TEST_STATUS_COUNT_MSB 15
#define WLAN_LPO_CAL_TEST_STATUS_COUNT_LSB 0
#define WLAN_LPO_CAL_TEST_STATUS_COUNT_MASK 0x0000ffff
#define WLAN_LPO_CAL_TEST_STATUS_COUNT_GET(x) \
    (((x)&WLAN_LPO_CAL_TEST_STATUS_COUNT_MASK) >> WLAN_LPO_CAL_TEST_STATUS_COUNT_LSB)
#define WLAN_LPO_CAL_TEST_STATUS_COUNT_SET(x) \
    (((x) << WLAN_LPO_CAL_TEST_STATUS_COUNT_LSB) & WLAN_LPO_CAL_TEST_STATUS_COUNT_MASK)

#define WLAN_CHIP_ID_ADDRESS 0x000000ec
#define WLAN_CHIP_ID_OFFSET 0x000000ec
#define WLAN_CHIP_ID_DEVICE_ID_MSB 31
#define WLAN_CHIP_ID_DEVICE_ID_LSB 16
#define WLAN_CHIP_ID_DEVICE_ID_MASK 0xffff0000
#define WLAN_CHIP_ID_DEVICE_ID_GET(x) (((x)&WLAN_CHIP_ID_DEVICE_ID_MASK) >> WLAN_CHIP_ID_DEVICE_ID_LSB)
#define WLAN_CHIP_ID_DEVICE_ID_SET(x) (((x) << WLAN_CHIP_ID_DEVICE_ID_LSB) & WLAN_CHIP_ID_DEVICE_ID_MASK)
#define WLAN_CHIP_ID_CONFIG_ID_MSB 15
#define WLAN_CHIP_ID_CONFIG_ID_LSB 4
#define WLAN_CHIP_ID_CONFIG_ID_MASK 0x0000fff0
#define WLAN_CHIP_ID_CONFIG_ID_GET(x) (((x)&WLAN_CHIP_ID_CONFIG_ID_MASK) >> WLAN_CHIP_ID_CONFIG_ID_LSB)
#define WLAN_CHIP_ID_CONFIG_ID_SET(x) (((x) << WLAN_CHIP_ID_CONFIG_ID_LSB) & WLAN_CHIP_ID_CONFIG_ID_MASK)
#define WLAN_CHIP_ID_VERSION_ID_MSB 3
#define WLAN_CHIP_ID_VERSION_ID_LSB 0
#define WLAN_CHIP_ID_VERSION_ID_MASK 0x0000000f
#define WLAN_CHIP_ID_VERSION_ID_GET(x) (((x)&WLAN_CHIP_ID_VERSION_ID_MASK) >> WLAN_CHIP_ID_VERSION_ID_LSB)
#define WLAN_CHIP_ID_VERSION_ID_SET(x) (((x) << WLAN_CHIP_ID_VERSION_ID_LSB) & WLAN_CHIP_ID_VERSION_ID_MASK)

#define WLAN_DERIVED_RTC_CLK_ADDRESS 0x000000f0
#define WLAN_DERIVED_RTC_CLK_OFFSET 0x000000f0
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_MSB 20
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_LSB 20
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_MASK 0x00100000
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_GET(x) \
    (((x)&WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_MASK) >> WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_LSB)
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_SET(x) \
    (((x) << WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_LSB) & WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_MASK)
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_MSB 18
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_LSB 18
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_MASK 0x00040000
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_GET(x) \
    (((x)&WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_MASK) >> WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_LSB)
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_SET(x) \
    (((x) << WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_LSB) & WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_MASK)
#define WLAN_DERIVED_RTC_CLK_FORCE_MSB 17
#define WLAN_DERIVED_RTC_CLK_FORCE_LSB 16
#define WLAN_DERIVED_RTC_CLK_FORCE_MASK 0x00030000
#define WLAN_DERIVED_RTC_CLK_FORCE_GET(x) (((x)&WLAN_DERIVED_RTC_CLK_FORCE_MASK) >> WLAN_DERIVED_RTC_CLK_FORCE_LSB)
#define WLAN_DERIVED_RTC_CLK_FORCE_SET(x) (((x) << WLAN_DERIVED_RTC_CLK_FORCE_LSB) & WLAN_DERIVED_RTC_CLK_FORCE_MASK)
#define WLAN_DERIVED_RTC_CLK_PERIOD_MSB 15
#define WLAN_DERIVED_RTC_CLK_PERIOD_LSB 1
#define WLAN_DERIVED_RTC_CLK_PERIOD_MASK 0x0000fffe
#define WLAN_DERIVED_RTC_CLK_PERIOD_GET(x) (((x)&WLAN_DERIVED_RTC_CLK_PERIOD_MASK) >> WLAN_DERIVED_RTC_CLK_PERIOD_LSB)
#define WLAN_DERIVED_RTC_CLK_PERIOD_SET(x) (((x) << WLAN_DERIVED_RTC_CLK_PERIOD_LSB) & WLAN_DERIVED_RTC_CLK_PERIOD_MASK)

#define MAC_PCU_SLP32_MODE_ADDRESS 0x000000f4
#define MAC_PCU_SLP32_MODE_OFFSET 0x000000f4
#define MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_MSB 24
#define MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_LSB 24
#define MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_MASK 0x01000000
#define MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_GET(x) \
    (((x)&MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_MASK) >> MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_LSB)
#define MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_SET(x) \
    (((x) << MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_LSB) & MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_MASK)
#define MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_MSB 23
#define MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_LSB 23
#define MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_MASK 0x00800000
#define MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_GET(x) \
    (((x)&MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_MASK) >> MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_LSB)
#define MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_SET(x) \
    (((x) << MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_LSB) & MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_MASK)
#define MAC_PCU_SLP32_MODE_DISABLE_32KHZ_MSB 22
#define MAC_PCU_SLP32_MODE_DISABLE_32KHZ_LSB 22
#define MAC_PCU_SLP32_MODE_DISABLE_32KHZ_MASK 0x00400000
#define MAC_PCU_SLP32_MODE_DISABLE_32KHZ_GET(x) \
    (((x)&MAC_PCU_SLP32_MODE_DISABLE_32KHZ_MASK) >> MAC_PCU_SLP32_MODE_DISABLE_32KHZ_LSB)
#define MAC_PCU_SLP32_MODE_DISABLE_32KHZ_SET(x) \
    (((x) << MAC_PCU_SLP32_MODE_DISABLE_32KHZ_LSB) & MAC_PCU_SLP32_MODE_DISABLE_32KHZ_MASK)
#define MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_MSB 21
#define MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_LSB 21
#define MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_MASK 0x00200000
#define MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_GET(x) \
    (((x)&MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_MASK) >> MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_LSB)
#define MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_SET(x) \
    (((x) << MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_LSB) & MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_MASK)
#define MAC_PCU_SLP32_MODE_ENABLE_MSB 20
#define MAC_PCU_SLP32_MODE_ENABLE_LSB 20
#define MAC_PCU_SLP32_MODE_ENABLE_MASK 0x00100000
#define MAC_PCU_SLP32_MODE_ENABLE_GET(x) (((x)&MAC_PCU_SLP32_MODE_ENABLE_MASK) >> MAC_PCU_SLP32_MODE_ENABLE_LSB)
#define MAC_PCU_SLP32_MODE_ENABLE_SET(x) (((x) << MAC_PCU_SLP32_MODE_ENABLE_LSB) & MAC_PCU_SLP32_MODE_ENABLE_MASK)
#define MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_MSB 19
#define MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_LSB 0
#define MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_MASK 0x000fffff
#define MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_GET(x) \
    (((x)&MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_MASK) >> MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_LSB)
#define MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_SET(x) \
    (((x) << MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_LSB) & MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_MASK)

#define MAC_PCU_SLP32_WAKE_ADDRESS 0x000000f8
#define MAC_PCU_SLP32_WAKE_OFFSET 0x000000f8
#define MAC_PCU_SLP32_WAKE_XTL_TIME_MSB 15
#define MAC_PCU_SLP32_WAKE_XTL_TIME_LSB 0
#define MAC_PCU_SLP32_WAKE_XTL_TIME_MASK 0x0000ffff
#define MAC_PCU_SLP32_WAKE_XTL_TIME_GET(x) (((x)&MAC_PCU_SLP32_WAKE_XTL_TIME_MASK) >> MAC_PCU_SLP32_WAKE_XTL_TIME_LSB)
#define MAC_PCU_SLP32_WAKE_XTL_TIME_SET(x) (((x) << MAC_PCU_SLP32_WAKE_XTL_TIME_LSB) & MAC_PCU_SLP32_WAKE_XTL_TIME_MASK)

#define MAC_PCU_SLP32_INC_ADDRESS 0x000000fc
#define MAC_PCU_SLP32_INC_OFFSET 0x000000fc
#define MAC_PCU_SLP32_INC_TSF_INC_MSB 19
#define MAC_PCU_SLP32_INC_TSF_INC_LSB 0
#define MAC_PCU_SLP32_INC_TSF_INC_MASK 0x000fffff
#define MAC_PCU_SLP32_INC_TSF_INC_GET(x) (((x)&MAC_PCU_SLP32_INC_TSF_INC_MASK) >> MAC_PCU_SLP32_INC_TSF_INC_LSB)
#define MAC_PCU_SLP32_INC_TSF_INC_SET(x) (((x) << MAC_PCU_SLP32_INC_TSF_INC_LSB) & MAC_PCU_SLP32_INC_TSF_INC_MASK)

#define MAC_PCU_SLP_MIB1_ADDRESS 0x00000100
#define MAC_PCU_SLP_MIB1_OFFSET 0x00000100
#define MAC_PCU_SLP_MIB1_SLEEP_CNT_MSB 31
#define MAC_PCU_SLP_MIB1_SLEEP_CNT_LSB 0
#define MAC_PCU_SLP_MIB1_SLEEP_CNT_MASK 0xffffffff
#define MAC_PCU_SLP_MIB1_SLEEP_CNT_GET(x) (((x)&MAC_PCU_SLP_MIB1_SLEEP_CNT_MASK) >> MAC_PCU_SLP_MIB1_SLEEP_CNT_LSB)
#define MAC_PCU_SLP_MIB1_SLEEP_CNT_SET(x) (((x) << MAC_PCU_SLP_MIB1_SLEEP_CNT_LSB) & MAC_PCU_SLP_MIB1_SLEEP_CNT_MASK)

#define MAC_PCU_SLP_MIB2_ADDRESS 0x00000104
#define MAC_PCU_SLP_MIB2_OFFSET 0x00000104
#define MAC_PCU_SLP_MIB2_CYCLE_CNT_MSB 31
#define MAC_PCU_SLP_MIB2_CYCLE_CNT_LSB 0
#define MAC_PCU_SLP_MIB2_CYCLE_CNT_MASK 0xffffffff
#define MAC_PCU_SLP_MIB2_CYCLE_CNT_GET(x) (((x)&MAC_PCU_SLP_MIB2_CYCLE_CNT_MASK) >> MAC_PCU_SLP_MIB2_CYCLE_CNT_LSB)
#define MAC_PCU_SLP_MIB2_CYCLE_CNT_SET(x) (((x) << MAC_PCU_SLP_MIB2_CYCLE_CNT_LSB) & MAC_PCU_SLP_MIB2_CYCLE_CNT_MASK)

#define MAC_PCU_SLP_MIB3_ADDRESS 0x00000108
#define MAC_PCU_SLP_MIB3_OFFSET 0x00000108
#define MAC_PCU_SLP_MIB3_PENDING_MSB 1
#define MAC_PCU_SLP_MIB3_PENDING_LSB 1
#define MAC_PCU_SLP_MIB3_PENDING_MASK 0x00000002
#define MAC_PCU_SLP_MIB3_PENDING_GET(x) (((x)&MAC_PCU_SLP_MIB3_PENDING_MASK) >> MAC_PCU_SLP_MIB3_PENDING_LSB)
#define MAC_PCU_SLP_MIB3_PENDING_SET(x) (((x) << MAC_PCU_SLP_MIB3_PENDING_LSB) & MAC_PCU_SLP_MIB3_PENDING_MASK)
#define MAC_PCU_SLP_MIB3_CLR_CNT_MSB 0
#define MAC_PCU_SLP_MIB3_CLR_CNT_LSB 0
#define MAC_PCU_SLP_MIB3_CLR_CNT_MASK 0x00000001
#define MAC_PCU_SLP_MIB3_CLR_CNT_GET(x) (((x)&MAC_PCU_SLP_MIB3_CLR_CNT_MASK) >> MAC_PCU_SLP_MIB3_CLR_CNT_LSB)
#define MAC_PCU_SLP_MIB3_CLR_CNT_SET(x) (((x) << MAC_PCU_SLP_MIB3_CLR_CNT_LSB) & MAC_PCU_SLP_MIB3_CLR_CNT_MASK)

#define WLAN_POWER_REG_ADDRESS 0x0000010c
#define WLAN_POWER_REG_OFFSET 0x0000010c
#define WLAN_POWER_REG_SLEEP_MAKE_N_BREAK_EN_MSB 15
#define WLAN_POWER_REG_SLEEP_MAKE_N_BREAK_EN_LSB 15
#define WLAN_POWER_REG_SLEEP_MAKE_N_BREAK_EN_MASK 0x00008000
#define WLAN_POWER_REG_SLEEP_MAKE_N_BREAK_EN_GET(x) \
    (((x)&WLAN_POWER_REG_SLEEP_MAKE_N_BREAK_EN_MASK) >> WLAN_POWER_REG_SLEEP_MAKE_N_BREAK_EN_LSB)
#define WLAN_POWER_REG_SLEEP_MAKE_N_BREAK_EN_SET(x) \
    (((x) << WLAN_POWER_REG_SLEEP_MAKE_N_BREAK_EN_LSB) & WLAN_POWER_REG_SLEEP_MAKE_N_BREAK_EN_MASK)
#define WLAN_POWER_REG_DEBUG_EN_MSB 14
#define WLAN_POWER_REG_DEBUG_EN_LSB 14
#define WLAN_POWER_REG_DEBUG_EN_MASK 0x00004000
#define WLAN_POWER_REG_DEBUG_EN_GET(x) (((x)&WLAN_POWER_REG_DEBUG_EN_MASK) >> WLAN_POWER_REG_DEBUG_EN_LSB)
#define WLAN_POWER_REG_DEBUG_EN_SET(x) (((x) << WLAN_POWER_REG_DEBUG_EN_LSB) & WLAN_POWER_REG_DEBUG_EN_MASK)
#define WLAN_POWER_REG_WLAN_BB_PWD_EN_MSB 13
#define WLAN_POWER_REG_WLAN_BB_PWD_EN_LSB 13
#define WLAN_POWER_REG_WLAN_BB_PWD_EN_MASK 0x00002000
#define WLAN_POWER_REG_WLAN_BB_PWD_EN_GET(x) \
    (((x)&WLAN_POWER_REG_WLAN_BB_PWD_EN_MASK) >> WLAN_POWER_REG_WLAN_BB_PWD_EN_LSB)
#define WLAN_POWER_REG_WLAN_BB_PWD_EN_SET(x) \
    (((x) << WLAN_POWER_REG_WLAN_BB_PWD_EN_LSB) & WLAN_POWER_REG_WLAN_BB_PWD_EN_MASK)
#define WLAN_POWER_REG_WLAN_MAC_PWD_EN_MSB 12
#define WLAN_POWER_REG_WLAN_MAC_PWD_EN_LSB 12
#define WLAN_POWER_REG_WLAN_MAC_PWD_EN_MASK 0x00001000
#define WLAN_POWER_REG_WLAN_MAC_PWD_EN_GET(x) \
    (((x)&WLAN_POWER_REG_WLAN_MAC_PWD_EN_MASK) >> WLAN_POWER_REG_WLAN_MAC_PWD_EN_LSB)
#define WLAN_POWER_REG_WLAN_MAC_PWD_EN_SET(x) \
    (((x) << WLAN_POWER_REG_WLAN_MAC_PWD_EN_LSB) & WLAN_POWER_REG_WLAN_MAC_PWD_EN_MASK)
#define WLAN_POWER_REG_VLVL_MSB 11
#define WLAN_POWER_REG_VLVL_LSB 8
#define WLAN_POWER_REG_VLVL_MASK 0x00000f00
#define WLAN_POWER_REG_VLVL_GET(x) (((x)&WLAN_POWER_REG_VLVL_MASK) >> WLAN_POWER_REG_VLVL_LSB)
#define WLAN_POWER_REG_VLVL_SET(x) (((x) << WLAN_POWER_REG_VLVL_LSB) & WLAN_POWER_REG_VLVL_MASK)
#define WLAN_POWER_REG_CPU_INT_ENABLE_MSB 7
#define WLAN_POWER_REG_CPU_INT_ENABLE_LSB 7
#define WLAN_POWER_REG_CPU_INT_ENABLE_MASK 0x00000080
#define WLAN_POWER_REG_CPU_INT_ENABLE_GET(x) \
    (((x)&WLAN_POWER_REG_CPU_INT_ENABLE_MASK) >> WLAN_POWER_REG_CPU_INT_ENABLE_LSB)
#define WLAN_POWER_REG_CPU_INT_ENABLE_SET(x) \
    (((x) << WLAN_POWER_REG_CPU_INT_ENABLE_LSB) & WLAN_POWER_REG_CPU_INT_ENABLE_MASK)
#define WLAN_POWER_REG_WLAN_ISO_DIS_MSB 6
#define WLAN_POWER_REG_WLAN_ISO_DIS_LSB 6
#define WLAN_POWER_REG_WLAN_ISO_DIS_MASK 0x00000040
#define WLAN_POWER_REG_WLAN_ISO_DIS_GET(x) (((x)&WLAN_POWER_REG_WLAN_ISO_DIS_MASK) >> WLAN_POWER_REG_WLAN_ISO_DIS_LSB)
#define WLAN_POWER_REG_WLAN_ISO_DIS_SET(x) (((x) << WLAN_POWER_REG_WLAN_ISO_DIS_LSB) & WLAN_POWER_REG_WLAN_ISO_DIS_MASK)
#define WLAN_POWER_REG_WLAN_ISO_CNTL_MSB 5
#define WLAN_POWER_REG_WLAN_ISO_CNTL_LSB 5
#define WLAN_POWER_REG_WLAN_ISO_CNTL_MASK 0x00000020
#define WLAN_POWER_REG_WLAN_ISO_CNTL_GET(x) \
    (((x)&WLAN_POWER_REG_WLAN_ISO_CNTL_MASK) >> WLAN_POWER_REG_WLAN_ISO_CNTL_LSB)
#define WLAN_POWER_REG_WLAN_ISO_CNTL_SET(x) \
    (((x) << WLAN_POWER_REG_WLAN_ISO_CNTL_LSB) & WLAN_POWER_REG_WLAN_ISO_CNTL_MASK)
#define WLAN_POWER_REG_RADIO_PWD_EN_MSB 4
#define WLAN_POWER_REG_RADIO_PWD_EN_LSB 4
#define WLAN_POWER_REG_RADIO_PWD_EN_MASK 0x00000010
#define WLAN_POWER_REG_RADIO_PWD_EN_GET(x) (((x)&WLAN_POWER_REG_RADIO_PWD_EN_MASK) >> WLAN_POWER_REG_RADIO_PWD_EN_LSB)
#define WLAN_POWER_REG_RADIO_PWD_EN_SET(x) (((x) << WLAN_POWER_REG_RADIO_PWD_EN_LSB) & WLAN_POWER_REG_RADIO_PWD_EN_MASK)
#define WLAN_POWER_REG_SOC_ISO_EN_MSB 3
#define WLAN_POWER_REG_SOC_ISO_EN_LSB 3
#define WLAN_POWER_REG_SOC_ISO_EN_MASK 0x00000008
#define WLAN_POWER_REG_SOC_ISO_EN_GET(x) (((x)&WLAN_POWER_REG_SOC_ISO_EN_MASK) >> WLAN_POWER_REG_SOC_ISO_EN_LSB)
#define WLAN_POWER_REG_SOC_ISO_EN_SET(x) (((x) << WLAN_POWER_REG_SOC_ISO_EN_LSB) & WLAN_POWER_REG_SOC_ISO_EN_MASK)
#define WLAN_POWER_REG_WLAN_ISO_EN_MSB 2
#define WLAN_POWER_REG_WLAN_ISO_EN_LSB 2
#define WLAN_POWER_REG_WLAN_ISO_EN_MASK 0x00000004
#define WLAN_POWER_REG_WLAN_ISO_EN_GET(x) (((x)&WLAN_POWER_REG_WLAN_ISO_EN_MASK) >> WLAN_POWER_REG_WLAN_ISO_EN_LSB)
#define WLAN_POWER_REG_WLAN_ISO_EN_SET(x) (((x) << WLAN_POWER_REG_WLAN_ISO_EN_LSB) & WLAN_POWER_REG_WLAN_ISO_EN_MASK)
#define WLAN_POWER_REG_WLAN_PWD_EN_MSB 1
#define WLAN_POWER_REG_WLAN_PWD_EN_LSB 1
#define WLAN_POWER_REG_WLAN_PWD_EN_MASK 0x00000002
#define WLAN_POWER_REG_WLAN_PWD_EN_GET(x) (((x)&WLAN_POWER_REG_WLAN_PWD_EN_MASK) >> WLAN_POWER_REG_WLAN_PWD_EN_LSB)
#define WLAN_POWER_REG_WLAN_PWD_EN_SET(x) (((x) << WLAN_POWER_REG_WLAN_PWD_EN_LSB) & WLAN_POWER_REG_WLAN_PWD_EN_MASK)
#define WLAN_POWER_REG_POWER_EN_MSB 0
#define WLAN_POWER_REG_POWER_EN_LSB 0
#define WLAN_POWER_REG_POWER_EN_MASK 0x00000001
#define WLAN_POWER_REG_POWER_EN_GET(x) (((x)&WLAN_POWER_REG_POWER_EN_MASK) >> WLAN_POWER_REG_POWER_EN_LSB)
#define WLAN_POWER_REG_POWER_EN_SET(x) (((x) << WLAN_POWER_REG_POWER_EN_LSB) & WLAN_POWER_REG_POWER_EN_MASK)

#define WLAN_CORE_CLK_CTRL_ADDRESS 0x00000110
#define WLAN_CORE_CLK_CTRL_OFFSET 0x00000110
#define WLAN_CORE_CLK_CTRL_DIV_MSB 2
#define WLAN_CORE_CLK_CTRL_DIV_LSB 0
#define WLAN_CORE_CLK_CTRL_DIV_MASK 0x00000007
#define WLAN_CORE_CLK_CTRL_DIV_GET(x) (((x)&WLAN_CORE_CLK_CTRL_DIV_MASK) >> WLAN_CORE_CLK_CTRL_DIV_LSB)
#define WLAN_CORE_CLK_CTRL_DIV_SET(x) (((x) << WLAN_CORE_CLK_CTRL_DIV_LSB) & WLAN_CORE_CLK_CTRL_DIV_MASK)

#define WLAN_GPIO_WAKEUP_CONTROL_ADDRESS 0x00000114
#define WLAN_GPIO_WAKEUP_CONTROL_OFFSET 0x00000114
#define WLAN_GPIO_WAKEUP_CONTROL_ENABLE_MSB 0
#define WLAN_GPIO_WAKEUP_CONTROL_ENABLE_LSB 0
#define WLAN_GPIO_WAKEUP_CONTROL_ENABLE_MASK 0x00000001
#define WLAN_GPIO_WAKEUP_CONTROL_ENABLE_GET(x) \
    (((x)&WLAN_GPIO_WAKEUP_CONTROL_ENABLE_MASK) >> WLAN_GPIO_WAKEUP_CONTROL_ENABLE_LSB)
#define WLAN_GPIO_WAKEUP_CONTROL_ENABLE_SET(x) \
    (((x) << WLAN_GPIO_WAKEUP_CONTROL_ENABLE_LSB) & WLAN_GPIO_WAKEUP_CONTROL_ENABLE_MASK)

#define HT_ADDRESS 0x00000118
#define HT_OFFSET 0x00000118
#define HT_MODE_MSB 0
#define HT_MODE_LSB 0
#define HT_MODE_MASK 0x00000001
#define HT_MODE_GET(x) (((x)&HT_MODE_MASK) >> HT_MODE_LSB)
#define HT_MODE_SET(x) (((x) << HT_MODE_LSB) & HT_MODE_MASK)

#define MAC_PCU_TSF_L32_ADDRESS 0x0000011c
#define MAC_PCU_TSF_L32_OFFSET 0x0000011c
#define MAC_PCU_TSF_L32_VALUE_MSB 31
#define MAC_PCU_TSF_L32_VALUE_LSB 0
#define MAC_PCU_TSF_L32_VALUE_MASK 0xffffffff
#define MAC_PCU_TSF_L32_VALUE_GET(x) (((x)&MAC_PCU_TSF_L32_VALUE_MASK) >> MAC_PCU_TSF_L32_VALUE_LSB)
#define MAC_PCU_TSF_L32_VALUE_SET(x) (((x) << MAC_PCU_TSF_L32_VALUE_LSB) & MAC_PCU_TSF_L32_VALUE_MASK)

#define MAC_PCU_TSF_U32_ADDRESS 0x00000120
#define MAC_PCU_TSF_U32_OFFSET 0x00000120
#define MAC_PCU_TSF_U32_VALUE_MSB 31
#define MAC_PCU_TSF_U32_VALUE_LSB 0
#define MAC_PCU_TSF_U32_VALUE_MASK 0xffffffff
#define MAC_PCU_TSF_U32_VALUE_GET(x) (((x)&MAC_PCU_TSF_U32_VALUE_MASK) >> MAC_PCU_TSF_U32_VALUE_LSB)
#define MAC_PCU_TSF_U32_VALUE_SET(x) (((x) << MAC_PCU_TSF_U32_VALUE_LSB) & MAC_PCU_TSF_U32_VALUE_MASK)

#define MAC_PCU_WBTIMER_ADDRESS 0x00000124
#define MAC_PCU_WBTIMER_OFFSET 0x00000124
#define MAC_PCU_WBTIMER_VALUE_MSB 31
#define MAC_PCU_WBTIMER_VALUE_LSB 0
#define MAC_PCU_WBTIMER_VALUE_MASK 0xffffffff
#define MAC_PCU_WBTIMER_VALUE_GET(x) (((x)&MAC_PCU_WBTIMER_VALUE_MASK) >> MAC_PCU_WBTIMER_VALUE_LSB)
#define MAC_PCU_WBTIMER_VALUE_SET(x) (((x) << MAC_PCU_WBTIMER_VALUE_LSB) & MAC_PCU_WBTIMER_VALUE_MASK)

#define MAC_PCU_GENERIC_TIMERS_ADDRESS 0x00000140
#define MAC_PCU_GENERIC_TIMERS_OFFSET 0x00000140
#define MAC_PCU_GENERIC_TIMERS_DATA_MSB 31
#define MAC_PCU_GENERIC_TIMERS_DATA_LSB 0
#define MAC_PCU_GENERIC_TIMERS_DATA_MASK 0xffffffff
#define MAC_PCU_GENERIC_TIMERS_DATA_GET(x) (((x)&MAC_PCU_GENERIC_TIMERS_DATA_MASK) >> MAC_PCU_GENERIC_TIMERS_DATA_LSB)
#define MAC_PCU_GENERIC_TIMERS_DATA_SET(x) (((x) << MAC_PCU_GENERIC_TIMERS_DATA_LSB) & MAC_PCU_GENERIC_TIMERS_DATA_MASK)

#define MAC_PCU_GENERIC_TIMERS_MODE_ADDRESS 0x00000180
#define MAC_PCU_GENERIC_TIMERS_MODE_OFFSET 0x00000180
#define MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_MSB 15
#define MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_LSB 0
#define MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_MASK 0x0000ffff
#define MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_GET(x) \
    (((x)&MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_MASK) >> MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_LSB)
#define MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_SET(x) \
    (((x) << MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_LSB) & MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_MASK)

#define MAC_PCU_GENERIC_TIMERS2_ADDRESS 0x000001c0
#define MAC_PCU_GENERIC_TIMERS2_OFFSET 0x000001c0
#define MAC_PCU_GENERIC_TIMERS2_DATA_MSB 31
#define MAC_PCU_GENERIC_TIMERS2_DATA_LSB 0
#define MAC_PCU_GENERIC_TIMERS2_DATA_MASK 0xffffffff
#define MAC_PCU_GENERIC_TIMERS2_DATA_GET(x) \
    (((x)&MAC_PCU_GENERIC_TIMERS2_DATA_MASK) >> MAC_PCU_GENERIC_TIMERS2_DATA_LSB)
#define MAC_PCU_GENERIC_TIMERS2_DATA_SET(x) \
    (((x) << MAC_PCU_GENERIC_TIMERS2_DATA_LSB) & MAC_PCU_GENERIC_TIMERS2_DATA_MASK)

#define MAC_PCU_GENERIC_TIMERS_MODE2_ADDRESS 0x00000200
#define MAC_PCU_GENERIC_TIMERS_MODE2_OFFSET 0x00000200
#define MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_MSB 15
#define MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_LSB 0
#define MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_MASK 0x0000ffff
#define MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_GET(x) \
    (((x)&MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_MASK) >> MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_LSB)
#define MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_SET(x) \
    (((x) << MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_LSB) & MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_MASK)

#define MAC_PCU_SLP1_ADDRESS 0x00000204
#define MAC_PCU_SLP1_OFFSET 0x00000204
#define MAC_PCU_SLP1_ASSUME_DTIM_MSB 19
#define MAC_PCU_SLP1_ASSUME_DTIM_LSB 19
#define MAC_PCU_SLP1_ASSUME_DTIM_MASK 0x00080000
#define MAC_PCU_SLP1_ASSUME_DTIM_GET(x) (((x)&MAC_PCU_SLP1_ASSUME_DTIM_MASK) >> MAC_PCU_SLP1_ASSUME_DTIM_LSB)
#define MAC_PCU_SLP1_ASSUME_DTIM_SET(x) (((x) << MAC_PCU_SLP1_ASSUME_DTIM_LSB) & MAC_PCU_SLP1_ASSUME_DTIM_MASK)
#define MAC_PCU_SLP1_CAB_TIMEOUT_MSB 15
#define MAC_PCU_SLP1_CAB_TIMEOUT_LSB 0
#define MAC_PCU_SLP1_CAB_TIMEOUT_MASK 0x0000ffff
#define MAC_PCU_SLP1_CAB_TIMEOUT_GET(x) (((x)&MAC_PCU_SLP1_CAB_TIMEOUT_MASK) >> MAC_PCU_SLP1_CAB_TIMEOUT_LSB)
#define MAC_PCU_SLP1_CAB_TIMEOUT_SET(x) (((x) << MAC_PCU_SLP1_CAB_TIMEOUT_LSB) & MAC_PCU_SLP1_CAB_TIMEOUT_MASK)

#define MAC_PCU_SLP2_ADDRESS 0x00000208
#define MAC_PCU_SLP2_OFFSET 0x00000208
#define MAC_PCU_SLP2_BEACON_TIMEOUT_MSB 15
#define MAC_PCU_SLP2_BEACON_TIMEOUT_LSB 0
#define MAC_PCU_SLP2_BEACON_TIMEOUT_MASK 0x0000ffff
#define MAC_PCU_SLP2_BEACON_TIMEOUT_GET(x) (((x)&MAC_PCU_SLP2_BEACON_TIMEOUT_MASK) >> MAC_PCU_SLP2_BEACON_TIMEOUT_LSB)
#define MAC_PCU_SLP2_BEACON_TIMEOUT_SET(x) (((x) << MAC_PCU_SLP2_BEACON_TIMEOUT_LSB) & MAC_PCU_SLP2_BEACON_TIMEOUT_MASK)

#define MAC_PCU_RESET_TSF_ADDRESS 0x0000020c
#define MAC_PCU_RESET_TSF_OFFSET 0x0000020c
#define MAC_PCU_RESET_TSF_ONE_SHOT2_MSB 25
#define MAC_PCU_RESET_TSF_ONE_SHOT2_LSB 25
#define MAC_PCU_RESET_TSF_ONE_SHOT2_MASK 0x02000000
#define MAC_PCU_RESET_TSF_ONE_SHOT2_GET(x) (((x)&MAC_PCU_RESET_TSF_ONE_SHOT2_MASK) >> MAC_PCU_RESET_TSF_ONE_SHOT2_LSB)
#define MAC_PCU_RESET_TSF_ONE_SHOT2_SET(x) (((x) << MAC_PCU_RESET_TSF_ONE_SHOT2_LSB) & MAC_PCU_RESET_TSF_ONE_SHOT2_MASK)
#define MAC_PCU_RESET_TSF_ONE_SHOT_MSB 24
#define MAC_PCU_RESET_TSF_ONE_SHOT_LSB 24
#define MAC_PCU_RESET_TSF_ONE_SHOT_MASK 0x01000000
#define MAC_PCU_RESET_TSF_ONE_SHOT_GET(x) (((x)&MAC_PCU_RESET_TSF_ONE_SHOT_MASK) >> MAC_PCU_RESET_TSF_ONE_SHOT_LSB)
#define MAC_PCU_RESET_TSF_ONE_SHOT_SET(x) (((x) << MAC_PCU_RESET_TSF_ONE_SHOT_LSB) & MAC_PCU_RESET_TSF_ONE_SHOT_MASK)

#define MAC_PCU_TSF_ADD_PLL_ADDRESS 0x00000210
#define MAC_PCU_TSF_ADD_PLL_OFFSET 0x00000210
#define MAC_PCU_TSF_ADD_PLL_VALUE_MSB 7
#define MAC_PCU_TSF_ADD_PLL_VALUE_LSB 0
#define MAC_PCU_TSF_ADD_PLL_VALUE_MASK 0x000000ff
#define MAC_PCU_TSF_ADD_PLL_VALUE_GET(x) (((x)&MAC_PCU_TSF_ADD_PLL_VALUE_MASK) >> MAC_PCU_TSF_ADD_PLL_VALUE_LSB)
#define MAC_PCU_TSF_ADD_PLL_VALUE_SET(x) (((x) << MAC_PCU_TSF_ADD_PLL_VALUE_LSB) & MAC_PCU_TSF_ADD_PLL_VALUE_MASK)

#define SLEEP_RETENTION_ADDRESS 0x00000214
#define SLEEP_RETENTION_OFFSET 0x00000214
#define SLEEP_RETENTION_TIME_MSB 9
#define SLEEP_RETENTION_TIME_LSB 2
#define SLEEP_RETENTION_TIME_MASK 0x000003fc
#define SLEEP_RETENTION_TIME_GET(x) (((x)&SLEEP_RETENTION_TIME_MASK) >> SLEEP_RETENTION_TIME_LSB)
#define SLEEP_RETENTION_TIME_SET(x) (((x) << SLEEP_RETENTION_TIME_LSB) & SLEEP_RETENTION_TIME_MASK)
#define SLEEP_RETENTION_MODE_MSB 1
#define SLEEP_RETENTION_MODE_LSB 1
#define SLEEP_RETENTION_MODE_MASK 0x00000002
#define SLEEP_RETENTION_MODE_GET(x) (((x)&SLEEP_RETENTION_MODE_MASK) >> SLEEP_RETENTION_MODE_LSB)
#define SLEEP_RETENTION_MODE_SET(x) (((x) << SLEEP_RETENTION_MODE_LSB) & SLEEP_RETENTION_MODE_MASK)
#define SLEEP_RETENTION_ENABLE_MSB 0
#define SLEEP_RETENTION_ENABLE_LSB 0
#define SLEEP_RETENTION_ENABLE_MASK 0x00000001
#define SLEEP_RETENTION_ENABLE_GET(x) (((x)&SLEEP_RETENTION_ENABLE_MASK) >> SLEEP_RETENTION_ENABLE_LSB)
#define SLEEP_RETENTION_ENABLE_SET(x) (((x) << SLEEP_RETENTION_ENABLE_LSB) & SLEEP_RETENTION_ENABLE_MASK)

#define BTCOEXCTRL_ADDRESS 0x00000218
#define BTCOEXCTRL_OFFSET 0x00000218
#define BTCOEXCTRL_WBTIMER_ENABLE_MSB 26
#define BTCOEXCTRL_WBTIMER_ENABLE_LSB 26
#define BTCOEXCTRL_WBTIMER_ENABLE_MASK 0x04000000
#define BTCOEXCTRL_WBTIMER_ENABLE_GET(x) (((x)&BTCOEXCTRL_WBTIMER_ENABLE_MASK) >> BTCOEXCTRL_WBTIMER_ENABLE_LSB)
#define BTCOEXCTRL_WBTIMER_ENABLE_SET(x) (((x) << BTCOEXCTRL_WBTIMER_ENABLE_LSB) & BTCOEXCTRL_WBTIMER_ENABLE_MASK)
#define BTCOEXCTRL_WBSYNC_ON_BEACON_MSB 25
#define BTCOEXCTRL_WBSYNC_ON_BEACON_LSB 25
#define BTCOEXCTRL_WBSYNC_ON_BEACON_MASK 0x02000000
#define BTCOEXCTRL_WBSYNC_ON_BEACON_GET(x) (((x)&BTCOEXCTRL_WBSYNC_ON_BEACON_MASK) >> BTCOEXCTRL_WBSYNC_ON_BEACON_LSB)
#define BTCOEXCTRL_WBSYNC_ON_BEACON_SET(x) (((x) << BTCOEXCTRL_WBSYNC_ON_BEACON_LSB) & BTCOEXCTRL_WBSYNC_ON_BEACON_MASK)
#define BTCOEXCTRL_PTA_MODE_MSB 24
#define BTCOEXCTRL_PTA_MODE_LSB 23
#define BTCOEXCTRL_PTA_MODE_MASK 0x01800000
#define BTCOEXCTRL_PTA_MODE_GET(x) (((x)&BTCOEXCTRL_PTA_MODE_MASK) >> BTCOEXCTRL_PTA_MODE_LSB)
#define BTCOEXCTRL_PTA_MODE_SET(x) (((x) << BTCOEXCTRL_PTA_MODE_LSB) & BTCOEXCTRL_PTA_MODE_MASK)
#define BTCOEXCTRL_FREQ_TIME_MSB 22
#define BTCOEXCTRL_FREQ_TIME_LSB 18
#define BTCOEXCTRL_FREQ_TIME_MASK 0x007c0000
#define BTCOEXCTRL_FREQ_TIME_GET(x) (((x)&BTCOEXCTRL_FREQ_TIME_MASK) >> BTCOEXCTRL_FREQ_TIME_LSB)
#define BTCOEXCTRL_FREQ_TIME_SET(x) (((x) << BTCOEXCTRL_FREQ_TIME_LSB) & BTCOEXCTRL_FREQ_TIME_MASK)
#define BTCOEXCTRL_PRIORITY_TIME_MSB 17
#define BTCOEXCTRL_PRIORITY_TIME_LSB 12
#define BTCOEXCTRL_PRIORITY_TIME_MASK 0x0003f000
#define BTCOEXCTRL_PRIORITY_TIME_GET(x) (((x)&BTCOEXCTRL_PRIORITY_TIME_MASK) >> BTCOEXCTRL_PRIORITY_TIME_LSB)
#define BTCOEXCTRL_PRIORITY_TIME_SET(x) (((x) << BTCOEXCTRL_PRIORITY_TIME_LSB) & BTCOEXCTRL_PRIORITY_TIME_MASK)
#define BTCOEXCTRL_SYNC_DET_EN_MSB 11
#define BTCOEXCTRL_SYNC_DET_EN_LSB 11
#define BTCOEXCTRL_SYNC_DET_EN_MASK 0x00000800
#define BTCOEXCTRL_SYNC_DET_EN_GET(x) (((x)&BTCOEXCTRL_SYNC_DET_EN_MASK) >> BTCOEXCTRL_SYNC_DET_EN_LSB)
#define BTCOEXCTRL_SYNC_DET_EN_SET(x) (((x) << BTCOEXCTRL_SYNC_DET_EN_LSB) & BTCOEXCTRL_SYNC_DET_EN_MASK)
#define BTCOEXCTRL_IDLE_CNT_EN_MSB 10
#define BTCOEXCTRL_IDLE_CNT_EN_LSB 10
#define BTCOEXCTRL_IDLE_CNT_EN_MASK 0x00000400
#define BTCOEXCTRL_IDLE_CNT_EN_GET(x) (((x)&BTCOEXCTRL_IDLE_CNT_EN_MASK) >> BTCOEXCTRL_IDLE_CNT_EN_LSB)
#define BTCOEXCTRL_IDLE_CNT_EN_SET(x) (((x) << BTCOEXCTRL_IDLE_CNT_EN_LSB) & BTCOEXCTRL_IDLE_CNT_EN_MASK)
#define BTCOEXCTRL_FRAME_CNT_EN_MSB 9
#define BTCOEXCTRL_FRAME_CNT_EN_LSB 9
#define BTCOEXCTRL_FRAME_CNT_EN_MASK 0x00000200
#define BTCOEXCTRL_FRAME_CNT_EN_GET(x) (((x)&BTCOEXCTRL_FRAME_CNT_EN_MASK) >> BTCOEXCTRL_FRAME_CNT_EN_LSB)
#define BTCOEXCTRL_FRAME_CNT_EN_SET(x) (((x) << BTCOEXCTRL_FRAME_CNT_EN_LSB) & BTCOEXCTRL_FRAME_CNT_EN_MASK)
#define BTCOEXCTRL_CLK_CNT_EN_MSB 8
#define BTCOEXCTRL_CLK_CNT_EN_LSB 8
#define BTCOEXCTRL_CLK_CNT_EN_MASK 0x00000100
#define BTCOEXCTRL_CLK_CNT_EN_GET(x) (((x)&BTCOEXCTRL_CLK_CNT_EN_MASK) >> BTCOEXCTRL_CLK_CNT_EN_LSB)
#define BTCOEXCTRL_CLK_CNT_EN_SET(x) (((x) << BTCOEXCTRL_CLK_CNT_EN_LSB) & BTCOEXCTRL_CLK_CNT_EN_MASK)
#define BTCOEXCTRL_GAP_MSB 7
#define BTCOEXCTRL_GAP_LSB 0
#define BTCOEXCTRL_GAP_MASK 0x000000ff
#define BTCOEXCTRL_GAP_GET(x) (((x)&BTCOEXCTRL_GAP_MASK) >> BTCOEXCTRL_GAP_LSB)
#define BTCOEXCTRL_GAP_SET(x) (((x) << BTCOEXCTRL_GAP_LSB) & BTCOEXCTRL_GAP_MASK)

#define WBSYNC_PRIORITY1_ADDRESS 0x0000021c
#define WBSYNC_PRIORITY1_OFFSET 0x0000021c
#define WBSYNC_PRIORITY1_BITMAP_MSB 31
#define WBSYNC_PRIORITY1_BITMAP_LSB 0
#define WBSYNC_PRIORITY1_BITMAP_MASK 0xffffffff
#define WBSYNC_PRIORITY1_BITMAP_GET(x) (((x)&WBSYNC_PRIORITY1_BITMAP_MASK) >> WBSYNC_PRIORITY1_BITMAP_LSB)
#define WBSYNC_PRIORITY1_BITMAP_SET(x) (((x) << WBSYNC_PRIORITY1_BITMAP_LSB) & WBSYNC_PRIORITY1_BITMAP_MASK)

#define WBSYNC_PRIORITY2_ADDRESS 0x00000220
#define WBSYNC_PRIORITY2_OFFSET 0x00000220
#define WBSYNC_PRIORITY2_BITMAP_MSB 31
#define WBSYNC_PRIORITY2_BITMAP_LSB 0
#define WBSYNC_PRIORITY2_BITMAP_MASK 0xffffffff
#define WBSYNC_PRIORITY2_BITMAP_GET(x) (((x)&WBSYNC_PRIORITY2_BITMAP_MASK) >> WBSYNC_PRIORITY2_BITMAP_LSB)
#define WBSYNC_PRIORITY2_BITMAP_SET(x) (((x) << WBSYNC_PRIORITY2_BITMAP_LSB) & WBSYNC_PRIORITY2_BITMAP_MASK)

#define WBSYNC_PRIORITY3_ADDRESS 0x00000224
#define WBSYNC_PRIORITY3_OFFSET 0x00000224
#define WBSYNC_PRIORITY3_BITMAP_MSB 31
#define WBSYNC_PRIORITY3_BITMAP_LSB 0
#define WBSYNC_PRIORITY3_BITMAP_MASK 0xffffffff
#define WBSYNC_PRIORITY3_BITMAP_GET(x) (((x)&WBSYNC_PRIORITY3_BITMAP_MASK) >> WBSYNC_PRIORITY3_BITMAP_LSB)
#define WBSYNC_PRIORITY3_BITMAP_SET(x) (((x) << WBSYNC_PRIORITY3_BITMAP_LSB) & WBSYNC_PRIORITY3_BITMAP_MASK)

#define BTCOEX0_ADDRESS 0x00000228
#define BTCOEX0_OFFSET 0x00000228
#define BTCOEX0_SYNC_DUR_MSB 7
#define BTCOEX0_SYNC_DUR_LSB 0
#define BTCOEX0_SYNC_DUR_MASK 0x000000ff
#define BTCOEX0_SYNC_DUR_GET(x) (((x)&BTCOEX0_SYNC_DUR_MASK) >> BTCOEX0_SYNC_DUR_LSB)
#define BTCOEX0_SYNC_DUR_SET(x) (((x) << BTCOEX0_SYNC_DUR_LSB) & BTCOEX0_SYNC_DUR_MASK)

#define BTCOEX1_ADDRESS 0x0000022c
#define BTCOEX1_OFFSET 0x0000022c
#define BTCOEX1_CLK_THRES_MSB 20
#define BTCOEX1_CLK_THRES_LSB 0
#define BTCOEX1_CLK_THRES_MASK 0x001fffff
#define BTCOEX1_CLK_THRES_GET(x) (((x)&BTCOEX1_CLK_THRES_MASK) >> BTCOEX1_CLK_THRES_LSB)
#define BTCOEX1_CLK_THRES_SET(x) (((x) << BTCOEX1_CLK_THRES_LSB) & BTCOEX1_CLK_THRES_MASK)

#define BTCOEX2_ADDRESS 0x00000230
#define BTCOEX2_OFFSET 0x00000230
#define BTCOEX2_FRAME_THRES_MSB 7
#define BTCOEX2_FRAME_THRES_LSB 0
#define BTCOEX2_FRAME_THRES_MASK 0x000000ff
#define BTCOEX2_FRAME_THRES_GET(x) (((x)&BTCOEX2_FRAME_THRES_MASK) >> BTCOEX2_FRAME_THRES_LSB)
#define BTCOEX2_FRAME_THRES_SET(x) (((x) << BTCOEX2_FRAME_THRES_LSB) & BTCOEX2_FRAME_THRES_MASK)

#define BTCOEX3_ADDRESS 0x00000234
#define BTCOEX3_OFFSET 0x00000234
#define BTCOEX3_CLK_CNT_MSB 20
#define BTCOEX3_CLK_CNT_LSB 0
#define BTCOEX3_CLK_CNT_MASK 0x001fffff
#define BTCOEX3_CLK_CNT_GET(x) (((x)&BTCOEX3_CLK_CNT_MASK) >> BTCOEX3_CLK_CNT_LSB)
#define BTCOEX3_CLK_CNT_SET(x) (((x) << BTCOEX3_CLK_CNT_LSB) & BTCOEX3_CLK_CNT_MASK)

#define BTCOEX4_ADDRESS 0x00000238
#define BTCOEX4_OFFSET 0x00000238
#define BTCOEX4_FRAME_CNT_MSB 7
#define BTCOEX4_FRAME_CNT_LSB 0
#define BTCOEX4_FRAME_CNT_MASK 0x000000ff
#define BTCOEX4_FRAME_CNT_GET(x) (((x)&BTCOEX4_FRAME_CNT_MASK) >> BTCOEX4_FRAME_CNT_LSB)
#define BTCOEX4_FRAME_CNT_SET(x) (((x) << BTCOEX4_FRAME_CNT_LSB) & BTCOEX4_FRAME_CNT_MASK)

#define BTCOEX5_ADDRESS 0x0000023c
#define BTCOEX5_OFFSET 0x0000023c
#define BTCOEX5_IDLE_CNT_MSB 15
#define BTCOEX5_IDLE_CNT_LSB 0
#define BTCOEX5_IDLE_CNT_MASK 0x0000ffff
#define BTCOEX5_IDLE_CNT_GET(x) (((x)&BTCOEX5_IDLE_CNT_MASK) >> BTCOEX5_IDLE_CNT_LSB)
#define BTCOEX5_IDLE_CNT_SET(x) (((x) << BTCOEX5_IDLE_CNT_LSB) & BTCOEX5_IDLE_CNT_MASK)

#define BTCOEX6_ADDRESS 0x00000240
#define BTCOEX6_OFFSET 0x00000240
#define BTCOEX6_IDLE_RESET_LVL_BITMAP_MSB 31
#define BTCOEX6_IDLE_RESET_LVL_BITMAP_LSB 0
#define BTCOEX6_IDLE_RESET_LVL_BITMAP_MASK 0xffffffff
#define BTCOEX6_IDLE_RESET_LVL_BITMAP_GET(x) \
    (((x)&BTCOEX6_IDLE_RESET_LVL_BITMAP_MASK) >> BTCOEX6_IDLE_RESET_LVL_BITMAP_LSB)
#define BTCOEX6_IDLE_RESET_LVL_BITMAP_SET(x) \
    (((x) << BTCOEX6_IDLE_RESET_LVL_BITMAP_LSB) & BTCOEX6_IDLE_RESET_LVL_BITMAP_MASK)

#define LOCK_ADDRESS 0x00000244
#define LOCK_OFFSET 0x00000244
#define LOCK_TLOCK_SLAVE_MSB 31
#define LOCK_TLOCK_SLAVE_LSB 24
#define LOCK_TLOCK_SLAVE_MASK 0xff000000
#define LOCK_TLOCK_SLAVE_GET(x) (((x)&LOCK_TLOCK_SLAVE_MASK) >> LOCK_TLOCK_SLAVE_LSB)
#define LOCK_TLOCK_SLAVE_SET(x) (((x) << LOCK_TLOCK_SLAVE_LSB) & LOCK_TLOCK_SLAVE_MASK)
#define LOCK_TUNLOCK_SLAVE_MSB 23
#define LOCK_TUNLOCK_SLAVE_LSB 16
#define LOCK_TUNLOCK_SLAVE_MASK 0x00ff0000
#define LOCK_TUNLOCK_SLAVE_GET(x) (((x)&LOCK_TUNLOCK_SLAVE_MASK) >> LOCK_TUNLOCK_SLAVE_LSB)
#define LOCK_TUNLOCK_SLAVE_SET(x) (((x) << LOCK_TUNLOCK_SLAVE_LSB) & LOCK_TUNLOCK_SLAVE_MASK)
#define LOCK_TLOCK_MASTER_MSB 15
#define LOCK_TLOCK_MASTER_LSB 8
#define LOCK_TLOCK_MASTER_MASK 0x0000ff00
#define LOCK_TLOCK_MASTER_GET(x) (((x)&LOCK_TLOCK_MASTER_MASK) >> LOCK_TLOCK_MASTER_LSB)
#define LOCK_TLOCK_MASTER_SET(x) (((x) << LOCK_TLOCK_MASTER_LSB) & LOCK_TLOCK_MASTER_MASK)
#define LOCK_TUNLOCK_MASTER_MSB 7
#define LOCK_TUNLOCK_MASTER_LSB 0
#define LOCK_TUNLOCK_MASTER_MASK 0x000000ff
#define LOCK_TUNLOCK_MASTER_GET(x) (((x)&LOCK_TUNLOCK_MASTER_MASK) >> LOCK_TUNLOCK_MASTER_LSB)
#define LOCK_TUNLOCK_MASTER_SET(x) (((x) << LOCK_TUNLOCK_MASTER_LSB) & LOCK_TUNLOCK_MASTER_MASK)

#define NOLOCK_PRIORITY_ADDRESS 0x00000248
#define NOLOCK_PRIORITY_OFFSET 0x00000248
#define NOLOCK_PRIORITY_BITMAP_MSB 31
#define NOLOCK_PRIORITY_BITMAP_LSB 0
#define NOLOCK_PRIORITY_BITMAP_MASK 0xffffffff
#define NOLOCK_PRIORITY_BITMAP_GET(x) (((x)&NOLOCK_PRIORITY_BITMAP_MASK) >> NOLOCK_PRIORITY_BITMAP_LSB)
#define NOLOCK_PRIORITY_BITMAP_SET(x) (((x) << NOLOCK_PRIORITY_BITMAP_LSB) & NOLOCK_PRIORITY_BITMAP_MASK)

#define WBSYNC_ADDRESS 0x0000024c
#define WBSYNC_OFFSET 0x0000024c
#define WBSYNC_BTCLOCK_MSB 31
#define WBSYNC_BTCLOCK_LSB 0
#define WBSYNC_BTCLOCK_MASK 0xffffffff
#define WBSYNC_BTCLOCK_GET(x) (((x)&WBSYNC_BTCLOCK_MASK) >> WBSYNC_BTCLOCK_LSB)
#define WBSYNC_BTCLOCK_SET(x) (((x) << WBSYNC_BTCLOCK_LSB) & WBSYNC_BTCLOCK_MASK)

#define WBSYNC1_ADDRESS 0x00000250
#define WBSYNC1_OFFSET 0x00000250
#define WBSYNC1_BTCLOCK_MSB 31
#define WBSYNC1_BTCLOCK_LSB 0
#define WBSYNC1_BTCLOCK_MASK 0xffffffff
#define WBSYNC1_BTCLOCK_GET(x) (((x)&WBSYNC1_BTCLOCK_MASK) >> WBSYNC1_BTCLOCK_LSB)
#define WBSYNC1_BTCLOCK_SET(x) (((x) << WBSYNC1_BTCLOCK_LSB) & WBSYNC1_BTCLOCK_MASK)

#define WBSYNC2_ADDRESS 0x00000254
#define WBSYNC2_OFFSET 0x00000254
#define WBSYNC2_BTCLOCK_MSB 31
#define WBSYNC2_BTCLOCK_LSB 0
#define WBSYNC2_BTCLOCK_MASK 0xffffffff
#define WBSYNC2_BTCLOCK_GET(x) (((x)&WBSYNC2_BTCLOCK_MASK) >> WBSYNC2_BTCLOCK_LSB)
#define WBSYNC2_BTCLOCK_SET(x) (((x) << WBSYNC2_BTCLOCK_LSB) & WBSYNC2_BTCLOCK_MASK)

#define WBSYNC3_ADDRESS 0x00000258
#define WBSYNC3_OFFSET 0x00000258
#define WBSYNC3_BTCLOCK_MSB 31
#define WBSYNC3_BTCLOCK_LSB 0
#define WBSYNC3_BTCLOCK_MASK 0xffffffff
#define WBSYNC3_BTCLOCK_GET(x) (((x)&WBSYNC3_BTCLOCK_MASK) >> WBSYNC3_BTCLOCK_LSB)
#define WBSYNC3_BTCLOCK_SET(x) (((x) << WBSYNC3_BTCLOCK_LSB) & WBSYNC3_BTCLOCK_MASK)

#define WB_TIMER_TARGET_ADDRESS 0x0000025c
#define WB_TIMER_TARGET_OFFSET 0x0000025c
#define WB_TIMER_TARGET_VALUE_MSB 31
#define WB_TIMER_TARGET_VALUE_LSB 0
#define WB_TIMER_TARGET_VALUE_MASK 0xffffffff
#define WB_TIMER_TARGET_VALUE_GET(x) (((x)&WB_TIMER_TARGET_VALUE_MASK) >> WB_TIMER_TARGET_VALUE_LSB)
#define WB_TIMER_TARGET_VALUE_SET(x) (((x) << WB_TIMER_TARGET_VALUE_LSB) & WB_TIMER_TARGET_VALUE_MASK)

#define WB_TIMER_SLOP_ADDRESS 0x00000260
#define WB_TIMER_SLOP_OFFSET 0x00000260
#define WB_TIMER_SLOP_VALUE_MSB 9
#define WB_TIMER_SLOP_VALUE_LSB 0
#define WB_TIMER_SLOP_VALUE_MASK 0x000003ff
#define WB_TIMER_SLOP_VALUE_GET(x) (((x)&WB_TIMER_SLOP_VALUE_MASK) >> WB_TIMER_SLOP_VALUE_LSB)
#define WB_TIMER_SLOP_VALUE_SET(x) (((x) << WB_TIMER_SLOP_VALUE_LSB) & WB_TIMER_SLOP_VALUE_MASK)

#define BTCOEX_INT_EN_ADDRESS 0x00000264
#define BTCOEX_INT_EN_OFFSET 0x00000264
#define BTCOEX_INT_EN_I2C_RECV_OVERFLOW_MSB 11
#define BTCOEX_INT_EN_I2C_RECV_OVERFLOW_LSB 11
#define BTCOEX_INT_EN_I2C_RECV_OVERFLOW_MASK 0x00000800
#define BTCOEX_INT_EN_I2C_RECV_OVERFLOW_GET(x) \
    (((x)&BTCOEX_INT_EN_I2C_RECV_OVERFLOW_MASK) >> BTCOEX_INT_EN_I2C_RECV_OVERFLOW_LSB)
#define BTCOEX_INT_EN_I2C_RECV_OVERFLOW_SET(x) \
    (((x) << BTCOEX_INT_EN_I2C_RECV_OVERFLOW_LSB) & BTCOEX_INT_EN_I2C_RECV_OVERFLOW_MASK)
#define BTCOEX_INT_EN_I2C_TX_FAILED_MSB 10
#define BTCOEX_INT_EN_I2C_TX_FAILED_LSB 10
#define BTCOEX_INT_EN_I2C_TX_FAILED_MASK 0x00000400
#define BTCOEX_INT_EN_I2C_TX_FAILED_GET(x) (((x)&BTCOEX_INT_EN_I2C_TX_FAILED_MASK) >> BTCOEX_INT_EN_I2C_TX_FAILED_LSB)
#define BTCOEX_INT_EN_I2C_TX_FAILED_SET(x) (((x) << BTCOEX_INT_EN_I2C_TX_FAILED_LSB) & BTCOEX_INT_EN_I2C_TX_FAILED_MASK)
#define BTCOEX_INT_EN_I2C_MESG_SENT_MSB 9
#define BTCOEX_INT_EN_I2C_MESG_SENT_LSB 9
#define BTCOEX_INT_EN_I2C_MESG_SENT_MASK 0x00000200
#define BTCOEX_INT_EN_I2C_MESG_SENT_GET(x) (((x)&BTCOEX_INT_EN_I2C_MESG_SENT_MASK) >> BTCOEX_INT_EN_I2C_MESG_SENT_LSB)
#define BTCOEX_INT_EN_I2C_MESG_SENT_SET(x) (((x) << BTCOEX_INT_EN_I2C_MESG_SENT_LSB) & BTCOEX_INT_EN_I2C_MESG_SENT_MASK)
#define BTCOEX_INT_EN_ST_MESG_RECV_MSB 8
#define BTCOEX_INT_EN_ST_MESG_RECV_LSB 8
#define BTCOEX_INT_EN_ST_MESG_RECV_MASK 0x00000100
#define BTCOEX_INT_EN_ST_MESG_RECV_GET(x) (((x)&BTCOEX_INT_EN_ST_MESG_RECV_MASK) >> BTCOEX_INT_EN_ST_MESG_RECV_LSB)
#define BTCOEX_INT_EN_ST_MESG_RECV_SET(x) (((x) << BTCOEX_INT_EN_ST_MESG_RECV_LSB) & BTCOEX_INT_EN_ST_MESG_RECV_MASK)
#define BTCOEX_INT_EN_WB_TIMER_MSB 7
#define BTCOEX_INT_EN_WB_TIMER_LSB 7
#define BTCOEX_INT_EN_WB_TIMER_MASK 0x00000080
#define BTCOEX_INT_EN_WB_TIMER_GET(x) (((x)&BTCOEX_INT_EN_WB_TIMER_MASK) >> BTCOEX_INT_EN_WB_TIMER_LSB)
#define BTCOEX_INT_EN_WB_TIMER_SET(x) (((x) << BTCOEX_INT_EN_WB_TIMER_LSB) & BTCOEX_INT_EN_WB_TIMER_MASK)
#define BTCOEX_INT_EN_NOSYNC_MSB 4
#define BTCOEX_INT_EN_NOSYNC_LSB 4
#define BTCOEX_INT_EN_NOSYNC_MASK 0x00000010
#define BTCOEX_INT_EN_NOSYNC_GET(x) (((x)&BTCOEX_INT_EN_NOSYNC_MASK) >> BTCOEX_INT_EN_NOSYNC_LSB)
#define BTCOEX_INT_EN_NOSYNC_SET(x) (((x) << BTCOEX_INT_EN_NOSYNC_LSB) & BTCOEX_INT_EN_NOSYNC_MASK)
#define BTCOEX_INT_EN_SYNC_MSB 3
#define BTCOEX_INT_EN_SYNC_LSB 3
#define BTCOEX_INT_EN_SYNC_MASK 0x00000008
#define BTCOEX_INT_EN_SYNC_GET(x) (((x)&BTCOEX_INT_EN_SYNC_MASK) >> BTCOEX_INT_EN_SYNC_LSB)
#define BTCOEX_INT_EN_SYNC_SET(x) (((x) << BTCOEX_INT_EN_SYNC_LSB) & BTCOEX_INT_EN_SYNC_MASK)
#define BTCOEX_INT_EN_END_MSB 2
#define BTCOEX_INT_EN_END_LSB 2
#define BTCOEX_INT_EN_END_MASK 0x00000004
#define BTCOEX_INT_EN_END_GET(x) (((x)&BTCOEX_INT_EN_END_MASK) >> BTCOEX_INT_EN_END_LSB)
#define BTCOEX_INT_EN_END_SET(x) (((x) << BTCOEX_INT_EN_END_LSB) & BTCOEX_INT_EN_END_MASK)
#define BTCOEX_INT_EN_FRAME_CNT_MSB 1
#define BTCOEX_INT_EN_FRAME_CNT_LSB 1
#define BTCOEX_INT_EN_FRAME_CNT_MASK 0x00000002
#define BTCOEX_INT_EN_FRAME_CNT_GET(x) (((x)&BTCOEX_INT_EN_FRAME_CNT_MASK) >> BTCOEX_INT_EN_FRAME_CNT_LSB)
#define BTCOEX_INT_EN_FRAME_CNT_SET(x) (((x) << BTCOEX_INT_EN_FRAME_CNT_LSB) & BTCOEX_INT_EN_FRAME_CNT_MASK)
#define BTCOEX_INT_EN_CLK_CNT_MSB 0
#define BTCOEX_INT_EN_CLK_CNT_LSB 0
#define BTCOEX_INT_EN_CLK_CNT_MASK 0x00000001
#define BTCOEX_INT_EN_CLK_CNT_GET(x) (((x)&BTCOEX_INT_EN_CLK_CNT_MASK) >> BTCOEX_INT_EN_CLK_CNT_LSB)
#define BTCOEX_INT_EN_CLK_CNT_SET(x) (((x) << BTCOEX_INT_EN_CLK_CNT_LSB) & BTCOEX_INT_EN_CLK_CNT_MASK)

#define BTCOEX_INT_STAT_ADDRESS 0x00000268
#define BTCOEX_INT_STAT_OFFSET 0x00000268
#define BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_MSB 11
#define BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_LSB 11
#define BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_MASK 0x00000800
#define BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_GET(x) \
    (((x)&BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_MASK) >> BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_LSB)
#define BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_SET(x) \
    (((x) << BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_LSB) & BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_MASK)
#define BTCOEX_INT_STAT_I2C_TX_FAILED_MSB 10
#define BTCOEX_INT_STAT_I2C_TX_FAILED_LSB 10
#define BTCOEX_INT_STAT_I2C_TX_FAILED_MASK 0x00000400
#define BTCOEX_INT_STAT_I2C_TX_FAILED_GET(x) \
    (((x)&BTCOEX_INT_STAT_I2C_TX_FAILED_MASK) >> BTCOEX_INT_STAT_I2C_TX_FAILED_LSB)
#define BTCOEX_INT_STAT_I2C_TX_FAILED_SET(x) \
    (((x) << BTCOEX_INT_STAT_I2C_TX_FAILED_LSB) & BTCOEX_INT_STAT_I2C_TX_FAILED_MASK)
#define BTCOEX_INT_STAT_I2C_MESG_SENT_MSB 9
#define BTCOEX_INT_STAT_I2C_MESG_SENT_LSB 9
#define BTCOEX_INT_STAT_I2C_MESG_SENT_MASK 0x00000200
#define BTCOEX_INT_STAT_I2C_MESG_SENT_GET(x) \
    (((x)&BTCOEX_INT_STAT_I2C_MESG_SENT_MASK) >> BTCOEX_INT_STAT_I2C_MESG_SENT_LSB)
#define BTCOEX_INT_STAT_I2C_MESG_SENT_SET(x) \
    (((x) << BTCOEX_INT_STAT_I2C_MESG_SENT_LSB) & BTCOEX_INT_STAT_I2C_MESG_SENT_MASK)
#define BTCOEX_INT_STAT_I2C_MESG_RECV_MSB 8
#define BTCOEX_INT_STAT_I2C_MESG_RECV_LSB 8
#define BTCOEX_INT_STAT_I2C_MESG_RECV_MASK 0x00000100
#define BTCOEX_INT_STAT_I2C_MESG_RECV_GET(x) \
    (((x)&BTCOEX_INT_STAT_I2C_MESG_RECV_MASK) >> BTCOEX_INT_STAT_I2C_MESG_RECV_LSB)
#define BTCOEX_INT_STAT_I2C_MESG_RECV_SET(x) \
    (((x) << BTCOEX_INT_STAT_I2C_MESG_RECV_LSB) & BTCOEX_INT_STAT_I2C_MESG_RECV_MASK)
#define BTCOEX_INT_STAT_WB_TIMER_MSB 7
#define BTCOEX_INT_STAT_WB_TIMER_LSB 7
#define BTCOEX_INT_STAT_WB_TIMER_MASK 0x00000080
#define BTCOEX_INT_STAT_WB_TIMER_GET(x) (((x)&BTCOEX_INT_STAT_WB_TIMER_MASK) >> BTCOEX_INT_STAT_WB_TIMER_LSB)
#define BTCOEX_INT_STAT_WB_TIMER_SET(x) (((x) << BTCOEX_INT_STAT_WB_TIMER_LSB) & BTCOEX_INT_STAT_WB_TIMER_MASK)
#define BTCOEX_INT_STAT_BTPRIORITY_STOMP_MSB 6
#define BTCOEX_INT_STAT_BTPRIORITY_STOMP_LSB 6
#define BTCOEX_INT_STAT_BTPRIORITY_STOMP_MASK 0x00000040
#define BTCOEX_INT_STAT_BTPRIORITY_STOMP_GET(x) \
    (((x)&BTCOEX_INT_STAT_BTPRIORITY_STOMP_MASK) >> BTCOEX_INT_STAT_BTPRIORITY_STOMP_LSB)
#define BTCOEX_INT_STAT_BTPRIORITY_STOMP_SET(x) \
    (((x) << BTCOEX_INT_STAT_BTPRIORITY_STOMP_LSB) & BTCOEX_INT_STAT_BTPRIORITY_STOMP_MASK)
#define BTCOEX_INT_STAT_BTPRIORITY_MSB 5
#define BTCOEX_INT_STAT_BTPRIORITY_LSB 5
#define BTCOEX_INT_STAT_BTPRIORITY_MASK 0x00000020
#define BTCOEX_INT_STAT_BTPRIORITY_GET(x) (((x)&BTCOEX_INT_STAT_BTPRIORITY_MASK) >> BTCOEX_INT_STAT_BTPRIORITY_LSB)
#define BTCOEX_INT_STAT_BTPRIORITY_SET(x) (((x) << BTCOEX_INT_STAT_BTPRIORITY_LSB) & BTCOEX_INT_STAT_BTPRIORITY_MASK)
#define BTCOEX_INT_STAT_NOSYNC_MSB 4
#define BTCOEX_INT_STAT_NOSYNC_LSB 4
#define BTCOEX_INT_STAT_NOSYNC_MASK 0x00000010
#define BTCOEX_INT_STAT_NOSYNC_GET(x) (((x)&BTCOEX_INT_STAT_NOSYNC_MASK) >> BTCOEX_INT_STAT_NOSYNC_LSB)
#define BTCOEX_INT_STAT_NOSYNC_SET(x) (((x) << BTCOEX_INT_STAT_NOSYNC_LSB) & BTCOEX_INT_STAT_NOSYNC_MASK)
#define BTCOEX_INT_STAT_SYNC_MSB 3
#define BTCOEX_INT_STAT_SYNC_LSB 3
#define BTCOEX_INT_STAT_SYNC_MASK 0x00000008
#define BTCOEX_INT_STAT_SYNC_GET(x) (((x)&BTCOEX_INT_STAT_SYNC_MASK) >> BTCOEX_INT_STAT_SYNC_LSB)
#define BTCOEX_INT_STAT_SYNC_SET(x) (((x) << BTCOEX_INT_STAT_SYNC_LSB) & BTCOEX_INT_STAT_SYNC_MASK)
#define BTCOEX_INT_STAT_END_MSB 2
#define BTCOEX_INT_STAT_END_LSB 2
#define BTCOEX_INT_STAT_END_MASK 0x00000004
#define BTCOEX_INT_STAT_END_GET(x) (((x)&BTCOEX_INT_STAT_END_MASK) >> BTCOEX_INT_STAT_END_LSB)
#define BTCOEX_INT_STAT_END_SET(x) (((x) << BTCOEX_INT_STAT_END_LSB) & BTCOEX_INT_STAT_END_MASK)
#define BTCOEX_INT_STAT_FRAME_CNT_MSB 1
#define BTCOEX_INT_STAT_FRAME_CNT_LSB 1
#define BTCOEX_INT_STAT_FRAME_CNT_MASK 0x00000002
#define BTCOEX_INT_STAT_FRAME_CNT_GET(x) (((x)&BTCOEX_INT_STAT_FRAME_CNT_MASK) >> BTCOEX_INT_STAT_FRAME_CNT_LSB)
#define BTCOEX_INT_STAT_FRAME_CNT_SET(x) (((x) << BTCOEX_INT_STAT_FRAME_CNT_LSB) & BTCOEX_INT_STAT_FRAME_CNT_MASK)
#define BTCOEX_INT_STAT_CLK_CNT_MSB 0
#define BTCOEX_INT_STAT_CLK_CNT_LSB 0
#define BTCOEX_INT_STAT_CLK_CNT_MASK 0x00000001
#define BTCOEX_INT_STAT_CLK_CNT_GET(x) (((x)&BTCOEX_INT_STAT_CLK_CNT_MASK) >> BTCOEX_INT_STAT_CLK_CNT_LSB)
#define BTCOEX_INT_STAT_CLK_CNT_SET(x) (((x) << BTCOEX_INT_STAT_CLK_CNT_LSB) & BTCOEX_INT_STAT_CLK_CNT_MASK)

#define BTPRIORITY_INT_EN_ADDRESS 0x0000026c
#define BTPRIORITY_INT_EN_OFFSET 0x0000026c
#define BTPRIORITY_INT_EN_BITMAP_MSB 31
#define BTPRIORITY_INT_EN_BITMAP_LSB 0
#define BTPRIORITY_INT_EN_BITMAP_MASK 0xffffffff
#define BTPRIORITY_INT_EN_BITMAP_GET(x) (((x)&BTPRIORITY_INT_EN_BITMAP_MASK) >> BTPRIORITY_INT_EN_BITMAP_LSB)
#define BTPRIORITY_INT_EN_BITMAP_SET(x) (((x) << BTPRIORITY_INT_EN_BITMAP_LSB) & BTPRIORITY_INT_EN_BITMAP_MASK)

#define BTPRIORITY_INT_STAT_ADDRESS 0x00000270
#define BTPRIORITY_INT_STAT_OFFSET 0x00000270
#define BTPRIORITY_INT_STAT_BITMAP_MSB 31
#define BTPRIORITY_INT_STAT_BITMAP_LSB 0
#define BTPRIORITY_INT_STAT_BITMAP_MASK 0xffffffff
#define BTPRIORITY_INT_STAT_BITMAP_GET(x) (((x)&BTPRIORITY_INT_STAT_BITMAP_MASK) >> BTPRIORITY_INT_STAT_BITMAP_LSB)
#define BTPRIORITY_INT_STAT_BITMAP_SET(x) (((x) << BTPRIORITY_INT_STAT_BITMAP_LSB) & BTPRIORITY_INT_STAT_BITMAP_MASK)

#define BTPRIORITY_STOMP_INT_EN_ADDRESS 0x00000274
#define BTPRIORITY_STOMP_INT_EN_OFFSET 0x00000274
#define BTPRIORITY_STOMP_INT_EN_BITMAP_MSB 31
#define BTPRIORITY_STOMP_INT_EN_BITMAP_LSB 0
#define BTPRIORITY_STOMP_INT_EN_BITMAP_MASK 0xffffffff
#define BTPRIORITY_STOMP_INT_EN_BITMAP_GET(x) \
    (((x)&BTPRIORITY_STOMP_INT_EN_BITMAP_MASK) >> BTPRIORITY_STOMP_INT_EN_BITMAP_LSB)
#define BTPRIORITY_STOMP_INT_EN_BITMAP_SET(x) \
    (((x) << BTPRIORITY_STOMP_INT_EN_BITMAP_LSB) & BTPRIORITY_STOMP_INT_EN_BITMAP_MASK)

#define BTPRIORITY_STOMP_INT_STAT_ADDRESS 0x00000278
#define BTPRIORITY_STOMP_INT_STAT_OFFSET 0x00000278
#define BTPRIORITY_STOMP_INT_STAT_BITMAP_MSB 31
#define BTPRIORITY_STOMP_INT_STAT_BITMAP_LSB 0
#define BTPRIORITY_STOMP_INT_STAT_BITMAP_MASK 0xffffffff
#define BTPRIORITY_STOMP_INT_STAT_BITMAP_GET(x) \
    (((x)&BTPRIORITY_STOMP_INT_STAT_BITMAP_MASK) >> BTPRIORITY_STOMP_INT_STAT_BITMAP_LSB)
#define BTPRIORITY_STOMP_INT_STAT_BITMAP_SET(x) \
    (((x) << BTPRIORITY_STOMP_INT_STAT_BITMAP_LSB) & BTPRIORITY_STOMP_INT_STAT_BITMAP_MASK)

#define MAC_PCU_BMISS_TIMEOUT_ADDRESS 0x0000027c
#define MAC_PCU_BMISS_TIMEOUT_OFFSET 0x0000027c
#define MAC_PCU_BMISS_TIMEOUT_ENABLE_MSB 24
#define MAC_PCU_BMISS_TIMEOUT_ENABLE_LSB 24
#define MAC_PCU_BMISS_TIMEOUT_ENABLE_MASK 0x01000000
#define MAC_PCU_BMISS_TIMEOUT_ENABLE_GET(x) \
    (((x)&MAC_PCU_BMISS_TIMEOUT_ENABLE_MASK) >> MAC_PCU_BMISS_TIMEOUT_ENABLE_LSB)
#define MAC_PCU_BMISS_TIMEOUT_ENABLE_SET(x) \
    (((x) << MAC_PCU_BMISS_TIMEOUT_ENABLE_LSB) & MAC_PCU_BMISS_TIMEOUT_ENABLE_MASK)
#define MAC_PCU_BMISS_TIMEOUT_VALUE_MSB 23
#define MAC_PCU_BMISS_TIMEOUT_VALUE_LSB 0
#define MAC_PCU_BMISS_TIMEOUT_VALUE_MASK 0x00ffffff
#define MAC_PCU_BMISS_TIMEOUT_VALUE_GET(x) (((x)&MAC_PCU_BMISS_TIMEOUT_VALUE_MASK) >> MAC_PCU_BMISS_TIMEOUT_VALUE_LSB)
#define MAC_PCU_BMISS_TIMEOUT_VALUE_SET(x) (((x) << MAC_PCU_BMISS_TIMEOUT_VALUE_LSB) & MAC_PCU_BMISS_TIMEOUT_VALUE_MASK)

#define MAC_PCU_CAB_AWAKE_ADDRESS 0x00000280
#define MAC_PCU_CAB_AWAKE_OFFSET 0x00000280
#define MAC_PCU_CAB_AWAKE_ENABLE_MSB 16
#define MAC_PCU_CAB_AWAKE_ENABLE_LSB 16
#define MAC_PCU_CAB_AWAKE_ENABLE_MASK 0x00010000
#define MAC_PCU_CAB_AWAKE_ENABLE_GET(x) (((x)&MAC_PCU_CAB_AWAKE_ENABLE_MASK) >> MAC_PCU_CAB_AWAKE_ENABLE_LSB)
#define MAC_PCU_CAB_AWAKE_ENABLE_SET(x) (((x) << MAC_PCU_CAB_AWAKE_ENABLE_LSB) & MAC_PCU_CAB_AWAKE_ENABLE_MASK)
#define MAC_PCU_CAB_AWAKE_DURATION_MSB 15
#define MAC_PCU_CAB_AWAKE_DURATION_LSB 0
#define MAC_PCU_CAB_AWAKE_DURATION_MASK 0x0000ffff
#define MAC_PCU_CAB_AWAKE_DURATION_GET(x) (((x)&MAC_PCU_CAB_AWAKE_DURATION_MASK) >> MAC_PCU_CAB_AWAKE_DURATION_LSB)
#define MAC_PCU_CAB_AWAKE_DURATION_SET(x) (((x) << MAC_PCU_CAB_AWAKE_DURATION_LSB) & MAC_PCU_CAB_AWAKE_DURATION_MASK)

#define LP_PERF_COUNTER_ADDRESS 0x00000284
#define LP_PERF_COUNTER_OFFSET 0x00000284
#define LP_PERF_COUNTER_EN_MSB 0
#define LP_PERF_COUNTER_EN_LSB 0
#define LP_PERF_COUNTER_EN_MASK 0x00000001
#define LP_PERF_COUNTER_EN_GET(x) (((x)&LP_PERF_COUNTER_EN_MASK) >> LP_PERF_COUNTER_EN_LSB)
#define LP_PERF_COUNTER_EN_SET(x) (((x) << LP_PERF_COUNTER_EN_LSB) & LP_PERF_COUNTER_EN_MASK)

#define LP_PERF_LIGHT_SLEEP_ADDRESS 0x00000288
#define LP_PERF_LIGHT_SLEEP_OFFSET 0x00000288
#define LP_PERF_LIGHT_SLEEP_CNT_MSB 31
#define LP_PERF_LIGHT_SLEEP_CNT_LSB 0
#define LP_PERF_LIGHT_SLEEP_CNT_MASK 0xffffffff
#define LP_PERF_LIGHT_SLEEP_CNT_GET(x) (((x)&LP_PERF_LIGHT_SLEEP_CNT_MASK) >> LP_PERF_LIGHT_SLEEP_CNT_LSB)
#define LP_PERF_LIGHT_SLEEP_CNT_SET(x) (((x) << LP_PERF_LIGHT_SLEEP_CNT_LSB) & LP_PERF_LIGHT_SLEEP_CNT_MASK)

#define LP_PERF_DEEP_SLEEP_ADDRESS 0x0000028c
#define LP_PERF_DEEP_SLEEP_OFFSET 0x0000028c
#define LP_PERF_DEEP_SLEEP_CNT_MSB 31
#define LP_PERF_DEEP_SLEEP_CNT_LSB 0
#define LP_PERF_DEEP_SLEEP_CNT_MASK 0xffffffff
#define LP_PERF_DEEP_SLEEP_CNT_GET(x) (((x)&LP_PERF_DEEP_SLEEP_CNT_MASK) >> LP_PERF_DEEP_SLEEP_CNT_LSB)
#define LP_PERF_DEEP_SLEEP_CNT_SET(x) (((x) << LP_PERF_DEEP_SLEEP_CNT_LSB) & LP_PERF_DEEP_SLEEP_CNT_MASK)

#define LP_PERF_ON_ADDRESS 0x00000290
#define LP_PERF_ON_OFFSET 0x00000290
#define LP_PERF_ON_CNT_MSB 31
#define LP_PERF_ON_CNT_LSB 0
#define LP_PERF_ON_CNT_MASK 0xffffffff
#define LP_PERF_ON_CNT_GET(x) (((x)&LP_PERF_ON_CNT_MASK) >> LP_PERF_ON_CNT_LSB)
#define LP_PERF_ON_CNT_SET(x) (((x) << LP_PERF_ON_CNT_LSB) & LP_PERF_ON_CNT_MASK)

#define ST_64_BIT_ADDRESS 0x00000294
#define ST_64_BIT_OFFSET 0x00000294
#define ST_64_BIT_TIMEOUT_MSB 26
#define ST_64_BIT_TIMEOUT_LSB 9
#define ST_64_BIT_TIMEOUT_MASK 0x07fffe00
#define ST_64_BIT_TIMEOUT_GET(x) (((x)&ST_64_BIT_TIMEOUT_MASK) >> ST_64_BIT_TIMEOUT_LSB)
#define ST_64_BIT_TIMEOUT_SET(x) (((x) << ST_64_BIT_TIMEOUT_LSB) & ST_64_BIT_TIMEOUT_MASK)
#define ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_MSB 8
#define ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_LSB 8
#define ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_MASK 0x00000100
#define ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_GET(x) \
    (((x)&ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_MASK) >> ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_LSB)
#define ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_SET(x) \
    (((x) << ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_LSB) & ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_MASK)
#define ST_64_BIT_DRIVE_MODE_MSB 7
#define ST_64_BIT_DRIVE_MODE_LSB 7
#define ST_64_BIT_DRIVE_MODE_MASK 0x00000080
#define ST_64_BIT_DRIVE_MODE_GET(x) (((x)&ST_64_BIT_DRIVE_MODE_MASK) >> ST_64_BIT_DRIVE_MODE_LSB)
#define ST_64_BIT_DRIVE_MODE_SET(x) (((x) << ST_64_BIT_DRIVE_MODE_LSB) & ST_64_BIT_DRIVE_MODE_MASK)
#define ST_64_BIT_CLOCK_GATE_MSB 6
#define ST_64_BIT_CLOCK_GATE_LSB 6
#define ST_64_BIT_CLOCK_GATE_MASK 0x00000040
#define ST_64_BIT_CLOCK_GATE_GET(x) (((x)&ST_64_BIT_CLOCK_GATE_MASK) >> ST_64_BIT_CLOCK_GATE_LSB)
#define ST_64_BIT_CLOCK_GATE_SET(x) (((x) << ST_64_BIT_CLOCK_GATE_LSB) & ST_64_BIT_CLOCK_GATE_MASK)
#define ST_64_BIT_SOC_CLK_DIVIDE_RATIO_MSB 5
#define ST_64_BIT_SOC_CLK_DIVIDE_RATIO_LSB 1
#define ST_64_BIT_SOC_CLK_DIVIDE_RATIO_MASK 0x0000003e
#define ST_64_BIT_SOC_CLK_DIVIDE_RATIO_GET(x) \
    (((x)&ST_64_BIT_SOC_CLK_DIVIDE_RATIO_MASK) >> ST_64_BIT_SOC_CLK_DIVIDE_RATIO_LSB)
#define ST_64_BIT_SOC_CLK_DIVIDE_RATIO_SET(x) \
    (((x) << ST_64_BIT_SOC_CLK_DIVIDE_RATIO_LSB) & ST_64_BIT_SOC_CLK_DIVIDE_RATIO_MASK)
#define ST_64_BIT_MODE_MSB 0
#define ST_64_BIT_MODE_LSB 0
#define ST_64_BIT_MODE_MASK 0x00000001
#define ST_64_BIT_MODE_GET(x) (((x)&ST_64_BIT_MODE_MASK) >> ST_64_BIT_MODE_LSB)
#define ST_64_BIT_MODE_SET(x) (((x) << ST_64_BIT_MODE_LSB) & ST_64_BIT_MODE_MASK)

#define MESSAGE_WR_ADDRESS 0x00000298
#define MESSAGE_WR_OFFSET 0x00000298
#define MESSAGE_WR_TYPE_MSB 31
#define MESSAGE_WR_TYPE_LSB 0
#define MESSAGE_WR_TYPE_MASK 0xffffffff
#define MESSAGE_WR_TYPE_GET(x) (((x)&MESSAGE_WR_TYPE_MASK) >> MESSAGE_WR_TYPE_LSB)
#define MESSAGE_WR_TYPE_SET(x) (((x) << MESSAGE_WR_TYPE_LSB) & MESSAGE_WR_TYPE_MASK)

#define MESSAGE_WR_P_ADDRESS 0x0000029c
#define MESSAGE_WR_P_OFFSET 0x0000029c
#define MESSAGE_WR_P_PARAMETER_MSB 31
#define MESSAGE_WR_P_PARAMETER_LSB 0
#define MESSAGE_WR_P_PARAMETER_MASK 0xffffffff
#define MESSAGE_WR_P_PARAMETER_GET(x) (((x)&MESSAGE_WR_P_PARAMETER_MASK) >> MESSAGE_WR_P_PARAMETER_LSB)
#define MESSAGE_WR_P_PARAMETER_SET(x) (((x) << MESSAGE_WR_P_PARAMETER_LSB) & MESSAGE_WR_P_PARAMETER_MASK)

#define MESSAGE_RD_ADDRESS 0x000002a0
#define MESSAGE_RD_OFFSET 0x000002a0
#define MESSAGE_RD_TYPE_MSB 31
#define MESSAGE_RD_TYPE_LSB 0
#define MESSAGE_RD_TYPE_MASK 0xffffffff
#define MESSAGE_RD_TYPE_GET(x) (((x)&MESSAGE_RD_TYPE_MASK) >> MESSAGE_RD_TYPE_LSB)
#define MESSAGE_RD_TYPE_SET(x) (((x) << MESSAGE_RD_TYPE_LSB) & MESSAGE_RD_TYPE_MASK)

#define MESSAGE_RD_P_ADDRESS 0x000002a4
#define MESSAGE_RD_P_OFFSET 0x000002a4
#define MESSAGE_RD_P_PARAMETER_MSB 31
#define MESSAGE_RD_P_PARAMETER_LSB 0
#define MESSAGE_RD_P_PARAMETER_MASK 0xffffffff
#define MESSAGE_RD_P_PARAMETER_GET(x) (((x)&MESSAGE_RD_P_PARAMETER_MASK) >> MESSAGE_RD_P_PARAMETER_LSB)
#define MESSAGE_RD_P_PARAMETER_SET(x) (((x) << MESSAGE_RD_P_PARAMETER_LSB) & MESSAGE_RD_P_PARAMETER_MASK)

#define CHIP_MODE_ADDRESS 0x000002a8
#define CHIP_MODE_OFFSET 0x000002a8
#define CHIP_MODE_BIT_MSB 1
#define CHIP_MODE_BIT_LSB 0
#define CHIP_MODE_BIT_MASK 0x00000003
#define CHIP_MODE_BIT_GET(x) (((x)&CHIP_MODE_BIT_MASK) >> CHIP_MODE_BIT_LSB)
#define CHIP_MODE_BIT_SET(x) (((x) << CHIP_MODE_BIT_LSB) & CHIP_MODE_BIT_MASK)

#define CLK_REQ_FALL_EDGE_ADDRESS 0x000002ac
#define CLK_REQ_FALL_EDGE_OFFSET 0x000002ac
#define CLK_REQ_FALL_EDGE_EN_MSB 31
#define CLK_REQ_FALL_EDGE_EN_LSB 31
#define CLK_REQ_FALL_EDGE_EN_MASK 0x80000000
#define CLK_REQ_FALL_EDGE_EN_GET(x) (((x)&CLK_REQ_FALL_EDGE_EN_MASK) >> CLK_REQ_FALL_EDGE_EN_LSB)
#define CLK_REQ_FALL_EDGE_EN_SET(x) (((x) << CLK_REQ_FALL_EDGE_EN_LSB) & CLK_REQ_FALL_EDGE_EN_MASK)
#define CLK_REQ_FALL_EDGE_DELAY_MSB 7
#define CLK_REQ_FALL_EDGE_DELAY_LSB 0
#define CLK_REQ_FALL_EDGE_DELAY_MASK 0x000000ff
#define CLK_REQ_FALL_EDGE_DELAY_GET(x) (((x)&CLK_REQ_FALL_EDGE_DELAY_MASK) >> CLK_REQ_FALL_EDGE_DELAY_LSB)
#define CLK_REQ_FALL_EDGE_DELAY_SET(x) (((x) << CLK_REQ_FALL_EDGE_DELAY_LSB) & CLK_REQ_FALL_EDGE_DELAY_MASK)

#define OTP_ADDRESS 0x000002b0
#define OTP_OFFSET 0x000002b0
#define OTP_LDO25_EN_MSB 1
#define OTP_LDO25_EN_LSB 1
#define OTP_LDO25_EN_MASK 0x00000002
#define OTP_LDO25_EN_GET(x) (((x)&OTP_LDO25_EN_MASK) >> OTP_LDO25_EN_LSB)
#define OTP_LDO25_EN_SET(x) (((x) << OTP_LDO25_EN_LSB) & OTP_LDO25_EN_MASK)
#define OTP_VDD12_EN_MSB 0
#define OTP_VDD12_EN_LSB 0
#define OTP_VDD12_EN_MASK 0x00000001
#define OTP_VDD12_EN_GET(x) (((x)&OTP_VDD12_EN_MASK) >> OTP_VDD12_EN_LSB)
#define OTP_VDD12_EN_SET(x) (((x) << OTP_VDD12_EN_LSB) & OTP_VDD12_EN_MASK)

#define OTP_STATUS_ADDRESS 0x000002b4
#define OTP_STATUS_OFFSET 0x000002b4
#define OTP_STATUS_LDO25_EN_READY_MSB 1
#define OTP_STATUS_LDO25_EN_READY_LSB 1
#define OTP_STATUS_LDO25_EN_READY_MASK 0x00000002
#define OTP_STATUS_LDO25_EN_READY_GET(x) (((x)&OTP_STATUS_LDO25_EN_READY_MASK) >> OTP_STATUS_LDO25_EN_READY_LSB)
#define OTP_STATUS_LDO25_EN_READY_SET(x) (((x) << OTP_STATUS_LDO25_EN_READY_LSB) & OTP_STATUS_LDO25_EN_READY_MASK)
#define OTP_STATUS_VDD12_EN_READY_MSB 0
#define OTP_STATUS_VDD12_EN_READY_LSB 0
#define OTP_STATUS_VDD12_EN_READY_MASK 0x00000001
#define OTP_STATUS_VDD12_EN_READY_GET(x) (((x)&OTP_STATUS_VDD12_EN_READY_MASK) >> OTP_STATUS_VDD12_EN_READY_LSB)
#define OTP_STATUS_VDD12_EN_READY_SET(x) (((x) << OTP_STATUS_VDD12_EN_READY_LSB) & OTP_STATUS_VDD12_EN_READY_MASK)

#define PMU_ADDRESS 0x000002b8
#define PMU_OFFSET 0x000002b8
#define PMU_REG_WAKEUP_TIME_SEL_MSB 1
#define PMU_REG_WAKEUP_TIME_SEL_LSB 0
#define PMU_REG_WAKEUP_TIME_SEL_MASK 0x00000003
#define PMU_REG_WAKEUP_TIME_SEL_GET(x) (((x)&PMU_REG_WAKEUP_TIME_SEL_MASK) >> PMU_REG_WAKEUP_TIME_SEL_LSB)
#define PMU_REG_WAKEUP_TIME_SEL_SET(x) (((x) << PMU_REG_WAKEUP_TIME_SEL_LSB) & PMU_REG_WAKEUP_TIME_SEL_MASK)

#define PMU_CONFIG_ADDRESS 0x000002c0
#define PMU_CONFIG_OFFSET 0x000002c0
#define PMU_CONFIG_VALUE_MSB 15
#define PMU_CONFIG_VALUE_LSB 0
#define PMU_CONFIG_VALUE_MASK 0x0000ffff
#define PMU_CONFIG_VALUE_GET(x) (((x)&PMU_CONFIG_VALUE_MASK) >> PMU_CONFIG_VALUE_LSB)
#define PMU_CONFIG_VALUE_SET(x) (((x) << PMU_CONFIG_VALUE_LSB) & PMU_CONFIG_VALUE_MASK)

#define PMU_BYPASS_ADDRESS 0x000002c8
#define PMU_BYPASS_OFFSET 0x000002c8
#define PMU_BYPASS_SWREG_MSB 2
#define PMU_BYPASS_SWREG_LSB 2
#define PMU_BYPASS_SWREG_MASK 0x00000004
#define PMU_BYPASS_SWREG_GET(x) (((x)&PMU_BYPASS_SWREG_MASK) >> PMU_BYPASS_SWREG_LSB)
#define PMU_BYPASS_SWREG_SET(x) (((x) << PMU_BYPASS_SWREG_LSB) & PMU_BYPASS_SWREG_MASK)
#define PMU_BYPASS_DREG_MSB 1
#define PMU_BYPASS_DREG_LSB 1
#define PMU_BYPASS_DREG_MASK 0x00000002
#define PMU_BYPASS_DREG_GET(x) (((x)&PMU_BYPASS_DREG_MASK) >> PMU_BYPASS_DREG_LSB)
#define PMU_BYPASS_DREG_SET(x) (((x) << PMU_BYPASS_DREG_LSB) & PMU_BYPASS_DREG_MASK)
#define PMU_BYPASS_PAREG_MSB 0
#define PMU_BYPASS_PAREG_LSB 0
#define PMU_BYPASS_PAREG_MASK 0x00000001
#define PMU_BYPASS_PAREG_GET(x) (((x)&PMU_BYPASS_PAREG_MASK) >> PMU_BYPASS_PAREG_LSB)
#define PMU_BYPASS_PAREG_SET(x) (((x) << PMU_BYPASS_PAREG_LSB) & PMU_BYPASS_PAREG_MASK)

#define MAC_PCU_TSF2_L32_ADDRESS 0x000002cc
#define MAC_PCU_TSF2_L32_OFFSET 0x000002cc
#define MAC_PCU_TSF2_L32_VALUE_MSB 31
#define MAC_PCU_TSF2_L32_VALUE_LSB 0
#define MAC_PCU_TSF2_L32_VALUE_MASK 0xffffffff
#define MAC_PCU_TSF2_L32_VALUE_GET(x) (((x)&MAC_PCU_TSF2_L32_VALUE_MASK) >> MAC_PCU_TSF2_L32_VALUE_LSB)
#define MAC_PCU_TSF2_L32_VALUE_SET(x) (((x) << MAC_PCU_TSF2_L32_VALUE_LSB) & MAC_PCU_TSF2_L32_VALUE_MASK)

#define MAC_PCU_TSF2_U32_ADDRESS 0x000002d0
#define MAC_PCU_TSF2_U32_OFFSET 0x000002d0
#define MAC_PCU_TSF2_U32_VALUE_MSB 31
#define MAC_PCU_TSF2_U32_VALUE_LSB 0
#define MAC_PCU_TSF2_U32_VALUE_MASK 0xffffffff
#define MAC_PCU_TSF2_U32_VALUE_GET(x) (((x)&MAC_PCU_TSF2_U32_VALUE_MASK) >> MAC_PCU_TSF2_U32_VALUE_LSB)
#define MAC_PCU_TSF2_U32_VALUE_SET(x) (((x) << MAC_PCU_TSF2_U32_VALUE_LSB) & MAC_PCU_TSF2_U32_VALUE_MASK)

#define MAC_PCU_GENERIC_TIMERS_MODE3_ADDRESS 0x000002d4
#define MAC_PCU_GENERIC_TIMERS_MODE3_OFFSET 0x000002d4
#define MAC_PCU_GENERIC_TIMERS_MODE3_OVERFLOW_INDEX_MSB 27
#define MAC_PCU_GENERIC_TIMERS_MODE3_OVERFLOW_INDEX_LSB 24
#define MAC_PCU_GENERIC_TIMERS_MODE3_OVERFLOW_INDEX_MASK 0x0f000000
#define MAC_PCU_GENERIC_TIMERS_MODE3_OVERFLOW_INDEX_GET(x) \
    (((x)&MAC_PCU_GENERIC_TIMERS_MODE3_OVERFLOW_INDEX_MASK) >> MAC_PCU_GENERIC_TIMERS_MODE3_OVERFLOW_INDEX_LSB)
#define MAC_PCU_GENERIC_TIMERS_MODE3_OVERFLOW_INDEX_SET(x) \
    (((x) << MAC_PCU_GENERIC_TIMERS_MODE3_OVERFLOW_INDEX_LSB) & MAC_PCU_GENERIC_TIMERS_MODE3_OVERFLOW_INDEX_MASK)
#define MAC_PCU_GENERIC_TIMERS_MODE3_THRESH_MSB 19
#define MAC_PCU_GENERIC_TIMERS_MODE3_THRESH_LSB 0
#define MAC_PCU_GENERIC_TIMERS_MODE3_THRESH_MASK 0x000fffff
#define MAC_PCU_GENERIC_TIMERS_MODE3_THRESH_GET(x) \
    (((x)&MAC_PCU_GENERIC_TIMERS_MODE3_THRESH_MASK) >> MAC_PCU_GENERIC_TIMERS_MODE3_THRESH_LSB)
#define MAC_PCU_GENERIC_TIMERS_MODE3_THRESH_SET(x) \
    (((x) << MAC_PCU_GENERIC_TIMERS_MODE3_THRESH_LSB) & MAC_PCU_GENERIC_TIMERS_MODE3_THRESH_MASK)

#define MAC_PCU_DIRECT_CONNECT_ADDRESS 0x000002d8
#define MAC_PCU_DIRECT_CONNECT_OFFSET 0x000002d8
#define MAC_PCU_DIRECT_CONNECT_STA_TSF_1_2_SEL_MSB 2
#define MAC_PCU_DIRECT_CONNECT_STA_TSF_1_2_SEL_LSB 2
#define MAC_PCU_DIRECT_CONNECT_STA_TSF_1_2_SEL_MASK 0x00000004
#define MAC_PCU_DIRECT_CONNECT_STA_TSF_1_2_SEL_GET(x) \
    (((x)&MAC_PCU_DIRECT_CONNECT_STA_TSF_1_2_SEL_MASK) >> MAC_PCU_DIRECT_CONNECT_STA_TSF_1_2_SEL_LSB)
#define MAC_PCU_DIRECT_CONNECT_STA_TSF_1_2_SEL_SET(x) \
    (((x) << MAC_PCU_DIRECT_CONNECT_STA_TSF_1_2_SEL_LSB) & MAC_PCU_DIRECT_CONNECT_STA_TSF_1_2_SEL_MASK)
#define MAC_PCU_DIRECT_CONNECT_AP_TSF_1_2_SEL_MSB 1
#define MAC_PCU_DIRECT_CONNECT_AP_TSF_1_2_SEL_LSB 1
#define MAC_PCU_DIRECT_CONNECT_AP_TSF_1_2_SEL_MASK 0x00000002
#define MAC_PCU_DIRECT_CONNECT_AP_TSF_1_2_SEL_GET(x) \
    (((x)&MAC_PCU_DIRECT_CONNECT_AP_TSF_1_2_SEL_MASK) >> MAC_PCU_DIRECT_CONNECT_AP_TSF_1_2_SEL_LSB)
#define MAC_PCU_DIRECT_CONNECT_AP_TSF_1_2_SEL_SET(x) \
    (((x) << MAC_PCU_DIRECT_CONNECT_AP_TSF_1_2_SEL_LSB) & MAC_PCU_DIRECT_CONNECT_AP_TSF_1_2_SEL_MASK)
#define MAC_PCU_DIRECT_CONNECT_AP_STA_ENABLE_MSB 0
#define MAC_PCU_DIRECT_CONNECT_AP_STA_ENABLE_LSB 0
#define MAC_PCU_DIRECT_CONNECT_AP_STA_ENABLE_MASK 0x00000001
#define MAC_PCU_DIRECT_CONNECT_AP_STA_ENABLE_GET(x) \
    (((x)&MAC_PCU_DIRECT_CONNECT_AP_STA_ENABLE_MASK) >> MAC_PCU_DIRECT_CONNECT_AP_STA_ENABLE_LSB)
#define MAC_PCU_DIRECT_CONNECT_AP_STA_ENABLE_SET(x) \
    (((x) << MAC_PCU_DIRECT_CONNECT_AP_STA_ENABLE_LSB) & MAC_PCU_DIRECT_CONNECT_AP_STA_ENABLE_MASK)

#define THERM_CTRL1_ADDRESS 0x000002dc
#define THERM_CTRL1_OFFSET 0x000002dc
#define THERM_CTRL1_BYPASS_MSB 16
#define THERM_CTRL1_BYPASS_LSB 16
#define THERM_CTRL1_BYPASS_MASK 0x00010000
#define THERM_CTRL1_BYPASS_GET(x) (((x)&THERM_CTRL1_BYPASS_MASK) >> THERM_CTRL1_BYPASS_LSB)
#define THERM_CTRL1_BYPASS_SET(x) (((x) << THERM_CTRL1_BYPASS_LSB) & THERM_CTRL1_BYPASS_MASK)
#define THERM_CTRL1_WIDTH_ARBITOR_MSB 15
#define THERM_CTRL1_WIDTH_ARBITOR_LSB 12
#define THERM_CTRL1_WIDTH_ARBITOR_MASK 0x0000f000
#define THERM_CTRL1_WIDTH_ARBITOR_GET(x) (((x)&THERM_CTRL1_WIDTH_ARBITOR_MASK) >> THERM_CTRL1_WIDTH_ARBITOR_LSB)
#define THERM_CTRL1_WIDTH_ARBITOR_SET(x) (((x) << THERM_CTRL1_WIDTH_ARBITOR_LSB) & THERM_CTRL1_WIDTH_ARBITOR_MASK)
#define THERM_CTRL1_WIDTH_MSB 11
#define THERM_CTRL1_WIDTH_LSB 5
#define THERM_CTRL1_WIDTH_MASK 0x00000fe0
#define THERM_CTRL1_WIDTH_GET(x) (((x)&THERM_CTRL1_WIDTH_MASK) >> THERM_CTRL1_WIDTH_LSB)
#define THERM_CTRL1_WIDTH_SET(x) (((x) << THERM_CTRL1_WIDTH_LSB) & THERM_CTRL1_WIDTH_MASK)
#define THERM_CTRL1_TYPE_MSB 4
#define THERM_CTRL1_TYPE_LSB 3
#define THERM_CTRL1_TYPE_MASK 0x00000018
#define THERM_CTRL1_TYPE_GET(x) (((x)&THERM_CTRL1_TYPE_MASK) >> THERM_CTRL1_TYPE_LSB)
#define THERM_CTRL1_TYPE_SET(x) (((x) << THERM_CTRL1_TYPE_LSB) & THERM_CTRL1_TYPE_MASK)
#define THERM_CTRL1_MEASURE_MSB 2
#define THERM_CTRL1_MEASURE_LSB 2
#define THERM_CTRL1_MEASURE_MASK 0x00000004
#define THERM_CTRL1_MEASURE_GET(x) (((x)&THERM_CTRL1_MEASURE_MASK) >> THERM_CTRL1_MEASURE_LSB)
#define THERM_CTRL1_MEASURE_SET(x) (((x) << THERM_CTRL1_MEASURE_LSB) & THERM_CTRL1_MEASURE_MASK)
#define THERM_CTRL1_INT_EN_MSB 1
#define THERM_CTRL1_INT_EN_LSB 1
#define THERM_CTRL1_INT_EN_MASK 0x00000002
#define THERM_CTRL1_INT_EN_GET(x) (((x)&THERM_CTRL1_INT_EN_MASK) >> THERM_CTRL1_INT_EN_LSB)
#define THERM_CTRL1_INT_EN_SET(x) (((x) << THERM_CTRL1_INT_EN_LSB) & THERM_CTRL1_INT_EN_MASK)
#define THERM_CTRL1_INT_STATUS_MSB 0
#define THERM_CTRL1_INT_STATUS_LSB 0
#define THERM_CTRL1_INT_STATUS_MASK 0x00000001
#define THERM_CTRL1_INT_STATUS_GET(x) (((x)&THERM_CTRL1_INT_STATUS_MASK) >> THERM_CTRL1_INT_STATUS_LSB)
#define THERM_CTRL1_INT_STATUS_SET(x) (((x) << THERM_CTRL1_INT_STATUS_LSB) & THERM_CTRL1_INT_STATUS_MASK)

#define THERM_CTRL2_ADDRESS 0x000002e0
#define THERM_CTRL2_OFFSET 0x000002e0
#define THERM_CTRL2_ADC_OFF_MSB 25
#define THERM_CTRL2_ADC_OFF_LSB 25
#define THERM_CTRL2_ADC_OFF_MASK 0x02000000
#define THERM_CTRL2_ADC_OFF_GET(x) (((x)&THERM_CTRL2_ADC_OFF_MASK) >> THERM_CTRL2_ADC_OFF_LSB)
#define THERM_CTRL2_ADC_OFF_SET(x) (((x) << THERM_CTRL2_ADC_OFF_LSB) & THERM_CTRL2_ADC_OFF_MASK)
#define THERM_CTRL2_ADC_ON_MSB 24
#define THERM_CTRL2_ADC_ON_LSB 24
#define THERM_CTRL2_ADC_ON_MASK 0x01000000
#define THERM_CTRL2_ADC_ON_GET(x) (((x)&THERM_CTRL2_ADC_ON_MASK) >> THERM_CTRL2_ADC_ON_LSB)
#define THERM_CTRL2_ADC_ON_SET(x) (((x) << THERM_CTRL2_ADC_ON_LSB) & THERM_CTRL2_ADC_ON_MASK)
#define THERM_CTRL2_SAMPLE_MSB 23
#define THERM_CTRL2_SAMPLE_LSB 16
#define THERM_CTRL2_SAMPLE_MASK 0x00ff0000
#define THERM_CTRL2_SAMPLE_GET(x) (((x)&THERM_CTRL2_SAMPLE_MASK) >> THERM_CTRL2_SAMPLE_LSB)
#define THERM_CTRL2_SAMPLE_SET(x) (((x) << THERM_CTRL2_SAMPLE_LSB) & THERM_CTRL2_SAMPLE_MASK)
#define THERM_CTRL2_HIGH_MSB 15
#define THERM_CTRL2_HIGH_LSB 8
#define THERM_CTRL2_HIGH_MASK 0x0000ff00
#define THERM_CTRL2_HIGH_GET(x) (((x)&THERM_CTRL2_HIGH_MASK) >> THERM_CTRL2_HIGH_LSB)
#define THERM_CTRL2_HIGH_SET(x) (((x) << THERM_CTRL2_HIGH_LSB) & THERM_CTRL2_HIGH_MASK)
#define THERM_CTRL2_LOW_MSB 7
#define THERM_CTRL2_LOW_LSB 0
#define THERM_CTRL2_LOW_MASK 0x000000ff
#define THERM_CTRL2_LOW_GET(x) (((x)&THERM_CTRL2_LOW_MASK) >> THERM_CTRL2_LOW_LSB)
#define THERM_CTRL2_LOW_SET(x) (((x) << THERM_CTRL2_LOW_LSB) & THERM_CTRL2_LOW_MASK)

#define THERM_CTRL3_ADDRESS 0x000002e4
#define THERM_CTRL3_OFFSET 0x000002e4
#define THERM_CTRL3_ADC_GAIN_MSB 16
#define THERM_CTRL3_ADC_GAIN_LSB 8
#define THERM_CTRL3_ADC_GAIN_MASK 0x0001ff00
#define THERM_CTRL3_ADC_GAIN_GET(x) (((x)&THERM_CTRL3_ADC_GAIN_MASK) >> THERM_CTRL3_ADC_GAIN_LSB)
#define THERM_CTRL3_ADC_GAIN_SET(x) (((x) << THERM_CTRL3_ADC_GAIN_LSB) & THERM_CTRL3_ADC_GAIN_MASK)
#define THERM_CTRL3_ADC_OFFSET_MSB 7
#define THERM_CTRL3_ADC_OFFSET_LSB 0
#define THERM_CTRL3_ADC_OFFSET_MASK 0x000000ff
#define THERM_CTRL3_ADC_OFFSET_GET(x) (((x)&THERM_CTRL3_ADC_OFFSET_MASK) >> THERM_CTRL3_ADC_OFFSET_LSB)
#define THERM_CTRL3_ADC_OFFSET_SET(x) (((x) << THERM_CTRL3_ADC_OFFSET_LSB) & THERM_CTRL3_ADC_OFFSET_MASK)

#ifndef __ASSEMBLER__

typedef struct rtc_wlan_reg_reg_s
{
    volatile unsigned int wlan_reset_control;
    volatile unsigned int wlan_xtal_control;
    volatile unsigned int wlan_tcxo_detect;
    volatile unsigned int wlan_xtal_test;
    volatile unsigned int wlan_quadrature;
    volatile unsigned int wlan_pll_control;
    volatile unsigned int wlan_pll_settle;
    volatile unsigned int wlan_xtal_settle;
    volatile unsigned int wlan_cpu_clock;
    volatile unsigned int wlan_clock_out;
    volatile unsigned int wlan_clock_control;
    volatile unsigned int wlan_bias_override;
    volatile unsigned int wlan_wdt_control;
    volatile unsigned int wlan_wdt_status;
    volatile unsigned int wlan_wdt;
    volatile unsigned int wlan_wdt_count;
    volatile unsigned int wlan_wdt_reset;
    volatile unsigned int wlan_int_status;
    volatile unsigned int wlan_lf_timer0;
    volatile unsigned int wlan_lf_timer_count0;
    volatile unsigned int wlan_lf_timer_control0;
    volatile unsigned int wlan_lf_timer_status0;
    volatile unsigned int wlan_lf_timer1;
    volatile unsigned int wlan_lf_timer_count1;
    volatile unsigned int wlan_lf_timer_control1;
    volatile unsigned int wlan_lf_timer_status1;
    volatile unsigned int wlan_lf_timer2;
    volatile unsigned int wlan_lf_timer_count2;
    volatile unsigned int wlan_lf_timer_control2;
    volatile unsigned int wlan_lf_timer_status2;
    volatile unsigned int wlan_lf_timer3;
    volatile unsigned int wlan_lf_timer_count3;
    volatile unsigned int wlan_lf_timer_control3;
    volatile unsigned int wlan_lf_timer_status3;
    volatile unsigned int wlan_hf_timer;
    volatile unsigned int wlan_hf_timer_count;
    volatile unsigned int wlan_hf_lf_count;
    volatile unsigned int wlan_hf_timer_control;
    volatile unsigned int wlan_hf_timer_status;
    volatile unsigned int wlan_rtc_control;
    volatile unsigned int wlan_rtc_time;
    volatile unsigned int wlan_rtc_date;
    volatile unsigned int wlan_rtc_set_time;
    volatile unsigned int wlan_rtc_set_date;
    volatile unsigned int wlan_rtc_set_alarm;
    volatile unsigned int wlan_rtc_config;
    volatile unsigned int wlan_rtc_alarm_status;
    volatile unsigned int wlan_uart_wakeup;
    volatile unsigned int wlan_reset_cause;
    volatile unsigned int wlan_system_sleep;
    volatile unsigned int wlan_sdio_wrapper;
    volatile unsigned int wlan_mac_sleep_control;
    volatile unsigned int wlan_keep_awake;
    volatile unsigned int wlan_lpo_cal_time;
    volatile unsigned int wlan_lpo_init_dividend_int;
    volatile unsigned int wlan_lpo_init_dividend_fraction;
    volatile unsigned int wlan_lpo_cal;
    volatile unsigned int wlan_lpo_cal_test_control;
    volatile unsigned int wlan_lpo_cal_test_status;
    volatile unsigned int wlan_chip_id;
    volatile unsigned int wlan_derived_rtc_clk;
    volatile unsigned int mac_pcu_slp32_mode;
    volatile unsigned int mac_pcu_slp32_wake;
    volatile unsigned int mac_pcu_slp32_inc;
    volatile unsigned int mac_pcu_slp_mib1;
    volatile unsigned int mac_pcu_slp_mib2;
    volatile unsigned int mac_pcu_slp_mib3;
    volatile unsigned int wlan_power_reg;
    volatile unsigned int wlan_core_clk_ctrl;
    volatile unsigned int wlan_gpio_wakeup_control;
    volatile unsigned int ht;
    volatile unsigned int mac_pcu_tsf_l32;
    volatile unsigned int mac_pcu_tsf_u32;
    volatile unsigned int mac_pcu_wbtimer;
    unsigned char pad0[24]; /* pad to 0x140 */
    volatile unsigned int mac_pcu_generic_timers[16];
    volatile unsigned int mac_pcu_generic_timers_mode;
    unsigned char pad1[60]; /* pad to 0x1c0 */
    volatile unsigned int mac_pcu_generic_timers2[16];
    volatile unsigned int mac_pcu_generic_timers_mode2;
    volatile unsigned int mac_pcu_slp1;
    volatile unsigned int mac_pcu_slp2;
    volatile unsigned int mac_pcu_reset_tsf;
    volatile unsigned int mac_pcu_tsf_add_pll;
    volatile unsigned int sleep_retention;
    volatile unsigned int btcoexctrl;
    volatile unsigned int wbsync_priority1;
    volatile unsigned int wbsync_priority2;
    volatile unsigned int wbsync_priority3;
    volatile unsigned int btcoex0;
    volatile unsigned int btcoex1;
    volatile unsigned int btcoex2;
    volatile unsigned int btcoex3;
    volatile unsigned int btcoex4;
    volatile unsigned int btcoex5;
    volatile unsigned int btcoex6;
    volatile unsigned int lock;
    volatile unsigned int nolock_priority;
    volatile unsigned int wbsync;
    volatile unsigned int wbsync1;
    volatile unsigned int wbsync2;
    volatile unsigned int wbsync3;
    volatile unsigned int wb_timer_target;
    volatile unsigned int wb_timer_slop;
    volatile unsigned int btcoex_int_en;
    volatile unsigned int btcoex_int_stat;
    volatile unsigned int btpriority_int_en;
    volatile unsigned int btpriority_int_stat;
    volatile unsigned int btpriority_stomp_int_en;
    volatile unsigned int btpriority_stomp_int_stat;
    volatile unsigned int mac_pcu_bmiss_timeout;
    volatile unsigned int mac_pcu_cab_awake;
    volatile unsigned int lp_perf_counter;
    volatile unsigned int lp_perf_light_sleep;
    volatile unsigned int lp_perf_deep_sleep;
    volatile unsigned int lp_perf_on;
    volatile unsigned int st_64_bit;
    volatile unsigned int message_wr;
    volatile unsigned int message_wr_p;
    volatile unsigned int message_rd;
    volatile unsigned int message_rd_p;
    volatile unsigned int chip_mode;
    volatile unsigned int clk_req_fall_edge;
    volatile unsigned int otp;
    volatile unsigned int otp_status;
    volatile unsigned int pmu;
    unsigned char pad2[4]; /* pad to 0x2c0 */
    volatile unsigned int pmu_config[2];
    volatile unsigned int pmu_bypass;
    volatile unsigned int mac_pcu_tsf2_l32;
    volatile unsigned int mac_pcu_tsf2_u32;
    volatile unsigned int mac_pcu_generic_timers_mode3;
    volatile unsigned int mac_pcu_direct_connect;
    volatile unsigned int therm_ctrl1;
    volatile unsigned int therm_ctrl2;
    volatile unsigned int therm_ctrl3;
} rtc_wlan_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _RTC_WLAN_REG_H_ */
