/*
 * Copyright (c) 2015 - 2016, Freescale Semiconductor, Inc.
 * Copyright 2016 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "MK20D10.h"
#include "core_cm4.h"

#include "fsl_uart.h"
#include "fsl_debug_console.h"
#include "pin_mux.h"
#include "board.h"
#include "uart.h"
#include "mouse.h"
#include "uart_to_hid_protocol.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/


/*******************************************************************************
 * Prototypes
 ******************************************************************************/
extern void USB_DeviceApplicationInit(void);

/*******************************************************************************
 * Variables
 ******************************************************************************/
uint8_t g_tipString[] =
    "Uart functional API interrupt example\r\nBoard receives characters then sends them out\r\nNow please input:\r\n";

extern uint8_t g_UartRxBuffer[DEMO_RING_BUFFER_SIZE];
extern volatile uint16_t txIndex; /* Index of the data to send out. */
extern volatile uint16_t rxIndex; /* Index of the memory to save new arrived data. */


/*******************************************************************************
 * Code
 ******************************************************************************/
 void Clock_Configuration(void)
{
    SIM->CLKDIV1 = (uint32_t)0x00110000u; /* Update system prescalers */
    /* Switch to FBE Mode */
    /* OSC0->CR: ERCLKEN=0,?=0,EREFSTEN=0,?=0,SC2P=0,SC4P=0,SC8P=0,SC16P=0 */
    OSC0->CR = (uint8_t)0x00u;
    /* MCG->C7: OSCSEL=0 */
    MCG->C7 = (uint8_t)0x00u;
    /* MCG->C2: ?=0,?=0,RANGE0=2,HGO=0,EREFS=1,LP=0,IRCS=0 */
    MCG->C2 = (uint8_t)0x24u;
    /* MCG->C1: CLKS=2,FRDIV=3,IREFS=0,IRCLKEN=1,IREFSTEN=0 */
    MCG->C1 = (uint8_t)0x9Au;
    /* MCG->C4: DMX32=0,DRST_DRS=0 */
    MCG->C4 &= (uint8_t)~(uint8_t)0xE0u;
    /* MCG->C5: ?=0,PLLCLKEN=0,PLLSTEN=0,PRDIV0=3 */
    MCG->C5 = (uint8_t)0x03u;
    /* MCG->C6: LOLIE=0,PLLS=0,CME=0,VDIV0=0 */
    MCG->C6 = (uint8_t)0x00u;
    while((MCG->S & MCG_S_OSCINIT0_MASK) == 0u) { /* Check that the oscillator is running */
    }

    while((MCG->S & 0x0Cu) != 0x08u) {    /* Wait until external reference clock is selected as MCG output */
    }
    /* Switch to PBE Mode */
    /* MCG_C5: ?=0,PLLCLKEN=0,PLLSTEN=0,PRDIV0=3 */
    MCG->C5 = (uint8_t)0x03u;
    /* MCG->C6: LOLIE=0,PLLS=1,CME=0,VDIV0=0 */
    MCG->C6 = (uint8_t)0x40u;
    while((MCG->S & MCG_S_PLLST_MASK) == 0u) { /* Wait until the source of the PLLS clock has switched to the PLL */
    }
    while((MCG->S & MCG_S_LOCK0_MASK) == 0u) { /* Wait until locked */
    }
    /* Switch to PEE Mode */
    /* MCG->C1: CLKS=0,FRDIV=3,IREFS=0,IRCLKEN=1,IREFSTEN=0 */
    MCG->C1 = (uint8_t)0x1Au;
    while((MCG->S & 0x0Cu) != 0x0Cu) {    /* Wait until output of the PLL is selected */
    }
    while((MCG->S & MCG_S_LOCK0_MASK) == 0u) { /* Wait until locked */
    }
}
 
 
#if defined(__CC_ARM) || defined(__GNUC__)
int main(void)
#else
void main(void)
#endif
{
	  char ch;
	  gpio_pin_config_t led_config = {
        kGPIO_DigitalOutput, 0,
    };
	  uart_config_t config;
    BOARD_InitPins();
	  Clock_Configuration();
		
		GPIO_PinInit(GPIOD, 6U, &led_config);
		/* POWER Enable */
	  GPIO_WritePinOutput(GPIOD, 6U, 1);
	
	    /*
     * config.baudRate_Bps = 115200U;
     * config.parityMode = kUART_ParityDisabled;
     * config.stopBitCount = kUART_OneStopBit;
     * config.txFifoWatermark = 0;
     * config.rxFifoWatermark = 1;
     * config.enableTx = false;
     * config.enableRx = false;
     */
    UART_GetDefaultConfig(&config);
    config.baudRate_Bps = BOARD_DEBUG_UART_BAUDRATE;
    config.enableTx = true;
    config.enableRx = true;
		

    UART_Init(UART1, &config, 48000000);
		//uart_to_hid_init();

    /* Send g_tipString out. */
    UART_WriteBlocking(UART1, g_tipString, sizeof(g_tipString) / sizeof(g_tipString[0]));

    /* Enable RX interrupt. */
    UART_EnableInterrupts(UART1, kUART_RxDataRegFullInterruptEnable | kUART_RxOverrunInterruptEnable);
		
		
    EnableIRQ(UART1_RX_TX_IRQn);
	
	
	  PRINTF("hello world\r\n");

    USB_DeviceApplicationInit();

    while (1U)
    {

			

    }
		



}
