/*
 * Copyright (c) 2015 - 2016, Freescale Semiconductor, Inc.
 * Copyright 2016 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */



#include "uart_to_hid_protocol.h"
#include "mouse.h"
#include "MK20D10.h"
#include "fsl_uart.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/


/*******************************************************************************
 * Prototypes
 ******************************************************************************/


/*******************************************************************************
 * Variables
 ******************************************************************************/
uint8_t g_UartCmdData[16];
ch9329_uart_data_struct_t g_UartCmd;
ch9329_uart_data_struct_t g_UartCmdAck;
uint8_t g_UartCmdUpdataFlag;

extern usb_hid_mouse_struct_t g_UsbDeviceHidMouse;



/*******************************************************************************
 * Code
 ******************************************************************************/
void uart_mouse_handle(ch9329_uart_data_struct_t * uart_hid_data)
{
	  ch9329_uart_data_struct_t * uartCmd = uart_hid_data;
	  uint16_t sum;
	  uint8_t i;
    //uint16_t x_data;
	  //uint16_t y_data;
	  
	  sum = 0;
	  sum = uartCmd->header[0] + uartCmd->header[1] + uartCmd->addr + uartCmd->cmd + uartCmd->length;
	  for(i = 0; i < uartCmd->length; i++)
	  {
			  sum += uartCmd->data[i];
		}
		
		/* Low 8 bytes is valid */
		sum = sum & 0xFF;
		
		/* Not a valid uart command frame */
		if(sum != uartCmd->data[i])
		{
			  return;
		}
	  
	  /* Check sum */
	  
	  switch(uartCmd->cmd)
		{
			  case CMD_SEND_MS_ABS_DATA:
				    {
							  /* The first byte must be 0x02 */
							  if(uartCmd->data[0] != 0x02)
								{
									  return;
								}								
					  
							  /* Report ID */
								g_UsbDeviceHidMouse.buffer[0] = uartCmd->data[0];
								//g_UsbDeviceHidMouse.buffer[1] ;
								g_UsbDeviceHidMouse.buffer[2] = uartCmd->data[2];
								g_UsbDeviceHidMouse.buffer[3] = uartCmd->data[3];
								g_UsbDeviceHidMouse.buffer[4] = uartCmd->data[4];
								g_UsbDeviceHidMouse.buffer[5] = uartCmd->data[5];
								g_UsbDeviceHidMouse.length = 6;
								
								g_UartCmdAck.header[0] = 0x57;
								g_UartCmdAck.header[1] = 0xAB;
								g_UartCmdAck.addr = 0x00;
								g_UartCmdAck.cmd = 0x84;
								g_UartCmdAck.length = 1;
								g_UartCmdAck.data[0] = 0x00;
								g_UartCmdAck.data[1] = g_UartCmdAck.header[0] + g_UartCmdAck.header[1] + g_UartCmdAck.addr + g_UartCmdAck.cmd + g_UartCmdAck.length + g_UartCmdAck.data[0];							
								
				    }
				    break;
				case CMD_SEND_MS_REL_DATA:
				    {
							  /* The first byte must be 0x01 */
							  if(uartCmd->data[0] != 0x01)
								{
									  return;
								}
								
								/* Report ID */
								g_UsbDeviceHidMouse.buffer[0] = uartCmd->data[0];
								g_UsbDeviceHidMouse.buffer[2] = uartCmd->data[2];
								g_UsbDeviceHidMouse.buffer[3] = uartCmd->data[3];
								g_UsbDeviceHidMouse.length = 5;
								
								g_UartCmdAck.header[0] = 0x57;
								g_UartCmdAck.header[1] = 0xAB;
								g_UartCmdAck.addr = 0x00;
								g_UartCmdAck.cmd = 0x85;
								g_UartCmdAck.length = 1;
								g_UartCmdAck.data[0] = 0x00;
								g_UartCmdAck.data[1] = g_UartCmdAck.header[0] + g_UartCmdAck.header[1] + g_UartCmdAck.addr + g_UartCmdAck.cmd + g_UartCmdAck.length + g_UartCmdAck.data[0];
								
				    }
				    break;
				default:
				  	break;
		}
		

		g_UartCmdUpdataFlag = 1;
		UART_WriteBlocking(UART1, (const uint8_t *)&g_UartCmdAck, 7);
		
		
}
void uart_to_hid_init(void)
{
	  //g_UartCmd.data = g_UartCmdData;
}
