/*
 * Copyright (c) 2013 - 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <xtensa/config/core.h>

#include "srtm_naturedsp_test.h"
#include "fsl_device_registers.h"
#include "fsl_debug_console.h"
#include "fsl_common.h"
#include "fsl_mu.h"
#include "fsl_usart.h"

#include "pin_mux.h"
#include "board_fusionf1.h"

/* Signal Processing Library API. */
#include "NatureDSP_Signal.h"
#include "scl_sine_table32.h"
#include "scl_sqrt_table.h"

/* Portable data types. */
#include "NatureDSP_types.h"
#include "math.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define APP_MU MUB
/* Flag indicates Core Boot Up*/
#define BOOT_FLAG 0x01U

/* Channel transmit and receive register */
#define CHN_MU_REG_NUM 0U

/* How many message is used to test message sending */
#define MSG_LENGTH 32U

#define FLOAT_2_Q31(x) ((int32_t)((x)*2147483648.0f))

#define DEMO_USART USART0
#define DEMO_USART_CLK_SRC kCLOCK_Flexcomm0
#define DEMO_USART_CLK_FREQ CLOCK_GetFlexcommClkFreq(0U)

#define BOARD_XTAL_SYS_CLK_HZ 24000000U /*!< Board xtal_sys frequency in Hz */

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/


/*!
 * @brief Main function
 */

int main(void)
{
	usart_config_t config;
    uint8_t g_msgRecv = 0;

    /* Init board hardware. */
    CLOCK_SetXtalFreq(BOARD_XTAL_SYS_CLK_HZ);
    BOARD_InitDebugConsole();

    /* Enable Rx and Tx on UART */
    USART_GetDefaultConfig(&config);
	config.baudRate_Bps = BOARD_DEBUG_UART_BAUDRATE;
	config.enableTx     = true;
	config.enableRx     = true;

	USART_Init(DEMO_USART, &config, DEMO_USART_CLK_FREQ);

    /* MUB init */
    MU_Init(APP_MU);

    /* Send flag to Core 0 to indicate Core 1 has startup */
    MU_SetFlags(APP_MU, BOOT_FLAG);

    while (1)
    {
    	/* Wait until a message from CM33 is received */
        g_msgRecv = MU_ReceiveMsg(APP_MU, CHN_MU_REG_NUM);

		/* Execute math function */
		switch(g_msgRecv)
		{
			case 1:
				/* Execute square root */
				TEST_SQRT();
				break;
			case 2:
				/* Execute sine */
				TEST_SINE();
				break;
			case 3:
				/* Execute vector add */
				TEST_VEC_ADD();
				break;
			case 4:
				/* Execute vector dot product */
				TEST_VEC_DOT();
				break;
			case 5:
				/* Execute inverse matrix */
				TEST_MATRIX_INV();
				break;
			case 6:
				/* Execute matrix transpose */
				TEST_MATRIX_TRANSPOSE();
				break;
			default:
				break;
		}
    }
}
