/*
 * Copyright 2019-2021 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v6.0
processor: MIMXRT595S
package_id: MIMXRT595SFFOB
mcu_data: ksdk2_0
processor_version: 0.0.0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_iopctl.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: fusionf1, enableClock: 'true'}
- pin_list:
  - {pin_num: B12, peripheral: GPIO, signal: 'PIO0, 14', pin_signal: PIO0_14/FC2_SCK/SCT0_GPI0/SCT0_OUT0/CTIMER2_MAT0/SEC_PIO0_14}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cadence-FusionF1 */
void BOARD_InitPins(void)
{
	const uint32_t port0_pin1_config = (/* Pin is configured as FC0_TXD_SCL_MISO_WS */
	                                        IOPCTL_PIO_FUNC1 |
	                                        /* Disable pull-up / pull-down function */
	                                        IOPCTL_PIO_PUPD_DI |
	                                        /* Enable pull-down function */
	                                        IOPCTL_PIO_PULLDOWN_EN |
	                                        /* Disable input buffer function */
	                                        IOPCTL_PIO_INBUF_DI |
	                                        /* Normal mode */
	                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
	                                        /* Normal drive */
	                                        IOPCTL_PIO_FULLDRIVE_DI |
	                                        /* Analog mux is disabled */
	                                        IOPCTL_PIO_ANAMUX_DI |
	                                        /* Pseudo Output Drain is disabled */
	                                        IOPCTL_PIO_PSEDRAIN_DI |
	                                        /* Input function is not inverted */
	                                        IOPCTL_PIO_INV_DI);
	    /* PORT0 PIN1 (coords: G16) is configured as FC0_TXD_SCL_MISO_WS */
	    IOPCTL_PinMuxSet(IOPCTL, 0U, 1U, port0_pin1_config);

	    const uint32_t port0_pin2_config = (/* Pin is configured as FC0_RXD_SDA_MOSI_DATA */
	                                        IOPCTL_PIO_FUNC1 |
	                                        /* Disable pull-up / pull-down function */
	                                        IOPCTL_PIO_PUPD_DI |
	                                        /* Enable pull-down function */
	                                        IOPCTL_PIO_PULLDOWN_EN |
	                                        /* Disable input buffer function */
	                                        IOPCTL_PIO_INBUF_DI |
	                                        /* Normal mode */
	                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
	                                        /* Normal drive */
	                                        IOPCTL_PIO_FULLDRIVE_DI |
	                                        /* Analog mux is disabled */
	                                        IOPCTL_PIO_ANAMUX_DI |
	                                        /* Pseudo Output Drain is disabled */
	                                        IOPCTL_PIO_PSEDRAIN_DI |
	                                        /* Input function is not inverted */
	                                        IOPCTL_PIO_INV_DI);
	    /* PORT0 PIN2 (coords: H16) is configured as FC0_RXD_SDA_MOSI_DATA */
	    IOPCTL_PinMuxSet(IOPCTL, 0U, 2U, port0_pin2_config);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
