#**************************************************************************/
#* FILE NAME: intc_sw_handlers.s            COPYRIGHT (c) Freescale 2012  */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#*        This file creates prolog, epilog for C ISR and enables nested   */
#*        interrupts. This file starts in memory at the beginning of the  */
#*        ".xcptn" section designated by the label "IVOR4Handler".        */
#* WARNING:  This stack frame does not save the SPEs Accumulator, which   */
#*           is required if SPE instructions are used in ISRs.   If SPE   */
#*           instructions are used, the stack frame must include the      */
#*           accumulator, and prologue and epilogue must be modified.     */
#=========================================================================*/
    .globl   IVOR4_Handler
    .globl   IVOR1_Handler

    .extern  Machine_check_handler


    .section  .vletext, vax
    .vle

    .equ  INTC_IACKR, 0xfc040020  # Interrupt Acknowledge Register address
    .equ  INTC_EOIR,  0xfc040030  # End Of Interrupt Register address

    .align 4

IVOR4_Handler:
prolog:                           # PROLOGUE 
    e_stwu   r1, -0x50 (r1)       # Create stack frame and store back chain
    e_stw    r0, 0x24 (r1)        # Save working registers R0
    mfSRR1 r0                     # Store SRR1 (must be done before enabling EE)
    e_stw    r0, 0x10 (r1)
    mfSRR0 r0                     # Store SRR0 (must be done before enabling EE)
    e_stw    r0, 0x0C (r1)
    mfLR   r0              	# Store LR (Store now since LR will be used for ISR Vector)
    e_stw    r0, 0x14 (r1)

    e_stw    r3, 0x28 (r1)        # Store a working register

    e_lis    r3, INTC_IACKR@h     # Store address of IACKR in r3
    e_or2i   r3, INTC_IACKR@l
    e_lwz    r3, 0(r3)            # Store contents of IACKR in r3 (this is vector table
#                                 # address)
   e_lwz    r0, 0(r3)            # Read ISR address from ISR Vector Table address

    mtLR   r0                     # Store ISR address to LR to use for branching later

    wrteei 1         			  # Set MSR[EE]=1 (must wait a couple clocks after reading IACKR)
    e_stw    r12, 0x4C (r1)       # Store rest of gprs
    e_stw    r11, 0x48 (r1)
    e_stw    r10, 0x44 (r1)
    e_stw    r9,  0x40 (r1)
    e_stw    r8,  0x3C (r1)
    e_stw    r7,  0x38 (r1)
    e_stw    r6,  0x34 (r1)
    e_stw    r5,  0x30 (r1)
    e_stw    r4,  0x2c (r1)  
	
    mfCR   r0                      # Store CR
    e_stw    r0,  0x20 (r1)
    mfXER  r0                      # Store XER
    e_stw    r0,  0x1C (r1)
    mfCTR  r0                      # Store CTR
    e_stw    r0,  0x18 (r1)
								
    se_blrl                 # Branch to ISR, but return here

epilog:                            # EPILOGUE

#                                  # STEP 6 :  RESTORE CONTEXT
    mbar 0                         # Ensure interrupt flag has finished clearing
#                                  # before writing to INTC_EIOR

	
    e_lwz    r0, 0x14 (r1)         # Restore LR
    mtLR   r0
    e_lwz    r0, 0x18 (r1)         # Restore CTR
    mtCTR  r0
    e_lwz    r0, 0x1C (r1)         # Restore XER
    mtXER  r0
    e_lwz    r0, 0x20 (r1)         # Restore CR
    mtcrf  0xff, r0
    e_lwz    r5,  0x30 (r1)
    e_lwz    r6,  0x34 (r1)
    e_lwz    r7,  0x38 (r1)
    e_lwz    r8,  0x3C (r1)
    e_lwz    r9,  0x40 (r1)
    e_lwz    r10, 0x44 (r1)
    e_lwz    r11, 0x48 (r1)
    e_lwz    r12, 0x4C (r1)

    wrteei 0                       # Disable interrupts

    se_li     r3,0		
    e_lis   r4, INTC_EOIR@ha       # Load upper half of EIOR address to r4
    e_add16i  r4,r4, INTC_EOIR@l      # Load lower half of EIOR address to R4
    e_stw   r3, 0(r4)              # Write 0 to INTC_EOIR, address 0xFFF4 8018
    
    e_lwz    r3,  0x28 (r1)   	   # Restore r3 after INTC_EOIR uses this register
    e_lwz    r4,  0x2C (r1)  	   # Restore r4 after INTC_EOIR uses this register

    e_lwz    r0,  0x0C (r1)   	   # Restore SRR0
    mtSRR0 r0                      
    e_lwz    r0,  0x10 (r1)   	   # Restore SRR1
    mtSRR1 r0                      
    e_lwz    r0,  0x24 (r1)   	   # Restore working register
    e_add16i  r1,r1, 0x50    		   # Restore space on stack     e_add2i.  r1, 0x50    	

    se_rfi                         # End of Interrupt - re-enables interrupts.

    .align 16

IVOR1_Handler:
prolog_IVOR1:                                
    e_stwu   r1, -0x50(r1)            # Create stack frame and store back chain
    se_stw   r0,  0x20(r1)            # Store GPR0 (working register)
    se_mfctr r0
    se_stw   r0,  0x10(r1)            # Store CTR
    mfxer    r0
    se_stw   r0,  0x14(r1)            # Store XER
    mfcr     r0
    se_stw   r0,  0x18(r1)            # Store CR
    se_mflr  r0
    se_stw   r0,  0x1C(r1)            # Store LR
    se_stw   r3,  0x24(r1)            # Store GPR3
    se_stw   r4,  0x28(r1)            # Store GPR4
    se_stw   r5,  0x2C(r1)            # Store GPR5
    se_stw   r6,  0x30(r1)            # Store GPR6
    se_stw   r7,  0x34(r1)            # Store GPR7
    e_stw    r8,  0x38(r1)            # Store GPR8
    e_stw    r9,  0x3C(r1)            # Store GPR9
    e_stw    r10, 0x40(r1)            # Store GPR10
    e_stw    r11, 0x44(r1)            # Store GPR11
    e_stw    r12, 0x48(r1)            # Store GPR12

    mfmsr    r0                       # As function prologs/epilogs may contain
    e_or2is  r0, 0x0200               # SPE instruction, enable SPE, as MSR
    mtmsr    r0                       # register is cleared at this point

    e_lis    r0,  Machine_check_handler@h
    e_or2i   r0,  Machine_check_handler@l

    mtlr     r0                       # Store LR
    se_blrl                           # Branch to ISR, return here

epilog_IVOR1:
    se_lwz   r3,  0x24(r1)            # Restore GPR3
    se_lwz   r4,  0x28(r1)            # Restore GPR4
    se_lwz   r5,  0x2C(r1)            # Restore GPR5
    se_lwz   r6,  0x30(r1)            # Restore GPR6
    se_lwz   r7,  0x34(r1)            # Restore GPR7
    e_lwz    r8,  0x38(r1)            # Restore GPR8
    e_lwz    r9,  0x3C(r1)            # Restore GPR9
    e_lwz    r10, 0x40(r1)            # Restore GPR10
    e_lwz    r11, 0x44(r1)            # Restore GPR11
    e_lwz    r12, 0x48(r1)            # Restore GPR12
    se_lwz   r0,  0x10(r1)
    se_mtctr r0                       # Restore CTR
    se_lwz   r0,  0x14(r1)
    mtxer r0                          # Restore XER
    se_lwz   r0,  0x18(r1)
    mtcr  r0                          # Restore CR
    se_lwz   r0,  0x1C(r1)
    se_mtlr  r0                       # Restore LR
    
    se_lwz   r0,  0x20(r1)            # Restore GPR0 (working register)
    e_add16i r1, r1, 0x50             # Clean up stack
    se_rfmci                          # Return from machine check



