/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2014 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. FREESCALE neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED 
TO THE PROJECT BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE 
SERVICES. IN NO EVENT SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL 
DAMAGES ARISING OUT OF THIS AGREEMENT.
CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands 
or actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result 
of the advise or assistance supplied CUSTOMER in connection with product, 
services or goods supplied under this Agreement.
********************************************************************************
* File:             MPC5744P_IsrVecTab.c
* Owner:            b21190(Vlna Peter)
* Version:          1.0
* Date:             Jan-06-2015
* Classification:   General Business Information
* Brief:            ISR routines for INTC in HW or SW vector mode
********************************************************************************
********************************************************************************
* Detailed Description:
* ISR routines for Panther (MPC5744P)
* 
* ------------------------------------------------------------------------------
* Test HW:  MPC57xx
* Maskset:  1N65H
* Target :  internal_FLASH
********************************************************************************
Revision History:
1.0     Jan-06-2015     b21190(Vlna Peter)  Initial Version for Panther
1.1     Mar-18-2015     b21190(Vlna Peter)  Fixed table
*******************************************************************************/

/*******************************************************************************
* Includes                                                                     
*******************************************************************************/
#include "INTC_Init.h"

/*******************************************************************************
* Local functions
*******************************************************************************/
void NonHandledINTCException();

/*******************************************************************************
* Global variables
*******************************************************************************/
extern void FCCU_Alarm_Interrupt(void);

// ****************************************************************************
//in case you are using SW interrupts and VLE is enabled use this
#pragma asm
  .macro ISRline value
  .long  value
  .endm    
#pragma endasm

//In case you are using HW use this 
//#pragma asm
//    .macro ISRline value
//    e_b  value
//	nop
//	nop
//	nop
//    .endm
//#pragma endasm

// ****************************************************************************
// ************************ Internal Constants and Variables ******************
// ****************************************************************************
/* Use next line with Green Hills compile */
#pragma ghs section rodata=".isrvectab"

// This table contains all ISR routines called when a peripheral interrupt occurs.
// The table is used only when INTC is configured to work in "SW vector mode"

#pragma asm
   
  .section  ".isrvectab", "vax"
  .vle

    
  .global IntcIsrVectorTable
IntcIsrVectorTable:

  ; #IRQ 000                               ;*** Source of interrupt: SOFTWARE ***   
  ISRline NonHandledINTCException          ;Vec 000, INTC SW settable Clear Flag 0 
  ISRline NonHandledINTCException          ;Vec 001, INTC SW settable Clear Flag 1 
  ISRline NonHandledINTCException          ;Vec 002, INTC SW settable Clear Flag 2 
  ISRline NonHandledINTCException          ;Vec 003, INTC SW settable Clear Flag 3 
  ISRline NonHandledINTCException          ;Vec 004, INTC SW settable Clear Flag 4 
  ISRline NonHandledINTCException          ;Vec 005, INTC SW settable Clear Flag 5 
  ISRline NonHandledINTCException          ;Vec 006, INTC SW settable Clear Flag 6 
  ISRline NonHandledINTCException          ;Vec 007, INTC SW settable Clear Flag 7 
  ISRline NonHandledINTCException          ;Vec 008, INTC SW settable Clear Flag 8 
  ISRline NonHandledINTCException          ;Vec 009, INTC SW settable Clear Flag 9 
  ISRline NonHandledINTCException          ;Vec 010, INTC SW settable Clear Flag 10
  ISRline NonHandledINTCException          ;Vec 011, INTC SW settable Clear Flag 11
  ISRline NonHandledINTCException          ;Vec 012, INTC SW settable Clear Flag 12
  ISRline NonHandledINTCException          ;Vec 013, INTC SW settable Clear Flag 13
  ISRline NonHandledINTCException          ;Vec 014, INTC SW settable Clear Flag 14
  ISRline NonHandledINTCException          ;Vec 015, INTC SW settable Clear Flag 15
                                                                                   
                                           ;*** Source of interrupt: Reserved ***                                        
  ISRline NonHandledINTCException          ;Vec 016, Reserved 
  ISRline NonHandledINTCException          ;Vec 017, Reserved
  ISRline NonHandledINTCException          ;Vec 018, Reserved
  ISRline NonHandledINTCException          ;Vec 019, Reserved
  ISRline NonHandledINTCException          ;Vec 020, Reserved
  ISRline NonHandledINTCException          ;Vec 021, Reserved
  ISRline NonHandledINTCException          ;Vec 022, Reserved
  ISRline NonHandledINTCException          ;Vec 023, Reserved
  ISRline NonHandledINTCException          ;Vec 024, Reserved
  ISRline NonHandledINTCException          ;Vec 025, Reserved
  ISRline NonHandledINTCException          ;Vec 026, Reserved
  ISRline NonHandledINTCException          ;Vec 027, Reserved
  ISRline NonHandledINTCException          ;Vec 028, Reserved
  ISRline NonHandledINTCException          ;Vec 029, Reserved
  ISRline NonHandledINTCException          ;Vec 030, Reserved
  ISRline NonHandledINTCException          ;Vec 031, Reserved
  
                                           ;*** Source of interrupt: Software watchdog timer ***
  ISRline NonHandledINTCException          ;Vec 032, Platform software watchdog timeout
  ISRline NonHandledINTCException          ;Vec 033, Reserved for Platform watchdog timer1
  ISRline NonHandledINTCException          ;Vec 034, Reserved for Platform watchdog timer2
  ISRline NonHandledINTCException          ;Vec 035, Reserved for Platform watchdog timer3

                                           ;*** Source of interrupt: STM ***    
  ISRline NonHandledINTCException          ;Vec 036, Platform periodic timer 0_0              
  ISRline NonHandledINTCException          ;Vec 037, Platform periodic timer 0_1           
  ISRline NonHandledINTCException          ;Vec 038, Platform periodic timer 0_2           
  ISRline NonHandledINTCException          ;Vec 039, Platform periodic timer 0_3
                                           ;*** Source of interrupt: STM Reserved***
  ISRline NonHandledINTCException          ;Vec 040, Reserved (for Platform periodic timer 1_0)              
  ISRline NonHandledINTCException          ;Vec 041, Reserved (for Platform periodic timer 1_1)           
  ISRline NonHandledINTCException          ;Vec 042, Reserved (for Platform periodic timer 1_2)           
  ISRline NonHandledINTCException          ;Vec 043, Reserved (for Platform periodic timer 1_3)
  ISRline NonHandledINTCException          ;Vec 044, Reserved (for Platform periodic timer 2_0)              
  ISRline NonHandledINTCException          ;Vec 045, Reserved (for Platform periodic timer 2_1)           
  ISRline NonHandledINTCException          ;Vec 046, Reserved (for Platform periodic timer 2_2)           
  ISRline NonHandledINTCException          ;Vec 047, Reserved (for Platform periodic timer 2_3)
  ISRline NonHandledINTCException          ;Vec 048, Reserved (for Platform periodic timer 3_0)              
  ISRline NonHandledINTCException          ;Vec 049, Reserved (for Platform periodic timer 3_1)           
  ISRline NonHandledINTCException          ;Vec 050, Reserved (for Platform periodic timer 3_2)           
  ISRline NonHandledINTCException          ;Vec 051, Reserved (for Platform periodic timer 3_3)
  
                                           ;*** Source of interrupt: eDMA ***                   
  ISRline NonHandledINTCException          ;Vec 052, eDMA Combined Error                                                    
  ISRline NonHandledINTCException          ;Vec 053, eDMA Channel 0
  ISRline NonHandledINTCException          ;Vec 054, eDMA Channel 1
  ISRline NonHandledINTCException          ;Vec 055, eDMA Channel 2
  ISRline NonHandledINTCException          ;Vec 056, eDMA Channel 3
  ISRline NonHandledINTCException          ;Vec 057, eDMA Channel 4
  ISRline NonHandledINTCException          ;Vec 058, eDMA Channel 5
  ISRline NonHandledINTCException          ;Vec 059, eDMA Channel 6                                                  
  ISRline NonHandledINTCException          ;Vec 060, eDMA Channel 7                                                  
  ISRline NonHandledINTCException          ;Vec 061, eDMA Channel 8 
  ISRline NonHandledINTCException          ;Vec 062, eDMA Channel 9
  ISRline NonHandledINTCException          ;Vec 063, eDMA Channel 10
  ISRline NonHandledINTCException          ;Vec 064, eDMA Channel 11
  ISRline NonHandledINTCException          ;Vec 065, eDMA Channel 12
  ISRline NonHandledINTCException          ;Vec 066, eDMA Channel 13
  ISRline NonHandledINTCException          ;Vec 067, eDMA Channel 14
  ISRline NonHandledINTCException          ;Vec 068, eDMA Channel 15
  ISRline NonHandledINTCException          ;Vec 069, eDMA Channel 16
  ISRline NonHandledINTCException          ;Vec 070, eDMA Channel 17
  ISRline NonHandledINTCException          ;Vec 071, eDMA Channel 18
  ISRline NonHandledINTCException          ;Vec 072, eDMA Channel 19
  ISRline NonHandledINTCException          ;Vec 073, eDMA Channel 20
  ISRline NonHandledINTCException          ;Vec 074, eDMA Channel 21
  ISRline NonHandledINTCException          ;Vec 075, eDMA Channel 22
  ISRline NonHandledINTCException          ;Vec 076, eDMA Channel 23 
  ISRline NonHandledINTCException          ;Vec 077, eDMA Channel 24 
  ISRline NonHandledINTCException          ;Vec 078, eDMA Channel 25
  ISRline NonHandledINTCException          ;Vec 079, eDMA Channel 26
  ISRline NonHandledINTCException          ;Vec 080, eDMA Channel 27
  ISRline NonHandledINTCException          ;Vec 081, eDMA Channel 28
  ISRline NonHandledINTCException          ;Vec 082, eDMA Channel 29
  ISRline NonHandledINTCException          ;Vec 083, eDMA Channel 30
  ISRline NonHandledINTCException          ;Vec 084, eDMA Channel 31
                                           ;*** Source of interrupt: eDMA Reserved ***
  ISRline NonHandledINTCException          ;Vec 085, Reserved for eDMA Channel 32 
  ISRline NonHandledINTCException          ;Vec 086, Reserved for eDMA Channel 33
  ISRline NonHandledINTCException          ;Vec 087, Reserved for eDMA Channel 34
  ISRline NonHandledINTCException          ;Vec 088, Reserved for eDMA Channel 35
  ISRline NonHandledINTCException          ;Vec 089, Reserved for eDMA Channel 36
  ISRline NonHandledINTCException          ;Vec 090, Reserved for eDMA Channel 37
  ISRline NonHandledINTCException          ;Vec 091, Reserved for eDMA Channel 38
  ISRline NonHandledINTCException          ;Vec 092, Reserved for eDMA Channel 39
  ISRline NonHandledINTCException          ;Vec 093, Reserved for eDMA Channel 40
  ISRline NonHandledINTCException          ;Vec 094, Reserved for eDMA Channel 41
  ISRline NonHandledINTCException          ;Vec 095, Reserved for eDMA Channel 42
  ISRline NonHandledINTCException          ;Vec 096, Reserved for eDMA Channel 43
  ISRline NonHandledINTCException          ;Vec 097, Reserved for eDMA Channel 44
  ISRline NonHandledINTCException          ;Vec 098, Reserved for eDMA Channel 45
  ISRline NonHandledINTCException          ;Vec 099, Reserved for eDMA Channel 46
  ISRline NonHandledINTCException          ;Vec 100, Reserved for eDMA Channel 47
  ISRline NonHandledINTCException          ;Vec 101, Reserved for eDMA Channel 48
  ISRline NonHandledINTCException          ;Vec 102, Reserved for eDMA Channel 49                                                    
  ISRline NonHandledINTCException          ;Vec 103, Reserved for eDMA Channel 50
  ISRline NonHandledINTCException          ;Vec 104, Reserved for eDMA Channel 51  
  ISRline NonHandledINTCException          ;Vec 105, Reserved for eDMA Channel 52
  ISRline NonHandledINTCException          ;Vec 106, Reserved for eDMA Channel 53  
  ISRline NonHandledINTCException          ;Vec 107, Reserved for eDMA Channel 54  
  ISRline NonHandledINTCException          ;Vec 108, Reserved for eDMA Channel 55  
  ISRline NonHandledINTCException          ;Vec 109, Reserved for eDMA Channel 56
  ISRline NonHandledINTCException          ;Vec 110, Reserved for eDMA Channel 57  
  ISRline NonHandledINTCException          ;Vec 111, Reserved for eDMA Channel 58
  ISRline NonHandledINTCException          ;Vec 112, Reserved for eDMA Channel 59  
  ISRline NonHandledINTCException          ;Vec 113, Reserved for eDMA Channel 60  
  ISRline NonHandledINTCException          ;Vec 114, Reserved for eDMA Channel 61  
  ISRline NonHandledINTCException          ;Vec 115, Reserved for eDMA Channel 62
  ISRline NonHandledINTCException          ;Vec 116, Reserved for eDMA Channel 63 
  ISRline NonHandledINTCException          ;Vec 117, Reserved for eDMA Channel 64
  ISRline NonHandledINTCException          ;Vec 118, Reserved for eDMA Channel 65  
  ISRline NonHandledINTCException          ;Vec 119, Reserved for eDMA Channel 66
  ISRline NonHandledINTCException          ;Vec 120, Reserved for eDMA Channel 67
  ISRline NonHandledINTCException          ;Vec 121, Reserved for eDMA Channel 68
  ISRline NonHandledINTCException          ;Vec 122, Reserved for eDMA Channel 69
  ISRline NonHandledINTCException          ;Vec 123, Reserved for eDMA Channel 70
  ISRline NonHandledINTCException          ;Vec 124, Reserved for eDMA Channel 71
  ISRline NonHandledINTCException          ;Vec 125, Reserved for eDMA Channel 72
  ISRline NonHandledINTCException          ;Vec 126, Reserved for eDMA Channel 73
  ISRline NonHandledINTCException          ;Vec 127, Reserved for eDMA Channel 74
  ISRline NonHandledINTCException          ;Vec 128, Reserved for eDMA Channel 75
  ISRline NonHandledINTCException          ;Vec 129, Reserved for eDMA Channel 76
  ISRline NonHandledINTCException          ;Vec 130, Reserved for eDMA Channel 77
  ISRline NonHandledINTCException          ;Vec 131, Reserved for eDMA Channel 78
  ISRline NonHandledINTCException          ;Vec 132, Reserved for eDMA Channel 79
  ISRline NonHandledINTCException          ;Vec 133, Reserved for eDMA Channel 80
  ISRline NonHandledINTCException          ;Vec 134, Reserved for eDMA Channel 81
  ISRline NonHandledINTCException          ;Vec 135, Reserved for eDMA Channel 82
  ISRline NonHandledINTCException          ;Vec 136, Reserved for eDMA Channel 83
  ISRline NonHandledINTCException          ;Vec 137, Reserved for eDMA Channel 84
  ISRline NonHandledINTCException          ;Vec 138, Reserved for eDMA Channel 85
  ISRline NonHandledINTCException          ;Vec 139, Reserved for eDMA Channel 86
  ISRline NonHandledINTCException          ;Vec 140, Reserved for eDMA Channel 87
  ISRline NonHandledINTCException          ;Vec 141, Reserved for eDMA Channel 88
  ISRline NonHandledINTCException          ;Vec 142, Reserved for eDMA Channel 89
  ISRline NonHandledINTCException          ;Vec 143, Reserved for eDMA Channel 90
  ISRline NonHandledINTCException          ;Vec 144, Reserved for eDMA Channel 91
  ISRline NonHandledINTCException          ;Vec 145, Reserved for eDMA Channel 92
  ISRline NonHandledINTCException          ;Vec 146, Reserved for eDMA Channel 93
  ISRline NonHandledINTCException          ;Vec 147, Reserved for eDMA Channel 94
  ISRline NonHandledINTCException          ;Vec 148, Reserved for eDMA Channel 95
  ISRline NonHandledINTCException          ;Vec 149, Reserved for eDMA Channel 96
  ISRline NonHandledINTCException          ;Vec 150, Reserved for eDMA Channel 97
  ISRline NonHandledINTCException          ;Vec 151, Reserved for eDMA Channel 98
  ISRline NonHandledINTCException          ;Vec 152, Reserved for eDMA Channel 99
  ISRline NonHandledINTCException          ;Vec 153, Reserved for eDMA Channel 100 
  ISRline NonHandledINTCException          ;Vec 154, Reserved for eDMA Channel 101  
  ISRline NonHandledINTCException          ;Vec 155, Reserved for eDMA Channel 102  
  ISRline NonHandledINTCException          ;Vec 156, Reserved for eDMA Channel 103  
  ISRline NonHandledINTCException          ;Vec 157, Reserved for eDMA Channel 104  
  ISRline NonHandledINTCException          ;Vec 158, Reserved for eDMA Channel 105
  ISRline NonHandledINTCException          ;Vec 159, Reserved for eDMA Channel 106  
  ISRline NonHandledINTCException          ;Vec 160, Reserved for eDMA Channel 107  
  ISRline NonHandledINTCException          ;Vec 161, Reserved for eDMA Channel 108  
  ISRline NonHandledINTCException          ;Vec 162, Reserved for eDMA Channel 109  
  ISRline NonHandledINTCException          ;Vec 163, Reserved for eDMA Channel 110  
  ISRline NonHandledINTCException          ;Vec 164, Reserved for eDMA Channel 111  
  ISRline NonHandledINTCException          ;Vec 165, Reserved for eDMA Channel 112  
  ISRline NonHandledINTCException          ;Vec 166, Reserved for eDMA Channel 113  
  ISRline NonHandledINTCException          ;Vec 167, Reserved for eDMA Channel 114  
  ISRline NonHandledINTCException          ;Vec 168, Reserved for eDMA Channel 115  
  ISRline NonHandledINTCException          ;Vec 169, Reserved for eDMA Channel 116
  ISRline NonHandledINTCException          ;Vec 170, Reserved for eDMA Channel 117  
  ISRline NonHandledINTCException          ;Vec 171, Reserved for eDMA Channel 118  
  ISRline NonHandledINTCException          ;Vec 172, Reserved for eDMA Channel 119  
  ISRline NonHandledINTCException          ;Vec 173, Reserved for eDMA Channel 120  
  ISRline NonHandledINTCException          ;Vec 174, Reserved for eDMA Channel 121  
  ISRline NonHandledINTCException          ;Vec 175, Reserved for eDMA Channel 122  
  ISRline NonHandledINTCException          ;Vec 176, Reserved for eDMA Channel 123
  ISRline NonHandledINTCException          ;Vec 177, Reserved for eDMA Channel 124  
  ISRline NonHandledINTCException          ;Vec 178, Reserved for eDMA Channel 125  
  ISRline NonHandledINTCException          ;Vec 179, Reserved for eDMA Channel 126  
  ISRline NonHandledINTCException          ;Vec 180, Reserved for eDMA Channel 127
  
                                           ;*** Source of interrupt: MEMU Reserved ***
  ISRline NonHandledINTCException          ;Vec 181, Reserved for MEMU (Platform error reporting)
  ISRline NonHandledINTCException          ;Vec 182, Reserved for MEMU (Platform error reporting)   
  ISRline NonHandledINTCException          ;Vec 183, Reserved for MEMU (Platform error reporting)   
  ISRline NonHandledINTCException          ;Vec 184, Reserved for MEMU (Platform error reporting)  
     
                                           ;*** Source of interrupt: Platform flash controller ***
  ISRline NonHandledINTCException          ;Vec 185, Flash controller Prog/Erase/Suspend IRQ_0                                            
                                           ;*** Source of interrupt: Platform flash controller Reserved***
  ISRline NonHandledINTCException          ;Vec 186, Reserved for flash controller IRQs  
  ISRline NonHandledINTCException          ;Vec 187, Reserved for flash controller IRQs  
  ISRline NonHandledINTCException          ;Vec 188, Reserved for flash controller IRQs
  
                                           ;*** Source of interrupt: AMU reserved ***
  ISRline NonHandledINTCException          ;Vec 189, Reserved for AMU_0  
  ISRline NonHandledINTCException          ;Vec 190, Reserved for AMU_1  
  ISRline NonHandledINTCException          ;Vec 191, Reserved for AMU_2
  ISRline NonHandledINTCException          ;Vec 192, Reserved for AMU_3  
  ISRline NonHandledINTCException          ;Vec 193, Reserved for AMU_4  
  ISRline NonHandledINTCException          ;Vec 194, Reserved for AMU_5                                           
  ISRline NonHandledINTCException          ;Vec 195, Reserved for future AMU expansion  
  ISRline NonHandledINTCException          ;Vec 196, Reserved for future AMU expansion  
  ISRline NonHandledINTCException          ;Vec 197, Reserved for future AMU expansion
  ISRline NonHandledINTCException          ;Vec 198, Reserved for future AMU expansion
  
                                           ;*** Source of interrupt: SEMA4 Reserved ***
  ISRline NonHandledINTCException          ;Vec 199, Reserved for Semaphore IOP  
  ISRline NonHandledINTCException          ;Vec 200, Reserved for Semaphore CPU0
  ISRline NonHandledINTCException          ;Vec 201, Reserved for Semaphore CPU1
  ISRline NonHandledINTCException          ;Vec 202, Reserved for Semaphore CPU_SC
  
                                           ;*** Source of interrupt: Not defined Reserved***
  ISRline NonHandledINTCException          ;Vec 203, Reserved for future on-platform modules
  ISRline NonHandledINTCException          ;Vec 204, Reserved for future on-platform modules
  ISRline NonHandledINTCException          ;Vec 205, Reserved for future on-platform modules
  ISRline NonHandledINTCException          ;Vec 206, Reserved for future on-platform modules
  ISRline NonHandledINTCException          ;Vec 207, Reserved for future on-platform modules
  ISRline NonHandledINTCException          ;Vec 208, Reserved for future on-platform modules
  ISRline NonHandledINTCException          ;Vec 209, Reserved for future on-platform modules
  ISRline NonHandledINTCException          ;Vec 210, Reserved for future on-platform modules 
  ISRline NonHandledINTCException          ;Vec 211, Reserved for future on-platform modules 
  ISRline NonHandledINTCException          ;Vec 212, Reserved for future on-platform modules 
  ISRline NonHandledINTCException          ;Vec 213, Reserved for future on-platform modules 
  ISRline NonHandledINTCException          ;Vec 214, Reserved for future on-platform modules 
  ISRline NonHandledINTCException          ;Vec 215, Reserved for future on-platform modules 
  
                                           ;*** Source of interrupt: ENET_0 ***
  ISRline NonHandledINTCException          ;Vec 216, Timer IRQ Ethernet 0
  ISRline NonHandledINTCException          ;Vec 217, TX IRQ Ethernet 0
  ISRline NonHandledINTCException          ;Vec 218, RX IRQ Ethernet 0
  ISRline NonHandledINTCException          ;Vec 219, Error/Generic IRQ1 Ethernet 0
                                           ;*** Source of interrupt: ENET Reserved ***    
  ISRline NonHandledINTCException          ;Vec 220, Reserved for Ethernet_0_2          
  ISRline NonHandledINTCException          ;Vec 221, Reserved for Ethernet_1_0            
  ISRline NonHandledINTCException          ;Vec 222, Reserved for Ethernet_1_1            
  ISRline NonHandledINTCException          ;Vec 223, Reserved for Ethernet_1_2
  
                                           ;*** Source of interrupt: Not defined Reserved *** 
  ISRline NonHandledINTCException          ;Vec 224, Reserved for Real Time Counter (RTC)          
  ISRline NonHandledINTCException          ;Vec 225, Reserved for Autonomous Periodic Interrupt (API)
  
                                           ;*** Source of interrupt: PIT_0 ***
  ISRline NonHandledINTCException          ;Vec 226, Periodic Interrupt Timer (PIT_0) channel 0        
  ISRline NonHandledINTCException          ;Vec 227, Periodic Interrupt Timer (PIT_0) channel 1        
  ISRline NonHandledINTCException          ;Vec 228, Periodic Interrupt Timer (PIT_0) channel 2
  ISRline NonHandledINTCException          ;Vec 229, Periodic Interrupt Timer (PIT_0) channel 3
                                           ;*** Source of interrupt: PIT Reserved***                  
  ISRline NonHandledINTCException          ;Vec 230, Reserved for PITx
  ISRline NonHandledINTCException          ;Vec 231, Reserved for PITx
  ISRline NonHandledINTCException          ;Vec 232, Reserved for PITx
  ISRline NonHandledINTCException          ;Vec 233, Reserved for PITx
  ISRline NonHandledINTCException          ;Vec 234, Reserved for PITx
  ISRline NonHandledINTCException          ;Vec 235, Reserved for PITx
  ISRline NonHandledINTCException          ;Vec 236, Reserved for PITx
  ISRline NonHandledINTCException          ;Vec 237, Reserved for PITx
  ISRline NonHandledINTCException          ;Vec 238, Reserved for PITx
  ISRline NonHandledINTCException          ;Vec 239, Reserved for PIT_RTI
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 240, Reserved
  ISRline NonHandledINTCException          ;Vec 241, Reserved
  
                                           ;*** Source of interrupt: External oscillator ***
  ISRline NonHandledINTCException          ;Vec 242, XOSC counter expired
  
                                           ;*** Source of interrupt: SIUL2 ***
  ISRline NonHandledINTCException          ;Vec 243, SIUL2 External Interrupt_0                               
  ISRline NonHandledINTCException          ;Vec 244, SIUL2 External Interrupt_1
  ISRline NonHandledINTCException          ;Vec 245, SIUL2 External Interrupt_2
  ISRline NonHandledINTCException          ;Vec 246, SIUL2 External Interrupt_3                               
                                           ;*** Source of interrupt: SIUL2 Reserved ***  
  ISRline NonHandledINTCException          ;Vec 247, SIUL2 External Interrupt_4
  ISRline NonHandledINTCException          ;Vec 248, SIUL2 External Interrupt_5
  ISRline NonHandledINTCException          ;Vec 249, SIUL2 External Interrupt_6
  ISRline NonHandledINTCException          ;Vec 250, SIUL2 External Interrupt_7

                                           ;*** Source of interrupt: MC_ME ***  
  ISRline NonHandledINTCException          ;Vec 251, Safe Mode Interrupt
  ISRline NonHandledINTCException          ;Vec 252, Mode Transition Interrupt
  ISRline NonHandledINTCException          ;Vec 253, Invalid Mode Interrupt
  ISRline NonHandledINTCException          ;Vec 254, Invalid Mode Config
  
                                           ;*** Source of interrupt: MC_RGM ***
  ISRline NonHandledINTCException          ;Vec 255, Functional and destructive reset alternate event interrupt
                                           
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 256, Reserved
  ISRline NonHandledINTCException          ;Vec 257, Reserved                                           
  ISRline NonHandledINTCException          ;Vec 258, Reserved  
  
                                           ;*** Source of interrupt: DSPI0 ***
  ISRline NonHandledINTCException          ;Vec 259, DSPI_SR[TFUF] | DSPI_SR[RFOF]                               
  ISRline NonHandledINTCException          ;Vec 260, DSPI_SR[EOQF]
  ISRline NonHandledINTCException          ;Vec 261, DSPI_SR[TFFF]
  ISRline NonHandledINTCException          ;Vec 262, DSPI_SR[TCF]
  ISRline NonHandledINTCException          ;Vec 263, DSPI_SR[RFDF]
                                           ;*** Source of interrupt: DSPI0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 264, Reserved for DSPI0_5                               
  ISRline NonHandledINTCException          ;Vec 265, Reserved for DSPI0_6
  ISRline NonHandledINTCException          ;Vec 266, Reserved for DSPI0_7
  ISRline NonHandledINTCException          ;Vec 267, Reserved for DSPI0_8
  
                                           ;*** Source of interrupt: DSPI1 ***
  ISRline NonHandledINTCException          ;Vec 268, DSPI_SR[TFUF] | DSPI_SR[RFOF]                               
  ISRline NonHandledINTCException          ;Vec 269, DSPI_SR[EOQF]
  ISRline NonHandledINTCException          ;Vec 270, DSPI_SR[TFFF]
  ISRline NonHandledINTCException          ;Vec 271, DSPI_SR[TCF]
  ISRline NonHandledINTCException          ;Vec 272, DSPI_SR[RFDF]
                                           ;*** Source of interrupt: DSPI1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 273, Reserved for DSPI1_5                               
  ISRline NonHandledINTCException          ;Vec 274, Reserved for DSPI1_6
  ISRline NonHandledINTCException          ;Vec 275, Reserved for DSPI1_7
  ISRline NonHandledINTCException          ;Vec 276, Reserved for DSPI1_8
  
                                           ;*** Source of interrupt: DSPI2 ***
  ISRline NonHandledINTCException          ;Vec 277, DSPI_SR[TFUF] | DSPI_SR[RFOF]                               
  ISRline NonHandledINTCException          ;Vec 278, DSPI_SR[EOQF]
  ISRline NonHandledINTCException          ;Vec 279, DSPI_SR[TFFF]
  ISRline NonHandledINTCException          ;Vec 280, DSPI_SR[TCF]
  ISRline NonHandledINTCException          ;Vec 281, DSPI_SR[RFDF]
                                           ;*** Source of interrupt: DSPI2 Reserved ***
  ISRline NonHandledINTCException          ;Vec 282, Reserved for DSPI2_5                               
  ISRline NonHandledINTCException          ;Vec 283, Reserved for DSPI2_6
  ISRline NonHandledINTCException          ;Vec 284, Reserved for DSPI2_7
  ISRline NonHandledINTCException          ;Vec 285, Reserved for DSPI2_8
  
                                           ;*** Source of interrupt: DSPI3 ***
  ISRline NonHandledINTCException          ;Vec 286, DSPI_SR[TFUF] | DSPI_SR[RFOF]                               
  ISRline NonHandledINTCException          ;Vec 287, DSPI_SR[EOQF]
  ISRline NonHandledINTCException          ;Vec 288, DSPI_SR[TFFF]
  ISRline NonHandledINTCException          ;Vec 289, DSPI_SR[TCF]
  ISRline NonHandledINTCException          ;Vec 290, DSPI_SR[RFDF]
                                           ;*** Source of interrupt: DSPI3 Reserved ***
  ISRline NonHandledINTCException          ;Vec 291, Reserved for DSPI3_5                               
  ISRline NonHandledINTCException          ;Vec 292, Reserved for DSPI3_6
  ISRline NonHandledINTCException          ;Vec 293, Reserved for DSPI3_7
  ISRline NonHandledINTCException          ;Vec 294, Reserved for DSPI3_8  
  
                                           ;*** Source of interrupt: DSPI4 Reserved ***
  ISRline NonHandledINTCException          ;Vec 295, Reserved for DSPI4_0                               
  ISRline NonHandledINTCException          ;Vec 296, Reserved for DSPI4_1
  ISRline NonHandledINTCException          ;Vec 297, Reserved for DSPI4_2
  ISRline NonHandledINTCException          ;Vec 298, Reserved for DSPI4_3   
  ISRline NonHandledINTCException          ;Vec 299, Reserved for DSPI4_4                               
  ISRline NonHandledINTCException          ;Vec 300, Reserved for DSPI4_5
  ISRline NonHandledINTCException          ;Vec 301, Reserved for DSPI4_6
  ISRline NonHandledINTCException          ;Vec 302, Reserved for DSPI4_7
  ISRline NonHandledINTCException          ;Vec 303, Reserved for DSPI4_8   
  
                                           ;*** Source of interrupt: DSPI5 Reserved ***
  ISRline NonHandledINTCException          ;Vec 304, Reserved for DSPI5_0                               
  ISRline NonHandledINTCException          ;Vec 305, Reserved for DSPI5_1
  ISRline NonHandledINTCException          ;Vec 306, Reserved for DSPI5_2
  ISRline NonHandledINTCException          ;Vec 307, Reserved for DSPI5_3   
  ISRline NonHandledINTCException          ;Vec 308, Reserved for DSPI5_4                               
  ISRline NonHandledINTCException          ;Vec 309, Reserved for DSPI5_5
  ISRline NonHandledINTCException          ;Vec 310, Reserved for DSPI5_6
  ISRline NonHandledINTCException          ;Vec 311, Reserved for DSPI5_7
  ISRline NonHandledINTCException          ;Vec 312, Reserved for DSPI4_8 
  
                                           ;*** Source of interrupt: DSPI6 Reserved ***
  ISRline NonHandledINTCException          ;Vec 313, Reserved for DSPI6_0                               
  ISRline NonHandledINTCException          ;Vec 314, Reserved for DSPI6_1
  ISRline NonHandledINTCException          ;Vec 315, Reserved for DSPI6_2
  ISRline NonHandledINTCException          ;Vec 316, Reserved for DSPI6_3   
  ISRline NonHandledINTCException          ;Vec 317, Reserved for DSPI6_4                               
  ISRline NonHandledINTCException          ;Vec 318, Reserved for DSPI6_5
  ISRline NonHandledINTCException          ;Vec 319, Reserved for DSPI6_6
  ISRline NonHandledINTCException          ;Vec 320, Reserved for DSPI6_7
  ISRline NonHandledINTCException          ;Vec 321, Reserved for DSPI6_8   
  
                                           ;*** Source of interrupt: DSPI7 Reserved ***
  ISRline NonHandledINTCException          ;Vec 322, Reserved for DSPI7_0                               
  ISRline NonHandledINTCException          ;Vec 323, Reserved for DSPI7_1
  ISRline NonHandledINTCException          ;Vec 324, Reserved for DSPI7_2
  ISRline NonHandledINTCException          ;Vec 325, Reserved for DSPI7_3   
  ISRline NonHandledINTCException          ;Vec 326, Reserved for DSPI7_4                               
  ISRline NonHandledINTCException          ;Vec 327, Reserved for DSPI7_5
  ISRline NonHandledINTCException          ;Vec 328, Reserved for DSPI7_6
  ISRline NonHandledINTCException          ;Vec 329, Reserved for DSPI7_7
  ISRline NonHandledINTCException          ;Vec 330, Reserved for DSPI7_8   

                                           ;*** Source of interrupt: DSPI8 Reserved ***
  ISRline NonHandledINTCException          ;Vec 331, Reserved for DSPI8_0                               
  ISRline NonHandledINTCException          ;Vec 332, Reserved for DSPI8_1
  ISRline NonHandledINTCException          ;Vec 333, Reserved for DSPI8_2
  ISRline NonHandledINTCException          ;Vec 334, Reserved for DSPI8_3   
  ISRline NonHandledINTCException          ;Vec 335, Reserved for DSPI8_4                               
  ISRline NonHandledINTCException          ;Vec 336, Reserved for DSPI8_5
  ISRline NonHandledINTCException          ;Vec 337, Reserved for DSPI8_6
  ISRline NonHandledINTCException          ;Vec 338, Reserved for DSPI8_7
  ISRline NonHandledINTCException          ;Vec 339, Reserved for DSPI8_8      
  
                                           ;*** Source of interrupt: DSPI9 Reserved ***
  ISRline NonHandledINTCException          ;Vec 340, Reserved for DSPI9_0                               
  ISRline NonHandledINTCException          ;Vec 341, Reserved for DSPI9_1
  ISRline NonHandledINTCException          ;Vec 342, Reserved for DSPI9_2
  ISRline NonHandledINTCException          ;Vec 343, Reserved for DSPI9_3   
  ISRline NonHandledINTCException          ;Vec 344, Reserved for DSPI9_4                               
  ISRline NonHandledINTCException          ;Vec 345, Reserved for DSPI9_5
  ISRline NonHandledINTCException          ;Vec 346, Reserved for DSPI9_6
  ISRline NonHandledINTCException          ;Vec 347, Reserved for DSPI9_7
  ISRline NonHandledINTCException          ;Vec 348, Reserved for DSPI9_8  
  
                                           ;*** Source of interrupt: DSPI10 Reserved ***
  ISRline NonHandledINTCException          ;Vec 349, Reserved for DSPI10_0                               
  ISRline NonHandledINTCException          ;Vec 350, Reserved for DSPI10_1
  ISRline NonHandledINTCException          ;Vec 351, Reserved for DSPI10_2
  ISRline NonHandledINTCException          ;Vec 352, Reserved for DSPI10_3   
  ISRline NonHandledINTCException          ;Vec 353, Reserved for DSPI10_4                               
  ISRline NonHandledINTCException          ;Vec 354, Reserved for DSPI10_5
  ISRline NonHandledINTCException          ;Vec 355, Reserved for DSPI10_6
  ISRline NonHandledINTCException          ;Vec 356, Reserved for DSPI10_7
  ISRline NonHandledINTCException          ;Vec 357, Reserved for DSPI10_8
  
                                           ;*** Source of interrupt: DSPI11 Reserved ***
  ISRline NonHandledINTCException          ;Vec 358, Reserved for DSPI11_0                               
  ISRline NonHandledINTCException          ;Vec 359, Reserved for DSPI11_1
  ISRline NonHandledINTCException          ;Vec 360, Reserved for DSPI11_2
  ISRline NonHandledINTCException          ;Vec 361, Reserved for DSPI11_3   
  ISRline NonHandledINTCException          ;Vec 362, Reserved for DSPI11_4                               
  ISRline NonHandledINTCException          ;Vec 363, Reserved for DSPI11_5
  ISRline NonHandledINTCException          ;Vec 364, Reserved for DSPI11_6
  ISRline NonHandledINTCException          ;Vec 365, Reserved for DSPI11_7
  ISRline NonHandledINTCException          ;Vec 366, Reserved for DSPI11_8 
  
                                           ;*** Source of interrupt: DSPI12 Reserved ***
  ISRline NonHandledINTCException          ;Vec 367, Reserved for DSPI12_0                               
  ISRline NonHandledINTCException          ;Vec 368, Reserved for DSPI12_1
  ISRline NonHandledINTCException          ;Vec 369, Reserved for DSPI12_2
  ISRline NonHandledINTCException          ;Vec 370, Reserved for DSPI12_3   
  ISRline NonHandledINTCException          ;Vec 371, Reserved for DSPI12_4                               
  ISRline NonHandledINTCException          ;Vec 372, Reserved for DSPI12_5
  ISRline NonHandledINTCException          ;Vec 373, Reserved for DSPI12_6
  ISRline NonHandledINTCException          ;Vec 374, Reserved for DSPI12_7
  ISRline NonHandledINTCException          ;Vec 375, Reserved for DSPI12_8
    
                                           ;*** Source of interrupt: LINFlex_0 ***
  ISRline NonHandledINTCException          ;Vec 376, LINFlex_RXI                               
  ISRline NonHandledINTCException          ;Vec 377, LINFlex_TXI
  ISRline NonHandledINTCException          ;Vec 378, LINFlex_ERR
                                           ;*** Source of interrupt: LINFlex_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 379, Reserved for LINFlex/eSCI0_3
  
                                           ;*** Source of interrupt: LINFlex_1 ***
  ISRline NonHandledINTCException          ;Vec 380, LINFlex_RXI                               
  ISRline NonHandledINTCException          ;Vec 381, LINFlex_TXI
  ISRline NonHandledINTCException          ;Vec 382, LINFlex_ERR
                                           ;*** Source of interrupt: LINFlex_1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 383, Reserved for LINFlex/eSCI0_3  
  
                                           ;*** Source of interrupt: LINFlex_2 Reserved ***
  ISRline NonHandledINTCException          ;Vec 384, Reserved for LINFlex/eSCI2_0
  ISRline NonHandledINTCException          ;Vec 385, Reserved for LINFlex/eSCI2_1
  ISRline NonHandledINTCException          ;Vec 386, Reserved for LINFlex/eSCI2_2
  ISRline NonHandledINTCException          ;Vec 387, Reserved for LINFlex/eSCI2_3
  
                                           ;*** Source of interrupt: LINFlex_3 Reserved ***
  ISRline NonHandledINTCException          ;Vec 388, Reserved for LINFlex/eSCI3_0
  ISRline NonHandledINTCException          ;Vec 389, Reserved for LINFlex/eSCI3_1
  ISRline NonHandledINTCException          ;Vec 390, Reserved for LINFlex/eSCI3_2
  ISRline NonHandledINTCException          ;Vec 391, Reserved for LINFlex/eSCI3_3  

                                           ;*** Source of interrupt: LINFlex_4 Reserved ***
  ISRline NonHandledINTCException          ;Vec 392, Reserved for LINFlex/eSCI4_0
  ISRline NonHandledINTCException          ;Vec 393, Reserved for LINFlex/eSCI4_1
  ISRline NonHandledINTCException          ;Vec 394, Reserved for LINFlex/eSCI4_2
  ISRline NonHandledINTCException          ;Vec 395, Reserved for LINFlex/eSCI4_3    
  
                                           ;*** Source of interrupt: LINFlex_5 Reserved ***
  ISRline NonHandledINTCException          ;Vec 396, Reserved for LINFlex/eSCI5_0
  ISRline NonHandledINTCException          ;Vec 397, Reserved for LINFlex/eSCI5_1
  ISRline NonHandledINTCException          ;Vec 398, Reserved for LINFlex/eSCI5_2
  ISRline NonHandledINTCException          ;Vec 399, Reserved for LINFlex/eSCI5_3  
  
                                           ;*** Source of interrupt: LINFlex_6 Reserved ***
  ISRline NonHandledINTCException          ;Vec 400, Reserved for LINFlex/eSCI6_0
  ISRline NonHandledINTCException          ;Vec 401, Reserved for LINFlex/eSCI6_1
  ISRline NonHandledINTCException          ;Vec 402, Reserved for LINFlex/eSCI6_2
  ISRline NonHandledINTCException          ;Vec 403, Reserved for LINFlex/eSCI6_3    
  
                                           ;*** Source of interrupt: LINFlex_7 Reserved ***
  ISRline NonHandledINTCException          ;Vec 404, Reserved for LINFlex/eSCI7_0
  ISRline NonHandledINTCException          ;Vec 405, Reserved for LINFlex/eSCI7_1
  ISRline NonHandledINTCException          ;Vec 406, Reserved for LINFlex/eSCI7_2
  ISRline NonHandledINTCException          ;Vec 407, Reserved for LINFlex/eSCI7_3   
  
                                           ;*** Source of interrupt: LINFlex_8 Reserved ***
  ISRline NonHandledINTCException          ;Vec 408, Reserved for LINFlex/eSCI8_0
  ISRline NonHandledINTCException          ;Vec 409, Reserved for LINFlex/eSCI8_1
  ISRline NonHandledINTCException          ;Vec 410, Reserved for LINFlex/eSCI8_2
  ISRline NonHandledINTCException          ;Vec 411, Reserved for LINFlex/eSCI8_3    
  
                                           ;*** Source of interrupt: LINFlex_9 Reserved ***
  ISRline NonHandledINTCException          ;Vec 412, Reserved for LINFlex/eSCI9_0
  ISRline NonHandledINTCException          ;Vec 413, Reserved for LINFlex/eSCI9_1
  ISRline NonHandledINTCException          ;Vec 414, Reserved for LINFlex/eSCI9_2
  ISRline NonHandledINTCException          ;Vec 415, Reserved for LINFlex/eSCI9_3  
  
                                           ;*** Source of interrupt: LINFlex_10 Reserved ***
  ISRline NonHandledINTCException          ;Vec 416, Reserved for LINFlex/eSCI10_0
  ISRline NonHandledINTCException          ;Vec 417, Reserved for LINFlex/eSCI10_1
  ISRline NonHandledINTCException          ;Vec 418, Reserved for LINFlex/eSCI10_2
  ISRline NonHandledINTCException          ;Vec 419, Reserved for LINFlex/eSCI10_3   
  
                                           ;*** Source of interrupt: LINFlex_11 Reserved ***
  ISRline NonHandledINTCException          ;Vec 420, Reserved for LINFlex/eSCI11_0
  ISRline NonHandledINTCException          ;Vec 421, Reserved for LINFlex/eSCI11_1
  ISRline NonHandledINTCException          ;Vec 422, Reserved for LINFlex/eSCI11_2
  ISRline NonHandledINTCException          ;Vec 423, Reserved for LINFlex/eSCI11_3    
  
                                           ;*** Source of interrupt: LINFlex_12 Reserved ***
  ISRline NonHandledINTCException          ;Vec 424, Reserved for LINFlex/eSCI12_0
  ISRline NonHandledINTCException          ;Vec 425, Reserved for LINFlex/eSCI12_1
  ISRline NonHandledINTCException          ;Vec 426, Reserved for LINFlex/eSCI12_2
  ISRline NonHandledINTCException          ;Vec 427, Reserved for LINFlex/eSCI12_3  
  
                                           ;*** Source of interrupt: LINFlex_13 Reserved ***
  ISRline NonHandledINTCException          ;Vec 428, Reserved for LINFlex/eSCI13_0
  ISRline NonHandledINTCException          ;Vec 429, Reserved for LINFlex/eSCI13_1
  ISRline NonHandledINTCException          ;Vec 430, Reserved for LINFlex/eSCI13_2
  ISRline NonHandledINTCException          ;Vec 431, Reserved for LINFlex/eSCI13_3   
  
                                           ;*** Source of interrupt: LINFlex_14 Reserved ***
  ISRline NonHandledINTCException          ;Vec 432, Reserved for LINFlex/eSCI14_0
  ISRline NonHandledINTCException          ;Vec 433, Reserved for LINFlex/eSCI14_1
  ISRline NonHandledINTCException          ;Vec 434, Reserved for LINFlex/eSCI14_2
  ISRline NonHandledINTCException          ;Vec 435, Reserved for LINFlex/eSCI14_3    
  
                                           ;*** Source of interrupt: LINFlex_15 Reserved ***
  ISRline NonHandledINTCException          ;Vec 436, Reserved for LINFlex/eSCI15_0
  ISRline NonHandledINTCException          ;Vec 437, Reserved for LINFlex/eSCI15_1
  ISRline NonHandledINTCException          ;Vec 438, Reserved for LINFlex/eSCI15_2
  ISRline NonHandledINTCException          ;Vec 439, Reserved for LINFlex/eSCI15_3
  
                                           ;*** Source of interrupt: IIC_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 440, Reserved for IIC_0_0
  ISRline NonHandledINTCException          ;Vec 441, Reserved for IIC_0_1
  
                                           ;*** Source of interrupt: IIC_1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 442, Reserved for IIC_1_0
  ISRline NonHandledINTCException          ;Vec 443, Reserved for IIC_1_1
  
                                           ;*** Source of interrupt: IIC_2 Reserved ***
  ISRline NonHandledINTCException          ;Vec 444, Reserved for IIC_2_0
  ISRline NonHandledINTCException          ;Vec 445, Reserved for IIC_2_1
 
                                           ;*** Source of interrupt: IIC_3 Reserved ***
  ISRline NonHandledINTCException          ;Vec 446, Reserved for IIC_3_0
  ISRline NonHandledINTCException          ;Vec 447, Reserved for IIC_3_1
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 448, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 449, Reserved for future use                                           
  ISRline NonHandledINTCException          ;Vec 450, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 451, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 452, Reserved for future use    
    
                                           ;*** Source of interrupt: FlexRay_0 ***
  ISRline NonHandledINTCException          ;Vec 453, LRNEIF | DRNEIF
  ISRline NonHandledINTCException          ;Vec 454, LRCEIF | DRCEIF
  ISRline NonHandledINTCException          ;Vec 455, FNEAIF
  ISRline NonHandledINTCException          ;Vec 456, FNEBIF
  ISRline NonHandledINTCException          ;Vec 457, WUPIF
  ISRline NonHandledINTCException          ;Vec 458, PRIF
  ISRline NonHandledINTCException          ;Vec 459, CHIF
  ISRline NonHandledINTCException          ;Vec 460, TBIF
  ISRline NonHandledINTCException          ;Vec 461, RBIF
  ISRline NonHandledINTCException          ;Vec 462, MIF
                                           ;*** Source of interrupt: FlexRay_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 463, Reserved for FlexRay_0_10
  ISRline NonHandledINTCException          ;Vec 464, Reserved for FlexRay_0_11
  
                                           ;*** Source of interrupt: FlexRay_1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 465, Reserved for FlexRay_1_0
  ISRline NonHandledINTCException          ;Vec 466, Reserved for FlexRay_1_1
  ISRline NonHandledINTCException          ;Vec 467, Reserved for FlexRay_1_2
  ISRline NonHandledINTCException          ;Vec 468, Reserved for FlexRay_1_3
  ISRline NonHandledINTCException          ;Vec 469, Reserved for FlexRay_1_4
  ISRline NonHandledINTCException          ;Vec 470, Reserved for FlexRay_1_5
  ISRline NonHandledINTCException          ;Vec 471, Reserved for FlexRay_1_6
  ISRline NonHandledINTCException          ;Vec 472, Reserved for FlexRay_1_7
  ISRline NonHandledINTCException          ;Vec 473, Reserved for FlexRay_1_8
  ISRline NonHandledINTCException          ;Vec 474, Reserved for FlexRay_1_9        
  ISRline NonHandledINTCException          ;Vec 475, Reserved for FlexRay_1_10
  ISRline NonHandledINTCException          ;Vec 476, Reserved for FlexRay_1_11
  
                                           ;*** Source of interrupt: PMU ***
  ISRline NonHandledINTCException          ;Vec 477, Power Monitor Unit
  ISRline NonHandledINTCException          ;Vec 478, Power management Unit (temp sensor)
  
                                           ;*** Source of interrupt: CMU Reserved ***
  ISRline NonHandledINTCException          ;Vec 479, Reserved for Clock Monitor Unit    
  
                                           ;*** Source of interrupt: PLL_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 480, Reserved for PLL_0
  ISRline NonHandledINTCException          ;Vec 481, Reserved for PLL_0
  
                                           ;*** Source of interrupt: PLL_1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 482, Reserved for PLL_1
  ISRline NonHandledINTCException          ;Vec 483, Reserved for PLL_1
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 484, Reserved for ipi_int_ext_pd1_done
  ISRline NonHandledINTCException          ;Vec 485, Reserved for ipi_int_ext_pd2_done                                           
  ISRline NonHandledINTCException          ;Vec 486, Reserved for ipi_int_pll1_clk_sw
  ISRline NonHandledINTCException          ;Vec 487, Reserved for ipi_int_pll2_clk_sw
      
                                           ;*** Source of interrupt: FCCU ***
  ISRline FCCU_Alarm_Interrupt             ;Vec 488, Alarm Interrupt (ALRM)
  ISRline NonHandledINTCException          ;Vec 489, Configuration Time-out (CFG_TO)
                                           ;*** Source of interrupt: FCCU Reserved ***
  ISRline NonHandledINTCException          ;Vec 490, Reserved for FCCU
  ISRline NonHandledINTCException          ;Vec 491, Reserved for FCCU
  ISRline NonHandledINTCException          ;Vec 492, Reserved for FCCU_4
  ISRline NonHandledINTCException          ;Vec 493, Reserved for FCCU_5
  ISRline NonHandledINTCException          ;Vec 494, Reserved for FCCU_6
  ISRline NonHandledINTCException          ;Vec 495, Reserved for FCCU_7  
    
                                           ;*** Source of interrupt: ADC_0 ***
  ISRline NonHandledINTCException          ;Vec 496, ADC_EOC
  ISRline NonHandledINTCException          ;Vec 497, ADC_ER 
  ISRline NonHandledINTCException          ;Vec 498, ADC_WD
                                           ;*** Source of interrupt: ADC_0 Reserved ***                                          
  ISRline NonHandledINTCException          ;Vec 499, Reserved for ADC
  
                                           ;*** Source of interrupt: ADC_1 ***
  ISRline NonHandledINTCException          ;Vec 500, ADC_EOC
  ISRline NonHandledINTCException          ;Vec 501, ADC_ER 
  ISRline NonHandledINTCException          ;Vec 502, ADC_WD
                                           ;*** Source of interrupt: ADC_1 Reserved ***                                          
  ISRline NonHandledINTCException          ;Vec 503, Reserved for ADC  

                                           ;*** Source of interrupt: ADC_2 ***
  ISRline NonHandledINTCException          ;Vec 504, ADC_EOC
  ISRline NonHandledINTCException          ;Vec 505, ADC_ER 
  ISRline NonHandledINTCException          ;Vec 506, ADC_WD
                                           ;*** Source of interrupt: ADC_2 Reserved ***                                          
  ISRline NonHandledINTCException          ;Vec 507, Reserved for ADC
  
                                           ;*** Source of interrupt: ADC_3 ***
  ISRline NonHandledINTCException          ;Vec 508, ADC_EOC
  ISRline NonHandledINTCException          ;Vec 509, ADC_ER 
  ISRline NonHandledINTCException          ;Vec 510, ADC_WD
                                           ;*** Source of interrupt: ADC_3 Reserved ***                                          
  ISRline NonHandledINTCException          ;Vec 511, Reserved for ADC
  
                                           ;*** Source of interrupt: ADC_4 Reserved ***                                          
  ISRline NonHandledINTCException          ;Vec 512, Reserved for ADC
  ISRline NonHandledINTCException          ;Vec 513, Reserved for ADC
  ISRline NonHandledINTCException          ;Vec 514, Reserved for ADC
  ISRline NonHandledINTCException          ;Vec 515, Reserved for ADC        

                                           ;*** Source of interrupt: ADC_5 Reserved ***                                          
  ISRline NonHandledINTCException          ;Vec 516, Reserved for ADC
  ISRline NonHandledINTCException          ;Vec 517, Reserved for ADC
  ISRline NonHandledINTCException          ;Vec 518, Reserved for ADC
  ISRline NonHandledINTCException          ;Vec 519, Reserved for ADC   
  
                                           ;*** Source of interrupt: FlexCAN_0 ***                                          
  ISRline NonHandledINTCException          ;Vec 520, FLEXCAN_ESR[ERR_INT]
  ISRline NonHandledINTCException          ;Vec 521, FLEXCAN_ESR_BOFF | FLEXCAN_Transmit_Warning |FLEXCAN_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 522, FLEXCAN_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 523, FLEXCAN_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 524, FLEXCAN_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 525, FLEXCAN_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 526, FLEXCAN_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 527, FLEXCAN_BUF_32_39
  ISRline NonHandledINTCException          ;Vec 528, FLEXCAN_BUF_40_47
  ISRline NonHandledINTCException          ;Vec 529, FLEXCAN_BUF_48_55
  ISRline NonHandledINTCException          ;Vec 530, FLEXCAN_BUF_56_63
                                           ;*** Source of interrupt: FlexCAN_0 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 531, Reserved
  ISRline NonHandledINTCException          ;Vec 532, Reserved
  
                                           ;*** Source of interrupt: FlexCAN_1 ***                                          
  ISRline NonHandledINTCException          ;Vec 533, FLEXCAN_ESR[ERR_INT]
  ISRline NonHandledINTCException          ;Vec 534, FLEXCAN_ESR_BOFF | FLEXCAN_Transmit_Warning |FLEXCAN_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 535, FLEXCAN_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 536, FLEXCAN_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 537, FLEXCAN_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 538, FLEXCAN_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 539, FLEXCAN_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 540, FLEXCAN_BUF_32_39
  ISRline NonHandledINTCException          ;Vec 541, FLEXCAN_BUF_40_47
  ISRline NonHandledINTCException          ;Vec 542, FLEXCAN_BUF_48_55
  ISRline NonHandledINTCException          ;Vec 543, FLEXCAN_BUF_56_63
                                           ;*** Source of interrupt: FlexCAN_1 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 544, Reserved
  ISRline NonHandledINTCException          ;Vec 545, Reserved    
  
                                           ;*** Source of interrupt: FlexCAN_2 ***                                          
  ISRline NonHandledINTCException          ;Vec 546, FLEXCAN_ESR[ERR_INT]
  ISRline NonHandledINTCException          ;Vec 547, FLEXCAN_ESR_BOFF | FLEXCAN_Transmit_Warning |FLEXCAN_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 548, FLEXCAN_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 549, FLEXCAN_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 550, FLEXCAN_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 551, FLEXCAN_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 552, FLEXCAN_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 553, FLEXCAN_BUF_32_39
  ISRline NonHandledINTCException          ;Vec 554, FLEXCAN_BUF_40_47
  ISRline NonHandledINTCException          ;Vec 555, FLEXCAN_BUF_48_55
  ISRline NonHandledINTCException          ;Vec 556, FLEXCAN_BUF_56_63
                                           ;*** Source of interrupt: FlexCAN_2 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 557, Reserved
  ISRline NonHandledINTCException          ;Vec 558, Reserved  
  
                                           ;*** Source of interrupt: FlexCAN_3 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 559, Reserved
  ISRline NonHandledINTCException          ;Vec 560, Reserved  
  ISRline NonHandledINTCException          ;Vec 561, Reserved
  ISRline NonHandledINTCException          ;Vec 562, Reserved  
  ISRline NonHandledINTCException          ;Vec 563, Reserved
  ISRline NonHandledINTCException          ;Vec 564, Reserved
  ISRline NonHandledINTCException          ;Vec 565, Reserved
  ISRline NonHandledINTCException          ;Vec 566, Reserved
  ISRline NonHandledINTCException          ;Vec 567, Reserved
  ISRline NonHandledINTCException          ;Vec 568, Reserved  
  ISRline NonHandledINTCException          ;Vec 569, Reserved

                                           ;*** Source of interrupt: SENT_0 ***                 
  ISRline NonHandledINTCException          ;Vec 570, Valid Fast Message Received on Channel 0
  ISRline NonHandledINTCException          ;Vec 571, Valid Slow Message Received on Channel 0
  ISRline NonHandledINTCException          ;Vec 572, Receive Error Interrupt Channel 0
  ISRline NonHandledINTCException          ;Vec 573, Valid Fast Message Received on Channel 1
  ISRline NonHandledINTCException          ;Vec 574, Valid Slow Message Received on Channel 1
  ISRline NonHandledINTCException          ;Vec 575, Receive Error Interrupt Channel 1        
                                           ;*** Source of interrupt: SENT_0 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 576, Reserved
  ISRline NonHandledINTCException          ;Vec 577, Reserved
  ISRline NonHandledINTCException          ;Vec 578, Reserved
  ISRline NonHandledINTCException          ;Vec 579, Reserved
  ISRline NonHandledINTCException          ;Vec 580, Reserved
  ISRline NonHandledINTCException          ;Vec 581, Reserved
    
                                           ;*** Source of interrupt: SENT_1 ***                 
  ISRline NonHandledINTCException          ;Vec 582, Valid Fast Message Received on Channel 0
  ISRline NonHandledINTCException          ;Vec 583, Valid Slow Message Received on Channel 0
  ISRline NonHandledINTCException          ;Vec 584, Receive Error Interrupt Channel 0
  ISRline NonHandledINTCException          ;Vec 585, Valid Fast Message Received on Channel 1
  ISRline NonHandledINTCException          ;Vec 586, Valid Slow Message Received on Channel 1
  ISRline NonHandledINTCException          ;Vec 587, Receive Error Interrupt Channel 1 
                                           ;*** Source of interrupt: SENT_1 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 588, Reserved
  ISRline NonHandledINTCException          ;Vec 589, Reserved
  ISRline NonHandledINTCException          ;Vec 590, Reserved
  ISRline NonHandledINTCException          ;Vec 591, Reserved
  ISRline NonHandledINTCException          ;Vec 592, Reserved
  ISRline NonHandledINTCException          ;Vec 593, Reserved
  
                                           ;*** Source of interrupt: SIPI ***                 
  ISRline NonHandledINTCException          ;Vec 594, Read interrupt channel 1
  ISRline NonHandledINTCException          ;Vec 595, Read interrupt channel 2
  ISRline NonHandledINTCException          ;Vec 596, Read interrupt channel 3
  ISRline NonHandledINTCException          ;Vec 597, Read interrupt channel 4    
                                           ;*** Source of interrupt: SIPI Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 598, Reserved
  ISRline NonHandledINTCException          ;Vec 599, Reserved
  ISRline NonHandledINTCException          ;Vec 600, Reserved
  ISRline NonHandledINTCException          ;Vec 601, Reserved
                                           ;*** Source of interrupt: SIPI ***                 
  ISRline NonHandledINTCException          ;Vec 602, Error 1
  ISRline NonHandledINTCException          ;Vec 603, Error 2
  ISRline NonHandledINTCException          ;Vec 604, Trigger command
  
                                           ;*** Source of interrupt: LFAST0 ***                 
  ISRline NonHandledINTCException          ;Vec 605, Tx interrupt
  ISRline NonHandledINTCException          ;Vec 606, Tx exception
  ISRline NonHandledINTCException          ;Vec 607, Rx interrupt
  ISRline NonHandledINTCException          ;Vec 608, Rx exception
  ISRline NonHandledINTCException          ;Vec 609, Rx ICLC
                                           ;*** Source of interrupt: LFAST0 Reserved ***  
  ISRline NonHandledINTCException          ;Vec 610, Reserved
  
                                           ;*** Source of interrupt: eTimer_0 ***                 
  ISRline NonHandledINTCException          ;Vec 611, TC0IR
  ISRline NonHandledINTCException          ;Vec 612, TC1IR
  ISRline NonHandledINTCException          ;Vec 613, TC2IR
  ISRline NonHandledINTCException          ;Vec 614, TC3IR
  ISRline NonHandledINTCException          ;Vec 615, TC4IR
  ISRline NonHandledINTCException          ;Vec 616, TC5IR
                                           ;*** Source of interrupt: eTimer_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 617, Not used
  ISRline NonHandledINTCException          ;Vec 618, Not used                                                                                            
                                           ;*** Source of interrupt: eTimer_0 ***
  ISRline NonHandledINTCException          ;Vec 619, WTIF
                                           ;*** Source of interrupt: eTimer_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 620, Not used
                                           ;*** Source of interrupt: eTimer_0 ***
  ISRline NonHandledINTCException          ;Vec 621, RCF
  
                                           ;*** Source of interrupt: eTimer_1 ***                 
  ISRline NonHandledINTCException          ;Vec 622, TC0IR
  ISRline NonHandledINTCException          ;Vec 623, TC1IR
  ISRline NonHandledINTCException          ;Vec 624, TC2IR
  ISRline NonHandledINTCException          ;Vec 625, TC3IR
  ISRline NonHandledINTCException          ;Vec 626, TC4IR
  ISRline NonHandledINTCException          ;Vec 627, TC5IR
                                           ;*** Source of interrupt: eTimer_1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 628, Not used
  ISRline NonHandledINTCException          ;Vec 629, Not used
  ISRline NonHandledINTCException          ;Vec 630, Not used
  ISRline NonHandledINTCException          ;Vec 631, Not used                                                                                            
                                           ;*** Source of interrupt: eTimer_1 ***
  ISRline NonHandledINTCException          ;Vec 632, RCF
  
                                           ;*** Source of interrupt: eTimer_2 ***                 
  ISRline NonHandledINTCException          ;Vec 633, TC0IR
  ISRline NonHandledINTCException          ;Vec 634, TC1IR
  ISRline NonHandledINTCException          ;Vec 635, TC2IR
  ISRline NonHandledINTCException          ;Vec 636, TC3IR
  ISRline NonHandledINTCException          ;Vec 637, TC4IR
  ISRline NonHandledINTCException          ;Vec 638, TC5IR
                                           ;*** Source of interrupt: eTimer_2 Reserved ***
  ISRline NonHandledINTCException          ;Vec 639, Not used
  ISRline NonHandledINTCException          ;Vec 640, Not used
  ISRline NonHandledINTCException          ;Vec 641, Not used
  ISRline NonHandledINTCException          ;Vec 642, Not used                                                                                            
                                           ;*** Source of interrupt: eTimer_2 ***
  ISRline NonHandledINTCException          ;Vec 643, RCF
  
                                           ;*** Source of interrupt: eTimer_3 Reserved ***
  ISRline NonHandledINTCException          ;Vec 644, Not used
  ISRline NonHandledINTCException          ;Vec 645, Not used
  ISRline NonHandledINTCException          ;Vec 646, Not used
  ISRline NonHandledINTCException          ;Vec 647, Not used
  ISRline NonHandledINTCException          ;Vec 648, Not used
  ISRline NonHandledINTCException          ;Vec 649, Not used
  ISRline NonHandledINTCException          ;Vec 650, Not used
  ISRline NonHandledINTCException          ;Vec 651, Not used
  ISRline NonHandledINTCException          ;Vec 652, Not used
  ISRline NonHandledINTCException          ;Vec 653, Not used
  ISRline NonHandledINTCException          ;Vec 654, Not used
    
                                           ;*** Source of interrupt: FlexPWM_0 ***
  ISRline NonHandledINTCException          ;Vec 655, RF0
  ISRline NonHandledINTCException          ;Vec 656, COF0
  ISRline NonHandledINTCException          ;Vec 657, CAF0
  ISRline NonHandledINTCException          ;Vec 658, RF1
  ISRline NonHandledINTCException          ;Vec 659, COF1
  ISRline NonHandledINTCException          ;Vec 660, CAF1
  ISRline NonHandledINTCException          ;Vec 661, RF2
  ISRline NonHandledINTCException          ;Vec 662, COF2  
  ISRline NonHandledINTCException          ;Vec 663, CAF2
  ISRline NonHandledINTCException          ;Vec 664, RF3
  ISRline NonHandledINTCException          ;Vec 665, COF3
  ISRline NonHandledINTCException          ;Vec 666, CAF3
  ISRline NonHandledINTCException          ;Vec 667, FFLAG
  ISRline NonHandledINTCException          ;Vec 668, REF
                                           ;*** Source of interrupt: FlexPWM_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 669, Reserved
  
                                           ;*** Source of interrupt: FlexPWM_1 ***
  ISRline NonHandledINTCException          ;Vec 670, RF0
  ISRline NonHandledINTCException          ;Vec 671, COF0
  ISRline NonHandledINTCException          ;Vec 672, CAF0
  ISRline NonHandledINTCException          ;Vec 673, RF1
  ISRline NonHandledINTCException          ;Vec 674, COF1
  ISRline NonHandledINTCException          ;Vec 675, CAF1
  ISRline NonHandledINTCException          ;Vec 676, RF2
  ISRline NonHandledINTCException          ;Vec 677, COF2  
  ISRline NonHandledINTCException          ;Vec 678, CAF2
  ISRline NonHandledINTCException          ;Vec 679, RF3
  ISRline NonHandledINTCException          ;Vec 680, COF3
  ISRline NonHandledINTCException          ;Vec 681, CAF3
  ISRline NonHandledINTCException          ;Vec 682, FFLAG
  ISRline NonHandledINTCException          ;Vec 683, REF
                                           ;*** Source of interrupt: FlexPWM_1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 684, Reserved
  
                                           ;*** Source of interrupt: FlexPWM_2 Reserved ***
  ISRline NonHandledINTCException          ;Vec 685, Reserved
  ISRline NonHandledINTCException          ;Vec 686, Reserved
  ISRline NonHandledINTCException          ;Vec 687, Reserved
  ISRline NonHandledINTCException          ;Vec 688, Reserved
  ISRline NonHandledINTCException          ;Vec 689, Reserved
  ISRline NonHandledINTCException          ;Vec 690, Reserved
  ISRline NonHandledINTCException          ;Vec 691, Reserved
  ISRline NonHandledINTCException          ;Vec 692, Reserved      
  ISRline NonHandledINTCException          ;Vec 693, Reserved
  ISRline NonHandledINTCException          ;Vec 694, Reserved
  ISRline NonHandledINTCException          ;Vec 695, Reserved
  ISRline NonHandledINTCException          ;Vec 696, Reserved
  ISRline NonHandledINTCException          ;Vec 697, Reserved
  ISRline NonHandledINTCException          ;Vec 698, Reserved
  ISRline NonHandledINTCException          ;Vec 699, Reserved   
  
                                           ;*** Source of interrupt: CTU_0 ***
  ISRline NonHandledINTCException          ;Vec 700, MRS_I
  ISRline NonHandledINTCException          ;Vec 701, T0_I
  ISRline NonHandledINTCException          ;Vec 702, T1_I
  ISRline NonHandledINTCException          ;Vec 703, T2_I
  ISRline NonHandledINTCException          ;Vec 704, T3_I
  ISRline NonHandledINTCException          ;Vec 705, T4_I
  ISRline NonHandledINTCException          ;Vec 706, T5_I
  ISRline NonHandledINTCException          ;Vec 707, T6_I  
  ISRline NonHandledINTCException          ;Vec 708, T7_I  
  ISRline NonHandledINTCException          ;Vec 709, FIFO0_I
  ISRline NonHandledINTCException          ;Vec 710, FIFO1_I
  ISRline NonHandledINTCException          ;Vec 711, FIFO2_I
  ISRline NonHandledINTCException          ;Vec 712, FIFO3_I
  ISRline NonHandledINTCException          ;Vec 713, ADC_I
  ISRline NonHandledINTCException          ;Vec 714, ERR_I
                                           ;*** Source of interrupt: CTU_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 715, Reserved  
  
                                           ;*** Source of interrupt: CTU_1 ***
  ISRline NonHandledINTCException          ;Vec 716, MRS_I
  ISRline NonHandledINTCException          ;Vec 717, T0_I
  ISRline NonHandledINTCException          ;Vec 718, T1_I
  ISRline NonHandledINTCException          ;Vec 719, T2_I
  ISRline NonHandledINTCException          ;Vec 720, T3_I
  ISRline NonHandledINTCException          ;Vec 721, T4_I
  ISRline NonHandledINTCException          ;Vec 722, T5_I
  ISRline NonHandledINTCException          ;Vec 723, T6_I  
  ISRline NonHandledINTCException          ;Vec 724, T7_I  
  ISRline NonHandledINTCException          ;Vec 725, FIFO0_I
  ISRline NonHandledINTCException          ;Vec 726, FIFO1_I
  ISRline NonHandledINTCException          ;Vec 727, FIFO2_I
  ISRline NonHandledINTCException          ;Vec 728, FIFO3_I
  ISRline NonHandledINTCException          ;Vec 729, ADC_I
  ISRline NonHandledINTCException          ;Vec 730, ERR_I
                                           ;*** Source of interrupt: CTU_1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 731, Reserved  
  
                                           ;*** Source of interrupt: SGEN ***
  ISRline NonHandledINTCException          ;Vec 732, sgen_error  
                                           ;*** Source of interrupt: SGEN Reserved ***
  ISRline NonHandledINTCException          ;Vec 733, Reserved
  
  // interrupt vectors: 734-1023 Reserved  
                           
#pragma endasm

// ****************************************************************************
// ***************************** Functions ************************************
// ****************************************************************************
       
//default code for unused ISR
void NonHandledINTCException(){
    while(1);
}//NonHandledINTCException
