
MEMORY {
// Memory map for the MPC5744P

//   16KB of UTEST flash starting at 0x00400000.
//   96KB of data flash starting at 0x00800000.
//  416KB of small flash blocks starting at 0x00f98000.
// 2048KB of large flash blocks starting at 0x01000000.

    flash_rsvd1  : ORIGIN = 0x00400000, LENGTH = 0x00b98000
    //flash_memory : ORIGIN = 0x00f98000,	LENGTH = 0x00268000 // small and large flashblocks
    flash_memory : ORIGIN = 0x00f98000, LENGTH = 0x228000 // small and large flashblocks
    my_flash     : ORIGIN = .,          LENGTH = 0x4B400  // L7 block excluded
    flash_rsvd2  : ORIGIN = .,          LENGTH = 0
    

// 384KB of system SRAM starting at 0x40000000
    dram_rsvd1   : ORIGIN = 0x40000000, LENGTH = 0x100 // reserved for interrupt vectors
    dram_reset   : ORIGIN = .,	        LENGTH = 0
    dram_memory  : ORIGIN = .,          LENGTH = 384K-0x100
    dram_rsvd2   : ORIGIN = .,          LENGTH = 0
}
DEFAULTS {
    stack_reserve = 32k
    heap_reserve = 32k
}
//
// Program layout for starting in ROM, copying data to RAM,
// and continuing to execute out of ROM.
//

SECTIONS
{
//
// RAM SECTIONS
//
    .PPC.EMB.sdata0 	          		    ABS : > dram_memory
    .PPC.EMB.sbss0                            CLEAR ABS : > .
   
    .sdabase 		       		       ALIGN(16): > dram_memory	
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 						: > .
    .ghcovfz 					  CLEAR : > .
    .ghcovcz 					  CLEAR	: > .
    .ghcovdz 					  CLEAR	: > .
    .isrvectab   			 ALIGN(0x1000)  : {} > .   /* ISR Vector Table - must be 2K aligned */
    .heap                  ALIGN(16) PAD(heap_reserve)  : > .   
    .stack                 ALIGN(16) PAD(stack_reserve) : > .

//
// ROM SECTIONS
//

    .rchw						: > flash_memory
    .text						: > flash_memory
    .vletext						: > .
    .xptn_vectors			  ALIGN(0x1000)	: > .
    .syscall						: > .

    .rodata		 				: > .
    .toc 				     SHFLAGS(2)	: > .
    .sdata2 						: > .
    .opd 				     SHFLAGS(2)	: > .

    .secinfo 						: > .
    .fixaddr 						: > .
    .fixtype 						: > .

    .CROM.PPC.EMB.sdata0 	  CROM(.PPC.EMB.sdata0) : > .
    .CROM.sdata  	            	   CROM(.sdata) : > .
    .CROM.data 	            		    CROM(.data) : > .
    .ROM.isrvectab  ROM(.isrvectab) 	  ALIGN(0x1000)	: {} > .   /* ISR vector table */
    
    .xcptn                               ALIGN(0x10000) : {} > .   /* Exception Vector Table (IVPR) - align 64K boundary */

/*-------- LABELS USED IN CODE -------------------------------*/
/* Interrupt Handler Parameters */
__IVPR = ADDR(.xptn_vectors);
__IV_ADDR = ADDR(.xcptn);


//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(dram_rsvd1);
    __ghs_ramend    = MEMENDADDR(dram_memory);
    __ghs_romstart  = MEMADDR(flash_rsvd1);
    __ghs_romend    = MEMENDADDR(flash_rsvd2);

//
// These special symbols mark the bounds of RAM and ROM images of boot code.
// They are used by the GHS startup code (_start and __ghs_ind_crt0).
//
    __ghs_rambootcodestart  = 0;
    __ghs_rambootcodeend    = 0;
    __ghs_rombootcodestart  = ADDR(.vletext);
    __ghs_rombootcodeend    = ENDADDR(.fixtype);
}

