/**************************************************************************
 * FILE NAME: MPC5744P                       COPYRIGHT (c) Freescale 2013 *
 * REVISION:  1.0                                     All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the mpc5744p.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 0.2      P.A.      16-APR-12     -XBIC and PRAMC modules were added.   *
 *                                  -PWM module name was modified as      * 
 *                                  FlexPWM (Just in the header file).    *
 *                                  -In FlexPWM, DCHMID, DCHPRI and TCDs  *
 *                                  were arranged in an array.            *
 *                                  -In the MEMU, SYS_RAM_CERR_STS and    *
 *                                  SYS_RAM_CERR_ADDR were organized as   *
 *                                  an array of 10 channels.              *
 *                                  FLASH_CERR_STS and FLASH_CERR _ADDR   *
 *                                  were organized as an array of 20      *
 *                                  channels. PERIPH_RAM_CERR_STS and     *
 *                                  PERIPH_RAM_CERR _ADDR were organized  *
 *                                  as an array of 2 channels.            *
 *                                  -In the PIT, LDVAL, CVAL, TCTRL,      *
 *                                  TFLG were organized as an array of    *
 *                                  4 timers.                             *   
 *                                  -In the SMPU, EAR and EDR were        *
 *                                  organized as an array of 16 channels. *
 *                                  -In the STM, CCR, CIR and CMP were    *
 *                                  organized as an array of 4 channels.  *
 *                                  -In the XBAR, PRS and CRS were        *
 *                                  organized as an array of 8 channels.  *
 *                                  -In the DMAMUX, CHCFG was organized   *
 *                                  as an array of 16 channels.           *
 *                                  -In the DSPI, RXFR was organized as   *
 *                                  an array of 5 registers and TXFR was  *
 *                                  organized as an array of 5 registers. * 
 *                                  -In the FR, SSR was organized as an   *
 *                                  array of 8 registers. SSCR was        *
 *                                  organized as an array of 4 registers. *
 *                                  NMVR was organized as an array of 6   *
 *                                  registers. MBCCSR, MBCCFR, MBFIDR,    *
 *                                  MBIDXR were organized as an array of  *
 *                                  64. MBDOR was organized as an array   *
 *                                  of 68 registers. LEETR was organized  *
 *                                  as an array of 6 registers.           *
 *                                  -In the INTC, CPR was organized as    *
 *                                  an array of 4 registers. IACKR was    *
 *                                  organized as an array of 4 registers. *
 *                                  EOIR was organized as an array of     *
 *                                  4 registers.                          *
 *                                  -In the ME, RUN_MC was organized as   *
 *                                  an array of 4 registers. RUN_PC was   *
 *                                  organized as an array of 8 registers. *
 *                                  LP_PC was organized as an array of    *
 *                                  8 registers.                          *
 *                                                                        *
 * 0.3      P.A.      07-MAY-12     -Adding PFLASH module.                *
 *                                                                        *
 * 0.4      P.A.      12-JUN-12     -Adding AIPS, C55FMC, LINFlexD, and   *
 *                                  SIUL2 modules.                        *
 *                                  -All the other modules are from the   *
 *                                  previous release.                     *
 *                                                                        *                                                                          
 * 0.5      P.A.      13-JUN-12     -Generated using the last update of   *
 *                                  of AIPS, C55FMC, LINFlexD, and        *
 *                                  SIUL2 modules.                        *
 *                                                                        *
 * 0.6      P.A.      14-JUN-12     -Fix filter issues in AIPS module.    *
 *                                                                        *
 * 0.6.1    P.A.      14-JUN-12     -The IMCR register of SIUL2 module was*
 *                                  modified in the size of the array     *
 *                                  adding 32 more and decreasing the     *
 *                                  previous memory spot in 128.          *
 *                                  -Next drop of XML files is going to   *
 *                                  include this change.                  *                                    
 *                                                                        *
 * 0.7      P.A.      27-JUN-12     -Adding latest files sended by Nick   *
 *                                  Evans.                                *
 *                                                                        *
 * 0.7.1    P.A.      28-JUN-12     -Some registers were arranged in      *
 *                                  arrays.                               *
 *                                                                        *
 * 0.7.2    P.A.      29-JUN-12     -Registers NCFS_CFG, NCFS_CFG, NCF_S, *
 *                                  NCF_E, NCF_TOE, IRQ_ALARM_EN, NMI_EN, *
 *                                  and EOUT_SIG_EN were expanded from    *
 *                                  arrays and they were indexed with     *
 *                                  their corresponding number.           *                                                 
 *                                                                        *
 * 0.7.3    P.A.      29-JUN-12     -Registers NCFS_CFG, NCFS_CFG, NCF_S, *
 *                                  NCF_E, NCF_TOE, IRQ_ALARM_EN, NMI_EN, *
 *                                  and EOUT_SIG_EN were changed to get   *
 *                                  something similar to McKinley.        *
 *                                                                        *
 * 0.7.4    P.A.      12-JUL-12     -GPDO and GPDI registers were added   *
 *                                  into an array.                        *
 *                                  -FCCU XML files has an incorrect      *
 *                                  address value for the tag             *
 *                                  componentUnitAddrAsHex. Nick Evans    *
 *                                  has the fixed one and he is going     *
 *                                  to send it untill the next release.   *
 *                                  I'm changing manually the value from  *
 *                                  0xFEED0000UL to 0xFBF58000UL.         *
 *                                                                        *
 * 0.7.5    P.A.      24-JUL-12     -CDRx_MCR_WLSIDE_n registers were     *
 *                                  removed. Also, CDRx_MCR_WLSIDE_0      *
 *                                  registers were put into an array and  *
 *                                  its name were modified to CDR_MCR.    *
 *                                  -Bit CIF of STM_CCR register was      *
 *                                  corrected to CEN.                     *
 *                                  -Registers T0CR-T7CR were put into    *
 *                                  an array.                             *
 *                                  -CLR_x_n were put into a struct named *
 *                                  CHANNEL.                              *
 *                                                                        *
 * 0.7.6    P.A.      26-JUL-12     -THRHLR registers were included into  *
 *                                  two arrays. First one includes from   *
 *                                  THRHLR0 to THRHLR3 and it was named   *
 *                                  as THRHLR. Second one includes from   *
 *                                  THRHLR4 to THRHLR15 and it was named  *
 *                                  as THRHLRx.                           *
 *                                                                        *
 *                                                                        *
 * 0.7.7    P.A.      27-JUL-12     -eTIMER channel registers were added  *
 *                                  into a structure call CHANNEL.        *
 *                                                                        *
 * 0.7.8    P.A.      31-JUL-12     -PS5 was removed from MC_ME module.   *
 *                                                                        *
 * 0.7.9    P.A.      06-AUG-12     -GPDO and GPDI registers were         *
 *                                   modified from vuint32_t to           *
 *                                   vuint8_t.                            *
 *                                                                        *
 * 0.7.10   P.A.      06-AUG-12     -PS5 was added again because Nick     *
 *                                  Evans notified about an errata in the *
 *                                  RM where PS5 was not included.        *
 *                                  -TCD array was modified from 64 to 32 *
 *                                  channels.                             *
 *                                                                        *
 * 0.7.11   P.A.      14-AUG-12     -CTR0_SLAVE module was removed.       *
 *                                  -Registers CPR, IACKR, and EOIR were  *
 *                                  removed for processor 1 and up. A     *
 *                                  reserved space was added for each one.*
 *                                                                        *
 * 0.7.12   P.A.      21-AUG-12     -PS5 was removed.                     *
 *                                                                        *
 * 0.7.13   P.A.      14-SEP-12     -Line uint8_t LFAST_reserved0[1]; was *
 *                                  removed from LFAST module.            *
 *                                                                        *
 * 0.7.14   P.A.      18-SEP-12     -CAN module was modified according    *
 *                                  with the changes requested by         *
 *                                  Barbara.                              *
 *                                  -Struct canbuf_t was added.           *
 *                                  -Some memory spots were added and     *
 *                                  modified.                             *
 *                                                                        *
 * 0.7.15   P.A.      26-SEP-12     -CLR_B and CLR_C registers of CTU     *
 *                                  module were commented out.            *
 *                                  -Also, the struct CHANNEL, that       *
 *                                  used to contain those registers, was  *
 *                                  removed.                              *
 *                                                                        *
 * 0.7.16   P.A.      03-OCT-12     -Register NICCH4 had an wrong name.   *
 *                                  I changed it to NIBBCH4.              *
 *                                                                        *
 * 0.7.17   P.A.      23-Oct-12     -Added                                *
 *               #define CRC_1 (*(volatile struct CRC_tag *) 0xFFF64010UL)*
 *               #define CRC_2 (*(volatile struct CRC_tag *) 0xFFF64020UL)*
 *                                                                        *
 *                                                                        *
 * 0.7.18   P.A.      26-Oct-12     -CRC module was modified adding:      *
 *                                     	CRC_CFG1                        *
 *                                     	CRC_INP1                        *
 *                                     	CRC_CSTAT1                      *
 *                                     	CRC_OUTP1                       *
 *                                     	CRC_CFG2                        *
 *                                     	CRC_INP2                        *
 *                                     	CRC_CSTAT2                      *
 *                                     	CRC_OUTP2                       *
 *                                     	CRC_CFG3                        *
 *                                     	CRC_INP3                        *
 *                                     	CRC_CSTAT3                      *
 *                                     	CRC_OUTP3                       *
 *                                                                        *
 * 0.7.19   M.D.      05-Dec-12     -Regenerated from SIDSC database      *                                                              
 *                                  -CLR_A, CLR_B, CLR_C compressed into  *
 *                                   CHANNEL struct                       *
 *                                  -CH_FMSG_DATA, CH_FMSG_CRC,           *
 *                                   CH_FMSG_TS, CH_SMSG_BIT3,            *
 *                                   CH_SMSG_BIT2, CH_SMSG_TS compressed  *
 *                                   into CHANNEL struct                  *
 *                                  -MB_CTRL compressed into array        *
 *                                                                        *
 * 0.7.20   M.D.      20-Dec-12     -Regenerated from SIDSC database      *
 *                                  -CAN Module:                          *
 *                                    inserted code in place of uint8_t   *
 *                                    CAN_reserved2[2096]; and in between *
 *                                    RXFIR and RXIMR                     *
 *                                  -Module: CTU                          *
 *                                   CLR_A, CLR_B, CLR_C -> union {CLR_A, *
 *                                    CLR_B, CLR_C} CLR                   *
 *                                  -Module: DMA                          *
 *                                   TCD_NBYTES_MLOFFNO,                  *
 *                                    TCD_NBYTES_MLOFFYES, TCD_NBYTES_MLNO*
 *                                    -> union {OFFNO, OFFYES, NO}        *
 *                                    NBYTES_ML                           *
 *                                   TCD_CITER_ELINKYES, TCD_CITER_ELINKNO*
 *                                    -> union {YES, NO} CITER_ELINK      *
 *                                   TCD_BITER_ELINKYES, TCD_BITER_ELINKNO*
 *                                    -> union {YES, NO} BITER_ELINK      *
 *                                  -Module: FR                           *
 *                                   MTSACFR, MTSBCFR -> MTSxCFR[2]       *
 *                                   RFARIR, RFBRIR -> RFxRIR[2]          *
 *                                  -Module: FlexPWM                      *
 *                                   SUB0_VAL0 through SUB0_VAL5 to array *
 *                                    SUB0_VAL[6]                         *
 *                                   SUB0_CNT, SUB0_INIT, SUB0_CTRL2,     *
 *                                    SUB0_CTRL1, SUB0_VAL[6], SUB0_OCTRL,*
 *                                    SUB0_STS, SUB0_INTEN, SUB0_DMAEN,   *
 *                                    SUB0_TCTRL, SUB0_DISMAP, SUB0_DTCNT,*
 *                                    SUB0_CAPTCTRLX, SUB0_CAPTCMPX,      *
 *                                    SUB0_CVAL0, SUB0_CVAL0CYC,          *
 *                                    SUB0_CVAL1, SUB0_CVAL1CYC to struct *
 *                                    {} SUB[4]                           *
 *                                  -Module: INTC                         *
 *                                   HIPRI0C0 -> HIPRIC0[4]               *
 *                                   LAT0C0 -> LATC0[4]                   *
 *                                   IMER0C0 -> TIMERC0[4]                *
 *                                  -Module: MC_CGM                       *
 *                                   PCS_DIVC1, PCS_DIVS1, PCS_DIVE1      *
 *                                    through 2 -> struct {DIVC, DIVS,    *
 *                                    DIVE} PCS[2]                        *
 *                                  -Module: SPI                          *
 *                                   CTAR0, CTAR0_SLAVE -> union {CTAR0,  *
 *                                    SLAVE} CTAR                         *
 *                                   CTAR from 1 through 3 to array       *
 *                                    CTAR[3]                             *
 *                                   PUSHR, PUSHR_SLAVE -> union {PUSHR,  *
 *                                    PUSHR_SLAVE} PUSHR                  *
 *                                  -Module: SRX                          *
 *                                   CH0_CLK_CTRL, CH0_STATUS, CH0_CONFIG *
 *                                    from 1 through 15 to struct {}      *
 *                                    CH1[16]                             *
 *                                   CH0_FMSG_DATA, CH0_FMSG_CRC,         *
 *                                    CH0_FMSG_TS, CH0_SMSG_BIT3,         *
 *                                    CH0_SMSG_BIT2, CH0_SMSG_TS -> struct*
 *                                    {} CH2[16]                          *
 *                                  -Module: STCU                         *
 *                                   LB0_CTRL, LB0_PCS, LB0_MISRELSW,     *
 *                                    LB0_MISREHSW from 1 through 3 to    *
 *                                    struct {CTRL, PCS, MISRELSW,        *
 *                                    MISREHSW} LB[4]                     *
 *                                                                        *
 * 0.7.21   M.D.      18-Feb-13     -Regenerated from SIDSC database      * 
 *                                                                        *
 * 0.7.22   M.D.      22-Feb-13     -Removed duplicate LINFlexD registers *
 *                                                                        *
 * 0.7.23   M.D.      25-Feb-13     -Updated per Barbara                  *
 *                                                                        *
 * 0.7.24   M.D.      27-Feb-13     -More updates per Barbara             *
 *                                                                        *
 * 0.7.25   M.D.      28-Feb-13     -ADC THRHLR (offset 0x60) should be THRHLR[4] so there are 4 registers. Nick confirmed this error is in the RM and XML and he will make the correction in the source.
 *                                  -For the CTU registers, add a comment near CHANNEL[24] that for CLR_A_n, CLR_B_n, CLR_C_n,  n=1:24.
 *                                  -For INTC LATC[4], change to LATC0[4].
 *                                  -Add the missing SSCIR[8:15] registers. Theres no need to adjust the INTC_reserved4 size. 
 *                                  -For SRX CH1[] and CH[2], follow the Mattherhorn format of uncompressed names.
 *                                  -For SRX PRS and CRS, follow Matterhorn format of arrays and add a comment to check the RM for unimplemented registers.
 *                                                                        *
 * 0.7.26   M.D.      11-Mar-13     -Changed ADC_reserved5 array from 28  *
 *                                   to 16                                *
 *                                  -Changed CAN Message Buffer definition*
 *                                   vuint32_t ID to                      *
 *                                    union {                             *
 *                                        vuint32_t R;                    *
 *                                        struct {                        *
 *                                            vuint32_t PRIO:3;           *
 *                                            vuint32_t ID_STD:11;        *
 *                                            vuint32_t ID_EXT:18;        *
 *                                        } B;                            *
 *                                    } ID;                               *
 *                                                                        * 
 * 0.7.27   M.D.      17-Apr-13     -Corrected reserved memory within FCCU*
 *                                                                        *
 * 1.0.0    M.D.      11-Jun-13     -Updated per RM Rev2                  *  
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MPC5744P_H_
#define _MPC5744P_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

struct ADC_tag {
  union {                              /* Main Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t OWREN:1;               /* Overwrite enable. */
      vuint32_t WLSIDE:1;              /* Write Left/Right aligned. */
      vuint32_t MODE:1;                /* One_Shot/Scan. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t NSTART:1;
      vuint32_t  :1;
      vuint32_t JTRGEN:1;              /* Injection external trigger enable. */
      vuint32_t JEDGE:1;               /* Injection trigger edge selection. */
      vuint32_t JSTART:1;              /* Injection start. */
      vuint32_t  :2;
      vuint32_t CTUEN:1;               /* Crosstrigger Unit Enable. */
      vuint32_t  :1;
      vuint32_t STCL:1;                /* Self Testing Configuration Lock. */
      vuint32_t  :6;
      vuint32_t ADCLKSEL:1;            /* Analog Clock frequency Selector. */
      vuint32_t ABORT_CHAIN:1;         /* Abort Chain. */
      vuint32_t ABORT:1;               /* Abort Conversion. */
      vuint32_t ACKO:1;                /* Auto clock off enable. */
      vuint32_t  :2;
      vuint32_t REFSEL:2;              /* Reference voltage selection for ADC analog part. */
      vuint32_t PWDN:1;                /* Power-down enable. */
    } B;
  } MCR;

  union {                              /* Main Status register */
    vuint32_t R;
    struct {
      vuint32_t CALIBRTD:1;            /* This bit indicates the ADC calibration status. */
      vuint32_t  :6;
      vuint32_t NSTART:1;              /* This status bit is used to signal that a Normal conversion is ongoing. */
      vuint32_t JABORT:1;
      vuint32_t  :2;
      vuint32_t JSTART:1;              /* This status bit is used to signal that an Injected conversion is ongoing. */
      vuint32_t  :1;
      vuint32_t SELF_TEST_S:1;         /* This status bit signals that self test conversion is ongoing. */
      vuint32_t  :1;
      vuint32_t CTUSTART:1;            /* This status bit is used to signal that a CTU conversion is ongoing. */
      vuint32_t CHADDR:7;              /* Channel under measure address. */
      vuint32_t  :3;
      vuint32_t ACKO:1;                /* Auto clock off enable. */
      vuint32_t  :2;
      vuint32_t ADCSTATUS:3;           /* Status of the ADC. */
    } B;
  } MSR;

  uint8_t ADC_reserved0[8];
  union {                              /* Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t EOCTU:1;
      vuint32_t JEOC:1;                /* End of injected channel conversion. */
      vuint32_t JECH:1;                /* End of injected chain conversion. */
      vuint32_t EOC:1;                 /* End of channel conversion. */
      vuint32_t ECH:1;                 /* End of chain conversion. */
    } B;
  } ISR;

  union {                              /* Channel Pending register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t EOCCH15:1;             /* EOC Channel 15. */
      vuint32_t EOCCH14:1;             /* EOC Channel 14. */
      vuint32_t EOCCH13:1;             /* EOC Channel 13. */
      vuint32_t EOCCH12:1;             /* EOC Channel 12. */
      vuint32_t EOCCH11:1;             /* EOC Channel 11. */
      vuint32_t EOCCH10:1;             /* EOC Channel 10. */
      vuint32_t EOCCH9:1;              /* EOC Channel 9. */
      vuint32_t EOCCH8:1;              /* EOC Channel 8. */
      vuint32_t EOCCH7:1;              /* EOC Channel 7. */
      vuint32_t EOCCH6:1;              /* EOC Channel 6. */
      vuint32_t EOCCH5:1;              /* EOC Channel 5. */
      vuint32_t EOCCH4:1;              /* EOC Channel 4. */
      vuint32_t EOCCH3:1;              /* EOC Channel 3. */
      vuint32_t EOCCH2:1;              /* EOC Channel 2. */
      vuint32_t EOCCH1:1;              /* EOC Channel 1. */
      vuint32_t EOCCH0:1;              /* EOC Channel 0. */
    } B;
  } CEOCFR0;

  uint8_t ADC_reserved1[8];
  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t MSKEOCTU:1;            /* Mask bit for EOCTU. */
      vuint32_t MSKJEOC:1;             /* Mask bit for JEOC. */
      vuint32_t MSKJECH:1;             /* Mask bit for JECH. */
      vuint32_t MSKEOC:1;              /* Mask bit for EOC. */
      vuint32_t MSKECH:1;              /* Mask bit for ECH. */
    } B;
  } IMR;

  union {                              /* Channel Interrupt Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CIM15:1;               /* Channel 15 interrupt enable. */
      vuint32_t CIM14:1;               /* Channel 14 interrupt enable. */
      vuint32_t CIM13:1;               /* Channel 13 interrupt enable. */
      vuint32_t CIM12:1;               /* Channel 12 interrupt enable. */
      vuint32_t CIM11:1;               /* Channel 11 interrupt enable. */
      vuint32_t CIM10:1;               /* Channel 10 interrupt enable. */
      vuint32_t CIM9:1;                /* Channel 9 interrupt enable. */
      vuint32_t CIM8:1;                /* Channel 8 interrupt enable. */
      vuint32_t CIM7:1;                /* Channel 7 interrupt enable. */
      vuint32_t CIM6:1;                /* Channel 6 interrupt enable. */
      vuint32_t CIM5:1;                /* Channel 5 interrupt enable. */
      vuint32_t CIM4:1;                /* Channel 4 interrupt enable. */
      vuint32_t CIM3:1;                /* Channel 3 interrupt enable. */
      vuint32_t CIM2:1;                /* Channel 2 interrupt enable. */
      vuint32_t CIM1:1;                /* Channel 1 interrupt enable. */
      vuint32_t CIM0:1;                /* Channel 0 interrupt enable. */
    } B;
  } CIMR0;

  uint8_t ADC_reserved2[8];
  union {                              /* Watchdog Threshold Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t WDG15H:1;
      vuint32_t WDG15L:1;
      vuint32_t WDG14H:1;
      vuint32_t WDG14L:1;
      vuint32_t WDG13H:1;
      vuint32_t WDG13L:1;
      vuint32_t WDG12H:1;
      vuint32_t WDG12L:1;
      vuint32_t WDG11H:1;
      vuint32_t WDG11L:1;
      vuint32_t WDG10H:1;
      vuint32_t WDG10L:1;
      vuint32_t WDG9H:1;
      vuint32_t WDG9L:1;
      vuint32_t WDG8H:1;
      vuint32_t WDG8L:1;
      vuint32_t WDG7H:1;
      vuint32_t WDG7L:1;
      vuint32_t WDG6H:1;
      vuint32_t WDG6L:1;
      vuint32_t WDG5H:1;
      vuint32_t WDG5L:1;
      vuint32_t WDG4H:1;
      vuint32_t WDG4L:1;
      vuint32_t WDG3H:1;
      vuint32_t WDG3L:1;
      vuint32_t WDG2H:1;
      vuint32_t WDG2L:1;
      vuint32_t WDG1H:1;
      vuint32_t WDG1L:1;
      vuint32_t WDG0H:1;
      vuint32_t WDG0L:1;
    } B;
  } WTISR;

  union {                              /* Watchdog Threshold Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t MSKWDG15H:1;
      vuint32_t MSKWDG15L:1;
      vuint32_t MSKWDG14H:1;
      vuint32_t MSKWDG14L:1;
      vuint32_t MSKWDG13H:1;
      vuint32_t MSKWDG13L:1;
      vuint32_t MSKWDG12H:1;
      vuint32_t MSKWDG12L:1;
      vuint32_t MSKWDG11H:1;
      vuint32_t MSKWDG11L:1;
      vuint32_t MSKWDG10H:1;
      vuint32_t MSKWDG10L:1;
      vuint32_t MSKWDG9H:1;
      vuint32_t MSKWDG9L:1;
      vuint32_t MSKWDG8H:1;
      vuint32_t MSKWDG8L:1;
      vuint32_t MSKWDG7H:1;
      vuint32_t MSKWDG7L:1;
      vuint32_t MSKWDG6H:1;
      vuint32_t MSKWDG6L:1;
      vuint32_t MSKWDG5H:1;
      vuint32_t MSKWDG5L:1;
      vuint32_t MSKWDG4H:1;
      vuint32_t MSKWDG4L:1;
      vuint32_t MSKWDG3H:1;
      vuint32_t MSKWDG3L:1;
      vuint32_t MSKWDG2H:1;
      vuint32_t MSKWDG2L:1;
      vuint32_t MSKWDG1H:1;
      vuint32_t MSKWDG1L:1;
      vuint32_t MSKWDG0H:1;
      vuint32_t MSKWDG0L:1;
    } B;
  } WTIMR;

  uint8_t ADC_reserved3[8];
  union {                              /* DMA Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t DCLR:1;                /* DMA Clear sequence enable. */
      vuint32_t DMAEN:1;               /* DMA global enable. */
    } B;
  } DMAE;

  union {                              /* DMA Channel Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DMA15:1;               /* DMA enable for channel 15. */
      vuint32_t DMA14:1;               /* DMA enable for channel 14. */
      vuint32_t DMA13:1;               /* DMA enable for channel 13. */
      vuint32_t DMA12:1;               /* DMA enable for channel 12. */
      vuint32_t DMA11:1;               /* DMA enable for channel 11. */
      vuint32_t DMA10:1;               /* DMA enable for channel 10. */
      vuint32_t DMA9:1;                /* DMA enable for channel 9. */
      vuint32_t DMA8:1;                /* DMA enable for channel 8. */
      vuint32_t DMA7:1;                /* DMA enable for channel 7. */
      vuint32_t DMA6:1;                /* DMA enable for channel 6. */
      vuint32_t DMA5:1;                /* DMA enable for channel 5. */
      vuint32_t DMA4:1;                /* DMA enable for channel 4. */
      vuint32_t DMA3:1;                /* DMA enable for channel 3. */
      vuint32_t DMA2:1;                /* DMA enable for channel 2. */
      vuint32_t DMA1:1;                /* DMA enable for channel 1. */
      vuint32_t DMA0:1;                /* DMA enable for channel 0. */
    } B;
  } DMAR0;

  uint8_t ADC_reserved4[24];
  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR0;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR1;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR2;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR3;

  uint8_t ADC_reserved5[16];
  union {                              /* Presampling Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t PREVAL2:2;             /* Internal voltage selection for Presampling */
      vuint32_t PREVAL1:2;             /* Internal voltage selection for Presampling. */
      vuint32_t PREVAL0:2;             /* Internal voltage selection for Presampling. */
      vuint32_t PRECONV:1;             /* Convert Presampled value */
    } B;
  } PSCR;

  union {                              /* Presampling register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t PRES15:1;              /* Presampling enable for channel 15. */
      vuint32_t PRES14:1;              /* Presampling enable for channel 14. */
      vuint32_t PRES13:1;              /* Presampling enable for channel 13. */
      vuint32_t PRES12:1;              /* Presampling enable for channel 12. */
      vuint32_t PRES11:1;              /* Presampling enable for channel 11. */
      vuint32_t PRES10:1;              /* Presampling enable for channel 10. */
      vuint32_t PRES9:1;               /* Presampling enable for channel 9. */
      vuint32_t PRES8:1;               /* Presampling enable for channel 8. */
      vuint32_t PRES7:1;               /* Presampling enable for channel 7. */
      vuint32_t PRES6:1;               /* Presampling enable for channel 6. */
      vuint32_t PRES5:1;               /* Presampling enable for channel 5. */
      vuint32_t PRES4:1;               /* Presampling enable for channel 4. */
      vuint32_t PRES3:1;               /* Presampling enable for channel 3. */
      vuint32_t PRES2:1;               /* Presampling enable for channel 2. */
      vuint32_t PRES1:1;               /* Presampling enable for channel 1. */
      vuint32_t PRES0:1;               /* Presampling enable for channel 0. */
    } B;
  } PSR0;

  uint8_t ADC_reserved6[12];
  union {                              /* Conversion Timing Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t INPSAMP:8;             /* Configuration of sampling phase duration. */
    } B;
  } CTR0;

  union {                              /* Conversion Timing Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t INPSAMP:7;             /* Configuration of sampling phase duration. */
      vuint32_t TSENSOR_SEL:1;         /* Voltage Select for temperature sensor. */
    } B;
  } CTR1;

  uint8_t ADC_reserved7[8];
  union {                              /* Normal Conversion Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CH15:1;                /* Sampling enable for channel 15. */
      vuint32_t CH14:1;                /* Sampling enable for channel 14. */
      vuint32_t CH13:1;                /* Sampling enable for channel 13. */
      vuint32_t CH12:1;                /* Sampling enable for channel 12. */
      vuint32_t CH11:1;                /* Sampling enable for channel 11. */
      vuint32_t CH10:1;                /* Sampling enable for channel 10. */
      vuint32_t CH9:1;                 /* Sampling enable for channel 9. */
      vuint32_t CH8:1;                 /* Sampling enable for channel 8. */
      vuint32_t CH7:1;                 /* Sampling enable for channel 7. */
      vuint32_t CH6:1;                 /* Sampling enable for channel 6. */
      vuint32_t CH5:1;                 /* Sampling enable for channel 5. */
      vuint32_t CH4:1;                 /* Sampling enable for channel 4. */
      vuint32_t CH3:1;                 /* Sampling enable for channel 3. */
      vuint32_t CH2:1;                 /* Sampling enable for channel 2. */
      vuint32_t CH1:1;                 /* Sampling enable for channel 1. */
      vuint32_t CH0:1;                 /* Sampling enable for channel 0. */
    } B;
  } NCMR0;

  uint8_t ADC_reserved8[12];
  union {                              /* Injected Conversion Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CH15:1;                /* Sampling enable for channel 15. */
      vuint32_t CH14:1;                /* Sampling enable for channel 14. */
      vuint32_t CH13:1;                /* Sampling enable for channel 13. */
      vuint32_t CH12:1;                /* Sampling enable for channel 12. */
      vuint32_t CH11:1;                /* Sampling enable for channel 11. */
      vuint32_t CH10:1;                /* Sampling enable for channel 10. */
      vuint32_t CH9:1;                 /* Sampling enable for channel 9. */
      vuint32_t CH8:1;                 /* Sampling enable for channel 8. */
      vuint32_t CH7:1;                 /* Sampling enable for channel 7. */
      vuint32_t CH6:1;                 /* Sampling enable for channel 6. */
      vuint32_t CH5:1;                 /* Sampling enable for channel 5. */
      vuint32_t CH4:1;                 /* Sampling enable for channel 4. */
      vuint32_t CH3:1;                 /* Sampling enable for channel 3. */
      vuint32_t CH2:1;                 /* Sampling enable for channel 2. */
      vuint32_t CH1:1;                 /* Sampling enable for channel 1. */
      vuint32_t CH0:1;                 /* Sampling enable for channel 0. */
    } B;
  } JCMR0;

  uint8_t ADC_reserved9[16];
  union {                              /* Power Down Exit Delay Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t PDED:8;
    } B;
  } PDEDR;

  uint8_t ADC_reserved10[52];
  union {                              /* Channel Data Register n (Precision Channels) */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t VALID:1;               /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
      vuint32_t OVERW:1;               /* Overwrite data */
      vuint32_t RESULT:2;
      vuint32_t CDATA:16;              /* Converted Data 11:0. */
    } B;
  } CDR[16];

  uint8_t ADC_reserved11[320];
  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR4;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR5;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR6;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR7;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR8;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR9;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR10;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR11;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR12;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR13;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR14;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR15;

  union {                              /* Channel Watchdog Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH7:4;            /* Channel Watchdog select for channel 7. */
      vuint32_t WSEL_CH6:4;            /* Channel Watchdog select for channel 6. */
      vuint32_t WSEL_CH5:4;            /* Channel Watchdog select for channel 5. */
      vuint32_t WSEL_CH4:4;            /* Channel Watchdog select for channel 4. */
      vuint32_t WSEL_CH3:4;            /* Channel Watchdog select for channel 3. */
      vuint32_t WSEL_CH2:4;            /* Channel Watchdog select for channel 2. */
      vuint32_t WSEL_CH1:4;            /* Channel Watchdog select for channel 1. */
      vuint32_t WSEL_CH0:4;            /* Channel Watchdog select for channel 0. */
    } B;
  } CWSELR0;

  union {                              /* Channel Watchdog Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH15:4;           /* Channel Watchdog select for channel 15. */
      vuint32_t WSEL_CH14:4;           /* Channel Watchdog select for channel 14. */
      vuint32_t WSEL_CH13:4;           /* Channel Watchdog select for channel 13. */
      vuint32_t WSEL_CH12:4;           /* Channel Watchdog select for channel 12. */
      vuint32_t WSEL_CH11:4;           /* Channel Watchdog select for channel 11. */
      vuint32_t WSEL_CH10:4;           /* Channel Watchdog select for channel 10. */
      vuint32_t WSEL_CH9:4;            /* Channel Watchdog select for channel 9. */
      vuint32_t WSEL_CH8:4;            /* Channel Watchdog select for channel 8. */
    } B;
  } CWSELR1;

  uint8_t ADC_reserved12[40];
  union {                              /* Channel Watchdog Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CWEN15:1;              /* Sampling enable for channel 15. */
      vuint32_t CWEN14:1;              /* Sampling enable for channel 14. */
      vuint32_t CWEN13:1;              /* Sampling enable for channel 13. */
      vuint32_t CWEN12:1;              /* Sampling enable for channel 12. */
      vuint32_t CWEN11:1;              /* Sampling enable for channel 11. */
      vuint32_t CWEN10:1;              /* Sampling enable for channel 10. */
      vuint32_t CWEN9:1;               /* Sampling enable for channel 9. */
      vuint32_t CWEN8:1;               /* Sampling enable for channel 8. */
      vuint32_t CWEN7:1;               /* Sampling enable for channel 7. */
      vuint32_t CWEN6:1;               /* Sampling enable for channel 6. */
      vuint32_t CWEN5:1;               /* Sampling enable for channel 5. */
      vuint32_t CWEN4:1;               /* Sampling enable for channel 4. */
      vuint32_t CWEN3:1;               /* Sampling enable for channel 3. */
      vuint32_t CWEN2:1;               /* Sampling enable for channel 2. */
      vuint32_t CWEN1:1;               /* Sampling enable for channel 1. */
      vuint32_t CWEN0:1;               /* Sampling enable for channel 0. */
    } B;
  } CWENR0;

  uint8_t ADC_reserved13[12];
  union {                              /* Analog Watchdog Out of Range Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t AWOR_CH15:1;           /* Analog watchdog out of range for channel 15. */
      vuint32_t AWOR_CH14:1;           /* Analog watchdog out of range for channel 14. */
      vuint32_t AWOR_CH13:1;           /* Analog watchdog out of range for channel 13. */
      vuint32_t AWOR_CH12:1;           /* Analog watchdog out of range for channel 12. */
      vuint32_t AWOR_CH11:1;           /* Analog watchdog out of range for channel 11. */
      vuint32_t AWOR_CH10:1;           /* Analog watchdog out of range for channel 10. */
      vuint32_t AWOR_CH9:1;            /* Analog watchdog out of range for channel 9. */
      vuint32_t AWOR_CH8:1;            /* Analog watchdog out of range for channel 8. */
      vuint32_t AWOR_CH7:1;            /* Analog watchdog out of range for channel 7. */
      vuint32_t AWOR_CH6:1;            /* Analog watchdog out of range for channel 6. */
      vuint32_t AWOR_CH5:1;            /* Analog watchdog out of range for channel 5. */
      vuint32_t AWOR_CH4:1;            /* Analog watchdog out of range for channel 4. */
      vuint32_t AWOR_CH3:1;            /* Analog watchdog out of range for channel 3. */
      vuint32_t AWOR_CH2:1;            /* Analog watchdog out of range for channel 2. */
      vuint32_t AWOR_CH1:1;            /* Analog watchdog out of range for channel 1. */
      vuint32_t AWOR_CH0:1;            /* Analog watchdog out of range for channel 0. */
    } B;
  } AWORR0;

  uint8_t ADC_reserved14[76];
  union {                              /* Self Test Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t INPSAMP_C:8;
      vuint32_t  :8;
      vuint32_t INPSAMP_S:8;
      vuint32_t  :8;
    } B;
  } STCR1;

  union {                              /* Self Test Configuration Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t MSKWDSERR:1;
      vuint32_t SERR:1;
      vuint32_t MSKWDTERR:1;           /* Interrupt enable (STSR.WDTERR status bit) */
      vuint32_t  :1;
      vuint32_t MSKST_EOC:1;           /* Interrupt Enable bit for STSR2.ST_EOC */
      vuint32_t  :4;
      vuint32_t MSKWDG_EOA_C:1;        /* Interrupt enable (WDG_EOA_C status bit) */
      vuint32_t  :1;
      vuint32_t MSKWDG_EOA_S:1;        /* Interrupt enable (WDG_EOA_S status bit) */
      vuint32_t MSKERR_C:1;            /* Interrupt enable (ERR_C status bit) */
      vuint32_t  :1;
      vuint32_t MSKERR_S2:1;           /* Interrupt enable (ERR_S2 status bit) */
      vuint32_t MSKERR_S1:1;           /* Interrupt enable (ERR_S1 status bit) */
      vuint32_t MSKERR_S0:1;           /* Interrupt enable (ERR_S1 status bit) */
      vuint32_t  :3;
      vuint32_t EN:1;                  /* Self testing channel enable. The TEST conversions are enabled. */
      vuint32_t  :2;
      vuint32_t FMA_WDSERR:1;          /* Fault mapping for the Watchdog Sequence error. */
      vuint32_t FMA_WDTERR:1;          /* Fault mapping for the Watchdog Timer error. */
      vuint32_t FMA_C:1;               /* Fault mapping for self test algorithm C. */
      vuint32_t  :1;
      vuint32_t FMA_S:1;               /* Fault mapping for the self test algorithm BGAP. */
    } B;
  } STCR2;

  union {                              /* Self Test Configuration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t ALG:2;                 /* Algorithm scheduling. */
      vuint32_t  :3;
      vuint32_t MSTEP:5;
    } B;
  } STCR3;

  union {                              /* Self Test Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t WDT:3;
      vuint32_t  :8;
      vuint32_t BR:8;                  /* Baud rate for the selected algorithm in SCAN mode (MCR[MODE] = 1). */
    } B;
  } STBRR;

  union {                              /* Self Test Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t WDSERR:1;
      vuint32_t  :1;
      vuint32_t WDTERR:1;
      vuint32_t OVERWR:1;              /* Overwrite error. */
      vuint32_t ST_EOC:1;              /* Self Test EOC Bit. */
      vuint32_t  :4;
      vuint32_t WDG_EOA_C:1;
      vuint32_t  :1;
      vuint32_t WDG_EOA_S:1;
      vuint32_t ERR_C:1;
      vuint32_t  :1;
      vuint32_t ERR_S2:1;
      vuint32_t ERR_S1:1;
      vuint32_t ERR_S0:1;
      vuint32_t  :1;
      vuint32_t STEP_C:5;              /* Step of the algorithm C when an ERR_C has occurred. */
      vuint32_t  :5;
    } B;
  } STSR1;

  union {                              /* Self Test Status Register 2 */
    vuint32_t R;
    struct {
      vuint32_t OVFL:1;                /* Overflow Bit */
      vuint32_t  :3;
      vuint32_t DATA1:12;              /* Test channel converted data when the ERR_S1 has occurred. */
      vuint32_t  :4;
      vuint32_t DATA0:12;              /* Test channel converted data when the ERR_S1 has occurred. */
    } B;
  } STSR2;

  union {                              /* Self Test Status Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DATA1:12;              /* Test channel converted data when the ERR_S2 has occurred. */
      vuint32_t  :4;
      vuint32_t DATA0:12;              /* Test channel converted data when the ERR_S0 has occurred. */
    } B;
  } STSR3;

  union {                              /* Self Test Status Register 4 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DATA1:12;              /* Test channel converted data when the ERR_C has occurred. */
      vuint32_t  :4;
      vuint32_t  :12;
    } B;
  } STSR4;

  uint8_t ADC_reserved15[16];
  union {                              /* Self Test Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t VALID:1;               /* Valid data. */
      vuint32_t OWERWR:1;              /* Overwrite data. */
      vuint32_t  :6;
      vuint32_t TCDATA:12;             /* Test channel converted data. (In 2's complement format) */
    } B;
  } STDR1;

  union {                              /* Self Test Data Register 2 */
    vuint32_t R;
    struct {
      vuint32_t FDATA:12;
      vuint32_t VALID:1;               /* Valid data. */
      vuint32_t OWERWR:1;              /* Overwrite data. */
      vuint32_t  :6;
      vuint32_t IDATA:12;
    } B;
  } STDR2;

  uint8_t ADC_reserved16[8];
  union {                              /* Self Test Analog Watchdog Register 0 */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable (related to the algorithm S (step 0)) */
      vuint32_t WDTE:1;                /* Watchdog timer enable (related to the algorithm S) */
      vuint32_t  :2;
      vuint32_t THRH:12;               /* High threshold value for channel 0. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel 0. */
    } B;
  } STAW0R;

  union {                              /* Self Test Analog Watchdog Register 1A */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable related to the algorithm S (step1). */
      vuint32_t  :3;
      vuint32_t THRH:12;               /* High threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
    } B;
  } STAW1AR;

  union {                              /* Self Test Analog Watchdog Register 1B */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value (fractional part) for test channel for algorithm S (step 1)(unsigned coding). */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value (fractional part) for test channel for algorithm S (step 1) (unsigned coding). */
    } B;
  } STAW1BR;

  union {                              /* Self Test Analog Watchdog Register 2 */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable related to the algorithm S (step2). */
      vuint32_t  :19;
      vuint32_t THRL:12;               /* Low threshold value for channel x (unsigned coding). If the analog watchdog is enabled, the STSR1.ERR_S2 status bit is set if STDR1.TCDATA < THRL. */
    } B;
  } STAW2R;

  uint8_t ADC_reserved17[4];
  union {                              /* Self Test Analog Watchdog Register 4 */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable (related to the algorithm C) */
      vuint32_t WDTE:1;                /* Watchdog timer enable (related to the algorithm C). */
      vuint32_t  :2;
      vuint32_t THRH:12;               /* High threshold value for channel sampled for C algorithm. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel sampled for the C self test algorithm. */
    } B;
  } STAW4R;

  union {                              /* Self Test Analog Watchdog Register 5 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for the algorithm C (step1 to step CS-1). */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for the algorithm C (step1 to step CS-1). */
    } B;
  } STAW5R;

  uint8_t ADC_reserved18[4];
  union {                              /* Calibration, BIST Control and status Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t TSAMP:2;               /* Test Sample period in Calibration, BIST and Offset calculation process. */
      vuint32_t  :3;
      vuint32_t  :8;
      vuint32_t C_T_BUSY:1;
      vuint32_t  :1;
      vuint32_t  :6;
      vuint32_t  :1;
      vuint32_t NR_SMPL:2;             /* Number of Samples for averaging. */
      vuint32_t AVG_EN:1;              /* Average Enable (for Calibration only). */
      vuint32_t TEST_FAIL:1;           /* Test Fail. */
      vuint32_t  :2;
      vuint32_t TEST_EN:1;             /* Enable the test. */
    } B;
  } CALBISTREG;

  uint8_t ADC_reserved19[4];
  union {                              /* Offset and Gain User Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t GAIN_USER:10;
      vuint32_t  :8;
      vuint32_t OFFSET_USER:8;
    } B;
  } OFSGNUSR;

  uint8_t ADC_reserved20[12];
  union {                              /* Alternate Result register */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } ALTR;
};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

struct AIPS_tag {
  union {                              /* Master Privilege Register A */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MTR0:1;                /* Master 0 Trusted For Read */
      vuint32_t MTW0:1;                /* Master 0 Trusted For Writes */
      vuint32_t MPL0:1;                /* Master 0 Privilege Level */
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t MTR2:1;                /* Master 2 Trusted For Read */
      vuint32_t MTW2:1;                /* Master 2 Trusted For Writes */
      vuint32_t MPL2:1;                /* Master 2 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR3:1;                /* Master 3 Trusted For Read */
      vuint32_t MTW3:1;                /* Master 3 Trusted For Writes */
      vuint32_t MPL3:1;                /* Master 3 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR4:1;                /* Master 4 Trusted For Read */
      vuint32_t MTW4:1;                /* Master 4 Trusted For Writes */
      vuint32_t MPL4:1;                /* Master 4 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR5:1;                /* Master 5 Trusted For Read */
      vuint32_t MTW5:1;                /* Master 5 Trusted For Writes */
      vuint32_t MPL5:1;                /* Master 5 Privilege Level */
      vuint32_t  :4;
      vuint32_t  :4;
    } B;
  } MPRA;

  uint8_t AIPS_reserved0[252];
  union {                              /* Peripheral Access Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SP0:1;                 /* Supervisor Protect */
      vuint32_t WP0:1;                 /* Write Protect */
      vuint32_t TP0:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP1:1;                 /* Supervisor Protect */
      vuint32_t WP1:1;                 /* Write Protect */
      vuint32_t TP1:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP2:1;                 /* Supervisor Protect */
      vuint32_t WP2:1;                 /* Write Protect */
      vuint32_t TP2:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP3:1;                 /* Supervisor Protect */
      vuint32_t WP3:1;                 /* Write Protect */
      vuint32_t TP3:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP4:1;                 /* Supervisor Protect */
      vuint32_t WP4:1;                 /* Write Protect */
      vuint32_t TP4:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP5:1;                 /* Supervisor Protect */
      vuint32_t WP5:1;                 /* Write Protect */
      vuint32_t TP5:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP6:1;                 /* Supervisor Protect */
      vuint32_t WP6:1;                 /* Write Protect */
      vuint32_t TP6:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP7:1;                 /* Supervisor Protect */
      vuint32_t WP7:1;                 /* Write Protect */
      vuint32_t TP7:1;                 /* Trusted Protect */
    } B;
  } PACR[8];

  uint8_t AIPS_reserved1[32];
  union {                              /* Off-Platform Peripheral Access Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SP0:1;                 /* Supervisor Protect */
      vuint32_t WP0:1;                 /* Write Protect */
      vuint32_t TP0:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP1:1;                 /* Supervisor Protect */
      vuint32_t WP1:1;                 /* Write Protect */
      vuint32_t TP1:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP2:1;                 /* Supervisor Protect */
      vuint32_t WP2:1;                 /* Write Protect */
      vuint32_t TP2:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP3:1;                 /* Supervisor Protect */
      vuint32_t WP3:1;                 /* Write Protect */
      vuint32_t TP3:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP4:1;                 /* Supervisor Protect */
      vuint32_t WP4:1;                 /* Write Protect */
      vuint32_t TP4:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP5:1;                 /* Supervisor Protect */
      vuint32_t WP5:1;                 /* Write Protect */
      vuint32_t TP5:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP6:1;                 /* Supervisor Protect */
      vuint32_t WP6:1;                 /* Write Protect */
      vuint32_t TP6:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP7:1;                 /* Supervisor Protect */
      vuint32_t WP7:1;                 /* Write Protect */
      vuint32_t TP7:1;                 /* Trusted Protect */
    } B;
  } OPACR[32];
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

struct C55FMC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t RVE:1;                 /* Read Voltage Error */
      vuint32_t RRE:1;                 /* Read Reference Error */
      vuint32_t AEE:1;                 /* Address Encode Error */
      vuint32_t EEE:1;                 /* ECC after ECC Error */
      vuint32_t  :12;
      vuint32_t EER:1;                 /* ECC Event Error */
      vuint32_t RWE:1;                 /* Read-While-Write Event Error */
      vuint32_t SBC:1;                 /* Single Bit Correction */
      vuint32_t  :1;
      vuint32_t PEAS:1;                /* Program Access Space */
      vuint32_t DONE:1;                /* State Machine Status */
      vuint32_t PEG:1;                 /* Program/Erase Good */
      vuint32_t PECIE:1;               /* Program/Erase Complete Interrupt Enable */
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t PGM:1;                 /* Program */
      vuint32_t PSUS:1;                /* Program Suspend */
      vuint32_t ERS:1;                 /* Erase */
      vuint32_t ESUS:1;                /* Erase Suspend */
      vuint32_t EHV:1;                 /* Enable High Voltage */
    } B;
  } MCR;

  uint8_t C55FMC_reserved0[4];
  union {                              /* Extended Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t HT:1;                  /* High Temperature Enabled. */
      vuint32_t  :2;
      vuint32_t n256K:5;
      vuint32_t n64Kh:3;
      vuint32_t n32Kh:2;
      vuint32_t n16Kh:3;
      vuint32_t n64Km:3;
      vuint32_t n32Km:2;
      vuint32_t n16Km:3;
      vuint32_t n64Kl:3;
      vuint32_t n32Kl:2;
      vuint32_t n16Kl:3;
    } B;
  } MCRE;

  uint8_t C55FMC_reserved1[4];
  union {                              /* Lock 0 register */
    vuint32_t R;
    struct {
      vuint32_t TSLOCK:1;              /* UTest NVM Lock. */
      vuint32_t  :1;
      vuint32_t LOWLOCK:14;            /* Low Block Lock */
      vuint32_t MIDLOCK:16;            /* Mid Block Lock */
    } B;
  } LOCK0;

  union {                              /* Lock 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHLOCK:16;           /* High Block Lock */
    } B;
  } LOCK1;

  union {                              /* Lock 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KLOCK:32;          /* 256 KB Block Lock */
    } B;
  } LOCK2;

  union {                              /* Lock 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KLOCK:16;          /* 256 KB Block Lock */
    } B;
  } LOCK3;

  uint8_t C55FMC_reserved2[24];
  union {                              /* Select 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t LOWSEL:14;             /* LOW Block Select. */
      vuint32_t MIDSEL:16;             /* Mid Block Select. */
    } B;
  } SEL0;

  union {                              /* Select 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHSEL:16;            /* High Block Select. */
    } B;
  } SEL1;

  union {                              /* Select 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KSEL:32;           /* 256 KB Block Select. */
    } B;
  } SEL2;

  union {                              /* Select 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KSEL:16;           /* 256 KB Block Select. */
    } B;
  } SEL3;

  uint8_t C55FMC_reserved3[8];
  union {                              /* Address register */
    vuint32_t R;
    struct {
      vuint32_t SAD:1;
      vuint32_t aH:1;
      vuint32_t aM:1;
      vuint32_t aL:1;
      vuint32_t a256k:1;
      vuint32_t a64k:1;
      vuint32_t a32k:1;
      vuint32_t a16k:1;
      vuint32_t ADDR:21;
      vuint32_t  :3;
    } B;
  } ADR;

  union {                              /* UTest 0 register */
    vuint32_t R;
    struct {
      vuint32_t UTE:1;
      vuint32_t SBCE:1;
      vuint32_t  :11;
      vuint32_t CPR:1;
      vuint32_t CPA:1;
      vuint32_t CPE:1;
      vuint32_t  :6;
      vuint32_t NAIBP:1;
      vuint32_t AIBPE:1;
      vuint32_t  :1;
      vuint32_t AISUS:1;
      vuint32_t MRE:1;
      vuint32_t MRV:1;
      vuint32_t  :1;
      vuint32_t AIS:1;
      vuint32_t AIE:1;
      vuint32_t AID:1;
    } B;
  } UT0;

  union {                              /* UMISR register */
    vuint32_t R;
    struct {
      vuint32_t MISR:32;
    } B;
  } UM[9];

  union {                              /* UMISR register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t MISR:1;                /* MISR[288]. */
    } B;
  } UM9;

  union {                              /* Over-Program Protection 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t LOWOPP:14;             /* Low Block Over-Program Protection[13:0]. */
      vuint32_t MIDOPP:16;             /* Mid Block Over-Program Protection[15:0]. */
    } B;
  } OPP0;

  union {                              /* Over-Program Protection 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHOPP:16;            /* High Block Over-Program Protection[15:0]. */
    } B;
  } OPP1;

  union {                              /* Over-Program Protection 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KOPP:32;           /* 256K Block Over-Program Protection[31:0]. */
    } B;
  } OPP2;

  union {                              /* Over-Program Protection 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KOPP:16;           /* 256K Block Over-Program Protection[47:32]. */
    } B;
  } OPP3;
};


/* ============================================================================
   =============================== Module: CAN ================================
   ============================================================================ */

struct CAN_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze Enable */
      vuint32_t RFEN:1;                /* Rx FIFO Enable */
      vuint32_t HALT:1;                /* Halt FlexCAN */
      vuint32_t NOTRDY:1;              /* FlexCAN Not Ready */
      vuint32_t  :1;
      vuint32_t SOFTRST:1;             /* Soft Reset */
      vuint32_t FRZACK:1;              /* Freeze Mode Acknowledge */
      vuint32_t SUPV:1;                /* Supervisor Mode */
      vuint32_t  :1;
      vuint32_t WRNEN:1;               /* Warning Interrupt Enable */
      vuint32_t LPMACK:1;              /* Low-Power Mode Acknowledge */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t SRXDIS:1;              /* Self Reception Disable */
      vuint32_t IRMQ:1;                /* Individual Rx Masking And Queue Enable */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LPRIOEN:1;             /* Local Priority Enable */
      vuint32_t AEN:1;                 /* Abort Enable */
      vuint32_t  :2;
      vuint32_t IDAM:2;                /* ID Acceptance Mode */
      vuint32_t  :1;
      vuint32_t MAXMB:7;               /* Number Of The Last Message Buffer */
    } B;
  } MCR;

  union {                              /* Control 1 register */
    vuint32_t R;
    struct {
      vuint32_t PRESDIV:8;             /* Prescaler Division Factor */
      vuint32_t RJW:2;                 /* Resync Jump Width */
      vuint32_t PSEG1:3;               /* Phase Segment 1 */
      vuint32_t PSEG2:3;               /* Phase Segment 2 */
      vuint32_t BOFFMSK:1;             /* Bus Off Mask */
      vuint32_t ERRMSK:1;              /* Error Mask */
      vuint32_t CLKSRC:1;              /* CAN Engine Clock Source */
      vuint32_t LPB:1;                 /* Loop Back Mode */
      vuint32_t TWRNMSK:1;             /* Tx Warning Interrupt Mask */
      vuint32_t RWRNMSK:1;             /* Rx Warning Interrupt Mask */
      vuint32_t  :2;
      vuint32_t SMP:1;                 /* CAN Bit Sampling */
      vuint32_t BOFFREC:1;             /* Bus Off Recovery */
      vuint32_t TSYN:1;                /* Timer Sync */
      vuint32_t LBUF:1;                /* Lowest Buffer Transmitted First */
      vuint32_t LOM:1;                 /* Listen-Only Mode */
      vuint32_t PROPSEG:3;             /* Propagation Segment */
    } B;
  } CTRL1;

  union {                              /* Free Running Timer */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TIMER:16;              /* Timer Value */
    } B;
  } TIMER;

  uint8_t CAN_reserved0[4];
  union {                              /* Rx Mailboxes Global Mask Register */
    vuint32_t R;
    struct {
      vuint32_t MG:32;                 /* Rx Mailboxes Global Mask Bits */
    } B;
  } RXMGMASK;

  union {                              /* Rx 14 Mask register */
    vuint32_t R;
    struct {
      vuint32_t RX14M:32;              /* Rx Buffer 14 Mask Bits */
    } B;
  } RX14MASK;

  union {                              /* Rx 15 Mask register */
    vuint32_t R;
    struct {
      vuint32_t RX15M:32;              /* Rx Buffer 15 Mask Bits */
    } B;
  } RX15MASK;

  union {                              /* Error Counter */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RXERRCNT:8;            /* Receive Error Counter */
      vuint32_t TXERRCNT:8;            /* Transmit Error Counter */
    } B;
  } ECR;

  union {                              /* Error and Status 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SYNCH:1;               /* CAN Synchronization Status */
      vuint32_t TWRNINT:1;             /* Tx Warning Interrupt Flag */
      vuint32_t RWRNINT:1;             /* Rx Warning Interrupt Flag */
      vuint32_t BIT1ERR:1;             /* Bit1 Error */
      vuint32_t BIT0ERR:1;             /* Bit0 Error */
      vuint32_t ACKERR:1;              /* Acknowledge Error */
      vuint32_t CRCERR:1;              /* Cyclic Redundancy Check Error */
      vuint32_t FRMERR:1;              /* Form Error */
      vuint32_t STFERR:1;              /* Stuffing Error */
      vuint32_t TXWRN:1;               /* TX Error Warning */
      vuint32_t RXWRN:1;               /* Rx Error Warning */
      vuint32_t IDLE:1;
      vuint32_t TX:1;                  /* FlexCAN In Transmission */
      vuint32_t FLTCONF:2;             /* Fault Confinement State */
      vuint32_t RX:1;                  /* FlexCAN In Reception */
      vuint32_t BOFFINT:1;             /* Bus Off Interrupt */
      vuint32_t ERRINT:1;              /* Error Interrupt */
      vuint32_t  :1;
    } B;
  } ESR1;

  union {                              /* Interrupt Masks 2 register */
    vuint32_t R;
    struct {
      vuint32_t BUFHM:32;              /* Buffer MB i Mask */
    } B;
  } IMASK2;

  union {                              /* Interrupt Masks 1 register */
    vuint32_t R;
    struct {
      vuint32_t BUFLM:32;              /* Buffer MB i Mask */
    } B;
  } IMASK1;

  union {                              /* Interrupt Flags 2 register */
    vuint32_t R;
    struct {
      vuint32_t BUFHI:32;              /* Buffer MB i Interrupt */
    } B;
  } IFLAG2;

  union {                              /* Interrupt Flags 1 register */
    vuint32_t R;
    struct {
      vuint32_t BUF31TO8I:24;          /* Buffer MBi Interrupt */
      vuint32_t BUF7I:1;               /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
      vuint32_t BUF6I:1;               /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
      vuint32_t BUF5I:1;               /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
      vuint32_t BUF4TO1I:4;            /* Buffer MB i Interrupt Or "reserved" */
      vuint32_t BUF0I:1;               /* Buffer MB0 Interrupt Or "reserved" */
    } B;
  } IFLAG1;

  union {                              /* Control 2 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t ECRWRE:1;              /* Error-correction Configuration Register Write Enable */
      vuint32_t WRMFRZ:1;              /* Write-Access To Memory In Freeze Mode */
      vuint32_t RFFN:4;                /* Number Of Rx FIFO Filters */
      vuint32_t TASD:5;                /* Tx Arbitration Start Delay */
      vuint32_t MRP:1;                 /* Mailboxes Reception Priority */
      vuint32_t RRS:1;                 /* Remote Request Storing */
      vuint32_t EACEN:1;               /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
      vuint32_t  :16;
    } B;
  } CTRL2;

  union {                              /* Error and Status 2 register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t LPTM:7;                /* Lowest Priority Tx Mailbox */
      vuint32_t  :1;
      vuint32_t VPS:1;                 /* Valid Priority Status */
      vuint32_t IMB:1;                 /* Inactive Mailbox */
      vuint32_t  :13;
    } B;
  } ESR2;

  uint8_t CAN_reserved1[8];
  union {                              /* CRC Register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t MBCRC:7;               /* CRC Mailbox */
      vuint32_t  :1;
      vuint32_t TXCRC:15;              /* CRC Transmitted */
    } B;
  } CRCR;

  union {                              /* Rx FIFO Global Mask register */
    vuint32_t R;
    struct {
      vuint32_t FGM:32;                /* Rx FIFO Global Mask Bits */
    } B;
  } RXFGMASK;

  union {                              /* Rx FIFO Information Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t IDHIT:9;               /* Identifier Acceptance Filter Hit Indicator */
    } B;
  } RXFIR;

  uint8_t CAN_reserved2[48];
  struct {
    union {                            /* Message Buffer 0 CS Register */
      vuint32_t R;
      struct {
        vuint32_t  :4;
        vuint32_t CODE:4;              /* Message Buffer Code */
        vuint32_t  :1;
        vuint32_t SRR:1;               /* Substitute Remote Request. Contains a fixed recessive bit. */
        vuint32_t IDE:1;               /* ID Extended. One/zero for extended/standard format frame. */
        vuint32_t RTR:1;               /* Remote Transmission Request. One/zero for remote/data frame. */
        vuint32_t DLC:4;               /* Length of the data to be stored/transmitted. */
        vuint32_t TIMESTAMP:16;        /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
      } B;
    } CS;
    union {                            /* Message Buffer 0 ID Register */
      vuint32_t R;
      struct {
        vuint32_t PRIO:3;              /* Local Priority */
        vuint32_t ID_STD:11;           /* Frame Identifier Standard */
        vuint32_t ID_EXT:18;           /* Frame Identifier Extended */
      } B;
    } ID;
    union {
      vuint8_t B[8];
      vuint16_t H[4];
      vuint32_t W[2];
    } DATA;
  } MB[64];

  uint8_t CAN_reserved3[1024];
  union {                              /* Rx Individual Mask Registers */
    vuint32_t R;
    struct {
      vuint32_t MI:32;                 /* Individual Mask Bits */
    } B;
  } RXIMR[64];

  uint8_t CAN_reserved4[352];
  union {                              /* Memory Error Control Register */
    vuint32_t R;
    struct {
      vuint32_t ECRWRDIS:1;            /* Error Configuration Register Write Disable */
      vuint32_t  :14;
      vuint32_t CEI_MSK:1;             /* Correctable Errors Interrupt Mask */
      vuint32_t HAERRIE:1;             /* Host Access Error Injection Enable */
      vuint32_t FAERRIE:1;             /* FlexCAN Access Error Injection Enable */
      vuint32_t EXTERRIE:1;            /* Extended Error Injection Enable */
      vuint32_t  :3;
      vuint32_t RERRDIS:1;             /* Error Report Disable */
      vuint32_t ECCDIS:1;              /* Error Correction Disable */
      vuint32_t NCEFAFRZ:1;            /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
      vuint32_t  :7;
    } B;
  } MECR;

  union {                              /* Error Injection Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t INJADDR:14;            /* Address Where Error Is To Be Injected */
    } B;
  } ERRIAR;

  union {                              /* Error Injection Data Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t DFLIP:32;              /* Data flip pattern */
    } B;
  } ERRIDPR;

  union {                              /* Error Injection Parity Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t PFLIP3:5;              /* Parity Flip Pattern For Byte 3 (most significant) */
      vuint32_t  :3;
      vuint32_t PFLIP2:5;              /* Parity Flip Pattern For Byte 2 */
      vuint32_t  :3;
      vuint32_t PFLIP1:5;              /* Parity Flip Pattern For Byte 1 */
      vuint32_t  :3;
      vuint32_t PFLIP0:5;              /* Parity Flip Pattern For Byte 0 (Least Significant) */
    } B;
  } ERRIPPR;

  union {                              /* Error Report Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t NCE:1;                 /* Non-Correctable Error */
      vuint32_t  :5;
      vuint32_t SAID:3;
      vuint32_t  :2;
      vuint32_t ERRADDR:14;            /* Address Where The Error Was Detected */
    } B;
  } RERRAR;

  union {                              /* Error Report Data Register */
    vuint32_t R;
    struct {
      vuint32_t RDATA:32;              /* Raw data word read from memory with error */
    } B;
  } RERRDR;

  union {                              /* Error Report Syndrome Register */
    vuint32_t R;
    struct {
      vuint32_t BE3:1;                 /* Byte Enabled For Byte 3 (Most Significant) */
      vuint32_t  :2;
      vuint32_t SYND3:5;               /* Error Syndrome For Byte 3 (Most Significant) */
      vuint32_t BE2:1;                 /* Byte Enabled For Byte 2 */
      vuint32_t  :2;
      vuint32_t SYND2:5;               /* Error Syndrome For Byte 2 */
      vuint32_t BE1:1;                 /* Byte Enabled For Byte 1 */
      vuint32_t  :2;
      vuint32_t SYND1:5;               /* Error Syndrome for Byte 1 */
      vuint32_t BE0:1;                 /* Byte Enabled For Byte 0 (least significant) */
      vuint32_t  :2;
      vuint32_t SYND0:5;               /* Error Syndrome For Byte 0 (least significant) */
    } B;
  } RERRSYNR;

  union {                              /* Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t HANCEIF:1;             /* Host Access With Non-Correctable Error Interrupt Flag */
      vuint32_t FANCEIF:1;             /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
      vuint32_t  :1;
      vuint32_t CEIF:1;                /* Correctable Error Interrupt Flag */
      vuint32_t  :12;
      vuint32_t HANCEIOF:1;            /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
      vuint32_t FANCEIOF:1;            /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
      vuint32_t  :1;
      vuint32_t CEIOF:1;               /* Correctable Error Interrupt Overrun Flag */
    } B;
  } ERRSR;
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

struct CMU_tag {
  union {                              /* CMU Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SFM:1;                 /* Start frequency measure. */
      vuint32_t  :13;
      vuint32_t CKSEL1:2;              /* Frequency measure clock selection bit. */
      vuint32_t  :5;
      vuint32_t RCDIV:2;               /* CLKMT0_RMN division factor. */
      vuint32_t CME:1;                 /* CLKMN1 monitor enable. */
    } B;
  } CSR;

  union {                              /* CMU Frequency Display Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t FD:20;                 /* Measured frequency bits. */
    } B;
  } FDR;

  union {                              /* CMU High Frequency Reference Register CLKMN1 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t HFREF:12;              /* High Frequency reference value. */
    } B;
  } HFREFR;

  union {                              /* CMU Low Frequency Reference Register CLKMN1 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t LFREF:12;              /* Low Frequency reference value. */
    } B;
  } LFREFR;

  union {                              /* CMU Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t  :1;
      vuint32_t FHHI:1;                /* CLKMN1 frequency higher than high reference event status. */
      vuint32_t FLLI:1;                /* CLKMN1 frequency less than low reference event status. */
      vuint32_t OLRI:1;                /* Oscillator frequency less than f CLKMT0_RMN * 2RCDIVevent status. */
    } B;
  } ISR;

  uint8_t CMU_reserved0[4];
  union {                              /* CMU Measurement Duration Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t MD:20;                 /* Measurement duration bits */
    } B;
  } MDR;
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

struct CRC_tag {
  struct {
    union {                            /* Configuration Register */
      vuint32_t R;
      struct {
        vuint32_t  :8;
        vuint32_t  :18;
        vuint32_t  :2;
        vuint32_t POLYG:2;             /* Polynomial selection */
        vuint32_t SWAP:1;              /* Swap selection */
        vuint32_t INV:1;               /* Inversion selection */
      } B;
    } CFG;
    union {                            /* Input Register */
      vuint32_t R;
      struct {
        vuint32_t INP:32;              /* Input data for the CRC computation */
      } B;
    } INP;
    union {                            /* Current Status Register */
      vuint32_t R;
      struct {
        vuint32_t CSTAT:32;            /* CRC signature status */
      } B;
    } CSTAT;
    union {                            /* Output Register */
      vuint32_t R;
      struct {
        vuint32_t OUTP:32;             /* Final CRC signature */
      } B;
    } OUTP;
  } CHANNEL[3];
};


/* ============================================================================
   =============================== Module: CTU ================================
   ============================================================================ */

struct CTU_tag {
  union {                              /* Trigger Generator Subunit Input Selection Register */
    vuint32_t R;
    struct {
      vuint32_t I15_FE:1;              /* Input 15 Falling Edge Enable. */
      vuint32_t I15_RE:1;              /* Input 15 Rising Edge Enable. */
      vuint32_t I14_FE:1;              /* Input 14 Falling Edge Enable. */
      vuint32_t I14_RE:1;              /* Input 14 Rising Edge Enable. */
      vuint32_t I13_FE:1;              /* Input 13 Falling Edge Enable. */
      vuint32_t I13_RE:1;              /* Input 13 Rising Edge Enable. */
      vuint32_t I12_FE:1;              /* Input 12 Falling Edge Enable. */
      vuint32_t I12_RE:1;              /* Input 12 Rising Edge Enable. */
      vuint32_t I11_FE:1;              /* Input 11 Falling Edge Enable. */
      vuint32_t I11_RE:1;              /* Input 11 Rising Edge Enable. */
      vuint32_t I10_FE:1;              /* Input 10 Falling Edge Enable. */
      vuint32_t I10_RE:1;              /* Input 10 Rising Edge Enable. */
      vuint32_t I9_FE:1;               /* Input 9 Falling Edge Enable. */
      vuint32_t I9_RE:1;               /* Input 9 Rising Edge Enable. */
      vuint32_t I8_FE:1;               /* Input 8 Falling Edge Enable. */
      vuint32_t I8_RE:1;               /* Input 8 Rising Edge Enable. */
      vuint32_t I7_FE:1;               /* Input 7 Falling Edge Enable. */
      vuint32_t I7_RE:1;               /* Input 7 Rising Edge Enable. */
      vuint32_t I6_FE:1;               /* Input 6 Falling Edge Enable. */
      vuint32_t I6_RE:1;               /* Input 6 Rising Edge Enable. */
      vuint32_t I5_FE:1;               /* Input 5 Falling Edge Enable. */
      vuint32_t I5_RE:1;               /* Input 5 Rising Edge Enable. */
      vuint32_t I4_FE:1;               /* Input 4 Falling Edge Enable. */
      vuint32_t I4_RE:1;               /* Input 4 Rising Edge Enable. */
      vuint32_t I3_FE:1;               /* Input 3 Falling Edge Enable. */
      vuint32_t I3_RE:1;               /* Input 3 Rising edge Enable */
      vuint32_t I2_FE:1;               /* Input 2 Falling Edge Enable. */
      vuint32_t I2_RE:1;               /* Input 2 Rising Edge Enable. */
      vuint32_t I1_FE:1;               /* Input 1 Falling Edge Enable. */
      vuint32_t I1_RE:1;               /* Input 1 Rising edge Enable */
      vuint32_t I0_FE:1;               /* Input 0 Falling Edge Enable. */
      vuint32_t I0_RE:1;               /* Input 0 Rising Edge Enable. */
    } B;
  } TGSISR;

  union {                              /* Trigger Generator Subunit Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :7;
      vuint16_t ET_TM:1;
      vuint16_t PRES:2;
      vuint16_t MRS_SM:5;
      vuint16_t TGS_M:1;
    } B;
  } TGSCR;

  union {                              /* Trigger Compare Register */
    vuint16_t R;
    struct {
      vuint16_t TCRV:16;
    } B;
  } TCR[8];

  union {                              /* TGS Counter Compare Register */
    vuint16_t R;
    struct {
      vuint16_t TGSCCV:16;
    } B;
  } TGSCCR;

  union {                              /* TGS Counter Reload Register */
    vuint16_t R;
    struct {
      vuint16_t TGSCRV:16;
    } B;
  } TGSCRR;

  uint8_t CTU_reserved0[2];
  union {                              /* Commands List Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t T3_INDEX:5;
      vuint32_t  :3;
      vuint32_t T2_INDEX:5;
      vuint32_t  :3;
      vuint32_t T1_INDEX:5;
      vuint32_t  :3;
      vuint32_t T0_INDEX:5;
    } B;
  } CLCR1;

  union {                              /* Commands List Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t T7_INDEX:5;
      vuint32_t  :3;
      vuint32_t T6_INDEX:5;
      vuint32_t  :3;
      vuint32_t T5_INDEX:5;
      vuint32_t  :3;
      vuint32_t T4_INDEX:5;
    } B;
  } CLCR2;

  union {                              /* Trigger Handler Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t T3_E:1;
      vuint32_t T3_ETE:1;
      vuint32_t T3_T4E:1;
      vuint32_t T3_T3E:1;
      vuint32_t T3_T2E:1;
      vuint32_t T3_T1E:1;
      vuint32_t T3_ADCE:1;
      vuint32_t  :1;
      vuint32_t T2_E:1;
      vuint32_t T2_ETE:1;
      vuint32_t T2_T4E:1;
      vuint32_t T2_T3E:1;
      vuint32_t T2_T2E:1;
      vuint32_t T2_T1E:1;
      vuint32_t T2_ADCE:1;
      vuint32_t  :1;
      vuint32_t T1_E:1;
      vuint32_t T1_ETE:1;
      vuint32_t T1_T4E:1;
      vuint32_t T1_T3E:1;
      vuint32_t T1_T2E:1;
      vuint32_t T1_T1E:1;
      vuint32_t T1_ADCE:1;
      vuint32_t  :1;
      vuint32_t T0_E:1;
      vuint32_t T0_ETE:1;
      vuint32_t T0_T4E:1;
      vuint32_t T0_T3E:1;
      vuint32_t T0_T2E:1;
      vuint32_t T0_T1E:1;
      vuint32_t T0_ADCE:1;
    } B;
  } THCR1;

  union {                              /* Trigger Handler Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t T7_E:1;
      vuint32_t T7_ETE:1;
      vuint32_t T7_T4E:1;
      vuint32_t T7_T3E:1;
      vuint32_t T7_T2E:1;
      vuint32_t T7_T1E:1;
      vuint32_t T7_ADCE:1;
      vuint32_t  :1;
      vuint32_t T6_E:1;
      vuint32_t T6_ETE:1;
      vuint32_t T6_T4E:1;
      vuint32_t T6_T3E:1;
      vuint32_t T6_T2E:1;
      vuint32_t T6_T1E:1;
      vuint32_t T6_ADCE:1;
      vuint32_t  :1;
      vuint32_t T5_E:1;
      vuint32_t T5_ETE:1;
      vuint32_t T5_T4E:1;
      vuint32_t T5_T3E:1;
      vuint32_t T5_T2E:1;
      vuint32_t T5_T1E:1;
      vuint32_t T5_ADCE:1;
      vuint32_t  :1;
      vuint32_t T4_E:1;
      vuint32_t T4_ETE:1;
      vuint32_t T4_T4E:1;
      vuint32_t T4_T3E:1;
      vuint32_t T4_T2E:1;
      vuint32_t T4_T1E:1;
      vuint32_t T4_ADCE:1;
    } B;
  } THCR2;

  union {
    union {                            /* Commands List Register A for ADC single-conversion mode commands */
      vuint16_t R;
      struct {
        vuint16_t CIR:1;
        vuint16_t LC:1;
        vuint16_t CMS:1;
        vuint16_t FIFO:3;              /* FIFO used for ADC Port A / Port B. */
        vuint16_t ST0:1;
        vuint16_t  :3;
        vuint16_t SU:1;                /* ADC Port A / Port B selection. */
        vuint16_t  :1;
        vuint16_t CH:4;                /* ADC Port channel number. */
      } B;
    } A;
    union {                            /* Command List Register B for ADC dual-conversion mode commands */
      vuint16_t R;
      struct {
        vuint16_t CIR:1;
        vuint16_t LC:1;
        vuint16_t CMS:1;
        vuint16_t FIFO:3;              /* FIFO used for ADC Port A / Port B. */
        vuint16_t ST0:1;               /* Sel-Test mode control 0. Must be 0 in this register format. */
        vuint16_t CH_B:4;              /* ADC Port B channel number. */
        vuint16_t  :1;                 /* Reserved. */
        vuint16_t CH_A:4;              /* ADC Port A channel number. */
      } B;
    } B;
    union {                            /* Command List Register C for self-test commands */
      vuint16_t R;
      struct {
        vuint16_t CIR:1;
        vuint16_t LC:1;
        vuint16_t ST1:1;
        vuint16_t ST_CMS:1;
        vuint16_t ST_SU:1;
        vuint16_t  :1;
        vuint16_t ST0:1;
        vuint16_t ALG:2;
        vuint16_t BSIZE:7;
      } B;
    } C;
  } CLR[24];

  uint8_t CTU_reserved1[16];
  union {                              /* FIFO DMA Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :4;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :4;
      vuint16_t DE3:1;
      vuint16_t DE2:1;
      vuint16_t DE1:1;
      vuint16_t DE0:1;
    } B;
  } FDCR;

  uint8_t CTU_reserved2[2];
  union {                              /* FIFO Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OR_EN3:1;
      vuint32_t OF_EN3:1;
      vuint32_t EMPTY_EN3:1;
      vuint32_t FULL_EN3:1;
      vuint32_t OR_EN2:1;
      vuint32_t OF_EN2:1;
      vuint32_t EMPTY_EN2:1;
      vuint32_t FULL_EN2:1;
      vuint32_t OR_EN1:1;
      vuint32_t OF_EN1:1;
      vuint32_t EMPTY_EN1:1;
      vuint32_t FULL_EN1:1;
      vuint32_t OR_EN0:1;
      vuint32_t OF_EN0:1;
      vuint32_t EMPTY_EN0:1;
      vuint32_t FULL_EN0:1;
    } B;
  } FCR;

  union {                              /* FIFO Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t TH3:8;
      vuint32_t TH2:8;
      vuint32_t TH1:8;
      vuint32_t TH0:8;
    } B;
  } FTH;

  uint8_t CTU_reserved3[4];
  union {                              /* FIFO Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OR3:1;
      vuint32_t OF3:1;
      vuint32_t EMP3:1;
      vuint32_t FULL3:1;
      vuint32_t OR2:1;
      vuint32_t OF2:1;
      vuint32_t EMP2:1;
      vuint32_t FULL2:1;
      vuint32_t OR1:1;
      vuint32_t OF1:1;
      vuint32_t EMP1:1;
      vuint32_t FULL1:1;
      vuint32_t OR0:1;
      vuint32_t OF0:1;
      vuint32_t EMP0:1;
      vuint32_t FULL0:1;
    } B;
  } FST;

  union {                              /* FIFO Right Aligned Data Register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t ADC:1;                 /* This bit indicates from which ADC Port the value in the DATA field corresponds to. */
      vuint32_t N_CH:4;
      vuint32_t  :4;
      vuint32_t DATA:12;
    } B;
  } FR[4];

  uint8_t CTU_reserved4[16];
  union {                              /* FIFO Signed Left Aligned Data Register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t ADC:1;                 /* This bit indicates from which ADC Port the value in the DATA field corresponds to. */
      vuint32_t N_CH:4;
      vuint32_t  :1;
      vuint32_t LA_DATA:12;
      vuint32_t  :3;
    } B;
  } FL[4];

  uint8_t CTU_reserved5[16];
  union {                              /* Error Flag Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t LIST_BE:1;
      vuint16_t CS:1;
      vuint16_t ET_OE:1;
      vuint16_t ERRCMP:1;
      vuint16_t T4_OE:1;
      vuint16_t T3_OE:1;
      vuint16_t T2_OE:1;
      vuint16_t T1_OE:1;
      vuint16_t ADC_OE:1;
      vuint16_t TGS_OSM:1;
      vuint16_t MRS_O:1;
      vuint16_t ICE:1;
      vuint16_t SM_TO:1;
      vuint16_t MRS_RE:1;
    } B;
  } EFR;

  union {                              /* Interrupt Flag Register */
    vuint16_t R;
    struct {
      vuint16_t  :4;
      vuint16_t SERR_B:1;
      vuint16_t SERR_A:1;
      vuint16_t ADC_I:1;
      vuint16_t T7_I:1;
      vuint16_t T6_I:1;
      vuint16_t T5_I:1;
      vuint16_t T4_I:1;
      vuint16_t T3_I:1;
      vuint16_t T2_I:1;
      vuint16_t T1_I:1;
      vuint16_t T0_I:1;
      vuint16_t MRS_I:1;
    } B;
  } IFR;

  union {                              /* Interrupt/DMA Register */
    vuint16_t R;
    struct {
      vuint16_t T7_IE:1;
      vuint16_t T6_IE:1;
      vuint16_t T5_IE:1;
      vuint16_t T4_IE:1;
      vuint16_t T3_IE:1;
      vuint16_t T2_IE:1;
      vuint16_t T1_IE:1;
      vuint16_t T0_IE:1;
      vuint16_t  :2;
      vuint16_t SAF_CNT_B_EN:1;        /* Enable the ADC Port B counter to check the conversion time. */
      vuint16_t SAF_CNT_A_EN:1;        /* Enable the ADC Port A counter to check the conversion time. */
      vuint16_t DMA_DE:1;
      vuint16_t MRS_DMAE:1;
      vuint16_t MRS_IE:1;
      vuint16_t IEE:1;
    } B;
  } IR;

  union {                              /* Control ON Time Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t COTGT:8;
    } B;
  } COTR;

  union {                              /* Control Register */
    vuint16_t R;
    struct {
      vuint16_t T7_SG:1;
      vuint16_t T6_SG:1;
      vuint16_t T5_SG:1;
      vuint16_t T4_SG:1;
      vuint16_t T3_SG:1;
      vuint16_t T2_SG:1;
      vuint16_t T1_SG:1;
      vuint16_t T0_SG:1;
      vuint16_t CTU_ADC_R:1;
      vuint16_t CTU_ODIS:1;
      vuint16_t DFE:1;
      vuint16_t CGRE:1;
      vuint16_t FGRE:1;
      vuint16_t MRS_SG:1;
      vuint16_t GRE:1;
      vuint16_t TGSISR_RE:1;
    } B;
  } CR;

  union {                              /* Digital Filter Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t FILTER_N:8;
    } B;
  } DFR;

  union {                              /* Expected Value A Register */
    vuint16_t R;
    struct {
      vuint16_t EXPA:16;               /* This value is the maximum number of system clock cycles needed by ADC Port A in order to complete a conversion. */
    } B;
  } EXPAR;

  union {                              /* Expected Value B Register */
    vuint16_t R;
    struct {
      vuint16_t EXPB:16;               /* This value is the maximum number of system clock cycles needed by ADC Port B in order to complete a conversion. */
    } B;
  } EXPBR;

  union {                              /* Counter Range Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t CNTRNG:8;
    } B;
  } CNTRNGR;

  uint8_t CTU_reserved6[2];
  union {                              /* List Control/Status Register */
    vuint32_t R;
    struct {
      vuint32_t LIST1_BLK:1;
      vuint32_t  :2;
      vuint32_t LIST1_ADDR:5;
      vuint32_t LIST0_BLK:1;
      vuint32_t  :2;
      vuint32_t LIST0_ADDR:5;          /* List Address 0, indicates the command address being executed when LIST_BE flag in EFR register bit was set. */
      vuint32_t  :15;
      vuint32_t PAR_LIST:1;
    } B;
  } LISTCSR;
};


/* ============================================================================
   =============================== Module: DCL ================================
   ============================================================================ */

struct DCL_tag {
//  uint8_t DCL_reserved0[4290773252];
  union {                              /* Different Clock register */
    vuint32_t R;
    struct {
      vuint32_t DCL_IPS:32;
    } B;
  } IPS0;
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

struct DMAMUX_tag {
  union {                              /* Channel Configuration register */
    vuint8_t R;
    struct {
      vuint8_t ENBL:1;                 /* DMA Channel Enable */
      vuint8_t TRIG:1;                 /* DMA Channel Trigger Enable */
      vuint8_t SOURCE:6;               /* DMA Channel Source (Slot) */
    } B;
  } CHCFG[16];
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

struct DMA_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t CX:1;                  /* Cancel Transfer */
      vuint32_t ECX:1;                 /* Error Cancel Transfer */
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t GRP1PRI:1;             /* Channel Group 1 Priority */
      vuint32_t  :1;
      vuint32_t GRP0PRI:1;             /* Channel Group 0 Priority */
      vuint32_t EMLM:1;                /* Enable Minor Loop Mapping */
      vuint32_t CLM:1;                 /* Continuous Link Mode */
      vuint32_t HALT:1;                /* Halt DMA Operations */
      vuint32_t HOE:1;                 /* Halt On Error */
      vuint32_t ERGA:1;                /* Enable Round Robin Group Arbitration */
      vuint32_t ERCA:1;                /* Enable Round Robin Channel Arbitration */
      vuint32_t EDBG:1;                /* Enable Debug */
      vuint32_t  :1;
    } B;
  } CR;

  union {                              /* Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :13;
      vuint32_t UCE:1;                 /* Uncorrectable ECC error during channel execution. */
      vuint32_t ECX:1;                 /* Transfer Canceled */
      vuint32_t GPE:1;                 /* Group Priority Error */
      vuint32_t CPE:1;                 /* Channel Priority Error */
      vuint32_t  :1;
      vuint32_t ERRCHN:5;              /* Error Channel Number or Canceled Channel Number */
      vuint32_t SAE:1;                 /* Source Address Error */
      vuint32_t SOE:1;                 /* Source Offset Error */
      vuint32_t DAE:1;                 /* Destination Address Error */
      vuint32_t DOE:1;                 /* Destination Offset Error */
      vuint32_t NCE:1;                 /* NBYTES/CITER Configuration Error */
      vuint32_t SGE:1;                 /* Scatter/Gather Configuration Error */
      vuint32_t SBE:1;                 /* Source Bus Error */
      vuint32_t DBE:1;                 /* Destination Bus Error */
    } B;
  } ES;

  uint8_t DMA_reserved0[4];
  union {                              /* Enable Request Register */
    vuint32_t R;
    struct {
      vuint32_t ERQ31:1;               /* Enable DMA Request 31 */
      vuint32_t ERQ30:1;               /* Enable DMA Request 30 */
      vuint32_t ERQ29:1;               /* Enable DMA Request 29 */
      vuint32_t ERQ28:1;               /* Enable DMA Request 28 */
      vuint32_t ERQ27:1;               /* Enable DMA Request 27 */
      vuint32_t ERQ26:1;               /* Enable DMA Request 26 */
      vuint32_t ERQ25:1;               /* Enable DMA Request 25 */
      vuint32_t ERQ24:1;               /* Enable DMA Request 24 */
      vuint32_t ERQ23:1;               /* Enable DMA Request 23 */
      vuint32_t ERQ22:1;               /* Enable DMA Request 22 */
      vuint32_t ERQ21:1;               /* Enable DMA Request 21 */
      vuint32_t ERQ20:1;               /* Enable DMA Request 20 */
      vuint32_t ERQ19:1;               /* Enable DMA Request 19 */
      vuint32_t ERQ18:1;               /* Enable DMA Request 18 */
      vuint32_t ERQ17:1;               /* Enable DMA Request 17 */
      vuint32_t ERQ16:1;               /* Enable DMA Request 16 */
      vuint32_t ERQ15:1;               /* Enable DMA Request 15 */
      vuint32_t ERQ14:1;               /* Enable DMA Request 14 */
      vuint32_t ERQ13:1;               /* Enable DMA Request 13 */
      vuint32_t ERQ12:1;               /* Enable DMA Request 12 */
      vuint32_t ERQ11:1;               /* Enable DMA Request 11 */
      vuint32_t ERQ10:1;               /* Enable DMA Request 10 */
      vuint32_t ERQ9:1;                /* Enable DMA Request 9 */
      vuint32_t ERQ8:1;                /* Enable DMA Request 8 */
      vuint32_t ERQ7:1;                /* Enable DMA Request 7 */
      vuint32_t ERQ6:1;                /* Enable DMA Request 6 */
      vuint32_t ERQ5:1;                /* Enable DMA Request 5 */
      vuint32_t ERQ4:1;                /* Enable DMA Request 4 */
      vuint32_t ERQ3:1;                /* Enable DMA Request 3 */
      vuint32_t ERQ2:1;                /* Enable DMA Request 2 */
      vuint32_t ERQ1:1;                /* Enable DMA Request 1 */
      vuint32_t ERQ0:1;                /* Enable DMA Request 0 */
    } B;
  } ERQ;

  uint8_t DMA_reserved1[4];
  union {                              /* Enable Error Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t EEI31:1;               /* Enable Error Interrupt 31 */
      vuint32_t EEI30:1;               /* Enable Error Interrupt 30 */
      vuint32_t EEI29:1;               /* Enable Error Interrupt 29 */
      vuint32_t EEI28:1;               /* Enable Error Interrupt 28 */
      vuint32_t EEI27:1;               /* Enable Error Interrupt 27 */
      vuint32_t EEI26:1;               /* Enable Error Interrupt 26 */
      vuint32_t EEI25:1;               /* Enable Error Interrupt 25 */
      vuint32_t EEI24:1;               /* Enable Error Interrupt 24 */
      vuint32_t EEI23:1;               /* Enable Error Interrupt 23 */
      vuint32_t EEI22:1;               /* Enable Error Interrupt 22 */
      vuint32_t EEI21:1;               /* Enable Error Interrupt 21 */
      vuint32_t EEI20:1;               /* Enable Error Interrupt 20 */
      vuint32_t EEI19:1;               /* Enable Error Interrupt 19 */
      vuint32_t EEI18:1;               /* Enable Error Interrupt 18 */
      vuint32_t EEI17:1;               /* Enable Error Interrupt 17 */
      vuint32_t EEI16:1;               /* Enable Error Interrupt 16 */
      vuint32_t EEI15:1;               /* Enable Error Interrupt 15 */
      vuint32_t EEI14:1;               /* Enable Error Interrupt 14 */
      vuint32_t EEI13:1;               /* Enable Error Interrupt 13 */
      vuint32_t EEI12:1;               /* Enable Error Interrupt 12 */
      vuint32_t EEI11:1;               /* Enable Error Interrupt 11 */
      vuint32_t EEI10:1;               /* Enable Error Interrupt 10 */
      vuint32_t EEI9:1;                /* Enable Error Interrupt 9 */
      vuint32_t EEI8:1;                /* Enable Error Interrupt 8 */
      vuint32_t EEI7:1;                /* Enable Error Interrupt 7 */
      vuint32_t EEI6:1;                /* Enable Error Interrupt 6 */
      vuint32_t EEI5:1;                /* Enable Error Interrupt 5 */
      vuint32_t EEI4:1;                /* Enable Error Interrupt 4 */
      vuint32_t EEI3:1;                /* Enable Error Interrupt 3 */
      vuint32_t EEI2:1;                /* Enable Error Interrupt 2 */
      vuint32_t EEI1:1;                /* Enable Error Interrupt 1 */
      vuint32_t EEI0:1;                /* Enable Error Interrupt 0 */
    } B;
  } EEI;

  union {                              /* Set Enable Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SAER:1;                 /* Set All Enable Requests */
      vuint8_t  :1;
      vuint8_t SERQ:5;                 /* Set Enable Request */
    } B;
  } SERQ;

  union {                              /* Clear Enable Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAER:1;                 /* Clear All Enable Requests */
      vuint8_t  :1;
      vuint8_t CERQ:5;                 /* Clear Enable Request */
    } B;
  } CERQ;

  union {                              /* Set Enable Error Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SAEE:1;                 /* Sets All Enable Error Interrupts */
      vuint8_t  :1;
      vuint8_t SEEI:5;                 /* Set Enable Error Interrupt */
    } B;
  } SEEI;

  union {                              /* Clear Enable Error Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAEE:1;                 /* Clear All Enable Error Interrupts */
      vuint8_t  :1;
      vuint8_t CEEI:5;                 /* Clear Enable Error Interrupt */
    } B;
  } CEEI;

  union {                              /* Clear Interrupt Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAIR:1;                 /* Clear All Interrupt Requests */
      vuint8_t  :1;
      vuint8_t CINT:5;                 /* Clear interrupt request */
    } B;
  } CINT;

  union {                              /* Clear Error Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAEI:1;                 /* Clear All Error Indicators */
      vuint8_t  :1;
      vuint8_t CERR:5;                 /* Clear Error Indicator */
    } B;
  } CERR;

  union {                              /* Set START Bit Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SAST:1;                 /* Set All START Bits (activates all channels) */
      vuint8_t  :1;
      vuint8_t SSRT:5;                 /* Set START Bit */
    } B;
  } SSRT;

  union {                              /* Clear DONE Status Bit Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CADN:1;                 /* Clears All DONE Bits */
      vuint8_t  :1;
      vuint8_t CDNE:5;                 /* Clear DONE Bit */
    } B;
  } CDNE;

  uint8_t DMA_reserved2[4];
  union {                              /* Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t INT31:1;               /* Interrupt Request 31 */
      vuint32_t INT30:1;               /* Interrupt Request 30 */
      vuint32_t INT29:1;               /* Interrupt Request 29 */
      vuint32_t INT28:1;               /* Interrupt Request 28 */
      vuint32_t INT27:1;               /* Interrupt Request 27 */
      vuint32_t INT26:1;               /* Interrupt Request 26 */
      vuint32_t INT25:1;               /* Interrupt Request 25 */
      vuint32_t INT24:1;               /* Interrupt Request 24 */
      vuint32_t INT23:1;               /* Interrupt Request 23 */
      vuint32_t INT22:1;               /* Interrupt Request 22 */
      vuint32_t INT21:1;               /* Interrupt Request 21 */
      vuint32_t INT20:1;               /* Interrupt Request 20 */
      vuint32_t INT19:1;               /* Interrupt Request 19 */
      vuint32_t INT18:1;               /* Interrupt Request 18 */
      vuint32_t INT17:1;               /* Interrupt Request 17 */
      vuint32_t INT16:1;               /* Interrupt Request 16 */
      vuint32_t INT15:1;               /* Interrupt Request 15 */
      vuint32_t INT14:1;               /* Interrupt Request 14 */
      vuint32_t INT13:1;               /* Interrupt Request 13 */
      vuint32_t INT12:1;               /* Interrupt Request 12 */
      vuint32_t INT11:1;               /* Interrupt Request 11 */
      vuint32_t INT10:1;               /* Interrupt Request 10 */
      vuint32_t INT9:1;                /* Interrupt Request 9 */
      vuint32_t INT8:1;                /* Interrupt Request 8 */
      vuint32_t INT7:1;                /* Interrupt Request 7 */
      vuint32_t INT6:1;                /* Interrupt Request 6 */
      vuint32_t INT5:1;                /* Interrupt Request 5 */
      vuint32_t INT4:1;                /* Interrupt Request 4 */
      vuint32_t INT3:1;                /* Interrupt Request 3 */
      vuint32_t INT2:1;                /* Interrupt Request 2 */
      vuint32_t INT1:1;                /* Interrupt Request 1 */
      vuint32_t INT0:1;                /* Interrupt Request 0 */
    } B;
  } INT;

  uint8_t DMA_reserved3[4];
  union {                              /* Error Register */
    vuint32_t R;
    struct {
      vuint32_t ERR31:1;               /* Error In Channel 31 */
      vuint32_t ERR30:1;               /* Error In Channel 30 */
      vuint32_t ERR29:1;               /* Error In Channel 29 */
      vuint32_t ERR28:1;               /* Error In Channel 28 */
      vuint32_t ERR27:1;               /* Error In Channel 27 */
      vuint32_t ERR26:1;               /* Error In Channel 26 */
      vuint32_t ERR25:1;               /* Error In Channel 25 */
      vuint32_t ERR24:1;               /* Error In Channel 24 */
      vuint32_t ERR23:1;               /* Error In Channel 23 */
      vuint32_t ERR22:1;               /* Error In Channel 22 */
      vuint32_t ERR21:1;               /* Error In Channel 21 */
      vuint32_t ERR20:1;               /* Error In Channel 20 */
      vuint32_t ERR19:1;               /* Error In Channel 19 */
      vuint32_t ERR18:1;               /* Error In Channel 18 */
      vuint32_t ERR17:1;               /* Error In Channel 17 */
      vuint32_t ERR16:1;               /* Error In Channel 16 */
      vuint32_t ERR15:1;               /* Error In Channel 15 */
      vuint32_t ERR14:1;               /* Error In Channel 14 */
      vuint32_t ERR13:1;               /* Error In Channel 13 */
      vuint32_t ERR12:1;               /* Error In Channel 12 */
      vuint32_t ERR11:1;               /* Error In Channel 11 */
      vuint32_t ERR10:1;               /* Error In Channel 10 */
      vuint32_t ERR9:1;                /* Error In Channel 9 */
      vuint32_t ERR8:1;                /* Error In Channel 8 */
      vuint32_t ERR7:1;                /* Error In Channel 7 */
      vuint32_t ERR6:1;                /* Error In Channel 6 */
      vuint32_t ERR5:1;                /* Error In Channel 5 */
      vuint32_t ERR4:1;                /* Error In Channel 4 */
      vuint32_t ERR3:1;                /* Error In Channel 3 */
      vuint32_t ERR2:1;                /* Error In Channel 2 */
      vuint32_t ERR1:1;                /* Error In Channel 1 */
      vuint32_t ERR0:1;                /* Error In Channel 0 */
    } B;
  } ERR;

  uint8_t DMA_reserved4[4];
  union {                              /* Hardware Request Status Register */
    vuint32_t R;
    struct {
      vuint32_t HRS31:1;               /* Hardware Request Status Channel 31 */
      vuint32_t HRS30:1;               /* Hardware Request Status Channel 30 */
      vuint32_t HRS29:1;               /* Hardware Request Status Channel 29 */
      vuint32_t HRS28:1;               /* Hardware Request Status Channel 28 */
      vuint32_t HRS27:1;               /* Hardware Request Status Channel 27 */
      vuint32_t HRS26:1;               /* Hardware Request Status Channel 26 */
      vuint32_t HRS25:1;               /* Hardware Request Status Channel 25 */
      vuint32_t HRS24:1;               /* Hardware Request Status Channel 24 */
      vuint32_t HRS23:1;               /* Hardware Request Status Channel 23 */
      vuint32_t HRS22:1;               /* Hardware Request Status Channel 22 */
      vuint32_t HRS21:1;               /* Hardware Request Status Channel 21 */
      vuint32_t HRS20:1;               /* Hardware Request Status Channel 20 */
      vuint32_t HRS19:1;               /* Hardware Request Status Channel 19 */
      vuint32_t HRS18:1;               /* Hardware Request Status Channel 18 */
      vuint32_t HRS17:1;               /* Hardware Request Status Channel 17 */
      vuint32_t HRS16:1;               /* Hardware Request Status Channel 16 */
      vuint32_t HRS15:1;               /* Hardware Request Status Channel 15 */
      vuint32_t HRS14:1;               /* Hardware Request Status Channel 14 */
      vuint32_t HRS13:1;               /* Hardware Request Status Channel 13 */
      vuint32_t HRS12:1;               /* Hardware Request Status Channel 12 */
      vuint32_t HRS11:1;               /* Hardware Request Status Channel 11 */
      vuint32_t HRS10:1;               /* Hardware Request Status Channel 10 */
      vuint32_t HRS9:1;                /* Hardware Request Status Channel 9 */
      vuint32_t HRS8:1;                /* Hardware Request Status Channel 8 */
      vuint32_t HRS7:1;                /* Hardware Request Status Channel 7 */
      vuint32_t HRS6:1;                /* Hardware Request Status Channel 6 */
      vuint32_t HRS5:1;                /* Hardware Request Status Channel 5 */
      vuint32_t HRS4:1;                /* Hardware Request Status Channel 4 */
      vuint32_t HRS3:1;                /* Hardware Request Status Channel 3 */
      vuint32_t HRS2:1;                /* Hardware Request Status Channel 2 */
      vuint32_t HRS1:1;                /* Hardware Request Status Channel 1 */
      vuint32_t HRS0:1;                /* Hardware Request Status Channel 0 */
    } B;
  } HRS;

  uint8_t DMA_reserved5[200];
  union {                              /* Channel n Priority Register */
    vuint8_t R;
    struct {
      vuint8_t ECP:1;                  /* Enable Channel Preemption. This bit resets to zero. */
      vuint8_t DPA:1;                  /* Disable preempt ability. This bit resets to zero. */
      vuint8_t GRPPRI:2;               /* Channel n Current Group Priority */
      vuint8_t CHPRI:4;                /* Channel n Arbitration Priority */
    } B;
  } DCHPRI[32];

  uint8_t DMA_reserved6[32];
  union {                              /* Channel n Master ID Register */
    vuint8_t R;
    struct {
      vuint8_t EMI:1;                  /* Enable Master ID replication */
      vuint8_t PAL:1;                  /* Privileged Access Level */
      vuint8_t  :2;
      vuint8_t MID:4;                  /* Master ID */
    } B;
  } DCHMID[32];

  uint8_t DMA_reserved7[3744];
  struct {
    union {                            /* TCD Source Address */
      vuint32_t R;
      struct {
        vuint32_t SADDR:32;            /* Source Address */
      } B;
    } SADDR;
    union {                            /* TCD Transfer Attributes */
      vuint16_t R;
      struct {
        vuint16_t SMOD:5;              /* Source Address Modulo */
        vuint16_t SSIZE:3;             /* Source data transfer size */
        vuint16_t DMOD:5;              /* Destination Address Modulo */
        vuint16_t DSIZE:3;             /* Destination Data Transfer Size */
      } B;
    } ATTR;
    union {                            /* TCD Signed Source Address Offset */
      vuint16_t R;
      struct {
        vuint16_t SOFF:16;             /* Source Address Signed Offset */
      } B;
    } SOFF;
    union {
      union {                          /* TCD Minor Byte Count (Minor Loop Disabled) */
        vuint32_t R;
        struct {
          vuint32_t NBYTES:32;         /* Minor Byte Transfer Count */
        } B;
      } MLNO;
      union {                          /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
        vuint32_t R;
        struct {
          vuint32_t SMLOE:1;           /* Source Minor Loop Offset Enable */
          vuint32_t DMLOE:1;           /* Destination Minor Loop Offset enable */
          vuint32_t NBYTES:30;         /* Minor Byte Transfer Count */
        } B;
      } MLOFFNO;
      union {                          /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
        vuint32_t R;
        struct {
          vuint32_t SMLOE:1;           /* Source Minor Loop Offset Enable */
          vuint32_t DMLOE:1;           /* Destination Minor Loop Offset Enable */
          vuint32_t MLOFF:20;          /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
          vuint32_t NBYTES:10;         /* Minor Byte Transfer Count */
        } B;
      } MLOFFYES;
    } NBYTES;
    union {                            /* TCD Last Source Address Adjustment */
      vuint32_t R;
      struct {
        vuint32_t SLAST:32;            /* Last Source Address Adjustment */
      } B;
    } SLAST;
    union {                            /* TCD Destination Address */
      vuint32_t R;
      struct {
        vuint32_t DADDR:32;            /* Destination Address */
      } B;
    } DADDR;
    union {
      union {                          /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enable channel-to-channel linking on minor-loop complete */
          vuint16_t CITER:15;          /* Current Major Iteration Count */
        } B;
      } ELINKNO;
      union {                          /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enable channel-to-channel linking on minor-loop complete */
          vuint16_t  :1;
          vuint16_t LINKCH:5;          /* Link Channel Number */
          vuint16_t CITER:9;           /* Current Major Iteration Count */
        } B;
      } ELINKYES;
    } CITER;
    union {                            /* TCD Signed Destination Address Offset */
      vuint16_t R;
      struct {
        vuint16_t DOFF:16;             /* Destination Address Signed Offset */
      } B;
    } DOFF;
    union {                            /* TCD Last Destination Address Adjustment/Scatter Gather Address */
      vuint32_t R;
      struct {
        vuint32_t DLASTSGA:32;
      } B;
    } DLASTSGA;
    union {
      union {                          /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enables channel-to-channel linking on minor loop complete */
          vuint16_t BITER:15;          /* Starting Major Iteration Count */
        } B;
      } ELINKNO;
      union {                          /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enables channel-to-channel linking on minor loop complete */
          vuint16_t  :1;
          vuint16_t LINKCH:5;          /* Link Channel Number */
          vuint16_t BITER:9;           /* Starting Major Iteration Count */
        } B;
      } ELINKYES;
    } BITER;
    union {                            /* TCD Control and Status */
      vuint16_t R;
      struct {
        vuint16_t BWC:2;               /* Bandwidth Control */
        vuint16_t  :1;
        vuint16_t MAJORLINKCH:5;       /* Link Channel Number */
        vuint16_t DONE:1;              /* Channel Done */
        vuint16_t ACTIVE:1;            /* Channel Active */
        vuint16_t MAJORELINK:1;        /* Enable channel-to-channel linking on major loop complete */
        vuint16_t ESG:1;               /* Enable Scatter/Gather Processing */
        vuint16_t DREQ:1;              /* Disable Request */
        vuint16_t INTHALF:1;           /* Enable an interrupt when major counter is half complete. */
        vuint16_t INTMAJOR:1;          /* Enable an interrupt when major iteration count completes */
        vuint16_t START:1;             /* Channel Start */
      } B;
    } CSR;
  } TCD[32];
};


/* ============================================================================
   =============================== Module: EIM ================================
   ============================================================================ */

struct EIM_tag {
  union {                              /* Error Injection Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t GEIEN:1;               /* Global Error Injection Enable. */
    } B;
  } EIMCR;

  union {                              /* Error Injection Channel Enable register */
    vuint32_t R;
    struct {
      vuint32_t EICH0EN:1;             /* Error Injection Channel 0 Enable */
      vuint32_t  :31;
    } B;
  } EICHEN;

  uint8_t EIM_reserved0[248];
  union {                              /* Error Injection Channel Descriptor, Word0 */
    vuint32_t R;
    struct {
      vuint32_t CHKBIT_MASK:8;         /* Checkbit Mask. */
      vuint32_t  :24;
    } B;
  } EICHD_Word0;

  union {                              /* Error Injection Channel Descriptor, Word1 */
    vuint32_t R;
    struct {
      vuint32_t UDATA_MASK:32;         /* Upper Data Mask. */
    } B;
  } EICHD_Word1;

  union {                              /* Error Injection Channel Descriptor, Word2 */
    vuint32_t R;
    struct {
      vuint32_t LDATA_MASK:32;         /* Lower Data Mask. */
    } B;
  } EICHD_Word2;
};


/* ============================================================================
   =============================== Module: ENET ===============================
   ============================================================================ */

struct ENET_tag {
  uint8_t ENET_reserved0[4];
  union {                              /* Interrupt Event Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t BABR:1;                /* Babbling Receive Error */
      vuint32_t BABT:1;                /* Babbling Transmit Error */
      vuint32_t GRA:1;                 /* Graceful Stop Complete */
      vuint32_t TXF:1;                 /* Transmit Frame Interrupt */
      vuint32_t TXB:1;                 /* Transmit Buffer Interrupt */
      vuint32_t RXF:1;                 /* Receive Frame Interrupt */
      vuint32_t RXB:1;                 /* Receive Buffer Interrupt */
      vuint32_t MII:1;                 /* MII Interrupt. */
      vuint32_t EBERR:1;               /* Ethernet Bus Error */
      vuint32_t LC:1;                  /* Late Collision */
      vuint32_t RL:1;                  /* Collision Retry Limit */
      vuint32_t UN:1;                  /* Transmit FIFO Underrun */
      vuint32_t PLR:1;                 /* Payload Receive Error */
      vuint32_t WAKEUP:1;              /* Node Wakeup Request Indication */
      vuint32_t TS_AVAIL:1;            /* Transmit Timestamp Available */
      vuint32_t TS_TIMER:1;            /* Timestamp Timer */
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t  :12;
    } B;
  } EIR;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t BABR:1;                /* BABR Interrupt Mask */
      vuint32_t BABT:1;                /* BABT Interrupt Mask */
      vuint32_t GRA:1;                 /* GRA Interrupt Mask */
      vuint32_t TXF:1;                 /* TXF Interrupt Mask */
      vuint32_t TXB:1;                 /* TXB Interrupt Mask */
      vuint32_t RXF:1;                 /* RXF Interrupt Mask */
      vuint32_t RXB:1;                 /* RXB Interrupt Mask */
      vuint32_t MII:1;                 /* MII Interrupt Mask */
      vuint32_t EBERR:1;               /* EBERR Interrupt Mask */
      vuint32_t LC:1;                  /* LC Interrupt Mask */
      vuint32_t RL:1;                  /* RL Interrupt Mask */
      vuint32_t UN:1;                  /* UN Interrupt Mask */
      vuint32_t PLR:1;                 /* PLR Interrupt Mask */
      vuint32_t WAKEUP:1;              /* WAKEUP Interrupt Mask */
      vuint32_t TS_AVAIL:1;            /* TS_AVAIL Interrupt Mask */
      vuint32_t TS_TIMER:1;            /* TS_TIMER Interrupt Mask */
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t  :12;
    } B;
  } EIMR;

  uint8_t ENET_reserved1[4];
  union {                              /* Receive Descriptor Active Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDAR:1;                /* Receive Descriptor Active */
      vuint32_t  :24;
    } B;
  } RDAR;

  union {                              /* Transmit Descriptor Active Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t TDAR:1;                /* Transmit Descriptor Active */
      vuint32_t  :24;
    } B;
  } TDAR;

  uint8_t ENET_reserved2[12];
  union {                              /* Ethernet Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t DBSWP:1;               /* Descriptor Byte Swapping Enable */
      vuint32_t STOPEN:1;              /* STOPEN Signal Control */
      vuint32_t DBGEN:1;               /* Debug Enable */
      vuint32_t  :1;
      vuint32_t EN1588:1;              /* EN1588 Enable */
      vuint32_t SLEEP:1;               /* Sleep Mode Enable */
      vuint32_t MAGICEN:1;             /* Magic Packet Detection Enable */
      vuint32_t ETHEREN:1;             /* Ethernet Enable */
      vuint32_t RESET:1;               /* Ethernet MAC Reset */
    } B;
  } ECR;

  uint8_t ENET_reserved3[24];
  union {                              /* MII Management Frame Register */
    vuint32_t R;
    struct {
      vuint32_t ST:2;                  /* Start Of Frame Delimiter */
      vuint32_t OP:2;                  /* Operation Code */
      vuint32_t PA:5;                  /* PHY Address */
      vuint32_t RA:5;                  /* Register Address */
      vuint32_t TA:2;                  /* Turn Around */
      vuint32_t DATA:16;               /* Management Frame Data */
    } B;
  } MMFR;

  union {                              /* MII Speed Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t HOLDTIME:3;            /* Holdtime On MDIO Output */
      vuint32_t DIS_PRE:1;             /* Disable Preamble */
      vuint32_t MII_SPEED:6;           /* MII Speed */
      vuint32_t  :1;
    } B;
  } MSCR;

  uint8_t ENET_reserved4[28];
  union {                              /* MIB Control Register */
    vuint32_t R;
    struct {
      vuint32_t MIB_DIS:1;             /* Disable MIB Logic */
      vuint32_t MIB_IDLE:1;            /* MIB Idle */
      vuint32_t MIB_CLEAR:1;           /* MIB Clear */
      vuint32_t  :29;
    } B;
  } MIBC;

  uint8_t ENET_reserved5[28];
  union {                              /* Receive Control Register */
    vuint32_t R;
    struct {
      vuint32_t GRS:1;                 /* Graceful Receive Stopped */
      vuint32_t NLC:1;                 /* Payload Length Check Disable */
      vuint32_t MAX_FL:14;             /* Maximum Frame Length */
      vuint32_t CFEN:1;                /* MAC Control Frame Enable */
      vuint32_t CRCFWD:1;              /* Terminate/Forward Received CRC */
      vuint32_t PAUFWD:1;              /* Terminate/Forward Pause Frames */
      vuint32_t PADEN:1;               /* Enable Frame Padding Remove On Receive */
      vuint32_t  :2;
      vuint32_t RMII_10T:1;
      vuint32_t RMII_MODE:1;           /* RMII Mode Enable */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t FCE:1;                 /* Flow Control Enable */
      vuint32_t BC_REJ:1;              /* Broadcast Frame Reject */
      vuint32_t PROM:1;                /* Promiscuous Mode */
      vuint32_t MII_MODE:1;            /* Media Independent Interface Mode */
      vuint32_t DRT:1;                 /* Disable Receive On Transmit */
      vuint32_t LOOP:1;                /* Internal Loopback */
    } B;
  } RCR;

  uint8_t ENET_reserved6[60];
  union {                              /* Transmit Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t CRCFWD:1;              /* Forward Frame From Application With CRC */
      vuint32_t ADDINS:1;              /* Set MAC Address On Transmit */
      vuint32_t ADDSEL:3;              /* Source MAC Address Select On Transmit */
      vuint32_t RFC_PAUSE:1;           /* Receive Frame Control Pause */
      vuint32_t TFC_PAUSE:1;           /* Transmit Frame Control Pause */
      vuint32_t FDEN:1;                /* Full-Duplex Enable */
      vuint32_t  :1;
      vuint32_t GTS:1;                 /* Graceful Transmit Stop */
    } B;
  } TCR;

  uint8_t ENET_reserved7[28];
  union {                              /* Physical Address Lower Register */
    vuint32_t R;
    struct {
      vuint32_t PADDR1:32;             /* Pause Address */
    } B;
  } PALR;

  union {                              /* Physical Address Upper Register */
    vuint32_t R;
    struct {
      vuint32_t PADDR2:16;
      vuint32_t TYPE:16;               /* Type Field In PAUSE Frames */
    } B;
  } PAUR;

  union {                              /* Opcode/Pause Duration Register */
    vuint32_t R;
    struct {
      vuint32_t OPCODE:16;             /* Opcode Field In PAUSE Frames */
      vuint32_t PAUSE_DUR:16;          /* Pause Duration */
    } B;
  } OPD;

  uint8_t ENET_reserved8[40];
  union {                              /* Descriptor Individual Upper Address Register */
    vuint32_t R;
    struct {
      vuint32_t IADDR1:32;
    } B;
  } IAUR;

  union {                              /* Descriptor Individual Lower Address Register */
    vuint32_t R;
    struct {
      vuint32_t IADDR2:32;
    } B;
  } IALR;

  union {                              /* Descriptor Group Upper Address Register */
    vuint32_t R;
    struct {
      vuint32_t GADDR1:32;
    } B;
  } GAUR;

  union {                              /* Descriptor Group Lower Address Register */
    vuint32_t R;
    struct {
      vuint32_t GADDR2:32;
    } B;
  } GALR;

  uint8_t ENET_reserved9[28];
  union {                              /* Transmit FIFO Watermark Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t STRFWD:1;              /* Store And Forward Enable */
      vuint32_t  :2;
      vuint32_t TFWR:6;                /* Transmit FIFO Write */
    } B;
  } TFWR;

  uint8_t ENET_reserved10[56];
  union {                              /* Receive Descriptor Ring Start Register */
    vuint32_t R;
    struct {
      vuint32_t R_DES_START:29;
      vuint32_t  :3;
    } B;
  } RDSR;

  union {                              /* Transmit Buffer Descriptor Ring Start Register */
    vuint32_t R;
    struct {
      vuint32_t X_DES_START:29;
      vuint32_t  :3;
    } B;
  } TDSR;

  union {                              /* Maximum Receive Buffer Size Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t R_BUF_SIZE:10;
      vuint32_t  :4;
    } B;
  } MRBR;

  uint8_t ENET_reserved11[4];
  union {                              /* Receive FIFO Section Full Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RX_SECTION_FULL:8;     /* Value Of Receive FIFO Section Full Threshold */
    } B;
  } RSFL;

  union {                              /* Receive FIFO Section Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t STAT_SECTION_EMPTY:5;  /* RX Status FIFO Section Empty Threshold */
      vuint32_t  :8;
      vuint32_t RX_SECTION_EMPTY:8;    /* Value Of The Receive FIFO Section Empty Threshold */
    } B;
  } RSEM;

  union {                              /* Receive FIFO Almost Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RX_ALMOST_EMPTY:8;     /* Value Of The Receive FIFO Almost Empty Threshold */
    } B;
  } RAEM;

  union {                              /* Receive FIFO Almost Full Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RX_ALMOST_FULL:8;      /* Value Of The Receive FIFO Almost Full Threshold */
    } B;
  } RAFL;

  union {                              /* Transmit FIFO Section Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TX_SECTION_EMPTY:8;    /* Value Of The Transmit FIFO Section Empty Threshold */
    } B;
  } TSEM;

  union {                              /* Transmit FIFO Almost Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TX_ALMOST_EMPTY:8;     /* Value of Transmit FIFO Almost Empty Threshold */
    } B;
  } TAEM;

  union {                              /* Transmit FIFO Almost Full Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TX_ALMOST_FULL:8;      /* Value Of The Transmit FIFO Almost Full Threshold */
    } B;
  } TAFL;

  union {                              /* Transmit Inter-Packet Gap */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t IPG:5;                 /* Transmit Inter-Packet Gap */
    } B;
  } TIPG;

  union {                              /* Frame Truncation Length */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t TRUNC_FL:14;           /* Frame Truncation Length */
    } B;
  } FTRL;

  uint8_t ENET_reserved12[12];
  union {                              /* Transmit Accelerator Function Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t PROCHK:1;
      vuint32_t IPCHK:1;
      vuint32_t  :2;
      vuint32_t SHIFT16:1;             /* TX FIFO Shift-16 */
    } B;
  } TACC;

  union {                              /* Receive Accelerator Function Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SHIFT16:1;             /* RX FIFO Shift-16 */
      vuint32_t LINEDIS:1;             /* Enable Discard Of Frames With MAC Layer Errors */
      vuint32_t  :3;
      vuint32_t PRODIS:1;              /* Enable Discard Of Frames With Wrong Protocol Checksum */
      vuint32_t IPDIS:1;               /* Enable Discard Of Frames With Wrong IPv4 Header Checksum */
      vuint32_t PADREM:1;              /* Enable Padding Removal For Short IP Frames */
    } B;
  } RACC;

  uint8_t ENET_reserved13[568];
  union {                              /* Timer Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t SLAVE:1;               /* Enable Timer Slave Mode */
      vuint32_t  :1;
      vuint32_t CAPTURE:1;             /* Capture Timer Value */
      vuint32_t  :1;
      vuint32_t RESTART:1;             /* Reset Timer */
      vuint32_t  :1;
      vuint32_t PINPER:1;
      vuint32_t  :2;
      vuint32_t PEREN:1;               /* Enable Periodical Event */
      vuint32_t OFFRST:1;              /* Reset Timer On Offset Event */
      vuint32_t OFFEN:1;               /* Enable One-Shot Offset Event */
      vuint32_t  :1;
      vuint32_t EN:1;                  /* Enable Timer */
    } B;
  } ATCR;

  union {                              /* Timer Value Register */
    vuint32_t R;
    struct {
      vuint32_t ATIME:32;
    } B;
  } ATVR;

  union {                              /* Timer Offset Register */
    vuint32_t R;
    struct {
      vuint32_t OFFSET:32;
    } B;
  } ATOFF;

  union {                              /* Timer Period Register */
    vuint32_t R;
    struct {
      vuint32_t PERIOD:32;
    } B;
  } ATPER;

  union {                              /* Timer Correction Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t COR:31;                /* Correction Counter Wrap-Around Value */
    } B;
  } ATCOR;

  union {                              /* Time-Stamping Clock Period Register */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t INC_CORR:7;            /* Correction Increment Value */
      vuint32_t  :1;
      vuint32_t INC:7;                 /* Clock Period Of The Timestamping Clock (ts_clk) In Nanoseconds */
    } B;
  } ATINC;

  union {                              /* Timestamp of Last Transmitted Frame */
    vuint32_t R;
    struct {
      vuint32_t TIMESTAMP:32;
    } B;
  } ATSTMP;

  uint8_t ENET_reserved14[488];
  union {                              /* Timer Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t TF3:1;                 /* Copy Of Timer Flag For Channel 3 */
      vuint32_t TF2:1;                 /* Copy Of Timer Flag For Channel 2 */
      vuint32_t TF1:1;                 /* Copy Of Timer Flag For Channel 1 */
      vuint32_t TF0:1;                 /* Copy Of Timer Flag For Channel 0 */
    } B;
  } TGSR;

  struct {
    union {                            /* Timer Control Status Register */
      vuint32_t R;
      struct {
        vuint32_t  :24;
        vuint32_t TF:1;                /* Timer Flag */
        vuint32_t TIE:1;               /* Timer Interrupt Enable */
        vuint32_t TMODE:4;             /* Timer Mode */
        vuint32_t  :1;
        vuint32_t TDRE:1;              /* Timer DMA Request Enable */
      } B;
    } TCSR;
    union {                            /* Timer Compare Capture Register */
      vuint32_t R;
      struct {
        vuint32_t TCC:32;              /* Timer Capture Compare */
      } B;
    } TCCR;
  } TIMER[4];
};


/* ============================================================================
   =============================== Module: ETIMER =============================
   ============================================================================ */

struct ETIMER_tag {
  struct {
    union {                            /* Channel n Compare Register 1 */
      vuint16_t R;
      struct {
        vuint16_t COMP1:16;
      } B;
    } COMP1;
    union {                            /* Channel n Compare Register 2 */
      vuint16_t R;
      struct {
        vuint16_t COMP2:16;
      } B;
    } COMP2;
    union {                            /* Channel n Capture Register 1 */
      vuint16_t R;
      struct {
        vuint16_t CAPT1:16;
      } B;
    } CAPT1;
    union {                            /* Channel n Capture Register 2 */
      vuint16_t R;
      struct {
        vuint16_t CAPT2:16;
      } B;
    } CAPT2;
    union {                            /* Channel n Load Register */
      vuint16_t R;
      struct {
        vuint16_t LOAD:16;
      } B;
    } LOAD;
    union {                            /* Channel n Hold Register */
      vuint16_t R;
      struct {
        vuint16_t HOLD:16;
      } B;
    } HOLD;
    union {                            /* Channel n Counter Register */
      vuint16_t R;
      struct {
        vuint16_t CNTR:16;
      } B;
    } CNTR;
    union {                            /* Channel n Control Register 1 */
      vuint16_t R;
      struct {
        vuint16_t CNTMODE:3;           /* Count mode */
        vuint16_t PRISRC:5;            /* Primary Count Source */
        vuint16_t ONCE:1;              /* Count once */
        vuint16_t LENGTH:1;            /* Count Length */
        vuint16_t DIR:1;               /* Count Direction */
        vuint16_t SECSRC:5;            /* Secondary Count Source */
      } B;
    } CTRL1;
    union {                            /* Channel n Control Register 2 */
      vuint16_t R;
      struct {
        vuint16_t OEN:1;               /* Output Enable */
        vuint16_t RDNT:1;              /* Redundant Channel Enable */
        vuint16_t INPUT:1;             /* External input signal */
        vuint16_t VAL:1;               /* Forced OFLAG Value */
        vuint16_t FORCE:1;             /* Force the OFLAG output */
        vuint16_t COFRC:1;             /* Co-channel OFLAG Force */
        vuint16_t COINIT:2;            /* Co-channel Initialization */
        vuint16_t SIPS:1;              /* Secondary Source Input Polarity Select */
        vuint16_t PIPS:1;              /* Primary Source Input Polarity Select */
        vuint16_t OPS:1;               /* Output Polarity Select. */
        vuint16_t MSTR:1;              /* Master Mode */
        vuint16_t OUTMODE:4;           /* Output Mode */
      } B;
    } CTRL2;
    union {                            /* Channel n Control Register 3 */
      vuint16_t R;
      struct {
        vuint16_t STPEN:1;             /* Stop Actions Enable */
        vuint16_t ROC:2;               /* Reload on Capture */
        vuint16_t  :5;
        vuint16_t C2FCNT:3;            /* Capture 2 FIFO count */
        vuint16_t C1FCNT:3;            /* Capture 1 FIFO count */
        vuint16_t DBGEN:2;             /* Debug Actions Enable */
      } B;
    } CTRL3;
    union {                            /* Channel n Status Register */
      vuint16_t R;
      struct {
        vuint16_t  :6;
        vuint16_t WDF:1;               /* Watchdog Time-out Flag */
        vuint16_t RCF:1;               /* Redundant Channel Flag */
        vuint16_t ICF2:1;              /* Input Capture 2 Flag */
        vuint16_t ICF1:1;              /* Input Capture 1 Flag */
        vuint16_t IEHF:1;              /* Input Edge High Flag */
        vuint16_t IELF:1;              /* Input Edge Low Flag */
        vuint16_t TOF:1;               /* Timer Overflow Flag */
        vuint16_t TCF2:1;              /* Timer Compare 2 Flag */
        vuint16_t TCF1:1;              /* Timer Compare 1 Flag */
        vuint16_t TCF:1;
      } B;
    } STS;
    union {                            /* Channel n Interrupt and DMA Enable Register */
      vuint16_t R;
      struct {
        vuint16_t ICF2DE:1;            /* Input Capture 2 Flag DMA Enable */
        vuint16_t ICF1DE:1;            /* Input Capture 1 Flag DMA Enable */
        vuint16_t CMPLD2DE:1;          /* Comparator Load Register 2 Flag DMA Enable */
        vuint16_t CMPLD1DE:1;          /* Comparator Load Register 1 Flag DMA Enable */
        vuint16_t  :2;
        vuint16_t WDFIE:1;             /* Watchdog Flag Interrupt Enable */
        vuint16_t RCFIE:1;             /* Redundant Channel Flag Interrupt Enable */
        vuint16_t ICF2IE:1;            /* Input Capture 2 Flag Interrupt Enable */
        vuint16_t ICF1IE:1;            /* Input Capture 1 Flag Interrupt Enable */
        vuint16_t IEHFIE:1;            /* Input Edge High Flag Interrupt Enable */
        vuint16_t IELFIE:1;            /* Input Edge Low Flag Interrupt Enable */
        vuint16_t TOFIE:1;             /* Timer Overflow Flag Interrupt Enable */
        vuint16_t TCF2IE:1;            /* Timer Compare 2 Flag Interrupt Enable */
        vuint16_t TCF1IE:1;            /* Timer Compare 1 Flag Interrupt Enable */
        vuint16_t TCFIE:1;             /* Timer Compare Flag Interrupt Enable */
      } B;
    } INTDMA;
    union {                            /* Channel n Comparator Load Register 1 */
      vuint16_t R;
      struct {
        vuint16_t CMPLD1:16;
      } B;
    } CMPLD1;
    union {                            /* Channel n Comparator Load Register 2 */
      vuint16_t R;
      struct {
        vuint16_t CMPLD2:16;
      } B;
    } CMPLD2;
    union {                            /* Channel n Compare and Capture Control Register */
      vuint16_t R;
      struct {
        vuint16_t CLC2:3;              /* Compare Load Control 2 */
        vuint16_t CLC1:3;              /* Compare Load Control 1 */
        vuint16_t CMPMODE:2;           /* Compare Mode */
        vuint16_t CPT2MODE:2;          /* Capture 2 Mode Control */
        vuint16_t CPT1MODE:2;          /* Capture 1 Mode Control */
        vuint16_t CFWM:2;              /* Capture FIFO Water Mark */
        vuint16_t ONESHOT:1;           /* One Shot Capture Mode */
        vuint16_t ARM:1;               /* Arm Capture */
      } B;
    } CCCTRL;
    union {                            /* Channel n Input Filter Register */
      vuint16_t R;
      struct {
        vuint16_t  :5;
        vuint16_t FILT_CNT:3;          /* Input Filter Sample Count */
        vuint16_t FILT_PER:8;          /* Input Filter Sample Period */
      } B;
    } FILT;
  } CH[6];

  uint8_t ETIMER_reserved0[64];
  union {                              /* Watchdog Time-out Low Word Register */
    vuint16_t R;
    struct {
      vuint16_t WDTOL:16;
    } B;
  } WDTOL;

  union {                              /* Watchdog Time-out High Word Register */
    vuint16_t R;
    struct {
      vuint16_t WDTOH:16;
    } B;
  } WDTOH;

  uint8_t ETIMER_reserved1[8];
  union {                              /* Channel Enable Register */
    vuint16_t R;
    struct {
      vuint16_t  :10;
      vuint16_t ENBL:6;                /* Timer Channel Enable */
    } B;
  } ENBL;

  uint8_t ETIMER_reserved2[2];
  union {                              /* DMA Request 0 Select Register */
    vuint16_t R;
    struct {
      vuint16_t DREQ0_EN:1;
      vuint16_t  :10;
      vuint16_t DREQ0:5;
    } B;
  } DREQ0;

  union {                              /* DMA Request 1 Select Register */
    vuint16_t R;
    struct {
      vuint16_t DREQ1_EN:1;
      vuint16_t  :10;
      vuint16_t DREQ1:5;               /* DMA Request Select */
    } B;
  } DREQ1;

  union {                              /* DMA Request 2 Select Register */
    vuint16_t R;
    struct {
      vuint16_t DREQ2_EN:1;
      vuint16_t  :10;
      vuint16_t DREQ2:5;               /* DMA Request Select */
    } B;
  } DREQ2;

  union {                              /* DMA Request 3 Select Register */
    vuint16_t R;
    struct {
      vuint16_t DREQ3_EN:1;
      vuint16_t  :10;
      vuint16_t DREQ3:5;               /* DMA Request Select */
    } B;
  } DREQ3;
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

struct FCCU_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t FILTER_BYPASS:1;
      vuint32_t FILTER_WIDTH:2;
      vuint32_t  :19;
      vuint32_t DEBUG:1;
      vuint32_t  :1;
      vuint32_t OPS:2;
      vuint32_t  :1;
      vuint32_t OPR:5;
    } B;
  } CTRL;

  union {                              /* CTRL Key Register */
    vuint32_t R;
    struct {
      vuint32_t CTRLK:32;
    } B;
  } CTRLK;

  union {                              /* Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t FCCU_SET_AFTER_RESET:1;
      vuint32_t FCCU_SET_CLEAR:2;
      vuint32_t  :2;
      vuint32_t  :4;
      vuint32_t FOPE:1;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t SM:1;
      vuint32_t PS:1;
      vuint32_t FOM:3;
      vuint32_t FOP:6;
    } B;
  } CFG;

  uint8_t FCCU_reserved0[16];
  union {                              /* NCF Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NCFC0:1;
      vuint32_t NCFC1:1;
      vuint32_t NCFC2:1;
      vuint32_t NCFC3:1;
      vuint32_t NCFC4:1;
      vuint32_t NCFC5:1;
      vuint32_t NCFC6:1;
      vuint32_t NCFC7:1;
      vuint32_t NCFC8:1;
      vuint32_t NCFC9:1;
      vuint32_t NCFC10:1;
      vuint32_t NCFC11:1;
      vuint32_t NCFC12:1;
      vuint32_t NCFC13:1;
      vuint32_t NCFC14:1;
      vuint32_t NCFC15:1;
      vuint32_t NCFC16:1;
      vuint32_t NCFC17:1;
      vuint32_t NCFC18:1;
      vuint32_t NCFC19:1;
      vuint32_t NCFC20:1;
      vuint32_t NCFC21:1;
      vuint32_t NCFC22:1;
      vuint32_t NCFC23:1;
      vuint32_t NCFC24:1;
      vuint32_t NCFC25:1;
      vuint32_t NCFC26:1;
      vuint32_t NCFC27:1;
      vuint32_t NCFC28:1;
      vuint32_t NCFC29:1;
      vuint32_t NCFC30:1;
      vuint32_t NCFC31:1;
    } B;
  } NCF_CFG[3];

  uint8_t FCCU_reserved1[36];
  union {                              /* NCFS Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NCFSC0:1;
      vuint32_t NCFSC1:1;
      vuint32_t NCFSC2:1;
      vuint32_t NCFSC3:1;
      vuint32_t NCFSC4:1;
      vuint32_t NCFSC5:1;
      vuint32_t NCFSC6:1;
      vuint32_t NCFSC7:1;
      vuint32_t NCFSC8:1;
      vuint32_t NCFSC9:1;
      vuint32_t NCFSC10:1;
      vuint32_t NCFSC11:1;
      vuint32_t NCFSC12:1;
      vuint32_t NCFSC13:1;
      vuint32_t NCFSC14:1;
      vuint32_t NCFSC15:1;
      vuint32_t NCFSC16:1;
      vuint32_t NCFSC17:1;
      vuint32_t NCFSC18:1;
      vuint32_t NCFSC19:1;
      vuint32_t NCFSC20:1;
      vuint32_t NCFSC21:1;
      vuint32_t NCFSC22:1;
      vuint32_t NCFSC23:1;
      vuint32_t NCFSC24:1;
      vuint32_t NCFSC25:1;
      vuint32_t NCFSC26:1;
      vuint32_t NCFSC27:1;
      vuint32_t NCFSC28:1;
      vuint32_t NCFSC29:1;
      vuint32_t NCFSC30:1;
      vuint32_t NCFSC31:1;
    } B;
  } NCFS_CFG[5];

  uint8_t FCCU_reserved2[32];
  union {                              /* NCF Status Register */
    vuint32_t R;
    struct {
      vuint32_t NCFS0:1;
      vuint32_t NCFS1:1;
      vuint32_t NCFS2:1;
      vuint32_t NCFS3:1;
      vuint32_t NCFS4:1;
      vuint32_t NCFS5:1;
      vuint32_t NCFS6:1;
      vuint32_t NCFS7:1;
      vuint32_t NCFS8:1;
      vuint32_t NCFS9:1;
      vuint32_t NCFS10:1;
      vuint32_t NCFS11:1;
      vuint32_t NCFS12:1;
      vuint32_t NCFS13:1;
      vuint32_t NCFS14:1;
      vuint32_t NCFS15:1;
      vuint32_t NCFS16:1;
      vuint32_t NCFS17:1;
      vuint32_t NCFS18:1;
      vuint32_t NCFS19:1;
      vuint32_t NCFS20:1;
      vuint32_t NCFS21:1;
      vuint32_t NCFS22:1;
      vuint32_t NCFS23:1;
      vuint32_t NCFS24:1;
      vuint32_t NCFS25:1;
      vuint32_t NCFS26:1;
      vuint32_t NCFS27:1;
      vuint32_t NCFS28:1;
      vuint32_t NCFS29:1;
      vuint32_t NCFS30:1;
      vuint32_t NCFS31:1;
    } B;
  } NCF_S[3];

  uint8_t FCCU_reserved3[4];
  union {                              /* NCF Key Register */
    vuint32_t R;
    struct {
      vuint32_t NCFK:32;
    } B;
  } NCFK;

  union {                              /* NCF Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NCFE0:1;
      vuint32_t NCFE1:1;
      vuint32_t NCFE2:1;
      vuint32_t NCFE3:1;
      vuint32_t NCFE4:1;
      vuint32_t NCFE5:1;
      vuint32_t NCFE6:1;
      vuint32_t NCFE7:1;
      vuint32_t NCFE8:1;
      vuint32_t NCFE9:1;
      vuint32_t NCFE10:1;
      vuint32_t NCFE11:1;
      vuint32_t NCFE12:1;
      vuint32_t NCFE13:1;
      vuint32_t NCFE14:1;
      vuint32_t NCFE15:1;
      vuint32_t NCFE16:1;
      vuint32_t NCFE17:1;
      vuint32_t NCFE18:1;
      vuint32_t NCFE19:1;
      vuint32_t NCFE20:1;
      vuint32_t NCFE21:1;
      vuint32_t NCFE22:1;
      vuint32_t NCFE23:1;
      vuint32_t NCFE24:1;
      vuint32_t NCFE25:1;
      vuint32_t NCFE26:1;
      vuint32_t NCFE27:1;
      vuint32_t NCFE28:1;
      vuint32_t NCFE29:1;
      vuint32_t NCFE30:1;
      vuint32_t NCFE31:1;
    } B;
  } NCF_E[3];

  uint8_t FCCU_reserved4[4];
  union {                              /* NCF Time-out Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NCFTOE0:1;
      vuint32_t NCFTOE1:1;
      vuint32_t NCFTOE2:1;
      vuint32_t NCFTOE3:1;
      vuint32_t NCFTOE4:1;
      vuint32_t NCFTOE5:1;
      vuint32_t NCFTOE6:1;
      vuint32_t NCFTOE7:1;
      vuint32_t NCFTOE8:1;
      vuint32_t NCFTOE9:1;
      vuint32_t NCFTOE10:1;
      vuint32_t NCFTOE11:1;
      vuint32_t NCFTOE12:1;
      vuint32_t NCFTOE13:1;
      vuint32_t NCFTOE14:1;
      vuint32_t NCFTOE15:1;
      vuint32_t NCFTOE16:1;
      vuint32_t NCFTOE17:1;
      vuint32_t NCFTOE18:1;
      vuint32_t NCFTOE19:1;
      vuint32_t NCFTOE20:1;
      vuint32_t NCFTOE21:1;
      vuint32_t NCFTOE22:1;
      vuint32_t NCFTOE23:1;
      vuint32_t NCFTOE24:1;
      vuint32_t NCFTOE25:1;
      vuint32_t NCFTOE26:1;
      vuint32_t NCFTOE27:1;
      vuint32_t NCFTOE28:1;
      vuint32_t NCFTOE29:1;
      vuint32_t NCFTOE30:1;
      vuint32_t NCFTOE31:1;
    } B;
  } NCF_TOE[3];

  uint8_t FCCU_reserved5[4];
  union {                              /* NCF Time-out Register */
    vuint32_t R;
    struct {
      vuint32_t TO:32;
    } B;
  } NCF_TO;

  union {                              /* CFG Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TO:3;
    } B;
  } CFG_TO;

  union {                              /* IO Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t EIN1:1;
      vuint32_t EIN0:1;
      vuint32_t  :2;
      vuint32_t EOUT1:1;
      vuint32_t EOUT0:1;
    } B;
  } EINOUT;

  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t PhysicErrorPin:2;
      vuint32_t ESTAT:1;
      vuint32_t STATUS:3;
    } B;
  } STAT;

  union {                              /* NA Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t NAFS:8;
    } B;
  } N2AF_STATUS;

  union {                              /* AF Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t AF_SRC:2;
      vuint32_t AFFS:8;
    } B;
  } A2FF_STATUS;

  union {                              /* NF Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t NF_SRC:2;
      vuint32_t NFFS:8;
    } B;
  } N2FF_STATUS;

  union {                              /* FA Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t FAFS:9;
    } B;
  } F2A_STATUS;

  uint8_t FCCU_reserved6[8];
  union {                              /* NCF Fake Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t FNCFC:7;
    } B;
  } NCFF;

  union {                              /* IRQ Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t NMI_STAT:1;
      vuint32_t ALRM_STAT:1;
      vuint32_t CFG_TO_STAT:1;
    } B;
  } IRQ_STAT;

  union {                              /* IRQ Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t CFG_TO_IEN:1;
    } B;
  } IRQ_EN;

  union {                              /* XTMR Register */
    vuint32_t R;
    struct {
      vuint32_t XTMR:32;
    } B;
  } XTMR;

  union {                              /* MCS Register */
    vuint32_t R;
    struct {
      vuint32_t VL3:1;
      vuint32_t FS3:1;
      vuint32_t  :2;
      vuint32_t MCS3:4;
      vuint32_t VL2:1;
      vuint32_t FS2:1;
      vuint32_t  :2;
      vuint32_t MCS2:4;
      vuint32_t VL1:1;
      vuint32_t FS1:1;
      vuint32_t  :2;
      vuint32_t MCS1:4;
      vuint32_t VL0:1;
      vuint32_t FS0:1;
      vuint32_t  :2;
      vuint32_t MCS0:4;
    } B;
  } MCS;

  union {                              /* Transient Lock Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t TRANSKEY:9;
    } B;
  } TRANS_LOCK;

  union {                              /* Permanent Lock Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t PERMNTKEY:9;
    } B;
  } PERMNT_LOCK;

  union {                              /* Delta T Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t  :14;
      vuint32_t  :2;
      vuint32_t DELTA_T:14;
    } B;
  } DELTA_T;

  union {                              /* IRQ Alarm Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IRQEN0:1;
      vuint32_t IRQEN1:1;
      vuint32_t IRQEN2:1;
      vuint32_t IRQEN3:1;
      vuint32_t IRQEN4:1;
      vuint32_t IRQEN5:1;
      vuint32_t IRQEN6:1;
      vuint32_t IRQEN7:1;
      vuint32_t IRQEN8:1;
      vuint32_t IRQEN9:1;
      vuint32_t IRQEN10:1;
      vuint32_t IRQEN11:1;
      vuint32_t IRQEN12:1;
      vuint32_t IRQEN13:1;
      vuint32_t IRQEN14:1;
      vuint32_t IRQEN15:1;
      vuint32_t IRQEN16:1;
      vuint32_t IRQEN17:1;
      vuint32_t IRQEN18:1;
      vuint32_t IRQEN19:1;
      vuint32_t IRQEN20:1;
      vuint32_t IRQEN21:1;
      vuint32_t IRQEN22:1;
      vuint32_t IRQEN23:1;
      vuint32_t IRQEN24:1;
      vuint32_t IRQEN25:1;
      vuint32_t IRQEN26:1;
      vuint32_t IRQEN27:1;
      vuint32_t IRQEN28:1;
      vuint32_t IRQEN29:1;
      vuint32_t IRQEN30:1;
      vuint32_t IRQEN31:1;
    } B;
  } IRQ_ALARM_EN[3];

  uint8_t FCCU_reserved7[4];
  union {                              /* NMI Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NMIEN0:1;
      vuint32_t NMIEN1:1;
      vuint32_t NMIEN2:1;
      vuint32_t NMIEN3:1;
      vuint32_t NMIEN4:1;
      vuint32_t NMIEN5:1;
      vuint32_t NMIEN6:1;
      vuint32_t NMIEN7:1;
      vuint32_t NMIEN8:1;
      vuint32_t NMIEN9:1;
      vuint32_t NMIEN10:1;
      vuint32_t NMIEN11:1;
      vuint32_t NMIEN12:1;
      vuint32_t NMIEN13:1;
      vuint32_t NMIEN14:1;
      vuint32_t NMIEN15:1;
      vuint32_t NMIEN16:1;
      vuint32_t NMIEN17:1;
      vuint32_t NMIEN18:1;
      vuint32_t NMIEN19:1;
      vuint32_t NMIEN20:1;
      vuint32_t NMIEN21:1;
      vuint32_t NMIEN22:1;
      vuint32_t NMIEN23:1;
      vuint32_t NMIEN24:1;
      vuint32_t NMIEN25:1;
      vuint32_t NMIEN26:1;
      vuint32_t NMIEN27:1;
      vuint32_t NMIEN28:1;
      vuint32_t NMIEN29:1;
      vuint32_t NMIEN30:1;
      vuint32_t NMIEN31:1;
    } B;
  } NMI_EN[3];

  uint8_t FCCU_reserved8[4];
  union {                              /* EOUT Signaling Enable Register */
    vuint32_t R;
    struct {
      vuint32_t EOUTEN0:1;
      vuint32_t EOUTEN1:1;
      vuint32_t EOUTEN2:1;
      vuint32_t EOUTEN3:1;
      vuint32_t EOUTEN4:1;
      vuint32_t EOUTEN5:1;
      vuint32_t EOUTEN6:1;
      vuint32_t EOUTEN7:1;
      vuint32_t EOUTEN8:1;
      vuint32_t EOUTEN9:1;
      vuint32_t EOUTEN10:1;
      vuint32_t EOUTEN11:1;
      vuint32_t EOUTEN12:1;
      vuint32_t EOUTEN13:1;
      vuint32_t EOUTEN14:1;
      vuint32_t EOUTEN15:1;
      vuint32_t EOUTEN16:1;
      vuint32_t EOUTEN17:1;
      vuint32_t EOUTEN18:1;
      vuint32_t EOUTEN19:1;
      vuint32_t EOUTEN20:1;
      vuint32_t EOUTEN21:1;
      vuint32_t EOUTEN22:1;
      vuint32_t EOUTEN23:1;
      vuint32_t EOUTEN24:1;
      vuint32_t EOUTEN25:1;
      vuint32_t EOUTEN26:1;
      vuint32_t EOUTEN27:1;
      vuint32_t EOUTEN28:1;
      vuint32_t EOUTEN29:1;
      vuint32_t EOUTEN30:1;
      vuint32_t EOUTEN31:1;
    } B;
  } EOUT_SIG_EN[3];
};


/* ============================================================================
   =============================== Module: FR =================================
   ============================================================================ */

struct FR_tag {
  union {                              /* Module Version Register */
    vuint16_t R;
    struct {
      vuint16_t CHIVER:8;
      vuint16_t PEVER:8;
    } B;
  } MVR;

  union {                              /* Module Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MEN:1;
      vuint16_t SBFF:1;                /* System Bus Failure Freeze */
      vuint16_t SCM:1;
      vuint16_t CHB:1;
      vuint16_t CHA:1;
      vuint16_t SFFE:1;
      vuint16_t ECCE:1;
      vuint16_t  :1;                   /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
      vuint16_t FUM:1;
      vuint16_t FAM:1;
      vuint16_t  :1;
      vuint16_t CLKSEL:1;
      vuint16_t BITRATE:3;
      vuint16_t  :1;
    } B;
  } MCR;

  union {                              /* System Memory Base Address High Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:16;               /* System Memory Base Address high. This is the value of the system memory base address for the individual message buffers and sync frame table. This is the value of the system memory base address for the receive FIFO if the FIFO address mode bit FR_MCR[FAM] is set to 1. It is defines as a byte address. */
    } B;
  } SYMBADHR;

  union {                              /* System Memory Base Address Low Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:12;
      vuint16_t  :4;
    } B;
  } SYMBADLR;

  union {                              /* Strobe Signal Control Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :3;
      vuint16_t SEL:4;
      vuint16_t  :3;
      vuint16_t ENB:1;
      vuint16_t  :2;
      vuint16_t STBPSEL:2;
    } B;
  } STBSCR;

  uint8_t FR_reserved0[2];
  union {                              /* Message Buffer Data Size Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t MBSEG2DS:7;
      vuint16_t  :1;
      vuint16_t MBSEG1DS:7;
    } B;
  } MBDSR;

  union {                              /* Message Buffer Segment Size and Utilization Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t LAST_MB_SEG1:6;
      vuint16_t  :2;
      vuint16_t LAST_MB_UTIL:6;
    } B;
  } MBSSUTR;

  union {                              /* PE DRAM Access Register */
    vuint16_t R;
    struct {
      vuint16_t INST:4;
      vuint16_t ADDR:11;
      vuint16_t DAD:1;
    } B;
  } PEDRAR;

  union {                              /* PE DRAM Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } PEDRDR;

  union {                              /* Protocol Operation Control Register */
    vuint16_t R;
    struct {
      vuint16_t WME:1;
      vuint16_t  :3;
      vuint16_t EOC_AP:2;
      vuint16_t ERC_AP:2;
      vuint16_t BSY_WMC:1;
      vuint16_t  :3;
      vuint16_t POCCMD:4;
    } B;
  } POCR;

  union {                              /* Global Interrupt Flag and Enable Register */
    vuint16_t R;
    struct {
      vuint16_t MIF:1;
      vuint16_t PRIF:1;
      vuint16_t CHIF:1;
      vuint16_t WUPIF:1;
      vuint16_t FAFBIF:1;
      vuint16_t FAFAIF:1;
      vuint16_t RBIF:1;
      vuint16_t TBIF:1;
      vuint16_t MIE:1;
      vuint16_t PRIE:1;
      vuint16_t CHIE:1;
      vuint16_t WUPIE:1;
      vuint16_t FAFBIE:1;
      vuint16_t FAFAIE:1;
      vuint16_t RBIE:1;
      vuint16_t TBIE:1;
    } B;
  } GIFER;

  union {                              /* Protocol Interrupt Flag Register 0 */
    vuint16_t R;
    struct {
      vuint16_t FATL_IF:1;
      vuint16_t INTL_IF:1;
      vuint16_t ILCF_IF:1;
      vuint16_t CSA_IF:1;
      vuint16_t MRC_IF:1;
      vuint16_t MOC_IF:1;
      vuint16_t CCL_IF:1;
      vuint16_t MXS_IF:1;
      vuint16_t MTX_IF:1;
      vuint16_t LTXB_IF:1;
      vuint16_t LTXA_IF:1;
      vuint16_t TBVB_IF:1;
      vuint16_t TBVA_IF:1;
      vuint16_t TI2_IF:1;
      vuint16_t TI1_IF:1;
      vuint16_t CYS_IF:1;
    } B;
  } PIFR0;

  union {                              /* Protocol Interrupt Flag Register 1 */
    vuint16_t R;
    struct {
      vuint16_t EMC_IF:1;
      vuint16_t IPC_IF:1;
      vuint16_t PECF_IF:1;
      vuint16_t PSC_IF:1;
      vuint16_t SSI3_IF:1;
      vuint16_t SSI2_IF:1;
      vuint16_t SSI1_IF:1;
      vuint16_t SSI0_IF:1;
      vuint16_t  :2;
      vuint16_t EVT_IF:1;
      vuint16_t ODT_IF:1;
      vuint16_t  :4;
    } B;
  } PIFR1;

  union {                              /* Protocol Interrupt Enable Register 0 */
    vuint16_t R;
    struct {
      vuint16_t FATL_IE:1;
      vuint16_t INTL_IE:1;
      vuint16_t ILCF_IE:1;
      vuint16_t CSA_IE:1;
      vuint16_t MRC_IE:1;
      vuint16_t MOC_IE:1;
      vuint16_t CCL_IE:1;
      vuint16_t MXS_IE:1;
      vuint16_t MTX_IE:1;
      vuint16_t LTXB_IE:1;
      vuint16_t LTXA_IE:1;
      vuint16_t TBVB_IE:1;
      vuint16_t TBVA_IE:1;
      vuint16_t TI2_IE:1;
      vuint16_t TI1_IE:1;
      vuint16_t CYS_IE:1;
    } B;
  } PIER0;

  union {                              /* Protocol Interrupt Enable Register 1 */
    vuint16_t R;
    struct {
      vuint16_t EMC_IE:1;
      vuint16_t IPC_IE:1;
      vuint16_t PECF_IE:1;
      vuint16_t PSC_IE:1;
      vuint16_t SSI3_IE:1;
      vuint16_t SSI2_IE:1;
      vuint16_t SSI1_IE:1;
      vuint16_t SSI0_IE:1;
      vuint16_t  :2;
      vuint16_t EVT_IE:1;
      vuint16_t ODT_IE:1;
      vuint16_t  :4;
    } B;
  } PIER1;

  union {                              /* CHI Error Flag Register */
    vuint16_t R;
    struct {
      vuint16_t FRLB_EF:1;
      vuint16_t FRLA_EF:1;
      vuint16_t PCMI_EF:1;
      vuint16_t FOVB_EF:1;
      vuint16_t FOVA_EF:1;
      vuint16_t MBS_EF:1;
      vuint16_t MBU_EF:1;
      vuint16_t LCK_EF:1;
      vuint16_t  :1;
      vuint16_t SBCF_EF:1;
      vuint16_t FID_EF:1;
      vuint16_t DPL_EF:1;
      vuint16_t SPL_EF:1;
      vuint16_t NML_EF:1;
      vuint16_t NMF_EF:1;
      vuint16_t ILSA_EF:1;
    } B;
  } CHIERFR;

  union {                              /* Message Buffer Interrupt Vector Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t TBIVEC:6;
      vuint16_t  :2;
      vuint16_t RBIVEC:6;
    } B;
  } MBIVEC;

  union {                              /* Channel A Status Error Counter Register */
    vuint16_t R;
    struct {
      vuint16_t CHAERSCNT:16;
    } B;
  } CASERCR;

  union {                              /* Channel B Status Error Counter Register */
    vuint16_t R;
    struct {
      vuint16_t CHBERSCNT:16;
    } B;
  } CBSERCR;

  union {                              /* Protocol Status Register 0 */
    vuint16_t R;
    struct {
      vuint16_t ERRMODE:2;
      vuint16_t SLOTMODE:2;
      vuint16_t  :1;
      vuint16_t PROTSTATE:3;
      vuint16_t STARTUPSTATE:4;
      vuint16_t  :1;
      vuint16_t WAKEUPSTATUS:3;
    } B;
  } PSR0;

  union {                              /* Protocol Status Register 1 */
    vuint16_t R;
    struct {
      vuint16_t CSAA:1;
      vuint16_t CSP:1;
      vuint16_t  :1;
      vuint16_t REMCSAT:5;
      vuint16_t CPN:1;
      vuint16_t HHR:1;
      vuint16_t FRZ:1;
      vuint16_t APTAC:5;
    } B;
  } PSR1;

  union {                              /* Protocol Status Register 2 */
    vuint16_t R;
    struct {
      vuint16_t NBVB:1;
      vuint16_t NSEB:1;
      vuint16_t STCB:1;
      vuint16_t SBVB:1;
      vuint16_t SSEB:1;
      vuint16_t MTB:1;
      vuint16_t NBVA:1;
      vuint16_t NSEA:1;
      vuint16_t STCA:1;
      vuint16_t SBVA:1;
      vuint16_t SSEA:1;
      vuint16_t MTA:1;
      vuint16_t CKCORFCNT:4;
    } B;
  } PSR2;

  union {                              /* Protocol Status Register 3 */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t WUB:1;
      vuint16_t ABVB:1;
      vuint16_t AACB:1;
      vuint16_t ACEB:1;
      vuint16_t ASEB:1;
      vuint16_t AVFB:1;
      vuint16_t  :2;
      vuint16_t WUA:1;
      vuint16_t ABVA:1;
      vuint16_t AACA:1;
      vuint16_t ACEA:1;
      vuint16_t ASEA:1;
      vuint16_t AVFA:1;
    } B;
  } PSR3;

  union {                              /* Macrotick Counter Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t MTCT:14;
    } B;
  } MTCTR;

  union {                              /* Cycle Counter Register */
    vuint16_t R;
    struct {
      vuint16_t  :10;
      vuint16_t CYCCNT:6;
    } B;
  } CYCTR;

  union {                              /* Slot Counter Channel A Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t SLOTCNTA:11;
    } B;
  } SLTCTAR;

  union {                              /* Slot Counter Channel B Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t SLOTCNTB:11;
    } B;
  } SLTCTBR;

  union {                              /* Rate Correction Value Register */
    vuint16_t R;
    struct {
      vuint16_t RATECORR:16;
    } B;
  } RTCORVR;

  union {                              /* Offset Correction Value Register */
    vuint16_t R;
    struct {
      vuint16_t OFFSETCORR:16;
    } B;
  } OFCORVR;

  union {                              /* Combined Interrupt Flag Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t MIF:1;
      vuint16_t PRIF:1;
      vuint16_t CHIF:1;
      vuint16_t WUPIF:1;
      vuint16_t FAFBIF:1;
      vuint16_t FAFAIF:1;
      vuint16_t RBIF:1;
      vuint16_t TBIF:1;
    } B;
  } CIFR;

  union {                              /* System Memory Access Time-Out Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t TIMEOUT:8;
    } B;
  } SYMATOR;

  union {                              /* Sync Frame Counter Register */
    vuint16_t R;
    struct {
      vuint16_t SFEVB:4;
      vuint16_t SFEVA:4;
      vuint16_t SFODB:4;
      vuint16_t SFODA:4;
    } B;
  } SFCNTR;

  union {                              /* Sync Frame Table Offset Register */
    vuint16_t R;
    struct {
      vuint16_t SFT_OFFSET:15;
      vuint16_t  :1;
    } B;
  } SFTOR;

  union {                              /* Sync Frame Table Configuration, Control, Status Register */
    vuint16_t R;
    struct {
      vuint16_t ELKT:1;
      vuint16_t OLKT:1;
      vuint16_t CYCNUM:6;
      vuint16_t ELKS:1;
      vuint16_t OLKS:1;
      vuint16_t EVAL:1;
      vuint16_t OVAL:1;
      vuint16_t  :1;
      vuint16_t OPT:1;
      vuint16_t SDVEN:1;
      vuint16_t SIDEN:1;
    } B;
  } SFTCCSR;

  union {                              /* Sync Frame ID Rejection Filter Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t SYNFRID:10;
    } B;
  } SFIDRFR;

  union {                              /* Sync Frame ID Acceptance Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t FVAL:10;
    } B;
  } SFIDAFVR;

  union {                              /* Sync Frame ID Acceptance Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t FMSK:10;
    } B;
  } SFIDAFMR;

  union {                              /* Network Management Vector Register */
    vuint16_t R;
    struct {
      vuint16_t NMVP:16;
    } B;
  } NMVR[6];

  union {                              /* Network Management Vector Length Register */
    vuint16_t R;
    struct {
      vuint16_t  :12;
      vuint16_t NMVL:4;
    } B;
  } NMVLR;

  union {                              /* Timer Configuration and Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T2_CFG:1;
      vuint16_t T2_REP:1;
      vuint16_t  :1;
      vuint16_t T2SP:1;
      vuint16_t T2TR:1;
      vuint16_t T2ST:1;
      vuint16_t  :3;
      vuint16_t T1_REP:1;
      vuint16_t  :1;
      vuint16_t T1SP:1;
      vuint16_t T1TR:1;
      vuint16_t T1ST:1;
    } B;
  } TICCR;

  union {                              /* Timer 1 Cycle Set Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T1_CYC_VAL:6;
      vuint16_t  :2;
      vuint16_t T1_CYC_MSK:6;
    } B;
  } TI1CYSR;

  union {                              /* Timer 1 Macrotick Offset Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T1_MTOFFSET:14;
    } B;
  } TI1MTOR;

  union {
    union {                            /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t T2CYCVAL:6;          /* Timer T2 Cycle Filter Mask */
        vuint16_t  :2;
        vuint16_t T2CYCMSK:6;          /* Timer T2 Cycle Filter Mask */
      } B;
    } ABS;
    union {                            /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t T2MTCNT:16;          /* Timer T2 Macrotick High Word */
      } B;
    } REL;
  } TI2CR0;

  union {
    union {                            /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t T2MOFF:14;           /* Timer T2 Macrotick Offset */
      } B;
    } ABS;
    union {                            /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t T2MTCNT:16;
      } B;
    } REL;
  } TI2CR1;

  union {                              /* Slot Status Selection Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t SLOTNUMBER:11;
    } B;
  } SSSR;

  union {                              /* Slot Status Counter Condition Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t CNTCFG:2;
      vuint16_t MCY:1;
      vuint16_t VFR:1;
      vuint16_t SYF:1;
      vuint16_t NUF:1;
      vuint16_t SUF:1;
      vuint16_t STATUSMASK:4;
    } B;
  } SSCCR;

  union {                              /* Slot Status Register */
    vuint16_t R;
    struct {
      vuint16_t VFB:1;
      vuint16_t SYB:1;
      vuint16_t NFB:1;
      vuint16_t SUB:1;
      vuint16_t SEB:1;
      vuint16_t CEB:1;
      vuint16_t BVB:1;
      vuint16_t TCB:1;
      vuint16_t VFA:1;
      vuint16_t SYA:1;
      vuint16_t NFA:1;
      vuint16_t SUA:1;
      vuint16_t SEA:1;
      vuint16_t CEA:1;
      vuint16_t BVA:1;
      vuint16_t TCA:1;
    } B;
  } SSR[8];

  union {                              /* Slot Status Counter Register */
    vuint16_t R;
    struct {
      vuint16_t SLOTSTATUSCNT:16;
    } B;
  } SSCR[4];

  union {                              /* MTS A Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MTE:1;
      vuint16_t  :1;
      vuint16_t CYCCNTMSK:6;
      vuint16_t  :2;
      vuint16_t CYCCNTVAL:6;
    } B;
  } MTSACFR;

  union {                              /* MTS B Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MTE:1;
      vuint16_t  :1;
      vuint16_t CYCCNTMSK:6;
      vuint16_t  :2;
      vuint16_t CYCCNTVAL:6;
    } B;
  } MTSBCFR;

  union {                              /* Receive Shadow Buffer Index Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :5;
      vuint16_t RSBIDX:7;              /* RSBIDXA1/RSBIDXA2/RSBIDXB1/RSBIDXB2- Receive Shadow Buffer Index */
    } B;
  } RSBIR;

  union {                              /* Receive FIFO Watermark and Selection Register */
    vuint16_t R;
    struct {
      vuint16_t WM:8;                  /* WMA/WMB - Watermark */
      vuint16_t  :7;
      vuint16_t SEL:1;
    } B;
  } RFWMSR;

  union {                              /* Receive FIFO Start Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t SIDX:10;               /* SIDXA/SIDXB - Start Index */
    } B;
  } RFSIR;

  union {                              /* Receive FIFO Depth and Size Register */
    vuint16_t R;
    struct {
      vuint16_t FIFO_DEPTH:8;          /* FIFO_DEPTHA/FIFO_DEPTHB - FIFO Depth */
      vuint16_t  :1;
      vuint16_t ENTRY_SIZE:7;          /* ENTRY_SIZEA/ENTRY_SIZEB - Entry Size */
    } B;
  } RFDSR;

  union {                              /* Receive FIFO A Read Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t RDIDX:10;
    } B;
  } RFARIR;

  union {                              /* Receive FIFO B Read Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t RDIDX:10;
    } B;
  } RFBRIR;

  union {                              /* Receive FIFO Message ID Acceptance Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t MIDAFVAL:16;           /* MIDAFVALA/MIDAFVALB - Message ID Acceptance Filter Value */
    } B;
  } RFMIDAFVR;

  union {                              /* Receive FIFO Message ID Acceptance Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t MIDAFMSK:16;           /* MIDAFMSKA/MIDAFMSKB - Message ID Acceptance Filter Mask */
    } B;
  } RFMIDAFMR;

  union {                              /* Receive FIFO Frame ID Rejection Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t FIDRFVAL:11;           /* FIDRFVALA/FIDRFVALB - Frame ID Rejection Filter Value */
    } B;
  } RFFIDRFVR;

  union {                              /* Receive FIFO Frame ID Rejection Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t FIDRFMSK:11;
    } B;
  } RFFIDRFMR;

  union {                              /* Receive FIFO Range Filter Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t IBD:1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t SID:11;                /* Slot ID */
    } B;
  } RFRFCFR;

  union {                              /* Receive FIFO Range Filter Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :4;
      vuint16_t F3MD:1;
      vuint16_t F2MD:1;
      vuint16_t F1MD:1;
      vuint16_t F0MD:1;
      vuint16_t  :4;
      vuint16_t F3EN:1;
      vuint16_t F2EN:1;
      vuint16_t F1EN:1;
      vuint16_t F0EN:1;
    } B;
  } RFRFCTR;

  union {                              /* Last Dynamic Transmit Slot Channel A Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t LDYNTXSLOTA:11;
    } B;
  } LDTXSLAR;

  union {                              /* Last Dynamic Transmit Slot Channel B Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t LDYNTXSLOTB:11;
    } B;
  } LDTXSLBR;

  union {                              /* Protocol Configuration Register 0 */
    vuint16_t R;
    struct {
      vuint16_t action_point_offset:6;
      vuint16_t static_slot_length:10;
    } B;
  } PCR0;

  union {                              /* Protocol Configuration Register 1 */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t macro_after_first_static_slot:14;
    } B;
  } PCR1;

  union {                              /* Protocol Configuration Register 2 */
    vuint16_t R;
    struct {
      vuint16_t minislot_after_action_point:6;
      vuint16_t number_of_static_slots:10; /* gNumberOfStaticSlots */
    } B;
  } PCR2;

  union {                              /* Protocol Configuration Register 3 */
    vuint16_t R;
    struct {
      vuint16_t wakeup_symbol_rx_low:6;
      vuint16_t minislot_action_point_offset:5;
      vuint16_t coldstart_attempts:5;
    } B;
  } PCR3;

  union {                              /* Protocol Configuration Register 4 */
    vuint16_t R;
    struct {
      vuint16_t cas_rx_low_max:7;
      vuint16_t wakeup_symbol_rx_window:9;
    } B;
  } PCR4;

  union {                              /* Protocol Configuration Register 5 */
    vuint16_t R;
    struct {
      vuint16_t tss_transmitter:4;
      vuint16_t wakeup_symbol_tx_low:6;
      vuint16_t wakeup_symbol_rx_idle:6;
    } B;
  } PCR5;

  union {                              /* Protocol Configuration Register 6 */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t symbol_window_after_action_point:8;
      vuint16_t macro_initial_offset_a:7;
    } B;
  } PCR6;

  union {                              /* Protocol Configuration Register 7 */
    vuint16_t R;
    struct {
      vuint16_t decoding_correction_b:9;
      vuint16_t micro_per_macro_nom_half:7;
    } B;
  } PCR7;

  union {                              /* Protocol Configuration Register 8 */
    vuint16_t R;
    struct {
      vuint16_t max_without_clock_correction_fatal:4;
      vuint16_t max_without_clock_correction_passive:4;
      vuint16_t wakeup_symbol_tx_idle:8;
    } B;
  } PCR8;

  union {                              /* Protocol Configuration Register 9 */
    vuint16_t R;
    struct {
      vuint16_t minislot_exists:1;
      vuint16_t symbol_window_exists:1;
      vuint16_t offset_correction_out:14;
    } B;
  } PCR9;

  union {                              /* Protocol Configuration Register 10 */
    vuint16_t R;
    struct {
      vuint16_t single_slot_enabled:1;
      vuint16_t wakeup_channel:1;
      vuint16_t macro_per_cycle:14;
    } B;
  } PCR10;

  union {                              /* Protocol Configuration Register 11 */
    vuint16_t R;
    struct {
      vuint16_t key_slot_used_for_startup:1;
      vuint16_t key_slot_used_for_sync:1;
      vuint16_t offset_correction_start:14;
    } B;
  } PCR11;

  union {                              /* Protocol Configuration Register 12 */
    vuint16_t R;
    struct {
      vuint16_t allow_passive_to_active:5;
      vuint16_t key_slot_header_crc:11;
    } B;
  } PCR12;

  union {                              /* Protocol Configuration Register 13 */
    vuint16_t R;
    struct {
      vuint16_t first_minislot_action_point_offset:6;
      vuint16_t static_slot_after_action_point:10;
    } B;
  } PCR13;

  union {                              /* Protocol Configuration Register 14 */
    vuint16_t R;
    struct {
      vuint16_t rate_correction_out:11;
      vuint16_t listen_timeout:5;
    } B;
  } PCR14;

  union {                              /* Protocol Configuration Register 15 */
    vuint16_t R;
    struct {
      vuint16_t listen_timeout:16;
    } B;
  } PCR15;

  union {                              /* Protocol Configuration Register 16 */
    vuint16_t R;
    struct {
      vuint16_t macro_initial_offset_b:7;
      vuint16_t noise_listen_timeout:9;
    } B;
  } PCR16;

  union {                              /* Protocol Configuration Register 17 */
    vuint16_t R;
    struct {
      vuint16_t noise_listen_timeout:16;
    } B;
  } PCR17;

  union {                              /* Protocol Configuration Register 18 */
    vuint16_t R;
    struct {
      vuint16_t wakeup_pattern:6;
      vuint16_t key_slot_id:10;
    } B;
  } PCR18;

  union {                              /* Protocol Configuration Register 19 */
    vuint16_t R;
    struct {
      vuint16_t decoding_correction_a:9;
      vuint16_t payload_length_static:7;
    } B;
  } PCR19;

  union {                              /* Protocol Configuration Register 20 */
    vuint16_t R;
    struct {
      vuint16_t micro_initial_offset_b:8;
      vuint16_t micro_initial_offset_a:8;
    } B;
  } PCR20;

  union {                              /* Protocol Configuration Register 21 */
    vuint16_t R;
    struct {
      vuint16_t extern_rate_correction:3;
      vuint16_t latest_tx:13;
    } B;
  } PCR21;

  union {                              /* Protocol Configuration Register 22 */
    vuint16_t R;
    struct {
      vuint16_t  :1;                   /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
      vuint16_t comp_accepted_startup_range_a:11;
      vuint16_t micro_per_cycle:4;
    } B;
  } PCR22;

  union {                              /* Protocol Configuration Register 23 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle:16;
    } B;
  } PCR23;

  union {                              /* Protocol Configuration Register 24 */
    vuint16_t R;
    struct {
      vuint16_t cluster_drift_damping:5;
      vuint16_t max_payload_length_dynamic:7;
      vuint16_t micro_per_cycle_min:4;
    } B;
  } PCR24;

  union {                              /* Protocol Configuration Register 25 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle_min:16;
    } B;
  } PCR25;

  union {                              /* Protocol Configuration Register 26 */
    vuint16_t R;
    struct {
      vuint16_t allow_halt_due_to_clock:1;
      vuint16_t comp_accepted_startup_range_b:11;
      vuint16_t micro_per_cycle_max:4;
    } B;
  } PCR26;

  union {                              /* Protocol Configuration Register 27 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle_max:16;
    } B;
  } PCR27;

  union {                              /* Protocol Configuration Register 28 */
    vuint16_t R;
    struct {
      vuint16_t dynamic_slot_idle_phase:2;
      vuint16_t macro_after_offset_correction:14;
    } B;
  } PCR28;

  union {                              /* Protocol Configuration Register 29 */
    vuint16_t R;
    struct {
      vuint16_t extern_offset_correction:3;
      vuint16_t minislots_max:13;
    } B;
  } PCR29;

  union {                              /* Protocol Configuration Register 30 */
    vuint16_t R;
    struct {
      vuint16_t  :12;
      vuint16_t sync_node_max:4;
    } B;
  } PCR30;

  uint8_t FR_reserved1[4];
  union {                              /* Protocol Event Output Enable Register */
    vuint16_t R;
    struct {
      vuint16_t  :13;
      vuint16_t TIM2_EE:1;
      vuint16_t TIM1_EE:1;
      vuint16_t CYC_EE:1;
    } B;
  } PEOER;

  uint8_t FR_reserved2[2];
  union {                              /* Receive FIFO Start Data Offset Register */
    vuint16_t R;
    struct {
      vuint16_t SDO:16;                /* SDOA/SDOB - Start Data Field Offset */
    } B;
  } RFSDOR;

  union {                              /* Receive FIFO System Memory Base Address High Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:16;
    } B;
  } RFSYMBADHR;

  union {                              /* Receive FIFO System Memory Base Address Low Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:12;
      vuint16_t  :4;
    } B;
  } RFSYMBADLR;

  union {                              /* Receive FIFO Periodic Timer Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t PTD:14;
    } B;
  } RFPTR;

  union {                              /* Receive FIFO Fill Level and POP Count Register */
    vuint16_t R;
    struct {
      vuint16_t FLB_or_PCB:8;
      vuint16_t FLA_or_PCA:8;
    } B;
  } RFFLPCR;

  union {                              /* ECC Error Interrupt Flag and Enable Register */
    vuint16_t R;
    struct {
      vuint16_t LRNE_OF:1;
      vuint16_t LRCE_OF:1;
      vuint16_t DRNE_OF:1;
      vuint16_t DRCE_OF:1;
      vuint16_t LRNE_IF:1;
      vuint16_t LRCE_IF:1;
      vuint16_t DRNE_IF:1;
      vuint16_t DRCE_IF:1;
      vuint16_t  :4;
      vuint16_t LRNE_IE:1;
      vuint16_t LRCE_IE:1;
      vuint16_t DRNE_IE:1;
      vuint16_t DRCE_IE:1;
    } B;
  } EEIFER;

  union {                              /* ECC Error Report and Injection Control Register */
    vuint16_t R;
    struct {
      vuint16_t BSY:1;
      vuint16_t  :5;
      vuint16_t ERS:2;
      vuint16_t  :3;
      vuint16_t ERM:1;
      vuint16_t  :2;
      vuint16_t EIM:1;
      vuint16_t EIE:1;
    } B;
  } EERICR;

  union {                              /* ECC Error Report Address Register */
    vuint16_t R;
    struct {
      vuint16_t MID:1;
      vuint16_t BANK:3;
      vuint16_t ADDR:12;
    } B;
  } EERAR;

  union {                              /* ECC Error Report Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } EERDR;

  union {                              /* ECC Error Report Code Register */
    vuint16_t R;
    struct {
      vuint16_t  :11;
      vuint16_t CODE:5;
    } B;
  } EERCR;

  union {                              /* ECC Error Injection Address Register */
    vuint16_t R;
    struct {
      vuint16_t MID:1;
      vuint16_t BANK:3;
      vuint16_t ADDR:12;
    } B;
  } EEIAR;

  union {                              /* ECC Error Injection Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } EEIDR;

  union {                              /* ECC Error Injection Code Register */
    vuint16_t R;
    struct {
      vuint16_t  :11;
      vuint16_t CODE:5;
    } B;
  } EEICR;

  uint8_t FR_reserved3[1792];
  struct {
    union {                            /* Message Buffer Configuration, Control, Status Register */
      vuint16_t R;
      struct {
        vuint16_t  :3;
        vuint16_t MTD:1;
        vuint16_t CMT:1;
        vuint16_t EDT:1;
        vuint16_t LCKT:1;
        vuint16_t MBIE:1;
        vuint16_t  :3;
        vuint16_t DUP:1;
        vuint16_t DVAL:1;
        vuint16_t EDS:1;
        vuint16_t LCKS:1;
        vuint16_t MBIF:1;
      } B;
    } CCSR;
    union {                            /* Message Buffer Cycle Counter Filter Register */
      vuint16_t R;
      struct {
        vuint16_t MTM:1;
        vuint16_t CHA:1;
        vuint16_t CHB:1;
        vuint16_t CCFE:1;
        vuint16_t CCFMSK:6;
        vuint16_t CCFVAL:6;
      } B;
    } CCFR;
    union {                            /* Message Buffer Frame ID Register */
      vuint16_t R;
      struct {
        vuint16_t  :5;
        vuint16_t FID:11;
      } B;
    } FIDR;
    union {                            /* Message Buffer Index Register */
      vuint16_t R;
      struct {
        vuint16_t  :9;
        vuint16_t MBIDX:7;
      } B;
    } IDXR;
  } MB[64];

  uint8_t FR_reserved4[1536];
  union {                              /* Message Buffer Data Field Offset Register */
    vuint16_t R;
    struct {
      vuint16_t MBDO:16;
    } B;
  } MBDOR[68];

  uint8_t FR_reserved5[8];
  union {                              /* LRAM ECC Error Test Register */
    vuint16_t R;
    struct {
      vuint16_t LEETD:16;
    } B;
  } LEETR[6];
};


/* ============================================================================
   =============================== Module: FlexPWM ============================
   ============================================================================ */

struct FlexPWM_tag {
  struct {
    union {                            /* Submodule n Counter Register */
      vuint16_t R;
      struct {
        vuint16_t CNT:16;              /* Count */
      } B;
    } CNT;
    union {                            /* Submodule n Initial Count Register */
      vuint16_t R;
      struct {
        vuint16_t INIT:16;             /* Initial count */
      } B;
    } INIT;
    union {                            /* Submodule n Control 2 Register */
      vuint16_t R;
      struct {
        vuint16_t DBGEN:1;             /* Debug Enable */
        vuint16_t  :1;
        vuint16_t INDEP:1;             /* Independent or Complementary Pair Operation */
        vuint16_t PWM23_INIT:1;        /* PWM23 Initial Value */
        vuint16_t PWM45_INIT:1;        /* PWM45 Initial Value */
        vuint16_t PWMX_INIT:1;         /* PWMX Initial Value */
        vuint16_t INIT_SEL:2;          /* Initialization Control Select */
        vuint16_t FRCEN:1;             /* Force Initialization Enable */
        vuint16_t FORCE:1;             /* Force Initialization */
        vuint16_t FORCE_SEL:3;         /* Force Source Select */
        vuint16_t RELOAD_SEL:1;        /* Reload Source Select */
        vuint16_t CLK_SEL:2;           /* Clock Source Select */
      } B;
    } CTRL2;
    union {                            /* Submodule n Control 1 Register */
      vuint16_t R;
      struct {
        vuint16_t LDFQ:4;              /* Load Frequency */
        vuint16_t HALF:1;              /* Half Cycle Reload */
        vuint16_t FULL:1;              /* Full Cycle Reload */
        vuint16_t DT:2;                /* Deadtime */
        vuint16_t  :1;
        vuint16_t PRSC:3;              /* Prescaler */
        vuint16_t PHSSHFT:1;           /* Phase Shift Mode Enable */
        vuint16_t LDMOD:1;             /* Load Mode Select */
        vuint16_t  :1;
        vuint16_t DBLEN:1;             /* Double Switching Enable */
      } B;
    } CTRL1;
    union {                            /* Submodule n Value Register 0 */
      vuint16_t R;
      struct {
        vuint16_t VAL0:16;             /* Value 0 */
      } B;
    } VAL0;
    union {                            /* Submodule n Value Register 1 */
      vuint16_t R;
      struct {
        vuint16_t VAL1:16;             /* Value 1 */
      } B;
    } VAL1;
    union {                            /* Submodule n Value Register 2 */
      vuint16_t R;
      struct {
        vuint16_t VAL2:16;             /* Value 2 */
      } B;
    } VAL2;
    union {                            /* Submodule n Value Register 3 */
      vuint16_t R;
      struct {
        vuint16_t VAL3:16;             /* Value 3 */
      } B;
    } VAL3;
    union {                            /* Submodule n Value Register 4 */
      vuint16_t R;
      struct {
        vuint16_t VAL4:16;
      } B;
    } VAL4;
    union {                            /* Submodule n Value Register 5 */
      vuint16_t R;
      struct {
        vuint16_t VAL5:16;
      } B;
    } VAL5;
    uint8_t SUB_reserved0[4];
    union {                            /* Submodule n Output Control Register */
      vuint16_t R;
      struct {
        vuint16_t  :1;
        vuint16_t  :1;
        vuint16_t PWMX_IN:1;
        vuint16_t  :2;
        vuint16_t POLA:1;
        vuint16_t POLB:1;
        vuint16_t POLX:1;
        vuint16_t  :2;
        vuint16_t PWMAFS:2;            /* PWMA Fault State */
        vuint16_t PWMBFS:2;            /* PWMB Fault State */
        vuint16_t PWMXFS:2;            /* PWMX Fault State */
      } B;
    } OCTRL;
    union {                            /* Submodule n Status Register */
      vuint16_t R;
      struct {
        vuint16_t  :1;
        vuint16_t RUF:1;
        vuint16_t REF:1;
        vuint16_t RF:1;
        vuint16_t  :4;
        vuint16_t CFX1:1;
        vuint16_t CFX0:1;
        vuint16_t CMPF:6;
      } B;
    } STS;
    union {                            /* Submodule n Interrupt Enable Register */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t REIE:1;
        vuint16_t RIE:1;
        vuint16_t  :4;
        vuint16_t CX1IE:1;
        vuint16_t CX0IE:1;
        vuint16_t CMPIE:6;
      } B;
    } INTEN;
    union {                            /* Submodule n DMA Enable Register */
      vuint16_t R;
      struct {
        vuint16_t  :6;
        vuint16_t VALDE:1;
        vuint16_t FAND:1;
        vuint16_t CAPTDE:2;
        vuint16_t  :4;
        vuint16_t CX1DE:1;
        vuint16_t CX0DE:1;
      } B;
    } DMAEN;
    union {                            /* Submodule n Output Trigger Control Register */
      vuint16_t R;
      struct {
        vuint16_t  :10;
        vuint16_t OUT_TRIG_EN:6;
      } B;
    } TCTRL;
    union {                            /* Submodule n Fault Disable Mapping Register */
      vuint16_t R;
      struct {
        vuint16_t  :4;
        vuint16_t DISX:4;
        vuint16_t DISB:4;
        vuint16_t DISA:4;
      } B;
    } DISMAP;
    union {                            /* Submodule n Deadtime Count Register 0 */
      vuint16_t R;
      struct {
        vuint16_t  :5;
        vuint16_t DTCNT0:11;
      } B;
    } DTCNT0;
    union {                            /* Submodule n Deadtime Count Register 1 */
      vuint16_t R;
      struct {
        vuint16_t  :5;
        vuint16_t DTCNT1:11;
      } B;
    } DTCNT1;
    uint8_t SUB_reserved1[8];
    union {                            /* Submodule n Capture Control X Register */
      vuint16_t R;
      struct {
        vuint16_t CX1CNT:3;
        vuint16_t CX0CNT:3;
        vuint16_t CFXWM:2;             /* Capture X FIFOs Watermark */
        vuint16_t EDGCNTX_EN:1;
        vuint16_t INPSELX:1;
        vuint16_t EDGX1:2;
        vuint16_t EDGX0:2;
        vuint16_t ONESHOTX:1;
        vuint16_t ARMX:1;
      } B;
    } CAPTCTRLX;
    union {                            /* Submodule n Capture Compare X Register */
      vuint16_t R;
      struct {
        vuint16_t EDGCNTX:8;
        vuint16_t EDGCMPX:8;
      } B;
    } CAPTCMPX;
    union {                            /* Submodule n Capture Value 0 Register */
      vuint16_t R;
      struct {
        vuint16_t CAPTVAL0:16;
      } B;
    } CVAL0;
    union {                            /* Submodule n Capture Value 0 Cycle Register */
      vuint16_t R;
      struct {
        vuint16_t  :13;
        vuint16_t CVAL0CYC:3;          /* CVAL0 Cycle */
      } B;
    } CVAL0CYC;
    union {                            /* Submodule n Capture Value 1 Register */
      vuint16_t R;
      struct {
        vuint16_t CAPTVAL1:16;
      } B;
    } CVAL1;
    union {                            /* Submodule n Capture Value 1 Cycle Register */
      vuint16_t R;
      struct {
        vuint16_t  :13;
        vuint16_t CVAL1CYC:3;          /* CVAL1 Cycle */
      } B;
    } CVAL1CYC;
    uint8_t SUB_reserved2[20];
  } SUB[4];

  union {                              /* Output Enable Register */
    vuint16_t R;
    struct {
      vuint16_t  :4;
      vuint16_t PWMA_EN:4;
      vuint16_t PWMB_EN:4;
      vuint16_t PWMX_EN:4;
    } B;
  } OUTEN;

  union {                              /* Mask Register */
    vuint16_t R;
    struct {
      vuint16_t UPDATE_MASK:4;         /* Update Mask */
      vuint16_t MASKA:4;
      vuint16_t MASKB:4;
      vuint16_t MASKX:4;
    } B;
  } MASK;

  union {                              /* Software Controlled Output Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t OUT23_3:1;
      vuint16_t OUT45_3:1;
      vuint16_t OUT23_2:1;
      vuint16_t OUT45_2:1;
      vuint16_t OUT23_1:1;
      vuint16_t OUT45_1:1;
      vuint16_t OUT23_0:1;
      vuint16_t OUT45_0:1;
    } B;
  } SWCOUT;

  union {                              /* Deadtime Source Select Register */
    vuint16_t R;
    struct {
      vuint16_t SEL23_3:2;
      vuint16_t SEL45_3:2;
      vuint16_t SEL23_2:2;
      vuint16_t SEL45_2:2;
      vuint16_t SEL23_1:2;
      vuint16_t SEL45_1:2;
      vuint16_t SEL23_0:2;
      vuint16_t SEL45_0:2;
    } B;
  } DTSRCSEL;

  union {                              /* Master Control Register */
    vuint16_t R;
    struct {
      vuint16_t IPOL:4;                /* Current Polarity */
      vuint16_t RUN:4;                 /* Run */
      vuint16_t CLDOK:4;               /* Clear Load Okay */
      vuint16_t LDOK:4;                /* Load Okay */
    } B;
  } MCTRL;

  uint8_t FlexPWM_reserved0[2];
  union {                              /* Fault Control Register */
    vuint16_t R;
    struct {
      vuint16_t FLVL:4;
      vuint16_t FAUTO:4;
      vuint16_t FSAFE:4;
      vuint16_t FIE:4;
    } B;
  } FCTRL;

  union {                              /* Fault Status Register */
    vuint16_t R;
    struct {
      vuint16_t  :3;
      vuint16_t FTEST:1;
      vuint16_t FFPIN:4;
      vuint16_t FFULL:4;
      vuint16_t FFLAG:4;
    } B;
  } FSTS;

  union {                              /* Fault Filter Register */
    vuint16_t R;
    struct {
      vuint16_t GSTR:1;
      vuint16_t  :4;
      vuint16_t FILT_CNT:3;
      vuint16_t FILT_PER:8;
    } B;
  } FFILT;
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

struct INTC_tag {
  union {                              /* INTC Block Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t HVEN3:1;
      vuint32_t  :3;
      vuint32_t HVEN2:1;
      vuint32_t  :3;
      vuint32_t HVEN1:1;
      vuint32_t  :3;
      vuint32_t HVEN0:1;
    } B;
  } BCR;

  uint8_t INTC_reserved0[12];
  union {                              /* INTC Current Priority Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t PRI:5;
    } B;
  } CPR[1];

  uint8_t INTC_reserved1[12];
  union {                              /* INTC Interrupt Acknowledge Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t VTBA:20;
      vuint32_t INTVEC:10;
      vuint32_t  :2;
    } B;
  } IACKR[1];

  uint8_t INTC_reserved2[12];
  union {                              /* INTC End Of Interrupt Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t EOI:32;
    } B;
  } EOIR[1];

  uint8_t INTC_reserved3[12];
  union {                              /* INTC Software Set/Clear Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t  :6;
      vuint8_t SETN:1;
      vuint8_t CLRN:1;
    } B;
  } SSCIR[16];

  uint8_t INTC_reserved4[16];
  union {                              /* INTC Priority Select Register */
    vuint16_t R;
    struct {
      vuint16_t PRC_SELN:4;
      vuint16_t  :3;
      vuint16_t SWTN:1;
      vuint16_t  :3;
      vuint16_t PRIN:5;
    } B;
  } PSR[1024];

  uint8_t INTC_reserved5[1952];
  union {                              /* INTC Monitor Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t MM:2;
    } B;
  } MMRC[1];

  union {                              /* INTC HIPRI Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t IRQ:10;
    } B;
  } HIPRIC0[4];

  union {                              /* INTC LAT Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t LAT:24;
    } B;
  } LATC0[4];

  union {                              /* INTC Timer Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TIMER:24;
    } B;
  } TIMERC0[4];
};


/* ============================================================================
   =============================== Module: IRCOSC =============================
   ============================================================================ */

struct IRCOSC_tag {
  union {                              /* IRCOSC Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t USER_TRIM:5;
      vuint32_t  :3;
      vuint32_t  :5;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t  :5;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: LFAST ==============================
   ============================================================================ */

struct LFAST_tag {
  union {                              /* LFAST Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MSEN:1;
      vuint32_t  :6;
      vuint32_t IPGDBG:1;
      vuint32_t  :7;
      vuint32_t LSSEL:1;
      vuint32_t DRFEN:1;
      vuint32_t RXEN:1;
      vuint32_t TXEN:1;
      vuint32_t  :8;
      vuint32_t TXARBD:1;
      vuint32_t CTSEN:1;
      vuint32_t  :1;
      vuint32_t DRFRST:1;
      vuint32_t DATAEN:1;
    } B;
  } MCR;

  union {                              /* LFAST Speed Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t DRMD:1;
      vuint32_t  :7;
      vuint32_t RDR:1;
      vuint32_t  :7;
      vuint32_t TDR:1;
    } B;
  } SCR;

  union {                              /* LFAST Correlator Control Register */
    vuint32_t R;
    struct {
      vuint32_t SMPSEL:8;
      vuint32_t  :6;
      vuint32_t  :2;
      vuint32_t  :12;
      vuint32_t CORRTH:3;
      vuint32_t PHSSEL:1;
    } B;
  } COCR;

  union {                              /* LFAST Test Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t CLKTST:1;
      vuint32_t LPON:1;
      vuint32_t  :5;
      vuint32_t LPMOD:3;
      vuint32_t LPFRMTH:16;
    } B;
  } TMCR;

  union {                              /* LFAST Auto Loopback Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t LPCNTEN:1;
      vuint32_t LPFMCNT:16;
    } B;
  } ALCR;

  union {                              /* LFAST Rate Change Delay Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DRCNT:4;
      vuint32_t  :16;
    } B;
  } RCDCR;

  union {                              /* LFAST Wakeup Delay Control Register */
    vuint32_t R;
    struct {
      vuint32_t HSCNT:8;
      vuint32_t  :4;
      vuint32_t LSCNT:4;
      vuint32_t HWKCNT:8;
      vuint32_t  :4;
      vuint32_t LWKCNT:4;
    } B;
  } SLCR;

  union {                              /* LFAST ICLC Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t ICLCSEQ:1;
      vuint32_t SNDICLC:1;
      vuint32_t  :8;
      vuint32_t ICLCPLD:8;
    } B;
  } ICR;

  union {                              /* LFAST Ping Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t PNGREQ:1;
      vuint32_t PNGAUTO:1;
      vuint32_t  :7;
      vuint32_t PNGPYLD:8;
    } B;
  } PICR;

  uint8_t LFAST_reserved0[8];
  union {                              /* LFAST Rx FIFO CTS Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t RCTSMX:6;
      vuint32_t  :10;
      vuint32_t RCTSMN:6;
    } B;
  } RFCR;

  union {                              /* LFAST Tx Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t TXIIE:1;
      vuint32_t TXOVIE:1;
      vuint32_t  :11;
      vuint32_t TXPNGIE:1;
      vuint32_t  :1;
      vuint32_t TXUNSIE:1;
      vuint32_t TXICLCIE:1;
      vuint32_t TXDTIE:1;
    } B;
  } TIER;

  union {                              /* LFAST Rx Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RXUOIE:1;
      vuint32_t RXMNIE:1;
      vuint32_t RXMXIE:1;
      vuint32_t RXUFIE:1;
      vuint32_t RXOFIE:1;
      vuint32_t RXSZIE:1;
      vuint32_t RXICIE:1;
      vuint32_t RXLCEIE:1;
      vuint32_t  :12;
      vuint32_t RXCTSIE:1;
      vuint32_t RXDIE:1;
      vuint32_t RXUNSIE:1;
      vuint32_t  :1;
    } B;
  } RIER;

  union {                              /* LFAST Rx ICLC Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t ICPFIE:1;
      vuint32_t ICPSIE:1;
      vuint32_t ICPRIE:1;
      vuint32_t ICTOIE:1;
      vuint32_t ICLPIE:1;
      vuint32_t ICCTIE:1;
      vuint32_t ICTDIE:1;
      vuint32_t ICTEIE:1;
      vuint32_t ICRFIE:1;
      vuint32_t ICRSIE:1;
      vuint32_t ICTFIE:1;
      vuint32_t ICTSIE:1;
      vuint32_t ICPOFIE:1;
      vuint32_t ICPONIE:1;
    } B;
  } RIIER;

  union {                              /* LFAST PLL Control Register */
    vuint32_t R;
    struct {
      vuint32_t IPTMOD:3;
      vuint32_t  :11;
      vuint32_t SWPOFF:1;
      vuint32_t SWPON:1;
      vuint32_t REFINV:1;
      vuint32_t LPCFG:2;
      vuint32_t  :2;
      vuint32_t PLCKCW:2;
      vuint32_t FDIVEN:1;
      vuint32_t FBDIV:6;
      vuint32_t PREDIV:2;
    } B;
  } PLLCR;

  union {                              /* LFAST LVDS Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SWWKLD:1;
      vuint32_t SWSLPLD:1;
      vuint32_t SWWKLR:1;
      vuint32_t SWSLPLR:1;
      vuint32_t SWOFFLD:1;
      vuint32_t SWONLD:1;
      vuint32_t SWOFFLR:1;
      vuint32_t SWONLR:1;
      vuint32_t LVRXOFF:1;
      vuint32_t LVTXOE:1;
      vuint32_t TXCMUX:1;
      vuint32_t LVRFEN:1;
      vuint32_t LVLPEN:1;
      vuint32_t  :5;
      vuint32_t LVRXOP:3;
      vuint32_t LVTXOP:1;
      vuint32_t LVCKSS:1;
      vuint32_t LVCKP:1;
    } B;
  } LCR;

  union {                              /* LFAST Unsolicited Tx Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t USNDRQ:1;
      vuint32_t  :9;
      vuint32_t UNSHDR:7;
    } B;
  } UNSTCR;

  union {                              /* LFAST Unsolicited Tx Data Registers */
    vuint32_t R;
    struct {
      vuint32_t UNTXD:32;
    } B;
  } UNSTDR[9];

  uint8_t LFAST_reserved1[20];
  union {                              /* LFAST Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t DUALMD:1;
      vuint32_t  :12;
      vuint32_t LRMD:1;
      vuint32_t LDSM:1;
      vuint32_t DRSM:1;
      vuint32_t  :11;
      vuint32_t LPTXDN:1;
      vuint32_t LPFPDV:1;
      vuint32_t LPCPDV:1;
      vuint32_t LPCHDV:1;
      vuint32_t LPCSDV:1;
    } B;
  } GSR;

  union {                              /* LFAST Ping Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RXPNGD:8;
    } B;
  } PISR;

  uint8_t LFAST_reserved2[12];
  union {                              /* LFAST Data Frame Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t RXDCNT:6;
      vuint32_t  :5;
      vuint32_t RXFCNT:3;
      vuint32_t  :2;
      vuint32_t TXDCNT:6;
      vuint32_t  :5;
      vuint32_t TXFCNT:3;
    } B;
  } DFSR;

  union {                              /* LFAST Tx Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t TXIEF:1;
      vuint32_t TXOVF:1;
      vuint32_t  :11;
      vuint32_t TXPNGF:1;
      vuint32_t  :1;
      vuint32_t TXUNSF:1;
      vuint32_t TXICLCF:1;
      vuint32_t TXDTF:1;
    } B;
  } TISR;

  union {                              /* LFAST Rx Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RXUOF:1;
      vuint32_t RXMNF:1;
      vuint32_t RXMXF:1;
      vuint32_t RXUFF:1;
      vuint32_t RXOFF:1;
      vuint32_t RXSZF:1;
      vuint32_t RXICF:1;
      vuint32_t RXLCEF:1;
      vuint32_t  :12;
      vuint32_t RXCTSF:1;
      vuint32_t RXDF:1;
      vuint32_t RXUNSF:1;
      vuint32_t  :1;
    } B;
  } RISR;

  union {                              /* LFAST Rx ICLC Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t ICPFF:1;
      vuint32_t ICPSF:1;
      vuint32_t ICPRF:1;
      vuint32_t ICTOF:1;
      vuint32_t ICLPF:1;
      vuint32_t ICCTF:1;
      vuint32_t ICTDF:1;
      vuint32_t ICTEF:1;
      vuint32_t ICRFF:1;
      vuint32_t ICRSF:1;
      vuint32_t ICTFF:1;
      vuint32_t ICTSF:1;
      vuint32_t ICPOFF:1;
      vuint32_t ICPONF:1;
    } B;
  } RIISR;

  union {                              /* LFAST PLL and LVDS Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t PLLDIS:1;
      vuint32_t PLDCR:1;
      vuint32_t  :12;
      vuint32_t LRSLPS:1;
      vuint32_t LDSLPS:1;
      vuint32_t LDPDS:1;
      vuint32_t LRPDS:1;
    } B;
  } PLLLSR;

  union {                              /* LFAST Unsolicited Rx Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t URXDV:1;
      vuint32_t  :5;
      vuint32_t URPCNT:3;
    } B;
  } UNSRSR;

  union {                              /* LFAST Unsolicited Rx Data Register */
    vuint32_t R;
    struct {
      vuint32_t UNRXD:32;
    } B;
  } UNSRDR[9];
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

struct LINFlexD_tag {
  union {                              /* LIN Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CCD:1;
      vuint32_t CFD:1;
      vuint32_t LASE:1;
      vuint32_t AUTOWU:1;
      vuint32_t MBL:4;
      vuint32_t BF:1;
      vuint32_t  :1;
      vuint32_t LBKM:1;
      vuint32_t MME:1;
      vuint32_t SSBL:1;
      vuint32_t RBLM:1;
      vuint32_t SLEEP:1;
      vuint32_t INIT:1;
    } B;
  } LINCR1;

  union {                              /* LIN Interrupt enable register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZIE:1;
      vuint32_t OCIE:1;
      vuint32_t BEIE:1;
      vuint32_t CEIE:1;
      vuint32_t HEIE:1;
      vuint32_t  :2;
      vuint32_t FEIE:1;
      vuint32_t BOIE:1;
      vuint32_t LSIE:1;
      vuint32_t WUIE:1;
      vuint32_t DBFIE:1;
      vuint32_t DBEIETOIE:1;
      vuint32_t DRIE:1;
      vuint32_t DTIE:1;
      vuint32_t HRIE:1;
    } B;
  } LINIER;

  union {                              /* LIN Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t  :1;
      vuint32_t RDC:3;
      vuint32_t LINS:4;
      vuint32_t  :2;
      vuint32_t RMB:1;
      vuint32_t DRBNE:1;
      vuint32_t RXbusy:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t DBFF:1;
      vuint32_t DBEF:1;
      vuint32_t DRF:1;
      vuint32_t DTF:1;
      vuint32_t HRF:1;
    } B;
  } LINSR;

  union {                              /* LIN Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t BEF:1;
      vuint32_t CEF:1;
      vuint32_t SFEF:1;
      vuint32_t SDEF:1;
      vuint32_t IDPEF:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t  :6;
      vuint32_t NF:1;
    } B;
  } LINESR;

  union {                              /* UART Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TDFLTFC:3;
      vuint32_t RDFLRFC:3;
      vuint32_t RFBM:1;
      vuint32_t TFBM:1;
      vuint32_t WL1:1;
      vuint32_t PC1:1;
      vuint32_t RxEn:1;
      vuint32_t TxEn:1;
      vuint32_t PC0:1;
      vuint32_t PCE:1;
      vuint32_t WL0:1;
      vuint32_t UART:1;
    } B;
  } UARTCR;

  union {                              /* UART Mode Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t PE:4;
      vuint32_t RMB:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t RFNE:1;
      vuint32_t TO:1;
      vuint32_t DRFRFE:1;
      vuint32_t DTFTFF:1;
      vuint32_t NF:1;
    } B;
  } UARTSR;

  union {                              /* LIN Time-Out Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t MODE:1;
      vuint32_t IOT:1;
      vuint32_t TOCE:1;
      vuint32_t CNT:8;
    } B;
  } LINTCSR;

  union {                              /* LIN Output Compare Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OC2:8;
      vuint32_t OC1:8;
    } B;
  } LINOCR;

  union {                              /* LIN Time-Out Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t RTO:4;
      vuint32_t  :1;
      vuint32_t HTO:7;
    } B;
  } LINTOCR;

  union {                              /* LIN Fractional Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t DIV_F:4;               /* Fractional bits of LFDIV */
    } B;
  } LINFBRR;

  union {                              /* LIN Integer Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIV_M:20;              /* LFDIV mantissa */
    } B;
  } LINIBRR;

  union {                              /* LIN Checksum Field Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t CF:8;
    } B;
  } LINCFR;

  union {                              /* LIN Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TBDE:1;
      vuint32_t IOBE:1;
      vuint32_t IOPE:1;
      vuint32_t WURQ:1;
      vuint32_t DDRQ:1;
      vuint32_t DTRQ:1;
      vuint32_t ABRQ:1;
      vuint32_t HTRQ:1;
      vuint32_t  :8;
    } B;
  } LINCR2;

  union {                              /* Buffer Identifier Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DFL:6;
      vuint32_t DIR:1;
      vuint32_t CCS:1;
      vuint32_t  :2;
      vuint32_t ID:6;
    } B;
  } BIDR;

  union {                              /* Buffer Data Register Least Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA3:8;
      vuint32_t DATA2:8;
      vuint32_t DATA1:8;
      vuint32_t DATA0:8;
    } B;
  } BDRL;

  union {                              /* Buffer Data Register Most Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA7:8;
      vuint32_t DATA6:8;
      vuint32_t DATA5:8;
      vuint32_t DATA4:8;
    } B;
  } BDRM;

  union {                              /* Identifier Filter Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FACT:16;
    } B;
  } IFER;

  union {                              /* Identifier Filter Match Index */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t IFMI:5;
    } B;
  } IFMI;

  union {                              /* Identifier Filter Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t IFM:8;
    } B;
  } IFMR;

  union {                              /* Identifier Filter Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DFL:6;                 /* Data Field Length */
      vuint32_t DIR:1;                 /* Direction */
      vuint32_t CCS:1;                 /* Classic Checksum */
      vuint32_t  :2;
      vuint32_t ID:6;                  /* Identifier */
    } B;
  } IFCR[16];

  union {                              /* Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TDFBM:1;
      vuint32_t RDFBM:1;
      vuint32_t TDLIS:1;
      vuint32_t RDLIS:1;
      vuint32_t STOP:1;
      vuint32_t SR:1;
    } B;
  } GCR;

  union {                              /* UART Preset Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t PTO:12;
    } B;
  } UARTPTO;

  union {                              /* UART Current Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t CTO:12;
    } B;
  } UARTCTO;

  union {                              /* DMA Tx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DTE:16;
    } B;
  } DMATXE;

  union {                              /* DMA Rx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DRE:16;
    } B;
  } DMARXE;
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

struct MC_CGM_tag {
  uint8_t MC_CGM_reserved0[1792];
  union {                              /* PCS Switch Duration Register */
    vuint8_t R;
    struct {
      vuint8_t SDUR:8;
    } B;
  } PCS_SDUR;

  uint8_t MC_CGM_reserved1[3];
  union {                              /* PCS Divider End Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE1;

  union {                              /* PCS Divider Start Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS1;

  union {                              /* PCS Divider Change Register 1 */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC1;

  union {                              /* PCS Divider End Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE2;

  union {                              /* PCS Divider Start Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS2;

  union {                              /* PCS Divider Change Register 2 */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC2;

  uint8_t MC_CGM_reserved2[12];
  union {                              /* PCS Divider End Register 4 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE4;

  union {                              /* PCS Divider Start Register 4 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS4;

  union {                              /* PCS Divider Change Register 4 */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC4;

  uint8_t MC_CGM_reserved3[176];
  union {                              /* System Clock Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :4;
      vuint32_t SWTRG:3;
      vuint32_t SWIP:1;
      vuint32_t  :16;
    } B;
  } SC_SS;

  union {                              /* System Clock Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } SC_DC0;

  uint8_t MC_CGM_reserved4[20];
  union {                              /* Auxiliary Clock 0 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t SELCTL:2;
      vuint32_t  :24;
    } B;
  } AC0_SC;

  union {                              /* Auxiliary Clock 0 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t SELSTAT:2;
      vuint32_t  :24;
    } B;
  } AC0_SS;

  union {                              /* Auxiliary Clock 0 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } AC0_DC0;

  union {                              /* Auxiliary Clock 0 Divider 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :10;
      vuint32_t DIV:5;
      vuint32_t  :16;
    } B;
  } AC0_DC1;

  union {                              /* Auxiliary Clock 0 Divider 2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :10;
      vuint32_t DIV:5;
      vuint32_t  :16;
    } B;
  } AC0_DC2;

  uint8_t MC_CGM_reserved5[20];
  union {                              /* Auxiliary Clock 1 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :10;
      vuint32_t DIV:5;
      vuint32_t  :16;
    } B;
  } AC1_DC0;

  union {                              /* Auxiliary Clock 1 Divider 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC1_DC1;

  uint8_t MC_CGM_reserved6[24];
  union {                              /* Auxiliary Clock 2 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } AC2_DC0;

  uint8_t MC_CGM_reserved7[20];
  union {                              /* Auxiliary Clock 3 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC3_SC;

  union {                              /* Auxiliary Clock 3 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELSTAT:1;
      vuint32_t  :24;
    } B;
  } AC3_SS;

  uint8_t MC_CGM_reserved8[24];
  union {                              /* Auxiliary Clock 4 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t SELCTL:2;
      vuint32_t  :24;
    } B;
  } AC4_SC;

  union {                              /* Auxiliary Clock 4 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t SELSTAT:2;
      vuint32_t  :24;
    } B;
  } AC4_SS;

  uint8_t MC_CGM_reserved9[24];
  union {                              /* Auxiliary Clock 5 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SELCTL:3;
      vuint32_t  :24;
    } B;
  } AC5_SC;

  union {                              /* Auxiliary Clock 5 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SELSTAT:3;
      vuint32_t  :24;
    } B;
  } AC5_SS;

  union {                              /* Auxiliary Clock 5 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :10;
      vuint32_t DIV:5;
      vuint32_t  :16;
    } B;
  } AC5_DC0;

  uint8_t MC_CGM_reserved10[20];
  union {                              /* Auxiliary Clock 6 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SELCTL:3;
      vuint32_t  :24;
    } B;
  } AC6_SC;

  union {                              /* Auxiliary Clock 6 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SELSTAT:3;
      vuint32_t  :24;
    } B;
  } AC6_SS;

  union {                              /* Auxiliary Clock 6 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :8;
      vuint32_t DIV:7;
      vuint32_t  :16;
    } B;
  } AC6_DC0;

  uint8_t MC_CGM_reserved11[116];
  union {                              /* Auxiliary Clock 10 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SELCTL:3;
      vuint32_t  :24;
    } B;
  } AC10_SC;

  union {                              /* Auxiliary Clock 10 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SELSTAT:3;
      vuint32_t  :24;
    } B;
  } AC10_SS;

  union {                              /* Auxiliary Clock 10 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } AC10_DC0;

  uint8_t MC_CGM_reserved12[20];
  union {                              /* Auxiliary Clock 11 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SELCTL:3;
      vuint32_t  :24;
    } B;
  } AC11_SC;

  union {                              /* Auxiliary Clock 11 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SELSTAT:3;
      vuint32_t  :24;
    } B;
  } AC11_SS;

  union {                              /* Auxiliary Clock 11 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } AC11_DC0;
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

struct MC_ME_tag {
  union {                              /* Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t S_CURRENT_MODE:4;
      vuint32_t S_MTRANS:1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t S_PDO:1;
      vuint32_t  :2;
      vuint32_t S_MVR:1;
      vuint32_t  :2;
      vuint32_t S_FLA:2;
      vuint32_t  :8;
      vuint32_t S_PLL1:1;
      vuint32_t S_PLL0:1;
      vuint32_t S_XOSC:1;
      vuint32_t S_IRC:1;
      vuint32_t S_SYSCLK:4;
    } B;
  } GS;

  union {                              /* Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t TARGET_MODE:4;
      vuint32_t  :12;
      vuint32_t KEY:16;
    } B;
  } MCTL;

  union {                              /* Mode Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RESET_DEST:1;
      vuint32_t  :4;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t HALT0:1;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t TEST:1;
      vuint32_t RESET_FUNC:1;
    } B;
  } ME;

  union {                              /* Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t I_ICONF_CC:1;
      vuint32_t I_ICONF_CU:1;
      vuint32_t I_ICONF:1;
      vuint32_t I_IMODE:1;
      vuint32_t I_SAFE:1;
      vuint32_t I_MTC:1;
    } B;
  } IS;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t M_ICONF_CC:1;
      vuint32_t M_ICONF_CU:1;
      vuint32_t M_ICONF:1;
      vuint32_t M_IMODE:1;
      vuint32_t M_SAFE:1;
      vuint32_t M_MTC:1;
    } B;
  } IM;

  union {                              /* Invalid Mode Transition Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t S_MRIG:1;
      vuint32_t S_MTI:1;
      vuint32_t S_MRI:1;
      vuint32_t S_DMA:1;
      vuint32_t S_NMA:1;
      vuint32_t S_SEA:1;
    } B;
  } IMTS;

  union {                              /* Debug Mode Transition Status Register */
    vuint32_t R;
    struct {
      vuint32_t PREVIOUS_MODE:4;
      vuint32_t  :4;
      vuint32_t MPH_BUSY:1;
      vuint32_t  :2;
      vuint32_t PMC_PROG:1;
      vuint32_t DBG_MODE:1;
      vuint32_t CCKL_PROG:1;
      vuint32_t PCS_PROG:1;            /* Progressive System Clock Switching in Progress */
      vuint32_t SMR:1;
      vuint32_t CDP_PRPH_0_255:1;      /* Clock Disable Process Pending status for Peripherals 0 to 255 */
      vuint32_t VREG_CSRC_SC:1;
      vuint32_t CSRC_CSRC_SC:1;
      vuint32_t IRC_SC:1;
      vuint32_t SCSRC_SC:1;
      vuint32_t SYSCLK_SW:1;
      vuint32_t  :1;
      vuint32_t FLASH_SC:1;
      vuint32_t CDP_PRPH_224_255:1;
      vuint32_t CDP_PRPH_192_223:1;
      vuint32_t CDP_PRPH_160_191:1;
      vuint32_t CDP_PRPH_128_159:1;
      vuint32_t CDP_PRPH_96_127:1;
      vuint32_t CDP_PRPH_64_95:1;
      vuint32_t CDP_PRPH_32_63:1;
      vuint32_t CDP_PRPH_0_31:1;
    } B;
  } DMTS;

  uint8_t MC_ME_reserved0[4];
  union {                              /* RESET Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RESET_MC;

  union {                              /* TEST Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } TEST_MC;

  union {                              /* SAFE Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } SAFE_MC;

  union {                              /* DRUN Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } DRUN_MC;

  union {                              /* RUN0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RUN0_MC;

  union {                              /* RUN1 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RUN1_MC;

  union {                              /* RUN2 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RUN2_MC;

  union {                              /* RUN3 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RUN3_MC;

  union {                              /* HALT0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } HALT0_MC;

  uint8_t MC_ME_reserved1[4];
  union {                              /* STOP0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } STOP0_MC;

  uint8_t MC_ME_reserved2[20];
  union {                              /* Peripheral Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t S_PIT_0:1;
      vuint32_t  :17;
      vuint32_t S_ENET_0:1;
      vuint32_t S_SIPI_0:1;
      vuint32_t  :1;
      vuint32_t S_LFAST_0:1;
      vuint32_t  :9;
    } B;
  } PS0;

  union {                              /* Peripheral Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t S_CRC_0:1;
      vuint32_t  :1;
      vuint32_t S_DMAMUX_0:1;
      vuint32_t  :1;
      vuint32_t S_ATX:1;
      vuint32_t  :2;
    } B;
  } PS1;

  union {                              /* Peripheral Status Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t S_LINFlex_1:1;
      vuint32_t  :11;
      vuint32_t S_CAN_0:1;
      vuint32_t S_CAN_1:1;
      vuint32_t S_CAN_2:1;
      vuint32_t  :13;
    } B;
  } PS2;

  union {                              /* Peripheral Status Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t S_ADC_1:1;
      vuint32_t  :1;
      vuint32_t S_ADC_3:1;
      vuint32_t  :16;
      vuint32_t S_FLEXRAY:1;
      vuint32_t  :2;
      vuint32_t S_SENT_0:1;
      vuint32_t  :4;
      vuint32_t S_DSPI_0:1;
      vuint32_t S_DSPI_1:1;
      vuint32_t  :2;
    } B;
  } PS3;

  union {                              /* Peripheral Status Register 4 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t S_DMAMUX_1:1;
      vuint32_t  :1;
      vuint32_t S_PWM_1:1;
      vuint32_t  :2;
      vuint32_t S_CTU_1:1;
      vuint32_t  :3;
      vuint32_t S_ETIMER_1:1;
      vuint32_t  :9;
    } B;
  } PS4;

  union {                              /* Peripheral Status Register 5 */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } PS5;

  union {                              /* Peripheral Status Register 6 */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t S_SENT_1:1;
      vuint32_t  :4;
      vuint32_t S_DSPI_2:1;
      vuint32_t S_DSPI_3:1;
      vuint32_t  :3;
      vuint32_t S_LINFlex_0:1;
      vuint32_t  :12;
    } B;
  } PS6;

  union {                              /* Peripheral Status Register 7 */
    vuint32_t R;
    struct {
      vuint32_t S_PWM_0:1;
      vuint32_t  :3;
      vuint32_t S_CTU_0:1;
      vuint32_t  :3;
      vuint32_t S_ETIMER_0:1;
      vuint32_t  :1;
      vuint32_t S_ETIMER_2:1;
      vuint32_t  :5;
      vuint32_t S_SWG_0:1;
      vuint32_t  :1;
      vuint32_t S_ADC_0:1;
      vuint32_t  :1;
      vuint32_t S_ADC_2:1;
      vuint32_t  :11;
    } B;
  } PS7;

  union {                              /* Run Peripheral Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t TEST:1;
      vuint32_t RESET:1;
    } B;
  } RUN_PC[8];

  union {                              /* Low-Power Peripheral Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t HALT0:1;
      vuint32_t  :8;
    } B;
  } LP_PC[8];

  uint8_t MC_ME_reserved3[9];
  union {                              /* LFAST_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL9;

  uint8_t MC_ME_reserved4[1];
  union {                              /* SIPI_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL11;

  union {                              /* ENET_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL12;

  uint8_t MC_ME_reserved5[17];
  union {                              /* PIT_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL30;

  uint8_t MC_ME_reserved6[5];
  union {                              /* DMAMUX_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL36;

  uint8_t MC_ME_reserved7[1];
  union {                              /* CRC_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL38;

  uint8_t MC_ME_reserved8[38];
  union {                              /* CAN_2 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL77;

  union {                              /* CAN_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL78;

  union {                              /* CAN_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL79;

  uint8_t MC_ME_reserved9[11];
  union {                              /* LINFlex_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL91;

  uint8_t MC_ME_reserved10[6];
  union {                              /* DSPI_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL98;

  union {                              /* DSPI_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL99;

  uint8_t MC_ME_reserved11[4];
  union {                              /* SENT_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL104;

  uint8_t MC_ME_reserved12[2];
  union {                              /* FLEXRAY Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL107;

  uint8_t MC_ME_reserved13[16];
  union {                              /* ADC_3 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL124;

  uint8_t MC_ME_reserved14[1];
  union {                              /* ADC_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL126;

  uint8_t MC_ME_reserved15[10];
  union {                              /* ETIMER_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL137;

  uint8_t MC_ME_reserved16[3];
  union {                              /* CTU_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL141;

  uint8_t MC_ME_reserved17[2];
  union {                              /* PWM_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL144;

  uint8_t MC_ME_reserved18[1];
  union {                              /* DMAMUX_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL146;

  uint8_t MC_ME_reserved19[57];
  union {                              /* LINFlex_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL204;

  uint8_t MC_ME_reserved20[3];
  union {                              /* DSPI_3 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL208;

  union {                              /* DSPI_2 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL209;

  uint8_t MC_ME_reserved21[4];
  union {                              /* SENT_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL214;

  uint8_t MC_ME_reserved22[20];
  union {                              /* ADC_2 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL235;

  uint8_t MC_ME_reserved23[1];
  union {                              /* ADC_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL237;

  uint8_t MC_ME_reserved24[1];
  union {                              /* SGEN_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL239;

  uint8_t MC_ME_reserved25[5];
  union {                              /* ETIMER_2 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL245;

  uint8_t MC_ME_reserved26[1];
  union {                              /* ETIMER_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL247;

  uint8_t MC_ME_reserved27[3];
  union {                              /* CTU_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL251;

  uint8_t MC_ME_reserved28[3];
  union {                              /* PWM_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL255;

  union {                              /* Core Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t S_CORE0:1;
    } B;
  } CS;

  union {                              /* Core Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t STOP0:1;
      vuint16_t  :1;
      vuint16_t HALT0:1;
      vuint16_t RUN3:1;
      vuint16_t RUN2:1;
      vuint16_t RUN1:1;
      vuint16_t RUN0:1;
      vuint16_t DRUN:1;
      vuint16_t SAFE:1;
      vuint16_t TEST:1;
      vuint16_t RESET:1;
    } B;
  } CCTL0;

  uint8_t MC_ME_reserved29[26];
  union {                              /* CORE0 Address Register */
    vuint32_t R;
    struct {
      vuint32_t ADDR:30;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } CADDR0;
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

struct MC_PCU_tag {
  union {                              /* Power Domain #0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t HALT0:1;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t TEST:1;
      vuint32_t RST:1;
    } B;
  } PCONF0;

  uint8_t MC_PCU_reserved0[60];
  union {                              /* Power Domain Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t PD0:1;
    } B;
  } PSTAT;
};


/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

struct MC_RGM_tag {
  union {                              /* 'Destructive' Event Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t F_VOR_DEST:1;
      vuint32_t F_TSR_DEST:1;
      vuint32_t  :13;
      vuint32_t F_FIF:1;
      vuint32_t F_EDR:1;
      vuint32_t  :2;
      vuint32_t F_SUF:1;
      vuint32_t F_FFRR:1;
      vuint32_t F_SOFT_DEST:1;
      vuint32_t  :2;
      vuint32_t F_POR:1;
    } B;
  } DES;

  uint8_t MC_RGM_reserved0[12];
  union {                              /* 'Destructive' Event Reset Disable Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t D_VOR_DEST:1;
      vuint32_t D_TSR_DEST:1;
      vuint32_t  :13;
      vuint32_t F_FIF:1;
      vuint32_t D_EDR:1;
      vuint32_t  :2;
      vuint32_t F_SUF:1;
      vuint32_t D_FFRR:1;
      vuint32_t D_SOF_DEST:1;
      vuint32_t  :2;
      vuint32_t D_POR:1;
    } B;
  } DERD;

  uint8_t MC_RGM_reserved1[28];
  union {                              /* Destructive' Bidirectional Reset Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t BE_VOR_DEST:1;
      vuint32_t BE_TSR_DEST:1;
      vuint32_t  :13;
      vuint32_t F_FIF:1;
      vuint32_t BE_EDR:1;
      vuint32_t  :2;
      vuint32_t F_SUF:1;
      vuint32_t BE_FFRR:1;
      vuint32_t BE_SOF_DEST:1;
      vuint32_t  :2;
      vuint32_t BE_POR:1;
    } B;
  } DBRE;

  uint8_t MC_RGM_reserved2[716];
  union {                              /* 'Functional' Event Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t F_VOR_FUNC:1;
      vuint32_t F_TSR_FUNC:1;
      vuint32_t  :12;
      vuint32_t F_JTAG_FUNC:1;         /* Flag for JTAG 'functional' reset */
      vuint32_t  :3;
      vuint32_t F_FCCU_SOFT:1;
      vuint32_t F_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t F_SOFT_FUNC:1;
      vuint32_t F_ST_DONE:1;
      vuint32_t  :1;
      vuint32_t F_EXR:1;
    } B;
  } FES;

  uint8_t MC_RGM_reserved3[12];
  union {                              /* 'Functional' Event Reset Disable Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t D_VOR_FUNC:1;
      vuint32_t D_TSR_FUNC:1;
      vuint32_t  :12;
      vuint32_t D_JTAG_FUNC:1;
      vuint32_t  :3;
      vuint32_t D_FCCU_SOFT:1;
      vuint32_t D_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t D_SOFT_FUNC:1;
      vuint32_t D_ST_DONE:1;
      vuint32_t  :2;
    } B;
  } FERD;

  uint8_t MC_RGM_reserved4[12];
  union {                              /* 'Functional' Event Alternate Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t AR_VOR_FUNC:1;
      vuint32_t AR_TSR_FUNC:1;
      vuint32_t  :12;
      vuint32_t AR_JTAG_FUNC:1;
      vuint32_t  :10;
    } B;
  } FEAR;

  uint8_t MC_RGM_reserved5[12];
  union {                              /* 'Functional' Bidirectional Reset Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t BE_VOR_FUNC:1;
      vuint32_t BE_TSR_FUNC:1;
      vuint32_t  :12;
      vuint32_t BE_JTAG_FUNC:1;
      vuint32_t  :3;
      vuint32_t BE_FCCU_SOFT:1;
      vuint32_t BE_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t BE_SOFT_FUNC:1;
      vuint32_t BE_ST_DONE:1;
      vuint32_t  :1;
      vuint32_t BE_EXR:1;
    } B;
  } FBRE;

  uint8_t MC_RGM_reserved6[12];
  union {                              /* 'Functional' Event Short Sequence Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SS_VOR_FUNC:1;
      vuint32_t SS_TSR_FUNC:1;
      vuint32_t  :12;
      vuint32_t SS_JTAG_FUNC:1;
      vuint32_t  :3;
      vuint32_t SS_FCCU_SOFT:1;
      vuint32_t SS_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t SS_SOFT_FUNC:1;
      vuint32_t SS_ST_DONE:1;
      vuint32_t  :1;
      vuint32_t SS_EXR:1;
    } B;
  } FESS;

  uint8_t MC_RGM_reserved7[704];
  union {                              /* 'Functional' Reset Escalation Threshold Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t FRET:4;
    } B;
  } FRET;

  uint8_t MC_RGM_reserved8[3];
  union {                              /* 'Destructive' Reset Escalation Threshold Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t DRET:4;
    } B;
  } DRET;
};


/* ============================================================================
   =============================== Module: MEMU ===============================
   ============================================================================ */

struct MEMU_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SWR:1;
      vuint32_t  :15;
    } B;
  } CTRL;

  union {                              /* Error flag register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t PR_CE:1;
      vuint32_t PR_UCE:1;
      vuint32_t PR_CEO:1;
      vuint32_t PR_UCO:1;
      vuint32_t PR_EBO:1;
      vuint32_t  :3;
      vuint32_t F_CE:1;
      vuint32_t F_UCE:1;
      vuint32_t F_CEO:1;
      vuint32_t F_UCO:1;
      vuint32_t F_EBO:1;
      vuint32_t  :3;
      vuint32_t SR_CE:1;
      vuint32_t SR_UCE:1;
      vuint32_t SR_CEO:1;
      vuint32_t SR_UCO:1;
      vuint32_t SR_EBO:1;
    } B;
  } ERR_FLAG;

  uint8_t MEMU_reserved0[4];
  union {                              /* Debug register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t FR_PR_CE:1;
      vuint32_t FR_PR_UCE:1;
      vuint32_t FR_PR_CEO:1;
      vuint32_t FR_PR_UCO:1;
      vuint32_t FR_PR_EBO:1;
      vuint32_t  :3;
      vuint32_t FR_F_CE:1;
      vuint32_t FR_F_UCE:1;
      vuint32_t FR_F_CEO:1;
      vuint32_t FR_F_UCO:1;
      vuint32_t FR_F_EBO:1;
      vuint32_t  :3;
      vuint32_t FR_SR_CE:1;
      vuint32_t FR_SR_UCE:1;
      vuint32_t FR_SR_CEO:1;
      vuint32_t FR_SR_UCO:1;
      vuint32_t FR_SR_EBO:1;
    } B;
  } DEBUG;

  uint8_t MEMU_reserved1[16];
  struct {
    union {                            /* System RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* System RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } SYS_RAM_CERR[10];

  union {                              /* System RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } SYS_RAM_UNCERR_STS;

  union {                              /* System RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } SYS_RAM_UNCERR_ADDR;

  union {                              /* System RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } SYS_RAM_OFLW[3];

  uint8_t MEMU_reserved2[1436];
  struct {
    union {                            /* Peripheral RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Peripheral RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } PERIPH_RAM_CERR[2];

  union {                              /* Peripheral RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } PERIPH_RAM_UNCERR_STS;

  union {                              /* Peripheral RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } PERIPH_RAM_UNCERR_ADDR;

  union {                              /* Peripheral RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } PERIPH_RAM_OFLW0;

  uint8_t MEMU_reserved3[1508];
  struct {
    union {                            /* Flash memory correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Flash memory correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } FLASH_CERR[20];

  union {                              /* Flash memory uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } FLASH_UNCERR_STS;

  union {                              /* Flash memory uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } FLASH_UNCERR_ADDR;

  union {                              /* Flash memory concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } FLASH_OFLW0;
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

struct PCM_tag {
  uint8_t PCM_reserved0[4];
  union {                              /* Bus Bridge Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t PRE:1;                 /* Pending Read Enable */
      vuint32_t BRE:1;                 /* Burst Read Enable */
      vuint32_t BWE:1;                 /* Burst Write Enable */
      vuint32_t  :16;
    } B;
  } IAHB_BE1;

  union {                              /* Bus Bridge Configuration Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t PRE:1;                 /* Pending Read Enable */
      vuint32_t BRE:1;                 /* Burst Read Enable */
      vuint32_t BWE:1;                 /* Burst Write Enable */
      vuint32_t  :8;
    } B;
  } IAHB_BE2;

  union {                              /* Bus Bridge Configuration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t PRE_B:1;               /* Pending Read Enable */
      vuint32_t BRE_B:1;               /* Burst Read Enable */
      vuint32_t BWE_B:1;               /* Burst Write Enable */
      vuint32_t  :5;
      vuint32_t PRE_A:1;               /* Pending Read Enable */
      vuint32_t BRE_A:1;               /* Burst Read Enable */
      vuint32_t BWE_A:1;               /* Burst Write Enable */
    } B;
  } IAHB_BE3;
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

struct PFLASH_tag {
  union {                              /* Platform Flash Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t P0_M15PFE:1;
      vuint32_t P0_M14PFE:1;
      vuint32_t P0_M13PFE:1;
      vuint32_t P0_M12PFE:1;
      vuint32_t P0_M11PFE:1;
      vuint32_t P0_M10PFE:1;
      vuint32_t P0_M9PFE:1;
      vuint32_t P0_M8PFE:1;
      vuint32_t P0_M7PFE:1;
      vuint32_t P0_M6PFE:1;
      vuint32_t P0_M5PFE:1;
      vuint32_t P0_M4PFE:1;
      vuint32_t P0_M3PFE:1;
      vuint32_t P0_M2PFE:1;
      vuint32_t P0_M1PFE:1;
      vuint32_t P0_M0PFE:1;
      vuint32_t APC:3;
      vuint32_t RWSC:5;
      vuint32_t  :1;
      vuint32_t P0_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P0_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P0_PFLIM:2;
      vuint32_t P0_BFEN:1;
    } B;
  } PFCR1;

  uint8_t PFLASH_reserved0[4];
  union {                              /* Platform Flash Configuration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t P0_WCFG:2;
      vuint32_t  :2;
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t  :1;
      vuint32_t  :4;
      vuint32_t  :11;
      vuint32_t  :1;
    } B;
  } PFCR3;

  union {                              /* Platform Flash Access Protection Register */
    vuint32_t R;
    struct {
      vuint32_t M0AP:2;
      vuint32_t M1AP:2;
      vuint32_t M2AP:2;
      vuint32_t M3AP:2;
      vuint32_t M4AP:2;
      vuint32_t M5AP:2;
      vuint32_t M6AP:2;
      vuint32_t M7AP:2;
      vuint32_t M8AP:2;
      vuint32_t M9AP:2;
      vuint32_t M10AP:2;
      vuint32_t M11AP:2;
      vuint32_t M12AP:2;
      vuint32_t M13AP:2;
      vuint32_t M14AP:2;
      vuint32_t M15AP:2;
    } B;
  } PFAPR;

  union {                              /* Platform Flash Remap Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t SAFE_CAL:1;
      vuint32_t  :3;
      vuint32_t IRMEN:1;
      vuint32_t  :3;
      vuint32_t GRMEN:1;
    } B;
  } PFCRCR;

  union {                              /* Platform Flash Remap Descriptor Enable Register */
    vuint32_t R;
    struct {
      vuint32_t CRD0EN:1;
      vuint32_t CRD1EN:1;
      vuint32_t CRD2EN:1;
      vuint32_t CRD3EN:1;
      vuint32_t CRD4EN:1;
      vuint32_t CRD5EN:1;
      vuint32_t CRD6EN:1;
      vuint32_t CRD7EN:1;
      vuint32_t CRD8EN:1;
      vuint32_t CRD9EN:1;
      vuint32_t CRD10EN:1;
      vuint32_t CRD11EN:1;
      vuint32_t CRD12EN:1;
      vuint32_t CRD13EN:1;
      vuint32_t CRD14EN:1;
      vuint32_t CRD15EN:1;
      vuint32_t CRD16EN:1;
      vuint32_t CRD17EN:1;
      vuint32_t CRD18EN:1;
      vuint32_t CRD19EN:1;
      vuint32_t CRD20EN:1;
      vuint32_t CRD21EN:1;
      vuint32_t CRD22EN:1;
      vuint32_t CRD23EN:1;
      vuint32_t CRD24EN:1;
      vuint32_t CRD25EN:1;
      vuint32_t CRD26EN:1;
      vuint32_t CRD27EN:1;
      vuint32_t CRD28EN:1;
      vuint32_t CRD29EN:1;
      vuint32_t CRD30EN:1;
      vuint32_t CRD31EN:1;
    } B;
  } PFCRDE;

  uint8_t PFLASH_reserved1[232];
  struct {
    union {                            /* Platform Flash Calibration Region Descriptor n Word0 */
      vuint32_t R;
      struct {
        vuint32_t LSTARTADDR:32;
      } B;
    } Word0;
    union {                            /* Platform Flash Calibration Region Descriptor n Word1 */
      vuint32_t R;
      struct {
        vuint32_t PSTARTADDR:32;
      } B;
    } Word1;
    union {                            /* Platform Flash Calibration Region Descriptor n Word2 */
      vuint32_t R;
      struct {
        vuint32_t M0EN:1;
        vuint32_t M1EN:1;
        vuint32_t M2EN:1;
        vuint32_t M3EN:1;
        vuint32_t M4EN:1;
        vuint32_t M5EN:1;
        vuint32_t M6EN:1;
        vuint32_t M7EN:1;
        vuint32_t M8EN:1;
        vuint32_t M9EN:1;
        vuint32_t M10EN:1;
        vuint32_t M11EN:1;
        vuint32_t M12EN:1;
        vuint32_t M13EN:1;
        vuint32_t M14EN:1;
        vuint32_t M15EN:1;
        vuint32_t  :11;
        vuint32_t CRDSize:5;
      } B;
    } Word2;
    uint8_t PFCRD_reserved0[4];
  } PFCRD[8];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

struct PIT_tag {
  union {                              /* PIT Module Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable - (PIT section) */
      vuint32_t FRZ:1;                 /* Freeze */
    } B;
  } MCR;

  uint8_t PIT_reserved0[220];
  union {                              /* PIT Upper Lifetime Timer Register */
    vuint32_t R;
    struct {
      vuint32_t LTH:32;                /* Life Timer value */
    } B;
  } LTMR64H;

  union {                              /* PIT Lower Lifetime Timer Register */
    vuint32_t R;
    struct {
      vuint32_t LTL:32;                /* Life Timer value */
    } B;
  } LTMR64L;

  uint8_t PIT_reserved1[24];
  struct {
    union {                            /* Timer Load Value Register */
      vuint32_t R;
      struct {
        vuint32_t TSV:32;              /* Timer Start Value */
      } B;
    } LDVAL;
    union {                            /* Current Timer Value Register */
      vuint32_t R;
      struct {
        vuint32_t TVL:32;              /* Current Timer Value */
      } B;
    } CVAL;
    union {                            /* Timer Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :29;
        vuint32_t CHN:1;               /* Chain Mode */
        vuint32_t TIE:1;               /* Timer Interrupt Enable */
        vuint32_t TEN:1;               /* Timer Enable */
      } B;
    } TCTRL;
    union {                            /* Timer Flag Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t TIF:1;               /* Timer Interrupt Flag */
      } B;
    } TFLG;
  } TIMER[4];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

struct PLLDIG_tag {
  union {                              /* PLLDIG PLL0 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t CLKCFG:2;              /* Clock Configuration */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLIE:1;               /* Loss-of-lock interrupt enable. */
      vuint32_t  :1;
      vuint32_t LOCIE:1;               /* Loss-of-clock interrupt request. */
      vuint32_t  :1;
    } B;
  } PLL0CR;

  union {                              /* PLLDIG PLL0 Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLF:1;
      vuint32_t LOCK:1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLL0SR;

  union {                              /* PLLDIG PLL0 Divider Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t RFDPHI1:4;             /* PHI1 reduced frequency divider. */
      vuint32_t  :5;
      vuint32_t RFDPHI:6;              /* PHI reduced frequency divider. */
      vuint32_t  :1;
      vuint32_t PREDIV:3;              /* Input clock predivider. */
      vuint32_t  :5;
      vuint32_t MFD:7;                 /* Loop multiplication factor divider. */
    } B;
  } PLL0DV;

  uint8_t PLLDIG_reserved0[20];
  union {                              /* PLLDIG PLL1 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t CLKCFG:2;              /* Clock Configuration */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLIE:1;               /* Loss-of-lock interrupt enable. */
      vuint32_t  :1;
      vuint32_t LOCIE:1;               /* Loss-of-clock interrupt request. */
      vuint32_t  :1;
    } B;
  } PLL1CR;

  union {                              /* PLLDIG PLL1 Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLF:1;
      vuint32_t LOCK:1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLL1SR;

  union {                              /* PLLDIG PLL1 Divider Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t RFDPHI:6;
      vuint32_t  :5;
      vuint32_t  :4;
      vuint32_t MFD:7;                 /* Loop multiplication factor divider. */
    } B;
  } PLL1DV;

  union {                              /* PLLDIG PLL1 Frequency Modulation Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MODEN:1;               /* Modulation enable. */
      vuint32_t MODSEL:1;              /* Modulation selection. */
      vuint32_t MODPRD:13;             /* Modulation period. */
      vuint32_t  :1;
      vuint32_t INCSTP:15;             /* Increment step. */
    } B;
  } PLL1FM;

  union {                              /* PLLDIG PLL1 Fractional Divide Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t FDEN:1;                /* Fractional Divide Enable */
      vuint32_t  :12;
      vuint32_t DTHDIS:2;              /* Dither Disable. */
      vuint32_t  :4;
      vuint32_t FRCDIV:12;
    } B;
  } PLL1FD;
};


/* ============================================================================
   =============================== Module: PMC ================================
   ============================================================================ */

struct PMC_tag {
  union {                              /* PMC Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved */
      vuint32_t INT_EXT_AUX_REG:1;
      vuint32_t EXT_INT_REG:1;
    } B;
  } PMCSR;

  union {                              /* Regulator Voltage Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;                  /* Reserved */
      vuint32_t VD6:1;
      vuint32_t  :1;                   /* Reserved */
      vuint32_t VD4:1;
      vuint32_t VD3:1;
      vuint32_t  :3;                   /* Reserved */
    } B;
  } RSSR;

  union {                              /* PMC Control Register */
    vuint32_t R;
    struct {
      vuint32_t PMCCR_EN:1;
      vuint32_t  :16;                  /* Reserved */
      vuint32_t LVD_OSC_DIS:1;
      vuint32_t LVD_ADC_DIS:1;
      vuint32_t LVD_IO_DIS:1;
      vuint32_t LVD_FLASH_DIS:1;
      vuint32_t LVD2_CORE_DIS:1;
      vuint32_t  :2;
      vuint32_t HVD_CORE_DIS:1;
      vuint32_t  :2;                   /* Reserved */
      vuint32_t LVD1_H_CORE_DIS:1;
      vuint32_t LVD1_C_CORE_DIS:1;
      vuint32_t  :1;                   /* Reserved */
      vuint32_t INT_AUX_REG_BYPASS:1;
      vuint32_t INT_REG_BYPASS:1;
    } B;
  } PMCCR;

  uint8_t PMC_reserved0[4];
  union {                              /* Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IE_EN:1;
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TS1_3IE:1;
      vuint32_t TS1_2IE:1;
      vuint32_t TS1_0IE:1;
      vuint32_t TS0_3IE:1;
      vuint32_t TS0_2IE:1;
      vuint32_t TS0_0IE:1;
      vuint32_t  :9;                   /* Reserved */
      vuint32_t VD6IE_O:1;
      vuint32_t VD6IE_ADC:1;
      vuint32_t VD6IE_IM:1;
      vuint32_t VD6IE_F:1;
      vuint32_t VD6IE_C:1;
      vuint32_t  :2;                   /* Reserved */
      vuint32_t VD4IE_C:1;
      vuint32_t  :2;                   /* Reserved */
      vuint32_t VD3IE_H:1;             /* Voltage Detect 3 Interrupt Enable Hot */
      vuint32_t VD3IE_C:1;
      vuint32_t  :3;                   /* Reserved */
    } B;
  } IER;

  uint8_t PMC_reserved1[12];
  union {                              /* Event Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :10;                  /* Reserved */
      vuint32_t VD0_C:1;               /* Voltage Detect 0 Cold low-voltage POR flag */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t VD15_C:1;
      vuint32_t  :1;
      vuint32_t VD12_C:1;
      vuint32_t  :2;
      vuint32_t VD6_O:1;
      vuint32_t VD6_ADC:1;
      vuint32_t VD6_IM:1;
      vuint32_t VD6_F:1;
      vuint32_t VD6_C:1;
      vuint32_t  :1;
      vuint32_t VD5_C:1;
      vuint32_t VD4_C:1;
      vuint32_t  :2;
      vuint32_t VD3_H:1;               /* Voltage Detect 3 Hot low-voltage detect flag. */
      vuint32_t VD3_C:1;
      vuint32_t  :1;
      vuint32_t VD2_C:1;
      vuint32_t VD1_C:1;
    } B;
  } ESR_0;

  uint8_t PMC_reserved2[12];
  union {                              /* Reset Event Enable 0 */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t VD6RE_O:1;
      vuint32_t VD6RE_ADC:1;
      vuint32_t VD6RE_IM:1;
      vuint32_t VD6RE_F:1;
      vuint32_t VD6RE_C:1;
      vuint32_t  :2;                   /* Reserved */
      vuint32_t VD4RE_C:1;
      vuint32_t  :2;                   /* Reserved */
      vuint32_t VD3RE_H:1;             /* Voltage Detect 3 Reset Enable Hot. */
      vuint32_t VD3RE_C:1;
      vuint32_t  :3;                   /* Reserved */
    } B;
  } REE_0;

  uint8_t PMC_reserved3[12];
  union {                              /* Reset Event Selection 0 */
    vuint32_t R;
    struct {
      vuint32_t  :17;                  /* Reserved */
      vuint32_t VD6RES_O:1;
      vuint32_t VD6RES_ADC:1;
      vuint32_t VD6RES_IM:1;
      vuint32_t VD6RES_F:1;
      vuint32_t VD6RES_C:1;
      vuint32_t  :2;                   /* Reserved */
      vuint32_t VD4RES_C:1;
      vuint32_t  :2;                   /* Reserved */
      vuint32_t VD3RES_H:1;            /* Voltage Detect 3 Reset Event Select Hot. */
      vuint32_t VD3RES_C:1;
      vuint32_t  :3;                   /* Reserved */
    } B;
  } RES_0;

  uint8_t PMC_reserved4[44];
  union {                              /* FCCU Fault Injection Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;                  /* Reserved */
      vuint32_t STEST_Fault:1;
      vuint32_t TSNS_Fault:1;
      vuint32_t HVD_Fault:1;
      vuint32_t LVD_Fault:1;
    } B;
  } FIR;

  uint8_t PMC_reserved5[140];
  union {                              /* Temperature Event Status register */
    vuint32_t R;
    struct {
      vuint32_t  :4;                   /* Reserved */
      vuint32_t TEMP1_3_OP:1;          /* Temperature Sensor 1 Output 3 */
      vuint32_t TEMP1_2_OP:1;          /* Temperature Sensor 1 Output 2 */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TEMP1_0_OP:1;          /* Temperature Sensor 1 Output 0 */
      vuint32_t  :4;                   /* Reserved */
      vuint32_t TEMP0_3_OP:1;          /* Temperature Sensor 0 Output 3 */
      vuint32_t TEMP0_2_OP:1;          /* Temperature Sensor 0 Output 2 */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TEMP0_0_OP:1;          /* Temperature Sensor 0 Output 0 */
      vuint32_t  :4;                   /* Reserved */
      vuint32_t TEMP1_3:1;
      vuint32_t TEMP1_2:1;
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TEMP1_0:1;
      vuint32_t  :4;                   /* Reserved */
      vuint32_t TEMP0_3:1;
      vuint32_t TEMP0_2:1;
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TEMP0_0:1;
    } B;
  } ESR_TD;

  union {                              /* Temperature Reset Event Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :20;                  /* Reserved */
      vuint32_t TEMP1_3:1;
      vuint32_t TEMP1_2:1;
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TEMP1_0:1;
      vuint32_t  :4;                   /* Reserved */
      vuint32_t TEMP0_3:1;
      vuint32_t TEMP0_2:1;
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TEMP0_0:1;
    } B;
  } REE_TD;

  union {                              /* Temperature Reset Event Selection register */
    vuint32_t R;
    struct {
      vuint32_t  :20;                  /* Reserved */
      vuint32_t TEMP1_3:1;             /* TEMP1_3 Reset Event Select. */
      vuint32_t TEMP1_2:1;             /* TEMP1_2 Reset Event Select. */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TEMP1_0:1;             /* TEMP1_0 Reset Event Select. */
      vuint32_t  :4;                   /* Reserved */
      vuint32_t TEMP0_3:1;             /* TEMP0_3 Reset Event Select. */
      vuint32_t TEMP0_2:1;             /* TEMP0_2 Reset Event Select. */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TEMP0_0:1;             /* TEMP0_0 Reset Event Select. */
    } B;
  } RES_TD;

  union {                              /* Temperature detector configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :17;                  /* Reserved */
      vuint32_t TS1_TRIM_ADJ:5;
      vuint32_t TS1_DOUT_EN:1;
      vuint32_t TS1_AOUT_EN:1;
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TS0_TRIM_ADJ:5;
      vuint32_t TS0_DOUT_EN:1;
      vuint32_t TS0_AOUT_EN:1;
    } B;
  } CTL_TD;

  uint8_t PMC_reserved6[44];
  union {                              /* LVD Self Test Time Window Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;                  /* Reserved */
      vuint32_t STTW:12;
    } B;
  } STTW;

  union {                              /* Voltage Detect User Mode Test Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;                  /* Reserved */
      vuint32_t ST_RESULT:1;           /* Self Test Result. */
      vuint32_t ST_DONE:1;
      vuint32_t  :8;                   /* Reserved */
      vuint32_t ST_MODE:2;             /* Self Test mode bits for testing of LVDs and HVDs. */
      vuint32_t VD_ST_CTRL:6;
    } B;
  } VD_UTST;
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

struct PRAMC_tag {
  union {                              /* Platform RAM Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t PRI:2;                 /* AHB port arbitration mode. */
      vuint32_t P1_BO_DIS:1;           /* Port p1 read burst optimization disable. */
      vuint32_t P0_BO_DIS:1;           /* Port p0 read burst optimization disable. */
      vuint32_t  :5;
      vuint32_t FT_DIS:1;              /* Flow through disabled. */
    } B;
  } PRCR1;
};


/* ============================================================================
   =============================== Module: SGEN ===============================
   ============================================================================ */

struct SGEN_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t LDOS:1;                /* Load on set */
      vuint32_t  :1;
      vuint32_t IOAMPL:4;              /* IO amplitude */
      vuint32_t  :2;
      vuint32_t SEMASK:1;              /* Sine wave generator error mask interrupt register */
      vuint32_t  :3;
      vuint32_t TRIG_SEL:1;            /* Input trigger select */
      vuint32_t TRIG_EN:1;             /* Input phase align trigger enable bit */
      vuint32_t S0H1:1;                /* Operation status */
      vuint32_t PDS:1;                 /* Operation status */
      vuint32_t IOFREQ:16;             /* Sine wave frequency value on I/O pad */
    } B;
  } CTRL;

  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SERR:1;                /* Status error */
      vuint32_t  :3;
      vuint32_t FERR:1;                /* Force error */
      vuint32_t PHERR:1;               /* Phase error force bit */
      vuint32_t  :18;
    } B;
  } STAT;
};


/* ============================================================================
   =============================== Module: SIPI ===============================
   ============================================================================ */

struct SIPI_tag {
  union {                              /* SIPI Channel Control Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;                  /* Streaming Transfer. */
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;                 /* Read Request Transfer. */
      vuint32_t WRT:1;                 /* Write Request Transfer. */
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR0;

  union {                              /* SIPI Channel Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;                 /* Transaction ID of transmitted frame. */
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR0;

  uint8_t SIPI_reserved0[4];
  union {                              /* SIPI Channel Interrupt Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;                /* Write Acknowledge Interrupt Enable. */
      vuint32_t RAIE:1;                /* Read Answer Interrupt Enable. */
      vuint32_t TCIE:1;                /* Trigger Command Interrupt Enable. */
      vuint32_t TOIE:1;                /* Timeout Error Interrupt Enabled. */
      vuint32_t TIDIE:1;               /* Transaction ID Error Interrupt Enable. */
      vuint32_t ACKIE:1;               /* Acknowledge Error Interrupt Enable. */
    } B;
  } CIR0;

  union {                              /* SIPI Channel Timeout Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;                 /* Timeout value for transmitted requests. */
    } B;
  } CTOR0;

  union {                              /* SIPI Channel CRC Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC0;

  union {                              /* SIPI Channel Address Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR0;

  union {                              /* SIPI Channel Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CDR:32;
    } B;
  } CDR0;

  union {                              /* SIPI Channel Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;
      vuint32_t WRT:1;
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR1;

  union {                              /* SIPI Channel Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR1;

  uint8_t SIPI_reserved1[4];
  union {                              /* SIPI Channel Interrupt Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;
      vuint32_t RAIE:1;
      vuint32_t TCIE:1;
      vuint32_t TOIE:1;
      vuint32_t TIDIE:1;
      vuint32_t ACKIE:1;
    } B;
  } CIR1;

  union {                              /* SIPI Channel Timeout Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;                 /* Timeout value for transmitted requests. */
    } B;
  } CTOR1;

  union {                              /* SIPI Channel CRC Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC1;

  union {                              /* SIPI Channel Address Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR1;

  union {                              /* SIPI Channel Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CDR:32;
    } B;
  } CDR1;

  union {                              /* SIPI Channel Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;                 /* Read Request Transfer. */
      vuint32_t WRT:1;
      vuint32_t DEN:1;
    } B;
  } CCR2;

  union {                              /* SIPI Channel Status Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;                 /* Transaction ID of transmitted frame. */
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR2;

  uint8_t SIPI_reserved2[4];
  union {                              /* SIPI Channel Interrupt Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;
      vuint32_t RAIE:1;
      vuint32_t TCIE:1;
      vuint32_t TOIE:1;
      vuint32_t TIDIE:1;
      vuint32_t ACKIE:1;
    } B;
  } CIR2;

  union {                              /* SIPI Channel Timeout Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;
    } B;
  } CTOR2;

  union {                              /* SIPI Channel CRC Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC2;

  union {                              /* SIPI Channel Address Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR2;

  union {                              /* SIPI Channel Data Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CDR2:32;
    } B;
  } CDR2_[8];

  union {                              /* SIPI Channel Control Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;                  /* Streaming Transfer. */
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;
      vuint32_t WRT:1;
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR3;

  union {                              /* SIPI Channel Status Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;                 /* Transaction ID of transmitted frame. */
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR3;

  uint8_t SIPI_reserved3[4];
  union {                              /* SIPI Channel Interrupt Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;
      vuint32_t RAIE:1;
      vuint32_t TCIE:1;
      vuint32_t TOIE:1;
      vuint32_t TIDIE:1;
      vuint32_t ACKIE:1;
    } B;
  } CIR3;

  union {                              /* SIPI Channel Timeout Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;                 /* Timeout value for transmitted requests. */
    } B;
  } CTOR3;

  union {                              /* SIPI Channel CRC Register 3 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC3;

  union {                              /* SIPI Channel Address Register 3 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR3;

  union {                              /* SIPI Channel Data Register 3 */
    vuint32_t R;
    struct {
      vuint32_t CDR:32;
    } B;
  } CDR3;

  union {                              /* SIPI Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t FRZ:1;                 /* Freeze Enable */
      vuint32_t  :1;
      vuint32_t HALT:1;                /* Halt Mode Enable */
      vuint32_t  :2;
      vuint32_t PRSCLR:11;             /* Timeout counter prescaler */
      vuint32_t AID:2;                 /* Address Increment/Decrement */
      vuint32_t  :3;
      vuint32_t CRCIE:1;               /* CRC Error Interrupt Enable */
      vuint32_t MCRIE:1;               /* Max Count Reached Interrupt Enable */
      vuint32_t  :4;
      vuint32_t CHNSB:1;               /* Channel coding select bit. */
      vuint32_t TEN:1;                 /* Target Enable */
      vuint32_t INIT:1;                /* Initialization Mode */
      vuint32_t MOEN:1;                /* Module Enable */
      vuint32_t SR:1;                  /* Soft Reset */
    } B;
  } MCR;

  union {                              /* SIPI Status Register */
    vuint32_t R;
    struct {
      vuint32_t FRZACK:1;
      vuint32_t LPMACK:1;              /* Low Power Mode Acknowledge. */
      vuint32_t  :19;
      vuint32_t GCRCE:1;
      vuint32_t MCR:1;                 /* Maximum Count Reached. */
      vuint32_t  :1;
      vuint32_t TE:4;
      vuint32_t STATE:4;
    } B;
  } SR;

  union {                              /* SIPI Max Count Register */
    vuint32_t R;
    struct {
      vuint32_t MXCNT:30;
      vuint32_t  :2;
    } B;
  } MAXCR;

  union {                              /* SIPI Address Reload Register */
    vuint32_t R;
    struct {
      vuint32_t ADRLD:30;
      vuint32_t  :2;
    } B;
  } ARR;

  union {                              /* SIPI Address Count Register */
    vuint32_t R;
    struct {
      vuint32_t ADCNT:30;              /* Feflects the count value of address counter at target node. */
      vuint32_t  :2;
    } B;
  } ACR;

  union {                              /* SIPI Error Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t TOE3:1;
      vuint32_t TIDE3:1;
      vuint32_t ACKE3:1;
      vuint32_t  :5;
      vuint32_t TOE2:1;
      vuint32_t TIDE2:1;
      vuint32_t ACKE2:1;
      vuint32_t  :5;
      vuint32_t TOE1:1;
      vuint32_t TIDE1:1;
      vuint32_t ACKE1:1;
      vuint32_t  :5;
      vuint32_t TOE0:1;
      vuint32_t TIDE0:1;
      vuint32_t ACKE0:1;
    } B;
  } ERR;
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  union {                              /* SIUL2 MCU ID Register #1 */
    vuint32_t R;
    struct {
      vuint32_t PARTNUM:16;            /* MCU Part Number */
      vuint32_t ED:1;
      vuint32_t PKG:5;                 /* Package Settings */
      vuint32_t  :2;
      vuint32_t MAJOR_MASK:4;          /* Major Mask Revision */
      vuint32_t MINOR_MASK:4;          /* Minor Mask Revision */
    } B;
  } MIDR1;

  union {                              /* SIUL2 MCU ID Register #2 */
    vuint32_t R;
    struct {
      vuint32_t SF:1;                  /* Manufacturer */
      vuint32_t FLASH_SIZE_1:4;        /* Coarse granularity for flash memory size */
      vuint32_t FLASH_SIZE_2:4;        /* Fine granularity for flash memory size */
      vuint32_t  :7;
      vuint32_t PARTNUM:8;             /* ASCII character in MCU Part Number */
      vuint32_t  :8;
    } B;
  } MIDR2;

  uint8_t SIUL2_reserved1[4];
  union {                              /* SIUL2 DMA/Interrupt Status Flag Register0 */
    vuint32_t R;
    struct {
      vuint32_t EIF31:1;               /* External Interrupt Status Flag 31 */
      vuint32_t EIF30:1;               /* External Interrupt Status Flag 30 */
      vuint32_t EIF29:1;               /* External Interrupt Status Flag 29 */
      vuint32_t EIF28:1;               /* External Interrupt Status Flag 28 */
      vuint32_t EIF27:1;               /* External Interrupt Status Flag 27 */
      vuint32_t EIF26:1;               /* External Interrupt Status Flag 26 */
      vuint32_t EIF25:1;               /* External Interrupt Status Flag 25 */
      vuint32_t EIF24:1;               /* External Interrupt Status Flag 24 */
      vuint32_t EIF23:1;               /* External Interrupt Status Flag 23 */
      vuint32_t EIF22:1;               /* External Interrupt Status Flag 22 */
      vuint32_t EIF21:1;               /* External Interrupt Status Flag 21 */
      vuint32_t EIF20:1;               /* External Interrupt Status Flag 20 */
      vuint32_t EIF19:1;               /* External Interrupt Status Flag 19 */
      vuint32_t EIF18:1;               /* External Interrupt Status Flag 18 */
      vuint32_t EIF17:1;               /* External Interrupt Status Flag 17 */
      vuint32_t EIF16:1;               /* External Interrupt Status Flag 16 */
      vuint32_t EIF15:1;               /* External Interrupt Status Flag 15 */
      vuint32_t EIF14:1;               /* External Interrupt Status Flag 14 */
      vuint32_t EIF13:1;               /* External Interrupt Status Flag 13 */
      vuint32_t EIF12:1;               /* External Interrupt Status Flag 12 */
      vuint32_t EIF11:1;               /* External Interrupt Status Flag 11 */
      vuint32_t EIF10:1;               /* External Interrupt Status Flag 10 */
      vuint32_t EIF9:1;                /* External Interrupt Status Flag 9 */
      vuint32_t EIF8:1;                /* External Interrupt Status Flag 8 */
      vuint32_t EIF7:1;                /* External Interrupt Status Flag 7 */
      vuint32_t EIF6:1;                /* External Interrupt Status Flag 6 */
      vuint32_t EIF5:1;                /* External Interrupt Status Flag 5 */
      vuint32_t EIF4:1;                /* External Interrupt Status Flag 4 */
      vuint32_t EIF3:1;                /* External Interrupt Status Flag 3 */
      vuint32_t EIF2:1;                /* External Interrupt Status Flag 2 */
      vuint32_t EIF1:1;                /* External Interrupt Status Flag 1 */
      vuint32_t EIF0:1;                /* External Interrupt Status Flag 0 */
    } B;
  } DISR0;

  uint8_t SIUL2_reserved2[4];
  union {                              /* SIUL2 DMA/Interrupt Request Enable Register0 */
    vuint32_t R;
    struct {
      vuint32_t EIRE31:1;
      vuint32_t EIRE30:1;
      vuint32_t EIRE29:1;
      vuint32_t EIRE28:1;
      vuint32_t EIRE27:1;
      vuint32_t EIRE26:1;
      vuint32_t EIRE25:1;
      vuint32_t EIRE24:1;
      vuint32_t EIRE23:1;
      vuint32_t EIRE22:1;
      vuint32_t EIRE21:1;
      vuint32_t EIRE20:1;
      vuint32_t EIRE19:1;
      vuint32_t EIRE18:1;
      vuint32_t EIRE17:1;
      vuint32_t EIRE16:1;
      vuint32_t EIRE15:1;
      vuint32_t EIRE14:1;
      vuint32_t EIRE13:1;
      vuint32_t EIRE12:1;
      vuint32_t EIRE11:1;
      vuint32_t EIRE10:1;
      vuint32_t EIRE9:1;
      vuint32_t EIRE8:1;
      vuint32_t EIRE7:1;
      vuint32_t EIRE6:1;
      vuint32_t EIRE5:1;
      vuint32_t EIRE4:1;
      vuint32_t EIRE3:1;
      vuint32_t EIRE2:1;
      vuint32_t EIRE1:1;
      vuint32_t EIRE0:1;
    } B;
  } DIRER0;

  uint8_t SIUL2_reserved3[4];
  union {                              /* SIUL2 DMA/Interrupt Request Select Register0 */
    vuint32_t R;
    struct {
      vuint32_t DIRSR31:1;
      vuint32_t DIRSR30:1;
      vuint32_t DIRSR29:1;
      vuint32_t DIRSR28:1;
      vuint32_t DIRSR27:1;
      vuint32_t DIRSR26:1;
      vuint32_t DIRSR25:1;
      vuint32_t DIRSR24:1;
      vuint32_t DIRSR23:1;
      vuint32_t DIRSR22:1;
      vuint32_t DIRSR21:1;
      vuint32_t DIRSR20:1;
      vuint32_t DIRSR19:1;
      vuint32_t DIRSR18:1;
      vuint32_t DIRSR17:1;
      vuint32_t DIRSR16:1;
      vuint32_t DIRSR15:1;
      vuint32_t DIRSR14:1;
      vuint32_t DIRSR13:1;
      vuint32_t DIRSR12:1;
      vuint32_t DIRSR11:1;
      vuint32_t DIRSR10:1;
      vuint32_t DIRSR9:1;
      vuint32_t DIRSR8:1;
      vuint32_t DIRSR7:1;
      vuint32_t DIRSR6:1;
      vuint32_t DIRSR5:1;
      vuint32_t DIRSR4:1;
      vuint32_t DIRSR3:1;
      vuint32_t DIRSR2:1;
      vuint32_t DIRSR1:1;
      vuint32_t DIRSR0:1;
    } B;
  } DIRSR0;

  uint8_t SIUL2_reserved4[4];
  union {                              /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IREE31:1;
      vuint32_t IREE30:1;
      vuint32_t IREE29:1;
      vuint32_t IREE28:1;
      vuint32_t IREE27:1;
      vuint32_t IREE26:1;
      vuint32_t IREE25:1;
      vuint32_t IREE24:1;
      vuint32_t IREE23:1;
      vuint32_t IREE22:1;
      vuint32_t IREE21:1;
      vuint32_t IREE20:1;
      vuint32_t IREE19:1;
      vuint32_t IREE18:1;
      vuint32_t IREE17:1;
      vuint32_t IREE16:1;
      vuint32_t IREE15:1;
      vuint32_t IREE14:1;
      vuint32_t IREE13:1;
      vuint32_t IREE12:1;
      vuint32_t IREE11:1;
      vuint32_t IREE10:1;
      vuint32_t IREE9:1;
      vuint32_t IREE8:1;
      vuint32_t IREE7:1;
      vuint32_t IREE6:1;
      vuint32_t IREE5:1;
      vuint32_t IREE4:1;
      vuint32_t IREE3:1;
      vuint32_t IREE2:1;
      vuint32_t IREE1:1;
      vuint32_t IREE0:1;
    } B;
  } IREER0;

  uint8_t SIUL2_reserved5[4];
  union {                              /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IFEE31:1;
      vuint32_t IFEE30:1;
      vuint32_t IFEE29:1;
      vuint32_t IFEE28:1;
      vuint32_t IFEE27:1;
      vuint32_t IFEE26:1;
      vuint32_t IFEE25:1;
      vuint32_t IFEE24:1;
      vuint32_t IFEE23:1;
      vuint32_t IFEE22:1;
      vuint32_t IFEE21:1;
      vuint32_t IFEE20:1;
      vuint32_t IFEE19:1;
      vuint32_t IFEE18:1;
      vuint32_t IFEE17:1;
      vuint32_t IFEE16:1;
      vuint32_t IFEE15:1;
      vuint32_t IFEE14:1;
      vuint32_t IFEE13:1;
      vuint32_t IFEE12:1;
      vuint32_t IFEE11:1;
      vuint32_t IFEE10:1;
      vuint32_t IFEE9:1;
      vuint32_t IFEE8:1;
      vuint32_t IFEE7:1;
      vuint32_t IFEE6:1;
      vuint32_t IFEE5:1;
      vuint32_t IFEE4:1;
      vuint32_t IFEE3:1;
      vuint32_t IFEE2:1;
      vuint32_t IFEE1:1;
      vuint32_t IFEE0:1;
    } B;
  } IFEER0;

  uint8_t SIUL2_reserved6[4];
  union {                              /* SIUL2 Interrupt Filter Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IFE31:1;
      vuint32_t IFE30:1;
      vuint32_t IFE29:1;
      vuint32_t IFE28:1;
      vuint32_t IFE27:1;
      vuint32_t IFE26:1;
      vuint32_t IFE25:1;
      vuint32_t IFE24:1;
      vuint32_t IFE23:1;
      vuint32_t IFE22:1;
      vuint32_t IFE21:1;
      vuint32_t IFE20:1;
      vuint32_t IFE19:1;
      vuint32_t IFE18:1;
      vuint32_t IFE17:1;
      vuint32_t IFE16:1;
      vuint32_t IFE15:1;
      vuint32_t IFE14:1;
      vuint32_t IFE13:1;
      vuint32_t IFE12:1;
      vuint32_t IFE11:1;
      vuint32_t IFE10:1;
      vuint32_t IFE9:1;
      vuint32_t IFE8:1;
      vuint32_t IFE7:1;
      vuint32_t IFE6:1;
      vuint32_t IFE5:1;
      vuint32_t IFE4:1;
      vuint32_t IFE3:1;
      vuint32_t IFE2:1;
      vuint32_t IFE1:1;
      vuint32_t IFE0:1;
    } B;
  } IFER0;

  uint8_t SIUL2_reserved7[4];
  union {                              /* SIUL2 Interrupt Filter Maximum Counter Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t MAXCNT:4;              /* Maximum Interrupt Filter Counter setting */
    } B;
  } IFMCR[32];

  union {                              /* SIUL2 Interrupt Filter Clock Prescaler Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t IFCP:4;                /* Interrupt Filter Clock Prescaler setting */
    } B;
  } IFCPR;

  uint8_t SIUL2_reserved8[380];

/*******************************************************************************  
*   Unimplemented registers should not be accessed by the user. Refer to the   * 
*     Reference Manual for the implemented SIUL2 MSCR and IMCR registers.      *
* *****************************************************************************/

  union {                              /* SIUL2 Multiplexed Signal Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t SRC:2;                 /* Slew Rate Control */
      vuint32_t  :2;
      vuint32_t OBE:1;                 /* GPIO Output Buffer Enable */
      vuint32_t ODE:1;                 /* Open Drain Enable */
      vuint32_t SMC:1;                 /* Safe Mode Control */
      vuint32_t APC:1;                 /* Analog Pad Control */
      vuint32_t  :2;
      vuint32_t IBE:1;                 /* Input Buffer Enable */
      vuint32_t HYS:1;                 /* Input Hysteresis */
      vuint32_t PUS:1;                 /* Pull Select */
      vuint32_t PUE:1;                 /* Pull Enable */
      vuint32_t INV:1;                 /* Invert */
      vuint32_t  :7;
      vuint32_t  :4;
      vuint32_t SSS:4;                 /* Source Signal Select */
    } B;
  } MSCR[155];

  uint8_t SIUL2_reserved9[1428];

/*******************************************************************************  
*   Unimplemented registers should not be accessed by the user. Refer to the   * 
*     Reference Manual for the implemented SIUL2 MSCR and IMCR registers.      *
* *****************************************************************************/

  union {                              /* SIUL2 Input Multiplexed Signal Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t INV:1;                 /* Invert */
      vuint32_t  :7;
      vuint32_t  :4;
      vuint32_t SSS:4;                 /* Source Signal Select */
    } B;
  } IMCR[234];

  uint8_t SIUL2_reserved10[1304];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :7;					 /*  */
        vuint8_t PDO:1;					 /* Pad Data Out */
    } B;
  } GPDO[156];

  uint8_t SIUL2_reserved11[356];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :7;					 /*  */
        vuint8_t PDI:1;					 /* Pad Data In */
    } B;
  } GPDI[156];

  uint8_t SIUL2_reserved12[356];
  union {                              /* SIUL2 Parallel GPIO Pad Data Out Register */
    vuint16_t R;
    struct {
      vuint16_t PPDO:16;               /* Parallel Pad Data Out */
    } B;
  } PGPDO[10];

  uint8_t SIUL2_reserved13[44];
  union {                              /* SIUL2 Parallel GPIO Pad Data In Register */
    vuint16_t R;
    struct {
      vuint16_t PPDI:16;               /* Parallel Pad Data In */
    } B;
  } PGPDI[10];

  uint8_t SIUL2_reserved14[44];
  union {                              /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
    vuint32_t R;
    struct {
      vuint32_t MASK:16;               /* Mask Field */
      vuint32_t MPPDO:16;              /* Masked Parallel Pad Data Out */
    } B;
  } MPGPDO[10];
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

struct SMPU_tag {
  union {                              /* Control/Error Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t MERR:16;               /* Master n error, where the bus master number matches the bit number */
      vuint32_t  :1;
      vuint32_t  :11;
      vuint32_t HRL:3;                 /* Hardware revision level */
      vuint32_t GVLD:1;                /* Global Valid (global enable/disable for the SMPU) */
    } B;
  } CESR0;

  union {                              /* Control/Error Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t MEOVR:16;              /* Master n error overrun, where the bus master number matches the bit number */
      vuint32_t  :1;
      vuint32_t  :11;
      vuint32_t NRGD:4;                /* Number of region descriptors */
    } B;
  } CESR1;

  uint8_t SMPU_reserved0[248];
  struct {
    union {                            /* Error Address Register, Bus Master n */
      vuint32_t R;
      struct {
        vuint32_t EADDR:32;            /* Error address */
      } B;
    } EAR;
    union {                            /* Error Detail Register, Bus Master n */
      vuint32_t R;
      struct {
        vuint32_t EACD:24;             /* Error access control detail */
        vuint32_t  :1;
        vuint32_t EATTR:2;             /* Error attributes */
        vuint32_t ERW:1;               /* Error read/write */
        vuint32_t EMN:4;               /* Error master number */
      } B;
    } EDR;
  } ERROR[16];

  uint8_t SMPU_reserved1[640];
  struct {
    union {                            /* Region Descriptor n, Word 0 */
      vuint32_t R;
      struct {
        vuint32_t SRTADDR:32;          /* Start address */
      } B;
    } WORD0;
    union {                            /* Region Descriptor n, Word 1 */
      vuint32_t R;
      struct {
        vuint32_t ENDADDR:32;          /* End address */
      } B;
    } WORD1;
    union {                            /* Region Descriptor n, Word 2 */
      vuint32_t R;
      struct {
        vuint32_t M0P:2;               /* Bus master 0 permissions */
        vuint32_t M1P:2;               /* Bus master 1 permissions */
        vuint32_t M2P:2;               /* Bus master 2 permissions */
        vuint32_t M3P:2;               /* Bus master 3 permissions */
        vuint32_t M4P:2;               /* Bus master 4 permissions */
        vuint32_t M5P:2;               /* Bus master 5 permissions */
        vuint32_t M6P:2;               /* Bus master 6 permissions */
        vuint32_t M7P:2;               /* Bus master 7 permissions */
        vuint32_t M8P:2;               /* Bus master 8 permissions */
        vuint32_t M9P:2;               /* Bus master 9 permissions */
        vuint32_t M10P:2;              /* Bus master 10 permissions */
        vuint32_t M11P:2;              /* Bus master 11 permissions */
        vuint32_t M12P:2;              /* Bus master 12 permissions */
        vuint32_t M13P:2;              /* Bus master 13 permissions */
        vuint32_t M14P:2;              /* Bus master 14 permissions */
        vuint32_t M15P:2;              /* Bus master 15 permissions */
      } B;
    } WORD2;
    union {                            /* Region Descriptor n, Word 3 */
      vuint32_t R;
      struct {
        vuint32_t  :28;
        vuint32_t RO:1;                /* Read-Only */
        vuint32_t  :1;
        vuint32_t CI:1;                /* Cache Inhibit */
        vuint32_t VLD:1;               /* Valid */
      } B;
    } WORD3;
  } RGD[16];
};


/* ============================================================================
   =============================== Module: SPI ================================
   ============================================================================ */

struct SPI_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MSTR:1;                /* Master/Slave Mode Select */
      vuint32_t CONT_SCKE:1;           /* Continuous SCK Enable */
      vuint32_t DCONF:2;               /* SPI Configuration. */
      vuint32_t FRZ:1;                 /* Freeze */
      vuint32_t MTFE:1;                /* Modified Timing Format Enable */
      vuint32_t  :1;
      vuint32_t ROOE:1;                /* Receive FIFO Overflow Overwrite Enable */
      vuint32_t PCSIS:8;               /* Peripheral Chip Select x Inactive State */
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t DIS_TXF:1;             /* Disable Transmit FIFO */
      vuint32_t DIS_RXF:1;             /* Disable Receive FIFO */
      vuint32_t CLR_TXF:1;             /* Clear TX FIFO */
      vuint32_t CLR_RXF:1;
      vuint32_t SMPL_PT:2;             /* Sample Point */
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t HALT:1;                /* Halt */
    } B;
  } MCR;

  uint8_t SPI_reserved0[4];
  union {                              /* Transfer Count Register */
    vuint32_t R;
    struct {
      vuint32_t SPI_TCNT:16;           /* SPI Transfer Counter */
      vuint32_t  :16;
    } B;
  } TCR;

  union {
    union {                            /* Clock and Transfer Attributes Register (In Master Mode) */
      vuint32_t R;
      struct {
        vuint32_t DBR:1;               /* Double Baud Rate */
        vuint32_t FMSZ:4;              /* Frame Size */
        vuint32_t CPOL:1;              /* Clock Polarity */
        vuint32_t CPHA:1;              /* Clock Phase */
        vuint32_t LSBFE:1;             /* LSB First */
        vuint32_t PCSSCK:2;            /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;              /* After SCK Delay Prescaler */
        vuint32_t PDT:2;               /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;               /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;             /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;               /* After SCK Delay Scaler */
        vuint32_t DT:4;                /* Delay After Transfer Scaler */
        vuint32_t BR:4;                /* Baud Rate Scaler */
      } B;
    } CTAR[4];
    union {                            /* Clock and Transfer Attributes Register (In Slave Mode) */
      vuint32_t R;
      struct {
        vuint32_t FMSZ:5;              /* Frame Size */
        vuint32_t CPOL:1;              /* Clock Polarity */
        vuint32_t CPHA:1;              /* Clock Phase */
        vuint32_t  :2;
        vuint32_t  :1;
        vuint32_t  :22;
      } B;
    } CTAR_SLAVE[1];
  } MODE;

  uint8_t SPI_reserved1[16];
  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t TCF:1;                 /* Transfer Complete Flag */
      vuint32_t TXRXS:1;               /* TX and RX Status */
      vuint32_t  :1;
      vuint32_t EOQF:1;                /* End of Queue Flag */
      vuint32_t TFUF:1;                /* Transmit FIFO Underflow Flag */
      vuint32_t  :1;
      vuint32_t TFFF:1;                /* Transmit FIFO Fill Flag */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t RFOF:1;                /* Receive FIFO Overflow Flag */
      vuint32_t  :1;
      vuint32_t RFDF:1;                /* Receive FIFO Drain Flag */
      vuint32_t  :1;
      vuint32_t TXCTR:4;               /* TX FIFO Counter */
      vuint32_t TXNXTPTR:4;            /* Transmit Next Pointer */
      vuint32_t RXCTR:4;               /* RX FIFO Counter */
      vuint32_t POPNXTPTR:4;           /* Pop Next Pointer */
    } B;
  } SR;

  union {                              /* DMA/Interrupt Request Select and Enable Register */
    vuint32_t R;
    struct {
      vuint32_t TCF_RE:1;              /* Transmission Complete Request Enable */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t EOQF_RE:1;             /* Finished Request Enable */
      vuint32_t TFUF_RE:1;             /* Transmit FIFO Underflow Request Enable */
      vuint32_t  :1;
      vuint32_t TFFF_RE:1;             /* Transmit FIFO Fill Request Enable */
      vuint32_t TFFF_DIRS:1;           /* Transmit FIFO Fill DMA or Interrupt Request Select */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t RFOF_RE:1;             /* Receive FIFO Overflow Request Enable */
      vuint32_t  :1;
      vuint32_t RFDF_RE:1;             /* Receive FIFO Drain Request Enable */
      vuint32_t RFDF_DIRS:1;           /* Receive FIFO Drain DMA or Interrupt Request Select */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :14;
    } B;
  } RSER;

  union {
    union {                            /* PUSH TX FIFO Register In Master Mode */
      vuint32_t R;
      struct {
        vuint32_t CONT:1;              /* Continuous Peripheral Chip Select Enable */
        vuint32_t CTAS:3;              /* Clock and Transfer Attributes Select */
        vuint32_t EOQ:1;               /* End Of Queue */
        vuint32_t CTCNT:1;             /* Clear Transfer Counter */
        vuint32_t  :2;
        vuint32_t PCS:8;
        vuint32_t TXDATA:16;           /* Transmit Data */
      } B;
    } PUSHR;
    union {                            /* PUSH TX FIFO Register In Slave Mode */
      vuint32_t R;
      struct {
        vuint32_t TXDATA:32;           /* Transmit Data */
      } B;
    } PUSHR_SLAVE;
  } PUSHR;

  union {                              /* POP RX FIFO Register */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;             /* Received Data */
    } B;
  } POPR;

  union {                              /* Transmit FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t TXCMD_TXDATA:16;       /* Transmit Command or Transmit Data */
      vuint32_t TXDATA:16;             /* Transmit Data */
    } B;
  } TXFR[5];

  uint8_t SPI_reserved2[44];
  union {                              /* Receive FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;             /* Receive Data */
    } B;
  } RXFR[5];
};


/* ============================================================================
   =============================== Module: SRX ================================
   ============================================================================ */

struct SRX_tag {
  union {                              /* Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t TSPRSC:8;
      vuint32_t  :3;
      vuint32_t FIFOWM:5;
      vuint32_t  :5;
      vuint32_t FMFOIE:1;
      vuint32_t FMDUIE:1;
      vuint32_t SMDUIE:1;
      vuint32_t  :1;
      vuint32_t FIFO_EN:1;
      vuint32_t  :1;
      vuint32_t FAST_CLR:1;
      vuint32_t  :1;
      vuint32_t DBG_FRZ:1;
      vuint32_t  :1;
      vuint32_t SENT_EN:1;
    } B;
  } GBL_CTRL;

  union {                              /* Channel Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t EN_CH:16;
    } B;
  } CHNL_EN;

  union {                              /* Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t FMFO:1;
      vuint32_t FDMU:1;
      vuint32_t SMDU:1;
      vuint32_t  :8;
    } B;
  } GBL_STATUS;

  union {                              /* Fast Message Ready Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t F_RDY:16;
    } B;
  } FMSG_RDY;

  union {                              /* Slow Serial Message Ready Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t S_RDY:16;
    } B;
  } SMSG_RDY;

  uint8_t SRX_reserved0[4];
  union {                              /* Data Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t NIBBCH0:3;
      vuint32_t  :1;
      vuint32_t NIBBCH1:3;
      vuint32_t  :1;
      vuint32_t NIBBCH2:3;
      vuint32_t  :1;
      vuint32_t NIBBCH3:3;
      vuint32_t  :1;
      vuint32_t NIBBCH4:3;
      vuint32_t  :1;
      vuint32_t NIBBCH5:3;
      vuint32_t  :1;
      vuint32_t NIBBCH6:3;
      vuint32_t  :1;
      vuint32_t NIBBCH7:3;
    } B;
  } DATA_CTRL1;

  union {                              /* Data Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t NIBBCH8:3;
      vuint32_t  :1;
      vuint32_t NIBBCH9:3;
      vuint32_t  :1;
      vuint32_t NIBBCH10:3;
      vuint32_t  :1;
      vuint32_t NIBBCH11:3;
      vuint32_t  :1;
      vuint32_t NIBBCH12:3;
      vuint32_t  :1;
      vuint32_t NIBBCH13:3;
      vuint32_t  :1;
      vuint32_t NIBBCH14:3;
      vuint32_t  :1;
      vuint32_t NIBBCH15:3;
    } B;
  } DATA_CTRL2;

  uint8_t SRX_reserved1[8];
  union {                              /* Fast Message DMA Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FDMA_EN:16;
    } B;
  } FDMA_CTRL;

  union {                              /* Slow Serial Message DMA Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SDMA_EN:16;
    } B;
  } SDMA_CTRL;

  uint8_t SRX_reserved2[4];
  union {                              /* Fast Message Ready Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FRDY_IE:16;
    } B;
  } FRDY_IE;

  union {                              /* Slow Serial Message Ready Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SRDY_IE:16;
    } B;
  } SRDY_IE;

  uint8_t SRX_reserved3[4];
  union {                              /* DMA Fast Message Data Read Register */
    vuint32_t R;
    struct {
      vuint32_t CHNUM:4;
      vuint32_t SCNIB:4;
      vuint32_t DNIB1:4;
      vuint32_t DNIB2:4;
      vuint32_t DNIB3:4;
      vuint32_t DNIB4:4;
      vuint32_t DNIB5:4;
      vuint32_t DNIB6:4;
    } B;
  } DMA_FMSG_DATA;

  union {                              /* DMA Fast Message CRC Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t CRC4b:4;
      vuint32_t  :16;
    } B;
  } DMA_FMSG_CRC;

  union {                              /* DMA Fast Message Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t TS:32;
    } B;
  } DMA_FMSG_TS;

  uint8_t SRX_reserved4[4];
  union {                              /* DMA Slow Serial Message Bit3 Read Register */
    vuint32_t R;
    struct {
      vuint32_t CHNUM:4;
      vuint32_t TYPE:1;
      vuint32_t  :16;
      vuint32_t CFG:1;
      vuint32_t ID7_4_D3_0:4;
      vuint32_t  :1;
      vuint32_t ID3_0_DATA15_12:4;
      vuint32_t  :1;
    } B;
  } DMA_SMSG_BIT3;

  union {                              /* DMA Slow Serial Message Bit2 Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t SMCRC:6;
      vuint32_t  :4;
      vuint32_t DATA:12;
    } B;
  } DMA_SMSG_BIT2;

  union {                              /* DMA Slow Serial Message Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t TS:32;
    } B;
  } DMA_SMSG_TS;

  uint8_t SRX_reserved5[4];
  struct {
    union {                            /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t  :1;
        vuint32_t CM_PRSC:15;
        vuint32_t COMP_EN:1;
        vuint32_t  :1;
        vuint32_t PRSC:14;
      } B;
    } CLK_CTRL;
    union {                            /* Channel 'n' Status Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t BUS_IDLE:1;
        vuint32_t  :3;
        vuint32_t CAL_RESYNC:1;
        vuint32_t CAL_20_25:1;
        vuint32_t SMSG_OFLW:1;
        vuint32_t FMSG_OFLW:1;
        vuint32_t  :1;
        vuint32_t PP_DIAG_ERR:1;
        vuint32_t CAL_LEN_ERR:1;
        vuint32_t CAL_DIAG_ERR:1;
        vuint32_t NIB_VAL_ERR:1;
        vuint32_t SMSG_CRC_ERR:1;
        vuint32_t FMSG_CRC_ERR:1;
        vuint32_t NUM_EDGES_ERR:1;
        vuint32_t  :16;
      } B;
    } STATUS;
    union {                            /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t BUS_IDLE_CNT:4;
        vuint32_t IE_CAL_RESYNC:1;
        vuint32_t IE_CAL_20_25:1;
        vuint32_t IE_SMSG_OFLW:1;
        vuint32_t IE_FMSG_OFLW:1;
        vuint32_t FCRC_CHK_OFF:1;
        vuint32_t IE_PP_DIAG_ERR:1;
        vuint32_t IE_CAL_LEN_ERR:1;
        vuint32_t IE_CAL_DIAG_ERR:1;
        vuint32_t IE_NIB_VAL_ERR:1;
        vuint32_t IE_SMSG_CRC_ERR:1;
        vuint32_t IE_FMSG_CRC_ERR:1;
        vuint32_t IE_NUM_EDGES_ERR:1;
        vuint32_t DCHNG_INT:1;
        vuint32_t CAL_RNG:1;
        vuint32_t PP_CHKSEL:1;
        vuint32_t FCRC_TYPE:1;
        vuint32_t FCRC_SC_EN:1;
        vuint32_t SCRC_TYPE:1;
        vuint32_t PAUSE_EN:1;
        vuint32_t SUCC_CAL_CHK:1;
        vuint32_t FIL_CNT:8;
      } B;
    } CONFIG;
    uint8_t CH_reserved0[4];
  } CH[16];

  struct {
    union {                            /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t CHNUM:4;
        vuint32_t SCNIB:4;
        vuint32_t DNIB1:4;
        vuint32_t DNIB2:4;
        vuint32_t DNIB3:4;
        vuint32_t DNIB4:4;
        vuint32_t DNIB5:4;
        vuint32_t DNIB6:4;
      } B;
    } FMSG_DATA;
    union {                            /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t  :12;
        vuint32_t CRC4b:4;
        vuint32_t  :16;
      } B;
    } FMSG_CRC;
    union {                            /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t TS:32;
      } B;
    } FMSG_TS;
    union {                            /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t CHNUM:4;
        vuint32_t TYPE:1;
        vuint32_t  :16;
        vuint32_t CFG:1;
        vuint32_t ID7_4_ID3_0:4;
        vuint32_t  :1;
        vuint32_t ID3_0_DATA15_12:4;
        vuint32_t  :1;
      } B;
    } SMSG_BIT3;
    union {                            /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t  :10;
        vuint32_t SMCRC:6;
        vuint32_t  :4;
        vuint32_t DATA:12;
      } B;
    } SMSG_BIT2;
    union {                            /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t TS:32;
      } B;
    } SMSG_TS;
  } CHANNEL[16];
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

struct SSCM_tag {
  union {                              /* SSCM System Status */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t CER:1;                 /* Configuration Error */
      vuint16_t CERS:1;                /* Configuration Error for Safe DCF Clients */
      vuint16_t  :1;
      vuint16_t NXEN:1;                /* Processor 0 Nexus enable status */
      vuint16_t PUB:1;                 /* Public Serial Access Status */
      vuint16_t SEC:1;                 /* Security Status */
      vuint16_t  :1;
      vuint16_t BMODE:3;               /* Device Boot Mode */
      vuint16_t VLE:1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :2;
    } B;
  } STATUS;

  union {                              /* SSCM System Memory and ID Register */
    vuint16_t R;
    struct {
      vuint16_t JPIN:10;
      vuint16_t IVLD:1;                /* Instruction flash memory Valid */
      vuint16_t MREV:4;                /* Minor Mask Revision */
      vuint16_t DVLD:1;                /* Data flash memory Valid */
    } B;
  } MEMCONFIG;

  uint8_t SSCM_reserved0[2];
  union {                              /* SSCM Error Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t  :14;
      vuint16_t PAE:1;                 /* Peripheral Bus Abort Enable. */
      vuint16_t RAE:1;                 /* Register Bus Abort Enable. */
    } B;
  } ERROR;

  union {                              /* SSCM Debug Status Port Register */
    vuint16_t R;
    struct {
      vuint16_t  :13;
      vuint16_t DEBUG_MODE:3;
    } B;
  } DEBUGPORT;

  uint8_t SSCM_reserved1[22];
  union {                              /* User Option Status Register */
    vuint32_t R;
    struct {
      vuint32_t UOPT:32;               /* Shows the values read from the User Option Bits location in the flash memory. */
    } B;
  } UOPS;

  uint8_t SSCM_reserved2[4];
  union {                              /* Processor Start Address Register */
    vuint32_t R;
    struct {
      vuint32_t SADR:32;               /* Processor Start Address */
    } B;
  } PSA;
};


/* ============================================================================
   =============================== Module: STCU ===============================
   ============================================================================ */

struct STCU_tag {
  uint8_t STCU_reserved0[4];
  union {                              /* STCU2 Run Software Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t MBSWPLLEN:1;
      vuint32_t LBSWPLLEN:1;
      vuint32_t  :6;
      vuint32_t  :1;
      vuint32_t RUNSW:1;
    } B;
  } RUNSW;

  union {                              /* STCU2 SK Code Register */
    vuint32_t R;
    struct {
      vuint32_t SKC:32;
    } B;
  } SKC;

  union {                              /* STCU2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PTR:7;
      vuint32_t LB_DELAY:8;
      vuint32_t  :7;
      vuint32_t WRP:1;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t PMOSEN:1;
      vuint32_t MBU:1;
      vuint32_t CLK_CFG:3;
    } B;
  } CFG;

  uint8_t STCU_reserved1[4];
  union {                              /* STCU2 Watchdog Register Granularity */
    vuint32_t R;
    struct {
      vuint32_t WDGEOC:32;
    } B;
  } WDG;

  uint8_t STCU_reserved2[12];
  union {                              /* STCU2 Error Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t LOCKESW:1;
      vuint32_t WDTOSW:1;
      vuint32_t  :1;
      vuint32_t ENGESW:1;
      vuint32_t INVPSW:1;
      vuint32_t  :6;
      vuint32_t CFSF:1;
      vuint32_t NCFSF:1;
      vuint32_t  :3;
      vuint32_t LOCKE:1;
      vuint32_t WDTO:1;
      vuint32_t  :1;
      vuint32_t ENGE:1;
      vuint32_t INVP:1;
    } B;
  } ERR_STAT;

  uint8_t STCU_reserved3[4];
  union {                              /* STCU2 Startup LBIST Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t LBS3:1;
      vuint32_t LBS2:1;
      vuint32_t LBS1:1;
      vuint32_t LBS0:1;
    } B;
  } LBS;

  union {                              /* STCU2 Startup LBIST End Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t LBE3:1;
      vuint32_t LBE2:1;
      vuint32_t LBE1:1;
      vuint32_t LBE0:1;
    } B;
  } LBE;

  union {                              /* STCU2 Shutdown LBIST Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t LBSSW3:1;
      vuint32_t LBSSW2:1;
      vuint32_t LBSSW1:1;
      vuint32_t LBSSW0:1;
    } B;
  } LBSSW;

  union {                              /* STCU2 Shutdown LBIST End Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t LBESW3:1;
      vuint32_t LBESW2:1;
      vuint32_t LBESW1:1;
      vuint32_t LBESW0:1;
    } B;
  } LBESW;

  union {                              /* STCU2 Shutdown LBIST Reset Management */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LBRMSW15:1;
      vuint32_t LBRMSW14:1;
      vuint32_t LBRMSW13:1;
      vuint32_t LBRMSW12:1;
      vuint32_t LBRMSW11:1;
      vuint32_t LBRMSW10:1;
      vuint32_t LBRMSW9:1;
      vuint32_t LBRMSW8:1;
      vuint32_t LBRMSW7:1;
      vuint32_t LBRMSW6:1;
      vuint32_t LBRMSW5:1;
      vuint32_t LBRMSW4:1;
      vuint32_t LBRMSW3:1;
      vuint32_t LBRMSW2:1;
      vuint32_t LBRMSW1:1;
      vuint32_t LBRMSW0:1;
    } B;
  } LBRMSW;

  uint8_t STCU_reserved4[4];
  union {                              /* STCU2 Startup MBIST Status Low Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t MBS26:1;
      vuint32_t MBS25:1;
      vuint32_t MBS24:1;
      vuint32_t MBS23:1;
      vuint32_t MBS22:1;
      vuint32_t MBS21:1;
      vuint32_t MBS20:1;
      vuint32_t MBS19:1;
      vuint32_t MBS18:1;
      vuint32_t MBS17:1;
      vuint32_t MBS16:1;
      vuint32_t MBS15:1;
      vuint32_t MBS14:1;
      vuint32_t MBS13:1;
      vuint32_t MBS12:1;
      vuint32_t MBS11:1;
      vuint32_t MBS10:1;
      vuint32_t MBS9:1;
      vuint32_t MBS8:1;
      vuint32_t MBS7:1;
      vuint32_t MBS6:1;
      vuint32_t MBS5:1;
      vuint32_t MBS4:1;
      vuint32_t MBS3:1;
      vuint32_t MBS2:1;
      vuint32_t MBS1:1;
      vuint32_t MBS0:1;
    } B;
  } MBSL;

  uint8_t STCU_reserved5[8];
  union {                              /* STCU2 Startup MBIST End Flag Low Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t MBE26:1;
      vuint32_t MBE25:1;
      vuint32_t MBE24:1;
      vuint32_t MBE23:1;
      vuint32_t MBE22:1;
      vuint32_t MBE21:1;
      vuint32_t MBE20:1;
      vuint32_t MBE19:1;
      vuint32_t MBE18:1;
      vuint32_t MBE17:1;
      vuint32_t MBE16:1;
      vuint32_t MBE15:1;
      vuint32_t MBE14:1;
      vuint32_t MBE13:1;
      vuint32_t MBE12:1;
      vuint32_t MBE11:1;
      vuint32_t MBE10:1;
      vuint32_t MBE9:1;
      vuint32_t MBE8:1;
      vuint32_t MBE7:1;
      vuint32_t MBE6:1;
      vuint32_t MBE5:1;
      vuint32_t MBE4:1;
      vuint32_t MBE3:1;
      vuint32_t MBE2:1;
      vuint32_t MBE1:1;
      vuint32_t MBE0:1;
    } B;
  } MBEL;

  uint8_t STCU_reserved6[8];
  union {                              /* STCU2 Shutdown MBIST Status Low Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t MBSSW26:1;
      vuint32_t MBSSW25:1;
      vuint32_t MBSSW24:1;
      vuint32_t MBSSW23:1;
      vuint32_t MBSSW22:1;
      vuint32_t MBSSW21:1;
      vuint32_t MBSSW20:1;
      vuint32_t MBSSW19:1;
      vuint32_t MBSSW18:1;
      vuint32_t MBSSW17:1;
      vuint32_t MBSSW16:1;
      vuint32_t MBSSW15:1;
      vuint32_t MBSSW14:1;
      vuint32_t MBSSW13:1;
      vuint32_t MBSSW12:1;
      vuint32_t MBSSW11:1;
      vuint32_t MBSSW10:1;
      vuint32_t MBSSW9:1;
      vuint32_t MBSSW8:1;
      vuint32_t MBSSW7:1;
      vuint32_t MBSSW6:1;
      vuint32_t MBSSW5:1;
      vuint32_t MBSSW4:1;
      vuint32_t MBSSW3:1;
      vuint32_t MBSSW2:1;
      vuint32_t MBSSW1:1;
      vuint32_t MBSSW0:1;
    } B;
  } MBSLSW;

  uint8_t STCU_reserved7[8];
  union {                              /* STCU2 Shutdown MBIST End Flag Low Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t MBESW26:1;
      vuint32_t MBESW25:1;
      vuint32_t MBESW24:1;
      vuint32_t MBESW23:1;
      vuint32_t MBESW22:1;
      vuint32_t MBESW21:1;
      vuint32_t MBESW20:1;
      vuint32_t MBESW19:1;
      vuint32_t MBESW18:1;
      vuint32_t MBESW17:1;
      vuint32_t MBESW16:1;
      vuint32_t MBESW15:1;
      vuint32_t MBESW14:1;
      vuint32_t MBESW13:1;
      vuint32_t MBESW12:1;
      vuint32_t MBESW11:1;
      vuint32_t MBESW10:1;
      vuint32_t MBESW9:1;
      vuint32_t MBESW8:1;
      vuint32_t MBESW7:1;
      vuint32_t MBESW6:1;
      vuint32_t MBESW5:1;
      vuint32_t MBESW4:1;
      vuint32_t MBESW3:1;
      vuint32_t MBESW2:1;
      vuint32_t MBESW1:1;
      vuint32_t MBESW0:1;
    } B;
  } MBELSW;

  uint8_t STCU_reserved8[148];
  struct {
    union {                            /* STCU2 LBIST Control Register */
      vuint32_t R;
      struct {
        vuint32_t CSM:1;
        vuint32_t PTR:7;
        vuint32_t  :4;
        vuint32_t PRPGEN:1;
        vuint32_t SHS:3;
        vuint32_t SCEN_OFF:4;
        vuint32_t SCEN_ON:4;
        vuint32_t  :2;
        vuint32_t CWS:6;
      } B;
    } CTRL;
    union {                            /* STCU2 LBIST PC Stop Register */
      vuint32_t R;
      struct {
        vuint32_t  :6;
        vuint32_t PCS:26;
      } B;
    } PCS;
    uint8_t LB_reserved0[24];
    union {                            /* STCU2 Shutdown LBIST MISR Expected Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISRESWx:32;
      } B;
    } MISRELSW;
    union {                            /* STCU2 Shutdown LBIST MISR Expected High Register */
      vuint32_t R;
      struct {
        vuint32_t MISRESWx:32;
      } B;
    } MISREHSW;
    uint8_t LB_reserved1[24];
  } LB[4];

  uint8_t STCU_reserved9[1024];
  union {                              /* STCU2 MBIST Control Register */
    vuint32_t R;
    struct {
      vuint32_t CSM:1;
      vuint32_t PTR:7;
      vuint32_t  :24;
    } B;
  } MB_CTRL[27];
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

struct STM_tag {
  union {                              /* STM Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CPS:8;                 /* Counter Prescaler. */
      vuint32_t  :6;
      vuint32_t FRZ:1;                 /* Freeze. */
      vuint32_t TEN:1;                 /* Timer counter Enabled. */
    } B;
  } CR;

  union {                              /* STM Count Register */
    vuint32_t R;
    struct {
      vuint32_t CNT:32;                /* Timer count value used as the time base for all channels. */
    } B;
  } CNT;

  uint8_t STM_reserved0[8];
  struct {
    union {                            /* STM Channel Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t CEN:1;               /* Channel Enable */
      } B;
    } CCR;
    union {                            /* STM Channel Interrupt Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t CIF:1;               /* Channel Interrupt Flag */
      } B;
    } CIR;
    union {                            /* STM Channel Compare Register */
      vuint32_t R;
      struct {
        vuint32_t CMP:32;              /* Compare value for channel n. */
      } B;
    } CMP;
    uint8_t CHANNEL_reserved0[4];
  } CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

struct SWT_tag {
  union {                              /* SWT Control Register */
    vuint32_t R;
    struct {
      vuint32_t MAP0:1;
      vuint32_t MAP1:1;
      vuint32_t MAP2:1;
      vuint32_t MAP3:1;
      vuint32_t MAP4:1;
      vuint32_t MAP5:1;
      vuint32_t MAP6:1;
      vuint32_t MAP7:1;
      vuint32_t  :13;
      vuint32_t SMD:2;                 /* Service Mode. */
      vuint32_t RIA:1;
      vuint32_t WND:1;
      vuint32_t ITR:1;
      vuint32_t HLK:1;
      vuint32_t SLK:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t STP:1;
      vuint32_t FRZ:1;
      vuint32_t WEN:1;
    } B;
  } CR;

  union {                              /* SWT Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t TIF:1;
    } B;
  } IR;

  union {                              /* SWT Time-out Register */
    vuint32_t R;
    struct {
      vuint32_t WTO:32;
    } B;
  } TO;

  union {                              /* SWT Window Register */
    vuint32_t R;
    struct {
      vuint32_t WST:32;
    } B;
  } WN;

  union {                              /* SWT Service Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t WSC:16;
    } B;
  } SR;

  union {                              /* SWT Counter Output Register */
    vuint32_t R;
    struct {
      vuint32_t CNT:32;
    } B;
  } CO;

  union {                              /* SWT Service Key Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SK:16;
    } B;
  } SK;
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

struct WKPU_tag {
  union {                              /* NMI Status Flag Register */
    vuint32_t R;
    struct {
      vuint32_t NIF0:1;
      vuint32_t NOVF0:1;
      vuint32_t  :6;
      vuint32_t  :2;
      vuint32_t  :6;
      vuint32_t  :2;
      vuint32_t  :6;
      vuint32_t  :2;
      vuint32_t  :6;
    } B;
  } NSR;

  uint8_t WKPU_reserved0[4];
  union {                              /* NMI Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NLOCK0:1;
      vuint32_t NDSS0:2;
      vuint32_t NWRE0:1;
      vuint32_t  :1;
      vuint32_t NREE0:1;
      vuint32_t NFEE0:1;
      vuint32_t NFE0:1;
      vuint32_t  :24;
    } B;
  } NCR;
};


/* ============================================================================
   =============================== Module: XBAR ===============================
   ============================================================================ */

struct XBAR_tag {
  struct {
    union {                            /* Priority Registers Slave */
      vuint32_t R;
      struct {
        vuint32_t  :1;
        vuint32_t  :3;
        vuint32_t  :1;
        vuint32_t M6:3;                /* Master 6 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M5:3;                /* Master 5 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t  :3;
        vuint32_t  :1;
        vuint32_t  :3;
        vuint32_t  :1;
        vuint32_t  :3;
        vuint32_t  :1;
        vuint32_t M1:3;                /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M0:3;                /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
      } B;
    } PRS;
    uint8_t PORT_reserved0[12];
    union {                            /* Control Register */
      vuint32_t R;
      struct {
        vuint32_t RO:1;                /* Read Only */
        vuint32_t HLP:1;               /* Halt Low Priority */
        vuint32_t  :6;
        vuint32_t  :1;
        vuint32_t HPE6:1;
        vuint32_t HPE5:1;
        vuint32_t  :1;
        vuint32_t  :1;
        vuint32_t  :1;
        vuint32_t HPE1:1;
        vuint32_t HPE0:1;
        vuint32_t  :6;
        vuint32_t ARB:2;               /* Arbitration Mode */
        vuint32_t  :2;
        vuint32_t PCTL:2;              /* Parking Control */
        vuint32_t  :1;
        vuint32_t PARK:3;              /* Park */
      } B;
    } CRS;
    uint8_t PORT_reserved1[236];
  } PORT[8];
};


/* ============================================================================
   =============================== Module: XBIC ===============================
   ============================================================================ */

struct XBIC_tag {
  union {                              /* XBIC Module Control Register */
    vuint32_t R;
    struct {
      vuint32_t SE0:1;
      vuint32_t SE1:1;
      vuint32_t SE2:1;
      vuint32_t SE3:1;
      vuint32_t SE4:1;
      vuint32_t SE5:1;
      vuint32_t SE6:1;
      vuint32_t SE7:1;
      vuint32_t ME0:1;
      vuint32_t ME1:1;
      vuint32_t ME2:1;
      vuint32_t ME3:1;
      vuint32_t ME4:1;
      vuint32_t ME5:1;
      vuint32_t ME6:1;
      vuint32_t ME7:1;
      vuint32_t  :16;
    } B;
  } MCR;

  union {                              /* XBIC Error Injection Register */
    vuint32_t R;
    struct {
      vuint32_t EIE:1;
      vuint32_t  :16;
      vuint32_t SLV:3;
      vuint32_t MST:4;
      vuint32_t SYN:8;
    } B;
  } EIR;

  union {                              /* XBIC Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t DPSE0:1;
      vuint32_t DPSE1:1;
      vuint32_t DPSE2:1;
      vuint32_t DPSE3:1;
      vuint32_t DPSE4:1;
      vuint32_t DPSE5:1;
      vuint32_t DPSE6:1;
      vuint32_t DPSE7:1;
      vuint32_t DPME0:1;
      vuint32_t DPME1:1;
      vuint32_t DPME2:1;
      vuint32_t DPME3:1;
      vuint32_t DPME4:1;
      vuint32_t DPME5:1;
      vuint32_t DPME6:1;
      vuint32_t DPME7:1;
      vuint32_t SLV:3;
      vuint32_t MST:4;
      vuint32_t SYN:8;
    } B;
  } ESR;

  union {                              /* XBIC Error Address Register */
    vuint32_t R;
    struct {
      vuint32_t ADDR:32;
    } B;
  } EAR;
};


/* ============================================================================
   =============================== Module: XOSC ===============================
   ============================================================================ */

struct XOSC_tag {
  union {                              /* XOSC Control Register */
    vuint32_t R;
    struct {
      vuint32_t OSCBYP:1;
      vuint32_t OSCM:1;
      vuint32_t MON:1;
      vuint32_t  :5;
      vuint32_t EOCV:8;                /* End of Count Value */
      vuint32_t M_OSC:1;               /* Crystal oscillator clock interrupt mask */
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t I_OSC:1;
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } CTL;
};
#define SRAM0_START 0x40000000UL;
#define ADC_0 (*(volatile struct ADC_tag *) 0xFBE00000UL)
#define ADC_1 (*(volatile struct ADC_tag *) 0xFFE04000UL)
#define ADC_2 (*(volatile struct ADC_tag *) 0xFBE08000UL)
#define ADC_3 (*(volatile struct ADC_tag *) 0xFFE0C000UL)
#define AIPS_0 (*(volatile struct AIPS_tag *) 0xFC000000UL)
#define AIPS_1 (*(volatile struct AIPS_tag *) 0xF8000000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CAN_0 (*(volatile struct CAN_tag *) 0xFFEC0000UL)
#define CAN_1 (*(volatile struct CAN_tag *) 0xFFEC4000UL)
#define CAN_2 (*(volatile struct CAN_tag *) 0xFFEC8000UL)
#define CMU_0 (*(volatile struct CMU_tag *) 0xFBFB0200UL)
#define CMU_1 (*(volatile struct CMU_tag *) 0xFBFB0240UL)
#define CMU_2 (*(volatile struct CMU_tag *) 0xFBFB0280UL)
#define CMU_3 (*(volatile struct CMU_tag *) 0xFBFB02C0UL)
#define CMU_4 (*(volatile struct CMU_tag *) 0xFBFB0300UL)
#define CRC_0 (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define CTU_0 (*(volatile struct CTU_tag *) 0xFBC10000UL)
#define CTU_1 (*(volatile struct CTU_tag *) 0xFFC14000UL)
#define DCL (*(volatile struct DCL_tag *) 0xFFC00104UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFBF6C000UL)
#define DMA_0 (*(volatile struct DMA_tag *) 0xFC0A0000UL)
#define EIM (*(volatile struct EIM_tag *) 0xFC07C000UL)
#define ENET_0 (*(volatile struct ENET_tag *) 0xFC0B0000UL)
#define ETIMER_0 (*(volatile struct ETIMER_tag *) 0xFBC20000UL)
#define ETIMER_1 (*(volatile struct ETIMER_tag *) 0xFFC24000UL)
#define ETIMER_2 (*(volatile struct ETIMER_tag *) 0xFBC28000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FR_0 (*(volatile struct FR_tag *) 0xFFE50000UL)
#define FlexPWM_0 (*(volatile struct FlexPWM_tag *) 0xFBC00000UL)
#define FlexPWM_1 (*(volatile struct FlexPWM_tag *) 0xFFC04000UL)
#define INTC_0 (*(volatile struct INTC_tag *) 0xFC040000UL)
#define IRCOSC (*(volatile struct IRCOSC_tag *) 0xFFFB0000UL)
#define LFAST_0 (*(volatile struct LFAST_tag *) 0xFFFD8000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFBE84000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0xFFFA8000UL)
#define MEMU (*(volatile struct MEMU_tag *) 0xFFF50000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT_0 (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0100UL)
#define PMC (*(volatile struct PMC_tag *) 0xFFFA0400UL)
#define PRAMC (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define SGEN_0 (*(volatile struct SGEN_tag *) 0xFBC40000UL)
#define SIPI_0 (*(volatile struct SIPI_tag *) 0xFFFD0000UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU_0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SPI_0 (*(volatile struct SPI_tag *) 0xFFE70000UL)
#define SPI_1 (*(volatile struct SPI_tag *) 0xFFE74000UL)
#define SPI_2 (*(volatile struct SPI_tag *) 0xFBE70000UL)
#define SPI_3 (*(volatile struct SPI_tag *) 0xFBE74000UL)
#define SRX_0 (*(volatile struct SRX_tag *) 0xFFE5C000UL)
#define SRX_1 (*(volatile struct SRX_tag *) 0xFBE5C000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU (*(volatile struct STCU_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define XBAR_0 (*(volatile struct XBAR_tag *) 0xFC004000UL)
#define XBIC (*(volatile struct XBIC_tag *) 0xFC018000UL)
#define XOSC (*(volatile struct XOSC_tag *) 0xFFFB0080UL)

/* ADC */
#define ADC_0_MCR            ADC_0.MCR.R                   /* Main Configuration Register */
#define ADC_0_MSR            ADC_0.MSR.R                   /* Main Status register */
#define ADC_0_ISR            ADC_0.ISR.R                   /* Interrupt Status Register */
#define ADC_0_CEOCFR0        ADC_0.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_0_IMR            ADC_0.IMR.R                   /* Interrupt Mask Register */
#define ADC_0_CIMR0          ADC_0.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_0_WTISR          ADC_0.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_0_WTIMR          ADC_0.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_0_DMAE           ADC_0.DMAE.R                  /* DMA Enable register */
#define ADC_0_DMAR0          ADC_0.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_0_THRHLR0        ADC_0.THRHLR0.R               /* Threshold Register */
#define ADC_0_THRHLR1        ADC_0.THRHLR1.R               /* Threshold Register */
#define ADC_0_THRHLR2        ADC_0.THRHLR2.R               /* Threshold Register */
#define ADC_0_THRHLR3        ADC_0.THRHLR3.R               /* Threshold Register */
#define ADC_0_PSCR           ADC_0.PSCR.R                  /* Presampling Control Register */
#define ADC_0_PSR0           ADC_0.PSR0.R                  /* Presampling register 0 */
#define ADC_0_CTR0           ADC_0.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_0_CTR1           ADC_0.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_0_NCMR0          ADC_0.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_0_JCMR0          ADC_0.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_0_PDEDR          ADC_0.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_0_CDR0           ADC_0.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR1           ADC_0.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR2           ADC_0.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR3           ADC_0.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR4           ADC_0.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR5           ADC_0.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR6           ADC_0.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR7           ADC_0.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR8           ADC_0.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR9           ADC_0.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR10          ADC_0.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR11          ADC_0.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR12          ADC_0.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR13          ADC_0.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR14          ADC_0.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR15          ADC_0.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_THRHLR4        ADC_0.THRHLR4.R               /* Threshold Register */
#define ADC_0_THRHLR5        ADC_0.THRHLR5.R               /* Threshold Register */
#define ADC_0_THRHLR6        ADC_0.THRHLR6.R               /* Threshold Register */
#define ADC_0_THRHLR7        ADC_0.THRHLR7.R               /* Threshold Register */
#define ADC_0_THRHLR8        ADC_0.THRHLR8.R               /* Threshold Register */
#define ADC_0_THRHLR9        ADC_0.THRHLR9.R               /* Threshold Register */
#define ADC_0_THRHLR10       ADC_0.THRHLR10.R              /* Threshold Register */
#define ADC_0_THRHLR11       ADC_0.THRHLR11.R              /* Threshold Register */
#define ADC_0_THRHLR12       ADC_0.THRHLR12.R              /* Threshold Register */
#define ADC_0_THRHLR13       ADC_0.THRHLR13.R              /* Threshold Register */
#define ADC_0_THRHLR14       ADC_0.THRHLR14.R              /* Threshold Register */
#define ADC_0_THRHLR15       ADC_0.THRHLR15.R              /* Threshold Register */
#define ADC_0_CWSELR0        ADC_0.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_0_CWSELR1        ADC_0.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_0_CWENR0         ADC_0.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_0_AWORR0         ADC_0.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_0_STCR1          ADC_0.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_0_STCR2          ADC_0.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_0_STCR3          ADC_0.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_0_STBRR          ADC_0.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_0_STSR1          ADC_0.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_0_STSR2          ADC_0.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_0_STSR3          ADC_0.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_0_STSR4          ADC_0.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_0_STDR1          ADC_0.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_0_STDR2          ADC_0.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_0_STAW0R         ADC_0.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_0_STAW1AR        ADC_0.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_0_STAW1BR        ADC_0.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_0_STAW2R         ADC_0.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_0_STAW4R         ADC_0.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_0_STAW5R         ADC_0.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_0_CALBISTREG     ADC_0.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_0_OFSGNUSR       ADC_0.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_0_ALTR           ADC_0.ALTR.R                  /* Alternate Result register */

/* ADC */
#define ADC_1_MCR            ADC_1.MCR.R                   /* Main Configuration Register */
#define ADC_1_MSR            ADC_1.MSR.R                   /* Main Status register */
#define ADC_1_ISR            ADC_1.ISR.R                   /* Interrupt Status Register */
#define ADC_1_CEOCFR0        ADC_1.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_1_IMR            ADC_1.IMR.R                   /* Interrupt Mask Register */
#define ADC_1_CIMR0          ADC_1.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_1_WTISR          ADC_1.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_1_WTIMR          ADC_1.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_1_DMAE           ADC_1.DMAE.R                  /* DMA Enable register */
#define ADC_1_DMAR0          ADC_1.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_1_THRHLR0        ADC_1.THRHLR0.R               /* Threshold Register */
#define ADC_1_THRHLR1        ADC_1.THRHLR1.R               /* Threshold Register */
#define ADC_1_THRHLR2        ADC_1.THRHLR2.R               /* Threshold Register */
#define ADC_1_THRHLR3        ADC_1.THRHLR3.R               /* Threshold Register */
#define ADC_1_PSCR           ADC_1.PSCR.R                  /* Presampling Control Register */
#define ADC_1_PSR0           ADC_1.PSR0.R                  /* Presampling register 0 */
#define ADC_1_CTR0           ADC_1.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_1_CTR1           ADC_1.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_1_NCMR0          ADC_1.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_1_JCMR0          ADC_1.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_1_PDEDR          ADC_1.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_1_CDR0           ADC_1.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR1           ADC_1.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR2           ADC_1.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR3           ADC_1.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR4           ADC_1.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR5           ADC_1.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR6           ADC_1.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR7           ADC_1.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR8           ADC_1.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR9           ADC_1.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR10          ADC_1.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR11          ADC_1.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR12          ADC_1.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR13          ADC_1.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR14          ADC_1.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR15          ADC_1.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_THRHLR4        ADC_1.THRHLR4.R               /* Threshold Register */
#define ADC_1_THRHLR5        ADC_1.THRHLR5.R               /* Threshold Register */
#define ADC_1_THRHLR6        ADC_1.THRHLR6.R               /* Threshold Register */
#define ADC_1_THRHLR7        ADC_1.THRHLR7.R               /* Threshold Register */
#define ADC_1_THRHLR8        ADC_1.THRHLR8.R               /* Threshold Register */
#define ADC_1_THRHLR9        ADC_1.THRHLR9.R               /* Threshold Register */
#define ADC_1_THRHLR10       ADC_1.THRHLR10.R              /* Threshold Register */
#define ADC_1_THRHLR11       ADC_1.THRHLR11.R              /* Threshold Register */
#define ADC_1_THRHLR12       ADC_1.THRHLR12.R              /* Threshold Register */
#define ADC_1_THRHLR13       ADC_1.THRHLR13.R              /* Threshold Register */
#define ADC_1_THRHLR14       ADC_1.THRHLR14.R              /* Threshold Register */
#define ADC_1_THRHLR15       ADC_1.THRHLR15.R              /* Threshold Register */
#define ADC_1_CWSELR0        ADC_1.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_1_CWSELR1        ADC_1.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_1_CWENR0         ADC_1.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_1_AWORR0         ADC_1.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_1_STCR1          ADC_1.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_1_STCR2          ADC_1.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_1_STCR3          ADC_1.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_1_STBRR          ADC_1.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_1_STSR1          ADC_1.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_1_STSR2          ADC_1.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_1_STSR3          ADC_1.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_1_STSR4          ADC_1.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_1_STDR1          ADC_1.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_1_STDR2          ADC_1.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_1_STAW0R         ADC_1.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_1_STAW1AR        ADC_1.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_1_STAW1BR        ADC_1.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_1_STAW2R         ADC_1.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_1_STAW4R         ADC_1.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_1_STAW5R         ADC_1.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_1_CALBISTREG     ADC_1.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_1_OFSGNUSR       ADC_1.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_1_ALTR           ADC_1.ALTR.R                  /* Alternate Result register */

/* ADC */
#define ADC_2_MCR            ADC_2.MCR.R                   /* Main Configuration Register */
#define ADC_2_MSR            ADC_2.MSR.R                   /* Main Status register */
#define ADC_2_ISR            ADC_2.ISR.R                   /* Interrupt Status Register */
#define ADC_2_CEOCFR0        ADC_2.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_2_IMR            ADC_2.IMR.R                   /* Interrupt Mask Register */
#define ADC_2_CIMR0          ADC_2.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_2_WTISR          ADC_2.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_2_WTIMR          ADC_2.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_2_DMAE           ADC_2.DMAE.R                  /* DMA Enable register */
#define ADC_2_DMAR0          ADC_2.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_2_THRHLR0        ADC_2.THRHLR0.R               /* Threshold Register */
#define ADC_2_THRHLR1        ADC_2.THRHLR1.R               /* Threshold Register */
#define ADC_2_THRHLR2        ADC_2.THRHLR2.R               /* Threshold Register */
#define ADC_2_THRHLR3        ADC_2.THRHLR3.R               /* Threshold Register */
#define ADC_2_PSCR           ADC_2.PSCR.R                  /* Presampling Control Register */
#define ADC_2_PSR0           ADC_2.PSR0.R                  /* Presampling register 0 */
#define ADC_2_CTR0           ADC_2.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_2_CTR1           ADC_2.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_2_NCMR0          ADC_2.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_2_JCMR0          ADC_2.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_2_PDEDR          ADC_2.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_2_CDR0           ADC_2.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR1           ADC_2.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR2           ADC_2.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR3           ADC_2.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR4           ADC_2.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR5           ADC_2.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR6           ADC_2.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR7           ADC_2.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR8           ADC_2.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR9           ADC_2.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR10          ADC_2.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR11          ADC_2.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR12          ADC_2.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR13          ADC_2.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR14          ADC_2.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR15          ADC_2.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_THRHLR4        ADC_2.THRHLR4.R               /* Threshold Register */
#define ADC_2_THRHLR5        ADC_2.THRHLR5.R               /* Threshold Register */
#define ADC_2_THRHLR6        ADC_2.THRHLR6.R               /* Threshold Register */
#define ADC_2_THRHLR7        ADC_2.THRHLR7.R               /* Threshold Register */
#define ADC_2_THRHLR8        ADC_2.THRHLR8.R               /* Threshold Register */
#define ADC_2_THRHLR9        ADC_2.THRHLR9.R               /* Threshold Register */
#define ADC_2_THRHLR10       ADC_2.THRHLR10.R              /* Threshold Register */
#define ADC_2_THRHLR11       ADC_2.THRHLR11.R              /* Threshold Register */
#define ADC_2_THRHLR12       ADC_2.THRHLR12.R              /* Threshold Register */
#define ADC_2_THRHLR13       ADC_2.THRHLR13.R              /* Threshold Register */
#define ADC_2_THRHLR14       ADC_2.THRHLR14.R              /* Threshold Register */
#define ADC_2_THRHLR15       ADC_2.THRHLR15.R              /* Threshold Register */
#define ADC_2_CWSELR0        ADC_2.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_2_CWSELR1        ADC_2.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_2_CWENR0         ADC_2.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_2_AWORR0         ADC_2.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_2_STCR1          ADC_2.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_2_STCR2          ADC_2.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_2_STCR3          ADC_2.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_2_STBRR          ADC_2.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_2_STSR1          ADC_2.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_2_STSR2          ADC_2.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_2_STSR3          ADC_2.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_2_STSR4          ADC_2.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_2_STDR1          ADC_2.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_2_STDR2          ADC_2.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_2_STAW0R         ADC_2.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_2_STAW1AR        ADC_2.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_2_STAW1BR        ADC_2.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_2_STAW2R         ADC_2.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_2_STAW4R         ADC_2.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_2_STAW5R         ADC_2.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_2_CALBISTREG     ADC_2.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_2_OFSGNUSR       ADC_2.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_2_ALTR           ADC_2.ALTR.R                  /* Alternate Result register */

/* ADC */
#define ADC_3_MCR            ADC_3.MCR.R                   /* Main Configuration Register */
#define ADC_3_MSR            ADC_3.MSR.R                   /* Main Status register */
#define ADC_3_ISR            ADC_3.ISR.R                   /* Interrupt Status Register */
#define ADC_3_CEOCFR0        ADC_3.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_3_IMR            ADC_3.IMR.R                   /* Interrupt Mask Register */
#define ADC_3_CIMR0          ADC_3.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_3_WTISR          ADC_3.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_3_WTIMR          ADC_3.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_3_DMAE           ADC_3.DMAE.R                  /* DMA Enable register */
#define ADC_3_DMAR0          ADC_3.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_3_THRHLR0        ADC_3.THRHLR0.R               /* Threshold Register */
#define ADC_3_THRHLR1        ADC_3.THRHLR1.R               /* Threshold Register */
#define ADC_3_THRHLR2        ADC_3.THRHLR2.R               /* Threshold Register */
#define ADC_3_THRHLR3        ADC_3.THRHLR3.R               /* Threshold Register */
#define ADC_3_PSCR           ADC_3.PSCR.R                  /* Presampling Control Register */
#define ADC_3_PSR0           ADC_3.PSR0.R                  /* Presampling register 0 */
#define ADC_3_CTR0           ADC_3.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_3_CTR1           ADC_3.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_3_NCMR0          ADC_3.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_3_JCMR0          ADC_3.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_3_PDEDR          ADC_3.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_3_CDR0           ADC_3.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR1           ADC_3.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR2           ADC_3.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR3           ADC_3.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR4           ADC_3.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR5           ADC_3.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR6           ADC_3.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR7           ADC_3.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR8           ADC_3.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR9           ADC_3.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR10          ADC_3.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR11          ADC_3.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR12          ADC_3.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR13          ADC_3.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR14          ADC_3.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR15          ADC_3.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_THRHLR4        ADC_3.THRHLR4.R               /* Threshold Register */
#define ADC_3_THRHLR5        ADC_3.THRHLR5.R               /* Threshold Register */
#define ADC_3_THRHLR6        ADC_3.THRHLR6.R               /* Threshold Register */
#define ADC_3_THRHLR7        ADC_3.THRHLR7.R               /* Threshold Register */
#define ADC_3_THRHLR8        ADC_3.THRHLR8.R               /* Threshold Register */
#define ADC_3_THRHLR9        ADC_3.THRHLR9.R               /* Threshold Register */
#define ADC_3_THRHLR10       ADC_3.THRHLR10.R              /* Threshold Register */
#define ADC_3_THRHLR11       ADC_3.THRHLR11.R              /* Threshold Register */
#define ADC_3_THRHLR12       ADC_3.THRHLR12.R              /* Threshold Register */
#define ADC_3_THRHLR13       ADC_3.THRHLR13.R              /* Threshold Register */
#define ADC_3_THRHLR14       ADC_3.THRHLR14.R              /* Threshold Register */
#define ADC_3_THRHLR15       ADC_3.THRHLR15.R              /* Threshold Register */
#define ADC_3_CWSELR0        ADC_3.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_3_CWSELR1        ADC_3.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_3_CWENR0         ADC_3.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_3_AWORR0         ADC_3.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_3_STCR1          ADC_3.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_3_STCR2          ADC_3.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_3_STCR3          ADC_3.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_3_STBRR          ADC_3.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_3_STSR1          ADC_3.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_3_STSR2          ADC_3.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_3_STSR3          ADC_3.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_3_STSR4          ADC_3.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_3_STDR1          ADC_3.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_3_STDR2          ADC_3.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_3_STAW0R         ADC_3.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_3_STAW1AR        ADC_3.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_3_STAW1BR        ADC_3.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_3_STAW2R         ADC_3.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_3_STAW4R         ADC_3.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_3_STAW5R         ADC_3.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_3_CALBISTREG     ADC_3.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_3_OFSGNUSR       ADC_3.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_3_ALTR           ADC_3.ALTR.R                  /* Alternate Result register */

/* AIPS */
#define AIPS_0_MPRA          AIPS_0.MPRA.R                 /* Master Privilege Register A */
#define AIPS_0_PACRA         AIPS_0.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRB         AIPS_0.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRC         AIPS_0.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRD         AIPS_0.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_0_PACR_Reserved AIPS_0.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRF         AIPS_0.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRG         AIPS_0.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_0_PACRH         AIPS_0.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_0_OPACRA        AIPS_0.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRB        AIPS_0.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRC        AIPS_0.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRD        AIPS_0.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRE        AIPS_0.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRF        AIPS_0.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRG        AIPS_0.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRH        AIPS_0.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRI        AIPS_0.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRJ        AIPS_0.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRK        AIPS_0.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRL        AIPS_0.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRM        AIPS_0.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRN        AIPS_0.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRO        AIPS_0.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRP        AIPS_0.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRQ        AIPS_0.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRR        AIPS_0.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRS        AIPS_0.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRT        AIPS_0.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRU        AIPS_0.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRV        AIPS_0.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRW        AIPS_0.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRX        AIPS_0.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRY        AIPS_0.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRZ        AIPS_0.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAA       AIPS_0.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAB       AIPS_0.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAC       AIPS_0.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAD       AIPS_0.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAE       AIPS_0.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAF       AIPS_0.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* AIPS */
#define AIPS_1_MPRA          AIPS_1.MPRA.R                 /* Master Privilege Register A */
#define AIPS_1_PACRA         AIPS_1.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRB         AIPS_1.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRC         AIPS_1.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRD         AIPS_1.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_1_PACR_Reserved AIPS_1.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRF         AIPS_1.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRG         AIPS_1.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_1_PACRH         AIPS_1.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_1_OPACRA        AIPS_1.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRB        AIPS_1.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRC        AIPS_1.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRD        AIPS_1.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRE        AIPS_1.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRF        AIPS_1.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRG        AIPS_1.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRH        AIPS_1.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRI        AIPS_1.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRJ        AIPS_1.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRK        AIPS_1.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRL        AIPS_1.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRM        AIPS_1.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRN        AIPS_1.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRO        AIPS_1.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRP        AIPS_1.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRQ        AIPS_1.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRR        AIPS_1.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRS        AIPS_1.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRT        AIPS_1.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRU        AIPS_1.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRV        AIPS_1.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRW        AIPS_1.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRX        AIPS_1.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRY        AIPS_1.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRZ        AIPS_1.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAA       AIPS_1.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAB       AIPS_1.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAC       AIPS_1.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAD       AIPS_1.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAE       AIPS_1.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAF       AIPS_1.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */

/* CAN */
#define CAN_0_MCR            CAN_0.MCR.R                   /* Module Configuration Register */
#define CAN_0_CTRL1          CAN_0.CTRL1.R                 /* Control 1 register */
#define CAN_0_TIMER          CAN_0.TIMER.R                 /* Free Running Timer */
#define CAN_0_RXMGMASK       CAN_0.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_0_RX14MASK       CAN_0.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_0_RX15MASK       CAN_0.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_0_ECR            CAN_0.ECR.R                   /* Error Counter */
#define CAN_0_ESR1           CAN_0.ESR1.R                  /* Error and Status 1 register */
#define CAN_0_IMASK2         CAN_0.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_0_IMASK1         CAN_0.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_0_IFLAG2         CAN_0.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_0_IFLAG1         CAN_0.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_0_CTRL2          CAN_0.CTRL2.R                 /* Control 2 register */
#define CAN_0_ESR2           CAN_0.ESR2.R                  /* Error and Status 2 register */
#define CAN_0_CRCR           CAN_0.CRCR.R                  /* CRC Register */
#define CAN_0_RXFGMASK       CAN_0.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_0_RXFIR          CAN_0.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_0_CS0            CAN_0.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_0_ID0            CAN_0.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_0_B0             CAN_0.MB[0].DATA.B.R          /* Message Buffer 0 B Register */
#define CAN_0_H0             CAN_0.MB[0].DATA.H.R          /* Message Buffer 0 H Register */
#define CAN_0_W0             CAN_0.MB[0].DATA.W.R          /* Message Buffer 0 W Register */
#define CAN_0_CS1            CAN_0.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_0_ID1            CAN_0.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_0_B1             CAN_0.MB[1].DATA.B.R          /* Message Buffer 1 B Register */
#define CAN_0_H1             CAN_0.MB[1].DATA.H.R          /* Message Buffer 1 H Register */
#define CAN_0_W1             CAN_0.MB[1].DATA.W.R          /* Message Buffer 1 W Register */
#define CAN_0_CS2            CAN_0.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_0_ID2            CAN_0.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_0_B2             CAN_0.MB[2].DATA.B.R          /* Message Buffer 2 B Register */
#define CAN_0_H2             CAN_0.MB[2].DATA.H.R          /* Message Buffer 2 H Register */
#define CAN_0_W2             CAN_0.MB[2].DATA.W.R          /* Message Buffer 2 W Register */
#define CAN_0_CS3            CAN_0.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_0_ID3            CAN_0.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_0_B3             CAN_0.MB[3].DATA.B.R          /* Message Buffer 3 B Register */
#define CAN_0_H3             CAN_0.MB[3].DATA.H.R          /* Message Buffer 3 H Register */
#define CAN_0_W3             CAN_0.MB[3].DATA.W.R          /* Message Buffer 3 W Register */
#define CAN_0_CS4            CAN_0.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_0_ID4            CAN_0.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_0_B4             CAN_0.MB[4].DATA.B.R          /* Message Buffer 4 B Register */
#define CAN_0_H4             CAN_0.MB[4].DATA.H.R          /* Message Buffer 4 H Register */
#define CAN_0_W4             CAN_0.MB[4].DATA.W.R          /* Message Buffer 4 W Register */
#define CAN_0_CS5            CAN_0.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_0_ID5            CAN_0.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_0_B5             CAN_0.MB[5].DATA.B.R          /* Message Buffer 5 B Register */
#define CAN_0_H5             CAN_0.MB[5].DATA.H.R          /* Message Buffer 5 H Register */
#define CAN_0_W5             CAN_0.MB[5].DATA.W.R          /* Message Buffer 5 W Register */
#define CAN_0_CS6            CAN_0.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_0_ID6            CAN_0.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_0_B6             CAN_0.MB[6].DATA.B.R          /* Message Buffer 6 B Register */
#define CAN_0_H6             CAN_0.MB[6].DATA.H.R          /* Message Buffer 6 H Register */
#define CAN_0_W6             CAN_0.MB[6].DATA.W.R          /* Message Buffer 6 W Register */
#define CAN_0_CS7            CAN_0.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_0_ID7            CAN_0.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_0_B7             CAN_0.MB[7].DATA.B.R          /* Message Buffer 7 B Register */
#define CAN_0_H7             CAN_0.MB[7].DATA.H.R          /* Message Buffer 7 H Register */
#define CAN_0_W7             CAN_0.MB[7].DATA.W.R          /* Message Buffer 7 W Register */
#define CAN_0_CS8            CAN_0.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_0_ID8            CAN_0.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_0_B8             CAN_0.MB[8].DATA.B.R          /* Message Buffer 8 B Register */
#define CAN_0_H8             CAN_0.MB[8].DATA.H.R          /* Message Buffer 8 H Register */
#define CAN_0_W8             CAN_0.MB[8].DATA.W.R          /* Message Buffer 8 W Register */
#define CAN_0_CS9            CAN_0.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_0_ID9            CAN_0.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_0_B9             CAN_0.MB[9].DATA.B.R          /* Message Buffer 9 B Register */
#define CAN_0_H9             CAN_0.MB[9].DATA.H.R          /* Message Buffer 9 H Register */
#define CAN_0_W9             CAN_0.MB[9].DATA.W.R          /* Message Buffer 9 W Register */
#define CAN_0_CS10           CAN_0.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_0_ID10           CAN_0.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_0_B10            CAN_0.MB[10].DATA.B.R         /* Message Buffer 10 B Register */
#define CAN_0_H10            CAN_0.MB[10].DATA.H.R         /* Message Buffer 10 H Register */
#define CAN_0_W10            CAN_0.MB[10].DATA.W.R         /* Message Buffer 10 W Register */
#define CAN_0_CS11           CAN_0.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_0_ID11           CAN_0.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_0_B11            CAN_0.MB[11].DATA.B.R         /* Message Buffer 11 B Register */
#define CAN_0_H11            CAN_0.MB[11].DATA.H.R         /* Message Buffer 11 H Register */
#define CAN_0_W11            CAN_0.MB[11].DATA.W.R         /* Message Buffer 11 W Register */
#define CAN_0_CS12           CAN_0.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_0_ID12           CAN_0.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_0_B12            CAN_0.MB[12].DATA.B.R         /* Message Buffer 12 B Register */
#define CAN_0_H12            CAN_0.MB[12].DATA.H.R         /* Message Buffer 12 H Register */
#define CAN_0_W12            CAN_0.MB[12].DATA.W.R         /* Message Buffer 12 W Register */
#define CAN_0_CS13           CAN_0.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_0_ID13           CAN_0.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_0_B13            CAN_0.MB[13].DATA.B.R         /* Message Buffer 13 B Register */
#define CAN_0_H13            CAN_0.MB[13].DATA.H.R         /* Message Buffer 13 H Register */
#define CAN_0_W13            CAN_0.MB[13].DATA.W.R         /* Message Buffer 13 W Register */
#define CAN_0_CS14           CAN_0.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_0_ID14           CAN_0.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_0_B14            CAN_0.MB[14].DATA.B.R         /* Message Buffer 14 B Register */
#define CAN_0_H14            CAN_0.MB[14].DATA.H.R         /* Message Buffer 14 H Register */
#define CAN_0_W14            CAN_0.MB[14].DATA.W.R         /* Message Buffer 14 W Register */
#define CAN_0_CS15           CAN_0.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_0_ID15           CAN_0.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_0_B15            CAN_0.MB[15].DATA.B.R         /* Message Buffer 15 B Register */
#define CAN_0_H15            CAN_0.MB[15].DATA.H.R         /* Message Buffer 15 H Register */
#define CAN_0_W15            CAN_0.MB[15].DATA.W.R         /* Message Buffer 15 W Register */
#define CAN_0_CS16           CAN_0.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_0_ID16           CAN_0.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_0_B16            CAN_0.MB[16].DATA.B.R         /* Message Buffer 16 B Register */
#define CAN_0_H16            CAN_0.MB[16].DATA.H.R         /* Message Buffer 16 H Register */
#define CAN_0_W16            CAN_0.MB[16].DATA.W.R         /* Message Buffer 16 W Register */
#define CAN_0_CS17           CAN_0.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_0_ID17           CAN_0.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_0_B17            CAN_0.MB[17].DATA.B.R         /* Message Buffer 17 B Register */
#define CAN_0_H17            CAN_0.MB[17].DATA.H.R         /* Message Buffer 17 H Register */
#define CAN_0_W17            CAN_0.MB[17].DATA.W.R         /* Message Buffer 17 W Register */
#define CAN_0_CS18           CAN_0.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_0_ID18           CAN_0.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_0_B18            CAN_0.MB[18].DATA.B.R         /* Message Buffer 18 B Register */
#define CAN_0_H18            CAN_0.MB[18].DATA.H.R         /* Message Buffer 18 H Register */
#define CAN_0_W18            CAN_0.MB[18].DATA.W.R         /* Message Buffer 18 W Register */
#define CAN_0_CS19           CAN_0.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_0_ID19           CAN_0.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_0_B19            CAN_0.MB[19].DATA.B.R         /* Message Buffer 19 B Register */
#define CAN_0_H19            CAN_0.MB[19].DATA.H.R         /* Message Buffer 19 H Register */
#define CAN_0_W19            CAN_0.MB[19].DATA.W.R         /* Message Buffer 19 W Register */
#define CAN_0_CS20           CAN_0.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_0_ID20           CAN_0.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_0_B20            CAN_0.MB[20].DATA.B.R         /* Message Buffer 20 B Register */
#define CAN_0_H20            CAN_0.MB[20].DATA.H.R         /* Message Buffer 20 H Register */
#define CAN_0_W20            CAN_0.MB[20].DATA.W.R         /* Message Buffer 20 W Register */
#define CAN_0_CS21           CAN_0.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_0_ID21           CAN_0.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_0_B21            CAN_0.MB[21].DATA.B.R         /* Message Buffer 21 B Register */
#define CAN_0_H21            CAN_0.MB[21].DATA.H.R         /* Message Buffer 21 H Register */
#define CAN_0_W21            CAN_0.MB[21].DATA.W.R         /* Message Buffer 21 W Register */
#define CAN_0_CS22           CAN_0.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_0_ID22           CAN_0.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_0_B22            CAN_0.MB[22].DATA.B.R         /* Message Buffer 22 B Register */
#define CAN_0_H22            CAN_0.MB[22].DATA.H.R         /* Message Buffer 22 H Register */
#define CAN_0_W22            CAN_0.MB[22].DATA.W.R         /* Message Buffer 22 W Register */
#define CAN_0_CS23           CAN_0.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_0_ID23           CAN_0.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_0_B23            CAN_0.MB[23].DATA.B.R         /* Message Buffer 23 B Register */
#define CAN_0_H23            CAN_0.MB[23].DATA.H.R         /* Message Buffer 23 H Register */
#define CAN_0_W23            CAN_0.MB[23].DATA.W.R         /* Message Buffer 23 W Register */
#define CAN_0_CS24           CAN_0.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_0_ID24           CAN_0.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_0_B24            CAN_0.MB[24].DATA.B.R         /* Message Buffer 24 B Register */
#define CAN_0_H24            CAN_0.MB[24].DATA.H.R         /* Message Buffer 24 H Register */
#define CAN_0_W24            CAN_0.MB[24].DATA.W.R         /* Message Buffer 24 W Register */
#define CAN_0_CS25           CAN_0.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_0_ID25           CAN_0.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_0_B25            CAN_0.MB[25].DATA.B.R         /* Message Buffer 25 B Register */
#define CAN_0_H25            CAN_0.MB[25].DATA.H.R         /* Message Buffer 25 H Register */
#define CAN_0_W25            CAN_0.MB[25].DATA.W.R         /* Message Buffer 25 W Register */
#define CAN_0_CS26           CAN_0.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_0_ID26           CAN_0.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_0_B26            CAN_0.MB[26].DATA.B.R         /* Message Buffer 26 B Register */
#define CAN_0_H26            CAN_0.MB[26].DATA.H.R         /* Message Buffer 26 H Register */
#define CAN_0_W26            CAN_0.MB[26].DATA.W.R         /* Message Buffer 26 W Register */
#define CAN_0_CS27           CAN_0.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_0_ID27           CAN_0.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_0_B27            CAN_0.MB[27].DATA.B.R         /* Message Buffer 27 B Register */
#define CAN_0_H27            CAN_0.MB[27].DATA.H.R         /* Message Buffer 27 H Register */
#define CAN_0_W27            CAN_0.MB[27].DATA.W.R         /* Message Buffer 27 W Register */
#define CAN_0_CS28           CAN_0.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_0_ID28           CAN_0.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_0_B28            CAN_0.MB[28].DATA.B.R         /* Message Buffer 28 B Register */
#define CAN_0_H28            CAN_0.MB[28].DATA.H.R         /* Message Buffer 28 H Register */
#define CAN_0_W28            CAN_0.MB[28].DATA.W.R         /* Message Buffer 28 W Register */
#define CAN_0_CS29           CAN_0.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_0_ID29           CAN_0.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_0_B29            CAN_0.MB[29].DATA.B.R         /* Message Buffer 29 B Register */
#define CAN_0_H29            CAN_0.MB[29].DATA.H.R         /* Message Buffer 29 H Register */
#define CAN_0_W29            CAN_0.MB[29].DATA.W.R         /* Message Buffer 29 W Register */
#define CAN_0_CS30           CAN_0.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_0_ID30           CAN_0.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_0_B30            CAN_0.MB[30].DATA.B.R         /* Message Buffer 30 B Register */
#define CAN_0_H30            CAN_0.MB[30].DATA.H.R         /* Message Buffer 30 H Register */
#define CAN_0_W30            CAN_0.MB[30].DATA.W.R         /* Message Buffer 30 W Register */
#define CAN_0_CS31           CAN_0.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_0_ID31           CAN_0.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_0_B31            CAN_0.MB[31].DATA.B.R         /* Message Buffer 31 B Register */
#define CAN_0_H31            CAN_0.MB[31].DATA.H.R         /* Message Buffer 31 H Register */
#define CAN_0_W31            CAN_0.MB[31].DATA.W.R         /* Message Buffer 31 W Register */
#define CAN_0_CS32           CAN_0.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_0_ID32           CAN_0.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_0_B32            CAN_0.MB[32].DATA.B.R         /* Message Buffer 32 B Register */
#define CAN_0_H32            CAN_0.MB[32].DATA.H.R         /* Message Buffer 32 H Register */
#define CAN_0_W32            CAN_0.MB[32].DATA.W.R         /* Message Buffer 32 W Register */
#define CAN_0_CS33           CAN_0.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_0_ID33           CAN_0.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_0_B33            CAN_0.MB[33].DATA.B.R         /* Message Buffer 33 B Register */
#define CAN_0_H33            CAN_0.MB[33].DATA.H.R         /* Message Buffer 33 H Register */
#define CAN_0_W33            CAN_0.MB[33].DATA.W.R         /* Message Buffer 33 W Register */
#define CAN_0_CS34           CAN_0.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_0_ID34           CAN_0.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_0_B34            CAN_0.MB[34].DATA.B.R         /* Message Buffer 34 B Register */
#define CAN_0_H34            CAN_0.MB[34].DATA.H.R         /* Message Buffer 34 H Register */
#define CAN_0_W34            CAN_0.MB[34].DATA.W.R         /* Message Buffer 34 W Register */
#define CAN_0_CS35           CAN_0.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_0_ID35           CAN_0.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_0_B35            CAN_0.MB[35].DATA.B.R         /* Message Buffer 35 B Register */
#define CAN_0_H35            CAN_0.MB[35].DATA.H.R         /* Message Buffer 35 H Register */
#define CAN_0_W35            CAN_0.MB[35].DATA.W.R         /* Message Buffer 35 W Register */
#define CAN_0_CS36           CAN_0.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_0_ID36           CAN_0.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_0_B36            CAN_0.MB[36].DATA.B.R         /* Message Buffer 36 B Register */
#define CAN_0_H36            CAN_0.MB[36].DATA.H.R         /* Message Buffer 36 H Register */
#define CAN_0_W36            CAN_0.MB[36].DATA.W.R         /* Message Buffer 36 W Register */
#define CAN_0_CS37           CAN_0.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_0_ID37           CAN_0.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_0_B37            CAN_0.MB[37].DATA.B.R         /* Message Buffer 37 B Register */
#define CAN_0_H37            CAN_0.MB[37].DATA.H.R         /* Message Buffer 37 H Register */
#define CAN_0_W37            CAN_0.MB[37].DATA.W.R         /* Message Buffer 37 W Register */
#define CAN_0_CS38           CAN_0.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_0_ID38           CAN_0.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_0_B38            CAN_0.MB[38].DATA.B.R         /* Message Buffer 38 B Register */
#define CAN_0_H38            CAN_0.MB[38].DATA.H.R         /* Message Buffer 38 H Register */
#define CAN_0_W38            CAN_0.MB[38].DATA.W.R         /* Message Buffer 38 W Register */
#define CAN_0_CS39           CAN_0.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_0_ID39           CAN_0.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_0_B39            CAN_0.MB[39].DATA.B.R         /* Message Buffer 39 B Register */
#define CAN_0_H39            CAN_0.MB[39].DATA.H.R         /* Message Buffer 39 H Register */
#define CAN_0_W39            CAN_0.MB[39].DATA.W.R         /* Message Buffer 39 W Register */
#define CAN_0_CS40           CAN_0.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_0_ID40           CAN_0.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_0_B40            CAN_0.MB[40].DATA.B.R         /* Message Buffer 40 B Register */
#define CAN_0_H40            CAN_0.MB[40].DATA.H.R         /* Message Buffer 40 H Register */
#define CAN_0_W40            CAN_0.MB[40].DATA.W.R         /* Message Buffer 40 W Register */
#define CAN_0_CS41           CAN_0.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_0_ID41           CAN_0.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_0_B41            CAN_0.MB[41].DATA.B.R         /* Message Buffer 41 B Register */
#define CAN_0_H41            CAN_0.MB[41].DATA.H.R         /* Message Buffer 41 H Register */
#define CAN_0_W41            CAN_0.MB[41].DATA.W.R         /* Message Buffer 41 W Register */
#define CAN_0_CS42           CAN_0.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_0_ID42           CAN_0.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_0_B42            CAN_0.MB[42].DATA.B.R         /* Message Buffer 42 B Register */
#define CAN_0_H42            CAN_0.MB[42].DATA.H.R         /* Message Buffer 42 H Register */
#define CAN_0_W42            CAN_0.MB[42].DATA.W.R         /* Message Buffer 42 W Register */
#define CAN_0_CS43           CAN_0.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_0_ID43           CAN_0.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_0_B43            CAN_0.MB[43].DATA.B.R         /* Message Buffer 43 B Register */
#define CAN_0_H43            CAN_0.MB[43].DATA.H.R         /* Message Buffer 43 H Register */
#define CAN_0_W43            CAN_0.MB[43].DATA.W.R         /* Message Buffer 43 W Register */
#define CAN_0_CS44           CAN_0.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_0_ID44           CAN_0.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_0_B44            CAN_0.MB[44].DATA.B.R         /* Message Buffer 44 B Register */
#define CAN_0_H44            CAN_0.MB[44].DATA.H.R         /* Message Buffer 44 H Register */
#define CAN_0_W44            CAN_0.MB[44].DATA.W.R         /* Message Buffer 44 W Register */
#define CAN_0_CS45           CAN_0.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_0_ID45           CAN_0.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_0_B45            CAN_0.MB[45].DATA.B.R         /* Message Buffer 45 B Register */
#define CAN_0_H45            CAN_0.MB[45].DATA.H.R         /* Message Buffer 45 H Register */
#define CAN_0_W45            CAN_0.MB[45].DATA.W.R         /* Message Buffer 45 W Register */
#define CAN_0_CS46           CAN_0.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_0_ID46           CAN_0.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_0_B46            CAN_0.MB[46].DATA.B.R         /* Message Buffer 46 B Register */
#define CAN_0_H46            CAN_0.MB[46].DATA.H.R         /* Message Buffer 46 H Register */
#define CAN_0_W46            CAN_0.MB[46].DATA.W.R         /* Message Buffer 46 W Register */
#define CAN_0_CS47           CAN_0.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_0_ID47           CAN_0.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_0_B47            CAN_0.MB[47].DATA.B.R         /* Message Buffer 47 B Register */
#define CAN_0_H47            CAN_0.MB[47].DATA.H.R         /* Message Buffer 47 H Register */
#define CAN_0_W47            CAN_0.MB[47].DATA.W.R         /* Message Buffer 47 W Register */
#define CAN_0_CS48           CAN_0.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_0_ID48           CAN_0.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_0_B48            CAN_0.MB[48].DATA.B.R         /* Message Buffer 48 B Register */
#define CAN_0_H48            CAN_0.MB[48].DATA.H.R         /* Message Buffer 48 H Register */
#define CAN_0_W48            CAN_0.MB[48].DATA.W.R         /* Message Buffer 48 W Register */
#define CAN_0_CS49           CAN_0.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_0_ID49           CAN_0.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_0_B49            CAN_0.MB[49].DATA.B.R         /* Message Buffer 49 B Register */
#define CAN_0_H49            CAN_0.MB[49].DATA.H.R         /* Message Buffer 49 H Register */
#define CAN_0_W49            CAN_0.MB[49].DATA.W.R         /* Message Buffer 49 W Register */
#define CAN_0_CS50           CAN_0.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_0_ID50           CAN_0.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_0_B50            CAN_0.MB[50].DATA.B.R         /* Message Buffer 50 B Register */
#define CAN_0_H50            CAN_0.MB[50].DATA.H.R         /* Message Buffer 50 H Register */
#define CAN_0_W50            CAN_0.MB[50].DATA.W.R         /* Message Buffer 50 W Register */
#define CAN_0_CS51           CAN_0.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_0_ID51           CAN_0.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_0_B51            CAN_0.MB[51].DATA.B.R         /* Message Buffer 51 B Register */
#define CAN_0_H51            CAN_0.MB[51].DATA.H.R         /* Message Buffer 51 H Register */
#define CAN_0_W51            CAN_0.MB[51].DATA.W.R         /* Message Buffer 51 W Register */
#define CAN_0_CS52           CAN_0.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_0_ID52           CAN_0.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_0_B52            CAN_0.MB[52].DATA.B.R         /* Message Buffer 52 B Register */
#define CAN_0_H52            CAN_0.MB[52].DATA.H.R         /* Message Buffer 52 H Register */
#define CAN_0_W52            CAN_0.MB[52].DATA.W.R         /* Message Buffer 52 W Register */
#define CAN_0_CS53           CAN_0.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_0_ID53           CAN_0.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_0_B53            CAN_0.MB[53].DATA.B.R         /* Message Buffer 53 B Register */
#define CAN_0_H53            CAN_0.MB[53].DATA.H.R         /* Message Buffer 53 H Register */
#define CAN_0_W53            CAN_0.MB[53].DATA.W.R         /* Message Buffer 53 W Register */
#define CAN_0_CS54           CAN_0.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_0_ID54           CAN_0.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_0_B54            CAN_0.MB[54].DATA.B.R         /* Message Buffer 54 B Register */
#define CAN_0_H54            CAN_0.MB[54].DATA.H.R         /* Message Buffer 54 H Register */
#define CAN_0_W54            CAN_0.MB[54].DATA.W.R         /* Message Buffer 54 W Register */
#define CAN_0_CS55           CAN_0.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_0_ID55           CAN_0.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_0_B55            CAN_0.MB[55].DATA.B.R         /* Message Buffer 55 B Register */
#define CAN_0_H55            CAN_0.MB[55].DATA.H.R         /* Message Buffer 55 H Register */
#define CAN_0_W55            CAN_0.MB[55].DATA.W.R         /* Message Buffer 55 W Register */
#define CAN_0_CS56           CAN_0.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_0_ID56           CAN_0.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_0_B56            CAN_0.MB[56].DATA.B.R         /* Message Buffer 56 B Register */
#define CAN_0_H56            CAN_0.MB[56].DATA.H.R         /* Message Buffer 56 H Register */
#define CAN_0_W56            CAN_0.MB[56].DATA.W.R         /* Message Buffer 56 W Register */
#define CAN_0_CS57           CAN_0.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_0_ID57           CAN_0.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_0_B57            CAN_0.MB[57].DATA.B.R         /* Message Buffer 57 B Register */
#define CAN_0_H57            CAN_0.MB[57].DATA.H.R         /* Message Buffer 57 H Register */
#define CAN_0_W57            CAN_0.MB[57].DATA.W.R         /* Message Buffer 57 W Register */
#define CAN_0_CS58           CAN_0.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_0_ID58           CAN_0.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_0_B58            CAN_0.MB[58].DATA.B.R         /* Message Buffer 58 B Register */
#define CAN_0_H58            CAN_0.MB[58].DATA.H.R         /* Message Buffer 58 H Register */
#define CAN_0_W58            CAN_0.MB[58].DATA.W.R         /* Message Buffer 58 W Register */
#define CAN_0_CS59           CAN_0.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_0_ID59           CAN_0.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_0_B59            CAN_0.MB[59].DATA.B.R         /* Message Buffer 59 B Register */
#define CAN_0_H59            CAN_0.MB[59].DATA.H.R         /* Message Buffer 59 H Register */
#define CAN_0_W59            CAN_0.MB[59].DATA.W.R         /* Message Buffer 59 W Register */
#define CAN_0_CS60           CAN_0.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_0_ID60           CAN_0.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_0_B60            CAN_0.MB[60].DATA.B.R         /* Message Buffer 60 B Register */
#define CAN_0_H60            CAN_0.MB[60].DATA.H.R         /* Message Buffer 60 H Register */
#define CAN_0_W60            CAN_0.MB[60].DATA.W.R         /* Message Buffer 60 W Register */
#define CAN_0_CS61           CAN_0.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_0_ID61           CAN_0.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_0_B61            CAN_0.MB[61].DATA.B.R         /* Message Buffer 61 B Register */
#define CAN_0_H61            CAN_0.MB[61].DATA.H.R         /* Message Buffer 61 H Register */
#define CAN_0_W61            CAN_0.MB[61].DATA.W.R         /* Message Buffer 61 W Register */
#define CAN_0_CS62           CAN_0.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_0_ID62           CAN_0.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_0_B62            CAN_0.MB[62].DATA.B.R         /* Message Buffer 62 B Register */
#define CAN_0_H62            CAN_0.MB[62].DATA.H.R         /* Message Buffer 62 H Register */
#define CAN_0_W62            CAN_0.MB[62].DATA.W.R         /* Message Buffer 62 W Register */
#define CAN_0_CS63           CAN_0.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_0_ID63           CAN_0.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_0_B63            CAN_0.MB[63].DATA.B.R         /* Message Buffer 63 B Register */
#define CAN_0_H63            CAN_0.MB[63].DATA.H.R         /* Message Buffer 63 H Register */
#define CAN_0_W63            CAN_0.MB[63].DATA.W.R         /* Message Buffer 63 W Register */
#define CAN_0_RXIMR0         CAN_0.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR1         CAN_0.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR2         CAN_0.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR3         CAN_0.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR4         CAN_0.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR5         CAN_0.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR6         CAN_0.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR7         CAN_0.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR8         CAN_0.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR9         CAN_0.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR10        CAN_0.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR11        CAN_0.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR12        CAN_0.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR13        CAN_0.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR14        CAN_0.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR15        CAN_0.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR16        CAN_0.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR17        CAN_0.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR18        CAN_0.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR19        CAN_0.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR20        CAN_0.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR21        CAN_0.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR22        CAN_0.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR23        CAN_0.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR24        CAN_0.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR25        CAN_0.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR26        CAN_0.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR27        CAN_0.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR28        CAN_0.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR29        CAN_0.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR30        CAN_0.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR31        CAN_0.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR32        CAN_0.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR33        CAN_0.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR34        CAN_0.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR35        CAN_0.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR36        CAN_0.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR37        CAN_0.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR38        CAN_0.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR39        CAN_0.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR40        CAN_0.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR41        CAN_0.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR42        CAN_0.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR43        CAN_0.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR44        CAN_0.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR45        CAN_0.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR46        CAN_0.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR47        CAN_0.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR48        CAN_0.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR49        CAN_0.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR50        CAN_0.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR51        CAN_0.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR52        CAN_0.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR53        CAN_0.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR54        CAN_0.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR55        CAN_0.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR56        CAN_0.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR57        CAN_0.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR58        CAN_0.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR59        CAN_0.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR60        CAN_0.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR61        CAN_0.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR62        CAN_0.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR63        CAN_0.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_0_MECR           CAN_0.MECR.R                  /* Memory Error Control Register */
#define CAN_0_ERRIAR         CAN_0.ERRIAR.R                /* Error Injection Address Register */
#define CAN_0_ERRIDPR        CAN_0.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_0_ERRIPPR        CAN_0.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_0_RERRAR         CAN_0.RERRAR.R                /* Error Report Address Register */
#define CAN_0_RERRDR         CAN_0.RERRDR.R                /* Error Report Data Register */
#define CAN_0_RERRSYNR       CAN_0.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_0_ERRSR          CAN_0.ERRSR.R                 /* Error Status Register */

/* CAN */
#define CAN_1_MCR            CAN_1.MCR.R                   /* Module Configuration Register */
#define CAN_1_CTRL1          CAN_1.CTRL1.R                 /* Control 1 register */
#define CAN_1_TIMER          CAN_1.TIMER.R                 /* Free Running Timer */
#define CAN_1_RXMGMASK       CAN_1.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_1_RX14MASK       CAN_1.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_1_RX15MASK       CAN_1.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_1_ECR            CAN_1.ECR.R                   /* Error Counter */
#define CAN_1_ESR1           CAN_1.ESR1.R                  /* Error and Status 1 register */
#define CAN_1_IMASK2         CAN_1.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_1_IMASK1         CAN_1.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_1_IFLAG2         CAN_1.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_1_IFLAG1         CAN_1.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_1_CTRL2          CAN_1.CTRL2.R                 /* Control 2 register */
#define CAN_1_ESR2           CAN_1.ESR2.R                  /* Error and Status 2 register */
#define CAN_1_CRCR           CAN_1.CRCR.R                  /* CRC Register */
#define CAN_1_RXFGMASK       CAN_1.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_1_RXFIR          CAN_1.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_1_CS0            CAN_1.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_1_ID0            CAN_1.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_1_B0             CAN_1.MB[0].DATA.B.R          /* Message Buffer 0 B Register */
#define CAN_1_H0             CAN_1.MB[0].DATA.H.R          /* Message Buffer 0 H Register */
#define CAN_1_W0             CAN_1.MB[0].DATA.W.R          /* Message Buffer 0 W Register */
#define CAN_1_CS1            CAN_1.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_1_ID1            CAN_1.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_1_B1             CAN_1.MB[1].DATA.B.R          /* Message Buffer 1 B Register */
#define CAN_1_H1             CAN_1.MB[1].DATA.H.R          /* Message Buffer 1 H Register */
#define CAN_1_W1             CAN_1.MB[1].DATA.W.R          /* Message Buffer 1 W Register */
#define CAN_1_CS2            CAN_1.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_1_ID2            CAN_1.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_1_B2             CAN_1.MB[2].DATA.B.R          /* Message Buffer 2 B Register */
#define CAN_1_H2             CAN_1.MB[2].DATA.H.R          /* Message Buffer 2 H Register */
#define CAN_1_W2             CAN_1.MB[2].DATA.W.R          /* Message Buffer 2 W Register */
#define CAN_1_CS3            CAN_1.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_1_ID3            CAN_1.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_1_B3             CAN_1.MB[3].DATA.B.R          /* Message Buffer 3 B Register */
#define CAN_1_H3             CAN_1.MB[3].DATA.H.R          /* Message Buffer 3 H Register */
#define CAN_1_W3             CAN_1.MB[3].DATA.W.R          /* Message Buffer 3 W Register */
#define CAN_1_CS4            CAN_1.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_1_ID4            CAN_1.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_1_B4             CAN_1.MB[4].DATA.B.R          /* Message Buffer 4 B Register */
#define CAN_1_H4             CAN_1.MB[4].DATA.H.R          /* Message Buffer 4 H Register */
#define CAN_1_W4             CAN_1.MB[4].DATA.W.R          /* Message Buffer 4 W Register */
#define CAN_1_CS5            CAN_1.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_1_ID5            CAN_1.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_1_B5             CAN_1.MB[5].DATA.B.R          /* Message Buffer 5 B Register */
#define CAN_1_H5             CAN_1.MB[5].DATA.H.R          /* Message Buffer 5 H Register */
#define CAN_1_W5             CAN_1.MB[5].DATA.W.R          /* Message Buffer 5 W Register */
#define CAN_1_CS6            CAN_1.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_1_ID6            CAN_1.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_1_B6             CAN_1.MB[6].DATA.B.R          /* Message Buffer 6 B Register */
#define CAN_1_H6             CAN_1.MB[6].DATA.H.R          /* Message Buffer 6 H Register */
#define CAN_1_W6             CAN_1.MB[6].DATA.W.R          /* Message Buffer 6 W Register */
#define CAN_1_CS7            CAN_1.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_1_ID7            CAN_1.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_1_B7             CAN_1.MB[7].DATA.B.R          /* Message Buffer 7 B Register */
#define CAN_1_H7             CAN_1.MB[7].DATA.H.R          /* Message Buffer 7 H Register */
#define CAN_1_W7             CAN_1.MB[7].DATA.W.R          /* Message Buffer 7 W Register */
#define CAN_1_CS8            CAN_1.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_1_ID8            CAN_1.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_1_B8             CAN_1.MB[8].DATA.B.R          /* Message Buffer 8 B Register */
#define CAN_1_H8             CAN_1.MB[8].DATA.H.R          /* Message Buffer 8 H Register */
#define CAN_1_W8             CAN_1.MB[8].DATA.W.R          /* Message Buffer 8 W Register */
#define CAN_1_CS9            CAN_1.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_1_ID9            CAN_1.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_1_B9             CAN_1.MB[9].DATA.B.R          /* Message Buffer 9 B Register */
#define CAN_1_H9             CAN_1.MB[9].DATA.H.R          /* Message Buffer 9 H Register */
#define CAN_1_W9             CAN_1.MB[9].DATA.W.R          /* Message Buffer 9 W Register */
#define CAN_1_CS10           CAN_1.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_1_ID10           CAN_1.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_1_B10            CAN_1.MB[10].DATA.B.R         /* Message Buffer 10 B Register */
#define CAN_1_H10            CAN_1.MB[10].DATA.H.R         /* Message Buffer 10 H Register */
#define CAN_1_W10            CAN_1.MB[10].DATA.W.R         /* Message Buffer 10 W Register */
#define CAN_1_CS11           CAN_1.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_1_ID11           CAN_1.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_1_B11            CAN_1.MB[11].DATA.B.R         /* Message Buffer 11 B Register */
#define CAN_1_H11            CAN_1.MB[11].DATA.H.R         /* Message Buffer 11 H Register */
#define CAN_1_W11            CAN_1.MB[11].DATA.W.R         /* Message Buffer 11 W Register */
#define CAN_1_CS12           CAN_1.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_1_ID12           CAN_1.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_1_B12            CAN_1.MB[12].DATA.B.R         /* Message Buffer 12 B Register */
#define CAN_1_H12            CAN_1.MB[12].DATA.H.R         /* Message Buffer 12 H Register */
#define CAN_1_W12            CAN_1.MB[12].DATA.W.R         /* Message Buffer 12 W Register */
#define CAN_1_CS13           CAN_1.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_1_ID13           CAN_1.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_1_B13            CAN_1.MB[13].DATA.B.R         /* Message Buffer 13 B Register */
#define CAN_1_H13            CAN_1.MB[13].DATA.H.R         /* Message Buffer 13 H Register */
#define CAN_1_W13            CAN_1.MB[13].DATA.W.R         /* Message Buffer 13 W Register */
#define CAN_1_CS14           CAN_1.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_1_ID14           CAN_1.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_1_B14            CAN_1.MB[14].DATA.B.R         /* Message Buffer 14 B Register */
#define CAN_1_H14            CAN_1.MB[14].DATA.H.R         /* Message Buffer 14 H Register */
#define CAN_1_W14            CAN_1.MB[14].DATA.W.R         /* Message Buffer 14 W Register */
#define CAN_1_CS15           CAN_1.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_1_ID15           CAN_1.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_1_B15            CAN_1.MB[15].DATA.B.R         /* Message Buffer 15 B Register */
#define CAN_1_H15            CAN_1.MB[15].DATA.H.R         /* Message Buffer 15 H Register */
#define CAN_1_W15            CAN_1.MB[15].DATA.W.R         /* Message Buffer 15 W Register */
#define CAN_1_CS16           CAN_1.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_1_ID16           CAN_1.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_1_B16            CAN_1.MB[16].DATA.B.R         /* Message Buffer 16 B Register */
#define CAN_1_H16            CAN_1.MB[16].DATA.H.R         /* Message Buffer 16 H Register */
#define CAN_1_W16            CAN_1.MB[16].DATA.W.R         /* Message Buffer 16 W Register */
#define CAN_1_CS17           CAN_1.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_1_ID17           CAN_1.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_1_B17            CAN_1.MB[17].DATA.B.R         /* Message Buffer 17 B Register */
#define CAN_1_H17            CAN_1.MB[17].DATA.H.R         /* Message Buffer 17 H Register */
#define CAN_1_W17            CAN_1.MB[17].DATA.W.R         /* Message Buffer 17 W Register */
#define CAN_1_CS18           CAN_1.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_1_ID18           CAN_1.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_1_B18            CAN_1.MB[18].DATA.B.R         /* Message Buffer 18 B Register */
#define CAN_1_H18            CAN_1.MB[18].DATA.H.R         /* Message Buffer 18 H Register */
#define CAN_1_W18            CAN_1.MB[18].DATA.W.R         /* Message Buffer 18 W Register */
#define CAN_1_CS19           CAN_1.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_1_ID19           CAN_1.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_1_B19            CAN_1.MB[19].DATA.B.R         /* Message Buffer 19 B Register */
#define CAN_1_H19            CAN_1.MB[19].DATA.H.R         /* Message Buffer 19 H Register */
#define CAN_1_W19            CAN_1.MB[19].DATA.W.R         /* Message Buffer 19 W Register */
#define CAN_1_CS20           CAN_1.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_1_ID20           CAN_1.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_1_B20            CAN_1.MB[20].DATA.B.R         /* Message Buffer 20 B Register */
#define CAN_1_H20            CAN_1.MB[20].DATA.H.R         /* Message Buffer 20 H Register */
#define CAN_1_W20            CAN_1.MB[20].DATA.W.R         /* Message Buffer 20 W Register */
#define CAN_1_CS21           CAN_1.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_1_ID21           CAN_1.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_1_B21            CAN_1.MB[21].DATA.B.R         /* Message Buffer 21 B Register */
#define CAN_1_H21            CAN_1.MB[21].DATA.H.R         /* Message Buffer 21 H Register */
#define CAN_1_W21            CAN_1.MB[21].DATA.W.R         /* Message Buffer 21 W Register */
#define CAN_1_CS22           CAN_1.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_1_ID22           CAN_1.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_1_B22            CAN_1.MB[22].DATA.B.R         /* Message Buffer 22 B Register */
#define CAN_1_H22            CAN_1.MB[22].DATA.H.R         /* Message Buffer 22 H Register */
#define CAN_1_W22            CAN_1.MB[22].DATA.W.R         /* Message Buffer 22 W Register */
#define CAN_1_CS23           CAN_1.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_1_ID23           CAN_1.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_1_B23            CAN_1.MB[23].DATA.B.R         /* Message Buffer 23 B Register */
#define CAN_1_H23            CAN_1.MB[23].DATA.H.R         /* Message Buffer 23 H Register */
#define CAN_1_W23            CAN_1.MB[23].DATA.W.R         /* Message Buffer 23 W Register */
#define CAN_1_CS24           CAN_1.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_1_ID24           CAN_1.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_1_B24            CAN_1.MB[24].DATA.B.R         /* Message Buffer 24 B Register */
#define CAN_1_H24            CAN_1.MB[24].DATA.H.R         /* Message Buffer 24 H Register */
#define CAN_1_W24            CAN_1.MB[24].DATA.W.R         /* Message Buffer 24 W Register */
#define CAN_1_CS25           CAN_1.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_1_ID25           CAN_1.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_1_B25            CAN_1.MB[25].DATA.B.R         /* Message Buffer 25 B Register */
#define CAN_1_H25            CAN_1.MB[25].DATA.H.R         /* Message Buffer 25 H Register */
#define CAN_1_W25            CAN_1.MB[25].DATA.W.R         /* Message Buffer 25 W Register */
#define CAN_1_CS26           CAN_1.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_1_ID26           CAN_1.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_1_B26            CAN_1.MB[26].DATA.B.R         /* Message Buffer 26 B Register */
#define CAN_1_H26            CAN_1.MB[26].DATA.H.R         /* Message Buffer 26 H Register */
#define CAN_1_W26            CAN_1.MB[26].DATA.W.R         /* Message Buffer 26 W Register */
#define CAN_1_CS27           CAN_1.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_1_ID27           CAN_1.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_1_B27            CAN_1.MB[27].DATA.B.R         /* Message Buffer 27 B Register */
#define CAN_1_H27            CAN_1.MB[27].DATA.H.R         /* Message Buffer 27 H Register */
#define CAN_1_W27            CAN_1.MB[27].DATA.W.R         /* Message Buffer 27 W Register */
#define CAN_1_CS28           CAN_1.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_1_ID28           CAN_1.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_1_B28            CAN_1.MB[28].DATA.B.R         /* Message Buffer 28 B Register */
#define CAN_1_H28            CAN_1.MB[28].DATA.H.R         /* Message Buffer 28 H Register */
#define CAN_1_W28            CAN_1.MB[28].DATA.W.R         /* Message Buffer 28 W Register */
#define CAN_1_CS29           CAN_1.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_1_ID29           CAN_1.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_1_B29            CAN_1.MB[29].DATA.B.R         /* Message Buffer 29 B Register */
#define CAN_1_H29            CAN_1.MB[29].DATA.H.R         /* Message Buffer 29 H Register */
#define CAN_1_W29            CAN_1.MB[29].DATA.W.R         /* Message Buffer 29 W Register */
#define CAN_1_CS30           CAN_1.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_1_ID30           CAN_1.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_1_B30            CAN_1.MB[30].DATA.B.R         /* Message Buffer 30 B Register */
#define CAN_1_H30            CAN_1.MB[30].DATA.H.R         /* Message Buffer 30 H Register */
#define CAN_1_W30            CAN_1.MB[30].DATA.W.R         /* Message Buffer 30 W Register */
#define CAN_1_CS31           CAN_1.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_1_ID31           CAN_1.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_1_B31            CAN_1.MB[31].DATA.B.R         /* Message Buffer 31 B Register */
#define CAN_1_H31            CAN_1.MB[31].DATA.H.R         /* Message Buffer 31 H Register */
#define CAN_1_W31            CAN_1.MB[31].DATA.W.R         /* Message Buffer 31 W Register */
#define CAN_1_CS32           CAN_1.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_1_ID32           CAN_1.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_1_B32            CAN_1.MB[32].DATA.B.R         /* Message Buffer 32 B Register */
#define CAN_1_H32            CAN_1.MB[32].DATA.H.R         /* Message Buffer 32 H Register */
#define CAN_1_W32            CAN_1.MB[32].DATA.W.R         /* Message Buffer 32 W Register */
#define CAN_1_CS33           CAN_1.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_1_ID33           CAN_1.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_1_B33            CAN_1.MB[33].DATA.B.R         /* Message Buffer 33 B Register */
#define CAN_1_H33            CAN_1.MB[33].DATA.H.R         /* Message Buffer 33 H Register */
#define CAN_1_W33            CAN_1.MB[33].DATA.W.R         /* Message Buffer 33 W Register */
#define CAN_1_CS34           CAN_1.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_1_ID34           CAN_1.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_1_B34            CAN_1.MB[34].DATA.B.R         /* Message Buffer 34 B Register */
#define CAN_1_H34            CAN_1.MB[34].DATA.H.R         /* Message Buffer 34 H Register */
#define CAN_1_W34            CAN_1.MB[34].DATA.W.R         /* Message Buffer 34 W Register */
#define CAN_1_CS35           CAN_1.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_1_ID35           CAN_1.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_1_B35            CAN_1.MB[35].DATA.B.R         /* Message Buffer 35 B Register */
#define CAN_1_H35            CAN_1.MB[35].DATA.H.R         /* Message Buffer 35 H Register */
#define CAN_1_W35            CAN_1.MB[35].DATA.W.R         /* Message Buffer 35 W Register */
#define CAN_1_CS36           CAN_1.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_1_ID36           CAN_1.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_1_B36            CAN_1.MB[36].DATA.B.R         /* Message Buffer 36 B Register */
#define CAN_1_H36            CAN_1.MB[36].DATA.H.R         /* Message Buffer 36 H Register */
#define CAN_1_W36            CAN_1.MB[36].DATA.W.R         /* Message Buffer 36 W Register */
#define CAN_1_CS37           CAN_1.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_1_ID37           CAN_1.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_1_B37            CAN_1.MB[37].DATA.B.R         /* Message Buffer 37 B Register */
#define CAN_1_H37            CAN_1.MB[37].DATA.H.R         /* Message Buffer 37 H Register */
#define CAN_1_W37            CAN_1.MB[37].DATA.W.R         /* Message Buffer 37 W Register */
#define CAN_1_CS38           CAN_1.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_1_ID38           CAN_1.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_1_B38            CAN_1.MB[38].DATA.B.R         /* Message Buffer 38 B Register */
#define CAN_1_H38            CAN_1.MB[38].DATA.H.R         /* Message Buffer 38 H Register */
#define CAN_1_W38            CAN_1.MB[38].DATA.W.R         /* Message Buffer 38 W Register */
#define CAN_1_CS39           CAN_1.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_1_ID39           CAN_1.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_1_B39            CAN_1.MB[39].DATA.B.R         /* Message Buffer 39 B Register */
#define CAN_1_H39            CAN_1.MB[39].DATA.H.R         /* Message Buffer 39 H Register */
#define CAN_1_W39            CAN_1.MB[39].DATA.W.R         /* Message Buffer 39 W Register */
#define CAN_1_CS40           CAN_1.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_1_ID40           CAN_1.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_1_B40            CAN_1.MB[40].DATA.B.R         /* Message Buffer 40 B Register */
#define CAN_1_H40            CAN_1.MB[40].DATA.H.R         /* Message Buffer 40 H Register */
#define CAN_1_W40            CAN_1.MB[40].DATA.W.R         /* Message Buffer 40 W Register */
#define CAN_1_CS41           CAN_1.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_1_ID41           CAN_1.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_1_B41            CAN_1.MB[41].DATA.B.R         /* Message Buffer 41 B Register */
#define CAN_1_H41            CAN_1.MB[41].DATA.H.R         /* Message Buffer 41 H Register */
#define CAN_1_W41            CAN_1.MB[41].DATA.W.R         /* Message Buffer 41 W Register */
#define CAN_1_CS42           CAN_1.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_1_ID42           CAN_1.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_1_B42            CAN_1.MB[42].DATA.B.R         /* Message Buffer 42 B Register */
#define CAN_1_H42            CAN_1.MB[42].DATA.H.R         /* Message Buffer 42 H Register */
#define CAN_1_W42            CAN_1.MB[42].DATA.W.R         /* Message Buffer 42 W Register */
#define CAN_1_CS43           CAN_1.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_1_ID43           CAN_1.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_1_B43            CAN_1.MB[43].DATA.B.R         /* Message Buffer 43 B Register */
#define CAN_1_H43            CAN_1.MB[43].DATA.H.R         /* Message Buffer 43 H Register */
#define CAN_1_W43            CAN_1.MB[43].DATA.W.R         /* Message Buffer 43 W Register */
#define CAN_1_CS44           CAN_1.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_1_ID44           CAN_1.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_1_B44            CAN_1.MB[44].DATA.B.R         /* Message Buffer 44 B Register */
#define CAN_1_H44            CAN_1.MB[44].DATA.H.R         /* Message Buffer 44 H Register */
#define CAN_1_W44            CAN_1.MB[44].DATA.W.R         /* Message Buffer 44 W Register */
#define CAN_1_CS45           CAN_1.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_1_ID45           CAN_1.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_1_B45            CAN_1.MB[45].DATA.B.R         /* Message Buffer 45 B Register */
#define CAN_1_H45            CAN_1.MB[45].DATA.H.R         /* Message Buffer 45 H Register */
#define CAN_1_W45            CAN_1.MB[45].DATA.W.R         /* Message Buffer 45 W Register */
#define CAN_1_CS46           CAN_1.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_1_ID46           CAN_1.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_1_B46            CAN_1.MB[46].DATA.B.R         /* Message Buffer 46 B Register */
#define CAN_1_H46            CAN_1.MB[46].DATA.H.R         /* Message Buffer 46 H Register */
#define CAN_1_W46            CAN_1.MB[46].DATA.W.R         /* Message Buffer 46 W Register */
#define CAN_1_CS47           CAN_1.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_1_ID47           CAN_1.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_1_B47            CAN_1.MB[47].DATA.B.R         /* Message Buffer 47 B Register */
#define CAN_1_H47            CAN_1.MB[47].DATA.H.R         /* Message Buffer 47 H Register */
#define CAN_1_W47            CAN_1.MB[47].DATA.W.R         /* Message Buffer 47 W Register */
#define CAN_1_CS48           CAN_1.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_1_ID48           CAN_1.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_1_B48            CAN_1.MB[48].DATA.B.R         /* Message Buffer 48 B Register */
#define CAN_1_H48            CAN_1.MB[48].DATA.H.R         /* Message Buffer 48 H Register */
#define CAN_1_W48            CAN_1.MB[48].DATA.W.R         /* Message Buffer 48 W Register */
#define CAN_1_CS49           CAN_1.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_1_ID49           CAN_1.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_1_B49            CAN_1.MB[49].DATA.B.R         /* Message Buffer 49 B Register */
#define CAN_1_H49            CAN_1.MB[49].DATA.H.R         /* Message Buffer 49 H Register */
#define CAN_1_W49            CAN_1.MB[49].DATA.W.R         /* Message Buffer 49 W Register */
#define CAN_1_CS50           CAN_1.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_1_ID50           CAN_1.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_1_B50            CAN_1.MB[50].DATA.B.R         /* Message Buffer 50 B Register */
#define CAN_1_H50            CAN_1.MB[50].DATA.H.R         /* Message Buffer 50 H Register */
#define CAN_1_W50            CAN_1.MB[50].DATA.W.R         /* Message Buffer 50 W Register */
#define CAN_1_CS51           CAN_1.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_1_ID51           CAN_1.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_1_B51            CAN_1.MB[51].DATA.B.R         /* Message Buffer 51 B Register */
#define CAN_1_H51            CAN_1.MB[51].DATA.H.R         /* Message Buffer 51 H Register */
#define CAN_1_W51            CAN_1.MB[51].DATA.W.R         /* Message Buffer 51 W Register */
#define CAN_1_CS52           CAN_1.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_1_ID52           CAN_1.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_1_B52            CAN_1.MB[52].DATA.B.R         /* Message Buffer 52 B Register */
#define CAN_1_H52            CAN_1.MB[52].DATA.H.R         /* Message Buffer 52 H Register */
#define CAN_1_W52            CAN_1.MB[52].DATA.W.R         /* Message Buffer 52 W Register */
#define CAN_1_CS53           CAN_1.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_1_ID53           CAN_1.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_1_B53            CAN_1.MB[53].DATA.B.R         /* Message Buffer 53 B Register */
#define CAN_1_H53            CAN_1.MB[53].DATA.H.R         /* Message Buffer 53 H Register */
#define CAN_1_W53            CAN_1.MB[53].DATA.W.R         /* Message Buffer 53 W Register */
#define CAN_1_CS54           CAN_1.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_1_ID54           CAN_1.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_1_B54            CAN_1.MB[54].DATA.B.R         /* Message Buffer 54 B Register */
#define CAN_1_H54            CAN_1.MB[54].DATA.H.R         /* Message Buffer 54 H Register */
#define CAN_1_W54            CAN_1.MB[54].DATA.W.R         /* Message Buffer 54 W Register */
#define CAN_1_CS55           CAN_1.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_1_ID55           CAN_1.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_1_B55            CAN_1.MB[55].DATA.B.R         /* Message Buffer 55 B Register */
#define CAN_1_H55            CAN_1.MB[55].DATA.H.R         /* Message Buffer 55 H Register */
#define CAN_1_W55            CAN_1.MB[55].DATA.W.R         /* Message Buffer 55 W Register */
#define CAN_1_CS56           CAN_1.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_1_ID56           CAN_1.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_1_B56            CAN_1.MB[56].DATA.B.R         /* Message Buffer 56 B Register */
#define CAN_1_H56            CAN_1.MB[56].DATA.H.R         /* Message Buffer 56 H Register */
#define CAN_1_W56            CAN_1.MB[56].DATA.W.R         /* Message Buffer 56 W Register */
#define CAN_1_CS57           CAN_1.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_1_ID57           CAN_1.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_1_B57            CAN_1.MB[57].DATA.B.R         /* Message Buffer 57 B Register */
#define CAN_1_H57            CAN_1.MB[57].DATA.H.R         /* Message Buffer 57 H Register */
#define CAN_1_W57            CAN_1.MB[57].DATA.W.R         /* Message Buffer 57 W Register */
#define CAN_1_CS58           CAN_1.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_1_ID58           CAN_1.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_1_B58            CAN_1.MB[58].DATA.B.R         /* Message Buffer 58 B Register */
#define CAN_1_H58            CAN_1.MB[58].DATA.H.R         /* Message Buffer 58 H Register */
#define CAN_1_W58            CAN_1.MB[58].DATA.W.R         /* Message Buffer 58 W Register */
#define CAN_1_CS59           CAN_1.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_1_ID59           CAN_1.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_1_B59            CAN_1.MB[59].DATA.B.R         /* Message Buffer 59 B Register */
#define CAN_1_H59            CAN_1.MB[59].DATA.H.R         /* Message Buffer 59 H Register */
#define CAN_1_W59            CAN_1.MB[59].DATA.W.R         /* Message Buffer 59 W Register */
#define CAN_1_CS60           CAN_1.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_1_ID60           CAN_1.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_1_B60            CAN_1.MB[60].DATA.B.R         /* Message Buffer 60 B Register */
#define CAN_1_H60            CAN_1.MB[60].DATA.H.R         /* Message Buffer 60 H Register */
#define CAN_1_W60            CAN_1.MB[60].DATA.W.R         /* Message Buffer 60 W Register */
#define CAN_1_CS61           CAN_1.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_1_ID61           CAN_1.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_1_B61            CAN_1.MB[61].DATA.B.R         /* Message Buffer 61 B Register */
#define CAN_1_H61            CAN_1.MB[61].DATA.H.R         /* Message Buffer 61 H Register */
#define CAN_1_W61            CAN_1.MB[61].DATA.W.R         /* Message Buffer 61 W Register */
#define CAN_1_CS62           CAN_1.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_1_ID62           CAN_1.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_1_B62            CAN_1.MB[62].DATA.B.R         /* Message Buffer 62 B Register */
#define CAN_1_H62            CAN_1.MB[62].DATA.H.R         /* Message Buffer 62 H Register */
#define CAN_1_W62            CAN_1.MB[62].DATA.W.R         /* Message Buffer 62 W Register */
#define CAN_1_CS63           CAN_1.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_1_ID63           CAN_1.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_1_B63            CAN_1.MB[63].DATA.B.R         /* Message Buffer 63 B Register */
#define CAN_1_H63            CAN_1.MB[63].DATA.H.R         /* Message Buffer 63 H Register */
#define CAN_1_W63            CAN_1.MB[63].DATA.W.R         /* Message Buffer 63 W Register */
#define CAN_1_RXIMR0         CAN_1.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR1         CAN_1.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR2         CAN_1.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR3         CAN_1.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR4         CAN_1.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR5         CAN_1.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR6         CAN_1.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR7         CAN_1.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR8         CAN_1.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR9         CAN_1.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR10        CAN_1.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR11        CAN_1.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR12        CAN_1.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR13        CAN_1.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR14        CAN_1.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR15        CAN_1.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR16        CAN_1.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR17        CAN_1.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR18        CAN_1.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR19        CAN_1.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR20        CAN_1.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR21        CAN_1.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR22        CAN_1.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR23        CAN_1.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR24        CAN_1.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR25        CAN_1.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR26        CAN_1.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR27        CAN_1.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR28        CAN_1.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR29        CAN_1.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR30        CAN_1.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR31        CAN_1.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR32        CAN_1.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR33        CAN_1.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR34        CAN_1.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR35        CAN_1.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR36        CAN_1.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR37        CAN_1.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR38        CAN_1.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR39        CAN_1.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR40        CAN_1.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR41        CAN_1.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR42        CAN_1.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR43        CAN_1.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR44        CAN_1.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR45        CAN_1.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR46        CAN_1.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR47        CAN_1.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR48        CAN_1.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR49        CAN_1.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR50        CAN_1.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR51        CAN_1.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR52        CAN_1.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR53        CAN_1.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR54        CAN_1.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR55        CAN_1.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR56        CAN_1.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR57        CAN_1.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR58        CAN_1.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR59        CAN_1.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR60        CAN_1.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR61        CAN_1.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR62        CAN_1.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR63        CAN_1.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_1_MECR           CAN_1.MECR.R                  /* Memory Error Control Register */
#define CAN_1_ERRIAR         CAN_1.ERRIAR.R                /* Error Injection Address Register */
#define CAN_1_ERRIDPR        CAN_1.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_1_ERRIPPR        CAN_1.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_1_RERRAR         CAN_1.RERRAR.R                /* Error Report Address Register */
#define CAN_1_RERRDR         CAN_1.RERRDR.R                /* Error Report Data Register */
#define CAN_1_RERRSYNR       CAN_1.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_1_ERRSR          CAN_1.ERRSR.R                 /* Error Status Register */

/* CAN */
#define CAN_2_MCR            CAN_2.MCR.R                   /* Module Configuration Register */
#define CAN_2_CTRL1          CAN_2.CTRL1.R                 /* Control 1 register */
#define CAN_2_TIMER          CAN_2.TIMER.R                 /* Free Running Timer */
#define CAN_2_RXMGMASK       CAN_2.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_2_RX14MASK       CAN_2.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_2_RX15MASK       CAN_2.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_2_ECR            CAN_2.ECR.R                   /* Error Counter */
#define CAN_2_ESR1           CAN_2.ESR1.R                  /* Error and Status 1 register */
#define CAN_2_IMASK2         CAN_2.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_2_IMASK1         CAN_2.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_2_IFLAG2         CAN_2.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_2_IFLAG1         CAN_2.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_2_CTRL2          CAN_2.CTRL2.R                 /* Control 2 register */
#define CAN_2_ESR2           CAN_2.ESR2.R                  /* Error and Status 2 register */
#define CAN_2_CRCR           CAN_2.CRCR.R                  /* CRC Register */
#define CAN_2_RXFGMASK       CAN_2.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_2_RXFIR          CAN_2.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_2_CS0            CAN_2.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_2_ID0            CAN_2.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_2_B0             CAN_2.MB[0].DATA.B.R          /* Message Buffer 0 B Register */
#define CAN_2_H0             CAN_2.MB[0].DATA.H.R          /* Message Buffer 0 H Register */
#define CAN_2_W0             CAN_2.MB[0].DATA.W.R          /* Message Buffer 0 W Register */
#define CAN_2_CS1            CAN_2.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_2_ID1            CAN_2.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_2_B1             CAN_2.MB[1].DATA.B.R          /* Message Buffer 1 B Register */
#define CAN_2_H1             CAN_2.MB[1].DATA.H.R          /* Message Buffer 1 H Register */
#define CAN_2_W1             CAN_2.MB[1].DATA.W.R          /* Message Buffer 1 W Register */
#define CAN_2_CS2            CAN_2.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_2_ID2            CAN_2.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_2_B2             CAN_2.MB[2].DATA.B.R          /* Message Buffer 2 B Register */
#define CAN_2_H2             CAN_2.MB[2].DATA.H.R          /* Message Buffer 2 H Register */
#define CAN_2_W2             CAN_2.MB[2].DATA.W.R          /* Message Buffer 2 W Register */
#define CAN_2_CS3            CAN_2.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_2_ID3            CAN_2.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_2_B3             CAN_2.MB[3].DATA.B.R          /* Message Buffer 3 B Register */
#define CAN_2_H3             CAN_2.MB[3].DATA.H.R          /* Message Buffer 3 H Register */
#define CAN_2_W3             CAN_2.MB[3].DATA.W.R          /* Message Buffer 3 W Register */
#define CAN_2_CS4            CAN_2.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_2_ID4            CAN_2.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_2_B4             CAN_2.MB[4].DATA.B.R          /* Message Buffer 4 B Register */
#define CAN_2_H4             CAN_2.MB[4].DATA.H.R          /* Message Buffer 4 H Register */
#define CAN_2_W4             CAN_2.MB[4].DATA.W.R          /* Message Buffer 4 W Register */
#define CAN_2_CS5            CAN_2.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_2_ID5            CAN_2.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_2_B5             CAN_2.MB[5].DATA.B.R          /* Message Buffer 5 B Register */
#define CAN_2_H5             CAN_2.MB[5].DATA.H.R          /* Message Buffer 5 H Register */
#define CAN_2_W5             CAN_2.MB[5].DATA.W.R          /* Message Buffer 5 W Register */
#define CAN_2_CS6            CAN_2.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_2_ID6            CAN_2.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_2_B6             CAN_2.MB[6].DATA.B.R          /* Message Buffer 6 B Register */
#define CAN_2_H6             CAN_2.MB[6].DATA.H.R          /* Message Buffer 6 H Register */
#define CAN_2_W6             CAN_2.MB[6].DATA.W.R          /* Message Buffer 6 W Register */
#define CAN_2_CS7            CAN_2.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_2_ID7            CAN_2.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_2_B7             CAN_2.MB[7].DATA.B.R          /* Message Buffer 7 B Register */
#define CAN_2_H7             CAN_2.MB[7].DATA.H.R          /* Message Buffer 7 H Register */
#define CAN_2_W7             CAN_2.MB[7].DATA.W.R          /* Message Buffer 7 W Register */
#define CAN_2_CS8            CAN_2.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_2_ID8            CAN_2.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_2_B8             CAN_2.MB[8].DATA.B.R          /* Message Buffer 8 B Register */
#define CAN_2_H8             CAN_2.MB[8].DATA.H.R          /* Message Buffer 8 H Register */
#define CAN_2_W8             CAN_2.MB[8].DATA.W.R          /* Message Buffer 8 W Register */
#define CAN_2_CS9            CAN_2.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_2_ID9            CAN_2.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_2_B9             CAN_2.MB[9].DATA.B.R          /* Message Buffer 9 B Register */
#define CAN_2_H9             CAN_2.MB[9].DATA.H.R          /* Message Buffer 9 H Register */
#define CAN_2_W9             CAN_2.MB[9].DATA.W.R          /* Message Buffer 9 W Register */
#define CAN_2_CS10           CAN_2.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_2_ID10           CAN_2.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_2_B10            CAN_2.MB[10].DATA.B.R         /* Message Buffer 10 B Register */
#define CAN_2_H10            CAN_2.MB[10].DATA.H.R         /* Message Buffer 10 H Register */
#define CAN_2_W10            CAN_2.MB[10].DATA.W.R         /* Message Buffer 10 W Register */
#define CAN_2_CS11           CAN_2.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_2_ID11           CAN_2.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_2_B11            CAN_2.MB[11].DATA.B.R         /* Message Buffer 11 B Register */
#define CAN_2_H11            CAN_2.MB[11].DATA.H.R         /* Message Buffer 11 H Register */
#define CAN_2_W11            CAN_2.MB[11].DATA.W.R         /* Message Buffer 11 W Register */
#define CAN_2_CS12           CAN_2.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_2_ID12           CAN_2.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_2_B12            CAN_2.MB[12].DATA.B.R         /* Message Buffer 12 B Register */
#define CAN_2_H12            CAN_2.MB[12].DATA.H.R         /* Message Buffer 12 H Register */
#define CAN_2_W12            CAN_2.MB[12].DATA.W.R         /* Message Buffer 12 W Register */
#define CAN_2_CS13           CAN_2.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_2_ID13           CAN_2.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_2_B13            CAN_2.MB[13].DATA.B.R         /* Message Buffer 13 B Register */
#define CAN_2_H13            CAN_2.MB[13].DATA.H.R         /* Message Buffer 13 H Register */
#define CAN_2_W13            CAN_2.MB[13].DATA.W.R         /* Message Buffer 13 W Register */
#define CAN_2_CS14           CAN_2.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_2_ID14           CAN_2.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_2_B14            CAN_2.MB[14].DATA.B.R         /* Message Buffer 14 B Register */
#define CAN_2_H14            CAN_2.MB[14].DATA.H.R         /* Message Buffer 14 H Register */
#define CAN_2_W14            CAN_2.MB[14].DATA.W.R         /* Message Buffer 14 W Register */
#define CAN_2_CS15           CAN_2.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_2_ID15           CAN_2.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_2_B15            CAN_2.MB[15].DATA.B.R         /* Message Buffer 15 B Register */
#define CAN_2_H15            CAN_2.MB[15].DATA.H.R         /* Message Buffer 15 H Register */
#define CAN_2_W15            CAN_2.MB[15].DATA.W.R         /* Message Buffer 15 W Register */
#define CAN_2_CS16           CAN_2.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_2_ID16           CAN_2.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_2_B16            CAN_2.MB[16].DATA.B.R         /* Message Buffer 16 B Register */
#define CAN_2_H16            CAN_2.MB[16].DATA.H.R         /* Message Buffer 16 H Register */
#define CAN_2_W16            CAN_2.MB[16].DATA.W.R         /* Message Buffer 16 W Register */
#define CAN_2_CS17           CAN_2.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_2_ID17           CAN_2.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_2_B17            CAN_2.MB[17].DATA.B.R         /* Message Buffer 17 B Register */
#define CAN_2_H17            CAN_2.MB[17].DATA.H.R         /* Message Buffer 17 H Register */
#define CAN_2_W17            CAN_2.MB[17].DATA.W.R         /* Message Buffer 17 W Register */
#define CAN_2_CS18           CAN_2.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_2_ID18           CAN_2.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_2_B18            CAN_2.MB[18].DATA.B.R         /* Message Buffer 18 B Register */
#define CAN_2_H18            CAN_2.MB[18].DATA.H.R         /* Message Buffer 18 H Register */
#define CAN_2_W18            CAN_2.MB[18].DATA.W.R         /* Message Buffer 18 W Register */
#define CAN_2_CS19           CAN_2.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_2_ID19           CAN_2.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_2_B19            CAN_2.MB[19].DATA.B.R         /* Message Buffer 19 B Register */
#define CAN_2_H19            CAN_2.MB[19].DATA.H.R         /* Message Buffer 19 H Register */
#define CAN_2_W19            CAN_2.MB[19].DATA.W.R         /* Message Buffer 19 W Register */
#define CAN_2_CS20           CAN_2.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_2_ID20           CAN_2.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_2_B20            CAN_2.MB[20].DATA.B.R         /* Message Buffer 20 B Register */
#define CAN_2_H20            CAN_2.MB[20].DATA.H.R         /* Message Buffer 20 H Register */
#define CAN_2_W20            CAN_2.MB[20].DATA.W.R         /* Message Buffer 20 W Register */
#define CAN_2_CS21           CAN_2.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_2_ID21           CAN_2.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_2_B21            CAN_2.MB[21].DATA.B.R         /* Message Buffer 21 B Register */
#define CAN_2_H21            CAN_2.MB[21].DATA.H.R         /* Message Buffer 21 H Register */
#define CAN_2_W21            CAN_2.MB[21].DATA.W.R         /* Message Buffer 21 W Register */
#define CAN_2_CS22           CAN_2.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_2_ID22           CAN_2.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_2_B22            CAN_2.MB[22].DATA.B.R         /* Message Buffer 22 B Register */
#define CAN_2_H22            CAN_2.MB[22].DATA.H.R         /* Message Buffer 22 H Register */
#define CAN_2_W22            CAN_2.MB[22].DATA.W.R         /* Message Buffer 22 W Register */
#define CAN_2_CS23           CAN_2.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_2_ID23           CAN_2.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_2_B23            CAN_2.MB[23].DATA.B.R         /* Message Buffer 23 B Register */
#define CAN_2_H23            CAN_2.MB[23].DATA.H.R         /* Message Buffer 23 H Register */
#define CAN_2_W23            CAN_2.MB[23].DATA.W.R         /* Message Buffer 23 W Register */
#define CAN_2_CS24           CAN_2.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_2_ID24           CAN_2.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_2_B24            CAN_2.MB[24].DATA.B.R         /* Message Buffer 24 B Register */
#define CAN_2_H24            CAN_2.MB[24].DATA.H.R         /* Message Buffer 24 H Register */
#define CAN_2_W24            CAN_2.MB[24].DATA.W.R         /* Message Buffer 24 W Register */
#define CAN_2_CS25           CAN_2.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_2_ID25           CAN_2.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_2_B25            CAN_2.MB[25].DATA.B.R         /* Message Buffer 25 B Register */
#define CAN_2_H25            CAN_2.MB[25].DATA.H.R         /* Message Buffer 25 H Register */
#define CAN_2_W25            CAN_2.MB[25].DATA.W.R         /* Message Buffer 25 W Register */
#define CAN_2_CS26           CAN_2.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_2_ID26           CAN_2.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_2_B26            CAN_2.MB[26].DATA.B.R         /* Message Buffer 26 B Register */
#define CAN_2_H26            CAN_2.MB[26].DATA.H.R         /* Message Buffer 26 H Register */
#define CAN_2_W26            CAN_2.MB[26].DATA.W.R         /* Message Buffer 26 W Register */
#define CAN_2_CS27           CAN_2.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_2_ID27           CAN_2.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_2_B27            CAN_2.MB[27].DATA.B.R         /* Message Buffer 27 B Register */
#define CAN_2_H27            CAN_2.MB[27].DATA.H.R         /* Message Buffer 27 H Register */
#define CAN_2_W27            CAN_2.MB[27].DATA.W.R         /* Message Buffer 27 W Register */
#define CAN_2_CS28           CAN_2.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_2_ID28           CAN_2.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_2_B28            CAN_2.MB[28].DATA.B.R         /* Message Buffer 28 B Register */
#define CAN_2_H28            CAN_2.MB[28].DATA.H.R         /* Message Buffer 28 H Register */
#define CAN_2_W28            CAN_2.MB[28].DATA.W.R         /* Message Buffer 28 W Register */
#define CAN_2_CS29           CAN_2.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_2_ID29           CAN_2.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_2_B29            CAN_2.MB[29].DATA.B.R         /* Message Buffer 29 B Register */
#define CAN_2_H29            CAN_2.MB[29].DATA.H.R         /* Message Buffer 29 H Register */
#define CAN_2_W29            CAN_2.MB[29].DATA.W.R         /* Message Buffer 29 W Register */
#define CAN_2_CS30           CAN_2.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_2_ID30           CAN_2.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_2_B30            CAN_2.MB[30].DATA.B.R         /* Message Buffer 30 B Register */
#define CAN_2_H30            CAN_2.MB[30].DATA.H.R         /* Message Buffer 30 H Register */
#define CAN_2_W30            CAN_2.MB[30].DATA.W.R         /* Message Buffer 30 W Register */
#define CAN_2_CS31           CAN_2.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_2_ID31           CAN_2.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_2_B31            CAN_2.MB[31].DATA.B.R         /* Message Buffer 31 B Register */
#define CAN_2_H31            CAN_2.MB[31].DATA.H.R         /* Message Buffer 31 H Register */
#define CAN_2_W31            CAN_2.MB[31].DATA.W.R         /* Message Buffer 31 W Register */
#define CAN_2_CS32           CAN_2.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_2_ID32           CAN_2.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_2_B32            CAN_2.MB[32].DATA.B.R         /* Message Buffer 32 B Register */
#define CAN_2_H32            CAN_2.MB[32].DATA.H.R         /* Message Buffer 32 H Register */
#define CAN_2_W32            CAN_2.MB[32].DATA.W.R         /* Message Buffer 32 W Register */
#define CAN_2_CS33           CAN_2.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_2_ID33           CAN_2.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_2_B33            CAN_2.MB[33].DATA.B.R         /* Message Buffer 33 B Register */
#define CAN_2_H33            CAN_2.MB[33].DATA.H.R         /* Message Buffer 33 H Register */
#define CAN_2_W33            CAN_2.MB[33].DATA.W.R         /* Message Buffer 33 W Register */
#define CAN_2_CS34           CAN_2.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_2_ID34           CAN_2.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_2_B34            CAN_2.MB[34].DATA.B.R         /* Message Buffer 34 B Register */
#define CAN_2_H34            CAN_2.MB[34].DATA.H.R         /* Message Buffer 34 H Register */
#define CAN_2_W34            CAN_2.MB[34].DATA.W.R         /* Message Buffer 34 W Register */
#define CAN_2_CS35           CAN_2.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_2_ID35           CAN_2.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_2_B35            CAN_2.MB[35].DATA.B.R         /* Message Buffer 35 B Register */
#define CAN_2_H35            CAN_2.MB[35].DATA.H.R         /* Message Buffer 35 H Register */
#define CAN_2_W35            CAN_2.MB[35].DATA.W.R         /* Message Buffer 35 W Register */
#define CAN_2_CS36           CAN_2.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_2_ID36           CAN_2.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_2_B36            CAN_2.MB[36].DATA.B.R         /* Message Buffer 36 B Register */
#define CAN_2_H36            CAN_2.MB[36].DATA.H.R         /* Message Buffer 36 H Register */
#define CAN_2_W36            CAN_2.MB[36].DATA.W.R         /* Message Buffer 36 W Register */
#define CAN_2_CS37           CAN_2.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_2_ID37           CAN_2.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_2_B37            CAN_2.MB[37].DATA.B.R         /* Message Buffer 37 B Register */
#define CAN_2_H37            CAN_2.MB[37].DATA.H.R         /* Message Buffer 37 H Register */
#define CAN_2_W37            CAN_2.MB[37].DATA.W.R         /* Message Buffer 37 W Register */
#define CAN_2_CS38           CAN_2.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_2_ID38           CAN_2.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_2_B38            CAN_2.MB[38].DATA.B.R         /* Message Buffer 38 B Register */
#define CAN_2_H38            CAN_2.MB[38].DATA.H.R         /* Message Buffer 38 H Register */
#define CAN_2_W38            CAN_2.MB[38].DATA.W.R         /* Message Buffer 38 W Register */
#define CAN_2_CS39           CAN_2.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_2_ID39           CAN_2.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_2_B39            CAN_2.MB[39].DATA.B.R         /* Message Buffer 39 B Register */
#define CAN_2_H39            CAN_2.MB[39].DATA.H.R         /* Message Buffer 39 H Register */
#define CAN_2_W39            CAN_2.MB[39].DATA.W.R         /* Message Buffer 39 W Register */
#define CAN_2_CS40           CAN_2.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_2_ID40           CAN_2.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_2_B40            CAN_2.MB[40].DATA.B.R         /* Message Buffer 40 B Register */
#define CAN_2_H40            CAN_2.MB[40].DATA.H.R         /* Message Buffer 40 H Register */
#define CAN_2_W40            CAN_2.MB[40].DATA.W.R         /* Message Buffer 40 W Register */
#define CAN_2_CS41           CAN_2.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_2_ID41           CAN_2.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_2_B41            CAN_2.MB[41].DATA.B.R         /* Message Buffer 41 B Register */
#define CAN_2_H41            CAN_2.MB[41].DATA.H.R         /* Message Buffer 41 H Register */
#define CAN_2_W41            CAN_2.MB[41].DATA.W.R         /* Message Buffer 41 W Register */
#define CAN_2_CS42           CAN_2.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_2_ID42           CAN_2.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_2_B42            CAN_2.MB[42].DATA.B.R         /* Message Buffer 42 B Register */
#define CAN_2_H42            CAN_2.MB[42].DATA.H.R         /* Message Buffer 42 H Register */
#define CAN_2_W42            CAN_2.MB[42].DATA.W.R         /* Message Buffer 42 W Register */
#define CAN_2_CS43           CAN_2.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_2_ID43           CAN_2.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_2_B43            CAN_2.MB[43].DATA.B.R         /* Message Buffer 43 B Register */
#define CAN_2_H43            CAN_2.MB[43].DATA.H.R         /* Message Buffer 43 H Register */
#define CAN_2_W43            CAN_2.MB[43].DATA.W.R         /* Message Buffer 43 W Register */
#define CAN_2_CS44           CAN_2.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_2_ID44           CAN_2.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_2_B44            CAN_2.MB[44].DATA.B.R         /* Message Buffer 44 B Register */
#define CAN_2_H44            CAN_2.MB[44].DATA.H.R         /* Message Buffer 44 H Register */
#define CAN_2_W44            CAN_2.MB[44].DATA.W.R         /* Message Buffer 44 W Register */
#define CAN_2_CS45           CAN_2.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_2_ID45           CAN_2.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_2_B45            CAN_2.MB[45].DATA.B.R         /* Message Buffer 45 B Register */
#define CAN_2_H45            CAN_2.MB[45].DATA.H.R         /* Message Buffer 45 H Register */
#define CAN_2_W45            CAN_2.MB[45].DATA.W.R         /* Message Buffer 45 W Register */
#define CAN_2_CS46           CAN_2.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_2_ID46           CAN_2.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_2_B46            CAN_2.MB[46].DATA.B.R         /* Message Buffer 46 B Register */
#define CAN_2_H46            CAN_2.MB[46].DATA.H.R         /* Message Buffer 46 H Register */
#define CAN_2_W46            CAN_2.MB[46].DATA.W.R         /* Message Buffer 46 W Register */
#define CAN_2_CS47           CAN_2.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_2_ID47           CAN_2.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_2_B47            CAN_2.MB[47].DATA.B.R         /* Message Buffer 47 B Register */
#define CAN_2_H47            CAN_2.MB[47].DATA.H.R         /* Message Buffer 47 H Register */
#define CAN_2_W47            CAN_2.MB[47].DATA.W.R         /* Message Buffer 47 W Register */
#define CAN_2_CS48           CAN_2.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_2_ID48           CAN_2.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_2_B48            CAN_2.MB[48].DATA.B.R         /* Message Buffer 48 B Register */
#define CAN_2_H48            CAN_2.MB[48].DATA.H.R         /* Message Buffer 48 H Register */
#define CAN_2_W48            CAN_2.MB[48].DATA.W.R         /* Message Buffer 48 W Register */
#define CAN_2_CS49           CAN_2.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_2_ID49           CAN_2.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_2_B49            CAN_2.MB[49].DATA.B.R         /* Message Buffer 49 B Register */
#define CAN_2_H49            CAN_2.MB[49].DATA.H.R         /* Message Buffer 49 H Register */
#define CAN_2_W49            CAN_2.MB[49].DATA.W.R         /* Message Buffer 49 W Register */
#define CAN_2_CS50           CAN_2.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_2_ID50           CAN_2.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_2_B50            CAN_2.MB[50].DATA.B.R         /* Message Buffer 50 B Register */
#define CAN_2_H50            CAN_2.MB[50].DATA.H.R         /* Message Buffer 50 H Register */
#define CAN_2_W50            CAN_2.MB[50].DATA.W.R         /* Message Buffer 50 W Register */
#define CAN_2_CS51           CAN_2.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_2_ID51           CAN_2.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_2_B51            CAN_2.MB[51].DATA.B.R         /* Message Buffer 51 B Register */
#define CAN_2_H51            CAN_2.MB[51].DATA.H.R         /* Message Buffer 51 H Register */
#define CAN_2_W51            CAN_2.MB[51].DATA.W.R         /* Message Buffer 51 W Register */
#define CAN_2_CS52           CAN_2.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_2_ID52           CAN_2.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_2_B52            CAN_2.MB[52].DATA.B.R         /* Message Buffer 52 B Register */
#define CAN_2_H52            CAN_2.MB[52].DATA.H.R         /* Message Buffer 52 H Register */
#define CAN_2_W52            CAN_2.MB[52].DATA.W.R         /* Message Buffer 52 W Register */
#define CAN_2_CS53           CAN_2.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_2_ID53           CAN_2.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_2_B53            CAN_2.MB[53].DATA.B.R         /* Message Buffer 53 B Register */
#define CAN_2_H53            CAN_2.MB[53].DATA.H.R         /* Message Buffer 53 H Register */
#define CAN_2_W53            CAN_2.MB[53].DATA.W.R         /* Message Buffer 53 W Register */
#define CAN_2_CS54           CAN_2.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_2_ID54           CAN_2.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_2_B54            CAN_2.MB[54].DATA.B.R         /* Message Buffer 54 B Register */
#define CAN_2_H54            CAN_2.MB[54].DATA.H.R         /* Message Buffer 54 H Register */
#define CAN_2_W54            CAN_2.MB[54].DATA.W.R         /* Message Buffer 54 W Register */
#define CAN_2_CS55           CAN_2.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_2_ID55           CAN_2.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_2_B55            CAN_2.MB[55].DATA.B.R         /* Message Buffer 55 B Register */
#define CAN_2_H55            CAN_2.MB[55].DATA.H.R         /* Message Buffer 55 H Register */
#define CAN_2_W55            CAN_2.MB[55].DATA.W.R         /* Message Buffer 55 W Register */
#define CAN_2_CS56           CAN_2.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_2_ID56           CAN_2.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_2_B56            CAN_2.MB[56].DATA.B.R         /* Message Buffer 56 B Register */
#define CAN_2_H56            CAN_2.MB[56].DATA.H.R         /* Message Buffer 56 H Register */
#define CAN_2_W56            CAN_2.MB[56].DATA.W.R         /* Message Buffer 56 W Register */
#define CAN_2_CS57           CAN_2.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_2_ID57           CAN_2.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_2_B57            CAN_2.MB[57].DATA.B.R         /* Message Buffer 57 B Register */
#define CAN_2_H57            CAN_2.MB[57].DATA.H.R         /* Message Buffer 57 H Register */
#define CAN_2_W57            CAN_2.MB[57].DATA.W.R         /* Message Buffer 57 W Register */
#define CAN_2_CS58           CAN_2.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_2_ID58           CAN_2.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_2_B58            CAN_2.MB[58].DATA.B.R         /* Message Buffer 58 B Register */
#define CAN_2_H58            CAN_2.MB[58].DATA.H.R         /* Message Buffer 58 H Register */
#define CAN_2_W58            CAN_2.MB[58].DATA.W.R         /* Message Buffer 58 W Register */
#define CAN_2_CS59           CAN_2.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_2_ID59           CAN_2.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_2_B59            CAN_2.MB[59].DATA.B.R         /* Message Buffer 59 B Register */
#define CAN_2_H59            CAN_2.MB[59].DATA.H.R         /* Message Buffer 59 H Register */
#define CAN_2_W59            CAN_2.MB[59].DATA.W.R         /* Message Buffer 59 W Register */
#define CAN_2_CS60           CAN_2.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_2_ID60           CAN_2.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_2_B60            CAN_2.MB[60].DATA.B.R         /* Message Buffer 60 B Register */
#define CAN_2_H60            CAN_2.MB[60].DATA.H.R         /* Message Buffer 60 H Register */
#define CAN_2_W60            CAN_2.MB[60].DATA.W.R         /* Message Buffer 60 W Register */
#define CAN_2_CS61           CAN_2.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_2_ID61           CAN_2.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_2_B61            CAN_2.MB[61].DATA.B.R         /* Message Buffer 61 B Register */
#define CAN_2_H61            CAN_2.MB[61].DATA.H.R         /* Message Buffer 61 H Register */
#define CAN_2_W61            CAN_2.MB[61].DATA.W.R         /* Message Buffer 61 W Register */
#define CAN_2_CS62           CAN_2.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_2_ID62           CAN_2.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_2_B62            CAN_2.MB[62].DATA.B.R         /* Message Buffer 62 B Register */
#define CAN_2_H62            CAN_2.MB[62].DATA.H.R         /* Message Buffer 62 H Register */
#define CAN_2_W62            CAN_2.MB[62].DATA.W.R         /* Message Buffer 62 W Register */
#define CAN_2_CS63           CAN_2.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_2_ID63           CAN_2.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_2_B63            CAN_2.MB[63].DATA.B.R         /* Message Buffer 63 B Register */
#define CAN_2_H63            CAN_2.MB[63].DATA.H.R         /* Message Buffer 63 H Register */
#define CAN_2_W63            CAN_2.MB[63].DATA.W.R         /* Message Buffer 63 W Register */
#define CAN_2_RXIMR0         CAN_2.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR1         CAN_2.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR2         CAN_2.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR3         CAN_2.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR4         CAN_2.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR5         CAN_2.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR6         CAN_2.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR7         CAN_2.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR8         CAN_2.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR9         CAN_2.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR10        CAN_2.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR11        CAN_2.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR12        CAN_2.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR13        CAN_2.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR14        CAN_2.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR15        CAN_2.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR16        CAN_2.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR17        CAN_2.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR18        CAN_2.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR19        CAN_2.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR20        CAN_2.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR21        CAN_2.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR22        CAN_2.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR23        CAN_2.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR24        CAN_2.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR25        CAN_2.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR26        CAN_2.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR27        CAN_2.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR28        CAN_2.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR29        CAN_2.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR30        CAN_2.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR31        CAN_2.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR32        CAN_2.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR33        CAN_2.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR34        CAN_2.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR35        CAN_2.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR36        CAN_2.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR37        CAN_2.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR38        CAN_2.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR39        CAN_2.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR40        CAN_2.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR41        CAN_2.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR42        CAN_2.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR43        CAN_2.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR44        CAN_2.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR45        CAN_2.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR46        CAN_2.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR47        CAN_2.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR48        CAN_2.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR49        CAN_2.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR50        CAN_2.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR51        CAN_2.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR52        CAN_2.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR53        CAN_2.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR54        CAN_2.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR55        CAN_2.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR56        CAN_2.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR57        CAN_2.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR58        CAN_2.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR59        CAN_2.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR60        CAN_2.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR61        CAN_2.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR62        CAN_2.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR63        CAN_2.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_2_MECR           CAN_2.MECR.R                  /* Memory Error Control Register */
#define CAN_2_ERRIAR         CAN_2.ERRIAR.R                /* Error Injection Address Register */
#define CAN_2_ERRIDPR        CAN_2.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_2_ERRIPPR        CAN_2.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_2_RERRAR         CAN_2.RERRAR.R                /* Error Report Address Register */
#define CAN_2_RERRDR         CAN_2.RERRDR.R                /* Error Report Data Register */
#define CAN_2_RERRSYNR       CAN_2.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_2_ERRSR          CAN_2.ERRSR.R                 /* Error Status Register */

/* CMU */
#define CMU_0_CSR            CMU_0.CSR.R                   /* CMU Control Status Register */
#define CMU_0_FDR            CMU_0.FDR.R                   /* CMU Frequency Display Register */
#define CMU_0_HFREFR         CMU_0.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_0_LFREFR         CMU_0.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_0_ISR            CMU_0.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_0_MDR            CMU_0.MDR.R                   /* CMU Measurement Duration Register */

/* CMU */
#define CMU_1_CSR            CMU_1.CSR.R                   /* CMU Control Status Register */
#define CMU_1_FDR            CMU_1.FDR.R                   /* CMU Frequency Display Register */
#define CMU_1_HFREFR         CMU_1.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_1_LFREFR         CMU_1.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_1_ISR            CMU_1.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_1_MDR            CMU_1.MDR.R                   /* CMU Measurement Duration Register */

/* CMU */
#define CMU_2_CSR            CMU_2.CSR.R                   /* CMU Control Status Register */
#define CMU_2_FDR            CMU_2.FDR.R                   /* CMU Frequency Display Register */
#define CMU_2_HFREFR         CMU_2.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_2_LFREFR         CMU_2.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_2_ISR            CMU_2.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_2_MDR            CMU_2.MDR.R                   /* CMU Measurement Duration Register */

/* CMU */
#define CMU_3_CSR            CMU_3.CSR.R                   /* CMU Control Status Register */
#define CMU_3_FDR            CMU_3.FDR.R                   /* CMU Frequency Display Register */
#define CMU_3_HFREFR         CMU_3.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_3_LFREFR         CMU_3.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_3_ISR            CMU_3.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_3_MDR            CMU_3.MDR.R                   /* CMU Measurement Duration Register */

/* CMU */
#define CMU_4_CSR            CMU_4.CSR.R                   /* CMU Control Status Register */
#define CMU_4_FDR            CMU_4.FDR.R                   /* CMU Frequency Display Register */
#define CMU_4_HFREFR         CMU_4.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_4_LFREFR         CMU_4.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_4_ISR            CMU_4.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_4_MDR            CMU_4.MDR.R                   /* CMU Measurement Duration Register */

/* CRC */
#define CRC_0_CFG1           CRC_0.CHANNEL[0].CFG.R        /* Configuration Register */
#define CRC_0_INP1           CRC_0.CHANNEL[0].INP.R        /* Input Register */
#define CRC_0_CSTAT1         CRC_0.CHANNEL[0].CSTAT.R      /* Current Status Register */
#define CRC_0_OUTP1          CRC_0.CHANNEL[0].OUTP.R       /* Output Register */
#define CRC_0_CFG2           CRC_0.CHANNEL[1].CFG.R        /* Configuration Register */
#define CRC_0_INP2           CRC_0.CHANNEL[1].INP.R        /* Input Register */
#define CRC_0_CSTAT2         CRC_0.CHANNEL[1].CSTAT.R      /* Current Status Register */
#define CRC_0_OUTP2          CRC_0.CHANNEL[1].OUTP.R       /* Output Register */
#define CRC_0_CFG3           CRC_0.CHANNEL[2].CFG.R        /* Configuration Register */
#define CRC_0_INP3           CRC_0.CHANNEL[2].INP.R        /* Input Register */
#define CRC_0_CSTAT3         CRC_0.CHANNEL[2].CSTAT.R      /* Current Status Register */
#define CRC_0_OUTP3          CRC_0.CHANNEL[2].OUTP.R       /* Output Register */

/* CTU */
#define CTU_0_TGSISR         CTU_0.TGSISR.R                /* Trigger Generator Subunit Input Selection Register */
#define CTU_0_TGSCR          CTU_0.TGSCR.R                 /* Trigger Generator Subunit Control Register */
#define CTU_0_T0CR           CTU_0.TCR[0].R                /* Trigger Compare Register */
#define CTU_0_T1CR           CTU_0.TCR[1].R                /* Trigger Compare Register */
#define CTU_0_T2CR           CTU_0.TCR[2].R                /* Trigger Compare Register */
#define CTU_0_T3CR           CTU_0.TCR[3].R                /* Trigger Compare Register */
#define CTU_0_T4CR           CTU_0.TCR[4].R                /* Trigger Compare Register */
#define CTU_0_T5CR           CTU_0.TCR[5].R                /* Trigger Compare Register */
#define CTU_0_T6CR           CTU_0.TCR[6].R                /* Trigger Compare Register */
#define CTU_0_T7CR           CTU_0.TCR[7].R                /* Trigger Compare Register */
#define CTU_0_TGSCCR         CTU_0.TGSCCR.R                /* TGS Counter Compare Register */
#define CTU_0_TGSCRR         CTU_0.TGSCRR.R                /* TGS Counter Reload Register */
#define CTU_0_CLCR1          CTU_0.CLCR1.R                 /* Commands List Control Register 1 */
#define CTU_0_CLCR2          CTU_0.CLCR2.R                 /* Commands List Control Register 2 */
#define CTU_0_THCR1          CTU_0.THCR1.R                 /* Trigger Handler Control Register 1 */
#define CTU_0_THCR2          CTU_0.THCR2.R                 /* Trigger Handler Control Register 2 */
#define CTU_0_CLR_A_1        CTU_0.CLR[0].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_1        CTU_0.CLR[0].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_1        CTU_0.CLR[0].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_2        CTU_0.CLR[1].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_2        CTU_0.CLR[1].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_2        CTU_0.CLR[1].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_3        CTU_0.CLR[2].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_3        CTU_0.CLR[2].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_3        CTU_0.CLR[2].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_4        CTU_0.CLR[3].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_4        CTU_0.CLR[3].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_4        CTU_0.CLR[3].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_5        CTU_0.CLR[4].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_5        CTU_0.CLR[4].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_5        CTU_0.CLR[4].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_6        CTU_0.CLR[5].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_6        CTU_0.CLR[5].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_6        CTU_0.CLR[5].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_7        CTU_0.CLR[6].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_7        CTU_0.CLR[6].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_7        CTU_0.CLR[6].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_8        CTU_0.CLR[7].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_8        CTU_0.CLR[7].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_8        CTU_0.CLR[7].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_9        CTU_0.CLR[8].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_9        CTU_0.CLR[8].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_9        CTU_0.CLR[8].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_10       CTU_0.CLR[9].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_10       CTU_0.CLR[9].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_10       CTU_0.CLR[9].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_11       CTU_0.CLR[10].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_11       CTU_0.CLR[10].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_11       CTU_0.CLR[10].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_12       CTU_0.CLR[11].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_12       CTU_0.CLR[11].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_12       CTU_0.CLR[11].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_13       CTU_0.CLR[12].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_13       CTU_0.CLR[12].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_13       CTU_0.CLR[12].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_14       CTU_0.CLR[13].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_14       CTU_0.CLR[13].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_14       CTU_0.CLR[13].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_15       CTU_0.CLR[14].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_15       CTU_0.CLR[14].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_15       CTU_0.CLR[14].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_16       CTU_0.CLR[15].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_16       CTU_0.CLR[15].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_16       CTU_0.CLR[15].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_17       CTU_0.CLR[16].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_17       CTU_0.CLR[16].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_17       CTU_0.CLR[16].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_18       CTU_0.CLR[17].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_18       CTU_0.CLR[17].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_18       CTU_0.CLR[17].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_19       CTU_0.CLR[18].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_19       CTU_0.CLR[18].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_19       CTU_0.CLR[18].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_20       CTU_0.CLR[19].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_20       CTU_0.CLR[19].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_20       CTU_0.CLR[19].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_21       CTU_0.CLR[20].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_21       CTU_0.CLR[20].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_21       CTU_0.CLR[20].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_22       CTU_0.CLR[21].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_22       CTU_0.CLR[21].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_22       CTU_0.CLR[21].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_23       CTU_0.CLR[22].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_23       CTU_0.CLR[22].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_23       CTU_0.CLR[22].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_24       CTU_0.CLR[23].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_24       CTU_0.CLR[23].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_24       CTU_0.CLR[23].C.R             /* Command List Register C for self-test commands */
#define CTU_0_FDCR           CTU_0.FDCR.R                  /* FIFO DMA Control Register */
#define CTU_0_FCR            CTU_0.FCR.R                   /* FIFO Control Register */
#define CTU_0_FTH            CTU_0.FTH.R                   /* FIFO Threshold Register */
#define CTU_0_FST            CTU_0.FST.R                   /* FIFO Status Register */
#define CTU_0_FR0            CTU_0.FR[0].R                 /* FIFO Right Aligned Data Register */
#define CTU_0_FR1            CTU_0.FR[1].R                 /* FIFO Right Aligned Data Register */
#define CTU_0_FR2            CTU_0.FR[2].R                 /* FIFO Right Aligned Data Register */
#define CTU_0_FR3            CTU_0.FR[3].R                 /* FIFO Right Aligned Data Register */
#define CTU_0_FL0            CTU_0.FL[0].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_0_FL1            CTU_0.FL[1].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_0_FL2            CTU_0.FL[2].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_0_FL3            CTU_0.FL[3].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_0_EFR            CTU_0.EFR.R                   /* Error Flag Register */
#define CTU_0_IFR            CTU_0.IFR.R                   /* Interrupt Flag Register */
#define CTU_0_IR             CTU_0.IR.R                    /* Interrupt/DMA Register */
#define CTU_0_COTR           CTU_0.COTR.R                  /* Control ON Time Register */
#define CTU_0_CR             CTU_0.CR.R                    /* Control Register */
#define CTU_0_DFR            CTU_0.DFR.R                   /* Digital Filter Register */
#define CTU_0_EXPAR          CTU_0.EXPAR.R                 /* Expected Value A Register */
#define CTU_0_EXPBR          CTU_0.EXPBR.R                 /* Expected Value B Register */
#define CTU_0_CNTRNGR        CTU_0.CNTRNGR.R               /* Counter Range Register */
#define CTU_0_LISTCSR        CTU_0.LISTCSR.R               /* List Control/Status Register */

/* CTU */
#define CTU_1_TGSISR         CTU_1.TGSISR.R                /* Trigger Generator Subunit Input Selection Register */
#define CTU_1_TGSCR          CTU_1.TGSCR.R                 /* Trigger Generator Subunit Control Register */
#define CTU_1_T0CR           CTU_1.TCR[0].R                /* Trigger Compare Register */
#define CTU_1_T1CR           CTU_1.TCR[1].R                /* Trigger Compare Register */
#define CTU_1_T2CR           CTU_1.TCR[2].R                /* Trigger Compare Register */
#define CTU_1_T3CR           CTU_1.TCR[3].R                /* Trigger Compare Register */
#define CTU_1_T4CR           CTU_1.TCR[4].R                /* Trigger Compare Register */
#define CTU_1_T5CR           CTU_1.TCR[5].R                /* Trigger Compare Register */
#define CTU_1_T6CR           CTU_1.TCR[6].R                /* Trigger Compare Register */
#define CTU_1_T7CR           CTU_1.TCR[7].R                /* Trigger Compare Register */
#define CTU_1_TGSCCR         CTU_1.TGSCCR.R                /* TGS Counter Compare Register */
#define CTU_1_TGSCRR         CTU_1.TGSCRR.R                /* TGS Counter Reload Register */
#define CTU_1_CLCR1          CTU_1.CLCR1.R                 /* Commands List Control Register 1 */
#define CTU_1_CLCR2          CTU_1.CLCR2.R                 /* Commands List Control Register 2 */
#define CTU_1_THCR1          CTU_1.THCR1.R                 /* Trigger Handler Control Register 1 */
#define CTU_1_THCR2          CTU_1.THCR2.R                 /* Trigger Handler Control Register 2 */
#define CTU_1_CLR_A_1        CTU_1.CLR[0].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_1        CTU_1.CLR[0].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_1        CTU_1.CLR[0].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_2        CTU_1.CLR[1].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_2        CTU_1.CLR[1].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_2        CTU_1.CLR[1].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_3        CTU_1.CLR[2].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_3        CTU_1.CLR[2].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_3        CTU_1.CLR[2].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_4        CTU_1.CLR[3].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_4        CTU_1.CLR[3].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_4        CTU_1.CLR[3].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_5        CTU_1.CLR[4].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_5        CTU_1.CLR[4].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_5        CTU_1.CLR[4].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_6        CTU_1.CLR[5].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_6        CTU_1.CLR[5].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_6        CTU_1.CLR[5].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_7        CTU_1.CLR[6].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_7        CTU_1.CLR[6].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_7        CTU_1.CLR[6].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_8        CTU_1.CLR[7].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_8        CTU_1.CLR[7].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_8        CTU_1.CLR[7].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_9        CTU_1.CLR[8].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_9        CTU_1.CLR[8].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_9        CTU_1.CLR[8].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_10       CTU_1.CLR[9].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_10       CTU_1.CLR[9].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_10       CTU_1.CLR[9].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_11       CTU_1.CLR[10].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_11       CTU_1.CLR[10].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_11       CTU_1.CLR[10].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_12       CTU_1.CLR[11].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_12       CTU_1.CLR[11].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_12       CTU_1.CLR[11].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_13       CTU_1.CLR[12].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_13       CTU_1.CLR[12].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_13       CTU_1.CLR[12].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_14       CTU_1.CLR[13].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_14       CTU_1.CLR[13].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_14       CTU_1.CLR[13].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_15       CTU_1.CLR[14].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_15       CTU_1.CLR[14].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_15       CTU_1.CLR[14].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_16       CTU_1.CLR[15].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_16       CTU_1.CLR[15].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_16       CTU_1.CLR[15].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_17       CTU_1.CLR[16].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_17       CTU_1.CLR[16].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_17       CTU_1.CLR[16].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_18       CTU_1.CLR[17].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_18       CTU_1.CLR[17].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_18       CTU_1.CLR[17].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_19       CTU_1.CLR[18].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_19       CTU_1.CLR[18].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_19       CTU_1.CLR[18].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_20       CTU_1.CLR[19].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_20       CTU_1.CLR[19].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_20       CTU_1.CLR[19].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_21       CTU_1.CLR[20].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_21       CTU_1.CLR[20].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_21       CTU_1.CLR[20].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_22       CTU_1.CLR[21].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_22       CTU_1.CLR[21].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_22       CTU_1.CLR[21].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_23       CTU_1.CLR[22].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_23       CTU_1.CLR[22].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_23       CTU_1.CLR[22].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_24       CTU_1.CLR[23].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_24       CTU_1.CLR[23].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_24       CTU_1.CLR[23].C.R             /* Command List Register C for self-test commands */
#define CTU_1_FDCR           CTU_1.FDCR.R                  /* FIFO DMA Control Register */
#define CTU_1_FCR            CTU_1.FCR.R                   /* FIFO Control Register */
#define CTU_1_FTH            CTU_1.FTH.R                   /* FIFO Threshold Register */
#define CTU_1_FST            CTU_1.FST.R                   /* FIFO Status Register */
#define CTU_1_FR0            CTU_1.FR[0].R                 /* FIFO Right Aligned Data Register */
#define CTU_1_FR1            CTU_1.FR[1].R                 /* FIFO Right Aligned Data Register */
#define CTU_1_FR2            CTU_1.FR[2].R                 /* FIFO Right Aligned Data Register */
#define CTU_1_FR3            CTU_1.FR[3].R                 /* FIFO Right Aligned Data Register */
#define CTU_1_FL0            CTU_1.FL[0].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_1_FL1            CTU_1.FL[1].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_1_FL2            CTU_1.FL[2].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_1_FL3            CTU_1.FL[3].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_1_EFR            CTU_1.EFR.R                   /* Error Flag Register */
#define CTU_1_IFR            CTU_1.IFR.R                   /* Interrupt Flag Register */
#define CTU_1_IR             CTU_1.IR.R                    /* Interrupt/DMA Register */
#define CTU_1_COTR           CTU_1.COTR.R                  /* Control ON Time Register */
#define CTU_1_CR             CTU_1.CR.R                    /* Control Register */
#define CTU_1_DFR            CTU_1.DFR.R                   /* Digital Filter Register */
#define CTU_1_EXPAR          CTU_1.EXPAR.R                 /* Expected Value A Register */
#define CTU_1_EXPBR          CTU_1.EXPBR.R                 /* Expected Value B Register */
#define CTU_1_CNTRNGR        CTU_1.CNTRNGR.R               /* Counter Range Register */
#define CTU_1_LISTCSR        CTU_1.LISTCSR.R               /* List Control/Status Register */

/* DCL */
#define DCL_IPS0             DCL.IPS0.R                    /* Different Clock register */

/* DMAMUX */
#define DMAMUX_0_CHCFG0      DMAMUX_0.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG1      DMAMUX_0.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG2      DMAMUX_0.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG3      DMAMUX_0.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG4      DMAMUX_0.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG5      DMAMUX_0.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG6      DMAMUX_0.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG7      DMAMUX_0.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG8      DMAMUX_0.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG9      DMAMUX_0.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG10     DMAMUX_0.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG11     DMAMUX_0.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG12     DMAMUX_0.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG13     DMAMUX_0.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG14     DMAMUX_0.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG15     DMAMUX_0.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_1_CHCFG0      DMAMUX_1.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG1      DMAMUX_1.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG2      DMAMUX_1.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG3      DMAMUX_1.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG4      DMAMUX_1.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG5      DMAMUX_1.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG6      DMAMUX_1.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG7      DMAMUX_1.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG8      DMAMUX_1.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG9      DMAMUX_1.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG10     DMAMUX_1.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG11     DMAMUX_1.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG12     DMAMUX_1.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG13     DMAMUX_1.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG14     DMAMUX_1.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG15     DMAMUX_1.CHCFG[15].R          /* Channel Configuration register */

/* DMA */
#define DMA_0_CR             DMA_0.CR.R                    /* Control Register */
#define DMA_0_ES             DMA_0.ES.R                    /* Error Status Register */
#define DMA_0_ERQ            DMA_0.ERQ.R                   /* Enable Request Register */
#define DMA_0_EEI            DMA_0.EEI.R                   /* Enable Error Interrupt Register */
#define DMA_0_SERQ           DMA_0.SERQ.R                  /* Set Enable Request Register */
#define DMA_0_CERQ           DMA_0.CERQ.R                  /* Clear Enable Request Register */
#define DMA_0_SEEI           DMA_0.SEEI.R                  /* Set Enable Error Interrupt Register */
#define DMA_0_CEEI           DMA_0.CEEI.R                  /* Clear Enable Error Interrupt Register */
#define DMA_0_CINT           DMA_0.CINT.R                  /* Clear Interrupt Request Register */
#define DMA_0_CERR           DMA_0.CERR.R                  /* Clear Error Register */
#define DMA_0_SSRT           DMA_0.SSRT.R                  /* Set START Bit Register */
#define DMA_0_CDNE           DMA_0.CDNE.R                  /* Clear DONE Status Bit Register */
#define DMA_0_INT            DMA_0.INT.R                   /* Interrupt Request Register */
#define DMA_0_ERR            DMA_0.ERR.R                   /* Error Register */
#define DMA_0_HRS            DMA_0.HRS.R                   /* Hardware Request Status Register */
#define DMA_0_DCHPRI0        DMA_0.DCHPRI[0].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI1        DMA_0.DCHPRI[1].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI2        DMA_0.DCHPRI[2].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI3        DMA_0.DCHPRI[3].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI4        DMA_0.DCHPRI[4].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI5        DMA_0.DCHPRI[5].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI6        DMA_0.DCHPRI[6].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI7        DMA_0.DCHPRI[7].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI8        DMA_0.DCHPRI[8].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI9        DMA_0.DCHPRI[9].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI10       DMA_0.DCHPRI[10].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI11       DMA_0.DCHPRI[11].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI12       DMA_0.DCHPRI[12].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI13       DMA_0.DCHPRI[13].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI14       DMA_0.DCHPRI[14].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI15       DMA_0.DCHPRI[15].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI16       DMA_0.DCHPRI[16].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI17       DMA_0.DCHPRI[17].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI18       DMA_0.DCHPRI[18].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI19       DMA_0.DCHPRI[19].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI20       DMA_0.DCHPRI[20].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI21       DMA_0.DCHPRI[21].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI22       DMA_0.DCHPRI[22].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI23       DMA_0.DCHPRI[23].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI24       DMA_0.DCHPRI[24].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI25       DMA_0.DCHPRI[25].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI26       DMA_0.DCHPRI[26].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI27       DMA_0.DCHPRI[27].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI28       DMA_0.DCHPRI[28].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI29       DMA_0.DCHPRI[29].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI30       DMA_0.DCHPRI[30].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI31       DMA_0.DCHPRI[31].R            /* Channel n Priority Register */
#define DMA_0_DCHMID0        DMA_0.DCHMID[0].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID1        DMA_0.DCHMID[1].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID2        DMA_0.DCHMID[2].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID3        DMA_0.DCHMID[3].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID4        DMA_0.DCHMID[4].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID5        DMA_0.DCHMID[5].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID6        DMA_0.DCHMID[6].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID7        DMA_0.DCHMID[7].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID8        DMA_0.DCHMID[8].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID9        DMA_0.DCHMID[9].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID10       DMA_0.DCHMID[10].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID11       DMA_0.DCHMID[11].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID12       DMA_0.DCHMID[12].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID13       DMA_0.DCHMID[13].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID14       DMA_0.DCHMID[14].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID15       DMA_0.DCHMID[15].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID16       DMA_0.DCHMID[16].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID17       DMA_0.DCHMID[17].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID18       DMA_0.DCHMID[18].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID19       DMA_0.DCHMID[19].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID20       DMA_0.DCHMID[20].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID21       DMA_0.DCHMID[21].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID22       DMA_0.DCHMID[22].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID23       DMA_0.DCHMID[23].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID24       DMA_0.DCHMID[24].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID25       DMA_0.DCHMID[25].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID26       DMA_0.DCHMID[26].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID27       DMA_0.DCHMID[27].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID28       DMA_0.DCHMID[28].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID29       DMA_0.DCHMID[29].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID30       DMA_0.DCHMID[30].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID31       DMA_0.DCHMID[31].R            /* Channel n Master ID Register */
#define DMA_0_TCD0_SADDR     DMA_0.TCD[0].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD0_ATTR      DMA_0.TCD[0].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD0_SOFF      DMA_0.TCD[0].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD0_NBYTES_MLNO DMA_0.TCD[0].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD0_NBYTES_MLOFFNO DMA_0.TCD[0].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD0_NBYTES_MLOFFYES DMA_0.TCD[0].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD0_SLAST     DMA_0.TCD[0].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD0_DADDR     DMA_0.TCD[0].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD0_CITER_ELINKNO DMA_0.TCD[0].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD0_CITER_ELINKYES DMA_0.TCD[0].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD0_DOFF      DMA_0.TCD[0].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD0_DLASTSGA  DMA_0.TCD[0].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD0_BITER_ELINKNO DMA_0.TCD[0].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD0_BITER_ELINKYES DMA_0.TCD[0].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD0_CSR       DMA_0.TCD[0].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD1_SADDR     DMA_0.TCD[1].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD1_ATTR      DMA_0.TCD[1].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD1_SOFF      DMA_0.TCD[1].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD1_NBYTES_MLNO DMA_0.TCD[1].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD1_NBYTES_MLOFFNO DMA_0.TCD[1].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD1_NBYTES_MLOFFYES DMA_0.TCD[1].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD1_SLAST     DMA_0.TCD[1].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD1_DADDR     DMA_0.TCD[1].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD1_CITER_ELINKNO DMA_0.TCD[1].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD1_CITER_ELINKYES DMA_0.TCD[1].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD1_DOFF      DMA_0.TCD[1].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD1_DLASTSGA  DMA_0.TCD[1].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD1_BITER_ELINKNO DMA_0.TCD[1].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD1_BITER_ELINKYES DMA_0.TCD[1].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD1_CSR       DMA_0.TCD[1].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD2_SADDR     DMA_0.TCD[2].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD2_ATTR      DMA_0.TCD[2].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD2_SOFF      DMA_0.TCD[2].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD2_NBYTES_MLNO DMA_0.TCD[2].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD2_NBYTES_MLOFFNO DMA_0.TCD[2].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD2_NBYTES_MLOFFYES DMA_0.TCD[2].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD2_SLAST     DMA_0.TCD[2].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD2_DADDR     DMA_0.TCD[2].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD2_CITER_ELINKNO DMA_0.TCD[2].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD2_CITER_ELINKYES DMA_0.TCD[2].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD2_DOFF      DMA_0.TCD[2].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD2_DLASTSGA  DMA_0.TCD[2].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD2_BITER_ELINKNO DMA_0.TCD[2].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD2_BITER_ELINKYES DMA_0.TCD[2].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD2_CSR       DMA_0.TCD[2].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD3_SADDR     DMA_0.TCD[3].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD3_ATTR      DMA_0.TCD[3].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD3_SOFF      DMA_0.TCD[3].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD3_NBYTES_MLNO DMA_0.TCD[3].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD3_NBYTES_MLOFFNO DMA_0.TCD[3].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD3_NBYTES_MLOFFYES DMA_0.TCD[3].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD3_SLAST     DMA_0.TCD[3].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD3_DADDR     DMA_0.TCD[3].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD3_CITER_ELINKNO DMA_0.TCD[3].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD3_CITER_ELINKYES DMA_0.TCD[3].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD3_DOFF      DMA_0.TCD[3].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD3_DLASTSGA  DMA_0.TCD[3].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD3_BITER_ELINKNO DMA_0.TCD[3].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD3_BITER_ELINKYES DMA_0.TCD[3].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD3_CSR       DMA_0.TCD[3].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD4_SADDR     DMA_0.TCD[4].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD4_ATTR      DMA_0.TCD[4].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD4_SOFF      DMA_0.TCD[4].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD4_NBYTES_MLNO DMA_0.TCD[4].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD4_NBYTES_MLOFFNO DMA_0.TCD[4].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD4_NBYTES_MLOFFYES DMA_0.TCD[4].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD4_SLAST     DMA_0.TCD[4].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD4_DADDR     DMA_0.TCD[4].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD4_CITER_ELINKNO DMA_0.TCD[4].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD4_CITER_ELINKYES DMA_0.TCD[4].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD4_DOFF      DMA_0.TCD[4].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD4_DLASTSGA  DMA_0.TCD[4].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD4_BITER_ELINKNO DMA_0.TCD[4].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD4_BITER_ELINKYES DMA_0.TCD[4].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD4_CSR       DMA_0.TCD[4].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD5_SADDR     DMA_0.TCD[5].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD5_ATTR      DMA_0.TCD[5].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD5_SOFF      DMA_0.TCD[5].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD5_NBYTES_MLNO DMA_0.TCD[5].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD5_NBYTES_MLOFFNO DMA_0.TCD[5].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD5_NBYTES_MLOFFYES DMA_0.TCD[5].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD5_SLAST     DMA_0.TCD[5].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD5_DADDR     DMA_0.TCD[5].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD5_CITER_ELINKNO DMA_0.TCD[5].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD5_CITER_ELINKYES DMA_0.TCD[5].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD5_DOFF      DMA_0.TCD[5].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD5_DLASTSGA  DMA_0.TCD[5].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD5_BITER_ELINKNO DMA_0.TCD[5].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD5_BITER_ELINKYES DMA_0.TCD[5].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD5_CSR       DMA_0.TCD[5].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD6_SADDR     DMA_0.TCD[6].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD6_ATTR      DMA_0.TCD[6].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD6_SOFF      DMA_0.TCD[6].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD6_NBYTES_MLNO DMA_0.TCD[6].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD6_NBYTES_MLOFFNO DMA_0.TCD[6].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD6_NBYTES_MLOFFYES DMA_0.TCD[6].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD6_SLAST     DMA_0.TCD[6].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD6_DADDR     DMA_0.TCD[6].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD6_CITER_ELINKNO DMA_0.TCD[6].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD6_CITER_ELINKYES DMA_0.TCD[6].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD6_DOFF      DMA_0.TCD[6].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD6_DLASTSGA  DMA_0.TCD[6].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD6_BITER_ELINKNO DMA_0.TCD[6].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD6_BITER_ELINKYES DMA_0.TCD[6].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD6_CSR       DMA_0.TCD[6].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD7_SADDR     DMA_0.TCD[7].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD7_ATTR      DMA_0.TCD[7].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD7_SOFF      DMA_0.TCD[7].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD7_NBYTES_MLNO DMA_0.TCD[7].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD7_NBYTES_MLOFFNO DMA_0.TCD[7].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD7_NBYTES_MLOFFYES DMA_0.TCD[7].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD7_SLAST     DMA_0.TCD[7].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD7_DADDR     DMA_0.TCD[7].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD7_CITER_ELINKNO DMA_0.TCD[7].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD7_CITER_ELINKYES DMA_0.TCD[7].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD7_DOFF      DMA_0.TCD[7].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD7_DLASTSGA  DMA_0.TCD[7].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD7_BITER_ELINKNO DMA_0.TCD[7].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD7_BITER_ELINKYES DMA_0.TCD[7].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD7_CSR       DMA_0.TCD[7].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD8_SADDR     DMA_0.TCD[8].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD8_ATTR      DMA_0.TCD[8].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD8_SOFF      DMA_0.TCD[8].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD8_NBYTES_MLNO DMA_0.TCD[8].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD8_NBYTES_MLOFFNO DMA_0.TCD[8].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD8_NBYTES_MLOFFYES DMA_0.TCD[8].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD8_SLAST     DMA_0.TCD[8].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD8_DADDR     DMA_0.TCD[8].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD8_CITER_ELINKNO DMA_0.TCD[8].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD8_CITER_ELINKYES DMA_0.TCD[8].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD8_DOFF      DMA_0.TCD[8].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD8_DLASTSGA  DMA_0.TCD[8].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD8_BITER_ELINKNO DMA_0.TCD[8].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD8_BITER_ELINKYES DMA_0.TCD[8].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD8_CSR       DMA_0.TCD[8].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD9_SADDR     DMA_0.TCD[9].SADDR.R          /* TCD Source Address */
#define DMA_0_TCD9_ATTR      DMA_0.TCD[9].ATTR.R           /* TCD Transfer Attributes */
#define DMA_0_TCD9_SOFF      DMA_0.TCD[9].SOFF.R           /* TCD Signed Source Address Offset */
#define DMA_0_TCD9_NBYTES_MLNO DMA_0.TCD[9].NBYTES.MLNO.R  /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD9_NBYTES_MLOFFNO DMA_0.TCD[9].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD9_NBYTES_MLOFFYES DMA_0.TCD[9].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD9_SLAST     DMA_0.TCD[9].SLAST.R          /* TCD Last Source Address Adjustment */
#define DMA_0_TCD9_DADDR     DMA_0.TCD[9].DADDR.R          /* TCD Destination Address */
#define DMA_0_TCD9_CITER_ELINKNO DMA_0.TCD[9].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD9_CITER_ELINKYES DMA_0.TCD[9].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD9_DOFF      DMA_0.TCD[9].DOFF.R           /* TCD Signed Destination Address Offset */
#define DMA_0_TCD9_DLASTSGA  DMA_0.TCD[9].DLASTSGA.R       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD9_BITER_ELINKNO DMA_0.TCD[9].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD9_BITER_ELINKYES DMA_0.TCD[9].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD9_CSR       DMA_0.TCD[9].CSR.R            /* TCD Control and Status */
#define DMA_0_TCD10_SADDR    DMA_0.TCD[10].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD10_ATTR     DMA_0.TCD[10].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD10_SOFF     DMA_0.TCD[10].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD10_NBYTES_MLNO DMA_0.TCD[10].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD10_NBYTES_MLOFFNO DMA_0.TCD[10].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD10_NBYTES_MLOFFYES DMA_0.TCD[10].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD10_SLAST    DMA_0.TCD[10].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD10_DADDR    DMA_0.TCD[10].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD10_CITER_ELINKNO DMA_0.TCD[10].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD10_CITER_ELINKYES DMA_0.TCD[10].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD10_DOFF     DMA_0.TCD[10].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD10_DLASTSGA DMA_0.TCD[10].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD10_BITER_ELINKNO DMA_0.TCD[10].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD10_BITER_ELINKYES DMA_0.TCD[10].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD10_CSR      DMA_0.TCD[10].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD11_SADDR    DMA_0.TCD[11].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD11_ATTR     DMA_0.TCD[11].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD11_SOFF     DMA_0.TCD[11].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD11_NBYTES_MLNO DMA_0.TCD[11].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD11_NBYTES_MLOFFNO DMA_0.TCD[11].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD11_NBYTES_MLOFFYES DMA_0.TCD[11].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD11_SLAST    DMA_0.TCD[11].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD11_DADDR    DMA_0.TCD[11].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD11_CITER_ELINKNO DMA_0.TCD[11].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD11_CITER_ELINKYES DMA_0.TCD[11].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD11_DOFF     DMA_0.TCD[11].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD11_DLASTSGA DMA_0.TCD[11].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD11_BITER_ELINKNO DMA_0.TCD[11].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD11_BITER_ELINKYES DMA_0.TCD[11].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD11_CSR      DMA_0.TCD[11].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD12_SADDR    DMA_0.TCD[12].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD12_ATTR     DMA_0.TCD[12].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD12_SOFF     DMA_0.TCD[12].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD12_NBYTES_MLNO DMA_0.TCD[12].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD12_NBYTES_MLOFFNO DMA_0.TCD[12].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD12_NBYTES_MLOFFYES DMA_0.TCD[12].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD12_SLAST    DMA_0.TCD[12].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD12_DADDR    DMA_0.TCD[12].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD12_CITER_ELINKNO DMA_0.TCD[12].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD12_CITER_ELINKYES DMA_0.TCD[12].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD12_DOFF     DMA_0.TCD[12].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD12_DLASTSGA DMA_0.TCD[12].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD12_BITER_ELINKNO DMA_0.TCD[12].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD12_BITER_ELINKYES DMA_0.TCD[12].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD12_CSR      DMA_0.TCD[12].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD13_SADDR    DMA_0.TCD[13].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD13_ATTR     DMA_0.TCD[13].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD13_SOFF     DMA_0.TCD[13].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD13_NBYTES_MLNO DMA_0.TCD[13].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD13_NBYTES_MLOFFNO DMA_0.TCD[13].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD13_NBYTES_MLOFFYES DMA_0.TCD[13].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD13_SLAST    DMA_0.TCD[13].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD13_DADDR    DMA_0.TCD[13].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD13_CITER_ELINKNO DMA_0.TCD[13].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD13_CITER_ELINKYES DMA_0.TCD[13].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD13_DOFF     DMA_0.TCD[13].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD13_DLASTSGA DMA_0.TCD[13].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD13_BITER_ELINKNO DMA_0.TCD[13].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD13_BITER_ELINKYES DMA_0.TCD[13].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD13_CSR      DMA_0.TCD[13].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD14_SADDR    DMA_0.TCD[14].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD14_ATTR     DMA_0.TCD[14].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD14_SOFF     DMA_0.TCD[14].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD14_NBYTES_MLNO DMA_0.TCD[14].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD14_NBYTES_MLOFFNO DMA_0.TCD[14].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD14_NBYTES_MLOFFYES DMA_0.TCD[14].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD14_SLAST    DMA_0.TCD[14].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD14_DADDR    DMA_0.TCD[14].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD14_CITER_ELINKNO DMA_0.TCD[14].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD14_CITER_ELINKYES DMA_0.TCD[14].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD14_DOFF     DMA_0.TCD[14].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD14_DLASTSGA DMA_0.TCD[14].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD14_BITER_ELINKNO DMA_0.TCD[14].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD14_BITER_ELINKYES DMA_0.TCD[14].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD14_CSR      DMA_0.TCD[14].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD15_SADDR    DMA_0.TCD[15].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD15_ATTR     DMA_0.TCD[15].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD15_SOFF     DMA_0.TCD[15].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD15_NBYTES_MLNO DMA_0.TCD[15].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD15_NBYTES_MLOFFNO DMA_0.TCD[15].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD15_NBYTES_MLOFFYES DMA_0.TCD[15].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD15_SLAST    DMA_0.TCD[15].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD15_DADDR    DMA_0.TCD[15].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD15_CITER_ELINKNO DMA_0.TCD[15].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD15_CITER_ELINKYES DMA_0.TCD[15].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD15_DOFF     DMA_0.TCD[15].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD15_DLASTSGA DMA_0.TCD[15].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD15_BITER_ELINKNO DMA_0.TCD[15].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD15_BITER_ELINKYES DMA_0.TCD[15].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD15_CSR      DMA_0.TCD[15].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD16_SADDR    DMA_0.TCD[16].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD16_ATTR     DMA_0.TCD[16].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD16_SOFF     DMA_0.TCD[16].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD16_NBYTES_MLNO DMA_0.TCD[16].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD16_NBYTES_MLOFFNO DMA_0.TCD[16].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD16_NBYTES_MLOFFYES DMA_0.TCD[16].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD16_SLAST    DMA_0.TCD[16].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD16_DADDR    DMA_0.TCD[16].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD16_CITER_ELINKNO DMA_0.TCD[16].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD16_CITER_ELINKYES DMA_0.TCD[16].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD16_DOFF     DMA_0.TCD[16].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD16_DLASTSGA DMA_0.TCD[16].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD16_BITER_ELINKNO DMA_0.TCD[16].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD16_BITER_ELINKYES DMA_0.TCD[16].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD16_CSR      DMA_0.TCD[16].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD17_SADDR    DMA_0.TCD[17].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD17_ATTR     DMA_0.TCD[17].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD17_SOFF     DMA_0.TCD[17].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD17_NBYTES_MLNO DMA_0.TCD[17].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD17_NBYTES_MLOFFNO DMA_0.TCD[17].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD17_NBYTES_MLOFFYES DMA_0.TCD[17].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD17_SLAST    DMA_0.TCD[17].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD17_DADDR    DMA_0.TCD[17].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD17_CITER_ELINKNO DMA_0.TCD[17].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD17_CITER_ELINKYES DMA_0.TCD[17].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD17_DOFF     DMA_0.TCD[17].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD17_DLASTSGA DMA_0.TCD[17].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD17_BITER_ELINKNO DMA_0.TCD[17].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD17_BITER_ELINKYES DMA_0.TCD[17].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD17_CSR      DMA_0.TCD[17].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD18_SADDR    DMA_0.TCD[18].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD18_ATTR     DMA_0.TCD[18].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD18_SOFF     DMA_0.TCD[18].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD18_NBYTES_MLNO DMA_0.TCD[18].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD18_NBYTES_MLOFFNO DMA_0.TCD[18].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD18_NBYTES_MLOFFYES DMA_0.TCD[18].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD18_SLAST    DMA_0.TCD[18].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD18_DADDR    DMA_0.TCD[18].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD18_CITER_ELINKNO DMA_0.TCD[18].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD18_CITER_ELINKYES DMA_0.TCD[18].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD18_DOFF     DMA_0.TCD[18].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD18_DLASTSGA DMA_0.TCD[18].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD18_BITER_ELINKNO DMA_0.TCD[18].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD18_BITER_ELINKYES DMA_0.TCD[18].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD18_CSR      DMA_0.TCD[18].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD19_SADDR    DMA_0.TCD[19].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD19_ATTR     DMA_0.TCD[19].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD19_SOFF     DMA_0.TCD[19].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD19_NBYTES_MLNO DMA_0.TCD[19].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD19_NBYTES_MLOFFNO DMA_0.TCD[19].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD19_NBYTES_MLOFFYES DMA_0.TCD[19].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD19_SLAST    DMA_0.TCD[19].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD19_DADDR    DMA_0.TCD[19].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD19_CITER_ELINKNO DMA_0.TCD[19].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD19_CITER_ELINKYES DMA_0.TCD[19].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD19_DOFF     DMA_0.TCD[19].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD19_DLASTSGA DMA_0.TCD[19].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD19_BITER_ELINKNO DMA_0.TCD[19].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD19_BITER_ELINKYES DMA_0.TCD[19].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD19_CSR      DMA_0.TCD[19].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD20_SADDR    DMA_0.TCD[20].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD20_ATTR     DMA_0.TCD[20].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD20_SOFF     DMA_0.TCD[20].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD20_NBYTES_MLNO DMA_0.TCD[20].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD20_NBYTES_MLOFFNO DMA_0.TCD[20].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD20_NBYTES_MLOFFYES DMA_0.TCD[20].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD20_SLAST    DMA_0.TCD[20].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD20_DADDR    DMA_0.TCD[20].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD20_CITER_ELINKNO DMA_0.TCD[20].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD20_CITER_ELINKYES DMA_0.TCD[20].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD20_DOFF     DMA_0.TCD[20].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD20_DLASTSGA DMA_0.TCD[20].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD20_BITER_ELINKNO DMA_0.TCD[20].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD20_BITER_ELINKYES DMA_0.TCD[20].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD20_CSR      DMA_0.TCD[20].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD21_SADDR    DMA_0.TCD[21].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD21_ATTR     DMA_0.TCD[21].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD21_SOFF     DMA_0.TCD[21].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD21_NBYTES_MLNO DMA_0.TCD[21].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD21_NBYTES_MLOFFNO DMA_0.TCD[21].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD21_NBYTES_MLOFFYES DMA_0.TCD[21].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD21_SLAST    DMA_0.TCD[21].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD21_DADDR    DMA_0.TCD[21].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD21_CITER_ELINKNO DMA_0.TCD[21].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD21_CITER_ELINKYES DMA_0.TCD[21].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD21_DOFF     DMA_0.TCD[21].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD21_DLASTSGA DMA_0.TCD[21].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD21_BITER_ELINKNO DMA_0.TCD[21].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD21_BITER_ELINKYES DMA_0.TCD[21].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD21_CSR      DMA_0.TCD[21].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD22_SADDR    DMA_0.TCD[22].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD22_ATTR     DMA_0.TCD[22].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD22_SOFF     DMA_0.TCD[22].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD22_NBYTES_MLNO DMA_0.TCD[22].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD22_NBYTES_MLOFFNO DMA_0.TCD[22].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD22_NBYTES_MLOFFYES DMA_0.TCD[22].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD22_SLAST    DMA_0.TCD[22].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD22_DADDR    DMA_0.TCD[22].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD22_CITER_ELINKNO DMA_0.TCD[22].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD22_CITER_ELINKYES DMA_0.TCD[22].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD22_DOFF     DMA_0.TCD[22].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD22_DLASTSGA DMA_0.TCD[22].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD22_BITER_ELINKNO DMA_0.TCD[22].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD22_BITER_ELINKYES DMA_0.TCD[22].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD22_CSR      DMA_0.TCD[22].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD23_SADDR    DMA_0.TCD[23].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD23_ATTR     DMA_0.TCD[23].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD23_SOFF     DMA_0.TCD[23].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD23_NBYTES_MLNO DMA_0.TCD[23].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD23_NBYTES_MLOFFNO DMA_0.TCD[23].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD23_NBYTES_MLOFFYES DMA_0.TCD[23].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD23_SLAST    DMA_0.TCD[23].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD23_DADDR    DMA_0.TCD[23].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD23_CITER_ELINKNO DMA_0.TCD[23].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD23_CITER_ELINKYES DMA_0.TCD[23].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD23_DOFF     DMA_0.TCD[23].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD23_DLASTSGA DMA_0.TCD[23].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD23_BITER_ELINKNO DMA_0.TCD[23].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD23_BITER_ELINKYES DMA_0.TCD[23].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD23_CSR      DMA_0.TCD[23].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD24_SADDR    DMA_0.TCD[24].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD24_ATTR     DMA_0.TCD[24].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD24_SOFF     DMA_0.TCD[24].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD24_NBYTES_MLNO DMA_0.TCD[24].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD24_NBYTES_MLOFFNO DMA_0.TCD[24].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD24_NBYTES_MLOFFYES DMA_0.TCD[24].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD24_SLAST    DMA_0.TCD[24].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD24_DADDR    DMA_0.TCD[24].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD24_CITER_ELINKNO DMA_0.TCD[24].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD24_CITER_ELINKYES DMA_0.TCD[24].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD24_DOFF     DMA_0.TCD[24].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD24_DLASTSGA DMA_0.TCD[24].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD24_BITER_ELINKNO DMA_0.TCD[24].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD24_BITER_ELINKYES DMA_0.TCD[24].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD24_CSR      DMA_0.TCD[24].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD25_SADDR    DMA_0.TCD[25].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD25_ATTR     DMA_0.TCD[25].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD25_SOFF     DMA_0.TCD[25].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD25_NBYTES_MLNO DMA_0.TCD[25].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD25_NBYTES_MLOFFNO DMA_0.TCD[25].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD25_NBYTES_MLOFFYES DMA_0.TCD[25].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD25_SLAST    DMA_0.TCD[25].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD25_DADDR    DMA_0.TCD[25].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD25_CITER_ELINKNO DMA_0.TCD[25].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD25_CITER_ELINKYES DMA_0.TCD[25].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD25_DOFF     DMA_0.TCD[25].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD25_DLASTSGA DMA_0.TCD[25].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD25_BITER_ELINKNO DMA_0.TCD[25].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD25_BITER_ELINKYES DMA_0.TCD[25].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD25_CSR      DMA_0.TCD[25].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD26_SADDR    DMA_0.TCD[26].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD26_ATTR     DMA_0.TCD[26].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD26_SOFF     DMA_0.TCD[26].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD26_NBYTES_MLNO DMA_0.TCD[26].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD26_NBYTES_MLOFFNO DMA_0.TCD[26].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD26_NBYTES_MLOFFYES DMA_0.TCD[26].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD26_SLAST    DMA_0.TCD[26].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD26_DADDR    DMA_0.TCD[26].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD26_CITER_ELINKNO DMA_0.TCD[26].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD26_CITER_ELINKYES DMA_0.TCD[26].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD26_DOFF     DMA_0.TCD[26].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD26_DLASTSGA DMA_0.TCD[26].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD26_BITER_ELINKNO DMA_0.TCD[26].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD26_BITER_ELINKYES DMA_0.TCD[26].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD26_CSR      DMA_0.TCD[26].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD27_SADDR    DMA_0.TCD[27].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD27_ATTR     DMA_0.TCD[27].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD27_SOFF     DMA_0.TCD[27].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD27_NBYTES_MLNO DMA_0.TCD[27].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD27_NBYTES_MLOFFNO DMA_0.TCD[27].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD27_NBYTES_MLOFFYES DMA_0.TCD[27].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD27_SLAST    DMA_0.TCD[27].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD27_DADDR    DMA_0.TCD[27].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD27_CITER_ELINKNO DMA_0.TCD[27].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD27_CITER_ELINKYES DMA_0.TCD[27].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD27_DOFF     DMA_0.TCD[27].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD27_DLASTSGA DMA_0.TCD[27].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD27_BITER_ELINKNO DMA_0.TCD[27].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD27_BITER_ELINKYES DMA_0.TCD[27].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD27_CSR      DMA_0.TCD[27].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD28_SADDR    DMA_0.TCD[28].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD28_ATTR     DMA_0.TCD[28].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD28_SOFF     DMA_0.TCD[28].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD28_NBYTES_MLNO DMA_0.TCD[28].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD28_NBYTES_MLOFFNO DMA_0.TCD[28].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD28_NBYTES_MLOFFYES DMA_0.TCD[28].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD28_SLAST    DMA_0.TCD[28].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD28_DADDR    DMA_0.TCD[28].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD28_CITER_ELINKNO DMA_0.TCD[28].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD28_CITER_ELINKYES DMA_0.TCD[28].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD28_DOFF     DMA_0.TCD[28].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD28_DLASTSGA DMA_0.TCD[28].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD28_BITER_ELINKNO DMA_0.TCD[28].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD28_BITER_ELINKYES DMA_0.TCD[28].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD28_CSR      DMA_0.TCD[28].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD29_SADDR    DMA_0.TCD[29].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD29_ATTR     DMA_0.TCD[29].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD29_SOFF     DMA_0.TCD[29].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD29_NBYTES_MLNO DMA_0.TCD[29].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD29_NBYTES_MLOFFNO DMA_0.TCD[29].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD29_NBYTES_MLOFFYES DMA_0.TCD[29].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD29_SLAST    DMA_0.TCD[29].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD29_DADDR    DMA_0.TCD[29].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD29_CITER_ELINKNO DMA_0.TCD[29].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD29_CITER_ELINKYES DMA_0.TCD[29].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD29_DOFF     DMA_0.TCD[29].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD29_DLASTSGA DMA_0.TCD[29].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD29_BITER_ELINKNO DMA_0.TCD[29].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD29_BITER_ELINKYES DMA_0.TCD[29].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD29_CSR      DMA_0.TCD[29].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD30_SADDR    DMA_0.TCD[30].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD30_ATTR     DMA_0.TCD[30].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD30_SOFF     DMA_0.TCD[30].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD30_NBYTES_MLNO DMA_0.TCD[30].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD30_NBYTES_MLOFFNO DMA_0.TCD[30].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD30_NBYTES_MLOFFYES DMA_0.TCD[30].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD30_SLAST    DMA_0.TCD[30].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD30_DADDR    DMA_0.TCD[30].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD30_CITER_ELINKNO DMA_0.TCD[30].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD30_CITER_ELINKYES DMA_0.TCD[30].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD30_DOFF     DMA_0.TCD[30].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD30_DLASTSGA DMA_0.TCD[30].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD30_BITER_ELINKNO DMA_0.TCD[30].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD30_BITER_ELINKYES DMA_0.TCD[30].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD30_CSR      DMA_0.TCD[30].CSR.R           /* TCD Control and Status */
#define DMA_0_TCD31_SADDR    DMA_0.TCD[31].SADDR.R         /* TCD Source Address */
#define DMA_0_TCD31_ATTR     DMA_0.TCD[31].ATTR.R          /* TCD Transfer Attributes */
#define DMA_0_TCD31_SOFF     DMA_0.TCD[31].SOFF.R          /* TCD Signed Source Address Offset */
#define DMA_0_TCD31_NBYTES_MLNO DMA_0.TCD[31].NBYTES.MLNO.R /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_0_TCD31_NBYTES_MLOFFNO DMA_0.TCD[31].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_0_TCD31_NBYTES_MLOFFYES DMA_0.TCD[31].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD31_SLAST    DMA_0.TCD[31].SLAST.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD31_DADDR    DMA_0.TCD[31].DADDR.R         /* TCD Destination Address */
#define DMA_0_TCD31_CITER_ELINKNO DMA_0.TCD[31].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD31_CITER_ELINKYES DMA_0.TCD[31].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD31_DOFF     DMA_0.TCD[31].DOFF.R          /* TCD Signed Destination Address Offset */
#define DMA_0_TCD31_DLASTSGA DMA_0.TCD[31].DLASTSGA.R      /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD31_BITER_ELINKNO DMA_0.TCD[31].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_0_TCD31_BITER_ELINKYES DMA_0.TCD[31].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD31_CSR      DMA_0.TCD[31].CSR.R           /* TCD Control and Status */

/* EIM */
#define EIM_EIMCR            EIM.EIMCR.R                   /* Error Injection Module Configuration Register */
#define EIM_EICHEN           EIM.EICHEN.R                  /* Error Injection Channel Enable register */
#define EIM_EICHD_Word0      EIM.EICHD_Word0.R             /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD_Word1      EIM.EICHD_Word1.R             /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD_Word2      EIM.EICHD_Word2.R             /* Error Injection Channel Descriptor, Word2 */

/* ENET */
#define ENET_0_EIR           ENET_0.EIR.R                  /* Interrupt Event Register */
#define ENET_0_EIMR          ENET_0.EIMR.R                 /* Interrupt Mask Register */
#define ENET_0_RDAR          ENET_0.RDAR.R                 /* Receive Descriptor Active Register */
#define ENET_0_TDAR          ENET_0.TDAR.R                 /* Transmit Descriptor Active Register */
#define ENET_0_ECR           ENET_0.ECR.R                  /* Ethernet Control Register */
#define ENET_0_MMFR          ENET_0.MMFR.R                 /* MII Management Frame Register */
#define ENET_0_MSCR          ENET_0.MSCR.R                 /* MII Speed Control Register */
#define ENET_0_MIBC          ENET_0.MIBC.R                 /* MIB Control Register */
#define ENET_0_RCR           ENET_0.RCR.R                  /* Receive Control Register */
#define ENET_0_TCR           ENET_0.TCR.R                  /* Transmit Control Register */
#define ENET_0_PALR          ENET_0.PALR.R                 /* Physical Address Lower Register */
#define ENET_0_PAUR          ENET_0.PAUR.R                 /* Physical Address Upper Register */
#define ENET_0_OPD           ENET_0.OPD.R                  /* Opcode/Pause Duration Register */
#define ENET_0_IAUR          ENET_0.IAUR.R                 /* Descriptor Individual Upper Address Register */
#define ENET_0_IALR          ENET_0.IALR.R                 /* Descriptor Individual Lower Address Register */
#define ENET_0_GAUR          ENET_0.GAUR.R                 /* Descriptor Group Upper Address Register */
#define ENET_0_GALR          ENET_0.GALR.R                 /* Descriptor Group Lower Address Register */
#define ENET_0_TFWR          ENET_0.TFWR.R                 /* Transmit FIFO Watermark Register */
#define ENET_0_RDSR          ENET_0.RDSR.R                 /* Receive Descriptor Ring Start Register */
#define ENET_0_TDSR          ENET_0.TDSR.R                 /* Transmit Buffer Descriptor Ring Start Register */
#define ENET_0_MRBR          ENET_0.MRBR.R                 /* Maximum Receive Buffer Size Register */
#define ENET_0_RSFL          ENET_0.RSFL.R                 /* Receive FIFO Section Full Threshold */
#define ENET_0_RSEM          ENET_0.RSEM.R                 /* Receive FIFO Section Empty Threshold */
#define ENET_0_RAEM          ENET_0.RAEM.R                 /* Receive FIFO Almost Empty Threshold */
#define ENET_0_RAFL          ENET_0.RAFL.R                 /* Receive FIFO Almost Full Threshold */
#define ENET_0_TSEM          ENET_0.TSEM.R                 /* Transmit FIFO Section Empty Threshold */
#define ENET_0_TAEM          ENET_0.TAEM.R                 /* Transmit FIFO Almost Empty Threshold */
#define ENET_0_TAFL          ENET_0.TAFL.R                 /* Transmit FIFO Almost Full Threshold */
#define ENET_0_TIPG          ENET_0.TIPG.R                 /* Transmit Inter-Packet Gap */
#define ENET_0_FTRL          ENET_0.FTRL.R                 /* Frame Truncation Length */
#define ENET_0_TACC          ENET_0.TACC.R                 /* Transmit Accelerator Function Configuration */
#define ENET_0_RACC          ENET_0.RACC.R                 /* Receive Accelerator Function Configuration */
#define ENET_0_ATCR          ENET_0.ATCR.R                 /* Timer Control Register */
#define ENET_0_ATVR          ENET_0.ATVR.R                 /* Timer Value Register */
#define ENET_0_ATOFF         ENET_0.ATOFF.R                /* Timer Offset Register */
#define ENET_0_ATPER         ENET_0.ATPER.R                /* Timer Period Register */
#define ENET_0_ATCOR         ENET_0.ATCOR.R                /* Timer Correction Register */
#define ENET_0_ATINC         ENET_0.ATINC.R                /* Time-Stamping Clock Period Register */
#define ENET_0_ATSTMP        ENET_0.ATSTMP.R               /* Timestamp of Last Transmitted Frame */
#define ENET_0_TGSR          ENET_0.TGSR.R                 /* Timer Global Status Register */
#define ENET_0_TCSR0         ENET_0.TIMER[0].TCSR.R        /* Timer Control Status Register */
#define ENET_0_TCCR0         ENET_0.TIMER[0].TCCR.R        /* Timer Compare Capture Register */
#define ENET_0_TCSR1         ENET_0.TIMER[1].TCSR.R        /* Timer Control Status Register */
#define ENET_0_TCCR1         ENET_0.TIMER[1].TCCR.R        /* Timer Compare Capture Register */
#define ENET_0_TCSR2         ENET_0.TIMER[2].TCSR.R        /* Timer Control Status Register */
#define ENET_0_TCCR2         ENET_0.TIMER[2].TCCR.R        /* Timer Compare Capture Register */
#define ENET_0_TCSR3         ENET_0.TIMER[3].TCSR.R        /* Timer Control Status Register */
#define ENET_0_TCCR3         ENET_0.TIMER[3].TCCR.R        /* Timer Compare Capture Register */

/* ETIMER */
#define ETIMER_0_CH0_COMP1   ETIMER_0.CH[0].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_0_CH0_COMP2   ETIMER_0.CH[0].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_0_CH0_CAPT1   ETIMER_0.CH[0].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_0_CH0_CAPT2   ETIMER_0.CH[0].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_0_CH0_LOAD    ETIMER_0.CH[0].LOAD.R         /* Channel n Load Register */
#define ETIMER_0_CH0_HOLD    ETIMER_0.CH[0].HOLD.R         /* Channel n Hold Register */
#define ETIMER_0_CH0_CNTR    ETIMER_0.CH[0].CNTR.R         /* Channel n Counter Register */
#define ETIMER_0_CH0_CTRL1   ETIMER_0.CH[0].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_0_CH0_CTRL2   ETIMER_0.CH[0].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_0_CH0_CTRL3   ETIMER_0.CH[0].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_0_CH0_STS     ETIMER_0.CH[0].STS.R          /* Channel n Status Register */
#define ETIMER_0_CH0_INTDMA  ETIMER_0.CH[0].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_0_CH0_CMPLD1  ETIMER_0.CH[0].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_0_CH0_CMPLD2  ETIMER_0.CH[0].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_0_CH0_CCCTRL  ETIMER_0.CH[0].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_0_CH0_FILT    ETIMER_0.CH[0].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_0_CH1_COMP1   ETIMER_0.CH[1].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_0_CH1_COMP2   ETIMER_0.CH[1].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_0_CH1_CAPT1   ETIMER_0.CH[1].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_0_CH1_CAPT2   ETIMER_0.CH[1].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_0_CH1_LOAD    ETIMER_0.CH[1].LOAD.R         /* Channel n Load Register */
#define ETIMER_0_CH1_HOLD    ETIMER_0.CH[1].HOLD.R         /* Channel n Hold Register */
#define ETIMER_0_CH1_CNTR    ETIMER_0.CH[1].CNTR.R         /* Channel n Counter Register */
#define ETIMER_0_CH1_CTRL1   ETIMER_0.CH[1].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_0_CH1_CTRL2   ETIMER_0.CH[1].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_0_CH1_CTRL3   ETIMER_0.CH[1].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_0_CH1_STS     ETIMER_0.CH[1].STS.R          /* Channel n Status Register */
#define ETIMER_0_CH1_INTDMA  ETIMER_0.CH[1].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_0_CH1_CMPLD1  ETIMER_0.CH[1].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_0_CH1_CMPLD2  ETIMER_0.CH[1].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_0_CH1_CCCTRL  ETIMER_0.CH[1].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_0_CH1_FILT    ETIMER_0.CH[1].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_0_CH2_COMP1   ETIMER_0.CH[2].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_0_CH2_COMP2   ETIMER_0.CH[2].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_0_CH2_CAPT1   ETIMER_0.CH[2].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_0_CH2_CAPT2   ETIMER_0.CH[2].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_0_CH2_LOAD    ETIMER_0.CH[2].LOAD.R         /* Channel n Load Register */
#define ETIMER_0_CH2_HOLD    ETIMER_0.CH[2].HOLD.R         /* Channel n Hold Register */
#define ETIMER_0_CH2_CNTR    ETIMER_0.CH[2].CNTR.R         /* Channel n Counter Register */
#define ETIMER_0_CH2_CTRL1   ETIMER_0.CH[2].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_0_CH2_CTRL2   ETIMER_0.CH[2].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_0_CH2_CTRL3   ETIMER_0.CH[2].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_0_CH2_STS     ETIMER_0.CH[2].STS.R          /* Channel n Status Register */
#define ETIMER_0_CH2_INTDMA  ETIMER_0.CH[2].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_0_CH2_CMPLD1  ETIMER_0.CH[2].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_0_CH2_CMPLD2  ETIMER_0.CH[2].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_0_CH2_CCCTRL  ETIMER_0.CH[2].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_0_CH2_FILT    ETIMER_0.CH[2].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_0_CH3_COMP1   ETIMER_0.CH[3].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_0_CH3_COMP2   ETIMER_0.CH[3].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_0_CH3_CAPT1   ETIMER_0.CH[3].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_0_CH3_CAPT2   ETIMER_0.CH[3].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_0_CH3_LOAD    ETIMER_0.CH[3].LOAD.R         /* Channel n Load Register */
#define ETIMER_0_CH3_HOLD    ETIMER_0.CH[3].HOLD.R         /* Channel n Hold Register */
#define ETIMER_0_CH3_CNTR    ETIMER_0.CH[3].CNTR.R         /* Channel n Counter Register */
#define ETIMER_0_CH3_CTRL1   ETIMER_0.CH[3].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_0_CH3_CTRL2   ETIMER_0.CH[3].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_0_CH3_CTRL3   ETIMER_0.CH[3].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_0_CH3_STS     ETIMER_0.CH[3].STS.R          /* Channel n Status Register */
#define ETIMER_0_CH3_INTDMA  ETIMER_0.CH[3].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_0_CH3_CMPLD1  ETIMER_0.CH[3].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_0_CH3_CMPLD2  ETIMER_0.CH[3].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_0_CH3_CCCTRL  ETIMER_0.CH[3].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_0_CH3_FILT    ETIMER_0.CH[3].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_0_CH4_COMP1   ETIMER_0.CH[4].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_0_CH4_COMP2   ETIMER_0.CH[4].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_0_CH4_CAPT1   ETIMER_0.CH[4].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_0_CH4_CAPT2   ETIMER_0.CH[4].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_0_CH4_LOAD    ETIMER_0.CH[4].LOAD.R         /* Channel n Load Register */
#define ETIMER_0_CH4_HOLD    ETIMER_0.CH[4].HOLD.R         /* Channel n Hold Register */
#define ETIMER_0_CH4_CNTR    ETIMER_0.CH[4].CNTR.R         /* Channel n Counter Register */
#define ETIMER_0_CH4_CTRL1   ETIMER_0.CH[4].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_0_CH4_CTRL2   ETIMER_0.CH[4].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_0_CH4_CTRL3   ETIMER_0.CH[4].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_0_CH4_STS     ETIMER_0.CH[4].STS.R          /* Channel n Status Register */
#define ETIMER_0_CH4_INTDMA  ETIMER_0.CH[4].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_0_CH4_CMPLD1  ETIMER_0.CH[4].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_0_CH4_CMPLD2  ETIMER_0.CH[4].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_0_CH4_CCCTRL  ETIMER_0.CH[4].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_0_CH4_FILT    ETIMER_0.CH[4].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_0_CH5_COMP1   ETIMER_0.CH[5].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_0_CH5_COMP2   ETIMER_0.CH[5].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_0_CH5_CAPT1   ETIMER_0.CH[5].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_0_CH5_CAPT2   ETIMER_0.CH[5].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_0_CH5_LOAD    ETIMER_0.CH[5].LOAD.R         /* Channel n Load Register */
#define ETIMER_0_CH5_HOLD    ETIMER_0.CH[5].HOLD.R         /* Channel n Hold Register */
#define ETIMER_0_CH5_CNTR    ETIMER_0.CH[5].CNTR.R         /* Channel n Counter Register */
#define ETIMER_0_CH5_CTRL1   ETIMER_0.CH[5].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_0_CH5_CTRL2   ETIMER_0.CH[5].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_0_CH5_CTRL3   ETIMER_0.CH[5].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_0_CH5_STS     ETIMER_0.CH[5].STS.R          /* Channel n Status Register */
#define ETIMER_0_CH5_INTDMA  ETIMER_0.CH[5].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_0_CH5_CMPLD1  ETIMER_0.CH[5].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_0_CH5_CMPLD2  ETIMER_0.CH[5].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_0_CH5_CCCTRL  ETIMER_0.CH[5].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_0_CH5_FILT    ETIMER_0.CH[5].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_0_WDTOL       ETIMER_0.WDTOL.R              /* Watchdog Time-out Low Word Register */
#define ETIMER_0_WDTOH       ETIMER_0.WDTOH.R              /* Watchdog Time-out High Word Register */
#define ETIMER_0_ENBL        ETIMER_0.ENBL.R               /* Channel Enable Register */
#define ETIMER_0_DREQ0       ETIMER_0.DREQ0.R              /* DMA Request 0 Select Register */
#define ETIMER_0_DREQ1       ETIMER_0.DREQ1.R              /* DMA Request 1 Select Register */
#define ETIMER_0_DREQ2       ETIMER_0.DREQ2.R              /* DMA Request 2 Select Register */
#define ETIMER_0_DREQ3       ETIMER_0.DREQ3.R              /* DMA Request 3 Select Register */

/* ETIMER */
#define ETIMER_1_CH0_COMP1   ETIMER_1.CH[0].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH0_COMP2   ETIMER_1.CH[0].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH0_CAPT1   ETIMER_1.CH[0].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH0_CAPT2   ETIMER_1.CH[0].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH0_LOAD    ETIMER_1.CH[0].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH0_HOLD    ETIMER_1.CH[0].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH0_CNTR    ETIMER_1.CH[0].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH0_CTRL1   ETIMER_1.CH[0].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH0_CTRL2   ETIMER_1.CH[0].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH0_CTRL3   ETIMER_1.CH[0].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH0_STS     ETIMER_1.CH[0].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH0_INTDMA  ETIMER_1.CH[0].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH0_CMPLD1  ETIMER_1.CH[0].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH0_CMPLD2  ETIMER_1.CH[0].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH0_CCCTRL  ETIMER_1.CH[0].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH0_FILT    ETIMER_1.CH[0].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH1_COMP1   ETIMER_1.CH[1].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH1_COMP2   ETIMER_1.CH[1].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH1_CAPT1   ETIMER_1.CH[1].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH1_CAPT2   ETIMER_1.CH[1].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH1_LOAD    ETIMER_1.CH[1].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH1_HOLD    ETIMER_1.CH[1].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH1_CNTR    ETIMER_1.CH[1].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH1_CTRL1   ETIMER_1.CH[1].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH1_CTRL2   ETIMER_1.CH[1].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH1_CTRL3   ETIMER_1.CH[1].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH1_STS     ETIMER_1.CH[1].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH1_INTDMA  ETIMER_1.CH[1].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH1_CMPLD1  ETIMER_1.CH[1].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH1_CMPLD2  ETIMER_1.CH[1].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH1_CCCTRL  ETIMER_1.CH[1].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH1_FILT    ETIMER_1.CH[1].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH2_COMP1   ETIMER_1.CH[2].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH2_COMP2   ETIMER_1.CH[2].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH2_CAPT1   ETIMER_1.CH[2].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH2_CAPT2   ETIMER_1.CH[2].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH2_LOAD    ETIMER_1.CH[2].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH2_HOLD    ETIMER_1.CH[2].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH2_CNTR    ETIMER_1.CH[2].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH2_CTRL1   ETIMER_1.CH[2].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH2_CTRL2   ETIMER_1.CH[2].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH2_CTRL3   ETIMER_1.CH[2].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH2_STS     ETIMER_1.CH[2].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH2_INTDMA  ETIMER_1.CH[2].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH2_CMPLD1  ETIMER_1.CH[2].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH2_CMPLD2  ETIMER_1.CH[2].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH2_CCCTRL  ETIMER_1.CH[2].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH2_FILT    ETIMER_1.CH[2].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH3_COMP1   ETIMER_1.CH[3].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH3_COMP2   ETIMER_1.CH[3].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH3_CAPT1   ETIMER_1.CH[3].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH3_CAPT2   ETIMER_1.CH[3].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH3_LOAD    ETIMER_1.CH[3].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH3_HOLD    ETIMER_1.CH[3].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH3_CNTR    ETIMER_1.CH[3].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH3_CTRL1   ETIMER_1.CH[3].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH3_CTRL2   ETIMER_1.CH[3].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH3_CTRL3   ETIMER_1.CH[3].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH3_STS     ETIMER_1.CH[3].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH3_INTDMA  ETIMER_1.CH[3].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH3_CMPLD1  ETIMER_1.CH[3].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH3_CMPLD2  ETIMER_1.CH[3].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH3_CCCTRL  ETIMER_1.CH[3].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH3_FILT    ETIMER_1.CH[3].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH4_COMP1   ETIMER_1.CH[4].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH4_COMP2   ETIMER_1.CH[4].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH4_CAPT1   ETIMER_1.CH[4].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH4_CAPT2   ETIMER_1.CH[4].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH4_LOAD    ETIMER_1.CH[4].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH4_HOLD    ETIMER_1.CH[4].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH4_CNTR    ETIMER_1.CH[4].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH4_CTRL1   ETIMER_1.CH[4].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH4_CTRL2   ETIMER_1.CH[4].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH4_CTRL3   ETIMER_1.CH[4].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH4_STS     ETIMER_1.CH[4].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH4_INTDMA  ETIMER_1.CH[4].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH4_CMPLD1  ETIMER_1.CH[4].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH4_CMPLD2  ETIMER_1.CH[4].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH4_CCCTRL  ETIMER_1.CH[4].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH4_FILT    ETIMER_1.CH[4].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_CH5_COMP1   ETIMER_1.CH[5].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_1_CH5_COMP2   ETIMER_1.CH[5].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_1_CH5_CAPT1   ETIMER_1.CH[5].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_1_CH5_CAPT2   ETIMER_1.CH[5].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_1_CH5_LOAD    ETIMER_1.CH[5].LOAD.R         /* Channel n Load Register */
#define ETIMER_1_CH5_HOLD    ETIMER_1.CH[5].HOLD.R         /* Channel n Hold Register */
#define ETIMER_1_CH5_CNTR    ETIMER_1.CH[5].CNTR.R         /* Channel n Counter Register */
#define ETIMER_1_CH5_CTRL1   ETIMER_1.CH[5].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_1_CH5_CTRL2   ETIMER_1.CH[5].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_1_CH5_CTRL3   ETIMER_1.CH[5].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_1_CH5_STS     ETIMER_1.CH[5].STS.R          /* Channel n Status Register */
#define ETIMER_1_CH5_INTDMA  ETIMER_1.CH[5].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_1_CH5_CMPLD1  ETIMER_1.CH[5].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_1_CH5_CMPLD2  ETIMER_1.CH[5].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_1_CH5_CCCTRL  ETIMER_1.CH[5].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_1_CH5_FILT    ETIMER_1.CH[5].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_1_WDTOL       ETIMER_1.WDTOL.R              /* Watchdog Time-out Low Word Register */
#define ETIMER_1_WDTOH       ETIMER_1.WDTOH.R              /* Watchdog Time-out High Word Register */
#define ETIMER_1_ENBL        ETIMER_1.ENBL.R               /* Channel Enable Register */
#define ETIMER_1_DREQ0       ETIMER_1.DREQ0.R              /* DMA Request 0 Select Register */
#define ETIMER_1_DREQ1       ETIMER_1.DREQ1.R              /* DMA Request 1 Select Register */
#define ETIMER_1_DREQ2       ETIMER_1.DREQ2.R              /* DMA Request 2 Select Register */
#define ETIMER_1_DREQ3       ETIMER_1.DREQ3.R              /* DMA Request 3 Select Register */

/* ETIMER */
#define ETIMER_2_CH0_COMP1   ETIMER_2.CH[0].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_2_CH0_COMP2   ETIMER_2.CH[0].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_2_CH0_CAPT1   ETIMER_2.CH[0].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_2_CH0_CAPT2   ETIMER_2.CH[0].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_2_CH0_LOAD    ETIMER_2.CH[0].LOAD.R         /* Channel n Load Register */
#define ETIMER_2_CH0_HOLD    ETIMER_2.CH[0].HOLD.R         /* Channel n Hold Register */
#define ETIMER_2_CH0_CNTR    ETIMER_2.CH[0].CNTR.R         /* Channel n Counter Register */
#define ETIMER_2_CH0_CTRL1   ETIMER_2.CH[0].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_2_CH0_CTRL2   ETIMER_2.CH[0].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_2_CH0_CTRL3   ETIMER_2.CH[0].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_2_CH0_STS     ETIMER_2.CH[0].STS.R          /* Channel n Status Register */
#define ETIMER_2_CH0_INTDMA  ETIMER_2.CH[0].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_2_CH0_CMPLD1  ETIMER_2.CH[0].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_2_CH0_CMPLD2  ETIMER_2.CH[0].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_2_CH0_CCCTRL  ETIMER_2.CH[0].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_2_CH0_FILT    ETIMER_2.CH[0].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_2_CH1_COMP1   ETIMER_2.CH[1].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_2_CH1_COMP2   ETIMER_2.CH[1].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_2_CH1_CAPT1   ETIMER_2.CH[1].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_2_CH1_CAPT2   ETIMER_2.CH[1].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_2_CH1_LOAD    ETIMER_2.CH[1].LOAD.R         /* Channel n Load Register */
#define ETIMER_2_CH1_HOLD    ETIMER_2.CH[1].HOLD.R         /* Channel n Hold Register */
#define ETIMER_2_CH1_CNTR    ETIMER_2.CH[1].CNTR.R         /* Channel n Counter Register */
#define ETIMER_2_CH1_CTRL1   ETIMER_2.CH[1].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_2_CH1_CTRL2   ETIMER_2.CH[1].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_2_CH1_CTRL3   ETIMER_2.CH[1].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_2_CH1_STS     ETIMER_2.CH[1].STS.R          /* Channel n Status Register */
#define ETIMER_2_CH1_INTDMA  ETIMER_2.CH[1].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_2_CH1_CMPLD1  ETIMER_2.CH[1].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_2_CH1_CMPLD2  ETIMER_2.CH[1].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_2_CH1_CCCTRL  ETIMER_2.CH[1].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_2_CH1_FILT    ETIMER_2.CH[1].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_2_CH2_COMP1   ETIMER_2.CH[2].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_2_CH2_COMP2   ETIMER_2.CH[2].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_2_CH2_CAPT1   ETIMER_2.CH[2].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_2_CH2_CAPT2   ETIMER_2.CH[2].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_2_CH2_LOAD    ETIMER_2.CH[2].LOAD.R         /* Channel n Load Register */
#define ETIMER_2_CH2_HOLD    ETIMER_2.CH[2].HOLD.R         /* Channel n Hold Register */
#define ETIMER_2_CH2_CNTR    ETIMER_2.CH[2].CNTR.R         /* Channel n Counter Register */
#define ETIMER_2_CH2_CTRL1   ETIMER_2.CH[2].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_2_CH2_CTRL2   ETIMER_2.CH[2].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_2_CH2_CTRL3   ETIMER_2.CH[2].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_2_CH2_STS     ETIMER_2.CH[2].STS.R          /* Channel n Status Register */
#define ETIMER_2_CH2_INTDMA  ETIMER_2.CH[2].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_2_CH2_CMPLD1  ETIMER_2.CH[2].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_2_CH2_CMPLD2  ETIMER_2.CH[2].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_2_CH2_CCCTRL  ETIMER_2.CH[2].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_2_CH2_FILT    ETIMER_2.CH[2].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_2_CH3_COMP1   ETIMER_2.CH[3].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_2_CH3_COMP2   ETIMER_2.CH[3].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_2_CH3_CAPT1   ETIMER_2.CH[3].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_2_CH3_CAPT2   ETIMER_2.CH[3].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_2_CH3_LOAD    ETIMER_2.CH[3].LOAD.R         /* Channel n Load Register */
#define ETIMER_2_CH3_HOLD    ETIMER_2.CH[3].HOLD.R         /* Channel n Hold Register */
#define ETIMER_2_CH3_CNTR    ETIMER_2.CH[3].CNTR.R         /* Channel n Counter Register */
#define ETIMER_2_CH3_CTRL1   ETIMER_2.CH[3].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_2_CH3_CTRL2   ETIMER_2.CH[3].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_2_CH3_CTRL3   ETIMER_2.CH[3].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_2_CH3_STS     ETIMER_2.CH[3].STS.R          /* Channel n Status Register */
#define ETIMER_2_CH3_INTDMA  ETIMER_2.CH[3].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_2_CH3_CMPLD1  ETIMER_2.CH[3].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_2_CH3_CMPLD2  ETIMER_2.CH[3].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_2_CH3_CCCTRL  ETIMER_2.CH[3].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_2_CH3_FILT    ETIMER_2.CH[3].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_2_CH4_COMP1   ETIMER_2.CH[4].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_2_CH4_COMP2   ETIMER_2.CH[4].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_2_CH4_CAPT1   ETIMER_2.CH[4].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_2_CH4_CAPT2   ETIMER_2.CH[4].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_2_CH4_LOAD    ETIMER_2.CH[4].LOAD.R         /* Channel n Load Register */
#define ETIMER_2_CH4_HOLD    ETIMER_2.CH[4].HOLD.R         /* Channel n Hold Register */
#define ETIMER_2_CH4_CNTR    ETIMER_2.CH[4].CNTR.R         /* Channel n Counter Register */
#define ETIMER_2_CH4_CTRL1   ETIMER_2.CH[4].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_2_CH4_CTRL2   ETIMER_2.CH[4].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_2_CH4_CTRL3   ETIMER_2.CH[4].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_2_CH4_STS     ETIMER_2.CH[4].STS.R          /* Channel n Status Register */
#define ETIMER_2_CH4_INTDMA  ETIMER_2.CH[4].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_2_CH4_CMPLD1  ETIMER_2.CH[4].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_2_CH4_CMPLD2  ETIMER_2.CH[4].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_2_CH4_CCCTRL  ETIMER_2.CH[4].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_2_CH4_FILT    ETIMER_2.CH[4].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_2_CH5_COMP1   ETIMER_2.CH[5].COMP1.R        /* Channel n Compare Register 1 */
#define ETIMER_2_CH5_COMP2   ETIMER_2.CH[5].COMP2.R        /* Channel n Compare Register 2 */
#define ETIMER_2_CH5_CAPT1   ETIMER_2.CH[5].CAPT1.R        /* Channel n Capture Register 1 */
#define ETIMER_2_CH5_CAPT2   ETIMER_2.CH[5].CAPT2.R        /* Channel n Capture Register 2 */
#define ETIMER_2_CH5_LOAD    ETIMER_2.CH[5].LOAD.R         /* Channel n Load Register */
#define ETIMER_2_CH5_HOLD    ETIMER_2.CH[5].HOLD.R         /* Channel n Hold Register */
#define ETIMER_2_CH5_CNTR    ETIMER_2.CH[5].CNTR.R         /* Channel n Counter Register */
#define ETIMER_2_CH5_CTRL1   ETIMER_2.CH[5].CTRL1.R        /* Channel n Control Register 1 */
#define ETIMER_2_CH5_CTRL2   ETIMER_2.CH[5].CTRL2.R        /* Channel n Control Register 2 */
#define ETIMER_2_CH5_CTRL3   ETIMER_2.CH[5].CTRL3.R        /* Channel n Control Register 3 */
#define ETIMER_2_CH5_STS     ETIMER_2.CH[5].STS.R          /* Channel n Status Register */
#define ETIMER_2_CH5_INTDMA  ETIMER_2.CH[5].INTDMA.R       /* Channel n Interrupt and DMA Enable Register */
#define ETIMER_2_CH5_CMPLD1  ETIMER_2.CH[5].CMPLD1.R       /* Channel n Comparator Load Register 1 */
#define ETIMER_2_CH5_CMPLD2  ETIMER_2.CH[5].CMPLD2.R       /* Channel n Comparator Load Register 2 */
#define ETIMER_2_CH5_CCCTRL  ETIMER_2.CH[5].CCCTRL.R       /* Channel n Compare and Capture Control Register */
#define ETIMER_2_CH5_FILT    ETIMER_2.CH[5].FILT.R         /* Channel n Input Filter Register */
#define ETIMER_2_WDTOL       ETIMER_2.WDTOL.R              /* Watchdog Time-out Low Word Register */
#define ETIMER_2_WDTOH       ETIMER_2.WDTOH.R              /* Watchdog Time-out High Word Register */
#define ETIMER_2_ENBL        ETIMER_2.ENBL.R               /* Channel Enable Register */
#define ETIMER_2_DREQ0       ETIMER_2.DREQ0.R              /* DMA Request 0 Select Register */
#define ETIMER_2_DREQ1       ETIMER_2.DREQ1.R              /* DMA Request 1 Select Register */
#define ETIMER_2_DREQ2       ETIMER_2.DREQ2.R              /* DMA Request 2 Select Register */
#define ETIMER_2_DREQ3       ETIMER_2.DREQ3.R              /* DMA Request 3 Select Register */

/* FCCU */
#define FCCU_CTRL            FCCU.CTRL.R                   /* Control Register */
#define FCCU_CTRLK           FCCU.CTRLK.R                  /* CTRL Key Register */
#define FCCU_CFG             FCCU.CFG.R                    /* Configuration Register */
#define FCCU_NCF_CFG0        FCCU.NCF_CFG[0].R             /* NCF Configuration Register */
#define FCCU_NCF_CFG1        FCCU.NCF_CFG[1].R             /* NCF Configuration Register */
#define FCCU_NCF_CFG2        FCCU.NCF_CFG[2].R             /* NCF Configuration Register */
#define FCCU_NCFS_CFG0       FCCU.NCFS_CFG[0].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG1       FCCU.NCFS_CFG[1].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG2       FCCU.NCFS_CFG[2].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG3       FCCU.NCFS_CFG[3].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG4       FCCU.NCFS_CFG[4].R            /* NCFS Configuration Register */
#define FCCU_NCF_S0          FCCU.NCF_S[0].R               /* NCF Status Register */
#define FCCU_NCF_S1          FCCU.NCF_S[1].R               /* NCF Status Register */
#define FCCU_NCF_S2          FCCU.NCF_S[2].R               /* NCF Status Register */
#define FCCU_NCFK            FCCU.NCFK.R                   /* NCF Key Register */
#define FCCU_NCF_E0          FCCU.NCF_E[0].R               /* NCF Enable Register */
#define FCCU_NCF_E1          FCCU.NCF_E[1].R               /* NCF Enable Register */
#define FCCU_NCF_E2          FCCU.NCF_E[2].R               /* NCF Enable Register */
#define FCCU_NCF_TOE0        FCCU.NCF_TOE[0].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TOE1        FCCU.NCF_TOE[1].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TOE2        FCCU.NCF_TOE[2].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TO          FCCU.NCF_TO.R                 /* NCF Time-out Register */
#define FCCU_CFG_TO          FCCU.CFG_TO.R                 /* CFG Timeout Register */
#define FCCU_EINOUT          FCCU.EINOUT.R                 /* IO Control Register */
#define FCCU_STAT            FCCU.STAT.R                   /* Status Register */
#define FCCU_N2AF_STATUS     FCCU.N2AF_STATUS.R            /* NA Freeze Status Register */
#define FCCU_A2FF_STATUS     FCCU.A2FF_STATUS.R            /* AF Freeze Status Register */
#define FCCU_N2FF_STATUS     FCCU.N2FF_STATUS.R            /* NF Freeze Status Register */
#define FCCU_F2A_STATUS      FCCU.F2A_STATUS.R             /* FA Freeze Status Register */
#define FCCU_NCFF            FCCU.NCFF.R                   /* NCF Fake Register */
#define FCCU_IRQ_STAT        FCCU.IRQ_STAT.R               /* IRQ Status Register */
#define FCCU_IRQ_EN          FCCU.IRQ_EN.R                 /* IRQ Enable Register */
#define FCCU_XTMR            FCCU.XTMR.R                   /* XTMR Register */
#define FCCU_MCS             FCCU.MCS.R                    /* MCS Register */
#define FCCU_TRANS_LOCK      FCCU.TRANS_LOCK.R             /* Transient Lock Register */
#define FCCU_PERMNT_LOCK     FCCU.PERMNT_LOCK.R            /* Permanent Lock Register */
#define FCCU_DELTA_T         FCCU.DELTA_T.R                /* Delta T Register */
#define FCCU_IRQ_ALARM_EN0   FCCU.IRQ_ALARM_EN[0].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN1   FCCU.IRQ_ALARM_EN[1].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN2   FCCU.IRQ_ALARM_EN[2].R        /* IRQ Alarm Enable Register */
#define FCCU_NMI_EN0         FCCU.NMI_EN[0].R              /* NMI Enable Register */
#define FCCU_NMI_EN1         FCCU.NMI_EN[1].R              /* NMI Enable Register */
#define FCCU_NMI_EN2         FCCU.NMI_EN[2].R              /* NMI Enable Register */
#define FCCU_EOUT_SIG_EN0    FCCU.EOUT_SIG_EN[0].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN1    FCCU.EOUT_SIG_EN[1].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN2    FCCU.EOUT_SIG_EN[2].R         /* EOUT Signaling Enable Register */

/* FR */
#define FR_0_MVR             FR_0.MVR.R                    /* Module Version Register */
#define FR_0_MCR             FR_0.MCR.R                    /* Module Configuration Register */
#define FR_0_SYMBADHR        FR_0.SYMBADHR.R               /* System Memory Base Address High Register */
#define FR_0_SYMBADLR        FR_0.SYMBADLR.R               /* System Memory Base Address Low Register */
#define FR_0_STBSCR          FR_0.STBSCR.R                 /* Strobe Signal Control Register */
#define FR_0_MBDSR           FR_0.MBDSR.R                  /* Message Buffer Data Size Register */
#define FR_0_MBSSUTR         FR_0.MBSSUTR.R                /* Message Buffer Segment Size and Utilization Register */
#define FR_0_PEDRAR          FR_0.PEDRAR.R                 /* PE DRAM Access Register */
#define FR_0_PEDRDR          FR_0.PEDRDR.R                 /* PE DRAM Data Register */
#define FR_0_POCR            FR_0.POCR.R                   /* Protocol Operation Control Register */
#define FR_0_GIFER           FR_0.GIFER.R                  /* Global Interrupt Flag and Enable Register */
#define FR_0_PIFR0           FR_0.PIFR0.R                  /* Protocol Interrupt Flag Register 0 */
#define FR_0_PIFR1           FR_0.PIFR1.R                  /* Protocol Interrupt Flag Register 1 */
#define FR_0_PIER0           FR_0.PIER0.R                  /* Protocol Interrupt Enable Register 0 */
#define FR_0_PIER1           FR_0.PIER1.R                  /* Protocol Interrupt Enable Register 1 */
#define FR_0_CHIERFR         FR_0.CHIERFR.R                /* CHI Error Flag Register */
#define FR_0_MBIVEC          FR_0.MBIVEC.R                 /* Message Buffer Interrupt Vector Register */
#define FR_0_CASERCR         FR_0.CASERCR.R                /* Channel A Status Error Counter Register */
#define FR_0_CBSERCR         FR_0.CBSERCR.R                /* Channel B Status Error Counter Register */
#define FR_0_PSR0            FR_0.PSR0.R                   /* Protocol Status Register 0 */
#define FR_0_PSR1            FR_0.PSR1.R                   /* Protocol Status Register 1 */
#define FR_0_PSR2            FR_0.PSR2.R                   /* Protocol Status Register 2 */
#define FR_0_PSR3            FR_0.PSR3.R                   /* Protocol Status Register 3 */
#define FR_0_MTCTR           FR_0.MTCTR.R                  /* Macrotick Counter Register */
#define FR_0_CYCTR           FR_0.CYCTR.R                  /* Cycle Counter Register */
#define FR_0_SLTCTAR         FR_0.SLTCTAR.R                /* Slot Counter Channel A Register */
#define FR_0_SLTCTBR         FR_0.SLTCTBR.R                /* Slot Counter Channel B Register */
#define FR_0_RTCORVR         FR_0.RTCORVR.R                /* Rate Correction Value Register */
#define FR_0_OFCORVR         FR_0.OFCORVR.R                /* Offset Correction Value Register */
#define FR_0_CIFR            FR_0.CIFR.R                   /* Combined Interrupt Flag Register */
#define FR_0_SYMATOR         FR_0.SYMATOR.R                /* System Memory Access Time-Out Register */
#define FR_0_SFCNTR          FR_0.SFCNTR.R                 /* Sync Frame Counter Register */
#define FR_0_SFTOR           FR_0.SFTOR.R                  /* Sync Frame Table Offset Register */
#define FR_0_SFTCCSR         FR_0.SFTCCSR.R                /* Sync Frame Table Configuration, Control, Status Register */
#define FR_0_SFIDRFR         FR_0.SFIDRFR.R                /* Sync Frame ID Rejection Filter Register */
#define FR_0_SFIDAFVR        FR_0.SFIDAFVR.R               /* Sync Frame ID Acceptance Filter Value Register */
#define FR_0_SFIDAFMR        FR_0.SFIDAFMR.R               /* Sync Frame ID Acceptance Filter Mask Register */
#define FR_0_NMVR0           FR_0.NMVR[0].R                /* Network Management Vector Register */
#define FR_0_NMVR1           FR_0.NMVR[1].R                /* Network Management Vector Register */
#define FR_0_NMVR2           FR_0.NMVR[2].R                /* Network Management Vector Register */
#define FR_0_NMVR3           FR_0.NMVR[3].R                /* Network Management Vector Register */
#define FR_0_NMVR4           FR_0.NMVR[4].R                /* Network Management Vector Register */
#define FR_0_NMVR5           FR_0.NMVR[5].R                /* Network Management Vector Register */
#define FR_0_NMVLR           FR_0.NMVLR.R                  /* Network Management Vector Length Register */
#define FR_0_TICCR           FR_0.TICCR.R                  /* Timer Configuration and Control Register */
#define FR_0_TI1CYSR         FR_0.TI1CYSR.R                /* Timer 1 Cycle Set Register */
#define FR_0_TI1MTOR         FR_0.TI1MTOR.R                /* Timer 1 Macrotick Offset Register */
#define FR_0_TI2CR0_ABS      FR_0.TI2CR0.ABS.R             /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
#define FR_0_TI2CR0_REL      FR_0.TI2CR0.REL.R             /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
#define FR_0_TI2CR1_ABS      FR_0.TI2CR1.ABS.R             /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
#define FR_0_TI2CR1_REL      FR_0.TI2CR1.REL.R             /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
#define FR_0_SSSR            FR_0.SSSR.R                   /* Slot Status Selection Register */
#define FR_0_SSCCR           FR_0.SSCCR.R                  /* Slot Status Counter Condition Register */
#define FR_0_SSR0            FR_0.SSR[0].R                 /* Slot Status Register */
#define FR_0_SSR1            FR_0.SSR[1].R                 /* Slot Status Register */
#define FR_0_SSR2            FR_0.SSR[2].R                 /* Slot Status Register */
#define FR_0_SSR3            FR_0.SSR[3].R                 /* Slot Status Register */
#define FR_0_SSR4            FR_0.SSR[4].R                 /* Slot Status Register */
#define FR_0_SSR5            FR_0.SSR[5].R                 /* Slot Status Register */
#define FR_0_SSR6            FR_0.SSR[6].R                 /* Slot Status Register */
#define FR_0_SSR7            FR_0.SSR[7].R                 /* Slot Status Register */
#define FR_0_SSCR0           FR_0.SSCR[0].R                /* Slot Status Counter Register */
#define FR_0_SSCR1           FR_0.SSCR[1].R                /* Slot Status Counter Register */
#define FR_0_SSCR2           FR_0.SSCR[2].R                /* Slot Status Counter Register */
#define FR_0_SSCR3           FR_0.SSCR[3].R                /* Slot Status Counter Register */
#define FR_0_MTSACFR         FR_0.MTSACFR.R                /* MTS A Configuration Register */
#define FR_0_MTSBCFR         FR_0.MTSBCFR.R                /* MTS B Configuration Register */
#define FR_0_RSBIR           FR_0.RSBIR.R                  /* Receive Shadow Buffer Index Register */
#define FR_0_RFWMSR          FR_0.RFWMSR.R                 /* Receive FIFO Watermark and Selection Register */
#define FR_0_RFSIR           FR_0.RFSIR.R                  /* Receive FIFO Start Index Register */
#define FR_0_RFDSR           FR_0.RFDSR.R                  /* Receive FIFO Depth and Size Register */
#define FR_0_RFARIR          FR_0.RFARIR.R                 /* Receive FIFO A Read Index Register */
#define FR_0_RFBRIR          FR_0.RFBRIR.R                 /* Receive FIFO B Read Index Register */
#define FR_0_RFMIDAFVR       FR_0.RFMIDAFVR.R              /* Receive FIFO Message ID Acceptance Filter Value Register */
#define FR_0_RFMIDAFMR       FR_0.RFMIDAFMR.R              /* Receive FIFO Message ID Acceptance Filter Mask Register */
#define FR_0_RFFIDRFVR       FR_0.RFFIDRFVR.R              /* Receive FIFO Frame ID Rejection Filter Value Register */
#define FR_0_RFFIDRFMR       FR_0.RFFIDRFMR.R              /* Receive FIFO Frame ID Rejection Filter Mask Register */
#define FR_0_RFRFCFR         FR_0.RFRFCFR.R                /* Receive FIFO Range Filter Configuration Register */
#define FR_0_RFRFCTR         FR_0.RFRFCTR.R                /* Receive FIFO Range Filter Control Register */
#define FR_0_LDTXSLAR        FR_0.LDTXSLAR.R               /* Last Dynamic Transmit Slot Channel A Register */
#define FR_0_LDTXSLBR        FR_0.LDTXSLBR.R               /* Last Dynamic Transmit Slot Channel B Register */
#define FR_0_PCR0            FR_0.PCR0.R                   /* Protocol Configuration Register 0 */
#define FR_0_PCR1            FR_0.PCR1.R                   /* Protocol Configuration Register 1 */
#define FR_0_PCR2            FR_0.PCR2.R                   /* Protocol Configuration Register 2 */
#define FR_0_PCR3            FR_0.PCR3.R                   /* Protocol Configuration Register 3 */
#define FR_0_PCR4            FR_0.PCR4.R                   /* Protocol Configuration Register 4 */
#define FR_0_PCR5            FR_0.PCR5.R                   /* Protocol Configuration Register 5 */
#define FR_0_PCR6            FR_0.PCR6.R                   /* Protocol Configuration Register 6 */
#define FR_0_PCR7            FR_0.PCR7.R                   /* Protocol Configuration Register 7 */
#define FR_0_PCR8            FR_0.PCR8.R                   /* Protocol Configuration Register 8 */
#define FR_0_PCR9            FR_0.PCR9.R                   /* Protocol Configuration Register 9 */
#define FR_0_PCR10           FR_0.PCR10.R                  /* Protocol Configuration Register 10 */
#define FR_0_PCR11           FR_0.PCR11.R                  /* Protocol Configuration Register 11 */
#define FR_0_PCR12           FR_0.PCR12.R                  /* Protocol Configuration Register 12 */
#define FR_0_PCR13           FR_0.PCR13.R                  /* Protocol Configuration Register 13 */
#define FR_0_PCR14           FR_0.PCR14.R                  /* Protocol Configuration Register 14 */
#define FR_0_PCR15           FR_0.PCR15.R                  /* Protocol Configuration Register 15 */
#define FR_0_PCR16           FR_0.PCR16.R                  /* Protocol Configuration Register 16 */
#define FR_0_PCR17           FR_0.PCR17.R                  /* Protocol Configuration Register 17 */
#define FR_0_PCR18           FR_0.PCR18.R                  /* Protocol Configuration Register 18 */
#define FR_0_PCR19           FR_0.PCR19.R                  /* Protocol Configuration Register 19 */
#define FR_0_PCR20           FR_0.PCR20.R                  /* Protocol Configuration Register 20 */
#define FR_0_PCR21           FR_0.PCR21.R                  /* Protocol Configuration Register 21 */
#define FR_0_PCR22           FR_0.PCR22.R                  /* Protocol Configuration Register 22 */
#define FR_0_PCR23           FR_0.PCR23.R                  /* Protocol Configuration Register 23 */
#define FR_0_PCR24           FR_0.PCR24.R                  /* Protocol Configuration Register 24 */
#define FR_0_PCR25           FR_0.PCR25.R                  /* Protocol Configuration Register 25 */
#define FR_0_PCR26           FR_0.PCR26.R                  /* Protocol Configuration Register 26 */
#define FR_0_PCR27           FR_0.PCR27.R                  /* Protocol Configuration Register 27 */
#define FR_0_PCR28           FR_0.PCR28.R                  /* Protocol Configuration Register 28 */
#define FR_0_PCR29           FR_0.PCR29.R                  /* Protocol Configuration Register 29 */
#define FR_0_PCR30           FR_0.PCR30.R                  /* Protocol Configuration Register 30 */
#define FR_0_PEOER           FR_0.PEOER.R                  /* Protocol Event Output Enable Register */
#define FR_0_RFSDOR          FR_0.RFSDOR.R                 /* Receive FIFO Start Data Offset Register */
#define FR_0_RFSYMBADHR      FR_0.RFSYMBADHR.R             /* Receive FIFO System Memory Base Address High Register */
#define FR_0_RFSYMBADLR      FR_0.RFSYMBADLR.R             /* Receive FIFO System Memory Base Address Low Register */
#define FR_0_RFPTR           FR_0.RFPTR.R                  /* Receive FIFO Periodic Timer Register */
#define FR_0_RFFLPCR         FR_0.RFFLPCR.R                /* Receive FIFO Fill Level and POP Count Register */
#define FR_0_EEIFER          FR_0.EEIFER.R                 /* ECC Error Interrupt Flag and Enable Register */
#define FR_0_EERICR          FR_0.EERICR.R                 /* ECC Error Report and Injection Control Register */
#define FR_0_EERAR           FR_0.EERAR.R                  /* ECC Error Report Address Register */
#define FR_0_EERDR           FR_0.EERDR.R                  /* ECC Error Report Data Register */
#define FR_0_EERCR           FR_0.EERCR.R                  /* ECC Error Report Code Register */
#define FR_0_EEIAR           FR_0.EEIAR.R                  /* ECC Error Injection Address Register */
#define FR_0_EEIDR           FR_0.EEIDR.R                  /* ECC Error Injection Data Register */
#define FR_0_EEICR           FR_0.EEICR.R                  /* ECC Error Injection Code Register */
#define FR_0_MBCCSR0         FR_0.MB[0].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR0         FR_0.MB[0].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR0         FR_0.MB[0].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR0         FR_0.MB[0].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR1         FR_0.MB[1].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR1         FR_0.MB[1].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR1         FR_0.MB[1].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR1         FR_0.MB[1].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR2         FR_0.MB[2].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR2         FR_0.MB[2].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR2         FR_0.MB[2].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR2         FR_0.MB[2].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR3         FR_0.MB[3].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR3         FR_0.MB[3].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR3         FR_0.MB[3].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR3         FR_0.MB[3].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR4         FR_0.MB[4].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR4         FR_0.MB[4].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR4         FR_0.MB[4].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR4         FR_0.MB[4].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR5         FR_0.MB[5].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR5         FR_0.MB[5].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR5         FR_0.MB[5].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR5         FR_0.MB[5].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR6         FR_0.MB[6].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR6         FR_0.MB[6].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR6         FR_0.MB[6].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR6         FR_0.MB[6].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR7         FR_0.MB[7].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR7         FR_0.MB[7].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR7         FR_0.MB[7].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR7         FR_0.MB[7].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR8         FR_0.MB[8].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR8         FR_0.MB[8].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR8         FR_0.MB[8].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR8         FR_0.MB[8].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR9         FR_0.MB[9].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR9         FR_0.MB[9].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR9         FR_0.MB[9].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR9         FR_0.MB[9].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR10        FR_0.MB[10].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR10        FR_0.MB[10].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR10        FR_0.MB[10].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR10        FR_0.MB[10].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR11        FR_0.MB[11].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR11        FR_0.MB[11].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR11        FR_0.MB[11].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR11        FR_0.MB[11].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR12        FR_0.MB[12].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR12        FR_0.MB[12].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR12        FR_0.MB[12].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR12        FR_0.MB[12].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR13        FR_0.MB[13].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR13        FR_0.MB[13].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR13        FR_0.MB[13].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR13        FR_0.MB[13].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR14        FR_0.MB[14].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR14        FR_0.MB[14].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR14        FR_0.MB[14].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR14        FR_0.MB[14].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR15        FR_0.MB[15].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR15        FR_0.MB[15].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR15        FR_0.MB[15].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR15        FR_0.MB[15].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR16        FR_0.MB[16].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR16        FR_0.MB[16].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR16        FR_0.MB[16].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR16        FR_0.MB[16].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR17        FR_0.MB[17].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR17        FR_0.MB[17].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR17        FR_0.MB[17].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR17        FR_0.MB[17].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR18        FR_0.MB[18].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR18        FR_0.MB[18].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR18        FR_0.MB[18].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR18        FR_0.MB[18].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR19        FR_0.MB[19].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR19        FR_0.MB[19].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR19        FR_0.MB[19].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR19        FR_0.MB[19].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR20        FR_0.MB[20].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR20        FR_0.MB[20].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR20        FR_0.MB[20].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR20        FR_0.MB[20].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR21        FR_0.MB[21].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR21        FR_0.MB[21].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR21        FR_0.MB[21].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR21        FR_0.MB[21].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR22        FR_0.MB[22].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR22        FR_0.MB[22].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR22        FR_0.MB[22].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR22        FR_0.MB[22].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR23        FR_0.MB[23].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR23        FR_0.MB[23].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR23        FR_0.MB[23].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR23        FR_0.MB[23].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR24        FR_0.MB[24].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR24        FR_0.MB[24].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR24        FR_0.MB[24].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR24        FR_0.MB[24].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR25        FR_0.MB[25].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR25        FR_0.MB[25].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR25        FR_0.MB[25].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR25        FR_0.MB[25].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR26        FR_0.MB[26].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR26        FR_0.MB[26].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR26        FR_0.MB[26].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR26        FR_0.MB[26].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR27        FR_0.MB[27].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR27        FR_0.MB[27].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR27        FR_0.MB[27].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR27        FR_0.MB[27].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR28        FR_0.MB[28].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR28        FR_0.MB[28].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR28        FR_0.MB[28].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR28        FR_0.MB[28].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR29        FR_0.MB[29].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR29        FR_0.MB[29].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR29        FR_0.MB[29].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR29        FR_0.MB[29].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR30        FR_0.MB[30].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR30        FR_0.MB[30].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR30        FR_0.MB[30].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR30        FR_0.MB[30].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR31        FR_0.MB[31].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR31        FR_0.MB[31].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR31        FR_0.MB[31].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR31        FR_0.MB[31].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR32        FR_0.MB[32].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR32        FR_0.MB[32].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR32        FR_0.MB[32].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR32        FR_0.MB[32].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR33        FR_0.MB[33].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR33        FR_0.MB[33].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR33        FR_0.MB[33].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR33        FR_0.MB[33].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR34        FR_0.MB[34].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR34        FR_0.MB[34].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR34        FR_0.MB[34].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR34        FR_0.MB[34].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR35        FR_0.MB[35].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR35        FR_0.MB[35].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR35        FR_0.MB[35].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR35        FR_0.MB[35].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR36        FR_0.MB[36].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR36        FR_0.MB[36].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR36        FR_0.MB[36].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR36        FR_0.MB[36].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR37        FR_0.MB[37].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR37        FR_0.MB[37].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR37        FR_0.MB[37].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR37        FR_0.MB[37].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR38        FR_0.MB[38].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR38        FR_0.MB[38].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR38        FR_0.MB[38].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR38        FR_0.MB[38].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR39        FR_0.MB[39].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR39        FR_0.MB[39].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR39        FR_0.MB[39].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR39        FR_0.MB[39].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR40        FR_0.MB[40].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR40        FR_0.MB[40].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR40        FR_0.MB[40].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR40        FR_0.MB[40].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR41        FR_0.MB[41].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR41        FR_0.MB[41].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR41        FR_0.MB[41].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR41        FR_0.MB[41].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR42        FR_0.MB[42].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR42        FR_0.MB[42].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR42        FR_0.MB[42].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR42        FR_0.MB[42].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR43        FR_0.MB[43].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR43        FR_0.MB[43].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR43        FR_0.MB[43].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR43        FR_0.MB[43].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR44        FR_0.MB[44].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR44        FR_0.MB[44].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR44        FR_0.MB[44].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR44        FR_0.MB[44].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR45        FR_0.MB[45].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR45        FR_0.MB[45].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR45        FR_0.MB[45].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR45        FR_0.MB[45].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR46        FR_0.MB[46].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR46        FR_0.MB[46].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR46        FR_0.MB[46].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR46        FR_0.MB[46].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR47        FR_0.MB[47].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR47        FR_0.MB[47].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR47        FR_0.MB[47].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR47        FR_0.MB[47].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR48        FR_0.MB[48].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR48        FR_0.MB[48].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR48        FR_0.MB[48].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR48        FR_0.MB[48].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR49        FR_0.MB[49].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR49        FR_0.MB[49].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR49        FR_0.MB[49].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR49        FR_0.MB[49].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR50        FR_0.MB[50].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR50        FR_0.MB[50].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR50        FR_0.MB[50].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR50        FR_0.MB[50].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR51        FR_0.MB[51].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR51        FR_0.MB[51].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR51        FR_0.MB[51].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR51        FR_0.MB[51].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR52        FR_0.MB[52].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR52        FR_0.MB[52].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR52        FR_0.MB[52].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR52        FR_0.MB[52].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR53        FR_0.MB[53].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR53        FR_0.MB[53].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR53        FR_0.MB[53].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR53        FR_0.MB[53].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR54        FR_0.MB[54].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR54        FR_0.MB[54].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR54        FR_0.MB[54].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR54        FR_0.MB[54].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR55        FR_0.MB[55].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR55        FR_0.MB[55].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR55        FR_0.MB[55].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR55        FR_0.MB[55].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR56        FR_0.MB[56].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR56        FR_0.MB[56].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR56        FR_0.MB[56].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR56        FR_0.MB[56].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR57        FR_0.MB[57].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR57        FR_0.MB[57].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR57        FR_0.MB[57].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR57        FR_0.MB[57].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR58        FR_0.MB[58].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR58        FR_0.MB[58].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR58        FR_0.MB[58].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR58        FR_0.MB[58].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR59        FR_0.MB[59].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR59        FR_0.MB[59].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR59        FR_0.MB[59].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR59        FR_0.MB[59].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR60        FR_0.MB[60].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR60        FR_0.MB[60].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR60        FR_0.MB[60].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR60        FR_0.MB[60].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR61        FR_0.MB[61].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR61        FR_0.MB[61].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR61        FR_0.MB[61].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR61        FR_0.MB[61].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR62        FR_0.MB[62].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR62        FR_0.MB[62].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR62        FR_0.MB[62].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR62        FR_0.MB[62].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR63        FR_0.MB[63].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR63        FR_0.MB[63].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR63        FR_0.MB[63].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR63        FR_0.MB[63].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBDOR0          FR_0.MBDOR[0].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR1          FR_0.MBDOR[1].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR2          FR_0.MBDOR[2].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR3          FR_0.MBDOR[3].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR4          FR_0.MBDOR[4].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR5          FR_0.MBDOR[5].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR6          FR_0.MBDOR[6].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR7          FR_0.MBDOR[7].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR8          FR_0.MBDOR[8].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR9          FR_0.MBDOR[9].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR10         FR_0.MBDOR[10].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR11         FR_0.MBDOR[11].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR12         FR_0.MBDOR[12].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR13         FR_0.MBDOR[13].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR14         FR_0.MBDOR[14].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR15         FR_0.MBDOR[15].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR16         FR_0.MBDOR[16].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR17         FR_0.MBDOR[17].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR18         FR_0.MBDOR[18].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR19         FR_0.MBDOR[19].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR20         FR_0.MBDOR[20].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR21         FR_0.MBDOR[21].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR22         FR_0.MBDOR[22].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR23         FR_0.MBDOR[23].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR24         FR_0.MBDOR[24].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR25         FR_0.MBDOR[25].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR26         FR_0.MBDOR[26].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR27         FR_0.MBDOR[27].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR28         FR_0.MBDOR[28].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR29         FR_0.MBDOR[29].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR30         FR_0.MBDOR[30].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR31         FR_0.MBDOR[31].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR32         FR_0.MBDOR[32].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR33         FR_0.MBDOR[33].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR34         FR_0.MBDOR[34].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR35         FR_0.MBDOR[35].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR36         FR_0.MBDOR[36].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR37         FR_0.MBDOR[37].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR38         FR_0.MBDOR[38].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR39         FR_0.MBDOR[39].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR40         FR_0.MBDOR[40].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR41         FR_0.MBDOR[41].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR42         FR_0.MBDOR[42].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR43         FR_0.MBDOR[43].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR44         FR_0.MBDOR[44].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR45         FR_0.MBDOR[45].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR46         FR_0.MBDOR[46].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR47         FR_0.MBDOR[47].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR48         FR_0.MBDOR[48].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR49         FR_0.MBDOR[49].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR50         FR_0.MBDOR[50].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR51         FR_0.MBDOR[51].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR52         FR_0.MBDOR[52].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR53         FR_0.MBDOR[53].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR54         FR_0.MBDOR[54].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR55         FR_0.MBDOR[55].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR56         FR_0.MBDOR[56].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR57         FR_0.MBDOR[57].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR58         FR_0.MBDOR[58].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR59         FR_0.MBDOR[59].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR60         FR_0.MBDOR[60].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR61         FR_0.MBDOR[61].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR62         FR_0.MBDOR[62].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR63         FR_0.MBDOR[63].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR64         FR_0.MBDOR[64].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR65         FR_0.MBDOR[65].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR66         FR_0.MBDOR[66].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR67         FR_0.MBDOR[67].R              /* Message Buffer Data Field Offset Register */
#define FR_0_LEETR0          FR_0.LEETR[0].R               /* LRAM ECC Error Test Register */
#define FR_0_LEETR1          FR_0.LEETR[1].R               /* LRAM ECC Error Test Register */
#define FR_0_LEETR2          FR_0.LEETR[2].R               /* LRAM ECC Error Test Register */
#define FR_0_LEETR3          FR_0.LEETR[3].R               /* LRAM ECC Error Test Register */
#define FR_0_LEETR4          FR_0.LEETR[4].R               /* LRAM ECC Error Test Register */
#define FR_0_LEETR5          FR_0.LEETR[5].R               /* LRAM ECC Error Test Register */

/* FlexPWM */
#define FlexPWM_0_SUB0_CNT   FlexPWM_0.SUB[0].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_0_SUB0_INIT  FlexPWM_0.SUB[0].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_0_SUB0_CTRL2 FlexPWM_0.SUB[0].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_0_SUB0_CTRL1 FlexPWM_0.SUB[0].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_0_SUB0_VAL0  FlexPWM_0.SUB[0].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_0_SUB0_VAL1  FlexPWM_0.SUB[0].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_0_SUB0_VAL2  FlexPWM_0.SUB[0].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_0_SUB0_VAL3  FlexPWM_0.SUB[0].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_0_SUB0_VAL4  FlexPWM_0.SUB[0].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_0_SUB0_VAL5  FlexPWM_0.SUB[0].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_0_SUB0_OCTRL FlexPWM_0.SUB[0].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_0_SUB0_STS   FlexPWM_0.SUB[0].STS.R        /* Submodule n Status Register */
#define FlexPWM_0_SUB0_INTEN FlexPWM_0.SUB[0].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_0_SUB0_DMAEN FlexPWM_0.SUB[0].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_0_SUB0_TCTRL FlexPWM_0.SUB[0].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_0_SUB0_DISMAP FlexPWM_0.SUB[0].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_0_SUB0_DTCNT0 FlexPWM_0.SUB[0].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_0_SUB0_DTCNT1 FlexPWM_0.SUB[0].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_0_SUB0_CAPTCTRLX FlexPWM_0.SUB[0].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_0_SUB0_CAPTCMPX FlexPWM_0.SUB[0].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_0_SUB0_CVAL0 FlexPWM_0.SUB[0].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_0_SUB0_CVAL0CYC FlexPWM_0.SUB[0].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_0_SUB0_CVAL1 FlexPWM_0.SUB[0].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_0_SUB0_CVAL1CYC FlexPWM_0.SUB[0].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_0_SUB1_CNT   FlexPWM_0.SUB[1].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_0_SUB1_INIT  FlexPWM_0.SUB[1].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_0_SUB1_CTRL2 FlexPWM_0.SUB[1].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_0_SUB1_CTRL1 FlexPWM_0.SUB[1].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_0_SUB1_VAL0  FlexPWM_0.SUB[1].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_0_SUB1_VAL1  FlexPWM_0.SUB[1].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_0_SUB1_VAL2  FlexPWM_0.SUB[1].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_0_SUB1_VAL3  FlexPWM_0.SUB[1].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_0_SUB1_VAL4  FlexPWM_0.SUB[1].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_0_SUB1_VAL5  FlexPWM_0.SUB[1].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_0_SUB1_OCTRL FlexPWM_0.SUB[1].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_0_SUB1_STS   FlexPWM_0.SUB[1].STS.R        /* Submodule n Status Register */
#define FlexPWM_0_SUB1_INTEN FlexPWM_0.SUB[1].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_0_SUB1_DMAEN FlexPWM_0.SUB[1].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_0_SUB1_TCTRL FlexPWM_0.SUB[1].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_0_SUB1_DISMAP FlexPWM_0.SUB[1].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_0_SUB1_DTCNT0 FlexPWM_0.SUB[1].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_0_SUB1_DTCNT1 FlexPWM_0.SUB[1].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_0_SUB1_CAPTCTRLX FlexPWM_0.SUB[1].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_0_SUB1_CAPTCMPX FlexPWM_0.SUB[1].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_0_SUB1_CVAL0 FlexPWM_0.SUB[1].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_0_SUB1_CVAL0CYC FlexPWM_0.SUB[1].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_0_SUB1_CVAL1 FlexPWM_0.SUB[1].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_0_SUB1_CVAL1CYC FlexPWM_0.SUB[1].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_0_SUB2_CNT   FlexPWM_0.SUB[2].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_0_SUB2_INIT  FlexPWM_0.SUB[2].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_0_SUB2_CTRL2 FlexPWM_0.SUB[2].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_0_SUB2_CTRL1 FlexPWM_0.SUB[2].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_0_SUB2_VAL0  FlexPWM_0.SUB[2].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_0_SUB2_VAL1  FlexPWM_0.SUB[2].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_0_SUB2_VAL2  FlexPWM_0.SUB[2].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_0_SUB2_VAL3  FlexPWM_0.SUB[2].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_0_SUB2_VAL4  FlexPWM_0.SUB[2].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_0_SUB2_VAL5  FlexPWM_0.SUB[2].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_0_SUB2_OCTRL FlexPWM_0.SUB[2].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_0_SUB2_STS   FlexPWM_0.SUB[2].STS.R        /* Submodule n Status Register */
#define FlexPWM_0_SUB2_INTEN FlexPWM_0.SUB[2].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_0_SUB2_DMAEN FlexPWM_0.SUB[2].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_0_SUB2_TCTRL FlexPWM_0.SUB[2].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_0_SUB2_DISMAP FlexPWM_0.SUB[2].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_0_SUB2_DTCNT0 FlexPWM_0.SUB[2].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_0_SUB2_DTCNT1 FlexPWM_0.SUB[2].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_0_SUB2_CAPTCTRLX FlexPWM_0.SUB[2].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_0_SUB2_CAPTCMPX FlexPWM_0.SUB[2].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_0_SUB2_CVAL0 FlexPWM_0.SUB[2].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_0_SUB2_CVAL0CYC FlexPWM_0.SUB[2].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_0_SUB2_CVAL1 FlexPWM_0.SUB[2].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_0_SUB2_CVAL1CYC FlexPWM_0.SUB[2].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_0_SUB3_CNT   FlexPWM_0.SUB[3].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_0_SUB3_INIT  FlexPWM_0.SUB[3].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_0_SUB3_CTRL2 FlexPWM_0.SUB[3].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_0_SUB3_CTRL1 FlexPWM_0.SUB[3].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_0_SUB3_VAL0  FlexPWM_0.SUB[3].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_0_SUB3_VAL1  FlexPWM_0.SUB[3].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_0_SUB3_VAL2  FlexPWM_0.SUB[3].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_0_SUB3_VAL3  FlexPWM_0.SUB[3].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_0_SUB3_VAL4  FlexPWM_0.SUB[3].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_0_SUB3_VAL5  FlexPWM_0.SUB[3].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_0_SUB3_OCTRL FlexPWM_0.SUB[3].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_0_SUB3_STS   FlexPWM_0.SUB[3].STS.R        /* Submodule n Status Register */
#define FlexPWM_0_SUB3_INTEN FlexPWM_0.SUB[3].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_0_SUB3_DMAEN FlexPWM_0.SUB[3].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_0_SUB3_TCTRL FlexPWM_0.SUB[3].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_0_SUB3_DISMAP FlexPWM_0.SUB[3].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_0_SUB3_DTCNT0 FlexPWM_0.SUB[3].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_0_SUB3_DTCNT1 FlexPWM_0.SUB[3].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_0_SUB3_CAPTCTRLX FlexPWM_0.SUB[3].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_0_SUB3_CAPTCMPX FlexPWM_0.SUB[3].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_0_SUB3_CVAL0 FlexPWM_0.SUB[3].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_0_SUB3_CVAL0CYC FlexPWM_0.SUB[3].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_0_SUB3_CVAL1 FlexPWM_0.SUB[3].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_0_SUB3_CVAL1CYC FlexPWM_0.SUB[3].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_0_OUTEN      FlexPWM_0.OUTEN.R             /* Output Enable Register */
#define FlexPWM_0_MASK       FlexPWM_0.MASK.R              /* Mask Register */
#define FlexPWM_0_SWCOUT     FlexPWM_0.SWCOUT.R            /* Software Controlled Output Register */
#define FlexPWM_0_DTSRCSEL   FlexPWM_0.DTSRCSEL.R          /* Deadtime Source Select Register */
#define FlexPWM_0_MCTRL      FlexPWM_0.MCTRL.R             /* Master Control Register */
#define FlexPWM_0_FCTRL      FlexPWM_0.FCTRL.R             /* Fault Control Register */
#define FlexPWM_0_FSTS       FlexPWM_0.FSTS.R              /* Fault Status Register */
#define FlexPWM_0_FFILT      FlexPWM_0.FFILT.R             /* Fault Filter Register */

/* FlexPWM */
#define FlexPWM_1_SUB0_CNT   FlexPWM_1.SUB[0].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_1_SUB0_INIT  FlexPWM_1.SUB[0].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_1_SUB0_CTRL2 FlexPWM_1.SUB[0].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_1_SUB0_CTRL1 FlexPWM_1.SUB[0].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_1_SUB0_VAL0  FlexPWM_1.SUB[0].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_1_SUB0_VAL1  FlexPWM_1.SUB[0].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_1_SUB0_VAL2  FlexPWM_1.SUB[0].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_1_SUB0_VAL3  FlexPWM_1.SUB[0].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_1_SUB0_VAL4  FlexPWM_1.SUB[0].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_1_SUB0_VAL5  FlexPWM_1.SUB[0].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_1_SUB0_OCTRL FlexPWM_1.SUB[0].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_1_SUB0_STS   FlexPWM_1.SUB[0].STS.R        /* Submodule n Status Register */
#define FlexPWM_1_SUB0_INTEN FlexPWM_1.SUB[0].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_1_SUB0_DMAEN FlexPWM_1.SUB[0].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_1_SUB0_TCTRL FlexPWM_1.SUB[0].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_1_SUB0_DISMAP FlexPWM_1.SUB[0].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_1_SUB0_DTCNT0 FlexPWM_1.SUB[0].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_1_SUB0_DTCNT1 FlexPWM_1.SUB[0].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_1_SUB0_CAPTCTRLX FlexPWM_1.SUB[0].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_1_SUB0_CAPTCMPX FlexPWM_1.SUB[0].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_1_SUB0_CVAL0 FlexPWM_1.SUB[0].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_1_SUB0_CVAL0CYC FlexPWM_1.SUB[0].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_1_SUB0_CVAL1 FlexPWM_1.SUB[0].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_1_SUB0_CVAL1CYC FlexPWM_1.SUB[0].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_1_SUB1_CNT   FlexPWM_1.SUB[1].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_1_SUB1_INIT  FlexPWM_1.SUB[1].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_1_SUB1_CTRL2 FlexPWM_1.SUB[1].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_1_SUB1_CTRL1 FlexPWM_1.SUB[1].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_1_SUB1_VAL0  FlexPWM_1.SUB[1].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_1_SUB1_VAL1  FlexPWM_1.SUB[1].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_1_SUB1_VAL2  FlexPWM_1.SUB[1].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_1_SUB1_VAL3  FlexPWM_1.SUB[1].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_1_SUB1_VAL4  FlexPWM_1.SUB[1].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_1_SUB1_VAL5  FlexPWM_1.SUB[1].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_1_SUB1_OCTRL FlexPWM_1.SUB[1].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_1_SUB1_STS   FlexPWM_1.SUB[1].STS.R        /* Submodule n Status Register */
#define FlexPWM_1_SUB1_INTEN FlexPWM_1.SUB[1].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_1_SUB1_DMAEN FlexPWM_1.SUB[1].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_1_SUB1_TCTRL FlexPWM_1.SUB[1].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_1_SUB1_DISMAP FlexPWM_1.SUB[1].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_1_SUB1_DTCNT0 FlexPWM_1.SUB[1].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_1_SUB1_DTCNT1 FlexPWM_1.SUB[1].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_1_SUB1_CAPTCTRLX FlexPWM_1.SUB[1].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_1_SUB1_CAPTCMPX FlexPWM_1.SUB[1].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_1_SUB1_CVAL0 FlexPWM_1.SUB[1].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_1_SUB1_CVAL0CYC FlexPWM_1.SUB[1].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_1_SUB1_CVAL1 FlexPWM_1.SUB[1].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_1_SUB1_CVAL1CYC FlexPWM_1.SUB[1].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_1_SUB2_CNT   FlexPWM_1.SUB[2].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_1_SUB2_INIT  FlexPWM_1.SUB[2].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_1_SUB2_CTRL2 FlexPWM_1.SUB[2].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_1_SUB2_CTRL1 FlexPWM_1.SUB[2].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_1_SUB2_VAL0  FlexPWM_1.SUB[2].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_1_SUB2_VAL1  FlexPWM_1.SUB[2].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_1_SUB2_VAL2  FlexPWM_1.SUB[2].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_1_SUB2_VAL3  FlexPWM_1.SUB[2].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_1_SUB2_VAL4  FlexPWM_1.SUB[2].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_1_SUB2_VAL5  FlexPWM_1.SUB[2].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_1_SUB2_OCTRL FlexPWM_1.SUB[2].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_1_SUB2_STS   FlexPWM_1.SUB[2].STS.R        /* Submodule n Status Register */
#define FlexPWM_1_SUB2_INTEN FlexPWM_1.SUB[2].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_1_SUB2_DMAEN FlexPWM_1.SUB[2].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_1_SUB2_TCTRL FlexPWM_1.SUB[2].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_1_SUB2_DISMAP FlexPWM_1.SUB[2].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_1_SUB2_DTCNT0 FlexPWM_1.SUB[2].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_1_SUB2_DTCNT1 FlexPWM_1.SUB[2].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_1_SUB2_CAPTCTRLX FlexPWM_1.SUB[2].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_1_SUB2_CAPTCMPX FlexPWM_1.SUB[2].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_1_SUB2_CVAL0 FlexPWM_1.SUB[2].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_1_SUB2_CVAL0CYC FlexPWM_1.SUB[2].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_1_SUB2_CVAL1 FlexPWM_1.SUB[2].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_1_SUB2_CVAL1CYC FlexPWM_1.SUB[2].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_1_SUB3_CNT   FlexPWM_1.SUB[3].CNT.R        /* Submodule n Counter Register */
#define FlexPWM_1_SUB3_INIT  FlexPWM_1.SUB[3].INIT.R       /* Submodule n Initial Count Register */
#define FlexPWM_1_SUB3_CTRL2 FlexPWM_1.SUB[3].CTRL2.R      /* Submodule n Control 2 Register */
#define FlexPWM_1_SUB3_CTRL1 FlexPWM_1.SUB[3].CTRL1.R      /* Submodule n Control 1 Register */
#define FlexPWM_1_SUB3_VAL0  FlexPWM_1.SUB[3].VAL0.R       /* Submodule n Value Register 0 */
#define FlexPWM_1_SUB3_VAL1  FlexPWM_1.SUB[3].VAL1.R       /* Submodule n Value Register 1 */
#define FlexPWM_1_SUB3_VAL2  FlexPWM_1.SUB[3].VAL2.R       /* Submodule n Value Register 2 */
#define FlexPWM_1_SUB3_VAL3  FlexPWM_1.SUB[3].VAL3.R       /* Submodule n Value Register 3 */
#define FlexPWM_1_SUB3_VAL4  FlexPWM_1.SUB[3].VAL4.R       /* Submodule n Value Register 4 */
#define FlexPWM_1_SUB3_VAL5  FlexPWM_1.SUB[3].VAL5.R       /* Submodule n Value Register 5 */
#define FlexPWM_1_SUB3_OCTRL FlexPWM_1.SUB[3].OCTRL.R      /* Submodule n Output Control Register */
#define FlexPWM_1_SUB3_STS   FlexPWM_1.SUB[3].STS.R        /* Submodule n Status Register */
#define FlexPWM_1_SUB3_INTEN FlexPWM_1.SUB[3].INTEN.R      /* Submodule n Interrupt Enable Register */
#define FlexPWM_1_SUB3_DMAEN FlexPWM_1.SUB[3].DMAEN.R      /* Submodule n DMA Enable Register */
#define FlexPWM_1_SUB3_TCTRL FlexPWM_1.SUB[3].TCTRL.R      /* Submodule n Output Trigger Control Register */
#define FlexPWM_1_SUB3_DISMAP FlexPWM_1.SUB[3].DISMAP.R    /* Submodule n Fault Disable Mapping Register */
#define FlexPWM_1_SUB3_DTCNT0 FlexPWM_1.SUB[3].DTCNT0.R    /* Submodule n Deadtime Count Register 0 */
#define FlexPWM_1_SUB3_DTCNT1 FlexPWM_1.SUB[3].DTCNT1.R    /* Submodule n Deadtime Count Register 1 */
#define FlexPWM_1_SUB3_CAPTCTRLX FlexPWM_1.SUB[3].CAPTCTRLX.R /* Submodule n Capture Control X Register */
#define FlexPWM_1_SUB3_CAPTCMPX FlexPWM_1.SUB[3].CAPTCMPX.R /* Submodule n Capture Compare X Register */
#define FlexPWM_1_SUB3_CVAL0 FlexPWM_1.SUB[3].CVAL0.R      /* Submodule n Capture Value 0 Register */
#define FlexPWM_1_SUB3_CVAL0CYC FlexPWM_1.SUB[3].CVAL0CYC.R /* Submodule n Capture Value 0 Cycle Register */
#define FlexPWM_1_SUB3_CVAL1 FlexPWM_1.SUB[3].CVAL1.R      /* Submodule n Capture Value 1 Register */
#define FlexPWM_1_SUB3_CVAL1CYC FlexPWM_1.SUB[3].CVAL1CYC.R /* Submodule n Capture Value 1 Cycle Register */
#define FlexPWM_1_OUTEN      FlexPWM_1.OUTEN.R             /* Output Enable Register */
#define FlexPWM_1_MASK       FlexPWM_1.MASK.R              /* Mask Register */
#define FlexPWM_1_SWCOUT     FlexPWM_1.SWCOUT.R            /* Software Controlled Output Register */
#define FlexPWM_1_DTSRCSEL   FlexPWM_1.DTSRCSEL.R          /* Deadtime Source Select Register */
#define FlexPWM_1_MCTRL      FlexPWM_1.MCTRL.R             /* Master Control Register */
#define FlexPWM_1_FCTRL      FlexPWM_1.FCTRL.R             /* Fault Control Register */
#define FlexPWM_1_FSTS       FlexPWM_1.FSTS.R              /* Fault Status Register */
#define FlexPWM_1_FFILT      FlexPWM_1.FFILT.R             /* Fault Filter Register */

/* INTC */
#define INTC_0_BCR           INTC_0.BCR.R                  /* INTC Block Configuration Register */
#define INTC_0_CPR0          INTC_0.CPR[0].R               /* INTC Current Priority Register for Processor n */
#define INTC_0_IACKR0        INTC_0.IACKR[0].R             /* INTC Interrupt Acknowledge Register for Processor n */
#define INTC_0_EOIR0         INTC_0.EOIR[0].R              /* INTC End Of Interrupt Register for Processor n */
#define INTC_0_SSCIR0        INTC_0.SSCIR[0].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR1        INTC_0.SSCIR[1].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR2        INTC_0.SSCIR[2].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR3        INTC_0.SSCIR[3].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR4        INTC_0.SSCIR[4].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR5        INTC_0.SSCIR[5].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR6        INTC_0.SSCIR[6].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR7        INTC_0.SSCIR[7].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR8        INTC_0.SSCIR[8].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR9        INTC_0.SSCIR[9].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR10       INTC_0.SSCIR[10].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR11       INTC_0.SSCIR[11].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR12       INTC_0.SSCIR[12].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR13       INTC_0.SSCIR[13].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR14       INTC_0.SSCIR[14].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR15       INTC_0.SSCIR[15].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_PSR0          INTC_0.PSR[0].R               /* INTC Priority Select Register */
#define INTC_0_PSR1          INTC_0.PSR[1].R               /* INTC Priority Select Register */
#define INTC_0_PSR2          INTC_0.PSR[2].R               /* INTC Priority Select Register */
#define INTC_0_PSR3          INTC_0.PSR[3].R               /* INTC Priority Select Register */
#define INTC_0_PSR4          INTC_0.PSR[4].R               /* INTC Priority Select Register */
#define INTC_0_PSR5          INTC_0.PSR[5].R               /* INTC Priority Select Register */
#define INTC_0_PSR6          INTC_0.PSR[6].R               /* INTC Priority Select Register */
#define INTC_0_PSR7          INTC_0.PSR[7].R               /* INTC Priority Select Register */
#define INTC_0_PSR8          INTC_0.PSR[8].R               /* INTC Priority Select Register */
#define INTC_0_PSR9          INTC_0.PSR[9].R               /* INTC Priority Select Register */
#define INTC_0_PSR10         INTC_0.PSR[10].R              /* INTC Priority Select Register */
#define INTC_0_PSR11         INTC_0.PSR[11].R              /* INTC Priority Select Register */
#define INTC_0_PSR12         INTC_0.PSR[12].R              /* INTC Priority Select Register */
#define INTC_0_PSR13         INTC_0.PSR[13].R              /* INTC Priority Select Register */
#define INTC_0_PSR14         INTC_0.PSR[14].R              /* INTC Priority Select Register */
#define INTC_0_PSR15         INTC_0.PSR[15].R              /* INTC Priority Select Register */
#define INTC_0_PSR16         INTC_0.PSR[16].R              /* INTC Priority Select Register */
#define INTC_0_PSR17         INTC_0.PSR[17].R              /* INTC Priority Select Register */
#define INTC_0_PSR18         INTC_0.PSR[18].R              /* INTC Priority Select Register */
#define INTC_0_PSR19         INTC_0.PSR[19].R              /* INTC Priority Select Register */
#define INTC_0_PSR20         INTC_0.PSR[20].R              /* INTC Priority Select Register */
#define INTC_0_PSR21         INTC_0.PSR[21].R              /* INTC Priority Select Register */
#define INTC_0_PSR22         INTC_0.PSR[22].R              /* INTC Priority Select Register */
#define INTC_0_PSR23         INTC_0.PSR[23].R              /* INTC Priority Select Register */
#define INTC_0_PSR24         INTC_0.PSR[24].R              /* INTC Priority Select Register */
#define INTC_0_PSR25         INTC_0.PSR[25].R              /* INTC Priority Select Register */
#define INTC_0_PSR26         INTC_0.PSR[26].R              /* INTC Priority Select Register */
#define INTC_0_PSR27         INTC_0.PSR[27].R              /* INTC Priority Select Register */
#define INTC_0_PSR28         INTC_0.PSR[28].R              /* INTC Priority Select Register */
#define INTC_0_PSR29         INTC_0.PSR[29].R              /* INTC Priority Select Register */
#define INTC_0_PSR30         INTC_0.PSR[30].R              /* INTC Priority Select Register */
#define INTC_0_PSR31         INTC_0.PSR[31].R              /* INTC Priority Select Register */
#define INTC_0_PSR32         INTC_0.PSR[32].R              /* INTC Priority Select Register */
#define INTC_0_PSR33         INTC_0.PSR[33].R              /* INTC Priority Select Register */
#define INTC_0_PSR34         INTC_0.PSR[34].R              /* INTC Priority Select Register */
#define INTC_0_PSR35         INTC_0.PSR[35].R              /* INTC Priority Select Register */
#define INTC_0_PSR36         INTC_0.PSR[36].R              /* INTC Priority Select Register */
#define INTC_0_PSR37         INTC_0.PSR[37].R              /* INTC Priority Select Register */
#define INTC_0_PSR38         INTC_0.PSR[38].R              /* INTC Priority Select Register */
#define INTC_0_PSR39         INTC_0.PSR[39].R              /* INTC Priority Select Register */
#define INTC_0_PSR40         INTC_0.PSR[40].R              /* INTC Priority Select Register */
#define INTC_0_PSR41         INTC_0.PSR[41].R              /* INTC Priority Select Register */
#define INTC_0_PSR42         INTC_0.PSR[42].R              /* INTC Priority Select Register */
#define INTC_0_PSR43         INTC_0.PSR[43].R              /* INTC Priority Select Register */
#define INTC_0_PSR44         INTC_0.PSR[44].R              /* INTC Priority Select Register */
#define INTC_0_PSR45         INTC_0.PSR[45].R              /* INTC Priority Select Register */
#define INTC_0_PSR46         INTC_0.PSR[46].R              /* INTC Priority Select Register */
#define INTC_0_PSR47         INTC_0.PSR[47].R              /* INTC Priority Select Register */
#define INTC_0_PSR48         INTC_0.PSR[48].R              /* INTC Priority Select Register */
#define INTC_0_PSR49         INTC_0.PSR[49].R              /* INTC Priority Select Register */
#define INTC_0_PSR50         INTC_0.PSR[50].R              /* INTC Priority Select Register */
#define INTC_0_PSR51         INTC_0.PSR[51].R              /* INTC Priority Select Register */
#define INTC_0_PSR52         INTC_0.PSR[52].R              /* INTC Priority Select Register */
#define INTC_0_PSR53         INTC_0.PSR[53].R              /* INTC Priority Select Register */
#define INTC_0_PSR54         INTC_0.PSR[54].R              /* INTC Priority Select Register */
#define INTC_0_PSR55         INTC_0.PSR[55].R              /* INTC Priority Select Register */
#define INTC_0_PSR56         INTC_0.PSR[56].R              /* INTC Priority Select Register */
#define INTC_0_PSR57         INTC_0.PSR[57].R              /* INTC Priority Select Register */
#define INTC_0_PSR58         INTC_0.PSR[58].R              /* INTC Priority Select Register */
#define INTC_0_PSR59         INTC_0.PSR[59].R              /* INTC Priority Select Register */
#define INTC_0_PSR60         INTC_0.PSR[60].R              /* INTC Priority Select Register */
#define INTC_0_PSR61         INTC_0.PSR[61].R              /* INTC Priority Select Register */
#define INTC_0_PSR62         INTC_0.PSR[62].R              /* INTC Priority Select Register */
#define INTC_0_PSR63         INTC_0.PSR[63].R              /* INTC Priority Select Register */
#define INTC_0_PSR64         INTC_0.PSR[64].R              /* INTC Priority Select Register */
#define INTC_0_PSR65         INTC_0.PSR[65].R              /* INTC Priority Select Register */
#define INTC_0_PSR66         INTC_0.PSR[66].R              /* INTC Priority Select Register */
#define INTC_0_PSR67         INTC_0.PSR[67].R              /* INTC Priority Select Register */
#define INTC_0_PSR68         INTC_0.PSR[68].R              /* INTC Priority Select Register */
#define INTC_0_PSR69         INTC_0.PSR[69].R              /* INTC Priority Select Register */
#define INTC_0_PSR70         INTC_0.PSR[70].R              /* INTC Priority Select Register */
#define INTC_0_PSR71         INTC_0.PSR[71].R              /* INTC Priority Select Register */
#define INTC_0_PSR72         INTC_0.PSR[72].R              /* INTC Priority Select Register */
#define INTC_0_PSR73         INTC_0.PSR[73].R              /* INTC Priority Select Register */
#define INTC_0_PSR74         INTC_0.PSR[74].R              /* INTC Priority Select Register */
#define INTC_0_PSR75         INTC_0.PSR[75].R              /* INTC Priority Select Register */
#define INTC_0_PSR76         INTC_0.PSR[76].R              /* INTC Priority Select Register */
#define INTC_0_PSR77         INTC_0.PSR[77].R              /* INTC Priority Select Register */
#define INTC_0_PSR78         INTC_0.PSR[78].R              /* INTC Priority Select Register */
#define INTC_0_PSR79         INTC_0.PSR[79].R              /* INTC Priority Select Register */
#define INTC_0_PSR80         INTC_0.PSR[80].R              /* INTC Priority Select Register */
#define INTC_0_PSR81         INTC_0.PSR[81].R              /* INTC Priority Select Register */
#define INTC_0_PSR82         INTC_0.PSR[82].R              /* INTC Priority Select Register */
#define INTC_0_PSR83         INTC_0.PSR[83].R              /* INTC Priority Select Register */
#define INTC_0_PSR84         INTC_0.PSR[84].R              /* INTC Priority Select Register */
#define INTC_0_PSR85         INTC_0.PSR[85].R              /* INTC Priority Select Register */
#define INTC_0_PSR86         INTC_0.PSR[86].R              /* INTC Priority Select Register */
#define INTC_0_PSR87         INTC_0.PSR[87].R              /* INTC Priority Select Register */
#define INTC_0_PSR88         INTC_0.PSR[88].R              /* INTC Priority Select Register */
#define INTC_0_PSR89         INTC_0.PSR[89].R              /* INTC Priority Select Register */
#define INTC_0_PSR90         INTC_0.PSR[90].R              /* INTC Priority Select Register */
#define INTC_0_PSR91         INTC_0.PSR[91].R              /* INTC Priority Select Register */
#define INTC_0_PSR92         INTC_0.PSR[92].R              /* INTC Priority Select Register */
#define INTC_0_PSR93         INTC_0.PSR[93].R              /* INTC Priority Select Register */
#define INTC_0_PSR94         INTC_0.PSR[94].R              /* INTC Priority Select Register */
#define INTC_0_PSR95         INTC_0.PSR[95].R              /* INTC Priority Select Register */
#define INTC_0_PSR96         INTC_0.PSR[96].R              /* INTC Priority Select Register */
#define INTC_0_PSR97         INTC_0.PSR[97].R              /* INTC Priority Select Register */
#define INTC_0_PSR98         INTC_0.PSR[98].R              /* INTC Priority Select Register */
#define INTC_0_PSR99         INTC_0.PSR[99].R              /* INTC Priority Select Register */
#define INTC_0_PSR100        INTC_0.PSR[100].R             /* INTC Priority Select Register */
#define INTC_0_PSR101        INTC_0.PSR[101].R             /* INTC Priority Select Register */
#define INTC_0_PSR102        INTC_0.PSR[102].R             /* INTC Priority Select Register */
#define INTC_0_PSR103        INTC_0.PSR[103].R             /* INTC Priority Select Register */
#define INTC_0_PSR104        INTC_0.PSR[104].R             /* INTC Priority Select Register */
#define INTC_0_PSR105        INTC_0.PSR[105].R             /* INTC Priority Select Register */
#define INTC_0_PSR106        INTC_0.PSR[106].R             /* INTC Priority Select Register */
#define INTC_0_PSR107        INTC_0.PSR[107].R             /* INTC Priority Select Register */
#define INTC_0_PSR108        INTC_0.PSR[108].R             /* INTC Priority Select Register */
#define INTC_0_PSR109        INTC_0.PSR[109].R             /* INTC Priority Select Register */
#define INTC_0_PSR110        INTC_0.PSR[110].R             /* INTC Priority Select Register */
#define INTC_0_PSR111        INTC_0.PSR[111].R             /* INTC Priority Select Register */
#define INTC_0_PSR112        INTC_0.PSR[112].R             /* INTC Priority Select Register */
#define INTC_0_PSR113        INTC_0.PSR[113].R             /* INTC Priority Select Register */
#define INTC_0_PSR114        INTC_0.PSR[114].R             /* INTC Priority Select Register */
#define INTC_0_PSR115        INTC_0.PSR[115].R             /* INTC Priority Select Register */
#define INTC_0_PSR116        INTC_0.PSR[116].R             /* INTC Priority Select Register */
#define INTC_0_PSR117        INTC_0.PSR[117].R             /* INTC Priority Select Register */
#define INTC_0_PSR118        INTC_0.PSR[118].R             /* INTC Priority Select Register */
#define INTC_0_PSR119        INTC_0.PSR[119].R             /* INTC Priority Select Register */
#define INTC_0_PSR120        INTC_0.PSR[120].R             /* INTC Priority Select Register */
#define INTC_0_PSR121        INTC_0.PSR[121].R             /* INTC Priority Select Register */
#define INTC_0_PSR122        INTC_0.PSR[122].R             /* INTC Priority Select Register */
#define INTC_0_PSR123        INTC_0.PSR[123].R             /* INTC Priority Select Register */
#define INTC_0_PSR124        INTC_0.PSR[124].R             /* INTC Priority Select Register */
#define INTC_0_PSR125        INTC_0.PSR[125].R             /* INTC Priority Select Register */
#define INTC_0_PSR126        INTC_0.PSR[126].R             /* INTC Priority Select Register */
#define INTC_0_PSR127        INTC_0.PSR[127].R             /* INTC Priority Select Register */
#define INTC_0_PSR128        INTC_0.PSR[128].R             /* INTC Priority Select Register */
#define INTC_0_PSR129        INTC_0.PSR[129].R             /* INTC Priority Select Register */
#define INTC_0_PSR130        INTC_0.PSR[130].R             /* INTC Priority Select Register */
#define INTC_0_PSR131        INTC_0.PSR[131].R             /* INTC Priority Select Register */
#define INTC_0_PSR132        INTC_0.PSR[132].R             /* INTC Priority Select Register */
#define INTC_0_PSR133        INTC_0.PSR[133].R             /* INTC Priority Select Register */
#define INTC_0_PSR134        INTC_0.PSR[134].R             /* INTC Priority Select Register */
#define INTC_0_PSR135        INTC_0.PSR[135].R             /* INTC Priority Select Register */
#define INTC_0_PSR136        INTC_0.PSR[136].R             /* INTC Priority Select Register */
#define INTC_0_PSR137        INTC_0.PSR[137].R             /* INTC Priority Select Register */
#define INTC_0_PSR138        INTC_0.PSR[138].R             /* INTC Priority Select Register */
#define INTC_0_PSR139        INTC_0.PSR[139].R             /* INTC Priority Select Register */
#define INTC_0_PSR140        INTC_0.PSR[140].R             /* INTC Priority Select Register */
#define INTC_0_PSR141        INTC_0.PSR[141].R             /* INTC Priority Select Register */
#define INTC_0_PSR142        INTC_0.PSR[142].R             /* INTC Priority Select Register */
#define INTC_0_PSR143        INTC_0.PSR[143].R             /* INTC Priority Select Register */
#define INTC_0_PSR144        INTC_0.PSR[144].R             /* INTC Priority Select Register */
#define INTC_0_PSR145        INTC_0.PSR[145].R             /* INTC Priority Select Register */
#define INTC_0_PSR146        INTC_0.PSR[146].R             /* INTC Priority Select Register */
#define INTC_0_PSR147        INTC_0.PSR[147].R             /* INTC Priority Select Register */
#define INTC_0_PSR148        INTC_0.PSR[148].R             /* INTC Priority Select Register */
#define INTC_0_PSR149        INTC_0.PSR[149].R             /* INTC Priority Select Register */
#define INTC_0_PSR150        INTC_0.PSR[150].R             /* INTC Priority Select Register */
#define INTC_0_PSR151        INTC_0.PSR[151].R             /* INTC Priority Select Register */
#define INTC_0_PSR152        INTC_0.PSR[152].R             /* INTC Priority Select Register */
#define INTC_0_PSR153        INTC_0.PSR[153].R             /* INTC Priority Select Register */
#define INTC_0_PSR154        INTC_0.PSR[154].R             /* INTC Priority Select Register */
#define INTC_0_PSR155        INTC_0.PSR[155].R             /* INTC Priority Select Register */
#define INTC_0_PSR156        INTC_0.PSR[156].R             /* INTC Priority Select Register */
#define INTC_0_PSR157        INTC_0.PSR[157].R             /* INTC Priority Select Register */
#define INTC_0_PSR158        INTC_0.PSR[158].R             /* INTC Priority Select Register */
#define INTC_0_PSR159        INTC_0.PSR[159].R             /* INTC Priority Select Register */
#define INTC_0_PSR160        INTC_0.PSR[160].R             /* INTC Priority Select Register */
#define INTC_0_PSR161        INTC_0.PSR[161].R             /* INTC Priority Select Register */
#define INTC_0_PSR162        INTC_0.PSR[162].R             /* INTC Priority Select Register */
#define INTC_0_PSR163        INTC_0.PSR[163].R             /* INTC Priority Select Register */
#define INTC_0_PSR164        INTC_0.PSR[164].R             /* INTC Priority Select Register */
#define INTC_0_PSR165        INTC_0.PSR[165].R             /* INTC Priority Select Register */
#define INTC_0_PSR166        INTC_0.PSR[166].R             /* INTC Priority Select Register */
#define INTC_0_PSR167        INTC_0.PSR[167].R             /* INTC Priority Select Register */
#define INTC_0_PSR168        INTC_0.PSR[168].R             /* INTC Priority Select Register */
#define INTC_0_PSR169        INTC_0.PSR[169].R             /* INTC Priority Select Register */
#define INTC_0_PSR170        INTC_0.PSR[170].R             /* INTC Priority Select Register */
#define INTC_0_PSR171        INTC_0.PSR[171].R             /* INTC Priority Select Register */
#define INTC_0_PSR172        INTC_0.PSR[172].R             /* INTC Priority Select Register */
#define INTC_0_PSR173        INTC_0.PSR[173].R             /* INTC Priority Select Register */
#define INTC_0_PSR174        INTC_0.PSR[174].R             /* INTC Priority Select Register */
#define INTC_0_PSR175        INTC_0.PSR[175].R             /* INTC Priority Select Register */
#define INTC_0_PSR176        INTC_0.PSR[176].R             /* INTC Priority Select Register */
#define INTC_0_PSR177        INTC_0.PSR[177].R             /* INTC Priority Select Register */
#define INTC_0_PSR178        INTC_0.PSR[178].R             /* INTC Priority Select Register */
#define INTC_0_PSR179        INTC_0.PSR[179].R             /* INTC Priority Select Register */
#define INTC_0_PSR180        INTC_0.PSR[180].R             /* INTC Priority Select Register */
#define INTC_0_PSR181        INTC_0.PSR[181].R             /* INTC Priority Select Register */
#define INTC_0_PSR182        INTC_0.PSR[182].R             /* INTC Priority Select Register */
#define INTC_0_PSR183        INTC_0.PSR[183].R             /* INTC Priority Select Register */
#define INTC_0_PSR184        INTC_0.PSR[184].R             /* INTC Priority Select Register */
#define INTC_0_PSR185        INTC_0.PSR[185].R             /* INTC Priority Select Register */
#define INTC_0_PSR186        INTC_0.PSR[186].R             /* INTC Priority Select Register */
#define INTC_0_PSR187        INTC_0.PSR[187].R             /* INTC Priority Select Register */
#define INTC_0_PSR188        INTC_0.PSR[188].R             /* INTC Priority Select Register */
#define INTC_0_PSR189        INTC_0.PSR[189].R             /* INTC Priority Select Register */
#define INTC_0_PSR190        INTC_0.PSR[190].R             /* INTC Priority Select Register */
#define INTC_0_PSR191        INTC_0.PSR[191].R             /* INTC Priority Select Register */
#define INTC_0_PSR192        INTC_0.PSR[192].R             /* INTC Priority Select Register */
#define INTC_0_PSR193        INTC_0.PSR[193].R             /* INTC Priority Select Register */
#define INTC_0_PSR194        INTC_0.PSR[194].R             /* INTC Priority Select Register */
#define INTC_0_PSR195        INTC_0.PSR[195].R             /* INTC Priority Select Register */
#define INTC_0_PSR196        INTC_0.PSR[196].R             /* INTC Priority Select Register */
#define INTC_0_PSR197        INTC_0.PSR[197].R             /* INTC Priority Select Register */
#define INTC_0_PSR198        INTC_0.PSR[198].R             /* INTC Priority Select Register */
#define INTC_0_PSR199        INTC_0.PSR[199].R             /* INTC Priority Select Register */
#define INTC_0_PSR200        INTC_0.PSR[200].R             /* INTC Priority Select Register */
#define INTC_0_PSR201        INTC_0.PSR[201].R             /* INTC Priority Select Register */
#define INTC_0_PSR202        INTC_0.PSR[202].R             /* INTC Priority Select Register */
#define INTC_0_PSR203        INTC_0.PSR[203].R             /* INTC Priority Select Register */
#define INTC_0_PSR204        INTC_0.PSR[204].R             /* INTC Priority Select Register */
#define INTC_0_PSR205        INTC_0.PSR[205].R             /* INTC Priority Select Register */
#define INTC_0_PSR206        INTC_0.PSR[206].R             /* INTC Priority Select Register */
#define INTC_0_PSR207        INTC_0.PSR[207].R             /* INTC Priority Select Register */
#define INTC_0_PSR208        INTC_0.PSR[208].R             /* INTC Priority Select Register */
#define INTC_0_PSR209        INTC_0.PSR[209].R             /* INTC Priority Select Register */
#define INTC_0_PSR210        INTC_0.PSR[210].R             /* INTC Priority Select Register */
#define INTC_0_PSR211        INTC_0.PSR[211].R             /* INTC Priority Select Register */
#define INTC_0_PSR212        INTC_0.PSR[212].R             /* INTC Priority Select Register */
#define INTC_0_PSR213        INTC_0.PSR[213].R             /* INTC Priority Select Register */
#define INTC_0_PSR214        INTC_0.PSR[214].R             /* INTC Priority Select Register */
#define INTC_0_PSR215        INTC_0.PSR[215].R             /* INTC Priority Select Register */
#define INTC_0_PSR216        INTC_0.PSR[216].R             /* INTC Priority Select Register */
#define INTC_0_PSR217        INTC_0.PSR[217].R             /* INTC Priority Select Register */
#define INTC_0_PSR218        INTC_0.PSR[218].R             /* INTC Priority Select Register */
#define INTC_0_PSR219        INTC_0.PSR[219].R             /* INTC Priority Select Register */
#define INTC_0_PSR220        INTC_0.PSR[220].R             /* INTC Priority Select Register */
#define INTC_0_PSR221        INTC_0.PSR[221].R             /* INTC Priority Select Register */
#define INTC_0_PSR222        INTC_0.PSR[222].R             /* INTC Priority Select Register */
#define INTC_0_PSR223        INTC_0.PSR[223].R             /* INTC Priority Select Register */
#define INTC_0_PSR224        INTC_0.PSR[224].R             /* INTC Priority Select Register */
#define INTC_0_PSR225        INTC_0.PSR[225].R             /* INTC Priority Select Register */
#define INTC_0_PSR226        INTC_0.PSR[226].R             /* INTC Priority Select Register */
#define INTC_0_PSR227        INTC_0.PSR[227].R             /* INTC Priority Select Register */
#define INTC_0_PSR228        INTC_0.PSR[228].R             /* INTC Priority Select Register */
#define INTC_0_PSR229        INTC_0.PSR[229].R             /* INTC Priority Select Register */
#define INTC_0_PSR230        INTC_0.PSR[230].R             /* INTC Priority Select Register */
#define INTC_0_PSR231        INTC_0.PSR[231].R             /* INTC Priority Select Register */
#define INTC_0_PSR232        INTC_0.PSR[232].R             /* INTC Priority Select Register */
#define INTC_0_PSR233        INTC_0.PSR[233].R             /* INTC Priority Select Register */
#define INTC_0_PSR234        INTC_0.PSR[234].R             /* INTC Priority Select Register */
#define INTC_0_PSR235        INTC_0.PSR[235].R             /* INTC Priority Select Register */
#define INTC_0_PSR236        INTC_0.PSR[236].R             /* INTC Priority Select Register */
#define INTC_0_PSR237        INTC_0.PSR[237].R             /* INTC Priority Select Register */
#define INTC_0_PSR238        INTC_0.PSR[238].R             /* INTC Priority Select Register */
#define INTC_0_PSR239        INTC_0.PSR[239].R             /* INTC Priority Select Register */
#define INTC_0_PSR240        INTC_0.PSR[240].R             /* INTC Priority Select Register */
#define INTC_0_PSR241        INTC_0.PSR[241].R             /* INTC Priority Select Register */
#define INTC_0_PSR242        INTC_0.PSR[242].R             /* INTC Priority Select Register */
#define INTC_0_PSR243        INTC_0.PSR[243].R             /* INTC Priority Select Register */
#define INTC_0_PSR244        INTC_0.PSR[244].R             /* INTC Priority Select Register */
#define INTC_0_PSR245        INTC_0.PSR[245].R             /* INTC Priority Select Register */
#define INTC_0_PSR246        INTC_0.PSR[246].R             /* INTC Priority Select Register */
#define INTC_0_PSR247        INTC_0.PSR[247].R             /* INTC Priority Select Register */
#define INTC_0_PSR248        INTC_0.PSR[248].R             /* INTC Priority Select Register */
#define INTC_0_PSR249        INTC_0.PSR[249].R             /* INTC Priority Select Register */
#define INTC_0_PSR250        INTC_0.PSR[250].R             /* INTC Priority Select Register */
#define INTC_0_PSR251        INTC_0.PSR[251].R             /* INTC Priority Select Register */
#define INTC_0_PSR252        INTC_0.PSR[252].R             /* INTC Priority Select Register */
#define INTC_0_PSR253        INTC_0.PSR[253].R             /* INTC Priority Select Register */
#define INTC_0_PSR254        INTC_0.PSR[254].R             /* INTC Priority Select Register */
#define INTC_0_PSR255        INTC_0.PSR[255].R             /* INTC Priority Select Register */
#define INTC_0_PSR256        INTC_0.PSR[256].R             /* INTC Priority Select Register */
#define INTC_0_PSR257        INTC_0.PSR[257].R             /* INTC Priority Select Register */
#define INTC_0_PSR258        INTC_0.PSR[258].R             /* INTC Priority Select Register */
#define INTC_0_PSR259        INTC_0.PSR[259].R             /* INTC Priority Select Register */
#define INTC_0_PSR260        INTC_0.PSR[260].R             /* INTC Priority Select Register */
#define INTC_0_PSR261        INTC_0.PSR[261].R             /* INTC Priority Select Register */
#define INTC_0_PSR262        INTC_0.PSR[262].R             /* INTC Priority Select Register */
#define INTC_0_PSR263        INTC_0.PSR[263].R             /* INTC Priority Select Register */
#define INTC_0_PSR264        INTC_0.PSR[264].R             /* INTC Priority Select Register */
#define INTC_0_PSR265        INTC_0.PSR[265].R             /* INTC Priority Select Register */
#define INTC_0_PSR266        INTC_0.PSR[266].R             /* INTC Priority Select Register */
#define INTC_0_PSR267        INTC_0.PSR[267].R             /* INTC Priority Select Register */
#define INTC_0_PSR268        INTC_0.PSR[268].R             /* INTC Priority Select Register */
#define INTC_0_PSR269        INTC_0.PSR[269].R             /* INTC Priority Select Register */
#define INTC_0_PSR270        INTC_0.PSR[270].R             /* INTC Priority Select Register */
#define INTC_0_PSR271        INTC_0.PSR[271].R             /* INTC Priority Select Register */
#define INTC_0_PSR272        INTC_0.PSR[272].R             /* INTC Priority Select Register */
#define INTC_0_PSR273        INTC_0.PSR[273].R             /* INTC Priority Select Register */
#define INTC_0_PSR274        INTC_0.PSR[274].R             /* INTC Priority Select Register */
#define INTC_0_PSR275        INTC_0.PSR[275].R             /* INTC Priority Select Register */
#define INTC_0_PSR276        INTC_0.PSR[276].R             /* INTC Priority Select Register */
#define INTC_0_PSR277        INTC_0.PSR[277].R             /* INTC Priority Select Register */
#define INTC_0_PSR278        INTC_0.PSR[278].R             /* INTC Priority Select Register */
#define INTC_0_PSR279        INTC_0.PSR[279].R             /* INTC Priority Select Register */
#define INTC_0_PSR280        INTC_0.PSR[280].R             /* INTC Priority Select Register */
#define INTC_0_PSR281        INTC_0.PSR[281].R             /* INTC Priority Select Register */
#define INTC_0_PSR282        INTC_0.PSR[282].R             /* INTC Priority Select Register */
#define INTC_0_PSR283        INTC_0.PSR[283].R             /* INTC Priority Select Register */
#define INTC_0_PSR284        INTC_0.PSR[284].R             /* INTC Priority Select Register */
#define INTC_0_PSR285        INTC_0.PSR[285].R             /* INTC Priority Select Register */
#define INTC_0_PSR286        INTC_0.PSR[286].R             /* INTC Priority Select Register */
#define INTC_0_PSR287        INTC_0.PSR[287].R             /* INTC Priority Select Register */
#define INTC_0_PSR288        INTC_0.PSR[288].R             /* INTC Priority Select Register */
#define INTC_0_PSR289        INTC_0.PSR[289].R             /* INTC Priority Select Register */
#define INTC_0_PSR290        INTC_0.PSR[290].R             /* INTC Priority Select Register */
#define INTC_0_PSR291        INTC_0.PSR[291].R             /* INTC Priority Select Register */
#define INTC_0_PSR292        INTC_0.PSR[292].R             /* INTC Priority Select Register */
#define INTC_0_PSR293        INTC_0.PSR[293].R             /* INTC Priority Select Register */
#define INTC_0_PSR294        INTC_0.PSR[294].R             /* INTC Priority Select Register */
#define INTC_0_PSR295        INTC_0.PSR[295].R             /* INTC Priority Select Register */
#define INTC_0_PSR296        INTC_0.PSR[296].R             /* INTC Priority Select Register */
#define INTC_0_PSR297        INTC_0.PSR[297].R             /* INTC Priority Select Register */
#define INTC_0_PSR298        INTC_0.PSR[298].R             /* INTC Priority Select Register */
#define INTC_0_PSR299        INTC_0.PSR[299].R             /* INTC Priority Select Register */
#define INTC_0_PSR300        INTC_0.PSR[300].R             /* INTC Priority Select Register */
#define INTC_0_PSR301        INTC_0.PSR[301].R             /* INTC Priority Select Register */
#define INTC_0_PSR302        INTC_0.PSR[302].R             /* INTC Priority Select Register */
#define INTC_0_PSR303        INTC_0.PSR[303].R             /* INTC Priority Select Register */
#define INTC_0_PSR304        INTC_0.PSR[304].R             /* INTC Priority Select Register */
#define INTC_0_PSR305        INTC_0.PSR[305].R             /* INTC Priority Select Register */
#define INTC_0_PSR306        INTC_0.PSR[306].R             /* INTC Priority Select Register */
#define INTC_0_PSR307        INTC_0.PSR[307].R             /* INTC Priority Select Register */
#define INTC_0_PSR308        INTC_0.PSR[308].R             /* INTC Priority Select Register */
#define INTC_0_PSR309        INTC_0.PSR[309].R             /* INTC Priority Select Register */
#define INTC_0_PSR310        INTC_0.PSR[310].R             /* INTC Priority Select Register */
#define INTC_0_PSR311        INTC_0.PSR[311].R             /* INTC Priority Select Register */
#define INTC_0_PSR312        INTC_0.PSR[312].R             /* INTC Priority Select Register */
#define INTC_0_PSR313        INTC_0.PSR[313].R             /* INTC Priority Select Register */
#define INTC_0_PSR314        INTC_0.PSR[314].R             /* INTC Priority Select Register */
#define INTC_0_PSR315        INTC_0.PSR[315].R             /* INTC Priority Select Register */
#define INTC_0_PSR316        INTC_0.PSR[316].R             /* INTC Priority Select Register */
#define INTC_0_PSR317        INTC_0.PSR[317].R             /* INTC Priority Select Register */
#define INTC_0_PSR318        INTC_0.PSR[318].R             /* INTC Priority Select Register */
#define INTC_0_PSR319        INTC_0.PSR[319].R             /* INTC Priority Select Register */
#define INTC_0_PSR320        INTC_0.PSR[320].R             /* INTC Priority Select Register */
#define INTC_0_PSR321        INTC_0.PSR[321].R             /* INTC Priority Select Register */
#define INTC_0_PSR322        INTC_0.PSR[322].R             /* INTC Priority Select Register */
#define INTC_0_PSR323        INTC_0.PSR[323].R             /* INTC Priority Select Register */
#define INTC_0_PSR324        INTC_0.PSR[324].R             /* INTC Priority Select Register */
#define INTC_0_PSR325        INTC_0.PSR[325].R             /* INTC Priority Select Register */
#define INTC_0_PSR326        INTC_0.PSR[326].R             /* INTC Priority Select Register */
#define INTC_0_PSR327        INTC_0.PSR[327].R             /* INTC Priority Select Register */
#define INTC_0_PSR328        INTC_0.PSR[328].R             /* INTC Priority Select Register */
#define INTC_0_PSR329        INTC_0.PSR[329].R             /* INTC Priority Select Register */
#define INTC_0_PSR330        INTC_0.PSR[330].R             /* INTC Priority Select Register */
#define INTC_0_PSR331        INTC_0.PSR[331].R             /* INTC Priority Select Register */
#define INTC_0_PSR332        INTC_0.PSR[332].R             /* INTC Priority Select Register */
#define INTC_0_PSR333        INTC_0.PSR[333].R             /* INTC Priority Select Register */
#define INTC_0_PSR334        INTC_0.PSR[334].R             /* INTC Priority Select Register */
#define INTC_0_PSR335        INTC_0.PSR[335].R             /* INTC Priority Select Register */
#define INTC_0_PSR336        INTC_0.PSR[336].R             /* INTC Priority Select Register */
#define INTC_0_PSR337        INTC_0.PSR[337].R             /* INTC Priority Select Register */
#define INTC_0_PSR338        INTC_0.PSR[338].R             /* INTC Priority Select Register */
#define INTC_0_PSR339        INTC_0.PSR[339].R             /* INTC Priority Select Register */
#define INTC_0_PSR340        INTC_0.PSR[340].R             /* INTC Priority Select Register */
#define INTC_0_PSR341        INTC_0.PSR[341].R             /* INTC Priority Select Register */
#define INTC_0_PSR342        INTC_0.PSR[342].R             /* INTC Priority Select Register */
#define INTC_0_PSR343        INTC_0.PSR[343].R             /* INTC Priority Select Register */
#define INTC_0_PSR344        INTC_0.PSR[344].R             /* INTC Priority Select Register */
#define INTC_0_PSR345        INTC_0.PSR[345].R             /* INTC Priority Select Register */
#define INTC_0_PSR346        INTC_0.PSR[346].R             /* INTC Priority Select Register */
#define INTC_0_PSR347        INTC_0.PSR[347].R             /* INTC Priority Select Register */
#define INTC_0_PSR348        INTC_0.PSR[348].R             /* INTC Priority Select Register */
#define INTC_0_PSR349        INTC_0.PSR[349].R             /* INTC Priority Select Register */
#define INTC_0_PSR350        INTC_0.PSR[350].R             /* INTC Priority Select Register */
#define INTC_0_PSR351        INTC_0.PSR[351].R             /* INTC Priority Select Register */
#define INTC_0_PSR352        INTC_0.PSR[352].R             /* INTC Priority Select Register */
#define INTC_0_PSR353        INTC_0.PSR[353].R             /* INTC Priority Select Register */
#define INTC_0_PSR354        INTC_0.PSR[354].R             /* INTC Priority Select Register */
#define INTC_0_PSR355        INTC_0.PSR[355].R             /* INTC Priority Select Register */
#define INTC_0_PSR356        INTC_0.PSR[356].R             /* INTC Priority Select Register */
#define INTC_0_PSR357        INTC_0.PSR[357].R             /* INTC Priority Select Register */
#define INTC_0_PSR358        INTC_0.PSR[358].R             /* INTC Priority Select Register */
#define INTC_0_PSR359        INTC_0.PSR[359].R             /* INTC Priority Select Register */
#define INTC_0_PSR360        INTC_0.PSR[360].R             /* INTC Priority Select Register */
#define INTC_0_PSR361        INTC_0.PSR[361].R             /* INTC Priority Select Register */
#define INTC_0_PSR362        INTC_0.PSR[362].R             /* INTC Priority Select Register */
#define INTC_0_PSR363        INTC_0.PSR[363].R             /* INTC Priority Select Register */
#define INTC_0_PSR364        INTC_0.PSR[364].R             /* INTC Priority Select Register */
#define INTC_0_PSR365        INTC_0.PSR[365].R             /* INTC Priority Select Register */
#define INTC_0_PSR366        INTC_0.PSR[366].R             /* INTC Priority Select Register */
#define INTC_0_PSR367        INTC_0.PSR[367].R             /* INTC Priority Select Register */
#define INTC_0_PSR368        INTC_0.PSR[368].R             /* INTC Priority Select Register */
#define INTC_0_PSR369        INTC_0.PSR[369].R             /* INTC Priority Select Register */
#define INTC_0_PSR370        INTC_0.PSR[370].R             /* INTC Priority Select Register */
#define INTC_0_PSR371        INTC_0.PSR[371].R             /* INTC Priority Select Register */
#define INTC_0_PSR372        INTC_0.PSR[372].R             /* INTC Priority Select Register */
#define INTC_0_PSR373        INTC_0.PSR[373].R             /* INTC Priority Select Register */
#define INTC_0_PSR374        INTC_0.PSR[374].R             /* INTC Priority Select Register */
#define INTC_0_PSR375        INTC_0.PSR[375].R             /* INTC Priority Select Register */
#define INTC_0_PSR376        INTC_0.PSR[376].R             /* INTC Priority Select Register */
#define INTC_0_PSR377        INTC_0.PSR[377].R             /* INTC Priority Select Register */
#define INTC_0_PSR378        INTC_0.PSR[378].R             /* INTC Priority Select Register */
#define INTC_0_PSR379        INTC_0.PSR[379].R             /* INTC Priority Select Register */
#define INTC_0_PSR380        INTC_0.PSR[380].R             /* INTC Priority Select Register */
#define INTC_0_PSR381        INTC_0.PSR[381].R             /* INTC Priority Select Register */
#define INTC_0_PSR382        INTC_0.PSR[382].R             /* INTC Priority Select Register */
#define INTC_0_PSR383        INTC_0.PSR[383].R             /* INTC Priority Select Register */
#define INTC_0_PSR384        INTC_0.PSR[384].R             /* INTC Priority Select Register */
#define INTC_0_PSR385        INTC_0.PSR[385].R             /* INTC Priority Select Register */
#define INTC_0_PSR386        INTC_0.PSR[386].R             /* INTC Priority Select Register */
#define INTC_0_PSR387        INTC_0.PSR[387].R             /* INTC Priority Select Register */
#define INTC_0_PSR388        INTC_0.PSR[388].R             /* INTC Priority Select Register */
#define INTC_0_PSR389        INTC_0.PSR[389].R             /* INTC Priority Select Register */
#define INTC_0_PSR390        INTC_0.PSR[390].R             /* INTC Priority Select Register */
#define INTC_0_PSR391        INTC_0.PSR[391].R             /* INTC Priority Select Register */
#define INTC_0_PSR392        INTC_0.PSR[392].R             /* INTC Priority Select Register */
#define INTC_0_PSR393        INTC_0.PSR[393].R             /* INTC Priority Select Register */
#define INTC_0_PSR394        INTC_0.PSR[394].R             /* INTC Priority Select Register */
#define INTC_0_PSR395        INTC_0.PSR[395].R             /* INTC Priority Select Register */
#define INTC_0_PSR396        INTC_0.PSR[396].R             /* INTC Priority Select Register */
#define INTC_0_PSR397        INTC_0.PSR[397].R             /* INTC Priority Select Register */
#define INTC_0_PSR398        INTC_0.PSR[398].R             /* INTC Priority Select Register */
#define INTC_0_PSR399        INTC_0.PSR[399].R             /* INTC Priority Select Register */
#define INTC_0_PSR400        INTC_0.PSR[400].R             /* INTC Priority Select Register */
#define INTC_0_PSR401        INTC_0.PSR[401].R             /* INTC Priority Select Register */
#define INTC_0_PSR402        INTC_0.PSR[402].R             /* INTC Priority Select Register */
#define INTC_0_PSR403        INTC_0.PSR[403].R             /* INTC Priority Select Register */
#define INTC_0_PSR404        INTC_0.PSR[404].R             /* INTC Priority Select Register */
#define INTC_0_PSR405        INTC_0.PSR[405].R             /* INTC Priority Select Register */
#define INTC_0_PSR406        INTC_0.PSR[406].R             /* INTC Priority Select Register */
#define INTC_0_PSR407        INTC_0.PSR[407].R             /* INTC Priority Select Register */
#define INTC_0_PSR408        INTC_0.PSR[408].R             /* INTC Priority Select Register */
#define INTC_0_PSR409        INTC_0.PSR[409].R             /* INTC Priority Select Register */
#define INTC_0_PSR410        INTC_0.PSR[410].R             /* INTC Priority Select Register */
#define INTC_0_PSR411        INTC_0.PSR[411].R             /* INTC Priority Select Register */
#define INTC_0_PSR412        INTC_0.PSR[412].R             /* INTC Priority Select Register */
#define INTC_0_PSR413        INTC_0.PSR[413].R             /* INTC Priority Select Register */
#define INTC_0_PSR414        INTC_0.PSR[414].R             /* INTC Priority Select Register */
#define INTC_0_PSR415        INTC_0.PSR[415].R             /* INTC Priority Select Register */
#define INTC_0_PSR416        INTC_0.PSR[416].R             /* INTC Priority Select Register */
#define INTC_0_PSR417        INTC_0.PSR[417].R             /* INTC Priority Select Register */
#define INTC_0_PSR418        INTC_0.PSR[418].R             /* INTC Priority Select Register */
#define INTC_0_PSR419        INTC_0.PSR[419].R             /* INTC Priority Select Register */
#define INTC_0_PSR420        INTC_0.PSR[420].R             /* INTC Priority Select Register */
#define INTC_0_PSR421        INTC_0.PSR[421].R             /* INTC Priority Select Register */
#define INTC_0_PSR422        INTC_0.PSR[422].R             /* INTC Priority Select Register */
#define INTC_0_PSR423        INTC_0.PSR[423].R             /* INTC Priority Select Register */
#define INTC_0_PSR424        INTC_0.PSR[424].R             /* INTC Priority Select Register */
#define INTC_0_PSR425        INTC_0.PSR[425].R             /* INTC Priority Select Register */
#define INTC_0_PSR426        INTC_0.PSR[426].R             /* INTC Priority Select Register */
#define INTC_0_PSR427        INTC_0.PSR[427].R             /* INTC Priority Select Register */
#define INTC_0_PSR428        INTC_0.PSR[428].R             /* INTC Priority Select Register */
#define INTC_0_PSR429        INTC_0.PSR[429].R             /* INTC Priority Select Register */
#define INTC_0_PSR430        INTC_0.PSR[430].R             /* INTC Priority Select Register */
#define INTC_0_PSR431        INTC_0.PSR[431].R             /* INTC Priority Select Register */
#define INTC_0_PSR432        INTC_0.PSR[432].R             /* INTC Priority Select Register */
#define INTC_0_PSR433        INTC_0.PSR[433].R             /* INTC Priority Select Register */
#define INTC_0_PSR434        INTC_0.PSR[434].R             /* INTC Priority Select Register */
#define INTC_0_PSR435        INTC_0.PSR[435].R             /* INTC Priority Select Register */
#define INTC_0_PSR436        INTC_0.PSR[436].R             /* INTC Priority Select Register */
#define INTC_0_PSR437        INTC_0.PSR[437].R             /* INTC Priority Select Register */
#define INTC_0_PSR438        INTC_0.PSR[438].R             /* INTC Priority Select Register */
#define INTC_0_PSR439        INTC_0.PSR[439].R             /* INTC Priority Select Register */
#define INTC_0_PSR440        INTC_0.PSR[440].R             /* INTC Priority Select Register */
#define INTC_0_PSR441        INTC_0.PSR[441].R             /* INTC Priority Select Register */
#define INTC_0_PSR442        INTC_0.PSR[442].R             /* INTC Priority Select Register */
#define INTC_0_PSR443        INTC_0.PSR[443].R             /* INTC Priority Select Register */
#define INTC_0_PSR444        INTC_0.PSR[444].R             /* INTC Priority Select Register */
#define INTC_0_PSR445        INTC_0.PSR[445].R             /* INTC Priority Select Register */
#define INTC_0_PSR446        INTC_0.PSR[446].R             /* INTC Priority Select Register */
#define INTC_0_PSR447        INTC_0.PSR[447].R             /* INTC Priority Select Register */
#define INTC_0_PSR448        INTC_0.PSR[448].R             /* INTC Priority Select Register */
#define INTC_0_PSR449        INTC_0.PSR[449].R             /* INTC Priority Select Register */
#define INTC_0_PSR450        INTC_0.PSR[450].R             /* INTC Priority Select Register */
#define INTC_0_PSR451        INTC_0.PSR[451].R             /* INTC Priority Select Register */
#define INTC_0_PSR452        INTC_0.PSR[452].R             /* INTC Priority Select Register */
#define INTC_0_PSR453        INTC_0.PSR[453].R             /* INTC Priority Select Register */
#define INTC_0_PSR454        INTC_0.PSR[454].R             /* INTC Priority Select Register */
#define INTC_0_PSR455        INTC_0.PSR[455].R             /* INTC Priority Select Register */
#define INTC_0_PSR456        INTC_0.PSR[456].R             /* INTC Priority Select Register */
#define INTC_0_PSR457        INTC_0.PSR[457].R             /* INTC Priority Select Register */
#define INTC_0_PSR458        INTC_0.PSR[458].R             /* INTC Priority Select Register */
#define INTC_0_PSR459        INTC_0.PSR[459].R             /* INTC Priority Select Register */
#define INTC_0_PSR460        INTC_0.PSR[460].R             /* INTC Priority Select Register */
#define INTC_0_PSR461        INTC_0.PSR[461].R             /* INTC Priority Select Register */
#define INTC_0_PSR462        INTC_0.PSR[462].R             /* INTC Priority Select Register */
#define INTC_0_PSR463        INTC_0.PSR[463].R             /* INTC Priority Select Register */
#define INTC_0_PSR464        INTC_0.PSR[464].R             /* INTC Priority Select Register */
#define INTC_0_PSR465        INTC_0.PSR[465].R             /* INTC Priority Select Register */
#define INTC_0_PSR466        INTC_0.PSR[466].R             /* INTC Priority Select Register */
#define INTC_0_PSR467        INTC_0.PSR[467].R             /* INTC Priority Select Register */
#define INTC_0_PSR468        INTC_0.PSR[468].R             /* INTC Priority Select Register */
#define INTC_0_PSR469        INTC_0.PSR[469].R             /* INTC Priority Select Register */
#define INTC_0_PSR470        INTC_0.PSR[470].R             /* INTC Priority Select Register */
#define INTC_0_PSR471        INTC_0.PSR[471].R             /* INTC Priority Select Register */
#define INTC_0_PSR472        INTC_0.PSR[472].R             /* INTC Priority Select Register */
#define INTC_0_PSR473        INTC_0.PSR[473].R             /* INTC Priority Select Register */
#define INTC_0_PSR474        INTC_0.PSR[474].R             /* INTC Priority Select Register */
#define INTC_0_PSR475        INTC_0.PSR[475].R             /* INTC Priority Select Register */
#define INTC_0_PSR476        INTC_0.PSR[476].R             /* INTC Priority Select Register */
#define INTC_0_PSR477        INTC_0.PSR[477].R             /* INTC Priority Select Register */
#define INTC_0_PSR478        INTC_0.PSR[478].R             /* INTC Priority Select Register */
#define INTC_0_PSR479        INTC_0.PSR[479].R             /* INTC Priority Select Register */
#define INTC_0_PSR480        INTC_0.PSR[480].R             /* INTC Priority Select Register */
#define INTC_0_PSR481        INTC_0.PSR[481].R             /* INTC Priority Select Register */
#define INTC_0_PSR482        INTC_0.PSR[482].R             /* INTC Priority Select Register */
#define INTC_0_PSR483        INTC_0.PSR[483].R             /* INTC Priority Select Register */
#define INTC_0_PSR484        INTC_0.PSR[484].R             /* INTC Priority Select Register */
#define INTC_0_PSR485        INTC_0.PSR[485].R             /* INTC Priority Select Register */
#define INTC_0_PSR486        INTC_0.PSR[486].R             /* INTC Priority Select Register */
#define INTC_0_PSR487        INTC_0.PSR[487].R             /* INTC Priority Select Register */
#define INTC_0_PSR488        INTC_0.PSR[488].R             /* INTC Priority Select Register */
#define INTC_0_PSR489        INTC_0.PSR[489].R             /* INTC Priority Select Register */
#define INTC_0_PSR490        INTC_0.PSR[490].R             /* INTC Priority Select Register */
#define INTC_0_PSR491        INTC_0.PSR[491].R             /* INTC Priority Select Register */
#define INTC_0_PSR492        INTC_0.PSR[492].R             /* INTC Priority Select Register */
#define INTC_0_PSR493        INTC_0.PSR[493].R             /* INTC Priority Select Register */
#define INTC_0_PSR494        INTC_0.PSR[494].R             /* INTC Priority Select Register */
#define INTC_0_PSR495        INTC_0.PSR[495].R             /* INTC Priority Select Register */
#define INTC_0_PSR496        INTC_0.PSR[496].R             /* INTC Priority Select Register */
#define INTC_0_PSR497        INTC_0.PSR[497].R             /* INTC Priority Select Register */
#define INTC_0_PSR498        INTC_0.PSR[498].R             /* INTC Priority Select Register */
#define INTC_0_PSR499        INTC_0.PSR[499].R             /* INTC Priority Select Register */
#define INTC_0_PSR500        INTC_0.PSR[500].R             /* INTC Priority Select Register */
#define INTC_0_PSR501        INTC_0.PSR[501].R             /* INTC Priority Select Register */
#define INTC_0_PSR502        INTC_0.PSR[502].R             /* INTC Priority Select Register */
#define INTC_0_PSR503        INTC_0.PSR[503].R             /* INTC Priority Select Register */
#define INTC_0_PSR504        INTC_0.PSR[504].R             /* INTC Priority Select Register */
#define INTC_0_PSR505        INTC_0.PSR[505].R             /* INTC Priority Select Register */
#define INTC_0_PSR506        INTC_0.PSR[506].R             /* INTC Priority Select Register */
#define INTC_0_PSR507        INTC_0.PSR[507].R             /* INTC Priority Select Register */
#define INTC_0_PSR508        INTC_0.PSR[508].R             /* INTC Priority Select Register */
#define INTC_0_PSR509        INTC_0.PSR[509].R             /* INTC Priority Select Register */
#define INTC_0_PSR510        INTC_0.PSR[510].R             /* INTC Priority Select Register */
#define INTC_0_PSR511        INTC_0.PSR[511].R             /* INTC Priority Select Register */
#define INTC_0_PSR512        INTC_0.PSR[512].R             /* INTC Priority Select Register */
#define INTC_0_PSR513        INTC_0.PSR[513].R             /* INTC Priority Select Register */
#define INTC_0_PSR514        INTC_0.PSR[514].R             /* INTC Priority Select Register */
#define INTC_0_PSR515        INTC_0.PSR[515].R             /* INTC Priority Select Register */
#define INTC_0_PSR516        INTC_0.PSR[516].R             /* INTC Priority Select Register */
#define INTC_0_PSR517        INTC_0.PSR[517].R             /* INTC Priority Select Register */
#define INTC_0_PSR518        INTC_0.PSR[518].R             /* INTC Priority Select Register */
#define INTC_0_PSR519        INTC_0.PSR[519].R             /* INTC Priority Select Register */
#define INTC_0_PSR520        INTC_0.PSR[520].R             /* INTC Priority Select Register */
#define INTC_0_PSR521        INTC_0.PSR[521].R             /* INTC Priority Select Register */
#define INTC_0_PSR522        INTC_0.PSR[522].R             /* INTC Priority Select Register */
#define INTC_0_PSR523        INTC_0.PSR[523].R             /* INTC Priority Select Register */
#define INTC_0_PSR524        INTC_0.PSR[524].R             /* INTC Priority Select Register */
#define INTC_0_PSR525        INTC_0.PSR[525].R             /* INTC Priority Select Register */
#define INTC_0_PSR526        INTC_0.PSR[526].R             /* INTC Priority Select Register */
#define INTC_0_PSR527        INTC_0.PSR[527].R             /* INTC Priority Select Register */
#define INTC_0_PSR528        INTC_0.PSR[528].R             /* INTC Priority Select Register */
#define INTC_0_PSR529        INTC_0.PSR[529].R             /* INTC Priority Select Register */
#define INTC_0_PSR530        INTC_0.PSR[530].R             /* INTC Priority Select Register */
#define INTC_0_PSR531        INTC_0.PSR[531].R             /* INTC Priority Select Register */
#define INTC_0_PSR532        INTC_0.PSR[532].R             /* INTC Priority Select Register */
#define INTC_0_PSR533        INTC_0.PSR[533].R             /* INTC Priority Select Register */
#define INTC_0_PSR534        INTC_0.PSR[534].R             /* INTC Priority Select Register */
#define INTC_0_PSR535        INTC_0.PSR[535].R             /* INTC Priority Select Register */
#define INTC_0_PSR536        INTC_0.PSR[536].R             /* INTC Priority Select Register */
#define INTC_0_PSR537        INTC_0.PSR[537].R             /* INTC Priority Select Register */
#define INTC_0_PSR538        INTC_0.PSR[538].R             /* INTC Priority Select Register */
#define INTC_0_PSR539        INTC_0.PSR[539].R             /* INTC Priority Select Register */
#define INTC_0_PSR540        INTC_0.PSR[540].R             /* INTC Priority Select Register */
#define INTC_0_PSR541        INTC_0.PSR[541].R             /* INTC Priority Select Register */
#define INTC_0_PSR542        INTC_0.PSR[542].R             /* INTC Priority Select Register */
#define INTC_0_PSR543        INTC_0.PSR[543].R             /* INTC Priority Select Register */
#define INTC_0_PSR544        INTC_0.PSR[544].R             /* INTC Priority Select Register */
#define INTC_0_PSR545        INTC_0.PSR[545].R             /* INTC Priority Select Register */
#define INTC_0_PSR546        INTC_0.PSR[546].R             /* INTC Priority Select Register */
#define INTC_0_PSR547        INTC_0.PSR[547].R             /* INTC Priority Select Register */
#define INTC_0_PSR548        INTC_0.PSR[548].R             /* INTC Priority Select Register */
#define INTC_0_PSR549        INTC_0.PSR[549].R             /* INTC Priority Select Register */
#define INTC_0_PSR550        INTC_0.PSR[550].R             /* INTC Priority Select Register */
#define INTC_0_PSR551        INTC_0.PSR[551].R             /* INTC Priority Select Register */
#define INTC_0_PSR552        INTC_0.PSR[552].R             /* INTC Priority Select Register */
#define INTC_0_PSR553        INTC_0.PSR[553].R             /* INTC Priority Select Register */
#define INTC_0_PSR554        INTC_0.PSR[554].R             /* INTC Priority Select Register */
#define INTC_0_PSR555        INTC_0.PSR[555].R             /* INTC Priority Select Register */
#define INTC_0_PSR556        INTC_0.PSR[556].R             /* INTC Priority Select Register */
#define INTC_0_PSR557        INTC_0.PSR[557].R             /* INTC Priority Select Register */
#define INTC_0_PSR558        INTC_0.PSR[558].R             /* INTC Priority Select Register */
#define INTC_0_PSR559        INTC_0.PSR[559].R             /* INTC Priority Select Register */
#define INTC_0_PSR560        INTC_0.PSR[560].R             /* INTC Priority Select Register */
#define INTC_0_PSR561        INTC_0.PSR[561].R             /* INTC Priority Select Register */
#define INTC_0_PSR562        INTC_0.PSR[562].R             /* INTC Priority Select Register */
#define INTC_0_PSR563        INTC_0.PSR[563].R             /* INTC Priority Select Register */
#define INTC_0_PSR564        INTC_0.PSR[564].R             /* INTC Priority Select Register */
#define INTC_0_PSR565        INTC_0.PSR[565].R             /* INTC Priority Select Register */
#define INTC_0_PSR566        INTC_0.PSR[566].R             /* INTC Priority Select Register */
#define INTC_0_PSR567        INTC_0.PSR[567].R             /* INTC Priority Select Register */
#define INTC_0_PSR568        INTC_0.PSR[568].R             /* INTC Priority Select Register */
#define INTC_0_PSR569        INTC_0.PSR[569].R             /* INTC Priority Select Register */
#define INTC_0_PSR570        INTC_0.PSR[570].R             /* INTC Priority Select Register */
#define INTC_0_PSR571        INTC_0.PSR[571].R             /* INTC Priority Select Register */
#define INTC_0_PSR572        INTC_0.PSR[572].R             /* INTC Priority Select Register */
#define INTC_0_PSR573        INTC_0.PSR[573].R             /* INTC Priority Select Register */
#define INTC_0_PSR574        INTC_0.PSR[574].R             /* INTC Priority Select Register */
#define INTC_0_PSR575        INTC_0.PSR[575].R             /* INTC Priority Select Register */
#define INTC_0_PSR576        INTC_0.PSR[576].R             /* INTC Priority Select Register */
#define INTC_0_PSR577        INTC_0.PSR[577].R             /* INTC Priority Select Register */
#define INTC_0_PSR578        INTC_0.PSR[578].R             /* INTC Priority Select Register */
#define INTC_0_PSR579        INTC_0.PSR[579].R             /* INTC Priority Select Register */
#define INTC_0_PSR580        INTC_0.PSR[580].R             /* INTC Priority Select Register */
#define INTC_0_PSR581        INTC_0.PSR[581].R             /* INTC Priority Select Register */
#define INTC_0_PSR582        INTC_0.PSR[582].R             /* INTC Priority Select Register */
#define INTC_0_PSR583        INTC_0.PSR[583].R             /* INTC Priority Select Register */
#define INTC_0_PSR584        INTC_0.PSR[584].R             /* INTC Priority Select Register */
#define INTC_0_PSR585        INTC_0.PSR[585].R             /* INTC Priority Select Register */
#define INTC_0_PSR586        INTC_0.PSR[586].R             /* INTC Priority Select Register */
#define INTC_0_PSR587        INTC_0.PSR[587].R             /* INTC Priority Select Register */
#define INTC_0_PSR588        INTC_0.PSR[588].R             /* INTC Priority Select Register */
#define INTC_0_PSR589        INTC_0.PSR[589].R             /* INTC Priority Select Register */
#define INTC_0_PSR590        INTC_0.PSR[590].R             /* INTC Priority Select Register */
#define INTC_0_PSR591        INTC_0.PSR[591].R             /* INTC Priority Select Register */
#define INTC_0_PSR592        INTC_0.PSR[592].R             /* INTC Priority Select Register */
#define INTC_0_PSR593        INTC_0.PSR[593].R             /* INTC Priority Select Register */
#define INTC_0_PSR594        INTC_0.PSR[594].R             /* INTC Priority Select Register */
#define INTC_0_PSR595        INTC_0.PSR[595].R             /* INTC Priority Select Register */
#define INTC_0_PSR596        INTC_0.PSR[596].R             /* INTC Priority Select Register */
#define INTC_0_PSR597        INTC_0.PSR[597].R             /* INTC Priority Select Register */
#define INTC_0_PSR598        INTC_0.PSR[598].R             /* INTC Priority Select Register */
#define INTC_0_PSR599        INTC_0.PSR[599].R             /* INTC Priority Select Register */
#define INTC_0_PSR600        INTC_0.PSR[600].R             /* INTC Priority Select Register */
#define INTC_0_PSR601        INTC_0.PSR[601].R             /* INTC Priority Select Register */
#define INTC_0_PSR602        INTC_0.PSR[602].R             /* INTC Priority Select Register */
#define INTC_0_PSR603        INTC_0.PSR[603].R             /* INTC Priority Select Register */
#define INTC_0_PSR604        INTC_0.PSR[604].R             /* INTC Priority Select Register */
#define INTC_0_PSR605        INTC_0.PSR[605].R             /* INTC Priority Select Register */
#define INTC_0_PSR606        INTC_0.PSR[606].R             /* INTC Priority Select Register */
#define INTC_0_PSR607        INTC_0.PSR[607].R             /* INTC Priority Select Register */
#define INTC_0_PSR608        INTC_0.PSR[608].R             /* INTC Priority Select Register */
#define INTC_0_PSR609        INTC_0.PSR[609].R             /* INTC Priority Select Register */
#define INTC_0_PSR610        INTC_0.PSR[610].R             /* INTC Priority Select Register */
#define INTC_0_PSR611        INTC_0.PSR[611].R             /* INTC Priority Select Register */
#define INTC_0_PSR612        INTC_0.PSR[612].R             /* INTC Priority Select Register */
#define INTC_0_PSR613        INTC_0.PSR[613].R             /* INTC Priority Select Register */
#define INTC_0_PSR614        INTC_0.PSR[614].R             /* INTC Priority Select Register */
#define INTC_0_PSR615        INTC_0.PSR[615].R             /* INTC Priority Select Register */
#define INTC_0_PSR616        INTC_0.PSR[616].R             /* INTC Priority Select Register */
#define INTC_0_PSR617        INTC_0.PSR[617].R             /* INTC Priority Select Register */
#define INTC_0_PSR618        INTC_0.PSR[618].R             /* INTC Priority Select Register */
#define INTC_0_PSR619        INTC_0.PSR[619].R             /* INTC Priority Select Register */
#define INTC_0_PSR620        INTC_0.PSR[620].R             /* INTC Priority Select Register */
#define INTC_0_PSR621        INTC_0.PSR[621].R             /* INTC Priority Select Register */
#define INTC_0_PSR622        INTC_0.PSR[622].R             /* INTC Priority Select Register */
#define INTC_0_PSR623        INTC_0.PSR[623].R             /* INTC Priority Select Register */
#define INTC_0_PSR624        INTC_0.PSR[624].R             /* INTC Priority Select Register */
#define INTC_0_PSR625        INTC_0.PSR[625].R             /* INTC Priority Select Register */
#define INTC_0_PSR626        INTC_0.PSR[626].R             /* INTC Priority Select Register */
#define INTC_0_PSR627        INTC_0.PSR[627].R             /* INTC Priority Select Register */
#define INTC_0_PSR628        INTC_0.PSR[628].R             /* INTC Priority Select Register */
#define INTC_0_PSR629        INTC_0.PSR[629].R             /* INTC Priority Select Register */
#define INTC_0_PSR630        INTC_0.PSR[630].R             /* INTC Priority Select Register */
#define INTC_0_PSR631        INTC_0.PSR[631].R             /* INTC Priority Select Register */
#define INTC_0_PSR632        INTC_0.PSR[632].R             /* INTC Priority Select Register */
#define INTC_0_PSR633        INTC_0.PSR[633].R             /* INTC Priority Select Register */
#define INTC_0_PSR634        INTC_0.PSR[634].R             /* INTC Priority Select Register */
#define INTC_0_PSR635        INTC_0.PSR[635].R             /* INTC Priority Select Register */
#define INTC_0_PSR636        INTC_0.PSR[636].R             /* INTC Priority Select Register */
#define INTC_0_PSR637        INTC_0.PSR[637].R             /* INTC Priority Select Register */
#define INTC_0_PSR638        INTC_0.PSR[638].R             /* INTC Priority Select Register */
#define INTC_0_PSR639        INTC_0.PSR[639].R             /* INTC Priority Select Register */
#define INTC_0_PSR640        INTC_0.PSR[640].R             /* INTC Priority Select Register */
#define INTC_0_PSR641        INTC_0.PSR[641].R             /* INTC Priority Select Register */
#define INTC_0_PSR642        INTC_0.PSR[642].R             /* INTC Priority Select Register */
#define INTC_0_PSR643        INTC_0.PSR[643].R             /* INTC Priority Select Register */
#define INTC_0_PSR644        INTC_0.PSR[644].R             /* INTC Priority Select Register */
#define INTC_0_PSR645        INTC_0.PSR[645].R             /* INTC Priority Select Register */
#define INTC_0_PSR646        INTC_0.PSR[646].R             /* INTC Priority Select Register */
#define INTC_0_PSR647        INTC_0.PSR[647].R             /* INTC Priority Select Register */
#define INTC_0_PSR648        INTC_0.PSR[648].R             /* INTC Priority Select Register */
#define INTC_0_PSR649        INTC_0.PSR[649].R             /* INTC Priority Select Register */
#define INTC_0_PSR650        INTC_0.PSR[650].R             /* INTC Priority Select Register */
#define INTC_0_PSR651        INTC_0.PSR[651].R             /* INTC Priority Select Register */
#define INTC_0_PSR652        INTC_0.PSR[652].R             /* INTC Priority Select Register */
#define INTC_0_PSR653        INTC_0.PSR[653].R             /* INTC Priority Select Register */
#define INTC_0_PSR654        INTC_0.PSR[654].R             /* INTC Priority Select Register */
#define INTC_0_PSR655        INTC_0.PSR[655].R             /* INTC Priority Select Register */
#define INTC_0_PSR656        INTC_0.PSR[656].R             /* INTC Priority Select Register */
#define INTC_0_PSR657        INTC_0.PSR[657].R             /* INTC Priority Select Register */
#define INTC_0_PSR658        INTC_0.PSR[658].R             /* INTC Priority Select Register */
#define INTC_0_PSR659        INTC_0.PSR[659].R             /* INTC Priority Select Register */
#define INTC_0_PSR660        INTC_0.PSR[660].R             /* INTC Priority Select Register */
#define INTC_0_PSR661        INTC_0.PSR[661].R             /* INTC Priority Select Register */
#define INTC_0_PSR662        INTC_0.PSR[662].R             /* INTC Priority Select Register */
#define INTC_0_PSR663        INTC_0.PSR[663].R             /* INTC Priority Select Register */
#define INTC_0_PSR664        INTC_0.PSR[664].R             /* INTC Priority Select Register */
#define INTC_0_PSR665        INTC_0.PSR[665].R             /* INTC Priority Select Register */
#define INTC_0_PSR666        INTC_0.PSR[666].R             /* INTC Priority Select Register */
#define INTC_0_PSR667        INTC_0.PSR[667].R             /* INTC Priority Select Register */
#define INTC_0_PSR668        INTC_0.PSR[668].R             /* INTC Priority Select Register */
#define INTC_0_PSR669        INTC_0.PSR[669].R             /* INTC Priority Select Register */
#define INTC_0_PSR670        INTC_0.PSR[670].R             /* INTC Priority Select Register */
#define INTC_0_PSR671        INTC_0.PSR[671].R             /* INTC Priority Select Register */
#define INTC_0_PSR672        INTC_0.PSR[672].R             /* INTC Priority Select Register */
#define INTC_0_PSR673        INTC_0.PSR[673].R             /* INTC Priority Select Register */
#define INTC_0_PSR674        INTC_0.PSR[674].R             /* INTC Priority Select Register */
#define INTC_0_PSR675        INTC_0.PSR[675].R             /* INTC Priority Select Register */
#define INTC_0_PSR676        INTC_0.PSR[676].R             /* INTC Priority Select Register */
#define INTC_0_PSR677        INTC_0.PSR[677].R             /* INTC Priority Select Register */
#define INTC_0_PSR678        INTC_0.PSR[678].R             /* INTC Priority Select Register */
#define INTC_0_PSR679        INTC_0.PSR[679].R             /* INTC Priority Select Register */
#define INTC_0_PSR680        INTC_0.PSR[680].R             /* INTC Priority Select Register */
#define INTC_0_PSR681        INTC_0.PSR[681].R             /* INTC Priority Select Register */
#define INTC_0_PSR682        INTC_0.PSR[682].R             /* INTC Priority Select Register */
#define INTC_0_PSR683        INTC_0.PSR[683].R             /* INTC Priority Select Register */
#define INTC_0_PSR684        INTC_0.PSR[684].R             /* INTC Priority Select Register */
#define INTC_0_PSR685        INTC_0.PSR[685].R             /* INTC Priority Select Register */
#define INTC_0_PSR686        INTC_0.PSR[686].R             /* INTC Priority Select Register */
#define INTC_0_PSR687        INTC_0.PSR[687].R             /* INTC Priority Select Register */
#define INTC_0_PSR688        INTC_0.PSR[688].R             /* INTC Priority Select Register */
#define INTC_0_PSR689        INTC_0.PSR[689].R             /* INTC Priority Select Register */
#define INTC_0_PSR690        INTC_0.PSR[690].R             /* INTC Priority Select Register */
#define INTC_0_PSR691        INTC_0.PSR[691].R             /* INTC Priority Select Register */
#define INTC_0_PSR692        INTC_0.PSR[692].R             /* INTC Priority Select Register */
#define INTC_0_PSR693        INTC_0.PSR[693].R             /* INTC Priority Select Register */
#define INTC_0_PSR694        INTC_0.PSR[694].R             /* INTC Priority Select Register */
#define INTC_0_PSR695        INTC_0.PSR[695].R             /* INTC Priority Select Register */
#define INTC_0_PSR696        INTC_0.PSR[696].R             /* INTC Priority Select Register */
#define INTC_0_PSR697        INTC_0.PSR[697].R             /* INTC Priority Select Register */
#define INTC_0_PSR698        INTC_0.PSR[698].R             /* INTC Priority Select Register */
#define INTC_0_PSR699        INTC_0.PSR[699].R             /* INTC Priority Select Register */
#define INTC_0_PSR700        INTC_0.PSR[700].R             /* INTC Priority Select Register */
#define INTC_0_PSR701        INTC_0.PSR[701].R             /* INTC Priority Select Register */
#define INTC_0_PSR702        INTC_0.PSR[702].R             /* INTC Priority Select Register */
#define INTC_0_PSR703        INTC_0.PSR[703].R             /* INTC Priority Select Register */
#define INTC_0_PSR704        INTC_0.PSR[704].R             /* INTC Priority Select Register */
#define INTC_0_PSR705        INTC_0.PSR[705].R             /* INTC Priority Select Register */
#define INTC_0_PSR706        INTC_0.PSR[706].R             /* INTC Priority Select Register */
#define INTC_0_PSR707        INTC_0.PSR[707].R             /* INTC Priority Select Register */
#define INTC_0_PSR708        INTC_0.PSR[708].R             /* INTC Priority Select Register */
#define INTC_0_PSR709        INTC_0.PSR[709].R             /* INTC Priority Select Register */
#define INTC_0_PSR710        INTC_0.PSR[710].R             /* INTC Priority Select Register */
#define INTC_0_PSR711        INTC_0.PSR[711].R             /* INTC Priority Select Register */
#define INTC_0_PSR712        INTC_0.PSR[712].R             /* INTC Priority Select Register */
#define INTC_0_PSR713        INTC_0.PSR[713].R             /* INTC Priority Select Register */
#define INTC_0_PSR714        INTC_0.PSR[714].R             /* INTC Priority Select Register */
#define INTC_0_PSR715        INTC_0.PSR[715].R             /* INTC Priority Select Register */
#define INTC_0_PSR716        INTC_0.PSR[716].R             /* INTC Priority Select Register */
#define INTC_0_PSR717        INTC_0.PSR[717].R             /* INTC Priority Select Register */
#define INTC_0_PSR718        INTC_0.PSR[718].R             /* INTC Priority Select Register */
#define INTC_0_PSR719        INTC_0.PSR[719].R             /* INTC Priority Select Register */
#define INTC_0_PSR720        INTC_0.PSR[720].R             /* INTC Priority Select Register */
#define INTC_0_PSR721        INTC_0.PSR[721].R             /* INTC Priority Select Register */
#define INTC_0_PSR722        INTC_0.PSR[722].R             /* INTC Priority Select Register */
#define INTC_0_PSR723        INTC_0.PSR[723].R             /* INTC Priority Select Register */
#define INTC_0_PSR724        INTC_0.PSR[724].R             /* INTC Priority Select Register */
#define INTC_0_PSR725        INTC_0.PSR[725].R             /* INTC Priority Select Register */
#define INTC_0_PSR726        INTC_0.PSR[726].R             /* INTC Priority Select Register */
#define INTC_0_PSR727        INTC_0.PSR[727].R             /* INTC Priority Select Register */
#define INTC_0_PSR728        INTC_0.PSR[728].R             /* INTC Priority Select Register */
#define INTC_0_PSR729        INTC_0.PSR[729].R             /* INTC Priority Select Register */
#define INTC_0_PSR730        INTC_0.PSR[730].R             /* INTC Priority Select Register */
#define INTC_0_PSR731        INTC_0.PSR[731].R             /* INTC Priority Select Register */
#define INTC_0_PSR732        INTC_0.PSR[732].R             /* INTC Priority Select Register */
#define INTC_0_PSR733        INTC_0.PSR[733].R             /* INTC Priority Select Register */
#define INTC_0_PSR734        INTC_0.PSR[734].R             /* INTC Priority Select Register */
#define INTC_0_PSR735        INTC_0.PSR[735].R             /* INTC Priority Select Register */
#define INTC_0_PSR736        INTC_0.PSR[736].R             /* INTC Priority Select Register */
#define INTC_0_PSR737        INTC_0.PSR[737].R             /* INTC Priority Select Register */
#define INTC_0_PSR738        INTC_0.PSR[738].R             /* INTC Priority Select Register */
#define INTC_0_PSR739        INTC_0.PSR[739].R             /* INTC Priority Select Register */
#define INTC_0_PSR740        INTC_0.PSR[740].R             /* INTC Priority Select Register */
#define INTC_0_PSR741        INTC_0.PSR[741].R             /* INTC Priority Select Register */
#define INTC_0_PSR742        INTC_0.PSR[742].R             /* INTC Priority Select Register */
#define INTC_0_PSR743        INTC_0.PSR[743].R             /* INTC Priority Select Register */
#define INTC_0_PSR744        INTC_0.PSR[744].R             /* INTC Priority Select Register */
#define INTC_0_PSR745        INTC_0.PSR[745].R             /* INTC Priority Select Register */
#define INTC_0_PSR746        INTC_0.PSR[746].R             /* INTC Priority Select Register */
#define INTC_0_PSR747        INTC_0.PSR[747].R             /* INTC Priority Select Register */
#define INTC_0_PSR748        INTC_0.PSR[748].R             /* INTC Priority Select Register */
#define INTC_0_PSR749        INTC_0.PSR[749].R             /* INTC Priority Select Register */
#define INTC_0_PSR750        INTC_0.PSR[750].R             /* INTC Priority Select Register */
#define INTC_0_PSR751        INTC_0.PSR[751].R             /* INTC Priority Select Register */
#define INTC_0_PSR752        INTC_0.PSR[752].R             /* INTC Priority Select Register */
#define INTC_0_PSR753        INTC_0.PSR[753].R             /* INTC Priority Select Register */
#define INTC_0_PSR754        INTC_0.PSR[754].R             /* INTC Priority Select Register */
#define INTC_0_PSR755        INTC_0.PSR[755].R             /* INTC Priority Select Register */
#define INTC_0_PSR756        INTC_0.PSR[756].R             /* INTC Priority Select Register */
#define INTC_0_PSR757        INTC_0.PSR[757].R             /* INTC Priority Select Register */
#define INTC_0_PSR758        INTC_0.PSR[758].R             /* INTC Priority Select Register */
#define INTC_0_PSR759        INTC_0.PSR[759].R             /* INTC Priority Select Register */
#define INTC_0_PSR760        INTC_0.PSR[760].R             /* INTC Priority Select Register */
#define INTC_0_PSR761        INTC_0.PSR[761].R             /* INTC Priority Select Register */
#define INTC_0_PSR762        INTC_0.PSR[762].R             /* INTC Priority Select Register */
#define INTC_0_PSR763        INTC_0.PSR[763].R             /* INTC Priority Select Register */
#define INTC_0_PSR764        INTC_0.PSR[764].R             /* INTC Priority Select Register */
#define INTC_0_PSR765        INTC_0.PSR[765].R             /* INTC Priority Select Register */
#define INTC_0_PSR766        INTC_0.PSR[766].R             /* INTC Priority Select Register */
#define INTC_0_PSR767        INTC_0.PSR[767].R             /* INTC Priority Select Register */
#define INTC_0_PSR768        INTC_0.PSR[768].R             /* INTC Priority Select Register */
#define INTC_0_PSR769        INTC_0.PSR[769].R             /* INTC Priority Select Register */
#define INTC_0_PSR770        INTC_0.PSR[770].R             /* INTC Priority Select Register */
#define INTC_0_PSR771        INTC_0.PSR[771].R             /* INTC Priority Select Register */
#define INTC_0_PSR772        INTC_0.PSR[772].R             /* INTC Priority Select Register */
#define INTC_0_PSR773        INTC_0.PSR[773].R             /* INTC Priority Select Register */
#define INTC_0_PSR774        INTC_0.PSR[774].R             /* INTC Priority Select Register */
#define INTC_0_PSR775        INTC_0.PSR[775].R             /* INTC Priority Select Register */
#define INTC_0_PSR776        INTC_0.PSR[776].R             /* INTC Priority Select Register */
#define INTC_0_PSR777        INTC_0.PSR[777].R             /* INTC Priority Select Register */
#define INTC_0_PSR778        INTC_0.PSR[778].R             /* INTC Priority Select Register */
#define INTC_0_PSR779        INTC_0.PSR[779].R             /* INTC Priority Select Register */
#define INTC_0_PSR780        INTC_0.PSR[780].R             /* INTC Priority Select Register */
#define INTC_0_PSR781        INTC_0.PSR[781].R             /* INTC Priority Select Register */
#define INTC_0_PSR782        INTC_0.PSR[782].R             /* INTC Priority Select Register */
#define INTC_0_PSR783        INTC_0.PSR[783].R             /* INTC Priority Select Register */
#define INTC_0_PSR784        INTC_0.PSR[784].R             /* INTC Priority Select Register */
#define INTC_0_PSR785        INTC_0.PSR[785].R             /* INTC Priority Select Register */
#define INTC_0_PSR786        INTC_0.PSR[786].R             /* INTC Priority Select Register */
#define INTC_0_PSR787        INTC_0.PSR[787].R             /* INTC Priority Select Register */
#define INTC_0_PSR788        INTC_0.PSR[788].R             /* INTC Priority Select Register */
#define INTC_0_PSR789        INTC_0.PSR[789].R             /* INTC Priority Select Register */
#define INTC_0_PSR790        INTC_0.PSR[790].R             /* INTC Priority Select Register */
#define INTC_0_PSR791        INTC_0.PSR[791].R             /* INTC Priority Select Register */
#define INTC_0_PSR792        INTC_0.PSR[792].R             /* INTC Priority Select Register */
#define INTC_0_PSR793        INTC_0.PSR[793].R             /* INTC Priority Select Register */
#define INTC_0_PSR794        INTC_0.PSR[794].R             /* INTC Priority Select Register */
#define INTC_0_PSR795        INTC_0.PSR[795].R             /* INTC Priority Select Register */
#define INTC_0_PSR796        INTC_0.PSR[796].R             /* INTC Priority Select Register */
#define INTC_0_PSR797        INTC_0.PSR[797].R             /* INTC Priority Select Register */
#define INTC_0_PSR798        INTC_0.PSR[798].R             /* INTC Priority Select Register */
#define INTC_0_PSR799        INTC_0.PSR[799].R             /* INTC Priority Select Register */
#define INTC_0_PSR800        INTC_0.PSR[800].R             /* INTC Priority Select Register */
#define INTC_0_PSR801        INTC_0.PSR[801].R             /* INTC Priority Select Register */
#define INTC_0_PSR802        INTC_0.PSR[802].R             /* INTC Priority Select Register */
#define INTC_0_PSR803        INTC_0.PSR[803].R             /* INTC Priority Select Register */
#define INTC_0_PSR804        INTC_0.PSR[804].R             /* INTC Priority Select Register */
#define INTC_0_PSR805        INTC_0.PSR[805].R             /* INTC Priority Select Register */
#define INTC_0_PSR806        INTC_0.PSR[806].R             /* INTC Priority Select Register */
#define INTC_0_PSR807        INTC_0.PSR[807].R             /* INTC Priority Select Register */
#define INTC_0_PSR808        INTC_0.PSR[808].R             /* INTC Priority Select Register */
#define INTC_0_PSR809        INTC_0.PSR[809].R             /* INTC Priority Select Register */
#define INTC_0_PSR810        INTC_0.PSR[810].R             /* INTC Priority Select Register */
#define INTC_0_PSR811        INTC_0.PSR[811].R             /* INTC Priority Select Register */
#define INTC_0_PSR812        INTC_0.PSR[812].R             /* INTC Priority Select Register */
#define INTC_0_PSR813        INTC_0.PSR[813].R             /* INTC Priority Select Register */
#define INTC_0_PSR814        INTC_0.PSR[814].R             /* INTC Priority Select Register */
#define INTC_0_PSR815        INTC_0.PSR[815].R             /* INTC Priority Select Register */
#define INTC_0_PSR816        INTC_0.PSR[816].R             /* INTC Priority Select Register */
#define INTC_0_PSR817        INTC_0.PSR[817].R             /* INTC Priority Select Register */
#define INTC_0_PSR818        INTC_0.PSR[818].R             /* INTC Priority Select Register */
#define INTC_0_PSR819        INTC_0.PSR[819].R             /* INTC Priority Select Register */
#define INTC_0_PSR820        INTC_0.PSR[820].R             /* INTC Priority Select Register */
#define INTC_0_PSR821        INTC_0.PSR[821].R             /* INTC Priority Select Register */
#define INTC_0_PSR822        INTC_0.PSR[822].R             /* INTC Priority Select Register */
#define INTC_0_PSR823        INTC_0.PSR[823].R             /* INTC Priority Select Register */
#define INTC_0_PSR824        INTC_0.PSR[824].R             /* INTC Priority Select Register */
#define INTC_0_PSR825        INTC_0.PSR[825].R             /* INTC Priority Select Register */
#define INTC_0_PSR826        INTC_0.PSR[826].R             /* INTC Priority Select Register */
#define INTC_0_PSR827        INTC_0.PSR[827].R             /* INTC Priority Select Register */
#define INTC_0_PSR828        INTC_0.PSR[828].R             /* INTC Priority Select Register */
#define INTC_0_PSR829        INTC_0.PSR[829].R             /* INTC Priority Select Register */
#define INTC_0_PSR830        INTC_0.PSR[830].R             /* INTC Priority Select Register */
#define INTC_0_PSR831        INTC_0.PSR[831].R             /* INTC Priority Select Register */
#define INTC_0_PSR832        INTC_0.PSR[832].R             /* INTC Priority Select Register */
#define INTC_0_PSR833        INTC_0.PSR[833].R             /* INTC Priority Select Register */
#define INTC_0_PSR834        INTC_0.PSR[834].R             /* INTC Priority Select Register */
#define INTC_0_PSR835        INTC_0.PSR[835].R             /* INTC Priority Select Register */
#define INTC_0_PSR836        INTC_0.PSR[836].R             /* INTC Priority Select Register */
#define INTC_0_PSR837        INTC_0.PSR[837].R             /* INTC Priority Select Register */
#define INTC_0_PSR838        INTC_0.PSR[838].R             /* INTC Priority Select Register */
#define INTC_0_PSR839        INTC_0.PSR[839].R             /* INTC Priority Select Register */
#define INTC_0_PSR840        INTC_0.PSR[840].R             /* INTC Priority Select Register */
#define INTC_0_PSR841        INTC_0.PSR[841].R             /* INTC Priority Select Register */
#define INTC_0_PSR842        INTC_0.PSR[842].R             /* INTC Priority Select Register */
#define INTC_0_PSR843        INTC_0.PSR[843].R             /* INTC Priority Select Register */
#define INTC_0_PSR844        INTC_0.PSR[844].R             /* INTC Priority Select Register */
#define INTC_0_PSR845        INTC_0.PSR[845].R             /* INTC Priority Select Register */
#define INTC_0_PSR846        INTC_0.PSR[846].R             /* INTC Priority Select Register */
#define INTC_0_PSR847        INTC_0.PSR[847].R             /* INTC Priority Select Register */
#define INTC_0_PSR848        INTC_0.PSR[848].R             /* INTC Priority Select Register */
#define INTC_0_PSR849        INTC_0.PSR[849].R             /* INTC Priority Select Register */
#define INTC_0_PSR850        INTC_0.PSR[850].R             /* INTC Priority Select Register */
#define INTC_0_PSR851        INTC_0.PSR[851].R             /* INTC Priority Select Register */
#define INTC_0_PSR852        INTC_0.PSR[852].R             /* INTC Priority Select Register */
#define INTC_0_PSR853        INTC_0.PSR[853].R             /* INTC Priority Select Register */
#define INTC_0_PSR854        INTC_0.PSR[854].R             /* INTC Priority Select Register */
#define INTC_0_PSR855        INTC_0.PSR[855].R             /* INTC Priority Select Register */
#define INTC_0_PSR856        INTC_0.PSR[856].R             /* INTC Priority Select Register */
#define INTC_0_PSR857        INTC_0.PSR[857].R             /* INTC Priority Select Register */
#define INTC_0_PSR858        INTC_0.PSR[858].R             /* INTC Priority Select Register */
#define INTC_0_PSR859        INTC_0.PSR[859].R             /* INTC Priority Select Register */
#define INTC_0_PSR860        INTC_0.PSR[860].R             /* INTC Priority Select Register */
#define INTC_0_PSR861        INTC_0.PSR[861].R             /* INTC Priority Select Register */
#define INTC_0_PSR862        INTC_0.PSR[862].R             /* INTC Priority Select Register */
#define INTC_0_PSR863        INTC_0.PSR[863].R             /* INTC Priority Select Register */
#define INTC_0_PSR864        INTC_0.PSR[864].R             /* INTC Priority Select Register */
#define INTC_0_PSR865        INTC_0.PSR[865].R             /* INTC Priority Select Register */
#define INTC_0_PSR866        INTC_0.PSR[866].R             /* INTC Priority Select Register */
#define INTC_0_PSR867        INTC_0.PSR[867].R             /* INTC Priority Select Register */
#define INTC_0_PSR868        INTC_0.PSR[868].R             /* INTC Priority Select Register */
#define INTC_0_PSR869        INTC_0.PSR[869].R             /* INTC Priority Select Register */
#define INTC_0_PSR870        INTC_0.PSR[870].R             /* INTC Priority Select Register */
#define INTC_0_PSR871        INTC_0.PSR[871].R             /* INTC Priority Select Register */
#define INTC_0_PSR872        INTC_0.PSR[872].R             /* INTC Priority Select Register */
#define INTC_0_PSR873        INTC_0.PSR[873].R             /* INTC Priority Select Register */
#define INTC_0_PSR874        INTC_0.PSR[874].R             /* INTC Priority Select Register */
#define INTC_0_PSR875        INTC_0.PSR[875].R             /* INTC Priority Select Register */
#define INTC_0_PSR876        INTC_0.PSR[876].R             /* INTC Priority Select Register */
#define INTC_0_PSR877        INTC_0.PSR[877].R             /* INTC Priority Select Register */
#define INTC_0_PSR878        INTC_0.PSR[878].R             /* INTC Priority Select Register */
#define INTC_0_PSR879        INTC_0.PSR[879].R             /* INTC Priority Select Register */
#define INTC_0_PSR880        INTC_0.PSR[880].R             /* INTC Priority Select Register */
#define INTC_0_PSR881        INTC_0.PSR[881].R             /* INTC Priority Select Register */
#define INTC_0_PSR882        INTC_0.PSR[882].R             /* INTC Priority Select Register */
#define INTC_0_PSR883        INTC_0.PSR[883].R             /* INTC Priority Select Register */
#define INTC_0_PSR884        INTC_0.PSR[884].R             /* INTC Priority Select Register */
#define INTC_0_PSR885        INTC_0.PSR[885].R             /* INTC Priority Select Register */
#define INTC_0_PSR886        INTC_0.PSR[886].R             /* INTC Priority Select Register */
#define INTC_0_PSR887        INTC_0.PSR[887].R             /* INTC Priority Select Register */
#define INTC_0_PSR888        INTC_0.PSR[888].R             /* INTC Priority Select Register */
#define INTC_0_PSR889        INTC_0.PSR[889].R             /* INTC Priority Select Register */
#define INTC_0_PSR890        INTC_0.PSR[890].R             /* INTC Priority Select Register */
#define INTC_0_PSR891        INTC_0.PSR[891].R             /* INTC Priority Select Register */
#define INTC_0_PSR892        INTC_0.PSR[892].R             /* INTC Priority Select Register */
#define INTC_0_PSR893        INTC_0.PSR[893].R             /* INTC Priority Select Register */
#define INTC_0_PSR894        INTC_0.PSR[894].R             /* INTC Priority Select Register */
#define INTC_0_PSR895        INTC_0.PSR[895].R             /* INTC Priority Select Register */
#define INTC_0_PSR896        INTC_0.PSR[896].R             /* INTC Priority Select Register */
#define INTC_0_PSR897        INTC_0.PSR[897].R             /* INTC Priority Select Register */
#define INTC_0_PSR898        INTC_0.PSR[898].R             /* INTC Priority Select Register */
#define INTC_0_PSR899        INTC_0.PSR[899].R             /* INTC Priority Select Register */
#define INTC_0_PSR900        INTC_0.PSR[900].R             /* INTC Priority Select Register */
#define INTC_0_PSR901        INTC_0.PSR[901].R             /* INTC Priority Select Register */
#define INTC_0_PSR902        INTC_0.PSR[902].R             /* INTC Priority Select Register */
#define INTC_0_PSR903        INTC_0.PSR[903].R             /* INTC Priority Select Register */
#define INTC_0_PSR904        INTC_0.PSR[904].R             /* INTC Priority Select Register */
#define INTC_0_PSR905        INTC_0.PSR[905].R             /* INTC Priority Select Register */
#define INTC_0_PSR906        INTC_0.PSR[906].R             /* INTC Priority Select Register */
#define INTC_0_PSR907        INTC_0.PSR[907].R             /* INTC Priority Select Register */
#define INTC_0_PSR908        INTC_0.PSR[908].R             /* INTC Priority Select Register */
#define INTC_0_PSR909        INTC_0.PSR[909].R             /* INTC Priority Select Register */
#define INTC_0_PSR910        INTC_0.PSR[910].R             /* INTC Priority Select Register */
#define INTC_0_PSR911        INTC_0.PSR[911].R             /* INTC Priority Select Register */
#define INTC_0_PSR912        INTC_0.PSR[912].R             /* INTC Priority Select Register */
#define INTC_0_PSR913        INTC_0.PSR[913].R             /* INTC Priority Select Register */
#define INTC_0_PSR914        INTC_0.PSR[914].R             /* INTC Priority Select Register */
#define INTC_0_PSR915        INTC_0.PSR[915].R             /* INTC Priority Select Register */
#define INTC_0_PSR916        INTC_0.PSR[916].R             /* INTC Priority Select Register */
#define INTC_0_PSR917        INTC_0.PSR[917].R             /* INTC Priority Select Register */
#define INTC_0_PSR918        INTC_0.PSR[918].R             /* INTC Priority Select Register */
#define INTC_0_PSR919        INTC_0.PSR[919].R             /* INTC Priority Select Register */
#define INTC_0_PSR920        INTC_0.PSR[920].R             /* INTC Priority Select Register */
#define INTC_0_PSR921        INTC_0.PSR[921].R             /* INTC Priority Select Register */
#define INTC_0_PSR922        INTC_0.PSR[922].R             /* INTC Priority Select Register */
#define INTC_0_PSR923        INTC_0.PSR[923].R             /* INTC Priority Select Register */
#define INTC_0_PSR924        INTC_0.PSR[924].R             /* INTC Priority Select Register */
#define INTC_0_PSR925        INTC_0.PSR[925].R             /* INTC Priority Select Register */
#define INTC_0_PSR926        INTC_0.PSR[926].R             /* INTC Priority Select Register */
#define INTC_0_PSR927        INTC_0.PSR[927].R             /* INTC Priority Select Register */
#define INTC_0_PSR928        INTC_0.PSR[928].R             /* INTC Priority Select Register */
#define INTC_0_PSR929        INTC_0.PSR[929].R             /* INTC Priority Select Register */
#define INTC_0_PSR930        INTC_0.PSR[930].R             /* INTC Priority Select Register */
#define INTC_0_PSR931        INTC_0.PSR[931].R             /* INTC Priority Select Register */
#define INTC_0_PSR932        INTC_0.PSR[932].R             /* INTC Priority Select Register */
#define INTC_0_PSR933        INTC_0.PSR[933].R             /* INTC Priority Select Register */
#define INTC_0_PSR934        INTC_0.PSR[934].R             /* INTC Priority Select Register */
#define INTC_0_PSR935        INTC_0.PSR[935].R             /* INTC Priority Select Register */
#define INTC_0_PSR936        INTC_0.PSR[936].R             /* INTC Priority Select Register */
#define INTC_0_PSR937        INTC_0.PSR[937].R             /* INTC Priority Select Register */
#define INTC_0_PSR938        INTC_0.PSR[938].R             /* INTC Priority Select Register */
#define INTC_0_PSR939        INTC_0.PSR[939].R             /* INTC Priority Select Register */
#define INTC_0_PSR940        INTC_0.PSR[940].R             /* INTC Priority Select Register */
#define INTC_0_PSR941        INTC_0.PSR[941].R             /* INTC Priority Select Register */
#define INTC_0_PSR942        INTC_0.PSR[942].R             /* INTC Priority Select Register */
#define INTC_0_PSR943        INTC_0.PSR[943].R             /* INTC Priority Select Register */
#define INTC_0_PSR944        INTC_0.PSR[944].R             /* INTC Priority Select Register */
#define INTC_0_PSR945        INTC_0.PSR[945].R             /* INTC Priority Select Register */
#define INTC_0_PSR946        INTC_0.PSR[946].R             /* INTC Priority Select Register */
#define INTC_0_PSR947        INTC_0.PSR[947].R             /* INTC Priority Select Register */
#define INTC_0_PSR948        INTC_0.PSR[948].R             /* INTC Priority Select Register */
#define INTC_0_PSR949        INTC_0.PSR[949].R             /* INTC Priority Select Register */
#define INTC_0_PSR950        INTC_0.PSR[950].R             /* INTC Priority Select Register */
#define INTC_0_PSR951        INTC_0.PSR[951].R             /* INTC Priority Select Register */
#define INTC_0_PSR952        INTC_0.PSR[952].R             /* INTC Priority Select Register */
#define INTC_0_PSR953        INTC_0.PSR[953].R             /* INTC Priority Select Register */
#define INTC_0_PSR954        INTC_0.PSR[954].R             /* INTC Priority Select Register */
#define INTC_0_PSR955        INTC_0.PSR[955].R             /* INTC Priority Select Register */
#define INTC_0_PSR956        INTC_0.PSR[956].R             /* INTC Priority Select Register */
#define INTC_0_PSR957        INTC_0.PSR[957].R             /* INTC Priority Select Register */
#define INTC_0_PSR958        INTC_0.PSR[958].R             /* INTC Priority Select Register */
#define INTC_0_PSR959        INTC_0.PSR[959].R             /* INTC Priority Select Register */
#define INTC_0_PSR960        INTC_0.PSR[960].R             /* INTC Priority Select Register */
#define INTC_0_PSR961        INTC_0.PSR[961].R             /* INTC Priority Select Register */
#define INTC_0_PSR962        INTC_0.PSR[962].R             /* INTC Priority Select Register */
#define INTC_0_PSR963        INTC_0.PSR[963].R             /* INTC Priority Select Register */
#define INTC_0_PSR964        INTC_0.PSR[964].R             /* INTC Priority Select Register */
#define INTC_0_PSR965        INTC_0.PSR[965].R             /* INTC Priority Select Register */
#define INTC_0_PSR966        INTC_0.PSR[966].R             /* INTC Priority Select Register */
#define INTC_0_PSR967        INTC_0.PSR[967].R             /* INTC Priority Select Register */
#define INTC_0_PSR968        INTC_0.PSR[968].R             /* INTC Priority Select Register */
#define INTC_0_PSR969        INTC_0.PSR[969].R             /* INTC Priority Select Register */
#define INTC_0_PSR970        INTC_0.PSR[970].R             /* INTC Priority Select Register */
#define INTC_0_PSR971        INTC_0.PSR[971].R             /* INTC Priority Select Register */
#define INTC_0_PSR972        INTC_0.PSR[972].R             /* INTC Priority Select Register */
#define INTC_0_PSR973        INTC_0.PSR[973].R             /* INTC Priority Select Register */
#define INTC_0_PSR974        INTC_0.PSR[974].R             /* INTC Priority Select Register */
#define INTC_0_PSR975        INTC_0.PSR[975].R             /* INTC Priority Select Register */
#define INTC_0_PSR976        INTC_0.PSR[976].R             /* INTC Priority Select Register */
#define INTC_0_PSR977        INTC_0.PSR[977].R             /* INTC Priority Select Register */
#define INTC_0_PSR978        INTC_0.PSR[978].R             /* INTC Priority Select Register */
#define INTC_0_PSR979        INTC_0.PSR[979].R             /* INTC Priority Select Register */
#define INTC_0_PSR980        INTC_0.PSR[980].R             /* INTC Priority Select Register */
#define INTC_0_PSR981        INTC_0.PSR[981].R             /* INTC Priority Select Register */
#define INTC_0_PSR982        INTC_0.PSR[982].R             /* INTC Priority Select Register */
#define INTC_0_PSR983        INTC_0.PSR[983].R             /* INTC Priority Select Register */
#define INTC_0_PSR984        INTC_0.PSR[984].R             /* INTC Priority Select Register */
#define INTC_0_PSR985        INTC_0.PSR[985].R             /* INTC Priority Select Register */
#define INTC_0_PSR986        INTC_0.PSR[986].R             /* INTC Priority Select Register */
#define INTC_0_PSR987        INTC_0.PSR[987].R             /* INTC Priority Select Register */
#define INTC_0_PSR988        INTC_0.PSR[988].R             /* INTC Priority Select Register */
#define INTC_0_PSR989        INTC_0.PSR[989].R             /* INTC Priority Select Register */
#define INTC_0_PSR990        INTC_0.PSR[990].R             /* INTC Priority Select Register */
#define INTC_0_PSR991        INTC_0.PSR[991].R             /* INTC Priority Select Register */
#define INTC_0_PSR992        INTC_0.PSR[992].R             /* INTC Priority Select Register */
#define INTC_0_PSR993        INTC_0.PSR[993].R             /* INTC Priority Select Register */
#define INTC_0_PSR994        INTC_0.PSR[994].R             /* INTC Priority Select Register */
#define INTC_0_PSR995        INTC_0.PSR[995].R             /* INTC Priority Select Register */
#define INTC_0_PSR996        INTC_0.PSR[996].R             /* INTC Priority Select Register */
#define INTC_0_PSR997        INTC_0.PSR[997].R             /* INTC Priority Select Register */
#define INTC_0_PSR998        INTC_0.PSR[998].R             /* INTC Priority Select Register */
#define INTC_0_PSR999        INTC_0.PSR[999].R             /* INTC Priority Select Register */
#define INTC_0_PSR1000       INTC_0.PSR[1000].R            /* INTC Priority Select Register */
#define INTC_0_PSR1001       INTC_0.PSR[1001].R            /* INTC Priority Select Register */
#define INTC_0_PSR1002       INTC_0.PSR[1002].R            /* INTC Priority Select Register */
#define INTC_0_PSR1003       INTC_0.PSR[1003].R            /* INTC Priority Select Register */
#define INTC_0_PSR1004       INTC_0.PSR[1004].R            /* INTC Priority Select Register */
#define INTC_0_PSR1005       INTC_0.PSR[1005].R            /* INTC Priority Select Register */
#define INTC_0_PSR1006       INTC_0.PSR[1006].R            /* INTC Priority Select Register */
#define INTC_0_PSR1007       INTC_0.PSR[1007].R            /* INTC Priority Select Register */
#define INTC_0_PSR1008       INTC_0.PSR[1008].R            /* INTC Priority Select Register */
#define INTC_0_PSR1009       INTC_0.PSR[1009].R            /* INTC Priority Select Register */
#define INTC_0_PSR1010       INTC_0.PSR[1010].R            /* INTC Priority Select Register */
#define INTC_0_PSR1011       INTC_0.PSR[1011].R            /* INTC Priority Select Register */
#define INTC_0_PSR1012       INTC_0.PSR[1012].R            /* INTC Priority Select Register */
#define INTC_0_PSR1013       INTC_0.PSR[1013].R            /* INTC Priority Select Register */
#define INTC_0_PSR1014       INTC_0.PSR[1014].R            /* INTC Priority Select Register */
#define INTC_0_PSR1015       INTC_0.PSR[1015].R            /* INTC Priority Select Register */
#define INTC_0_PSR1016       INTC_0.PSR[1016].R            /* INTC Priority Select Register */
#define INTC_0_PSR1017       INTC_0.PSR[1017].R            /* INTC Priority Select Register */
#define INTC_0_PSR1018       INTC_0.PSR[1018].R            /* INTC Priority Select Register */
#define INTC_0_PSR1019       INTC_0.PSR[1019].R            /* INTC Priority Select Register */
#define INTC_0_PSR1020       INTC_0.PSR[1020].R            /* INTC Priority Select Register */
#define INTC_0_PSR1021       INTC_0.PSR[1021].R            /* INTC Priority Select Register */
#define INTC_0_PSR1022       INTC_0.PSR[1022].R            /* INTC Priority Select Register */
#define INTC_0_PSR1023       INTC_0.PSR[1023].R            /* INTC Priority Select Register */
#define INTC_0_MMRC0         INTC_0.MMRC[0].R              /* INTC Monitor Mode Register */
#define INTC_0_HIPRI0C0      INTC_0.HIPRIC0[0].R           /* INTC HIPRI Register */
#define INTC_0_HIPRI1C0      INTC_0.HIPRIC0[1].R           /* INTC HIPRI Register */
#define INTC_0_HIPRI2C0      INTC_0.HIPRIC0[2].R           /* INTC HIPRI Register */
#define INTC_0_HIPRI3C0      INTC_0.HIPRIC0[3].R           /* INTC HIPRI Register */
#define INTC_0_LAT0C0        INTC_0.LATC0[0].R             /* INTC LAT Register */
#define INTC_0_LAT1C0        INTC_0.LATC0[1].R             /* INTC LAT Register */
#define INTC_0_LAT2C0        INTC_0.LATC0[2].R             /* INTC LAT Register */
#define INTC_0_LAT3C0        INTC_0.LATC0[3].R             /* INTC LAT Register */
#define INTC_0_TIMER0C0      INTC_0.TIMERC0[0].R           /* INTC Timer Register */
#define INTC_0_TIMER1C0      INTC_0.TIMERC0[1].R           /* INTC Timer Register */
#define INTC_0_TIMER2C0      INTC_0.TIMERC0[2].R           /* INTC Timer Register */
#define INTC_0_TIMER3C0      INTC_0.TIMERC0[3].R           /* INTC Timer Register */

/* IRCOSC */
#define IRCOSC_CTL           IRCOSC.CTL.R                  /* IRCOSC Control Register */

/* LFAST */
#define LFAST_0_MCR          LFAST_0.MCR.R                 /* LFAST Mode Configuration Register */
#define LFAST_0_SCR          LFAST_0.SCR.R                 /* LFAST Speed Control Register */
#define LFAST_0_COCR         LFAST_0.COCR.R                /* LFAST Correlator Control Register */
#define LFAST_0_TMCR         LFAST_0.TMCR.R                /* LFAST Test Mode Control Register */
#define LFAST_0_ALCR         LFAST_0.ALCR.R                /* LFAST Auto Loopback Control Register */
#define LFAST_0_RCDCR        LFAST_0.RCDCR.R               /* LFAST Rate Change Delay Control Register */
#define LFAST_0_SLCR         LFAST_0.SLCR.R                /* LFAST Wakeup Delay Control Register */
#define LFAST_0_ICR          LFAST_0.ICR.R                 /* LFAST ICLC Control Register */
#define LFAST_0_PICR         LFAST_0.PICR.R                /* LFAST Ping Control Register */
#define LFAST_0_RFCR         LFAST_0.RFCR.R                /* LFAST Rx FIFO CTS Control Register */
#define LFAST_0_TIER         LFAST_0.TIER.R                /* LFAST Tx Interrupt Enable Register */
#define LFAST_0_RIER         LFAST_0.RIER.R                /* LFAST Rx Interrupt Enable Register */
#define LFAST_0_RIIER        LFAST_0.RIIER.R               /* LFAST Rx ICLC Interrupt Enable Register */
#define LFAST_0_PLLCR        LFAST_0.PLLCR.R               /* LFAST PLL Control Register */
#define LFAST_0_LCR          LFAST_0.LCR.R                 /* LFAST LVDS Control Register */
#define LFAST_0_UNSTCR       LFAST_0.UNSTCR.R              /* LFAST Unsolicited Tx Control Register */
#define LFAST_0_UNSTDR0      LFAST_0.UNSTDR[0].R           /* LFAST Unsolicited Tx Data Registers */
#define LFAST_0_UNSTDR1      LFAST_0.UNSTDR[1].R           /* LFAST Unsolicited Tx Data Registers */
#define LFAST_0_UNSTDR2      LFAST_0.UNSTDR[2].R           /* LFAST Unsolicited Tx Data Registers */
#define LFAST_0_UNSTDR3      LFAST_0.UNSTDR[3].R           /* LFAST Unsolicited Tx Data Registers */
#define LFAST_0_UNSTDR4      LFAST_0.UNSTDR[4].R           /* LFAST Unsolicited Tx Data Registers */
#define LFAST_0_UNSTDR5      LFAST_0.UNSTDR[5].R           /* LFAST Unsolicited Tx Data Registers */
#define LFAST_0_UNSTDR6      LFAST_0.UNSTDR[6].R           /* LFAST Unsolicited Tx Data Registers */
#define LFAST_0_UNSTDR7      LFAST_0.UNSTDR[7].R           /* LFAST Unsolicited Tx Data Registers */
#define LFAST_0_UNSTDR8      LFAST_0.UNSTDR[8].R           /* LFAST Unsolicited Tx Data Registers */
#define LFAST_0_GSR          LFAST_0.GSR.R                 /* LFAST Global Status Register */
#define LFAST_0_PISR         LFAST_0.PISR.R                /* LFAST Ping Status Register */
#define LFAST_0_DFSR         LFAST_0.DFSR.R                /* LFAST Data Frame Status Register */
#define LFAST_0_TISR         LFAST_0.TISR.R                /* LFAST Tx Interrupt Status Register */
#define LFAST_0_RISR         LFAST_0.RISR.R                /* LFAST Rx Interrupt Status Register */
#define LFAST_0_RIISR        LFAST_0.RIISR.R               /* LFAST Rx ICLC Interrupt Status Register */
#define LFAST_0_PLLLSR       LFAST_0.PLLLSR.R              /* LFAST PLL and LVDS Status Register */
#define LFAST_0_UNSRSR       LFAST_0.UNSRSR.R              /* LFAST Unsolicited Rx Status Register */
#define LFAST_0_UNSRDR0      LFAST_0.UNSRDR[0].R           /* LFAST Unsolicited Rx Data Register */
#define LFAST_0_UNSRDR1      LFAST_0.UNSRDR[1].R           /* LFAST Unsolicited Rx Data Register */
#define LFAST_0_UNSRDR2      LFAST_0.UNSRDR[2].R           /* LFAST Unsolicited Rx Data Register */
#define LFAST_0_UNSRDR3      LFAST_0.UNSRDR[3].R           /* LFAST Unsolicited Rx Data Register */
#define LFAST_0_UNSRDR4      LFAST_0.UNSRDR[4].R           /* LFAST Unsolicited Rx Data Register */
#define LFAST_0_UNSRDR5      LFAST_0.UNSRDR[5].R           /* LFAST Unsolicited Rx Data Register */
#define LFAST_0_UNSRDR6      LFAST_0.UNSRDR[6].R           /* LFAST Unsolicited Rx Data Register */
#define LFAST_0_UNSRDR7      LFAST_0.UNSRDR[7].R           /* LFAST Unsolicited Rx Data Register */
#define LFAST_0_UNSRDR8      LFAST_0.UNSRDR[8].R           /* LFAST Unsolicited Rx Data Register */

/* LINFlexD */
#define LINFlexD_0_LINCR1    LINFlexD_0.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_0_LINIER    LINFlexD_0.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_0_LINSR     LINFlexD_0.LINSR.R            /* LIN Status Register */
#define LINFlexD_0_LINESR    LINFlexD_0.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_0_UARTCR    LINFlexD_0.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_0_UARTSR    LINFlexD_0.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_0_LINTCSR   LINFlexD_0.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_0_LINOCR    LINFlexD_0.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_0_LINTOCR   LINFlexD_0.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_0_LINFBRR   LINFlexD_0.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_0_LINIBRR   LINFlexD_0.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_0_LINCFR    LINFlexD_0.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_0_LINCR2    LINFlexD_0.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_0_BIDR      LINFlexD_0.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_0_BDRL      LINFlexD_0.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_0_BDRM      LINFlexD_0.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_0_IFER      LINFlexD_0.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_0_IFMI      LINFlexD_0.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_0_IFMR      LINFlexD_0.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_0_IFCR0     LINFlexD_0.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR1     LINFlexD_0.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR2     LINFlexD_0.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR3     LINFlexD_0.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR4     LINFlexD_0.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR5     LINFlexD_0.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR6     LINFlexD_0.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR7     LINFlexD_0.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR8     LINFlexD_0.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR9     LINFlexD_0.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR10    LINFlexD_0.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR11    LINFlexD_0.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR12    LINFlexD_0.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR13    LINFlexD_0.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR14    LINFlexD_0.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR15    LINFlexD_0.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_0_GCR       LINFlexD_0.GCR.R              /* Global Control Register */
#define LINFlexD_0_UARTPTO   LINFlexD_0.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_0_UARTCTO   LINFlexD_0.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_0_DMATXE    LINFlexD_0.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_0_DMARXE    LINFlexD_0.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_1_LINCR1    LINFlexD_1.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_1_LINIER    LINFlexD_1.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_1_LINSR     LINFlexD_1.LINSR.R            /* LIN Status Register */
#define LINFlexD_1_LINESR    LINFlexD_1.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_1_UARTCR    LINFlexD_1.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_1_UARTSR    LINFlexD_1.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_1_LINTCSR   LINFlexD_1.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_1_LINOCR    LINFlexD_1.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_1_LINTOCR   LINFlexD_1.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_1_LINFBRR   LINFlexD_1.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_1_LINIBRR   LINFlexD_1.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_1_LINCFR    LINFlexD_1.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_1_LINCR2    LINFlexD_1.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_1_BIDR      LINFlexD_1.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_1_BDRL      LINFlexD_1.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_1_BDRM      LINFlexD_1.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_1_IFER      LINFlexD_1.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_1_IFMI      LINFlexD_1.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_1_IFMR      LINFlexD_1.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_1_IFCR0     LINFlexD_1.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR1     LINFlexD_1.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR2     LINFlexD_1.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR3     LINFlexD_1.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR4     LINFlexD_1.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR5     LINFlexD_1.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR6     LINFlexD_1.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR7     LINFlexD_1.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR8     LINFlexD_1.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR9     LINFlexD_1.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR10    LINFlexD_1.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR11    LINFlexD_1.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR12    LINFlexD_1.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR13    LINFlexD_1.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR14    LINFlexD_1.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR15    LINFlexD_1.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_1_GCR       LINFlexD_1.GCR.R              /* Global Control Register */
#define LINFlexD_1_UARTPTO   LINFlexD_1.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_1_UARTCTO   LINFlexD_1.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_1_DMATXE    LINFlexD_1.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_1_DMARXE    LINFlexD_1.DMARXE.R           /* DMA Rx Enable Register */

/* MC_CGM */
#define MC_CGM_PCS_SDUR      MC_CGM.PCS_SDUR.R             /* PCS Switch Duration Register */
#define MC_CGM_PCS_DIVE1     MC_CGM.PCS_DIVE1.R            /* PCS Divider End Register 1 */
#define MC_CGM_PCS_DIVS1     MC_CGM.PCS_DIVS1.R            /* PCS Divider Start Register 1 */
#define MC_CGM_PCS_DIVC1     MC_CGM.PCS_DIVC1.R            /* PCS Divider Change Register 1 */
#define MC_CGM_PCS_DIVE2     MC_CGM.PCS_DIVE2.R            /* PCS Divider End Register 2 */
#define MC_CGM_PCS_DIVS2     MC_CGM.PCS_DIVS2.R            /* PCS Divider Start Register 2 */
#define MC_CGM_PCS_DIVC2     MC_CGM.PCS_DIVC2.R            /* PCS Divider Change Register 2 */
#define MC_CGM_PCS_DIVE4     MC_CGM.PCS_DIVE4.R            /* PCS Divider End Register 4 */
#define MC_CGM_PCS_DIVS4     MC_CGM.PCS_DIVS4.R            /* PCS Divider Start Register 4 */
#define MC_CGM_PCS_DIVC4     MC_CGM.PCS_DIVC4.R            /* PCS Divider Change Register 4 */
#define MC_CGM_SC_SS         MC_CGM.SC_SS.R                /* System Clock Select Status Register */
#define MC_CGM_SC_DC0        MC_CGM.SC_DC0.R               /* System Clock Divider 0 Configuration Register */
#define MC_CGM_AC0_SC        MC_CGM.AC0_SC.R               /* Auxiliary Clock 0 Select Control Register */
#define MC_CGM_AC0_SS        MC_CGM.AC0_SS.R               /* Auxiliary Clock 0 Select Status Register */
#define MC_CGM_AC0_DC0       MC_CGM.AC0_DC0.R              /* Auxiliary Clock 0 Divider 0 Configuration Register */
#define MC_CGM_AC0_DC1       MC_CGM.AC0_DC1.R              /* Auxiliary Clock 0 Divider 1 Configuration Register */
#define MC_CGM_AC0_DC2       MC_CGM.AC0_DC2.R              /* Auxiliary Clock 0 Divider 2 Configuration Register */
#define MC_CGM_AC1_DC0       MC_CGM.AC1_DC0.R              /* Auxiliary Clock 1 Divider 0 Configuration Register */
#define MC_CGM_AC1_DC1       MC_CGM.AC1_DC1.R              /* Auxiliary Clock 1 Divider 1 Configuration Register */
#define MC_CGM_AC2_DC0       MC_CGM.AC2_DC0.R              /* Auxiliary Clock 2 Divider 0 Configuration Register */
#define MC_CGM_AC3_SC        MC_CGM.AC3_SC.R               /* Auxiliary Clock 3 Select Control Register */
#define MC_CGM_AC3_SS        MC_CGM.AC3_SS.R               /* Auxiliary Clock 3 Select Status Register */
#define MC_CGM_AC4_SC        MC_CGM.AC4_SC.R               /* Auxiliary Clock 4 Select Control Register */
#define MC_CGM_AC4_SS        MC_CGM.AC4_SS.R               /* Auxiliary Clock 4 Select Status Register */
#define MC_CGM_AC5_SC        MC_CGM.AC5_SC.R               /* Auxiliary Clock 5 Select Control Register */
#define MC_CGM_AC5_SS        MC_CGM.AC5_SS.R               /* Auxiliary Clock 5 Select Status Register */
#define MC_CGM_AC5_DC0       MC_CGM.AC5_DC0.R              /* Auxiliary Clock 5 Divider 0 Configuration Register */
#define MC_CGM_AC6_SC        MC_CGM.AC6_SC.R               /* Auxiliary Clock 6 Select Control Register */
#define MC_CGM_AC6_SS        MC_CGM.AC6_SS.R               /* Auxiliary Clock 6 Select Status Register */
#define MC_CGM_AC6_DC0       MC_CGM.AC6_DC0.R              /* Auxiliary Clock 6 Divider 0 Configuration Register */
#define MC_CGM_AC10_SC       MC_CGM.AC10_SC.R              /* Auxiliary Clock 10 Select Control Register */
#define MC_CGM_AC10_SS       MC_CGM.AC10_SS.R              /* Auxiliary Clock 10 Select Status Register */
#define MC_CGM_AC10_DC0      MC_CGM.AC10_DC0.R             /* Auxiliary Clock 10 Divider 0 Configuration Register */
#define MC_CGM_AC11_SC       MC_CGM.AC11_SC.R              /* Auxiliary Clock 11 Select Control Register */
#define MC_CGM_AC11_SS       MC_CGM.AC11_SS.R              /* Auxiliary Clock 11 Select Status Register */
#define MC_CGM_AC11_DC0      MC_CGM.AC11_DC0.R             /* Auxiliary Clock 11 Divider 0 Configuration Register */

/* MC_ME */
#define MC_ME_GS             MC_ME.GS.R                    /* Global Status Register */
#define MC_ME_MCTL           MC_ME.MCTL.R                  /* Mode Control Register */
#define MC_ME_ME             MC_ME.ME.R                    /* Mode Enable Register */
#define MC_ME_IS             MC_ME.IS.R                    /* Interrupt Status Register */
#define MC_ME_IM             MC_ME.IM.R                    /* Interrupt Mask Register */
#define MC_ME_IMTS           MC_ME.IMTS.R                  /* Invalid Mode Transition Status Register */
#define MC_ME_DMTS           MC_ME.DMTS.R                  /* Debug Mode Transition Status Register */
#define MC_ME_RESET_MC       MC_ME.RESET_MC.R              /* RESET Mode Configuration Register */
#define MC_ME_TEST_MC        MC_ME.TEST_MC.R               /* TEST Mode Configuration Register */
#define MC_ME_SAFE_MC        MC_ME.SAFE_MC.R               /* SAFE Mode Configuration Register */
#define MC_ME_DRUN_MC        MC_ME.DRUN_MC.R               /* DRUN Mode Configuration Register */
#define MC_ME_RUN0_MC        MC_ME.RUN0_MC.R               /* RUN0 Mode Configuration Register */
#define MC_ME_RUN1_MC        MC_ME.RUN1_MC.R               /* RUN1 Mode Configuration Register */
#define MC_ME_RUN2_MC        MC_ME.RUN2_MC.R               /* RUN2 Mode Configuration Register */
#define MC_ME_RUN3_MC        MC_ME.RUN3_MC.R               /* RUN3 Mode Configuration Register */
#define MC_ME_HALT0_MC       MC_ME.HALT0_MC.R              /* HALT0 Mode Configuration Register */
#define MC_ME_STOP0_MC       MC_ME.STOP0_MC.R              /* STOP0 Mode Configuration Register */
#define MC_ME_PS0            MC_ME.PS0.R                   /* Peripheral Status Register 0 */
#define MC_ME_PS1            MC_ME.PS1.R                   /* Peripheral Status Register 1 */
#define MC_ME_PS2            MC_ME.PS2.R                   /* Peripheral Status Register 2 */
#define MC_ME_PS3            MC_ME.PS3.R                   /* Peripheral Status Register 3 */
#define MC_ME_PS4            MC_ME.PS4.R                   /* Peripheral Status Register 4 */
#define MC_ME_PS5            MC_ME.PS5.R                   /* Peripheral Status Register 5 */
#define MC_ME_PS6            MC_ME.PS6.R                   /* Peripheral Status Register 6 */
#define MC_ME_PS7            MC_ME.PS7.R                   /* Peripheral Status Register 7 */
#define MC_ME_RUN_PC0        MC_ME.RUN_PC[0].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC1        MC_ME.RUN_PC[1].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC2        MC_ME.RUN_PC[2].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC3        MC_ME.RUN_PC[3].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC4        MC_ME.RUN_PC[4].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC5        MC_ME.RUN_PC[5].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC6        MC_ME.RUN_PC[6].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC7        MC_ME.RUN_PC[7].R             /* Run Peripheral Configuration Register */
#define MC_ME_LP_PC0         MC_ME.LP_PC[0].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC1         MC_ME.LP_PC[1].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC2         MC_ME.LP_PC[2].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC3         MC_ME.LP_PC[3].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC4         MC_ME.LP_PC[4].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC5         MC_ME.LP_PC[5].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC6         MC_ME.LP_PC[6].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC7         MC_ME.LP_PC[7].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_PCTL9          MC_ME.PCTL9.R                 /* LFAST_0 Peripheral Control Register */
#define MC_ME_PCTL11         MC_ME.PCTL11.R                /* SIPI_0 Peripheral Control Register */
#define MC_ME_PCTL12         MC_ME.PCTL12.R                /* ENET_0 Peripheral Control Register */
#define MC_ME_PCTL30         MC_ME.PCTL30.R                /* PIT_0 Peripheral Control Register */
#define MC_ME_PCTL36         MC_ME.PCTL36.R                /* DMAMUX_0 Peripheral Control Register */
#define MC_ME_PCTL38         MC_ME.PCTL38.R                /* CRC_0 Peripheral Control Register */
#define MC_ME_PCTL77         MC_ME.PCTL77.R                /* CAN_2 Peripheral Control Register */
#define MC_ME_PCTL78         MC_ME.PCTL78.R                /* CAN_1 Peripheral Control Register */
#define MC_ME_PCTL79         MC_ME.PCTL79.R                /* CAN_0 Peripheral Control Register */
#define MC_ME_PCTL91         MC_ME.PCTL91.R                /* LINFlex_1 Peripheral Control Register */
#define MC_ME_PCTL98         MC_ME.PCTL98.R                /* DSPI_1 Peripheral Control Register */
#define MC_ME_PCTL99         MC_ME.PCTL99.R                /* DSPI_0 Peripheral Control Register */
#define MC_ME_PCTL104        MC_ME.PCTL104.R               /* SENT_0 Peripheral Control Register */
#define MC_ME_PCTL107        MC_ME.PCTL107.R               /* FLEXRAY Peripheral Control Register */
#define MC_ME_PCTL124        MC_ME.PCTL124.R               /* ADC_3 Peripheral Control Register */
#define MC_ME_PCTL126        MC_ME.PCTL126.R               /* ADC_1 Peripheral Control Register */
#define MC_ME_PCTL137        MC_ME.PCTL137.R               /* ETIMER_1 Peripheral Control Register */
#define MC_ME_PCTL141        MC_ME.PCTL141.R               /* CTU_1 Peripheral Control Register */
#define MC_ME_PCTL144        MC_ME.PCTL144.R               /* PWM_1 Peripheral Control Register */
#define MC_ME_PCTL146        MC_ME.PCTL146.R               /* DMAMUX_1 Peripheral Control Register */
#define MC_ME_PCTL204        MC_ME.PCTL204.R               /* LINFlex_0 Peripheral Control Register */
#define MC_ME_PCTL208        MC_ME.PCTL208.R               /* DSPI_3 Peripheral Control Register */
#define MC_ME_PCTL209        MC_ME.PCTL209.R               /* DSPI_2 Peripheral Control Register */
#define MC_ME_PCTL214        MC_ME.PCTL214.R               /* SENT_1 Peripheral Control Register */
#define MC_ME_PCTL235        MC_ME.PCTL235.R               /* ADC_2 Peripheral Control Register */
#define MC_ME_PCTL237        MC_ME.PCTL237.R               /* ADC_0 Peripheral Control Register */
#define MC_ME_PCTL239        MC_ME.PCTL239.R               /* SGEN_0 Peripheral Control Register */
#define MC_ME_PCTL245        MC_ME.PCTL245.R               /* ETIMER_2 Peripheral Control Register */
#define MC_ME_PCTL247        MC_ME.PCTL247.R               /* ETIMER_0 Peripheral Control Register */
#define MC_ME_PCTL251        MC_ME.PCTL251.R               /* CTU_0 Peripheral Control Register */
#define MC_ME_PCTL255        MC_ME.PCTL255.R               /* PWM_0 Peripheral Control Register */
#define MC_ME_CS             MC_ME.CS.R                    /* Core Status Register */
#define MC_ME_CCTL0          MC_ME.CCTL0.R                 /* Core Control Register */
#define MC_ME_CADDR0         MC_ME.CADDR0.R                /* CORE0 Address Register */

/* MC_PCU */
#define MC_PCU_PCONF0        MC_PCU.PCONF0.R               /* Power Domain #0 Configuration Register */
#define MC_PCU_PSTAT         MC_PCU.PSTAT.R                /* Power Domain Status Register */

/* MC_RGM */
#define MC_RGM_DES           MC_RGM.DES.R                  /* 'Destructive' Event Status Register */
#define MC_RGM_DERD          MC_RGM.DERD.R                 /* 'Destructive' Event Reset Disable Register */
#define MC_RGM_DBRE          MC_RGM.DBRE.R                 /* Destructive' Bidirectional Reset Enable Register */
#define MC_RGM_FES           MC_RGM.FES.R                  /* 'Functional' Event Status Register */
#define MC_RGM_FERD          MC_RGM.FERD.R                 /* 'Functional' Event Reset Disable Register */
#define MC_RGM_FEAR          MC_RGM.FEAR.R                 /* 'Functional' Event Alternate Request Register */
#define MC_RGM_FBRE          MC_RGM.FBRE.R                 /* 'Functional' Bidirectional Reset Enable Register */
#define MC_RGM_FESS          MC_RGM.FESS.R                 /* 'Functional' Event Short Sequence Register */
#define MC_RGM_FRET          MC_RGM.FRET.R                 /* 'Functional' Reset Escalation Threshold Register */
#define MC_RGM_DRET          MC_RGM.DRET.R                 /* 'Destructive' Reset Escalation Threshold Register */

/* MEMU */
#define MEMU_CTRL            MEMU.CTRL.R                   /* Control register */
#define MEMU_ERR_FLAG        MEMU.ERR_FLAG.R               /* Error flag register */
#define MEMU_DEBUG           MEMU.DEBUG.R                  /* Debug register */
#define MEMU_SYS_RAM_CERR_STS0 MEMU.SYS_RAM_CERR[0].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR0 MEMU.SYS_RAM_CERR[0].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS1 MEMU.SYS_RAM_CERR[1].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR1 MEMU.SYS_RAM_CERR[1].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS2 MEMU.SYS_RAM_CERR[2].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR2 MEMU.SYS_RAM_CERR[2].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS3 MEMU.SYS_RAM_CERR[3].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR3 MEMU.SYS_RAM_CERR[3].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS4 MEMU.SYS_RAM_CERR[4].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR4 MEMU.SYS_RAM_CERR[4].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS5 MEMU.SYS_RAM_CERR[5].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR5 MEMU.SYS_RAM_CERR[5].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS6 MEMU.SYS_RAM_CERR[6].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR6 MEMU.SYS_RAM_CERR[6].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS7 MEMU.SYS_RAM_CERR[7].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR7 MEMU.SYS_RAM_CERR[7].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS8 MEMU.SYS_RAM_CERR[8].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR8 MEMU.SYS_RAM_CERR[8].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_CERR_STS9 MEMU.SYS_RAM_CERR[9].STS.R  /* System RAM correctable error reporting table status register */
#define MEMU_SYS_RAM_CERR_ADDR9 MEMU.SYS_RAM_CERR[9].ADDR.R /* System RAM correctable error reporting table address register */
#define MEMU_SYS_RAM_UNCERR_STS MEMU.SYS_RAM_UNCERR_STS.R  /* System RAM uncorrectable error reporting table status register */
#define MEMU_SYS_RAM_UNCERR_ADDR MEMU.SYS_RAM_UNCERR_ADDR.R /* System RAM uncorrectable error reporting table address register */
#define MEMU_SYS_RAM_OFLW0   MEMU.SYS_RAM_OFLW[0].R        /* System RAM concurrent overflow register */
#define MEMU_SYS_RAM_OFLW1   MEMU.SYS_RAM_OFLW[1].R        /* System RAM concurrent overflow register */
#define MEMU_SYS_RAM_OFLW2   MEMU.SYS_RAM_OFLW[2].R        /* System RAM concurrent overflow register */
#define MEMU_PERIPH_RAM_CERR_STS0 MEMU.PERIPH_RAM_CERR[0].STS.R /* Peripheral RAM correctable error reporting table status register */
#define MEMU_PERIPH_RAM_CERR_ADDR0 MEMU.PERIPH_RAM_CERR[0].ADDR.R /* Peripheral RAM correctable error reporting table address register */
#define MEMU_PERIPH_RAM_CERR_STS1 MEMU.PERIPH_RAM_CERR[1].STS.R /* Peripheral RAM correctable error reporting table status register */
#define MEMU_PERIPH_RAM_CERR_ADDR1 MEMU.PERIPH_RAM_CERR[1].ADDR.R /* Peripheral RAM correctable error reporting table address register */
#define MEMU_PERIPH_RAM_UNCERR_STS MEMU.PERIPH_RAM_UNCERR_STS.R /* Peripheral RAM uncorrectable error reporting table status register */
#define MEMU_PERIPH_RAM_UNCERR_ADDR MEMU.PERIPH_RAM_UNCERR_ADDR.R /* Peripheral RAM uncorrectable error reporting table address register */
#define MEMU_PERIPH_RAM_OFLW0 MEMU.PERIPH_RAM_OFLW0.R      /* Peripheral RAM concurrent overflow register */
#define MEMU_FLASH_CERR_STS0 MEMU.FLASH_CERR[0].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR0 MEMU.FLASH_CERR[0].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS1 MEMU.FLASH_CERR[1].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR1 MEMU.FLASH_CERR[1].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS2 MEMU.FLASH_CERR[2].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR2 MEMU.FLASH_CERR[2].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS3 MEMU.FLASH_CERR[3].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR3 MEMU.FLASH_CERR[3].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS4 MEMU.FLASH_CERR[4].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR4 MEMU.FLASH_CERR[4].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS5 MEMU.FLASH_CERR[5].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR5 MEMU.FLASH_CERR[5].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS6 MEMU.FLASH_CERR[6].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR6 MEMU.FLASH_CERR[6].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS7 MEMU.FLASH_CERR[7].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR7 MEMU.FLASH_CERR[7].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS8 MEMU.FLASH_CERR[8].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR8 MEMU.FLASH_CERR[8].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS9 MEMU.FLASH_CERR[9].STS.R      /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR9 MEMU.FLASH_CERR[9].ADDR.R    /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS10 MEMU.FLASH_CERR[10].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR10 MEMU.FLASH_CERR[10].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS11 MEMU.FLASH_CERR[11].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR11 MEMU.FLASH_CERR[11].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS12 MEMU.FLASH_CERR[12].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR12 MEMU.FLASH_CERR[12].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS13 MEMU.FLASH_CERR[13].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR13 MEMU.FLASH_CERR[13].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS14 MEMU.FLASH_CERR[14].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR14 MEMU.FLASH_CERR[14].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS15 MEMU.FLASH_CERR[15].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR15 MEMU.FLASH_CERR[15].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS16 MEMU.FLASH_CERR[16].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR16 MEMU.FLASH_CERR[16].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS17 MEMU.FLASH_CERR[17].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR17 MEMU.FLASH_CERR[17].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS18 MEMU.FLASH_CERR[18].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR18 MEMU.FLASH_CERR[18].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_CERR_STS19 MEMU.FLASH_CERR[19].STS.R    /* Flash memory correctable error reporting table status register */
#define MEMU_FLASH_CERR_ADDR19 MEMU.FLASH_CERR[19].ADDR.R  /* Flash memory correctable error reporting table address register */
#define MEMU_FLASH_UNCERR_STS MEMU.FLASH_UNCERR_STS.R      /* Flash memory uncorrectable error reporting table status register */
#define MEMU_FLASH_UNCERR_ADDR MEMU.FLASH_UNCERR_ADDR.R    /* Flash memory uncorrectable error reporting table address register */
#define MEMU_FLASH_OFLW0     MEMU.FLASH_OFLW0.R            /* Flash memory concurrent overflow register */

/* PCM */
#define PCM_IAHB_BE1         PCM.IAHB_BE1.R                /* Bus Bridge Configuration Register 1 */
#define PCM_IAHB_BE2         PCM.IAHB_BE2.R                /* Bus Bridge Configuration Register 2 */
#define PCM_IAHB_BE3         PCM.IAHB_BE3.R                /* Bus Bridge Configuration Register 3 */

/* PFLASH */
#define PFLASH_PFCR1         PFLASH.PFCR1.R                /* Platform Flash Configuration Register 1 */
#define PFLASH_PFCR3         PFLASH.PFCR3.R                /* Platform Flash Configuration Register 3 */
#define PFLASH_PFAPR         PFLASH.PFAPR.R                /* Platform Flash Access Protection Register */
#define PFLASH_PFCRCR        PFLASH.PFCRCR.R               /* Platform Flash Remap Control Register */
#define PFLASH_PFCRDE        PFLASH.PFCRDE.R               /* Platform Flash Remap Descriptor Enable Register */
#define PFLASH_PFCRD0_Word0  PFLASH.PFCRD[0].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD0_Word1  PFLASH.PFCRD[0].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD0_Word2  PFLASH.PFCRD[0].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD1_Word0  PFLASH.PFCRD[1].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD1_Word1  PFLASH.PFCRD[1].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD1_Word2  PFLASH.PFCRD[1].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD2_Word0  PFLASH.PFCRD[2].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD2_Word1  PFLASH.PFCRD[2].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD2_Word2  PFLASH.PFCRD[2].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD3_Word0  PFLASH.PFCRD[3].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD3_Word1  PFLASH.PFCRD[3].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD3_Word2  PFLASH.PFCRD[3].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD4_Word0  PFLASH.PFCRD[4].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD4_Word1  PFLASH.PFCRD[4].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD4_Word2  PFLASH.PFCRD[4].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD5_Word0  PFLASH.PFCRD[5].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD5_Word1  PFLASH.PFCRD[5].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD5_Word2  PFLASH.PFCRD[5].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD6_Word0  PFLASH.PFCRD[6].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD6_Word1  PFLASH.PFCRD[6].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD6_Word2  PFLASH.PFCRD[6].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */
#define PFLASH_PFCRD7_Word0  PFLASH.PFCRD[7].Word0.R       /* Platform Flash Calibration Region Descriptor n Word0 */
#define PFLASH_PFCRD7_Word1  PFLASH.PFCRD[7].Word1.R       /* Platform Flash Calibration Region Descriptor n Word1 */
#define PFLASH_PFCRD7_Word2  PFLASH.PFCRD[7].Word2.R       /* Platform Flash Calibration Region Descriptor n Word2 */

/* PIT */
#define PIT_0_MCR            PIT_0.MCR.R                   /* PIT Module Control Register */
#define PIT_0_LTMR64H        PIT_0.LTMR64H.R               /* PIT Upper Lifetime Timer Register */
#define PIT_0_LTMR64L        PIT_0.LTMR64L.R               /* PIT Lower Lifetime Timer Register */
#define PIT_0_LDVAL0         PIT_0.TIMER[0].LDVAL.R        /* Timer Load Value Register */
#define PIT_0_CVAL0          PIT_0.TIMER[0].CVAL.R         /* Current Timer Value Register */
#define PIT_0_TCTRL0         PIT_0.TIMER[0].TCTRL.R        /* Timer Control Register */
#define PIT_0_TFLG0          PIT_0.TIMER[0].TFLG.R         /* Timer Flag Register */
#define PIT_0_LDVAL1         PIT_0.TIMER[1].LDVAL.R        /* Timer Load Value Register */
#define PIT_0_CVAL1          PIT_0.TIMER[1].CVAL.R         /* Current Timer Value Register */
#define PIT_0_TCTRL1         PIT_0.TIMER[1].TCTRL.R        /* Timer Control Register */
#define PIT_0_TFLG1          PIT_0.TIMER[1].TFLG.R         /* Timer Flag Register */
#define PIT_0_LDVAL2         PIT_0.TIMER[2].LDVAL.R        /* Timer Load Value Register */
#define PIT_0_CVAL2          PIT_0.TIMER[2].CVAL.R         /* Current Timer Value Register */
#define PIT_0_TCTRL2         PIT_0.TIMER[2].TCTRL.R        /* Timer Control Register */
#define PIT_0_TFLG2          PIT_0.TIMER[2].TFLG.R         /* Timer Flag Register */
#define PIT_0_LDVAL3         PIT_0.TIMER[3].LDVAL.R        /* Timer Load Value Register */
#define PIT_0_CVAL3          PIT_0.TIMER[3].CVAL.R         /* Current Timer Value Register */
#define PIT_0_TCTRL3         PIT_0.TIMER[3].TCTRL.R        /* Timer Control Register */
#define PIT_0_TFLG3          PIT_0.TIMER[3].TFLG.R         /* Timer Flag Register */

/* PLLDIG */
#define PLLDIG_PLL0CR        PLLDIG.PLL0CR.R               /* PLLDIG PLL0 Control Register */
#define PLLDIG_PLL0SR        PLLDIG.PLL0SR.R               /* PLLDIG PLL0 Status Register */
#define PLLDIG_PLL0DV        PLLDIG.PLL0DV.R               /* PLLDIG PLL0 Divider Register */
#define PLLDIG_PLL1CR        PLLDIG.PLL1CR.R               /* PLLDIG PLL1 Control Register */
#define PLLDIG_PLL1SR        PLLDIG.PLL1SR.R               /* PLLDIG PLL1 Status Register */
#define PLLDIG_PLL1DV        PLLDIG.PLL1DV.R               /* PLLDIG PLL1 Divider Register */
#define PLLDIG_PLL1FM        PLLDIG.PLL1FM.R               /* PLLDIG PLL1 Frequency Modulation Register */
#define PLLDIG_PLL1FD        PLLDIG.PLL1FD.R               /* PLLDIG PLL1 Fractional Divide Register */

/* PMC */
#define PMC_PMCSR            PMC.PMCSR.R                   /* PMC Status Register */
#define PMC_RSSR             PMC.RSSR.R                    /* Regulator Voltage Status Register */
#define PMC_PMCCR            PMC.PMCCR.R                   /* PMC Control Register */
#define PMC_IER              PMC.IER.R                     /* Interrupt Enable Register */
#define PMC_ESR_0            PMC.ESR_0.R                   /* Event Status Register 0 */
#define PMC_REE_0            PMC.REE_0.R                   /* Reset Event Enable 0 */
#define PMC_RES_0            PMC.RES_0.R                   /* Reset Event Selection 0 */
#define PMC_FIR              PMC.FIR.R                     /* FCCU Fault Injection Register */
#define PMC_ESR_TD           PMC.ESR_TD.R                  /* Temperature Event Status register */
#define PMC_REE_TD           PMC.REE_TD.R                  /* Temperature Reset Event Enable register */
#define PMC_RES_TD           PMC.RES_TD.R                  /* Temperature Reset Event Selection register */
#define PMC_CTL_TD           PMC.CTL_TD.R                  /* Temperature detector configuration register */
#define PMC_STTW             PMC.STTW.R                    /* LVD Self Test Time Window Register */
#define PMC_VD_UTST          PMC.VD_UTST.R                 /* Voltage Detect User Mode Test Register */

/* PRAMC */
#define PRAMC_PRCR1          PRAMC.PRCR1.R                 /* Platform RAM Configuration Register 1 */

/* SGEN */
#define SGEN_0_CTRL          SGEN_0.CTRL.R                 /* Control Register */
#define SGEN_0_STAT          SGEN_0.STAT.R                 /* Status Register */

/* SIPI */
#define SIPI_0_CCR0          SIPI_0.CCR0.R                 /* SIPI Channel Control Register 0 */
#define SIPI_0_CSR0          SIPI_0.CSR0.R                 /* SIPI Channel Status Register 0 */
#define SIPI_0_CIR0          SIPI_0.CIR0.R                 /* SIPI Channel Interrupt Register 0 */
#define SIPI_0_CTOR0         SIPI_0.CTOR0.R                /* SIPI Channel Timeout Register 0 */
#define SIPI_0_CCRC0         SIPI_0.CCRC0.R                /* SIPI Channel CRC Register 0 */
#define SIPI_0_CAR0          SIPI_0.CAR0.R                 /* SIPI Channel Address Register 0 */
#define SIPI_0_CDR0          SIPI_0.CDR0.R                 /* SIPI Channel Data Register 0 */
#define SIPI_0_CCR1          SIPI_0.CCR1.R                 /* SIPI Channel Control Register 1 */
#define SIPI_0_CSR1          SIPI_0.CSR1.R                 /* SIPI Channel Status Register 1 */
#define SIPI_0_CIR1          SIPI_0.CIR1.R                 /* SIPI Channel Interrupt Register 1 */
#define SIPI_0_CTOR1         SIPI_0.CTOR1.R                /* SIPI Channel Timeout Register 1 */
#define SIPI_0_CCRC1         SIPI_0.CCRC1.R                /* SIPI Channel CRC Register 1 */
#define SIPI_0_CAR1          SIPI_0.CAR1.R                 /* SIPI Channel Address Register 1 */
#define SIPI_0_CDR1          SIPI_0.CDR1.R                 /* SIPI Channel Data Register 1 */
#define SIPI_0_CCR2          SIPI_0.CCR2.R                 /* SIPI Channel Control Register 2 */
#define SIPI_0_CSR2          SIPI_0.CSR2.R                 /* SIPI Channel Status Register 2 */
#define SIPI_0_CIR2          SIPI_0.CIR2.R                 /* SIPI Channel Interrupt Register 2 */
#define SIPI_0_CTOR2         SIPI_0.CTOR2.R                /* SIPI Channel Timeout Register 2 */
#define SIPI_0_CCRC2         SIPI_0.CCRC2.R                /* SIPI Channel CRC Register 2 */
#define SIPI_0_CAR2          SIPI_0.CAR2.R                 /* SIPI Channel Address Register 2 */
#define SIPI_0_CDR2_0        SIPI_0.CDR2_[0].R             /* SIPI Channel Data Register 2 */
#define SIPI_0_CDR2_1        SIPI_0.CDR2_[1].R             /* SIPI Channel Data Register 2 */
#define SIPI_0_CDR2_2        SIPI_0.CDR2_[2].R             /* SIPI Channel Data Register 2 */
#define SIPI_0_CDR2_3        SIPI_0.CDR2_[3].R             /* SIPI Channel Data Register 2 */
#define SIPI_0_CDR2_4        SIPI_0.CDR2_[4].R             /* SIPI Channel Data Register 2 */
#define SIPI_0_CDR2_5        SIPI_0.CDR2_[5].R             /* SIPI Channel Data Register 2 */
#define SIPI_0_CDR2_6        SIPI_0.CDR2_[6].R             /* SIPI Channel Data Register 2 */
#define SIPI_0_CDR2_7        SIPI_0.CDR2_[7].R             /* SIPI Channel Data Register 2 */
#define SIPI_0_CCR3          SIPI_0.CCR3.R                 /* SIPI Channel Control Register 3 */
#define SIPI_0_CSR3          SIPI_0.CSR3.R                 /* SIPI Channel Status Register 3 */
#define SIPI_0_CIR3          SIPI_0.CIR3.R                 /* SIPI Channel Interrupt Register 3 */
#define SIPI_0_CTOR3         SIPI_0.CTOR3.R                /* SIPI Channel Timeout Register 3 */
#define SIPI_0_CCRC3         SIPI_0.CCRC3.R                /* SIPI Channel CRC Register 3 */
#define SIPI_0_CAR3          SIPI_0.CAR3.R                 /* SIPI Channel Address Register 3 */
#define SIPI_0_CDR3          SIPI_0.CDR3.R                 /* SIPI Channel Data Register 3 */
#define SIPI_0_MCR           SIPI_0.MCR.R                  /* SIPI Module Configuration Register */
#define SIPI_0_SR            SIPI_0.SR.R                   /* SIPI Status Register */
#define SIPI_0_MAXCR         SIPI_0.MAXCR.R                /* SIPI Max Count Register */
#define SIPI_0_ARR           SIPI_0.ARR.R                  /* SIPI Address Reload Register */
#define SIPI_0_ACR           SIPI_0.ACR.R                  /* SIPI Address Count Register */
#define SIPI_0_ERR           SIPI_0.ERR.R                  /* SIPI Error Register */

/* SIUL2 */
#define SIUL2_MIDR1          SIUL2.MIDR1.R                 /* SIUL2 MCU ID Register #1 */
#define SIUL2_MIDR2          SIUL2.MIDR2.R                 /* SIUL2 MCU ID Register #2 */
#define SIUL2_DISR0          SIUL2.DISR0.R                 /* SIUL2 DMA/Interrupt Status Flag Register0 */
#define SIUL2_DIRER0         SIUL2.DIRER0.R                /* SIUL2 DMA/Interrupt Request Enable Register0 */
#define SIUL2_DIRSR0         SIUL2.DIRSR0.R                /* SIUL2 DMA/Interrupt Request Select Register0 */
#define SIUL2_IREER0         SIUL2.IREER0.R                /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
#define SIUL2_IFEER0         SIUL2.IFEER0.R                /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
#define SIUL2_IFER0          SIUL2.IFER0.R                 /* SIUL2 Interrupt Filter Enable Register 0 */
#define SIUL2_IFMCR0         SIUL2.IFMCR[0].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR1         SIUL2.IFMCR[1].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR2         SIUL2.IFMCR[2].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR3         SIUL2.IFMCR[3].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR4         SIUL2.IFMCR[4].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR5         SIUL2.IFMCR[5].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR6         SIUL2.IFMCR[6].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR7         SIUL2.IFMCR[7].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR8         SIUL2.IFMCR[8].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR9         SIUL2.IFMCR[9].R              /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR10        SIUL2.IFMCR[10].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR11        SIUL2.IFMCR[11].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR12        SIUL2.IFMCR[12].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR13        SIUL2.IFMCR[13].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR14        SIUL2.IFMCR[14].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR15        SIUL2.IFMCR[15].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR16        SIUL2.IFMCR[16].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR17        SIUL2.IFMCR[17].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR18        SIUL2.IFMCR[18].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR19        SIUL2.IFMCR[19].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR20        SIUL2.IFMCR[20].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR21        SIUL2.IFMCR[21].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR22        SIUL2.IFMCR[22].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR23        SIUL2.IFMCR[23].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR24        SIUL2.IFMCR[24].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR25        SIUL2.IFMCR[25].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR26        SIUL2.IFMCR[26].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR27        SIUL2.IFMCR[27].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR28        SIUL2.IFMCR[28].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR29        SIUL2.IFMCR[29].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR30        SIUL2.IFMCR[30].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFMCR31        SIUL2.IFMCR[31].R             /* SIUL2 Interrupt Filter Maximum Counter Register */
#define SIUL2_IFCPR          SIUL2.IFCPR.R                 /* SIUL2 Interrupt Filter Clock Prescaler Register */
#define SIUL2_MSCR0          SIUL2.MSCR[0].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR1          SIUL2.MSCR[1].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR2          SIUL2.MSCR[2].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR3          SIUL2.MSCR[3].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR4          SIUL2.MSCR[4].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR5          SIUL2.MSCR[5].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR6          SIUL2.MSCR[6].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR7          SIUL2.MSCR[7].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR8          SIUL2.MSCR[8].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR9          SIUL2.MSCR[9].R               /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR10         SIUL2.MSCR[10].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR11         SIUL2.MSCR[11].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR12         SIUL2.MSCR[12].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR13         SIUL2.MSCR[13].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR14         SIUL2.MSCR[14].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR15         SIUL2.MSCR[15].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR16         SIUL2.MSCR[16].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR17         SIUL2.MSCR[17].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR18         SIUL2.MSCR[18].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR19         SIUL2.MSCR[19].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR20         SIUL2.MSCR[20].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR21         SIUL2.MSCR[21].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR22         SIUL2.MSCR[22].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR23         SIUL2.MSCR[23].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR24         SIUL2.MSCR[24].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR25         SIUL2.MSCR[25].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR26         SIUL2.MSCR[26].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR27         SIUL2.MSCR[27].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR28         SIUL2.MSCR[28].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR29         SIUL2.MSCR[29].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR30         SIUL2.MSCR[30].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR31         SIUL2.MSCR[31].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR32         SIUL2.MSCR[32].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR33         SIUL2.MSCR[33].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR34         SIUL2.MSCR[34].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR35         SIUL2.MSCR[35].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR36         SIUL2.MSCR[36].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR37         SIUL2.MSCR[37].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR38         SIUL2.MSCR[38].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR39         SIUL2.MSCR[39].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR40         SIUL2.MSCR[40].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR41         SIUL2.MSCR[41].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR42         SIUL2.MSCR[42].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR43         SIUL2.MSCR[43].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR44         SIUL2.MSCR[44].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR45         SIUL2.MSCR[45].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR46         SIUL2.MSCR[46].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR47         SIUL2.MSCR[47].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR48         SIUL2.MSCR[48].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR49         SIUL2.MSCR[49].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR50         SIUL2.MSCR[50].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR51         SIUL2.MSCR[51].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR52         SIUL2.MSCR[52].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR53         SIUL2.MSCR[53].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR54         SIUL2.MSCR[54].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR55         SIUL2.MSCR[55].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR56         SIUL2.MSCR[56].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR57         SIUL2.MSCR[57].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR58         SIUL2.MSCR[58].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR59         SIUL2.MSCR[59].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR60         SIUL2.MSCR[60].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR61         SIUL2.MSCR[61].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR62         SIUL2.MSCR[62].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR63         SIUL2.MSCR[63].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR64         SIUL2.MSCR[64].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR65         SIUL2.MSCR[65].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR66         SIUL2.MSCR[66].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR67         SIUL2.MSCR[67].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR68         SIUL2.MSCR[68].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR69         SIUL2.MSCR[69].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR70         SIUL2.MSCR[70].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR71         SIUL2.MSCR[71].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR72         SIUL2.MSCR[72].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR73         SIUL2.MSCR[73].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR74         SIUL2.MSCR[74].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR75         SIUL2.MSCR[75].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR76         SIUL2.MSCR[76].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR77         SIUL2.MSCR[77].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR78         SIUL2.MSCR[78].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR79         SIUL2.MSCR[79].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR80         SIUL2.MSCR[80].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR81         SIUL2.MSCR[81].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR82         SIUL2.MSCR[82].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR83         SIUL2.MSCR[83].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR84         SIUL2.MSCR[84].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR85         SIUL2.MSCR[85].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR86         SIUL2.MSCR[86].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR87         SIUL2.MSCR[87].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR88         SIUL2.MSCR[88].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR89         SIUL2.MSCR[89].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR90         SIUL2.MSCR[90].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR91         SIUL2.MSCR[91].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR92         SIUL2.MSCR[92].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR93         SIUL2.MSCR[93].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR94         SIUL2.MSCR[94].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR95         SIUL2.MSCR[95].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR96         SIUL2.MSCR[96].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR97         SIUL2.MSCR[97].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR98         SIUL2.MSCR[98].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR99         SIUL2.MSCR[99].R              /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR100        SIUL2.MSCR[100].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR101        SIUL2.MSCR[101].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR102        SIUL2.MSCR[102].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR103        SIUL2.MSCR[103].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR104        SIUL2.MSCR[104].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR105        SIUL2.MSCR[105].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR106        SIUL2.MSCR[106].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR107        SIUL2.MSCR[107].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR108        SIUL2.MSCR[108].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR109        SIUL2.MSCR[109].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR110        SIUL2.MSCR[110].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR111        SIUL2.MSCR[111].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR112        SIUL2.MSCR[112].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR113        SIUL2.MSCR[113].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR114        SIUL2.MSCR[114].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR115        SIUL2.MSCR[115].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR116        SIUL2.MSCR[116].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR117        SIUL2.MSCR[117].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR118        SIUL2.MSCR[118].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR119        SIUL2.MSCR[119].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR120        SIUL2.MSCR[120].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR121        SIUL2.MSCR[121].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR122        SIUL2.MSCR[122].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR123        SIUL2.MSCR[123].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR124        SIUL2.MSCR[124].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR125        SIUL2.MSCR[125].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR126        SIUL2.MSCR[126].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR127        SIUL2.MSCR[127].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR128        SIUL2.MSCR[128].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR129        SIUL2.MSCR[129].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR130        SIUL2.MSCR[130].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR131        SIUL2.MSCR[131].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR132        SIUL2.MSCR[132].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR133        SIUL2.MSCR[133].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR134        SIUL2.MSCR[134].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR135        SIUL2.MSCR[135].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR136        SIUL2.MSCR[136].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR137        SIUL2.MSCR[137].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR138        SIUL2.MSCR[138].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR139        SIUL2.MSCR[139].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR140        SIUL2.MSCR[140].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR141        SIUL2.MSCR[141].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR142        SIUL2.MSCR[142].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR143        SIUL2.MSCR[143].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR144        SIUL2.MSCR[144].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR145        SIUL2.MSCR[145].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR146        SIUL2.MSCR[146].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR147        SIUL2.MSCR[147].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR148        SIUL2.MSCR[148].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR149        SIUL2.MSCR[149].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR150        SIUL2.MSCR[150].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR151        SIUL2.MSCR[151].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR152        SIUL2.MSCR[152].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR153        SIUL2.MSCR[153].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_MSCR154        SIUL2.MSCR[154].R             /* SIUL2 Multiplexed Signal Configuration Register */
#define SIUL2_IMCR0          SIUL2.IMCR[0].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR1          SIUL2.IMCR[1].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR2          SIUL2.IMCR[2].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR3          SIUL2.IMCR[3].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR4          SIUL2.IMCR[4].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR5          SIUL2.IMCR[5].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR6          SIUL2.IMCR[6].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR7          SIUL2.IMCR[7].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR8          SIUL2.IMCR[8].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR9          SIUL2.IMCR[9].R               /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR10         SIUL2.IMCR[10].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR11         SIUL2.IMCR[11].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR12         SIUL2.IMCR[12].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR13         SIUL2.IMCR[13].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR14         SIUL2.IMCR[14].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR15         SIUL2.IMCR[15].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR16         SIUL2.IMCR[16].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR17         SIUL2.IMCR[17].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR18         SIUL2.IMCR[18].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR19         SIUL2.IMCR[19].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR20         SIUL2.IMCR[20].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR21         SIUL2.IMCR[21].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR22         SIUL2.IMCR[22].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR23         SIUL2.IMCR[23].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR24         SIUL2.IMCR[24].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR25         SIUL2.IMCR[25].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR26         SIUL2.IMCR[26].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR27         SIUL2.IMCR[27].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR28         SIUL2.IMCR[28].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR29         SIUL2.IMCR[29].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR30         SIUL2.IMCR[30].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR31         SIUL2.IMCR[31].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR32         SIUL2.IMCR[32].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR33         SIUL2.IMCR[33].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR34         SIUL2.IMCR[34].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR35         SIUL2.IMCR[35].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR36         SIUL2.IMCR[36].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR37         SIUL2.IMCR[37].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR38         SIUL2.IMCR[38].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR39         SIUL2.IMCR[39].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR40         SIUL2.IMCR[40].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR41         SIUL2.IMCR[41].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR42         SIUL2.IMCR[42].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR43         SIUL2.IMCR[43].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR44         SIUL2.IMCR[44].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR45         SIUL2.IMCR[45].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR46         SIUL2.IMCR[46].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR47         SIUL2.IMCR[47].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR48         SIUL2.IMCR[48].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR49         SIUL2.IMCR[49].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR50         SIUL2.IMCR[50].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR51         SIUL2.IMCR[51].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR52         SIUL2.IMCR[52].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR53         SIUL2.IMCR[53].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR54         SIUL2.IMCR[54].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR55         SIUL2.IMCR[55].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR56         SIUL2.IMCR[56].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR57         SIUL2.IMCR[57].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR58         SIUL2.IMCR[58].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR59         SIUL2.IMCR[59].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR60         SIUL2.IMCR[60].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR61         SIUL2.IMCR[61].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR62         SIUL2.IMCR[62].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR63         SIUL2.IMCR[63].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR64         SIUL2.IMCR[64].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR65         SIUL2.IMCR[65].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR66         SIUL2.IMCR[66].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR67         SIUL2.IMCR[67].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR68         SIUL2.IMCR[68].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR69         SIUL2.IMCR[69].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR70         SIUL2.IMCR[70].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR71         SIUL2.IMCR[71].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR72         SIUL2.IMCR[72].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR73         SIUL2.IMCR[73].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR74         SIUL2.IMCR[74].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR75         SIUL2.IMCR[75].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR76         SIUL2.IMCR[76].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR77         SIUL2.IMCR[77].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR78         SIUL2.IMCR[78].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR79         SIUL2.IMCR[79].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR80         SIUL2.IMCR[80].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR81         SIUL2.IMCR[81].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR82         SIUL2.IMCR[82].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR83         SIUL2.IMCR[83].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR84         SIUL2.IMCR[84].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR85         SIUL2.IMCR[85].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR86         SIUL2.IMCR[86].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR87         SIUL2.IMCR[87].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR88         SIUL2.IMCR[88].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR89         SIUL2.IMCR[89].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR90         SIUL2.IMCR[90].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR91         SIUL2.IMCR[91].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR92         SIUL2.IMCR[92].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR93         SIUL2.IMCR[93].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR94         SIUL2.IMCR[94].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR95         SIUL2.IMCR[95].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR96         SIUL2.IMCR[96].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR97         SIUL2.IMCR[97].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR98         SIUL2.IMCR[98].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR99         SIUL2.IMCR[99].R              /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR100        SIUL2.IMCR[100].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR101        SIUL2.IMCR[101].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR102        SIUL2.IMCR[102].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR103        SIUL2.IMCR[103].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR104        SIUL2.IMCR[104].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR105        SIUL2.IMCR[105].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR106        SIUL2.IMCR[106].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR107        SIUL2.IMCR[107].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR108        SIUL2.IMCR[108].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR109        SIUL2.IMCR[109].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR110        SIUL2.IMCR[110].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR111        SIUL2.IMCR[111].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR112        SIUL2.IMCR[112].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR113        SIUL2.IMCR[113].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR114        SIUL2.IMCR[114].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR115        SIUL2.IMCR[115].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR116        SIUL2.IMCR[116].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR117        SIUL2.IMCR[117].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR118        SIUL2.IMCR[118].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR119        SIUL2.IMCR[119].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR120        SIUL2.IMCR[120].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR121        SIUL2.IMCR[121].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR122        SIUL2.IMCR[122].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR123        SIUL2.IMCR[123].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR124        SIUL2.IMCR[124].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR125        SIUL2.IMCR[125].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR126        SIUL2.IMCR[126].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR127        SIUL2.IMCR[127].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR128        SIUL2.IMCR[128].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR129        SIUL2.IMCR[129].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR130        SIUL2.IMCR[130].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR131        SIUL2.IMCR[131].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR132        SIUL2.IMCR[132].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR133        SIUL2.IMCR[133].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR134        SIUL2.IMCR[134].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR135        SIUL2.IMCR[135].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR136        SIUL2.IMCR[136].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR137        SIUL2.IMCR[137].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR138        SIUL2.IMCR[138].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR139        SIUL2.IMCR[139].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR140        SIUL2.IMCR[140].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR141        SIUL2.IMCR[141].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR142        SIUL2.IMCR[142].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR143        SIUL2.IMCR[143].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR144        SIUL2.IMCR[144].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR145        SIUL2.IMCR[145].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR146        SIUL2.IMCR[146].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR147        SIUL2.IMCR[147].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR148        SIUL2.IMCR[148].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR149        SIUL2.IMCR[149].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR150        SIUL2.IMCR[150].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR151        SIUL2.IMCR[151].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR152        SIUL2.IMCR[152].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR153        SIUL2.IMCR[153].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR154        SIUL2.IMCR[154].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR155        SIUL2.IMCR[155].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR156        SIUL2.IMCR[156].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR157        SIUL2.IMCR[157].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR158        SIUL2.IMCR[158].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR159        SIUL2.IMCR[159].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR160        SIUL2.IMCR[160].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR161        SIUL2.IMCR[161].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR162        SIUL2.IMCR[162].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR163        SIUL2.IMCR[163].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR164        SIUL2.IMCR[164].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR165        SIUL2.IMCR[165].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR166        SIUL2.IMCR[166].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR167        SIUL2.IMCR[167].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR168        SIUL2.IMCR[168].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR169        SIUL2.IMCR[169].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR170        SIUL2.IMCR[170].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR171        SIUL2.IMCR[171].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR172        SIUL2.IMCR[172].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR173        SIUL2.IMCR[173].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR174        SIUL2.IMCR[174].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR175        SIUL2.IMCR[175].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR176        SIUL2.IMCR[176].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR177        SIUL2.IMCR[177].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR178        SIUL2.IMCR[178].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR179        SIUL2.IMCR[179].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR180        SIUL2.IMCR[180].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR181        SIUL2.IMCR[181].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR182        SIUL2.IMCR[182].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR183        SIUL2.IMCR[183].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR184        SIUL2.IMCR[184].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR185        SIUL2.IMCR[185].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR186        SIUL2.IMCR[186].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR187        SIUL2.IMCR[187].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR188        SIUL2.IMCR[188].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR189        SIUL2.IMCR[189].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR190        SIUL2.IMCR[190].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR191        SIUL2.IMCR[191].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR192        SIUL2.IMCR[192].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR193        SIUL2.IMCR[193].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR194        SIUL2.IMCR[194].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR195        SIUL2.IMCR[195].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR196        SIUL2.IMCR[196].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR197        SIUL2.IMCR[197].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR198        SIUL2.IMCR[198].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR199        SIUL2.IMCR[199].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR200        SIUL2.IMCR[200].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR201        SIUL2.IMCR[201].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR202        SIUL2.IMCR[202].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR203        SIUL2.IMCR[203].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR204        SIUL2.IMCR[204].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR205        SIUL2.IMCR[205].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR206        SIUL2.IMCR[206].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR207        SIUL2.IMCR[207].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR208        SIUL2.IMCR[208].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR209        SIUL2.IMCR[209].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR210        SIUL2.IMCR[210].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR211        SIUL2.IMCR[211].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR212        SIUL2.IMCR[212].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR213        SIUL2.IMCR[213].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR214        SIUL2.IMCR[214].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR215        SIUL2.IMCR[215].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR216        SIUL2.IMCR[216].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR217        SIUL2.IMCR[217].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR218        SIUL2.IMCR[218].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR219        SIUL2.IMCR[219].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR220        SIUL2.IMCR[220].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR221        SIUL2.IMCR[221].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR222        SIUL2.IMCR[222].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR223        SIUL2.IMCR[223].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR224        SIUL2.IMCR[224].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR225        SIUL2.IMCR[225].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR226        SIUL2.IMCR[226].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR227        SIUL2.IMCR[227].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR228        SIUL2.IMCR[228].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR229        SIUL2.IMCR[229].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR230        SIUL2.IMCR[230].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR231        SIUL2.IMCR[231].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR232        SIUL2.IMCR[232].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_IMCR233        SIUL2.IMCR[233].R             /* SIUL2 Input Multiplexed Signal Configuration Register */
#define SIUL2_GPDO0_3        SIUL2.GPDO[0].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO4_7        SIUL2.GPDO[1].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO8_11       SIUL2.GPDO[2].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO12_15      SIUL2.GPDO[3].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO16_19      SIUL2.GPDO[4].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO20_23      SIUL2.GPDO[5].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO24_27      SIUL2.GPDO[6].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO28_31      SIUL2.GPDO[7].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO32_35      SIUL2.GPDO[8].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO36_39      SIUL2.GPDO[9].R               /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO40_43      SIUL2.GPDO[10].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO44_47      SIUL2.GPDO[11].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO48_51      SIUL2.GPDO[12].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO52_55      SIUL2.GPDO[13].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO56_59      SIUL2.GPDO[14].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO60_63      SIUL2.GPDO[15].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO64_67      SIUL2.GPDO[16].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO68_71      SIUL2.GPDO[17].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO72_75      SIUL2.GPDO[18].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO76_79      SIUL2.GPDO[19].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO80_83      SIUL2.GPDO[20].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO84_87      SIUL2.GPDO[21].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO88_91      SIUL2.GPDO[22].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO92_95      SIUL2.GPDO[23].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO96_99      SIUL2.GPDO[24].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO100_103    SIUL2.GPDO[25].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO104_107    SIUL2.GPDO[26].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO108_111    SIUL2.GPDO[27].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO112_115    SIUL2.GPDO[28].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO116_119    SIUL2.GPDO[29].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO120_123    SIUL2.GPDO[30].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO124_127    SIUL2.GPDO[31].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO128_131    SIUL2.GPDO[32].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO132_135    SIUL2.GPDO[33].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO136_139    SIUL2.GPDO[34].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO140_143    SIUL2.GPDO[35].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO144_147    SIUL2.GPDO[36].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO148_151    SIUL2.GPDO[37].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDO152_155    SIUL2.GPDO[38].R              /* SIUL2 GPIO Pad Data Output Register */
#define SIUL2_GPDI0_3        SIUL2.GPDI[0].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI4_7        SIUL2.GPDI[1].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI8_11       SIUL2.GPDI[2].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI12_15      SIUL2.GPDI[3].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI16_19      SIUL2.GPDI[4].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI20_23      SIUL2.GPDI[5].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI24_27      SIUL2.GPDI[6].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI28_31      SIUL2.GPDI[7].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI32_35      SIUL2.GPDI[8].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI36_39      SIUL2.GPDI[9].R               /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI40_43      SIUL2.GPDI[10].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI44_47      SIUL2.GPDI[11].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI48_51      SIUL2.GPDI[12].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI52_55      SIUL2.GPDI[13].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI56_59      SIUL2.GPDI[14].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI60_63      SIUL2.GPDI[15].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI64_67      SIUL2.GPDI[16].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI68_71      SIUL2.GPDI[17].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI72_75      SIUL2.GPDI[18].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI76_79      SIUL2.GPDI[19].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI80_83      SIUL2.GPDI[20].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI84_87      SIUL2.GPDI[21].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI88_91      SIUL2.GPDI[22].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI92_95      SIUL2.GPDI[23].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI96_99      SIUL2.GPDI[24].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI100_103    SIUL2.GPDI[25].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI104_107    SIUL2.GPDI[26].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI108_111    SIUL2.GPDI[27].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI112_115    SIUL2.GPDI[28].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI116_119    SIUL2.GPDI[29].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI120_123    SIUL2.GPDI[30].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI124_127    SIUL2.GPDI[31].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI128_131    SIUL2.GPDI[32].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI132_135    SIUL2.GPDI[33].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI136_139    SIUL2.GPDI[34].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI140_143    SIUL2.GPDI[35].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI144_147    SIUL2.GPDI[36].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI148_151    SIUL2.GPDI[37].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_GPDI152_155    SIUL2.GPDI[38].R              /* SIUL2 GPIO Pad Data Input Register */
#define SIUL2_PGPDO0         SIUL2.PGPDO[0].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO1         SIUL2.PGPDO[1].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO2         SIUL2.PGPDO[2].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO3         SIUL2.PGPDO[3].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO4         SIUL2.PGPDO[4].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO5         SIUL2.PGPDO[5].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO6         SIUL2.PGPDO[6].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO7         SIUL2.PGPDO[7].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO8         SIUL2.PGPDO[8].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDO9         SIUL2.PGPDO[9].R              /* SIUL2 Parallel GPIO Pad Data Out Register */
#define SIUL2_PGPDI0         SIUL2.PGPDI[0].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI1         SIUL2.PGPDI[1].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI2         SIUL2.PGPDI[2].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI3         SIUL2.PGPDI[3].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI4         SIUL2.PGPDI[4].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI5         SIUL2.PGPDI[5].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI6         SIUL2.PGPDI[6].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI7         SIUL2.PGPDI[7].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI8         SIUL2.PGPDI[8].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_PGPDI9         SIUL2.PGPDI[9].R              /* SIUL2 Parallel GPIO Pad Data In Register */
#define SIUL2_MPGPDO0        SIUL2.MPGPDO[0].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO1        SIUL2.MPGPDO[1].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO2        SIUL2.MPGPDO[2].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO3        SIUL2.MPGPDO[3].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO4        SIUL2.MPGPDO[4].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO5        SIUL2.MPGPDO[5].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO6        SIUL2.MPGPDO[6].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO7        SIUL2.MPGPDO[7].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO8        SIUL2.MPGPDO[8].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
#define SIUL2_MPGPDO9        SIUL2.MPGPDO[9].R             /* SIUL2 Masked Parallel GPIO Pad Data Out Register */

/* SMPU */
#define SMPU_0_CESR0         SMPU_0.CESR0.R                /* Control/Error Status Register 0 */
#define SMPU_0_CESR1         SMPU_0.CESR1.R                /* Control/Error Status Register 1 */
#define SMPU_0_EAR0          SMPU_0.ERROR[0].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR0          SMPU_0.ERROR[0].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR1          SMPU_0.ERROR[1].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR1          SMPU_0.ERROR[1].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR2          SMPU_0.ERROR[2].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR2          SMPU_0.ERROR[2].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR3          SMPU_0.ERROR[3].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR3          SMPU_0.ERROR[3].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR4          SMPU_0.ERROR[4].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR4          SMPU_0.ERROR[4].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR5          SMPU_0.ERROR[5].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR5          SMPU_0.ERROR[5].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR6          SMPU_0.ERROR[6].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR6          SMPU_0.ERROR[6].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR7          SMPU_0.ERROR[7].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR7          SMPU_0.ERROR[7].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR8          SMPU_0.ERROR[8].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR8          SMPU_0.ERROR[8].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR9          SMPU_0.ERROR[9].EAR.R         /* Error Address Register, Bus Master n */
#define SMPU_0_EDR9          SMPU_0.ERROR[9].EDR.R         /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR10         SMPU_0.ERROR[10].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR10         SMPU_0.ERROR[10].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR11         SMPU_0.ERROR[11].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR11         SMPU_0.ERROR[11].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR12         SMPU_0.ERROR[12].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR12         SMPU_0.ERROR[12].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR13         SMPU_0.ERROR[13].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR13         SMPU_0.ERROR[13].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR14         SMPU_0.ERROR[14].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR14         SMPU_0.ERROR[14].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_EAR15         SMPU_0.ERROR[15].EAR.R        /* Error Address Register, Bus Master n */
#define SMPU_0_EDR15         SMPU_0.ERROR[15].EDR.R        /* Error Detail Register, Bus Master n */
#define SMPU_0_RGD0_WORD0    SMPU_0.RGD[0].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD0_WORD1    SMPU_0.RGD[0].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD0_WORD2    SMPU_0.RGD[0].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD0_WORD3    SMPU_0.RGD[0].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD1_WORD0    SMPU_0.RGD[1].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD1_WORD1    SMPU_0.RGD[1].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD1_WORD2    SMPU_0.RGD[1].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD1_WORD3    SMPU_0.RGD[1].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD2_WORD0    SMPU_0.RGD[2].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD2_WORD1    SMPU_0.RGD[2].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD2_WORD2    SMPU_0.RGD[2].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD2_WORD3    SMPU_0.RGD[2].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD3_WORD0    SMPU_0.RGD[3].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD3_WORD1    SMPU_0.RGD[3].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD3_WORD2    SMPU_0.RGD[3].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD3_WORD3    SMPU_0.RGD[3].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD4_WORD0    SMPU_0.RGD[4].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD4_WORD1    SMPU_0.RGD[4].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD4_WORD2    SMPU_0.RGD[4].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD4_WORD3    SMPU_0.RGD[4].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD5_WORD0    SMPU_0.RGD[5].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD5_WORD1    SMPU_0.RGD[5].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD5_WORD2    SMPU_0.RGD[5].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD5_WORD3    SMPU_0.RGD[5].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD6_WORD0    SMPU_0.RGD[6].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD6_WORD1    SMPU_0.RGD[6].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD6_WORD2    SMPU_0.RGD[6].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD6_WORD3    SMPU_0.RGD[6].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD7_WORD0    SMPU_0.RGD[7].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD7_WORD1    SMPU_0.RGD[7].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD7_WORD2    SMPU_0.RGD[7].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD7_WORD3    SMPU_0.RGD[7].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD8_WORD0    SMPU_0.RGD[8].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD8_WORD1    SMPU_0.RGD[8].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD8_WORD2    SMPU_0.RGD[8].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD8_WORD3    SMPU_0.RGD[8].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD9_WORD0    SMPU_0.RGD[9].WORD0.R         /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD9_WORD1    SMPU_0.RGD[9].WORD1.R         /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD9_WORD2    SMPU_0.RGD[9].WORD2.R         /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD9_WORD3    SMPU_0.RGD[9].WORD3.R         /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD10_WORD0   SMPU_0.RGD[10].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD10_WORD1   SMPU_0.RGD[10].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD10_WORD2   SMPU_0.RGD[10].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD10_WORD3   SMPU_0.RGD[10].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD11_WORD0   SMPU_0.RGD[11].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD11_WORD1   SMPU_0.RGD[11].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD11_WORD2   SMPU_0.RGD[11].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD11_WORD3   SMPU_0.RGD[11].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD12_WORD0   SMPU_0.RGD[12].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD12_WORD1   SMPU_0.RGD[12].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD12_WORD2   SMPU_0.RGD[12].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD12_WORD3   SMPU_0.RGD[12].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD13_WORD0   SMPU_0.RGD[13].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD13_WORD1   SMPU_0.RGD[13].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD13_WORD2   SMPU_0.RGD[13].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD13_WORD3   SMPU_0.RGD[13].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD14_WORD0   SMPU_0.RGD[14].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD14_WORD1   SMPU_0.RGD[14].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD14_WORD2   SMPU_0.RGD[14].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD14_WORD3   SMPU_0.RGD[14].WORD3.R        /* Region Descriptor n, Word 3 */
#define SMPU_0_RGD15_WORD0   SMPU_0.RGD[15].WORD0.R        /* Region Descriptor n, Word 0 */
#define SMPU_0_RGD15_WORD1   SMPU_0.RGD[15].WORD1.R        /* Region Descriptor n, Word 1 */
#define SMPU_0_RGD15_WORD2   SMPU_0.RGD[15].WORD2.R        /* Region Descriptor n, Word 2 */
#define SMPU_0_RGD15_WORD3   SMPU_0.RGD[15].WORD3.R        /* Region Descriptor n, Word 3 */

/* SPI */
#define SPI_0_MCR            SPI_0.MCR.R                   /* Module Configuration Register */
#define SPI_0_TCR            SPI_0.TCR.R                   /* Transfer Count Register */
#define SPI_0_CTAR0          SPI_0.MODE.CTAR[0].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_0_CTAR1          SPI_0.MODE.CTAR[1].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_0_CTAR2          SPI_0.MODE.CTAR[2].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_0_CTAR3          SPI_0.MODE.CTAR[3].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_0_CTAR0_SLAVE    SPI_0.MODE.CTAR_SLAVE[0].R    /* Clock and Transfer Attributes Register (In Slave Mode) */
#define SPI_0_SR             SPI_0.SR.R                    /* Status Register */
#define SPI_0_RSER           SPI_0.RSER.R                  /* DMA/Interrupt Request Select and Enable Register */
#define SPI_0_PUSHR          SPI_0.PUSHR.PUSHR.R           /* PUSH TX FIFO Register In Master Mode */
#define SPI_0_PUSHR_SLAVE    SPI_0.PUSHR.PUSHR_SLAVE.R     /* PUSH TX FIFO Register In Slave Mode */
#define SPI_0_POPR           SPI_0.POPR.R                  /* POP RX FIFO Register */
#define SPI_0_TXFR0          SPI_0.TXFR[0].R               /* Transmit FIFO Registers */
#define SPI_0_TXFR1          SPI_0.TXFR[1].R               /* Transmit FIFO Registers */
#define SPI_0_TXFR2          SPI_0.TXFR[2].R               /* Transmit FIFO Registers */
#define SPI_0_TXFR3          SPI_0.TXFR[3].R               /* Transmit FIFO Registers */
#define SPI_0_TXFR4          SPI_0.TXFR[4].R               /* Transmit FIFO Registers */
#define SPI_0_RXFR0          SPI_0.RXFR[0].R               /* Receive FIFO Registers */
#define SPI_0_RXFR1          SPI_0.RXFR[1].R               /* Receive FIFO Registers */
#define SPI_0_RXFR2          SPI_0.RXFR[2].R               /* Receive FIFO Registers */
#define SPI_0_RXFR3          SPI_0.RXFR[3].R               /* Receive FIFO Registers */
#define SPI_0_RXFR4          SPI_0.RXFR[4].R               /* Receive FIFO Registers */

/* SPI */
#define SPI_1_MCR            SPI_1.MCR.R                   /* Module Configuration Register */
#define SPI_1_TCR            SPI_1.TCR.R                   /* Transfer Count Register */
#define SPI_1_CTAR0          SPI_1.MODE.CTAR[0].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR1          SPI_1.MODE.CTAR[1].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR2          SPI_1.MODE.CTAR[2].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR3          SPI_1.MODE.CTAR[3].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_1_CTAR0_SLAVE    SPI_1.MODE.CTAR_SLAVE[0].R    /* Clock and Transfer Attributes Register (In Slave Mode) */
#define SPI_1_SR             SPI_1.SR.R                    /* Status Register */
#define SPI_1_RSER           SPI_1.RSER.R                  /* DMA/Interrupt Request Select and Enable Register */
#define SPI_1_PUSHR          SPI_1.PUSHR.PUSHR.R           /* PUSH TX FIFO Register In Master Mode */
#define SPI_1_PUSHR_SLAVE    SPI_1.PUSHR.PUSHR_SLAVE.R     /* PUSH TX FIFO Register In Slave Mode */
#define SPI_1_POPR           SPI_1.POPR.R                  /* POP RX FIFO Register */
#define SPI_1_TXFR0          SPI_1.TXFR[0].R               /* Transmit FIFO Registers */
#define SPI_1_TXFR1          SPI_1.TXFR[1].R               /* Transmit FIFO Registers */
#define SPI_1_TXFR2          SPI_1.TXFR[2].R               /* Transmit FIFO Registers */
#define SPI_1_TXFR3          SPI_1.TXFR[3].R               /* Transmit FIFO Registers */
#define SPI_1_TXFR4          SPI_1.TXFR[4].R               /* Transmit FIFO Registers */
#define SPI_1_RXFR0          SPI_1.RXFR[0].R               /* Receive FIFO Registers */
#define SPI_1_RXFR1          SPI_1.RXFR[1].R               /* Receive FIFO Registers */
#define SPI_1_RXFR2          SPI_1.RXFR[2].R               /* Receive FIFO Registers */
#define SPI_1_RXFR3          SPI_1.RXFR[3].R               /* Receive FIFO Registers */
#define SPI_1_RXFR4          SPI_1.RXFR[4].R               /* Receive FIFO Registers */

/* SPI */
#define SPI_2_MCR            SPI_2.MCR.R                   /* Module Configuration Register */
#define SPI_2_TCR            SPI_2.TCR.R                   /* Transfer Count Register */
#define SPI_2_CTAR0          SPI_2.MODE.CTAR[0].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR1          SPI_2.MODE.CTAR[1].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR2          SPI_2.MODE.CTAR[2].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR3          SPI_2.MODE.CTAR[3].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_2_CTAR0_SLAVE    SPI_2.MODE.CTAR_SLAVE[0].R    /* Clock and Transfer Attributes Register (In Slave Mode) */
#define SPI_2_SR             SPI_2.SR.R                    /* Status Register */
#define SPI_2_RSER           SPI_2.RSER.R                  /* DMA/Interrupt Request Select and Enable Register */
#define SPI_2_PUSHR          SPI_2.PUSHR.PUSHR.R           /* PUSH TX FIFO Register In Master Mode */
#define SPI_2_PUSHR_SLAVE    SPI_2.PUSHR.PUSHR_SLAVE.R     /* PUSH TX FIFO Register In Slave Mode */
#define SPI_2_POPR           SPI_2.POPR.R                  /* POP RX FIFO Register */
#define SPI_2_TXFR0          SPI_2.TXFR[0].R               /* Transmit FIFO Registers */
#define SPI_2_TXFR1          SPI_2.TXFR[1].R               /* Transmit FIFO Registers */
#define SPI_2_TXFR2          SPI_2.TXFR[2].R               /* Transmit FIFO Registers */
#define SPI_2_TXFR3          SPI_2.TXFR[3].R               /* Transmit FIFO Registers */
#define SPI_2_TXFR4          SPI_2.TXFR[4].R               /* Transmit FIFO Registers */
#define SPI_2_RXFR0          SPI_2.RXFR[0].R               /* Receive FIFO Registers */
#define SPI_2_RXFR1          SPI_2.RXFR[1].R               /* Receive FIFO Registers */
#define SPI_2_RXFR2          SPI_2.RXFR[2].R               /* Receive FIFO Registers */
#define SPI_2_RXFR3          SPI_2.RXFR[3].R               /* Receive FIFO Registers */
#define SPI_2_RXFR4          SPI_2.RXFR[4].R               /* Receive FIFO Registers */

/* SPI */
#define SPI_3_MCR            SPI_3.MCR.R                   /* Module Configuration Register */
#define SPI_3_TCR            SPI_3.TCR.R                   /* Transfer Count Register */
#define SPI_3_CTAR0          SPI_3.MODE.CTAR[0].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_3_CTAR1          SPI_3.MODE.CTAR[1].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_3_CTAR2          SPI_3.MODE.CTAR[2].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_3_CTAR3          SPI_3.MODE.CTAR[3].R          /* Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_3_CTAR0_SLAVE    SPI_3.MODE.CTAR_SLAVE[0].R    /* Clock and Transfer Attributes Register (In Slave Mode) */
#define SPI_3_SR             SPI_3.SR.R                    /* Status Register */
#define SPI_3_RSER           SPI_3.RSER.R                  /* DMA/Interrupt Request Select and Enable Register */
#define SPI_3_PUSHR          SPI_3.PUSHR.PUSHR.R           /* PUSH TX FIFO Register In Master Mode */
#define SPI_3_PUSHR_SLAVE    SPI_3.PUSHR.PUSHR_SLAVE.R     /* PUSH TX FIFO Register In Slave Mode */
#define SPI_3_POPR           SPI_3.POPR.R                  /* POP RX FIFO Register */
#define SPI_3_TXFR0          SPI_3.TXFR[0].R               /* Transmit FIFO Registers */
#define SPI_3_TXFR1          SPI_3.TXFR[1].R               /* Transmit FIFO Registers */
#define SPI_3_TXFR2          SPI_3.TXFR[2].R               /* Transmit FIFO Registers */
#define SPI_3_TXFR3          SPI_3.TXFR[3].R               /* Transmit FIFO Registers */
#define SPI_3_TXFR4          SPI_3.TXFR[4].R               /* Transmit FIFO Registers */
#define SPI_3_RXFR0          SPI_3.RXFR[0].R               /* Receive FIFO Registers */
#define SPI_3_RXFR1          SPI_3.RXFR[1].R               /* Receive FIFO Registers */
#define SPI_3_RXFR2          SPI_3.RXFR[2].R               /* Receive FIFO Registers */
#define SPI_3_RXFR3          SPI_3.RXFR[3].R               /* Receive FIFO Registers */
#define SPI_3_RXFR4          SPI_3.RXFR[4].R               /* Receive FIFO Registers */

/* SRX */
#define SRX_0_GBL_CTRL       SRX_0.GBL_CTRL.R              /* Global Control Register */
#define SRX_0_CHNL_EN        SRX_0.CHNL_EN.R               /* Channel Enable Register */
#define SRX_0_GBL_STATUS     SRX_0.GBL_STATUS.R            /* Global Status Register */
#define SRX_0_FMSG_RDY       SRX_0.FMSG_RDY.R              /* Fast Message Ready Status Register */
#define SRX_0_SMSG_RDY       SRX_0.SMSG_RDY.R              /* Slow Serial Message Ready Status Register */
#define SRX_0_DATA_CTRL1     SRX_0.DATA_CTRL1.R            /* Data Control Register 1 */
#define SRX_0_DATA_CTRL2     SRX_0.DATA_CTRL2.R            /* Data Control Register 2 */
#define SRX_0_FDMA_CTRL      SRX_0.FDMA_CTRL.R             /* Fast Message DMA Control Register */
#define SRX_0_SDMA_CTRL      SRX_0.SDMA_CTRL.R             /* Slow Serial Message DMA Control Register */
#define SRX_0_FRDY_IE        SRX_0.FRDY_IE.R               /* Fast Message Ready Interrupt Control Register */
#define SRX_0_SRDY_IE        SRX_0.SRDY_IE.R               /* Slow Serial Message Ready Interrupt Enable Register */
#define SRX_0_DMA_FMSG_DATA  SRX_0.DMA_FMSG_DATA.R         /* DMA Fast Message Data Read Register */
#define SRX_0_DMA_FMSG_CRC   SRX_0.DMA_FMSG_CRC.R          /* DMA Fast Message CRC Read Register */
#define SRX_0_DMA_FMSG_TS    SRX_0.DMA_FMSG_TS.R           /* DMA Fast Message Time Stamp Read Register */
#define SRX_0_DMA_SMSG_BIT3  SRX_0.DMA_SMSG_BIT3.R         /* DMA Slow Serial Message Bit3 Read Register */
#define SRX_0_DMA_SMSG_BIT2  SRX_0.DMA_SMSG_BIT2.R         /* DMA Slow Serial Message Bit2 Read Register */
#define SRX_0_DMA_SMSG_TS    SRX_0.DMA_SMSG_TS.R           /* DMA Slow Serial Message Time Stamp Read Register */
#define SRX_0_CH0_CLK_CTRL   SRX_0.CH[0].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH0_STATUS     SRX_0.CH[0].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH0_CONFIG     SRX_0.CH[0].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH1_CLK_CTRL   SRX_0.CH[1].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH1_STATUS     SRX_0.CH[1].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH1_CONFIG     SRX_0.CH[1].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH2_CLK_CTRL   SRX_0.CH[2].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH2_STATUS     SRX_0.CH[2].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH2_CONFIG     SRX_0.CH[2].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH3_CLK_CTRL   SRX_0.CH[3].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH3_STATUS     SRX_0.CH[3].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH3_CONFIG     SRX_0.CH[3].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH4_CLK_CTRL   SRX_0.CH[4].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH4_STATUS     SRX_0.CH[4].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH4_CONFIG     SRX_0.CH[4].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH5_CLK_CTRL   SRX_0.CH[5].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH5_STATUS     SRX_0.CH[5].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH5_CONFIG     SRX_0.CH[5].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH6_CLK_CTRL   SRX_0.CH[6].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH6_STATUS     SRX_0.CH[6].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH6_CONFIG     SRX_0.CH[6].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH7_CLK_CTRL   SRX_0.CH[7].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH7_STATUS     SRX_0.CH[7].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH7_CONFIG     SRX_0.CH[7].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH8_CLK_CTRL   SRX_0.CH[8].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH8_STATUS     SRX_0.CH[8].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH8_CONFIG     SRX_0.CH[8].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH9_CLK_CTRL   SRX_0.CH[9].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH9_STATUS     SRX_0.CH[9].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH9_CONFIG     SRX_0.CH[9].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH10_CLK_CTRL  SRX_0.CH[10].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH10_STATUS    SRX_0.CH[10].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH10_CONFIG    SRX_0.CH[10].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH11_CLK_CTRL  SRX_0.CH[11].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH11_STATUS    SRX_0.CH[11].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH11_CONFIG    SRX_0.CH[11].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH12_CLK_CTRL  SRX_0.CH[12].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH12_STATUS    SRX_0.CH[12].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH12_CONFIG    SRX_0.CH[12].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH13_CLK_CTRL  SRX_0.CH[13].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH13_STATUS    SRX_0.CH[13].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH13_CONFIG    SRX_0.CH[13].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH14_CLK_CTRL  SRX_0.CH[14].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH14_STATUS    SRX_0.CH[14].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH14_CONFIG    SRX_0.CH[14].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH15_CLK_CTRL  SRX_0.CH[15].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_0_CH15_STATUS    SRX_0.CH[15].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_0_CH15_CONFIG    SRX_0.CH[15].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_0_CH0_FMSG_DATA  SRX_0.CHANNEL[0].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH0_FMSG_CRC   SRX_0.CHANNEL[0].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH0_FMSG_TS    SRX_0.CHANNEL[0].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH0_SMSG_BIT3  SRX_0.CHANNEL[0].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH0_SMSG_BIT2  SRX_0.CHANNEL[0].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH0_SMSG_TS    SRX_0.CHANNEL[0].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH1_FMSG_DATA  SRX_0.CHANNEL[1].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH1_FMSG_CRC   SRX_0.CHANNEL[1].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH1_FMSG_TS    SRX_0.CHANNEL[1].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH1_SMSG_BIT3  SRX_0.CHANNEL[1].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH1_SMSG_BIT2  SRX_0.CHANNEL[1].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH1_SMSG_TS    SRX_0.CHANNEL[1].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH2_FMSG_DATA  SRX_0.CHANNEL[2].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH2_FMSG_CRC   SRX_0.CHANNEL[2].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH2_FMSG_TS    SRX_0.CHANNEL[2].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH2_SMSG_BIT3  SRX_0.CHANNEL[2].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH2_SMSG_BIT2  SRX_0.CHANNEL[2].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH2_SMSG_TS    SRX_0.CHANNEL[2].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH3_FMSG_DATA  SRX_0.CHANNEL[3].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH3_FMSG_CRC   SRX_0.CHANNEL[3].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH3_FMSG_TS    SRX_0.CHANNEL[3].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH3_SMSG_BIT3  SRX_0.CHANNEL[3].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH3_SMSG_BIT2  SRX_0.CHANNEL[3].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH3_SMSG_TS    SRX_0.CHANNEL[3].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH4_FMSG_DATA  SRX_0.CHANNEL[4].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH4_FMSG_CRC   SRX_0.CHANNEL[4].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH4_FMSG_TS    SRX_0.CHANNEL[4].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH4_SMSG_BIT3  SRX_0.CHANNEL[4].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH4_SMSG_BIT2  SRX_0.CHANNEL[4].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH4_SMSG_TS    SRX_0.CHANNEL[4].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH5_FMSG_DATA  SRX_0.CHANNEL[5].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH5_FMSG_CRC   SRX_0.CHANNEL[5].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH5_FMSG_TS    SRX_0.CHANNEL[5].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH5_SMSG_BIT3  SRX_0.CHANNEL[5].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH5_SMSG_BIT2  SRX_0.CHANNEL[5].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH5_SMSG_TS    SRX_0.CHANNEL[5].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH6_FMSG_DATA  SRX_0.CHANNEL[6].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH6_FMSG_CRC   SRX_0.CHANNEL[6].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH6_FMSG_TS    SRX_0.CHANNEL[6].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH6_SMSG_BIT3  SRX_0.CHANNEL[6].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH6_SMSG_BIT2  SRX_0.CHANNEL[6].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH6_SMSG_TS    SRX_0.CHANNEL[6].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH7_FMSG_DATA  SRX_0.CHANNEL[7].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH7_FMSG_CRC   SRX_0.CHANNEL[7].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH7_FMSG_TS    SRX_0.CHANNEL[7].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH7_SMSG_BIT3  SRX_0.CHANNEL[7].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH7_SMSG_BIT2  SRX_0.CHANNEL[7].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH7_SMSG_TS    SRX_0.CHANNEL[7].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH8_FMSG_DATA  SRX_0.CHANNEL[8].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH8_FMSG_CRC   SRX_0.CHANNEL[8].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH8_FMSG_TS    SRX_0.CHANNEL[8].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH8_SMSG_BIT3  SRX_0.CHANNEL[8].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH8_SMSG_BIT2  SRX_0.CHANNEL[8].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH8_SMSG_TS    SRX_0.CHANNEL[8].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH9_FMSG_DATA  SRX_0.CHANNEL[9].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH9_FMSG_CRC   SRX_0.CHANNEL[9].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH9_FMSG_TS    SRX_0.CHANNEL[9].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH9_SMSG_BIT3  SRX_0.CHANNEL[9].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH9_SMSG_BIT2  SRX_0.CHANNEL[9].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH9_SMSG_TS    SRX_0.CHANNEL[9].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH10_FMSG_DATA SRX_0.CHANNEL[10].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH10_FMSG_CRC  SRX_0.CHANNEL[10].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH10_FMSG_TS   SRX_0.CHANNEL[10].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH10_SMSG_BIT3 SRX_0.CHANNEL[10].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH10_SMSG_BIT2 SRX_0.CHANNEL[10].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH10_SMSG_TS   SRX_0.CHANNEL[10].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH11_FMSG_DATA SRX_0.CHANNEL[11].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH11_FMSG_CRC  SRX_0.CHANNEL[11].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH11_FMSG_TS   SRX_0.CHANNEL[11].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH11_SMSG_BIT3 SRX_0.CHANNEL[11].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH11_SMSG_BIT2 SRX_0.CHANNEL[11].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH11_SMSG_TS   SRX_0.CHANNEL[11].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH12_FMSG_DATA SRX_0.CHANNEL[12].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH12_FMSG_CRC  SRX_0.CHANNEL[12].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH12_FMSG_TS   SRX_0.CHANNEL[12].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH12_SMSG_BIT3 SRX_0.CHANNEL[12].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH12_SMSG_BIT2 SRX_0.CHANNEL[12].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH12_SMSG_TS   SRX_0.CHANNEL[12].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH13_FMSG_DATA SRX_0.CHANNEL[13].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH13_FMSG_CRC  SRX_0.CHANNEL[13].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH13_FMSG_TS   SRX_0.CHANNEL[13].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH13_SMSG_BIT3 SRX_0.CHANNEL[13].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH13_SMSG_BIT2 SRX_0.CHANNEL[13].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH13_SMSG_TS   SRX_0.CHANNEL[13].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH14_FMSG_DATA SRX_0.CHANNEL[14].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH14_FMSG_CRC  SRX_0.CHANNEL[14].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH14_FMSG_TS   SRX_0.CHANNEL[14].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH14_SMSG_BIT3 SRX_0.CHANNEL[14].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH14_SMSG_BIT2 SRX_0.CHANNEL[14].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH14_SMSG_TS   SRX_0.CHANNEL[14].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH15_FMSG_DATA SRX_0.CHANNEL[15].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_0_CH15_FMSG_CRC  SRX_0.CHANNEL[15].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_0_CH15_FMSG_TS   SRX_0.CHANNEL[15].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_0_CH15_SMSG_BIT3 SRX_0.CHANNEL[15].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_0_CH15_SMSG_BIT2 SRX_0.CHANNEL[15].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_0_CH15_SMSG_TS   SRX_0.CHANNEL[15].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */

/* SRX */
#define SRX_1_GBL_CTRL       SRX_1.GBL_CTRL.R              /* Global Control Register */
#define SRX_1_CHNL_EN        SRX_1.CHNL_EN.R               /* Channel Enable Register */
#define SRX_1_GBL_STATUS     SRX_1.GBL_STATUS.R            /* Global Status Register */
#define SRX_1_FMSG_RDY       SRX_1.FMSG_RDY.R              /* Fast Message Ready Status Register */
#define SRX_1_SMSG_RDY       SRX_1.SMSG_RDY.R              /* Slow Serial Message Ready Status Register */
#define SRX_1_DATA_CTRL1     SRX_1.DATA_CTRL1.R            /* Data Control Register 1 */
#define SRX_1_DATA_CTRL2     SRX_1.DATA_CTRL2.R            /* Data Control Register 2 */
#define SRX_1_FDMA_CTRL      SRX_1.FDMA_CTRL.R             /* Fast Message DMA Control Register */
#define SRX_1_SDMA_CTRL      SRX_1.SDMA_CTRL.R             /* Slow Serial Message DMA Control Register */
#define SRX_1_FRDY_IE        SRX_1.FRDY_IE.R               /* Fast Message Ready Interrupt Control Register */
#define SRX_1_SRDY_IE        SRX_1.SRDY_IE.R               /* Slow Serial Message Ready Interrupt Enable Register */
#define SRX_1_DMA_FMSG_DATA  SRX_1.DMA_FMSG_DATA.R         /* DMA Fast Message Data Read Register */
#define SRX_1_DMA_FMSG_CRC   SRX_1.DMA_FMSG_CRC.R          /* DMA Fast Message CRC Read Register */
#define SRX_1_DMA_FMSG_TS    SRX_1.DMA_FMSG_TS.R           /* DMA Fast Message Time Stamp Read Register */
#define SRX_1_DMA_SMSG_BIT3  SRX_1.DMA_SMSG_BIT3.R         /* DMA Slow Serial Message Bit3 Read Register */
#define SRX_1_DMA_SMSG_BIT2  SRX_1.DMA_SMSG_BIT2.R         /* DMA Slow Serial Message Bit2 Read Register */
#define SRX_1_DMA_SMSG_TS    SRX_1.DMA_SMSG_TS.R           /* DMA Slow Serial Message Time Stamp Read Register */
#define SRX_1_CH0_CLK_CTRL   SRX_1.CH[0].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH0_STATUS     SRX_1.CH[0].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH0_CONFIG     SRX_1.CH[0].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH1_CLK_CTRL   SRX_1.CH[1].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH1_STATUS     SRX_1.CH[1].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH1_CONFIG     SRX_1.CH[1].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH2_CLK_CTRL   SRX_1.CH[2].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH2_STATUS     SRX_1.CH[2].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH2_CONFIG     SRX_1.CH[2].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH3_CLK_CTRL   SRX_1.CH[3].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH3_STATUS     SRX_1.CH[3].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH3_CONFIG     SRX_1.CH[3].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH4_CLK_CTRL   SRX_1.CH[4].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH4_STATUS     SRX_1.CH[4].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH4_CONFIG     SRX_1.CH[4].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH5_CLK_CTRL   SRX_1.CH[5].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH5_STATUS     SRX_1.CH[5].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH5_CONFIG     SRX_1.CH[5].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH6_CLK_CTRL   SRX_1.CH[6].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH6_STATUS     SRX_1.CH[6].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH6_CONFIG     SRX_1.CH[6].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH7_CLK_CTRL   SRX_1.CH[7].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH7_STATUS     SRX_1.CH[7].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH7_CONFIG     SRX_1.CH[7].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH8_CLK_CTRL   SRX_1.CH[8].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH8_STATUS     SRX_1.CH[8].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH8_CONFIG     SRX_1.CH[8].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH9_CLK_CTRL   SRX_1.CH[9].CLK_CTRL.R        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH9_STATUS     SRX_1.CH[9].STATUS.R          /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH9_CONFIG     SRX_1.CH[9].CONFIG.R          /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH10_CLK_CTRL  SRX_1.CH[10].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH10_STATUS    SRX_1.CH[10].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH10_CONFIG    SRX_1.CH[10].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH11_CLK_CTRL  SRX_1.CH[11].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH11_STATUS    SRX_1.CH[11].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH11_CONFIG    SRX_1.CH[11].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH12_CLK_CTRL  SRX_1.CH[12].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH12_STATUS    SRX_1.CH[12].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH12_CONFIG    SRX_1.CH[12].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH13_CLK_CTRL  SRX_1.CH[13].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH13_STATUS    SRX_1.CH[13].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH13_CONFIG    SRX_1.CH[13].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH14_CLK_CTRL  SRX_1.CH[14].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH14_STATUS    SRX_1.CH[14].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH14_CONFIG    SRX_1.CH[14].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH15_CLK_CTRL  SRX_1.CH[15].CLK_CTRL.R       /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
#define SRX_1_CH15_STATUS    SRX_1.CH[15].STATUS.R         /* Channel 'n' Status Register (n=0 to (CH-1)) */
#define SRX_1_CH15_CONFIG    SRX_1.CH[15].CONFIG.R         /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
#define SRX_1_CH0_FMSG_DATA  SRX_1.CHANNEL[0].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH0_FMSG_CRC   SRX_1.CHANNEL[0].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH0_FMSG_TS    SRX_1.CHANNEL[0].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH0_SMSG_BIT3  SRX_1.CHANNEL[0].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH0_SMSG_BIT2  SRX_1.CHANNEL[0].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH0_SMSG_TS    SRX_1.CHANNEL[0].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH1_FMSG_DATA  SRX_1.CHANNEL[1].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH1_FMSG_CRC   SRX_1.CHANNEL[1].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH1_FMSG_TS    SRX_1.CHANNEL[1].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH1_SMSG_BIT3  SRX_1.CHANNEL[1].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH1_SMSG_BIT2  SRX_1.CHANNEL[1].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH1_SMSG_TS    SRX_1.CHANNEL[1].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH2_FMSG_DATA  SRX_1.CHANNEL[2].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH2_FMSG_CRC   SRX_1.CHANNEL[2].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH2_FMSG_TS    SRX_1.CHANNEL[2].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH2_SMSG_BIT3  SRX_1.CHANNEL[2].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH2_SMSG_BIT2  SRX_1.CHANNEL[2].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH2_SMSG_TS    SRX_1.CHANNEL[2].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH3_FMSG_DATA  SRX_1.CHANNEL[3].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH3_FMSG_CRC   SRX_1.CHANNEL[3].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH3_FMSG_TS    SRX_1.CHANNEL[3].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH3_SMSG_BIT3  SRX_1.CHANNEL[3].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH3_SMSG_BIT2  SRX_1.CHANNEL[3].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH3_SMSG_TS    SRX_1.CHANNEL[3].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH4_FMSG_DATA  SRX_1.CHANNEL[4].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH4_FMSG_CRC   SRX_1.CHANNEL[4].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH4_FMSG_TS    SRX_1.CHANNEL[4].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH4_SMSG_BIT3  SRX_1.CHANNEL[4].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH4_SMSG_BIT2  SRX_1.CHANNEL[4].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH4_SMSG_TS    SRX_1.CHANNEL[4].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH5_FMSG_DATA  SRX_1.CHANNEL[5].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH5_FMSG_CRC   SRX_1.CHANNEL[5].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH5_FMSG_TS    SRX_1.CHANNEL[5].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH5_SMSG_BIT3  SRX_1.CHANNEL[5].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH5_SMSG_BIT2  SRX_1.CHANNEL[5].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH5_SMSG_TS    SRX_1.CHANNEL[5].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH6_FMSG_DATA  SRX_1.CHANNEL[6].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH6_FMSG_CRC   SRX_1.CHANNEL[6].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH6_FMSG_TS    SRX_1.CHANNEL[6].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH6_SMSG_BIT3  SRX_1.CHANNEL[6].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH6_SMSG_BIT2  SRX_1.CHANNEL[6].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH6_SMSG_TS    SRX_1.CHANNEL[6].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH7_FMSG_DATA  SRX_1.CHANNEL[7].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH7_FMSG_CRC   SRX_1.CHANNEL[7].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH7_FMSG_TS    SRX_1.CHANNEL[7].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH7_SMSG_BIT3  SRX_1.CHANNEL[7].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH7_SMSG_BIT2  SRX_1.CHANNEL[7].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH7_SMSG_TS    SRX_1.CHANNEL[7].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH8_FMSG_DATA  SRX_1.CHANNEL[8].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH8_FMSG_CRC   SRX_1.CHANNEL[8].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH8_FMSG_TS    SRX_1.CHANNEL[8].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH8_SMSG_BIT3  SRX_1.CHANNEL[8].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH8_SMSG_BIT2  SRX_1.CHANNEL[8].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH8_SMSG_TS    SRX_1.CHANNEL[8].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH9_FMSG_DATA  SRX_1.CHANNEL[9].FMSG_DATA.R  /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH9_FMSG_CRC   SRX_1.CHANNEL[9].FMSG_CRC.R   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH9_FMSG_TS    SRX_1.CHANNEL[9].FMSG_TS.R    /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH9_SMSG_BIT3  SRX_1.CHANNEL[9].SMSG_BIT3.R  /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH9_SMSG_BIT2  SRX_1.CHANNEL[9].SMSG_BIT2.R  /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH9_SMSG_TS    SRX_1.CHANNEL[9].SMSG_TS.R    /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH10_FMSG_DATA SRX_1.CHANNEL[10].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH10_FMSG_CRC  SRX_1.CHANNEL[10].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH10_FMSG_TS   SRX_1.CHANNEL[10].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH10_SMSG_BIT3 SRX_1.CHANNEL[10].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH10_SMSG_BIT2 SRX_1.CHANNEL[10].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH10_SMSG_TS   SRX_1.CHANNEL[10].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH11_FMSG_DATA SRX_1.CHANNEL[11].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH11_FMSG_CRC  SRX_1.CHANNEL[11].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH11_FMSG_TS   SRX_1.CHANNEL[11].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH11_SMSG_BIT3 SRX_1.CHANNEL[11].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH11_SMSG_BIT2 SRX_1.CHANNEL[11].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH11_SMSG_TS   SRX_1.CHANNEL[11].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH12_FMSG_DATA SRX_1.CHANNEL[12].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH12_FMSG_CRC  SRX_1.CHANNEL[12].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH12_FMSG_TS   SRX_1.CHANNEL[12].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH12_SMSG_BIT3 SRX_1.CHANNEL[12].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH12_SMSG_BIT2 SRX_1.CHANNEL[12].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH12_SMSG_TS   SRX_1.CHANNEL[12].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH13_FMSG_DATA SRX_1.CHANNEL[13].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH13_FMSG_CRC  SRX_1.CHANNEL[13].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH13_FMSG_TS   SRX_1.CHANNEL[13].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH13_SMSG_BIT3 SRX_1.CHANNEL[13].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH13_SMSG_BIT2 SRX_1.CHANNEL[13].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH13_SMSG_TS   SRX_1.CHANNEL[13].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH14_FMSG_DATA SRX_1.CHANNEL[14].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH14_FMSG_CRC  SRX_1.CHANNEL[14].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH14_FMSG_TS   SRX_1.CHANNEL[14].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH14_SMSG_BIT3 SRX_1.CHANNEL[14].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH14_SMSG_BIT2 SRX_1.CHANNEL[14].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH14_SMSG_TS   SRX_1.CHANNEL[14].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH15_FMSG_DATA SRX_1.CHANNEL[15].FMSG_DATA.R /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
#define SRX_1_CH15_FMSG_CRC  SRX_1.CHANNEL[15].FMSG_CRC.R  /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
#define SRX_1_CH15_FMSG_TS   SRX_1.CHANNEL[15].FMSG_TS.R   /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
#define SRX_1_CH15_SMSG_BIT3 SRX_1.CHANNEL[15].SMSG_BIT3.R /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
#define SRX_1_CH15_SMSG_BIT2 SRX_1.CHANNEL[15].SMSG_BIT2.R /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
#define SRX_1_CH15_SMSG_TS   SRX_1.CHANNEL[15].SMSG_TS.R   /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */

/* SSCM */
#define SSCM_STATUS          SSCM.STATUS.R                 /* SSCM System Status */
#define SSCM_MEMCONFIG       SSCM.MEMCONFIG.R              /* SSCM System Memory and ID Register */
#define SSCM_ERROR           SSCM.ERROR.R                  /* SSCM Error Configuration Register */
#define SSCM_DEBUGPORT       SSCM.DEBUGPORT.R              /* SSCM Debug Status Port Register */
#define SSCM_UOPS            SSCM.UOPS.R                   /* User Option Status Register */
#define SSCM_PSA             SSCM.PSA.R                    /* Processor Start Address Register */

/* STCU */
#define STCU_RUNSW           STCU.RUNSW.R                  /* STCU2 Run Software Register */
#define STCU_SKC             STCU.SKC.R                    /* STCU2 SK Code Register */
#define STCU_CFG             STCU.CFG.R                    /* STCU2 Configuration Register */
#define STCU_WDG             STCU.WDG.R                    /* STCU2 Watchdog Register Granularity */
#define STCU_ERR_STAT        STCU.ERR_STAT.R               /* STCU2 Error Register */
#define STCU_LBS             STCU.LBS.R                    /* STCU2 Startup LBIST Status Register */
#define STCU_LBE             STCU.LBE.R                    /* STCU2 Startup LBIST End Flag Register */
#define STCU_LBSSW           STCU.LBSSW.R                  /* STCU2 Shutdown LBIST Status Register */
#define STCU_LBESW           STCU.LBESW.R                  /* STCU2 Shutdown LBIST End Flag Register */
#define STCU_LBRMSW          STCU.LBRMSW.R                 /* STCU2 Shutdown LBIST Reset Management */
#define STCU_MBSL            STCU.MBSL.R                   /* STCU2 Startup MBIST Status Low Register */
#define STCU_MBEL            STCU.MBEL.R                   /* STCU2 Startup MBIST End Flag Low Register */
#define STCU_MBSLSW          STCU.MBSLSW.R                 /* STCU2 Shutdown MBIST Status Low Register */
#define STCU_MBELSW          STCU.MBELSW.R                 /* STCU2 Shutdown MBIST End Flag Low Register */
#define STCU_LB0_CTRL        STCU.LB[0].CTRL.R             /* STCU2 LBIST Control Register */
#define STCU_LB0_PCS         STCU.LB[0].PCS.R              /* STCU2 LBIST PC Stop Register */
#define STCU_LB0_MISRELSW    STCU.LB[0].MISRELSW.R         /* STCU2 Shutdown LBIST MISR Expected Low Register */
#define STCU_LB0_MISREHSW    STCU.LB[0].MISREHSW.R         /* STCU2 Shutdown LBIST MISR Expected High Register */
#define STCU_LB1_CTRL        STCU.LB[1].CTRL.R             /* STCU2 LBIST Control Register */
#define STCU_LB1_PCS         STCU.LB[1].PCS.R              /* STCU2 LBIST PC Stop Register */
#define STCU_LB1_MISRELSW    STCU.LB[1].MISRELSW.R         /* STCU2 Shutdown LBIST MISR Expected Low Register */
#define STCU_LB1_MISREHSW    STCU.LB[1].MISREHSW.R         /* STCU2 Shutdown LBIST MISR Expected High Register */
#define STCU_LB2_CTRL        STCU.LB[2].CTRL.R             /* STCU2 LBIST Control Register */
#define STCU_LB2_PCS         STCU.LB[2].PCS.R              /* STCU2 LBIST PC Stop Register */
#define STCU_LB2_MISRELSW    STCU.LB[2].MISRELSW.R         /* STCU2 Shutdown LBIST MISR Expected Low Register */
#define STCU_LB2_MISREHSW    STCU.LB[2].MISREHSW.R         /* STCU2 Shutdown LBIST MISR Expected High Register */
#define STCU_LB3_CTRL        STCU.LB[3].CTRL.R             /* STCU2 LBIST Control Register */
#define STCU_LB3_PCS         STCU.LB[3].PCS.R              /* STCU2 LBIST PC Stop Register */
#define STCU_LB3_MISRELSW    STCU.LB[3].MISRELSW.R         /* STCU2 Shutdown LBIST MISR Expected Low Register */
#define STCU_LB3_MISREHSW    STCU.LB[3].MISREHSW.R         /* STCU2 Shutdown LBIST MISR Expected High Register */
#define STCU_MB0_CTRL        STCU.MB_CTRL[0].R             /* STCU2 MBIST Control Register */
#define STCU_MB1_CTRL        STCU.MB_CTRL[1].R             /* STCU2 MBIST Control Register */
#define STCU_MB2_CTRL        STCU.MB_CTRL[2].R             /* STCU2 MBIST Control Register */
#define STCU_MB3_CTRL        STCU.MB_CTRL[3].R             /* STCU2 MBIST Control Register */
#define STCU_MB4_CTRL        STCU.MB_CTRL[4].R             /* STCU2 MBIST Control Register */
#define STCU_MB5_CTRL        STCU.MB_CTRL[5].R             /* STCU2 MBIST Control Register */
#define STCU_MB6_CTRL        STCU.MB_CTRL[6].R             /* STCU2 MBIST Control Register */
#define STCU_MB7_CTRL        STCU.MB_CTRL[7].R             /* STCU2 MBIST Control Register */
#define STCU_MB8_CTRL        STCU.MB_CTRL[8].R             /* STCU2 MBIST Control Register */
#define STCU_MB9_CTRL        STCU.MB_CTRL[9].R             /* STCU2 MBIST Control Register */
#define STCU_MB10_CTRL       STCU.MB_CTRL[10].R            /* STCU2 MBIST Control Register */
#define STCU_MB11_CTRL       STCU.MB_CTRL[11].R            /* STCU2 MBIST Control Register */
#define STCU_MB12_CTRL       STCU.MB_CTRL[12].R            /* STCU2 MBIST Control Register */
#define STCU_MB13_CTRL       STCU.MB_CTRL[13].R            /* STCU2 MBIST Control Register */
#define STCU_MB14_CTRL       STCU.MB_CTRL[14].R            /* STCU2 MBIST Control Register */
#define STCU_MB15_CTRL       STCU.MB_CTRL[15].R            /* STCU2 MBIST Control Register */
#define STCU_MB16_CTRL       STCU.MB_CTRL[16].R            /* STCU2 MBIST Control Register */
#define STCU_MB17_CTRL       STCU.MB_CTRL[17].R            /* STCU2 MBIST Control Register */
#define STCU_MB18_CTRL       STCU.MB_CTRL[18].R            /* STCU2 MBIST Control Register */
#define STCU_MB19_CTRL       STCU.MB_CTRL[19].R            /* STCU2 MBIST Control Register */
#define STCU_MB20_CTRL       STCU.MB_CTRL[20].R            /* STCU2 MBIST Control Register */
#define STCU_MB21_CTRL       STCU.MB_CTRL[21].R            /* STCU2 MBIST Control Register */
#define STCU_MB22_CTRL       STCU.MB_CTRL[22].R            /* STCU2 MBIST Control Register */
#define STCU_MB23_CTRL       STCU.MB_CTRL[23].R            /* STCU2 MBIST Control Register */
#define STCU_MB24_CTRL       STCU.MB_CTRL[24].R            /* STCU2 MBIST Control Register */
#define STCU_MB25_CTRL       STCU.MB_CTRL[25].R            /* STCU2 MBIST Control Register */
#define STCU_MB26_CTRL       STCU.MB_CTRL[26].R            /* STCU2 MBIST Control Register */

/* STM */
#define STM_0_CR             STM_0.CR.R                    /* STM Control Register */
#define STM_0_CNT            STM_0.CNT.R                   /* STM Count Register */
#define STM_0_CCR0           STM_0.CHANNEL[0].CCR.R        /* STM Channel Control Register */
#define STM_0_CIR0           STM_0.CHANNEL[0].CIR.R        /* STM Channel Interrupt Register */
#define STM_0_CMP0           STM_0.CHANNEL[0].CMP.R        /* STM Channel Compare Register */
#define STM_0_CCR1           STM_0.CHANNEL[1].CCR.R        /* STM Channel Control Register */
#define STM_0_CIR1           STM_0.CHANNEL[1].CIR.R        /* STM Channel Interrupt Register */
#define STM_0_CMP1           STM_0.CHANNEL[1].CMP.R        /* STM Channel Compare Register */
#define STM_0_CCR2           STM_0.CHANNEL[2].CCR.R        /* STM Channel Control Register */
#define STM_0_CIR2           STM_0.CHANNEL[2].CIR.R        /* STM Channel Interrupt Register */
#define STM_0_CMP2           STM_0.CHANNEL[2].CMP.R        /* STM Channel Compare Register */
#define STM_0_CCR3           STM_0.CHANNEL[3].CCR.R        /* STM Channel Control Register */
#define STM_0_CIR3           STM_0.CHANNEL[3].CIR.R        /* STM Channel Interrupt Register */
#define STM_0_CMP3           STM_0.CHANNEL[3].CMP.R        /* STM Channel Compare Register */

/* SWT */
#define SWT_0_CR             SWT_0.CR.R                    /* SWT Control Register */
#define SWT_0_IR             SWT_0.IR.R                    /* SWT Interrupt Register */
#define SWT_0_TO             SWT_0.TO.R                    /* SWT Time-out Register */
#define SWT_0_WN             SWT_0.WN.R                    /* SWT Window Register */
#define SWT_0_SR             SWT_0.SR.R                    /* SWT Service Register */
#define SWT_0_CO             SWT_0.CO.R                    /* SWT Counter Output Register */
#define SWT_0_SK             SWT_0.SK.R                    /* SWT Service Key Register */

/* WKPU */
#define WKPU_NSR             WKPU.NSR.R                    /* NMI Status Flag Register */
#define WKPU_NCR             WKPU.NCR.R                    /* NMI Configuration Register */

/* XBAR */
#define XBAR_0_PRS0          XBAR_0.PORT[0].PRS.R          /* Priority Registers Slave */
#define XBAR_0_CRS0          XBAR_0.PORT[0].CRS.R          /* Control Register */
#define XBAR_0_PRS1          XBAR_0.PORT[1].PRS.R          /* Priority Registers Slave */
#define XBAR_0_CRS1          XBAR_0.PORT[1].CRS.R          /* Control Register */
#define XBAR_0_PRS2          XBAR_0.PORT[2].PRS.R          /* Priority Registers Slave */
#define XBAR_0_CRS2          XBAR_0.PORT[2].CRS.R          /* Control Register */
#define XBAR_0_PRS3          XBAR_0.PORT[3].PRS.R          /* Priority Registers Slave */
#define XBAR_0_CRS3          XBAR_0.PORT[3].CRS.R          /* Control Register */
#define XBAR_0_PRS4          XBAR_0.PORT[4].PRS.R          /* Priority Registers Slave */
#define XBAR_0_CRS4          XBAR_0.PORT[4].CRS.R          /* Control Register */
#define XBAR_0_PRS5          XBAR_0.PORT[5].PRS.R          /* Priority Registers Slave */
#define XBAR_0_CRS5          XBAR_0.PORT[5].CRS.R          /* Control Register */
#define XBAR_0_PRS6          XBAR_0.PORT[6].PRS.R          /* Priority Registers Slave */
#define XBAR_0_CRS6          XBAR_0.PORT[6].CRS.R          /* Control Register */
#define XBAR_0_PRS7          XBAR_0.PORT[7].PRS.R          /* Priority Registers Slave */
#define XBAR_0_CRS7          XBAR_0.PORT[7].CRS.R          /* Control Register */

/* XBIC */
#define XBIC_MCR             XBIC.MCR.R                    /* XBIC Module Control Register */
#define XBIC_EIR             XBIC.EIR.R                    /* XBIC Error Injection Register */
#define XBIC_ESR             XBIC.ESR.R                    /* XBIC Error Status Register */
#define XBIC_EAR             XBIC.EAR.R                    /* XBIC Error Address Register */

/* XOSC */
#define XOSC_CTL             XOSC.CTL.R                    /* XOSC Control Register */

#ifdef __MWERKS__
#pragma pop
#endif
#ifdef __ghs__
#pragma ghs endnowarning
#endif
#ifdef  __cplusplus
}
#endif
#endif /* ifdef _MPC5744P_H */
