/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2014 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. FREESCALE neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED 
TO THE PROJECT BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE 
SERVICES. IN NO EVENT SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL 
DAMAGES ARISING OUT OF THIS AGREEMENT.
CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands 
or actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result 
of the advise or assistance supplied CUSTOMER in connection with product, 
services or goods supplied under this Agreement.
********************************************************************************
* File:             INTC_Init.c
* Owner:            b21190(Vlna Peter)
* Version:          1.0
* Date:             Jan-05-2015
* Classification:   General Business Information
* Brief:            (e200z425) INTC initialization code
********************************************************************************
********************************************************************************
* Detailed Description:
*
* 
* ------------------------------------------------------------------------------
* Test HW:  MPC57xx
* Maskset:  1N65H
* Target :  internal_FLASH
* Fsys:     200 MHz PLL with 40 MHz crystal reference
*
********************************************************************************
Revision History:
1.0     Jan-05-2015     b21190(Vlna Peter)  Initial Version
*******************************************************************************/

/*******************************************************************************
* Includes                                                                     
*******************************************************************************/
#include "MPC5744P.h"

/*******************************************************************************
* Constants and macros
*******************************************************************************/

/*******************************************************************************
* External objects
*******************************************************************************/

/*******************************************************************************
* Global variables
*******************************************************************************/
extern const uint32_t IntcIsrVectorTable[];

/*******************************************************************************
*                      EXTERNAL PROTOTYPES                                    
*******************************************************************************/
extern void e200zX_Interrupt_Setup(void);

/*******************************************************************************
* Local functions
*******************************************************************************/

/*******************************************************************************
Function Name : INTC_Init
Engineer      : b21190
Date          : Jan-05-2015
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : INTC_Init function
Issues        : NONE
*******************************************************************************/
void INTC_Init(void)
{ 
//-1--------------------------------------------------------------------
  /* The Block Configuration Register is used to configure options of the INTC. 
     Initialize INTC for software vector mode */
  INTC_0.BCR.R = 0x00000000;       
//-2--------------------------------------------------------------------
  /* configure IVORx offsets
     This file also includes a trap for all core exceptions, excluding IVOR4 exceptions which have seperate handler */
  e200zX_Interrupt_Setup();

//-3--------------------------------------------------------------------	
  /* configure Interrupt Base pointer
     Set INTC ISR vector table base address */
  INTC_0.IACKR[0].R = (uint32_t) &IntcIsrVectorTable[0]; 
//-4--------------------------------------------------------------------
  // assign VECTOR TABLE address
//  INTC_0.IACKR[0].R = (uint32_t) IntcIsrVectorTable;
//-5--------------------------------------------------------------------
  // set lowest priority to enable interrupts from higher ones
  INTC_0.CPR[0].B.PRI = 0;
//-6--------------------------------------------------------------------	
  // assing required peripheral priorities
  //INTC_0.PSR[226].R = 0x8001;    // PIT0
  INTC_0.PSR[488].R = 0x801F; //
//-7--------------------------------------------------------------------
  // Enable interrupts
  asm(" wrteei 1");
}//INTC_Init
