//
// File : rijndael.cpp
// Creation date : Sun Nov 5 2000 03:22:10 CEST
// Author : Szymon Stefanek (stefanek@tin.it)
//
// Another implementation of the Rijndael cipher.
// This is intended to be an easily usable library file.
// This code is public domain.
// Based on the Vincent Rijmen and K.U.Leuven implementation 2.4.
//

//
// Original Copyright notice:
//
//    rijndael-alg-fst.c   v2.4   April '2000
//    rijndael-alg-fst.h
//    rijndael-api-fst.c
//    rijndael-api-fst.h
//
//    Optimised ANSI C code
//
//    authors: v1.0: Antoon Bosselaers
//             v2.0: Vincent Rijmen, K.U.Leuven
//             v2.3: Paulo Barreto
//             v2.4: Vincent Rijmen, K.U.Leuven
//
//    This code is placed in the public domain.
//

//
// This implementation works on 128 , 192 , 256 bit keys
// and on 128 bit blocks
//

#define _RIJNDAEL_CPP_

#include "rijndael.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static uint8_t S[256] = { 99,  124, 119, 123, 242, 107, 111, 197, 48,  1,   103, 43,  254, 215, 171, 118, 202, 130, 201,
                          125, 250, 89,  71,  240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38,  54,  63,
                          247, 204, 52,  165, 229, 241, 113, 216, 49,  21,  4,   199, 35,  195, 24,  150, 5,   154, 7,
                          18,  128, 226, 235, 39,  178, 117, 9,   131, 44,  26,  27,  110, 90,  160, 82,  59,  214, 179,
                          41,  227, 47,  132, 83,  209, 0,   237, 32,  252, 177, 91,  106, 203, 190, 57,  74,  76,  88,
                          207, 208, 239, 170, 251, 67,  77,  51,  133, 69,  249, 2,   127, 80,  60,  159, 168, 81,  163,
                          64,  143, 146, 157, 56,  245, 188, 182, 218, 33,  16,  255, 243, 210, 205, 12,  19,  236, 95,
                          151, 68,  23,  196, 167, 126, 61,  100, 93,  25,  115, 96,  129, 79,  220, 34,  42,  144, 136,
                          70,  238, 184, 20,  222, 94,  11,  219, 224, 50,  58,  10,  73,  6,   36,  92,  194, 211, 172,
                          98,  145, 149, 228, 121, 231, 200, 55,  109, 141, 213, 78,  169, 108, 86,  244, 234, 101, 122,
                          174, 8,   186, 120, 37,  46,  28,  166, 180, 198, 232, 221, 116, 31,  75,  189, 139, 138, 112,
                          62,  181, 102, 72,  3,   246, 14,  97,  53,  87,  185, 134, 193, 29,  158, 225, 248, 152, 17,
                          105, 217, 142, 148, 155, 30,  135, 233, 206, 85,  40,  223, 140, 161, 137, 13,  191, 230, 66,
                          104, 65,  153, 45,  15,  176, 84,  187, 22 };

static uint8_t T1[256][4] = {
    0xc6, 0x63, 0x63, 0xa5, 0xf8, 0x7c, 0x7c, 0x84, 0xee, 0x77, 0x77, 0x99, 0xf6, 0x7b, 0x7b, 0x8d, 0xff, 0xf2, 0xf2,
    0x0d, 0xd6, 0x6b, 0x6b, 0xbd, 0xde, 0x6f, 0x6f, 0xb1, 0x91, 0xc5, 0xc5, 0x54, 0x60, 0x30, 0x30, 0x50, 0x02, 0x01,
    0x01, 0x03, 0xce, 0x67, 0x67, 0xa9, 0x56, 0x2b, 0x2b, 0x7d, 0xe7, 0xfe, 0xfe, 0x19, 0xb5, 0xd7, 0xd7, 0x62, 0x4d,
    0xab, 0xab, 0xe6, 0xec, 0x76, 0x76, 0x9a, 0x8f, 0xca, 0xca, 0x45, 0x1f, 0x82, 0x82, 0x9d, 0x89, 0xc9, 0xc9, 0x40,
    0xfa, 0x7d, 0x7d, 0x87, 0xef, 0xfa, 0xfa, 0x15, 0xb2, 0x59, 0x59, 0xeb, 0x8e, 0x47, 0x47, 0xc9, 0xfb, 0xf0, 0xf0,
    0x0b, 0x41, 0xad, 0xad, 0xec, 0xb3, 0xd4, 0xd4, 0x67, 0x5f, 0xa2, 0xa2, 0xfd, 0x45, 0xaf, 0xaf, 0xea, 0x23, 0x9c,
    0x9c, 0xbf, 0x53, 0xa4, 0xa4, 0xf7, 0xe4, 0x72, 0x72, 0x96, 0x9b, 0xc0, 0xc0, 0x5b, 0x75, 0xb7, 0xb7, 0xc2, 0xe1,
    0xfd, 0xfd, 0x1c, 0x3d, 0x93, 0x93, 0xae, 0x4c, 0x26, 0x26, 0x6a, 0x6c, 0x36, 0x36, 0x5a, 0x7e, 0x3f, 0x3f, 0x41,
    0xf5, 0xf7, 0xf7, 0x02, 0x83, 0xcc, 0xcc, 0x4f, 0x68, 0x34, 0x34, 0x5c, 0x51, 0xa5, 0xa5, 0xf4, 0xd1, 0xe5, 0xe5,
    0x34, 0xf9, 0xf1, 0xf1, 0x08, 0xe2, 0x71, 0x71, 0x93, 0xab, 0xd8, 0xd8, 0x73, 0x62, 0x31, 0x31, 0x53, 0x2a, 0x15,
    0x15, 0x3f, 0x08, 0x04, 0x04, 0x0c, 0x95, 0xc7, 0xc7, 0x52, 0x46, 0x23, 0x23, 0x65, 0x9d, 0xc3, 0xc3, 0x5e, 0x30,
    0x18, 0x18, 0x28, 0x37, 0x96, 0x96, 0xa1, 0x0a, 0x05, 0x05, 0x0f, 0x2f, 0x9a, 0x9a, 0xb5, 0x0e, 0x07, 0x07, 0x09,
    0x24, 0x12, 0x12, 0x36, 0x1b, 0x80, 0x80, 0x9b, 0xdf, 0xe2, 0xe2, 0x3d, 0xcd, 0xeb, 0xeb, 0x26, 0x4e, 0x27, 0x27,
    0x69, 0x7f, 0xb2, 0xb2, 0xcd, 0xea, 0x75, 0x75, 0x9f, 0x12, 0x09, 0x09, 0x1b, 0x1d, 0x83, 0x83, 0x9e, 0x58, 0x2c,
    0x2c, 0x74, 0x34, 0x1a, 0x1a, 0x2e, 0x36, 0x1b, 0x1b, 0x2d, 0xdc, 0x6e, 0x6e, 0xb2, 0xb4, 0x5a, 0x5a, 0xee, 0x5b,
    0xa0, 0xa0, 0xfb, 0xa4, 0x52, 0x52, 0xf6, 0x76, 0x3b, 0x3b, 0x4d, 0xb7, 0xd6, 0xd6, 0x61, 0x7d, 0xb3, 0xb3, 0xce,
    0x52, 0x29, 0x29, 0x7b, 0xdd, 0xe3, 0xe3, 0x3e, 0x5e, 0x2f, 0x2f, 0x71, 0x13, 0x84, 0x84, 0x97, 0xa6, 0x53, 0x53,
    0xf5, 0xb9, 0xd1, 0xd1, 0x68, 0x00, 0x00, 0x00, 0x00, 0xc1, 0xed, 0xed, 0x2c, 0x40, 0x20, 0x20, 0x60, 0xe3, 0xfc,
    0xfc, 0x1f, 0x79, 0xb1, 0xb1, 0xc8, 0xb6, 0x5b, 0x5b, 0xed, 0xd4, 0x6a, 0x6a, 0xbe, 0x8d, 0xcb, 0xcb, 0x46, 0x67,
    0xbe, 0xbe, 0xd9, 0x72, 0x39, 0x39, 0x4b, 0x94, 0x4a, 0x4a, 0xde, 0x98, 0x4c, 0x4c, 0xd4, 0xb0, 0x58, 0x58, 0xe8,
    0x85, 0xcf, 0xcf, 0x4a, 0xbb, 0xd0, 0xd0, 0x6b, 0xc5, 0xef, 0xef, 0x2a, 0x4f, 0xaa, 0xaa, 0xe5, 0xed, 0xfb, 0xfb,
    0x16, 0x86, 0x43, 0x43, 0xc5, 0x9a, 0x4d, 0x4d, 0xd7, 0x66, 0x33, 0x33, 0x55, 0x11, 0x85, 0x85, 0x94, 0x8a, 0x45,
    0x45, 0xcf, 0xe9, 0xf9, 0xf9, 0x10, 0x04, 0x02, 0x02, 0x06, 0xfe, 0x7f, 0x7f, 0x81, 0xa0, 0x50, 0x50, 0xf0, 0x78,
    0x3c, 0x3c, 0x44, 0x25, 0x9f, 0x9f, 0xba, 0x4b, 0xa8, 0xa8, 0xe3, 0xa2, 0x51, 0x51, 0xf3, 0x5d, 0xa3, 0xa3, 0xfe,
    0x80, 0x40, 0x40, 0xc0, 0x05, 0x8f, 0x8f, 0x8a, 0x3f, 0x92, 0x92, 0xad, 0x21, 0x9d, 0x9d, 0xbc, 0x70, 0x38, 0x38,
    0x48, 0xf1, 0xf5, 0xf5, 0x04, 0x63, 0xbc, 0xbc, 0xdf, 0x77, 0xb6, 0xb6, 0xc1, 0xaf, 0xda, 0xda, 0x75, 0x42, 0x21,
    0x21, 0x63, 0x20, 0x10, 0x10, 0x30, 0xe5, 0xff, 0xff, 0x1a, 0xfd, 0xf3, 0xf3, 0x0e, 0xbf, 0xd2, 0xd2, 0x6d, 0x81,
    0xcd, 0xcd, 0x4c, 0x18, 0x0c, 0x0c, 0x14, 0x26, 0x13, 0x13, 0x35, 0xc3, 0xec, 0xec, 0x2f, 0xbe, 0x5f, 0x5f, 0xe1,
    0x35, 0x97, 0x97, 0xa2, 0x88, 0x44, 0x44, 0xcc, 0x2e, 0x17, 0x17, 0x39, 0x93, 0xc4, 0xc4, 0x57, 0x55, 0xa7, 0xa7,
    0xf2, 0xfc, 0x7e, 0x7e, 0x82, 0x7a, 0x3d, 0x3d, 0x47, 0xc8, 0x64, 0x64, 0xac, 0xba, 0x5d, 0x5d, 0xe7, 0x32, 0x19,
    0x19, 0x2b, 0xe6, 0x73, 0x73, 0x95, 0xc0, 0x60, 0x60, 0xa0, 0x19, 0x81, 0x81, 0x98, 0x9e, 0x4f, 0x4f, 0xd1, 0xa3,
    0xdc, 0xdc, 0x7f, 0x44, 0x22, 0x22, 0x66, 0x54, 0x2a, 0x2a, 0x7e, 0x3b, 0x90, 0x90, 0xab, 0x0b, 0x88, 0x88, 0x83,
    0x8c, 0x46, 0x46, 0xca, 0xc7, 0xee, 0xee, 0x29, 0x6b, 0xb8, 0xb8, 0xd3, 0x28, 0x14, 0x14, 0x3c, 0xa7, 0xde, 0xde,
    0x79, 0xbc, 0x5e, 0x5e, 0xe2, 0x16, 0x0b, 0x0b, 0x1d, 0xad, 0xdb, 0xdb, 0x76, 0xdb, 0xe0, 0xe0, 0x3b, 0x64, 0x32,
    0x32, 0x56, 0x74, 0x3a, 0x3a, 0x4e, 0x14, 0x0a, 0x0a, 0x1e, 0x92, 0x49, 0x49, 0xdb, 0x0c, 0x06, 0x06, 0x0a, 0x48,
    0x24, 0x24, 0x6c, 0xb8, 0x5c, 0x5c, 0xe4, 0x9f, 0xc2, 0xc2, 0x5d, 0xbd, 0xd3, 0xd3, 0x6e, 0x43, 0xac, 0xac, 0xef,
    0xc4, 0x62, 0x62, 0xa6, 0x39, 0x91, 0x91, 0xa8, 0x31, 0x95, 0x95, 0xa4, 0xd3, 0xe4, 0xe4, 0x37, 0xf2, 0x79, 0x79,
    0x8b, 0xd5, 0xe7, 0xe7, 0x32, 0x8b, 0xc8, 0xc8, 0x43, 0x6e, 0x37, 0x37, 0x59, 0xda, 0x6d, 0x6d, 0xb7, 0x01, 0x8d,
    0x8d, 0x8c, 0xb1, 0xd5, 0xd5, 0x64, 0x9c, 0x4e, 0x4e, 0xd2, 0x49, 0xa9, 0xa9, 0xe0, 0xd8, 0x6c, 0x6c, 0xb4, 0xac,
    0x56, 0x56, 0xfa, 0xf3, 0xf4, 0xf4, 0x07, 0xcf, 0xea, 0xea, 0x25, 0xca, 0x65, 0x65, 0xaf, 0xf4, 0x7a, 0x7a, 0x8e,
    0x47, 0xae, 0xae, 0xe9, 0x10, 0x08, 0x08, 0x18, 0x6f, 0xba, 0xba, 0xd5, 0xf0, 0x78, 0x78, 0x88, 0x4a, 0x25, 0x25,
    0x6f, 0x5c, 0x2e, 0x2e, 0x72, 0x38, 0x1c, 0x1c, 0x24, 0x57, 0xa6, 0xa6, 0xf1, 0x73, 0xb4, 0xb4, 0xc7, 0x97, 0xc6,
    0xc6, 0x51, 0xcb, 0xe8, 0xe8, 0x23, 0xa1, 0xdd, 0xdd, 0x7c, 0xe8, 0x74, 0x74, 0x9c, 0x3e, 0x1f, 0x1f, 0x21, 0x96,
    0x4b, 0x4b, 0xdd, 0x61, 0xbd, 0xbd, 0xdc, 0x0d, 0x8b, 0x8b, 0x86, 0x0f, 0x8a, 0x8a, 0x85, 0xe0, 0x70, 0x70, 0x90,
    0x7c, 0x3e, 0x3e, 0x42, 0x71, 0xb5, 0xb5, 0xc4, 0xcc, 0x66, 0x66, 0xaa, 0x90, 0x48, 0x48, 0xd8, 0x06, 0x03, 0x03,
    0x05, 0xf7, 0xf6, 0xf6, 0x01, 0x1c, 0x0e, 0x0e, 0x12, 0xc2, 0x61, 0x61, 0xa3, 0x6a, 0x35, 0x35, 0x5f, 0xae, 0x57,
    0x57, 0xf9, 0x69, 0xb9, 0xb9, 0xd0, 0x17, 0x86, 0x86, 0x91, 0x99, 0xc1, 0xc1, 0x58, 0x3a, 0x1d, 0x1d, 0x27, 0x27,
    0x9e, 0x9e, 0xb9, 0xd9, 0xe1, 0xe1, 0x38, 0xeb, 0xf8, 0xf8, 0x13, 0x2b, 0x98, 0x98, 0xb3, 0x22, 0x11, 0x11, 0x33,
    0xd2, 0x69, 0x69, 0xbb, 0xa9, 0xd9, 0xd9, 0x70, 0x07, 0x8e, 0x8e, 0x89, 0x33, 0x94, 0x94, 0xa7, 0x2d, 0x9b, 0x9b,
    0xb6, 0x3c, 0x1e, 0x1e, 0x22, 0x15, 0x87, 0x87, 0x92, 0xc9, 0xe9, 0xe9, 0x20, 0x87, 0xce, 0xce, 0x49, 0xaa, 0x55,
    0x55, 0xff, 0x50, 0x28, 0x28, 0x78, 0xa5, 0xdf, 0xdf, 0x7a, 0x03, 0x8c, 0x8c, 0x8f, 0x59, 0xa1, 0xa1, 0xf8, 0x09,
    0x89, 0x89, 0x80, 0x1a, 0x0d, 0x0d, 0x17, 0x65, 0xbf, 0xbf, 0xda, 0xd7, 0xe6, 0xe6, 0x31, 0x84, 0x42, 0x42, 0xc6,
    0xd0, 0x68, 0x68, 0xb8, 0x82, 0x41, 0x41, 0xc3, 0x29, 0x99, 0x99, 0xb0, 0x5a, 0x2d, 0x2d, 0x77, 0x1e, 0x0f, 0x0f,
    0x11, 0x7b, 0xb0, 0xb0, 0xcb, 0xa8, 0x54, 0x54, 0xfc, 0x6d, 0xbb, 0xbb, 0xd6, 0x2c, 0x16, 0x16, 0x3a
};

static uint8_t T2[256][4] = {
    0xa5, 0xc6, 0x63, 0x63, 0x84, 0xf8, 0x7c, 0x7c, 0x99, 0xee, 0x77, 0x77, 0x8d, 0xf6, 0x7b, 0x7b, 0x0d, 0xff, 0xf2,
    0xf2, 0xbd, 0xd6, 0x6b, 0x6b, 0xb1, 0xde, 0x6f, 0x6f, 0x54, 0x91, 0xc5, 0xc5, 0x50, 0x60, 0x30, 0x30, 0x03, 0x02,
    0x01, 0x01, 0xa9, 0xce, 0x67, 0x67, 0x7d, 0x56, 0x2b, 0x2b, 0x19, 0xe7, 0xfe, 0xfe, 0x62, 0xb5, 0xd7, 0xd7, 0xe6,
    0x4d, 0xab, 0xab, 0x9a, 0xec, 0x76, 0x76, 0x45, 0x8f, 0xca, 0xca, 0x9d, 0x1f, 0x82, 0x82, 0x40, 0x89, 0xc9, 0xc9,
    0x87, 0xfa, 0x7d, 0x7d, 0x15, 0xef, 0xfa, 0xfa, 0xeb, 0xb2, 0x59, 0x59, 0xc9, 0x8e, 0x47, 0x47, 0x0b, 0xfb, 0xf0,
    0xf0, 0xec, 0x41, 0xad, 0xad, 0x67, 0xb3, 0xd4, 0xd4, 0xfd, 0x5f, 0xa2, 0xa2, 0xea, 0x45, 0xaf, 0xaf, 0xbf, 0x23,
    0x9c, 0x9c, 0xf7, 0x53, 0xa4, 0xa4, 0x96, 0xe4, 0x72, 0x72, 0x5b, 0x9b, 0xc0, 0xc0, 0xc2, 0x75, 0xb7, 0xb7, 0x1c,
    0xe1, 0xfd, 0xfd, 0xae, 0x3d, 0x93, 0x93, 0x6a, 0x4c, 0x26, 0x26, 0x5a, 0x6c, 0x36, 0x36, 0x41, 0x7e, 0x3f, 0x3f,
    0x02, 0xf5, 0xf7, 0xf7, 0x4f, 0x83, 0xcc, 0xcc, 0x5c, 0x68, 0x34, 0x34, 0xf4, 0x51, 0xa5, 0xa5, 0x34, 0xd1, 0xe5,
    0xe5, 0x08, 0xf9, 0xf1, 0xf1, 0x93, 0xe2, 0x71, 0x71, 0x73, 0xab, 0xd8, 0xd8, 0x53, 0x62, 0x31, 0x31, 0x3f, 0x2a,
    0x15, 0x15, 0x0c, 0x08, 0x04, 0x04, 0x52, 0x95, 0xc7, 0xc7, 0x65, 0x46, 0x23, 0x23, 0x5e, 0x9d, 0xc3, 0xc3, 0x28,
    0x30, 0x18, 0x18, 0xa1, 0x37, 0x96, 0x96, 0x0f, 0x0a, 0x05, 0x05, 0xb5, 0x2f, 0x9a, 0x9a, 0x09, 0x0e, 0x07, 0x07,
    0x36, 0x24, 0x12, 0x12, 0x9b, 0x1b, 0x80, 0x80, 0x3d, 0xdf, 0xe2, 0xe2, 0x26, 0xcd, 0xeb, 0xeb, 0x69, 0x4e, 0x27,
    0x27, 0xcd, 0x7f, 0xb2, 0xb2, 0x9f, 0xea, 0x75, 0x75, 0x1b, 0x12, 0x09, 0x09, 0x9e, 0x1d, 0x83, 0x83, 0x74, 0x58,
    0x2c, 0x2c, 0x2e, 0x34, 0x1a, 0x1a, 0x2d, 0x36, 0x1b, 0x1b, 0xb2, 0xdc, 0x6e, 0x6e, 0xee, 0xb4, 0x5a, 0x5a, 0xfb,
    0x5b, 0xa0, 0xa0, 0xf6, 0xa4, 0x52, 0x52, 0x4d, 0x76, 0x3b, 0x3b, 0x61, 0xb7, 0xd6, 0xd6, 0xce, 0x7d, 0xb3, 0xb3,
    0x7b, 0x52, 0x29, 0x29, 0x3e, 0xdd, 0xe3, 0xe3, 0x71, 0x5e, 0x2f, 0x2f, 0x97, 0x13, 0x84, 0x84, 0xf5, 0xa6, 0x53,
    0x53, 0x68, 0xb9, 0xd1, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xc1, 0xed, 0xed, 0x60, 0x40, 0x20, 0x20, 0x1f, 0xe3,
    0xfc, 0xfc, 0xc8, 0x79, 0xb1, 0xb1, 0xed, 0xb6, 0x5b, 0x5b, 0xbe, 0xd4, 0x6a, 0x6a, 0x46, 0x8d, 0xcb, 0xcb, 0xd9,
    0x67, 0xbe, 0xbe, 0x4b, 0x72, 0x39, 0x39, 0xde, 0x94, 0x4a, 0x4a, 0xd4, 0x98, 0x4c, 0x4c, 0xe8, 0xb0, 0x58, 0x58,
    0x4a, 0x85, 0xcf, 0xcf, 0x6b, 0xbb, 0xd0, 0xd0, 0x2a, 0xc5, 0xef, 0xef, 0xe5, 0x4f, 0xaa, 0xaa, 0x16, 0xed, 0xfb,
    0xfb, 0xc5, 0x86, 0x43, 0x43, 0xd7, 0x9a, 0x4d, 0x4d, 0x55, 0x66, 0x33, 0x33, 0x94, 0x11, 0x85, 0x85, 0xcf, 0x8a,
    0x45, 0x45, 0x10, 0xe9, 0xf9, 0xf9, 0x06, 0x04, 0x02, 0x02, 0x81, 0xfe, 0x7f, 0x7f, 0xf0, 0xa0, 0x50, 0x50, 0x44,
    0x78, 0x3c, 0x3c, 0xba, 0x25, 0x9f, 0x9f, 0xe3, 0x4b, 0xa8, 0xa8, 0xf3, 0xa2, 0x51, 0x51, 0xfe, 0x5d, 0xa3, 0xa3,
    0xc0, 0x80, 0x40, 0x40, 0x8a, 0x05, 0x8f, 0x8f, 0xad, 0x3f, 0x92, 0x92, 0xbc, 0x21, 0x9d, 0x9d, 0x48, 0x70, 0x38,
    0x38, 0x04, 0xf1, 0xf5, 0xf5, 0xdf, 0x63, 0xbc, 0xbc, 0xc1, 0x77, 0xb6, 0xb6, 0x75, 0xaf, 0xda, 0xda, 0x63, 0x42,
    0x21, 0x21, 0x30, 0x20, 0x10, 0x10, 0x1a, 0xe5, 0xff, 0xff, 0x0e, 0xfd, 0xf3, 0xf3, 0x6d, 0xbf, 0xd2, 0xd2, 0x4c,
    0x81, 0xcd, 0xcd, 0x14, 0x18, 0x0c, 0x0c, 0x35, 0x26, 0x13, 0x13, 0x2f, 0xc3, 0xec, 0xec, 0xe1, 0xbe, 0x5f, 0x5f,
    0xa2, 0x35, 0x97, 0x97, 0xcc, 0x88, 0x44, 0x44, 0x39, 0x2e, 0x17, 0x17, 0x57, 0x93, 0xc4, 0xc4, 0xf2, 0x55, 0xa7,
    0xa7, 0x82, 0xfc, 0x7e, 0x7e, 0x47, 0x7a, 0x3d, 0x3d, 0xac, 0xc8, 0x64, 0x64, 0xe7, 0xba, 0x5d, 0x5d, 0x2b, 0x32,
    0x19, 0x19, 0x95, 0xe6, 0x73, 0x73, 0xa0, 0xc0, 0x60, 0x60, 0x98, 0x19, 0x81, 0x81, 0xd1, 0x9e, 0x4f, 0x4f, 0x7f,
    0xa3, 0xdc, 0xdc, 0x66, 0x44, 0x22, 0x22, 0x7e, 0x54, 0x2a, 0x2a, 0xab, 0x3b, 0x90, 0x90, 0x83, 0x0b, 0x88, 0x88,
    0xca, 0x8c, 0x46, 0x46, 0x29, 0xc7, 0xee, 0xee, 0xd3, 0x6b, 0xb8, 0xb8, 0x3c, 0x28, 0x14, 0x14, 0x79, 0xa7, 0xde,
    0xde, 0xe2, 0xbc, 0x5e, 0x5e, 0x1d, 0x16, 0x0b, 0x0b, 0x76, 0xad, 0xdb, 0xdb, 0x3b, 0xdb, 0xe0, 0xe0, 0x56, 0x64,
    0x32, 0x32, 0x4e, 0x74, 0x3a, 0x3a, 0x1e, 0x14, 0x0a, 0x0a, 0xdb, 0x92, 0x49, 0x49, 0x0a, 0x0c, 0x06, 0x06, 0x6c,
    0x48, 0x24, 0x24, 0xe4, 0xb8, 0x5c, 0x5c, 0x5d, 0x9f, 0xc2, 0xc2, 0x6e, 0xbd, 0xd3, 0xd3, 0xef, 0x43, 0xac, 0xac,
    0xa6, 0xc4, 0x62, 0x62, 0xa8, 0x39, 0x91, 0x91, 0xa4, 0x31, 0x95, 0x95, 0x37, 0xd3, 0xe4, 0xe4, 0x8b, 0xf2, 0x79,
    0x79, 0x32, 0xd5, 0xe7, 0xe7, 0x43, 0x8b, 0xc8, 0xc8, 0x59, 0x6e, 0x37, 0x37, 0xb7, 0xda, 0x6d, 0x6d, 0x8c, 0x01,
    0x8d, 0x8d, 0x64, 0xb1, 0xd5, 0xd5, 0xd2, 0x9c, 0x4e, 0x4e, 0xe0, 0x49, 0xa9, 0xa9, 0xb4, 0xd8, 0x6c, 0x6c, 0xfa,
    0xac, 0x56, 0x56, 0x07, 0xf3, 0xf4, 0xf4, 0x25, 0xcf, 0xea, 0xea, 0xaf, 0xca, 0x65, 0x65, 0x8e, 0xf4, 0x7a, 0x7a,
    0xe9, 0x47, 0xae, 0xae, 0x18, 0x10, 0x08, 0x08, 0xd5, 0x6f, 0xba, 0xba, 0x88, 0xf0, 0x78, 0x78, 0x6f, 0x4a, 0x25,
    0x25, 0x72, 0x5c, 0x2e, 0x2e, 0x24, 0x38, 0x1c, 0x1c, 0xf1, 0x57, 0xa6, 0xa6, 0xc7, 0x73, 0xb4, 0xb4, 0x51, 0x97,
    0xc6, 0xc6, 0x23, 0xcb, 0xe8, 0xe8, 0x7c, 0xa1, 0xdd, 0xdd, 0x9c, 0xe8, 0x74, 0x74, 0x21, 0x3e, 0x1f, 0x1f, 0xdd,
    0x96, 0x4b, 0x4b, 0xdc, 0x61, 0xbd, 0xbd, 0x86, 0x0d, 0x8b, 0x8b, 0x85, 0x0f, 0x8a, 0x8a, 0x90, 0xe0, 0x70, 0x70,
    0x42, 0x7c, 0x3e, 0x3e, 0xc4, 0x71, 0xb5, 0xb5, 0xaa, 0xcc, 0x66, 0x66, 0xd8, 0x90, 0x48, 0x48, 0x05, 0x06, 0x03,
    0x03, 0x01, 0xf7, 0xf6, 0xf6, 0x12, 0x1c, 0x0e, 0x0e, 0xa3, 0xc2, 0x61, 0x61, 0x5f, 0x6a, 0x35, 0x35, 0xf9, 0xae,
    0x57, 0x57, 0xd0, 0x69, 0xb9, 0xb9, 0x91, 0x17, 0x86, 0x86, 0x58, 0x99, 0xc1, 0xc1, 0x27, 0x3a, 0x1d, 0x1d, 0xb9,
    0x27, 0x9e, 0x9e, 0x38, 0xd9, 0xe1, 0xe1, 0x13, 0xeb, 0xf8, 0xf8, 0xb3, 0x2b, 0x98, 0x98, 0x33, 0x22, 0x11, 0x11,
    0xbb, 0xd2, 0x69, 0x69, 0x70, 0xa9, 0xd9, 0xd9, 0x89, 0x07, 0x8e, 0x8e, 0xa7, 0x33, 0x94, 0x94, 0xb6, 0x2d, 0x9b,
    0x9b, 0x22, 0x3c, 0x1e, 0x1e, 0x92, 0x15, 0x87, 0x87, 0x20, 0xc9, 0xe9, 0xe9, 0x49, 0x87, 0xce, 0xce, 0xff, 0xaa,
    0x55, 0x55, 0x78, 0x50, 0x28, 0x28, 0x7a, 0xa5, 0xdf, 0xdf, 0x8f, 0x03, 0x8c, 0x8c, 0xf8, 0x59, 0xa1, 0xa1, 0x80,
    0x09, 0x89, 0x89, 0x17, 0x1a, 0x0d, 0x0d, 0xda, 0x65, 0xbf, 0xbf, 0x31, 0xd7, 0xe6, 0xe6, 0xc6, 0x84, 0x42, 0x42,
    0xb8, 0xd0, 0x68, 0x68, 0xc3, 0x82, 0x41, 0x41, 0xb0, 0x29, 0x99, 0x99, 0x77, 0x5a, 0x2d, 0x2d, 0x11, 0x1e, 0x0f,
    0x0f, 0xcb, 0x7b, 0xb0, 0xb0, 0xfc, 0xa8, 0x54, 0x54, 0xd6, 0x6d, 0xbb, 0xbb, 0x3a, 0x2c, 0x16, 0x16
};

static uint8_t T3[256][4] = {
    0x63, 0xa5, 0xc6, 0x63, 0x7c, 0x84, 0xf8, 0x7c, 0x77, 0x99, 0xee, 0x77, 0x7b, 0x8d, 0xf6, 0x7b, 0xf2, 0x0d, 0xff,
    0xf2, 0x6b, 0xbd, 0xd6, 0x6b, 0x6f, 0xb1, 0xde, 0x6f, 0xc5, 0x54, 0x91, 0xc5, 0x30, 0x50, 0x60, 0x30, 0x01, 0x03,
    0x02, 0x01, 0x67, 0xa9, 0xce, 0x67, 0x2b, 0x7d, 0x56, 0x2b, 0xfe, 0x19, 0xe7, 0xfe, 0xd7, 0x62, 0xb5, 0xd7, 0xab,
    0xe6, 0x4d, 0xab, 0x76, 0x9a, 0xec, 0x76, 0xca, 0x45, 0x8f, 0xca, 0x82, 0x9d, 0x1f, 0x82, 0xc9, 0x40, 0x89, 0xc9,
    0x7d, 0x87, 0xfa, 0x7d, 0xfa, 0x15, 0xef, 0xfa, 0x59, 0xeb, 0xb2, 0x59, 0x47, 0xc9, 0x8e, 0x47, 0xf0, 0x0b, 0xfb,
    0xf0, 0xad, 0xec, 0x41, 0xad, 0xd4, 0x67, 0xb3, 0xd4, 0xa2, 0xfd, 0x5f, 0xa2, 0xaf, 0xea, 0x45, 0xaf, 0x9c, 0xbf,
    0x23, 0x9c, 0xa4, 0xf7, 0x53, 0xa4, 0x72, 0x96, 0xe4, 0x72, 0xc0, 0x5b, 0x9b, 0xc0, 0xb7, 0xc2, 0x75, 0xb7, 0xfd,
    0x1c, 0xe1, 0xfd, 0x93, 0xae, 0x3d, 0x93, 0x26, 0x6a, 0x4c, 0x26, 0x36, 0x5a, 0x6c, 0x36, 0x3f, 0x41, 0x7e, 0x3f,
    0xf7, 0x02, 0xf5, 0xf7, 0xcc, 0x4f, 0x83, 0xcc, 0x34, 0x5c, 0x68, 0x34, 0xa5, 0xf4, 0x51, 0xa5, 0xe5, 0x34, 0xd1,
    0xe5, 0xf1, 0x08, 0xf9, 0xf1, 0x71, 0x93, 0xe2, 0x71, 0xd8, 0x73, 0xab, 0xd8, 0x31, 0x53, 0x62, 0x31, 0x15, 0x3f,
    0x2a, 0x15, 0x04, 0x0c, 0x08, 0x04, 0xc7, 0x52, 0x95, 0xc7, 0x23, 0x65, 0x46, 0x23, 0xc3, 0x5e, 0x9d, 0xc3, 0x18,
    0x28, 0x30, 0x18, 0x96, 0xa1, 0x37, 0x96, 0x05, 0x0f, 0x0a, 0x05, 0x9a, 0xb5, 0x2f, 0x9a, 0x07, 0x09, 0x0e, 0x07,
    0x12, 0x36, 0x24, 0x12, 0x80, 0x9b, 0x1b, 0x80, 0xe2, 0x3d, 0xdf, 0xe2, 0xeb, 0x26, 0xcd, 0xeb, 0x27, 0x69, 0x4e,
    0x27, 0xb2, 0xcd, 0x7f, 0xb2, 0x75, 0x9f, 0xea, 0x75, 0x09, 0x1b, 0x12, 0x09, 0x83, 0x9e, 0x1d, 0x83, 0x2c, 0x74,
    0x58, 0x2c, 0x1a, 0x2e, 0x34, 0x1a, 0x1b, 0x2d, 0x36, 0x1b, 0x6e, 0xb2, 0xdc, 0x6e, 0x5a, 0xee, 0xb4, 0x5a, 0xa0,
    0xfb, 0x5b, 0xa0, 0x52, 0xf6, 0xa4, 0x52, 0x3b, 0x4d, 0x76, 0x3b, 0xd6, 0x61, 0xb7, 0xd6, 0xb3, 0xce, 0x7d, 0xb3,
    0x29, 0x7b, 0x52, 0x29, 0xe3, 0x3e, 0xdd, 0xe3, 0x2f, 0x71, 0x5e, 0x2f, 0x84, 0x97, 0x13, 0x84, 0x53, 0xf5, 0xa6,
    0x53, 0xd1, 0x68, 0xb9, 0xd1, 0x00, 0x00, 0x00, 0x00, 0xed, 0x2c, 0xc1, 0xed, 0x20, 0x60, 0x40, 0x20, 0xfc, 0x1f,
    0xe3, 0xfc, 0xb1, 0xc8, 0x79, 0xb1, 0x5b, 0xed, 0xb6, 0x5b, 0x6a, 0xbe, 0xd4, 0x6a, 0xcb, 0x46, 0x8d, 0xcb, 0xbe,
    0xd9, 0x67, 0xbe, 0x39, 0x4b, 0x72, 0x39, 0x4a, 0xde, 0x94, 0x4a, 0x4c, 0xd4, 0x98, 0x4c, 0x58, 0xe8, 0xb0, 0x58,
    0xcf, 0x4a, 0x85, 0xcf, 0xd0, 0x6b, 0xbb, 0xd0, 0xef, 0x2a, 0xc5, 0xef, 0xaa, 0xe5, 0x4f, 0xaa, 0xfb, 0x16, 0xed,
    0xfb, 0x43, 0xc5, 0x86, 0x43, 0x4d, 0xd7, 0x9a, 0x4d, 0x33, 0x55, 0x66, 0x33, 0x85, 0x94, 0x11, 0x85, 0x45, 0xcf,
    0x8a, 0x45, 0xf9, 0x10, 0xe9, 0xf9, 0x02, 0x06, 0x04, 0x02, 0x7f, 0x81, 0xfe, 0x7f, 0x50, 0xf0, 0xa0, 0x50, 0x3c,
    0x44, 0x78, 0x3c, 0x9f, 0xba, 0x25, 0x9f, 0xa8, 0xe3, 0x4b, 0xa8, 0x51, 0xf3, 0xa2, 0x51, 0xa3, 0xfe, 0x5d, 0xa3,
    0x40, 0xc0, 0x80, 0x40, 0x8f, 0x8a, 0x05, 0x8f, 0x92, 0xad, 0x3f, 0x92, 0x9d, 0xbc, 0x21, 0x9d, 0x38, 0x48, 0x70,
    0x38, 0xf5, 0x04, 0xf1, 0xf5, 0xbc, 0xdf, 0x63, 0xbc, 0xb6, 0xc1, 0x77, 0xb6, 0xda, 0x75, 0xaf, 0xda, 0x21, 0x63,
    0x42, 0x21, 0x10, 0x30, 0x20, 0x10, 0xff, 0x1a, 0xe5, 0xff, 0xf3, 0x0e, 0xfd, 0xf3, 0xd2, 0x6d, 0xbf, 0xd2, 0xcd,
    0x4c, 0x81, 0xcd, 0x0c, 0x14, 0x18, 0x0c, 0x13, 0x35, 0x26, 0x13, 0xec, 0x2f, 0xc3, 0xec, 0x5f, 0xe1, 0xbe, 0x5f,
    0x97, 0xa2, 0x35, 0x97, 0x44, 0xcc, 0x88, 0x44, 0x17, 0x39, 0x2e, 0x17, 0xc4, 0x57, 0x93, 0xc4, 0xa7, 0xf2, 0x55,
    0xa7, 0x7e, 0x82, 0xfc, 0x7e, 0x3d, 0x47, 0x7a, 0x3d, 0x64, 0xac, 0xc8, 0x64, 0x5d, 0xe7, 0xba, 0x5d, 0x19, 0x2b,
    0x32, 0x19, 0x73, 0x95, 0xe6, 0x73, 0x60, 0xa0, 0xc0, 0x60, 0x81, 0x98, 0x19, 0x81, 0x4f, 0xd1, 0x9e, 0x4f, 0xdc,
    0x7f, 0xa3, 0xdc, 0x22, 0x66, 0x44, 0x22, 0x2a, 0x7e, 0x54, 0x2a, 0x90, 0xab, 0x3b, 0x90, 0x88, 0x83, 0x0b, 0x88,
    0x46, 0xca, 0x8c, 0x46, 0xee, 0x29, 0xc7, 0xee, 0xb8, 0xd3, 0x6b, 0xb8, 0x14, 0x3c, 0x28, 0x14, 0xde, 0x79, 0xa7,
    0xde, 0x5e, 0xe2, 0xbc, 0x5e, 0x0b, 0x1d, 0x16, 0x0b, 0xdb, 0x76, 0xad, 0xdb, 0xe0, 0x3b, 0xdb, 0xe0, 0x32, 0x56,
    0x64, 0x32, 0x3a, 0x4e, 0x74, 0x3a, 0x0a, 0x1e, 0x14, 0x0a, 0x49, 0xdb, 0x92, 0x49, 0x06, 0x0a, 0x0c, 0x06, 0x24,
    0x6c, 0x48, 0x24, 0x5c, 0xe4, 0xb8, 0x5c, 0xc2, 0x5d, 0x9f, 0xc2, 0xd3, 0x6e, 0xbd, 0xd3, 0xac, 0xef, 0x43, 0xac,
    0x62, 0xa6, 0xc4, 0x62, 0x91, 0xa8, 0x39, 0x91, 0x95, 0xa4, 0x31, 0x95, 0xe4, 0x37, 0xd3, 0xe4, 0x79, 0x8b, 0xf2,
    0x79, 0xe7, 0x32, 0xd5, 0xe7, 0xc8, 0x43, 0x8b, 0xc8, 0x37, 0x59, 0x6e, 0x37, 0x6d, 0xb7, 0xda, 0x6d, 0x8d, 0x8c,
    0x01, 0x8d, 0xd5, 0x64, 0xb1, 0xd5, 0x4e, 0xd2, 0x9c, 0x4e, 0xa9, 0xe0, 0x49, 0xa9, 0x6c, 0xb4, 0xd8, 0x6c, 0x56,
    0xfa, 0xac, 0x56, 0xf4, 0x07, 0xf3, 0xf4, 0xea, 0x25, 0xcf, 0xea, 0x65, 0xaf, 0xca, 0x65, 0x7a, 0x8e, 0xf4, 0x7a,
    0xae, 0xe9, 0x47, 0xae, 0x08, 0x18, 0x10, 0x08, 0xba, 0xd5, 0x6f, 0xba, 0x78, 0x88, 0xf0, 0x78, 0x25, 0x6f, 0x4a,
    0x25, 0x2e, 0x72, 0x5c, 0x2e, 0x1c, 0x24, 0x38, 0x1c, 0xa6, 0xf1, 0x57, 0xa6, 0xb4, 0xc7, 0x73, 0xb4, 0xc6, 0x51,
    0x97, 0xc6, 0xe8, 0x23, 0xcb, 0xe8, 0xdd, 0x7c, 0xa1, 0xdd, 0x74, 0x9c, 0xe8, 0x74, 0x1f, 0x21, 0x3e, 0x1f, 0x4b,
    0xdd, 0x96, 0x4b, 0xbd, 0xdc, 0x61, 0xbd, 0x8b, 0x86, 0x0d, 0x8b, 0x8a, 0x85, 0x0f, 0x8a, 0x70, 0x90, 0xe0, 0x70,
    0x3e, 0x42, 0x7c, 0x3e, 0xb5, 0xc4, 0x71, 0xb5, 0x66, 0xaa, 0xcc, 0x66, 0x48, 0xd8, 0x90, 0x48, 0x03, 0x05, 0x06,
    0x03, 0xf6, 0x01, 0xf7, 0xf6, 0x0e, 0x12, 0x1c, 0x0e, 0x61, 0xa3, 0xc2, 0x61, 0x35, 0x5f, 0x6a, 0x35, 0x57, 0xf9,
    0xae, 0x57, 0xb9, 0xd0, 0x69, 0xb9, 0x86, 0x91, 0x17, 0x86, 0xc1, 0x58, 0x99, 0xc1, 0x1d, 0x27, 0x3a, 0x1d, 0x9e,
    0xb9, 0x27, 0x9e, 0xe1, 0x38, 0xd9, 0xe1, 0xf8, 0x13, 0xeb, 0xf8, 0x98, 0xb3, 0x2b, 0x98, 0x11, 0x33, 0x22, 0x11,
    0x69, 0xbb, 0xd2, 0x69, 0xd9, 0x70, 0xa9, 0xd9, 0x8e, 0x89, 0x07, 0x8e, 0x94, 0xa7, 0x33, 0x94, 0x9b, 0xb6, 0x2d,
    0x9b, 0x1e, 0x22, 0x3c, 0x1e, 0x87, 0x92, 0x15, 0x87, 0xe9, 0x20, 0xc9, 0xe9, 0xce, 0x49, 0x87, 0xce, 0x55, 0xff,
    0xaa, 0x55, 0x28, 0x78, 0x50, 0x28, 0xdf, 0x7a, 0xa5, 0xdf, 0x8c, 0x8f, 0x03, 0x8c, 0xa1, 0xf8, 0x59, 0xa1, 0x89,
    0x80, 0x09, 0x89, 0x0d, 0x17, 0x1a, 0x0d, 0xbf, 0xda, 0x65, 0xbf, 0xe6, 0x31, 0xd7, 0xe6, 0x42, 0xc6, 0x84, 0x42,
    0x68, 0xb8, 0xd0, 0x68, 0x41, 0xc3, 0x82, 0x41, 0x99, 0xb0, 0x29, 0x99, 0x2d, 0x77, 0x5a, 0x2d, 0x0f, 0x11, 0x1e,
    0x0f, 0xb0, 0xcb, 0x7b, 0xb0, 0x54, 0xfc, 0xa8, 0x54, 0xbb, 0xd6, 0x6d, 0xbb, 0x16, 0x3a, 0x2c, 0x16
};

static uint8_t T4[256][4] = {
    0x63, 0x63, 0xa5, 0xc6, 0x7c, 0x7c, 0x84, 0xf8, 0x77, 0x77, 0x99, 0xee, 0x7b, 0x7b, 0x8d, 0xf6, 0xf2, 0xf2, 0x0d,
    0xff, 0x6b, 0x6b, 0xbd, 0xd6, 0x6f, 0x6f, 0xb1, 0xde, 0xc5, 0xc5, 0x54, 0x91, 0x30, 0x30, 0x50, 0x60, 0x01, 0x01,
    0x03, 0x02, 0x67, 0x67, 0xa9, 0xce, 0x2b, 0x2b, 0x7d, 0x56, 0xfe, 0xfe, 0x19, 0xe7, 0xd7, 0xd7, 0x62, 0xb5, 0xab,
    0xab, 0xe6, 0x4d, 0x76, 0x76, 0x9a, 0xec, 0xca, 0xca, 0x45, 0x8f, 0x82, 0x82, 0x9d, 0x1f, 0xc9, 0xc9, 0x40, 0x89,
    0x7d, 0x7d, 0x87, 0xfa, 0xfa, 0xfa, 0x15, 0xef, 0x59, 0x59, 0xeb, 0xb2, 0x47, 0x47, 0xc9, 0x8e, 0xf0, 0xf0, 0x0b,
    0xfb, 0xad, 0xad, 0xec, 0x41, 0xd4, 0xd4, 0x67, 0xb3, 0xa2, 0xa2, 0xfd, 0x5f, 0xaf, 0xaf, 0xea, 0x45, 0x9c, 0x9c,
    0xbf, 0x23, 0xa4, 0xa4, 0xf7, 0x53, 0x72, 0x72, 0x96, 0xe4, 0xc0, 0xc0, 0x5b, 0x9b, 0xb7, 0xb7, 0xc2, 0x75, 0xfd,
    0xfd, 0x1c, 0xe1, 0x93, 0x93, 0xae, 0x3d, 0x26, 0x26, 0x6a, 0x4c, 0x36, 0x36, 0x5a, 0x6c, 0x3f, 0x3f, 0x41, 0x7e,
    0xf7, 0xf7, 0x02, 0xf5, 0xcc, 0xcc, 0x4f, 0x83, 0x34, 0x34, 0x5c, 0x68, 0xa5, 0xa5, 0xf4, 0x51, 0xe5, 0xe5, 0x34,
    0xd1, 0xf1, 0xf1, 0x08, 0xf9, 0x71, 0x71, 0x93, 0xe2, 0xd8, 0xd8, 0x73, 0xab, 0x31, 0x31, 0x53, 0x62, 0x15, 0x15,
    0x3f, 0x2a, 0x04, 0x04, 0x0c, 0x08, 0xc7, 0xc7, 0x52, 0x95, 0x23, 0x23, 0x65, 0x46, 0xc3, 0xc3, 0x5e, 0x9d, 0x18,
    0x18, 0x28, 0x30, 0x96, 0x96, 0xa1, 0x37, 0x05, 0x05, 0x0f, 0x0a, 0x9a, 0x9a, 0xb5, 0x2f, 0x07, 0x07, 0x09, 0x0e,
    0x12, 0x12, 0x36, 0x24, 0x80, 0x80, 0x9b, 0x1b, 0xe2, 0xe2, 0x3d, 0xdf, 0xeb, 0xeb, 0x26, 0xcd, 0x27, 0x27, 0x69,
    0x4e, 0xb2, 0xb2, 0xcd, 0x7f, 0x75, 0x75, 0x9f, 0xea, 0x09, 0x09, 0x1b, 0x12, 0x83, 0x83, 0x9e, 0x1d, 0x2c, 0x2c,
    0x74, 0x58, 0x1a, 0x1a, 0x2e, 0x34, 0x1b, 0x1b, 0x2d, 0x36, 0x6e, 0x6e, 0xb2, 0xdc, 0x5a, 0x5a, 0xee, 0xb4, 0xa0,
    0xa0, 0xfb, 0x5b, 0x52, 0x52, 0xf6, 0xa4, 0x3b, 0x3b, 0x4d, 0x76, 0xd6, 0xd6, 0x61, 0xb7, 0xb3, 0xb3, 0xce, 0x7d,
    0x29, 0x29, 0x7b, 0x52, 0xe3, 0xe3, 0x3e, 0xdd, 0x2f, 0x2f, 0x71, 0x5e, 0x84, 0x84, 0x97, 0x13, 0x53, 0x53, 0xf5,
    0xa6, 0xd1, 0xd1, 0x68, 0xb9, 0x00, 0x00, 0x00, 0x00, 0xed, 0xed, 0x2c, 0xc1, 0x20, 0x20, 0x60, 0x40, 0xfc, 0xfc,
    0x1f, 0xe3, 0xb1, 0xb1, 0xc8, 0x79, 0x5b, 0x5b, 0xed, 0xb6, 0x6a, 0x6a, 0xbe, 0xd4, 0xcb, 0xcb, 0x46, 0x8d, 0xbe,
    0xbe, 0xd9, 0x67, 0x39, 0x39, 0x4b, 0x72, 0x4a, 0x4a, 0xde, 0x94, 0x4c, 0x4c, 0xd4, 0x98, 0x58, 0x58, 0xe8, 0xb0,
    0xcf, 0xcf, 0x4a, 0x85, 0xd0, 0xd0, 0x6b, 0xbb, 0xef, 0xef, 0x2a, 0xc5, 0xaa, 0xaa, 0xe5, 0x4f, 0xfb, 0xfb, 0x16,
    0xed, 0x43, 0x43, 0xc5, 0x86, 0x4d, 0x4d, 0xd7, 0x9a, 0x33, 0x33, 0x55, 0x66, 0x85, 0x85, 0x94, 0x11, 0x45, 0x45,
    0xcf, 0x8a, 0xf9, 0xf9, 0x10, 0xe9, 0x02, 0x02, 0x06, 0x04, 0x7f, 0x7f, 0x81, 0xfe, 0x50, 0x50, 0xf0, 0xa0, 0x3c,
    0x3c, 0x44, 0x78, 0x9f, 0x9f, 0xba, 0x25, 0xa8, 0xa8, 0xe3, 0x4b, 0x51, 0x51, 0xf3, 0xa2, 0xa3, 0xa3, 0xfe, 0x5d,
    0x40, 0x40, 0xc0, 0x80, 0x8f, 0x8f, 0x8a, 0x05, 0x92, 0x92, 0xad, 0x3f, 0x9d, 0x9d, 0xbc, 0x21, 0x38, 0x38, 0x48,
    0x70, 0xf5, 0xf5, 0x04, 0xf1, 0xbc, 0xbc, 0xdf, 0x63, 0xb6, 0xb6, 0xc1, 0x77, 0xda, 0xda, 0x75, 0xaf, 0x21, 0x21,
    0x63, 0x42, 0x10, 0x10, 0x30, 0x20, 0xff, 0xff, 0x1a, 0xe5, 0xf3, 0xf3, 0x0e, 0xfd, 0xd2, 0xd2, 0x6d, 0xbf, 0xcd,
    0xcd, 0x4c, 0x81, 0x0c, 0x0c, 0x14, 0x18, 0x13, 0x13, 0x35, 0x26, 0xec, 0xec, 0x2f, 0xc3, 0x5f, 0x5f, 0xe1, 0xbe,
    0x97, 0x97, 0xa2, 0x35, 0x44, 0x44, 0xcc, 0x88, 0x17, 0x17, 0x39, 0x2e, 0xc4, 0xc4, 0x57, 0x93, 0xa7, 0xa7, 0xf2,
    0x55, 0x7e, 0x7e, 0x82, 0xfc, 0x3d, 0x3d, 0x47, 0x7a, 0x64, 0x64, 0xac, 0xc8, 0x5d, 0x5d, 0xe7, 0xba, 0x19, 0x19,
    0x2b, 0x32, 0x73, 0x73, 0x95, 0xe6, 0x60, 0x60, 0xa0, 0xc0, 0x81, 0x81, 0x98, 0x19, 0x4f, 0x4f, 0xd1, 0x9e, 0xdc,
    0xdc, 0x7f, 0xa3, 0x22, 0x22, 0x66, 0x44, 0x2a, 0x2a, 0x7e, 0x54, 0x90, 0x90, 0xab, 0x3b, 0x88, 0x88, 0x83, 0x0b,
    0x46, 0x46, 0xca, 0x8c, 0xee, 0xee, 0x29, 0xc7, 0xb8, 0xb8, 0xd3, 0x6b, 0x14, 0x14, 0x3c, 0x28, 0xde, 0xde, 0x79,
    0xa7, 0x5e, 0x5e, 0xe2, 0xbc, 0x0b, 0x0b, 0x1d, 0x16, 0xdb, 0xdb, 0x76, 0xad, 0xe0, 0xe0, 0x3b, 0xdb, 0x32, 0x32,
    0x56, 0x64, 0x3a, 0x3a, 0x4e, 0x74, 0x0a, 0x0a, 0x1e, 0x14, 0x49, 0x49, 0xdb, 0x92, 0x06, 0x06, 0x0a, 0x0c, 0x24,
    0x24, 0x6c, 0x48, 0x5c, 0x5c, 0xe4, 0xb8, 0xc2, 0xc2, 0x5d, 0x9f, 0xd3, 0xd3, 0x6e, 0xbd, 0xac, 0xac, 0xef, 0x43,
    0x62, 0x62, 0xa6, 0xc4, 0x91, 0x91, 0xa8, 0x39, 0x95, 0x95, 0xa4, 0x31, 0xe4, 0xe4, 0x37, 0xd3, 0x79, 0x79, 0x8b,
    0xf2, 0xe7, 0xe7, 0x32, 0xd5, 0xc8, 0xc8, 0x43, 0x8b, 0x37, 0x37, 0x59, 0x6e, 0x6d, 0x6d, 0xb7, 0xda, 0x8d, 0x8d,
    0x8c, 0x01, 0xd5, 0xd5, 0x64, 0xb1, 0x4e, 0x4e, 0xd2, 0x9c, 0xa9, 0xa9, 0xe0, 0x49, 0x6c, 0x6c, 0xb4, 0xd8, 0x56,
    0x56, 0xfa, 0xac, 0xf4, 0xf4, 0x07, 0xf3, 0xea, 0xea, 0x25, 0xcf, 0x65, 0x65, 0xaf, 0xca, 0x7a, 0x7a, 0x8e, 0xf4,
    0xae, 0xae, 0xe9, 0x47, 0x08, 0x08, 0x18, 0x10, 0xba, 0xba, 0xd5, 0x6f, 0x78, 0x78, 0x88, 0xf0, 0x25, 0x25, 0x6f,
    0x4a, 0x2e, 0x2e, 0x72, 0x5c, 0x1c, 0x1c, 0x24, 0x38, 0xa6, 0xa6, 0xf1, 0x57, 0xb4, 0xb4, 0xc7, 0x73, 0xc6, 0xc6,
    0x51, 0x97, 0xe8, 0xe8, 0x23, 0xcb, 0xdd, 0xdd, 0x7c, 0xa1, 0x74, 0x74, 0x9c, 0xe8, 0x1f, 0x1f, 0x21, 0x3e, 0x4b,
    0x4b, 0xdd, 0x96, 0xbd, 0xbd, 0xdc, 0x61, 0x8b, 0x8b, 0x86, 0x0d, 0x8a, 0x8a, 0x85, 0x0f, 0x70, 0x70, 0x90, 0xe0,
    0x3e, 0x3e, 0x42, 0x7c, 0xb5, 0xb5, 0xc4, 0x71, 0x66, 0x66, 0xaa, 0xcc, 0x48, 0x48, 0xd8, 0x90, 0x03, 0x03, 0x05,
    0x06, 0xf6, 0xf6, 0x01, 0xf7, 0x0e, 0x0e, 0x12, 0x1c, 0x61, 0x61, 0xa3, 0xc2, 0x35, 0x35, 0x5f, 0x6a, 0x57, 0x57,
    0xf9, 0xae, 0xb9, 0xb9, 0xd0, 0x69, 0x86, 0x86, 0x91, 0x17, 0xc1, 0xc1, 0x58, 0x99, 0x1d, 0x1d, 0x27, 0x3a, 0x9e,
    0x9e, 0xb9, 0x27, 0xe1, 0xe1, 0x38, 0xd9, 0xf8, 0xf8, 0x13, 0xeb, 0x98, 0x98, 0xb3, 0x2b, 0x11, 0x11, 0x33, 0x22,
    0x69, 0x69, 0xbb, 0xd2, 0xd9, 0xd9, 0x70, 0xa9, 0x8e, 0x8e, 0x89, 0x07, 0x94, 0x94, 0xa7, 0x33, 0x9b, 0x9b, 0xb6,
    0x2d, 0x1e, 0x1e, 0x22, 0x3c, 0x87, 0x87, 0x92, 0x15, 0xe9, 0xe9, 0x20, 0xc9, 0xce, 0xce, 0x49, 0x87, 0x55, 0x55,
    0xff, 0xaa, 0x28, 0x28, 0x78, 0x50, 0xdf, 0xdf, 0x7a, 0xa5, 0x8c, 0x8c, 0x8f, 0x03, 0xa1, 0xa1, 0xf8, 0x59, 0x89,
    0x89, 0x80, 0x09, 0x0d, 0x0d, 0x17, 0x1a, 0xbf, 0xbf, 0xda, 0x65, 0xe6, 0xe6, 0x31, 0xd7, 0x42, 0x42, 0xc6, 0x84,
    0x68, 0x68, 0xb8, 0xd0, 0x41, 0x41, 0xc3, 0x82, 0x99, 0x99, 0xb0, 0x29, 0x2d, 0x2d, 0x77, 0x5a, 0x0f, 0x0f, 0x11,
    0x1e, 0xb0, 0xb0, 0xcb, 0x7b, 0x54, 0x54, 0xfc, 0xa8, 0xbb, 0xbb, 0xd6, 0x6d, 0x16, 0x16, 0x3a, 0x2c
};

static uint8_t T5[256][4] = {
    0x51, 0xf4, 0xa7, 0x50, 0x7e, 0x41, 0x65, 0x53, 0x1a, 0x17, 0xa4, 0xc3, 0x3a, 0x27, 0x5e, 0x96, 0x3b, 0xab, 0x6b,
    0xcb, 0x1f, 0x9d, 0x45, 0xf1, 0xac, 0xfa, 0x58, 0xab, 0x4b, 0xe3, 0x03, 0x93, 0x20, 0x30, 0xfa, 0x55, 0xad, 0x76,
    0x6d, 0xf6, 0x88, 0xcc, 0x76, 0x91, 0xf5, 0x02, 0x4c, 0x25, 0x4f, 0xe5, 0xd7, 0xfc, 0xc5, 0x2a, 0xcb, 0xd7, 0x26,
    0x35, 0x44, 0x80, 0xb5, 0x62, 0xa3, 0x8f, 0xde, 0xb1, 0x5a, 0x49, 0x25, 0xba, 0x1b, 0x67, 0x45, 0xea, 0x0e, 0x98,
    0x5d, 0xfe, 0xc0, 0xe1, 0xc3, 0x2f, 0x75, 0x02, 0x81, 0x4c, 0xf0, 0x12, 0x8d, 0x46, 0x97, 0xa3, 0x6b, 0xd3, 0xf9,
    0xc6, 0x03, 0x8f, 0x5f, 0xe7, 0x15, 0x92, 0x9c, 0x95, 0xbf, 0x6d, 0x7a, 0xeb, 0x95, 0x52, 0x59, 0xda, 0xd4, 0xbe,
    0x83, 0x2d, 0x58, 0x74, 0x21, 0xd3, 0x49, 0xe0, 0x69, 0x29, 0x8e, 0xc9, 0xc8, 0x44, 0x75, 0xc2, 0x89, 0x6a, 0xf4,
    0x8e, 0x79, 0x78, 0x99, 0x58, 0x3e, 0x6b, 0x27, 0xb9, 0x71, 0xdd, 0xbe, 0xe1, 0x4f, 0xb6, 0xf0, 0x88, 0xad, 0x17,
    0xc9, 0x20, 0xac, 0x66, 0x7d, 0xce, 0x3a, 0xb4, 0x63, 0xdf, 0x4a, 0x18, 0xe5, 0x1a, 0x31, 0x82, 0x97, 0x51, 0x33,
    0x60, 0x62, 0x53, 0x7f, 0x45, 0xb1, 0x64, 0x77, 0xe0, 0xbb, 0x6b, 0xae, 0x84, 0xfe, 0x81, 0xa0, 0x1c, 0xf9, 0x08,
    0x2b, 0x94, 0x70, 0x48, 0x68, 0x58, 0x8f, 0x45, 0xfd, 0x19, 0x94, 0xde, 0x6c, 0x87, 0x52, 0x7b, 0xf8, 0xb7, 0xab,
    0x73, 0xd3, 0x23, 0x72, 0x4b, 0x02, 0xe2, 0xe3, 0x1f, 0x8f, 0x57, 0x66, 0x55, 0xab, 0x2a, 0xb2, 0xeb, 0x28, 0x07,
    0x2f, 0xb5, 0xc2, 0x03, 0x86, 0xc5, 0x7b, 0x9a, 0xd3, 0x37, 0x08, 0xa5, 0x30, 0x28, 0x87, 0xf2, 0x23, 0xbf, 0xa5,
    0xb2, 0x02, 0x03, 0x6a, 0xba, 0xed, 0x16, 0x82, 0x5c, 0x8a, 0xcf, 0x1c, 0x2b, 0xa7, 0x79, 0xb4, 0x92, 0xf3, 0x07,
    0xf2, 0xf0, 0x4e, 0x69, 0xe2, 0xa1, 0x65, 0xda, 0xf4, 0xcd, 0x06, 0x05, 0xbe, 0xd5, 0xd1, 0x34, 0x62, 0x1f, 0xc4,
    0xa6, 0xfe, 0x8a, 0x34, 0x2e, 0x53, 0x9d, 0xa2, 0xf3, 0x55, 0xa0, 0x05, 0x8a, 0xe1, 0x32, 0xa4, 0xf6, 0xeb, 0x75,
    0x0b, 0x83, 0xec, 0x39, 0x40, 0x60, 0xef, 0xaa, 0x5e, 0x71, 0x9f, 0x06, 0xbd, 0x6e, 0x10, 0x51, 0x3e, 0x21, 0x8a,
    0xf9, 0x96, 0xdd, 0x06, 0x3d, 0xdd, 0x3e, 0x05, 0xae, 0x4d, 0xe6, 0xbd, 0x46, 0x91, 0x54, 0x8d, 0xb5, 0x71, 0xc4,
    0x5d, 0x05, 0x04, 0x06, 0xd4, 0x6f, 0x60, 0x50, 0x15, 0xff, 0x19, 0x98, 0xfb, 0x24, 0xd6, 0xbd, 0xe9, 0x97, 0x89,
    0x40, 0x43, 0xcc, 0x67, 0xd9, 0x9e, 0x77, 0xb0, 0xe8, 0x42, 0xbd, 0x07, 0x89, 0x8b, 0x88, 0xe7, 0x19, 0x5b, 0x38,
    0x79, 0xc8, 0xee, 0xdb, 0xa1, 0x7c, 0x0a, 0x47, 0x7c, 0x42, 0x0f, 0xe9, 0xf8, 0x84, 0x1e, 0xc9, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x80, 0x86, 0x83, 0x32, 0x2b, 0xed, 0x48, 0x1e, 0x11, 0x70, 0xac, 0x6c, 0x5a, 0x72, 0x4e, 0xfd, 0x0e,
    0xff, 0xfb, 0x0f, 0x85, 0x38, 0x56, 0x3d, 0xae, 0xd5, 0x1e, 0x36, 0x2d, 0x39, 0x27, 0x0a, 0x0f, 0xd9, 0x64, 0x68,
    0x5c, 0xa6, 0x21, 0x9b, 0x5b, 0x54, 0xd1, 0x24, 0x36, 0x2e, 0x3a, 0x0c, 0x0a, 0x67, 0xb1, 0x93, 0x57, 0xe7, 0x0f,
    0xb4, 0xee, 0x96, 0xd2, 0x1b, 0x9b, 0x91, 0x9e, 0x80, 0xc0, 0xc5, 0x4f, 0x61, 0xdc, 0x20, 0xa2, 0x5a, 0x77, 0x4b,
    0x69, 0x1c, 0x12, 0x1a, 0x16, 0xe2, 0x93, 0xba, 0x0a, 0xc0, 0xa0, 0x2a, 0xe5, 0x3c, 0x22, 0xe0, 0x43, 0x12, 0x1b,
    0x17, 0x1d, 0x0e, 0x09, 0x0d, 0x0b, 0xf2, 0x8b, 0xc7, 0xad, 0x2d, 0xb6, 0xa8, 0xb9, 0x14, 0x1e, 0xa9, 0xc8, 0x57,
    0xf1, 0x19, 0x85, 0xaf, 0x75, 0x07, 0x4c, 0xee, 0x99, 0xdd, 0xbb, 0xa3, 0x7f, 0x60, 0xfd, 0xf7, 0x01, 0x26, 0x9f,
    0x5c, 0x72, 0xf5, 0xbc, 0x44, 0x66, 0x3b, 0xc5, 0x5b, 0xfb, 0x7e, 0x34, 0x8b, 0x43, 0x29, 0x76, 0xcb, 0x23, 0xc6,
    0xdc, 0xb6, 0xed, 0xfc, 0x68, 0xb8, 0xe4, 0xf1, 0x63, 0xd7, 0x31, 0xdc, 0xca, 0x42, 0x63, 0x85, 0x10, 0x13, 0x97,
    0x22, 0x40, 0x84, 0xc6, 0x11, 0x20, 0x85, 0x4a, 0x24, 0x7d, 0xd2, 0xbb, 0x3d, 0xf8, 0xae, 0xf9, 0x32, 0x11, 0xc7,
    0x29, 0xa1, 0x6d, 0x1d, 0x9e, 0x2f, 0x4b, 0xdc, 0xb2, 0x30, 0xf3, 0x0d, 0x86, 0x52, 0xec, 0x77, 0xc1, 0xe3, 0xd0,
    0x2b, 0xb3, 0x16, 0x6c, 0xa9, 0x70, 0xb9, 0x99, 0x11, 0x94, 0x48, 0xfa, 0x47, 0xe9, 0x64, 0x22, 0xa8, 0xfc, 0x8c,
    0xc4, 0xa0, 0xf0, 0x3f, 0x1a, 0x56, 0x7d, 0x2c, 0xd8, 0x22, 0x33, 0x90, 0xef, 0x87, 0x49, 0x4e, 0xc7, 0xd9, 0x38,
    0xd1, 0xc1, 0x8c, 0xca, 0xa2, 0xfe, 0x98, 0xd4, 0x0b, 0x36, 0xa6, 0xf5, 0x81, 0xcf, 0xa5, 0x7a, 0xde, 0x28, 0xda,
    0xb7, 0x8e, 0x26, 0x3f, 0xad, 0xbf, 0xa4, 0x2c, 0x3a, 0x9d, 0xe4, 0x50, 0x78, 0x92, 0x0d, 0x6a, 0x5f, 0xcc, 0x9b,
    0x54, 0x7e, 0x46, 0x62, 0xf6, 0x8d, 0x13, 0xc2, 0x90, 0xd8, 0xb8, 0xe8, 0x2e, 0x39, 0xf7, 0x5e, 0x82, 0xc3, 0xaf,
    0xf5, 0x9f, 0x5d, 0x80, 0xbe, 0x69, 0xd0, 0x93, 0x7c, 0x6f, 0xd5, 0x2d, 0xa9, 0xcf, 0x25, 0x12, 0xb3, 0xc8, 0xac,
    0x99, 0x3b, 0x10, 0x18, 0x7d, 0xa7, 0xe8, 0x9c, 0x63, 0x6e, 0xdb, 0x3b, 0xbb, 0x7b, 0xcd, 0x26, 0x78, 0x09, 0x6e,
    0x59, 0x18, 0xf4, 0xec, 0x9a, 0xb7, 0x01, 0x83, 0x4f, 0x9a, 0xa8, 0xe6, 0x95, 0x6e, 0x65, 0xaa, 0xff, 0xe6, 0x7e,
    0x21, 0xbc, 0xcf, 0x08, 0xef, 0x15, 0xe8, 0xe6, 0xba, 0xe7, 0x9b, 0xd9, 0x4a, 0x6f, 0x36, 0xce, 0xea, 0x9f, 0x09,
    0xd4, 0x29, 0xb0, 0x7c, 0xd6, 0x31, 0xa4, 0xb2, 0xaf, 0x2a, 0x3f, 0x23, 0x31, 0xc6, 0xa5, 0x94, 0x30, 0x35, 0xa2,
    0x66, 0xc0, 0x74, 0x4e, 0xbc, 0x37, 0xfc, 0x82, 0xca, 0xa6, 0xe0, 0x90, 0xd0, 0xb0, 0x33, 0xa7, 0xd8, 0x15, 0xf1,
    0x04, 0x98, 0x4a, 0x41, 0xec, 0xda, 0xf7, 0x7f, 0xcd, 0x50, 0x0e, 0x17, 0x91, 0xf6, 0x2f, 0x76, 0x4d, 0xd6, 0x8d,
    0x43, 0xef, 0xb0, 0x4d, 0xcc, 0xaa, 0x4d, 0x54, 0xe4, 0x96, 0x04, 0xdf, 0x9e, 0xd1, 0xb5, 0xe3, 0x4c, 0x6a, 0x88,
    0x1b, 0xc1, 0x2c, 0x1f, 0xb8, 0x46, 0x65, 0x51, 0x7f, 0x9d, 0x5e, 0xea, 0x04, 0x01, 0x8c, 0x35, 0x5d, 0xfa, 0x87,
    0x74, 0x73, 0xfb, 0x0b, 0x41, 0x2e, 0xb3, 0x67, 0x1d, 0x5a, 0x92, 0xdb, 0xd2, 0x52, 0xe9, 0x10, 0x56, 0x33, 0x6d,
    0xd6, 0x47, 0x13, 0x9a, 0xd7, 0x61, 0x8c, 0x37, 0xa1, 0x0c, 0x7a, 0x59, 0xf8, 0x14, 0x8e, 0xeb, 0x13, 0x3c, 0x89,
    0xce, 0xa9, 0x27, 0xee, 0xb7, 0x61, 0xc9, 0x35, 0xe1, 0x1c, 0xe5, 0xed, 0x7a, 0x47, 0xb1, 0x3c, 0x9c, 0xd2, 0xdf,
    0x59, 0x55, 0xf2, 0x73, 0x3f, 0x18, 0x14, 0xce, 0x79, 0x73, 0xc7, 0x37, 0xbf, 0x53, 0xf7, 0xcd, 0xea, 0x5f, 0xfd,
    0xaa, 0x5b, 0xdf, 0x3d, 0x6f, 0x14, 0x78, 0x44, 0xdb, 0x86, 0xca, 0xaf, 0xf3, 0x81, 0xb9, 0x68, 0xc4, 0x3e, 0x38,
    0x24, 0x34, 0x2c, 0xc2, 0xa3, 0x40, 0x5f, 0x16, 0x1d, 0xc3, 0x72, 0xbc, 0xe2, 0x25, 0x0c, 0x28, 0x3c, 0x49, 0x8b,
    0xff, 0x0d, 0x95, 0x41, 0x39, 0xa8, 0x01, 0x71, 0x08, 0x0c, 0xb3, 0xde, 0xd8, 0xb4, 0xe4, 0x9c, 0x64, 0x56, 0xc1,
    0x90, 0x7b, 0xcb, 0x84, 0x61, 0xd5, 0x32, 0xb6, 0x70, 0x48, 0x6c, 0x5c, 0x74, 0xd0, 0xb8, 0x57, 0x42
};

static uint8_t T6[256][4] = {
    0x50, 0x51, 0xf4, 0xa7, 0x53, 0x7e, 0x41, 0x65, 0xc3, 0x1a, 0x17, 0xa4, 0x96, 0x3a, 0x27, 0x5e, 0xcb, 0x3b, 0xab,
    0x6b, 0xf1, 0x1f, 0x9d, 0x45, 0xab, 0xac, 0xfa, 0x58, 0x93, 0x4b, 0xe3, 0x03, 0x55, 0x20, 0x30, 0xfa, 0xf6, 0xad,
    0x76, 0x6d, 0x91, 0x88, 0xcc, 0x76, 0x25, 0xf5, 0x02, 0x4c, 0xfc, 0x4f, 0xe5, 0xd7, 0xd7, 0xc5, 0x2a, 0xcb, 0x80,
    0x26, 0x35, 0x44, 0x8f, 0xb5, 0x62, 0xa3, 0x49, 0xde, 0xb1, 0x5a, 0x67, 0x25, 0xba, 0x1b, 0x98, 0x45, 0xea, 0x0e,
    0xe1, 0x5d, 0xfe, 0xc0, 0x02, 0xc3, 0x2f, 0x75, 0x12, 0x81, 0x4c, 0xf0, 0xa3, 0x8d, 0x46, 0x97, 0xc6, 0x6b, 0xd3,
    0xf9, 0xe7, 0x03, 0x8f, 0x5f, 0x95, 0x15, 0x92, 0x9c, 0xeb, 0xbf, 0x6d, 0x7a, 0xda, 0x95, 0x52, 0x59, 0x2d, 0xd4,
    0xbe, 0x83, 0xd3, 0x58, 0x74, 0x21, 0x29, 0x49, 0xe0, 0x69, 0x44, 0x8e, 0xc9, 0xc8, 0x6a, 0x75, 0xc2, 0x89, 0x78,
    0xf4, 0x8e, 0x79, 0x6b, 0x99, 0x58, 0x3e, 0xdd, 0x27, 0xb9, 0x71, 0xb6, 0xbe, 0xe1, 0x4f, 0x17, 0xf0, 0x88, 0xad,
    0x66, 0xc9, 0x20, 0xac, 0xb4, 0x7d, 0xce, 0x3a, 0x18, 0x63, 0xdf, 0x4a, 0x82, 0xe5, 0x1a, 0x31, 0x60, 0x97, 0x51,
    0x33, 0x45, 0x62, 0x53, 0x7f, 0xe0, 0xb1, 0x64, 0x77, 0x84, 0xbb, 0x6b, 0xae, 0x1c, 0xfe, 0x81, 0xa0, 0x94, 0xf9,
    0x08, 0x2b, 0x58, 0x70, 0x48, 0x68, 0x19, 0x8f, 0x45, 0xfd, 0x87, 0x94, 0xde, 0x6c, 0xb7, 0x52, 0x7b, 0xf8, 0x23,
    0xab, 0x73, 0xd3, 0xe2, 0x72, 0x4b, 0x02, 0x57, 0xe3, 0x1f, 0x8f, 0x2a, 0x66, 0x55, 0xab, 0x07, 0xb2, 0xeb, 0x28,
    0x03, 0x2f, 0xb5, 0xc2, 0x9a, 0x86, 0xc5, 0x7b, 0xa5, 0xd3, 0x37, 0x08, 0xf2, 0x30, 0x28, 0x87, 0xb2, 0x23, 0xbf,
    0xa5, 0xba, 0x02, 0x03, 0x6a, 0x5c, 0xed, 0x16, 0x82, 0x2b, 0x8a, 0xcf, 0x1c, 0x92, 0xa7, 0x79, 0xb4, 0xf0, 0xf3,
    0x07, 0xf2, 0xa1, 0x4e, 0x69, 0xe2, 0xcd, 0x65, 0xda, 0xf4, 0xd5, 0x06, 0x05, 0xbe, 0x1f, 0xd1, 0x34, 0x62, 0x8a,
    0xc4, 0xa6, 0xfe, 0x9d, 0x34, 0x2e, 0x53, 0xa0, 0xa2, 0xf3, 0x55, 0x32, 0x05, 0x8a, 0xe1, 0x75, 0xa4, 0xf6, 0xeb,
    0x39, 0x0b, 0x83, 0xec, 0xaa, 0x40, 0x60, 0xef, 0x06, 0x5e, 0x71, 0x9f, 0x51, 0xbd, 0x6e, 0x10, 0xf9, 0x3e, 0x21,
    0x8a, 0x3d, 0x96, 0xdd, 0x06, 0xae, 0xdd, 0x3e, 0x05, 0x46, 0x4d, 0xe6, 0xbd, 0xb5, 0x91, 0x54, 0x8d, 0x05, 0x71,
    0xc4, 0x5d, 0x6f, 0x04, 0x06, 0xd4, 0xff, 0x60, 0x50, 0x15, 0x24, 0x19, 0x98, 0xfb, 0x97, 0xd6, 0xbd, 0xe9, 0xcc,
    0x89, 0x40, 0x43, 0x77, 0x67, 0xd9, 0x9e, 0xbd, 0xb0, 0xe8, 0x42, 0x88, 0x07, 0x89, 0x8b, 0x38, 0xe7, 0x19, 0x5b,
    0xdb, 0x79, 0xc8, 0xee, 0x47, 0xa1, 0x7c, 0x0a, 0xe9, 0x7c, 0x42, 0x0f, 0xc9, 0xf8, 0x84, 0x1e, 0x00, 0x00, 0x00,
    0x00, 0x83, 0x09, 0x80, 0x86, 0x48, 0x32, 0x2b, 0xed, 0xac, 0x1e, 0x11, 0x70, 0x4e, 0x6c, 0x5a, 0x72, 0xfb, 0xfd,
    0x0e, 0xff, 0x56, 0x0f, 0x85, 0x38, 0x1e, 0x3d, 0xae, 0xd5, 0x27, 0x36, 0x2d, 0x39, 0x64, 0x0a, 0x0f, 0xd9, 0x21,
    0x68, 0x5c, 0xa6, 0xd1, 0x9b, 0x5b, 0x54, 0x3a, 0x24, 0x36, 0x2e, 0xb1, 0x0c, 0x0a, 0x67, 0x0f, 0x93, 0x57, 0xe7,
    0xd2, 0xb4, 0xee, 0x96, 0x9e, 0x1b, 0x9b, 0x91, 0x4f, 0x80, 0xc0, 0xc5, 0xa2, 0x61, 0xdc, 0x20, 0x69, 0x5a, 0x77,
    0x4b, 0x16, 0x1c, 0x12, 0x1a, 0x0a, 0xe2, 0x93, 0xba, 0xe5, 0xc0, 0xa0, 0x2a, 0x43, 0x3c, 0x22, 0xe0, 0x1d, 0x12,
    0x1b, 0x17, 0x0b, 0x0e, 0x09, 0x0d, 0xad, 0xf2, 0x8b, 0xc7, 0xb9, 0x2d, 0xb6, 0xa8, 0xc8, 0x14, 0x1e, 0xa9, 0x85,
    0x57, 0xf1, 0x19, 0x4c, 0xaf, 0x75, 0x07, 0xbb, 0xee, 0x99, 0xdd, 0xfd, 0xa3, 0x7f, 0x60, 0x9f, 0xf7, 0x01, 0x26,
    0xbc, 0x5c, 0x72, 0xf5, 0xc5, 0x44, 0x66, 0x3b, 0x34, 0x5b, 0xfb, 0x7e, 0x76, 0x8b, 0x43, 0x29, 0xdc, 0xcb, 0x23,
    0xc6, 0x68, 0xb6, 0xed, 0xfc, 0x63, 0xb8, 0xe4, 0xf1, 0xca, 0xd7, 0x31, 0xdc, 0x10, 0x42, 0x63, 0x85, 0x40, 0x13,
    0x97, 0x22, 0x20, 0x84, 0xc6, 0x11, 0x7d, 0x85, 0x4a, 0x24, 0xf8, 0xd2, 0xbb, 0x3d, 0x11, 0xae, 0xf9, 0x32, 0x6d,
    0xc7, 0x29, 0xa1, 0x4b, 0x1d, 0x9e, 0x2f, 0xf3, 0xdc, 0xb2, 0x30, 0xec, 0x0d, 0x86, 0x52, 0xd0, 0x77, 0xc1, 0xe3,
    0x6c, 0x2b, 0xb3, 0x16, 0x99, 0xa9, 0x70, 0xb9, 0xfa, 0x11, 0x94, 0x48, 0x22, 0x47, 0xe9, 0x64, 0xc4, 0xa8, 0xfc,
    0x8c, 0x1a, 0xa0, 0xf0, 0x3f, 0xd8, 0x56, 0x7d, 0x2c, 0xef, 0x22, 0x33, 0x90, 0xc7, 0x87, 0x49, 0x4e, 0xc1, 0xd9,
    0x38, 0xd1, 0xfe, 0x8c, 0xca, 0xa2, 0x36, 0x98, 0xd4, 0x0b, 0xcf, 0xa6, 0xf5, 0x81, 0x28, 0xa5, 0x7a, 0xde, 0x26,
    0xda, 0xb7, 0x8e, 0xa4, 0x3f, 0xad, 0xbf, 0xe4, 0x2c, 0x3a, 0x9d, 0x0d, 0x50, 0x78, 0x92, 0x9b, 0x6a, 0x5f, 0xcc,
    0x62, 0x54, 0x7e, 0x46, 0xc2, 0xf6, 0x8d, 0x13, 0xe8, 0x90, 0xd8, 0xb8, 0x5e, 0x2e, 0x39, 0xf7, 0xf5, 0x82, 0xc3,
    0xaf, 0xbe, 0x9f, 0x5d, 0x80, 0x7c, 0x69, 0xd0, 0x93, 0xa9, 0x6f, 0xd5, 0x2d, 0xb3, 0xcf, 0x25, 0x12, 0x3b, 0xc8,
    0xac, 0x99, 0xa7, 0x10, 0x18, 0x7d, 0x6e, 0xe8, 0x9c, 0x63, 0x7b, 0xdb, 0x3b, 0xbb, 0x09, 0xcd, 0x26, 0x78, 0xf4,
    0x6e, 0x59, 0x18, 0x01, 0xec, 0x9a, 0xb7, 0xa8, 0x83, 0x4f, 0x9a, 0x65, 0xe6, 0x95, 0x6e, 0x7e, 0xaa, 0xff, 0xe6,
    0x08, 0x21, 0xbc, 0xcf, 0xe6, 0xef, 0x15, 0xe8, 0xd9, 0xba, 0xe7, 0x9b, 0xce, 0x4a, 0x6f, 0x36, 0xd4, 0xea, 0x9f,
    0x09, 0xd6, 0x29, 0xb0, 0x7c, 0xaf, 0x31, 0xa4, 0xb2, 0x31, 0x2a, 0x3f, 0x23, 0x30, 0xc6, 0xa5, 0x94, 0xc0, 0x35,
    0xa2, 0x66, 0x37, 0x74, 0x4e, 0xbc, 0xa6, 0xfc, 0x82, 0xca, 0xb0, 0xe0, 0x90, 0xd0, 0x15, 0x33, 0xa7, 0xd8, 0x4a,
    0xf1, 0x04, 0x98, 0xf7, 0x41, 0xec, 0xda, 0x0e, 0x7f, 0xcd, 0x50, 0x2f, 0x17, 0x91, 0xf6, 0x8d, 0x76, 0x4d, 0xd6,
    0x4d, 0x43, 0xef, 0xb0, 0x54, 0xcc, 0xaa, 0x4d, 0xdf, 0xe4, 0x96, 0x04, 0xe3, 0x9e, 0xd1, 0xb5, 0x1b, 0x4c, 0x6a,
    0x88, 0xb8, 0xc1, 0x2c, 0x1f, 0x7f, 0x46, 0x65, 0x51, 0x04, 0x9d, 0x5e, 0xea, 0x5d, 0x01, 0x8c, 0x35, 0x73, 0xfa,
    0x87, 0x74, 0x2e, 0xfb, 0x0b, 0x41, 0x5a, 0xb3, 0x67, 0x1d, 0x52, 0x92, 0xdb, 0xd2, 0x33, 0xe9, 0x10, 0x56, 0x13,
    0x6d, 0xd6, 0x47, 0x8c, 0x9a, 0xd7, 0x61, 0x7a, 0x37, 0xa1, 0x0c, 0x8e, 0x59, 0xf8, 0x14, 0x89, 0xeb, 0x13, 0x3c,
    0xee, 0xce, 0xa9, 0x27, 0x35, 0xb7, 0x61, 0xc9, 0xed, 0xe1, 0x1c, 0xe5, 0x3c, 0x7a, 0x47, 0xb1, 0x59, 0x9c, 0xd2,
    0xdf, 0x3f, 0x55, 0xf2, 0x73, 0x79, 0x18, 0x14, 0xce, 0xbf, 0x73, 0xc7, 0x37, 0xea, 0x53, 0xf7, 0xcd, 0x5b, 0x5f,
    0xfd, 0xaa, 0x14, 0xdf, 0x3d, 0x6f, 0x86, 0x78, 0x44, 0xdb, 0x81, 0xca, 0xaf, 0xf3, 0x3e, 0xb9, 0x68, 0xc4, 0x2c,
    0x38, 0x24, 0x34, 0x5f, 0xc2, 0xa3, 0x40, 0x72, 0x16, 0x1d, 0xc3, 0x0c, 0xbc, 0xe2, 0x25, 0x8b, 0x28, 0x3c, 0x49,
    0x41, 0xff, 0x0d, 0x95, 0x71, 0x39, 0xa8, 0x01, 0xde, 0x08, 0x0c, 0xb3, 0x9c, 0xd8, 0xb4, 0xe4, 0x90, 0x64, 0x56,
    0xc1, 0x61, 0x7b, 0xcb, 0x84, 0x70, 0xd5, 0x32, 0xb6, 0x74, 0x48, 0x6c, 0x5c, 0x42, 0xd0, 0xb8, 0x57
};

static uint8_t T7[256][4] = {
    0xa7, 0x50, 0x51, 0xf4, 0x65, 0x53, 0x7e, 0x41, 0xa4, 0xc3, 0x1a, 0x17, 0x5e, 0x96, 0x3a, 0x27, 0x6b, 0xcb, 0x3b,
    0xab, 0x45, 0xf1, 0x1f, 0x9d, 0x58, 0xab, 0xac, 0xfa, 0x03, 0x93, 0x4b, 0xe3, 0xfa, 0x55, 0x20, 0x30, 0x6d, 0xf6,
    0xad, 0x76, 0x76, 0x91, 0x88, 0xcc, 0x4c, 0x25, 0xf5, 0x02, 0xd7, 0xfc, 0x4f, 0xe5, 0xcb, 0xd7, 0xc5, 0x2a, 0x44,
    0x80, 0x26, 0x35, 0xa3, 0x8f, 0xb5, 0x62, 0x5a, 0x49, 0xde, 0xb1, 0x1b, 0x67, 0x25, 0xba, 0x0e, 0x98, 0x45, 0xea,
    0xc0, 0xe1, 0x5d, 0xfe, 0x75, 0x02, 0xc3, 0x2f, 0xf0, 0x12, 0x81, 0x4c, 0x97, 0xa3, 0x8d, 0x46, 0xf9, 0xc6, 0x6b,
    0xd3, 0x5f, 0xe7, 0x03, 0x8f, 0x9c, 0x95, 0x15, 0x92, 0x7a, 0xeb, 0xbf, 0x6d, 0x59, 0xda, 0x95, 0x52, 0x83, 0x2d,
    0xd4, 0xbe, 0x21, 0xd3, 0x58, 0x74, 0x69, 0x29, 0x49, 0xe0, 0xc8, 0x44, 0x8e, 0xc9, 0x89, 0x6a, 0x75, 0xc2, 0x79,
    0x78, 0xf4, 0x8e, 0x3e, 0x6b, 0x99, 0x58, 0x71, 0xdd, 0x27, 0xb9, 0x4f, 0xb6, 0xbe, 0xe1, 0xad, 0x17, 0xf0, 0x88,
    0xac, 0x66, 0xc9, 0x20, 0x3a, 0xb4, 0x7d, 0xce, 0x4a, 0x18, 0x63, 0xdf, 0x31, 0x82, 0xe5, 0x1a, 0x33, 0x60, 0x97,
    0x51, 0x7f, 0x45, 0x62, 0x53, 0x77, 0xe0, 0xb1, 0x64, 0xae, 0x84, 0xbb, 0x6b, 0xa0, 0x1c, 0xfe, 0x81, 0x2b, 0x94,
    0xf9, 0x08, 0x68, 0x58, 0x70, 0x48, 0xfd, 0x19, 0x8f, 0x45, 0x6c, 0x87, 0x94, 0xde, 0xf8, 0xb7, 0x52, 0x7b, 0xd3,
    0x23, 0xab, 0x73, 0x02, 0xe2, 0x72, 0x4b, 0x8f, 0x57, 0xe3, 0x1f, 0xab, 0x2a, 0x66, 0x55, 0x28, 0x07, 0xb2, 0xeb,
    0xc2, 0x03, 0x2f, 0xb5, 0x7b, 0x9a, 0x86, 0xc5, 0x08, 0xa5, 0xd3, 0x37, 0x87, 0xf2, 0x30, 0x28, 0xa5, 0xb2, 0x23,
    0xbf, 0x6a, 0xba, 0x02, 0x03, 0x82, 0x5c, 0xed, 0x16, 0x1c, 0x2b, 0x8a, 0xcf, 0xb4, 0x92, 0xa7, 0x79, 0xf2, 0xf0,
    0xf3, 0x07, 0xe2, 0xa1, 0x4e, 0x69, 0xf4, 0xcd, 0x65, 0xda, 0xbe, 0xd5, 0x06, 0x05, 0x62, 0x1f, 0xd1, 0x34, 0xfe,
    0x8a, 0xc4, 0xa6, 0x53, 0x9d, 0x34, 0x2e, 0x55, 0xa0, 0xa2, 0xf3, 0xe1, 0x32, 0x05, 0x8a, 0xeb, 0x75, 0xa4, 0xf6,
    0xec, 0x39, 0x0b, 0x83, 0xef, 0xaa, 0x40, 0x60, 0x9f, 0x06, 0x5e, 0x71, 0x10, 0x51, 0xbd, 0x6e, 0x8a, 0xf9, 0x3e,
    0x21, 0x06, 0x3d, 0x96, 0xdd, 0x05, 0xae, 0xdd, 0x3e, 0xbd, 0x46, 0x4d, 0xe6, 0x8d, 0xb5, 0x91, 0x54, 0x5d, 0x05,
    0x71, 0xc4, 0xd4, 0x6f, 0x04, 0x06, 0x15, 0xff, 0x60, 0x50, 0xfb, 0x24, 0x19, 0x98, 0xe9, 0x97, 0xd6, 0xbd, 0x43,
    0xcc, 0x89, 0x40, 0x9e, 0x77, 0x67, 0xd9, 0x42, 0xbd, 0xb0, 0xe8, 0x8b, 0x88, 0x07, 0x89, 0x5b, 0x38, 0xe7, 0x19,
    0xee, 0xdb, 0x79, 0xc8, 0x0a, 0x47, 0xa1, 0x7c, 0x0f, 0xe9, 0x7c, 0x42, 0x1e, 0xc9, 0xf8, 0x84, 0x00, 0x00, 0x00,
    0x00, 0x86, 0x83, 0x09, 0x80, 0xed, 0x48, 0x32, 0x2b, 0x70, 0xac, 0x1e, 0x11, 0x72, 0x4e, 0x6c, 0x5a, 0xff, 0xfb,
    0xfd, 0x0e, 0x38, 0x56, 0x0f, 0x85, 0xd5, 0x1e, 0x3d, 0xae, 0x39, 0x27, 0x36, 0x2d, 0xd9, 0x64, 0x0a, 0x0f, 0xa6,
    0x21, 0x68, 0x5c, 0x54, 0xd1, 0x9b, 0x5b, 0x2e, 0x3a, 0x24, 0x36, 0x67, 0xb1, 0x0c, 0x0a, 0xe7, 0x0f, 0x93, 0x57,
    0x96, 0xd2, 0xb4, 0xee, 0x91, 0x9e, 0x1b, 0x9b, 0xc5, 0x4f, 0x80, 0xc0, 0x20, 0xa2, 0x61, 0xdc, 0x4b, 0x69, 0x5a,
    0x77, 0x1a, 0x16, 0x1c, 0x12, 0xba, 0x0a, 0xe2, 0x93, 0x2a, 0xe5, 0xc0, 0xa0, 0xe0, 0x43, 0x3c, 0x22, 0x17, 0x1d,
    0x12, 0x1b, 0x0d, 0x0b, 0x0e, 0x09, 0xc7, 0xad, 0xf2, 0x8b, 0xa8, 0xb9, 0x2d, 0xb6, 0xa9, 0xc8, 0x14, 0x1e, 0x19,
    0x85, 0x57, 0xf1, 0x07, 0x4c, 0xaf, 0x75, 0xdd, 0xbb, 0xee, 0x99, 0x60, 0xfd, 0xa3, 0x7f, 0x26, 0x9f, 0xf7, 0x01,
    0xf5, 0xbc, 0x5c, 0x72, 0x3b, 0xc5, 0x44, 0x66, 0x7e, 0x34, 0x5b, 0xfb, 0x29, 0x76, 0x8b, 0x43, 0xc6, 0xdc, 0xcb,
    0x23, 0xfc, 0x68, 0xb6, 0xed, 0xf1, 0x63, 0xb8, 0xe4, 0xdc, 0xca, 0xd7, 0x31, 0x85, 0x10, 0x42, 0x63, 0x22, 0x40,
    0x13, 0x97, 0x11, 0x20, 0x84, 0xc6, 0x24, 0x7d, 0x85, 0x4a, 0x3d, 0xf8, 0xd2, 0xbb, 0x32, 0x11, 0xae, 0xf9, 0xa1,
    0x6d, 0xc7, 0x29, 0x2f, 0x4b, 0x1d, 0x9e, 0x30, 0xf3, 0xdc, 0xb2, 0x52, 0xec, 0x0d, 0x86, 0xe3, 0xd0, 0x77, 0xc1,
    0x16, 0x6c, 0x2b, 0xb3, 0xb9, 0x99, 0xa9, 0x70, 0x48, 0xfa, 0x11, 0x94, 0x64, 0x22, 0x47, 0xe9, 0x8c, 0xc4, 0xa8,
    0xfc, 0x3f, 0x1a, 0xa0, 0xf0, 0x2c, 0xd8, 0x56, 0x7d, 0x90, 0xef, 0x22, 0x33, 0x4e, 0xc7, 0x87, 0x49, 0xd1, 0xc1,
    0xd9, 0x38, 0xa2, 0xfe, 0x8c, 0xca, 0x0b, 0x36, 0x98, 0xd4, 0x81, 0xcf, 0xa6, 0xf5, 0xde, 0x28, 0xa5, 0x7a, 0x8e,
    0x26, 0xda, 0xb7, 0xbf, 0xa4, 0x3f, 0xad, 0x9d, 0xe4, 0x2c, 0x3a, 0x92, 0x0d, 0x50, 0x78, 0xcc, 0x9b, 0x6a, 0x5f,
    0x46, 0x62, 0x54, 0x7e, 0x13, 0xc2, 0xf6, 0x8d, 0xb8, 0xe8, 0x90, 0xd8, 0xf7, 0x5e, 0x2e, 0x39, 0xaf, 0xf5, 0x82,
    0xc3, 0x80, 0xbe, 0x9f, 0x5d, 0x93, 0x7c, 0x69, 0xd0, 0x2d, 0xa9, 0x6f, 0xd5, 0x12, 0xb3, 0xcf, 0x25, 0x99, 0x3b,
    0xc8, 0xac, 0x7d, 0xa7, 0x10, 0x18, 0x63, 0x6e, 0xe8, 0x9c, 0xbb, 0x7b, 0xdb, 0x3b, 0x78, 0x09, 0xcd, 0x26, 0x18,
    0xf4, 0x6e, 0x59, 0xb7, 0x01, 0xec, 0x9a, 0x9a, 0xa8, 0x83, 0x4f, 0x6e, 0x65, 0xe6, 0x95, 0xe6, 0x7e, 0xaa, 0xff,
    0xcf, 0x08, 0x21, 0xbc, 0xe8, 0xe6, 0xef, 0x15, 0x9b, 0xd9, 0xba, 0xe7, 0x36, 0xce, 0x4a, 0x6f, 0x09, 0xd4, 0xea,
    0x9f, 0x7c, 0xd6, 0x29, 0xb0, 0xb2, 0xaf, 0x31, 0xa4, 0x23, 0x31, 0x2a, 0x3f, 0x94, 0x30, 0xc6, 0xa5, 0x66, 0xc0,
    0x35, 0xa2, 0xbc, 0x37, 0x74, 0x4e, 0xca, 0xa6, 0xfc, 0x82, 0xd0, 0xb0, 0xe0, 0x90, 0xd8, 0x15, 0x33, 0xa7, 0x98,
    0x4a, 0xf1, 0x04, 0xda, 0xf7, 0x41, 0xec, 0x50, 0x0e, 0x7f, 0xcd, 0xf6, 0x2f, 0x17, 0x91, 0xd6, 0x8d, 0x76, 0x4d,
    0xb0, 0x4d, 0x43, 0xef, 0x4d, 0x54, 0xcc, 0xaa, 0x04, 0xdf, 0xe4, 0x96, 0xb5, 0xe3, 0x9e, 0xd1, 0x88, 0x1b, 0x4c,
    0x6a, 0x1f, 0xb8, 0xc1, 0x2c, 0x51, 0x7f, 0x46, 0x65, 0xea, 0x04, 0x9d, 0x5e, 0x35, 0x5d, 0x01, 0x8c, 0x74, 0x73,
    0xfa, 0x87, 0x41, 0x2e, 0xfb, 0x0b, 0x1d, 0x5a, 0xb3, 0x67, 0xd2, 0x52, 0x92, 0xdb, 0x56, 0x33, 0xe9, 0x10, 0x47,
    0x13, 0x6d, 0xd6, 0x61, 0x8c, 0x9a, 0xd7, 0x0c, 0x7a, 0x37, 0xa1, 0x14, 0x8e, 0x59, 0xf8, 0x3c, 0x89, 0xeb, 0x13,
    0x27, 0xee, 0xce, 0xa9, 0xc9, 0x35, 0xb7, 0x61, 0xe5, 0xed, 0xe1, 0x1c, 0xb1, 0x3c, 0x7a, 0x47, 0xdf, 0x59, 0x9c,
    0xd2, 0x73, 0x3f, 0x55, 0xf2, 0xce, 0x79, 0x18, 0x14, 0x37, 0xbf, 0x73, 0xc7, 0xcd, 0xea, 0x53, 0xf7, 0xaa, 0x5b,
    0x5f, 0xfd, 0x6f, 0x14, 0xdf, 0x3d, 0xdb, 0x86, 0x78, 0x44, 0xf3, 0x81, 0xca, 0xaf, 0xc4, 0x3e, 0xb9, 0x68, 0x34,
    0x2c, 0x38, 0x24, 0x40, 0x5f, 0xc2, 0xa3, 0xc3, 0x72, 0x16, 0x1d, 0x25, 0x0c, 0xbc, 0xe2, 0x49, 0x8b, 0x28, 0x3c,
    0x95, 0x41, 0xff, 0x0d, 0x01, 0x71, 0x39, 0xa8, 0xb3, 0xde, 0x08, 0x0c, 0xe4, 0x9c, 0xd8, 0xb4, 0xc1, 0x90, 0x64,
    0x56, 0x84, 0x61, 0x7b, 0xcb, 0xb6, 0x70, 0xd5, 0x32, 0x5c, 0x74, 0x48, 0x6c, 0x57, 0x42, 0xd0, 0xb8
};

static uint8_t T8[256][4] = {
    0xf4, 0xa7, 0x50, 0x51, 0x41, 0x65, 0x53, 0x7e, 0x17, 0xa4, 0xc3, 0x1a, 0x27, 0x5e, 0x96, 0x3a, 0xab, 0x6b, 0xcb,
    0x3b, 0x9d, 0x45, 0xf1, 0x1f, 0xfa, 0x58, 0xab, 0xac, 0xe3, 0x03, 0x93, 0x4b, 0x30, 0xfa, 0x55, 0x20, 0x76, 0x6d,
    0xf6, 0xad, 0xcc, 0x76, 0x91, 0x88, 0x02, 0x4c, 0x25, 0xf5, 0xe5, 0xd7, 0xfc, 0x4f, 0x2a, 0xcb, 0xd7, 0xc5, 0x35,
    0x44, 0x80, 0x26, 0x62, 0xa3, 0x8f, 0xb5, 0xb1, 0x5a, 0x49, 0xde, 0xba, 0x1b, 0x67, 0x25, 0xea, 0x0e, 0x98, 0x45,
    0xfe, 0xc0, 0xe1, 0x5d, 0x2f, 0x75, 0x02, 0xc3, 0x4c, 0xf0, 0x12, 0x81, 0x46, 0x97, 0xa3, 0x8d, 0xd3, 0xf9, 0xc6,
    0x6b, 0x8f, 0x5f, 0xe7, 0x03, 0x92, 0x9c, 0x95, 0x15, 0x6d, 0x7a, 0xeb, 0xbf, 0x52, 0x59, 0xda, 0x95, 0xbe, 0x83,
    0x2d, 0xd4, 0x74, 0x21, 0xd3, 0x58, 0xe0, 0x69, 0x29, 0x49, 0xc9, 0xc8, 0x44, 0x8e, 0xc2, 0x89, 0x6a, 0x75, 0x8e,
    0x79, 0x78, 0xf4, 0x58, 0x3e, 0x6b, 0x99, 0xb9, 0x71, 0xdd, 0x27, 0xe1, 0x4f, 0xb6, 0xbe, 0x88, 0xad, 0x17, 0xf0,
    0x20, 0xac, 0x66, 0xc9, 0xce, 0x3a, 0xb4, 0x7d, 0xdf, 0x4a, 0x18, 0x63, 0x1a, 0x31, 0x82, 0xe5, 0x51, 0x33, 0x60,
    0x97, 0x53, 0x7f, 0x45, 0x62, 0x64, 0x77, 0xe0, 0xb1, 0x6b, 0xae, 0x84, 0xbb, 0x81, 0xa0, 0x1c, 0xfe, 0x08, 0x2b,
    0x94, 0xf9, 0x48, 0x68, 0x58, 0x70, 0x45, 0xfd, 0x19, 0x8f, 0xde, 0x6c, 0x87, 0x94, 0x7b, 0xf8, 0xb7, 0x52, 0x73,
    0xd3, 0x23, 0xab, 0x4b, 0x02, 0xe2, 0x72, 0x1f, 0x8f, 0x57, 0xe3, 0x55, 0xab, 0x2a, 0x66, 0xeb, 0x28, 0x07, 0xb2,
    0xb5, 0xc2, 0x03, 0x2f, 0xc5, 0x7b, 0x9a, 0x86, 0x37, 0x08, 0xa5, 0xd3, 0x28, 0x87, 0xf2, 0x30, 0xbf, 0xa5, 0xb2,
    0x23, 0x03, 0x6a, 0xba, 0x02, 0x16, 0x82, 0x5c, 0xed, 0xcf, 0x1c, 0x2b, 0x8a, 0x79, 0xb4, 0x92, 0xa7, 0x07, 0xf2,
    0xf0, 0xf3, 0x69, 0xe2, 0xa1, 0x4e, 0xda, 0xf4, 0xcd, 0x65, 0x05, 0xbe, 0xd5, 0x06, 0x34, 0x62, 0x1f, 0xd1, 0xa6,
    0xfe, 0x8a, 0xc4, 0x2e, 0x53, 0x9d, 0x34, 0xf3, 0x55, 0xa0, 0xa2, 0x8a, 0xe1, 0x32, 0x05, 0xf6, 0xeb, 0x75, 0xa4,
    0x83, 0xec, 0x39, 0x0b, 0x60, 0xef, 0xaa, 0x40, 0x71, 0x9f, 0x06, 0x5e, 0x6e, 0x10, 0x51, 0xbd, 0x21, 0x8a, 0xf9,
    0x3e, 0xdd, 0x06, 0x3d, 0x96, 0x3e, 0x05, 0xae, 0xdd, 0xe6, 0xbd, 0x46, 0x4d, 0x54, 0x8d, 0xb5, 0x91, 0xc4, 0x5d,
    0x05, 0x71, 0x06, 0xd4, 0x6f, 0x04, 0x50, 0x15, 0xff, 0x60, 0x98, 0xfb, 0x24, 0x19, 0xbd, 0xe9, 0x97, 0xd6, 0x40,
    0x43, 0xcc, 0x89, 0xd9, 0x9e, 0x77, 0x67, 0xe8, 0x42, 0xbd, 0xb0, 0x89, 0x8b, 0x88, 0x07, 0x19, 0x5b, 0x38, 0xe7,
    0xc8, 0xee, 0xdb, 0x79, 0x7c, 0x0a, 0x47, 0xa1, 0x42, 0x0f, 0xe9, 0x7c, 0x84, 0x1e, 0xc9, 0xf8, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x86, 0x83, 0x09, 0x2b, 0xed, 0x48, 0x32, 0x11, 0x70, 0xac, 0x1e, 0x5a, 0x72, 0x4e, 0x6c, 0x0e, 0xff,
    0xfb, 0xfd, 0x85, 0x38, 0x56, 0x0f, 0xae, 0xd5, 0x1e, 0x3d, 0x2d, 0x39, 0x27, 0x36, 0x0f, 0xd9, 0x64, 0x0a, 0x5c,
    0xa6, 0x21, 0x68, 0x5b, 0x54, 0xd1, 0x9b, 0x36, 0x2e, 0x3a, 0x24, 0x0a, 0x67, 0xb1, 0x0c, 0x57, 0xe7, 0x0f, 0x93,
    0xee, 0x96, 0xd2, 0xb4, 0x9b, 0x91, 0x9e, 0x1b, 0xc0, 0xc5, 0x4f, 0x80, 0xdc, 0x20, 0xa2, 0x61, 0x77, 0x4b, 0x69,
    0x5a, 0x12, 0x1a, 0x16, 0x1c, 0x93, 0xba, 0x0a, 0xe2, 0xa0, 0x2a, 0xe5, 0xc0, 0x22, 0xe0, 0x43, 0x3c, 0x1b, 0x17,
    0x1d, 0x12, 0x09, 0x0d, 0x0b, 0x0e, 0x8b, 0xc7, 0xad, 0xf2, 0xb6, 0xa8, 0xb9, 0x2d, 0x1e, 0xa9, 0xc8, 0x14, 0xf1,
    0x19, 0x85, 0x57, 0x75, 0x07, 0x4c, 0xaf, 0x99, 0xdd, 0xbb, 0xee, 0x7f, 0x60, 0xfd, 0xa3, 0x01, 0x26, 0x9f, 0xf7,
    0x72, 0xf5, 0xbc, 0x5c, 0x66, 0x3b, 0xc5, 0x44, 0xfb, 0x7e, 0x34, 0x5b, 0x43, 0x29, 0x76, 0x8b, 0x23, 0xc6, 0xdc,
    0xcb, 0xed, 0xfc, 0x68, 0xb6, 0xe4, 0xf1, 0x63, 0xb8, 0x31, 0xdc, 0xca, 0xd7, 0x63, 0x85, 0x10, 0x42, 0x97, 0x22,
    0x40, 0x13, 0xc6, 0x11, 0x20, 0x84, 0x4a, 0x24, 0x7d, 0x85, 0xbb, 0x3d, 0xf8, 0xd2, 0xf9, 0x32, 0x11, 0xae, 0x29,
    0xa1, 0x6d, 0xc7, 0x9e, 0x2f, 0x4b, 0x1d, 0xb2, 0x30, 0xf3, 0xdc, 0x86, 0x52, 0xec, 0x0d, 0xc1, 0xe3, 0xd0, 0x77,
    0xb3, 0x16, 0x6c, 0x2b, 0x70, 0xb9, 0x99, 0xa9, 0x94, 0x48, 0xfa, 0x11, 0xe9, 0x64, 0x22, 0x47, 0xfc, 0x8c, 0xc4,
    0xa8, 0xf0, 0x3f, 0x1a, 0xa0, 0x7d, 0x2c, 0xd8, 0x56, 0x33, 0x90, 0xef, 0x22, 0x49, 0x4e, 0xc7, 0x87, 0x38, 0xd1,
    0xc1, 0xd9, 0xca, 0xa2, 0xfe, 0x8c, 0xd4, 0x0b, 0x36, 0x98, 0xf5, 0x81, 0xcf, 0xa6, 0x7a, 0xde, 0x28, 0xa5, 0xb7,
    0x8e, 0x26, 0xda, 0xad, 0xbf, 0xa4, 0x3f, 0x3a, 0x9d, 0xe4, 0x2c, 0x78, 0x92, 0x0d, 0x50, 0x5f, 0xcc, 0x9b, 0x6a,
    0x7e, 0x46, 0x62, 0x54, 0x8d, 0x13, 0xc2, 0xf6, 0xd8, 0xb8, 0xe8, 0x90, 0x39, 0xf7, 0x5e, 0x2e, 0xc3, 0xaf, 0xf5,
    0x82, 0x5d, 0x80, 0xbe, 0x9f, 0xd0, 0x93, 0x7c, 0x69, 0xd5, 0x2d, 0xa9, 0x6f, 0x25, 0x12, 0xb3, 0xcf, 0xac, 0x99,
    0x3b, 0xc8, 0x18, 0x7d, 0xa7, 0x10, 0x9c, 0x63, 0x6e, 0xe8, 0x3b, 0xbb, 0x7b, 0xdb, 0x26, 0x78, 0x09, 0xcd, 0x59,
    0x18, 0xf4, 0x6e, 0x9a, 0xb7, 0x01, 0xec, 0x4f, 0x9a, 0xa8, 0x83, 0x95, 0x6e, 0x65, 0xe6, 0xff, 0xe6, 0x7e, 0xaa,
    0xbc, 0xcf, 0x08, 0x21, 0x15, 0xe8, 0xe6, 0xef, 0xe7, 0x9b, 0xd9, 0xba, 0x6f, 0x36, 0xce, 0x4a, 0x9f, 0x09, 0xd4,
    0xea, 0xb0, 0x7c, 0xd6, 0x29, 0xa4, 0xb2, 0xaf, 0x31, 0x3f, 0x23, 0x31, 0x2a, 0xa5, 0x94, 0x30, 0xc6, 0xa2, 0x66,
    0xc0, 0x35, 0x4e, 0xbc, 0x37, 0x74, 0x82, 0xca, 0xa6, 0xfc, 0x90, 0xd0, 0xb0, 0xe0, 0xa7, 0xd8, 0x15, 0x33, 0x04,
    0x98, 0x4a, 0xf1, 0xec, 0xda, 0xf7, 0x41, 0xcd, 0x50, 0x0e, 0x7f, 0x91, 0xf6, 0x2f, 0x17, 0x4d, 0xd6, 0x8d, 0x76,
    0xef, 0xb0, 0x4d, 0x43, 0xaa, 0x4d, 0x54, 0xcc, 0x96, 0x04, 0xdf, 0xe4, 0xd1, 0xb5, 0xe3, 0x9e, 0x6a, 0x88, 0x1b,
    0x4c, 0x2c, 0x1f, 0xb8, 0xc1, 0x65, 0x51, 0x7f, 0x46, 0x5e, 0xea, 0x04, 0x9d, 0x8c, 0x35, 0x5d, 0x01, 0x87, 0x74,
    0x73, 0xfa, 0x0b, 0x41, 0x2e, 0xfb, 0x67, 0x1d, 0x5a, 0xb3, 0xdb, 0xd2, 0x52, 0x92, 0x10, 0x56, 0x33, 0xe9, 0xd6,
    0x47, 0x13, 0x6d, 0xd7, 0x61, 0x8c, 0x9a, 0xa1, 0x0c, 0x7a, 0x37, 0xf8, 0x14, 0x8e, 0x59, 0x13, 0x3c, 0x89, 0xeb,
    0xa9, 0x27, 0xee, 0xce, 0x61, 0xc9, 0x35, 0xb7, 0x1c, 0xe5, 0xed, 0xe1, 0x47, 0xb1, 0x3c, 0x7a, 0xd2, 0xdf, 0x59,
    0x9c, 0xf2, 0x73, 0x3f, 0x55, 0x14, 0xce, 0x79, 0x18, 0xc7, 0x37, 0xbf, 0x73, 0xf7, 0xcd, 0xea, 0x53, 0xfd, 0xaa,
    0x5b, 0x5f, 0x3d, 0x6f, 0x14, 0xdf, 0x44, 0xdb, 0x86, 0x78, 0xaf, 0xf3, 0x81, 0xca, 0x68, 0xc4, 0x3e, 0xb9, 0x24,
    0x34, 0x2c, 0x38, 0xa3, 0x40, 0x5f, 0xc2, 0x1d, 0xc3, 0x72, 0x16, 0xe2, 0x25, 0x0c, 0xbc, 0x3c, 0x49, 0x8b, 0x28,
    0x0d, 0x95, 0x41, 0xff, 0xa8, 0x01, 0x71, 0x39, 0x0c, 0xb3, 0xde, 0x08, 0xb4, 0xe4, 0x9c, 0xd8, 0x56, 0xc1, 0x90,
    0x64, 0xcb, 0x84, 0x61, 0x7b, 0x32, 0xb6, 0x70, 0xd5, 0x6c, 0x5c, 0x74, 0x48, 0xb8, 0x57, 0x42, 0xd0
};

static uint8_t S5[256] = {
    0x52, 0x09, 0x6a, 0xd5, 0x30, 0x36, 0xa5, 0x38, 0xbf, 0x40, 0xa3, 0x9e, 0x81, 0xf3, 0xd7, 0xfb, 0x7c, 0xe3, 0x39,
    0x82, 0x9b, 0x2f, 0xff, 0x87, 0x34, 0x8e, 0x43, 0x44, 0xc4, 0xde, 0xe9, 0xcb, 0x54, 0x7b, 0x94, 0x32, 0xa6, 0xc2,
    0x23, 0x3d, 0xee, 0x4c, 0x95, 0x0b, 0x42, 0xfa, 0xc3, 0x4e, 0x08, 0x2e, 0xa1, 0x66, 0x28, 0xd9, 0x24, 0xb2, 0x76,
    0x5b, 0xa2, 0x49, 0x6d, 0x8b, 0xd1, 0x25, 0x72, 0xf8, 0xf6, 0x64, 0x86, 0x68, 0x98, 0x16, 0xd4, 0xa4, 0x5c, 0xcc,
    0x5d, 0x65, 0xb6, 0x92, 0x6c, 0x70, 0x48, 0x50, 0xfd, 0xed, 0xb9, 0xda, 0x5e, 0x15, 0x46, 0x57, 0xa7, 0x8d, 0x9d,
    0x84, 0x90, 0xd8, 0xab, 0x00, 0x8c, 0xbc, 0xd3, 0x0a, 0xf7, 0xe4, 0x58, 0x05, 0xb8, 0xb3, 0x45, 0x06, 0xd0, 0x2c,
    0x1e, 0x8f, 0xca, 0x3f, 0x0f, 0x02, 0xc1, 0xaf, 0xbd, 0x03, 0x01, 0x13, 0x8a, 0x6b, 0x3a, 0x91, 0x11, 0x41, 0x4f,
    0x67, 0xdc, 0xea, 0x97, 0xf2, 0xcf, 0xce, 0xf0, 0xb4, 0xe6, 0x73, 0x96, 0xac, 0x74, 0x22, 0xe7, 0xad, 0x35, 0x85,
    0xe2, 0xf9, 0x37, 0xe8, 0x1c, 0x75, 0xdf, 0x6e, 0x47, 0xf1, 0x1a, 0x71, 0x1d, 0x29, 0xc5, 0x89, 0x6f, 0xb7, 0x62,
    0x0e, 0xaa, 0x18, 0xbe, 0x1b, 0xfc, 0x56, 0x3e, 0x4b, 0xc6, 0xd2, 0x79, 0x20, 0x9a, 0xdb, 0xc0, 0xfe, 0x78, 0xcd,
    0x5a, 0xf4, 0x1f, 0xdd, 0xa8, 0x33, 0x88, 0x07, 0xc7, 0x31, 0xb1, 0x12, 0x10, 0x59, 0x27, 0x80, 0xec, 0x5f, 0x60,
    0x51, 0x7f, 0xa9, 0x19, 0xb5, 0x4a, 0x0d, 0x2d, 0xe5, 0x7a, 0x9f, 0x93, 0xc9, 0x9c, 0xef, 0xa0, 0xe0, 0x3b, 0x4d,
    0xae, 0x2a, 0xf5, 0xb0, 0xc8, 0xeb, 0xbb, 0x3c, 0x83, 0x53, 0x99, 0x61, 0x17, 0x2b, 0x04, 0x7e, 0xba, 0x77, 0xd6,
    0x26, 0xe1, 0x69, 0x14, 0x63, 0x55, 0x21, 0x0c, 0x7d
};

static uint8_t U1[256][4] = {
    0x00, 0x00, 0x00, 0x00, 0x0e, 0x09, 0x0d, 0x0b, 0x1c, 0x12, 0x1a, 0x16, 0x12, 0x1b, 0x17, 0x1d, 0x38, 0x24, 0x34,
    0x2c, 0x36, 0x2d, 0x39, 0x27, 0x24, 0x36, 0x2e, 0x3a, 0x2a, 0x3f, 0x23, 0x31, 0x70, 0x48, 0x68, 0x58, 0x7e, 0x41,
    0x65, 0x53, 0x6c, 0x5a, 0x72, 0x4e, 0x62, 0x53, 0x7f, 0x45, 0x48, 0x6c, 0x5c, 0x74, 0x46, 0x65, 0x51, 0x7f, 0x54,
    0x7e, 0x46, 0x62, 0x5a, 0x77, 0x4b, 0x69, 0xe0, 0x90, 0xd0, 0xb0, 0xee, 0x99, 0xdd, 0xbb, 0xfc, 0x82, 0xca, 0xa6,
    0xf2, 0x8b, 0xc7, 0xad, 0xd8, 0xb4, 0xe4, 0x9c, 0xd6, 0xbd, 0xe9, 0x97, 0xc4, 0xa6, 0xfe, 0x8a, 0xca, 0xaf, 0xf3,
    0x81, 0x90, 0xd8, 0xb8, 0xe8, 0x9e, 0xd1, 0xb5, 0xe3, 0x8c, 0xca, 0xa2, 0xfe, 0x82, 0xc3, 0xaf, 0xf5, 0xa8, 0xfc,
    0x8c, 0xc4, 0xa6, 0xf5, 0x81, 0xcf, 0xb4, 0xee, 0x96, 0xd2, 0xba, 0xe7, 0x9b, 0xd9, 0xdb, 0x3b, 0xbb, 0x7b, 0xd5,
    0x32, 0xb6, 0x70, 0xc7, 0x29, 0xa1, 0x6d, 0xc9, 0x20, 0xac, 0x66, 0xe3, 0x1f, 0x8f, 0x57, 0xed, 0x16, 0x82, 0x5c,
    0xff, 0x0d, 0x95, 0x41, 0xf1, 0x04, 0x98, 0x4a, 0xab, 0x73, 0xd3, 0x23, 0xa5, 0x7a, 0xde, 0x28, 0xb7, 0x61, 0xc9,
    0x35, 0xb9, 0x68, 0xc4, 0x3e, 0x93, 0x57, 0xe7, 0x0f, 0x9d, 0x5e, 0xea, 0x04, 0x8f, 0x45, 0xfd, 0x19, 0x81, 0x4c,
    0xf0, 0x12, 0x3b, 0xab, 0x6b, 0xcb, 0x35, 0xa2, 0x66, 0xc0, 0x27, 0xb9, 0x71, 0xdd, 0x29, 0xb0, 0x7c, 0xd6, 0x03,
    0x8f, 0x5f, 0xe7, 0x0d, 0x86, 0x52, 0xec, 0x1f, 0x9d, 0x45, 0xf1, 0x11, 0x94, 0x48, 0xfa, 0x4b, 0xe3, 0x03, 0x93,
    0x45, 0xea, 0x0e, 0x98, 0x57, 0xf1, 0x19, 0x85, 0x59, 0xf8, 0x14, 0x8e, 0x73, 0xc7, 0x37, 0xbf, 0x7d, 0xce, 0x3a,
    0xb4, 0x6f, 0xd5, 0x2d, 0xa9, 0x61, 0xdc, 0x20, 0xa2, 0xad, 0x76, 0x6d, 0xf6, 0xa3, 0x7f, 0x60, 0xfd, 0xb1, 0x64,
    0x77, 0xe0, 0xbf, 0x6d, 0x7a, 0xeb, 0x95, 0x52, 0x59, 0xda, 0x9b, 0x5b, 0x54, 0xd1, 0x89, 0x40, 0x43, 0xcc, 0x87,
    0x49, 0x4e, 0xc7, 0xdd, 0x3e, 0x05, 0xae, 0xd3, 0x37, 0x08, 0xa5, 0xc1, 0x2c, 0x1f, 0xb8, 0xcf, 0x25, 0x12, 0xb3,
    0xe5, 0x1a, 0x31, 0x82, 0xeb, 0x13, 0x3c, 0x89, 0xf9, 0x08, 0x2b, 0x94, 0xf7, 0x01, 0x26, 0x9f, 0x4d, 0xe6, 0xbd,
    0x46, 0x43, 0xef, 0xb0, 0x4d, 0x51, 0xf4, 0xa7, 0x50, 0x5f, 0xfd, 0xaa, 0x5b, 0x75, 0xc2, 0x89, 0x6a, 0x7b, 0xcb,
    0x84, 0x61, 0x69, 0xd0, 0x93, 0x7c, 0x67, 0xd9, 0x9e, 0x77, 0x3d, 0xae, 0xd5, 0x1e, 0x33, 0xa7, 0xd8, 0x15, 0x21,
    0xbc, 0xcf, 0x08, 0x2f, 0xb5, 0xc2, 0x03, 0x05, 0x8a, 0xe1, 0x32, 0x0b, 0x83, 0xec, 0x39, 0x19, 0x98, 0xfb, 0x24,
    0x17, 0x91, 0xf6, 0x2f, 0x76, 0x4d, 0xd6, 0x8d, 0x78, 0x44, 0xdb, 0x86, 0x6a, 0x5f, 0xcc, 0x9b, 0x64, 0x56, 0xc1,
    0x90, 0x4e, 0x69, 0xe2, 0xa1, 0x40, 0x60, 0xef, 0xaa, 0x52, 0x7b, 0xf8, 0xb7, 0x5c, 0x72, 0xf5, 0xbc, 0x06, 0x05,
    0xbe, 0xd5, 0x08, 0x0c, 0xb3, 0xde, 0x1a, 0x17, 0xa4, 0xc3, 0x14, 0x1e, 0xa9, 0xc8, 0x3e, 0x21, 0x8a, 0xf9, 0x30,
    0x28, 0x87, 0xf2, 0x22, 0x33, 0x90, 0xef, 0x2c, 0x3a, 0x9d, 0xe4, 0x96, 0xdd, 0x06, 0x3d, 0x98, 0xd4, 0x0b, 0x36,
    0x8a, 0xcf, 0x1c, 0x2b, 0x84, 0xc6, 0x11, 0x20, 0xae, 0xf9, 0x32, 0x11, 0xa0, 0xf0, 0x3f, 0x1a, 0xb2, 0xeb, 0x28,
    0x07, 0xbc, 0xe2, 0x25, 0x0c, 0xe6, 0x95, 0x6e, 0x65, 0xe8, 0x9c, 0x63, 0x6e, 0xfa, 0x87, 0x74, 0x73, 0xf4, 0x8e,
    0x79, 0x78, 0xde, 0xb1, 0x5a, 0x49, 0xd0, 0xb8, 0x57, 0x42, 0xc2, 0xa3, 0x40, 0x5f, 0xcc, 0xaa, 0x4d, 0x54, 0x41,
    0xec, 0xda, 0xf7, 0x4f, 0xe5, 0xd7, 0xfc, 0x5d, 0xfe, 0xc0, 0xe1, 0x53, 0xf7, 0xcd, 0xea, 0x79, 0xc8, 0xee, 0xdb,
    0x77, 0xc1, 0xe3, 0xd0, 0x65, 0xda, 0xf4, 0xcd, 0x6b, 0xd3, 0xf9, 0xc6, 0x31, 0xa4, 0xb2, 0xaf, 0x3f, 0xad, 0xbf,
    0xa4, 0x2d, 0xb6, 0xa8, 0xb9, 0x23, 0xbf, 0xa5, 0xb2, 0x09, 0x80, 0x86, 0x83, 0x07, 0x89, 0x8b, 0x88, 0x15, 0x92,
    0x9c, 0x95, 0x1b, 0x9b, 0x91, 0x9e, 0xa1, 0x7c, 0x0a, 0x47, 0xaf, 0x75, 0x07, 0x4c, 0xbd, 0x6e, 0x10, 0x51, 0xb3,
    0x67, 0x1d, 0x5a, 0x99, 0x58, 0x3e, 0x6b, 0x97, 0x51, 0x33, 0x60, 0x85, 0x4a, 0x24, 0x7d, 0x8b, 0x43, 0x29, 0x76,
    0xd1, 0x34, 0x62, 0x1f, 0xdf, 0x3d, 0x6f, 0x14, 0xcd, 0x26, 0x78, 0x09, 0xc3, 0x2f, 0x75, 0x02, 0xe9, 0x10, 0x56,
    0x33, 0xe7, 0x19, 0x5b, 0x38, 0xf5, 0x02, 0x4c, 0x25, 0xfb, 0x0b, 0x41, 0x2e, 0x9a, 0xd7, 0x61, 0x8c, 0x94, 0xde,
    0x6c, 0x87, 0x86, 0xc5, 0x7b, 0x9a, 0x88, 0xcc, 0x76, 0x91, 0xa2, 0xf3, 0x55, 0xa0, 0xac, 0xfa, 0x58, 0xab, 0xbe,
    0xe1, 0x4f, 0xb6, 0xb0, 0xe8, 0x42, 0xbd, 0xea, 0x9f, 0x09, 0xd4, 0xe4, 0x96, 0x04, 0xdf, 0xf6, 0x8d, 0x13, 0xc2,
    0xf8, 0x84, 0x1e, 0xc9, 0xd2, 0xbb, 0x3d, 0xf8, 0xdc, 0xb2, 0x30, 0xf3, 0xce, 0xa9, 0x27, 0xee, 0xc0, 0xa0, 0x2a,
    0xe5, 0x7a, 0x47, 0xb1, 0x3c, 0x74, 0x4e, 0xbc, 0x37, 0x66, 0x55, 0xab, 0x2a, 0x68, 0x5c, 0xa6, 0x21, 0x42, 0x63,
    0x85, 0x10, 0x4c, 0x6a, 0x88, 0x1b, 0x5e, 0x71, 0x9f, 0x06, 0x50, 0x78, 0x92, 0x0d, 0x0a, 0x0f, 0xd9, 0x64, 0x04,
    0x06, 0xd4, 0x6f, 0x16, 0x1d, 0xc3, 0x72, 0x18, 0x14, 0xce, 0x79, 0x32, 0x2b, 0xed, 0x48, 0x3c, 0x22, 0xe0, 0x43,
    0x2e, 0x39, 0xf7, 0x5e, 0x20, 0x30, 0xfa, 0x55, 0xec, 0x9a, 0xb7, 0x01, 0xe2, 0x93, 0xba, 0x0a, 0xf0, 0x88, 0xad,
    0x17, 0xfe, 0x81, 0xa0, 0x1c, 0xd4, 0xbe, 0x83, 0x2d, 0xda, 0xb7, 0x8e, 0x26, 0xc8, 0xac, 0x99, 0x3b, 0xc6, 0xa5,
    0x94, 0x30, 0x9c, 0xd2, 0xdf, 0x59, 0x92, 0xdb, 0xd2, 0x52, 0x80, 0xc0, 0xc5, 0x4f, 0x8e, 0xc9, 0xc8, 0x44, 0xa4,
    0xf6, 0xeb, 0x75, 0xaa, 0xff, 0xe6, 0x7e, 0xb8, 0xe4, 0xf1, 0x63, 0xb6, 0xed, 0xfc, 0x68, 0x0c, 0x0a, 0x67, 0xb1,
    0x02, 0x03, 0x6a, 0xba, 0x10, 0x18, 0x7d, 0xa7, 0x1e, 0x11, 0x70, 0xac, 0x34, 0x2e, 0x53, 0x9d, 0x3a, 0x27, 0x5e,
    0x96, 0x28, 0x3c, 0x49, 0x8b, 0x26, 0x35, 0x44, 0x80, 0x7c, 0x42, 0x0f, 0xe9, 0x72, 0x4b, 0x02, 0xe2, 0x60, 0x50,
    0x15, 0xff, 0x6e, 0x59, 0x18, 0xf4, 0x44, 0x66, 0x3b, 0xc5, 0x4a, 0x6f, 0x36, 0xce, 0x58, 0x74, 0x21, 0xd3, 0x56,
    0x7d, 0x2c, 0xd8, 0x37, 0xa1, 0x0c, 0x7a, 0x39, 0xa8, 0x01, 0x71, 0x2b, 0xb3, 0x16, 0x6c, 0x25, 0xba, 0x1b, 0x67,
    0x0f, 0x85, 0x38, 0x56, 0x01, 0x8c, 0x35, 0x5d, 0x13, 0x97, 0x22, 0x40, 0x1d, 0x9e, 0x2f, 0x4b, 0x47, 0xe9, 0x64,
    0x22, 0x49, 0xe0, 0x69, 0x29, 0x5b, 0xfb, 0x7e, 0x34, 0x55, 0xf2, 0x73, 0x3f, 0x7f, 0xcd, 0x50, 0x0e, 0x71, 0xc4,
    0x5d, 0x05, 0x63, 0xdf, 0x4a, 0x18, 0x6d, 0xd6, 0x47, 0x13, 0xd7, 0x31, 0xdc, 0xca, 0xd9, 0x38, 0xd1, 0xc1, 0xcb,
    0x23, 0xc6, 0xdc, 0xc5, 0x2a, 0xcb, 0xd7, 0xef, 0x15, 0xe8, 0xe6, 0xe1, 0x1c, 0xe5, 0xed, 0xf3, 0x07, 0xf2, 0xf0,
    0xfd, 0x0e, 0xff, 0xfb, 0xa7, 0x79, 0xb4, 0x92, 0xa9, 0x70, 0xb9, 0x99, 0xbb, 0x6b, 0xae, 0x84, 0xb5, 0x62, 0xa3,
    0x8f, 0x9f, 0x5d, 0x80, 0xbe, 0x91, 0x54, 0x8d, 0xb5, 0x83, 0x4f, 0x9a, 0xa8, 0x8d, 0x46, 0x97, 0xa3
};

static uint8_t U2[256][4] = {
    0x00, 0x00, 0x00, 0x00, 0x0b, 0x0e, 0x09, 0x0d, 0x16, 0x1c, 0x12, 0x1a, 0x1d, 0x12, 0x1b, 0x17, 0x2c, 0x38, 0x24,
    0x34, 0x27, 0x36, 0x2d, 0x39, 0x3a, 0x24, 0x36, 0x2e, 0x31, 0x2a, 0x3f, 0x23, 0x58, 0x70, 0x48, 0x68, 0x53, 0x7e,
    0x41, 0x65, 0x4e, 0x6c, 0x5a, 0x72, 0x45, 0x62, 0x53, 0x7f, 0x74, 0x48, 0x6c, 0x5c, 0x7f, 0x46, 0x65, 0x51, 0x62,
    0x54, 0x7e, 0x46, 0x69, 0x5a, 0x77, 0x4b, 0xb0, 0xe0, 0x90, 0xd0, 0xbb, 0xee, 0x99, 0xdd, 0xa6, 0xfc, 0x82, 0xca,
    0xad, 0xf2, 0x8b, 0xc7, 0x9c, 0xd8, 0xb4, 0xe4, 0x97, 0xd6, 0xbd, 0xe9, 0x8a, 0xc4, 0xa6, 0xfe, 0x81, 0xca, 0xaf,
    0xf3, 0xe8, 0x90, 0xd8, 0xb8, 0xe3, 0x9e, 0xd1, 0xb5, 0xfe, 0x8c, 0xca, 0xa2, 0xf5, 0x82, 0xc3, 0xaf, 0xc4, 0xa8,
    0xfc, 0x8c, 0xcf, 0xa6, 0xf5, 0x81, 0xd2, 0xb4, 0xee, 0x96, 0xd9, 0xba, 0xe7, 0x9b, 0x7b, 0xdb, 0x3b, 0xbb, 0x70,
    0xd5, 0x32, 0xb6, 0x6d, 0xc7, 0x29, 0xa1, 0x66, 0xc9, 0x20, 0xac, 0x57, 0xe3, 0x1f, 0x8f, 0x5c, 0xed, 0x16, 0x82,
    0x41, 0xff, 0x0d, 0x95, 0x4a, 0xf1, 0x04, 0x98, 0x23, 0xab, 0x73, 0xd3, 0x28, 0xa5, 0x7a, 0xde, 0x35, 0xb7, 0x61,
    0xc9, 0x3e, 0xb9, 0x68, 0xc4, 0x0f, 0x93, 0x57, 0xe7, 0x04, 0x9d, 0x5e, 0xea, 0x19, 0x8f, 0x45, 0xfd, 0x12, 0x81,
    0x4c, 0xf0, 0xcb, 0x3b, 0xab, 0x6b, 0xc0, 0x35, 0xa2, 0x66, 0xdd, 0x27, 0xb9, 0x71, 0xd6, 0x29, 0xb0, 0x7c, 0xe7,
    0x03, 0x8f, 0x5f, 0xec, 0x0d, 0x86, 0x52, 0xf1, 0x1f, 0x9d, 0x45, 0xfa, 0x11, 0x94, 0x48, 0x93, 0x4b, 0xe3, 0x03,
    0x98, 0x45, 0xea, 0x0e, 0x85, 0x57, 0xf1, 0x19, 0x8e, 0x59, 0xf8, 0x14, 0xbf, 0x73, 0xc7, 0x37, 0xb4, 0x7d, 0xce,
    0x3a, 0xa9, 0x6f, 0xd5, 0x2d, 0xa2, 0x61, 0xdc, 0x20, 0xf6, 0xad, 0x76, 0x6d, 0xfd, 0xa3, 0x7f, 0x60, 0xe0, 0xb1,
    0x64, 0x77, 0xeb, 0xbf, 0x6d, 0x7a, 0xda, 0x95, 0x52, 0x59, 0xd1, 0x9b, 0x5b, 0x54, 0xcc, 0x89, 0x40, 0x43, 0xc7,
    0x87, 0x49, 0x4e, 0xae, 0xdd, 0x3e, 0x05, 0xa5, 0xd3, 0x37, 0x08, 0xb8, 0xc1, 0x2c, 0x1f, 0xb3, 0xcf, 0x25, 0x12,
    0x82, 0xe5, 0x1a, 0x31, 0x89, 0xeb, 0x13, 0x3c, 0x94, 0xf9, 0x08, 0x2b, 0x9f, 0xf7, 0x01, 0x26, 0x46, 0x4d, 0xe6,
    0xbd, 0x4d, 0x43, 0xef, 0xb0, 0x50, 0x51, 0xf4, 0xa7, 0x5b, 0x5f, 0xfd, 0xaa, 0x6a, 0x75, 0xc2, 0x89, 0x61, 0x7b,
    0xcb, 0x84, 0x7c, 0x69, 0xd0, 0x93, 0x77, 0x67, 0xd9, 0x9e, 0x1e, 0x3d, 0xae, 0xd5, 0x15, 0x33, 0xa7, 0xd8, 0x08,
    0x21, 0xbc, 0xcf, 0x03, 0x2f, 0xb5, 0xc2, 0x32, 0x05, 0x8a, 0xe1, 0x39, 0x0b, 0x83, 0xec, 0x24, 0x19, 0x98, 0xfb,
    0x2f, 0x17, 0x91, 0xf6, 0x8d, 0x76, 0x4d, 0xd6, 0x86, 0x78, 0x44, 0xdb, 0x9b, 0x6a, 0x5f, 0xcc, 0x90, 0x64, 0x56,
    0xc1, 0xa1, 0x4e, 0x69, 0xe2, 0xaa, 0x40, 0x60, 0xef, 0xb7, 0x52, 0x7b, 0xf8, 0xbc, 0x5c, 0x72, 0xf5, 0xd5, 0x06,
    0x05, 0xbe, 0xde, 0x08, 0x0c, 0xb3, 0xc3, 0x1a, 0x17, 0xa4, 0xc8, 0x14, 0x1e, 0xa9, 0xf9, 0x3e, 0x21, 0x8a, 0xf2,
    0x30, 0x28, 0x87, 0xef, 0x22, 0x33, 0x90, 0xe4, 0x2c, 0x3a, 0x9d, 0x3d, 0x96, 0xdd, 0x06, 0x36, 0x98, 0xd4, 0x0b,
    0x2b, 0x8a, 0xcf, 0x1c, 0x20, 0x84, 0xc6, 0x11, 0x11, 0xae, 0xf9, 0x32, 0x1a, 0xa0, 0xf0, 0x3f, 0x07, 0xb2, 0xeb,
    0x28, 0x0c, 0xbc, 0xe2, 0x25, 0x65, 0xe6, 0x95, 0x6e, 0x6e, 0xe8, 0x9c, 0x63, 0x73, 0xfa, 0x87, 0x74, 0x78, 0xf4,
    0x8e, 0x79, 0x49, 0xde, 0xb1, 0x5a, 0x42, 0xd0, 0xb8, 0x57, 0x5f, 0xc2, 0xa3, 0x40, 0x54, 0xcc, 0xaa, 0x4d, 0xf7,
    0x41, 0xec, 0xda, 0xfc, 0x4f, 0xe5, 0xd7, 0xe1, 0x5d, 0xfe, 0xc0, 0xea, 0x53, 0xf7, 0xcd, 0xdb, 0x79, 0xc8, 0xee,
    0xd0, 0x77, 0xc1, 0xe3, 0xcd, 0x65, 0xda, 0xf4, 0xc6, 0x6b, 0xd3, 0xf9, 0xaf, 0x31, 0xa4, 0xb2, 0xa4, 0x3f, 0xad,
    0xbf, 0xb9, 0x2d, 0xb6, 0xa8, 0xb2, 0x23, 0xbf, 0xa5, 0x83, 0x09, 0x80, 0x86, 0x88, 0x07, 0x89, 0x8b, 0x95, 0x15,
    0x92, 0x9c, 0x9e, 0x1b, 0x9b, 0x91, 0x47, 0xa1, 0x7c, 0x0a, 0x4c, 0xaf, 0x75, 0x07, 0x51, 0xbd, 0x6e, 0x10, 0x5a,
    0xb3, 0x67, 0x1d, 0x6b, 0x99, 0x58, 0x3e, 0x60, 0x97, 0x51, 0x33, 0x7d, 0x85, 0x4a, 0x24, 0x76, 0x8b, 0x43, 0x29,
    0x1f, 0xd1, 0x34, 0x62, 0x14, 0xdf, 0x3d, 0x6f, 0x09, 0xcd, 0x26, 0x78, 0x02, 0xc3, 0x2f, 0x75, 0x33, 0xe9, 0x10,
    0x56, 0x38, 0xe7, 0x19, 0x5b, 0x25, 0xf5, 0x02, 0x4c, 0x2e, 0xfb, 0x0b, 0x41, 0x8c, 0x9a, 0xd7, 0x61, 0x87, 0x94,
    0xde, 0x6c, 0x9a, 0x86, 0xc5, 0x7b, 0x91, 0x88, 0xcc, 0x76, 0xa0, 0xa2, 0xf3, 0x55, 0xab, 0xac, 0xfa, 0x58, 0xb6,
    0xbe, 0xe1, 0x4f, 0xbd, 0xb0, 0xe8, 0x42, 0xd4, 0xea, 0x9f, 0x09, 0xdf, 0xe4, 0x96, 0x04, 0xc2, 0xf6, 0x8d, 0x13,
    0xc9, 0xf8, 0x84, 0x1e, 0xf8, 0xd2, 0xbb, 0x3d, 0xf3, 0xdc, 0xb2, 0x30, 0xee, 0xce, 0xa9, 0x27, 0xe5, 0xc0, 0xa0,
    0x2a, 0x3c, 0x7a, 0x47, 0xb1, 0x37, 0x74, 0x4e, 0xbc, 0x2a, 0x66, 0x55, 0xab, 0x21, 0x68, 0x5c, 0xa6, 0x10, 0x42,
    0x63, 0x85, 0x1b, 0x4c, 0x6a, 0x88, 0x06, 0x5e, 0x71, 0x9f, 0x0d, 0x50, 0x78, 0x92, 0x64, 0x0a, 0x0f, 0xd9, 0x6f,
    0x04, 0x06, 0xd4, 0x72, 0x16, 0x1d, 0xc3, 0x79, 0x18, 0x14, 0xce, 0x48, 0x32, 0x2b, 0xed, 0x43, 0x3c, 0x22, 0xe0,
    0x5e, 0x2e, 0x39, 0xf7, 0x55, 0x20, 0x30, 0xfa, 0x01, 0xec, 0x9a, 0xb7, 0x0a, 0xe2, 0x93, 0xba, 0x17, 0xf0, 0x88,
    0xad, 0x1c, 0xfe, 0x81, 0xa0, 0x2d, 0xd4, 0xbe, 0x83, 0x26, 0xda, 0xb7, 0x8e, 0x3b, 0xc8, 0xac, 0x99, 0x30, 0xc6,
    0xa5, 0x94, 0x59, 0x9c, 0xd2, 0xdf, 0x52, 0x92, 0xdb, 0xd2, 0x4f, 0x80, 0xc0, 0xc5, 0x44, 0x8e, 0xc9, 0xc8, 0x75,
    0xa4, 0xf6, 0xeb, 0x7e, 0xaa, 0xff, 0xe6, 0x63, 0xb8, 0xe4, 0xf1, 0x68, 0xb6, 0xed, 0xfc, 0xb1, 0x0c, 0x0a, 0x67,
    0xba, 0x02, 0x03, 0x6a, 0xa7, 0x10, 0x18, 0x7d, 0xac, 0x1e, 0x11, 0x70, 0x9d, 0x34, 0x2e, 0x53, 0x96, 0x3a, 0x27,
    0x5e, 0x8b, 0x28, 0x3c, 0x49, 0x80, 0x26, 0x35, 0x44, 0xe9, 0x7c, 0x42, 0x0f, 0xe2, 0x72, 0x4b, 0x02, 0xff, 0x60,
    0x50, 0x15, 0xf4, 0x6e, 0x59, 0x18, 0xc5, 0x44, 0x66, 0x3b, 0xce, 0x4a, 0x6f, 0x36, 0xd3, 0x58, 0x74, 0x21, 0xd8,
    0x56, 0x7d, 0x2c, 0x7a, 0x37, 0xa1, 0x0c, 0x71, 0x39, 0xa8, 0x01, 0x6c, 0x2b, 0xb3, 0x16, 0x67, 0x25, 0xba, 0x1b,
    0x56, 0x0f, 0x85, 0x38, 0x5d, 0x01, 0x8c, 0x35, 0x40, 0x13, 0x97, 0x22, 0x4b, 0x1d, 0x9e, 0x2f, 0x22, 0x47, 0xe9,
    0x64, 0x29, 0x49, 0xe0, 0x69, 0x34, 0x5b, 0xfb, 0x7e, 0x3f, 0x55, 0xf2, 0x73, 0x0e, 0x7f, 0xcd, 0x50, 0x05, 0x71,
    0xc4, 0x5d, 0x18, 0x63, 0xdf, 0x4a, 0x13, 0x6d, 0xd6, 0x47, 0xca, 0xd7, 0x31, 0xdc, 0xc1, 0xd9, 0x38, 0xd1, 0xdc,
    0xcb, 0x23, 0xc6, 0xd7, 0xc5, 0x2a, 0xcb, 0xe6, 0xef, 0x15, 0xe8, 0xed, 0xe1, 0x1c, 0xe5, 0xf0, 0xf3, 0x07, 0xf2,
    0xfb, 0xfd, 0x0e, 0xff, 0x92, 0xa7, 0x79, 0xb4, 0x99, 0xa9, 0x70, 0xb9, 0x84, 0xbb, 0x6b, 0xae, 0x8f, 0xb5, 0x62,
    0xa3, 0xbe, 0x9f, 0x5d, 0x80, 0xb5, 0x91, 0x54, 0x8d, 0xa8, 0x83, 0x4f, 0x9a, 0xa3, 0x8d, 0x46, 0x97
};

static uint8_t U3[256][4] = {
    0x00, 0x00, 0x00, 0x00, 0x0d, 0x0b, 0x0e, 0x09, 0x1a, 0x16, 0x1c, 0x12, 0x17, 0x1d, 0x12, 0x1b, 0x34, 0x2c, 0x38,
    0x24, 0x39, 0x27, 0x36, 0x2d, 0x2e, 0x3a, 0x24, 0x36, 0x23, 0x31, 0x2a, 0x3f, 0x68, 0x58, 0x70, 0x48, 0x65, 0x53,
    0x7e, 0x41, 0x72, 0x4e, 0x6c, 0x5a, 0x7f, 0x45, 0x62, 0x53, 0x5c, 0x74, 0x48, 0x6c, 0x51, 0x7f, 0x46, 0x65, 0x46,
    0x62, 0x54, 0x7e, 0x4b, 0x69, 0x5a, 0x77, 0xd0, 0xb0, 0xe0, 0x90, 0xdd, 0xbb, 0xee, 0x99, 0xca, 0xa6, 0xfc, 0x82,
    0xc7, 0xad, 0xf2, 0x8b, 0xe4, 0x9c, 0xd8, 0xb4, 0xe9, 0x97, 0xd6, 0xbd, 0xfe, 0x8a, 0xc4, 0xa6, 0xf3, 0x81, 0xca,
    0xaf, 0xb8, 0xe8, 0x90, 0xd8, 0xb5, 0xe3, 0x9e, 0xd1, 0xa2, 0xfe, 0x8c, 0xca, 0xaf, 0xf5, 0x82, 0xc3, 0x8c, 0xc4,
    0xa8, 0xfc, 0x81, 0xcf, 0xa6, 0xf5, 0x96, 0xd2, 0xb4, 0xee, 0x9b, 0xd9, 0xba, 0xe7, 0xbb, 0x7b, 0xdb, 0x3b, 0xb6,
    0x70, 0xd5, 0x32, 0xa1, 0x6d, 0xc7, 0x29, 0xac, 0x66, 0xc9, 0x20, 0x8f, 0x57, 0xe3, 0x1f, 0x82, 0x5c, 0xed, 0x16,
    0x95, 0x41, 0xff, 0x0d, 0x98, 0x4a, 0xf1, 0x04, 0xd3, 0x23, 0xab, 0x73, 0xde, 0x28, 0xa5, 0x7a, 0xc9, 0x35, 0xb7,
    0x61, 0xc4, 0x3e, 0xb9, 0x68, 0xe7, 0x0f, 0x93, 0x57, 0xea, 0x04, 0x9d, 0x5e, 0xfd, 0x19, 0x8f, 0x45, 0xf0, 0x12,
    0x81, 0x4c, 0x6b, 0xcb, 0x3b, 0xab, 0x66, 0xc0, 0x35, 0xa2, 0x71, 0xdd, 0x27, 0xb9, 0x7c, 0xd6, 0x29, 0xb0, 0x5f,
    0xe7, 0x03, 0x8f, 0x52, 0xec, 0x0d, 0x86, 0x45, 0xf1, 0x1f, 0x9d, 0x48, 0xfa, 0x11, 0x94, 0x03, 0x93, 0x4b, 0xe3,
    0x0e, 0x98, 0x45, 0xea, 0x19, 0x85, 0x57, 0xf1, 0x14, 0x8e, 0x59, 0xf8, 0x37, 0xbf, 0x73, 0xc7, 0x3a, 0xb4, 0x7d,
    0xce, 0x2d, 0xa9, 0x6f, 0xd5, 0x20, 0xa2, 0x61, 0xdc, 0x6d, 0xf6, 0xad, 0x76, 0x60, 0xfd, 0xa3, 0x7f, 0x77, 0xe0,
    0xb1, 0x64, 0x7a, 0xeb, 0xbf, 0x6d, 0x59, 0xda, 0x95, 0x52, 0x54, 0xd1, 0x9b, 0x5b, 0x43, 0xcc, 0x89, 0x40, 0x4e,
    0xc7, 0x87, 0x49, 0x05, 0xae, 0xdd, 0x3e, 0x08, 0xa5, 0xd3, 0x37, 0x1f, 0xb8, 0xc1, 0x2c, 0x12, 0xb3, 0xcf, 0x25,
    0x31, 0x82, 0xe5, 0x1a, 0x3c, 0x89, 0xeb, 0x13, 0x2b, 0x94, 0xf9, 0x08, 0x26, 0x9f, 0xf7, 0x01, 0xbd, 0x46, 0x4d,
    0xe6, 0xb0, 0x4d, 0x43, 0xef, 0xa7, 0x50, 0x51, 0xf4, 0xaa, 0x5b, 0x5f, 0xfd, 0x89, 0x6a, 0x75, 0xc2, 0x84, 0x61,
    0x7b, 0xcb, 0x93, 0x7c, 0x69, 0xd0, 0x9e, 0x77, 0x67, 0xd9, 0xd5, 0x1e, 0x3d, 0xae, 0xd8, 0x15, 0x33, 0xa7, 0xcf,
    0x08, 0x21, 0xbc, 0xc2, 0x03, 0x2f, 0xb5, 0xe1, 0x32, 0x05, 0x8a, 0xec, 0x39, 0x0b, 0x83, 0xfb, 0x24, 0x19, 0x98,
    0xf6, 0x2f, 0x17, 0x91, 0xd6, 0x8d, 0x76, 0x4d, 0xdb, 0x86, 0x78, 0x44, 0xcc, 0x9b, 0x6a, 0x5f, 0xc1, 0x90, 0x64,
    0x56, 0xe2, 0xa1, 0x4e, 0x69, 0xef, 0xaa, 0x40, 0x60, 0xf8, 0xb7, 0x52, 0x7b, 0xf5, 0xbc, 0x5c, 0x72, 0xbe, 0xd5,
    0x06, 0x05, 0xb3, 0xde, 0x08, 0x0c, 0xa4, 0xc3, 0x1a, 0x17, 0xa9, 0xc8, 0x14, 0x1e, 0x8a, 0xf9, 0x3e, 0x21, 0x87,
    0xf2, 0x30, 0x28, 0x90, 0xef, 0x22, 0x33, 0x9d, 0xe4, 0x2c, 0x3a, 0x06, 0x3d, 0x96, 0xdd, 0x0b, 0x36, 0x98, 0xd4,
    0x1c, 0x2b, 0x8a, 0xcf, 0x11, 0x20, 0x84, 0xc6, 0x32, 0x11, 0xae, 0xf9, 0x3f, 0x1a, 0xa0, 0xf0, 0x28, 0x07, 0xb2,
    0xeb, 0x25, 0x0c, 0xbc, 0xe2, 0x6e, 0x65, 0xe6, 0x95, 0x63, 0x6e, 0xe8, 0x9c, 0x74, 0x73, 0xfa, 0x87, 0x79, 0x78,
    0xf4, 0x8e, 0x5a, 0x49, 0xde, 0xb1, 0x57, 0x42, 0xd0, 0xb8, 0x40, 0x5f, 0xc2, 0xa3, 0x4d, 0x54, 0xcc, 0xaa, 0xda,
    0xf7, 0x41, 0xec, 0xd7, 0xfc, 0x4f, 0xe5, 0xc0, 0xe1, 0x5d, 0xfe, 0xcd, 0xea, 0x53, 0xf7, 0xee, 0xdb, 0x79, 0xc8,
    0xe3, 0xd0, 0x77, 0xc1, 0xf4, 0xcd, 0x65, 0xda, 0xf9, 0xc6, 0x6b, 0xd3, 0xb2, 0xaf, 0x31, 0xa4, 0xbf, 0xa4, 0x3f,
    0xad, 0xa8, 0xb9, 0x2d, 0xb6, 0xa5, 0xb2, 0x23, 0xbf, 0x86, 0x83, 0x09, 0x80, 0x8b, 0x88, 0x07, 0x89, 0x9c, 0x95,
    0x15, 0x92, 0x91, 0x9e, 0x1b, 0x9b, 0x0a, 0x47, 0xa1, 0x7c, 0x07, 0x4c, 0xaf, 0x75, 0x10, 0x51, 0xbd, 0x6e, 0x1d,
    0x5a, 0xb3, 0x67, 0x3e, 0x6b, 0x99, 0x58, 0x33, 0x60, 0x97, 0x51, 0x24, 0x7d, 0x85, 0x4a, 0x29, 0x76, 0x8b, 0x43,
    0x62, 0x1f, 0xd1, 0x34, 0x6f, 0x14, 0xdf, 0x3d, 0x78, 0x09, 0xcd, 0x26, 0x75, 0x02, 0xc3, 0x2f, 0x56, 0x33, 0xe9,
    0x10, 0x5b, 0x38, 0xe7, 0x19, 0x4c, 0x25, 0xf5, 0x02, 0x41, 0x2e, 0xfb, 0x0b, 0x61, 0x8c, 0x9a, 0xd7, 0x6c, 0x87,
    0x94, 0xde, 0x7b, 0x9a, 0x86, 0xc5, 0x76, 0x91, 0x88, 0xcc, 0x55, 0xa0, 0xa2, 0xf3, 0x58, 0xab, 0xac, 0xfa, 0x4f,
    0xb6, 0xbe, 0xe1, 0x42, 0xbd, 0xb0, 0xe8, 0x09, 0xd4, 0xea, 0x9f, 0x04, 0xdf, 0xe4, 0x96, 0x13, 0xc2, 0xf6, 0x8d,
    0x1e, 0xc9, 0xf8, 0x84, 0x3d, 0xf8, 0xd2, 0xbb, 0x30, 0xf3, 0xdc, 0xb2, 0x27, 0xee, 0xce, 0xa9, 0x2a, 0xe5, 0xc0,
    0xa0, 0xb1, 0x3c, 0x7a, 0x47, 0xbc, 0x37, 0x74, 0x4e, 0xab, 0x2a, 0x66, 0x55, 0xa6, 0x21, 0x68, 0x5c, 0x85, 0x10,
    0x42, 0x63, 0x88, 0x1b, 0x4c, 0x6a, 0x9f, 0x06, 0x5e, 0x71, 0x92, 0x0d, 0x50, 0x78, 0xd9, 0x64, 0x0a, 0x0f, 0xd4,
    0x6f, 0x04, 0x06, 0xc3, 0x72, 0x16, 0x1d, 0xce, 0x79, 0x18, 0x14, 0xed, 0x48, 0x32, 0x2b, 0xe0, 0x43, 0x3c, 0x22,
    0xf7, 0x5e, 0x2e, 0x39, 0xfa, 0x55, 0x20, 0x30, 0xb7, 0x01, 0xec, 0x9a, 0xba, 0x0a, 0xe2, 0x93, 0xad, 0x17, 0xf0,
    0x88, 0xa0, 0x1c, 0xfe, 0x81, 0x83, 0x2d, 0xd4, 0xbe, 0x8e, 0x26, 0xda, 0xb7, 0x99, 0x3b, 0xc8, 0xac, 0x94, 0x30,
    0xc6, 0xa5, 0xdf, 0x59, 0x9c, 0xd2, 0xd2, 0x52, 0x92, 0xdb, 0xc5, 0x4f, 0x80, 0xc0, 0xc8, 0x44, 0x8e, 0xc9, 0xeb,
    0x75, 0xa4, 0xf6, 0xe6, 0x7e, 0xaa, 0xff, 0xf1, 0x63, 0xb8, 0xe4, 0xfc, 0x68, 0xb6, 0xed, 0x67, 0xb1, 0x0c, 0x0a,
    0x6a, 0xba, 0x02, 0x03, 0x7d, 0xa7, 0x10, 0x18, 0x70, 0xac, 0x1e, 0x11, 0x53, 0x9d, 0x34, 0x2e, 0x5e, 0x96, 0x3a,
    0x27, 0x49, 0x8b, 0x28, 0x3c, 0x44, 0x80, 0x26, 0x35, 0x0f, 0xe9, 0x7c, 0x42, 0x02, 0xe2, 0x72, 0x4b, 0x15, 0xff,
    0x60, 0x50, 0x18, 0xf4, 0x6e, 0x59, 0x3b, 0xc5, 0x44, 0x66, 0x36, 0xce, 0x4a, 0x6f, 0x21, 0xd3, 0x58, 0x74, 0x2c,
    0xd8, 0x56, 0x7d, 0x0c, 0x7a, 0x37, 0xa1, 0x01, 0x71, 0x39, 0xa8, 0x16, 0x6c, 0x2b, 0xb3, 0x1b, 0x67, 0x25, 0xba,
    0x38, 0x56, 0x0f, 0x85, 0x35, 0x5d, 0x01, 0x8c, 0x22, 0x40, 0x13, 0x97, 0x2f, 0x4b, 0x1d, 0x9e, 0x64, 0x22, 0x47,
    0xe9, 0x69, 0x29, 0x49, 0xe0, 0x7e, 0x34, 0x5b, 0xfb, 0x73, 0x3f, 0x55, 0xf2, 0x50, 0x0e, 0x7f, 0xcd, 0x5d, 0x05,
    0x71, 0xc4, 0x4a, 0x18, 0x63, 0xdf, 0x47, 0x13, 0x6d, 0xd6, 0xdc, 0xca, 0xd7, 0x31, 0xd1, 0xc1, 0xd9, 0x38, 0xc6,
    0xdc, 0xcb, 0x23, 0xcb, 0xd7, 0xc5, 0x2a, 0xe8, 0xe6, 0xef, 0x15, 0xe5, 0xed, 0xe1, 0x1c, 0xf2, 0xf0, 0xf3, 0x07,
    0xff, 0xfb, 0xfd, 0x0e, 0xb4, 0x92, 0xa7, 0x79, 0xb9, 0x99, 0xa9, 0x70, 0xae, 0x84, 0xbb, 0x6b, 0xa3, 0x8f, 0xb5,
    0x62, 0x80, 0xbe, 0x9f, 0x5d, 0x8d, 0xb5, 0x91, 0x54, 0x9a, 0xa8, 0x83, 0x4f, 0x97, 0xa3, 0x8d, 0x46
};

static uint8_t U4[256][4] = {
    0x00, 0x00, 0x00, 0x00, 0x09, 0x0d, 0x0b, 0x0e, 0x12, 0x1a, 0x16, 0x1c, 0x1b, 0x17, 0x1d, 0x12, 0x24, 0x34, 0x2c,
    0x38, 0x2d, 0x39, 0x27, 0x36, 0x36, 0x2e, 0x3a, 0x24, 0x3f, 0x23, 0x31, 0x2a, 0x48, 0x68, 0x58, 0x70, 0x41, 0x65,
    0x53, 0x7e, 0x5a, 0x72, 0x4e, 0x6c, 0x53, 0x7f, 0x45, 0x62, 0x6c, 0x5c, 0x74, 0x48, 0x65, 0x51, 0x7f, 0x46, 0x7e,
    0x46, 0x62, 0x54, 0x77, 0x4b, 0x69, 0x5a, 0x90, 0xd0, 0xb0, 0xe0, 0x99, 0xdd, 0xbb, 0xee, 0x82, 0xca, 0xa6, 0xfc,
    0x8b, 0xc7, 0xad, 0xf2, 0xb4, 0xe4, 0x9c, 0xd8, 0xbd, 0xe9, 0x97, 0xd6, 0xa6, 0xfe, 0x8a, 0xc4, 0xaf, 0xf3, 0x81,
    0xca, 0xd8, 0xb8, 0xe8, 0x90, 0xd1, 0xb5, 0xe3, 0x9e, 0xca, 0xa2, 0xfe, 0x8c, 0xc3, 0xaf, 0xf5, 0x82, 0xfc, 0x8c,
    0xc4, 0xa8, 0xf5, 0x81, 0xcf, 0xa6, 0xee, 0x96, 0xd2, 0xb4, 0xe7, 0x9b, 0xd9, 0xba, 0x3b, 0xbb, 0x7b, 0xdb, 0x32,
    0xb6, 0x70, 0xd5, 0x29, 0xa1, 0x6d, 0xc7, 0x20, 0xac, 0x66, 0xc9, 0x1f, 0x8f, 0x57, 0xe3, 0x16, 0x82, 0x5c, 0xed,
    0x0d, 0x95, 0x41, 0xff, 0x04, 0x98, 0x4a, 0xf1, 0x73, 0xd3, 0x23, 0xab, 0x7a, 0xde, 0x28, 0xa5, 0x61, 0xc9, 0x35,
    0xb7, 0x68, 0xc4, 0x3e, 0xb9, 0x57, 0xe7, 0x0f, 0x93, 0x5e, 0xea, 0x04, 0x9d, 0x45, 0xfd, 0x19, 0x8f, 0x4c, 0xf0,
    0x12, 0x81, 0xab, 0x6b, 0xcb, 0x3b, 0xa2, 0x66, 0xc0, 0x35, 0xb9, 0x71, 0xdd, 0x27, 0xb0, 0x7c, 0xd6, 0x29, 0x8f,
    0x5f, 0xe7, 0x03, 0x86, 0x52, 0xec, 0x0d, 0x9d, 0x45, 0xf1, 0x1f, 0x94, 0x48, 0xfa, 0x11, 0xe3, 0x03, 0x93, 0x4b,
    0xea, 0x0e, 0x98, 0x45, 0xf1, 0x19, 0x85, 0x57, 0xf8, 0x14, 0x8e, 0x59, 0xc7, 0x37, 0xbf, 0x73, 0xce, 0x3a, 0xb4,
    0x7d, 0xd5, 0x2d, 0xa9, 0x6f, 0xdc, 0x20, 0xa2, 0x61, 0x76, 0x6d, 0xf6, 0xad, 0x7f, 0x60, 0xfd, 0xa3, 0x64, 0x77,
    0xe0, 0xb1, 0x6d, 0x7a, 0xeb, 0xbf, 0x52, 0x59, 0xda, 0x95, 0x5b, 0x54, 0xd1, 0x9b, 0x40, 0x43, 0xcc, 0x89, 0x49,
    0x4e, 0xc7, 0x87, 0x3e, 0x05, 0xae, 0xdd, 0x37, 0x08, 0xa5, 0xd3, 0x2c, 0x1f, 0xb8, 0xc1, 0x25, 0x12, 0xb3, 0xcf,
    0x1a, 0x31, 0x82, 0xe5, 0x13, 0x3c, 0x89, 0xeb, 0x08, 0x2b, 0x94, 0xf9, 0x01, 0x26, 0x9f, 0xf7, 0xe6, 0xbd, 0x46,
    0x4d, 0xef, 0xb0, 0x4d, 0x43, 0xf4, 0xa7, 0x50, 0x51, 0xfd, 0xaa, 0x5b, 0x5f, 0xc2, 0x89, 0x6a, 0x75, 0xcb, 0x84,
    0x61, 0x7b, 0xd0, 0x93, 0x7c, 0x69, 0xd9, 0x9e, 0x77, 0x67, 0xae, 0xd5, 0x1e, 0x3d, 0xa7, 0xd8, 0x15, 0x33, 0xbc,
    0xcf, 0x08, 0x21, 0xb5, 0xc2, 0x03, 0x2f, 0x8a, 0xe1, 0x32, 0x05, 0x83, 0xec, 0x39, 0x0b, 0x98, 0xfb, 0x24, 0x19,
    0x91, 0xf6, 0x2f, 0x17, 0x4d, 0xd6, 0x8d, 0x76, 0x44, 0xdb, 0x86, 0x78, 0x5f, 0xcc, 0x9b, 0x6a, 0x56, 0xc1, 0x90,
    0x64, 0x69, 0xe2, 0xa1, 0x4e, 0x60, 0xef, 0xaa, 0x40, 0x7b, 0xf8, 0xb7, 0x52, 0x72, 0xf5, 0xbc, 0x5c, 0x05, 0xbe,
    0xd5, 0x06, 0x0c, 0xb3, 0xde, 0x08, 0x17, 0xa4, 0xc3, 0x1a, 0x1e, 0xa9, 0xc8, 0x14, 0x21, 0x8a, 0xf9, 0x3e, 0x28,
    0x87, 0xf2, 0x30, 0x33, 0x90, 0xef, 0x22, 0x3a, 0x9d, 0xe4, 0x2c, 0xdd, 0x06, 0x3d, 0x96, 0xd4, 0x0b, 0x36, 0x98,
    0xcf, 0x1c, 0x2b, 0x8a, 0xc6, 0x11, 0x20, 0x84, 0xf9, 0x32, 0x11, 0xae, 0xf0, 0x3f, 0x1a, 0xa0, 0xeb, 0x28, 0x07,
    0xb2, 0xe2, 0x25, 0x0c, 0xbc, 0x95, 0x6e, 0x65, 0xe6, 0x9c, 0x63, 0x6e, 0xe8, 0x87, 0x74, 0x73, 0xfa, 0x8e, 0x79,
    0x78, 0xf4, 0xb1, 0x5a, 0x49, 0xde, 0xb8, 0x57, 0x42, 0xd0, 0xa3, 0x40, 0x5f, 0xc2, 0xaa, 0x4d, 0x54, 0xcc, 0xec,
    0xda, 0xf7, 0x41, 0xe5, 0xd7, 0xfc, 0x4f, 0xfe, 0xc0, 0xe1, 0x5d, 0xf7, 0xcd, 0xea, 0x53, 0xc8, 0xee, 0xdb, 0x79,
    0xc1, 0xe3, 0xd0, 0x77, 0xda, 0xf4, 0xcd, 0x65, 0xd3, 0xf9, 0xc6, 0x6b, 0xa4, 0xb2, 0xaf, 0x31, 0xad, 0xbf, 0xa4,
    0x3f, 0xb6, 0xa8, 0xb9, 0x2d, 0xbf, 0xa5, 0xb2, 0x23, 0x80, 0x86, 0x83, 0x09, 0x89, 0x8b, 0x88, 0x07, 0x92, 0x9c,
    0x95, 0x15, 0x9b, 0x91, 0x9e, 0x1b, 0x7c, 0x0a, 0x47, 0xa1, 0x75, 0x07, 0x4c, 0xaf, 0x6e, 0x10, 0x51, 0xbd, 0x67,
    0x1d, 0x5a, 0xb3, 0x58, 0x3e, 0x6b, 0x99, 0x51, 0x33, 0x60, 0x97, 0x4a, 0x24, 0x7d, 0x85, 0x43, 0x29, 0x76, 0x8b,
    0x34, 0x62, 0x1f, 0xd1, 0x3d, 0x6f, 0x14, 0xdf, 0x26, 0x78, 0x09, 0xcd, 0x2f, 0x75, 0x02, 0xc3, 0x10, 0x56, 0x33,
    0xe9, 0x19, 0x5b, 0x38, 0xe7, 0x02, 0x4c, 0x25, 0xf5, 0x0b, 0x41, 0x2e, 0xfb, 0xd7, 0x61, 0x8c, 0x9a, 0xde, 0x6c,
    0x87, 0x94, 0xc5, 0x7b, 0x9a, 0x86, 0xcc, 0x76, 0x91, 0x88, 0xf3, 0x55, 0xa0, 0xa2, 0xfa, 0x58, 0xab, 0xac, 0xe1,
    0x4f, 0xb6, 0xbe, 0xe8, 0x42, 0xbd, 0xb0, 0x9f, 0x09, 0xd4, 0xea, 0x96, 0x04, 0xdf, 0xe4, 0x8d, 0x13, 0xc2, 0xf6,
    0x84, 0x1e, 0xc9, 0xf8, 0xbb, 0x3d, 0xf8, 0xd2, 0xb2, 0x30, 0xf3, 0xdc, 0xa9, 0x27, 0xee, 0xce, 0xa0, 0x2a, 0xe5,
    0xc0, 0x47, 0xb1, 0x3c, 0x7a, 0x4e, 0xbc, 0x37, 0x74, 0x55, 0xab, 0x2a, 0x66, 0x5c, 0xa6, 0x21, 0x68, 0x63, 0x85,
    0x10, 0x42, 0x6a, 0x88, 0x1b, 0x4c, 0x71, 0x9f, 0x06, 0x5e, 0x78, 0x92, 0x0d, 0x50, 0x0f, 0xd9, 0x64, 0x0a, 0x06,
    0xd4, 0x6f, 0x04, 0x1d, 0xc3, 0x72, 0x16, 0x14, 0xce, 0x79, 0x18, 0x2b, 0xed, 0x48, 0x32, 0x22, 0xe0, 0x43, 0x3c,
    0x39, 0xf7, 0x5e, 0x2e, 0x30, 0xfa, 0x55, 0x20, 0x9a, 0xb7, 0x01, 0xec, 0x93, 0xba, 0x0a, 0xe2, 0x88, 0xad, 0x17,
    0xf0, 0x81, 0xa0, 0x1c, 0xfe, 0xbe, 0x83, 0x2d, 0xd4, 0xb7, 0x8e, 0x26, 0xda, 0xac, 0x99, 0x3b, 0xc8, 0xa5, 0x94,
    0x30, 0xc6, 0xd2, 0xdf, 0x59, 0x9c, 0xdb, 0xd2, 0x52, 0x92, 0xc0, 0xc5, 0x4f, 0x80, 0xc9, 0xc8, 0x44, 0x8e, 0xf6,
    0xeb, 0x75, 0xa4, 0xff, 0xe6, 0x7e, 0xaa, 0xe4, 0xf1, 0x63, 0xb8, 0xed, 0xfc, 0x68, 0xb6, 0x0a, 0x67, 0xb1, 0x0c,
    0x03, 0x6a, 0xba, 0x02, 0x18, 0x7d, 0xa7, 0x10, 0x11, 0x70, 0xac, 0x1e, 0x2e, 0x53, 0x9d, 0x34, 0x27, 0x5e, 0x96,
    0x3a, 0x3c, 0x49, 0x8b, 0x28, 0x35, 0x44, 0x80, 0x26, 0x42, 0x0f, 0xe9, 0x7c, 0x4b, 0x02, 0xe2, 0x72, 0x50, 0x15,
    0xff, 0x60, 0x59, 0x18, 0xf4, 0x6e, 0x66, 0x3b, 0xc5, 0x44, 0x6f, 0x36, 0xce, 0x4a, 0x74, 0x21, 0xd3, 0x58, 0x7d,
    0x2c, 0xd8, 0x56, 0xa1, 0x0c, 0x7a, 0x37, 0xa8, 0x01, 0x71, 0x39, 0xb3, 0x16, 0x6c, 0x2b, 0xba, 0x1b, 0x67, 0x25,
    0x85, 0x38, 0x56, 0x0f, 0x8c, 0x35, 0x5d, 0x01, 0x97, 0x22, 0x40, 0x13, 0x9e, 0x2f, 0x4b, 0x1d, 0xe9, 0x64, 0x22,
    0x47, 0xe0, 0x69, 0x29, 0x49, 0xfb, 0x7e, 0x34, 0x5b, 0xf2, 0x73, 0x3f, 0x55, 0xcd, 0x50, 0x0e, 0x7f, 0xc4, 0x5d,
    0x05, 0x71, 0xdf, 0x4a, 0x18, 0x63, 0xd6, 0x47, 0x13, 0x6d, 0x31, 0xdc, 0xca, 0xd7, 0x38, 0xd1, 0xc1, 0xd9, 0x23,
    0xc6, 0xdc, 0xcb, 0x2a, 0xcb, 0xd7, 0xc5, 0x15, 0xe8, 0xe6, 0xef, 0x1c, 0xe5, 0xed, 0xe1, 0x07, 0xf2, 0xf0, 0xf3,
    0x0e, 0xff, 0xfb, 0xfd, 0x79, 0xb4, 0x92, 0xa7, 0x70, 0xb9, 0x99, 0xa9, 0x6b, 0xae, 0x84, 0xbb, 0x62, 0xa3, 0x8f,
    0xb5, 0x5d, 0x80, 0xbe, 0x9f, 0x54, 0x8d, 0xb5, 0x91, 0x4f, 0x9a, 0xa8, 0x83, 0x46, 0x97, 0xa3, 0x8d
};

static uint32_t rcon[30] = { 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36, 0x6c, 0xd8, 0xab, 0x4d, 0x9a,
                             0x2f, 0x5e, 0xbc, 0x63, 0xc6, 0x97, 0x35, 0x6a, 0xd4, 0xb3, 0x7d, 0xfa, 0xef, 0xc5, 0x91 };

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// API
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Rijndael::Rijndael()
{
    m_state = Invalid;
}

Rijndael::~Rijndael()
{
    // nothing here
}

int Rijndael::init(Mode mode, Direction dir, const uint8_t *key, KeyLength keyLen, uint8_t *initVector)
{
    // Not initialized yet
    m_state = Invalid;

    // Check the mode
    if ((mode != CBC) && (mode != ECB) && (mode != CFB1))
        return RIJNDAEL_UNSUPPORTED_MODE;
    m_mode = mode;

    // And the direction
    if ((dir != Encrypt) && (dir != Decrypt))
        return RIJNDAEL_UNSUPPORTED_DIRECTION;
    m_direction = dir;

    // Allow to set an init vector
    if (initVector)
    {
        // specified init vector
        for (int i = 0; i < MAX_IV_SIZE; i++)
        {
            m_initVector[i] = initVector[i];
        }
    }
    else
    {
        // zero init vector
        for (int i = 0; i < MAX_IV_SIZE; i++)
        {
            m_initVector[i] = 0;
        }
    }

    uint32_t uKeyLenInBytes;

    // And check the key length
    switch (keyLen)
    {
        case Key16Bytes:
            uKeyLenInBytes = 16;
            m_uRounds = 10;
            break;
        case Key24Bytes:
            uKeyLenInBytes = 24;
            m_uRounds = 12;
            break;
        case Key32Bytes:
            uKeyLenInBytes = 32;
            m_uRounds = 14;
            break;
        default:
            return RIJNDAEL_UNSUPPORTED_KEY_LENGTH;
            break;
    }
    // The number of rounds is calculated as
    // m_uRounds = (m_uKeyLenInBits / 32) + 6;

    if (!key)
        return RIJNDAEL_BAD_KEY;

    uint8_t keyMatrix[_MAX_KEY_COLUMNS][4];

    for (uint32_t i = 0; i < uKeyLenInBytes; i++)
        keyMatrix[i >> 2][i & 3] = key[i];

    keySched(keyMatrix);

    if (m_direction == Decrypt)
        keyEncToDec();

    m_state = Valid;

    return RIJNDAEL_SUCCESS;
}

int Rijndael::blockEncrypt(const uint8_t *input, int inputLen, uint8_t *outBuffer)
{
    int i, k, numBlocks;
    uint8_t block[16], iv[4][4];

    if (m_state != Valid)
        return RIJNDAEL_NOT_INITIALIZED;
    if (m_direction != Encrypt)
        return RIJNDAEL_BAD_DIRECTION;

    if (input == 0 || inputLen <= 0)
        return 0;

    numBlocks = inputLen / 128;

    switch (m_mode)
    {
        case ECB:
            for (i = numBlocks; i > 0; i--)
            {
                encrypt(input, outBuffer);
                input += 16;
                outBuffer += 16;
            }
            break;
        case CBC:
            ((uint32_t *)block)[0] = ((uint32_t *)m_initVector)[0] ^ ((uint32_t *)input)[0];
            ((uint32_t *)block)[1] = ((uint32_t *)m_initVector)[1] ^ ((uint32_t *)input)[1];
            ((uint32_t *)block)[2] = ((uint32_t *)m_initVector)[2] ^ ((uint32_t *)input)[2];
            ((uint32_t *)block)[3] = ((uint32_t *)m_initVector)[3] ^ ((uint32_t *)input)[3];
            encrypt(block, outBuffer);
            input += 16;
            for (i = numBlocks - 1; i > 0; i--)
            {
                ((uint32_t *)block)[0] = ((uint32_t *)outBuffer)[0] ^ ((uint32_t *)input)[0];
                ((uint32_t *)block)[1] = ((uint32_t *)outBuffer)[1] ^ ((uint32_t *)input)[1];
                ((uint32_t *)block)[2] = ((uint32_t *)outBuffer)[2] ^ ((uint32_t *)input)[2];
                ((uint32_t *)block)[3] = ((uint32_t *)outBuffer)[3] ^ ((uint32_t *)input)[3];
                outBuffer += 16;
                encrypt(block, outBuffer);
                input += 16;
            }
            break;
        case CFB1:
#if STRICT_ALIGN
            memcpy(iv, m_initVector, 16);
#else  /* !STRICT_ALIGN */
            *((uint32_t *)iv[0]) = *((uint32_t *)(m_initVector));
            *((uint32_t *)iv[1]) = *((uint32_t *)(m_initVector + 4));
            *((uint32_t *)iv[2]) = *((uint32_t *)(m_initVector + 8));
            *((uint32_t *)iv[3]) = *((uint32_t *)(m_initVector + 12));
#endif /* ?STRICT_ALIGN */
            for (i = numBlocks; i > 0; i--)
            {
                for (k = 0; k < 128; k++)
                {
                    *((uint32_t *)block) = *((uint32_t *)iv[0]);
                    *((uint32_t *)(block + 4)) = *((uint32_t *)iv[1]);
                    *((uint32_t *)(block + 8)) = *((uint32_t *)iv[2]);
                    *((uint32_t *)(block + 12)) = *((uint32_t *)iv[3]);
                    encrypt(block, block);
                    outBuffer[k / 8] ^= (block[0] & 0x80) >> (k & 7);
                    iv[0][0] = (iv[0][0] << 1) | (iv[0][1] >> 7);
                    iv[0][1] = (iv[0][1] << 1) | (iv[0][2] >> 7);
                    iv[0][2] = (iv[0][2] << 1) | (iv[0][3] >> 7);
                    iv[0][3] = (iv[0][3] << 1) | (iv[1][0] >> 7);
                    iv[1][0] = (iv[1][0] << 1) | (iv[1][1] >> 7);
                    iv[1][1] = (iv[1][1] << 1) | (iv[1][2] >> 7);
                    iv[1][2] = (iv[1][2] << 1) | (iv[1][3] >> 7);
                    iv[1][3] = (iv[1][3] << 1) | (iv[2][0] >> 7);
                    iv[2][0] = (iv[2][0] << 1) | (iv[2][1] >> 7);
                    iv[2][1] = (iv[2][1] << 1) | (iv[2][2] >> 7);
                    iv[2][2] = (iv[2][2] << 1) | (iv[2][3] >> 7);
                    iv[2][3] = (iv[2][3] << 1) | (iv[3][0] >> 7);
                    iv[3][0] = (iv[3][0] << 1) | (iv[3][1] >> 7);
                    iv[3][1] = (iv[3][1] << 1) | (iv[3][2] >> 7);
                    iv[3][2] = (iv[3][2] << 1) | (iv[3][3] >> 7);
                    iv[3][3] = (iv[3][3] << 1) | (outBuffer[k / 8] >> (7 - (k & 7))) & 1;
                }
            }
            break;
        default:
            return -1;
            break;
    }

    return 128 * numBlocks;
}

int Rijndael::padEncrypt(const uint8_t *input, int inputOctets, uint8_t *outBuffer)
{
    int i, numBlocks, padLen;
    uint8_t block[16], *iv;

    if (m_state != Valid)
        return RIJNDAEL_NOT_INITIALIZED;
    if (m_direction != Encrypt)
        return RIJNDAEL_NOT_INITIALIZED;

    if (input == 0 || inputOctets <= 0)
        return 0;

    numBlocks = inputOctets / 16;

    switch (m_mode)
    {
        case ECB:
            for (i = numBlocks; i > 0; i--)
            {
                encrypt(input, outBuffer);
                input += 16;
                outBuffer += 16;
            }
            padLen = 16 - (inputOctets - 16 * numBlocks);
            //			assert(padLen > 0 && padLen <= 16);
            memcpy(block, input, 16 - padLen);
            memset(block + 16 - padLen, padLen, padLen);
            encrypt(block, outBuffer);
            break;
        case CBC:
            iv = m_initVector;
            for (i = numBlocks; i > 0; i--)
            {
                ((uint32_t *)block)[0] = ((uint32_t *)input)[0] ^ ((uint32_t *)iv)[0];
                ((uint32_t *)block)[1] = ((uint32_t *)input)[1] ^ ((uint32_t *)iv)[1];
                ((uint32_t *)block)[2] = ((uint32_t *)input)[2] ^ ((uint32_t *)iv)[2];
                ((uint32_t *)block)[3] = ((uint32_t *)input)[3] ^ ((uint32_t *)iv)[3];
                encrypt(block, outBuffer);
                iv = outBuffer;
                input += 16;
                outBuffer += 16;
            }
            padLen = 16 - (inputOctets - 16 * numBlocks);
            //			assert(padLen > 0 && padLen <= 16); // DO SOMETHING HERE ?
            for (i = 0; i < 16 - padLen; i++)
            {
                block[i] = input[i] ^ iv[i];
            }
            for (i = 16 - padLen; i < 16; i++)
            {
                block[i] = (uint8_t)padLen ^ iv[i];
            }
            encrypt(block, outBuffer);
            break;
        default:
            return -1;
            break;
    }

    return 16 * (numBlocks + 1);
}

int Rijndael::blockDecrypt(const uint8_t *input, int inputLen, uint8_t *outBuffer)
{
    int i, k, numBlocks;
    uint8_t block[16], iv[4][4];

    if (m_state != Valid)
        return RIJNDAEL_NOT_INITIALIZED;
    if ((m_mode != CFB1) && (m_direction == Encrypt))
        return RIJNDAEL_BAD_DIRECTION;

    if (input == 0 || inputLen <= 0)
        return 0;

    numBlocks = inputLen / 128;

    switch (m_mode)
    {
        case ECB:
            for (i = numBlocks; i > 0; i--)
            {
                decrypt(input, outBuffer);
                input += 16;
                outBuffer += 16;
            }
            break;
        case CBC:
#if STRICT_ALIGN
            memcpy(iv, m_initVector, 16);
#else
            *((uint32_t *)iv[0]) = *((uint32_t *)(m_initVector));
            *((uint32_t *)iv[1]) = *((uint32_t *)(m_initVector + 4));
            *((uint32_t *)iv[2]) = *((uint32_t *)(m_initVector + 8));
            *((uint32_t *)iv[3]) = *((uint32_t *)(m_initVector + 12));
#endif
            for (i = numBlocks; i > 0; i--)
            {
                decrypt(input, block);
                ((uint32_t *)block)[0] ^= *((uint32_t *)iv[0]);
                ((uint32_t *)block)[1] ^= *((uint32_t *)iv[1]);
                ((uint32_t *)block)[2] ^= *((uint32_t *)iv[2]);
                ((uint32_t *)block)[3] ^= *((uint32_t *)iv[3]);
#if STRICT_ALIGN
                memcpy(iv, input, 16);
                memcpy(outBuf, block, 16);
#else
                *((uint32_t *)iv[0]) = ((uint32_t *)input)[0];
                ((uint32_t *)outBuffer)[0] = ((uint32_t *)block)[0];
                *((uint32_t *)iv[1]) = ((uint32_t *)input)[1];
                ((uint32_t *)outBuffer)[1] = ((uint32_t *)block)[1];
                *((uint32_t *)iv[2]) = ((uint32_t *)input)[2];
                ((uint32_t *)outBuffer)[2] = ((uint32_t *)block)[2];
                *((uint32_t *)iv[3]) = ((uint32_t *)input)[3];
                ((uint32_t *)outBuffer)[3] = ((uint32_t *)block)[3];
#endif
                input += 16;
                outBuffer += 16;
            }
            break;
        case CFB1:
#if STRICT_ALIGN
            memcpy(iv, m_initVector, 16);
#else
            *((uint32_t *)iv[0]) = *((uint32_t *)(m_initVector));
            *((uint32_t *)iv[1]) = *((uint32_t *)(m_initVector + 4));
            *((uint32_t *)iv[2]) = *((uint32_t *)(m_initVector + 8));
            *((uint32_t *)iv[3]) = *((uint32_t *)(m_initVector + 12));
#endif
            for (i = numBlocks; i > 0; i--)
            {
                for (k = 0; k < 128; k++)
                {
                    *((uint32_t *)block) = *((uint32_t *)iv[0]);
                    *((uint32_t *)(block + 4)) = *((uint32_t *)iv[1]);
                    *((uint32_t *)(block + 8)) = *((uint32_t *)iv[2]);
                    *((uint32_t *)(block + 12)) = *((uint32_t *)iv[3]);
                    encrypt(block, block);
                    iv[0][0] = (iv[0][0] << 1) | (iv[0][1] >> 7);
                    iv[0][1] = (iv[0][1] << 1) | (iv[0][2] >> 7);
                    iv[0][2] = (iv[0][2] << 1) | (iv[0][3] >> 7);
                    iv[0][3] = (iv[0][3] << 1) | (iv[1][0] >> 7);
                    iv[1][0] = (iv[1][0] << 1) | (iv[1][1] >> 7);
                    iv[1][1] = (iv[1][1] << 1) | (iv[1][2] >> 7);
                    iv[1][2] = (iv[1][2] << 1) | (iv[1][3] >> 7);
                    iv[1][3] = (iv[1][3] << 1) | (iv[2][0] >> 7);
                    iv[2][0] = (iv[2][0] << 1) | (iv[2][1] >> 7);
                    iv[2][1] = (iv[2][1] << 1) | (iv[2][2] >> 7);
                    iv[2][2] = (iv[2][2] << 1) | (iv[2][3] >> 7);
                    iv[2][3] = (iv[2][3] << 1) | (iv[3][0] >> 7);
                    iv[3][0] = (iv[3][0] << 1) | (iv[3][1] >> 7);
                    iv[3][1] = (iv[3][1] << 1) | (iv[3][2] >> 7);
                    iv[3][2] = (iv[3][2] << 1) | (iv[3][3] >> 7);
                    iv[3][3] = (iv[3][3] << 1) | (input[k / 8] >> (7 - (k & 7))) & 1;
                    outBuffer[k / 8] ^= (block[0] & 0x80) >> (k & 7);
                }
            }
            break;
        default:
            return -1;
            break;
    }

    return 128 * numBlocks;
}

int Rijndael::padDecrypt(const uint8_t *input, int inputOctets, uint8_t *outBuffer)
{
    int i, numBlocks, padLen;
    uint8_t block[16];
    uint32_t iv[4];

    if (m_state != Valid)
        return RIJNDAEL_NOT_INITIALIZED;
    if (m_direction != Decrypt)
        return RIJNDAEL_BAD_DIRECTION;

    if (input == 0 || inputOctets <= 0)
        return 0;

    if ((inputOctets % 16) != 0)
        return RIJNDAEL_CORRUPTED_DATA;

    numBlocks = inputOctets / 16;

    switch (m_mode)
    {
        case ECB:
            for (i = numBlocks - 1; i > 0; i--)
            {
                decrypt(input, outBuffer);
                input += 16;
                outBuffer += 16;
            }

            decrypt(input, block);
            padLen = block[15];
            if (padLen >= 16)
                return RIJNDAEL_CORRUPTED_DATA;
            for (i = 16 - padLen; i < 16; i++)
            {
                if (block[i] != padLen)
                    return RIJNDAEL_CORRUPTED_DATA;
            }
            memcpy(outBuffer, block, 16 - padLen);
            break;
        case CBC:
            memcpy(iv, m_initVector, 16);
            /* all blocks but last */
            for (i = numBlocks - 1; i > 0; i--)
            {
                decrypt(input, block);
                ((uint32_t *)block)[0] ^= iv[0];
                ((uint32_t *)block)[1] ^= iv[1];
                ((uint32_t *)block)[2] ^= iv[2];
                ((uint32_t *)block)[3] ^= iv[3];
                memcpy(iv, input, 16);
                memcpy(outBuffer, block, 16);
                input += 16;
                outBuffer += 16;
            }
            /* last block */
            decrypt(input, block);
            ((uint32_t *)block)[0] ^= iv[0];
            ((uint32_t *)block)[1] ^= iv[1];
            ((uint32_t *)block)[2] ^= iv[2];
            ((uint32_t *)block)[3] ^= iv[3];
            padLen = block[15];
            if (padLen <= 0 || padLen > 16)
                return RIJNDAEL_CORRUPTED_DATA;
            for (i = 16 - padLen; i < 16; i++)
            {
                if (block[i] != padLen)
                    return RIJNDAEL_CORRUPTED_DATA;
            }
            memcpy(outBuffer, block, 16 - padLen);
            break;

        default:
            return -1;
            break;
    }

    return 16 * numBlocks - padLen;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ALGORITHM
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Rijndael::keySched(uint8_t key[_MAX_KEY_COLUMNS][4])
{
    unsigned j, rconpointer = 0;

    // Calculate the necessary round keys
    // The number of calculations depends on keyBits and blockBits
    unsigned uKeyColumns = m_uRounds - 6;

    uint8_t tempKey[_MAX_KEY_COLUMNS][4];

    // Copy the input key to the temporary key matrix

    for (j = 0; j < uKeyColumns; j++)
    {
        *((uint32_t *)(tempKey[j])) = *((uint32_t *)(key[j]));
    }

    unsigned r = 0;
    unsigned t = 0;

    // copy values into round key array
    for (j = 0; (j < uKeyColumns) && (r <= m_uRounds);)
    {
        for (; (j < uKeyColumns) && (t < 4); j++, t++)
        {
            *((uint32_t *)m_expandedKey[r][t]) = *((uint32_t *)tempKey[j]);
        }

        if (t == 4)
        {
            r++;
            t = 0;
        }
    }

    while (r <= m_uRounds)
    {
        tempKey[0][0] ^= S[tempKey[uKeyColumns - 1][1]];
        tempKey[0][1] ^= S[tempKey[uKeyColumns - 1][2]];
        tempKey[0][2] ^= S[tempKey[uKeyColumns - 1][3]];
        tempKey[0][3] ^= S[tempKey[uKeyColumns - 1][0]];
        tempKey[0][0] ^= rcon[rconpointer++];

        if (uKeyColumns != 8)
        {
            for (j = 1; j < uKeyColumns; j++)
            {
                *((uint32_t *)tempKey[j]) ^= *((uint32_t *)tempKey[j - 1]);
            }
        }
        else
        {
            for (j = 1; j < uKeyColumns / 2; j++)
            {
                *((uint32_t *)tempKey[j]) ^= *((uint32_t *)tempKey[j - 1]);
            }
            tempKey[uKeyColumns / 2][0] ^= S[tempKey[uKeyColumns / 2 - 1][0]];
            tempKey[uKeyColumns / 2][1] ^= S[tempKey[uKeyColumns / 2 - 1][1]];
            tempKey[uKeyColumns / 2][2] ^= S[tempKey[uKeyColumns / 2 - 1][2]];
            tempKey[uKeyColumns / 2][3] ^= S[tempKey[uKeyColumns / 2 - 1][3]];
            for (j = uKeyColumns / 2 + 1; j < uKeyColumns; j++)
            {
                *((uint32_t *)tempKey[j]) ^= *((uint32_t *)tempKey[j - 1]);
            }
        }
        for (j = 0; (j < uKeyColumns) && (r <= m_uRounds);)
        {
            for (; (j < uKeyColumns) && (t < 4); j++, t++)
            {
                *((uint32_t *)m_expandedKey[r][t]) = *((uint32_t *)tempKey[j]);
            }
            if (t == 4)
            {
                r++;
                t = 0;
            }
        }
    }
}

void Rijndael::keyEncToDec()
{
    unsigned r;
    uint8_t *w;

    for (r = 1; r < m_uRounds; r++)
    {
        w = m_expandedKey[r][0];
        *((uint32_t *)w) =
            *((uint32_t *)U1[w[0]]) ^ *((uint32_t *)U2[w[1]]) ^ *((uint32_t *)U3[w[2]]) ^ *((uint32_t *)U4[w[3]]);
        w = m_expandedKey[r][1];
        *((uint32_t *)w) =
            *((uint32_t *)U1[w[0]]) ^ *((uint32_t *)U2[w[1]]) ^ *((uint32_t *)U3[w[2]]) ^ *((uint32_t *)U4[w[3]]);
        w = m_expandedKey[r][2];
        *((uint32_t *)w) =
            *((uint32_t *)U1[w[0]]) ^ *((uint32_t *)U2[w[1]]) ^ *((uint32_t *)U3[w[2]]) ^ *((uint32_t *)U4[w[3]]);
        w = m_expandedKey[r][3];
        *((uint32_t *)w) =
            *((uint32_t *)U1[w[0]]) ^ *((uint32_t *)U2[w[1]]) ^ *((uint32_t *)U3[w[2]]) ^ *((uint32_t *)U4[w[3]]);
    }
}

void Rijndael::encrypt(const uint8_t a[16], uint8_t b[16])
{
    unsigned r;
    uint8_t temp[4][4];

    *((uint32_t *)temp[0]) = *((uint32_t *)(a)) ^ *((uint32_t *)m_expandedKey[0][0]);
    *((uint32_t *)temp[1]) = *((uint32_t *)(a + 4)) ^ *((uint32_t *)m_expandedKey[0][1]);
    *((uint32_t *)temp[2]) = *((uint32_t *)(a + 8)) ^ *((uint32_t *)m_expandedKey[0][2]);
    *((uint32_t *)temp[3]) = *((uint32_t *)(a + 12)) ^ *((uint32_t *)m_expandedKey[0][3]);
    *((uint32_t *)(b)) = *((uint32_t *)T1[temp[0][0]]) ^ *((uint32_t *)T2[temp[1][1]]) ^ *((uint32_t *)T3[temp[2][2]]) ^
                         *((uint32_t *)T4[temp[3][3]]);
    *((uint32_t *)(b + 4)) = *((uint32_t *)T1[temp[1][0]]) ^ *((uint32_t *)T2[temp[2][1]]) ^
                             *((uint32_t *)T3[temp[3][2]]) ^ *((uint32_t *)T4[temp[0][3]]);
    *((uint32_t *)(b + 8)) = *((uint32_t *)T1[temp[2][0]]) ^ *((uint32_t *)T2[temp[3][1]]) ^
                             *((uint32_t *)T3[temp[0][2]]) ^ *((uint32_t *)T4[temp[1][3]]);
    *((uint32_t *)(b + 12)) = *((uint32_t *)T1[temp[3][0]]) ^ *((uint32_t *)T2[temp[0][1]]) ^
                              *((uint32_t *)T3[temp[1][2]]) ^ *((uint32_t *)T4[temp[2][3]]);
    for (r = 1; r < m_uRounds - 1; r++)
    {
        *((uint32_t *)temp[0]) = *((uint32_t *)(b)) ^ *((uint32_t *)m_expandedKey[r][0]);
        *((uint32_t *)temp[1]) = *((uint32_t *)(b + 4)) ^ *((uint32_t *)m_expandedKey[r][1]);
        *((uint32_t *)temp[2]) = *((uint32_t *)(b + 8)) ^ *((uint32_t *)m_expandedKey[r][2]);
        *((uint32_t *)temp[3]) = *((uint32_t *)(b + 12)) ^ *((uint32_t *)m_expandedKey[r][3]);

        *((uint32_t *)(b)) = *((uint32_t *)T1[temp[0][0]]) ^ *((uint32_t *)T2[temp[1][1]]) ^
                             *((uint32_t *)T3[temp[2][2]]) ^ *((uint32_t *)T4[temp[3][3]]);
        *((uint32_t *)(b + 4)) = *((uint32_t *)T1[temp[1][0]]) ^ *((uint32_t *)T2[temp[2][1]]) ^
                                 *((uint32_t *)T3[temp[3][2]]) ^ *((uint32_t *)T4[temp[0][3]]);
        *((uint32_t *)(b + 8)) = *((uint32_t *)T1[temp[2][0]]) ^ *((uint32_t *)T2[temp[3][1]]) ^
                                 *((uint32_t *)T3[temp[0][2]]) ^ *((uint32_t *)T4[temp[1][3]]);
        *((uint32_t *)(b + 12)) = *((uint32_t *)T1[temp[3][0]]) ^ *((uint32_t *)T2[temp[0][1]]) ^
                                  *((uint32_t *)T3[temp[1][2]]) ^ *((uint32_t *)T4[temp[2][3]]);
    }
    *((uint32_t *)temp[0]) = *((uint32_t *)(b)) ^ *((uint32_t *)m_expandedKey[m_uRounds - 1][0]);
    *((uint32_t *)temp[1]) = *((uint32_t *)(b + 4)) ^ *((uint32_t *)m_expandedKey[m_uRounds - 1][1]);
    *((uint32_t *)temp[2]) = *((uint32_t *)(b + 8)) ^ *((uint32_t *)m_expandedKey[m_uRounds - 1][2]);
    *((uint32_t *)temp[3]) = *((uint32_t *)(b + 12)) ^ *((uint32_t *)m_expandedKey[m_uRounds - 1][3]);
    b[0] = T1[temp[0][0]][1];
    b[1] = T1[temp[1][1]][1];
    b[2] = T1[temp[2][2]][1];
    b[3] = T1[temp[3][3]][1];
    b[4] = T1[temp[1][0]][1];
    b[5] = T1[temp[2][1]][1];
    b[6] = T1[temp[3][2]][1];
    b[7] = T1[temp[0][3]][1];
    b[8] = T1[temp[2][0]][1];
    b[9] = T1[temp[3][1]][1];
    b[10] = T1[temp[0][2]][1];
    b[11] = T1[temp[1][3]][1];
    b[12] = T1[temp[3][0]][1];
    b[13] = T1[temp[0][1]][1];
    b[14] = T1[temp[1][2]][1];
    b[15] = T1[temp[2][3]][1];
    *((uint32_t *)(b)) ^= *((uint32_t *)m_expandedKey[m_uRounds][0]);
    *((uint32_t *)(b + 4)) ^= *((uint32_t *)m_expandedKey[m_uRounds][1]);
    *((uint32_t *)(b + 8)) ^= *((uint32_t *)m_expandedKey[m_uRounds][2]);
    *((uint32_t *)(b + 12)) ^= *((uint32_t *)m_expandedKey[m_uRounds][3]);
}

void Rijndael::decrypt(const uint8_t a[16], uint8_t b[16])
{
    int r;
    uint8_t temp[4][4];

    *((uint32_t *)temp[0]) = *((uint32_t *)(a)) ^ *((uint32_t *)m_expandedKey[m_uRounds][0]);
    *((uint32_t *)temp[1]) = *((uint32_t *)(a + 4)) ^ *((uint32_t *)m_expandedKey[m_uRounds][1]);
    *((uint32_t *)temp[2]) = *((uint32_t *)(a + 8)) ^ *((uint32_t *)m_expandedKey[m_uRounds][2]);
    *((uint32_t *)temp[3]) = *((uint32_t *)(a + 12)) ^ *((uint32_t *)m_expandedKey[m_uRounds][3]);

    *((uint32_t *)(b)) = *((uint32_t *)T5[temp[0][0]]) ^ *((uint32_t *)T6[temp[3][1]]) ^ *((uint32_t *)T7[temp[2][2]]) ^
                         *((uint32_t *)T8[temp[1][3]]);
    *((uint32_t *)(b + 4)) = *((uint32_t *)T5[temp[1][0]]) ^ *((uint32_t *)T6[temp[0][1]]) ^
                             *((uint32_t *)T7[temp[3][2]]) ^ *((uint32_t *)T8[temp[2][3]]);
    *((uint32_t *)(b + 8)) = *((uint32_t *)T5[temp[2][0]]) ^ *((uint32_t *)T6[temp[1][1]]) ^
                             *((uint32_t *)T7[temp[0][2]]) ^ *((uint32_t *)T8[temp[3][3]]);
    *((uint32_t *)(b + 12)) = *((uint32_t *)T5[temp[3][0]]) ^ *((uint32_t *)T6[temp[2][1]]) ^
                              *((uint32_t *)T7[temp[1][2]]) ^ *((uint32_t *)T8[temp[0][3]]);
    for (r = m_uRounds - 1; r > 1; r--)
    {
        *((uint32_t *)temp[0]) = *((uint32_t *)(b)) ^ *((uint32_t *)m_expandedKey[r][0]);
        *((uint32_t *)temp[1]) = *((uint32_t *)(b + 4)) ^ *((uint32_t *)m_expandedKey[r][1]);
        *((uint32_t *)temp[2]) = *((uint32_t *)(b + 8)) ^ *((uint32_t *)m_expandedKey[r][2]);
        *((uint32_t *)temp[3]) = *((uint32_t *)(b + 12)) ^ *((uint32_t *)m_expandedKey[r][3]);
        *((uint32_t *)(b)) = *((uint32_t *)T5[temp[0][0]]) ^ *((uint32_t *)T6[temp[3][1]]) ^
                             *((uint32_t *)T7[temp[2][2]]) ^ *((uint32_t *)T8[temp[1][3]]);
        *((uint32_t *)(b + 4)) = *((uint32_t *)T5[temp[1][0]]) ^ *((uint32_t *)T6[temp[0][1]]) ^
                                 *((uint32_t *)T7[temp[3][2]]) ^ *((uint32_t *)T8[temp[2][3]]);
        *((uint32_t *)(b + 8)) = *((uint32_t *)T5[temp[2][0]]) ^ *((uint32_t *)T6[temp[1][1]]) ^
                                 *((uint32_t *)T7[temp[0][2]]) ^ *((uint32_t *)T8[temp[3][3]]);
        *((uint32_t *)(b + 12)) = *((uint32_t *)T5[temp[3][0]]) ^ *((uint32_t *)T6[temp[2][1]]) ^
                                  *((uint32_t *)T7[temp[1][2]]) ^ *((uint32_t *)T8[temp[0][3]]);
    }

    *((uint32_t *)temp[0]) = *((uint32_t *)(b)) ^ *((uint32_t *)m_expandedKey[1][0]);
    *((uint32_t *)temp[1]) = *((uint32_t *)(b + 4)) ^ *((uint32_t *)m_expandedKey[1][1]);
    *((uint32_t *)temp[2]) = *((uint32_t *)(b + 8)) ^ *((uint32_t *)m_expandedKey[1][2]);
    *((uint32_t *)temp[3]) = *((uint32_t *)(b + 12)) ^ *((uint32_t *)m_expandedKey[1][3]);
    b[0] = S5[temp[0][0]];
    b[1] = S5[temp[3][1]];
    b[2] = S5[temp[2][2]];
    b[3] = S5[temp[1][3]];
    b[4] = S5[temp[1][0]];
    b[5] = S5[temp[0][1]];
    b[6] = S5[temp[3][2]];
    b[7] = S5[temp[2][3]];
    b[8] = S5[temp[2][0]];
    b[9] = S5[temp[1][1]];
    b[10] = S5[temp[0][2]];
    b[11] = S5[temp[3][3]];
    b[12] = S5[temp[3][0]];
    b[13] = S5[temp[2][1]];
    b[14] = S5[temp[1][2]];
    b[15] = S5[temp[0][3]];
    *((uint32_t *)(b)) ^= *((uint32_t *)m_expandedKey[0][0]);
    *((uint32_t *)(b + 4)) ^= *((uint32_t *)m_expandedKey[0][1]);
    *((uint32_t *)(b + 8)) ^= *((uint32_t *)m_expandedKey[0][2]);
    *((uint32_t *)(b + 12)) ^= *((uint32_t *)m_expandedKey[0][3]);
}
