/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_debug_console.h"
#include "board.h"
#include "fsl_sctimer.h"

#include "pin_mux.h"
#include "fsl_inputmux.h"
#include <stdbool.h>
#include "fsl_power.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/

#define SCTIMER_CLK_FREQ        CLOCK_GetFreq(kCLOCK_BusClk)
#define DEMO_FIRST_SCTIMER_OUT  kSCTIMER_Out_4
#define DEMO_SECOND_SCTIMER_OUT kSCTIMER_Out_2

//Enable Start/Stop Error Generating
//#define Start_Stop_EN

//Enable Arbitration Loss Error Generating
//#define Arbitration_Loss_EN

//Enable SCL Timeout Error Generating
//#define SCL_Timeout_EN

//Enable Event Timeout Error Generating
#define Event_Timeout_EN
/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/
/*!
 * @brief Main function
 */
int main(void)
{
    sctimer_config_t sctimerInfo;
    sctimer_pwm_signal_param_t pwmParam;
    uint32_t stateNumber;
    uint32_t eventFirstNumberOutput, eventSecondNumberOutput, eventNumberInput;
    uint32_t sctimerClock;
    char I2C_Error_Selection;
	
    /* Board pin, clock, debug console init */
    /* set BOD VBAT level to 1.65V */
    POWER_SetBodVbatLevel(kPOWER_BodVbatLevel1650mv, kPOWER_BodHystLevel50mv, false);
    /* attach 12 MHz clock to FLEXCOMM0 (debug console) */
    CLOCK_AttachClk(BOARD_DEBUG_UART_CLK_ATTACH);

    /* enable clock for GPIO*/
    CLOCK_EnableClock(kCLOCK_Gpio0);
    CLOCK_EnableClock(kCLOCK_Gpio1);

    /* configure the input mux for the sct timer input1 from external pin*/
    INPUTMUX_Init(INPUTMUX);
    INPUTMUX_AttachSignal(INPUTMUX, 1U, kINPUTMUX_SctGpi5ToSct0);

    BOARD_InitPins();
    BOARD_BootClockPLL150M();
    BOARD_InitDebugConsole();

    sctimerClock = SCTIMER_CLK_FREQ;

    PRINTF("I2C Communication Error Trigger And Detect For Glitch Generator_20210412\r\n");

    /* Default configuration operates the counter in 32-bit mode */
    SCTIMER_GetDefaultConfig(&sctimerInfo);

    /* Initialize SCTimer module */
    SCTIMER_Init(SCT0, &sctimerInfo);
    SCT0->OUTPUT |= (1<<4);
		
		while(1)
		{
			PRINTF(
							"Select I2C Communication Error Type\r\n"
							"\t1.     Start/Stop error\r\n"
							"\t2.     Arbitration Loss\r\n"
							"\t3.     SCL Time-out\r\n"
							"\t4.     Event Time-out\r\n"
			        "\tother. exit\r\n"
			      );
      I2C_Error_Selection = GETCHAR();
			switch(I2C_Error_Selection)
			{
				case '1':
					PRINTF("Your selection is I2C Start/Stop error!\r\n");
				break;
				
				case '2':
					PRINTF("Your selection is I2C Arbitration Loss!\r\n");
				break;
				
				case '3':
					PRINTF("Your selection is I2C SCL Time-out!\r\n");
				break;
				
				case '4':
					PRINTF("Your selection is I2C Event Time-out!\r\n");
				break;
				
				default:
				{
				}
				break;
			}
			
			if(I2C_Error_Selection == '1')
			{
				//State 0
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputFallEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a falling edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				/* Go to next state; State 1 */
				SCTIMER_IncreaseState(SCT0);
				
				//State 1
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a rising edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputRiseEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a rising edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				/* Go to next state; State 2 */
				SCTIMER_IncreaseState(SCT0);

				//State 2
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputFallEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a falling edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				/* Go to next state; State 3 */
				SCTIMER_IncreaseState(SCT0);
				
				
				//State 3
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a rising edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputRiseEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a rising edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				//clear H counter 
				SCTIMER_SetupCounterLimitAction(SCT0, kSCTIMER_Counter_U, eventNumberInput);
				/* Go to next state; State 4 */
				SCTIMER_IncreaseState(SCT0);
				
				
				//State 4
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a match event in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_MatchEventOnly, 300, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a match event is detected in this state*/
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				//toggle SCT_OUT4 to low to simulate I2C Stop signal,this line is connected to SDA
				SCTIMER_SetupOutputToggleAction(SCT0, kSCTIMER_Out_4, eventNumberInput);
				/* Go to next state; State 5 */
				SCTIMER_IncreaseState(SCT0);
					
				//State 5
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling edge or a rising edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, (kSCTIMER_InputRiseEvent | kSCTIMER_InputFallEvent), 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a falling edge or rising edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber, eventNumberInput, true);
				/* Go to next state; State 5 */
				SCTIMER_IncreaseState(SCT0);
			}
			else if(I2C_Error_Selection == '2')
			{
				//State 0
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputFallEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a falling edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				/* Go to next state; State 1 */
				SCTIMER_IncreaseState(SCT0);
				
				//State 1
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a rising edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputRiseEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a rising edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				/* Go to next state; State 2 */
				SCTIMER_IncreaseState(SCT0);

				//State 2
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputFallEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				//clear H counter 
				SCTIMER_SetupCounterLimitAction(SCT0, kSCTIMER_Counter_U, eventNumberInput);
				/* Transition to next state when a falling edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				/* Go to next state; State 3 */
				SCTIMER_IncreaseState(SCT0);
				
				//State 3
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a match event in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_MatchEventOnly, 300, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a match event is detected in this state */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				//SCTIMER_SetupOutputToggleAction(SCT0, kSCTIMER_Out_4, eventNumberInput);
				//clear SCT_OUT4 to simulate I2C Arbitration Loss,this line is connected to SDA
				SCTIMER_SetupOutputClearAction(SCT0, kSCTIMER_Out_4, eventNumberInput);
				/* Go to next state; State 4 */
				SCTIMER_IncreaseState(SCT0);
				
				//State 4
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling or rising edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, (kSCTIMER_InputRiseEvent | kSCTIMER_InputFallEvent), 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a falling or rising edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber, eventNumberInput, true);
				/* Go to next state; State 4 */
				SCTIMER_IncreaseState(SCT0);
			}
			else if(I2C_Error_Selection == '3')
			{
				//State 0
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputFallEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a falling edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				/* Go to next state; State 1 */
				SCTIMER_IncreaseState(SCT0);
				
				//State 1
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a rising edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputRiseEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a rising edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				/* Go to next state; State 2 */
				SCTIMER_IncreaseState(SCT0);

				//State 2
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputFallEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a falling edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				/* Go to next state; State 3 */
				SCTIMER_IncreaseState(SCT0);
				
				
				//State 3
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a rising edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputRiseEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a rising edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				/* Go to next state; State 4 */
				SCTIMER_IncreaseState(SCT0);
				
				
				//State 4
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputFallEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a falling edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				////clear SCT_OUT4 to simulate I2C SCL time-out,this line is connected to SDA
				SCTIMER_SetupOutputClearAction(SCT0, kSCTIMER_Out_4, eventNumberInput);
				/* Go to next state; State 5 */
				SCTIMER_IncreaseState(SCT0);
					
				//State 5
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling or rising edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, (kSCTIMER_InputRiseEvent | kSCTIMER_InputFallEvent), 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a falling or rising edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber, eventNumberInput, true);
				/* Go to next state; State 5 */
				SCTIMER_IncreaseState(SCT0);
			}
			else if(I2C_Error_Selection == '4')
			{
				//State 0
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a falling edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_InputFallEvent, 0, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a falling edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber + 1, eventNumberInput, true);
				//clear SCT_OUT4
				SCTIMER_SetupOutputClearAction(SCT0, kSCTIMER_Out_4, eventNumberInput);
				//clear H counter
				SCTIMER_SetupCounterLimitAction(SCT0, kSCTIMER_Counter_U, eventNumberInput);
				/* Go to next state; State 1 */
				SCTIMER_IncreaseState(SCT0);
				
				//State 1
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a rising edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, kSCTIMER_MatchEventOnly, 1000, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a rising edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber+1, eventNumberInput, true);
				//set SCT_OUT4
				SCTIMER_SetupOutputSetAction(SCT0, kSCTIMER_Out_4, eventNumberInput);
				/* Go to next state; State 2 */
				SCTIMER_IncreaseState(SCT0);
				
				//State 2
				stateNumber = SCTIMER_GetCurrentState(SCT0);
				/* Schedule an event to look for a rising edge on input 1 in this state */
				if(SCTIMER_CreateAndScheduleEvent(SCT0, (kSCTIMER_InputFallEvent | kSCTIMER_InputRiseEvent | kSCTIMER_InputLowEvent | kSCTIMER_InputHighEvent), 1000, kSCTIMER_Input_1, kSCTIMER_Counter_U, &eventNumberInput) == kStatus_Fail)
				{
						return -1;
				}
				/* Transition to next state when a rising edge is detected on input 1 */
				SCTIMER_SetupNextStateActionwithLdMethod(SCT0, stateNumber, eventNumberInput, true);
				/* Go to next state; State 2 */
				SCTIMER_IncreaseState(SCT0);
			}
			else
		  {
				break;
		  }
			
			/* Start the 32-bit unify timer */
			SCTIMER_StartTimer(SCT0, kSCTIMER_Counter_U);
    }
		
		PRINTF("I2C Glitch Generator Exit\r\n");
		while(1)
		{
		}
}
