/*
 * Copyright 2017 NXP
 * All rights reserved.
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __WIFI_SHIELD_WIFI10CLICK_H__
#define __WIFI_SHIELD_WIFI10CLICK_H__

#include "board.h"
#include "wifi_common.h"
#include "pin_mux.h"
#include "fsl_gpio.h"

/* This file cannot be included directly in common code, it must pass through "wifi_shield.h" */
#ifndef WIFISHIELD_ENABLED
#   define WIFISHIELD_ENABLED
#else
#   error "Other WiFi shield is already enabled !"
#endif

/* Pinmux function, generated by pinmuxtool */
#define WIFISHIELD_PINMUX_INIT BOARD_InitWiFi10ClickShield

/* WLAN_IRQ PINT */
#define WIFISHIELD_WLAN_PINT (kPINT_PinInt1)
#define WIFISHIELD_WLAN_PINT_EDGE (kPINT_PinIntEnableFallEdge)
#define WIFISHIELD_WLAN_PINT_CONNECT (kINPUTMUX_GpioPort1Pin18ToPintsel)
#define WIFISHIELD_WLAN_PINT_IRQ (PIN_INT1_IRQn)

/* WLAN_IRQ signal */
#define WIFISHIELD_WLAN_IRQ_DIRECTION (kGPIO_DigitalInput)
#define WIFISHIELD_WLAN_IRQ_PORT (BOARD_INITWIFI10CLICKSHIELD_IRQ_PORT)
#define WIFISHIELD_WLAN_IRQ_GPIO (BOARD_INITWIFI10CLICKSHIELD_IRQ_GPIO)
#define WIFISHIELD_WLAN_IRQ_PIN (BOARD_INITWIFI10CLICKSHIELD_IRQ_PIN)
#define WIFISHIELD_WLAN_IRQ_CLOCKSRC (kCLOCK_Gpio1)

/* WLAN_PWRON (PWRDWN) signal */
#define WIFISHIELD_WLAN_PWRON_DIRECTION (kGPIO_DigitalOutput)
#define WIFISHIELD_WLAN_PWRON_PORT (BOARD_INITWIFI10CLICKSHIELD_PWRON_PORT)
#define WIFISHIELD_WLAN_PWRON_GPIO (BOARD_INITWIFI10CLICKSHIELD_PWRON_GPIO)
#define WIFISHIELD_WLAN_PWRON_PIN (BOARD_INITWIFI10CLICKSHIELD_PWRON_PIN)
#define WIFISHIELD_WLAN_PWRON_CLOCKSRC (kCLOCK_Gpio1)

/* SPI settings */
#define WIFISHIELD_SPI (SPI8)
#define WIFISHIELD_SPI_INIT_CS (kSPI_Ssel1)
#define WIFISHIELD_SPI_CLK_CONNECT (kFRO12M_to_HSLSPI)
#define WIFISHIELD_SPI_IP_RESET (kHSLSPI_RST_SHIFT_RSTn)
#define WIFISHIELD_SPI_BAUDRATE (10000000)
#define WIFISHIELD_SPI_THRESHOLD (8)

/* DMA settings */
#define WIFISHIELD_DMA (DMA0)
#define WIFISHIELD_DMA_RX_CHNL (2)
#define WIFISHIELD_DMA_TX_CHNL (3)

#endif
