/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#ifndef __DRIVER_OLED_SSD1306_H__
#define __DRIVER_OLED_SSD1306_H__

#include <stdint.h>

#include "u8x8.h"
#include "driver_oled_ssd1306.h"

/* -------------------------------------------------------------------------- */
/*                          Hardware Pin configuration                        */
/* -------------------------------------------------------------------------- */
#define USE_LPC55S69_EVK_HW
//#define USE_LPC55S69_IOTKIT_HW

#define U8G2_DEMO

#define SSD1306_USE_I2C_GPIO               1u
//#define SSD1306_USE_I2C_HW                 1u
//#define SSD1306_USE_SPI_GPIO               1u
//#define SSD1306_USE_SPI_HW                 1u

#ifdef SSD1306_USE_I2C_GPIO
/* Support LPC55S69-EVK GPIO simulate I2C */
#ifdef USE_LPC55S69_EVK_HW
#define DELAY_CNT                       10u
#define SSD1306_SCL_PORT                1u
#define SSD1306_SCL_PIN                 20u
#define SSD1306_SCL_FUNC                IOCON_FUNC0
#define SSD1306_SCL_PINCFG              IOCON_MODE_INACT  | IOCON_DIGITAL_EN
#define SSD1306_SCL_LOW()               GPIO_PinWrite(GPIO, SSD1306_SCL_PORT, SSD1306_SCL_PIN, 0)
#define SSD1306_SCL_HIGH()              GPIO_PinWrite(GPIO, SSD1306_SCL_PORT, SSD1306_SCL_PIN, 1)

#define SSD1306_SDA_PORT                1u
#define SSD1306_SDA_PIN                 21u
#define SSD1306_SDA_FUNC                IOCON_FUNC0
#define SSD1306_SDA_PINCFG              IOCON_MODE_INACT  | IOCON_DIGITAL_EN
#define SSD1306_SDA_LOW()               GPIO_PinWrite(GPIO, SSD1306_SDA_PORT, SSD1306_SDA_PIN, 0)
#define SSD1306_SDA_HIGH()              GPIO_PinWrite(GPIO, SSD1306_SDA_PORT, SSD1306_SDA_PIN, 1)
#define SSD1306_SDA_READ()              GPIO_PinRead(GPIO, SSD1306_SDA_PORT, SSD1306_SDA_PIN)
#endif // endif SSD1306_USE_I2C_GPIO

/* Support LPC55S69-IOTKIT GPIO simulate I2C */
#if USE_LPC55S69_IOTKIT_HW
#define DELAY_CNT                       10u
#define SSD1306_SCL_PORT                1u
#define SSD1306_SCL_PIN                 15u
#define SSD1306_SCL_FUNC                IOCON_FUNC0
#define SSD1306_SCL_PINCFG              IOCON_MODE_INACT  | IOCON_DIGITAL_EN
#define SSD1306_SCL_LOW()               GPIO_PinWrite(GPIO, SSD1306_SCL_PORT, SSD1306_SCL_PIN, 0)
#define SSD1306_SCL_HIGH()              GPIO_PinWrite(GPIO, SSD1306_SCL_PORT, SSD1306_SCL_PIN, 1)

#define SSD1306_SDA_PORT                1u
#define SSD1306_SDA_PIN                 14u
#define SSD1306_SDA_FUNC                IOCON_FUNC0
#define SSD1306_SDA_PINCFG              IOCON_MODE_INACT  | IOCON_DIGITAL_EN
#define SSD1306_SDA_LOW()               GPIO_PinWrite(GPIO, SSD1306_SDA_PORT, SSD1306_SDA_PIN, 0)
#define SSD1306_SDA_HIGH()              GPIO_PinWrite(GPIO, SSD1306_SDA_PORT, SSD1306_SDA_PIN, 1)
#define SSD1306_SDA_READ()              GPIO_PinRead(GPIO, SSD1306_SDA_PORT, SSD1306_SDA_PIN)
#endif  // endif USE_LPC55S69_IOTKIT_HW

#endif  // endif SSD1306_USE_I2C_GPIO

#ifdef SSD1306_USE_I2C_HW
/* Support LPC55S69-EVK Hardware I2C */
#ifdef USE_LPC55S69_EVK_HW
#define SSD1306_SCL_PORT                1u
#define SSD1306_SCL_PIN                 20u
#define SSD1306_SCL_FUNC                IOCON_FUNC5
#define SSD1306_SCL_PINCFG              IOCON_MODE_INACT  | IOCON_DIGITAL_EN

#define SSD1306_SDA_PORT                1u
#define SSD1306_SDA_PIN                 21u
#define SSD1306_SDA_FUNC                IOCON_FUNC5
#define SSD1306_SDA_PINCFG              IOCON_MODE_INACT  | IOCON_DIGITAL_EN

#define SSD1306_I2C                     I2C4
#define SSD1306_I2C_RST                 kFC4_RST_SHIFT_RSTn
#define SSD1306_I2C_CLKATTACH           kFRO12M_to_FLEXCOMM4
#define SSD1306_I2C_CLKFREQ             12000000UL
#define SSD1306_I2C_CLKSRC              kCLOCK_Flexcomm4
#define SSD1306_I2C_RATE                400000UL
#endif // endif USE_LPC55S69_EVK_HW

#ifdef USE_LPC55S69_IOTKIT_HW
/* Support LPC55S69-IOTKIT Hardware I2C */
#define SSD1306_SCL_PORT                1u
#define SSD1306_SCL_PIN                 15u
#define SSD1306_SCL_FUNC                IOCON_FUNC4
#define SSD1306_SCL_PINCFG              IOCON_MODE_INACT  | IOCON_DIGITAL_EN

#define SSD1306_SDA_PORT                1u
#define SSD1306_SDA_PIN                 14u
#define SSD1306_SDA_FUNC                IOCON_FUNC4
#define SSD1306_SDA_PINCFG              IOCON_MODE_INACT  | IOCON_DIGITAL_EN

#define SSD1306_I2C                     I2C5
#define SSD1306_I2C_RST                 kFC5_RST_SHIFT_RSTn
#define SSD1306_I2C_CLKATTACH           kFRO12M_to_FLEXCOMM5
#define SSD1306_I2C_CLKFREQ             12000000UL
#define SSD1306_I2C_CLKSRC              kCLOCK_Flexcomm5
#define SSD1306_I2C_RATE                400000UL
#endif  // endif USE_LPC55S69_IOTKIT_HW

#endif  // endif SSD1306_USE_I2C_HW

#ifdef SSD1306_USE_SPI_GPIO
/* Support LPC55S69-EVK GPIO simulate SPI */
#ifdef USE_LPC55S69_EVK_HW
#define SSD1306_SCK_PORT                1u
#define SSD1306_SCK_PIN                 2u
#define SSD1306_SCK_FUNC                IOCON_FUNC0
#define SSD1306_SCK_PINCFG              IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_SCK_LOW()               GPIO_PinWrite(GPIO, SSD1306_SCK_PORT, SSD1306_SCK_PIN, 0)
#define SSD1306_SCK_HIGH()              GPIO_PinWrite(GPIO, SSD1306_SCK_PORT, SSD1306_SCK_PIN, 1)

#define SSD1306_MOSI_PORT               0u
#define SSD1306_MOSI_PIN                26u
#define SSD1306_MOSI_FUNC               IOCON_FUNC0
#define SSD1306_MOSI_PINCFG             IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_MOSI_LOW()              GPIO_PinWrite(GPIO, SSD1306_MOSI_PORT, SSD1306_MOSI_PIN, 0)
#define SSD1306_MOSI_HIGH()             GPIO_PinWrite(GPIO, SSD1306_MOSI_PORT, SSD1306_MOSI_PIN, 1)

#define SSD1306_CS_PORT                 1u
#define SSD1306_CS_PIN                  1u
#define SSD1306_CS_FUNC                 IOCON_FUNC0
#define SSD1306_CS_PINCFG               IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_CS_LOW()                GPIO_PinWrite(GPIO, SSD1306_CS_PORT, SSD1306_CS_PIN, 0)
#define SSD1306_CS_HIGH()               GPIO_PinWrite(GPIO, SSD1306_CS_PORT, SSD1306_CS_PIN, 1)

#define SSD1306_DC_PORT                 1u
#define SSD1306_DC_PIN                  5u
#define SSD1306_DC_FUNC                 IOCON_FUNC0
#define SSD1306_DC_PINCFG               IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_DC_LOW()                GPIO_PinWrite(GPIO, SSD1306_DC_PORT, SSD1306_DC_PIN, 0)
#define SSD1306_DC_HIGH()               GPIO_PinWrite(GPIO, SSD1306_DC_PORT, SSD1306_DC_PIN, 1)

#define SSD1306_RST_PORT                1u
#define SSD1306_RST_PIN                 8u
#define SSD1306_RST_FUNC                IOCON_FUNC0
#define SSD1306_RST_PINCFG              IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_RST_LOW()               GPIO_PinWrite(GPIO, SSD1306_RST_PORT, SSD1306_RST_PIN, 0)
#define SSD1306_RST_HIGH()              GPIO_PinWrite(GPIO, SSD1306_RST_PORT, SSD1306_RST_PIN, 1)
#endif // endif USE_LPC55S69_EVK_HW

/* Support LPC55S69-IOTKIT GPIO simulate SPI */
#ifdef USE_LPC55S69_IOTKIT_HW
#define SSD1306_SCK_PORT                1u
#define SSD1306_SCK_PIN                 2u
#define SSD1306_SCK_FUNC                IOCON_FUNC0
#define SSD1306_SCK_PINCFG              IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_SCK_LOW()               GPIO_PinWrite(GPIO, SSD1306_SCK_PORT, SSD1306_SCK_PIN, 0)
#define SSD1306_SCK_HIGH()              GPIO_PinWrite(GPIO, SSD1306_SCK_PORT, SSD1306_SCK_PIN, 1)

#define SSD1306_MOSI_PORT               0u
#define SSD1306_MOSI_PIN                26u
#define SSD1306_MOSI_FUNC               IOCON_FUNC0
#define SSD1306_MOSI_PINCFG             IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_MOSI_LOW()              GPIO_PinWrite(GPIO, SSD1306_MOSI_PORT, SSD1306_MOSI_PIN, 0)
#define SSD1306_MOSI_HIGH()             GPIO_PinWrite(GPIO, SSD1306_MOSI_PORT, SSD1306_MOSI_PIN, 1)

#define SSD1306_CS_PORT                 1u
#define SSD1306_CS_PIN                  1u
#define SSD1306_CS_FUNC                 IOCON_FUNC0
#define SSD1306_CS_PINCFG               IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_CS_LOW()                GPIO_PinWrite(GPIO, SSD1306_CS_PORT, SSD1306_CS_PIN, 0)
#define SSD1306_CS_HIGH()               GPIO_PinWrite(GPIO, SSD1306_CS_PORT, SSD1306_CS_PIN, 1)

#define SSD1306_DC_PORT                 1u
#define SSD1306_DC_PIN                  4u
#define SSD1306_DC_FUNC                 IOCON_FUNC0
#define SSD1306_DC_PINCFG               IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_DC_LOW()                GPIO_PinWrite(GPIO, SSD1306_DC_PORT, SSD1306_DC_PIN, 0)
#define SSD1306_DC_HIGH()               GPIO_PinWrite(GPIO, SSD1306_DC_PORT, SSD1306_DC_PIN, 1)

#define SSD1306_RST_PORT                1u
#define SSD1306_RST_PIN                 19u
#define SSD1306_RST_FUNC                IOCON_FUNC0
#define SSD1306_RST_PINCFG              IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_RST_LOW()               GPIO_PinWrite(GPIO, SSD1306_RST_PORT, SSD1306_RST_PIN, 0)
#define SSD1306_RST_HIGH()              GPIO_PinWrite(GPIO, SSD1306_RST_PORT, SSD1306_RST_PIN, 1)
#endif  // endif USE_LPC55S69_IOTKIT_HW

#endif  // endif SSD1306_USE_SPI_GPIO

#ifdef SSD1306_USE_SPI_HW
/* Support LPC55S69-EVK Hardware SPI */
#ifdef USE_LPC55S69_EVK_HW
#define SSD1306_SCK_PORT                1u
#define SSD1306_SCK_PIN                 2u
#define SSD1306_SCK_FUNC                IOCON_FUNC6
#define SSD1306_SCK_PINCFG              IOCON_MODE_PULLUP | IOCON_DIGITAL_EN

#define SSD1306_MOSI_PORT               0u
#define SSD1306_MOSI_PIN                26u
#define SSD1306_MOSI_FUNC               IOCON_FUNC9
#define SSD1306_MOSI_PINCFG             IOCON_MODE_PULLUP | IOCON_DIGITAL_EN

#define SSD1306_CS_PORT                 1u
#define SSD1306_CS_PIN                  1u
#define SSD1306_CS_FUNC                 IOCON_FUNC0
#define SSD1306_CS_PINCFG               IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_CS_LOW()                GPIO_PinWrite(GPIO, SSD1306_CS_PORT, SSD1306_CS_PIN, 0)
#define SSD1306_CS_HIGH()               GPIO_PinWrite(GPIO, SSD1306_CS_PORT, SSD1306_CS_PIN, 1)

#define SSD1306_DC_PORT                 1u
#define SSD1306_DC_PIN                  5u
#define SSD1306_DC_FUNC                 IOCON_FUNC0
#define SSD1306_DC_PINCFG               IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_DC_LOW()                GPIO_PinWrite(GPIO, SSD1306_DC_PORT, SSD1306_DC_PIN, 0)
#define SSD1306_DC_HIGH()               GPIO_PinWrite(GPIO, SSD1306_DC_PORT, SSD1306_DC_PIN, 1)

#define SSD1306_RST_PORT                1u
#define SSD1306_RST_PIN                 8u
#define SSD1306_RST_FUNC                IOCON_FUNC0
#define SSD1306_RST_PINCFG              IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_RST_LOW()               GPIO_PinWrite(GPIO, SSD1306_RST_PORT, SSD1306_RST_PIN, 0)
#define SSD1306_RST_HIGH()              GPIO_PinWrite(GPIO, SSD1306_RST_PORT, SSD1306_RST_PIN, 1)

#define SSD1306_SPI                     SPI8
#define SSD1306_SPI_RST                 kHSLSPI_RST_SHIFT_RSTn
#define SSD1306_SPI_CLKATTACH           kFRO12M_to_HSLSPI
#define SSD1306_SPI_CLKFREQ             12000000UL
#define SSD1306_SPI_RATE                6000000UL
#endif  // endif USE_LPC55S69_EVK_HW

/* Support LPC55S69-IOTKIT Hardware SPI */
#ifdef USE_LPC55S69_IOTKIT_HW
#define SSD1306_SCK_PORT                1u
#define SSD1306_SCK_PIN                 2u
#define SSD1306_SCK_FUNC                IOCON_FUNC6
#define SSD1306_SCK_PINCFG              IOCON_MODE_PULLUP | IOCON_DIGITAL_EN

#define SSD1306_MOSI_PORT               0u
#define SSD1306_MOSI_PIN                26u
#define SSD1306_MOSI_FUNC               IOCON_FUNC9
#define SSD1306_MOSI_PINCFG             IOCON_MODE_PULLUP | IOCON_DIGITAL_EN

#define SSD1306_DC_PORT                 1u
#define SSD1306_DC_PIN                  4u
#define SSD1306_DC_FUNC                 IOCON_FUNC0
#define SSD1306_DC_PINCFG               IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_DC_LOW()                GPIO_PinWrite(GPIO, SSD1306_DC_PORT, SSD1306_DC_PIN, 0)
#define SSD1306_DC_HIGH()               GPIO_PinWrite(GPIO, SSD1306_DC_PORT, SSD1306_DC_PIN, 1)

#define SSD1306_CS_PORT                 1u
#define SSD1306_CS_PIN                  1u
#define SSD1306_CS_FUNC                 IOCON_FUNC0
#define SSD1306_CS_PINCFG               IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_CS_LOW()                GPIO_PinWrite(GPIO, SSD1306_CS_PORT, SSD1306_CS_PIN, 0)
#define SSD1306_CS_HIGH()               GPIO_PinWrite(GPIO, SSD1306_CS_PORT, SSD1306_CS_PIN, 1)

#define SSD1306_RST_PORT                1u
#define SSD1306_RST_PIN                 19u
#define SSD1306_RST_FUNC                IOCON_FUNC0
#define SSD1306_RST_PINCFG              IOCON_MODE_PULLUP | IOCON_DIGITAL_EN
#define SSD1306_RST_LOW()               GPIO_PinWrite(GPIO, SSD1306_RST_PORT, SSD1306_RST_PIN, 0)
#define SSD1306_RST_HIGH()              GPIO_PinWrite(GPIO, SSD1306_RST_PORT, SSD1306_RST_PIN, 1)

#define SSD1306_SPI                     SPI8
#define SSD1306_SPI_RST                 kHSLSPI_RST_SHIFT_RSTn
#define SSD1306_SPI_CLKATTACH           kFRO12M_to_HSLSPI
#define SSD1306_SPI_CLKFREQ             12000000UL
#define SSD1306_SPI_RATE                6000000UL
#endif  // endif USE_LPC55S69_IOTKIT_HW
#endif  // endif SSD1306_USE_SPI_HW


#ifdef SSD1306_USE_I2C_GPIO
extern uint8_t u8x8_gpio_and_delay_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr);
#endif

#ifdef SSD1306_USE_I2C_HW
extern uint8_t u8x8_byte_hw_i2c_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr);
extern uint8_t u8x8_gpio_and_delay_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr);
#endif

#ifdef SSD1306_USE_SPI_GPIO
extern uint8_t u8x8_gpio_and_delay_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr);
#endif

#ifdef SSD1306_USE_SPI_HW
extern uint8_t u8x8_byte_4wire_hw_spi_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr);
extern uint8_t u8x8_gpio_and_delay_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr);
#endif

#endif // end __DRIVER_OLED_SSD1306_H__

