/*
 * Copyright (c) 2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef APPCOMMON_H
#define APPCOMMON_H

#include "common.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define IRC_2MHZ_CLOCK                          2048000uL

/*Flash can't run for freq greater than 1 MHz in VLPR mode */

//#define SYSTEM_CLOCK                           (32768*375uL)  /* PLL */
#define SYSTEM_CLOCK                           (32768*732uL)  /* FLL 24 MHz */
#define BUS_CLOCK                              (SYSTEM_CLOCK/2)


/*Flash can't run for freq greater than 1 Mhz in VLPR mode */

#define BATTERY_FREQ_SYSTEM                       (IRC_2MHZ_CLOCK)
#define BATTERY_FREQ                           (IRC_2MHZ_CLOCK/2)

/* Partition table
 Bootloader =  = 12 KByte = 0 - 0x2FFF
 Application =  = 242 KBytes = 0x3000 - 0x3F7FF
 Metadata = 1 KBytes = 0x3F800 - 0x3FBFF
 Unused = 1 KBytes = 0x3FC00 - 0x3FFFF
 */
#define APP_IMAGE_START_ADDR          (0x00003000)          /* 12 KB */
#define APP_IMAGE_MAX_LEN             (0x0003C800)         /* 242 KB */
#define APP_METADATA_START_ADDR       (APP_IMAGE_START_ADDR + APP_IMAGE_MAX_LEN)  
#define APP_METADATA_MAX_LEN          (0x400)           /* 1 KB */

/*******************************************************************************
* Prototypes
******************************************************************************/
#ifdef __CODE_WARRIOR__
extern volatile uint8_t __attribute__((section (".RtcRamSection"))) IRTC_BbRam[32];  // for GCC
#else
extern volatile uint8_t IRTC_BbRam[32] ;
#endif

extern void WDOGModuleInit(void);
#endif
