/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __EEPROMADDRS_H
#define __EEPROMADDRS_H

#include "common.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define CALIBLOCKADDR 0x0008		/* Address to store a state that meter calibration is now blocked/unblocked */
#define CALIBADDRESS      0x7F40

#define EEPROMERASELOG    0x00BC

/* Section 1 */
#define zSRNO             7				/* Size of meter serial no in bytes */
#define zSRNORES          8				/* Total reserved size to store meter serial no in bytes */
#define zLOTNO            10			/* Size to store LOT number of the meter, in bytes */
#define zPCBNO            10			/* Size to store PCB number of the meter, in bytes */
#define zDEFSIGN          2				/* Size to store a sign to indicate the meter in production */
#define zBOOTPWDSIGN      2				/* Size to store a sign for bootmode password */
#define zBOOTPWD          (16+1)        /* Size to store bootmode password, 1 extra byte for the trailing '\0' character */

#define EEPDEFSIGN        0xDEAF		/* A sign to indicate meter is in production/calibration */

/* Section 2 */
#define GeneralAddr   0x0180
#define SRNOAddr          GeneralAddr           /* Address where meter serial no is saved */
#define MeterManuAddr     GeneralAddr+zSRNORES  /* Address where meter manufacturing date is saved */
#define MemSignAddr       MeterManuAddr+2       /* Address to store a sign to indicate that few 
                                        meter metadata can be initialized during the 1st time of meter initialization */
#define LotNoAddr         MemSignAddr+4			/* Address to store meter LOT number */
#define PCBNoAddr         LotNoAddr+zLOTNO              /* Address to store meter PCB number */
#define DefSignAddr       PCBNoAddr+zPCBNO              /* Address to store meter production/phase state */

#define DiscnCtrlAddr 0x0400		/* Reserved 0x10 bytes */
#define ImageTrnfInfoAddr DiscnCtrlAddr + 0x10 /* Reserved 0x200 bytes */

#define LastPON       0x700
#define METRECTYPE    LastPON+4

#define DispAddr      0x800			/* Address to store display function related metadata. 0x180 bytes. */

#define EPRTestAddr        0xA00

/* Section 4 */
#define FWBaseAddr    0x10000
#define MAX_IMAGE_SIZE (0x40000 - FWBaseAddr)
/*******************************************************************************
* Prototypes
******************************************************************************/

#endif