/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef RTC_DRIVER_H
#define RTC_DRIVER_H

#include "fsl_irtc.h"


/*******************************************************************************
 * Definitions
 ******************************************************************************/
/** Global structure for Date */
typedef struct
{
  /** Gives present year */
  uint16 m_ucYear;
  /** Gives present month */
  uint8  m_ucMonth;
  /** Gives present day */
  uint8  m_ucDay;
} stDate;

/** Global structure for Time */
typedef struct
{
  /** Gives seconds */
  uint8 m_ucSec;
  /** Gives minutes */
  uint8 m_ucMin;
  /** Gives hours */
  uint8 m_ucHr;
} stTime;

#define DAYS_IN_1_YR    (365)
#define DAYS_IN_1LP_YR  (366)
#define DAYS_IN_4_YRS   (DAYS_IN_1_YR*3 + DAYS_IN_1LP_YR)
#define MINS_IN_DAY     (24*60)
#define SECS_IN_DAY     (MINS_IN_DAY * 60)
#define SECS_IN_4_YRS   (DAYS_IN_4_YRS*SECS_IN_DAY)
#define SECS_IN_1_YR    (365*SECS_IN_DAY)
#define SECS_IN_16_YRS  (DAYS_IN_4_YRS*4)

extern stDate g_stDate;
extern stTime g_stTime;
extern irtc_config_t irtcConfig;
extern irtc_tamper_config_t copenTamperConfig, mopenTamperConfig, topenTamperConfig;

/*******************************************************************************
* Prototypes
******************************************************************************/
extern uint8  Min15Boundary;
extern uint16 EEPDefSign;
extern uint32 g_UTCTime;
extern uint8 GSMRemoved;
/* Global functions */
extern void InitTime(void);
extern void ReadDateAndTime(void);
extern void SetDateAndTime(stDate Date,stTime Time);
extern void RTCModuleInit(void);
extern void ComputeRTCCompensation(void);
extern void CalculateCoarseCompensation(int8 errorSign, float drift32768Clocks, uint8 *RTCCompInterval, int8 *RTCCompValue);
extern void ApplyRTCCompensation(uint8 compInterval, int8 compValue);
extern void UTCToRTC(stDate *Date, stTime *Time, uint32 UTCTime);
extern void RTCToUTC(stDate Date, stTime Time, uint32 *UtcTime);
#endif