/*
 * Copyright (c) 2010-2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
/*******************************************************************************
 * Definitions
 ******************************************************************************/
#ifndef __BOOT_LOADER_H
#define __BOOT_LOADER_H

#include "ComPortDriver.h"
#include "UpgradeFW.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define BLBattModeTO (20)

#define BL_UART_CHANNEL			UART3
#define BL_BAUD_RATE			9600	// bps
#define RECEIVE_TIMEOUT_NS		30000000000		// 30 seconds
#define APP_RESET_VECTOR		APP_IMAGE_START_ADDR

#define RESET_VALUE_IN_FLASH	0xFFFFFFFF
#define TIMEOUT					0
#define NO_TIMEOUT				1

#define NO_OF_RETRIES			3	// 3 times

#define IMAGE_ADDR              ((unsigned long int *)0x1800)

/*******************************************************************************
* Prototypes
******************************************************************************/
#ifdef __CODE_WARRIOR__
extern volatile uint8_t __attribute__((section (".RtcRamSection"))) IRTC_BbRam[32];
#else
extern volatile uint8_t IRTC_BbRam[32] ;
#endif

extern uint8 BattModeTimeout;
extern stImageTransfer imageTransfer;
/*
  Global functions declaration
*/
void JumpToApplication(uint32_t stackPointer, uint32_t applicationAddress);


/***************************************************************************//*!
 * @brief   Enables transmit Inversion Mode.
 * @details This macro enables the inversion mode of transmitted data.
 * @param   module    UART0,UART1,UART2,UART3
 * @note    Implemented as an inline macro.
 * @see     @ref UART_TxInVModeEnable
 ******************************************************************************/
#define UART_TxInVModeEnable(module)    iosetb (module##_C3,UART_C3_TXINV_MASK)

#endif
