/*
 * Copyright 2008-2020 NXP
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef AUDIO_COMMON_H_
#define AUDIO_COMMON_H_

#include <stdbool.h>

/**
 * @addtogroup KL_MODULES_AUDIOSERVICE_API API
 *
 * @{
 */

/**
 * Initializes ringbuffers and audio clock for Audio Streaming service.
 * Note: audio service should be initialized before initializing usb_ctrl service.
 */
void audio_Init(void);

/**
 * De-Initializes the Audio Streaming service and disables the audio clock.
 */
void audio_Deinit(void);

/**
 * Starts the Audio Streaming service.
 * Initializes SAI, I2S and DMA and enables the I2S pins
 */
void audio_Start(void);

/**
 * Stops the Audio Streaming Service.
 * Disables SAI,I2S and DMA.
 * Disables the Tx, Rx and its clocks and puts the I2S pins in tri-state.
 */
void audio_Stop(void);

/**
 * Enables/disables the I2S Pins.
 * @param enable true to enable and false to disable the I2S Pins.
 */
void audio_EnableI2sPins(bool enable);

/**
 * Set Audio service in busy streaming.
 * @param status true to set busy, false to set free.
 */
void audio_SetBusy(bool status);

/**
 * Returns status of audio service if it is busy streaming or not.
 * @return true if audio streaming in progress, false if not.
 */
bool audio_IsBusy(void);

/** @} */

#endif /* AUDIO_COMMON_H_ */
