/*
 * Copyright 2018-2020 NXP
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#include "fsl_sai.h"
#include "board.h"
#include "audio.h"
#include "audio_tx.h"
//#include "audio_rx.h"
/* TODO: don't depend on audio_common.h for defines */
#include "audio_common.h"
#include "audio_internal.h"

void I2S0_IRQHandler(void)
{
    if (SAI_TxGetStatusFlag(AUDIO_SERVICE_I2S_BASEADDR) & kSAI_FIFOErrorFlag) {
        PERR("TX I2S ERROR");
        audio_StopTx();
        if (g_AudioServiceCtxt.userConfig.audioTxWriteCompleteCb) {
            g_AudioServiceCtxt.userConfig.audioTxWriteCompleteCb(TX_AUDIO_DMA_TRANSFER_SIZE(audio_GetTxSampleSizeBytes()), kERROR_Fail);
        }
    }


//#if AUDIO_SERVICE_RX_ENABLE
//    if (SAI_RxGetStatusFlag(AUDIO_SERVICE_I2S_BASEADDR) & kSAI_FIFOErrorFlag) {
//        PERR("RX I2S ERROR");
//        audio_StopRx();
//    }
//#endif
}
