/*
 * Copyright 2017-2020 NXP
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef STATE_H_
#define STATE_H_

/**
 * @addtogroup KL_MODULES_FRMWSUPPORT_API
 * @{
 */

/**
 * Generic states enumeration
 */
typedef enum _state {
    kSTATE_Uninitialized = 0, /**< Service is uninitialized. */
    kSTATE_Stopped,           /**< Service is initialized but stopped. All necessary pins set. NO IRQ enabled. */
    kSTATE_Starting,          /**< Service is starting. All necessary pins set. IRQ being enabled. */
    kSTATE_Started,           /**< Service is started. All necessary pins set AND IRQ enabled. */
    kSTATE_Stopping,          /**< Service is stopping. All necessary pins set. IRQ being disabled. */
    kSTATE_Suspending,        /**< Service is being suspended. */
    kSTATE_Suspended,         /**< Service is suspended. */
    kSTATE_Resuming,          /**< Service is resuming after a suspend. */
    kSTATE_Resumed,           /**< Service is started after a suspend == resumed. */
    kSTATE_Count,             /**< Used as counter.*/
} state_t;

/**
 * Check if a state is valid, i.e. does correspond to a recognized value
 */
#define PHSTATE_IS_VALID(__s)  (((__s) >= kSTATE_Uninitialized) && ((__s) < kSTATE_Count))

/**
 * Check if the service has been initialized, i.e. is in a state that is different from @ref kSTATE_Uninitialized
 */
#define PHSTATE_IS_INITIALIZED(__s)  (((__s) > kSTATE_Uninitialized) && ((__s) < kSTATE_Count))

/**
 * Check if the service has been started
 */
#define PHSTATE_IS_STARTED(__s)  ((__s) == kSTATE_Started)

/** @} */

#endif /* STATE_H_ */
