/*
 * Copyright 2017-2020 NXP
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef USB_INTERNAL_H_
#define USB_INTERNAL_H_

#include <stdbool.h>
#include "composite.h"
#include "usb_feedback.h"
#include "state.h"

#define PHLOG_MODULE  "usb"
#include "log.h"

#ifdef USB_DEBUG
#define USB_PDBG(...) PDBG(__VA_ARGS__)
#else
#define USB_PDBG(...)
#endif

/**
 * State to keep track when (actually) suspended/resumed
 */
typedef enum _usb_suspend_state {
    kUSB_SuspendStateIdle = 0U,
    kUSB_SuspendStateSuspended,
    kUSB_SuspendStateResumed,
} usb_suspend_state_t;

/**
 * USB service context struct
 */
typedef struct _usb_service_ctxt {
    //usbConfig_t userConfig;
#if USB_CHAT_SPEAKER_ENABLE
    //usb_pipe_ctrl_t chatSpeakerPipeCtrl;
#endif
#if USB_GAME_SPEAKER_ENABLE
    usb_pipe_ctrl_t gameSpeakerPipeCtrl;
#endif
//    usb_pipe_ctrl_t recPipeCtrl;
    volatile usb_suspend_state_t currentSuspendState;
    volatile state_t currentState;  /**< Current state of the service */
    volatile bool resumePending;  /**< Workaround for resuming without actually receiving resume from host */
} usb_service_ctxt_t;

/**
 * Extern declaration of global usb service context
 */
extern usb_service_ctxt_t g_UsbServiceCtxt;


/** @brief Feedback configuration */
#if USB_CHAT_SPEAKER_ENABLE
extern UsbFeedback_t g_UsbChatSpeaker_FeedbackSettings;
#endif
#if USB_GAME_SPEAKER_ENABLE
extern UsbFeedback_t g_UsbGameSpeaker_FeedbackSettings;
#endif

/** @brief composite struct */
extern usb_device_composite_struct_t g_composite;

#endif /* USB_INTERNAL_H_ */
