/*
 * Copyright 2018-2020 NXP
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef USB_LATENCY_DEBUG_H_
#define USB_LATENCY_DEBUG_H_

#include <stdbool.h>

/**
 * Initialization of USB latency debug functionality.
 *
 * This is most likely BSP specific.
 * The default implementation of this is an empty function.
 */
__attribute__((weak)) void USB_LatencyDebug_Init(void);

/**
 * Indicate usb audio is being received from the host PC.
 *
 * This is most likely BSP specific.
 * The default implementation of this is an empty function.
 *
 * @param receiving Flag indicating if audio is being received
 */
__attribute__((weak)) void USB_LatencyDebug_ReceivingAudioFromHost(bool receiving);

/**
 * Indicate usb audio is being read to send to the host PC.
 *
 * This is most likely BSP specific.
 * The default implementation of this is an empty function.
 *
 * @param sending Flag indicating if audio is being sent
 */
__attribute__((weak)) void USB_LatencyDebug_SendingAudioToHost(bool sending);

/**
 * Deinit of USB latency debug functionality.
 *
 * This is most likely BSP specific.
 * The default implementation of this is an empty function.
 */
__attribute__((weak)) void USB_LatencyDebug_Deinit(void);

#endif /* USB_LATENCY_DEBUG_H_ */
