/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _BOARD_H_
#define _BOARD_H_

#include "clock_config.h"
#include "fsl_gpio.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/* The board name */
#define BOARD_NAME "FRDM-KL43Z"

/* The LPUART to use for debug messages. */
#define BOARD_DEBUG_UART_TYPE     kSerialPort_Uart
#define BOARD_DEBUG_UART_BASEADDR (uint32_t) LPUART0
#define BOARD_DEBUG_UART_INSTANCE 0U
#define BOARD_DEBUG_UART_CLKSRC   kCLOCK_McgIrc48MClk
#define BOARD_DEBUG_UART_CLK_FREQ CLOCK_GetFreq(kCLOCK_McgIrc48MClk)
#define BOARD_UART_IRQ            LPUART0_IRQn
#define BOARD_UART_IRQ_HANDLER    LPUART0_IRQHandler

#ifndef BOARD_DEBUG_UART_BAUDRATE
#define BOARD_DEBUG_UART_BAUDRATE 460800
#endif /* BOARD_DEBUG_UART_BAUDRATE */

#define BOARD_CODEC_I2C_BASEADDR   I2C1
#define BOARD_CODEC_I2C_CLOCK_FREQ CLOCK_GetFreq(I2C1_CLK_SRC)
#define BOARD_CODEC_I2C_INSTANCE   1

#define BOARD_ADC_USE_ALT_VREF 1U

#define BOARD_TPM_BASEADDR TPM0
#define BOARD_TPM_CHANNEL  5U

/*! @brief The bubble level demo information */
#define BOARD_BUBBLE_TPM_BASEADDR  TPM0
#define BOARD_TPM_X_CHANNEL        4U
#define BOARD_TPM_Y_CHANNEL        5U
#define BOARD_MMA8451_ADDR         0x1D
#define BOARD_ACCEL_ADDR           BOARD_MMA8451_ADDR
#define BOARD_ACCEL_BAUDRATE       100
#define BOARD_ACCEL_I2C_BASEADDR   I2C0
#define BOARD_ACCEL_I2C_CLOCK_FREQ CLOCK_GetFreq(I2C0_CLK_SRC)

/*! @brief The rtc instance used for board. */
#define BOARD_RTC_FUNC_BASEADDR RTC

/*! @brief The Compare instance/channel used for board */
#define BOARD_CMP_BASEADDR CMP0
#define BOARD_CMP_CHANNEL  0U

/*! @brief The i2c instance used for i2c connection by default */
#define BOARD_I2C_BASEADDR I2C1

/*! @brief The spi instance used for board. */
#define BOARD_SPI_BASEADDR SPI1

/*! @brief Define the port interrupt number for the board switches */
#ifndef BOARD_SW1_GPIO
#define BOARD_SW1_GPIO GPIOA
#endif
#ifndef BOARD_SW1_PORT
#define BOARD_SW1_PORT PORTA
#endif
#ifndef BOARD_SW1_GPIO_PIN
#define BOARD_SW1_GPIO_PIN 4U
#endif
#define BOARD_SW1_IRQ         PORTA_IRQn
#define BOARD_SW1_IRQ_HANDLER PORTA_IRQHandler
#define BOARD_SW1_NAME        "SW1"

#ifndef BOARD_SW3_GPIO
#define BOARD_SW3_GPIO GPIOC
#endif
#ifndef BOARD_SW3_PORT
#define BOARD_SW3_PORT PORTC
#endif
#ifndef BOARD_SW3_GPIO_PIN
#define BOARD_SW3_GPIO_PIN 3U
#endif
#define BOARD_SW3_IRQ         PORTC_PORTD_IRQn
#define BOARD_SW3_IRQ_HANDLER PORTC_PORTD_IRQHandler
#define BOARD_SW3_NAME        "SW3"

#define LLWU_SW_GPIO        BOARD_SW3_GPIO
#define LLWU_SW_PORT        BOARD_SW3_PORT
#define LLWU_SW_GPIO_PIN    BOARD_SW3_GPIO_PIN
#define LLWU_SW_IRQ         BOARD_SW3_IRQ
#define LLWU_SW_IRQ_HANDLER BOARD_SW3_IRQ_HANDLER
#define LLWU_SW_NAME        BOARD_SW3_NAME

/* Board led color mapping */
#define LOGIC_LED_ON  0U
#define LOGIC_LED_OFF 1U
#ifndef BOARD_LED_RED_GPIO
#define BOARD_LED_RED_GPIO GPIOE
#endif
#define BOARD_LED_RED_GPIO_PORT PORTE
#ifndef BOARD_LED_RED_GPIO_PIN
#define BOARD_LED_RED_GPIO_PIN 31U
#endif
#ifndef BOARD_LED_GREEN_GPIO
#define BOARD_LED_GREEN_GPIO GPIOD
#endif
#define BOARD_LED_GREEN_GPIO_PORT PORTD
#ifndef BOARD_LED_GREEN_GPIO_PIN
#define BOARD_LED_GREEN_GPIO_PIN 5U
#endif

#define LED_RED_INIT(output)                                           \
    GPIO_PinWrite(BOARD_LED_RED_GPIO, BOARD_LED_RED_GPIO_PIN, output); \
    BOARD_LED_RED_GPIO->PDDR |= (1U << BOARD_LED_RED_GPIO_PIN)                         /*!< Enable target LED_RED */
#define LED_RED_ON()  GPIO_PortClear(BOARD_LED_RED_GPIO, 1U << BOARD_LED_RED_GPIO_PIN) /*!< Turn on target LED_RED */
#define LED_RED_OFF() GPIO_PortSet(BOARD_LED_RED_GPIO, 1U << BOARD_LED_RED_GPIO_PIN)   /*!< Turn off target LED_RED */
#define LED_RED_TOGGLE() \
    GPIO_PortToggle(BOARD_LED_RED_GPIO, 1U << BOARD_LED_RED_GPIO_PIN) /*!< Toggle on target LED_RED */

#define LED_GREEN_INIT(output)                                             \
    GPIO_PinWrite(BOARD_LED_GREEN_GPIO, BOARD_LED_GREEN_GPIO_PIN, output); \
    BOARD_LED_GREEN_GPIO->PDDR |= (1U << BOARD_LED_GREEN_GPIO_PIN) /*!< Enable target LED_GREEN */
#define LED_GREEN_ON() \
    GPIO_PortClear(BOARD_LED_GREEN_GPIO, 1U << BOARD_LED_GREEN_GPIO_PIN) /*!< Turn on target LED_GREEN */
#define LED_GREEN_OFF() \
    GPIO_PortSet(BOARD_LED_GREEN_GPIO, 1U << BOARD_LED_GREEN_GPIO_PIN) /*!< Turn off target LED_GREEN */
#define LED_GREEN_TOGGLE() \
    GPIO_PortToggle(BOARD_LED_GREEN_GPIO, 1U << BOARD_LED_GREEN_GPIO_PIN) /*!< Toggle on target LED_GREEN */

/* ERPC SPI configuration */
#define ERPC_BOARD_SPI_BASEADDR            SPI1
#define ERPC_BOARD_SPI_BAUDRATE            500000U
#define ERPC_BOARD_SPI_CLKSRC              SPI1_CLK_SRC
#define ERPC_BOARD_SPI_CLK_FREQ            CLOCK_GetFreq(SPI1_CLK_SRC)
#define ERPC_BOARD_SPI_INT_GPIO            GPIOC
#define ERPC_BOARD_SPI_INT_PORT            PORTC
#define ERPC_BOARD_SPI_INT_PIN             1U
#define ERPC_BOARD_SPI_INT_PIN_IRQ         PORTC_PORTD_IRQn
#define ERPC_BOARD_SPI_INT_PIN_IRQ_HANDLER PORTC_PORTD_IRQHandler

/*! @brief Define the I2S base address */
#define AUDIO_SERVICE_I2S_BASEADDR  I2S0
/*! @brief Define the I2S TXD pin */
#define BOARD_I2S_TXD_PORT          PORTC
#define BOARD_I2S_TXD_PORT_MODE     kPORT_MuxAlt6
#define BOARD_I2S_TXD_PORT_PIN      0u
#define BOARD_I2S_TXD_PORT_CLOCK    kCLOCK_PortC

/*! @brief Define the I2S RXD pin */
#define BOARD_I2S_RXD_PORT        PORTC
#define BOARD_I2S_RXD_PORT_MODE   kPORT_MuxAlt4
#define BOARD_I2S_RXD_PORT_PIN    5u
#define BOARD_I2S_RXD_PORT_CLOCK  kCLOCK_PortC

/*! @brief Define the I2S BCLK pin */
#define BOARD_I2S_BCLK_PORT        PORTB
#define BOARD_I2S_BCLK_PORT_MODE   kPORT_MuxAlt4
#define BOARD_I2S_BCLK_PORT_PIN    18U
#define BOARD_I2S_BCLK_PORT_CLOCK  kCLOCK_PortB

/*! @brief Define the I2S FS pin */
#define BOARD_I2S_FS_PORT        PORTB
#define BOARD_I2S_FS_PORT_MODE   kPORT_MuxAlt4
#define BOARD_I2S_FS_PORT_PIN    19U
#define BOARD_I2S_FS_PORT_CLOCK  kCLOCK_PortB

#define BOARD_I2S_MCLK_PORT        PORTC
#define BOARD_I2S_MCLK_PORT_MODE   kPORT_MuxAlt5
#define BOARD_I2S_MCLK_PORT_PIN    4U
#define BOARD_I2S_MCLK_PORT_CLOCK  kCLOCK_PortC

/** DMA request source - I2S0 Receive */
#define AUDIO_SERVICE_DMA_RX_MUX_SOURCE  (14)
/** DMA request source - I2S0 Transmit */
#define AUDIO_SERVICE_DMA_TX_MUX_SOURCE  (15)

#define BOARD_EXT_XTAL_CLK_HZ  24576000u

/* DAC base address */
#define BOARD_DAC_BASEADDR DAC0

/* Board accelerometer driver */
#define BOARD_ACCEL_MMA

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

/*******************************************************************************
 * API
 ******************************************************************************/

void BOARD_InitDebugConsole(void);


#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif /* _BOARD_H_ */
