/* ---------------------------------------------------------------------------- */
/* Copyright 2020 NXP.                                                          */
/*                                                                              */
/* This software is owned or controlled by NXP and may only be used strictly    */
/* in accordance with the applicable license terms. By expressly accepting such */
/* terms or by downloading, installing, activating and/or otherwise using the   */
/* software, you are agreeing that you have read, and that you agree to comply  */
/* with and are bound by, such license terms. If you do not agree to be bound   */
/* by the applicable license terms, then you may not retain, install, activate  */
/* or otherwise use the software.                                               */
/* ---------------------------------------------------------------------------- */

#ifndef ERROR_H_
#define ERROR_H_

/**
 * @addtogroup KL_MODULES_GENERIC
 * @{
 */

/**
 * Generic error codes
 */
typedef enum _error {
    kERROR_Ok                  = 0,      /**< No error */
    kERROR_Fail                = 1,      /**< Error, not specified */
    kERROR_Busy                = 2,      /**< Busy error, previous operation not finished */
    kERROR_EndOfFile           = 3,      /**< End-of-file reached */
    kERROR_CommandNotProcessed = 4,      /**< Command was received but not processed due to an error */
    kERROR_InvalidRequest      = 5,      /**< Invalid request received */
    kERROR_Count,
} error_t;

/** @} */

#endif /* ERROR_H_ */
