/*
 * Copyright 2018-2020 NXP
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef UTILS_H_
#define UTILS_H_

#define SIZE_ARRAY(array)    (sizeof((array)) / sizeof((array)[0]))

#define MILLI_TO_MICRO(_m)   ((_m) * 1000u)
#define SECOND_TO_MICRO(_m)  ((_m) * 1000000u)

/* 1KB aligned section in RAM (sram) */
#define RAM_1K_ALIGNED_SECTION    __attribute__((section(".bss.sram_1k_aligned")))
/* 512Bytes aligned section in RAM (sram) */
#define RAM_512B_ALIGNED_SECTION  __attribute__((section(".bss.sram_512b_aligned")))
/* Align attribute */
#define ALIGN(n)  __attribute__((aligned(n)))

#endif /* UTILS_H_ */
