/*
 * Copyright 2019 ,2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v9.0
processor: LPC54S018
package_id: LPC54S018JET180
mcu_data: ksdk2_0
processor_version: 9.0.0
board: LPCXpresso54S018
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_gpio.h"
#include "fsl_iocon.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: C3, peripheral: GPIO, signal: 'PIO2, 2', pin_signal: PIO2_2/ENET_CRS/FC3_SSEL3/SCT0_OUT6/CTIMER1_MAT1, direction: OUTPUT, mode: pullUp, invert: disabled,
    glitch_filter: disabled, slew_rate: standard, open_drain: disabled}
  - {pin_num: P2, peripheral: SWD, signal: SWO, pin_signal: PIO0_10/FC6_SCK/CTIMER2_CAP2/CTIMER2_MAT0/FC1_TXD_SCL_MISO/SWO/ADC0_0, mode: inactive}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M4F */
void BOARD_InitPins(void)
{
    /* Enables the clock for the IOCON block. 0 = Disable; 1 = Enable.: 0x01u */
    CLOCK_EnableClock(kCLOCK_Iocon);
    /* Enables the clock for the GPIO2 module */
    CLOCK_EnableClock(kCLOCK_Gpio2);

    gpio_pin_config_t LED3_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO2_2 (pin C3)  */
    GPIO_PinInit(BOARD_LED3_GPIO, BOARD_LED3_PORT, BOARD_LED3_PIN, &LED3_config);

    IOCON->PIO[0][10] =
        ((IOCON->PIO[0][10] &
          /* Mask bits to zero which are setting */
          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_ANAMODE_MASK | IOCON_PIO_DIGIMODE_MASK)))

         /* Selects pin function.
          * : PORT010 (pin P2) is configured as SWO. */
         | IOCON_PIO_FUNC(PIO010_FUNC_ALT6)

         /* Selects function mode (on-chip pull-up/pull-down resistor control).
          * : Inactive.
          * Inactive (no pull-down/pull-up resistor enabled). */
         | IOCON_PIO_MODE(PIO010_MODE_INACTIVE)

         /* Enables or disables analog mode.
          * : Disable analog Mode. */
         | IOCON_PIO_ANAMODE(PIO010_ANAMODE_DISABLED)

         /* Select Analog/Digital mode.
          * : Digital mode. */
         | IOCON_PIO_DIGIMODE(PIO010_DIGIMODE_DIGITAL));

    const uint32_t LED3 = (/* Pin is configured as PIO2_2 */
                           IOCON_PIO_FUNC0 |
                           /* Selects pull-up function */
                           IOCON_PIO_MODE_PULLUP |
                           /* Input function is not inverted */
                           IOCON_PIO_INV_DI |
                           /* Enables digital function */
                           IOCON_PIO_DIGITAL_EN |
                           /* Input filter disabled */
                           IOCON_PIO_INPFILT_OFF |
                           /* Standard mode, output slew rate control is enabled */
                           IOCON_PIO_SLEW_STANDARD |
                           /* Open drain is disabled */
                           IOCON_PIO_OPENDRAIN_DI);
    /* PORT2 PIN2 (coords: C3) is configured as PIO2_2 */
    IOCON_PinMuxSet(IOCON, BOARD_LED3_PORT, BOARD_LED3_PIN, LED3);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
