/*
 * Copyright 2019 ,2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/* Define the PIO[ANAMODE] bit macro (SDK 2.6.x and older miss this bit macro definition) */
#ifndef IOCON_PIO_ANAMODE_MASK
#define IOCON_PIO_ANAMODE_MASK  (0x40U)
#define IOCON_PIO_ANAMODE_SHIFT (6U)
#define IOCON_PIO_ANAMODE(x)    (((uint32_t)(((uint32_t)(x)) << IOCON_PIO_ANAMODE_SHIFT)) & IOCON_PIO_ANAMODE_MASK)
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

/*!
 * @brief Enables digital function */
#define IOCON_PIO_DIGITAL_EN 0x0100u
/*!
 * @brief Selects pin function 0 */
#define IOCON_PIO_FUNC0 0x00u
/*!
 * @brief Input filter disabled */
#define IOCON_PIO_INPFILT_OFF 0x0200u
/*!
 * @brief Input function is not inverted */
#define IOCON_PIO_INV_DI 0x00u
/*!
 * @brief Selects pull-up function */
#define IOCON_PIO_MODE_PULLUP 0x20u
/*!
 * @brief Open drain is disabled */
#define IOCON_PIO_OPENDRAIN_DI 0x00u
/*!
 * @brief Standard mode, output slew rate control is enabled */
#define IOCON_PIO_SLEW_STANDARD 0x00u
/*!
 * @brief Enables or disables analog mode.: Disable analog Mode. */
#define PIO010_ANAMODE_DISABLED 0x01u
/*!
 * @brief Select Analog/Digital mode.: Digital mode. */
#define PIO010_DIGIMODE_DIGITAL 0x01u
/*!
 * @brief Selects pin function.: Alternative connection 6. */
#define PIO010_FUNC_ALT6 0x06u
/*!
 * @brief
 * Selects function mode (on-chip pull-up/pull-down resistor control).
 * : Inactive.
 * Inactive (no pull-down/pull-up resistor enabled).
 */
#define PIO010_MODE_INACTIVE 0x00u

/*! @name PIO2_2 (coord C3), J9[6]/LED3/P2_2-CT1MAT1-USR_LED3
  @{ */

/* Symbols to be used with GPIO driver */
#define BOARD_LED3_GPIO GPIO                /*!<@brief GPIO peripheral base pointer */
#define BOARD_LED3_GPIO_PIN_MASK (1U << 2U) /*!<@brief GPIO pin mask */
#define BOARD_LED3_PORT 2U                  /*!<@brief PORT peripheral base pointer */
#define BOARD_LED3_PIN 2U                   /*!<@brief PORT pin number */
#define BOARD_LED3_PIN_MASK (1U << 2U)      /*!<@brief PORT pin mask */
                                            /* @} */

/*! @name PIO0_10 (coord P2), U16[12]/SWO_TRGT
  @{ */
#define BOARD_SWO_TRGT_PORT 0U                   /*!<@brief PORT peripheral base pointer */
#define BOARD_SWO_TRGT_PIN 10U                   /*!<@brief PORT pin number */
#define BOARD_SWO_TRGT_PIN_MASK (1U << 10U)      /*!<@brief PORT pin mask */
                                                 /* @} */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void); /* Function assigned for the Cortex-M4F */

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
