/*
 * Copyright 2019-2020 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */


/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v8.0
processor: MIMX8ML8xxxLZ
package_id: MIMX8ML8DVNLZ
mcu_data: ksdk2_0
processor_version: 0.8.3
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

#include "fsl_common.h"
#include "fsl_iomuxc.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'false', coreID: m7}
- pin_list:
  - {pin_num: AJ5, peripheral: UART4, signal: uart_rx, pin_signal: UART4_RXD, PE: Enabled, HYS: CMOS, PUE: Weak_Pull_Up, FSEL: Slow, DSE: X1}
  - {pin_num: AH5, peripheral: UART4, signal: uart_tx, pin_signal: UART4_TXD, PE: Enabled, HYS: CMOS, PUE: Weak_Pull_Up, FSEL: Slow, DSE: X1}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void) {                                /*!< Function assigned for the core: Cortex-M7F[m7] */
    IOMUXC_SetPinMux(IOMUXC_UART4_RXD_UART4_RX, 0U);
    IOMUXC_SetPinConfig(IOMUXC_UART4_RXD_UART4_RX, 
                        IOMUXC_SW_PAD_CTL_PAD_PUE_MASK |
                        IOMUXC_SW_PAD_CTL_PAD_PE_MASK);
    IOMUXC_SetPinMux(IOMUXC_UART4_TXD_UART4_TX, 0U);
    IOMUXC_SetPinConfig(IOMUXC_UART4_TXD_UART4_TX, 
                        IOMUXC_SW_PAD_CTL_PAD_PUE_MASK |
                        IOMUXC_SW_PAD_CTL_PAD_PE_MASK);
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitEnet1GPins:
- options: {callFromInitBoot: 'false', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: E13, peripheral: ENET_1G, signal: enet_rx_en, pin_signal: GPIO_DISP_B1_00}
  - {pin_num: D13, peripheral: ENET_1G, signal: enet_rx_clk, pin_signal: GPIO_DISP_B1_01}
  - {pin_num: D11, peripheral: ENET_1G, signal: 'enet_rdata, 00', pin_signal: GPIO_DISP_B1_02}
  - {pin_num: E11, peripheral: ENET_1G, signal: 'enet_rdata, 01', pin_signal: GPIO_DISP_B1_03}
  - {pin_num: E10, peripheral: ENET_1G, signal: 'enet_rdata, 02', pin_signal: GPIO_DISP_B1_04}
  - {pin_num: C11, peripheral: ENET_1G, signal: 'enet_rdata, 03', pin_signal: GPIO_DISP_B1_05}
  - {pin_num: D10, peripheral: ENET_1G, signal: 'enet_tdata, 03', pin_signal: GPIO_DISP_B1_06}
  - {pin_num: E12, peripheral: ENET_1G, signal: 'enet_tdata, 02', pin_signal: GPIO_DISP_B1_07}
  - {pin_num: A15, peripheral: ENET_1G, signal: 'enet_tdata, 01', pin_signal: GPIO_DISP_B1_08}
  - {pin_num: C13, peripheral: ENET_1G, signal: 'enet_tdata, 00', pin_signal: GPIO_DISP_B1_09}
  - {pin_num: B14, peripheral: ENET_1G, signal: enet_tx_en, pin_signal: GPIO_DISP_B1_10}
  - {pin_num: A14, peripheral: ENET_1G, signal: enet_tx_clk_io, pin_signal: GPIO_DISP_B1_11}
  - {pin_num: A5, peripheral: GPIO11, signal: 'gpio_io, 14', pin_signal: GPIO_DISP_B2_13}
  - {pin_num: U2, peripheral: ENET_1G, signal: enet_mdc, pin_signal: GPIO_EMC_B2_19}
  - {pin_num: R3, peripheral: ENET_1G, signal: enet_mdio, pin_signal: GPIO_EMC_B2_20}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitEnet1GPins, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitEnet1GPins(void) {
    IOMUXC_SetPinMux(IOMUXC_SAI1_TXFS_ENET1_RGMII_RX_CTL, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_TXFS_ENET1_RGMII_RX_CTL,
                      IOMUXC_SW_PAD_CTL_PAD_HYS_MASK | IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK);

    IOMUXC_SetPinMux(IOMUXC_SAI1_TXC_ENET1_RGMII_RXC, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_TXC_ENET1_RGMII_RXC,
                      IOMUXC_SW_PAD_CTL_PAD_HYS_MASK | IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK);

    IOMUXC_SetPinMux(IOMUXC_SAI1_RXD4_ENET1_RGMII_RD0, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_RXD4_ENET1_RGMII_RD0,
                      IOMUXC_SW_PAD_CTL_PAD_HYS_MASK | IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK);

    IOMUXC_SetPinMux(IOMUXC_SAI1_RXD5_ENET1_RGMII_RD1, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_RXD5_ENET1_RGMII_RD1,
                      IOMUXC_SW_PAD_CTL_PAD_HYS_MASK | IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK);

    IOMUXC_SetPinMux(IOMUXC_SAI1_RXD6_ENET1_RGMII_RD2, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_RXD6_ENET1_RGMII_RD2,
                      IOMUXC_SW_PAD_CTL_PAD_HYS_MASK | IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK);

    IOMUXC_SetPinMux(IOMUXC_SAI1_RXD7_ENET1_RGMII_RD3, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_RXD7_ENET1_RGMII_RD3,
                      IOMUXC_SW_PAD_CTL_PAD_HYS_MASK | IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK);

    IOMUXC_SetPinMux(IOMUXC_SAI1_TXD0_ENET1_RGMII_TD0, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_TXD0_ENET1_RGMII_TD0,
                      IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK | IOMUXC_SW_PAD_CTL_PAD_DSE(3));

    IOMUXC_SetPinMux(IOMUXC_SAI1_TXD1_ENET1_RGMII_TD1, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_TXD1_ENET1_RGMII_TD1,
                      IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK | IOMUXC_SW_PAD_CTL_PAD_DSE(3));

    IOMUXC_SetPinMux(IOMUXC_SAI1_TXD2_ENET1_RGMII_TD2, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_TXD2_ENET1_RGMII_TD2,
                      IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK | IOMUXC_SW_PAD_CTL_PAD_DSE(3));

    IOMUXC_SetPinMux(IOMUXC_SAI1_TXD3_ENET1_RGMII_TD3, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_TXD3_ENET1_RGMII_TD3,
                      IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK | IOMUXC_SW_PAD_CTL_PAD_DSE(3));

    IOMUXC_SetPinMux(IOMUXC_SAI1_TXD4_ENET1_RGMII_TX_CTL, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_TXD4_ENET1_RGMII_TX_CTL,
                      IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK | IOMUXC_SW_PAD_CTL_PAD_DSE(3));

    IOMUXC_SetPinMux(IOMUXC_SAI1_TXD5_ENET1_RGMII_TXC, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_TXD5_ENET1_RGMII_TXC,
                      IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK | IOMUXC_SW_PAD_CTL_PAD_DSE(3));

    IOMUXC_SetPinMux(IOMUXC_SAI1_RXD0_GPIO4_IO02, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_RXD0_GPIO4_IO02, IOMUXC_SW_PAD_CTL_PAD_FSEL_MASK);

    IOMUXC_SetPinMux(IOMUXC_SAI1_RXD2_ENET1_MDC, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_RXD2_ENET1_MDC, IOMUXC_SW_PAD_CTL_PAD_DSE(1));

    IOMUXC_SetPinMux(IOMUXC_SAI1_RXD3_ENET1_MDIO, 0U);
    IOMUXC_SetPinConfig(IOMUXC_SAI1_RXD3_ENET1_MDIO, IOMUXC_SW_PAD_CTL_PAD_DSE(1));
}

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
