/*
 * Copyright (c) 2001-2003 Swedish Institute of Computer Science.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * This file is part of the lwIP TCP/IP stack.
 *
 * Author: Adam Dunkels <adam@sics.se>
 *
 */
#ifndef LWIP_UDP_OP_H
#define LWIP_UDP_OP_H

#include "fsl_phy.h"

/* MAC address configuration. */
#define configMAC_ADDR                     \
    {                                      \
        0x02, 0x12, 0x13, 0x10, 0x15, 0x11 \
    }

#define configUDP_OP_SERVER_IP          PP_HTONL(LWIP_MAKEU32(192, 168, 0,   102))
#define configUDP_OP_SERVER_NET_MASK    PP_HTONL(LWIP_MAKEU32(255, 255, 255, 0))
#define configUDP_OP_GATEWAY_IP         PP_HTONL(LWIP_MAKEU32(192, 168, 0,   100))
#define configUDP_OP_SERVER_PORT        1080

#define PKT_DATA_HEARTBEAT              "heartbeat"
#define PKT_DATA_WAKEUP                 "wakeup"
#define PKT_DATA_HEARTBEAT_RESP         "got"
#define PKT_DATA_WAKEUP_RESP            "ok"

#define PKT_DATA_BUF_SZ                 64

void udp_op_init(void);
void udp_op_init_netif(phy_handle_t *h_phy);
void udp_op_deinit_netif(void);
void udp_op_thread(void *arg);
void udp_op_process_thr(void);

#endif /* LWIP_UDPECHO_H */
