#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 20 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef LV_FONT_SIMSUN_20
#define LV_FONT_SIMSUN_20 1
#endif

#if LV_FONT_SIMSUN_20

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+21 "!" */
    0xb, 0x90, 0xe, 0xc0, 0xd, 0xb0, 0xc, 0x90,
    0xa, 0x70, 0x8, 0x50, 0x7, 0x40, 0x6, 0x40,
    0x4, 0x20, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xd0,
    0xd, 0xc0,

    /* U+22 "\"" */
    0x0, 0x5e, 0x14, 0xe3, 0x0, 0xed, 0x1d, 0xe1,
    0x8, 0xd1, 0x6e, 0x20, 0x1c, 0x10, 0xc2, 0x0,
    0x41, 0x3, 0x20, 0x0,

    /* U+23 "#" */
    0x0, 0x1a, 0x0, 0xb, 0x0, 0x0, 0x28, 0x0,
    0xb, 0x0, 0x2, 0x58, 0x22, 0x2b, 0x20, 0x4f,
    0xff, 0xff, 0xff, 0xf3, 0x15, 0x98, 0x55, 0x5b,
    0x51, 0x0, 0x73, 0x0, 0x28, 0x0, 0x0, 0x91,
    0x0, 0x46, 0x0, 0x2, 0xb2, 0x22, 0x76, 0x20,
    0x4f, 0xff, 0xff, 0xff, 0xf3, 0x15, 0xc5, 0x55,
    0xa6, 0x51, 0x0, 0xb0, 0x0, 0x91, 0x0, 0x0,
    0xb0, 0x0, 0xa0, 0x0, 0x0, 0xa0, 0x0, 0xb0,
    0x0,

    /* U+24 "$" */
    0x0, 0x2, 0x30, 0x0, 0x0, 0x5, 0x60, 0x0,
    0x0, 0x8b, 0xba, 0x20, 0xb, 0x35, 0x63, 0xe0,
    0x2e, 0x5, 0x66, 0xf2, 0x3f, 0x25, 0x63, 0x60,
    0xc, 0xd7, 0x60, 0x0, 0x1, 0xcf, 0x90, 0x0,
    0x0, 0xa, 0xf9, 0x0, 0x0, 0x5, 0xaf, 0x80,
    0x0, 0x5, 0x65, 0xf2, 0x5c, 0x5, 0x60, 0xe5,
    0xaf, 0x15, 0x60, 0xd3, 0x4d, 0x5, 0x62, 0xc0,
    0x4, 0x9a, 0xb8, 0x10, 0x0, 0x5, 0x60, 0x0,
    0x0, 0x5, 0x60, 0x0,

    /* U+25 "%" */
    0x0, 0x0, 0x0, 0x2, 0x0, 0x9, 0x86, 0x0,
    0x19, 0x0, 0x67, 0xb, 0x10, 0x73, 0x0, 0xa4,
    0x9, 0x50, 0x90, 0x0, 0xb4, 0x9, 0x64, 0x50,
    0x0, 0xa4, 0xa, 0x59, 0x0, 0x0, 0x58, 0xc,
    0x37, 0x0, 0x0, 0x6, 0x74, 0x81, 0x58, 0x40,
    0x0, 0x0, 0x83, 0xa0, 0xb1, 0x0, 0x6, 0x38,
    0x60, 0x86, 0x0, 0x9, 0xa, 0x50, 0x78, 0x0,
    0x35, 0x9, 0x50, 0x87, 0x0, 0x80, 0x5, 0x80,
    0xb3, 0x0, 0x60, 0x0, 0x88, 0x80,

    /* U+26 "&" */
    0x0, 0x58, 0x96, 0x0, 0x0, 0x1, 0xc0, 0xf,
    0x0, 0x0, 0x3, 0xc0, 0xf, 0x0, 0x0, 0x3,
    0xe0, 0x4b, 0x0, 0x0, 0x0, 0xf5, 0xa1, 0x0,
    0x0, 0x0, 0xdb, 0x2, 0x9b, 0x60, 0xa, 0x7f,
    0x10, 0x4a, 0x0, 0x59, 0xe, 0x70, 0x46, 0x0,
    0xa6, 0x7, 0xe1, 0x73, 0x0, 0xb7, 0x0, 0xea,
    0xb0, 0x0, 0x9a, 0x0, 0x4f, 0x90, 0x0, 0x2f,
    0x40, 0x1c, 0xf3, 0x17, 0x5, 0xed, 0xa1, 0x7e,
    0xc1,

    /* U+27 "'" */
    0x6f, 0x64, 0xfc, 0x6, 0xa0, 0xb3, 0x73, 0x0,

    /* U+28 "(" */
    0x0, 0x0, 0x60, 0x0, 0x8, 0x50, 0x0, 0x59,
    0x0, 0x1, 0xd0, 0x0, 0x9, 0x60, 0x0, 0x1f,
    0x10, 0x0, 0x5c, 0x0, 0x0, 0x99, 0x0, 0x0,
    0xa8, 0x0, 0x0, 0xa8, 0x0, 0x0, 0x99, 0x0,
    0x0, 0x6c, 0x0, 0x0, 0x1f, 0x10, 0x0, 0xa,
    0x60, 0x0, 0x2, 0xd0, 0x0, 0x0, 0x69, 0x0,
    0x0, 0x8, 0x60, 0x0, 0x0, 0x60,

    /* U+29 ")" */
    0x6, 0x0, 0x0, 0x7, 0x70, 0x0, 0x0, 0xa4,
    0x0, 0x0, 0x1d, 0x10, 0x0, 0x8, 0x80, 0x0,
    0x2, 0xe0, 0x0, 0x0, 0xd4, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0x99, 0x0, 0x0, 0x99, 0x0, 0x0,
    0xb7, 0x0, 0x0, 0xd4, 0x0, 0x2, 0xf0, 0x0,
    0x8, 0x80, 0x0, 0x1e, 0x10, 0x0, 0xa4, 0x0,
    0x7, 0x70, 0x0, 0x5, 0x0, 0x0,

    /* U+2A "*" */
    0x0, 0x0, 0x9a, 0x0, 0x0, 0x0, 0x0, 0xbb,
    0x0, 0x0, 0x2e, 0x60, 0x88, 0x7, 0xe1, 0x1b,
    0xf7, 0x55, 0x9f, 0xa0, 0x0, 0x28, 0xaa, 0x71,
    0x0, 0x0, 0x28, 0xaa, 0x71, 0x0, 0xb, 0xf7,
    0x64, 0x9f, 0xa0, 0x3e, 0x60, 0x97, 0x7, 0xf2,
    0x0, 0x0, 0xca, 0x0, 0x0, 0x0, 0x0, 0xb8,
    0x0, 0x0,

    /* U+2B "+" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x37,
    0x0, 0x0, 0x0, 0x0, 0x37, 0x0, 0x0, 0x0,
    0x0, 0x37, 0x0, 0x0, 0x0, 0x0, 0x37, 0x0,
    0x0, 0x1b, 0xbb, 0xcd, 0xbb, 0xb4, 0x0, 0x0,
    0x37, 0x0, 0x0, 0x0, 0x0, 0x37, 0x0, 0x0,
    0x0, 0x0, 0x37, 0x0, 0x0, 0x0, 0x0, 0x37,
    0x0, 0x0, 0x0, 0x0, 0x12, 0x0, 0x0,

    /* U+2D "-" */
    0x4b, 0xbb, 0xbb, 0xbb, 0xb3,

    /* U+2E "." */
    0x3, 0x8, 0xf8, 0x6f, 0x60,

    /* U+2F "/" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x90, 0x0, 0x0, 0x0, 0x2, 0x80, 0x0,
    0x0, 0x0, 0x9, 0x10, 0x0, 0x0, 0x0, 0x28,
    0x0, 0x0, 0x0, 0x0, 0x91, 0x0, 0x0, 0x0,
    0x1, 0x90, 0x0, 0x0, 0x0, 0x9, 0x10, 0x0,
    0x0, 0x0, 0x19, 0x0, 0x0, 0x0, 0x0, 0x82,
    0x0, 0x0, 0x0, 0x1, 0x90, 0x0, 0x0, 0x0,
    0x8, 0x20, 0x0, 0x0, 0x0, 0x19, 0x0, 0x0,
    0x0, 0x0, 0x82, 0x0, 0x0, 0x0, 0x1, 0xa0,
    0x0, 0x0, 0x0, 0x7, 0x30, 0x0, 0x0, 0x0,
    0xa, 0x0, 0x0, 0x0, 0x0, 0x12, 0x0, 0x0,
    0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x9, 0xaa, 0x90, 0x0, 0xb, 0x90, 0x8,
    0xa0, 0x4, 0xf1, 0x0, 0xf, 0x30, 0xab, 0x0,
    0x0, 0xc9, 0xe, 0x80, 0x0, 0x9, 0xd0, 0xf7,
    0x0, 0x0, 0x8e, 0xf, 0x60, 0x0, 0x8, 0xf0,
    0xf7, 0x0, 0x0, 0x8e, 0xe, 0x80, 0x0, 0x9,
    0xd0, 0xab, 0x0, 0x0, 0xc9, 0x5, 0xf1, 0x0,
    0x1f, 0x30, 0xb, 0x90, 0x9, 0xa0, 0x0, 0x9,
    0xaa, 0x90, 0x0,

    /* U+31 "1" */
    0x0, 0x29, 0x0, 0x58, 0xfb, 0x0, 0x0, 0x9b,
    0x0, 0x0, 0x8b, 0x0, 0x0, 0x8b, 0x0, 0x0,
    0x8b, 0x0, 0x0, 0x8b, 0x0, 0x0, 0x8b, 0x0,
    0x0, 0x8b, 0x0, 0x0, 0x8b, 0x0, 0x0, 0x8b,
    0x0, 0x0, 0x9b, 0x0, 0x58, 0xff, 0x97,

    /* U+32 "2" */
    0x3, 0x88, 0x9b, 0x30, 0x3c, 0x0, 0x4, 0xf2,
    0xa9, 0x0, 0x0, 0xd7, 0xbf, 0x0, 0x0, 0xc8,
    0x13, 0x0, 0x0, 0xf5, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x2d, 0x10, 0x0, 0x2, 0xb1, 0x0,
    0x0, 0x2a, 0x10, 0x0, 0x1, 0xa1, 0x0, 0x1,
    0xa, 0x10, 0x0, 0x8, 0x94, 0x22, 0x22, 0x97,
    0xff, 0xff, 0xff, 0xf5,

    /* U+33 "3" */
    0x5, 0x88, 0xa9, 0x10, 0x5b, 0x0, 0x9, 0xc0,
    0x8d, 0x0, 0x3, 0xf2, 0x2, 0x0, 0x4, 0xf0,
    0x0, 0x0, 0x1c, 0x60, 0x0, 0x1a, 0xe6, 0x0,
    0x0, 0x0, 0x9, 0x90, 0x0, 0x0, 0x0, 0xe5,
    0x0, 0x0, 0x0, 0xba, 0x69, 0x0, 0x0, 0xbb,
    0xce, 0x0, 0x0, 0xd7, 0x6c, 0x0, 0x5, 0xd0,
    0x5, 0x98, 0x99, 0x10,

    /* U+34 "4" */
    0x0, 0x0, 0x0, 0xe3, 0x0, 0x0, 0x0, 0x9,
    0xf3, 0x0, 0x0, 0x0, 0x46, 0xf3, 0x0, 0x0,
    0x1, 0x91, 0xf3, 0x0, 0x0, 0x9, 0x11, 0xf3,
    0x0, 0x0, 0x54, 0x1, 0xf3, 0x0, 0x1, 0x80,
    0x1, 0xf3, 0x0, 0x9, 0x0, 0x1, 0xf3, 0x0,
    0x29, 0x77, 0x78, 0xf9, 0x72, 0x0, 0x0, 0x1,
    0xf3, 0x0, 0x0, 0x0, 0x1, 0xf3, 0x0, 0x0,
    0x0, 0x1, 0xf3, 0x0, 0x0, 0x0, 0x7a, 0xfc,
    0x70,

    /* U+35 "5" */
    0xe, 0xff, 0xff, 0xf6, 0xa, 0x22, 0x22, 0x20,
    0x8, 0x0, 0x0, 0x0, 0x17, 0x0, 0x0, 0x0,
    0x26, 0x8a, 0xcc, 0x30, 0x3c, 0x30, 0x6, 0xe0,
    0x13, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0, 0xaa,
    0x0, 0x0, 0x0, 0x9b, 0xad, 0x0, 0x0, 0xa9,
    0xcb, 0x0, 0x0, 0xe5, 0x5a, 0x0, 0x5, 0xd0,
    0x4, 0x88, 0x9a, 0x10,

    /* U+36 "6" */
    0x0, 0x5, 0x88, 0xb8, 0x0, 0x6, 0x70, 0x4,
    0xf2, 0x2, 0xd0, 0x0, 0x1, 0x0, 0x89, 0x0,
    0x0, 0x0, 0xc, 0x74, 0xbc, 0xd5, 0x0, 0xfa,
    0x90, 0x4, 0xf3, 0xf, 0xd0, 0x0, 0xa, 0xa0,
    0xf7, 0x0, 0x0, 0x6e, 0xf, 0x70, 0x0, 0x5,
    0xf0, 0xca, 0x0, 0x0, 0x6d, 0x7, 0xe0, 0x0,
    0x9, 0x90, 0xd, 0x80, 0x1, 0xd2, 0x0, 0x1a,
    0xa9, 0xa2, 0x0,

    /* U+37 "7" */
    0x4f, 0xff, 0xff, 0xfc, 0x7a, 0x32, 0x22, 0x94,
    0x90, 0x0, 0x1, 0x90, 0x10, 0x0, 0x9, 0x20,
    0x0, 0x0, 0x2a, 0x0, 0x0, 0x0, 0x93, 0x0,
    0x0, 0x1, 0xd0, 0x0, 0x0, 0x8, 0x90, 0x0,
    0x0, 0xe, 0x60, 0x0, 0x0, 0x2f, 0x40, 0x0,
    0x0, 0x5f, 0x40, 0x0, 0x0, 0x7f, 0x40, 0x0,
    0x0, 0x4e, 0x30, 0x0,

    /* U+38 "8" */
    0x0, 0x49, 0x88, 0x93, 0x0, 0x5c, 0x0, 0x1,
    0xd3, 0xb, 0x50, 0x0, 0x8, 0x90, 0xc7, 0x0,
    0x0, 0x79, 0x6, 0xf5, 0x0, 0xc, 0x30, 0x7,
    0xfb, 0x59, 0x40, 0x0, 0x49, 0xaf, 0xb1, 0x0,
    0x5b, 0x0, 0x2d, 0xd1, 0xe, 0x30, 0x0, 0xd,
    0x91, 0xf0, 0x0, 0x0, 0x7c, 0xf, 0x10, 0x0,
    0x7, 0xb0, 0x79, 0x0, 0x0, 0xd3, 0x0, 0x49,
    0x88, 0x92, 0x0,

    /* U+39 "9" */
    0x0, 0x5a, 0x98, 0x90, 0x0, 0x5d, 0x0, 0x4,
    0xc0, 0xe, 0x60, 0x0, 0xd, 0x51, 0xf3, 0x0,
    0x0, 0xaa, 0x1f, 0x40, 0x0, 0xa, 0xd0, 0xf7,
    0x0, 0x1, 0xee, 0x8, 0xe2, 0x1, 0xab, 0xd0,
    0x6, 0xbb, 0x91, 0xbc, 0x0, 0x0, 0x0, 0xd,
    0x90, 0x0, 0x0, 0x1, 0xf4, 0x2, 0x90, 0x0,
    0x6d, 0x0, 0x5f, 0x30, 0x1d, 0x30, 0x0, 0x9a,
    0x8a, 0x30, 0x0,

    /* U+3A ":" */
    0x1e, 0xa2, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x2, 0xfc, 0x1e, 0xa0,

    /* U+3B ";" */
    0xf, 0xc0, 0xa8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa8, 0xf, 0xc0, 0x68, 0xc,
    0x10,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x35, 0x0, 0x0, 0x3, 0xb0,
    0x0, 0x0, 0x3a, 0x0, 0x0, 0x3, 0xa0, 0x0,
    0x0, 0x4a, 0x0, 0x0, 0x4, 0xa0, 0x0, 0x0,
    0x4a, 0x0, 0x0, 0x0, 0x4a, 0x0, 0x0, 0x0,
    0x3, 0xa0, 0x0, 0x0, 0x0, 0x3a, 0x0, 0x0,
    0x0, 0x3, 0xa0, 0x0, 0x0, 0x0, 0x3a, 0x0,
    0x0, 0x0, 0x2, 0xb0, 0x0, 0x0, 0x0, 0x25,

    /* U+3D "=" */
    0x4b, 0xbb, 0xbb, 0xbb, 0xb3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4b, 0xbb, 0xbb, 0xbb,
    0xb3,

    /* U+3E ">" */
    0x53, 0x0, 0x0, 0x0, 0xb, 0x30, 0x0, 0x0,
    0x0, 0xa3, 0x0, 0x0, 0x0, 0xa, 0x30, 0x0,
    0x0, 0x0, 0xa4, 0x0, 0x0, 0x0, 0xa, 0x40,
    0x0, 0x0, 0x0, 0xa4, 0x0, 0x0, 0x0, 0xa4,
    0x0, 0x0, 0xa, 0x30, 0x0, 0x0, 0xa3, 0x0,
    0x0, 0xa, 0x30, 0x0, 0x0, 0xb3, 0x0, 0x0,
    0xb, 0x20, 0x0, 0x0, 0x52, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x3, 0xab, 0xbb, 0x40, 0x39, 0x0, 0x2, 0xe5,
    0xc0, 0x0, 0x0, 0x8d, 0xf9, 0x0, 0x0, 0x7f,
    0x89, 0x0, 0x0, 0xac, 0x0, 0x0, 0x8, 0xe3,
    0x0, 0x0, 0xc9, 0x10, 0x0, 0x7, 0x50, 0x0,
    0x0, 0x8, 0x10, 0x0, 0x0, 0x5, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x1e, 0xa0, 0x0,

    /* U+40 "@" */
    0x0, 0x6, 0x98, 0x96, 0x0, 0x0, 0x86, 0x0,
    0x5, 0x80, 0x4, 0xa0, 0x17, 0x79, 0x91, 0xb,
    0x30, 0xb2, 0x69, 0x55, 0xf, 0x4, 0xa0, 0x87,
    0x37, 0x2e, 0xa, 0x40, 0xa4, 0x37, 0x3e, 0xe,
    0x10, 0xc2, 0x46, 0x2e, 0xf, 0x0, 0xf0, 0x73,
    0xf, 0xe, 0x6, 0xe1, 0xa0, 0xc, 0x35, 0xa4,
    0x8a, 0x20, 0x5, 0x90, 0x0, 0x0, 0x72, 0x0,
    0xa4, 0x0, 0x6, 0x60, 0x0, 0x8, 0xa9, 0xa5,
    0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x55, 0x0, 0x0, 0x0, 0x0, 0xec,
    0x0, 0x0, 0x0, 0x2, 0xaf, 0x0, 0x0, 0x0,
    0x6, 0x3e, 0x30, 0x0, 0x0, 0x9, 0xa, 0x70,
    0x0, 0x0, 0x9, 0x7, 0xb0, 0x0, 0x0, 0x26,
    0x3, 0xf0, 0x0, 0x0, 0x72, 0x0, 0xe3, 0x0,
    0x0, 0xa7, 0x77, 0xd7, 0x0, 0x0, 0x90, 0x0,
    0x8a, 0x0, 0x3, 0x60, 0x0, 0x4e, 0x0, 0x7,
    0x30, 0x0, 0x1f, 0x20, 0xb, 0x10, 0x0, 0xe,
    0x60, 0x7f, 0x90, 0x0, 0x5f, 0xe4,

    /* U+42 "B" */
    0x3c, 0xf8, 0x78, 0xb6, 0x0, 0x5, 0xe0, 0x0,
    0x1e, 0x50, 0x5, 0xe0, 0x0, 0xb, 0x90, 0x5,
    0xe0, 0x0, 0xc, 0x80, 0x5, 0xe0, 0x0, 0x6d,
    0x10, 0x5, 0xf7, 0x7a, 0xc1, 0x0, 0x5, 0xe0,
    0x0, 0x3e, 0x30, 0x5, 0xe0, 0x0, 0x8, 0xd0,
    0x5, 0xe0, 0x0, 0x4, 0xf2, 0x5, 0xe0, 0x0,
    0x3, 0xf4, 0x5, 0xe0, 0x0, 0x6, 0xf2, 0x5,
    0xe0, 0x0, 0xd, 0xa0, 0x4b, 0xf8, 0x78, 0xa6,
    0x0,

    /* U+43 "C" */
    0x0, 0x7, 0x98, 0xbf, 0xb0, 0x0, 0xa8, 0x0,
    0x4, 0xe0, 0x6, 0xe0, 0x0, 0x0, 0x92, 0xd,
    0x80, 0x0, 0x0, 0x11, 0x2f, 0x40, 0x0, 0x0,
    0x0, 0x4f, 0x30, 0x0, 0x0, 0x0, 0x5f, 0x10,
    0x0, 0x0, 0x0, 0x5f, 0x20, 0x0, 0x0, 0x0,
    0x3f, 0x40, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x32, 0xa, 0xc0, 0x0, 0x0, 0x80, 0x1,
    0xe7, 0x0, 0x7, 0x30, 0x0, 0x19, 0xca, 0xa3,
    0x0,

    /* U+44 "D" */
    0x3c, 0xf8, 0x79, 0x60, 0x0, 0x5, 0xe0, 0x0,
    0x8b, 0x0, 0x5, 0xe0, 0x0, 0xd, 0x70, 0x5,
    0xe0, 0x0, 0x7, 0xe0, 0x5, 0xe0, 0x0, 0x4,
    0xf2, 0x5, 0xe0, 0x0, 0x3, 0xf4, 0x5, 0xe0,
    0x0, 0x3, 0xf4, 0x5, 0xe0, 0x0, 0x3, 0xf3,
    0x5, 0xe0, 0x0, 0x5, 0xf1, 0x5, 0xe0, 0x0,
    0x8, 0xd0, 0x5, 0xe0, 0x0, 0xd, 0x70, 0x5,
    0xe0, 0x0, 0x9b, 0x0, 0x4b, 0xf8, 0x7a, 0x60,
    0x0,

    /* U+45 "E" */
    0x2b, 0xf8, 0x77, 0x9f, 0x70, 0x4, 0xf0, 0x0,
    0x3, 0xb0, 0x4, 0xf0, 0x0, 0x0, 0x60, 0x4,
    0xf0, 0x0, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x53,
    0x0, 0x4, 0xf7, 0x78, 0xf3, 0x0, 0x4, 0xf0,
    0x0, 0x93, 0x0, 0x4, 0xf0, 0x0, 0x53, 0x0,
    0x4, 0xf0, 0x0, 0x21, 0x0, 0x4, 0xf0, 0x0,
    0x0, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x43, 0x4,
    0xf0, 0x0, 0x1, 0xc0, 0x3b, 0xf8, 0x77, 0x9e,
    0xa0,

    /* U+46 "F" */
    0x3b, 0xf8, 0x77, 0x8e, 0xd0, 0x4, 0xf0, 0x0,
    0x0, 0xb3, 0x4, 0xf0, 0x0, 0x0, 0x15, 0x4,
    0xf0, 0x0, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x7,
    0x0, 0x4, 0xf0, 0x0, 0x28, 0x0, 0x4, 0xf7,
    0x77, 0xd8, 0x0, 0x4, 0xf0, 0x0, 0x27, 0x0,
    0x4, 0xf0, 0x0, 0x3, 0x0, 0x4, 0xf0, 0x0,
    0x0, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x0, 0x4,
    0xf0, 0x0, 0x0, 0x0, 0x3b, 0xf8, 0x10, 0x0,
    0x0,

    /* U+47 "G" */
    0x0, 0x9, 0x99, 0xee, 0x0, 0x0, 0xc5, 0x0,
    0x1e, 0x10, 0x7, 0xb0, 0x0, 0x6, 0x40, 0xe,
    0x50, 0x0, 0x0, 0x20, 0x3f, 0x10, 0x0, 0x0,
    0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x0, 0x2, 0x9b, 0xa4,
    0x4f, 0x10, 0x0, 0xf, 0x60, 0xf, 0x50, 0x0,
    0xe, 0x50, 0x9, 0xa0, 0x0, 0xe, 0x50, 0x1,
    0xe3, 0x0, 0x1f, 0x50, 0x0, 0x2a, 0x98, 0x83,
    0x10,

    /* U+48 "H" */
    0x4d, 0xe5, 0x0, 0x5e, 0xd3, 0x9, 0xa0, 0x0,
    0xb, 0x80, 0x9, 0xa0, 0x0, 0xb, 0x80, 0x9,
    0xa0, 0x0, 0xb, 0x80, 0x9, 0xa0, 0x0, 0xb,
    0x80, 0x9, 0xa0, 0x0, 0xb, 0x80, 0x9, 0xc7,
    0x77, 0x7d, 0x80, 0x9, 0xa0, 0x0, 0xb, 0x80,
    0x9, 0xa0, 0x0, 0xb, 0x80, 0x9, 0xa0, 0x0,
    0xb, 0x80, 0x9, 0xa0, 0x0, 0xb, 0x80, 0x9,
    0xa0, 0x0, 0xb, 0x80, 0x5d, 0xe5, 0x0, 0x6e,
    0xd4,

    /* U+49 "I" */
    0x7, 0x7e, 0xe7, 0x70, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x7, 0x7e, 0xe7, 0x70,

    /* U+4A "J" */
    0x0, 0x6, 0x7b, 0xf8, 0x73, 0x0, 0x0, 0x4,
    0xf0, 0x0, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x0,
    0x0, 0x4, 0xf0, 0x0, 0x0, 0x0, 0x4, 0xf0,
    0x0, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x0,
    0x4, 0xf0, 0x0, 0x0, 0x0, 0x4, 0xf0, 0x0,
    0x0, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x0, 0x4,
    0xf0, 0x0, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x0,
    0x0, 0x4, 0xf0, 0x0, 0x0, 0x0, 0x4, 0xe0,
    0x0, 0x6, 0x10, 0x6, 0xc0, 0x0, 0x3f, 0x50,
    0xb, 0x40, 0x0, 0x9, 0xb8, 0x83, 0x0, 0x0,

    /* U+4B "K" */
    0x3c, 0xf8, 0x1, 0x9f, 0x91, 0x5, 0xe0, 0x0,
    0x75, 0x0, 0x5, 0xe0, 0x2, 0x80, 0x0, 0x5,
    0xe0, 0xa, 0x0, 0x0, 0x5, 0xe0, 0x92, 0x0,
    0x0, 0x5, 0xe5, 0xf4, 0x0, 0x0, 0x5, 0xf9,
    0x8c, 0x0, 0x0, 0x5, 0xf1, 0x1f, 0x40, 0x0,
    0x5, 0xe0, 0x9, 0xb0, 0x0, 0x5, 0xe0, 0x2,
    0xf3, 0x0, 0x5, 0xe0, 0x0, 0xab, 0x0, 0x5,
    0xe0, 0x0, 0x2f, 0x30, 0x3b, 0xf8, 0x0, 0x6f,
    0xd4,

    /* U+4C "L" */
    0x29, 0xfa, 0x20, 0x0, 0x0, 0x2, 0xf2, 0x0,
    0x0, 0x0, 0x2, 0xf2, 0x0, 0x0, 0x0, 0x2,
    0xf2, 0x0, 0x0, 0x0, 0x2, 0xf2, 0x0, 0x0,
    0x0, 0x2, 0xf2, 0x0, 0x0, 0x0, 0x2, 0xf2,
    0x0, 0x0, 0x0, 0x2, 0xf2, 0x0, 0x0, 0x0,
    0x2, 0xf2, 0x0, 0x0, 0x0, 0x2, 0xf2, 0x0,
    0x0, 0x0, 0x2, 0xf2, 0x0, 0x0, 0x44, 0x2,
    0xf2, 0x0, 0x0, 0xc0, 0x29, 0xfa, 0x77, 0x8e,
    0xc0,

    /* U+4D "M" */
    0x6f, 0x80, 0x0, 0xd, 0xf6, 0xd, 0xc0, 0x0,
    0x1f, 0xc0, 0xa, 0xf0, 0x0, 0x5b, 0xc0, 0x7,
    0xe3, 0x0, 0x88, 0xc0, 0x7, 0xb6, 0x0, 0x88,
    0xc0, 0x7, 0x7a, 0x0, 0x78, 0xc0, 0x7, 0x3d,
    0x4, 0x48, 0xc0, 0x7, 0xf, 0x17, 0x8, 0xc0,
    0x7, 0xc, 0x48, 0x8, 0xc0, 0x7, 0x9, 0x87,
    0x8, 0xc0, 0x7, 0x5, 0xf4, 0x8, 0xc0, 0x7,
    0x1, 0xf0, 0x8, 0xc0, 0x6d, 0x40, 0xb0, 0x4d,
    0xf5,

    /* U+4E "N" */
    0x5d, 0xd0, 0x0, 0x28, 0xd6, 0x8, 0xe6, 0x0,
    0x0, 0x70, 0x7, 0x7e, 0x0, 0x0, 0x70, 0x7,
    0xe, 0x70, 0x0, 0x70, 0x7, 0x6, 0xe0, 0x0,
    0x70, 0x7, 0x0, 0xd8, 0x0, 0x70, 0x7, 0x0,
    0x5f, 0x10, 0x70, 0x7, 0x0, 0xd, 0x90, 0x70,
    0x7, 0x0, 0x5, 0xf2, 0x70, 0x7, 0x0, 0x0,
    0xca, 0x70, 0x7, 0x0, 0x0, 0x4f, 0x80, 0x7,
    0x0, 0x0, 0xb, 0x80, 0x6d, 0x82, 0x0, 0x3,
    0x80,

    /* U+4F "O" */
    0x0, 0x19, 0x98, 0x91, 0x0, 0x0, 0xc5, 0x0,
    0x2d, 0x10, 0x7, 0xc0, 0x0, 0x9, 0x90, 0xe,
    0x70, 0x0, 0x5, 0xf0, 0x1f, 0x40, 0x0, 0x2,
    0xf4, 0x3f, 0x30, 0x0, 0x1, 0xf6, 0x4f, 0x30,
    0x0, 0x0, 0xf7, 0x3f, 0x30, 0x0, 0x1, 0xf6,
    0x1f, 0x40, 0x0, 0x2, 0xf4, 0xd, 0x70, 0x0,
    0x4, 0xf0, 0x6, 0xb0, 0x0, 0x8, 0xa0, 0x0,
    0xb4, 0x0, 0x1d, 0x10, 0x0, 0x8, 0x77, 0x91,
    0x0,

    /* U+50 "P" */
    0x3b, 0xf8, 0x77, 0x96, 0x0, 0x4, 0xf0, 0x0,
    0xa, 0xa0, 0x4, 0xf0, 0x0, 0x3, 0xf1, 0x4,
    0xf0, 0x0, 0x2, 0xf3, 0x4, 0xf0, 0x0, 0x5,
    0xf0, 0x4, 0xf0, 0x0, 0x2d, 0x60, 0x4, 0xf7,
    0x77, 0x82, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x0,
    0x4, 0xf0, 0x0, 0x0, 0x0, 0x4, 0xf0, 0x0,
    0x0, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x0, 0x4,
    0xf0, 0x0, 0x0, 0x0, 0x3b, 0xf8, 0x10, 0x0,
    0x0,

    /* U+51 "Q" */
    0x0, 0x2a, 0x98, 0x91, 0x0, 0x1, 0xe4, 0x0,
    0x2d, 0x10, 0x9, 0xb0, 0x0, 0xa, 0x90, 0xf,
    0x60, 0x0, 0x5, 0xf0, 0x3f, 0x30, 0x0, 0x3,
    0xf3, 0x5f, 0x20, 0x0, 0x2, 0xf5, 0x5f, 0x10,
    0x0, 0x1, 0xf5, 0x5f, 0x20, 0x0, 0x2, 0xf5,
    0x3f, 0x20, 0x0, 0x3, 0xf3, 0xf, 0x59, 0xc8,
    0x5, 0xf0, 0xa, 0xe5, 0xd, 0x58, 0xa0, 0x1,
    0xe4, 0x7, 0xcd, 0x10, 0x0, 0x19, 0x8a, 0xf6,
    0x10, 0x0, 0x0, 0x0, 0xaf, 0xc0, 0x0, 0x0,
    0x0, 0x2, 0x0,

    /* U+52 "R" */
    0x2a, 0xf9, 0x78, 0xb5, 0x0, 0x3, 0xf0, 0x0,
    0x1f, 0x50, 0x3, 0xf0, 0x0, 0xa, 0xb0, 0x3,
    0xf0, 0x0, 0x8, 0xc0, 0x3, 0xf0, 0x0, 0xb,
    0x90, 0x3, 0xf0, 0x0, 0x5e, 0x10, 0x3, 0xf7,
    0x8d, 0x81, 0x0, 0x3, 0xf0, 0xd, 0x60, 0x0,
    0x3, 0xf0, 0x6, 0xd0, 0x0, 0x3, 0xf0, 0x1,
    0xf4, 0x0, 0x3, 0xf0, 0x0, 0x9a, 0x0, 0x3,
    0xf0, 0x0, 0x3f, 0x20, 0x2a, 0xf9, 0x10, 0xc,
    0xc4,

    /* U+53 "S" */
    0x0, 0x58, 0x8a, 0xff, 0x10, 0x58, 0x0, 0x2,
    0xe3, 0xd, 0x10, 0x0, 0x4, 0x40, 0xe2, 0x0,
    0x0, 0x0, 0xa, 0xc2, 0x0, 0x0, 0x0, 0x1a,
    0xfa, 0x20, 0x0, 0x0, 0x3, 0xaf, 0xb1, 0x0,
    0x0, 0x0, 0x2c, 0xe1, 0x0, 0x0, 0x0, 0xb,
    0x90, 0x30, 0x0, 0x0, 0x5c, 0xb, 0x0, 0x0,
    0x6, 0xa0, 0xc8, 0x0, 0x0, 0xc2, 0x9, 0xfd,
    0x98, 0xa4, 0x0,

    /* U+54 "T" */
    0xd, 0xb8, 0xed, 0x8b, 0xc0, 0x1a, 0x0, 0xb8,
    0x0, 0xb0, 0x53, 0x0, 0xb8, 0x0, 0x42, 0x0,
    0x0, 0xb8, 0x0, 0x0, 0x0, 0x0, 0xb8, 0x0,
    0x0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0, 0x0,
    0xb8, 0x0, 0x0, 0x0, 0x0, 0xb8, 0x0, 0x0,
    0x0, 0x0, 0xb8, 0x0, 0x0, 0x0, 0x0, 0xb8,
    0x0, 0x0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0,
    0x0, 0xb8, 0x0, 0x0, 0x0, 0x7, 0xed, 0x70,
    0x0,

    /* U+55 "U" */
    0x5d, 0xe5, 0x0, 0x29, 0xc3, 0x9, 0xa0, 0x0,
    0x1, 0x50, 0x9, 0xa0, 0x0, 0x1, 0x50, 0x9,
    0xa0, 0x0, 0x1, 0x50, 0x9, 0xa0, 0x0, 0x1,
    0x50, 0x9, 0xa0, 0x0, 0x1, 0x50, 0x9, 0xa0,
    0x0, 0x1, 0x50, 0x9, 0xa0, 0x0, 0x1, 0x50,
    0x9, 0xa0, 0x0, 0x1, 0x50, 0x9, 0xa0, 0x0,
    0x1, 0x50, 0x8, 0xb0, 0x0, 0x4, 0x40, 0x3,
    0xf2, 0x0, 0x1a, 0x0, 0x0, 0x3b, 0xa9, 0x81,
    0x0,

    /* U+56 "V" */
    0x5d, 0xe5, 0x0, 0x2c, 0xc3, 0x7, 0xd0, 0x0,
    0x8, 0x20, 0x3, 0xf1, 0x0, 0x9, 0x0, 0x0,
    0xe5, 0x0, 0x8, 0x0, 0x0, 0xb9, 0x0, 0x44,
    0x0, 0x0, 0x7d, 0x0, 0x80, 0x0, 0x0, 0x2f,
    0x10, 0x90, 0x0, 0x0, 0xe, 0x51, 0x70, 0x0,
    0x0, 0xa, 0x96, 0x20, 0x0, 0x0, 0x6, 0xd8,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xe5, 0x0, 0x0, 0x0, 0x0, 0xa1, 0x0,
    0x0,

    /* U+57 "W" */
    0x7f, 0x81, 0xdd, 0x33, 0xd7, 0xf, 0x10, 0x6b,
    0x0, 0x80, 0xd, 0x30, 0x4d, 0x0, 0x80, 0xa,
    0x60, 0x5f, 0x0, 0x70, 0x8, 0x80, 0x8f, 0x13,
    0x40, 0x5, 0xb0, 0x8d, 0x46, 0x20, 0x3, 0xd0,
    0x8a, 0x68, 0x0, 0x0, 0xf2, 0x68, 0x88, 0x0,
    0x0, 0xe8, 0x35, 0xb8, 0x0, 0x0, 0xbd, 0x3,
    0xf6, 0x0, 0x0, 0x9c, 0x1, 0xf3, 0x0, 0x0,
    0x69, 0x0, 0xe1, 0x0, 0x0, 0x46, 0x0, 0xa0,
    0x0,

    /* U+58 "X" */
    0x1a, 0xf9, 0x0, 0x6e, 0x91, 0x0, 0xd5, 0x0,
    0x9, 0x0, 0x0, 0x6c, 0x0, 0x73, 0x0, 0x0,
    0xe, 0x40, 0x90, 0x0, 0x0, 0x7, 0xb6, 0x30,
    0x0, 0x0, 0x0, 0xea, 0x0, 0x0, 0x0, 0x0,
    0x9b, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x30, 0x0,
    0x0, 0x6, 0x4a, 0xa0, 0x0, 0x0, 0xa, 0x2,
    0xf2, 0x0, 0x0, 0x54, 0x0, 0xb9, 0x0, 0x0,
    0xa0, 0x0, 0x3f, 0x20, 0x3b, 0xe3, 0x0, 0x6f,
    0xd4,

    /* U+59 "Y" */
    0x4e, 0xf6, 0x0, 0x4d, 0xc3, 0x4, 0xf0, 0x0,
    0x9, 0x0, 0x0, 0xd6, 0x0, 0x8, 0x0, 0x0,
    0x7c, 0x0, 0x62, 0x0, 0x0, 0x1f, 0x20, 0x80,
    0x0, 0x0, 0xb, 0x82, 0x50, 0x0, 0x0, 0x4,
    0xe8, 0x0, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x0,
    0x0, 0x0, 0xb8, 0x0, 0x0, 0x0, 0x0, 0xb8,
    0x0, 0x0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0,
    0x0, 0xb8, 0x0, 0x0, 0x0, 0x7, 0xed, 0x70,
    0x0,

    /* U+5A "Z" */
    0x2, 0xfc, 0x87, 0x7c, 0xd0, 0x8, 0x70, 0x0,
    0x1e, 0x50, 0x6, 0x0, 0x0, 0x8c, 0x0, 0x0,
    0x0, 0x1, 0xf3, 0x0, 0x0, 0x0, 0xa, 0xa0,
    0x0, 0x0, 0x0, 0x3f, 0x20, 0x0, 0x0, 0x0,
    0xb9, 0x0, 0x0, 0x0, 0x4, 0xf1, 0x0, 0x0,
    0x0, 0xd, 0x70, 0x0, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0x0, 0x0, 0xe6, 0x0, 0x0, 0x90, 0x7,
    0xd0, 0x0, 0x4, 0xa0, 0x1f, 0xa7, 0x77, 0xaf,
    0x50,

    /* U+5B "[" */
    0x1c, 0xbb, 0xb6, 0x1b, 0x0, 0x0, 0x1b, 0x0,
    0x0, 0x1b, 0x0, 0x0, 0x1b, 0x0, 0x0, 0x1b,
    0x0, 0x0, 0x1b, 0x0, 0x0, 0x1b, 0x0, 0x0,
    0x1b, 0x0, 0x0, 0x1b, 0x0, 0x0, 0x1b, 0x0,
    0x0, 0x1b, 0x0, 0x0, 0x1b, 0x0, 0x0, 0x1b,
    0x0, 0x0, 0x1b, 0x0, 0x0, 0x1b, 0x0, 0x0,
    0x1c, 0xbb, 0xb6,

    /* U+5C "\\" */
    0x4a, 0x0, 0x0, 0x0, 0x0, 0xd1, 0x0, 0x0,
    0x0, 0x7, 0x70, 0x0, 0x0, 0x0, 0x1d, 0x0,
    0x0, 0x0, 0x0, 0xa4, 0x0, 0x0, 0x0, 0x3,
    0xb0, 0x0, 0x0, 0x0, 0xc, 0x20, 0x0, 0x0,
    0x0, 0x68, 0x0, 0x0, 0x0, 0x0, 0xd0, 0x0,
    0x0, 0x0, 0x9, 0x50, 0x0, 0x0, 0x0, 0x2c,
    0x0, 0x0, 0x0, 0x0, 0xb3, 0x0, 0x0, 0x0,
    0x5, 0x90, 0x0, 0x0, 0x0, 0xd, 0x10, 0x0,
    0x0, 0x0, 0x87, 0x0, 0x0, 0x0, 0x1, 0xd0,

    /* U+5D "]" */
    0x7b, 0xbb, 0xc0, 0x0, 0x0, 0xc0, 0x0, 0x0,
    0xc0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0xc0, 0x0,
    0x0, 0xc0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0xc0,
    0x0, 0x0, 0xc0, 0x0, 0x0, 0xc0, 0x0, 0x0,
    0xc0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0xc0, 0x0,
    0x0, 0xc0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0xc0,
    0x7b, 0xbb, 0xc0,

    /* U+5E "^" */
    0x5, 0xee, 0x50, 0x38, 0x11, 0x92, 0x0, 0x0,
    0x0,

    /* U+5F "_" */
    0x77, 0x77, 0x77, 0x77, 0x76,

    /* U+60 "`" */
    0x19, 0xf6, 0x0, 0x1, 0x74,

    /* U+61 "a" */
    0x0, 0x68, 0x77, 0x92, 0x0, 0x7, 0xb0, 0x0,
    0x4c, 0x0, 0x5, 0x70, 0x0, 0x2f, 0x0, 0x0,
    0x1, 0x58, 0x8f, 0x0, 0x1, 0xb9, 0x30, 0x2f,
    0x0, 0xc, 0x80, 0x0, 0x2f, 0x0, 0x1f, 0x30,
    0x0, 0x2f, 0x0, 0xe, 0x60, 0x0, 0x6f, 0x5,
    0x3, 0xb9, 0x98, 0x3c, 0x93,

    /* U+62 "b" */
    0x1, 0x40, 0x0, 0x0, 0x3, 0xcb, 0x0, 0x0,
    0x0, 0x5, 0xb0, 0x0, 0x0, 0x0, 0x5b, 0x0,
    0x0, 0x0, 0x5, 0xb0, 0x0, 0x0, 0x0, 0x5b,
    0x29, 0x9c, 0x60, 0x5, 0xd8, 0x0, 0x1e, 0x40,
    0x5f, 0x10, 0x0, 0x9a, 0x5, 0xb0, 0x0, 0x6,
    0xd0, 0x5b, 0x0, 0x0, 0x5e, 0x5, 0xb0, 0x0,
    0x6, 0xd0, 0x5c, 0x0, 0x0, 0x99, 0x5, 0xf2,
    0x0, 0x1e, 0x20, 0x55, 0x78, 0x9a, 0x30,

    /* U+63 "c" */
    0x0, 0x88, 0x7a, 0x30, 0xc, 0x50, 0x3, 0xf0,
    0x6c, 0x0, 0x2, 0xd1, 0xb8, 0x0, 0x0, 0x0,
    0xc7, 0x0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0,
    0x8c, 0x0, 0x0, 0x6, 0x1e, 0x40, 0x0, 0x82,
    0x2, 0xaa, 0x99, 0x30,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x32, 0x0, 0x0, 0x1, 0x8f,
    0x40, 0x0, 0x0, 0x0, 0xd4, 0x0, 0x0, 0x0,
    0xd, 0x40, 0x0, 0x0, 0x0, 0xd4, 0x0, 0x1a,
    0xa9, 0x7d, 0x40, 0xd, 0x40, 0x2, 0xf4, 0x7,
    0xc0, 0x0, 0xd, 0x40, 0xb8, 0x0, 0x0, 0xd4,
    0xd, 0x70, 0x0, 0xd, 0x40, 0xc8, 0x0, 0x0,
    0xd4, 0x8, 0xa0, 0x0, 0xe, 0x40, 0x1e, 0x20,
    0x6, 0xf4, 0x0, 0x3b, 0xa9, 0x6c, 0xa3,

    /* U+65 "e" */
    0x0, 0x99, 0x9a, 0x20, 0xc, 0x50, 0x2, 0xe1,
    0x5c, 0x0, 0x0, 0xb8, 0xa9, 0x0, 0x0, 0x8b,
    0xbb, 0x77, 0x77, 0x99, 0xa8, 0x0, 0x0, 0x0,
    0x6c, 0x0, 0x0, 0x3, 0xd, 0x50, 0x0, 0x72,
    0x1, 0x9b, 0x99, 0x30,

    /* U+66 "f" */
    0x0, 0x3, 0x87, 0x8a, 0x10, 0x2, 0xd0, 0x0,
    0xf5, 0x0, 0x7a, 0x0, 0x0, 0x0, 0x7, 0x90,
    0x0, 0x0, 0x67, 0xbc, 0x77, 0x60, 0x0, 0x7,
    0x90, 0x0, 0x0, 0x0, 0x79, 0x0, 0x0, 0x0,
    0x7, 0x90, 0x0, 0x0, 0x0, 0x79, 0x0, 0x0,
    0x0, 0x7, 0x90, 0x0, 0x0, 0x0, 0x79, 0x0,
    0x0, 0x0, 0x7, 0x90, 0x0, 0x0, 0x37, 0xde,
    0x77, 0x10, 0x0,

    /* U+67 "g" */
    0x2, 0x97, 0x89, 0x8e, 0x40, 0xd1, 0x0, 0x88,
    0x41, 0x4c, 0x0, 0x4, 0xd0, 0x4, 0xd0, 0x0,
    0x4c, 0x0, 0xb, 0x40, 0xa, 0x50, 0x0, 0x97,
    0x77, 0x40, 0x0, 0x3d, 0x30, 0x0, 0x0, 0x0,
    0xbf, 0xfe, 0xb7, 0x0, 0x5b, 0x24, 0x68, 0xe9,
    0xd, 0x20, 0x0, 0x4, 0xc0, 0xa6, 0x0, 0x0,
    0x67, 0x0, 0x78, 0x77, 0x87, 0x0,

    /* U+68 "h" */
    0x1, 0x80, 0x0, 0x0, 0x0, 0x3b, 0xd0, 0x0,
    0x0, 0x0, 0x4, 0xd0, 0x0, 0x0, 0x0, 0x4,
    0xd0, 0x0, 0x0, 0x0, 0x4, 0xd0, 0x0, 0x0,
    0x0, 0x4, 0xd2, 0xab, 0xc6, 0x0, 0x4, 0xe9,
    0x0, 0x1f, 0x10, 0x4, 0xd0, 0x0, 0xd, 0x30,
    0x4, 0xd0, 0x0, 0xd, 0x40, 0x4, 0xd0, 0x0,
    0xd, 0x40, 0x4, 0xd0, 0x0, 0xd, 0x40, 0x4,
    0xd0, 0x0, 0xd, 0x40, 0x4, 0xd0, 0x0, 0xd,
    0x40, 0x2b, 0xf7, 0x0, 0x7f, 0xb2,

    /* U+69 "i" */
    0x0, 0xbd, 0x0, 0x0, 0x9b, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x23, 0x0, 0x67, 0xd8, 0x0, 0x0,
    0x88, 0x0, 0x0, 0x88, 0x0, 0x0, 0x88, 0x0,
    0x0, 0x88, 0x0, 0x0, 0x88, 0x0, 0x0, 0x88,
    0x0, 0x0, 0x88, 0x0, 0x67, 0xdd, 0x76,

    /* U+6A "j" */
    0x0, 0x0, 0xa, 0xd0, 0x0, 0x0, 0x9, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x40,
    0x0, 0x4, 0x7c, 0xb0, 0x0, 0x0, 0x5, 0xb0,
    0x0, 0x0, 0x5, 0xb0, 0x0, 0x0, 0x5, 0xb0,
    0x0, 0x0, 0x5, 0xb0, 0x0, 0x0, 0x5, 0xb0,
    0x0, 0x0, 0x5, 0xb0, 0x0, 0x0, 0x5, 0xb0,
    0x0, 0x0, 0x5, 0xb0, 0x0, 0x0, 0x7, 0x80,
    0x5e, 0x0, 0xc, 0x20, 0x1b, 0xb9, 0x92, 0x0,

    /* U+6B "k" */
    0x1, 0x80, 0x0, 0x0, 0x0, 0x2a, 0xe0, 0x0,
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x0, 0x3, 0xe0, 0x3, 0xec, 0x50, 0x3, 0xe0,
    0x2, 0xa0, 0x0, 0x3, 0xe0, 0x1b, 0x0, 0x0,
    0x3, 0xe1, 0xd7, 0x0, 0x0, 0x3, 0xea, 0x5f,
    0x10, 0x0, 0x3, 0xf2, 0xa, 0xa0, 0x0, 0x3,
    0xe0, 0x1, 0xf4, 0x0, 0x3, 0xe0, 0x0, 0x6d,
    0x0, 0x2a, 0xf8, 0x0, 0x6f, 0xb2,

    /* U+6C "l" */
    0x0, 0x17, 0x70, 0x0, 0x7, 0x7d, 0x80, 0x0,
    0x0, 0x8, 0x80, 0x0, 0x0, 0x8, 0x80, 0x0,
    0x0, 0x8, 0x80, 0x0, 0x0, 0x8, 0x80, 0x0,
    0x0, 0x8, 0x80, 0x0, 0x0, 0x8, 0x80, 0x0,
    0x0, 0x8, 0x80, 0x0, 0x0, 0x8, 0x80, 0x0,
    0x0, 0x8, 0x80, 0x0, 0x0, 0x8, 0x80, 0x0,
    0x0, 0x8, 0x80, 0x0, 0x7, 0x7d, 0xd7, 0x70,

    /* U+6D "m" */
    0x7f, 0x69, 0xd4, 0x9b, 0x90, 0xf, 0x60, 0x8d,
    0x0, 0xf1, 0xf, 0x10, 0x7a, 0x0, 0xf2, 0xf,
    0x10, 0x7a, 0x0, 0xf2, 0xf, 0x10, 0x7a, 0x0,
    0xf2, 0xf, 0x10, 0x7a, 0x0, 0xf2, 0xf, 0x10,
    0x7a, 0x0, 0xf2, 0xf, 0x10, 0x7a, 0x0, 0xf2,
    0x6f, 0x81, 0xcd, 0x36, 0xf9,

    /* U+6E "n" */
    0x2c, 0xd2, 0x99, 0xb5, 0x0, 0x4, 0xe9, 0x0,
    0x1e, 0x10, 0x4, 0xd0, 0x0, 0xd, 0x30, 0x4,
    0xd0, 0x0, 0xd, 0x40, 0x4, 0xd0, 0x0, 0xd,
    0x40, 0x4, 0xd0, 0x0, 0xd, 0x40, 0x4, 0xd0,
    0x0, 0xd, 0x40, 0x4, 0xd0, 0x0, 0xd, 0x40,
    0x2b, 0xf7, 0x0, 0x7f, 0xb2,

    /* U+6F "o" */
    0x0, 0x19, 0x77, 0x92, 0x0, 0x1, 0xd2, 0x0,
    0x2d, 0x10, 0x9, 0x80, 0x0, 0x8, 0x90, 0xe,
    0x50, 0x0, 0x5, 0xe0, 0xf, 0x30, 0x0, 0x3,
    0xf0, 0xf, 0x40, 0x0, 0x4, 0xf0, 0xa, 0x70,
    0x0, 0x8, 0xa0, 0x2, 0xd1, 0x0, 0x1d, 0x10,
    0x0, 0x29, 0x87, 0x92, 0x0,

    /* U+70 "p" */
    0x4d, 0xd3, 0xaa, 0xb5, 0x0, 0x4, 0xe8, 0x0,
    0xd, 0x50, 0x4, 0xd0, 0x0, 0x7, 0xc0, 0x4,
    0xd0, 0x0, 0x4, 0xf0, 0x4, 0xd0, 0x0, 0x3,
    0xf0, 0x4, 0xd0, 0x0, 0x4, 0xf0, 0x4, 0xd0,
    0x0, 0x7, 0xb0, 0x4, 0xf4, 0x0, 0x2e, 0x30,
    0x4, 0xd6, 0x89, 0xb3, 0x0, 0x4, 0xd0, 0x0,
    0x0, 0x0, 0x4, 0xd0, 0x0, 0x0, 0x0, 0x3b,
    0xf8, 0x10, 0x0, 0x0,

    /* U+71 "q" */
    0x2, 0xa9, 0x86, 0x63, 0x2, 0xd2, 0x0, 0x4f,
    0x30, 0xa8, 0x0, 0x0, 0xe3, 0xe, 0x50, 0x0,
    0xe, 0x30, 0xf4, 0x0, 0x0, 0xe3, 0xe, 0x40,
    0x0, 0xe, 0x30, 0xb7, 0x0, 0x0, 0xe3, 0x3,
    0xd1, 0x0, 0x6f, 0x30, 0x4, 0xba, 0x95, 0xe3,
    0x0, 0x0, 0x0, 0xe, 0x30, 0x0, 0x0, 0x0,
    0xe3, 0x0, 0x0, 0x1, 0x8f, 0xa2,

    /* U+72 "r" */
    0x29, 0xcf, 0x3, 0x9c, 0xb0, 0x0, 0x2f, 0x37,
    0x4, 0xe0, 0x0, 0x1f, 0x80, 0x0, 0x0, 0x0,
    0x1f, 0x10, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x0,
    0x27, 0x9f, 0x87, 0x20, 0x0,

    /* U+73 "s" */
    0x2, 0x87, 0x8e, 0xf0, 0xc, 0x0, 0x0, 0xc2,
    0xf, 0x0, 0x0, 0x32, 0xa, 0xd6, 0x10, 0x0,
    0x0, 0x5b, 0xfa, 0x20, 0x0, 0x0, 0x28, 0xe2,
    0x44, 0x0, 0x0, 0x87, 0x3c, 0x0, 0x0, 0x94,
    0x2f, 0xd8, 0x77, 0x60,

    /* U+74 "t" */
    0x0, 0x4, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0,
    0x1, 0xab, 0x0, 0x0, 0x57, 0xad, 0x77, 0x50,
    0x0, 0x6b, 0x0, 0x0, 0x0, 0x6b, 0x0, 0x0,
    0x0, 0x6b, 0x0, 0x0, 0x0, 0x6b, 0x0, 0x0,
    0x0, 0x6b, 0x0, 0x0, 0x0, 0x5b, 0x0, 0x4,
    0x0, 0x2d, 0x0, 0x52, 0x0, 0x8, 0xca, 0x60,

    /* U+75 "u" */
    0x3c, 0xb0, 0x0, 0x8f, 0x30, 0x5, 0xb0, 0x0,
    0xe, 0x30, 0x5, 0xb0, 0x0, 0xe, 0x30, 0x5,
    0xb0, 0x0, 0xe, 0x30, 0x5, 0xb0, 0x0, 0xe,
    0x30, 0x5, 0xb0, 0x0, 0xe, 0x30, 0x4, 0xc0,
    0x0, 0xf, 0x30, 0x1, 0xe1, 0x0, 0x8f, 0x30,
    0x0, 0x6d, 0xbb, 0x4d, 0xa2,

    /* U+76 "v" */
    0x2a, 0xf9, 0x0, 0x5f, 0xa1, 0x0, 0xe3, 0x0,
    0xa, 0x0, 0x0, 0x98, 0x0, 0x36, 0x0, 0x0,
    0x4d, 0x0, 0x81, 0x0, 0x0, 0xe, 0x30, 0x90,
    0x0, 0x0, 0x9, 0x83, 0x50, 0x0, 0x0, 0x3,
    0xe8, 0x0, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x0,
    0x0, 0x0, 0x84, 0x0, 0x0,

    /* U+77 "w" */
    0x8f, 0x83, 0xdd, 0x15, 0xe7, 0xe, 0x30, 0x6a,
    0x0, 0x90, 0x9, 0x60, 0x7d, 0x2, 0x60, 0x6,
    0xa0, 0x7f, 0x15, 0x20, 0x2, 0xd0, 0x7b, 0x48,
    0x0, 0x0, 0xe3, 0x47, 0x87, 0x0, 0x0, 0xab,
    0x14, 0xc6, 0x0, 0x0, 0x6c, 0x0, 0xf2, 0x0,
    0x0, 0x28, 0x0, 0xb0, 0x0,

    /* U+78 "x" */
    0x6, 0xee, 0x31, 0x9d, 0x60, 0x0, 0x3f, 0x20,
    0x83, 0x0, 0x0, 0x9, 0xb3, 0x80, 0x0, 0x0,
    0x1, 0xec, 0x0, 0x0, 0x0, 0x0, 0xad, 0x0,
    0x0, 0x0, 0x2, 0x8c, 0x60, 0x0, 0x0, 0xa,
    0x3, 0xe1, 0x0, 0x0, 0x74, 0x0, 0x99, 0x0,
    0x29, 0xf6, 0x2, 0xaf, 0x91,

    /* U+79 "y" */
    0x19, 0xfb, 0x10, 0x8f, 0x92, 0x0, 0xc5, 0x0,
    0xa, 0x0, 0x0, 0x6b, 0x0, 0x55, 0x0, 0x0,
    0x1f, 0x0, 0x90, 0x0, 0x0, 0xa, 0x50, 0xa0,
    0x0, 0x0, 0x4, 0xb4, 0x50, 0x0, 0x0, 0x0,
    0xea, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x0,
    0x0, 0x0, 0x56, 0x0, 0x0, 0x0, 0x0, 0x81,
    0x0, 0x0, 0x2, 0x51, 0x80, 0x0, 0x0, 0x6,
    0xfa, 0x10, 0x0, 0x0,

    /* U+7A "z" */
    0x5f, 0x87, 0x7b, 0xe0, 0x75, 0x0, 0x1e, 0x40,
    0x60, 0x0, 0xaa, 0x0, 0x0, 0x4, 0xe1, 0x0,
    0x0, 0xe, 0x50, 0x0, 0x0, 0x9a, 0x0, 0x1,
    0x4, 0xe1, 0x0, 0x17, 0xe, 0x50, 0x0, 0x84,
    0x8e, 0x77, 0x7a, 0xf2,

    /* U+7B "{" */
    0x0, 0x18, 0x40, 0xb, 0x10, 0x0, 0xa0, 0x0,
    0xa, 0x0, 0x1, 0xa0, 0x0, 0x1a, 0x0, 0x1,
    0xa0, 0x0, 0x28, 0x0, 0x48, 0x10, 0x3, 0x81,
    0x0, 0x2, 0x80, 0x0, 0x1a, 0x0, 0x1, 0xa0,
    0x0, 0x1a, 0x0, 0x0, 0xa0, 0x0, 0xa, 0x0,
    0x0, 0xb1, 0x0, 0x1, 0x84,

    /* U+7C "|" */
    0x21, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52,

    /* U+7D "}" */
    0x48, 0x10, 0x0, 0x1b, 0x0, 0x0, 0xa0, 0x0,
    0xa, 0x0, 0x0, 0xa1, 0x0, 0xa, 0x10, 0x0,
    0xa1, 0x0, 0x8, 0x30, 0x0, 0x18, 0x40, 0x1,
    0x83, 0x0, 0x83, 0x0, 0xa, 0x10, 0x0, 0xa1,
    0x0, 0xa, 0x10, 0x0, 0xa0, 0x0, 0xa, 0x0,
    0x1, 0xb0, 0x4, 0x81, 0x0,

    /* U+7E "~" */
    0x1, 0x8b, 0x40, 0x0, 0x0, 0x7, 0x2, 0xd4,
    0x0, 0x23, 0x14, 0x0, 0x2d, 0x40, 0x70, 0x0,
    0x0, 0x2, 0xba, 0x20,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x31, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x15, 0xae, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x7c, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x49, 0xef, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x4, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x69, 0xff, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xfe, 0x95, 0x0, 0x8, 0xff,
    0x0, 0x0, 0xf, 0xff, 0xc7, 0x30, 0x0, 0x0,
    0x8, 0xff, 0x0, 0x0, 0xf, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0x0, 0x0, 0xf, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x0, 0x0,
    0xf, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x0, 0x0, 0xf, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x0, 0x0, 0xf, 0xf8, 0x0, 0x0,
    0x1, 0x7b, 0xbd, 0xff, 0x0, 0x0, 0xf, 0xf8,
    0x0, 0x0, 0x1e, 0xff, 0xff, 0xff, 0x0, 0x13,
    0x3f, 0xf8, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0x2b, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xfc, 0xdf, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x6, 0xef, 0xff, 0xa1, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x2, 0x20, 0x0, 0x7f, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x8a, 0xa6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F008 "" */
    0xc4, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x4c, 0xfd, 0xcd, 0xff, 0xee, 0xee, 0xee,
    0xee, 0xff, 0xdc, 0xdf, 0xfa, 0x8a, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xb8, 0xaf, 0xf4, 0x3,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x40, 0x4f,
    0xf4, 0x4, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x50, 0x4f, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xf7, 0x47, 0xfd, 0x77,
    0x77, 0x77, 0x77, 0xdf, 0x84, 0x7f, 0xf4, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x4f,
    0xf7, 0x47, 0xfd, 0x77, 0x77, 0x77, 0x77, 0xdf,
    0x84, 0x7f, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xf4, 0x4, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x50, 0x4f, 0xf4, 0x3,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x40, 0x4f,
    0xfa, 0x8a, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xb8, 0xaf, 0xfd, 0xcd, 0xff, 0xee, 0xee, 0xee,
    0xee, 0xff, 0xdc, 0xdf, 0xc4, 0x3, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x4c,

    /* U+F00B "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xfa, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xfd, 0xe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xcf, 0xff, 0xf9, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xf9, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xfd, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff,
    0xfa, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xf9, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xfd, 0xe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xfa, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4e, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0x60, 0x6, 0xe4, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xf6, 0x0, 0x7f, 0xff, 0x40, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0x60, 0x0, 0xff, 0xff,
    0xf4, 0x0, 0x4, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0x40, 0x4f, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5e,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x6, 0x70, 0x0, 0x0, 0x0, 0x18, 0x40, 0x8f,
    0xfb, 0x0, 0x0, 0x1, 0xdf, 0xf4, 0xff, 0xff,
    0xb0, 0x0, 0x1d, 0xff, 0xfb, 0x7f, 0xff, 0xfb,
    0x1, 0xdf, 0xff, 0xf4, 0x8, 0xff, 0xff, 0xbd,
    0xff, 0xff, 0x40, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x1, 0xef, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x1,
    0xdf, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x1d, 0xff,
    0xff, 0x48, 0xff, 0xff, 0xb0, 0xcf, 0xff, 0xf4,
    0x0, 0x8f, 0xff, 0xf9, 0xdf, 0xff, 0x40, 0x0,
    0x8, 0xff, 0xf9, 0x2e, 0xf4, 0x0, 0x0, 0x0,
    0x8f, 0xc0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x1,
    0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0x26, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x64, 0x0,
    0xdf, 0xf4, 0x0, 0x72, 0x0, 0x0, 0x0, 0xb,
    0xfe, 0x10, 0xdf, 0xf4, 0x9, 0xfe, 0x30, 0x0,
    0x0, 0xaf, 0xff, 0x50, 0xdf, 0xf4, 0xe, 0xff,
    0xe1, 0x0, 0x5, 0xff, 0xfb, 0x0, 0xdf, 0xf4,
    0x5, 0xff, 0xfb, 0x0, 0xd, 0xff, 0xb0, 0x0,
    0xdf, 0xf4, 0x0, 0x5f, 0xff, 0x40, 0x4f, 0xff,
    0x20, 0x0, 0xdf, 0xf4, 0x0, 0xb, 0xff, 0xa0,
    0x8f, 0xfb, 0x0, 0x0, 0xdf, 0xf4, 0x0, 0x4,
    0xff, 0xf0, 0xbf, 0xf7, 0x0, 0x0, 0xdf, 0xf4,
    0x0, 0x1, 0xff, 0xf1, 0xbf, 0xf6, 0x0, 0x0,
    0xdf, 0xf4, 0x0, 0x0, 0xff, 0xf2, 0xbf, 0xf7,
    0x0, 0x0, 0x8d, 0xc1, 0x0, 0x0, 0xff, 0xf1,
    0x8f, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xf0, 0x4f, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xb0, 0xe, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0x50, 0x6, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x4, 0xff, 0xfc, 0x0,
    0x0, 0xaf, 0xff, 0xd5, 0x10, 0x3, 0x9f, 0xff,
    0xf2, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xd2, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x9e, 0xff, 0xff, 0xb6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x12, 0x10, 0x0, 0x0,
    0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x2b, 0xff, 0xff, 0xb2, 0x0, 0x10, 0x0,
    0x0, 0x8f, 0x87, 0xff, 0xff, 0xff, 0xff, 0x79,
    0xf8, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x40, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x2f, 0xff,
    0xff, 0xff, 0xc7, 0x7c, 0xff, 0xff, 0xff, 0xf2,
    0x7, 0xff, 0xff, 0xfa, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0x70, 0x0, 0x6f, 0xff, 0xf1, 0x0, 0x0,
    0x1f, 0xff, 0xf6, 0x0, 0x0, 0x7f, 0xff, 0xe0,
    0x0, 0x0, 0xe, 0xff, 0xf7, 0x0, 0x0, 0x6f,
    0xff, 0xf1, 0x0, 0x0, 0x1f, 0xff, 0xf6, 0x0,
    0x7, 0xff, 0xff, 0xfa, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0x70, 0x2f, 0xff, 0xff, 0xff, 0xc7, 0x7c,
    0xff, 0xff, 0xff, 0xf2, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x8f, 0x97, 0xff, 0xff, 0xff, 0xff, 0x78,
    0xf8, 0x0, 0x0, 0x1, 0x0, 0x1b, 0xff, 0xff,
    0xb1, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x20, 0x0, 0x0,
    0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x46, 0x10, 0x0,
    0x67, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xfe, 0x20, 0xf, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xbf, 0xff, 0xff, 0x51, 0xff,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x2, 0xdf, 0xfc,
    0x8f, 0xff, 0x8f, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xfa, 0x0, 0x4e, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xf7, 0x8, 0xd3,
    0x2d, 0xff, 0xff, 0x10, 0x0, 0x0, 0xa, 0xff,
    0xf5, 0x1b, 0xff, 0xf5, 0xb, 0xff, 0xf4, 0x0,
    0x0, 0x1c, 0xff, 0xe2, 0x2d, 0xff, 0xff, 0xf7,
    0x8, 0xff, 0xf6, 0x0, 0x3e, 0xff, 0xc1, 0x4e,
    0xff, 0xff, 0xff, 0xfa, 0x5, 0xff, 0xf9, 0xe,
    0xff, 0x90, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x13, 0xef, 0xf6, 0x4f, 0x70, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x31, 0xcc, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xff, 0x80, 0x1, 0xef, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xf6, 0x0, 0xe,
    0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0x60, 0x0, 0xef, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xf6, 0x0, 0xe, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff,
    0x40, 0x0, 0xcf, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x0, 0x56, 0x65, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xee, 0xef, 0xff, 0xff, 0xfe, 0xee,
    0x70, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x7a, 0xaa, 0xaa, 0x91,
    0x4f, 0xf4, 0x19, 0xaa, 0xaa, 0xa7, 0xff, 0xff,
    0xff, 0xfd, 0x23, 0x32, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0xf, 0x48, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xef, 0xff,
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x41,

    /* U+F01C "" */
    0x0, 0x0, 0x3d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0xa, 0xff, 0x98, 0x88, 0x88, 0x88, 0x88, 0xdf,
    0xf3, 0x0, 0x0, 0x5, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xd0, 0x0, 0x1, 0xef,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0x80, 0x0, 0xaf, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0x20, 0x5f, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfc,
    0xd, 0xff, 0x98, 0x88, 0x70, 0x0, 0x0, 0x3,
    0x88, 0x88, 0xdf, 0xf5, 0xff, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0x7f,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x0,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,
    0x7, 0xba, 0x0, 0x0, 0x1, 0x7c, 0xff, 0xff,
    0xb5, 0x0, 0xb, 0xff, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xe5, 0xb, 0xff, 0x0, 0xa,
    0xff, 0xff, 0xdb, 0xbe, 0xff, 0xff, 0x9a, 0xff,
    0x0, 0xaf, 0xff, 0xa2, 0x0, 0x0, 0x3b, 0xff,
    0xff, 0xff, 0x5, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xd, 0xff, 0x60, 0x0,
    0x0, 0x7, 0xba, 0x9c, 0xff, 0xff, 0x3f, 0xfc,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff,
    0x7f, 0xf6, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x6f, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0xcf, 0xf3, 0xff, 0xff, 0xc9, 0xaa,
    0x70, 0x0, 0x0, 0x7, 0xff, 0xd0, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0x50,
    0xff, 0xff, 0xff, 0xb3, 0x0, 0x0, 0x3b, 0xff,
    0xf9, 0x0, 0xff, 0xa9, 0xff, 0xff, 0xeb, 0xbd,
    0xff, 0xff, 0xa0, 0x0, 0xff, 0xb0, 0x5d, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0xff, 0xb0,
    0x0, 0x5b, 0xff, 0xff, 0xc8, 0x10, 0x0, 0x0,
    0xab, 0x70, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,
    0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x2, 0xee, 0x0, 0x0, 0x0, 0x2e, 0xff, 0x0,
    0x0, 0x2, 0xef, 0xff, 0x47, 0x77, 0x7e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x9, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x9f, 0xff, 0x0, 0x0,
    0x0, 0x9, 0xff, 0x0, 0x0, 0x0, 0x0, 0x89,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xf0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x73, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x1f, 0xf4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x5f, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x4f, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x1f, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x85, 0x4, 0x77, 0x77, 0xef, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xee, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7b, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x0, 0x9, 0xfe, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xee, 0x0, 0x0, 0x0, 0x9,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x2, 0xef, 0xf0,
    0x0, 0x8, 0x70, 0x8, 0xfd, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xff, 0x0, 0x0, 0xef, 0xb0, 0xc,
    0xf6, 0x4, 0x77, 0x77, 0xef, 0xff, 0xf0, 0x0,
    0x2, 0xdf, 0x80, 0x3f, 0xd0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x74, 0x1, 0xff, 0x10, 0xcf,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1f, 0xf4,
    0x8, 0xf7, 0x7, 0xf6, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x5f, 0xc0, 0x3f, 0xa0, 0x4f, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xff, 0x2,
    0xfb, 0x4, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x5f, 0xc0, 0x3f, 0xa0, 0x5f, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x1f, 0xf4, 0x8, 0xf7,
    0x7, 0xf6, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x74, 0x2, 0xff, 0x10, 0xcf, 0x30, 0x0, 0x0,
    0x9f, 0xff, 0xf0, 0x0, 0x2, 0xef, 0x80, 0x3f,
    0xd0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0x0, 0x0,
    0xef, 0xb0, 0xc, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xf0, 0x0, 0x8, 0x70, 0x8, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7b,
    0x20, 0x0, 0x0,

    /* U+F03E "" */
    0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe5, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xf6, 0x38, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x7f, 0xff, 0xff, 0xfb, 0xef,
    0xff, 0xff, 0xff, 0x80, 0x0, 0xcf, 0xff, 0xff,
    0x90, 0x3e, 0xff, 0xff, 0xff, 0xfa, 0x7c, 0xff,
    0xff, 0xf9, 0x0, 0x3, 0xef, 0xff, 0xff, 0xff,
    0xfc, 0xff, 0xff, 0x90, 0x0, 0x0, 0x3e, 0xff,
    0xff, 0xff, 0x90, 0x6f, 0xf9, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xf9, 0x0, 0x6, 0x90, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xc8, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x8c, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x5e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe5,

    /* U+F048 "" */
    0x47, 0x60, 0x0, 0x0, 0x0, 0x16, 0x1b, 0xff,
    0x10, 0x0, 0x0, 0x2d, 0xfb, 0xbf, 0xf1, 0x0,
    0x0, 0x2e, 0xff, 0xcb, 0xff, 0x10, 0x0, 0x3e,
    0xff, 0xfc, 0xbf, 0xf1, 0x0, 0x4f, 0xff, 0xff,
    0xcb, 0xff, 0x10, 0x5f, 0xff, 0xff, 0xfc, 0xbf,
    0xf1, 0x6f, 0xff, 0xff, 0xff, 0xcb, 0xff, 0x9f,
    0xff, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xcb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcb,
    0xff, 0x4e, 0xff, 0xff, 0xff, 0xfc, 0xbf, 0xf1,
    0x2d, 0xff, 0xff, 0xff, 0xcb, 0xff, 0x10, 0x1c,
    0xff, 0xff, 0xfc, 0xbf, 0xf1, 0x0, 0xc, 0xff,
    0xff, 0xcb, 0xff, 0x10, 0x0, 0xb, 0xff, 0xfc,
    0xbf, 0xf1, 0x0, 0x0, 0xa, 0xff, 0xca, 0xff,
    0x10, 0x0, 0x0, 0x8, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x6, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xfd, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xfa, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xd4, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb2, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x20, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x20, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x50, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xa2, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xd4, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xfa, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xfd, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x6, 0x77, 0x77, 0x30, 0x0, 0x6, 0x77, 0x77,
    0x30, 0xbf, 0xff, 0xff, 0xf3, 0x0, 0xbf, 0xff,
    0xff, 0xf3, 0xff, 0xff, 0xff, 0xf7, 0x0, 0xff,
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0xff, 0xff, 0xff, 0xf8,
    0xef, 0xff, 0xff, 0xf6, 0x0, 0xef, 0xff, 0xff,
    0xf6, 0x6f, 0xff, 0xff, 0xc1, 0x0, 0x6f, 0xff,
    0xff, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F04D "" */
    0x5, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x30, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F051 "" */
    0x5, 0x20, 0x0, 0x0, 0x0, 0x57, 0x66, 0xff,
    0x40, 0x0, 0x0, 0xc, 0xff, 0x8f, 0xff, 0x60,
    0x0, 0x0, 0xdf, 0xf8, 0xff, 0xff, 0x70, 0x0,
    0xd, 0xff, 0x8f, 0xff, 0xff, 0x80, 0x0, 0xdf,
    0xf8, 0xff, 0xff, 0xff, 0x90, 0xd, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xb0, 0xdf, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xcd, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0x5d, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0x40, 0xdf, 0xf8, 0xff, 0xff, 0xfe,
    0x30, 0xd, 0xff, 0x8f, 0xff, 0xfe, 0x20, 0x0,
    0xdf, 0xf8, 0xff, 0xfd, 0x20, 0x0, 0xd, 0xff,
    0x7f, 0xfd, 0x10, 0x0, 0x0, 0xdf, 0xf3, 0xfb,
    0x10, 0x0, 0x0, 0xc, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xff, 0xfe, 0x10, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe2, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x80, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0x40, 0x0, 0x0, 0x5f, 0xff, 0xe2, 0x0, 0x0,
    0x5f, 0xff, 0xe2, 0x0, 0x0, 0x5f, 0xff, 0xe3,
    0x0, 0x0, 0x5f, 0xff, 0xe3, 0x0, 0x0, 0x5f,
    0xff, 0xe3, 0x0, 0x0, 0x5f, 0xff, 0xe3, 0x0,
    0x0, 0xd, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xe3, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xe3,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xe3, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0xe3, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x5f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F054 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xdb, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xfc, 0x0, 0x0, 0x0,
    0x9, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x9, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x9, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0x9, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x9, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0xd, 0xff, 0xf6, 0x0,
    0x0, 0x9, 0xff, 0xfc, 0x0, 0x0, 0x9, 0xff,
    0xfc, 0x0, 0x0, 0x9, 0xff, 0xfc, 0x0, 0x0,
    0x9, 0xff, 0xfc, 0x0, 0x0, 0x9, 0xff, 0xfc,
    0x0, 0x0, 0x9, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0xcf, 0xfc, 0x0, 0x0, 0x0, 0x2, 0xdb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x2, 0x55, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x37,
    0x77, 0x77, 0x8f, 0xff, 0xc7, 0x77, 0x77, 0x60,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x14, 0x44, 0x44, 0x5f, 0xff,
    0xb4, 0x44, 0x44, 0x30, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0,
    0x0, 0x0, 0x0,

    /* U+F068 "" */
    0x49, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x2, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x10,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x6, 0xad, 0xff, 0xec, 0x83,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xef, 0xff, 0xfc, 0x40, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xff, 0x92, 0x0, 0x5, 0xdf, 0xff,
    0x90, 0x0, 0x0, 0x4, 0xff, 0xff, 0x50, 0x2,
    0x52, 0x1, 0xcf, 0xff, 0xb0, 0x0, 0x4, 0xff,
    0xff, 0x80, 0x0, 0x7f, 0xf9, 0x1, 0xef, 0xff,
    0xb0, 0x1, 0xef, 0xff, 0xf0, 0x0, 0x8, 0xff,
    0xf7, 0x8, 0xff, 0xff, 0x80, 0xaf, 0xff, 0xfb,
    0x2, 0x25, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xff,
    0x2f, 0xff, 0xff, 0xa0, 0x7f, 0xff, 0xff, 0xff,
    0x2, 0xff, 0xff, 0xf7, 0x9f, 0xff, 0xfb, 0x5,
    0xff, 0xff, 0xff, 0xc0, 0x3f, 0xff, 0xff, 0x21,
    0xef, 0xff, 0xf0, 0xc, 0xff, 0xff, 0xf5, 0x7,
    0xff, 0xff, 0x80, 0x3, 0xff, 0xff, 0x80, 0x1a,
    0xff, 0xe5, 0x1, 0xef, 0xff, 0xb0, 0x0, 0x4,
    0xff, 0xff, 0x50, 0x0, 0x10, 0x1, 0xcf, 0xff,
    0xb0, 0x0, 0x0, 0x3, 0xdf, 0xff, 0x92, 0x0,
    0x5, 0xdf, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xef, 0xff, 0xfc, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xad, 0xef, 0xec,
    0x83, 0x0, 0x0, 0x0, 0x0,

    /* U+F070 "" */
    0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xfc, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xe4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0x70, 0x4, 0x8c, 0xef, 0xed, 0x94,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xfb,
    0xef, 0xff, 0xfe, 0xff, 0xff, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2d, 0xff, 0xff, 0xc4, 0x0,
    0x4, 0xcf, 0xff, 0xb1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0x60, 0x3, 0x10, 0x9, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xf9, 0x4f, 0xfa, 0x0, 0xcf, 0xff, 0xe1, 0x0,
    0x0, 0xb, 0xb0, 0x0, 0x4e, 0xff, 0xef, 0xff,
    0xa0, 0x4f, 0xff, 0xfb, 0x0, 0x0, 0x6f, 0xfd,
    0x30, 0x1, 0xcf, 0xff, 0xff, 0xf1, 0xf, 0xff,
    0xff, 0x50, 0x0, 0xbf, 0xff, 0xf6, 0x0, 0x8,
    0xff, 0xff, 0xf3, 0xe, 0xff, 0xff, 0xa0, 0x0,
    0x6f, 0xff, 0xff, 0x0, 0x0, 0x5f, 0xff, 0xf2,
    0xf, 0xff, 0xff, 0x50, 0x0, 0xc, 0xff, 0xff,
    0x40, 0x0, 0x2, 0xdf, 0xfe, 0x8f, 0xff, 0xfa,
    0x0, 0x0, 0x1, 0xef, 0xff, 0xc0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xfd, 0x10, 0x0, 0x0, 0x0, 0x1, 0xcf, 0xff,
    0xc4, 0x0, 0x0, 0x3, 0xef, 0xfd, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xef, 0xff, 0xfe, 0xe3,
    0x0, 0x1b, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0x9d, 0xef, 0xec, 0x20, 0x0, 0x8f,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xef, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2c, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x60,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xa3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xa2, 0x24, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0x90, 0x1, 0xff,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xff, 0xa0, 0x2, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xb0, 0x3, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xc0, 0x4, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xd0, 0x5, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x6, 0xff, 0xff,
    0xff, 0xf9, 0x9c, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xf5, 0x2b, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0x90, 0x1, 0xff, 0xff, 0xff, 0xfe, 0x10,
    0x1, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0xff,
    0xff, 0xff, 0xff, 0x90, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x1a, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x1, 0x68, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x40,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0x50, 0xef, 0xff,
    0xf6, 0x0, 0x0, 0x1, 0xcf, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0x50, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xf7, 0x22, 0x23, 0xdf, 0xf8,
    0x9, 0xff, 0xf7, 0x2f, 0xff, 0x80, 0x0, 0x0,
    0x2e, 0xb0, 0x7f, 0xff, 0x90, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0x3, 0x6, 0xff, 0xfa, 0x0, 0x7,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xfd, 0x3, 0x0, 0x7, 0x60, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0xe1, 0x3f, 0x90, 0xf, 0xf8, 0x0,
    0x22, 0x23, 0xdf, 0xfe, 0x22, 0xef, 0xf7, 0x2f,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xf3, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0x50,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xff,
    0xf6, 0x0, 0x0, 0x1, 0xcf, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0x30, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x94, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xae, 0xff, 0xf5, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xf9, 0x2, 0xef, 0xff, 0x50, 0x0, 0x0, 0xcf,
    0xff, 0x90, 0x0, 0x2e, 0xff, 0xf5, 0x0, 0xc,
    0xff, 0xf9, 0x0, 0x0, 0x2, 0xef, 0xff, 0x50,
    0xaf, 0xff, 0x90, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xf2, 0x7f, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xe1, 0x6, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x29, 0x20,

    /* U+F078 "" */
    0x6, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29,
    0x20, 0x7f, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xef, 0xe1, 0x9f, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0xf2, 0xb, 0xff, 0xf9, 0x0, 0x0,
    0x3, 0xef, 0xff, 0x50, 0x0, 0xbf, 0xff, 0x90,
    0x0, 0x3e, 0xff, 0xf5, 0x0, 0x0, 0xb, 0xff,
    0xf9, 0x3, 0xef, 0xff, 0x50, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xae, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x94, 0x0,
    0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x9c, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xd1, 0x0, 0x58, 0x88, 0x88, 0x88, 0x88, 0x81,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xfd, 0x20, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xe2, 0x4e, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0x8f, 0xfc, 0xff, 0xcf,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf6, 0x0,
    0x0, 0x7f, 0xc2, 0xff, 0x67, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf6, 0x0, 0x0, 0x3, 0x1,
    0xff, 0x60, 0x30, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf6, 0x0, 0x0, 0x0, 0x1, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf6, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xf6, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x3, 0xd7, 0x1f, 0xf6,
    0x3d, 0x70, 0x0, 0x1, 0xff, 0x60, 0x0, 0x0,
    0x0, 0xa, 0xff, 0x7f, 0xf9, 0xef, 0xf0, 0x0,
    0x1, 0xff, 0xb8, 0x88, 0x88, 0x88, 0x32, 0xef,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x2e, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xe2, 0x2, 0xef, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x30, 0x0, 0x0,

    /* U+F07B "" */
    0x5e, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb8, 0x88, 0x88, 0x88, 0x60, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x5e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe5,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0xd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x11, 0x1b, 0xff, 0xff, 0x51, 0x11,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x7a, 0xaa, 0xaa, 0x2b,
    0xff, 0xff, 0x42, 0xaa, 0xaa, 0xa7, 0xff, 0xff,
    0xff, 0x82, 0x67, 0x76, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x77, 0x77, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0xf, 0x48, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xef, 0xff,
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x41,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xfe, 0xb5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x1, 0x30, 0x0, 0x0, 0x1d, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0x29, 0xff, 0x70, 0x0, 0x3e, 0xff,
    0xff, 0x30, 0x0, 0x4, 0xbf, 0xff, 0xff, 0x40,
    0x7f, 0xff, 0xff, 0x50, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xfe, 0xef, 0xff, 0xff, 0x50, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x10, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xea, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x57, 0x64, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C4 "" */
    0x0, 0x25, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xfe, 0x30, 0x0, 0x0, 0x4,
    0xaa, 0x50, 0x7f, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0x8f, 0xff, 0xf5, 0xef, 0xd3, 0x7f, 0xf6, 0x0,
    0x8, 0xff, 0xff, 0xb0, 0xff, 0x80, 0xf, 0xf7,
    0x0, 0x8f, 0xff, 0xfb, 0x0, 0xdf, 0xe7, 0xaf,
    0xf5, 0x8, 0xff, 0xff, 0xb0, 0x0, 0x5f, 0xff,
    0xff, 0xfd, 0x9f, 0xff, 0xfb, 0x0, 0x0, 0x5,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x1, 0x5f, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x25, 0x9f, 0xff, 0xff, 0xfd,
    0x10, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xfb,
    0x6f, 0xff, 0xfd, 0x10, 0x0, 0xef, 0xd3, 0x7f,
    0xf5, 0x5, 0xff, 0xff, 0xd1, 0x0, 0xff, 0x80,
    0xf, 0xf7, 0x0, 0x5f, 0xff, 0xfd, 0x10, 0xdf,
    0xe7, 0xaf, 0xf5, 0x0, 0x5, 0xff, 0xff, 0xd1,
    0x5f, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x4f, 0xff,
    0xf4, 0x5, 0xef, 0xfb, 0x10, 0x0, 0x0, 0x1,
    0x66, 0x20, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x8, 0xbb, 0xbb, 0xbb, 0x50, 0x90,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0x81,
    0xfb, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x81, 0xff, 0xb0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0x81, 0xff, 0xf8, 0x8c, 0xc9, 0xf, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0xff, 0xfc, 0xf,
    0xff, 0xff, 0xff, 0xd5, 0x44, 0x43, 0xff, 0xfc,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xff,
    0xfc, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xfc, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0xff, 0xfc, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0xff, 0xfc, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfa, 0xff, 0xfc, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xfc, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xfc, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xfc,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xff,
    0xfc, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xfe, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x58, 0x88, 0x88, 0x88,
    0x88, 0x87, 0x10, 0x0, 0x0,

    /* U+F0C7 "" */
    0x6, 0x77, 0x77, 0x77, 0x77, 0x77, 0x60, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x10, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc1, 0x0, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x1, 0xdf, 0xfc, 0x10, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xc0, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xf3, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xf4, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xf4,
    0xff, 0xd8, 0x88, 0x88, 0x88, 0x88, 0xef, 0xff,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xe4, 0x2,
    0xcf, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x2f, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff,
    0x40, 0x0, 0xf, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x6f, 0xff, 0xff, 0xf4, 0xff,
    0xff, 0xff, 0xfc, 0x8a, 0xff, 0xff, 0xff, 0xf4,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf3, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F0E7 "" */
    0x0, 0x14, 0x44, 0x44, 0x41, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x2, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x20, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xe1, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x40,
    0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x0, 0x6, 0x71, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x14, 0x44, 0xbf, 0xfe, 0x44, 0x43, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xf9, 0x4f, 0xff, 0xff,
    0x40, 0x0, 0x0, 0xff, 0xff, 0xf8, 0x3f, 0xff,
    0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x50, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xa8, 0x88, 0x88, 0x20, 0x0, 0x0, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xf0, 0xcf, 0xff, 0xff, 0x51, 0xe2, 0x0,
    0xff, 0xff, 0xf0, 0xef, 0xff, 0xff, 0x51, 0xfe,
    0x20, 0xff, 0xff, 0xf0, 0xef, 0xff, 0xff, 0x51,
    0xff, 0xe2, 0xff, 0xff, 0xf0, 0xef, 0xff, 0xff,
    0x50, 0xbb, 0xb7, 0xff, 0xff, 0xf0, 0xef, 0xff,
    0xff, 0x80, 0x0, 0x0, 0xff, 0xff, 0xf0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xf0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xff,
    0xf0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xff,
    0xff, 0xf0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xcf, 0xff, 0xf0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x7b,
    0xbb, 0xbb, 0xbb, 0xbb, 0xb4,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x0, 0x31, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xef, 0xff,
    0xfb, 0x20, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x10, 0x0, 0x0, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x75, 0x0, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xff,
    0xc8, 0x8f, 0xa8, 0xaf, 0x88, 0xbf, 0x88, 0xfb,
    0x88, 0xff, 0x8f, 0xf8, 0x0, 0xf4, 0x4, 0xf0,
    0x5, 0xe0, 0xe, 0x50, 0xf, 0xf8, 0xff, 0x80,
    0xf, 0x40, 0x4f, 0x0, 0x6f, 0x0, 0xf6, 0x0,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x94,
    0x6f, 0x64, 0x8f, 0x44, 0xbb, 0x44, 0xff, 0xff,
    0x8f, 0xff, 0xf6, 0x2, 0xf2, 0x5, 0xf0, 0x8,
    0x80, 0xe, 0xff, 0xf8, 0xff, 0xff, 0x94, 0x6f,
    0x64, 0x8f, 0x44, 0xbb, 0x44, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0x80, 0xf, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xf6, 0x0, 0xff, 0x8f, 0xf8,
    0x0, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xe, 0x50,
    0xf, 0xf8, 0xff, 0xc8, 0x8f, 0xa8, 0x88, 0x88,
    0x88, 0x88, 0xfb, 0x88, 0xff, 0x8e, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x0,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x56, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x7e, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x8f, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xaf,
    0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x5, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0x0, 0x0, 0x6, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x18, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x2, 0xac, 0xcc, 0xcc, 0xcd, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x27, 0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x24, 0x44, 0x44, 0x44, 0x30, 0x30, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xfc, 0xf, 0x60, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0xff, 0x60, 0xf, 0xff,
    0xff, 0xff, 0xfc, 0xf, 0xff, 0x60, 0xff, 0xff,
    0xff, 0xff, 0xc0, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xfc, 0xb, 0xbb, 0xbb, 0xff, 0xff, 0xff,
    0xff, 0xe1, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8b, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x80,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x23, 0x43, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x8c, 0xff, 0xff, 0xff, 0xfc, 0x83, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6d, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x60, 0x0, 0x0, 0x3, 0xdf,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xd3, 0x0, 0x8, 0xff, 0xff, 0xfb, 0x72, 0x0,
    0x0, 0x2, 0x7b, 0xff, 0xff, 0xf8, 0xa, 0xff,
    0xff, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xaf, 0xff, 0xfa, 0xbf, 0xfd, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0xff, 0xb0,
    0xba, 0x10, 0x0, 0x5, 0x9d, 0xef, 0xed, 0x95,
    0x0, 0x0, 0x1a, 0xb0, 0x0, 0x0, 0x0, 0x6d,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xfa, 0x53, 0x23, 0x5a, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xb1, 0x0, 0x0,
    0x0, 0x1, 0xbf, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x9d, 0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xef, 0xe3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x17, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x60, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xfd, 0xff, 0x84, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xc, 0xff, 0xff, 0xf8,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x5b, 0xff, 0xff, 0x84, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x8f, 0xff,
    0xf8, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8, 0xff, 0xff, 0x84, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xc8, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x8e,
    0xfd, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc2, 0x0,

    /* U+F241 "" */
    0x17, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x60, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xfd, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0xc, 0xff, 0xff, 0xf8,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x5b, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x8f, 0xff,
    0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x8, 0xff, 0xff, 0x81, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0xc, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xc8, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x8e,
    0xfd, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc2, 0x0,

    /* U+F242 "" */
    0x17, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x60, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xfd, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xf8,
    0x1f, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x5b, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xf8, 0x1f, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0x81, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xc8, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x8e,
    0xfd, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc2, 0x0,

    /* U+F243 "" */
    0x17, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x60, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xfd, 0xff, 0x81, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xf8,
    0x1f, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5b, 0xff, 0xff, 0x81, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xf8, 0x1f, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0x81, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xc8, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x8e,
    0xfd, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc2, 0x0,

    /* U+F244 "" */
    0x17, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x60, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xfd, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5b, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xc8, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x8e,
    0xfd, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x4e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc2, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7c,
    0xdf, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfb, 0xbf, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x70, 0xa, 0xfc, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x32, 0x0, 0x0, 0x9e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xff,
    0x90, 0x1, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1c, 0x30, 0x0, 0xcf, 0xff, 0xf6, 0x3c, 0xf3,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x5f, 0xf9, 0x10,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0xcf, 0xff, 0xf6,
    0x33, 0x34, 0xed, 0x33, 0x33, 0x33, 0x33, 0x5f,
    0xfa, 0x10, 0x2d, 0xff, 0x90, 0x0, 0x0, 0x5f,
    0x30, 0x0, 0x0, 0x0, 0x1c, 0x30, 0x0, 0x0,
    0x32, 0x0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf3, 0xa, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xce,
    0xae, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xbe, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x22, 0x20, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x0, 0x34, 0x31, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xbf, 0xff, 0xff, 0xe7, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xfa, 0xff, 0xff, 0xb0, 0x0,
    0x4, 0xff, 0xff, 0xf1, 0x9f, 0xff, 0xf8, 0x0,
    0xd, 0xff, 0xff, 0xf1, 0xa, 0xff, 0xff, 0x10,
    0x3f, 0xff, 0xff, 0xf1, 0x0, 0xbf, 0xff, 0x60,
    0x7f, 0xfd, 0x8f, 0xf1, 0x66, 0xc, 0xff, 0xa0,
    0xaf, 0xf8, 0x7, 0xf1, 0x6f, 0x13, 0xff, 0xd0,
    0xcf, 0xff, 0x70, 0x71, 0x53, 0x1e, 0xff, 0xf0,
    0xdf, 0xff, 0xf7, 0x0, 0x1, 0xdf, 0xff, 0xf0,
    0xef, 0xff, 0xff, 0x60, 0xc, 0xff, 0xff, 0xf0,
    0xef, 0xff, 0xff, 0x30, 0x7, 0xff, 0xff, 0xf0,
    0xdf, 0xff, 0xf3, 0x0, 0x10, 0x8f, 0xff, 0xf0,
    0xcf, 0xff, 0x30, 0xb1, 0x67, 0x9, 0xff, 0xf0,
    0x9f, 0xf6, 0xb, 0xf2, 0x6e, 0x2, 0xff, 0xd0,
    0x6f, 0xff, 0xcf, 0xf2, 0x52, 0x2e, 0xff, 0xa0,
    0x1f, 0xff, 0xff, 0xf2, 0x2, 0xef, 0xff, 0x50,
    0x9, 0xff, 0xff, 0xf2, 0x2e, 0xff, 0xfe, 0x0,
    0x0, 0xdf, 0xff, 0xf4, 0xef, 0xff, 0xf5, 0x0,
    0x0, 0x1a, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x27, 0xab, 0xb9, 0x50, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x2, 0xab, 0xbb, 0xb7, 0x0, 0x0,
    0x0, 0x57, 0x77, 0x7c, 0xff, 0xff, 0xff, 0x77,
    0x77, 0x72, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x20, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0xc, 0xff, 0x77, 0xff, 0x3b, 0xfe, 0x1e, 0xff,
    0x40, 0xc, 0xff, 0x66, 0xff, 0x2a, 0xfe, 0xe,
    0xff, 0x40, 0xc, 0xff, 0x66, 0xff, 0x2a, 0xfe,
    0xe, 0xff, 0x40, 0xc, 0xff, 0x66, 0xff, 0x2a,
    0xfe, 0xe, 0xff, 0x40, 0xc, 0xff, 0x66, 0xff,
    0x2a, 0xfe, 0xe, 0xff, 0x40, 0xc, 0xff, 0x66,
    0xff, 0x2a, 0xfe, 0xe, 0xff, 0x40, 0xc, 0xff,
    0x66, 0xff, 0x2a, 0xfe, 0xe, 0xff, 0x40, 0xc,
    0xff, 0x66, 0xff, 0x2a, 0xfe, 0xe, 0xff, 0x40,
    0xc, 0xff, 0x66, 0xff, 0x2a, 0xfe, 0xe, 0xff,
    0x40, 0xc, 0xff, 0x77, 0xff, 0x3b, 0xfe, 0x1e,
    0xff, 0x40, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x30, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x57, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x72, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x64, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xdf, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x90, 0x8f, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xb0, 0x8f, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xb0, 0x8f,
    0xfe, 0x10, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xb0, 0x8e, 0x20, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xff, 0xff, 0xff, 0xb0, 0x10, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x10,
    0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0x0, 0x1, 0xef, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0x75, 0x31, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x0, 0x6e, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x20, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0x85, 0xff, 0xff, 0x58, 0xff,
    0xff, 0xff, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xb0,
    0x4, 0xff, 0x40, 0xb, 0xff, 0xff, 0xf0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x4, 0x40, 0x4,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0xef, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x40, 0x4,
    0x40, 0x4, 0xff, 0xff, 0xff, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xb0, 0x4, 0xff, 0x40, 0xb, 0xff,
    0xff, 0xf0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x85,
    0xff, 0xff, 0x58, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x20,

    /* U+F7C2 "" */
    0x0, 0x0, 0x28, 0x88, 0x88, 0x88, 0x73, 0x0,
    0x0, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x1d,
    0xf6, 0xe, 0x50, 0xd6, 0x8, 0xff, 0x1d, 0xff,
    0x60, 0xe5, 0xd, 0x60, 0x8f, 0xfc, 0xff, 0xf6,
    0xe, 0x50, 0xd6, 0x8, 0xff, 0xff, 0xff, 0x60,
    0xe5, 0xd, 0x60, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe9, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7, 0xab,
    0xbb, 0xbb, 0xbb, 0xbb, 0xa6, 0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0x10,
    0x0, 0xa, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xf1, 0x0, 0xb, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0x10, 0xc, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf1, 0x1d,
    0xff, 0xff, 0xcb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbf,
    0xff, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x9f,
    0xff, 0xf9, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x40, 0x0, 0x8f, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5c, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 160, .box_w = 4, .box_h = 13, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 26, .adv_w = 160, .box_w = 8, .box_h = 5, .ofs_x = 1, .ofs_y = 11},
    {.bitmap_index = 46, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 111, .adv_w = 160, .box_w = 8, .box_h = 17, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 179, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 249, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 314, .adv_w = 160, .box_w = 3, .box_h = 5, .ofs_x = 1, .ofs_y = 11},
    {.bitmap_index = 322, .adv_w = 160, .box_w = 6, .box_h = 18, .ofs_x = 4, .ofs_y = -2},
    {.bitmap_index = 376, .adv_w = 160, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 430, .adv_w = 160, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 480, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 535, .adv_w = 160, .box_w = 10, .box_h = 1, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 540, .adv_w = 160, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 545, .adv_w = 160, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 635, .adv_w = 160, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 694, .adv_w = 160, .box_w = 6, .box_h = 13, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 733, .adv_w = 160, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 785, .adv_w = 160, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 837, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 902, .adv_w = 160, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 954, .adv_w = 160, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1013, .adv_w = 160, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1065, .adv_w = 160, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1124, .adv_w = 160, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1183, .adv_w = 160, .box_w = 3, .box_h = 9, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 1197, .adv_w = 160, .box_w = 3, .box_h = 11, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 1214, .adv_w = 160, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1270, .adv_w = 160, .box_w = 10, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 1295, .adv_w = 160, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1351, .adv_w = 160, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1403, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1468, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1538, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1603, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1668, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1733, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1798, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1863, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1928, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1993, .adv_w = 160, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2045, .adv_w = 160, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2125, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2190, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2255, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2320, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2385, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2450, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2515, .adv_w = 160, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2590, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2655, .adv_w = 160, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2714, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2779, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2844, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2909, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2974, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3039, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3104, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3169, .adv_w = 160, .box_w = 6, .box_h = 17, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 3220, .adv_w = 160, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3292, .adv_w = 160, .box_w = 6, .box_h = 17, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3343, .adv_w = 160, .box_w = 6, .box_h = 3, .ofs_x = 2, .ofs_y = 13},
    {.bitmap_index = 3352, .adv_w = 160, .box_w = 10, .box_h = 1, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3357, .adv_w = 160, .box_w = 5, .box_h = 2, .ofs_x = 1, .ofs_y = 14},
    {.bitmap_index = 3362, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3407, .adv_w = 160, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3470, .adv_w = 160, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3506, .adv_w = 160, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3569, .adv_w = 160, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3605, .adv_w = 160, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3664, .adv_w = 160, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3718, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3788, .adv_w = 160, .box_w = 6, .box_h = 13, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3827, .adv_w = 160, .box_w = 8, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3891, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3961, .adv_w = 160, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4017, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4062, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4107, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4152, .adv_w = 160, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4212, .adv_w = 160, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4266, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4311, .adv_w = 160, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4347, .adv_w = 160, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4395, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4440, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4485, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4530, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4575, .adv_w = 160, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4635, .adv_w = 160, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4671, .adv_w = 160, .box_w = 5, .box_h = 18, .ofs_x = 4, .ofs_y = -2},
    {.bitmap_index = 4716, .adv_w = 160, .box_w = 2, .box_h = 20, .ofs_x = 4, .ofs_y = -3},
    {.bitmap_index = 4736, .adv_w = 160, .box_w = 5, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 4781, .adv_w = 160, .box_w = 10, .box_h = 4, .ofs_x = 0, .ofs_y = 13},
    {.bitmap_index = 4801, .adv_w = 320, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5011, .adv_w = 320, .box_w = 20, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5161, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5351, .adv_w = 320, .box_w = 20, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5501, .adv_w = 220, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5606, .adv_w = 320, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5816, .adv_w = 320, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6026, .adv_w = 360, .box_w = 23, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6245, .adv_w = 320, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6455, .adv_w = 360, .box_w = 23, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6628, .adv_w = 320, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6838, .adv_w = 160, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6918, .adv_w = 240, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7038, .adv_w = 360, .box_w = 23, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7257, .adv_w = 320, .box_w = 20, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7407, .adv_w = 280, .box_w = 13, .box_h = 19, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 7531, .adv_w = 280, .box_w = 18, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7720, .adv_w = 280, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7891, .adv_w = 280, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8062, .adv_w = 280, .box_w = 13, .box_h = 19, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 8186, .adv_w = 280, .box_w = 19, .box_h = 19, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 8367, .adv_w = 200, .box_w = 11, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 8472, .adv_w = 200, .box_w = 11, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 8577, .adv_w = 280, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8748, .adv_w = 280, .box_w = 18, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 8793, .adv_w = 360, .box_w = 23, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8966, .adv_w = 400, .box_w = 26, .box_h = 21, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 9239, .adv_w = 360, .box_w = 24, .box_h = 21, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 9491, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9681, .adv_w = 280, .box_w = 18, .box_h = 11, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 9780, .adv_w = 280, .box_w = 18, .box_h = 11, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 9879, .adv_w = 400, .box_w = 26, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10087, .adv_w = 320, .box_w = 20, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10237, .adv_w = 320, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10447, .adv_w = 320, .box_w = 21, .box_h = 21, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 10668, .adv_w = 280, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10839, .adv_w = 280, .box_w = 18, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11028, .adv_w = 280, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11199, .adv_w = 200, .box_w = 14, .box_h = 21, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 11346, .adv_w = 280, .box_w = 18, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11535, .adv_w = 280, .box_w = 18, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11724, .adv_w = 360, .box_w = 23, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11897, .adv_w = 320, .box_w = 22, .box_h = 21, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 12128, .adv_w = 240, .box_w = 15, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12286, .adv_w = 400, .box_w = 25, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12524, .adv_w = 400, .box_w = 25, .box_h = 13, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 12687, .adv_w = 400, .box_w = 25, .box_h = 13, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 12850, .adv_w = 400, .box_w = 25, .box_h = 13, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 13013, .adv_w = 400, .box_w = 25, .box_h = 13, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 13176, .adv_w = 400, .box_w = 25, .box_h = 13, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 13339, .adv_w = 400, .box_w = 26, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13560, .adv_w = 280, .box_w = 16, .box_h = 21, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 13728, .adv_w = 280, .box_w = 18, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13917, .adv_w = 320, .box_w = 21, .box_h = 21, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 14138, .adv_w = 400, .box_w = 25, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14326, .adv_w = 240, .box_w = 15, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14484, .adv_w = 322, .box_w = 21, .box_h = 13, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 33, .range_length = 11, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 45, .range_length = 82, .glyph_id_start = 12,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 94,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_simsun_20 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 21,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0)
    .underline_position = -3,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};



#endif /*#if LV_FONT_SIMSUN_20*/

