#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 24 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef LV_FONT_SIMSUN_24
#define LV_FONT_SIMSUN_24 1
#endif

#if LV_FONT_SIMSUN_24

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xd, 0xa0, 0x1f, 0xe0, 0x1f, 0xe0, 0xf, 0xc0,
    0xe, 0xa0, 0xc, 0x90, 0xa, 0x70, 0x8, 0x50,
    0x8, 0x50, 0x7, 0x40, 0x6, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x60, 0x5f, 0xf2, 0x2e, 0xc0,

    /* U+22 "\"" */
    0x0, 0x8, 0xe1, 0xb, 0xc0, 0x0, 0x3f, 0xf2,
    0x7f, 0xd0, 0x0, 0xbf, 0x40, 0xee, 0x20, 0x4,
    0xf4, 0x8, 0xe2, 0x0, 0xc, 0x40, 0x1d, 0x20,
    0x0, 0x24, 0x0, 0x52, 0x0, 0x0,

    /* U+23 "#" */
    0x0, 0x7, 0x50, 0x0, 0x58, 0x0, 0x0, 0x9,
    0x40, 0x0, 0x66, 0x0, 0x0, 0xa, 0x30, 0x0,
    0x85, 0x0, 0x1c, 0xce, 0xcc, 0xcc, 0xed, 0xc0,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0xd,
    0x0, 0x0, 0xb2, 0x0, 0x0, 0xd, 0x0, 0x0,
    0xc0, 0x0, 0x0, 0xc, 0x0, 0x0, 0xd0, 0x0,
    0x0, 0x2b, 0x0, 0x0, 0xd0, 0x0, 0x0, 0x3a,
    0x0, 0x0, 0xc0, 0x0, 0x1c, 0xde, 0xcc, 0xcc,
    0xfc, 0xc0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x66, 0x0, 0x4, 0x90, 0x0, 0x0, 0x75,
    0x0, 0x5, 0x80, 0x0, 0x0, 0x84, 0x0, 0x6,
    0x70, 0x0, 0x0, 0x93, 0x0, 0x7, 0x60, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x67, 0x0, 0x0, 0x0, 0x0, 0x67,
    0x0, 0x0, 0x0, 0x19, 0xcd, 0xb5, 0x0, 0x2,
    0xd3, 0x67, 0x1e, 0x50, 0xa, 0x90, 0x67, 0xd,
    0xc0, 0xe, 0x80, 0x67, 0x4f, 0xb0, 0xc, 0xd0,
    0x67, 0x4, 0x10, 0x6, 0xfb, 0x77, 0x0, 0x0,
    0x0, 0x9f, 0xf8, 0x0, 0x0, 0x0, 0x7, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x7f, 0xf7, 0x0, 0x0,
    0x0, 0x68, 0xcf, 0x40, 0x0, 0x0, 0x67, 0x1e,
    0xc0, 0x9, 0x60, 0x67, 0x8, 0xf0, 0x5f, 0xc0,
    0x67, 0x6, 0xf0, 0x4f, 0x60, 0x67, 0x7, 0xb0,
    0xb, 0x80, 0x67, 0x2d, 0x30, 0x0, 0x7a, 0xcd,
    0x92, 0x0, 0x0, 0x0, 0x67, 0x0, 0x0, 0x0,
    0x0, 0x67, 0x0, 0x0, 0x0, 0x0, 0x33, 0x0,
    0x0,

    /* U+25 "%" */
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x7, 0xbb,
    0x30, 0x0, 0x83, 0x0, 0x2d, 0x2, 0xd0, 0x0,
    0xb0, 0x0, 0x89, 0x0, 0xf2, 0x5, 0x60, 0x0,
    0xa8, 0x0, 0xe4, 0xb, 0x0, 0x0, 0xa8, 0x0,
    0xe4, 0x28, 0x0, 0x0, 0x89, 0x0, 0xf2, 0x92,
    0x0, 0x0, 0x2d, 0x4, 0xc0, 0xa0, 0x0, 0x0,
    0x4, 0xaa, 0x26, 0x42, 0xaa, 0x10, 0x0, 0x0,
    0xb, 0xd, 0x23, 0xb0, 0x0, 0x0, 0x47, 0x5c,
    0x0, 0xf2, 0x0, 0x0, 0xa1, 0x8a, 0x0, 0xd5,
    0x0, 0x1, 0x90, 0x99, 0x0, 0xc6, 0x0, 0x8,
    0x30, 0x89, 0x0, 0xc5, 0x0, 0xa, 0x0, 0x6b,
    0x0, 0xe3, 0x0, 0x55, 0x0, 0xd, 0x2, 0xe0,
    0x0, 0x90, 0x0, 0x4, 0xbc, 0x40,

    /* U+26 "&" */
    0x0, 0x8, 0x9a, 0x50, 0x0, 0x0, 0x0, 0x69,
    0x2, 0xf1, 0x0, 0x0, 0x0, 0xc5, 0x0, 0xf4,
    0x0, 0x0, 0x0, 0xe5, 0x1, 0xf3, 0x0, 0x0,
    0x0, 0xd6, 0x4, 0xf0, 0x0, 0x0, 0x0, 0xba,
    0xa, 0x80, 0x0, 0x0, 0x0, 0x8e, 0x98, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x60, 0x19, 0xcb, 0x50,
    0x5, 0x8d, 0xb0, 0x0, 0xe3, 0x0, 0x1e, 0x6,
    0xf2, 0x0, 0xd0, 0x0, 0x7c, 0x0, 0xe9, 0x0,
    0xb0, 0x0, 0xab, 0x0, 0x6f, 0x33, 0x70, 0x0,
    0xac, 0x0, 0xc, 0xd9, 0x20, 0x0, 0x7f, 0x10,
    0x1, 0xee, 0x0, 0x3, 0xd, 0xd3, 0x14, 0xbe,
    0xc3, 0x65, 0x1, 0xaf, 0xe8, 0x2, 0xcf, 0x90,

    /* U+27 "'" */
    0x1d, 0xd1, 0x2f, 0xf8, 0x4, 0xf7, 0x0, 0xe3,
    0x7, 0xa0, 0x58, 0x0,

    /* U+28 "(" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x59, 0x0, 0x4,
    0xc0, 0x0, 0x1d, 0x10, 0x0, 0xb6, 0x0, 0x5,
    0xe0, 0x0, 0xc, 0x70, 0x0, 0x2f, 0x20, 0x0,
    0x7e, 0x0, 0x0, 0xab, 0x0, 0x0, 0xc9, 0x0,
    0x0, 0xd9, 0x0, 0x0, 0xc9, 0x0, 0x0, 0xab,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x2f, 0x20, 0x0,
    0xc, 0x80, 0x0, 0x4, 0xe0, 0x0, 0x0, 0xb8,
    0x0, 0x0, 0x1d, 0x20, 0x0, 0x3, 0xc1, 0x0,
    0x0, 0x39, 0x0, 0x0, 0x0,

    /* U+29 ")" */
    0x0, 0x0, 0x0, 0xa3, 0x0, 0x0, 0xc, 0x20,
    0x0, 0x2, 0xd1, 0x0, 0x0, 0x8a, 0x0, 0x0,
    0x1f, 0x30, 0x0, 0x9, 0xb0, 0x0, 0x3, 0xf1,
    0x0, 0x0, 0xf6, 0x0, 0x0, 0xc9, 0x0, 0x0,
    0xbb, 0x0, 0x0, 0xab, 0x0, 0x0, 0xbb, 0x0,
    0x0, 0xd9, 0x0, 0x0, 0xf5, 0x0, 0x4, 0xf1,
    0x0, 0x9, 0xa0, 0x0, 0x1f, 0x30, 0x0, 0x99,
    0x0, 0x4, 0xd0, 0x0, 0x1d, 0x20, 0x0, 0xa2,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+2A "*" */
    0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xe0, 0x0, 0x0, 0x6, 0x30, 0xb, 0xb0,
    0x4, 0x50, 0x1f, 0xf6, 0x8, 0x80, 0x7f, 0xf0,
    0x5, 0xcf, 0x76, 0x58, 0xfc, 0x40, 0x0, 0x3,
    0x9a, 0xa8, 0x20, 0x0, 0x0, 0x2, 0x9b, 0xa8,
    0x20, 0x0, 0x5, 0xcf, 0x76, 0x48, 0xfb, 0x40,
    0x1f, 0xf6, 0x9, 0x70, 0x7f, 0xf0, 0x6, 0x20,
    0xc, 0xa0, 0x3, 0x60, 0x0, 0x0, 0xf, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x0,

    /* U+2B "+" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x49, 0x0, 0x0,
    0x0, 0x0, 0x4, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x49, 0x0, 0x0, 0x0, 0x0, 0x4, 0x90, 0x0,
    0x0, 0xdd, 0xdd, 0xee, 0xdd, 0xdd, 0x30, 0x0,
    0x4, 0x90, 0x0, 0x0, 0x0, 0x0, 0x49, 0x0,
    0x0, 0x0, 0x0, 0x4, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x49, 0x0, 0x0, 0x0, 0x0, 0x4, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x13, 0x0, 0x0, 0x0,

    /* U+2D "-" */
    0x3d, 0xdd, 0xdd, 0xdd, 0xdd, 0xd2,

    /* U+2E "." */
    0xa, 0xa0, 0x5f, 0xf5, 0x1d, 0xd1,

    /* U+2F "/" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0x40, 0x0, 0x0, 0x0, 0x0, 0x1b, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x84, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x50, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x76, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x57, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x80, 0x0,
    0x0, 0x0, 0x0, 0xc, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x48, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb1,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xb, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x1a, 0xcc, 0xa1, 0x0, 0x1, 0xe9, 0x0,
    0x7d, 0x10, 0xa, 0xe0, 0x0, 0xd, 0x90, 0x2f,
    0x80, 0x0, 0x8, 0xf1, 0x7f, 0x30, 0x0, 0x4,
    0xf6, 0xaf, 0x10, 0x0, 0x2, 0xf9, 0xcf, 0x0,
    0x0, 0x0, 0xfb, 0xde, 0x0, 0x0, 0x0, 0xfc,
    0xde, 0x0, 0x0, 0x0, 0xfc, 0xcf, 0x0, 0x0,
    0x0, 0xfb, 0xaf, 0x10, 0x0, 0x2, 0xf9, 0x7f,
    0x30, 0x0, 0x4, 0xf5, 0x2f, 0x70, 0x0, 0x8,
    0xf1, 0xa, 0xd0, 0x0, 0xd, 0x90, 0x1, 0xe9,
    0x0, 0x8d, 0x10, 0x0, 0x1a, 0xcc, 0xa1, 0x0,

    /* U+31 "1" */
    0x0, 0x2, 0xb0, 0x0, 0x29, 0xbf, 0xd0, 0x0,
    0x0, 0xb, 0xd0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0xc, 0xf0, 0x0, 0x29, 0xbf, 0xfd, 0x95,

    /* U+32 "2" */
    0x0, 0x5a, 0xab, 0xc6, 0x0, 0x9, 0x90, 0x0,
    0x3f, 0x80, 0x3f, 0x10, 0x0, 0x8, 0xf1, 0x7f,
    0x30, 0x0, 0x5, 0xf4, 0x6f, 0x90, 0x0, 0x5,
    0xf3, 0x4, 0x10, 0x0, 0x8, 0xf0, 0x0, 0x0,
    0x0, 0xe, 0x80, 0x0, 0x0, 0x0, 0x9c, 0x0,
    0x0, 0x0, 0x5, 0xc1, 0x0, 0x0, 0x0, 0x4c,
    0x0, 0x0, 0x0, 0x4, 0xb0, 0x0, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x0, 0x2, 0xc1, 0x0, 0x0,
    0x26, 0xc, 0x20, 0x0, 0x0, 0x84, 0x9a, 0x66,
    0x66, 0x69, 0xf2, 0xcf, 0xff, 0xff, 0xff, 0xf0,

    /* U+33 "3" */
    0x0, 0x69, 0xac, 0xa1, 0x0, 0xb, 0x60, 0x0,
    0xae, 0x10, 0x3f, 0x30, 0x0, 0x1f, 0x90, 0x3f,
    0x70, 0x0, 0xc, 0xc0, 0x5, 0x10, 0x0, 0xd,
    0xb0, 0x0, 0x0, 0x0, 0x2f, 0x50, 0x0, 0x0,
    0x3, 0xc8, 0x0, 0x0, 0x4, 0xdf, 0x80, 0x0,
    0x0, 0x0, 0x1, 0x8d, 0x20, 0x0, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0x0, 0x0, 0x5, 0xf4, 0x4,
    0x0, 0x0, 0x3, 0xf7, 0x7f, 0x70, 0x0, 0x4,
    0xf6, 0x8f, 0x50, 0x0, 0x8, 0xf1, 0x1e, 0x60,
    0x0, 0x4f, 0x50, 0x1, 0x8a, 0xab, 0xa3, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x0, 0xa, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xa0, 0x0, 0x0, 0x0, 0x1, 0xbe,
    0xa0, 0x0, 0x0, 0x0, 0x9, 0x3e, 0xa0, 0x0,
    0x0, 0x0, 0x48, 0xe, 0xa0, 0x0, 0x0, 0x1,
    0xb0, 0xe, 0xa0, 0x0, 0x0, 0x9, 0x30, 0xe,
    0xa0, 0x0, 0x0, 0x48, 0x0, 0xe, 0xa0, 0x0,
    0x1, 0xb0, 0x0, 0xe, 0xa0, 0x0, 0x9, 0x30,
    0x0, 0xe, 0xa0, 0x0, 0x1b, 0x99, 0x99, 0x9f,
    0xd9, 0x91, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xb0, 0x0, 0x0, 0x0, 0x29, 0xbf, 0xfa, 0x70,

    /* U+35 "5" */
    0x8, 0xff, 0xff, 0xff, 0xf1, 0x8, 0x76, 0x66,
    0x66, 0x60, 0x9, 0x10, 0x0, 0x0, 0x0, 0xa,
    0x0, 0x0, 0x0, 0x0, 0xb, 0x0, 0x0, 0x0,
    0x0, 0xb, 0x19, 0xef, 0xd5, 0x0, 0xb, 0xb4,
    0x0, 0x6f, 0x60, 0xe, 0x30, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x0,
    0x2, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x4f,
    0x50, 0x0, 0x2, 0xf6, 0x8f, 0x70, 0x0, 0x4,
    0xf3, 0x6f, 0x10, 0x0, 0xa, 0xd0, 0xb, 0x60,
    0x0, 0x4f, 0x40, 0x0, 0x7b, 0xab, 0xb3, 0x0,

    /* U+36 "6" */
    0x0, 0x5, 0xaa, 0xba, 0x10, 0x0, 0x98, 0x0,
    0xf, 0xc0, 0x6, 0xb0, 0x0, 0x9, 0x70, 0xe,
    0x50, 0x0, 0x0, 0x0, 0x5f, 0x10, 0x0, 0x0,
    0x0, 0x9f, 0x5, 0xce, 0xe8, 0x0, 0xbf, 0x6a,
    0x10, 0x3e, 0xa0, 0xdf, 0xa0, 0x0, 0x6, 0xf3,
    0xdf, 0x20, 0x0, 0x0, 0xf8, 0xde, 0x0, 0x0,
    0x0, 0xeb, 0xcf, 0x0, 0x0, 0x0, 0xdc, 0x9f,
    0x20, 0x0, 0x0, 0xda, 0x5f, 0x60, 0x0, 0x0,
    0xf7, 0xe, 0xc0, 0x0, 0x3, 0xf2, 0x4, 0xf8,
    0x0, 0xc, 0x60, 0x0, 0x2a, 0xca, 0xb4, 0x0,

    /* U+37 "7" */
    0xe, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xb6, 0x66,
    0x66, 0xe2, 0x4a, 0x0, 0x0, 0x5, 0x80, 0x63,
    0x0, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x67,
    0x0, 0x0, 0x0, 0x0, 0xd1, 0x0, 0x0, 0x0,
    0x6, 0x90, 0x0, 0x0, 0x0, 0xe, 0x30, 0x0,
    0x0, 0x0, 0x5d, 0x0, 0x0, 0x0, 0x0, 0xb9,
    0x0, 0x0, 0x0, 0x1, 0xf6, 0x0, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x8, 0xf4, 0x0,
    0x0, 0x0, 0xa, 0xf5, 0x0, 0x0, 0x0, 0xc,
    0xf5, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x7b, 0xab, 0xb5, 0x0, 0xb, 0x90, 0x0,
    0x1c, 0x80, 0x5e, 0x0, 0x0, 0x3, 0xf2, 0x8c,
    0x0, 0x0, 0x0, 0xf5, 0x7f, 0x10, 0x0, 0x0,
    0xf4, 0x1f, 0xc1, 0x0, 0x5, 0xd0, 0x5, 0xff,
    0x70, 0x4c, 0x20, 0x0, 0x4f, 0xff, 0xd0, 0x0,
    0x4, 0xc1, 0x3b, 0xfc, 0x10, 0x3e, 0x20, 0x0,
    0x6f, 0xc0, 0xaa, 0x0, 0x0, 0x6, 0xf4, 0xe6,
    0x0, 0x0, 0x0, 0xe8, 0xe6, 0x0, 0x0, 0x0,
    0xd8, 0x9b, 0x0, 0x0, 0x1, 0xf3, 0x1c, 0x70,
    0x0, 0x1b, 0x80, 0x0, 0x7b, 0xab, 0xb5, 0x0,

    /* U+39 "9" */
    0x0, 0x7b, 0xaa, 0xa1, 0x0, 0xb, 0xb0, 0x0,
    0x4e, 0x20, 0x6f, 0x20, 0x0, 0xa, 0xb0, 0xcc,
    0x0, 0x0, 0x5, 0xf2, 0xea, 0x0, 0x0, 0x3,
    0xf6, 0xfa, 0x0, 0x0, 0x1, 0xf9, 0xdc, 0x0,
    0x0, 0x5, 0xfa, 0x9f, 0x20, 0x0, 0xb, 0xfa,
    0x1e, 0xc2, 0x2, 0xb6, 0xf9, 0x1, 0x9d, 0xca,
    0x24, 0xf7, 0x0, 0x0, 0x0, 0x6, 0xf5, 0x0,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x0, 0xe,
    0xa0, 0xe, 0xa0, 0x0, 0x5f, 0x20, 0xf, 0xe0,
    0x2, 0xe5, 0x0, 0x3, 0xcb, 0xaa, 0x30, 0x0,

    /* U+3A ":" */
    0x3e, 0xb0, 0x7f, 0xf1, 0x8, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0x50, 0x7f, 0xf1, 0x3e, 0xb0,

    /* U+3B ";" */
    0x3f, 0xf3, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x3f,
    0xf0, 0x7b, 0xd, 0x31, 0x60,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x0, 0x82, 0x0, 0x0, 0x0,
    0x8, 0x90, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0,
    0x0, 0x8, 0x90, 0x0, 0x0, 0x0, 0x89, 0x0,
    0x0, 0x0, 0x8, 0x80, 0x0, 0x0, 0x0, 0x98,
    0x0, 0x0, 0x0, 0x9, 0x80, 0x0, 0x0, 0x0,
    0x3d, 0x0, 0x0, 0x0, 0x0, 0x6, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x6a, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x6b, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x6b, 0x0, 0x0, 0x0, 0x0, 0x6, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x52,

    /* U+3D "=" */
    0x3d, 0xdd, 0xdd, 0xdd, 0xdd, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0xdd,
    0xdd, 0xdd, 0xdd, 0xd2,

    /* U+3E ">" */
    0x28, 0x0, 0x0, 0x0, 0x0, 0x9, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x98, 0x0, 0x0, 0x0, 0x0,
    0x9, 0x80, 0x0, 0x0, 0x0, 0x0, 0x98, 0x0,
    0x0, 0x0, 0x0, 0x9, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x88, 0x0, 0x0, 0x0, 0x0, 0x8, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xd3, 0x0, 0x0, 0x0,
    0xa, 0x60, 0x0, 0x0, 0x0, 0xb6, 0x0, 0x0,
    0x0, 0xb, 0x60, 0x0, 0x0, 0x0, 0xb6, 0x0,
    0x0, 0x0, 0xb, 0x60, 0x0, 0x0, 0x0, 0xb6,
    0x0, 0x0, 0x0, 0xb, 0x60, 0x0, 0x0, 0x0,
    0x25, 0x0, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x0, 0x5b, 0xde, 0xd7, 0x0, 0x8, 0x91, 0x0,
    0x2d, 0xb0, 0x5a, 0x0, 0x0, 0x3, 0xf6, 0xa7,
    0x0, 0x0, 0x0, 0xfb, 0xbf, 0x50, 0x0, 0x0,
    0xfb, 0x5d, 0x50, 0x0, 0x2, 0xf8, 0x0, 0x0,
    0x0, 0x1d, 0xe1, 0x0, 0x0, 0x4, 0xea, 0x10,
    0x0, 0x0, 0x3e, 0x40, 0x0, 0x0, 0x0, 0x94,
    0x0, 0x0, 0x0, 0x0, 0xa1, 0x0, 0x0, 0x0,
    0x0, 0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x85, 0x0, 0x0, 0x0, 0x7,
    0xff, 0x10, 0x0, 0x0, 0x3, 0xeb, 0x0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x6b, 0xab, 0x91, 0x0, 0x0, 0xb,
    0x70, 0x0, 0x3c, 0x10, 0x0, 0x88, 0x0, 0x88,
    0xa7, 0xa0, 0x2, 0xe0, 0xb, 0x51, 0xf2, 0xb1,
    0x8, 0xa0, 0x4c, 0x1, 0xf0, 0x84, 0xc, 0x70,
    0xb6, 0x4, 0xe0, 0x76, 0xf, 0x51, 0xf1, 0x6,
    0xc0, 0x66, 0xf, 0x44, 0xf0, 0x8, 0x90, 0x75,
    0xf, 0x46, 0xd0, 0xb, 0x70, 0x93, 0xf, 0x46,
    0xc0, 0xf, 0x50, 0xd0, 0xd, 0x62, 0xe0, 0x7d,
    0x68, 0x60, 0x9, 0x90, 0x8b, 0x54, 0xd7, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0x0, 0xa2, 0x0, 0xb6,
    0x0, 0x0, 0x4, 0x90, 0x0, 0x1d, 0x50, 0x0,
    0x6b, 0x0, 0x0, 0x1, 0x9c, 0xcc, 0x70, 0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x3, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x86, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xb0, 0xe8, 0x0, 0x0, 0x0, 0x0,
    0xb0, 0xac, 0x0, 0x0, 0x0, 0x4, 0x80, 0x6f,
    0x0, 0x0, 0x0, 0x8, 0x40, 0x2f, 0x30, 0x0,
    0x0, 0xb, 0x0, 0xe, 0x70, 0x0, 0x0, 0xb,
    0x0, 0xa, 0xb0, 0x0, 0x0, 0x4c, 0x88, 0x8b,
    0xf0, 0x0, 0x0, 0x83, 0x0, 0x3, 0xf3, 0x0,
    0x0, 0xb0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0xb0,
    0x0, 0x0, 0xda, 0x0, 0x4, 0x80, 0x0, 0x0,
    0x9e, 0x0, 0x8, 0x70, 0x0, 0x0, 0x6f, 0x20,
    0x8f, 0xe6, 0x0, 0x4, 0xdf, 0xd4,

    /* U+42 "B" */
    0x3b, 0xfe, 0x99, 0xad, 0x81, 0x0, 0x0, 0xf7,
    0x0, 0x1, 0xdc, 0x0, 0x0, 0xf7, 0x0, 0x0,
    0x5f, 0x30, 0x0, 0xf7, 0x0, 0x0, 0x3f, 0x60,
    0x0, 0xf7, 0x0, 0x0, 0x4f, 0x40, 0x0, 0xf7,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0xf7, 0x0, 0x6,
    0xe4, 0x0, 0x0, 0xfc, 0x99, 0xde, 0x40, 0x0,
    0x0, 0xf7, 0x0, 0x2, 0xca, 0x0, 0x0, 0xf7,
    0x0, 0x0, 0x1f, 0x70, 0x0, 0xf7, 0x0, 0x0,
    0xc, 0xe0, 0x0, 0xf7, 0x0, 0x0, 0xa, 0xf1,
    0x0, 0xf7, 0x0, 0x0, 0xb, 0xf1, 0x0, 0xf7,
    0x0, 0x0, 0xe, 0xd0, 0x0, 0xf7, 0x0, 0x0,
    0xaf, 0x30, 0x5b, 0xfe, 0x99, 0xac, 0xa2, 0x0,

    /* U+43 "C" */
    0x0, 0x0, 0x7b, 0xac, 0xff, 0x60, 0x0, 0x1d,
    0x90, 0x0, 0x3e, 0xa0, 0x0, 0xbc, 0x0, 0x0,
    0x3, 0xd0, 0x4, 0xf4, 0x0, 0x0, 0x0, 0xb0,
    0xb, 0xf0, 0x0, 0x0, 0x0, 0x10, 0xf, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xe0, 0x0, 0x0, 0x0, 0x50,
    0x8, 0xf2, 0x0, 0x0, 0x0, 0xa0, 0x1, 0xfa,
    0x0, 0x0, 0x6, 0x50, 0x0, 0x4f, 0x80, 0x0,
    0x69, 0x0, 0x0, 0x2, 0xad, 0xdc, 0x70, 0x0,

    /* U+44 "D" */
    0x3b, 0xfe, 0x99, 0xa7, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x8, 0xd2, 0x0, 0x0, 0xf7, 0x0, 0x0,
    0xbd, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x3f, 0x60,
    0x0, 0xf7, 0x0, 0x0, 0xe, 0xc0, 0x0, 0xf7,
    0x0, 0x0, 0xc, 0xf0, 0x0, 0xf7, 0x0, 0x0,
    0xa, 0xf1, 0x0, 0xf7, 0x0, 0x0, 0xa, 0xf2,
    0x0, 0xf7, 0x0, 0x0, 0xa, 0xf1, 0x0, 0xf7,
    0x0, 0x0, 0xb, 0xf0, 0x0, 0xf7, 0x0, 0x0,
    0xc, 0xe0, 0x0, 0xf7, 0x0, 0x0, 0xf, 0xa0,
    0x0, 0xf7, 0x0, 0x0, 0x4f, 0x50, 0x0, 0xf7,
    0x0, 0x0, 0xcc, 0x0, 0x0, 0xf7, 0x0, 0x1a,
    0xd1, 0x0, 0x4b, 0xfe, 0x99, 0xb6, 0x0, 0x0,

    /* U+45 "E" */
    0x2a, 0xfe, 0x99, 0x9a, 0xef, 0x10, 0x0, 0xf9,
    0x0, 0x0, 0x1c, 0x70, 0x0, 0xf9, 0x0, 0x0,
    0x1, 0xb0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x10,
    0x0, 0xf9, 0x0, 0x0, 0x40, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x90, 0x0, 0x0, 0xf9, 0x0, 0x4,
    0xa0, 0x0, 0x0, 0xfc, 0x99, 0xaf, 0xa0, 0x0,
    0x0, 0xf9, 0x0, 0x4, 0xa0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x90, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x61, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0xc0, 0x0, 0xf9, 0x0, 0x0,
    0xa, 0xa0, 0x3a, 0xfe, 0x99, 0x9a, 0xef, 0x50,

    /* U+46 "F" */
    0x3a, 0xfe, 0x99, 0x9a, 0xef, 0x90, 0x0, 0xf9,
    0x0, 0x0, 0x8, 0xe0, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x94, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x3,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x90, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0xc0, 0x0, 0x0, 0xfc, 0x99, 0x9d, 0xf0, 0x0,
    0x0, 0xf9, 0x0, 0x1, 0xe0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x90, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x30, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x3a, 0xfe, 0x90, 0x0, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x1, 0xab, 0xbf, 0xf7, 0x0, 0x0, 0x2e,
    0x50, 0x2, 0xda, 0x0, 0x0, 0xc9, 0x0, 0x0,
    0x3d, 0x0, 0x5, 0xf1, 0x0, 0x0, 0xb, 0x0,
    0xc, 0xb0, 0x0, 0x0, 0x2, 0x0, 0xf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0x18, 0xcc, 0xa4, 0x1f, 0x80, 0x0, 0x0,
    0x8f, 0x10, 0xd, 0xc0, 0x0, 0x0, 0x7f, 0x0,
    0x8, 0xf1, 0x0, 0x0, 0x7f, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x7f, 0x0, 0x0, 0x5f, 0x30, 0x0,
    0xcf, 0x0, 0x0, 0x4, 0xbb, 0xaa, 0x40, 0x0,

    /* U+48 "H" */
    0x4c, 0xfc, 0x30, 0x4, 0xcf, 0xc3, 0x5, 0xf3,
    0x0, 0x0, 0x4f, 0x30, 0x5, 0xf3, 0x0, 0x0,
    0x4f, 0x30, 0x5, 0xf3, 0x0, 0x0, 0x4f, 0x30,
    0x5, 0xf3, 0x0, 0x0, 0x4f, 0x30, 0x5, 0xf3,
    0x0, 0x0, 0x4f, 0x30, 0x5, 0xf3, 0x0, 0x0,
    0x4f, 0x30, 0x5, 0xfa, 0x99, 0x99, 0xaf, 0x30,
    0x5, 0xf3, 0x0, 0x0, 0x4f, 0x30, 0x5, 0xf3,
    0x0, 0x0, 0x4f, 0x30, 0x5, 0xf3, 0x0, 0x0,
    0x4f, 0x30, 0x5, 0xf3, 0x0, 0x0, 0x4f, 0x30,
    0x5, 0xf3, 0x0, 0x0, 0x4f, 0x30, 0x5, 0xf3,
    0x0, 0x0, 0x4f, 0x30, 0x5, 0xf3, 0x0, 0x0,
    0x4f, 0x30, 0x5c, 0xfc, 0x40, 0x5, 0xcf, 0xc4,

    /* U+49 "I" */
    0x69, 0x9f, 0xf9, 0x96, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x69, 0x9f, 0xf9, 0x96,

    /* U+4A "J" */
    0x0, 0x2, 0x99, 0xbf, 0xd9, 0x93, 0x0, 0x0,
    0x0, 0x2f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0xd, 0xa0, 0x0, 0x6e, 0x0, 0x0, 0x1f, 0xd0,
    0x1, 0xd5, 0x0, 0x0, 0x4, 0xcb, 0xaa, 0x30,
    0x0, 0x0,

    /* U+4B "K" */
    0x3b, 0xfe, 0x80, 0x9, 0xff, 0x90, 0x0, 0xf7,
    0x0, 0x0, 0xd2, 0x0, 0x0, 0xf7, 0x0, 0x9,
    0x40, 0x0, 0x0, 0xf7, 0x0, 0x49, 0x0, 0x0,
    0x0, 0xf7, 0x1, 0xb0, 0x0, 0x0, 0x0, 0xf7,
    0xa, 0x20, 0x0, 0x0, 0x0, 0xf7, 0x6f, 0x30,
    0x0, 0x0, 0x0, 0xf9, 0xbe, 0xb0, 0x0, 0x0,
    0x0, 0xfe, 0x16, 0xf2, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0xea, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x7f,
    0x10, 0x0, 0x0, 0xf7, 0x0, 0x1f, 0x90, 0x0,
    0x0, 0xf7, 0x0, 0x9, 0xf1, 0x0, 0x0, 0xf7,
    0x0, 0x1, 0xf8, 0x0, 0x0, 0xf7, 0x0, 0x0,
    0xae, 0x10, 0x3b, 0xfe, 0x80, 0x4, 0xdf, 0xd4,

    /* U+4C "L" */
    0x19, 0xff, 0x92, 0x0, 0x0, 0x0, 0x0, 0xcc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x0, 0x52, 0x0, 0xcc,
    0x0, 0x0, 0x0, 0xb0, 0x0, 0xcc, 0x0, 0x0,
    0x8, 0xc0, 0x29, 0xff, 0x99, 0x99, 0xdf, 0x80,

    /* U+4D "M" */
    0x7e, 0xf0, 0x0, 0x0, 0x6f, 0xe6, 0x9, 0xf3,
    0x0, 0x0, 0xaf, 0x80, 0x9, 0xf7, 0x0, 0x0,
    0xbf, 0x80, 0x9, 0xaa, 0x0, 0x1, 0x8f, 0x80,
    0x9, 0x7e, 0x0, 0x5, 0x5f, 0x80, 0x9, 0x3f,
    0x10, 0x8, 0x1f, 0x80, 0x9, 0xf, 0x50, 0xa,
    0xf, 0x80, 0x9, 0xc, 0x80, 0x9, 0xf, 0x80,
    0x9, 0x9, 0xb0, 0x46, 0xf, 0x80, 0x9, 0x5,
    0xf0, 0x72, 0xf, 0x80, 0x9, 0x2, 0xf2, 0xa0,
    0xf, 0x80, 0x9, 0x0, 0xe6, 0x90, 0xf, 0x80,
    0x9, 0x0, 0xbd, 0x70, 0xf, 0x80, 0x9, 0x0,
    0x7f, 0x30, 0xf, 0x80, 0x9, 0x0, 0x4f, 0x0,
    0xf, 0x80, 0x6e, 0xb0, 0xb, 0x2, 0xaf, 0xe6,

    /* U+4E "N" */
    0x5c, 0xf5, 0x0, 0x0, 0x8d, 0xc7, 0x3, 0xfd,
    0x0, 0x0, 0x5, 0x30, 0x3, 0x9f, 0x60, 0x0,
    0x5, 0x30, 0x3, 0x5b, 0xe0, 0x0, 0x5, 0x30,
    0x3, 0x53, 0xf6, 0x0, 0x5, 0x30, 0x3, 0x50,
    0xbe, 0x0, 0x5, 0x30, 0x3, 0x50, 0x3f, 0x70,
    0x5, 0x30, 0x3, 0x50, 0xa, 0xe0, 0x5, 0x30,
    0x3, 0x50, 0x2, 0xf8, 0x5, 0x30, 0x3, 0x50,
    0x0, 0xaf, 0x15, 0x30, 0x3, 0x50, 0x0, 0x2f,
    0x85, 0x30, 0x3, 0x50, 0x0, 0xa, 0xf7, 0x30,
    0x3, 0x50, 0x0, 0x2, 0xfe, 0x30, 0x3, 0x50,
    0x0, 0x0, 0x9f, 0x30, 0x3, 0x50, 0x0, 0x0,
    0x2f, 0x30, 0x7c, 0xd8, 0x0, 0x0, 0x9, 0x30,

    /* U+4F "O" */
    0x0, 0x2, 0xab, 0xab, 0x30, 0x0, 0x0, 0x2e,
    0x40, 0x1, 0xd4, 0x0, 0x0, 0xd9, 0x0, 0x0,
    0x5e, 0x10, 0x5, 0xf2, 0x0, 0x0, 0xf, 0x80,
    0xb, 0xe0, 0x0, 0x0, 0xb, 0xd0, 0xe, 0xc0,
    0x0, 0x0, 0x9, 0xf1, 0x1f, 0xa0, 0x0, 0x0,
    0x7, 0xf4, 0x2f, 0xa0, 0x0, 0x0, 0x7, 0xf5,
    0x2f, 0xa0, 0x0, 0x0, 0x7, 0xf5, 0x1f, 0xa0,
    0x0, 0x0, 0x7, 0xf4, 0xe, 0xc0, 0x0, 0x0,
    0x9, 0xf1, 0xa, 0xe0, 0x0, 0x0, 0xb, 0xe0,
    0x5, 0xf2, 0x0, 0x0, 0xe, 0x80, 0x0, 0xc8,
    0x0, 0x0, 0x4f, 0x10, 0x0, 0x1d, 0x40, 0x1,
    0xd4, 0x0, 0x0, 0x1, 0x99, 0x9a, 0x30, 0x0,

    /* U+50 "P" */
    0x3a, 0xfe, 0x99, 0x9b, 0x91, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x7e, 0x20, 0x0, 0xf9, 0x0, 0x0,
    0xd, 0xa0, 0x0, 0xf9, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0xf9, 0x0, 0x0, 0x8, 0xf0, 0x0, 0xf9,
    0x0, 0x0, 0xa, 0xe0, 0x0, 0xf9, 0x0, 0x0,
    0xe, 0x80, 0x0, 0xf9, 0x0, 0x2, 0xcb, 0x0,
    0x0, 0xfc, 0x99, 0xaa, 0x50, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x3a, 0xfe, 0x90, 0x0, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x3, 0xba, 0xaa, 0x30, 0x0, 0x0, 0x5f,
    0x30, 0x2, 0xd4, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0x5e, 0x10, 0x8, 0xf1, 0x0, 0x0, 0xf, 0x80,
    0xd, 0xd0, 0x0, 0x0, 0xc, 0xd0, 0xf, 0xa0,
    0x0, 0x0, 0xa, 0xf0, 0x2f, 0x90, 0x0, 0x0,
    0x9, 0xf2, 0x3f, 0x80, 0x0, 0x0, 0x8, 0xf3,
    0x3f, 0x80, 0x0, 0x0, 0x8, 0xf3, 0x2f, 0x90,
    0x0, 0x0, 0x9, 0xf3, 0x1f, 0xa0, 0x0, 0x0,
    0xa, 0xf1, 0xe, 0xc2, 0xce, 0x90, 0xb, 0xe0,
    0x9, 0xfc, 0x41, 0xe7, 0xe, 0x90, 0x2, 0xfc,
    0x0, 0x8d, 0x4f, 0x10, 0x0, 0x5f, 0x30, 0x3f,
    0xf6, 0x0, 0x0, 0x3, 0xaa, 0xbf, 0xa0, 0x10,
    0x0, 0x0, 0x0, 0xa, 0xe3, 0x80, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x23, 0x0,

    /* U+52 "R" */
    0x29, 0xff, 0x99, 0xac, 0x81, 0x0, 0x0, 0xda,
    0x0, 0x1, 0xcd, 0x0, 0x0, 0xda, 0x0, 0x0,
    0x4f, 0x60, 0x0, 0xda, 0x0, 0x0, 0xf, 0x90,
    0x0, 0xda, 0x0, 0x0, 0x1f, 0x80, 0x0, 0xda,
    0x0, 0x0, 0x5f, 0x30, 0x0, 0xda, 0x0, 0x4,
    0xe7, 0x0, 0x0, 0xdd, 0x99, 0xea, 0x30, 0x0,
    0x0, 0xda, 0x0, 0xe8, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x8e, 0x0, 0x0, 0x0, 0xda, 0x0, 0x2f,
    0x50, 0x0, 0x0, 0xda, 0x0, 0xc, 0xb0, 0x0,
    0x0, 0xda, 0x0, 0x6, 0xf2, 0x0, 0x0, 0xda,
    0x0, 0x1, 0xf8, 0x0, 0x0, 0xda, 0x0, 0x0,
    0xae, 0x0, 0x29, 0xff, 0x90, 0x0, 0x4f, 0xc4,

    /* U+53 "S" */
    0x0, 0x8a, 0xac, 0xff, 0xb0, 0xc, 0x40, 0x0,
    0x2d, 0xd0, 0x7a, 0x0, 0x0, 0x1, 0xe0, 0xb7,
    0x0, 0x0, 0x0, 0x40, 0xa9, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x60, 0x0, 0x0, 0x0, 0xa, 0xfd,
    0x50, 0x0, 0x0, 0x0, 0x4c, 0xfe, 0x60, 0x0,
    0x0, 0x0, 0x4c, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0x5f, 0xd0, 0x0, 0x0, 0x0, 0x4, 0xf5, 0x20,
    0x0, 0x0, 0x0, 0xc8, 0xc0, 0x0, 0x0, 0x0,
    0xd8, 0xa7, 0x0, 0x0, 0x1, 0xf3, 0x7f, 0x70,
    0x0, 0xa, 0x90, 0x4f, 0xfe, 0xba, 0xb6, 0x0,

    /* U+54 "T" */
    0x9, 0xfc, 0xaf, 0xea, 0xbf, 0x80, 0xd, 0x30,
    0xd, 0xa0, 0x4, 0xb0, 0x1a, 0x0, 0xd, 0xa0,
    0x0, 0xb0, 0x23, 0x0, 0xd, 0xa0, 0x0, 0x40,
    0x0, 0x0, 0xd, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xa0,
    0x0, 0x0, 0x0, 0x4, 0x9f, 0xf9, 0x30, 0x0,

    /* U+55 "U" */
    0x5c, 0xfc, 0x40, 0x0, 0x8e, 0xb3, 0x5, 0xf3,
    0x0, 0x0, 0x8, 0x0, 0x5, 0xf3, 0x0, 0x0,
    0x8, 0x0, 0x5, 0xf3, 0x0, 0x0, 0x8, 0x0,
    0x5, 0xf3, 0x0, 0x0, 0x8, 0x0, 0x5, 0xf3,
    0x0, 0x0, 0x8, 0x0, 0x5, 0xf3, 0x0, 0x0,
    0x8, 0x0, 0x5, 0xf3, 0x0, 0x0, 0x8, 0x0,
    0x5, 0xf3, 0x0, 0x0, 0x8, 0x0, 0x5, 0xf3,
    0x0, 0x0, 0x8, 0x0, 0x5, 0xf3, 0x0, 0x0,
    0x8, 0x0, 0x5, 0xf3, 0x0, 0x0, 0x8, 0x0,
    0x4, 0xf3, 0x0, 0x0, 0x9, 0x0, 0x1, 0xf5,
    0x0, 0x0, 0xa, 0x0, 0x0, 0x9d, 0x20, 0x1,
    0xa3, 0x0, 0x0, 0x5, 0xcc, 0xca, 0x20, 0x0,

    /* U+56 "V" */
    0x5d, 0xfc, 0x30, 0x0, 0xaf, 0xb3, 0x3, 0xf6,
    0x0, 0x0, 0xd, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x29, 0x0, 0x0, 0xbd, 0x0, 0x0, 0x64, 0x0,
    0x0, 0x7f, 0x10, 0x0, 0xa0, 0x0, 0x0, 0x3f,
    0x50, 0x0, 0xb0, 0x0, 0x0, 0xf, 0x80, 0x3,
    0x70, 0x0, 0x0, 0xb, 0xc0, 0x7, 0x30, 0x0,
    0x0, 0x7, 0xf0, 0xa, 0x0, 0x0, 0x0, 0x4,
    0xf4, 0xa, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x46,
    0x0, 0x0, 0x0, 0x0, 0xcc, 0x82, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x90, 0x0, 0x0, 0x0, 0x0, 0xf, 0x50,
    0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0, 0x0,

    /* U+57 "W" */
    0x8f, 0xe4, 0x4e, 0xf6, 0xa, 0xf7, 0xd, 0x70,
    0x8, 0xc0, 0x0, 0xa0, 0xb, 0x90, 0x6, 0xe0,
    0x2, 0x70, 0x8, 0xc0, 0x5, 0xf0, 0x5, 0x50,
    0x6, 0xe0, 0x6, 0xf3, 0x7, 0x20, 0x3, 0xf0,
    0x9, 0xf5, 0x9, 0x0, 0x1, 0xf3, 0xa, 0xd7,
    0xa, 0x0, 0x0, 0xe5, 0x9, 0xb9, 0x9, 0x0,
    0x0, 0xc7, 0x36, 0x8c, 0x27, 0x0, 0x0, 0x9a,
    0x73, 0x6e, 0x54, 0x0, 0x0, 0x7c, 0xa0, 0x3f,
    0x81, 0x0, 0x0, 0x5e, 0xb0, 0x1f, 0xd0, 0x0,
    0x0, 0x2f, 0xa0, 0xf, 0xc0, 0x0, 0x0, 0xf,
    0x60, 0xc, 0x90, 0x0, 0x0, 0xd, 0x30, 0xa,
    0x60, 0x0, 0x0, 0xb, 0x0, 0x7, 0x30, 0x0,

    /* U+58 "X" */
    0xa, 0xff, 0x70, 0x5, 0xcf, 0x90, 0x0, 0x9e,
    0x0, 0x0, 0x76, 0x0, 0x0, 0x2f, 0x40, 0x0,
    0xb0, 0x0, 0x0, 0xb, 0xc0, 0x5, 0x60, 0x0,
    0x0, 0x3, 0xf3, 0xb, 0x0, 0x0, 0x0, 0x0,
    0xca, 0x47, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x3a, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xa2, 0x8f,
    0x10, 0x0, 0x0, 0x2, 0xa0, 0x1f, 0x70, 0x0,
    0x0, 0x9, 0x20, 0x9, 0xe0, 0x0, 0x0, 0x1a,
    0x0, 0x2, 0xf6, 0x0, 0x0, 0x94, 0x0, 0x0,
    0xbd, 0x0, 0x3a, 0xfc, 0x10, 0x5, 0xdf, 0xc3,

    /* U+59 "Y" */
    0x4d, 0xfd, 0x60, 0x2, 0xbf, 0xc3, 0x2, 0xf8,
    0x0, 0x0, 0x1c, 0x0, 0x0, 0xad, 0x0, 0x0,
    0x64, 0x0, 0x0, 0x4f, 0x30, 0x0, 0xa0, 0x0,
    0x0, 0xe, 0x90, 0x2, 0x80, 0x0, 0x0, 0x8,
    0xe0, 0x8, 0x20, 0x0, 0x0, 0x2, 0xf5, 0xa,
    0x0, 0x0, 0x0, 0x0, 0xbb, 0x45, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xa0,
    0x0, 0x0, 0x0, 0x4, 0x9f, 0xf9, 0x30, 0x0,

    /* U+5A "Z" */
    0x0, 0xbf, 0xd9, 0x99, 0x9f, 0xb0, 0x1f, 0x60,
    0x0, 0x6, 0xf2, 0x7, 0x70, 0x0, 0x0, 0xea,
    0x0, 0x30, 0x0, 0x0, 0x7f, 0x10, 0x0, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x0, 0x8, 0xf1,
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x9e, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x60,
    0x0, 0x0, 0x0, 0xa, 0xd0, 0x0, 0x0, 0x0,
    0x3, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x70,
    0xd, 0xc0, 0x0, 0x0, 0x48, 0x5, 0xf3, 0x0,
    0x0, 0x2e, 0x40, 0xde, 0x99, 0x99, 0xbf, 0xf0,

    /* U+5B "[" */
    0x4e, 0xdd, 0xdd, 0x45, 0xa0, 0x0, 0x0, 0x5a,
    0x0, 0x0, 0x5, 0xa0, 0x0, 0x0, 0x5a, 0x0,
    0x0, 0x5, 0xa0, 0x0, 0x0, 0x5a, 0x0, 0x0,
    0x5, 0xa0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x5,
    0xa0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x5, 0xa0,
    0x0, 0x0, 0x5a, 0x0, 0x0, 0x5, 0xa0, 0x0,
    0x0, 0x5a, 0x0, 0x0, 0x5, 0xa0, 0x0, 0x0,
    0x5a, 0x0, 0x0, 0x5, 0xa0, 0x0, 0x0, 0x5a,
    0x0, 0x0, 0x5, 0xa0, 0x0, 0x0, 0x4e, 0xdd,
    0xdd, 0x40,

    /* U+5C "\\" */
    0xf, 0x10, 0x0, 0x0, 0x0, 0x9, 0x80, 0x0,
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xd4, 0x0, 0x0, 0x0, 0x0, 0x6b, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x10, 0x0, 0x0, 0x0, 0xa,
    0x70, 0x0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xd4, 0x0, 0x0, 0x0, 0x0, 0x6b,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x10, 0x0, 0x0,
    0x0, 0xa, 0x70, 0x0, 0x0, 0x0, 0x3, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xd4, 0x0, 0x0, 0x0,
    0x0, 0x7a, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x10,
    0x0, 0x0, 0x0, 0xa, 0x70, 0x0, 0x0, 0x0,
    0x3, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xd4, 0x0,
    0x0, 0x0, 0x0, 0x7a,

    /* U+5D "]" */
    0x5d, 0xdd, 0xde, 0x30, 0x0, 0x0, 0xb3, 0x0,
    0x0, 0xb, 0x30, 0x0, 0x0, 0xb3, 0x0, 0x0,
    0xb, 0x30, 0x0, 0x0, 0xb3, 0x0, 0x0, 0xb,
    0x30, 0x0, 0x0, 0xb3, 0x0, 0x0, 0xb, 0x30,
    0x0, 0x0, 0xb3, 0x0, 0x0, 0xb, 0x30, 0x0,
    0x0, 0xb3, 0x0, 0x0, 0xb, 0x30, 0x0, 0x0,
    0xb3, 0x0, 0x0, 0xb, 0x30, 0x0, 0x0, 0xb3,
    0x0, 0x0, 0xb, 0x30, 0x0, 0x0, 0xb3, 0x0,
    0x0, 0xb, 0x30, 0x0, 0x0, 0xb3, 0x5d, 0xdd,
    0xde, 0x30,

    /* U+5E "^" */
    0x0, 0x8f, 0xf8, 0x0, 0x5, 0xc2, 0x2c, 0x40,
    0x5, 0x0, 0x0, 0x50,

    /* U+5F "_" */
    0x99, 0x99, 0x99, 0x99, 0x99, 0x98,

    /* U+60 "`" */
    0x8, 0xef, 0x30, 0x0, 0x7, 0xd3, 0x0, 0x0,
    0x3,

    /* U+61 "a" */
    0x1, 0x89, 0x88, 0xa4, 0x0, 0x1, 0xe6, 0x0,
    0x1, 0xf3, 0x0, 0x5f, 0x30, 0x0, 0xc, 0x70,
    0x0, 0x40, 0x0, 0x0, 0xc9, 0x0, 0x0, 0x5,
    0x9a, 0x9e, 0x90, 0x0, 0x6e, 0x71, 0x0, 0xc9,
    0x0, 0x6f, 0x30, 0x0, 0xc, 0x90, 0xd, 0xb0,
    0x0, 0x0, 0xc9, 0x0, 0xeb, 0x0, 0x0, 0xc,
    0x90, 0x29, 0xf2, 0x0, 0x7, 0xe9, 0x16, 0x7,
    0xca, 0xa9, 0x35, 0xea, 0x10,

    /* U+62 "b" */
    0x0, 0x42, 0x0, 0x0, 0x0, 0x3, 0xbf, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x40, 0x0, 0x0, 0x0, 0x0, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xf4, 0x2a, 0xbd, 0x90, 0x0, 0xf,
    0x79, 0x0, 0xb, 0xb0, 0x0, 0xfc, 0x0, 0x0,
    0x3f, 0x30, 0xf, 0x60, 0x0, 0x0, 0xf8, 0x0,
    0xf4, 0x0, 0x0, 0xd, 0xa0, 0xf, 0x40, 0x0,
    0x0, 0xda, 0x0, 0xf4, 0x0, 0x0, 0xd, 0x90,
    0xf, 0x40, 0x0, 0x0, 0xf7, 0x0, 0xf6, 0x0,
    0x0, 0x3f, 0x10, 0xf, 0xd2, 0x0, 0xc, 0x70,
    0x0, 0xa1, 0x9a, 0xab, 0x50, 0x0,

    /* U+63 "c" */
    0x0, 0x19, 0x99, 0xa6, 0x0, 0x2, 0xe4, 0x0,
    0xd, 0x60, 0xd, 0xa0, 0x0, 0xe, 0xc0, 0x4f,
    0x30, 0x0, 0x6, 0x50, 0x8f, 0x0, 0x0, 0x0,
    0x0, 0x9e, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x20, 0x0, 0x0, 0x13,
    0xe, 0x80, 0x0, 0x0, 0x82, 0x5, 0xf5, 0x0,
    0x7, 0x70, 0x0, 0x3b, 0xdb, 0xb6, 0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x1, 0x70, 0x0, 0x0, 0x0,
    0x8, 0xdf, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x0, 0x0, 0x3b, 0xcb, 0x86, 0xf0, 0x0, 0x4f,
    0x30, 0x3, 0xdf, 0x0, 0xe, 0x80, 0x0, 0x6,
    0xf0, 0x5, 0xf3, 0x0, 0x0, 0x6f, 0x0, 0x8f,
    0x0, 0x0, 0x6, 0xf0, 0x9, 0xe0, 0x0, 0x0,
    0x6f, 0x0, 0x8f, 0x0, 0x0, 0x6, 0xf0, 0x5,
    0xf1, 0x0, 0x0, 0x6f, 0x0, 0x1f, 0x50, 0x0,
    0xa, 0xf0, 0x0, 0x6e, 0x20, 0x5, 0xef, 0x0,
    0x0, 0x5c, 0xcb, 0x76, 0xea, 0x20,

    /* U+65 "e" */
    0x0, 0x1a, 0xba, 0xb4, 0x0, 0x2, 0xe4, 0x0,
    0x1e, 0x60, 0xc, 0x90, 0x0, 0x6, 0xf1, 0x3f,
    0x30, 0x0, 0x1, 0xf5, 0x6f, 0x10, 0x0, 0x0,
    0xf8, 0x7f, 0x99, 0x99, 0x99, 0xc7, 0x6f, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x20, 0x0, 0x0, 0x0,
    0xd, 0x80, 0x0, 0x0, 0x71, 0x3, 0xe5, 0x0,
    0x6, 0x70, 0x0, 0x2a, 0xdb, 0xb6, 0x0,

    /* U+66 "f" */
    0x0, 0x0, 0x29, 0x88, 0xb7, 0x0, 0x0, 0x2e,
    0x10, 0x6, 0xf3, 0x0, 0xa, 0xa0, 0x0, 0x28,
    0x10, 0x0, 0xc8, 0x0, 0x0, 0x0, 0x0, 0xc,
    0x80, 0x0, 0x0, 0x6, 0x99, 0xec, 0x99, 0x94,
    0x0, 0x0, 0xc, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xc8, 0x0, 0x0, 0x0, 0x0, 0xc, 0x80, 0x0,
    0x0, 0x0, 0x0, 0xc8, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x80, 0x0, 0x0, 0x0, 0x0, 0xc8, 0x0,
    0x0, 0x0, 0x0, 0xc, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xc8, 0x0, 0x0, 0x0, 0x0, 0xc, 0x80,
    0x0, 0x0, 0x1, 0x99, 0xfe, 0x99, 0x50, 0x0,

    /* U+67 "g" */
    0x0, 0x5b, 0x9a, 0xa4, 0xbe, 0x10, 0x5d, 0x0,
    0x7, 0xe1, 0xa1, 0xd, 0x60, 0x0, 0xf, 0x40,
    0x0, 0xf5, 0x0, 0x0, 0xe6, 0x0, 0xc, 0x70,
    0x0, 0xf, 0x40, 0x0, 0x2d, 0x20, 0x8, 0xb0,
    0x0, 0x4, 0xa8, 0x89, 0x70, 0x0, 0x0, 0xe5,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xca, 0x85,
    0x0, 0x0, 0x78, 0x57, 0x9c, 0xee, 0x10, 0x6b,
    0x0, 0x0, 0x0, 0xd8, 0xa, 0x90, 0x0, 0x0,
    0xa, 0x80, 0x4e, 0x30, 0x0, 0x3, 0xd2, 0x0,
    0x29, 0x99, 0x99, 0x92, 0x0,

    /* U+68 "h" */
    0x0, 0x65, 0x0, 0x0, 0x0, 0x0, 0x3a, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf6, 0x2b, 0xde,
    0x90, 0x0, 0x0, 0xfa, 0xb2, 0x1, 0xc8, 0x0,
    0x0, 0xfc, 0x0, 0x0, 0x7d, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x6e, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x6f, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x6f, 0x0,
    0x0, 0xf6, 0x0, 0x0, 0x6f, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x6f, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x6f, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x6f, 0x0,
    0x2a, 0xfd, 0x60, 0x6, 0xdf, 0xa2,

    /* U+69 "i" */
    0x0, 0xc, 0xe1, 0x0, 0x0, 0xf, 0xf2, 0x0,
    0x0, 0x2, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x13, 0x40, 0x0, 0x49, 0x9f, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x49, 0x9f, 0xf9, 0x94,

    /* U+6A "j" */
    0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x8,
    0xfa, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x15, 0x20, 0x0,
    0x6, 0x9b, 0xf4, 0x0, 0x0, 0x0, 0xf, 0x40,
    0x0, 0x0, 0x0, 0xf4, 0x0, 0x0, 0x0, 0xf,
    0x40, 0x0, 0x0, 0x0, 0xf4, 0x0, 0x0, 0x0,
    0xf, 0x40, 0x0, 0x0, 0x0, 0xf4, 0x0, 0x0,
    0x0, 0xf, 0x40, 0x0, 0x0, 0x0, 0xf4, 0x0,
    0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0x1, 0xf3,
    0x4, 0x20, 0x0, 0x4e, 0x0, 0xfb, 0x0, 0x1c,
    0x50, 0x6, 0xdc, 0xca, 0x30, 0x0,

    /* U+6B "k" */
    0x0, 0x46, 0x0, 0x0, 0x0, 0x0, 0x29, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd7, 0x0, 0x3c,
    0xfb, 0x40, 0x0, 0xd7, 0x0, 0xb, 0x50, 0x0,
    0x0, 0xd7, 0x0, 0x87, 0x0, 0x0, 0x0, 0xd7,
    0x6, 0xa0, 0x0, 0x0, 0x0, 0xd7, 0x5f, 0xa0,
    0x0, 0x0, 0x0, 0xda, 0xb5, 0xf3, 0x0, 0x0,
    0x0, 0xdd, 0x10, 0xbd, 0x0, 0x0, 0x0, 0xd7,
    0x0, 0x2f, 0x70, 0x0, 0x0, 0xd7, 0x0, 0x8,
    0xf1, 0x0, 0x0, 0xd7, 0x0, 0x0, 0xeb, 0x0,
    0x19, 0xfe, 0x70, 0x5, 0xdf, 0xb2,

    /* U+6C "l" */
    0x0, 0x27, 0x90, 0x0, 0x59, 0x9f, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x59, 0x9f, 0xf9, 0x95,

    /* U+6D "m" */
    0x7f, 0x88, 0xcd, 0x37, 0xbd, 0x50, 0xc, 0xe3,
    0xa, 0xe5, 0x7, 0xd0, 0xc, 0x90, 0x9, 0xd0,
    0x5, 0xf0, 0xc, 0x80, 0x9, 0xc0, 0x5, 0xf0,
    0xc, 0x80, 0x9, 0xc0, 0x5, 0xf0, 0xc, 0x80,
    0x9, 0xc0, 0x5, 0xf0, 0xc, 0x80, 0x9, 0xc0,
    0x5, 0xf0, 0xc, 0x80, 0x9, 0xc0, 0x5, 0xf0,
    0xc, 0x80, 0x9, 0xc0, 0x5, 0xf0, 0xc, 0x80,
    0x9, 0xc0, 0x5, 0xf0, 0x7f, 0xe4, 0x4e, 0xf6,
    0x2d, 0xf9,

    /* U+6E "n" */
    0x1c, 0xf6, 0x2a, 0xcc, 0x90, 0x0, 0x0, 0xf9,
    0xb1, 0x0, 0xc8, 0x0, 0x0, 0xfc, 0x0, 0x0,
    0x7d, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0xf6, 0x0, 0x0, 0x6f, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x6f, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x6f, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x6f, 0x0,
    0x0, 0xf6, 0x0, 0x0, 0x6f, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x6f, 0x0, 0x2a, 0xfd, 0x60, 0x6,
    0xdf, 0xa2,

    /* U+6F "o" */
    0x0, 0x3a, 0x99, 0xa4, 0x0, 0x4, 0xd2, 0x0,
    0x1d, 0x50, 0x1f, 0x40, 0x0, 0x3, 0xf1, 0x8e,
    0x0, 0x0, 0x0, 0xd8, 0xcb, 0x0, 0x0, 0x0,
    0xbc, 0xda, 0x0, 0x0, 0x0, 0xad, 0xca, 0x0,
    0x0, 0x0, 0xbc, 0x8d, 0x0, 0x0, 0x0, 0xd8,
    0x2f, 0x20, 0x0, 0x3, 0xf2, 0x6, 0xc1, 0x0,
    0xc, 0x60, 0x0, 0x4a, 0x99, 0xa4, 0x0,

    /* U+70 "p" */
    0x4d, 0xf6, 0x4b, 0xcc, 0x80, 0x0, 0xf, 0xa9,
    0x0, 0xa, 0xc0, 0x0, 0xfb, 0x0, 0x0, 0x1f,
    0x50, 0xf, 0x60, 0x0, 0x0, 0xca, 0x0, 0xf6,
    0x0, 0x0, 0xa, 0xd0, 0xf, 0x60, 0x0, 0x0,
    0xad, 0x0, 0xf6, 0x0, 0x0, 0xb, 0xc0, 0xf,
    0x60, 0x0, 0x0, 0xd9, 0x0, 0xf7, 0x0, 0x0,
    0x3f, 0x30, 0xf, 0xe3, 0x0, 0x1d, 0x90, 0x0,
    0xf6, 0x8a, 0xac, 0x60, 0x0, 0xf, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x3,
    0xaf, 0xd8, 0x0, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x4b, 0xaa, 0x70, 0xa0, 0x0, 0x6d, 0x20,
    0x4, 0xdd, 0x0, 0x2f, 0x40, 0x0, 0x9, 0xd0,
    0x8, 0xf0, 0x0, 0x0, 0x7d, 0x0, 0xbc, 0x0,
    0x0, 0x7, 0xd0, 0xc, 0xb0, 0x0, 0x0, 0x7d,
    0x0, 0xbb, 0x0, 0x0, 0x7, 0xd0, 0x8, 0xd0,
    0x0, 0x0, 0x7d, 0x0, 0x3f, 0x20, 0x0, 0xa,
    0xd0, 0x0, 0x9b, 0x0, 0x6, 0xdd, 0x0, 0x0,
    0x7d, 0xbb, 0x67, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x7d, 0x0, 0x0, 0x0, 0x0, 0x7, 0xd0, 0x0,
    0x0, 0x0, 0x9, 0xdf, 0xa2,

    /* U+72 "r" */
    0x1c, 0xcf, 0xc0, 0x19, 0xbe, 0x70, 0x0, 0x9c,
    0x1a, 0x20, 0xde, 0x0, 0x8, 0xca, 0x10, 0x4,
    0x40, 0x0, 0x8f, 0x50, 0x0, 0x0, 0x0, 0x8,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x8c, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x8c, 0x0, 0x0, 0x0, 0x0, 0x8, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x8c, 0x0, 0x0, 0x0, 0x29,
    0x9e, 0xf9, 0x96, 0x0, 0x0,

    /* U+73 "s" */
    0x0, 0x39, 0x8a, 0xef, 0x90, 0x3, 0xc0, 0x0,
    0xb, 0xb0, 0x9, 0x80, 0x0, 0x0, 0xc0, 0x8,
    0xc0, 0x0, 0x0, 0x20, 0x1, 0xde, 0x93, 0x0,
    0x0, 0x0, 0x6, 0xdf, 0xd5, 0x0, 0x0, 0x0,
    0x3, 0xaf, 0x90, 0x5, 0x0, 0x0, 0x4, 0xf2,
    0xd, 0x0, 0x0, 0x0, 0xf1, 0xd, 0x90, 0x0,
    0x3, 0xb0, 0xc, 0xfe, 0xa9, 0x98, 0x10,

    /* U+74 "t" */
    0x0, 0x0, 0x90, 0x0, 0x0, 0x0, 0x5, 0xa0,
    0x0, 0x0, 0x0, 0x4e, 0xa0, 0x0, 0x0, 0x49,
    0x9d, 0xd9, 0x99, 0x30, 0x0, 0xb, 0xa0, 0x0,
    0x0, 0x0, 0xb, 0xa0, 0x0, 0x0, 0x0, 0xb,
    0xa0, 0x0, 0x0, 0x0, 0xb, 0xa0, 0x0, 0x0,
    0x0, 0xb, 0xa0, 0x0, 0x0, 0x0, 0xb, 0xa0,
    0x0, 0x0, 0x0, 0xa, 0xa0, 0x0, 0x10, 0x0,
    0x9, 0xb0, 0x0, 0x71, 0x0, 0x4, 0xf2, 0x2,
    0x80, 0x0, 0x0, 0x7d, 0xd9, 0x0,

    /* U+75 "u" */
    0x3b, 0xf4, 0x0, 0x8, 0xed, 0x0, 0x0, 0xf4,
    0x0, 0x0, 0x8d, 0x0, 0x0, 0xf4, 0x0, 0x0,
    0x7d, 0x0, 0x0, 0xf4, 0x0, 0x0, 0x7d, 0x0,
    0x0, 0xf4, 0x0, 0x0, 0x7d, 0x0, 0x0, 0xf4,
    0x0, 0x0, 0x7d, 0x0, 0x0, 0xf4, 0x0, 0x0,
    0x7d, 0x0, 0x0, 0xf4, 0x0, 0x0, 0x7d, 0x0,
    0x0, 0xe6, 0x0, 0x0, 0xbd, 0x0, 0x0, 0xad,
    0x20, 0x19, 0xce, 0x0, 0x0, 0x1a, 0xee, 0xc5,
    0x7d, 0x92,

    /* U+76 "v" */
    0x1a, 0xff, 0x80, 0x3, 0xdf, 0x90, 0xa, 0xc0,
    0x0, 0x6, 0x80, 0x0, 0x4f, 0x10, 0x0, 0xa1,
    0x0, 0x0, 0xf6, 0x0, 0xa, 0x0, 0x0, 0xa,
    0xb0, 0x5, 0x60, 0x0, 0x0, 0x4f, 0x10, 0xa0,
    0x0, 0x0, 0x0, 0xf6, 0xa, 0x0, 0x0, 0x0,
    0xa, 0xb5, 0x50, 0x0, 0x0, 0x0, 0x4f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xa, 0x40, 0x0, 0x0,

    /* U+77 "w" */
    0x9f, 0xe4, 0x6f, 0xe4, 0x2b, 0xf8, 0xb, 0xa0,
    0x9, 0xc0, 0x3, 0x80, 0x7, 0xc0, 0x6, 0xe0,
    0x6, 0x30, 0x3, 0xf0, 0x9, 0xf1, 0x9, 0x0,
    0x0, 0xf3, 0x9, 0xe5, 0xa, 0x0, 0x0, 0xc6,
    0x17, 0xa8, 0x18, 0x0, 0x0, 0x8a, 0x53, 0x7c,
    0x54, 0x0, 0x0, 0x4d, 0x80, 0x3f, 0x90, 0x0,
    0x0, 0xf, 0xa0, 0xf, 0xb0, 0x0, 0x0, 0xc,
    0x70, 0xc, 0x80, 0x0, 0x0, 0x8, 0x30, 0x8,
    0x40, 0x0,

    /* U+78 "x" */
    0x5, 0xcf, 0xd3, 0x9, 0xfc, 0x50, 0x0, 0xdb,
    0x0, 0x1c, 0x0, 0x0, 0x4, 0xf5, 0xb, 0x30,
    0x0, 0x0, 0xa, 0xe7, 0x80, 0x0, 0x0, 0x0,
    0x2f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xbe, 0x10,
    0x0, 0x0, 0x0, 0x4a, 0xd9, 0x0, 0x0, 0x0,
    0xc, 0x14, 0xf2, 0x0, 0x0, 0x8, 0x50, 0xa,
    0xb0, 0x0, 0x2, 0xb0, 0x0, 0x2f, 0x50, 0x19,
    0xee, 0x40, 0x19, 0xff, 0x90,

    /* U+79 "y" */
    0x9f, 0xf9, 0x0, 0x7e, 0xf9, 0x10, 0x7f, 0x0,
    0x0, 0x96, 0x0, 0x1, 0xf4, 0x0, 0xc, 0x0,
    0x0, 0xa, 0xa0, 0x2, 0xa0, 0x0, 0x0, 0x4f,
    0x0, 0x84, 0x0, 0x0, 0x0, 0xe5, 0xc, 0x0,
    0x0, 0x0, 0x8, 0xa2, 0x90, 0x0, 0x0, 0x0,
    0x2f, 0x84, 0x0, 0x0, 0x0, 0x0, 0xce, 0x0,
    0x0, 0x0, 0x0, 0x6, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x84, 0x0, 0x0, 0x0, 0x0, 0xb, 0x0,
    0x0, 0x0, 0x1b, 0x57, 0x60, 0x0, 0x0, 0x2,
    0xee, 0x70, 0x0, 0x0, 0x0,

    /* U+7A "z" */
    0xf, 0xe9, 0x99, 0x9f, 0x90, 0x1e, 0x10, 0x0,
    0x8e, 0x10, 0x38, 0x0, 0x3, 0xf5, 0x0, 0x12,
    0x0, 0xd, 0xa0, 0x0, 0x0, 0x0, 0x7e, 0x10,
    0x0, 0x0, 0x2, 0xf6, 0x0, 0x0, 0x0, 0xc,
    0xb0, 0x0, 0x0, 0x0, 0x7f, 0x20, 0x0, 0x53,
    0x2, 0xf7, 0x0, 0x0, 0xb1, 0xb, 0xc0, 0x0,
    0x4, 0xe0, 0x5f, 0xb9, 0x99, 0xbf, 0xb0,

    /* U+7B "{" */
    0x0, 0x6, 0xa2, 0x0, 0x79, 0x0, 0x0, 0xc1,
    0x0, 0x0, 0xd0, 0x0, 0x0, 0xd0, 0x0, 0x0,
    0xd0, 0x0, 0x0, 0xd0, 0x0, 0x0, 0xd0, 0x0,
    0x0, 0xd0, 0x0, 0x6, 0x80, 0x0, 0xb8, 0x0,
    0x0, 0x6, 0x80, 0x0, 0x0, 0xd0, 0x0, 0x0,
    0xd0, 0x0, 0x0, 0xd0, 0x0, 0x0, 0xd0, 0x0,
    0x0, 0xd0, 0x0, 0x0, 0xd0, 0x0, 0x0, 0xc1,
    0x0, 0x0, 0x79, 0x0, 0x0, 0x6, 0xa2,

    /* U+7C "|" */
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,

    /* U+7D "}" */
    0x2a, 0x60, 0x0, 0x0, 0x87, 0x0, 0x0, 0x1c,
    0x0, 0x0, 0xd, 0x0, 0x0, 0xd, 0x0, 0x0,
    0xd, 0x0, 0x0, 0xd, 0x0, 0x0, 0xd, 0x0,
    0x0, 0xd, 0x0, 0x0, 0x8, 0x70, 0x0, 0x0,
    0x8b, 0x0, 0x8, 0x60, 0x0, 0xd, 0x0, 0x0,
    0xd, 0x0, 0x0, 0xd, 0x0, 0x0, 0xd, 0x0,
    0x0, 0xd, 0x0, 0x0, 0xd, 0x0, 0x0, 0x1c,
    0x0, 0x0, 0x87, 0x0, 0x2a, 0x60, 0x0,

    /* U+7E "~" */
    0x0, 0x6c, 0xb2, 0x0, 0x0, 0x0, 0x5, 0x50,
    0x8e, 0x10, 0x0, 0x31, 0x8, 0x0, 0x9, 0xc0,
    0x0, 0x80, 0x5, 0x0, 0x0, 0xbc, 0x13, 0x70,
    0x0, 0x0, 0x0, 0x9, 0xd9, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x7b, 0xe8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x49, 0xdf, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x16, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x8c, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x3a,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xaf, 0xff,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd8, 0x30, 0xf, 0xff, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xfb, 0x62, 0x0, 0x0, 0xf, 0xff,
    0x0, 0x0, 0x0, 0xff, 0xfe, 0x94, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0x0, 0x0, 0x0, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0x0, 0x0, 0x0, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0x0, 0x0, 0x0, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0x0, 0x0, 0x0, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0x0, 0x0, 0x0, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0x0, 0x0, 0x0, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x3a, 0xdf, 0xef, 0xff, 0x0, 0x0, 0x0, 0xff,
    0xf0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xff, 0xf0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xff, 0x3, 0xad, 0xfe, 0xff,
    0xf0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xfe,
    0x6f, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xf6, 0xef, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x3a, 0xef, 0xea, 0x30,
    0xef, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xae, 0xfe, 0xa3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0xb7, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x7b, 0xfd, 0x88, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x88, 0xdf,
    0xff, 0xff, 0xff, 0xb4, 0x44, 0x44, 0x44, 0x44,
    0x5f, 0xff, 0xff, 0xff, 0xf9, 0x0, 0xcf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf5, 0x0, 0x9f,
    0xf8, 0x0, 0xbf, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf4, 0x0, 0x8f, 0xf9, 0x0, 0xcf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf5, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xfd, 0x88, 0xef, 0xa2,
    0x22, 0x22, 0x22, 0x22, 0x3f, 0xfb, 0x88, 0xdf,
    0xf8, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x8f, 0xf8, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x8f,
    0xfd, 0x88, 0xef, 0xa2, 0x22, 0x22, 0x22, 0x22,
    0x3f, 0xfb, 0x88, 0xdf, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0xcf, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf5, 0x0, 0x9f, 0xf8, 0x0, 0xbf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf4, 0x0, 0x8f,
    0xf9, 0x0, 0xcf, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf5, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xb4,
    0x44, 0x44, 0x44, 0x44, 0x5f, 0xff, 0xff, 0xff,
    0xfd, 0x88, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x88, 0xdf, 0xb7, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x7b,

    /* U+F00B "" */
    0x14, 0x44, 0x44, 0x10, 0x3, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x41, 0xef, 0xff, 0xff, 0xe0,
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x7b, 0xbb, 0xbb, 0x60, 0x2a, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xb7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xb0, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xb0,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x14, 0x44, 0x44, 0x10,
    0x3, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x41,
    0xef, 0xff, 0xff, 0xe0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x7b, 0xbb, 0xbb, 0x60,
    0x2a, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb7,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbd, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xfd, 0x10,
    0x2, 0xdb, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xd1, 0x0, 0x2e, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0xdf, 0xff, 0xfc, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xc0,
    0x0, 0xc, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xfc, 0x0, 0xcf, 0xff, 0xff,
    0xd1, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xff,
    0xcc, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xff, 0xff, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xcc, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x1, 0x41, 0x0, 0x0, 0x0, 0x0, 0x3, 0x30,
    0x1, 0xdf, 0xd2, 0x0, 0x0, 0x0, 0x7, 0xff,
    0x70, 0xcf, 0xff, 0xe2, 0x0, 0x0, 0x8, 0xff,
    0xff, 0x4e, 0xff, 0xff, 0xe2, 0x0, 0x8, 0xff,
    0xff, 0xf6, 0x4f, 0xff, 0xff, 0xe2, 0x8, 0xff,
    0xff, 0xfb, 0x0, 0x4f, 0xff, 0xff, 0xe9, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x8, 0xff,
    0xff, 0xfb, 0x5f, 0xff, 0xff, 0xe2, 0x7, 0xff,
    0xff, 0xfb, 0x0, 0x4f, 0xff, 0xff, 0xe1, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x4f, 0xff, 0xff, 0x7a,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf3,
    0xb, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf4,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0x60, 0x0, 0xef, 0xfd, 0x0,
    0x7, 0x70, 0x0, 0x0, 0x0, 0x1, 0xcf, 0xf3,
    0x0, 0xef, 0xfd, 0x0, 0x5f, 0xfb, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xfb, 0x0, 0xef, 0xfd, 0x0,
    0xcf, 0xff, 0xb0, 0x0, 0x0, 0x9f, 0xff, 0xf6,
    0x0, 0xef, 0xfd, 0x0, 0x7f, 0xff, 0xf7, 0x0,
    0x3, 0xff, 0xff, 0x60, 0x0, 0xef, 0xfd, 0x0,
    0x8, 0xff, 0xff, 0x20, 0xa, 0xff, 0xf9, 0x0,
    0x0, 0xef, 0xfd, 0x0, 0x0, 0xbf, 0xff, 0x90,
    0x1f, 0xff, 0xe0, 0x0, 0x0, 0xef, 0xfd, 0x0,
    0x0, 0x1f, 0xff, 0xf0, 0x5f, 0xff, 0x90, 0x0,
    0x0, 0xef, 0xfd, 0x0, 0x0, 0xa, 0xff, 0xf3,
    0x8f, 0xff, 0x40, 0x0, 0x0, 0xef, 0xfd, 0x0,
    0x0, 0x6, 0xff, 0xf6, 0x9f, 0xff, 0x20, 0x0,
    0x0, 0xef, 0xfd, 0x0, 0x0, 0x4, 0xff, 0xf8,
    0x9f, 0xff, 0x20, 0x0, 0x0, 0xef, 0xfc, 0x0,
    0x0, 0x4, 0xff, 0xf7, 0x8f, 0xff, 0x40, 0x0,
    0x0, 0x37, 0x72, 0x0, 0x0, 0x6, 0xff, 0xf6,
    0x5f, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xf4, 0x1f, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xf0,
    0xb, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xa0, 0x3, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0x20,
    0x0, 0xaf, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x1,
    0x9f, 0xff, 0xf8, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xe8, 0x42, 0x24, 0x9e, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x10, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3b, 0xff, 0xff, 0xff, 0xff,
    0xb3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x15, 0x89, 0x97, 0x51, 0x0, 0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x0, 0x4, 0x89, 0x98, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xc3, 0x2c, 0xff, 0xff, 0xff, 0xff,
    0xc2, 0x3c, 0xc0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0x94, 0x49, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x6, 0xef, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xfe, 0x60,
    0x0, 0x1e, 0xff, 0xff, 0x90, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xe1, 0x0, 0x0, 0xf, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x4, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0x40, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xf0, 0x0, 0x0, 0x1e, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x9, 0xff, 0xff, 0xe1, 0x0,
    0x6, 0xef, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x4f,
    0xff, 0xff, 0xfe, 0x60, 0xf, 0xff, 0xff, 0xff,
    0xff, 0x94, 0x49, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0x3, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0xc, 0xc3, 0x2c,
    0xff, 0xff, 0xff, 0xff, 0xc2, 0x3c, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x89, 0x98, 0x40, 0x0, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x13, 0x10,
    0x0, 0x2, 0x44, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xfe, 0x40, 0x0, 0xdf,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0x70, 0xe, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xa0, 0xef, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xb3, 0xbf, 0xff, 0xce,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xef,
    0xff, 0x90, 0x0, 0x9f, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0x60, 0x5d,
    0x50, 0x6f, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xfe, 0x30, 0x8f, 0xff, 0x70, 0x4e,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x1b, 0xff, 0xfd,
    0x20, 0xaf, 0xff, 0xff, 0xa0, 0x2d, 0xff, 0xfb,
    0x0, 0x0, 0x2d, 0xff, 0xfb, 0x1, 0xcf, 0xff,
    0xff, 0xff, 0xc1, 0xb, 0xff, 0xfd, 0x20, 0x4f,
    0xff, 0xf8, 0x3, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xe3, 0x8, 0xff, 0xfe, 0x4e, 0xff, 0xf5, 0x5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x5,
    0xff, 0xfe, 0x4f, 0xe3, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x3, 0xef, 0x40,
    0x41, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x1, 0x40, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xeb, 0xbb, 0xef, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xf4, 0x0, 0x4,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0x40, 0x0, 0x4f, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf4, 0x0, 0x4, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x4f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xf3, 0x0, 0x3, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x3, 0xbb, 0xbb,
    0xba, 0x10, 0x0, 0x1a, 0xbb, 0xbb, 0xb3, 0x0,
    0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x0, 0x9, 0xdd, 0xdd, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad, 0xdd,
    0xdf, 0xff, 0xff, 0xfd, 0xdd, 0xda, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xff, 0xff, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xfd,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x25, 0x55, 0x55, 0x55, 0x11, 0xdf, 0xfd, 0x11,
    0x55, 0x55, 0x55, 0x52, 0xef, 0xff, 0xff, 0xff,
    0xd1, 0x1d, 0xd1, 0x1d, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x1, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x71, 0xe7, 0x1e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb6, 0xfb, 0x6f, 0xff, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+F01C "" */
    0x0, 0x0, 0x3, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0x50, 0x0, 0x0, 0x1e,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xfe, 0x10, 0x0, 0xa, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xfa,
    0x0, 0x5, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xf5, 0x1, 0xef,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xe1, 0xaf, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x2f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd3, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd3,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x32, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x67, 0x75, 0x20, 0x0, 0x0, 0x4f, 0xff,
    0x0, 0x0, 0x0, 0x29, 0xff, 0xff, 0xff, 0xfd,
    0x70, 0x0, 0x4f, 0xff, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x3f, 0xff,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xfe, 0xef, 0xff,
    0xff, 0xfb, 0x3f, 0xff, 0x0, 0xd, 0xff, 0xff,
    0xb4, 0x0, 0x0, 0x5b, 0xff, 0xff, 0xdf, 0xff,
    0x0, 0xaf, 0xff, 0xe4, 0x0, 0x0, 0x0, 0x0,
    0x4d, 0xff, 0xff, 0xff, 0x4, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xc, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xee, 0xef, 0xff, 0xff, 0x1f, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x5f, 0xff, 0x10, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x4, 0x43, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x44, 0x44, 0x44, 0x44, 0x43,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x34, 0x44, 0x44, 0x44, 0x44, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x34, 0x40, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x1, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xf1, 0xff, 0xff, 0xfd, 0xee,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xb0,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xdf, 0xff, 0x40, 0xff, 0xff, 0xff, 0xd3,
    0x0, 0x0, 0x0, 0x0, 0x4e, 0xff, 0xfa, 0x0,
    0xff, 0xfe, 0xff, 0xff, 0xb5, 0x0, 0x0, 0x4b,
    0xff, 0xff, 0xd0, 0x0, 0xff, 0xf3, 0xbf, 0xff,
    0xff, 0xfe, 0xef, 0xff, 0xff, 0xfc, 0x10, 0x0,
    0xff, 0xf3, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0xff, 0xf4, 0x0, 0x17,
    0xdf, 0xff, 0xff, 0xff, 0xa2, 0x0, 0x0, 0x0,
    0xff, 0xf4, 0x0, 0x0, 0x2, 0x67, 0x76, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x23, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xa7, 0x0, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0x0, 0x0, 0x0, 0x1,
    0xcf, 0xff, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xff,
    0x14, 0x44, 0x44, 0xcf, 0xff, 0xff, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7b, 0xbb,
    0xbb, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x13, 0x33, 0x33, 0xcf,
    0xff, 0xff, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x4a, 0x20, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xcf, 0xe1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x3e, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x6,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x5, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x2e, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xcf, 0xf2, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x5b, 0x30, 0x7c, 0xcc, 0xcc,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x21,
    0x0, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1a, 0x70, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0x0, 0x0, 0x6, 0x30,
    0x5, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x1c,
    0xff, 0xf0, 0x0, 0x3, 0xff, 0x70, 0x8, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xff, 0x0,
    0x0, 0xc, 0xff, 0x70, 0xc, 0xfc, 0x1, 0x44,
    0x44, 0x4c, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xa,
    0xff, 0x30, 0x4f, 0xf3, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x5a, 0x20, 0xc, 0xfb, 0x0,
    0xdf, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xc, 0xfe, 0x20, 0x4f, 0xf1, 0x8, 0xfb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x2e, 0xfa,
    0x0, 0xff, 0x50, 0x5f, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0x6f, 0xe0, 0xc, 0xf7,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x6, 0xfe, 0x0, 0xcf, 0x70, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x2, 0xef,
    0xa0, 0xf, 0xf5, 0x6, 0xfe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xcf, 0xe2, 0x4, 0xff,
    0x10, 0x9f, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x4, 0xa2, 0x0, 0xcf, 0xb0, 0xd, 0xf8,
    0x7b, 0xbb, 0xbb, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0xaf, 0xf3, 0x4, 0xff, 0x30, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xcf, 0xf7,
    0x0, 0xcf, 0xc0, 0x0, 0x0, 0x0, 0x5, 0xff,
    0xff, 0x0, 0x0, 0x3f, 0xf7, 0x0, 0x6f, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xf0, 0x0,
    0x0, 0x53, 0x0, 0x4f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xfb, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x0, 0x0, 0x0,

    /* U+F03E "" */
    0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd3, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xca, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x1d,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0, 0x2,
    0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xe1, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf4,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x42, 0x8f,
    0xff, 0xff, 0xff, 0x40, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6b,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0xbf, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0x40, 0x0,
    0xb, 0x40, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x3d, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd3,

    /* U+F048 "" */
    0x34, 0x40, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x1d, 0xfb, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x2d, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8e, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0x1d, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x1c, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xea, 0xbb, 0x30,
    0x0, 0x0, 0x0, 0x5, 0xb4,

    /* U+F04B "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xdf, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xe6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xfc, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xa2, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb2, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe5, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x20, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xfa, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xfe, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3d, 0xf9, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F04C "" */
    0x19, 0xcc, 0xcc, 0xc9, 0x10, 0x0, 0x19, 0xcc,
    0xcc, 0xc9, 0x1b, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xfe, 0x5f, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0x50, 0x13, 0x33, 0x33,
    0x10, 0x0, 0x0, 0x13, 0x33, 0x33, 0x10,

    /* U+F04D "" */
    0x1, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x41, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb1, 0x8b, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x81,

    /* U+F051 "" */
    0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x44, 0x3b,
    0xfd, 0x10, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xff,
    0xfd, 0x20, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xfe, 0x30, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x16, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x6, 0xff, 0xff,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xef, 0xf6,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xf4, 0xb5, 0x0,
    0x0, 0x0, 0x0, 0x3b, 0xba,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x37, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x3d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x4b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0x40,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0x80, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xa, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0,

    /* U+F054 "" */
    0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x43, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd1, 0x77, 0x77, 0x77, 0x7d, 0xff, 0xfd, 0x77,
    0x77, 0x77, 0x71, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xab, 0xa2, 0x0, 0x0, 0x0, 0x0,

    /* U+F068 "" */
    0x16, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x76, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x0, 0x16, 0xad, 0xef, 0xed,
    0xa6, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xe9, 0x54, 0x59, 0xef, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x2d, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xfd, 0x20, 0x0, 0x0, 0x2e,
    0xff, 0xff, 0x70, 0x0, 0x14, 0x20, 0x0, 0x7f,
    0xff, 0xfe, 0x20, 0x0, 0x1e, 0xff, 0xff, 0xb0,
    0x0, 0x6, 0xff, 0xc2, 0x0, 0xbf, 0xff, 0xfe,
    0x10, 0xb, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x5f,
    0xff, 0xe2, 0x3, 0xff, 0xff, 0xfb, 0x6, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x1c, 0xff, 0xff, 0xa0,
    0xe, 0xff, 0xff, 0xf5, 0xef, 0xff, 0xff, 0xc0,
    0xd, 0xcf, 0xff, 0xff, 0xfe, 0x0, 0xcf, 0xff,
    0xff, 0xee, 0xff, 0xff, 0xfc, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xc, 0xff, 0xff, 0xfe, 0x5f,
    0xff, 0xff, 0xe0, 0xc, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0xef, 0xff, 0xff, 0x50, 0xbf, 0xff, 0xff,
    0x30, 0x4f, 0xff, 0xff, 0xff, 0x50, 0x3f, 0xff,
    0xff, 0xb0, 0x1, 0xdf, 0xff, 0xfb, 0x0, 0x7f,
    0xff, 0xff, 0x80, 0xb, 0xff, 0xff, 0xe1, 0x0,
    0x2, 0xef, 0xff, 0xf7, 0x0, 0x39, 0xb9, 0x30,
    0x7, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x2, 0xcf,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xfe,
    0x95, 0x45, 0x9e, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2a, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x6a, 0xdf, 0xfe, 0xda, 0x71, 0x0,
    0x0, 0x0, 0x0,

    /* U+F070 "" */
    0x5, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xff, 0xfc, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xfe, 0x40, 0x0, 0x48, 0xce, 0xff, 0xeb,
    0x72, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0x88, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xef, 0xff, 0xff, 0xff, 0xb6, 0x45, 0x7d, 0xff,
    0xff, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xbf, 0xff, 0xfd, 0x20, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xe4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xf6, 0x1, 0x76, 0x20, 0x4, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x4e, 0xff, 0xfa, 0x1f, 0xff, 0x90, 0x8, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x6e, 0x40, 0x0,
    0x2c, 0xff, 0xfd, 0xff, 0xff, 0x80, 0xf, 0xff,
    0xff, 0xe1, 0x0, 0x0, 0x2f, 0xff, 0x70, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0x0, 0xbf, 0xff,
    0xff, 0x90, 0x0, 0x9, 0xff, 0xff, 0xb1, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xf3, 0x9, 0xff, 0xff,
    0xff, 0x10, 0x0, 0x9f, 0xff, 0xff, 0xd1, 0x0,
    0x3, 0xdf, 0xff, 0xff, 0x30, 0x9f, 0xff, 0xff,
    0xf1, 0x0, 0x2, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x1, 0xbf, 0xff, 0xf4, 0xb, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xf7, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x4e, 0xff, 0xff, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x1c, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xc2, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xfb, 0x64, 0x51,
    0x0, 0x5, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x9f, 0xff, 0xff, 0xff, 0xe3,
    0x0, 0x2, 0xdf, 0xff, 0xc1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0x9d, 0xef, 0xfe, 0xa1,
    0x0, 0x0, 0xaf, 0xff, 0xe4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1b, 0xc0,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 0xfc,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xff, 0xff,
    0xff, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xa4, 0x44, 0xaf, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xf7, 0x0, 0x7, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xff, 0x80,
    0x0, 0x8f, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xf9, 0x0, 0x9,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xa0, 0x0, 0xaf, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xfb, 0x0, 0xb, 0xff, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff,
    0xff, 0xc0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0x30,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x2d, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x26, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x3d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x30,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x69, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xfc, 0x0, 0x9b, 0xbb, 0xbb, 0x30,
    0x0, 0x0, 0x0, 0x3b, 0xbb, 0xff, 0xff, 0xc0,
    0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xe1, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xe3, 0x0, 0x0, 0x3e, 0xff,
    0xe2, 0xc, 0xff, 0xfe, 0x20, 0xff, 0xfe, 0x30,
    0x0, 0x0, 0x3, 0xff, 0x30, 0xaf, 0xff, 0xf3,
    0x0, 0xff, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x54,
    0x9, 0xff, 0xff, 0x40, 0x0, 0xbe, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xf9, 0x4, 0x50,
    0x0, 0xbe, 0x30, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xa0, 0x3f, 0xf3, 0x0, 0xff, 0xe3, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xfc, 0x2, 0xef, 0xfe,
    0x30, 0xff, 0xfe, 0x30, 0xff, 0xff, 0xff, 0xff,
    0xd1, 0x1, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe3,
    0xff, 0xff, 0xff, 0xfe, 0x10, 0x0, 0x2e, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x9b, 0xbb, 0xbb, 0x30, 0x0, 0x0, 0x0, 0x3b,
    0xbb, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x69, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xfd, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xf9, 0xa, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xf9, 0x0, 0xa,
    0xff, 0xff, 0x90, 0x0, 0x0, 0xaf, 0xff, 0xf9,
    0x0, 0x0, 0xa, 0xff, 0xff, 0x90, 0x0, 0xaf,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff,
    0x90, 0x9f, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0x79, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xff, 0xf8, 0xb, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xfa,
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x0,

    /* U+F078 "" */
    0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x20, 0x0, 0xbf, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xa0, 0x9f, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0x89,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xf7, 0xa, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xf9, 0x0, 0xa, 0xff, 0xff,
    0x90, 0x0, 0x0, 0xaf, 0xff, 0xf9, 0x0, 0x0,
    0xa, 0xff, 0xff, 0x90, 0x0, 0xaf, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0x90, 0xaf,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xdf, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x3, 0xd9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xef, 0xfa, 0x0, 0x0, 0x34, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x10, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xff, 0xfa, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x3,
    0xef, 0xff, 0xff, 0xfa, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x5, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbf, 0xff, 0x10, 0x0, 0x0, 0xef, 0xfe,
    0xdf, 0xfb, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xf1, 0x0, 0x0, 0xd, 0xfe, 0x2b,
    0xff, 0x48, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0x10, 0x0, 0x0, 0x17, 0x20, 0xbf,
    0xf4, 0x5, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x70, 0xef, 0xf1,
    0x4f, 0xc0, 0x0, 0x0, 0xb, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0x6e, 0xff, 0x5f,
    0xff, 0x60, 0x0, 0x0, 0xbf, 0xf7, 0x44, 0x44,
    0x44, 0x44, 0x20, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xd1, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x50, 0xbf, 0xff, 0xff, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0xbf, 0xff, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x4, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0x60, 0x0, 0xbf, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0,

    /* U+F07B "" */
    0x3d, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x3d, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd3,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x2, 0x22,
    0x2f, 0xff, 0xff, 0xf2, 0x22, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x25, 0x55, 0x55, 0x52, 0xf, 0xff, 0xff, 0xf0,
    0x25, 0x55, 0x55, 0x52, 0xef, 0xff, 0xff, 0xf9,
    0xc, 0xff, 0xff, 0xc0, 0x9f, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x1, 0x10, 0x2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x88, 0x88, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x71, 0xe7, 0x1e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb6, 0xfb, 0x6f, 0xff, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xea, 0x63,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x1, 0x40,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x3a, 0xff, 0xa0, 0x0, 0x1, 0xbf,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x5, 0xcf, 0xff,
    0xff, 0x70, 0x3, 0xdf, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0x6a, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xfc, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfe, 0xc9,
    0x62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F0C4 "" */
    0x0, 0x2, 0x42, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xcf, 0xff, 0xc2, 0x0,
    0x0, 0x0, 0x0, 0x37, 0x73, 0x0, 0x2e, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x8, 0xff, 0xff,
    0x90, 0xaf, 0xff, 0xcf, 0xff, 0xa0, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0xb0, 0xef, 0xf4, 0x4, 0xff,
    0xe0, 0x0, 0x9, 0xff, 0xff, 0xfb, 0x0, 0xff,
    0xf1, 0x1, 0xff, 0xf0, 0x0, 0x9f, 0xff, 0xff,
    0xb0, 0x0, 0xcf, 0xfb, 0x5b, 0xff, 0xc0, 0x9,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xf5, 0x9f, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x39, 0xbe, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x49, 0xff,
    0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x2,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xfb, 0xef,
    0xff, 0xff, 0x50, 0x0, 0x0, 0xaf, 0xff, 0xcf,
    0xff, 0xd0, 0x2e, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0xef, 0xf4, 0x4, 0xff, 0xe0, 0x2, 0xef, 0xff,
    0xff, 0x50, 0x0, 0xff, 0xf1, 0x1, 0xff, 0xf0,
    0x0, 0x2e, 0xff, 0xff, 0xf5, 0x0, 0xcf, 0xfb,
    0x5b, 0xff, 0xc0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0x50, 0x5f, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x2e, 0xff, 0xff, 0xd0, 0x8, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x1, 0xae, 0xea, 0x20, 0x0,
    0x39, 0xb9, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf0,
    0x7a, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0x8, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x8f, 0xfb, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0x8,
    0xff, 0xfa, 0x47, 0x88, 0x40, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x48, 0x88, 0x7f, 0xff, 0xf8, 0xf,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x4, 0x78, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x74, 0xff, 0xff, 0xfa, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0x0, 0x0,

    /* U+F0C7 "" */
    0x1, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xf,
    0xff, 0xcb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbd, 0xff,
    0xf8, 0x0, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xf8, 0xf, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xf7, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xef, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0x54, 0x44, 0x44, 0x44, 0x44, 0x45, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0xce, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x57, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb1, 0x8b, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x81,

    /* U+F0E7 "" */
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xc8, 0x88, 0x87, 0x30, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xa0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x37,
    0x88, 0x88, 0xaf, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x0, 0x3, 0xdf, 0xd3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0x78, 0x88, 0xff, 0xef, 0xf8,
    0x88, 0x74, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0x90, 0x9f, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xf9, 0x9, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xf4, 0x7, 0x88, 0x88,
    0x88, 0x3, 0x30, 0x0, 0xff, 0xff, 0xff, 0x7,
    0xff, 0xff, 0xff, 0xf0, 0x8f, 0x40, 0xf, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0x8, 0xff,
    0x40, 0xff, 0xff, 0xff, 0x8, 0xff, 0xff, 0xff,
    0xf0, 0x8f, 0xff, 0x4f, 0xff, 0xff, 0xf0, 0x8f,
    0xff, 0xff, 0xff, 0x8, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0x8, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff,
    0xb8, 0x88, 0x88, 0xff, 0xff, 0xff, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x78, 0x88, 0x80, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x6f, 0xff, 0x51, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x4f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x3d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2,
    0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x72, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xcf, 0xc3,
    0x0, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x3d, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x10, 0x1f, 0x90, 0x9, 0xf1, 0x1,
    0xf9, 0x0, 0x9f, 0x10, 0x1f, 0xff, 0xff, 0xf0,
    0x0, 0xf8, 0x0, 0x8f, 0x0, 0xf, 0x80, 0x8,
    0xf0, 0x0, 0xff, 0xff, 0xff, 0x10, 0x1f, 0x90,
    0x9, 0xf1, 0x1, 0xf9, 0x0, 0x9f, 0x10, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb8, 0x8f, 0xe8, 0x8b, 0xfb, 0x88, 0xfe,
    0x88, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0xcc, 0x0, 0x4f, 0x40, 0xc, 0xc0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x40, 0xc, 0xc0, 0x4,
    0xf4, 0x0, 0xcc, 0x0, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x88, 0xfe, 0x88, 0xbf, 0xb8, 0x8f,
    0xe8, 0x8b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x1, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x1, 0xff, 0xff,
    0xff, 0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0x0, 0xf, 0xff, 0xff, 0xf1, 0x1,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd3, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd3,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3a,
    0xfc, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4b, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5c,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6e, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x8e,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x3, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x4, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x6, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x3, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0xd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x57,
    0x88, 0x88, 0x88, 0x8c, 0xff, 0xff, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xd3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F15B "" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0x80, 0xe4, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xff,
    0x40, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0xff, 0xf4, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xff, 0xff, 0x40, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x88, 0x88, 0x88,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x56, 0x77, 0x65,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc7, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x50, 0x0, 0x0, 0x0, 0x3, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x30, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xc9, 0x65, 0x44, 0x56, 0x9c, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x1c, 0xff, 0xff, 0xfd, 0x61, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x16, 0xdf, 0xff, 0xff,
    0xc1, 0xdf, 0xff, 0xfe, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xef, 0xff, 0xfd,
    0x9f, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xf9, 0x9,
    0xf6, 0x0, 0x0, 0x0, 0x48, 0xcd, 0xff, 0xdc,
    0x84, 0x0, 0x0, 0x0, 0x6f, 0x90, 0x0, 0x10,
    0x0, 0x0, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe6, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xfe, 0xcc, 0xef, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xc5, 0x10, 0x0, 0x1, 0x5c, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xe4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4e, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x32,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xc1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xaa, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F240 "" */
    0x1, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x30, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0xff, 0xfb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbd, 0xff, 0xa1, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xfe, 0xff, 0xf0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8,
    0xff, 0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5, 0xbf,
    0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xf, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xf, 0xff, 0xff,
    0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x2, 0x4f, 0xff, 0xff, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x8, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x4a, 0xff, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x18, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xa4, 0x0,

    /* U+F241 "" */
    0x1, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x30, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0xff, 0xfb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbd, 0xff, 0xa1, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xfe, 0xff, 0xf0, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xf0, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x5, 0xbf,
    0xff, 0xff, 0xf0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xf0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x2, 0x4f, 0xff, 0xff, 0xf0,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x4a, 0xff, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x18, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xa4, 0x0,

    /* U+F242 "" */
    0x1, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x30, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0xff, 0xfb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbd, 0xff, 0xa1, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xfe, 0xff, 0xf0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xbf,
    0xff, 0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x4f, 0xff, 0xff, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x4a, 0xff, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x18, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xa4, 0x0,

    /* U+F243 "" */
    0x1, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x30, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0xff, 0xfb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbd, 0xff, 0xa1, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xfe, 0xff, 0xf0, 0xbf, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xf0, 0xbf, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xbf,
    0xff, 0xff, 0xf0, 0xbf, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf0, 0xbf, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xf0, 0xbf, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x4f, 0xff, 0xff, 0xf0,
    0xbf, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x4a, 0xff, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x18, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xa4, 0x0,

    /* U+F244 "" */
    0x1, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x30, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0xff, 0xfb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbd, 0xff, 0xa1, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xfe, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xbf,
    0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x4f, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x4a, 0xff, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x18, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xa4, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d,
    0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x27, 0x7d, 0xff,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf5, 0x3a, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf6, 0x0, 0x9, 0xda, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0,
    0x0, 0x0, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xfe, 0x50,
    0x0, 0x6f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa4, 0x0, 0x0, 0x8f, 0xff, 0xff, 0x30,
    0x1e, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xfa, 0x10, 0xe, 0xff, 0xff, 0xfd, 0xbe,
    0xfe, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xff, 0xff, 0x60, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0xa, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x1c, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xd4, 0x0, 0x1c, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x2f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x70,
    0x0, 0x0, 0x4, 0x63, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xfb, 0x0, 0x8f, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf8, 0x4b, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x5c, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x11, 0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x2, 0x8c, 0xef, 0xfe, 0xa6, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x30, 0x0, 0x0, 0xc, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0x40, 0x0, 0xa, 0xff, 0xff,
    0xff, 0x5, 0xff, 0xff, 0xfe, 0x10, 0x2, 0xff,
    0xff, 0xff, 0xf0, 0x5, 0xff, 0xff, 0xf8, 0x0,
    0x9f, 0xff, 0xff, 0xff, 0x0, 0x6, 0xff, 0xff,
    0xe0, 0xe, 0xff, 0xfc, 0xff, 0xf0, 0x16, 0x7,
    0xff, 0xff, 0x21, 0xff, 0xf8, 0x9, 0xff, 0x1,
    0xf6, 0x7, 0xff, 0xf5, 0x4f, 0xff, 0xd1, 0x9,
    0xf0, 0x1f, 0x70, 0x6f, 0xff, 0x86, 0xff, 0xff,
    0xd1, 0x7, 0x1, 0x70, 0x5f, 0xff, 0xf9, 0x7f,
    0xff, 0xff, 0xd1, 0x0, 0x0, 0x3f, 0xff, 0xff,
    0xa7, 0xff, 0xff, 0xff, 0xc1, 0x0, 0x2e, 0xff,
    0xff, 0xfb, 0x7f, 0xff, 0xff, 0xff, 0x30, 0x5,
    0xff, 0xff, 0xff, 0xb7, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x6, 0xff, 0xff, 0xfa, 0x6f, 0xff, 0xff,
    0x40, 0x30, 0x3, 0x7, 0xff, 0xff, 0xa4, 0xff,
    0xff, 0x40, 0x4e, 0x1, 0xe2, 0x8, 0xff, 0xf8,
    0x2f, 0xff, 0x70, 0x4f, 0xf0, 0x1f, 0x90, 0x2f,
    0xff, 0x60, 0xef, 0xff, 0x7f, 0xff, 0x1, 0xb0,
    0x2e, 0xff, 0xf3, 0xa, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x2e, 0xff, 0xff, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0x0, 0x2e, 0xff, 0xff, 0x90, 0x0, 0xbf,
    0xff, 0xff, 0xf0, 0x2e, 0xff, 0xff, 0xf2, 0x0,
    0x1, 0xdf, 0xff, 0xff, 0x3e, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x28, 0xce, 0xff,
    0xec, 0x82, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x0, 0x1a, 0xcc, 0xcc, 0xca, 0x10,
    0x0, 0x0, 0x2, 0x44, 0x44, 0x49, 0xff, 0xff,
    0xff, 0xf9, 0x44, 0x44, 0x42, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x9b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x8f,
    0xff, 0x66, 0xff, 0xd1, 0xdf, 0xf6, 0x6f, 0xff,
    0x80, 0x8, 0xff, 0xf4, 0x4f, 0xfc, 0xc, 0xff,
    0x44, 0xff, 0xf8, 0x0, 0x8f, 0xff, 0x44, 0xff,
    0xc0, 0xcf, 0xf4, 0x4f, 0xff, 0x80, 0x8, 0xff,
    0xf4, 0x4f, 0xfc, 0xc, 0xff, 0x44, 0xff, 0xf8,
    0x0, 0x8f, 0xff, 0x44, 0xff, 0xc0, 0xcf, 0xf4,
    0x4f, 0xff, 0x80, 0x8, 0xff, 0xf4, 0x4f, 0xfc,
    0xc, 0xff, 0x44, 0xff, 0xf8, 0x0, 0x8f, 0xff,
    0x44, 0xff, 0xc0, 0xcf, 0xf4, 0x4f, 0xff, 0x80,
    0x8, 0xff, 0xf4, 0x4f, 0xfc, 0xc, 0xff, 0x44,
    0xff, 0xf8, 0x0, 0x8f, 0xff, 0x44, 0xff, 0xc0,
    0xcf, 0xf4, 0x4f, 0xff, 0x80, 0x8, 0xff, 0xf4,
    0x4f, 0xfc, 0xc, 0xff, 0x44, 0xff, 0xf8, 0x0,
    0x8f, 0xff, 0x44, 0xff, 0xc0, 0xcf, 0xf4, 0x4f,
    0xff, 0x80, 0x8, 0xff, 0xf6, 0x6f, 0xfd, 0x1d,
    0xff, 0x66, 0xff, 0xf8, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf9, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6e, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x50, 0x3f, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xb0, 0x3f,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xb0, 0x3f, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xb0, 0x3f, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xb0, 0x3f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xdb, 0xa8, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x0, 0x2, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x80, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x3, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x3e,
    0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x3, 0xef, 0xff,
    0xff, 0xff, 0xf8, 0x6, 0xff, 0xff, 0x60, 0x8f,
    0xff, 0xff, 0xff, 0x0, 0x3e, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0x0, 0x6f, 0xf6, 0x0, 0xc, 0xff,
    0xff, 0xff, 0x3, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x6, 0x60, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xff, 0x3, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x6, 0x60, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0x0, 0x3e, 0xff, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x6f, 0xf6, 0x0, 0xc,
    0xff, 0xff, 0xff, 0x0, 0x3, 0xef, 0xff, 0xff,
    0xff, 0xf8, 0x6, 0xff, 0xff, 0x60, 0x8f, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xff,
    0xff, 0xcf, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x3, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x2, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x80,

    /* U+F7C2 "" */
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x80, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x8f, 0xf4, 0x8, 0xf0,
    0xe, 0x90, 0xf, 0xff, 0x8, 0xff, 0xf4, 0x8,
    0xf0, 0xe, 0x90, 0xf, 0xff, 0x8f, 0xff, 0xf4,
    0x8, 0xf0, 0xe, 0x90, 0xf, 0xff, 0xff, 0xff,
    0xf4, 0x8, 0xf0, 0xe, 0x90, 0xf, 0xff, 0xff,
    0xff, 0xfa, 0x8c, 0xf8, 0x8f, 0xc8, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x8,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x80,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0x10, 0x0, 0x0,
    0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xf1, 0x0, 0x0, 0x1c, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0x10, 0x0,
    0x1d, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xf1, 0x0, 0x2d, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0x10,
    0x2e, 0xff, 0xff, 0xa2, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x2b, 0xff, 0xf1, 0x3e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x8f, 0xff, 0xff, 0xd9, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x60, 0x0, 0x7f,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 192, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 192, .box_w = 4, .box_h = 16, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 32, .adv_w = 192, .box_w = 10, .box_h = 6, .ofs_x = 1, .ofs_y = 13},
    {.bitmap_index = 62, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 158, .adv_w = 192, .box_w = 10, .box_h = 21, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 263, .adv_w = 192, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 365, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 461, .adv_w = 192, .box_w = 4, .box_h = 6, .ofs_x = 1, .ofs_y = 13},
    {.bitmap_index = 473, .adv_w = 192, .box_w = 6, .box_h = 23, .ofs_x = 5, .ofs_y = -3},
    {.bitmap_index = 542, .adv_w = 192, .box_w = 6, .box_h = 23, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 611, .adv_w = 192, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 683, .adv_w = 192, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 755, .adv_w = 192, .box_w = 12, .box_h = 1, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 761, .adv_w = 192, .box_w = 4, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 767, .adv_w = 192, .box_w = 12, .box_h = 21, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 893, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 973, .adv_w = 192, .box_w = 8, .box_h = 16, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1037, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1117, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1197, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1293, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1373, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1453, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1533, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1613, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1693, .adv_w = 192, .box_w = 4, .box_h = 11, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 1715, .adv_w = 192, .box_w = 3, .box_h = 14, .ofs_x = 4, .ofs_y = -3},
    {.bitmap_index = 1736, .adv_w = 192, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1821, .adv_w = 192, .box_w = 12, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 1857, .adv_w = 192, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1942, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2022, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2118, .adv_w = 192, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2220, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2316, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2412, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2508, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2604, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2700, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2796, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2892, .adv_w = 192, .box_w = 8, .box_h = 16, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2956, .adv_w = 192, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3070, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3166, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3262, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3358, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3454, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3550, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3646, .adv_w = 192, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3760, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3856, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3936, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4032, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4128, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4224, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4320, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4416, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4512, .adv_w = 192, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4600, .adv_w = 192, .box_w = 7, .box_h = 21, .ofs_x = 4, .ofs_y = -2},
    {.bitmap_index = 4674, .adv_w = 192, .box_w = 10, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4774, .adv_w = 192, .box_w = 7, .box_h = 21, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 4848, .adv_w = 192, .box_w = 8, .box_h = 3, .ofs_x = 2, .ofs_y = 16},
    {.bitmap_index = 4860, .adv_w = 192, .box_w = 12, .box_h = 1, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4866, .adv_w = 192, .box_w = 6, .box_h = 3, .ofs_x = 1, .ofs_y = 16},
    {.bitmap_index = 4875, .adv_w = 192, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4936, .adv_w = 192, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5030, .adv_w = 192, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5085, .adv_w = 192, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5179, .adv_w = 192, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5234, .adv_w = 192, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5322, .adv_w = 192, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5399, .adv_w = 192, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5501, .adv_w = 192, .box_w = 8, .box_h = 16, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5565, .adv_w = 192, .box_w = 9, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5651, .adv_w = 192, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5753, .adv_w = 192, .box_w = 8, .box_h = 17, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5821, .adv_w = 192, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5887, .adv_w = 192, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5953, .adv_w = 192, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6008, .adv_w = 192, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6085, .adv_w = 192, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 6162, .adv_w = 192, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6223, .adv_w = 192, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6278, .adv_w = 192, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6348, .adv_w = 192, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6414, .adv_w = 192, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6475, .adv_w = 192, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6541, .adv_w = 192, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6602, .adv_w = 192, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 6679, .adv_w = 192, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6734, .adv_w = 192, .box_w = 6, .box_h = 21, .ofs_x = 5, .ofs_y = -2},
    {.bitmap_index = 6797, .adv_w = 192, .box_w = 2, .box_h = 24, .ofs_x = 5, .ofs_y = -3},
    {.bitmap_index = 6821, .adv_w = 192, .box_w = 6, .box_h = 21, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 6884, .adv_w = 192, .box_w = 12, .box_h = 5, .ofs_x = 0, .ofs_y = 16},
    {.bitmap_index = 6914, .adv_w = 384, .box_w = 24, .box_h = 25, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7214, .adv_w = 384, .box_w = 24, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7430, .adv_w = 384, .box_w = 24, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7694, .adv_w = 384, .box_w = 24, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7910, .adv_w = 264, .box_w = 17, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8063, .adv_w = 384, .box_w = 24, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8351, .adv_w = 384, .box_w = 24, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8639, .adv_w = 432, .box_w = 27, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8936, .adv_w = 384, .box_w = 24, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9224, .adv_w = 432, .box_w = 27, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9467, .adv_w = 384, .box_w = 24, .box_h = 26, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9779, .adv_w = 192, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9893, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10064, .adv_w = 432, .box_w = 27, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10388, .adv_w = 384, .box_w = 24, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10604, .adv_w = 336, .box_w = 15, .box_h = 22, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 10769, .adv_w = 336, .box_w = 21, .box_h = 26, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11042, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11273, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11504, .adv_w = 336, .box_w = 15, .box_h = 22, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 11669, .adv_w = 336, .box_w = 23, .box_h = 22, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 11922, .adv_w = 240, .box_w = 13, .box_h = 22, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 12065, .adv_w = 240, .box_w = 13, .box_h = 22, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 12208, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12439, .adv_w = 336, .box_w = 21, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 12502, .adv_w = 432, .box_w = 27, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12745, .adv_w = 480, .box_w = 31, .box_h = 24, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 13117, .adv_w = 432, .box_w = 29, .box_h = 24, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 13465, .adv_w = 384, .box_w = 24, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13729, .adv_w = 336, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 13876, .adv_w = 336, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 14023, .adv_w = 480, .box_w = 31, .box_h = 19, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 14318, .adv_w = 384, .box_w = 24, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14534, .adv_w = 384, .box_w = 24, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14822, .adv_w = 384, .box_w = 25, .box_h = 25, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 15135, .adv_w = 336, .box_w = 22, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 15377, .adv_w = 336, .box_w = 21, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15629, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 15860, .adv_w = 240, .box_w = 17, .box_h = 24, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 16064, .adv_w = 336, .box_w = 21, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16316, .adv_w = 336, .box_w = 21, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16568, .adv_w = 432, .box_w = 27, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16811, .adv_w = 384, .box_w = 26, .box_h = 26, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 17149, .adv_w = 288, .box_w = 18, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 17365, .adv_w = 480, .box_w = 30, .box_h = 23, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17710, .adv_w = 480, .box_w = 30, .box_h = 16, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 17950, .adv_w = 480, .box_w = 30, .box_h = 16, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 18190, .adv_w = 480, .box_w = 30, .box_h = 16, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 18430, .adv_w = 480, .box_w = 30, .box_h = 16, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 18670, .adv_w = 480, .box_w = 30, .box_h = 16, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 18910, .adv_w = 480, .box_w = 31, .box_h = 20, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 19220, .adv_w = 336, .box_w = 19, .box_h = 24, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 19448, .adv_w = 336, .box_w = 21, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 19700, .adv_w = 384, .box_w = 25, .box_h = 25, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 20013, .adv_w = 480, .box_w = 30, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20283, .adv_w = 288, .box_w = 18, .box_h = 24, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 20499, .adv_w = 386, .box_w = 25, .box_h = 16, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 12, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 45, .range_length = 82, .glyph_id_start = 13,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 95,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_simsun_24 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 26,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0)
    .underline_position = -3,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};



#endif /*#if LV_FONT_SIMSUN_24*/

