#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef LV_FONT_SIMSUN_16
#define LV_FONT_SIMSUN_16 1
#endif

#if LV_FONT_SIMSUN_16

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x97, 0xb9, 0xa8, 0x97, 0x75, 0x64, 0x53, 0x53,
    0x0, 0x0, 0xa8, 0xb9,

    /* U+22 "\"" */
    0x2, 0xe1, 0x98, 0xa, 0xc3, 0xf4, 0x2c, 0xa,
    0x60, 0x81, 0x27, 0x0, 0x0, 0x0, 0x0,

    /* U+23 "#" */
    0x0, 0x90, 0x3, 0x50, 0x0, 0x90, 0x4, 0x40,
    0x0, 0x90, 0x6, 0x40, 0x7f, 0xff, 0xff, 0xf6,
    0x13, 0xa3, 0x39, 0x41, 0x0, 0x80, 0x8, 0x0,
    0x1, 0x70, 0x9, 0x0, 0x3, 0x70, 0x9, 0x0,
    0x7f, 0xff, 0xff, 0xf6, 0x17, 0x73, 0x3a, 0x31,
    0x5, 0x30, 0x9, 0x0, 0x6, 0x20, 0x9, 0x0,

    /* U+24 "$" */
    0x0, 0x45, 0x0, 0x6, 0xaa, 0x80, 0x48, 0x45,
    0x86, 0x95, 0x45, 0xc7, 0x7b, 0x45, 0x20, 0x1e,
    0xc5, 0x0, 0x2, 0xec, 0x0, 0x0, 0x4f, 0xb0,
    0x0, 0x45, 0xd5, 0x52, 0x45, 0x6a, 0xe7, 0x45,
    0x49, 0xa4, 0x45, 0x74, 0x18, 0x9a, 0x60, 0x0,
    0x45, 0x0, 0x0, 0x45, 0x0,

    /* U+25 "%" */
    0x19, 0x80, 0x3, 0x20, 0x82, 0x64, 0x8, 0x0,
    0xb0, 0x47, 0x7, 0x0, 0xc0, 0x48, 0x61, 0x0,
    0xb0, 0x47, 0x70, 0x0, 0x73, 0x76, 0x50, 0x0,
    0x7, 0x67, 0x7, 0x60, 0x0, 0x7, 0x64, 0x64,
    0x0, 0x42, 0xa1, 0x38, 0x0, 0x70, 0xb1, 0x39,
    0x1, 0x50, 0x82, 0x47, 0x5, 0x0, 0x19, 0x91,

    /* U+26 "&" */
    0x0, 0x88, 0x50, 0x0, 0x6, 0x40, 0xc0, 0x0,
    0x9, 0x30, 0xd0, 0x0, 0x8, 0x53, 0x90, 0x0,
    0x6, 0x99, 0x10, 0x0, 0x5, 0xf0, 0x2a, 0x80,
    0x18, 0xd4, 0x9, 0x10, 0x84, 0x6a, 0x8, 0x0,
    0xc2, 0xe, 0x38, 0x0, 0xb3, 0x6, 0xe5, 0x0,
    0x6a, 0x0, 0xe9, 0x5, 0x9, 0xc9, 0x2b, 0xc3,

    /* U+27 "'" */
    0xb, 0xb0, 0x7, 0xf0, 0x0, 0xc0, 0x8, 0x30,
    0x1, 0x0,

    /* U+28 "(" */
    0x0, 0x6, 0x10, 0x4, 0x60, 0x0, 0xb0, 0x0,
    0x84, 0x0, 0xd, 0x0, 0x4, 0xa0, 0x0, 0x67,
    0x0, 0x8, 0x60, 0x0, 0x77, 0x0, 0x6, 0x80,
    0x0, 0x2c, 0x0, 0x0, 0xc1, 0x0, 0x5, 0x70,
    0x0, 0xa, 0x10, 0x0, 0x19, 0x0, 0x0, 0x21,

    /* U+29 ")" */
    0x16, 0x0, 0x0, 0x74, 0x0, 0x0, 0xb0, 0x0,
    0x5, 0x70, 0x0, 0xd, 0x0, 0x0, 0xb3, 0x0,
    0x8, 0x50, 0x0, 0x77, 0x0, 0x8, 0x60, 0x0,
    0x95, 0x0, 0xc, 0x10, 0x1, 0xb0, 0x0, 0x84,
    0x0, 0x29, 0x0, 0x9, 0x0, 0x1, 0x10, 0x0,

    /* U+2A "*" */
    0x0, 0x7, 0x80, 0x0, 0x0, 0x8, 0x80, 0x0,
    0x5d, 0x26, 0x52, 0xd4, 0x18, 0xd6, 0x6d, 0x80,
    0x0, 0x1b, 0xa1, 0x0, 0x8, 0xd6, 0x6d, 0x80,
    0x5d, 0x27, 0x52, 0xd4, 0x0, 0x9, 0x70, 0x0,
    0x0, 0x9, 0x70, 0x0,

    /* U+2B "+" */
    0x0, 0x2, 0x40, 0x0, 0x0, 0x3, 0x60, 0x0,
    0x0, 0x3, 0x60, 0x0, 0x0, 0x3, 0x60, 0x0,
    0x39, 0x9a, 0xc9, 0x94, 0x0, 0x3, 0x60, 0x0,
    0x0, 0x3, 0x60, 0x0, 0x0, 0x3, 0x60, 0x0,
    0x0, 0x2, 0x40, 0x0,

    /* U+2D "-" */
    0x49, 0x99, 0x99, 0x94,

    /* U+2E "." */
    0x0, 0xcb, 0xbb,

    /* U+2F "/" */
    0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x71,
    0x0, 0x0, 0x0, 0x80, 0x0, 0x0, 0x5, 0x20,
    0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x44, 0x0,
    0x0, 0x0, 0x80, 0x0, 0x0, 0x2, 0x60, 0x0,
    0x0, 0x8, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0,
    0x0, 0x71, 0x0, 0x0, 0x0, 0x80, 0x0, 0x0,
    0x5, 0x30, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0,
    0x35, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x6a, 0x95, 0x0, 0x3, 0xc0, 0xb, 0x30,
    0xb, 0x60, 0x6, 0xa0, 0xf, 0x20, 0x2, 0xf0,
    0x2f, 0x0, 0x1, 0xf1, 0x3f, 0x0, 0x0, 0xf2,
    0x3f, 0x0, 0x0, 0xf2, 0x2f, 0x0, 0x1, 0xf1,
    0xf, 0x20, 0x2, 0xe0, 0xb, 0x50, 0x6, 0xa0,
    0x3, 0xc0, 0xb, 0x30, 0x0, 0x6a, 0x95, 0x0,

    /* U+31 "1" */
    0x0, 0x17, 0x0, 0x16, 0xd9, 0x0, 0x0, 0x79,
    0x0, 0x0, 0x79, 0x0, 0x0, 0x79, 0x0, 0x0,
    0x79, 0x0, 0x0, 0x79, 0x0, 0x0, 0x79, 0x0,
    0x0, 0x79, 0x0, 0x0, 0x79, 0x0, 0x0, 0x79,
    0x0, 0x16, 0xde, 0x72,

    /* U+32 "2" */
    0x0, 0x77, 0x89, 0x0, 0x92, 0x0, 0x88, 0xe,
    0x20, 0x4, 0xc0, 0xd5, 0x0, 0x3c, 0x0, 0x0,
    0x8, 0x80, 0x0, 0x1, 0xd1, 0x0, 0x0, 0x93,
    0x0, 0x0, 0x74, 0x0, 0x0, 0x55, 0x0, 0x0,
    0x28, 0x0, 0x6, 0x9, 0x0, 0x1, 0xa2, 0xff,
    0xff, 0xfb,

    /* U+33 "3" */
    0x1, 0x77, 0xa5, 0x0, 0xa2, 0x0, 0xd3, 0xd,
    0x40, 0x8, 0x80, 0x10, 0x0, 0x96, 0x0, 0x0,
    0x2c, 0x10, 0x0, 0x8d, 0x20, 0x0, 0x0, 0xb,
    0x30, 0x0, 0x0, 0x4c, 0x3, 0x0, 0x2, 0xf0,
    0xf4, 0x0, 0x3d, 0xd, 0x30, 0x9, 0x60, 0x28,
    0x78, 0x70,

    /* U+34 "4" */
    0x0, 0x0, 0x2b, 0x0, 0x0, 0x0, 0xac, 0x0,
    0x0, 0x3, 0x8c, 0x0, 0x0, 0x8, 0x4c, 0x0,
    0x0, 0x53, 0x4c, 0x0, 0x0, 0x80, 0x4c, 0x0,
    0x6, 0x20, 0x4c, 0x0, 0x7, 0x0, 0x4c, 0x0,
    0x47, 0x66, 0x8d, 0x62, 0x0, 0x0, 0x4c, 0x0,
    0x0, 0x0, 0x4c, 0x0, 0x0, 0x5, 0xaf, 0x71,

    /* U+35 "5" */
    0x5, 0xff, 0xff, 0xb0, 0x61, 0x0, 0x0, 0x7,
    0x0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x7, 0x5a,
    0xca, 0x0, 0x85, 0x0, 0xa7, 0x1, 0x0, 0x3,
    0xd0, 0x0, 0x0, 0x1f, 0x7, 0x20, 0x1, 0xe0,
    0xf4, 0x0, 0x3c, 0xb, 0x10, 0x9, 0x50, 0x17,
    0x79, 0x80,

    /* U+36 "6" */
    0x0, 0x28, 0x7b, 0x20, 0x1, 0xa0, 0xa, 0x80,
    0x9, 0x40, 0x0, 0x0, 0xe, 0x10, 0x0, 0x0,
    0x1f, 0x2a, 0xbb, 0x10, 0x3f, 0x90, 0x7, 0xa0,
    0x3f, 0x20, 0x0, 0xf0, 0x3f, 0x0, 0x0, 0xe2,
    0x1f, 0x10, 0x0, 0xe2, 0xd, 0x40, 0x0, 0xe0,
    0x6, 0xb0, 0x4, 0x90, 0x0, 0x79, 0x88, 0x0,

    /* U+37 "7" */
    0xaf, 0xff, 0xff, 0xb, 0x30, 0x1, 0x80, 0x60,
    0x0, 0x71, 0x0, 0x0, 0x8, 0x0, 0x0, 0x7,
    0x30, 0x0, 0x0, 0xb0, 0x0, 0x0, 0x49, 0x0,
    0x0, 0x9, 0x50, 0x0, 0x0, 0xd3, 0x0, 0x0,
    0xf, 0x30, 0x0, 0x2, 0xf3, 0x0, 0x0, 0x1e,
    0x20, 0x0,

    /* U+38 "8" */
    0x1, 0x87, 0x78, 0x0, 0xa, 0x20, 0x4, 0x80,
    0xd, 0x0, 0x0, 0xd0, 0xe, 0x20, 0x0, 0xc0,
    0x7, 0xd3, 0x7, 0x50, 0x0, 0x9f, 0xc6, 0x0,
    0x5, 0x72, 0xbe, 0x10, 0xc, 0x0, 0x9, 0xb0,
    0x39, 0x0, 0x0, 0xf0, 0x3a, 0x0, 0x0, 0xe0,
    0xb, 0x10, 0x3, 0x90, 0x1, 0x87, 0x78, 0x0,

    /* U+39 "9" */
    0x1, 0x98, 0x86, 0x0, 0xa, 0x40, 0x9, 0x40,
    0x1e, 0x0, 0x4, 0xb0, 0x3c, 0x0, 0x2, 0xf0,
    0x4c, 0x0, 0x1, 0xf1, 0x2e, 0x0, 0x6, 0xf1,
    0xc, 0x70, 0x29, 0xf1, 0x1, 0x99, 0x73, 0xf0,
    0x0, 0x0, 0x5, 0xb0, 0x0, 0x0, 0x9, 0x50,
    0xa, 0x80, 0x1c, 0x0, 0x4, 0xb7, 0x91, 0x0,

    /* U+3A ":" */
    0xc8, 0xb7, 0x0, 0x0, 0x0, 0x0, 0xb7, 0xc8,

    /* U+3B ";" */
    0xda, 0x64, 0x0, 0x0, 0x0, 0x0, 0x65, 0xda,
    0x56, 0x90,

    /* U+3C "<" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x38, 0x0, 0x2,
    0x90, 0x0, 0x19, 0x0, 0x1, 0xa0, 0x0, 0xa,
    0x10, 0x0, 0xa1, 0x0, 0x0, 0x56, 0x0, 0x0,
    0x6, 0x50, 0x0, 0x0, 0x74, 0x0, 0x0, 0x8,
    0x30, 0x0, 0x0, 0x92, 0x0, 0x0, 0x6,

    /* U+3D "=" */
    0x49, 0x99, 0x99, 0x94, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x49, 0x99, 0x99, 0x94,

    /* U+3E ">" */
    0x10, 0x0, 0x0, 0x83, 0x0, 0x0, 0x9, 0x20,
    0x0, 0x0, 0x91, 0x0, 0x0, 0xa, 0x10, 0x0,
    0x1, 0xa0, 0x0, 0x0, 0x1a, 0x0, 0x0, 0x65,
    0x0, 0x5, 0x60, 0x0, 0x47, 0x0, 0x3, 0x80,
    0x0, 0x29, 0x0, 0x0, 0x60, 0x0, 0x0,

    /* U+3F "?" */
    0x0, 0x79, 0xa9, 0x10, 0x8, 0x10, 0x5, 0xb0,
    0x1a, 0x0, 0x0, 0xf1, 0x2f, 0x40, 0x0, 0xf1,
    0x5, 0x10, 0x5, 0xe0, 0x0, 0x0, 0x5d, 0x20,
    0x0, 0x3, 0xa0, 0x0, 0x0, 0x6, 0x10, 0x0,
    0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0x70, 0x0, 0x0, 0xc, 0x80, 0x0,

    /* U+40 "@" */
    0x0, 0x38, 0x78, 0x10, 0x2, 0x90, 0x0, 0x90,
    0xa, 0x10, 0x79, 0x64, 0x1b, 0x8, 0x2b, 0x27,
    0x49, 0xa, 0xc, 0x9, 0x58, 0x57, 0xc, 0x8,
    0x58, 0x84, 0xb, 0x8, 0x39, 0x93, 0x39, 0x25,
    0x1b, 0x73, 0x78, 0x70, 0xa, 0x29, 0x3a, 0x41,
    0x3, 0x80, 0x0, 0x72, 0x0, 0x59, 0x88, 0x30,

    /* U+41 "A" */
    0x0, 0x5, 0x50, 0x0, 0x0, 0xc, 0xa0, 0x0,
    0x0, 0x8, 0xe0, 0x0, 0x0, 0x44, 0xd1, 0x0,
    0x0, 0x70, 0x95, 0x0, 0x0, 0x80, 0x68, 0x0,
    0x0, 0x80, 0x2c, 0x0, 0x3, 0x96, 0x6f, 0x0,
    0x7, 0x10, 0xc, 0x30, 0x8, 0x0, 0x8, 0x70,
    0x9, 0x0, 0x5, 0xa0, 0x8d, 0x20, 0x9, 0xf5,

    /* U+42 "B" */
    0x4e, 0xa6, 0x8a, 0x20, 0xb, 0x50, 0x6, 0xb0,
    0xb, 0x50, 0x2, 0xe0, 0xb, 0x50, 0x3, 0xd0,
    0xb, 0x50, 0xa, 0x50, 0xb, 0x96, 0xb7, 0x0,
    0xb, 0x50, 0x7, 0x90, 0xb, 0x50, 0x0, 0xe2,
    0xb, 0x50, 0x0, 0xc6, 0xb, 0x50, 0x0, 0xd5,
    0xb, 0x50, 0x3, 0xe1, 0x5e, 0xa6, 0x7a, 0x30,

    /* U+43 "C" */
    0x0, 0x49, 0x7c, 0xf0, 0x3, 0xb0, 0x0, 0xb2,
    0xc, 0x40, 0x0, 0x25, 0x2f, 0x0, 0x0, 0x0,
    0x6c, 0x0, 0x0, 0x0, 0x7b, 0x0, 0x0, 0x0,
    0x7b, 0x0, 0x0, 0x0, 0x6c, 0x0, 0x0, 0x0,
    0x4e, 0x0, 0x0, 0x2, 0xf, 0x20, 0x0, 0x42,
    0x7, 0xa0, 0x1, 0x70, 0x0, 0x7b, 0x98, 0x0,

    /* U+44 "D" */
    0x4e, 0xb6, 0x84, 0x0, 0xb, 0x50, 0xa, 0x50,
    0xb, 0x50, 0x3, 0xe0, 0xb, 0x50, 0x0, 0xe3,
    0xb, 0x50, 0x0, 0xd5, 0xb, 0x50, 0x0, 0xc6,
    0xb, 0x50, 0x0, 0xc6, 0xb, 0x50, 0x0, 0xd5,
    0xb, 0x50, 0x0, 0xf2, 0xb, 0x50, 0x3, 0xd0,
    0xb, 0x50, 0xb, 0x40, 0x4e, 0xb6, 0x94, 0x0,

    /* U+45 "E" */
    0x3d, 0xb6, 0x6b, 0xc0, 0xa, 0x60, 0x0, 0xb0,
    0xa, 0x60, 0x0, 0x22, 0xa, 0x60, 0x0, 0x0,
    0xa, 0x60, 0x6, 0x0, 0xa, 0xa6, 0x8b, 0x0,
    0xa, 0x60, 0x9, 0x0, 0xa, 0x60, 0x6, 0x0,
    0xa, 0x60, 0x0, 0x0, 0xa, 0x60, 0x0, 0x3,
    0xa, 0x60, 0x0, 0x63, 0x3d, 0xb6, 0x69, 0xe0,

    /* U+46 "F" */
    0x3d, 0xb6, 0x69, 0xf1, 0xa, 0x60, 0x0, 0x65,
    0xa, 0x60, 0x0, 0x5, 0xa, 0x60, 0x0, 0x0,
    0xa, 0x60, 0x6, 0x0, 0xa, 0xa6, 0x7e, 0x0,
    0xa, 0x60, 0x9, 0x0, 0xa, 0x60, 0x5, 0x0,
    0xa, 0x60, 0x0, 0x0, 0xa, 0x60, 0x0, 0x0,
    0xa, 0x60, 0x0, 0x0, 0x4d, 0xb2, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x68, 0x9f, 0x50, 0x4, 0x90, 0x4, 0x80,
    0xd, 0x10, 0x0, 0x70, 0x3c, 0x0, 0x0, 0x0,
    0x6a, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x29, 0xb4, 0x6a, 0x0, 0x5, 0xb0,
    0x4d, 0x0, 0x5, 0xb0, 0xe, 0x10, 0x5, 0xb0,
    0x7, 0x80, 0x6, 0xb0, 0x0, 0x88, 0x77, 0x20,

    /* U+48 "H" */
    0x4f, 0x80, 0x9, 0xf4, 0xe, 0x20, 0x3, 0xd0,
    0xe, 0x20, 0x3, 0xd0, 0xe, 0x20, 0x3, 0xd0,
    0xe, 0x20, 0x3, 0xd0, 0xe, 0x76, 0x68, 0xd0,
    0xe, 0x20, 0x3, 0xd0, 0xe, 0x20, 0x3, 0xd0,
    0xe, 0x20, 0x3, 0xd0, 0xe, 0x20, 0x3, 0xd0,
    0xe, 0x20, 0x3, 0xd0, 0x5f, 0x90, 0x9, 0xf4,

    /* U+49 "I" */
    0x36, 0xcc, 0x63, 0x0, 0x88, 0x0, 0x0, 0x88,
    0x0, 0x0, 0x88, 0x0, 0x0, 0x88, 0x0, 0x0,
    0x88, 0x0, 0x0, 0x88, 0x0, 0x0, 0x88, 0x0,
    0x0, 0x88, 0x0, 0x0, 0x88, 0x0, 0x0, 0x88,
    0x0, 0x36, 0xcc, 0x63,

    /* U+4A "J" */
    0x0, 0x36, 0xbd, 0x64, 0x0, 0x0, 0x79, 0x0,
    0x0, 0x0, 0x79, 0x0, 0x0, 0x0, 0x79, 0x0,
    0x0, 0x0, 0x79, 0x0, 0x0, 0x0, 0x79, 0x0,
    0x0, 0x0, 0x79, 0x0, 0x0, 0x0, 0x79, 0x0,
    0x0, 0x0, 0x79, 0x0, 0x0, 0x0, 0x79, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x1, 0x0, 0x87, 0x0,
    0x5d, 0x0, 0xb2, 0x0, 0x1b, 0x77, 0x40, 0x0,

    /* U+4B "K" */
    0x4e, 0xa1, 0x2c, 0xb2, 0xb, 0x50, 0x9, 0x0,
    0xb, 0x50, 0x62, 0x0, 0xb, 0x51, 0x60, 0x0,
    0xb, 0x5a, 0x10, 0x0, 0xb, 0x9d, 0x60, 0x0,
    0xb, 0xa3, 0xd0, 0x0, 0xb, 0x50, 0xd3, 0x0,
    0xb, 0x50, 0x6a, 0x0, 0xb, 0x50, 0xe, 0x10,
    0xb, 0x50, 0x9, 0x70, 0x4e, 0xa1, 0xa, 0xf5,

    /* U+4C "L" */
    0x2c, 0xc3, 0x0, 0x0, 0x8, 0x80, 0x0, 0x0,
    0x8, 0x80, 0x0, 0x0, 0x8, 0x80, 0x0, 0x0,
    0x8, 0x80, 0x0, 0x0, 0x8, 0x80, 0x0, 0x0,
    0x8, 0x80, 0x0, 0x0, 0x8, 0x80, 0x0, 0x0,
    0x8, 0x80, 0x0, 0x0, 0x8, 0x80, 0x0, 0x4,
    0x8, 0x80, 0x0, 0x63, 0x3c, 0xc6, 0x69, 0xf0,

    /* U+4D "M" */
    0x7f, 0x0, 0x4, 0xf6, 0x1f, 0x30, 0x7, 0xf0,
    0x1c, 0x60, 0x6, 0xf0, 0x19, 0x90, 0x6, 0xf0,
    0x16, 0xc0, 0x14, 0xf0, 0x15, 0xd0, 0x51, 0xf0,
    0x15, 0xb3, 0x60, 0xf0, 0x15, 0x86, 0x60, 0xf0,
    0x15, 0x49, 0x60, 0xf0, 0x15, 0x1e, 0x40, 0xf0,
    0x15, 0xe, 0x10, 0xf0, 0x7a, 0x9, 0x6, 0xf6,

    /* U+4E "N" */
    0x5f, 0x40, 0x4, 0xc6, 0xb, 0xc0, 0x0, 0x60,
    0x6, 0xd3, 0x0, 0x60, 0x6, 0x6a, 0x0, 0x60,
    0x6, 0xe, 0x20, 0x60, 0x6, 0x8, 0x90, 0x60,
    0x6, 0x1, 0xe1, 0x60, 0x6, 0x0, 0x98, 0x60,
    0x6, 0x0, 0x2e, 0x60, 0x6, 0x0, 0xb, 0xc0,
    0x6, 0x0, 0x3, 0xd0, 0x6c, 0x40, 0x0, 0x90,

    /* U+4F "O" */
    0x0, 0x68, 0x87, 0x0, 0x5, 0x90, 0x6, 0x70,
    0xd, 0x20, 0x0, 0xe0, 0x2e, 0x0, 0x0, 0xd3,
    0x5c, 0x0, 0x0, 0xb6, 0x6c, 0x0, 0x0, 0xa8,
    0x6c, 0x0, 0x0, 0xa8, 0x5c, 0x0, 0x0, 0xa7,
    0x2e, 0x0, 0x0, 0xc4, 0xd, 0x20, 0x0, 0xe0,
    0x4, 0x80, 0x5, 0x70, 0x0, 0x57, 0x77, 0x0,

    /* U+50 "P" */
    0x3d, 0xb6, 0x79, 0x20, 0xa, 0x60, 0x1, 0xd0,
    0xa, 0x60, 0x0, 0xc4, 0xa, 0x60, 0x0, 0xb5,
    0xa, 0x60, 0x0, 0xd2, 0xa, 0x60, 0x6, 0xa0,
    0xa, 0xa6, 0x76, 0x0, 0xa, 0x60, 0x0, 0x0,
    0xa, 0x60, 0x0, 0x0, 0xa, 0x60, 0x0, 0x0,
    0xa, 0x60, 0x0, 0x0, 0x4d, 0xb2, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x88, 0x87, 0x0, 0x7, 0x80, 0x6, 0x60,
    0xe, 0x10, 0x0, 0xe0, 0x3d, 0x0, 0x0, 0xd3,
    0x6b, 0x0, 0x0, 0xb6, 0x7b, 0x0, 0x0, 0xb7,
    0x7b, 0x0, 0x0, 0xb7, 0x6b, 0x0, 0x0, 0xb6,
    0x4d, 0x5b, 0x60, 0xd4, 0xf, 0x90, 0xd1, 0xe0,
    0x7, 0x90, 0x9c, 0x80, 0x0, 0x78, 0xbe, 0x0,
    0x0, 0x0, 0xd, 0xe1, 0x0, 0x0, 0x0, 0x0,

    /* U+52 "R" */
    0x3c, 0xb6, 0x7a, 0x20, 0x9, 0x70, 0x5, 0xc0,
    0x9, 0x70, 0x0, 0xf0, 0x9, 0x70, 0x1, 0xf0,
    0x9, 0x70, 0x8, 0x80, 0x9, 0xa6, 0xc5, 0x0,
    0x9, 0x70, 0xd1, 0x0, 0x9, 0x70, 0x87, 0x0,
    0x9, 0x70, 0x3c, 0x0, 0x9, 0x70, 0xe, 0x20,
    0x9, 0x70, 0x8, 0x70, 0x3c, 0xc2, 0x3, 0xe4,

    /* U+53 "S" */
    0x1, 0x77, 0x9f, 0x70, 0xa, 0x0, 0x5, 0x90,
    0x1a, 0x0, 0x0, 0x40, 0x1c, 0x0, 0x0, 0x0,
    0xb, 0xb2, 0x0, 0x0, 0x0, 0x9f, 0x91, 0x0,
    0x0, 0x2, 0xae, 0x20, 0x0, 0x0, 0x7, 0xb0,
    0x0, 0x0, 0x0, 0xe0, 0x35, 0x0, 0x0, 0xd0,
    0xd, 0x10, 0x3, 0x90, 0xe, 0xe8, 0x78, 0x0,

    /* U+54 "T" */
    0x1e, 0x8c, 0xb8, 0xe0, 0x54, 0x9, 0x70, 0x53,
    0x40, 0x9, 0x70, 0x3, 0x0, 0x9, 0x70, 0x0,
    0x0, 0x9, 0x70, 0x0, 0x0, 0x9, 0x70, 0x0,
    0x0, 0x9, 0x70, 0x0, 0x0, 0x9, 0x70, 0x0,
    0x0, 0x9, 0x70, 0x0, 0x0, 0x9, 0x70, 0x0,
    0x0, 0x9, 0x70, 0x0, 0x0, 0x4c, 0xb3, 0x0,

    /* U+55 "U" */
    0x5f, 0x90, 0x4, 0xc4, 0xe, 0x20, 0x0, 0x60,
    0xe, 0x20, 0x0, 0x60, 0xe, 0x20, 0x0, 0x60,
    0xe, 0x20, 0x0, 0x60, 0xe, 0x20, 0x0, 0x60,
    0xe, 0x20, 0x0, 0x60, 0xe, 0x20, 0x0, 0x60,
    0xe, 0x20, 0x0, 0x60, 0xc, 0x20, 0x0, 0x50,
    0x8, 0x60, 0x3, 0x40, 0x0, 0x98, 0x86, 0x0,

    /* U+56 "V" */
    0x5f, 0x90, 0x5, 0xe4, 0xb, 0x50, 0x0, 0x70,
    0x8, 0x80, 0x4, 0x30, 0x4, 0xb0, 0x7, 0x0,
    0x1, 0xf0, 0x7, 0x0, 0x0, 0xd2, 0x7, 0x0,
    0x0, 0xa6, 0x34, 0x0, 0x0, 0x69, 0x60, 0x0,
    0x0, 0x3c, 0x70, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0xc, 0x40, 0x0, 0x0, 0x8, 0x10, 0x0,

    /* U+57 "W" */
    0x8d, 0x2b, 0xc0, 0xa8, 0x2b, 0x5, 0x90, 0x50,
    0xd, 0x3, 0xb0, 0x60, 0xd, 0x4, 0xd0, 0x60,
    0xc, 0x17, 0xe0, 0x60, 0xa, 0x37, 0xd1, 0x60,
    0x8, 0x57, 0xa5, 0x40, 0x5, 0x86, 0x89, 0x20,
    0x3, 0xd3, 0x6d, 0x0, 0x1, 0xf1, 0x4d, 0x0,
    0x0, 0xd0, 0x2a, 0x0, 0x0, 0x80, 0x7, 0x0,

    /* U+58 "X" */
    0x2c, 0xc1, 0x9, 0xb2, 0x4, 0xb0, 0x6, 0x10,
    0x0, 0xd2, 0x7, 0x0, 0x0, 0x78, 0x43, 0x0,
    0x0, 0x1d, 0x80, 0x0, 0x0, 0xa, 0x70, 0x0,
    0x0, 0x8, 0xc0, 0x0, 0x0, 0x8, 0xd2, 0x0,
    0x0, 0x62, 0x79, 0x0, 0x0, 0x80, 0x1e, 0x0,
    0x3, 0x50, 0xa, 0x60, 0x3d, 0x70, 0xb, 0xe4,

    /* U+59 "Y" */
    0x4f, 0xa0, 0x7, 0xe4, 0x9, 0x70, 0x2, 0x50,
    0x3, 0xc0, 0x6, 0x0, 0x0, 0xe1, 0x7, 0x0,
    0x0, 0x86, 0x24, 0x0, 0x0, 0x3c, 0x60, 0x0,
    0x0, 0xd, 0x70, 0x0, 0x0, 0x9, 0x70, 0x0,
    0x0, 0x9, 0x70, 0x0, 0x0, 0x9, 0x70, 0x0,
    0x0, 0x9, 0x70, 0x0, 0x0, 0x4c, 0xb3, 0x0,

    /* U+5A "Z" */
    0x8, 0xd7, 0x67, 0xf1, 0xb, 0x10, 0x7, 0x90,
    0x3, 0x0, 0xe, 0x20, 0x0, 0x0, 0x6a, 0x0,
    0x0, 0x0, 0xd2, 0x0, 0x0, 0x5, 0xb0, 0x0,
    0x0, 0xd, 0x30, 0x0, 0x0, 0x4c, 0x0, 0x0,
    0x0, 0xc4, 0x0, 0x0, 0x4, 0xc0, 0x0, 0x31,
    0xb, 0x50, 0x0, 0xa0, 0x3f, 0x66, 0x6b, 0xb0,

    /* U+5B "[" */
    0xa9, 0x98, 0xa0, 0x0, 0xa0, 0x0, 0xa0, 0x0,
    0xa0, 0x0, 0xa0, 0x0, 0xa0, 0x0, 0xa0, 0x0,
    0xa0, 0x0, 0xa0, 0x0, 0xa0, 0x0, 0xa0, 0x0,
    0xa0, 0x0, 0xa0, 0x0, 0xa9, 0x98,

    /* U+5C "\\" */
    0xa1, 0x0, 0x0, 0x4, 0x70, 0x0, 0x0, 0xb,
    0x0, 0x0, 0x0, 0x83, 0x0, 0x0, 0x2, 0x90,
    0x0, 0x0, 0xb, 0x0, 0x0, 0x0, 0x65, 0x0,
    0x0, 0x1, 0xa0, 0x0, 0x0, 0xa, 0x10, 0x0,
    0x0, 0x56, 0x0, 0x0, 0x0, 0xb0, 0x0, 0x0,
    0x9, 0x20, 0x0, 0x0, 0x38, 0x0, 0x0, 0x0,
    0xb0, 0x0, 0x0, 0x4, 0x10,

    /* U+5D "]" */
    0x89, 0x99, 0x0, 0xa, 0x0, 0xa, 0x0, 0xa,
    0x0, 0xa, 0x0, 0xa, 0x0, 0xa, 0x0, 0xa,
    0x0, 0xa, 0x0, 0xa, 0x0, 0xa, 0x0, 0xa,
    0x0, 0xa, 0x0, 0xa, 0x99, 0x99,

    /* U+5E "^" */
    0x2, 0xdd, 0x20, 0x7, 0x1, 0x70,

    /* U+5F "_" */
    0x66, 0x66, 0x66, 0x66,

    /* U+60 "`" */
    0x3c, 0x90, 0x0, 0x43,

    /* U+61 "a" */
    0x2, 0x86, 0x68, 0x0, 0xd, 0x20, 0x9, 0x40,
    0x5, 0x0, 0x8, 0x50, 0x0, 0x68, 0x6a, 0x60,
    0xb, 0x50, 0x8, 0x60, 0x3d, 0x0, 0x8, 0x60,
    0x3e, 0x0, 0x9, 0x63, 0x7, 0x97, 0x76, 0xb4,

    /* U+62 "b" */
    0x2, 0x10, 0x0, 0x0, 0x4e, 0x30, 0x0, 0x0,
    0xb, 0x30, 0x0, 0x0, 0xb, 0x30, 0x0, 0x0,
    0xb, 0x30, 0x0, 0x0, 0xb, 0x48, 0x9b, 0x10,
    0xb, 0xa0, 0x5, 0xa0, 0xb, 0x40, 0x0, 0xf0,
    0xb, 0x30, 0x0, 0xe1, 0xb, 0x30, 0x0, 0xe1,
    0xb, 0x30, 0x0, 0xe0, 0xb, 0x60, 0x5, 0x80,
    0x8, 0x57, 0x89, 0x0,

    /* U+63 "c" */
    0x0, 0x67, 0x69, 0x0, 0x59, 0x0, 0x87, 0xc,
    0x20, 0x4, 0x30, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xd2, 0x0, 0x3, 0x6, 0x80, 0x0,
    0x60, 0x8, 0xa8, 0x80,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x2a, 0xa0,
    0x0, 0x0, 0x4, 0xa0, 0x0, 0x0, 0x4, 0xa0,
    0x0, 0x0, 0x4, 0xa0, 0x0, 0x89, 0x87, 0xa0,
    0x6, 0x80, 0x6, 0xa0, 0xd, 0x20, 0x4, 0xa0,
    0xf, 0x0, 0x4, 0xa0, 0xf, 0x0, 0x4, 0xa0,
    0xe, 0x10, 0x4, 0xa0, 0x7, 0x60, 0x9, 0xa0,
    0x0, 0x99, 0x86, 0xc3,

    /* U+65 "e" */
    0x6, 0x87, 0x90, 0x4, 0x70, 0x5, 0xa0, 0xb1,
    0x0, 0xf, 0xe, 0x66, 0x66, 0xb0, 0xe0, 0x0,
    0x0, 0xc, 0x30, 0x0, 0x20, 0x5a, 0x0, 0x16,
    0x0, 0x7a, 0x87, 0x0,

    /* U+66 "f" */
    0x0, 0x2, 0x76, 0xa2, 0x0, 0xb, 0x0, 0x87,
    0x0, 0x2b, 0x0, 0x0, 0x0, 0x3b, 0x0, 0x0,
    0x6, 0x8d, 0x66, 0x20, 0x0, 0x3b, 0x0, 0x0,
    0x0, 0x3b, 0x0, 0x0, 0x0, 0x3b, 0x0, 0x0,
    0x0, 0x3b, 0x0, 0x0, 0x0, 0x3b, 0x0, 0x0,
    0x0, 0x3b, 0x0, 0x0, 0x5, 0x9e, 0x64, 0x0,

    /* U+67 "g" */
    0x0, 0x86, 0x88, 0xb6, 0x7, 0x50, 0xb, 0x21,
    0xa, 0x30, 0x9, 0x40, 0x4, 0x80, 0xb, 0x10,
    0x3, 0x86, 0x72, 0x0, 0x8, 0x84, 0x10, 0x0,
    0x3, 0xaa, 0xde, 0x70, 0xc, 0x0, 0x0, 0xe0,
    0xc, 0x0, 0x0, 0xb0, 0x3, 0x86, 0x68, 0x30,

    /* U+68 "h" */
    0x3d, 0x40, 0x0, 0x0, 0xa, 0x40, 0x0, 0x0,
    0xa, 0x40, 0x0, 0x0, 0xa, 0x40, 0x0, 0x0,
    0xa, 0x59, 0x9b, 0x10, 0xa, 0xb0, 0x6, 0x70,
    0xa, 0x40, 0x4, 0x90, 0xa, 0x40, 0x4, 0xa0,
    0xa, 0x40, 0x4, 0xa0, 0xa, 0x40, 0x4, 0xa0,
    0xa, 0x40, 0x4, 0xa0, 0x3d, 0xa0, 0xa, 0xd3,

    /* U+69 "i" */
    0x0, 0x8a, 0x0, 0x0, 0x56, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x22, 0x0, 0x26, 0xc7, 0x0, 0x0,
    0x77, 0x0, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0,
    0x0, 0x77, 0x0, 0x0, 0x77, 0x0, 0x0, 0x77,
    0x0, 0x26, 0xbc, 0x62,

    /* U+6A "j" */
    0x0, 0x0, 0xd5, 0x0, 0x0, 0x92, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x31, 0x0, 0x36, 0xe3, 0x0,
    0x0, 0xb3, 0x0, 0x0, 0xb3, 0x0, 0x0, 0xb3,
    0x0, 0x0, 0xb3, 0x0, 0x0, 0xb3, 0x0, 0x0,
    0xb2, 0x0, 0x0, 0xb1, 0x73, 0x0, 0xb0, 0x6c,
    0x88, 0x10,

    /* U+6B "k" */
    0x3c, 0x50, 0x0, 0x0, 0x9, 0x50, 0x0, 0x0,
    0x9, 0x50, 0x0, 0x0, 0x9, 0x50, 0x0, 0x0,
    0x9, 0x50, 0x4e, 0x70, 0x9, 0x50, 0x63, 0x0,
    0x9, 0x54, 0x70, 0x0, 0x9, 0x7c, 0x80, 0x0,
    0x9, 0xb0, 0xd2, 0x0, 0x9, 0x50, 0x5a, 0x0,
    0x9, 0x50, 0xc, 0x30, 0x2c, 0xa1, 0xb, 0xd3,

    /* U+6C "l" */
    0x26, 0xb7, 0x0, 0x0, 0x77, 0x0, 0x0, 0x77,
    0x0, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0, 0x0,
    0x77, 0x0, 0x0, 0x77, 0x0, 0x0, 0x77, 0x0,
    0x0, 0x77, 0x0, 0x0, 0x77, 0x0, 0x0, 0x77,
    0x0, 0x26, 0xbb, 0x62,

    /* U+6D "m" */
    0x8b, 0x7b, 0x68, 0xc1, 0x3d, 0x6, 0xa0, 0x94,
    0x3b, 0x6, 0x80, 0x95, 0x3b, 0x6, 0x80, 0x95,
    0x3b, 0x6, 0x80, 0x95, 0x3b, 0x6, 0x80, 0x95,
    0x3b, 0x6, 0x80, 0x95, 0x8d, 0x2b, 0xc2, 0xc9,

    /* U+6E "n" */
    0x3d, 0x58, 0x8a, 0x10, 0xa, 0xa0, 0x6, 0x70,
    0xa, 0x40, 0x4, 0x90, 0xa, 0x40, 0x4, 0xa0,
    0xa, 0x40, 0x4, 0xa0, 0xa, 0x40, 0x4, 0xa0,
    0xa, 0x40, 0x4, 0xa0, 0x3d, 0xa0, 0xa, 0xd3,

    /* U+6F "o" */
    0x0, 0x87, 0x78, 0x0, 0x7, 0x60, 0x6, 0x70,
    0xd, 0x0, 0x0, 0xd0, 0x2c, 0x0, 0x0, 0xd2,
    0x2c, 0x0, 0x0, 0xc2, 0xd, 0x0, 0x0, 0xd0,
    0x8, 0x50, 0x4, 0x80, 0x0, 0x87, 0x77, 0x0,

    /* U+70 "p" */
    0x5e, 0x59, 0x89, 0x10, 0xa, 0xa0, 0x3, 0xc0,
    0xa, 0x40, 0x0, 0xe1, 0xa, 0x40, 0x0, 0xc3,
    0xa, 0x40, 0x0, 0xc2, 0xa, 0x40, 0x0, 0xe0,
    0xa, 0x70, 0x5, 0x90, 0xa, 0x87, 0x8a, 0x0,
    0xa, 0x40, 0x0, 0x0, 0x3d, 0xa2, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x88, 0x74, 0x70, 0x7, 0x60, 0x8, 0x90,
    0xe, 0x0, 0x5, 0x90, 0x1d, 0x0, 0x5, 0x90,
    0x2d, 0x0, 0x5, 0x90, 0xe, 0x0, 0x5, 0x90,
    0x9, 0x40, 0x9, 0x90, 0x1, 0xa9, 0x87, 0x90,
    0x0, 0x0, 0x5, 0x90, 0x0, 0x0, 0x2a, 0xd3,

    /* U+72 "r" */
    0x38, 0xe3, 0x58, 0xd2, 0x0, 0xb7, 0x40, 0x82,
    0x0, 0xb8, 0x0, 0x0, 0x0, 0xb3, 0x0, 0x0,
    0x0, 0xb3, 0x0, 0x0, 0x0, 0xb3, 0x0, 0x0,
    0x0, 0xb3, 0x0, 0x0, 0x36, 0xe9, 0x60, 0x0,

    /* U+73 "s" */
    0x6, 0x68, 0xe6, 0x46, 0x0, 0x28, 0x59, 0x0,
    0x2, 0xa, 0xd7, 0x10, 0x0, 0x29, 0xe3, 0x40,
    0x0, 0x3b, 0x92, 0x0, 0xa, 0x8e, 0x86, 0x72,

    /* U+74 "t" */
    0x0, 0x30, 0x0, 0x0, 0x80, 0x0, 0x5, 0xb0,
    0x0, 0x67, 0xd6, 0x61, 0x2, 0xc0, 0x0, 0x2,
    0xc0, 0x0, 0x2, 0xc0, 0x0, 0x2, 0xc0, 0x0,
    0x1, 0xc0, 0x1, 0x0, 0xd0, 0x6, 0x0, 0x7a,
    0x81,

    /* U+75 "u" */
    0x4e, 0x30, 0x1a, 0x90, 0xb, 0x30, 0x5, 0x90,
    0xb, 0x30, 0x5, 0x90, 0xb, 0x30, 0x5, 0x90,
    0xb, 0x30, 0x5, 0x90, 0xa, 0x30, 0x5, 0x90,
    0x8, 0x50, 0xa, 0x90, 0x1, 0xca, 0x96, 0xb3,

    /* U+76 "v" */
    0x2c, 0xb1, 0x9, 0xc2, 0x4, 0x90, 0x5, 0x20,
    0x0, 0xd0, 0x7, 0x0, 0x0, 0xb3, 0x7, 0x0,
    0x0, 0x68, 0x42, 0x0, 0x0, 0x1c, 0x60, 0x0,
    0x0, 0xc, 0x70, 0x0, 0x0, 0x7, 0x30, 0x0,

    /* U+77 "w" */
    0x9e, 0x2b, 0xb1, 0xb8, 0x1c, 0x4, 0x80, 0x70,
    0xc, 0x6, 0xb0, 0x60, 0x9, 0x26, 0xc0, 0x60,
    0x6, 0x66, 0xa4, 0x30, 0x2, 0xa4, 0x7b, 0x0,
    0x0, 0xf1, 0x4c, 0x0, 0x0, 0x90, 0x8, 0x0,

    /* U+78 "x" */
    0x8, 0xf5, 0x2c, 0x80, 0x0, 0xa5, 0x8, 0x0,
    0x0, 0x2e, 0x81, 0x0, 0x0, 0x9, 0x90, 0x0,
    0x0, 0x9, 0xd0, 0x0, 0x0, 0x44, 0x77, 0x0,
    0x0, 0x80, 0xd, 0x10, 0x2b, 0xb0, 0x2d, 0xc2,

    /* U+79 "y" */
    0x2b, 0xd2, 0x1a, 0xb2, 0x2, 0xc0, 0x7, 0x10,
    0x0, 0xc1, 0x8, 0x0, 0x0, 0x66, 0x16, 0x0,
    0x0, 0x1b, 0x61, 0x0, 0x0, 0xb, 0x90, 0x0,
    0x0, 0x5, 0x70, 0x0, 0x0, 0x5, 0x20, 0x0,
    0x2, 0x8, 0x0, 0x0, 0xb, 0xc3, 0x0, 0x0,

    /* U+7A "z" */
    0xaa, 0x66, 0xe4, 0x90, 0x4, 0xb0, 0x30, 0xd,
    0x20, 0x0, 0x78, 0x0, 0x1, 0xd0, 0x0, 0xa,
    0x50, 0x5, 0x4c, 0x0, 0x9, 0xc9, 0x66, 0xc8,

    /* U+7B "{" */
    0x0, 0x46, 0x1, 0x80, 0x3, 0x50, 0x4, 0x50,
    0x4, 0x50, 0x4, 0x50, 0x5, 0x40, 0x38, 0x0,
    0x27, 0x0, 0x5, 0x30, 0x4, 0x50, 0x4, 0x50,
    0x4, 0x50, 0x3, 0x50, 0x1, 0x80, 0x0, 0x46,

    /* U+7C "|" */
    0x21, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
    0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
    0x42, 0x42,

    /* U+7D "}" */
    0x64, 0x0, 0x8, 0x10, 0x5, 0x30, 0x5, 0x40,
    0x5, 0x40, 0x5, 0x40, 0x4, 0x50, 0x0, 0x83,
    0x0, 0x72, 0x3, 0x50, 0x5, 0x40, 0x5, 0x40,
    0x5, 0x40, 0x5, 0x30, 0x8, 0x10, 0x64, 0x0,

    /* U+7E "~" */
    0x4, 0x95, 0x0, 0x0, 0x5, 0xb, 0x30, 0x4,
    0x30, 0x1, 0xc1, 0x41, 0x0, 0x0, 0x3a, 0x50,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x49, 0xdc,
    0x0, 0x0, 0x0, 0x0, 0x16, 0xbf, 0xff, 0xff,
    0x0, 0x0, 0x3, 0x8d, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xff,
    0x0, 0x0, 0xff, 0xff, 0xea, 0x51, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x83, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x2b, 0xff, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0x2b, 0xff, 0xff, 0x0, 0x0, 0xdf, 0xff, 0xfd,
    0xdf, 0xff, 0xff, 0x0, 0x0, 0x2b, 0xff, 0xb2,
    0xdf, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xff, 0xb2, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0xd0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xd,
    0xff, 0xff, 0xc8, 0x88, 0x88, 0x8c, 0xff, 0xff,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xf0, 0xf, 0xec, 0xcc, 0xcc, 0xce, 0xf0, 0xf,
    0xf0, 0xf, 0xec, 0xcc, 0xcc, 0xce, 0xf0, 0xf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xf0, 0xf, 0x80, 0x0, 0x0, 0x8, 0xf0, 0xf,
    0xff, 0xff, 0xc8, 0x88, 0x88, 0x8c, 0xff, 0xff,
    0xd0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xd,

    /* U+F00B "" */
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdf, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xc0,
    0x1b, 0xa0, 0x0, 0x0, 0xb, 0xff, 0xfc, 0x0,
    0xcf, 0xfb, 0x0, 0x0, 0xbf, 0xff, 0xc0, 0x0,
    0xbf, 0xff, 0xb0, 0xb, 0xff, 0xfc, 0x0, 0x0,
    0xc, 0xff, 0xfb, 0xbf, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x3, 0x0, 0x0, 0x0, 0x3, 0x8, 0xfc, 0x10,
    0x0, 0x1c, 0xf8, 0xff, 0xfc, 0x10, 0x1c, 0xff,
    0xf5, 0xff, 0xfc, 0x2c, 0xff, 0xf5, 0x5, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x5, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x1d, 0xff, 0xfd, 0x10, 0x0, 0x1c,
    0xff, 0xff, 0xfc, 0x10, 0x1c, 0xff, 0xf9, 0xff,
    0xfc, 0x1c, 0xff, 0xf5, 0x5, 0xff, 0xfc, 0xdf,
    0xf5, 0x0, 0x5, 0xff, 0xd1, 0xa4, 0x0, 0x0,
    0x4, 0xa1,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x4f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x10, 0x6f, 0xf1, 0x3, 0x10, 0x0,
    0x0, 0x5f, 0xd0, 0x6f, 0xf1, 0x3f, 0xd1, 0x0,
    0x3, 0xff, 0xf1, 0x6f, 0xf1, 0x5f, 0xfd, 0x0,
    0xd, 0xff, 0x40, 0x6f, 0xf1, 0x9, 0xff, 0x70,
    0x4f, 0xf7, 0x0, 0x6f, 0xf1, 0x0, 0xcf, 0xe0,
    0x9f, 0xf0, 0x0, 0x6f, 0xf1, 0x0, 0x5f, 0xf3,
    0xbf, 0xc0, 0x0, 0x6f, 0xf1, 0x0, 0x2f, 0xf5,
    0xbf, 0xc0, 0x0, 0x4f, 0xe0, 0x0, 0x1f, 0xf6,
    0xaf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf4,
    0x6f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf0,
    0xf, 0xfe, 0x10, 0x0, 0x0, 0x5, 0xff, 0xa0,
    0x6, 0xff, 0xd3, 0x0, 0x0, 0x7f, 0xff, 0x20,
    0x0, 0x9f, 0xff, 0xda, 0xbe, 0xff, 0xf4, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xfd, 0x30, 0x0,
    0x0, 0x0, 0x17, 0xbd, 0xca, 0x50, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x8b, 0xb8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x30, 0x6, 0xff, 0xff, 0x60, 0x3, 0x0,
    0x4, 0xfd, 0xdf, 0xff, 0xff, 0xfd, 0xef, 0x40,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x4f, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff, 0xf4,
    0x8, 0xff, 0xff, 0x20, 0x2, 0xff, 0xff, 0x80,
    0x0, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0x0,
    0x0, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0x0,
    0x8, 0xff, 0xff, 0x20, 0x2, 0xff, 0xff, 0x80,
    0x4f, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff, 0xf4,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x4, 0xfe, 0xdf, 0xff, 0xff, 0xfd, 0xdf, 0x40,
    0x0, 0x30, 0x6, 0xff, 0xff, 0x60, 0x3, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8b, 0xb8, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x3, 0xdd, 0x30, 0x3f, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xf5, 0x4f,
    0xf4, 0x0, 0x0, 0x0, 0x9, 0xff, 0x99, 0xff,
    0xbf, 0xf4, 0x0, 0x0, 0x1, 0xbf, 0xf6, 0x22,
    0x6f, 0xff, 0xf4, 0x0, 0x0, 0x2d, 0xfe, 0x35,
    0xff, 0x53, 0xef, 0xf4, 0x0, 0x4, 0xff, 0xc1,
    0x8f, 0xff, 0xf8, 0x2d, 0xfe, 0x40, 0x7f, 0xfa,
    0x1a, 0xff, 0xff, 0xff, 0xa1, 0xaf, 0xf7, 0xcf,
    0x82, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x28, 0xfc,
    0x14, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x41, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0xf, 0xff, 0xf9, 0x0, 0x8f,
    0xff, 0xf0, 0x0, 0x0, 0xf, 0xff, 0xf8, 0x0,
    0x8f, 0xff, 0xf0, 0x0, 0x0, 0xf, 0xff, 0xf8,
    0x0, 0x8f, 0xff, 0xf0, 0x0, 0x0, 0xe, 0xff,
    0xf6, 0x0, 0x6f, 0xff, 0xe0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0xdf, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xfc, 0x1b, 0xb1, 0xcf, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xc2, 0x2c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe0, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F01C "" */
    0x0, 0x4, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40,
    0x0, 0x0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe1, 0x0, 0x0, 0xaf, 0xb0, 0x0, 0x0, 0x0,
    0xb, 0xfa, 0x0, 0x5, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x50, 0x1e, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xe1, 0xaf, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xfa, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8,

    /* U+F021 "" */
    0x0, 0x0, 0x6, 0xbd, 0xda, 0x50, 0x2, 0xff,
    0x0, 0x5, 0xef, 0xff, 0xff, 0xfe, 0x42, 0xff,
    0x0, 0x7f, 0xff, 0xa7, 0x7b, 0xff, 0xf9, 0xff,
    0x5, 0xff, 0xc1, 0x0, 0x0, 0x2c, 0xff, 0xff,
    0xe, 0xfc, 0x0, 0x0, 0x2, 0x22, 0xdf, 0xff,
    0x5f, 0xf2, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x8f, 0xb0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xb, 0xf8,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x2f, 0xf4,
    0xff, 0xfd, 0x22, 0x20, 0x0, 0x0, 0xcf, 0xe0,
    0xff, 0xff, 0xc2, 0x0, 0x0, 0x2c, 0xff, 0x40,
    0xff, 0x9f, 0xff, 0xb7, 0x6a, 0xff, 0xf7, 0x0,
    0xff, 0x24, 0xdf, 0xff, 0xff, 0xfe, 0x50, 0x0,
    0xff, 0x20, 0x5, 0xac, 0xdb, 0x60, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x8, 0xff, 0x0, 0x0, 0x8f, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x8, 0xff,
    0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0, 0x0,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0x1, 0x50, 0xff, 0xff,
    0xff, 0xff, 0x6, 0xf7, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xbe, 0xff, 0xff, 0xff, 0xff, 0x0, 0xae,
    0xff, 0xff, 0xff, 0xff, 0x5, 0xf8, 0xdf, 0xff,
    0xff, 0xff, 0x2, 0x60, 0x0, 0x0, 0x9f, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x3, 0xee, 0x10, 0x0, 0x0, 0x8, 0xff, 0x0,
    0xa, 0xb1, 0x2f, 0xb0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x5, 0xfc, 0x7, 0xf4, 0xdf, 0xff, 0xff,
    0xff, 0x2, 0x50, 0x5f, 0x60, 0xf9, 0xff, 0xff,
    0xff, 0xff, 0x6, 0xf7, 0xd, 0xc0, 0xbd, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xae, 0x9, 0xf0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xae, 0x9, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x6, 0xf7, 0xd,
    0xc0, 0xad, 0xdf, 0xff, 0xff, 0xff, 0x2, 0x50,
    0x5f, 0x60, 0xe9, 0x0, 0x0, 0x8f, 0xff, 0x0,
    0x5, 0xfc, 0x6, 0xf4, 0x0, 0x0, 0x8, 0xff,
    0x0, 0xa, 0xb1, 0x2f, 0xb0, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x2, 0xee, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x10, 0x0,

    /* U+F03E "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0xc, 0xff, 0xff, 0xee, 0xff, 0xff,
    0xff, 0x20, 0x2f, 0xff, 0xfe, 0x22, 0xef, 0xff,
    0xff, 0xfc, 0xff, 0xff, 0xe2, 0x0, 0x2e, 0xff,
    0xff, 0xfe, 0x4e, 0xfe, 0x20, 0x0, 0x2, 0xff,
    0xff, 0xe2, 0x2, 0xc2, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F048 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x30, 0x0,
    0x1, 0xcc, 0xff, 0x40, 0x0, 0x2d, 0xff, 0xff,
    0x40, 0x3, 0xef, 0xff, 0xff, 0x40, 0x3f, 0xff,
    0xff, 0xff, 0x44, 0xff, 0xff, 0xff, 0xff, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0x45, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x4f, 0xff, 0xff, 0xff, 0x40, 0x3, 0xef,
    0xff, 0xff, 0x40, 0x0, 0x2e, 0xff, 0xff, 0x30,
    0x0, 0x1, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xfd,
    0x40, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa,
    0x10, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb2, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd5, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa, 0x10,
    0x0, 0x0, 0xff, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x8e, 0xa1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xf8, 0x0, 0x8f, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xff,
    0xff, 0xff, 0x7f, 0xff, 0xf7, 0x0, 0x7f, 0xff,
    0xf7,

    /* U+F04D "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+F051 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x10, 0x0,
    0x3, 0xff, 0xff, 0xd2, 0x0, 0x4, 0xff, 0xff,
    0xfe, 0x30, 0x4, 0xff, 0xff, 0xff, 0xf4, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x54, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0xff, 0xff, 0xff, 0xff, 0x44, 0xff, 0xff,
    0xff, 0xf3, 0x4, 0xff, 0xff, 0xfe, 0x30, 0x4,
    0xff, 0xff, 0xd2, 0x0, 0x4, 0xff, 0xcc, 0x10,
    0x0, 0x3, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x2d, 0xd2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xfe, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x1a, 0x40, 0x0, 0x0, 0x1,
    0xdf, 0xf0, 0x0, 0x0, 0x1d, 0xff, 0xa0, 0x0,
    0x1, 0xdf, 0xfa, 0x0, 0x0, 0x1d, 0xff, 0xa0,
    0x0, 0x1, 0xdf, 0xfa, 0x0, 0x0, 0xc, 0xff,
    0xa0, 0x0, 0x0, 0xd, 0xff, 0x80, 0x0, 0x0,
    0x1, 0xdf, 0xf8, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0x80, 0x0, 0x0, 0x1, 0xdf, 0xf8, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0x80, 0x0, 0x0, 0x1, 0xdf,
    0xf0, 0x0, 0x0, 0x0, 0x1b, 0x50,

    /* U+F054 "" */
    0x4, 0xa1, 0x0, 0x0, 0x0, 0xf, 0xfd, 0x10,
    0x0, 0x0, 0xa, 0xff, 0xd1, 0x0, 0x0, 0x0,
    0xaf, 0xfd, 0x10, 0x0, 0x0, 0xa, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0xaf, 0xfd, 0x10, 0x0, 0x0,
    0xa, 0xff, 0xc0, 0x0, 0x0, 0x8, 0xff, 0xd0,
    0x0, 0x0, 0x8f, 0xfd, 0x10, 0x0, 0x8, 0xff,
    0xd1, 0x0, 0x0, 0x8f, 0xfd, 0x10, 0x0, 0x8,
    0xff, 0xd1, 0x0, 0x0, 0xf, 0xfd, 0x10, 0x0,
    0x0, 0x5, 0xb1, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x4, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x80, 0x0, 0x0, 0x48, 0x88, 0x8c, 0xff, 0xc8,
    0x88, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x48, 0x88, 0x8c, 0xff, 0xc8, 0x88, 0x84, 0x0,
    0x0, 0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x40,
    0x0, 0x0,

    /* U+F068 "" */
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x41, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7b, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xb7,

    /* U+F06E "" */
    0x0, 0x0, 0x5, 0xad, 0xff, 0xda, 0x50, 0x0,
    0x0, 0x0, 0x4, 0xdf, 0xfc, 0x88, 0xcf, 0xfd,
    0x40, 0x0, 0x0, 0x7f, 0xfe, 0x40, 0x0, 0x4,
    0xef, 0xf7, 0x0, 0x7, 0xff, 0xf4, 0x0, 0x9e,
    0x80, 0x4f, 0xff, 0x70, 0x4f, 0xff, 0xc0, 0x0,
    0xaf, 0xf8, 0xc, 0xff, 0xf4, 0xdf, 0xff, 0x80,
    0x9a, 0xff, 0xfe, 0x8, 0xff, 0xfd, 0xdf, 0xff,
    0x80, 0xef, 0xff, 0xfe, 0x8, 0xff, 0xfd, 0x4f,
    0xff, 0xc0, 0x8f, 0xff, 0xf8, 0xc, 0xff, 0xf4,
    0x7, 0xff, 0xf4, 0x8, 0xee, 0x80, 0x4f, 0xff,
    0x70, 0x0, 0x7f, 0xfe, 0x40, 0x0, 0x4, 0xef,
    0xf8, 0x0, 0x0, 0x4, 0xdf, 0xfc, 0x88, 0xcf,
    0xfd, 0x40, 0x0, 0x0, 0x0, 0x5, 0xad, 0xff,
    0xda, 0x50, 0x0, 0x0,

    /* U+F070 "" */
    0x8c, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xe4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1b, 0xff, 0x80, 0x49,
    0xdf, 0xfd, 0xa5, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xd8, 0x8c, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0x4, 0xef, 0xf8, 0x0, 0x0, 0x4e, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x1c, 0xff, 0x69, 0xe8,
    0x4, 0xff, 0xf7, 0x0, 0x4, 0xe3, 0x0, 0x9f,
    0xfe, 0xff, 0x80, 0xcf, 0xff, 0x40, 0xd, 0xff,
    0x70, 0x5, 0xff, 0xff, 0xe0, 0x8f, 0xff, 0xd0,
    0xd, 0xff, 0xf7, 0x0, 0x2d, 0xff, 0xe0, 0x8f,
    0xff, 0xd0, 0x4, 0xff, 0xfc, 0x0, 0x0, 0xaf,
    0xf8, 0xcf, 0xff, 0x30, 0x0, 0x7f, 0xff, 0x40,
    0x0, 0x6, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x8,
    0xff, 0xf4, 0x0, 0x0, 0x3e, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x4d, 0xff, 0xc8, 0x82, 0x1, 0xbf,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xdf, 0xfc,
    0x10, 0x8, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4e, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xc8,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xd2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xd8, 0x8d,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xa0, 0xa, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xb0, 0xb, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xc0, 0xc, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xd0, 0xd,
    0xff, 0xff, 0x50, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xf9, 0x9f, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xe2, 0x2e, 0xff, 0xff, 0xf8, 0x0,
    0x2, 0xff, 0xff, 0xff, 0x90, 0x9, 0xff, 0xff,
    0xff, 0x10, 0xa, 0xff, 0xff, 0xff, 0xe3, 0x3e,
    0xff, 0xff, 0xff, 0xa0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80,
    0xff, 0xff, 0x70, 0x0, 0x7, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xf6, 0x0, 0x6f, 0xff, 0xff, 0xfd,
    0x78, 0x8e, 0xff, 0x15, 0xff, 0xe8, 0xff, 0xe2,
    0x0, 0x2, 0xe5, 0x4f, 0xfe, 0x20, 0xfe, 0x20,
    0x0, 0x0, 0x13, 0xff, 0xf3, 0x0, 0x52, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0x31, 0x0, 0x52, 0x0,
    0x0, 0x2, 0xef, 0xf4, 0x5e, 0x20, 0xfe, 0x20,
    0x78, 0x8e, 0xff, 0x51, 0xff, 0xe8, 0xff, 0xe2,
    0xff, 0xff, 0xf6, 0x0, 0x6f, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0x70, 0x0, 0x7, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xdd, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0xfd, 0x10, 0x0, 0x0, 0x1d, 0xff, 0x99,
    0xff, 0xd1, 0x0, 0x1, 0xdf, 0xf9, 0x0, 0x9f,
    0xfd, 0x10, 0x1d, 0xff, 0x90, 0x0, 0x9, 0xff,
    0xd1, 0xbf, 0xf9, 0x0, 0x0, 0x0, 0x9f, 0xfb,
    0x5f, 0x90, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F078 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x90, 0x0, 0x0, 0x0, 0x9, 0xf5, 0xbf, 0xf9,
    0x0, 0x0, 0x0, 0x9f, 0xfb, 0x1d, 0xff, 0x90,
    0x0, 0x9, 0xff, 0xd1, 0x1, 0xdf, 0xf9, 0x0,
    0x9f, 0xfd, 0x10, 0x0, 0x1d, 0xff, 0x99, 0xff,
    0xd1, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x1d, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xfd, 0x10,
    0xef, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x1d, 0xff,
    0xff, 0xd1, 0xaf, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0xcf, 0xcf, 0xfc, 0xfc, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x6b, 0x1f, 0xf1, 0xb6, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x6b, 0x1f,
    0xf1, 0xb6, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0,
    0xcf, 0xcf, 0xfc, 0xfc, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xfa, 0x1d, 0xff, 0xff, 0xd1, 0x0, 0xd,
    0xff, 0xff, 0xff, 0xfe, 0x1, 0xdf, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F07B "" */
    0x8f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xf0, 0xdf, 0xfd, 0xf, 0xff, 0xfd,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe0, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xea,
    0x62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0x30, 0x0, 0x0, 0x2,
    0x0, 0x0, 0x4f, 0xff, 0x90, 0x0, 0x2, 0x8f,
    0xf3, 0x0, 0x6f, 0xff, 0xd0, 0x0, 0xa, 0xff,
    0xff, 0xe4, 0xbf, 0xff, 0xd1, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xd1, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xfb, 0x30, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xdb, 0x72, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F0C4 "" */
    0x8, 0xee, 0x80, 0x0, 0x0, 0x6, 0x61, 0x8,
    0xff, 0xff, 0x80, 0x0, 0x2d, 0xff, 0xd0, 0xef,
    0x33, 0xfe, 0x0, 0x2e, 0xff, 0xf3, 0xe, 0xf3,
    0x3f, 0xe0, 0x2e, 0xff, 0xf3, 0x0, 0x8f, 0xff,
    0xff, 0x6e, 0xff, 0xf3, 0x0, 0x0, 0x8e, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x8, 0xef, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x8, 0xff, 0xff, 0xf6, 0xef,
    0xff, 0x30, 0x0, 0xef, 0x33, 0xfe, 0x2, 0xef,
    0xff, 0x30, 0xe, 0xf3, 0x3f, 0xe0, 0x2, 0xef,
    0xff, 0x30, 0x8f, 0xff, 0xf8, 0x0, 0x2, 0xdf,
    0xfd, 0x0, 0x8e, 0xe8, 0x0, 0x0, 0x0, 0x66,
    0x10,

    /* U+F0C5 "" */
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xd, 0x20, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xf, 0xe2, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf, 0xfd, 0xdf, 0xf0, 0xff,
    0xff, 0xff, 0x20, 0x0, 0xff, 0xf0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xdf, 0xff,
    0xff, 0xff, 0xfd, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0,

    /* U+F0C7 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0xff, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xe2, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfc, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x11, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x11, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+F0E7 "" */
    0x0, 0xdf, 0xff, 0xfd, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x3, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xd0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0xe, 0xff, 0xff, 0xff, 0xff, 0x20,
    0xd, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xe0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x2f, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x4, 0xee, 0x40, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0x99, 0xff, 0xfd, 0x0, 0x0, 0xff, 0xff,
    0x99, 0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xd, 0xff, 0xff,
    0xd, 0x20, 0xff, 0xff, 0xf, 0xff, 0xff, 0xf,
    0xe2, 0xff, 0xff, 0xf, 0xff, 0xff, 0xf, 0xfd,
    0xff, 0xff, 0xf, 0xff, 0xff, 0x20, 0x0, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xf, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xfd,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x30, 0x0, 0x0, 0x0, 0x1,
    0xbf, 0xff, 0xfc, 0x20, 0x0, 0x0, 0x1e, 0xff,
    0xff, 0xff, 0xe1, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x1e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe1, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xee, 0x40, 0x0, 0x0,

    /* U+F11C "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xff, 0xff, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x8,
    0x80, 0x88, 0x8, 0x80, 0x8f, 0xff, 0xff, 0xf8,
    0x8, 0x80, 0x88, 0x8, 0x80, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf, 0x0,
    0xff, 0xff, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xaf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xdf, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x17,
    0xef, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0x18,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x2a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F15B "" */
    0xdf, 0xff, 0xff, 0xf0, 0xd2, 0x0, 0xff, 0xff,
    0xff, 0xf0, 0xfe, 0x20, 0xff, 0xff, 0xff, 0xf0,
    0xff, 0xe2, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x9c, 0xef, 0xfe,
    0xc9, 0x40, 0x0, 0x0, 0x0, 0x7, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x70, 0x0, 0x4, 0xdf,
    0xff, 0xfc, 0xa8, 0x8a, 0xcf, 0xff, 0xfd, 0x40,
    0x6f, 0xff, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x5d,
    0xff, 0xf6, 0xcf, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xfc, 0x1a, 0x30, 0x0, 0x5a,
    0xdf, 0xfd, 0xa5, 0x0, 0x3, 0xa1, 0x0, 0x0,
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xa8, 0x8a, 0xef, 0xff,
    0x50, 0x0, 0x0, 0x1, 0xdf, 0x70, 0x0, 0x0,
    0x7, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x12, 0x0,
    0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4e, 0xe4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4e, 0xe4, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F241 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F242 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F243 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0xf,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xf, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F244 "" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xfd, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xcf, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb9, 0x29, 0xfe, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x10, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xdf, 0x80, 0xa,
    0x90, 0x0, 0x0, 0x0, 0x3, 0x70, 0x0, 0xdf,
    0xff, 0x77, 0xf7, 0x55, 0x55, 0x55, 0x55, 0x8f,
    0xd3, 0xf, 0xff, 0xfd, 0xcc, 0xdf, 0xdc, 0xcc,
    0xcc, 0xcd, 0xff, 0xb0, 0x8f, 0xfe, 0x10, 0x0,
    0xaa, 0x0, 0x0, 0x0, 0x4d, 0x40, 0x0, 0x46,
    0x10, 0x0, 0x1, 0xf2, 0x2, 0x33, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb1, 0xcf,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x22,
    0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x18, 0xdf, 0xfd, 0x92, 0x0, 0x2, 0xef,
    0xfb, 0xef, 0xff, 0x30, 0xd, 0xff, 0xfa, 0x2e,
    0xff, 0xe0, 0x4f, 0xff, 0xfa, 0x3, 0xff, 0xf5,
    0x9f, 0xfa, 0xfa, 0x35, 0x4f, 0xfa, 0xcf, 0xc0,
    0x8a, 0x3d, 0xb, 0xfd, 0xef, 0xfb, 0x3, 0x12,
    0x8f, 0xfe, 0xff, 0xff, 0xb0, 0x6, 0xff, 0xff,
    0xff, 0xff, 0xd1, 0x8, 0xff, 0xff, 0xef, 0xfd,
    0x11, 0x10, 0x9f, 0xff, 0xdf, 0xd1, 0x59, 0x3b,
    0xb, 0xfd, 0xaf, 0xd7, 0xfa, 0x38, 0x1d, 0xfb,
    0x5f, 0xff, 0xfa, 0x1, 0xdf, 0xf7, 0xd, 0xff,
    0xfa, 0x1d, 0xff, 0xf1, 0x3, 0xef, 0xfc, 0xdf,
    0xff, 0x50, 0x0, 0x18, 0xdf, 0xfe, 0xa3, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x7f, 0xff, 0xf7, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xf, 0xf9, 0x9f, 0x99, 0xf9, 0x9f,
    0xf0, 0xf, 0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0,
    0xf, 0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf,
    0xf8, 0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8,
    0x8f, 0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8, 0x8f,
    0x88, 0xf8, 0x8f, 0xf0, 0xf, 0xf8, 0x8f, 0x88,
    0xf8, 0x8f, 0xf0, 0xf, 0xf9, 0x9f, 0x99, 0xf9,
    0x9f, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x8a, 0x1d,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfa,
    0x1d, 0xff, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xfa, 0x1d, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xde, 0xdb, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe4, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x1d, 0xff, 0xff,
    0xfa, 0xef, 0xfe, 0xaf, 0xff, 0xff, 0x1, 0xdf,
    0xff, 0xff, 0xa0, 0x2e, 0xe2, 0xa, 0xff, 0xff,
    0x1d, 0xff, 0xff, 0xff, 0xe2, 0x2, 0x20, 0x2e,
    0xff, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xfe, 0x20,
    0x2, 0xef, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x2, 0xef, 0xff, 0xff, 0x1d, 0xff,
    0xff, 0xff, 0xe2, 0x2, 0x20, 0x2e, 0xff, 0xff,
    0x1, 0xdf, 0xff, 0xff, 0xa0, 0x2e, 0xe2, 0xa,
    0xff, 0xff, 0x0, 0x1d, 0xff, 0xff, 0xfa, 0xef,
    0xfe, 0xaf, 0xff, 0xff, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F7C2 "" */
    0x0, 0x8, 0xff, 0xff, 0xff, 0xe4, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xfe, 0x8, 0xf8, 0xf, 0xb,
    0x40, 0xff, 0x8f, 0xf8, 0xf, 0xb, 0x40, 0xff,
    0xff, 0xf8, 0xf, 0xb, 0x40, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x2,
    0xef, 0x10, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf1, 0x0, 0xcf, 0xf1, 0x0, 0x0, 0x0,
    0x7, 0xff, 0x11, 0xcf, 0xff, 0x77, 0x77, 0x77,
    0x77, 0xbf, 0xf1, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x17, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x7, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 128, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 128, .box_w = 2, .box_h = 12, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 12, .adv_w = 128, .box_w = 6, .box_h = 5, .ofs_x = 1, .ofs_y = 9},
    {.bitmap_index = 27, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 75, .adv_w = 128, .box_w = 6, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 120, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 168, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 216, .adv_w = 128, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 226, .adv_w = 128, .box_w = 5, .box_h = 16, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 266, .adv_w = 128, .box_w = 5, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 306, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 342, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 378, .adv_w = 128, .box_w = 8, .box_h = 1, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 382, .adv_w = 128, .box_w = 2, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 385, .adv_w = 128, .box_w = 8, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 449, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 497, .adv_w = 128, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 533, .adv_w = 128, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 575, .adv_w = 128, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 617, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 665, .adv_w = 128, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 707, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 755, .adv_w = 128, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 797, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 845, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 893, .adv_w = 128, .box_w = 2, .box_h = 8, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 901, .adv_w = 128, .box_w = 2, .box_h = 10, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 911, .adv_w = 128, .box_w = 6, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 950, .adv_w = 128, .box_w = 8, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 966, .adv_w = 128, .box_w = 6, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1005, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1053, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1101, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1149, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1197, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1245, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1293, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1341, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1389, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1437, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1485, .adv_w = 128, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1521, .adv_w = 128, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1577, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1625, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1673, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1721, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1769, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1817, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1865, .adv_w = 128, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1921, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1969, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2017, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2065, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2113, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2161, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2209, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2257, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2305, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2353, .adv_w = 128, .box_w = 4, .box_h = 15, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 2383, .adv_w = 128, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2436, .adv_w = 128, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2466, .adv_w = 128, .box_w = 6, .box_h = 2, .ofs_x = 1, .ofs_y = 12},
    {.bitmap_index = 2472, .adv_w = 128, .box_w = 8, .box_h = 1, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2476, .adv_w = 128, .box_w = 4, .box_h = 2, .ofs_x = 1, .ofs_y = 12},
    {.bitmap_index = 2480, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2512, .adv_w = 128, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2564, .adv_w = 128, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2592, .adv_w = 128, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2644, .adv_w = 128, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2672, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2720, .adv_w = 128, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2760, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2808, .adv_w = 128, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2844, .adv_w = 128, .box_w = 6, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2886, .adv_w = 128, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2934, .adv_w = 128, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2970, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3002, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3034, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3066, .adv_w = 128, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3106, .adv_w = 128, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3146, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3178, .adv_w = 128, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3202, .adv_w = 128, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3235, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3267, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3299, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3331, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3363, .adv_w = 128, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3403, .adv_w = 128, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3427, .adv_w = 128, .box_w = 4, .box_h = 16, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 3459, .adv_w = 128, .box_w = 2, .box_h = 18, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 3477, .adv_w = 128, .box_w = 4, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3509, .adv_w = 128, .box_w = 8, .box_h = 4, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 3525, .adv_w = 256, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3661, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3757, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3869, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3965, .adv_w = 176, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4031, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4159, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4287, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4413, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4541, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4649, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4777, .adv_w = 128, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4833, .adv_w = 192, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4917, .adv_w = 288, .box_w = 18, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5061, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5157, .adv_w = 224, .box_w = 10, .box_h = 16, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 5237, .adv_w = 224, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5363, .adv_w = 224, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5468, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5566, .adv_w = 224, .box_w = 10, .box_h = 16, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 5646, .adv_w = 224, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 5758, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5828, .adv_w = 160, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5898, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5996, .adv_w = 224, .box_w = 14, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 6024, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6132, .adv_w = 320, .box_w = 20, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6292, .adv_w = 288, .box_w = 20, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 6452, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6580, .adv_w = 224, .box_w = 14, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 6650, .adv_w = 224, .box_w = 14, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 6720, .adv_w = 320, .box_w = 20, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6860, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6956, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7084, .adv_w = 256, .box_w = 17, .box_h = 17, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 7229, .adv_w = 224, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7334, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7446, .adv_w = 224, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7544, .adv_w = 160, .box_w = 12, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 7640, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7752, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7864, .adv_w = 288, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7972, .adv_w = 256, .box_w = 18, .box_h = 18, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 8134, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8230, .adv_w = 320, .box_w = 20, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8380, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8480, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8580, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8680, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8780, .adv_w = 320, .box_w = 20, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8880, .adv_w = 320, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9027, .adv_w = 224, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 9123, .adv_w = 224, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9235, .adv_w = 256, .box_w = 17, .box_h = 17, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 9380, .adv_w = 320, .box_w = 20, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9500, .adv_w = 192, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9596, .adv_w = 258, .box_w = 17, .box_h = 11, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 12, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 45, .range_length = 82, .glyph_id_start = 13,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 95,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_simsun_16 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 19,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0)
    .underline_position = -2,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};



#endif /*#if LV_FONT_SIMSUN_16*/

