#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 28 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef LV_FONT_SIMSUN_28
#define LV_FONT_SIMSUN_28 1
#endif

#if LV_FONT_SIMSUN_28

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+21 "!" */
    0x1e, 0xb0, 0x4f, 0xf0, 0x4f, 0xf1, 0x3f, 0xf0,
    0x1f, 0xe0, 0xf, 0xc0, 0xe, 0xa0, 0xc, 0x80,
    0xb, 0x70, 0xa, 0x60, 0x9, 0x50, 0x8, 0x50,
    0x7, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xe1, 0x9f, 0xf6, 0x3e, 0xd1,

    /* U+22 "\"" */
    0x0, 0x0, 0xbe, 0x10, 0x6e, 0x50, 0x0, 0x6f,
    0xf3, 0x1f, 0xf9, 0x0, 0xe, 0xf9, 0x9, 0xfd,
    0x10, 0x7, 0xf9, 0x2, 0xfd, 0x10, 0x1, 0xf9,
    0x0, 0xad, 0x10, 0x0, 0x89, 0x0, 0x3d, 0x10,
    0x0, 0x8, 0x0, 0x6, 0x10, 0x0, 0x0,

    /* U+23 "#" */
    0x0, 0x0, 0xe1, 0x0, 0x0, 0xd1, 0x0, 0x0,
    0xf, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xe0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x2d, 0x0, 0x0,
    0x1d, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1,
    0x16, 0xb1, 0x11, 0x15, 0xb1, 0x10, 0x0, 0x69,
    0x0, 0x0, 0x69, 0x0, 0x0, 0x8, 0x70, 0x0,
    0x7, 0x70, 0x0, 0x0, 0x96, 0x0, 0x0, 0x96,
    0x0, 0x0, 0xb, 0x40, 0x0, 0xa, 0x40, 0x0,
    0x0, 0xc3, 0x0, 0x0, 0xc3, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x1, 0x1f, 0x11, 0x11, 0x1f,
    0x11, 0x10, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x2,
    0xd0, 0x0, 0x2, 0xd0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x3c, 0x0, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x78, 0x0, 0x0, 0x0, 0x3, 0xbe, 0xed, 0x80,
    0x0, 0x5, 0xe3, 0x78, 0xc, 0xb0, 0x1, 0xf5,
    0x7, 0x80, 0x6f, 0x50, 0x7f, 0x10, 0x78, 0xb,
    0xf7, 0x8, 0xf2, 0x7, 0x80, 0xef, 0x30, 0x6f,
    0xa0, 0x78, 0x1, 0x10, 0x0, 0xef, 0x87, 0x80,
    0x0, 0x0, 0x4, 0xff, 0xe8, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xf4, 0x0, 0x0, 0x0, 0x1, 0xcf,
    0xf4, 0x0, 0x0, 0x0, 0x7, 0xef, 0xf3, 0x0,
    0x0, 0x0, 0x78, 0x6f, 0xe0, 0x0, 0x0, 0x7,
    0x80, 0x9f, 0x70, 0x48, 0x10, 0x78, 0x2, 0xfa,
    0xf, 0xf7, 0x7, 0x80, 0xf, 0xa1, 0xff, 0x40,
    0x78, 0x0, 0xf8, 0xc, 0xe0, 0x7, 0x80, 0x3f,
    0x20, 0x3e, 0x50, 0x78, 0x2c, 0x60, 0x0, 0x19,
    0xce, 0xfb, 0x30, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0,

    /* U+25 "%" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x2,
    0xcc, 0x90, 0x0, 0x1, 0xd0, 0x0, 0xd, 0x50,
    0xa7, 0x0, 0x7, 0x70, 0x0, 0x5e, 0x0, 0x5d,
    0x0, 0xd, 0x10, 0x0, 0x8c, 0x0, 0x3f, 0x10,
    0x49, 0x0, 0x0, 0xac, 0x0, 0x3f, 0x30, 0xa3,
    0x0, 0x0, 0x9c, 0x0, 0x3f, 0x21, 0xc0, 0x0,
    0x0, 0x8d, 0x0, 0x4f, 0x17, 0x50, 0x0, 0x0,
    0x4f, 0x0, 0x6d, 0xc, 0x0, 0x0, 0x0, 0xd,
    0x50, 0xc7, 0x58, 0x0, 0x0, 0x0, 0x1, 0xab,
    0x80, 0xb2, 0xa, 0xb8, 0x0, 0x0, 0x0, 0x2,
    0xb0, 0xa8, 0xa, 0x70, 0x0, 0x0, 0x8, 0x42,
    0xf1, 0x5, 0xe0, 0x0, 0x0, 0xc, 0x6, 0xe0,
    0x2, 0xf2, 0x0, 0x0, 0x57, 0x8, 0xd0, 0x1,
    0xf4, 0x0, 0x0, 0xb1, 0x8, 0xd0, 0x1, 0xf4,
    0x0, 0x2, 0x90, 0x6, 0xe0, 0x2, 0xf3, 0x0,
    0x9, 0x30, 0x2, 0xf0, 0x4, 0xf0, 0x0, 0xb,
    0x0, 0x0, 0xb6, 0x9, 0x90, 0x0, 0x45, 0x0,
    0x0, 0x1b, 0xdb, 0x10,

    /* U+26 "&" */
    0x0, 0x2, 0xba, 0xc5, 0x0, 0x0, 0x0, 0x0,
    0xd, 0x40, 0x3f, 0x20, 0x0, 0x0, 0x0, 0x5e,
    0x0, 0xf, 0x60, 0x0, 0x0, 0x0, 0x8d, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x2f,
    0x50, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x6e, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x51, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xcc, 0x50, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0xad, 0xdb, 0x30, 0x0,
    0xc9, 0xf6, 0x0, 0x9, 0xd0, 0x0, 0xa, 0x81,
    0xfd, 0x0, 0x8, 0x80, 0x0, 0x2f, 0x20, 0xaf,
    0x40, 0x9, 0x50, 0x0, 0x7f, 0x0, 0x2f, 0xc0,
    0xb, 0x20, 0x0, 0x9f, 0x0, 0x9, 0xf6, 0xd,
    0x0, 0x0, 0xaf, 0x10, 0x1, 0xff, 0x88, 0x0,
    0x0, 0x7f, 0x40, 0x0, 0x5f, 0xf2, 0x0, 0x0,
    0x2f, 0xb0, 0x0, 0xc, 0xfa, 0x0, 0x26, 0x7,
    0xfb, 0x54, 0x89, 0xaf, 0xb6, 0xc2, 0x0, 0x5d,
    0xfd, 0x60, 0x8, 0xfd, 0x50,

    /* U+27 "'" */
    0x9, 0xf9, 0x0, 0xff, 0xf3, 0x5, 0xff, 0x40,
    0x6, 0xf2, 0x0, 0x8c, 0x0, 0x3e, 0x20, 0x3b,
    0x20, 0x0, 0x0, 0x0,

    /* U+28 "(" */
    0x0, 0x0, 0x2, 0x40, 0x0, 0x2, 0xd2, 0x0,
    0x1, 0xd4, 0x0, 0x0, 0xb9, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x1e, 0x60, 0x0, 0x8, 0xe0, 0x0,
    0x0, 0xe8, 0x0, 0x0, 0x4f, 0x40, 0x0, 0x9,
    0xf0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0xf, 0xa0, 0x0,
    0x0, 0xeb, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x0,
    0x8f, 0x0, 0x0, 0x4, 0xf4, 0x0, 0x0, 0xe,
    0xa0, 0x0, 0x0, 0x7f, 0x10, 0x0, 0x0, 0xe8,
    0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x9, 0xb0,
    0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0xc, 0x50,
    0x0, 0x0, 0x2,

    /* U+29 ")" */
    0x51, 0x0, 0x0, 0x4, 0xd1, 0x0, 0x0, 0x6,
    0xc0, 0x0, 0x0, 0xa, 0x90, 0x0, 0x0, 0x1f,
    0x40, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x1, 0xf6,
    0x0, 0x0, 0xa, 0xd0, 0x0, 0x0, 0x5f, 0x30,
    0x0, 0x1, 0xf7, 0x0, 0x0, 0xf, 0xa0, 0x0,
    0x0, 0xdc, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0xd, 0xc0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x2f, 0x60, 0x0, 0x6, 0xf2, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x2f, 0x50, 0x0, 0xa,
    0xc0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0xd7, 0x0,
    0x0, 0x9a, 0x0, 0x0, 0x7a, 0x0, 0x0, 0x2,
    0x0, 0x0, 0x0,

    /* U+2A "*" */
    0x0, 0x0, 0x0, 0x45, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x45, 0x0, 0xd, 0xd0,
    0x0, 0x63, 0xf, 0xfa, 0x0, 0xba, 0x0, 0xcf,
    0xd0, 0x8f, 0xfb, 0x8, 0x71, 0xcf, 0xf7, 0x0,
    0x18, 0xec, 0x66, 0xdd, 0x71, 0x0, 0x0, 0x0,
    0x5c, 0xb4, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xaa,
    0xc5, 0x0, 0x0, 0x29, 0xff, 0x57, 0x56, 0xfe,
    0x81, 0xe, 0xff, 0x40, 0xa8, 0x5, 0xff, 0xc0,
    0xcd, 0x30, 0xd, 0xa0, 0x4, 0xdb, 0x0, 0x0,
    0x0, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdb, 0x0,
    0x0, 0x0,

    /* U+2B "+" */
    0x0, 0x0, 0x2, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5a, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xa0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x5, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x50, 0x0,
    0x0, 0x0,

    /* U+2D "-" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+2E "." */
    0x0, 0x40, 0x0, 0xdf, 0xd0, 0x1f, 0xff, 0x10,
    0x9f, 0x90,

    /* U+2F "/" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x87, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x68, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x5, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x87, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x3, 0xbe, 0xea, 0x20, 0x0, 0x0, 0x4f,
    0x90, 0x8, 0xf3, 0x0, 0x1, 0xec, 0x0, 0x0,
    0xbe, 0x0, 0x8, 0xf5, 0x0, 0x0, 0x4f, 0x70,
    0xe, 0xf0, 0x0, 0x0, 0xf, 0xd0, 0x3f, 0xb0,
    0x0, 0x0, 0xc, 0xf2, 0x7f, 0x90, 0x0, 0x0,
    0xa, 0xf5, 0x9f, 0x70, 0x0, 0x0, 0x9, 0xf7,
    0xaf, 0x60, 0x0, 0x0, 0x8, 0xf8, 0xaf, 0x60,
    0x0, 0x0, 0x8, 0xf9, 0xaf, 0x60, 0x0, 0x0,
    0x8, 0xf8, 0x9f, 0x70, 0x0, 0x0, 0x9, 0xf7,
    0x7f, 0x90, 0x0, 0x0, 0xa, 0xf5, 0x4f, 0xb0,
    0x0, 0x0, 0xd, 0xf2, 0xf, 0xf0, 0x0, 0x0,
    0xf, 0xd0, 0x9, 0xf4, 0x0, 0x0, 0x5f, 0x70,
    0x1, 0xec, 0x0, 0x0, 0xce, 0x0, 0x0, 0x4f,
    0x90, 0x8, 0xf3, 0x0, 0x0, 0x2, 0xbe, 0xea,
    0x20, 0x0,

    /* U+31 "1" */
    0x0, 0x3, 0xd0, 0x0, 0x8, 0xad, 0xff, 0x0,
    0x0, 0x0, 0xd, 0xf0, 0x0, 0x0, 0x0, 0xcf,
    0x0, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0x0,
    0xcf, 0x0, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0,
    0x0, 0xcf, 0x0, 0x0, 0x0, 0xc, 0xf0, 0x0,
    0x0, 0x0, 0xcf, 0x0, 0x0, 0x0, 0xc, 0xf0,
    0x0, 0x0, 0x0, 0xcf, 0x0, 0x0, 0x0, 0xc,
    0xf0, 0x0, 0x0, 0x0, 0xcf, 0x0, 0x0, 0x0,
    0xc, 0xf0, 0x0, 0x0, 0x0, 0xcf, 0x0, 0x0,
    0x0, 0xc, 0xf0, 0x0, 0x0, 0x1, 0xff, 0x40,
    0x0, 0x8b, 0xef, 0xff, 0xba, 0x10,

    /* U+32 "2" */
    0x0, 0x6, 0xbc, 0xdd, 0x80, 0x0, 0x1, 0xc8,
    0x0, 0x3, 0xed, 0x0, 0xb, 0xb0, 0x0, 0x0,
    0x5f, 0x80, 0x1f, 0x80, 0x0, 0x0, 0xf, 0xe0,
    0x3f, 0xe0, 0x0, 0x0, 0xd, 0xf0, 0x1f, 0xf3,
    0x0, 0x0, 0xe, 0xe0, 0x3, 0x40, 0x0, 0x0,
    0x2f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x40,
    0x0, 0x0, 0x0, 0x2, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xab,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x7b, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x5c, 0x0, 0x0,
    0x0, 0x52, 0x2, 0xd1, 0x0, 0x0, 0x0, 0xb1,
    0xd, 0x30, 0x0, 0x0, 0x4, 0xe0, 0x7e, 0xaa,
    0xaa, 0xaa, 0xbf, 0xc0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xa0,

    /* U+33 "3" */
    0x0, 0x18, 0xbc, 0xdb, 0x30, 0x0, 0x3, 0xe3,
    0x0, 0x9, 0xf5, 0x0, 0xd, 0xc0, 0x0, 0x0,
    0xdf, 0x10, 0xf, 0xf0, 0x0, 0x0, 0x8f, 0x60,
    0xb, 0xe0, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xec, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xb0, 0x0,
    0x0, 0x0, 0x8e, 0xfa, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x28, 0xe4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x30, 0x0, 0x0, 0x0, 0x0, 0xf, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf1, 0x3, 0x30,
    0x0, 0x0, 0xb, 0xf3, 0x2f, 0xf0, 0x0, 0x0,
    0xc, 0xf2, 0x5f, 0xf0, 0x0, 0x0, 0xf, 0xe0,
    0x1f, 0xc0, 0x0, 0x0, 0x5f, 0x50, 0x5, 0xf4,
    0x0, 0x5, 0xf8, 0x0, 0x0, 0x3a, 0xcc, 0xdb,
    0x40, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0x10, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x4a, 0xbf, 0x10, 0x0, 0x0, 0x0, 0x0, 0xc1,
    0xbf, 0x10, 0x0, 0x0, 0x0, 0x9, 0x50, 0xbf,
    0x10, 0x0, 0x0, 0x0, 0x4a, 0x0, 0xbf, 0x10,
    0x0, 0x0, 0x0, 0xc1, 0x0, 0xbf, 0x10, 0x0,
    0x0, 0x8, 0x50, 0x0, 0xbf, 0x10, 0x0, 0x0,
    0x3b, 0x0, 0x0, 0xbf, 0x10, 0x0, 0x0, 0xc1,
    0x0, 0x0, 0xbf, 0x10, 0x0, 0x8, 0x60, 0x0,
    0x0, 0xbf, 0x10, 0x0, 0xc, 0xaa, 0xaa, 0xaa,
    0xef, 0xaa, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x30, 0x0, 0x0, 0x0,
    0x5, 0xad, 0xff, 0xfb, 0x70,

    /* U+35 "5" */
    0x1, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x2, 0xea,
    0xaa, 0xaa, 0xaa, 0x60, 0x3, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x80, 0x0, 0x0, 0x0, 0x0, 0x5, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x6, 0x62, 0xae, 0xfd,
    0x80, 0x0, 0x7, 0x7d, 0x62, 0x28, 0xfb, 0x0,
    0x8, 0xe2, 0x0, 0x0, 0x8f, 0x60, 0x4, 0x40,
    0x0, 0x0, 0x1f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf3, 0xb, 0xc0,
    0x0, 0x0, 0xa, 0xf2, 0x4f, 0xf1, 0x0, 0x0,
    0xc, 0xf0, 0x4f, 0xc0, 0x0, 0x0, 0xf, 0xb0,
    0xe, 0x80, 0x0, 0x0, 0x7f, 0x40, 0x3, 0xd4,
    0x0, 0x4, 0xf8, 0x0, 0x0, 0x18, 0xcc, 0xcb,
    0x50, 0x0,

    /* U+36 "6" */
    0x0, 0x0, 0x5b, 0xbc, 0xc4, 0x0, 0x0, 0xb,
    0x91, 0x0, 0xaf, 0x40, 0x0, 0xa9, 0x0, 0x0,
    0xaf, 0x70, 0x4, 0xf1, 0x0, 0x0, 0x3, 0x0,
    0xc, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x6c, 0xfe,
    0xa2, 0x0, 0x7f, 0x79, 0xc4, 0x25, 0xef, 0x20,
    0x9f, 0xba, 0x0, 0x0, 0x3f, 0xb0, 0xaf, 0xe1,
    0x0, 0x0, 0xa, 0xf2, 0xaf, 0x80, 0x0, 0x0,
    0x6, 0xf6, 0xaf, 0x60, 0x0, 0x0, 0x5, 0xf8,
    0x8f, 0x70, 0x0, 0x0, 0x4, 0xf8, 0x6f, 0x90,
    0x0, 0x0, 0x5, 0xf7, 0x2f, 0xd0, 0x0, 0x0,
    0x6, 0xf5, 0xd, 0xf2, 0x0, 0x0, 0x9, 0xf1,
    0x4, 0xfb, 0x0, 0x0, 0xe, 0x80, 0x0, 0x8f,
    0x80, 0x0, 0xab, 0x0, 0x0, 0x4, 0xbd, 0xcc,
    0x60, 0x0,

    /* U+37 "7" */
    0x9, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xb, 0xfd,
    0xaa, 0xaa, 0xab, 0xe0, 0xe, 0x70, 0x0, 0x0,
    0xa, 0x60, 0x1d, 0x0, 0x0, 0x0, 0x2c, 0x0,
    0x25, 0x0, 0x0, 0x0, 0xb4, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x9, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x50, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x50,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x30,
    0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x18, 0xcc, 0xcc, 0x70, 0x0, 0x2, 0xe7,
    0x0, 0x1, 0xac, 0x10, 0xd, 0xa0, 0x0, 0x0,
    0xe, 0xa0, 0x3f, 0x40, 0x0, 0x0, 0x8, 0xf0,
    0x5f, 0x30, 0x0, 0x0, 0x6, 0xf1, 0x3f, 0xa0,
    0x0, 0x0, 0x8, 0xf0, 0xc, 0xf7, 0x0, 0x0,
    0xd, 0x80, 0x2, 0xef, 0xb2, 0x0, 0xab, 0x0,
    0x0, 0x2b, 0xff, 0xbc, 0x70, 0x0, 0x0, 0x3c,
    0x8d, 0xff, 0x80, 0x0, 0x4, 0xf3, 0x0, 0x5e,
    0xfb, 0x0, 0x1f, 0x70, 0x0, 0x1, 0xcf, 0x90,
    0x7f, 0x10, 0x0, 0x0, 0x1e, 0xf1, 0xad, 0x0,
    0x0, 0x0, 0x7, 0xf4, 0xcc, 0x0, 0x0, 0x0,
    0x5, 0xf5, 0x9e, 0x0, 0x0, 0x0, 0x7, 0xf2,
    0x2f, 0x50, 0x0, 0x0, 0xd, 0xb0, 0x4, 0xe6,
    0x0, 0x1, 0x9c, 0x10, 0x0, 0x19, 0xcc, 0xcc,
    0x70, 0x0,

    /* U+39 "9" */
    0x0, 0x19, 0xdc, 0xca, 0x30, 0x0, 0x2, 0xe9,
    0x0, 0x4, 0xf5, 0x0, 0xd, 0xd0, 0x0, 0x0,
    0x7f, 0x20, 0x5f, 0x70, 0x0, 0x0, 0xf, 0xa0,
    0x9f, 0x30, 0x0, 0x0, 0xc, 0xf0, 0xcf, 0x10,
    0x0, 0x0, 0xa, 0xf3, 0xcf, 0x10, 0x0, 0x0,
    0xa, 0xf5, 0xbf, 0x20, 0x0, 0x0, 0xc, 0xf6,
    0x8f, 0x60, 0x0, 0x0, 0x3f, 0xf7, 0x3f, 0xd0,
    0x0, 0x0, 0xcc, 0xf6, 0x8, 0xfb, 0x20, 0x3c,
    0x5b, 0xf5, 0x0, 0x5c, 0xfe, 0xb4, 0xd, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x60, 0x3, 0x91, 0x0, 0x0, 0xce, 0x0,
    0xc, 0xf6, 0x0, 0x5, 0xf4, 0x0, 0x9, 0xf9,
    0x0, 0x4e, 0x70, 0x0, 0x0, 0x7d, 0xcc, 0xa3,
    0x0, 0x0,

    /* U+3A ":" */
    0x0, 0x0, 0x5f, 0xd1, 0xbf, 0xf4, 0x4e, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xd1,
    0xbf, 0xf4, 0x4e, 0xc0,

    /* U+3B ";" */
    0x6f, 0xf1, 0x6f, 0xf1, 0x26, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x26, 0x60, 0x6f, 0xf1,
    0x6f, 0xf1, 0x8, 0xd0, 0xd, 0x60, 0x3e, 0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0x50, 0x0, 0x0, 0x0, 0x1,
    0xd6, 0x0, 0x0, 0x0, 0x0, 0x1d, 0x60, 0x0,
    0x0, 0x0, 0x1, 0xd6, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0x60, 0x0, 0x0, 0x0, 0x1, 0xd6, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0x60, 0x0, 0x0, 0x0,
    0x1, 0xd6, 0x0, 0x0, 0x0, 0x0, 0xd, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9a, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60,

    /* U+3D "=" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0,

    /* U+3E ">" */
    0xa, 0x10, 0x0, 0x0, 0x0, 0x0, 0x6, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6d,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x6, 0xd1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6d, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0x90, 0x0, 0x0, 0x0, 0x0, 0xa9, 0x0,
    0x0, 0x0, 0x0, 0xa, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xaa, 0x0, 0x0, 0x0, 0x0, 0xa, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xaa,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x0, 0x6, 0xcf, 0xfd, 0x81, 0x0, 0x1, 0xc9,
    0x30, 0x14, 0xde, 0x30, 0xb, 0x50, 0x0, 0x0,
    0xe, 0xe0, 0x4d, 0x0, 0x0, 0x0, 0x8, 0xf5,
    0x8e, 0x20, 0x0, 0x0, 0x6, 0xf8, 0x8f, 0xf0,
    0x0, 0x0, 0x7, 0xf8, 0x2e, 0xd0, 0x0, 0x0,
    0xb, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xd0,
    0x0, 0x0, 0x0, 0x7, 0xfc, 0x10, 0x0, 0x0,
    0x0, 0xbe, 0x60, 0x0, 0x0, 0x0, 0x7, 0xc1,
    0x0, 0x0, 0x0, 0x0, 0xb, 0x30, 0x0, 0x0,
    0x0, 0x0, 0xc, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x10, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xc0,
    0x0, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x7c, 0xcc, 0xa2, 0x0, 0x0, 0x1,
    0xc8, 0x0, 0x3, 0xd5, 0x0, 0x0, 0xc7, 0x0,
    0x0, 0x1, 0xd2, 0x0, 0x7c, 0x0, 0x8, 0xa8,
    0xc5, 0x90, 0xf, 0x50, 0xa, 0x90, 0xcb, 0xe,
    0x5, 0xf0, 0x4, 0xe0, 0xb, 0x90, 0xd2, 0x9d,
    0x0, 0xc7, 0x0, 0xe7, 0xb, 0x4c, 0xb0, 0x2f,
    0x20, 0xf, 0x50, 0xa5, 0xda, 0x7, 0xe0, 0x2,
    0xf3, 0xa, 0x5e, 0xa0, 0xac, 0x0, 0x4f, 0x0,
    0xb4, 0xda, 0xc, 0xa0, 0x6, 0xe0, 0xd, 0x2c,
    0xb0, 0xd9, 0x0, 0xac, 0x0, 0xe0, 0xad, 0xb,
    0x90, 0xe, 0xa0, 0x68, 0x6, 0xf0, 0x7c, 0x9,
    0xac, 0x4d, 0x10, 0x1f, 0x40, 0xbd, 0x51, 0xdc,
    0x20, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x0, 0xc0,
    0x1, 0xe5, 0x0, 0x0, 0x0, 0xb5, 0x0, 0x3,
    0xe7, 0x0, 0x4, 0xc7, 0x0, 0x0, 0x1, 0x9d,
    0xed, 0xa3, 0x0, 0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xaf, 0x50, 0x0, 0x0, 0x0, 0x0, 0xd, 0x2f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xd, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x59, 0x9, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x95, 0x5, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xd1, 0x2, 0xf8, 0x0, 0x0, 0x0,
    0x1, 0xd0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x5,
    0x90, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x9, 0x50,
    0x0, 0x6f, 0x30, 0x0, 0x0, 0xd, 0xaa, 0xaa,
    0xbf, 0x70, 0x0, 0x0, 0x1c, 0x0, 0x0, 0xf,
    0xb0, 0x0, 0x0, 0x58, 0x0, 0x0, 0xc, 0xf0,
    0x0, 0x0, 0x95, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0xd1, 0x0, 0x0, 0x5, 0xf6, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x1, 0xfa, 0x0, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0xfe, 0x0, 0x8f, 0xfc, 0x20,
    0x0, 0x2c, 0xff, 0xd4,

    /* U+42 "B" */
    0x3b, 0xff, 0xda, 0xac, 0xda, 0x30, 0x0, 0x0,
    0xcf, 0x10, 0x0, 0x2c, 0xf4, 0x0, 0x0, 0xbf,
    0x0, 0x0, 0x1, 0xfd, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0x0, 0xcf, 0x10, 0x0, 0xbf, 0x0, 0x0,
    0x0, 0xbf, 0x10, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0xef, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x4, 0xf8,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x5e, 0x80, 0x0,
    0x0, 0xbf, 0xaa, 0xad, 0xf6, 0x0, 0x0, 0x0,
    0xbf, 0x0, 0x0, 0x2b, 0xd2, 0x0, 0x0, 0xbf,
    0x0, 0x0, 0x0, 0xde, 0x10, 0x0, 0xbf, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0xbf, 0x0, 0x0,
    0x0, 0x2f, 0xd0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x1f, 0xf0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x1f,
    0xf0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x4f, 0xc0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0xbf, 0x50, 0x0,
    0xcf, 0x10, 0x0, 0x8, 0xf9, 0x0, 0x6b, 0xff,
    0xda, 0xab, 0xdb, 0x40, 0x0,

    /* U+43 "C" */
    0x0, 0x0, 0x7, 0xcc, 0xdf, 0xff, 0x20, 0x0,
    0x3, 0xe9, 0x10, 0x2, 0xcf, 0x50, 0x0, 0x1e,
    0xb0, 0x0, 0x0, 0xd, 0x80, 0x0, 0xaf, 0x20,
    0x0, 0x0, 0x4, 0xc0, 0x2, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xb0, 0x8, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x40, 0x6, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xb0, 0x1, 0xfe, 0x0, 0x0, 0x0, 0x7, 0x50,
    0x0, 0x7f, 0x80, 0x0, 0x0, 0x3b, 0x0, 0x0,
    0x8, 0xf9, 0x20, 0x16, 0xc1, 0x0, 0x0, 0x0,
    0x3a, 0xef, 0xe8, 0x10, 0x0,

    /* U+44 "D" */
    0x3b, 0xff, 0xda, 0xab, 0x70, 0x0, 0x0, 0x0,
    0xcf, 0x10, 0x1, 0x9e, 0x30, 0x0, 0x0, 0xbf,
    0x0, 0x0, 0x9, 0xf3, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x0, 0xbf, 0x0, 0x0,
    0x0, 0xaf, 0x40, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x6f, 0x90, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x3f,
    0xc0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0x1f, 0xf0, 0x0,
    0xbf, 0x0, 0x0, 0x0, 0x1f, 0xf0, 0x0, 0xbf,
    0x0, 0x0, 0x0, 0x1f, 0xf0, 0x0, 0xbf, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0xbf, 0x0, 0x0,
    0x0, 0x4f, 0xb0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x6f, 0x80, 0x0, 0xbf, 0x0, 0x0, 0x0, 0xbf,
    0x20, 0x0, 0xbf, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0xb, 0xe2, 0x0, 0x0,
    0xcf, 0x10, 0x2, 0xcd, 0x30, 0x0, 0x4b, 0xff,
    0xea, 0xbb, 0x60, 0x0, 0x0,

    /* U+45 "E" */
    0x1a, 0xff, 0xda, 0xaa, 0xbe, 0xfc, 0x0, 0x0,
    0xaf, 0x20, 0x0, 0x0, 0xaf, 0x10, 0x0, 0x9f,
    0x20, 0x0, 0x0, 0xb, 0x60, 0x0, 0x9f, 0x20,
    0x0, 0x0, 0x1, 0x80, 0x0, 0x9f, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x4,
    0x0, 0x0, 0x0, 0x9f, 0x20, 0x0, 0xa, 0x10,
    0x0, 0x0, 0x9f, 0x20, 0x0, 0x2e, 0x10, 0x0,
    0x0, 0x9f, 0xba, 0xab, 0xff, 0x10, 0x0, 0x0,
    0x9f, 0x20, 0x0, 0x3f, 0x10, 0x0, 0x0, 0x9f,
    0x20, 0x0, 0xb, 0x10, 0x0, 0x0, 0x9f, 0x20,
    0x0, 0x9, 0x10, 0x0, 0x0, 0x9f, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x0,
    0x40, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x0, 0xb0,
    0x0, 0x9f, 0x20, 0x0, 0x0, 0x7, 0x90, 0x0,
    0xaf, 0x30, 0x0, 0x0, 0x7f, 0x50, 0x2b, 0xff,
    0xea, 0xaa, 0xce, 0xff, 0x10,

    /* U+46 "F" */
    0x2a, 0xff, 0xea, 0xaa, 0xbe, 0xff, 0x40, 0x0,
    0xaf, 0x30, 0x0, 0x0, 0x6f, 0xa0, 0x0, 0x9f,
    0x20, 0x0, 0x0, 0x4, 0xe0, 0x0, 0x9f, 0x20,
    0x0, 0x0, 0x0, 0x84, 0x0, 0x9f, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x2, 0x80,
    0x0, 0x0, 0x9f, 0x20, 0x0, 0x4, 0x80, 0x0,
    0x0, 0x9f, 0x20, 0x0, 0xa, 0x80, 0x0, 0x0,
    0x9f, 0xba, 0xaa, 0xef, 0x80, 0x0, 0x0, 0x9f,
    0x20, 0x0, 0xa, 0x80, 0x0, 0x0, 0x9f, 0x20,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x9f, 0x20, 0x0,
    0x0, 0x30, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xff,
    0xd9, 0x0, 0x0, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x0, 0x3a, 0xcd, 0xff, 0xf0, 0x0, 0x0,
    0x5, 0xf6, 0x0, 0x1c, 0xf3, 0x0, 0x0, 0x2f,
    0x70, 0x0, 0x0, 0xd6, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0x0, 0x59, 0x0, 0x3, 0xf6, 0x0, 0x0,
    0x0, 0x9, 0x0, 0x9, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xc0,
    0x0, 0x0, 0xac, 0xdd, 0xb4, 0x1f, 0xd0, 0x0,
    0x0, 0x3, 0xfd, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0xfb, 0x0, 0xb, 0xf2, 0x0, 0x0, 0x0,
    0xfb, 0x0, 0x6, 0xf6, 0x0, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0xfb, 0x0,
    0x0, 0x7f, 0x40, 0x0, 0x2, 0xfb, 0x0, 0x0,
    0xa, 0xe4, 0x0, 0xb, 0xc8, 0x0, 0x0, 0x0,
    0x5c, 0xcc, 0xb5, 0x0, 0x0,

    /* U+48 "H" */
    0x4c, 0xff, 0xb1, 0x0, 0x2b, 0xff, 0xc3, 0x1,
    0xfc, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0x0, 0xde, 0x0, 0x0, 0xfb, 0x0,
    0x0, 0x0, 0xde, 0x0, 0x0, 0xfb, 0x0, 0x0,
    0x0, 0xde, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0,
    0xde, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0xde,
    0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0xde, 0x0,
    0x0, 0xfb, 0x0, 0x0, 0x0, 0xde, 0x0, 0x0,
    0xfe, 0xaa, 0xaa, 0xaa, 0xfe, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0x0, 0xde, 0x0, 0x0, 0xfb, 0x0,
    0x0, 0x0, 0xde, 0x0, 0x0, 0xfb, 0x0, 0x0,
    0x0, 0xde, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0,
    0xde, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0xde,
    0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0xde, 0x0,
    0x0, 0xfb, 0x0, 0x0, 0x0, 0xde, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0xdf, 0x0, 0x6c, 0xff,
    0xb2, 0x0, 0x3b, 0xff, 0xc4,

    /* U+49 "I" */
    0x3a, 0xab, 0xff, 0xca, 0xa3, 0x0, 0x0, 0xee,
    0x0, 0x0, 0x0, 0x0, 0xee, 0x0, 0x0, 0x0,
    0x0, 0xee, 0x0, 0x0, 0x0, 0x0, 0xee, 0x0,
    0x0, 0x0, 0x0, 0xee, 0x0, 0x0, 0x0, 0x0,
    0xee, 0x0, 0x0, 0x0, 0x0, 0xee, 0x0, 0x0,
    0x0, 0x0, 0xee, 0x0, 0x0, 0x0, 0x0, 0xee,
    0x0, 0x0, 0x0, 0x0, 0xee, 0x0, 0x0, 0x0,
    0x0, 0xee, 0x0, 0x0, 0x0, 0x0, 0xee, 0x0,
    0x0, 0x0, 0x0, 0xee, 0x0, 0x0, 0x0, 0x0,
    0xee, 0x0, 0x0, 0x0, 0x0, 0xee, 0x0, 0x0,
    0x0, 0x0, 0xee, 0x0, 0x0, 0x0, 0x0, 0xee,
    0x0, 0x0, 0x4a, 0xac, 0xff, 0xca, 0xa4,

    /* U+4A "J" */
    0x0, 0x0, 0x6a, 0xac, 0xff, 0xba, 0xa3, 0x0,
    0x0, 0x0, 0x1, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x4, 0x70,
    0x0, 0x2, 0xf7, 0x0, 0x0, 0xf, 0xf5, 0x0,
    0x7, 0xf1, 0x0, 0x0, 0xb, 0xf5, 0x0, 0x5e,
    0x40, 0x0, 0x0, 0x1, 0x8c, 0xcb, 0x81, 0x0,
    0x0, 0x0,

    /* U+4B "K" */
    0x3b, 0xff, 0xd7, 0x0, 0x9e, 0xff, 0x80, 0x0,
    0xcf, 0x10, 0x0, 0x8, 0xc1, 0x0, 0x0, 0xbf,
    0x0, 0x0, 0x1d, 0x10, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0xb5, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x6,
    0x90, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x2c, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x0, 0xb2, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x7, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x3d, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xd2, 0xcf, 0x10, 0x0, 0x0, 0x0, 0xbf,
    0x70, 0x4f, 0x80, 0x0, 0x0, 0x0, 0xbf, 0x0,
    0xd, 0xf1, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x6,
    0xf7, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0xee,
    0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x7f, 0x60,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x1f, 0xd0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x9, 0xf5, 0x0, 0x0,
    0xcf, 0x10, 0x0, 0x3, 0xfd, 0x0, 0x3b, 0xff,
    0xd7, 0x0, 0x2d, 0xff, 0xd4,

    /* U+4C "L" */
    0xa, 0xef, 0xea, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x0, 0x0,
    0x40, 0x0, 0x6f, 0x60, 0x0, 0x0, 0x0, 0xb0,
    0x0, 0x6f, 0x60, 0x0, 0x0, 0x5, 0xb0, 0x0,
    0x6f, 0x60, 0x0, 0x0, 0x5f, 0x70, 0x1a, 0xef,
    0xeb, 0xaa, 0xbe, 0xff, 0x40,

    /* U+4D "M" */
    0x8e, 0xf7, 0x0, 0x0, 0x0, 0xef, 0xe7, 0x6,
    0xfb, 0x0, 0x0, 0x2, 0xff, 0x40, 0x5, 0xfe,
    0x0, 0x0, 0x6, 0xff, 0x40, 0x5, 0xcf, 0x20,
    0x0, 0xa, 0xaf, 0x40, 0x5, 0x8f, 0x50, 0x0,
    0xc, 0x8f, 0x40, 0x5, 0x5f, 0x80, 0x0, 0x1a,
    0x8f, 0x40, 0x5, 0x4c, 0xc0, 0x0, 0x47, 0x8f,
    0x40, 0x5, 0x49, 0xf0, 0x0, 0x83, 0x8f, 0x40,
    0x5, 0x45, 0xf3, 0x0, 0xb0, 0x8f, 0x40, 0x5,
    0x42, 0xf6, 0x0, 0xb0, 0x8f, 0x40, 0x5, 0x40,
    0xea, 0x3, 0x80, 0x8f, 0x40, 0x5, 0x40, 0xbd,
    0x7, 0x40, 0x8f, 0x40, 0x5, 0x40, 0x7f, 0xa,
    0x10, 0x8f, 0x40, 0x5, 0x40, 0x4f, 0x4b, 0x0,
    0x8f, 0x40, 0x5, 0x40, 0x1f, 0xa9, 0x0, 0x8f,
    0x40, 0x5, 0x40, 0xd, 0xf5, 0x0, 0x8f, 0x40,
    0x5, 0x40, 0xa, 0xf2, 0x0, 0x8f, 0x40, 0x6,
    0x50, 0x6, 0xe0, 0x0, 0x8f, 0x40, 0x7e, 0xe6,
    0x3, 0xa0, 0xa, 0xff, 0xe7,

    /* U+4E "N" */
    0x5c, 0xfd, 0x0, 0x0, 0x6, 0xbf, 0xc8, 0x0,
    0xff, 0x50, 0x0, 0x0, 0xb, 0x0, 0x0, 0xcf,
    0xd0, 0x0, 0x0, 0xa, 0x0, 0x0, 0xa8, 0xf6,
    0x0, 0x0, 0xa, 0x0, 0x0, 0xa1, 0xfe, 0x0,
    0x0, 0xa, 0x0, 0x0, 0xa0, 0x8f, 0x60, 0x0,
    0xa, 0x0, 0x0, 0xa0, 0x1f, 0xe0, 0x0, 0xa,
    0x0, 0x0, 0xa0, 0x8, 0xf7, 0x0, 0xa, 0x0,
    0x0, 0xa0, 0x1, 0xfe, 0x0, 0xa, 0x0, 0x0,
    0xa0, 0x0, 0x8f, 0x70, 0xa, 0x0, 0x0, 0xa0,
    0x0, 0x1f, 0xe0, 0xa, 0x0, 0x0, 0xa0, 0x0,
    0x8, 0xf7, 0xa, 0x0, 0x0, 0xa0, 0x0, 0x1,
    0xee, 0xa, 0x0, 0x0, 0xa0, 0x0, 0x0, 0x7f,
    0x8a, 0x0, 0x0, 0xa0, 0x0, 0x0, 0xe, 0xfc,
    0x0, 0x0, 0xa0, 0x0, 0x0, 0x7, 0xfe, 0x0,
    0x0, 0xa0, 0x0, 0x0, 0x0, 0xee, 0x0, 0x0,
    0xb0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x8c, 0xfc,
    0x60, 0x0, 0x0, 0xd, 0x0,

    /* U+4F "O" */
    0x0, 0x0, 0x3b, 0xcc, 0xc5, 0x0, 0x0, 0x0,
    0x6, 0xf5, 0x0, 0x2d, 0x90, 0x0, 0x0, 0x3f,
    0x60, 0x0, 0x2, 0xf6, 0x0, 0x0, 0xce, 0x0,
    0x0, 0x0, 0xae, 0x0, 0x3, 0xf9, 0x0, 0x0,
    0x0, 0x5f, 0x60, 0x8, 0xf6, 0x0, 0x0, 0x0,
    0x2f, 0xb0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0xf,
    0xe0, 0xe, 0xf2, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0xf, 0xf1, 0x0, 0x0, 0x0, 0xe, 0xf2, 0xf,
    0xf1, 0x0, 0x0, 0x0, 0xd, 0xf3, 0xf, 0xf1,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0xe, 0xf2, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0xb, 0xf3, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x8, 0xf5, 0x0, 0x0, 0x0,
    0x1f, 0xc0, 0x2, 0xf9, 0x0, 0x0, 0x0, 0x5f,
    0x60, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x9e, 0x10,
    0x0, 0x2f, 0x60, 0x0, 0x1, 0xf6, 0x0, 0x0,
    0x4, 0xe3, 0x0, 0x1c, 0x90, 0x0, 0x0, 0x0,
    0x2a, 0xaa, 0xb5, 0x0, 0x0,

    /* U+50 "P" */
    0x2a, 0xff, 0xda, 0xab, 0xca, 0x40, 0x0, 0xa,
    0xf2, 0x0, 0x0, 0x5f, 0x80, 0x0, 0x9f, 0x20,
    0x0, 0x0, 0x7f, 0x50, 0x9, 0xf2, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x9f, 0x20, 0x0, 0x0, 0xf,
    0xe0, 0x9, 0xf2, 0x0, 0x0, 0x0, 0xfd, 0x0,
    0x9f, 0x20, 0x0, 0x0, 0x2f, 0xa0, 0x9, 0xf2,
    0x0, 0x0, 0x9, 0xf3, 0x0, 0x9f, 0x20, 0x0,
    0x2a, 0xf5, 0x0, 0x9, 0xfb, 0xaa, 0xbb, 0x81,
    0x0, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x20, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xff, 0xe9,
    0x0, 0x0, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x0, 0x5c, 0xcc, 0xb4, 0x0, 0x0, 0x0,
    0x9, 0xe3, 0x0, 0x2d, 0x80, 0x0, 0x0, 0x6f,
    0x40, 0x0, 0x2, 0xf5, 0x0, 0x0, 0xed, 0x0,
    0x0, 0x0, 0xbe, 0x0, 0x6, 0xf7, 0x0, 0x0,
    0x0, 0x6f, 0x50, 0xa, 0xf4, 0x0, 0x0, 0x0,
    0x3f, 0xa0, 0xd, 0xf1, 0x0, 0x0, 0x0, 0x1f,
    0xd0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0xf, 0xf0,
    0x1f, 0xf0, 0x0, 0x0, 0x0, 0xf, 0xf1, 0x1f,
    0xf0, 0x0, 0x0, 0x0, 0xf, 0xf1, 0x1f, 0xf0,
    0x0, 0x0, 0x0, 0xf, 0xf1, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x1f, 0xe0, 0xb, 0xf3, 0x4d, 0xe9, 0x0,
    0x3f, 0xb0, 0x7, 0xf8, 0xe5, 0x4f, 0x80, 0x5f,
    0x70, 0x1, 0xff, 0x70, 0x9, 0xf0, 0x9f, 0x10,
    0x0, 0x7f, 0x70, 0x4, 0xf8, 0xf7, 0x0, 0x0,
    0x9, 0xe3, 0x0, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x4b, 0xcc, 0xff, 0x10, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x71, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xb6, 0x0,

    /* U+52 "R" */
    0x1a, 0xff, 0xea, 0xab, 0xda, 0x20, 0x0, 0x0,
    0x8f, 0x40, 0x0, 0x1c, 0xf4, 0x0, 0x0, 0x7f,
    0x40, 0x0, 0x1, 0xfe, 0x0, 0x0, 0x7f, 0x40,
    0x0, 0x0, 0xbf, 0x30, 0x0, 0x7f, 0x40, 0x0,
    0x0, 0x8f, 0x50, 0x0, 0x7f, 0x40, 0x0, 0x0,
    0x8f, 0x40, 0x0, 0x7f, 0x40, 0x0, 0x0, 0xbf,
    0x10, 0x0, 0x7f, 0x40, 0x0, 0x2, 0xfa, 0x0,
    0x0, 0x7f, 0x40, 0x0, 0x4e, 0xc1, 0x0, 0x0,
    0x7f, 0xba, 0xbe, 0xd6, 0x0, 0x0, 0x0, 0x7f,
    0x40, 0xe, 0xb0, 0x0, 0x0, 0x0, 0x7f, 0x40,
    0x9, 0xf2, 0x0, 0x0, 0x0, 0x7f, 0x40, 0x2,
    0xf9, 0x0, 0x0, 0x0, 0x7f, 0x40, 0x0, 0xcf,
    0x0, 0x0, 0x0, 0x7f, 0x40, 0x0, 0x6f, 0x60,
    0x0, 0x0, 0x7f, 0x40, 0x0, 0xf, 0xd0, 0x0,
    0x0, 0x7f, 0x40, 0x0, 0x9, 0xf3, 0x0, 0x0,
    0x8f, 0x40, 0x0, 0x3, 0xfa, 0x0, 0x1a, 0xff,
    0xe9, 0x0, 0x0, 0xcf, 0xc4,

    /* U+53 "S" */
    0x0, 0x29, 0xbc, 0xda, 0x55, 0x40, 0x4, 0xd2,
    0x0, 0x4, 0xdf, 0x60, 0xe, 0x50, 0x0, 0x0,
    0x1e, 0x80, 0x6f, 0x0, 0x0, 0x0, 0x6, 0x90,
    0x8e, 0x0, 0x0, 0x0, 0x0, 0x60, 0x7f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xc2, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0x81, 0x0, 0x0, 0x0,
    0x0, 0x4d, 0xff, 0x92, 0x0, 0x0, 0x0, 0x0,
    0x6d, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x5d,
    0xfc, 0x10, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf1, 0x50, 0x0,
    0x0, 0x0, 0x4, 0xf5, 0xa3, 0x0, 0x0, 0x0,
    0x3, 0xf5, 0x8a, 0x0, 0x0, 0x0, 0x5, 0xf1,
    0x5f, 0x50, 0x0, 0x0, 0xc, 0xa0, 0x2f, 0xf7,
    0x0, 0x0, 0x8d, 0x10, 0xa, 0x47, 0xcc, 0xcc,
    0x80, 0x0,

    /* U+54 "T" */
    0x5, 0xff, 0xdd, 0xff, 0xcc, 0xff, 0x30, 0x9,
    0xc1, 0x0, 0xfc, 0x0, 0xd, 0x70, 0xd, 0x20,
    0x0, 0xfc, 0x0, 0x4, 0xa0, 0x1b, 0x0, 0x0,
    0xfc, 0x0, 0x0, 0xb0, 0x2, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xac, 0xff, 0xc7, 0x0, 0x0,

    /* U+55 "U" */
    0x5c, 0xff, 0xb2, 0x0, 0x6, 0xcf, 0xb3, 0x1,
    0xfc, 0x0, 0x0, 0x0, 0xb, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0xfb, 0x0,
    0x0, 0x0, 0xa, 0x0, 0x0, 0xfb, 0x0, 0x0,
    0x0, 0xa, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0,
    0xa, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0xa,
    0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0xa, 0x0,
    0x0, 0xfb, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0,
    0xfb, 0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0x0, 0xa, 0x0, 0x0, 0xfb, 0x0,
    0x0, 0x0, 0xa, 0x0, 0x0, 0xfb, 0x0, 0x0,
    0x0, 0xa, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0,
    0xa, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0xa,
    0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x28, 0x0,
    0x0, 0x9f, 0x10, 0x0, 0x0, 0xa3, 0x0, 0x0,
    0x1d, 0xc3, 0x0, 0x2a, 0x70, 0x0, 0x0, 0x0,
    0x8d, 0xfd, 0xb3, 0x0, 0x0,

    /* U+56 "V" */
    0x5d, 0xff, 0xb1, 0x0, 0x7, 0xef, 0xc2, 0x0,
    0xfe, 0x0, 0x0, 0x0, 0x7a, 0x0, 0x0, 0xbf,
    0x10, 0x0, 0x0, 0x94, 0x0, 0x0, 0x8f, 0x50,
    0x0, 0x0, 0xd0, 0x0, 0x0, 0x4f, 0x80, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0xf, 0xc0, 0x0, 0x5,
    0x70, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x9, 0x30,
    0x0, 0x0, 0x8, 0xf4, 0x0, 0xd, 0x0, 0x0,
    0x0, 0x4, 0xf7, 0x0, 0x2b, 0x0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x66, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x0, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x30, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x62,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xa6, 0x50,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xeb, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd0, 0x0, 0x0, 0x0,

    /* U+57 "W" */
    0x8f, 0xfc, 0x8, 0xff, 0xb0, 0x5e, 0xf8, 0xb,
    0xe0, 0x0, 0xae, 0x0, 0x5, 0x80, 0x8, 0xf0,
    0x0, 0x8f, 0x0, 0x6, 0x50, 0x6, 0xf1, 0x0,
    0x7f, 0x20, 0x9, 0x20, 0x3, 0xf4, 0x0, 0x5f,
    0x40, 0xb, 0x0, 0x1, 0xf6, 0x0, 0x8f, 0x60,
    0xb, 0x0, 0x0, 0xf8, 0x0, 0xbf, 0x80, 0x1a,
    0x0, 0x0, 0xcb, 0x0, 0xcd, 0xb0, 0x47, 0x0,
    0x0, 0xad, 0x2, 0xab, 0xd0, 0x64, 0x0, 0x0,
    0x7f, 0x5, 0x78, 0xf0, 0x92, 0x0, 0x0, 0x5f,
    0x18, 0x46, 0xf1, 0xb0, 0x0, 0x0, 0x3f, 0x4b,
    0x4, 0xf3, 0xb0, 0x0, 0x0, 0xf, 0x6c, 0x1,
    0xf7, 0x90, 0x0, 0x0, 0xe, 0xba, 0x0, 0xfe,
    0x70, 0x0, 0x0, 0xb, 0xf7, 0x0, 0xdf, 0x40,
    0x0, 0x0, 0x9, 0xf4, 0x0, 0xaf, 0x10, 0x0,
    0x0, 0x7, 0xf1, 0x0, 0x8f, 0x0, 0x0, 0x0,
    0x4, 0xe0, 0x0, 0x5c, 0x0, 0x0, 0x0, 0x2,
    0xb0, 0x0, 0x39, 0x0, 0x0,

    /* U+58 "X" */
    0xa, 0xff, 0xe6, 0x0, 0x3b, 0xff, 0x90, 0x0,
    0x5f, 0x80, 0x0, 0x0, 0xe2, 0x0, 0x0, 0xe,
    0xd0, 0x0, 0x4, 0x90, 0x0, 0x0, 0x7, 0xf4,
    0x0, 0xb, 0x20, 0x0, 0x0, 0x0, 0xfb, 0x0,
    0x3a, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x20, 0xa3,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x92, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xfa, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xce, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x8,
    0x7d, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xd, 0x7,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x77, 0x0, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xd1, 0x0, 0x8f, 0x40,
    0x0, 0x0, 0x5, 0x80, 0x0, 0x1f, 0xb0, 0x0,
    0x0, 0xc, 0x10, 0x0, 0xa, 0xf3, 0x0, 0x0,
    0x6c, 0x0, 0x0, 0x3, 0xfb, 0x0, 0x2b, 0xff,
    0xa0, 0x0, 0x3c, 0xff, 0xc3,

    /* U+59 "Y" */
    0x3d, 0xff, 0xb4, 0x0, 0xb, 0xff, 0xc2, 0x0,
    0xef, 0x10, 0x0, 0x0, 0xa9, 0x0, 0x0, 0x7f,
    0x50, 0x0, 0x0, 0xc1, 0x0, 0x0, 0x1f, 0xb0,
    0x0, 0x2, 0xa0, 0x0, 0x0, 0xb, 0xf1, 0x0,
    0x8, 0x40, 0x0, 0x0, 0x5, 0xf6, 0x0, 0xc,
    0x0, 0x0, 0x0, 0x0, 0xec, 0x0, 0x48, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x20, 0xa1, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x71, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xd6, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xac, 0xff, 0xc7, 0x0, 0x0,

    /* U+5A "Z" */
    0x0, 0x5f, 0xfe, 0xba, 0xaa, 0xdf, 0x80, 0xa,
    0xf5, 0x0, 0x0, 0xd, 0xf1, 0x0, 0xf3, 0x0,
    0x0, 0x5, 0xf7, 0x0, 0x47, 0x0, 0x0, 0x0,
    0xde, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf2, 0x0, 0x0,
    0x0, 0x40, 0x3, 0xfa, 0x0, 0x0, 0x0, 0x67,
    0x0, 0xbf, 0x20, 0x0, 0x0, 0x1e, 0x20, 0x3f,
    0x90, 0x0, 0x0, 0x2c, 0xe0, 0xc, 0xfc, 0xaa,
    0xaa, 0xcf, 0xf9, 0x0,

    /* U+5B "[" */
    0x8f, 0xff, 0xff, 0xf0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x89, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xf0,

    /* U+5C "\\" */
    0xb9, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x8c, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xb, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe5, 0x0, 0x0, 0x0, 0x0, 0x8, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x0, 0x0,
    0x0, 0xc8, 0x0, 0x0, 0x0, 0x0, 0x5, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0xc, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xd7, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x54,

    /* U+5D "]" */
    0x2f, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0, 0xa6,
    0x0, 0x0, 0x0, 0xa6, 0x2f, 0xff, 0xff, 0xf6,

    /* U+5E "^" */
    0x0, 0xbf, 0xfb, 0x0, 0x8, 0xe5, 0x5e, 0x70,
    0x59, 0x0, 0x1, 0x93, 0x0, 0x0, 0x0, 0x0,

    /* U+5F "_" */
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa9,

    /* U+60 "`" */
    0x5e, 0xfd, 0x10, 0x0, 0x5d, 0xd1, 0x0, 0x0,
    0x48,

    /* U+61 "a" */
    0x0, 0x29, 0xaa, 0xab, 0x70, 0x0, 0x0, 0x6e,
    0x30, 0x0, 0xd, 0x90, 0x0, 0x1f, 0xb0, 0x0,
    0x0, 0x7f, 0x0, 0x0, 0xd9, 0x0, 0x0, 0x6,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x2, 0x8f, 0x20,
    0x0, 0x0, 0x49, 0xcb, 0x8a, 0xf2, 0x0, 0x2,
    0xcd, 0x50, 0x0, 0x6f, 0x20, 0x1, 0xec, 0x0,
    0x0, 0x6, 0xf2, 0x0, 0x8f, 0x40, 0x0, 0x0,
    0x6f, 0x20, 0xc, 0xf1, 0x0, 0x0, 0x6, 0xf2,
    0x0, 0xaf, 0x40, 0x0, 0x0, 0x6f, 0x21, 0x53,
    0xfc, 0x10, 0x2, 0x9c, 0xf3, 0x54, 0x2, 0xad,
    0xcc, 0xa3, 0xb, 0xea, 0x0,

    /* U+62 "b" */
    0x0, 0x28, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbf,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbd, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xd0,
    0x3a, 0xde, 0xb3, 0x0, 0x0, 0xbd, 0x5a, 0x20,
    0x9, 0xf3, 0x0, 0xb, 0xeb, 0x0, 0x0, 0xe,
    0xc0, 0x0, 0xbf, 0x30, 0x0, 0x0, 0x9f, 0x10,
    0xb, 0xe0, 0x0, 0x0, 0x6, 0xf4, 0x0, 0xbd,
    0x0, 0x0, 0x0, 0x5f, 0x60, 0xb, 0xd0, 0x0,
    0x0, 0x4, 0xf7, 0x0, 0xbd, 0x0, 0x0, 0x0,
    0x5f, 0x60, 0xb, 0xd0, 0x0, 0x0, 0x6, 0xf4,
    0x0, 0xbe, 0x0, 0x0, 0x0, 0x9f, 0x0, 0xb,
    0xf2, 0x0, 0x0, 0xe, 0x80, 0x0, 0xbd, 0xc2,
    0x0, 0x1b, 0xc0, 0x0, 0xa, 0x12, 0xac, 0xcd,
    0x70, 0x0,

    /* U+63 "c" */
    0x0, 0x2, 0xab, 0xac, 0x91, 0x0, 0x0, 0x5f,
    0x50, 0x0, 0xad, 0x0, 0x3, 0xf6, 0x0, 0x0,
    0x7f, 0x60, 0xb, 0xe0, 0x0, 0x0, 0x8f, 0x60,
    0x1f, 0x90, 0x0, 0x0, 0x3, 0x0, 0x4f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x90, 0x0, 0x0, 0x0, 0x10, 0xd, 0xe0,
    0x0, 0x0, 0x0, 0x91, 0x6, 0xf5, 0x0, 0x0,
    0x4, 0x90, 0x0, 0x9f, 0x60, 0x0, 0x6c, 0x0,
    0x0, 0x5, 0xbe, 0xed, 0x80, 0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x0, 0x4, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x8c, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0, 0x5c,
    0xed, 0x91, 0xf9, 0x0, 0x0, 0x8e, 0x40, 0x3,
    0xbf, 0x90, 0x0, 0x5f, 0x50, 0x0, 0x1, 0xf9,
    0x0, 0xd, 0xd0, 0x0, 0x0, 0xf, 0x90, 0x2,
    0xf9, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x4f, 0x70,
    0x0, 0x0, 0xf, 0x90, 0x5, 0xf6, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x4f, 0x60, 0x0, 0x0, 0xf,
    0x90, 0x2, 0xf8, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0xe, 0xb0, 0x0, 0x0, 0x3f, 0x90, 0x0, 0x7f,
    0x20, 0x0, 0xa, 0xfa, 0x0, 0x0, 0xbd, 0x20,
    0x8, 0x5f, 0xfb, 0x20, 0x0, 0x7d, 0xec, 0x40,
    0xb2, 0x0,

    /* U+65 "e" */
    0x0, 0x2, 0xac, 0xcc, 0x60, 0x0, 0x0, 0x5e,
    0x40, 0x1, 0xdb, 0x0, 0x2, 0xf6, 0x0, 0x0,
    0x2f, 0x70, 0xa, 0xe0, 0x0, 0x0, 0xc, 0xe0,
    0xf, 0xa0, 0x0, 0x0, 0x9, 0xf2, 0x2f, 0x80,
    0x0, 0x0, 0x8, 0xf4, 0x3f, 0xda, 0xaa, 0xaa,
    0xab, 0xd4, 0x2f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0x0, 0x50, 0x4, 0xf5, 0x0, 0x0,
    0x3, 0x90, 0x0, 0x7f, 0x70, 0x0, 0x5b, 0x0,
    0x0, 0x3, 0xae, 0xee, 0x91, 0x0,

    /* U+66 "f" */
    0x0, 0x0, 0x1, 0x9b, 0xab, 0xb3, 0x0, 0x0,
    0x2, 0xe4, 0x0, 0xc, 0xf1, 0x0, 0x0, 0xba,
    0x0, 0x0, 0xbf, 0x10, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x70, 0x0, 0x0, 0x0, 0x4a,
    0xaa, 0xfc, 0xaa, 0xaa, 0x0, 0x0, 0x0, 0x1f,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x70, 0x0, 0x0, 0x0, 0x9, 0xad, 0xff,
    0xba, 0xa0, 0x0, 0x0,

    /* U+67 "g" */
    0x0, 0x7, 0xcb, 0xbb, 0x37, 0xdd, 0x0, 0x9,
    0xb1, 0x0, 0x7f, 0x77, 0xf0, 0x3, 0xf2, 0x0,
    0x0, 0xdb, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x9,
    0xe0, 0x0, 0xa, 0xd0, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x9, 0xe0, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0xd8, 0x0, 0x0, 0x6, 0xd2,
    0x0, 0x8d, 0x0, 0x0, 0x1, 0xb7, 0xaa, 0xb8,
    0x10, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xfd, 0xb8, 0x64, 0x10, 0x0, 0x0,
    0x9, 0x87, 0xac, 0xef, 0xd4, 0x0, 0xc, 0x50,
    0x0, 0x0, 0x19, 0xf2, 0x5, 0xf0, 0x0, 0x0,
    0x0, 0x1f, 0x50, 0x5f, 0x20, 0x0, 0x0, 0x2,
    0xf2, 0x0, 0xbd, 0x20, 0x0, 0x2, 0xc9, 0x0,
    0x0, 0x5b, 0xbb, 0xbb, 0xa4, 0x0, 0x0,

    /* U+68 "h" */
    0x0, 0x2b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2a,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x3, 0xbe, 0xfc, 0x30, 0x0,
    0x0, 0x9f, 0x5d, 0x50, 0x1b, 0xf1, 0x0, 0x0,
    0x9f, 0xb0, 0x0, 0x2, 0xf6, 0x0, 0x0, 0x9f,
    0x10, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x0, 0xf9, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0,
    0xf9, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0x0, 0xfa, 0x0, 0x1b, 0xff, 0xd5,
    0x0, 0x5c, 0xff, 0xb1,

    /* U+69 "i" */
    0x0, 0x1, 0xce, 0x30, 0x0, 0x0, 0x3, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x8a, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x46, 0x0, 0x0, 0xa, 0xab,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0xdc, 0x0, 0x0,
    0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0xcc,
    0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0,
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0xcc, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0,
    0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0xdc,
    0x0, 0x0, 0xa, 0xab, 0xff, 0xca, 0xa0,

    /* U+6A "j" */
    0x0, 0x0, 0x0, 0x2d, 0xd1, 0x0, 0x0, 0x0,
    0x6f, 0xf5, 0x0, 0x0, 0x0, 0x9, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x14, 0x70, 0x0, 0x0,
    0x9a, 0xbf, 0xd0, 0x0, 0x0, 0x0, 0xc, 0xd0,
    0x0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0x0, 0x0, 0xb, 0xd0, 0x0,
    0x0, 0x0, 0xb, 0xd0, 0x0, 0x0, 0x0, 0xb,
    0xd0, 0x0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x0,
    0x0, 0xb, 0xd0, 0x0, 0x0, 0x0, 0xb, 0xd0,
    0x0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0x0, 0x0, 0xb, 0xc0, 0x0,
    0x0, 0x0, 0xd, 0x90, 0x8d, 0x10, 0x0, 0x2f,
    0x20, 0xaf, 0x70, 0x3, 0xd6, 0x0, 0x1a, 0xee,
    0xea, 0x30, 0x0,

    /* U+6B "k" */
    0x0, 0x2b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1a,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x0, 0x3, 0xcf, 0xfb, 0x20,
    0x0, 0x7f, 0x0, 0x0, 0x5d, 0x10, 0x0, 0x0,
    0x7f, 0x0, 0x2, 0xd2, 0x0, 0x0, 0x0, 0x7f,
    0x0, 0x1d, 0x40, 0x0, 0x0, 0x0, 0x7f, 0x0,
    0xc8, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xa, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x99, 0x5f, 0x70,
    0x0, 0x0, 0x0, 0x7f, 0xb0, 0xc, 0xf1, 0x0,
    0x0, 0x0, 0x7f, 0x10, 0x2, 0xfa, 0x0, 0x0,
    0x0, 0x7f, 0x0, 0x0, 0x9f, 0x40, 0x0, 0x0,
    0x7f, 0x0, 0x0, 0x1e, 0xd0, 0x0, 0x0, 0x8f,
    0x10, 0x0, 0x6, 0xf7, 0x0, 0xa, 0xff, 0xd6,
    0x0, 0x3c, 0xff, 0xb1,

    /* U+6C "l" */
    0x0, 0x3, 0x8b, 0x0, 0x0, 0x1a, 0xab, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0,
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0xcc, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0,
    0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0xcc,
    0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0,
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0xcc, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0,
    0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0xcc,
    0x0, 0x0, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x2a,
    0xab, 0xff, 0xca, 0xa2,

    /* U+6D "m" */
    0x7f, 0xf2, 0xbe, 0xd3, 0x3c, 0xec, 0x10, 0x9,
    0xfa, 0x10, 0xdd, 0xb1, 0xe, 0x90, 0x9, 0xf3,
    0x0, 0xaf, 0x20, 0xc, 0xc0, 0x9, 0xf0, 0x0,
    0xae, 0x0, 0xb, 0xc0, 0x9, 0xf0, 0x0, 0xae,
    0x0, 0xb, 0xc0, 0x9, 0xf0, 0x0, 0xae, 0x0,
    0xb, 0xc0, 0x9, 0xf0, 0x0, 0xae, 0x0, 0xb,
    0xc0, 0x9, 0xf0, 0x0, 0xae, 0x0, 0xb, 0xc0,
    0x9, 0xf0, 0x0, 0xae, 0x0, 0xb, 0xc0, 0x9,
    0xf0, 0x0, 0xae, 0x0, 0xb, 0xc0, 0x9, 0xf0,
    0x0, 0xae, 0x0, 0xb, 0xc0, 0x9, 0xf0, 0x0,
    0xae, 0x0, 0xc, 0xd0, 0x7f, 0xfc, 0x8, 0xff,
    0xb0, 0x9f, 0xfa,

    /* U+6E "n" */
    0xe, 0xff, 0x2, 0xad, 0xeb, 0x30, 0x0, 0x0,
    0xaf, 0x5c, 0x30, 0xa, 0xe1, 0x0, 0x0, 0x9f,
    0xb0, 0x0, 0x2, 0xf6, 0x0, 0x0, 0x9f, 0x10,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0,
    0xf9, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x1b, 0xff, 0xd5, 0x0,
    0x5c, 0xff, 0xb1,

    /* U+6F "o" */
    0x0, 0x5, 0xba, 0xab, 0x60, 0x0, 0x0, 0x9d,
    0x20, 0x1, 0xca, 0x0, 0x6, 0xf1, 0x0, 0x0,
    0x1f, 0x70, 0xf, 0x90, 0x0, 0x0, 0x8, 0xf1,
    0x6f, 0x40, 0x0, 0x0, 0x4, 0xf6, 0x9f, 0x20,
    0x0, 0x0, 0x2, 0xf9, 0xaf, 0x10, 0x0, 0x0,
    0x1, 0xfa, 0x9f, 0x10, 0x0, 0x0, 0x1, 0xf9,
    0x6f, 0x30, 0x0, 0x0, 0x3, 0xf6, 0x1f, 0x70,
    0x0, 0x0, 0x7, 0xf1, 0x8, 0xe0, 0x0, 0x0,
    0xe, 0x80, 0x0, 0xab, 0x10, 0x0, 0xba, 0x0,
    0x0, 0x6, 0xba, 0xab, 0x50, 0x0,

    /* U+70 "p" */
    0x3e, 0xff, 0x4, 0xce, 0xea, 0x20, 0x0, 0xb,
    0xf6, 0xa2, 0x0, 0x9f, 0x30, 0x0, 0x9f, 0xa0,
    0x0, 0x0, 0xcd, 0x0, 0x9, 0xf0, 0x0, 0x0,
    0x6, 0xf4, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x3f,
    0x80, 0x9, 0xf0, 0x0, 0x0, 0x1, 0xfa, 0x0,
    0x9f, 0x0, 0x0, 0x0, 0x1f, 0xa0, 0x9, 0xf0,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x9f, 0x0, 0x0,
    0x0, 0x4f, 0x70, 0x9, 0xf0, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x9f, 0x40, 0x0, 0x1, 0xeb, 0x0,
    0x9, 0xfc, 0x40, 0x1, 0xcd, 0x10, 0x0, 0x9f,
    0x19, 0xcc, 0xd8, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x2b, 0xff, 0xd8, 0x0, 0x0, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x6, 0xcc, 0xc8, 0x4, 0x70, 0x0, 0xa,
    0xd2, 0x0, 0x4c, 0xd7, 0x0, 0x8, 0xf1, 0x0,
    0x0, 0x5f, 0x70, 0x1, 0xf9, 0x0, 0x0, 0x0,
    0xf7, 0x0, 0x5f, 0x50, 0x0, 0x0, 0xf, 0x70,
    0x8, 0xf3, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x9f,
    0x20, 0x0, 0x0, 0xf, 0x70, 0x8, 0xf3, 0x0,
    0x0, 0x0, 0xf7, 0x0, 0x6f, 0x40, 0x0, 0x0,
    0xf, 0x70, 0x2, 0xf7, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0xb, 0xd0, 0x0, 0x0, 0x7f, 0x70, 0x0,
    0x1d, 0xa1, 0x0, 0x7a, 0xf7, 0x0, 0x0, 0x19,
    0xee, 0xd6, 0xf, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xcf, 0xfb, 0x10,

    /* U+72 "r" */
    0xe, 0xef, 0xf9, 0x0, 0x5c, 0xec, 0x30, 0x0,
    0x1f, 0x90, 0x97, 0x5, 0xfb, 0x0, 0x0, 0xf9,
    0x86, 0x0, 0x2d, 0x70, 0x0, 0xf, 0xd9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xfe, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x90, 0x0, 0x0, 0x0, 0x1a, 0xac,
    0xff, 0xba, 0xa0, 0x0, 0x0,

    /* U+73 "s" */
    0x0, 0x5b, 0xab, 0xef, 0xf3, 0x9, 0xa0, 0x0,
    0x9, 0xf5, 0x1f, 0x10, 0x0, 0x0, 0xb7, 0x3f,
    0x20, 0x0, 0x0, 0x36, 0x1f, 0xb2, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xc5, 0x0, 0x0, 0x0, 0x18,
    0xef, 0xf9, 0x10, 0x0, 0x0, 0x5, 0xbf, 0xe2,
    0x20, 0x0, 0x0, 0x3, 0xeb, 0xa3, 0x0, 0x0,
    0x0, 0x8e, 0x9a, 0x0, 0x0, 0x0, 0x7b, 0x7f,
    0x80, 0x0, 0x2, 0xd4, 0x6f, 0xff, 0xca, 0xba,
    0x30,

    /* U+74 "t" */
    0x0, 0x0, 0x29, 0x0, 0x0, 0x0, 0x0, 0x6,
    0x90, 0x0, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0,
    0x0, 0x2, 0xaf, 0x90, 0x0, 0x0, 0x2a, 0xaa,
    0xfd, 0xaa, 0xa9, 0x0, 0x0, 0xf, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x90, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xf, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x90, 0x0, 0x7, 0x0, 0x0, 0xcb,
    0x0, 0x1, 0x90, 0x0, 0x6, 0xf5, 0x2, 0xb1,
    0x0, 0x0, 0x8, 0xef, 0xc3, 0x0,

    /* U+75 "u" */
    0x3b, 0xfd, 0x0, 0x0, 0x7d, 0xf7, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0xbd,
    0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x0, 0xf7, 0x0, 0x0, 0xbd, 0x0, 0x0,
    0x0, 0xf7, 0x0, 0x0, 0xbd, 0x0, 0x0, 0x0,
    0xf7, 0x0, 0x0, 0xbd, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x0, 0xbd, 0x0, 0x0, 0x0, 0xf7, 0x0,
    0x0, 0xbd, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0xae, 0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x7f,
    0x10, 0x0, 0xa, 0xf8, 0x0, 0x0, 0x2f, 0xc4,
    0x25, 0xc3, 0xff, 0xb1, 0x0, 0x4, 0xcf, 0xea,
    0x20, 0xb1, 0x0,

    /* U+76 "v" */
    0xa, 0xff, 0xe7, 0x0, 0x1c, 0xff, 0x80, 0x6,
    0xf6, 0x0, 0x0, 0xe, 0x30, 0x0, 0xf, 0x90,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0xae, 0x0, 0x0,
    0x76, 0x0, 0x0, 0x5, 0xf3, 0x0, 0xc, 0x10,
    0x0, 0x0, 0xf, 0x90, 0x1, 0xb0, 0x0, 0x0,
    0x0, 0xbe, 0x0, 0x75, 0x0, 0x0, 0x0, 0x5,
    0xf3, 0xb, 0x0, 0x0, 0x0, 0x0, 0xf, 0x81,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0xbd, 0x65, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb4, 0x0, 0x0, 0x0,

    /* U+77 "w" */
    0xaf, 0xfb, 0xb, 0xff, 0x80, 0x8e, 0xf9, 0xa,
    0xf0, 0x0, 0xcd, 0x0, 0x8, 0x60, 0x5, 0xf2,
    0x0, 0x7f, 0x0, 0xb, 0x10, 0x1, 0xf5, 0x0,
    0x9f, 0x20, 0xc, 0x0, 0x0, 0xd8, 0x0, 0xbf,
    0x50, 0x29, 0x0, 0x0, 0x9c, 0x1, 0x9d, 0x90,
    0x65, 0x0, 0x0, 0x6f, 0x4, 0x59, 0xc0, 0xa1,
    0x0, 0x0, 0x2f, 0x38, 0x16, 0xf0, 0xb0, 0x0,
    0x0, 0xe, 0x6a, 0x2, 0xf5, 0x90, 0x0, 0x0,
    0xa, 0xb9, 0x0, 0xec, 0x50, 0x0, 0x0, 0x7,
    0xf6, 0x0, 0xbf, 0x10, 0x0, 0x0, 0x3, 0xf2,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0xe0, 0x0,
    0x4a, 0x0, 0x0,

    /* U+78 "x" */
    0x3, 0xbf, 0xfd, 0x30, 0x9e, 0xfb, 0x30, 0x0,
    0x8f, 0x60, 0x0, 0x97, 0x0, 0x0, 0x0, 0xee,
    0x0, 0x3d, 0x0, 0x0, 0x0, 0x5, 0xf8, 0xd,
    0x30, 0x0, 0x0, 0x0, 0xb, 0xfa, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x5b, 0xeb, 0x0, 0x0, 0x0, 0x0, 0x1d, 0x15,
    0xf4, 0x0, 0x0, 0x0, 0x9, 0x60, 0xc, 0xd0,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x3f, 0x70, 0x0,
    0x1, 0xd4, 0x0, 0x0, 0xbf, 0x20, 0xa, 0xef,
    0xd2, 0x0, 0xaf, 0xff, 0x80,

    /* U+79 "y" */
    0x8e, 0xff, 0x80, 0x6, 0xdf, 0xea, 0x0, 0x2f,
    0x90, 0x0, 0x2, 0xf2, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0x5a, 0x0, 0x0, 0x6, 0xf2, 0x0, 0xa,
    0x40, 0x0, 0x0, 0xf, 0x70, 0x0, 0xe0, 0x0,
    0x0, 0x0, 0xad, 0x0, 0x4a, 0x0, 0x0, 0x0,
    0x4, 0xf2, 0x9, 0x50, 0x0, 0x0, 0x0, 0xe,
    0x70, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x9d, 0x3a,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xfb, 0x50, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7b, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 0x0, 0x0,
    0x0, 0x0, 0xde, 0x6c, 0x10, 0x0, 0x0, 0x0,
    0xb, 0xfc, 0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+7A "z" */
    0xa, 0xfd, 0xaa, 0xaa, 0xef, 0x30, 0xc, 0xb0,
    0x0, 0x2, 0xfa, 0x0, 0xd, 0x10, 0x0, 0xc,
    0xe1, 0x0, 0xb, 0x0, 0x0, 0x6f, 0x50, 0x0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x60,
    0x0, 0x0, 0x0, 0x1, 0xec, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf2, 0x0, 0x0, 0x60, 0x0, 0x4f,
    0x80, 0x0, 0x0, 0xc0, 0x0, 0xdd, 0x0, 0x0,
    0x5, 0xa0, 0x8, 0xf3, 0x0, 0x0, 0x2e, 0x80,
    0x1f, 0xfa, 0xaa, 0xac, 0xff, 0x50,

    /* U+7B "{" */
    0x0, 0x0, 0x2a, 0xb0, 0x0, 0x2e, 0x30, 0x0,
    0x7, 0x80, 0x0, 0x0, 0xa5, 0x0, 0x0, 0xa,
    0x40, 0x0, 0x0, 0xb4, 0x0, 0x0, 0xb, 0x40,
    0x0, 0x0, 0xb4, 0x0, 0x0, 0xb, 0x40, 0x0,
    0x0, 0xb4, 0x0, 0x0, 0xe, 0x20, 0x0, 0x8,
    0xa0, 0x0, 0x1d, 0x80, 0x0, 0x0, 0x6, 0x90,
    0x0, 0x0, 0xd, 0x10, 0x0, 0x0, 0xb4, 0x0,
    0x0, 0xb, 0x40, 0x0, 0x0, 0xb4, 0x0, 0x0,
    0xb, 0x40, 0x0, 0x0, 0xb4, 0x0, 0x0, 0xa,
    0x40, 0x0, 0x0, 0xa5, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x2e, 0x40, 0x0, 0x0, 0x2a, 0xb0,

    /* U+7C "|" */
    0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
    0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
    0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73,
    0x73, 0x73, 0x73, 0x73,

    /* U+7D "}" */
    0xba, 0x20, 0x0, 0x0, 0x3d, 0x20, 0x0, 0x0,
    0x87, 0x0, 0x0, 0x5, 0xa0, 0x0, 0x0, 0x4a,
    0x0, 0x0, 0x4, 0xb0, 0x0, 0x0, 0x4b, 0x0,
    0x0, 0x4, 0xb0, 0x0, 0x0, 0x4b, 0x0, 0x0,
    0x4, 0xb0, 0x0, 0x0, 0x2e, 0x0, 0x0, 0x0,
    0xa8, 0x0, 0x0, 0x0, 0x8e, 0x10, 0x0, 0x97,
    0x0, 0x0, 0x2e, 0x0, 0x0, 0x4, 0xb0, 0x0,
    0x0, 0x4b, 0x0, 0x0, 0x4, 0xb0, 0x0, 0x0,
    0x4b, 0x0, 0x0, 0x4, 0xb0, 0x0, 0x0, 0x4a,
    0x0, 0x0, 0x5, 0xa0, 0x0, 0x0, 0x87, 0x0,
    0x0, 0x3e, 0x20, 0x0, 0xba, 0x20, 0x0, 0x0,

    /* U+7E "~" */
    0x3, 0xce, 0xb2, 0x0, 0x0, 0x0, 0x2, 0xa0,
    0x1c, 0xe2, 0x0, 0x0, 0x50, 0x81, 0x0, 0xb,
    0xe2, 0x0, 0xa, 0x5, 0x0, 0x0, 0xb, 0xe4,
    0x19, 0x40, 0x0, 0x0, 0x0, 0x8, 0xed, 0x50,
    0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x38, 0xdf, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x15, 0xae, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x49, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x16, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe9, 0xbf, 0xff, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x73, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xfe, 0xa5, 0x10, 0x0, 0x0,
    0x8f, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xd8, 0x30, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xa2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0x0, 0xf, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x0, 0x0, 0xf, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0x0, 0xf, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x1, 0x7a, 0xcb,
    0xcf, 0xff, 0x0, 0x0, 0x0, 0xf, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xf, 0xff, 0x80, 0x0, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x1,
    0x33, 0x2f, 0xff, 0x80, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x3, 0xcf, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x5f, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x7, 0xef, 0xff, 0xfb, 0x20, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x32, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xe4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x27, 0xaa, 0x95, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0x9b, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0xb9, 0xfe, 0x44,
    0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe4, 0x44, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x88, 0x8f, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xf8, 0x88, 0xff,
    0xfc, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xb0, 0x0, 0xcf, 0xfc, 0x0,
    0xc, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xb0, 0x0, 0xcf, 0xfd, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xd0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xcc, 0xcf, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xfc, 0xcc, 0xff, 0xfc, 0x0,
    0xc, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xff, 0xc0, 0x0, 0xcf, 0xfc, 0x0, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0xcf, 0xfc, 0x0, 0xc, 0xff, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xff, 0xc0, 0x0, 0xcf,
    0xff, 0xcc, 0xcf, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xfc, 0xcc, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xd0,
    0x0, 0xdf, 0xfc, 0x0, 0xc, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xb0, 0x0, 0xcf,
    0xfc, 0x0, 0xc, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xb0, 0x0, 0xcf, 0xff, 0x88,
    0x8f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xf8, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x44, 0x4e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x44, 0xef,
    0xab, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0xb9,

    /* U+F00B "" */
    0x9f, 0xff, 0xff, 0xfb, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff,
    0xff, 0xff, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x21, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x21, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xaf, 0xff, 0xff, 0xfc,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xfb, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff,
    0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x21, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x21, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xaf, 0xff, 0xff, 0xfc, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xfc,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x21, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x21, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x21, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x9f, 0xff, 0xff, 0xfb, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xe9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x8e, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0x80, 0x0,
    0xa, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xf6, 0x6, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xaf, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xe7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x6, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x2d, 0xfa, 0x0, 0x6f, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xa0, 0xef, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xf2,
    0xcf, 0xff, 0xff, 0xf5, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xf1, 0x2e, 0xff, 0xff, 0xff, 0x50, 0x2e,
    0xff, 0xff, 0xff, 0x50, 0x2, 0xef, 0xff, 0xff,
    0xf7, 0xef, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x2e,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x50, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xf6, 0xef, 0xff, 0xff, 0xf5, 0x0, 0x2e, 0xff,
    0xff, 0xff, 0x40, 0x2e, 0xff, 0xff, 0xff, 0x50,
    0xcf, 0xff, 0xff, 0xf4, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xf1, 0xef, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x2e, 0xff, 0xff, 0xf2, 0x6f, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xa0, 0x6, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x10, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x69, 0x96,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xa8, 0x0, 0x3,
    0xff, 0xff, 0x30, 0x0, 0x8a, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0x60, 0x3, 0xff, 0xff,
    0x30, 0x6, 0xff, 0xe3, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xff, 0xe0, 0x3, 0xff, 0xff, 0x30, 0xe,
    0xff, 0xff, 0x30, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xe0, 0x3, 0xff, 0xff, 0x30, 0xe, 0xff, 0xff,
    0xd1, 0x0, 0x0, 0x9f, 0xff, 0xfe, 0x30, 0x3,
    0xff, 0xff, 0x30, 0x3, 0xef, 0xff, 0xf9, 0x0,
    0x2, 0xff, 0xff, 0xe2, 0x0, 0x3, 0xff, 0xff,
    0x30, 0x0, 0x2e, 0xff, 0xff, 0x20, 0x9, 0xff,
    0xff, 0x50, 0x0, 0x3, 0xff, 0xff, 0x30, 0x0,
    0x5, 0xff, 0xff, 0x90, 0xe, 0xff, 0xfc, 0x0,
    0x0, 0x3, 0xff, 0xff, 0x30, 0x0, 0x0, 0xcf,
    0xff, 0xe0, 0x3f, 0xff, 0xf5, 0x0, 0x0, 0x3,
    0xff, 0xff, 0x30, 0x0, 0x0, 0x6f, 0xff, 0xf3,
    0x6f, 0xff, 0xf0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0x30, 0x0, 0x0, 0xf, 0xff, 0xf6, 0x7f, 0xff,
    0xe0, 0x0, 0x0, 0x3, 0xff, 0xff, 0x30, 0x0,
    0x0, 0xe, 0xff, 0xf8, 0x8f, 0xff, 0xd0, 0x0,
    0x0, 0x2, 0xff, 0xff, 0x20, 0x0, 0x0, 0xd,
    0xff, 0xf8, 0x8f, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0xef, 0xfe, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf7,
    0x6f, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x2, 0x20,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xf6, 0x3f, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xf3, 0xe, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xe0, 0x9, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x90,
    0x2, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xff, 0x20, 0x0, 0x9f,
    0xff, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xef, 0xff, 0xf9, 0x0, 0x0, 0x1e, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xd1, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xfa,
    0x75, 0x57, 0xaf, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe3, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x9d,
    0xff, 0xfe, 0xd9, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2c, 0xff, 0xff, 0xd6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xc8, 0x0, 0x5d,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x6d, 0x40,
    0x0, 0x0, 0xcf, 0xfe, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xcf, 0xfe, 0x20, 0x0, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xe7, 0x32, 0x5d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x13, 0xcf, 0xff, 0xff,
    0xff, 0xe1, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xfe, 0x60, 0x0, 0x7f, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xfb, 0x10, 0x0,
    0x4, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0x90, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x4, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xfb, 0x10, 0x3, 0xcf, 0xff,
    0xff, 0xff, 0xe1, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xfe, 0x60, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xe7, 0x32, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x17, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0xcf, 0xfe, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xcf, 0xfe, 0x10, 0x0, 0x1,
    0xc8, 0x0, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x5d, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2c, 0xff, 0xff, 0xd6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x37,
    0x60, 0x0, 0x0, 0x48, 0x88, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xfd, 0x10, 0x0, 0xaf, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xe3, 0x0, 0xbf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xff,
    0xff, 0xff, 0x60, 0xbf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xef, 0xff, 0xf8,
    0xcf, 0xff, 0xf9, 0xbf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xfe, 0x30,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xd2, 0x3,
    0x10, 0x7f, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xbf, 0xff, 0xfa, 0x0, 0x8f,
    0xd2, 0x4, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x2d, 0xff, 0xff, 0x80, 0xb, 0xff,
    0xff, 0x40, 0x2d, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xf5, 0x2, 0xdf, 0xff,
    0xff, 0xf7, 0x1, 0xbf, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xfe, 0x30, 0x3e, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0x9, 0xff, 0xff, 0xc1, 0x0,
    0xa, 0xff, 0xff, 0xc1, 0x6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x10, 0x6f, 0xff, 0xfe, 0x30,
    0xbf, 0xff, 0xfa, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe3, 0x4, 0xef, 0xff, 0xf4,
    0xbf, 0xff, 0x70, 0x1b, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x2d, 0xff, 0xf3,
    0xd, 0xf4, 0x2, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xbf, 0x60,
    0x1, 0x20, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x3, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xfe, 0x10, 0x0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x55, 0x55,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1c, 0xdd, 0xdd, 0xef,
    0xff, 0xff, 0xfe, 0xdd, 0xdd, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x10, 0x8,
    0xff, 0xff, 0x80, 0x1, 0x11, 0x11, 0x11, 0x10,
    0xbf, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x8f, 0xf8,
    0x1, 0xdf, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe2, 0x6, 0x60, 0x2d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x30, 0x3, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x1e, 0xb0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x2e, 0xc1,
    0x8f, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x37, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x73,

    /* U+F01C "" */
    0x0, 0x0, 0x0, 0x2b, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0xd8, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x9f, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x1, 0xef, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xef, 0xff, 0x30, 0x0,
    0x0, 0x5f, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xd0, 0x0,
    0x1, 0xef, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xf8, 0x0,
    0xa, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xff, 0x20,
    0x5f, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xd0,
    0xdf, 0xff, 0xb8, 0x88, 0x88, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x48, 0x88, 0x88, 0x8e, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x58, 0x86, 0x0, 0x0,
    0x0, 0x0, 0x4, 0x9d, 0xef, 0xfe, 0xb7, 0x20,
    0x0, 0x0, 0xdf, 0xff, 0x0, 0x0, 0x0, 0x6,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x30, 0x0,
    0xdf, 0xff, 0x0, 0x0, 0x1, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x10, 0xcf, 0xff,
    0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xfe, 0xef,
    0xff, 0xff, 0xff, 0xe3, 0xbf, 0xff, 0x0, 0x2,
    0xef, 0xff, 0xff, 0x94, 0x0, 0x0, 0x4b, 0xff,
    0xff, 0xfe, 0xdf, 0xff, 0x0, 0xd, 0xff, 0xff,
    0xc2, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x9f, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0x2, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x11, 0x0, 0x8, 0xff, 0xff, 0xff, 0x9, 0xff,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xee, 0xff, 0xff, 0xff, 0xe, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x3f, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x2b, 0xcc, 0x60, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xbc, 0xcc, 0xcc, 0xcc, 0xcc, 0xca, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xac, 0xcc, 0xcc, 0xcc, 0xcc, 0xcb, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xbc, 0xb2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xf2, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0xe0, 0xff, 0xff, 0xff, 0xee, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0x90,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x11, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xff, 0x20, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xf9, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xb2, 0x0, 0x0, 0x0, 0x0, 0x2c, 0xff, 0xff,
    0xd0, 0x0, 0xff, 0xfd, 0xef, 0xff, 0xff, 0xa4,
    0x0, 0x0, 0x4a, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0xff, 0xfb, 0x3e, 0xff, 0xff, 0xff, 0xfe, 0xef,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0xff, 0xfc,
    0x1, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x10, 0x0, 0x0, 0xff, 0xfd, 0x0, 0x3,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x60, 0x0,
    0x0, 0x0, 0xff, 0xfd, 0x0, 0x0, 0x2, 0x7c,
    0xff, 0xff, 0xd9, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x68, 0x85, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xb6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0x38, 0x88, 0x88, 0x8f, 0xff, 0xff,
    0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x10,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x38,
    0x88, 0x88, 0x8f, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x1, 0xb9, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x6f, 0xfc, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1, 0xcf,
    0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xef, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xdf,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xbf, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x6f, 0xfd, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x2, 0xdb, 0x10,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0,
    0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x18, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xb6, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xdf, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x0,
    0x0, 0x0, 0x21, 0x0, 0x1c, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0x0,
    0x0, 0x4, 0xfe, 0x50, 0x1, 0xef, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0x0,
    0x0, 0x5, 0xff, 0xf6, 0x0, 0x4f, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0x40, 0xa, 0xff, 0x40,
    0x38, 0x88, 0x88, 0x8f, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xe0, 0x2, 0xff, 0xa0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1c, 0xa1, 0x0, 0x8f, 0xf6, 0x0, 0xcf, 0xf0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x6f, 0xfd, 0x0, 0x1f, 0xfc, 0x0, 0x8f, 0xf2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1c, 0xff, 0x80, 0xa, 0xff, 0x0, 0x4f, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xdf, 0xd0, 0x7, 0xff, 0x20, 0x3f, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xaf, 0xf0, 0x6, 0xff, 0x30, 0x2f, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xdf, 0xd0, 0x7, 0xff, 0x20, 0x3f, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1c, 0xff, 0x80, 0xa, 0xff, 0x0, 0x4f, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x6f, 0xfd, 0x0, 0x1f, 0xfc, 0x0, 0x8f, 0xf2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x1c, 0xa1, 0x0, 0x9f, 0xf6, 0x0, 0xdf, 0xe0,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xe0, 0x3, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0x40, 0xa, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0x0,
    0x0, 0x5, 0xff, 0xf6, 0x0, 0x4f, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0x0,
    0x0, 0x4, 0xfe, 0x50, 0x1, 0xef, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0,
    0x0, 0x0, 0x21, 0x0, 0x1d, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xdf, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x18, 0x50, 0x0, 0x0, 0x0,

    /* U+F03E "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x93, 0x27, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xd8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xfc, 0x10, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x50, 0x3, 0xdf, 0xff, 0xff, 0xff,
    0xc1, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0xef, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x3e, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xff, 0xfc, 0x10, 0x3, 0xef, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xc1, 0x0, 0x0, 0x3b, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xfc,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb1,

    /* U+F048 "" */
    0x48, 0x88, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x70, 0xbf, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xf9, 0xbf, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x1c, 0xff, 0xfc, 0xbf, 0xff, 0x30, 0x0, 0x0,
    0x1, 0xdf, 0xff, 0xfc, 0xbf, 0xff, 0x30, 0x0,
    0x0, 0x2e, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0x30,
    0x0, 0x3, 0xef, 0xff, 0xff, 0xfc, 0xbf, 0xff,
    0x30, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xfc, 0xbf,
    0xff, 0x30, 0x5, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xbf, 0xff, 0x30, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0xbf, 0xff, 0x37, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0xbf, 0xff, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xbf,
    0xff, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xbf, 0xff, 0x31, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0xbf, 0xff, 0x30, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0xbf, 0xff, 0x30, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xfc, 0xbf, 0xff, 0x30, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0x30, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0x30,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xfc, 0xbf, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xfc, 0xbf,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x4, 0xff, 0xfb,
    0x9f, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x3d,
    0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F04B "" */
    0x3, 0x75, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xfc, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb2, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb2, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x50, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb2, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xe6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff,
    0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xfc, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x74,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x1a, 0xef, 0xff, 0xff, 0xd5, 0x0, 0x0, 0x1a,
    0xef, 0xff, 0xff, 0xd5, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0x66,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0x4, 0x89, 0x99, 0x98,
    0x71, 0x0, 0x0, 0x4, 0x89, 0x99, 0x98, 0x71,
    0x0,

    /* U+F04D "" */
    0x3, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x60, 0x6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x1a, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5,
    0x0,

    /* U+F051 "" */
    0x5, 0x81, 0x0, 0x0, 0x0, 0x0, 0x0, 0x68,
    0x87, 0x5f, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0x7f, 0xff, 0xe3, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0x8f, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xc1,
    0x0, 0x0, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x8f, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0x7f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0x1c, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x9a, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x1, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x5, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x93, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0,

    /* U+F054 "" */
    0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x1, 0xcf, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x1c, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x1, 0xcf, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x1c, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x1, 0xdf, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xa8, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x23, 0x33, 0x33, 0x33,
    0x8f, 0xff, 0xfe, 0x33, 0x33, 0x33, 0x33, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8d, 0xdc, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F068 "" */
    0x1, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x10, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x77, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe1, 0x1, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x10, 0x0,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x26, 0xad, 0xef,
    0xfe, 0xc9, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xff, 0xff, 0xff, 0xba,
    0xbd, 0xff, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xfd, 0x50, 0x0,
    0x0, 0x18, 0xff, 0xff, 0xfe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x39,
    0x95, 0x0, 0x2, 0xef, 0xff, 0xff, 0x70, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x3f,
    0xff, 0xd2, 0x0, 0x5f, 0xff, 0xff, 0xf5, 0x0,
    0x7, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x3f,
    0xff, 0xfe, 0x10, 0xd, 0xff, 0xff, 0xff, 0x20,
    0x2f, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0x80, 0x8, 0xff, 0xff, 0xff, 0xc0,
    0xbf, 0xff, 0xff, 0xff, 0x0, 0x48, 0x6b, 0xff,
    0xff, 0xff, 0xd0, 0x5, 0xff, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x4, 0xff, 0xff, 0xff, 0xf9,
    0xbf, 0xff, 0xff, 0xff, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x5, 0xff, 0xff, 0xff, 0xf5,
    0x1f, 0xff, 0xff, 0xff, 0x20, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x8, 0xff, 0xff, 0xff, 0xc0,
    0x6, 0xff, 0xff, 0xff, 0x70, 0x8, 0xff, 0xff,
    0xff, 0xff, 0x20, 0xd, 0xff, 0xff, 0xff, 0x20,
    0x0, 0xaf, 0xff, 0xff, 0xe0, 0x0, 0xaf, 0xff,
    0xff, 0xf4, 0x0, 0x5f, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xfb, 0x0, 0x4, 0xad,
    0xc8, 0x10, 0x2, 0xef, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xfd, 0x50, 0x0,
    0x0, 0x18, 0xff, 0xff, 0xfe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3c, 0xff, 0xff, 0xff, 0xba,
    0xac, 0xff, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4c, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x26, 0xad, 0xff,
    0xfe, 0xc9, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F070 "" */
    0x4, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xe3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x26, 0xad, 0xff, 0xed,
    0xb7, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xdf, 0xff, 0xfa, 0x16, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xba, 0xbe, 0xff, 0xff, 0xfe, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xc5, 0x0, 0x0, 0x3, 0xbf, 0xff, 0xff,
    0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1b, 0xff, 0xff, 0xc1, 0x6, 0xba, 0x50,
    0x0, 0x7f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xe4, 0x7f,
    0xff, 0xc1, 0x0, 0xbf, 0xff, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0xad, 0x20, 0x0, 0x4, 0xff, 0xff,
    0xfc, 0xff, 0xff, 0xc0, 0x3, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x5f, 0xff, 0x50, 0x0, 0x2,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0x50, 0xe, 0xff,
    0xff, 0xff, 0x50, 0x0, 0xe, 0xff, 0xff, 0x90,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0xbf, 0xff, 0xff, 0xfe, 0x0, 0x2, 0xff, 0xff,
    0xff, 0xc2, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xb0, 0xa, 0xff, 0xff, 0xff, 0xf2, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x3e, 0xff,
    0xff, 0xfa, 0x0, 0xcf, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x1b, 0xff, 0xff, 0xd2, 0xe, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x4, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x1, 0xcf,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xdf, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xbf, 0xff, 0xff, 0xc4, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0xff, 0xff,
    0xfe, 0xba, 0xb5, 0x0, 0x0, 0x2d, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xdf, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x37, 0xbd, 0xef, 0xfd, 0xb4, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xef, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xcf, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x44, 0x0,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x87, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xff, 0x80, 0x0, 0x1e, 0xff,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xff, 0xf6, 0x0, 0x0, 0xef,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0x70, 0x0, 0xf,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0x80, 0x0,
    0xf, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xd1, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x9, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x13, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x10, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf7, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x48,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x98, 0x71, 0x0,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xe3, 0x0, 0x24, 0x44, 0x44, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x44, 0x4f, 0xff, 0xfe, 0x30,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x1, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1,
    0x12, 0x22, 0x26, 0xff, 0xff, 0xa0, 0x1d, 0xff,
    0xff, 0xd2, 0x2f, 0xff, 0xfd, 0x10, 0x0, 0x0,
    0x0, 0x7f, 0xfb, 0x1, 0xdf, 0xff, 0xfd, 0x10,
    0xf, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xc0, 0xc, 0xff, 0xff, 0xe2, 0x0, 0xe, 0xfd,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xfe, 0x20, 0x0, 0x4, 0x81, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x4, 0x81, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xf5, 0x5, 0xe2, 0x0, 0xe, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0x60, 0x4f, 0xfd, 0x10, 0xf, 0xff, 0xe2, 0x0,
    0x12, 0x22, 0x26, 0xff, 0xff, 0xf7, 0x3, 0xff,
    0xff, 0xd2, 0x2f, 0xff, 0xfe, 0x20, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x1, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe2, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x24, 0x44,
    0x44, 0x30, 0x0, 0x0, 0x0, 0x0, 0x2, 0x44,
    0x4f, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfe, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xa2, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xb2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xfa, 0x3f, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xfa, 0x0, 0x3f, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xe2, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xe2, 0x0, 0x8, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff,
    0xe2, 0x6, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xe0, 0x9f, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0x11, 0xdf, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x60, 0x1,
    0xa8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3b, 0x50, 0x0,

    /* U+F078 "" */
    0x1, 0xa8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3b, 0x60, 0x1, 0xdf, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x60, 0x9f, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0x16, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xd0, 0x8, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xe2, 0x0, 0x8,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x8, 0xff, 0xff, 0xfa,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xfa, 0x0, 0x3f, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xfa, 0x3f, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xa2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x0, 0x42, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xf4,
    0x0, 0x0, 0x57, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x60, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xf4, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xf4, 0x2, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xef, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xf9,
    0x0, 0x0, 0xf, 0xff, 0xf4, 0xef, 0xf9, 0x9f,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0x90, 0x0, 0x0, 0x7f, 0xf5, 0xe, 0xff,
    0x90, 0xaf, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xf9, 0x0, 0x0, 0x0, 0x32, 0x0,
    0xef, 0xf9, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0x80,
    0xe, 0xff, 0x90, 0x2a, 0x70, 0x0, 0x0, 0xe,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xa0, 0xef, 0xf9, 0x2e, 0xff, 0x60, 0x0,
    0x0, 0xef, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0x9e, 0xff, 0xad, 0xff, 0xf9,
    0x0, 0x0, 0xe, 0xff, 0xc7, 0x77, 0x77, 0x77,
    0x77, 0x73, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x10, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x4, 0xff,
    0xff, 0xff, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x3, 0xff, 0xff, 0xfc, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xfc, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xdb, 0x0, 0x0,
    0x0,

    /* U+F07B "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xc1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd8, 0x88, 0x88, 0x88, 0x88, 0x87, 0x30,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb1,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x22, 0x22, 0xcf,
    0xff, 0xff, 0xf6, 0x22, 0x22, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x0, 0xbf,
    0xff, 0xff, 0xf4, 0x0, 0x11, 0x11, 0x11, 0x10,
    0xbf, 0xff, 0xff, 0xff, 0xc0, 0xaf, 0xff, 0xff,
    0xf3, 0xc, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x18, 0x99, 0x99, 0x60, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0x1, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xcc, 0xcc, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x1e, 0xb0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x2e, 0xc1,
    0x8f, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x37, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x73,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0x62, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xfe, 0xb7, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x26, 0x10, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xbf, 0xfc, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xfe, 0x10,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x5, 0xef, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x20, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x91, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xe9,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xd9, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x17,
    0x76, 0x53, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C4 "" */
    0x0, 0x5, 0x99, 0x72, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x1, 0x7b, 0xb8,
    0x10, 0x1e, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xfe, 0x38, 0xff, 0xff,
    0xef, 0xff, 0xf1, 0x0, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xf4, 0xdf, 0xfe, 0x10, 0x7f, 0xff, 0x50,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xf5, 0xf, 0xff,
    0x80, 0x0, 0xff, 0xf7, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xf5, 0x0, 0xef, 0xfc, 0x0, 0x4f, 0xff,
    0x60, 0x2, 0xef, 0xff, 0xff, 0xf5, 0x0, 0xa,
    0xff, 0xfd, 0xbf, 0xff, 0xf4, 0x3, 0xef, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0xe5, 0xef, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x18, 0xcd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xef, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x99, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x8, 0xff, 0xff, 0xef,
    0xff, 0xf6, 0x5, 0xff, 0xff, 0xff, 0xe2, 0x0,
    0x0, 0xdf, 0xfe, 0x10, 0x7f, 0xff, 0x50, 0x5,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0xf, 0xff, 0x80,
    0x0, 0xff, 0xf7, 0x0, 0x5, 0xff, 0xff, 0xff,
    0xe2, 0x0, 0xef, 0xfc, 0x0, 0x4f, 0xff, 0x60,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xe2, 0xa, 0xff,
    0xfd, 0xbf, 0xff, 0xf2, 0x0, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xe2, 0x2f, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0x40,
    0x4f, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xbe, 0xfb, 0x30, 0x0, 0x18, 0xcd, 0xb5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x0, 0x1, 0x44, 0x44, 0x44, 0x44,
    0x42, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0x80, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xe, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xef,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0xef, 0xff, 0xf4, 0xaf, 0xff, 0xf4, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0xbb, 0xbb, 0xb3, 0xff, 0xff, 0xf4, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x5f, 0xff, 0xff, 0x40, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xf4,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x5f, 0xff, 0xff, 0x40, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff,
    0xf4, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x5f, 0xff, 0xff, 0x40, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff,
    0xff, 0xf4, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x5f, 0xff, 0xff, 0x40, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xf4, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x5f, 0xff, 0xff, 0x40,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xf4, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xff, 0xff,
    0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xff, 0xff, 0xf4, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xff,
    0xff, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0xff, 0xff, 0xf5, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1f,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xa2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x37, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x60, 0x0,
    0x0, 0x0, 0x0,

    /* U+F0C7 "" */
    0x4, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x87, 0x20, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x40, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x0, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0x40, 0xf, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0x30, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xfe, 0xf,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xf3, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0x4f, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xf4, 0xff, 0xfd, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x7e, 0xff, 0xff,
    0xff, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x82, 0x15, 0xef, 0xff,
    0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0x30, 0x0, 0x0, 0xef, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xa9, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x1a, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3,
    0x0,

    /* U+F0E7 "" */
    0x0, 0x8, 0xbb, 0xbb, 0xbb, 0xbb, 0x80, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x70, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x0, 0x0, 0x1, 0x43, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x49, 0x99, 0x99, 0xff, 0xef, 0xfe, 0x99,
    0x99, 0x81, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xa0, 0x1e, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xfa, 0x1, 0xef,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xfc, 0x64, 0x44, 0x44, 0x44,
    0x30, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0x20, 0xaf, 0xff, 0xff,
    0xff, 0xa0, 0xd6, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xf0, 0x1f, 0xff, 0xff, 0xff, 0xfa, 0xe, 0xf6,
    0x0, 0xf, 0xff, 0xff, 0xff, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0xef, 0xf6, 0x0, 0xff, 0xff,
    0xff, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xfa, 0xe,
    0xff, 0xf6, 0xf, 0xff, 0xff, 0xff, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0xef, 0xff, 0xf3, 0xff,
    0xff, 0xff, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xfa,
    0x4, 0x44, 0x44, 0x1f, 0xff, 0xff, 0xff, 0x1,
    0xff, 0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x5f, 0xff, 0xff, 0xff,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xff, 0xf0, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xff, 0xff,
    0xff, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xff, 0xff, 0xff, 0xf0, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xff,
    0xff, 0xff, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0xaf, 0xff, 0xff, 0xf0, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x42, 0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xa2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x8d, 0xff, 0xfa, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xd4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xa0, 0x1, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x15, 0x73, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xff, 0xfd, 0x88, 0x9f, 0xf8, 0x88, 0xff, 0x98,
    0x8e, 0xfa, 0x88, 0xbf, 0xd8, 0x89, 0xff, 0xf8,
    0xff, 0xf8, 0x0, 0xf, 0xc0, 0x0, 0xcf, 0x0,
    0xa, 0xf1, 0x0, 0x4f, 0x70, 0x0, 0xff, 0xf8,
    0xff, 0xf8, 0x0, 0xf, 0xc0, 0x0, 0xcf, 0x0,
    0xa, 0xf1, 0x0, 0x4f, 0x70, 0x0, 0xff, 0xf8,
    0xff, 0xf9, 0x0, 0x1f, 0xd0, 0x0, 0xdf, 0x10,
    0xc, 0xf3, 0x0, 0x6f, 0x90, 0x1, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xdc, 0xce, 0xfe, 0xcc, 0xdf,
    0xfc, 0xcd, 0xff, 0xcc, 0xcf, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0x20, 0x6, 0xf6, 0x0, 0x3f,
    0x80, 0x0, 0xfd, 0x0, 0xa, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0x20, 0x6, 0xf6, 0x0, 0x2f,
    0x80, 0x0, 0xed, 0x0, 0xa, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0x20, 0x6, 0xf6, 0x0, 0x3f,
    0x80, 0x0, 0xfd, 0x0, 0xa, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xdc, 0xce, 0xfe, 0xcc, 0xdf,
    0xfc, 0xcd, 0xff, 0xcc, 0xcf, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xf9, 0x0, 0x1f, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x90, 0x1, 0xff, 0xf8,
    0xff, 0xf8, 0x0, 0xf, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0xff, 0xf8,
    0xff, 0xf8, 0x0, 0xf, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0xff, 0xf8,
    0xff, 0xfd, 0x88, 0x9f, 0xf8, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0xbf, 0xd8, 0x89, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x72, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xef, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x18, 0xef, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3a, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4c, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x7e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x2, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x4,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x1, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x44, 0x44, 0x44, 0x44, 0x4d, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x17, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x10, 0x30,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0xf, 0xa0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x40, 0xff, 0xa0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xf, 0xff,
    0xa0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0xff, 0xff, 0xa0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0xf, 0xff, 0xff, 0xa0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0xff, 0xff,
    0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0xb, 0xbb, 0xbb, 0xbb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x14, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x10,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x69, 0xab, 0xcb, 0xa9, 0x63, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x27,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xba,
    0xaa, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xc7, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x37, 0xcf, 0xff, 0xff,
    0xff, 0xd1, 0x3, 0xef, 0xff, 0xff, 0xf9, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29,
    0xff, 0xff, 0xff, 0xe3, 0xef, 0xff, 0xff, 0xb2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xbf, 0xff, 0xff, 0xe7, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xf7, 0x7,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x48, 0xbe, 0xff,
    0xfd, 0xb8, 0x40, 0x0, 0x0, 0x0, 0x2d, 0xf7,
    0x0, 0x4, 0x10, 0x0, 0x0, 0x18, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe8, 0x10, 0x0, 0x0,
    0x14, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xc8, 0x76, 0x78, 0xcf,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xef, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x47, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xdb, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x2, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x74,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x9f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0xc, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x80, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x28, 0xcf, 0xff, 0xff, 0xf8, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x8, 0xff, 0xff, 0xff, 0x80,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x80, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f,
    0xff, 0xff, 0xff, 0xf8, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfe, 0xff, 0xfb, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x79, 0xff, 0xfa, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F241 "" */
    0x2, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x74,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x9f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x80, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x28, 0xcf, 0xff, 0xff, 0xf8, 0xe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x80,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x80, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfe, 0xff, 0xfb, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x79, 0xff, 0xfa, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F242 "" */
    0x2, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x74,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x9f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x80, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x28, 0xcf, 0xff, 0xff, 0xf8, 0xe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x80,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x80, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfe, 0xff, 0xfb, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x79, 0xff, 0xfa, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F243 "" */
    0x2, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x74,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x9f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x80, 0xef, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x28, 0xcf, 0xff, 0xff, 0xf8, 0xe, 0xff,
    0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x80,
    0xef, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0xe, 0xff, 0xff, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x80, 0xef, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xf8, 0xe, 0xff, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfe, 0xff, 0xfb, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x79, 0xff, 0xfa, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F244 "" */
    0x2, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x74,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0x9f,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x28, 0xcf, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xfe, 0xff, 0xfb, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x79, 0xff, 0xfa, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x1, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5e, 0xfe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x23, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xcd, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xe1, 0x0, 0xcf, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x50, 0x0, 0x7, 0xa7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x10, 0x0, 0x0, 0x4, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xef, 0xfc, 0x20, 0x0, 0xc, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x40,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xe1, 0x0, 0x4f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xfb, 0x20, 0x0, 0xcf, 0xff, 0xff, 0xfa,
    0x35, 0xef, 0x94, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x4d, 0xff, 0xf7, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0xef, 0xff, 0xff, 0xfe, 0xbb, 0xbb, 0xbc, 0xff,
    0xcb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbf, 0xff,
    0xfe, 0x50, 0x8f, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x9f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0x80, 0x0, 0xb, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xb2, 0x0, 0x0, 0x0, 0x58,
    0x73, 0x0, 0x0, 0x0, 0x0, 0x7, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x20, 0x6, 0xdd, 0xdd, 0xc2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xc0, 0x9, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xde, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xaf,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x19, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x34, 0x32, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 0xef,
    0xff, 0xff, 0xfb, 0x50, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10,
    0x0, 0x0, 0x1, 0xcf, 0xff, 0xff, 0xc7, 0xff,
    0xff, 0xff, 0xd1, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xc0, 0x8f, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xc0, 0x9, 0xff, 0xff,
    0xff, 0x50, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0xaf, 0xff, 0xff, 0xb0, 0x2, 0xff, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0xb, 0xff, 0xff, 0xf1,
    0x6, 0xff, 0xff, 0xaf, 0xff, 0xc0, 0x39, 0x0,
    0xcf, 0xff, 0xf5, 0xa, 0xff, 0xf9, 0x3, 0xef,
    0xc0, 0x3f, 0x90, 0x1d, 0xff, 0xf8, 0xc, 0xff,
    0xfd, 0x10, 0x3e, 0xc0, 0x2f, 0xb0, 0xc, 0xff,
    0xfa, 0xe, 0xff, 0xff, 0xd1, 0x3, 0xb0, 0x2b,
    0x0, 0xaf, 0xff, 0xfc, 0xf, 0xff, 0xff, 0xfd,
    0x10, 0x10, 0x0, 0x9, 0xff, 0xff, 0xfd, 0xf,
    0xff, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0xfd, 0x10,
    0x5, 0xff, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x3, 0xff, 0xff, 0xff, 0xfe,
    0xf, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xfd, 0xf, 0xff, 0xff, 0xfb, 0x0,
    0x20, 0x11, 0x4, 0xff, 0xff, 0xfd, 0xe, 0xff,
    0xff, 0xb0, 0x5, 0xc0, 0x2d, 0x10, 0x5f, 0xff,
    0xfc, 0xc, 0xff, 0xfb, 0x0, 0x5f, 0xc0, 0x2f,
    0xd0, 0x7, 0xff, 0xfa, 0x9, 0xff, 0xfb, 0x5,
    0xff, 0xc0, 0x3f, 0x60, 0x1d, 0xff, 0xf7, 0x5,
    0xff, 0xff, 0xdf, 0xff, 0xc0, 0x36, 0x1, 0xdf,
    0xff, 0xf4, 0x1, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x1d, 0xff, 0xff, 0xf0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xd0, 0x1, 0xdf, 0xff, 0xff, 0xa0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xd0, 0x1d, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xd1, 0xcf, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x2, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x58, 0xab, 0xba, 0x84, 0x0, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x0, 0x0, 0x14, 0x44, 0x44, 0x43,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x58, 0x88, 0x88, 0x8c, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x88, 0x88, 0x88, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8b, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x28, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x86, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x4f, 0xff, 0xf5, 0x5f, 0xff, 0x92,
    0xff, 0xfc, 0x1c, 0xff, 0xfc, 0x0, 0x4, 0xff,
    0xff, 0x22, 0xff, 0xf6, 0xe, 0xff, 0xa0, 0xaf,
    0xff, 0xc0, 0x0, 0x4f, 0xff, 0xf2, 0x2f, 0xff,
    0x60, 0xef, 0xfa, 0xa, 0xff, 0xfc, 0x0, 0x4,
    0xff, 0xff, 0x22, 0xff, 0xf6, 0xe, 0xff, 0xa0,
    0xaf, 0xff, 0xc0, 0x0, 0x4f, 0xff, 0xf2, 0x2f,
    0xff, 0x60, 0xef, 0xfa, 0xa, 0xff, 0xfc, 0x0,
    0x4, 0xff, 0xff, 0x22, 0xff, 0xf6, 0xe, 0xff,
    0xa0, 0xaf, 0xff, 0xc0, 0x0, 0x4f, 0xff, 0xf2,
    0x2f, 0xff, 0x60, 0xef, 0xfa, 0xa, 0xff, 0xfc,
    0x0, 0x4, 0xff, 0xff, 0x22, 0xff, 0xf6, 0xe,
    0xff, 0xa0, 0xaf, 0xff, 0xc0, 0x0, 0x4f, 0xff,
    0xf2, 0x2f, 0xff, 0x60, 0xef, 0xfa, 0xa, 0xff,
    0xfc, 0x0, 0x4, 0xff, 0xff, 0x22, 0xff, 0xf6,
    0xe, 0xff, 0xa0, 0xaf, 0xff, 0xc0, 0x0, 0x4f,
    0xff, 0xf2, 0x2f, 0xff, 0x60, 0xef, 0xfa, 0xa,
    0xff, 0xfc, 0x0, 0x4, 0xff, 0xff, 0x22, 0xff,
    0xf6, 0xe, 0xff, 0xa0, 0xaf, 0xff, 0xc0, 0x0,
    0x4f, 0xff, 0xf2, 0x2f, 0xff, 0x60, 0xef, 0xfa,
    0xa, 0xff, 0xfc, 0x0, 0x4, 0xff, 0xff, 0x55,
    0xff, 0xf9, 0x2f, 0xff, 0xc1, 0xcf, 0xff, 0xc0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x4,
    0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x61, 0x0, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x66, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xdf, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xec,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xfc, 0x0,
    0xbf, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xfc, 0x0, 0xbf,
    0xff, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xff, 0xff, 0xfc, 0x0, 0xbf, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0xbe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xfe,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xec, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x76,
    0x42, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd5, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x99, 0xff,
    0xff, 0xff, 0x99, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x8, 0xff, 0xff, 0x80, 0x7, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x8, 0xff, 0x80, 0x0, 0xe, 0xff,
    0xff, 0xff, 0xf0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x8, 0x80, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x8, 0x80, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x8, 0xff,
    0x80, 0x0, 0xe, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x8,
    0xff, 0xff, 0x80, 0x8, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x99, 0xff, 0xff, 0xff, 0x99, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5, 0x0,

    /* U+F7C2 "" */
    0x0, 0x0, 0x0, 0x17, 0x88, 0x88, 0x88, 0x88,
    0x87, 0x50, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xc1, 0x0, 0x0, 0x2d,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x2e, 0xff, 0x20, 0x1f, 0xa0,
    0xe, 0xd0, 0x8, 0xff, 0xf0, 0x2e, 0xff, 0xf2,
    0x1, 0xfa, 0x0, 0xed, 0x0, 0x8f, 0xff, 0x3e,
    0xff, 0xff, 0x20, 0x1f, 0xa0, 0xe, 0xd0, 0x8,
    0xff, 0xfe, 0xff, 0xff, 0xf2, 0x1, 0xfa, 0x0,
    0xed, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x1f, 0xa0, 0xe, 0xd0, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x24,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x20,
    0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x5c, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x7f, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf1, 0x0,
    0x0, 0x8f, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0x10, 0x0, 0x9f,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xf1, 0x0, 0xaf, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0x10, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1c,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x2e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x1d, 0xff, 0xff,
    0xfe, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x10, 0x0, 0x1c, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 224, .box_w = 4, .box_h = 19, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 38, .adv_w = 224, .box_w = 11, .box_h = 7, .ofs_x = 1, .ofs_y = 16},
    {.bitmap_index = 77, .adv_w = 224, .box_w = 13, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 201, .adv_w = 224, .box_w = 11, .box_h = 24, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 333, .adv_w = 224, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 473, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 606, .adv_w = 224, .box_w = 5, .box_h = 8, .ofs_x = 1, .ofs_y = 15},
    {.bitmap_index = 626, .adv_w = 224, .box_w = 7, .box_h = 26, .ofs_x = 6, .ofs_y = -3},
    {.bitmap_index = 717, .adv_w = 224, .box_w = 7, .box_h = 26, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 808, .adv_w = 224, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 906, .adv_w = 224, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1004, .adv_w = 224, .box_w = 14, .box_h = 1, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 1011, .adv_w = 224, .box_w = 5, .box_h = 4, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1021, .adv_w = 224, .box_w = 13, .box_h = 25, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1184, .adv_w = 224, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1298, .adv_w = 224, .box_w = 9, .box_h = 19, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 1384, .adv_w = 224, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1498, .adv_w = 224, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1612, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1745, .adv_w = 224, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1859, .adv_w = 224, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1973, .adv_w = 224, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2087, .adv_w = 224, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2201, .adv_w = 224, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2315, .adv_w = 224, .box_w = 4, .box_h = 14, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 2343, .adv_w = 224, .box_w = 4, .box_h = 16, .ofs_x = 5, .ofs_y = -3},
    {.bitmap_index = 2375, .adv_w = 224, .box_w = 12, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2495, .adv_w = 224, .box_w = 14, .box_h = 7, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 2544, .adv_w = 224, .box_w = 12, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2664, .adv_w = 224, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2778, .adv_w = 224, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2902, .adv_w = 224, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3042, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3175, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3308, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3441, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3574, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3707, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3840, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3973, .adv_w = 224, .box_w = 10, .box_h = 19, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4068, .adv_w = 224, .box_w = 14, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4222, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4355, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4488, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4621, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4754, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4887, .adv_w = 224, .box_w = 13, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5011, .adv_w = 224, .box_w = 14, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5165, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5298, .adv_w = 224, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5412, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5545, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5678, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5811, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5944, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6077, .adv_w = 224, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6210, .adv_w = 224, .box_w = 13, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6334, .adv_w = 224, .box_w = 8, .box_h = 24, .ofs_x = 5, .ofs_y = -2},
    {.bitmap_index = 6430, .adv_w = 224, .box_w = 11, .box_h = 24, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 6562, .adv_w = 224, .box_w = 8, .box_h = 24, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 6658, .adv_w = 224, .box_w = 8, .box_h = 4, .ofs_x = 3, .ofs_y = 19},
    {.bitmap_index = 6674, .adv_w = 224, .box_w = 14, .box_h = 1, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6681, .adv_w = 224, .box_w = 6, .box_h = 3, .ofs_x = 2, .ofs_y = 20},
    {.bitmap_index = 6690, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6775, .adv_w = 224, .box_w = 13, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6905, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6983, .adv_w = 224, .box_w = 13, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7113, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7191, .adv_w = 224, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7315, .adv_w = 224, .box_w = 13, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 7426, .adv_w = 224, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7566, .adv_w = 224, .box_w = 10, .box_h = 19, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 7661, .adv_w = 224, .box_w = 10, .box_h = 23, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 7776, .adv_w = 224, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7916, .adv_w = 224, .box_w = 10, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 8016, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8107, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8198, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8276, .adv_w = 224, .box_w = 13, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 8387, .adv_w = 224, .box_w = 13, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 8498, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8583, .adv_w = 224, .box_w = 10, .box_h = 13, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 8648, .adv_w = 224, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8742, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8833, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8918, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9009, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9094, .adv_w = 224, .box_w = 13, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 9205, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9283, .adv_w = 224, .box_w = 7, .box_h = 25, .ofs_x = 5, .ofs_y = -2},
    {.bitmap_index = 9371, .adv_w = 224, .box_w = 2, .box_h = 28, .ofs_x = 6, .ofs_y = -4},
    {.bitmap_index = 9399, .adv_w = 224, .box_w = 7, .box_h = 25, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 9487, .adv_w = 224, .box_w = 13, .box_h = 5, .ofs_x = 1, .ofs_y = 19},
    {.bitmap_index = 9520, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9926, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10220, .adv_w = 448, .box_w = 28, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10570, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10864, .adv_w = 308, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11074, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11480, .adv_w = 448, .box_w = 27, .box_h = 29, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 11872, .adv_w = 504, .box_w = 32, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12272, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12678, .adv_w = 504, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13014, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 13420, .adv_w = 224, .box_w = 14, .box_h = 23, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13581, .adv_w = 336, .box_w = 21, .box_h = 23, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 13823, .adv_w = 504, .box_w = 32, .box_h = 27, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14255, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14549, .adv_w = 392, .box_w = 18, .box_h = 26, .ofs_x = 3, .ofs_y = -3},
    {.bitmap_index = 14783, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 15146, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 15459, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 15772, .adv_w = 392, .box_w = 18, .box_h = 26, .ofs_x = 3, .ofs_y = -3},
    {.bitmap_index = 16006, .adv_w = 392, .box_w = 26, .box_h = 25, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 16331, .adv_w = 280, .box_w = 16, .box_h = 25, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 16531, .adv_w = 280, .box_w = 16, .box_h = 25, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 16731, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 17044, .adv_w = 392, .box_w = 25, .box_h = 7, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 17132, .adv_w = 504, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17468, .adv_w = 560, .box_w = 35, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17976, .adv_w = 504, .box_w = 33, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 18455, .adv_w = 448, .box_w = 28, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18805, .adv_w = 392, .box_w = 25, .box_h = 15, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 18993, .adv_w = 392, .box_w = 25, .box_h = 15, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 19181, .adv_w = 560, .box_w = 35, .box_h = 22, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19566, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19860, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 20266, .adv_w = 448, .box_w = 29, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 20687, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21000, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 21363, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 21676, .adv_w = 280, .box_w = 19, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 21952, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 22315, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 22678, .adv_w = 504, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23014, .adv_w = 448, .box_w = 30, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 23449, .adv_w = 336, .box_w = 21, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 23754, .adv_w = 560, .box_w = 35, .box_h = 26, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 24209, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 24542, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 24875, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 25208, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 25541, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 25874, .adv_w = 560, .box_w = 36, .box_h = 23, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 26288, .adv_w = 392, .box_w = 22, .box_h = 29, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 26607, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 26970, .adv_w = 448, .box_w = 29, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 27391, .adv_w = 560, .box_w = 35, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27759, .adv_w = 336, .box_w = 21, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 28064, .adv_w = 451, .box_w = 29, .box_h = 19, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 33, .range_length = 11, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 45, .range_length = 82, .glyph_id_start = 12,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 94,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_simsun_28 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 29,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0)
    .underline_position = -4,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};



#endif /*#if LV_FONT_SIMSUN_28*/

